<?php
// This file was auto-generated from sdk-root/src/data/appstream/2016-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon AppStream 2.0</fullname> <p>API documentation for Amazon AppStream 2.0.</p>', 'operations' => [ 'AssociateFleet' => '<p>Associate a fleet to a stack.</p>', 'CreateDirectoryConfig' => '<p>Creates a directory configuration with the given parameters.</p>', 'CreateFleet' => '<p>Creates a new fleet.</p>', 'CreateStack' => '<p>Create a new stack.</p>', 'CreateStreamingURL' => '<p>Creates a URL to start an AppStream 2.0 streaming session for a user. By default, the URL is valid only for 1 minute from the time that it is generated.</p>', 'DeleteDirectoryConfig' => '<p>Deletes the directory configuration with the given parameters.</p>', 'DeleteFleet' => '<p>Deletes a fleet.</p>', 'DeleteStack' => '<p>Deletes the stack. After this operation completes, the environment can no longer be activated, and any reservations made for the stack are released.</p>', 'DescribeDirectoryConfigs' => '<p>Returns a list describing the specified directory configurations.</p>', 'DescribeFleets' => '<p>If fleet names are provided, this operation describes the specified fleets; otherwise, all the fleets in the account are described.</p>', 'DescribeImages' => '<p>Describes the images. If a list of names is not provided, all images in your account are returned. This operation does not return a paginated result.</p>', 'DescribeSessions' => '<p>Describes the streaming sessions for a stack and a fleet. If a user ID is provided, this operation returns streaming sessions for only that user. To retrieve the next set of items, pass this value for the <code>nextToken</code> parameter in a subsequent call to this operation. If an authentication type is not provided, the operation defaults to users authenticated using a streaming URL.</p>', 'DescribeStacks' => '<p>If stack names are not provided, this operation describes the specified stacks; otherwise, all stacks in the account are described. To retrieve the next set of items, pass the <code>nextToken</code> value in a subsequent call to this operation.</p>', 'DisassociateFleet' => '<p>Disassociates a fleet from a stack.</p>', 'ExpireSession' => '<p>This operation immediately stops a streaming session.</p>', 'ListAssociatedFleets' => '<p>Lists all fleets associated with the stack.</p>', 'ListAssociatedStacks' => '<p>Lists all stacks to which the specified fleet is associated.</p>', 'StartFleet' => '<p>Starts a fleet.</p>', 'StopFleet' => '<p>Stops a fleet.</p>', 'UpdateDirectoryConfig' => '<p>Updates the directory configuration with the given parameters.</p>', 'UpdateFleet' => '<p>Updates an existing fleet. All the attributes except the fleet name can be updated in the <b>STOPPED</b> state. When a fleet is in the <b>RUNNING</b> state, only <code>DisplayName</code> and <code>ComputeCapacity</code> can be updated. A fleet cannot be updated in a status of <b>STARTING</b> or <b>STOPPING</b>.</p>', 'UpdateStack' => '<p>Updates the specified fields in the stack with the specified name.</p>', ], 'shapes' => [ 'AccountName' => [ 'base' => NULL, 'refs' => [ 'ServiceAccountCredentials$AccountName' => '<p>The user name of an account in the directory that is used by AppStream 2.0 streaming instances to connect to the directory. This account must have the following privileges: create computer objects, join computers to the domain, change/reset the password on descendant computer objects for the organizational units specified.</p>', ], ], 'AccountPassword' => [ 'base' => NULL, 'refs' => [ 'ServiceAccountCredentials$AccountPassword' => '<p>The password for the user account for directory actions.</p>', ], ], 'Application' => [ 'base' => '<p>An entry for a single application in the application catalog.</p>', 'refs' => [ 'Applications$member' => NULL, ], ], 'Applications' => [ 'base' => NULL, 'refs' => [ 'Image$Applications' => '<p>The applications associated with an image.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'Fleet$Arn' => '<p>The ARN for the fleet.</p>', 'Image$Arn' => '<p>The ARN for the image.</p>', 'Image$BaseImageArn' => '<p>The source image ARN from which this image was created.</p>', 'Stack$Arn' => '<p>The ARN of the stack.</p>', ], ], 'AssociateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'AuthenticationType' => [ 'base' => NULL, 'refs' => [ 'DescribeSessionsRequest$AuthenticationType' => '<p>The authentication method of the user. It can be <code>API</code> for a user authenticated using a streaming URL, or <code>SAML</code> for a SAML federated user. If an authentication type is not provided, the operation defaults to users authenticated using a streaming URL.</p>', 'Session$AuthenticationType' => '<p>The authentication method of the user for whom the session was created. It can be <code>API</code> for a user authenticated using a streaming URL or <code>SAML</code> for a SAML federated user.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Application$Enabled' => '<p>If there is a problem, an application can be disabled after image creation.</p>', 'Image$ImageBuilderSupported' => '<p>Whether an image builder can be launched from this image.</p>', 'UpdateFleetRequest$DeleteVpcConfig' => '<p>Delete the VPC association for the specified fleet.</p>', 'UpdateStackRequest$DeleteStorageConnectors' => '<p>Remove all the storage connectors currently enabled for the stack.</p>', ], ], 'BooleanObject' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$EnableDefaultInternetAccess' => '<p>Enables or disables default internet access for the fleet.</p>', 'Fleet$EnableDefaultInternetAccess' => '<p>Whether default internet access is enabled for the fleet. </p>', 'UpdateFleetRequest$EnableDefaultInternetAccess' => '<p>Enables or disables default internet access for the fleet.</p>', ], ], 'ComputeCapacity' => [ 'base' => '<p>The capacity configuration for the fleet.</p>', 'refs' => [ 'CreateFleetRequest$ComputeCapacity' => '<p>The parameters for the capacity allocated to the fleet.</p>', 'UpdateFleetRequest$ComputeCapacity' => '<p>The parameters for the capacity allocated to the fleet. </p>', ], ], 'ComputeCapacityStatus' => [ 'base' => '<p>The capacity information for the fleet.</p>', 'refs' => [ 'Fleet$ComputeCapacityStatus' => '<p>The capacity information for the fleet.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>An API error occurred. Wait a few minutes and try again.</p>', 'refs' => [], ], 'CreateDirectoryConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDirectoryConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateFleetRequest' => [ 'base' => '<p>Contains the parameters for the new fleet to create.</p>', 'refs' => [], ], 'CreateFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStackResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamingURLRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamingURLResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDirectoryConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDirectoryConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStackResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDirectoryConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDirectoryConfigsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImagesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSessionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStacksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStacksResult' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$Description' => '<p>The description of the fleet.</p>', 'CreateStackRequest$Description' => '<p>The description displayed to end users on the AppStream 2.0 portal.</p>', 'UpdateFleetRequest$Description' => '<p>The description displayed to end users on the AppStream 2.0 portal.</p>', 'UpdateStackRequest$Description' => '<p>The description displayed to end users on the AppStream 2.0 portal.</p>', ], ], 'DirectoryConfig' => [ 'base' => '<p>Full directory configuration details, which are used to join domains for the AppStream 2.0 streaming instances.</p>', 'refs' => [ 'CreateDirectoryConfigResult$DirectoryConfig' => '<p>Directory configuration details.</p>', 'DirectoryConfigList$member' => NULL, 'UpdateDirectoryConfigResult$DirectoryConfig' => '<p>The updated directory configuration details.</p>', ], ], 'DirectoryConfigList' => [ 'base' => NULL, 'refs' => [ 'DescribeDirectoryConfigsResult$DirectoryConfigs' => '<p>The list of directory configurations.</p>', ], ], 'DirectoryName' => [ 'base' => NULL, 'refs' => [ 'CreateDirectoryConfigRequest$DirectoryName' => '<p>The fully qualified name of the directory, such as corp.example.com</p>', 'DeleteDirectoryConfigRequest$DirectoryName' => '<p>The name of the directory configuration to be deleted.</p>', 'DirectoryConfig$DirectoryName' => '<p>The fully qualified name of the directory, such as corp.example.com</p>', 'DirectoryNameList$member' => NULL, 'DomainJoinInfo$DirectoryName' => '<p>The fully qualified name of the directory, such as corp.example.com</p>', 'UpdateDirectoryConfigRequest$DirectoryName' => '<p>The name of the existing directory configuration to be updated.</p>', ], ], 'DirectoryNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeDirectoryConfigsRequest$DirectoryNames' => '<p>A specific list of directory names.</p>', ], ], 'DisassociateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'DisplayName' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$DisplayName' => '<p>The display name of the fleet.</p>', 'CreateStackRequest$DisplayName' => '<p>The name displayed to end users on the AppStream 2.0 portal.</p>', 'UpdateFleetRequest$DisplayName' => '<p>The name displayed to end users on the AppStream 2.0 portal.</p>', 'UpdateStackRequest$DisplayName' => '<p>The name displayed to end users on the AppStream 2.0 portal.</p>', ], ], 'DomainJoinInfo' => [ 'base' => '<p>The <i>DirectoryName</i> and <i>OrganizationalUnitDistinguishedName</i> values, which are used to join domains for the AppStream 2.0 streaming instances.</p>', 'refs' => [ 'CreateFleetRequest$DomainJoinInfo' => '<p>The <i>DirectoryName</i> and <i>OrganizationalUnitDistinguishedName</i> values, which are used to join domains for the AppStream 2.0 streaming instances.</p>', 'Fleet$DomainJoinInfo' => '<p>The <i>DirectoryName</i> and <i>OrganizationalUnitDistinguishedName</i> values, which are used to join domains for the AppStream 2.0 streaming instances.</p>', 'UpdateFleetRequest$DomainJoinInfo' => '<p>The <i>DirectoryName</i> and <i>OrganizationalUnitDistinguishedName</i> values, which are used to join domains for the AppStream 2.0 streaming instances.</p>', ], ], 'ErrorMessage' => [ 'base' => '<p>The error message in the exception.</p>', 'refs' => [ 'ConcurrentModificationException$Message' => NULL, 'IncompatibleImageException$Message' => NULL, 'InvalidParameterCombinationException$Message' => NULL, 'InvalidRoleException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'OperationNotPermittedException$Message' => NULL, 'ResourceAlreadyExistsException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceNotAvailableException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, ], ], 'ExpireSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExpireSessionResult' => [ 'base' => NULL, 'refs' => [], ], 'Fleet' => [ 'base' => '<p>Contains the parameters for a fleet.</p>', 'refs' => [ 'CreateFleetResult$Fleet' => '<p>The details for the created fleet.</p>', 'FleetList$member' => NULL, 'UpdateFleetResult$Fleet' => '<p>A list of fleet details.</p>', ], ], 'FleetAttribute' => [ 'base' => '<p>Fleet attribute.</p>', 'refs' => [ 'FleetAttributes$member' => NULL, ], ], 'FleetAttributes' => [ 'base' => '<p>A list of fleet attributes.</p>', 'refs' => [ 'UpdateFleetRequest$AttributesToDelete' => '<p>Fleet attributes to be deleted.</p>', ], ], 'FleetError' => [ 'base' => '<p>The details of the fleet error.</p>', 'refs' => [ 'FleetErrors$member' => NULL, ], ], 'FleetErrorCode' => [ 'base' => NULL, 'refs' => [ 'FleetError$ErrorCode' => '<p>The error code for the fleet error.</p>', ], ], 'FleetErrors' => [ 'base' => NULL, 'refs' => [ 'Fleet$FleetErrors' => '<p>The list of fleet errors is appended to this list.</p>', ], ], 'FleetList' => [ 'base' => '<p>A list of fleets.</p>', 'refs' => [ 'DescribeFleetsResult$Fleets' => '<p>The list of fleet details.</p>', ], ], 'FleetState' => [ 'base' => NULL, 'refs' => [ 'Fleet$State' => '<p>The current state for the fleet.</p>', ], ], 'Image' => [ 'base' => '<p>New streaming instances are booted from images. The image stores the application catalog and is connected to fleets.</p>', 'refs' => [ 'ImageList$member' => NULL, ], ], 'ImageList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesResult$Images' => '<p>The list of images.</p>', ], ], 'ImageState' => [ 'base' => NULL, 'refs' => [ 'Image$State' => '<p>The image starts in the <b>PENDING</b> state. If image creation succeeds, it moves to <b>AVAILABLE</b>. If image creation fails, it moves to <b>FAILED</b>.</p>', ], ], 'ImageStateChangeReason' => [ 'base' => '<p>The reason why the last state change occurred.</p>', 'refs' => [ 'Image$StateChangeReason' => '<p>The reason why the last state change occurred.</p>', ], ], 'ImageStateChangeReasonCode' => [ 'base' => NULL, 'refs' => [ 'ImageStateChangeReason$Code' => '<p>The state change reason code of the image.</p>', ], ], 'IncompatibleImageException' => [ 'base' => '<p>The image does not support storage connectors.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ComputeCapacity$DesiredInstances' => '<p>The desired number of streaming instances.</p>', 'ComputeCapacityStatus$Desired' => '<p>The desired number of streaming instances.</p>', 'ComputeCapacityStatus$Running' => '<p>The total number of simultaneous streaming instances that are running.</p>', 'ComputeCapacityStatus$InUse' => '<p>The number of instances that are being used for streaming.</p>', 'ComputeCapacityStatus$Available' => '<p>The number of currently available instances that can be used to stream sessions.</p>', 'CreateFleetRequest$MaxUserDurationInSeconds' => '<p>The maximum time for which a streaming session can run. The input can be any numeric value in seconds between 600 and 57600.</p>', 'CreateFleetRequest$DisconnectTimeoutInSeconds' => '<p>The time after disconnection when a session is considered to have ended. If a user who got disconnected reconnects within this timeout interval, the user is connected back to their previous session. The input can be any numeric value in seconds between 60 and 57600. </p>', 'DescribeDirectoryConfigsRequest$MaxResults' => '<p>The size of each page of results.</p>', 'DescribeSessionsRequest$Limit' => '<p>The size of each page of results. The default value is 20 and the maximum supported value is 50.</p>', 'Fleet$MaxUserDurationInSeconds' => '<p>The maximum time for which a streaming session can run. The value can be any numeric value in seconds between 600 and 57600.</p>', 'Fleet$DisconnectTimeoutInSeconds' => '<p>The time after disconnection when a session is considered to have ended. If a user who got disconnected reconnects within this timeout interval, the user is connected back to their previous session. The input can be any numeric value in seconds between 60 and 57600.</p>', 'UpdateFleetRequest$MaxUserDurationInSeconds' => '<p>The maximum time for which a streaming session can run. The input can be any numeric value in seconds between 600 and 57600.</p>', 'UpdateFleetRequest$DisconnectTimeoutInSeconds' => '<p>The time after disconnection when a session is considered to have ended. If a user who got disconnected reconnects within this timeout interval, the user is connected back to their previous session. The input can be any numeric value in seconds between 60 and 57600.</p>', ], ], 'InvalidParameterCombinationException' => [ 'base' => '<p>Indicates an incorrect combination of parameters, or a missing parameter.</p>', 'refs' => [], ], 'InvalidRoleException' => [ 'base' => '<p>The specified role is invalid.</p>', 'refs' => [], ], 'LimitExceededException' => [ 'base' => '<p>The requested limit exceeds the permitted limit for an account.</p>', 'refs' => [], ], 'ListAssociatedFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedFleetsResult' => [ 'base' => '<p>The response from a successful operation.</p>', 'refs' => [], ], 'ListAssociatedStacksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedStacksResult' => [ 'base' => '<p>The response from a successful operation.</p>', 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'CreateStreamingURLRequest$Validity' => '<p>The duration up to which the URL returned by this action is valid. The input can be any numeric value in seconds between 1 and 604800 seconds.</p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'Application$Metadata' => '<p>Additional attributes that describe the application.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$Name' => '<p>A unique identifier for the fleet.</p>', ], ], 'OperationNotPermittedException' => [ 'base' => '<p>The attempted operation is not permitted.</p>', 'refs' => [], ], 'OrganizationalUnitDistinguishedName' => [ 'base' => NULL, 'refs' => [ 'DomainJoinInfo$OrganizationalUnitDistinguishedName' => '<p>The distinguished name of the organizational unit to place the computer account in.</p>', 'OrganizationalUnitDistinguishedNamesList$member' => NULL, ], ], 'OrganizationalUnitDistinguishedNamesList' => [ 'base' => NULL, 'refs' => [ 'CreateDirectoryConfigRequest$OrganizationalUnitDistinguishedNames' => '<p>The list of the distinguished names of organizational units to place computer accounts in.</p>', 'DirectoryConfig$OrganizationalUnitDistinguishedNames' => '<p>The list of the distinguished names of organizational units in which to place computer accounts.</p>', 'UpdateDirectoryConfigRequest$OrganizationalUnitDistinguishedNames' => '<p>The list of the distinguished names of organizational units to place computer accounts in.</p>', ], ], 'PlatformType' => [ 'base' => NULL, 'refs' => [ 'Image$Platform' => '<p>The operating system platform of the image.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The specified resource already exists.</p>', 'refs' => [], ], 'ResourceIdentifier' => [ 'base' => '<p>The ARN of the resource.</p>', 'refs' => [ 'StorageConnector$ResourceIdentifier' => '<p>The ARN associated with the storage connector.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>The specified resource is in use.</p>', 'refs' => [], ], 'ResourceNotAvailableException' => [ 'base' => '<p>The specified resource exists and is not in use, but isn\'t available.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource was not found.</p>', 'refs' => [], ], 'SecurityGroupIdList' => [ 'base' => '<p>A list of security groups.</p>', 'refs' => [ 'VpcConfig$SecurityGroupIds' => '<p>Security groups associated with the fleet.</p>', ], ], 'ServiceAccountCredentials' => [ 'base' => '<p>The <i>AccountName</i> and <i>AccountPassword</i> of the service account, to be used by the streaming instance to connect to the directory.</p>', 'refs' => [ 'CreateDirectoryConfigRequest$ServiceAccountCredentials' => '<p>The <i>AccountName</i> and <i>AccountPassword</i> values for the service account, which are used by the streaming instance to connect to the directory.</p>', 'DirectoryConfig$ServiceAccountCredentials' => '<p>The <i>AccountName</i> and <i>AccountPassword</i> of the service account, to be used by the streaming instance to connect to the directory.</p>', 'UpdateDirectoryConfigRequest$ServiceAccountCredentials' => '<p>The <i>AccountName</i> and <i>AccountPassword</i> values for the service account, which are used by the streaming instance to connect to the directory</p>', ], ], 'Session' => [ 'base' => '<p>Contains the parameters for a streaming session.</p>', 'refs' => [ 'SessionList$member' => NULL, ], ], 'SessionList' => [ 'base' => '<p>List of sessions.</p>', 'refs' => [ 'DescribeSessionsResult$Sessions' => '<p>The list of streaming sessions.</p>', ], ], 'SessionState' => [ 'base' => '<p>Possible values for the state of a streaming session.</p>', 'refs' => [ 'Session$State' => '<p>The current state of the streaming session.</p>', ], ], 'Stack' => [ 'base' => '<p>Details about a stack.</p>', 'refs' => [ 'CreateStackResult$Stack' => '<p>The details for the created stack.</p>', 'StackList$member' => NULL, 'UpdateStackResult$Stack' => '<p>A list of stack details.</p>', ], ], 'StackError' => [ 'base' => '<p>Contains the parameters for a stack error.</p>', 'refs' => [ 'StackErrors$member' => NULL, ], ], 'StackErrorCode' => [ 'base' => NULL, 'refs' => [ 'StackError$ErrorCode' => '<p>The error code of a stack error.</p>', ], ], 'StackErrors' => [ 'base' => '<p>A list of stack errors.</p>', 'refs' => [ 'Stack$StackErrors' => '<p>The list of errors associated with the stack.</p>', ], ], 'StackList' => [ 'base' => '<p>A list of stacks.</p>', 'refs' => [ 'DescribeStacksResult$Stacks' => '<p>The list of stack details.</p>', ], ], 'StartFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'StopFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'StorageConnector' => [ 'base' => '<p>Contains the parameters for a storage connector.</p>', 'refs' => [ 'StorageConnectorList$member' => NULL, ], ], 'StorageConnectorList' => [ 'base' => '<p>A list of storage connectors.</p>', 'refs' => [ 'CreateStackRequest$StorageConnectors' => '<p>The storage connectors to be enabled for the stack.</p>', 'Stack$StorageConnectors' => '<p>The storage connectors to be enabled for the stack.</p>', 'UpdateStackRequest$StorageConnectors' => '<p>The storage connectors to be enabled for the stack.</p>', ], ], 'StorageConnectorType' => [ 'base' => '<p>The type of storage connector. The possible values include: HOMEFOLDERS.</p>', 'refs' => [ 'StorageConnector$ConnectorType' => '<p>The type of storage connector. The possible values include: HOMEFOLDERS.</p>', ], ], 'StreamingUrlUserId' => [ 'base' => NULL, 'refs' => [ 'CreateStreamingURLRequest$UserId' => '<p>A unique user ID for whom the URL is generated.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'Application$Name' => '<p>The unique identifier for the application.</p>', 'Application$DisplayName' => '<p>The name of the application shown to the end users.</p>', 'Application$IconURL' => '<p>The URL for the application icon. This URL may be time-limited.</p>', 'Application$LaunchPath' => '<p>The path to the application executable in the instance.</p>', 'Application$LaunchParameters' => '<p>A list of arguments that are passed to the application at launch.</p>', 'AssociateFleetRequest$FleetName' => '<p>The name of the fleet to associate.</p>', 'AssociateFleetRequest$StackName' => '<p>The name of the stack to which the fleet is associated.</p>', 'CreateFleetRequest$ImageName' => '<p>Unique name of the image used by the fleet.</p>', 'CreateFleetRequest$InstanceType' => '<p>The instance type of compute resources for the fleet. Fleet instances are launched from this instance type. Available instance types are:</p> <ul> <li> <p>stream.standard.medium</p> </li> <li> <p>stream.standard.large</p> </li> <li> <p>stream.compute.large</p> </li> <li> <p>stream.compute.xlarge</p> </li> <li> <p>stream.compute.2xlarge</p> </li> <li> <p>stream.compute.4xlarge</p> </li> <li> <p>stream.compute.8xlarge</p> </li> <li> <p>stream.memory.large</p> </li> <li> <p>stream.memory.xlarge</p> </li> <li> <p>stream.memory.2xlarge</p> </li> <li> <p>stream.memory.4xlarge</p> </li> <li> <p>stream.memory.8xlarge</p> </li> </ul>', 'CreateStackRequest$Name' => '<p>The unique identifier for this stack.</p>', 'CreateStreamingURLRequest$StackName' => '<p>The stack for which the URL is generated.</p>', 'CreateStreamingURLRequest$FleetName' => '<p>The fleet for which the URL is generated.</p>', 'CreateStreamingURLRequest$ApplicationId' => '<p>The ID of the application that must be launched after the session starts.</p>', 'CreateStreamingURLRequest$SessionContext' => '<p>The sessionContext of the streaming URL.</p>', 'CreateStreamingURLResult$StreamingURL' => '<p>The URL to start the AppStream 2.0 streaming session.</p>', 'DeleteFleetRequest$Name' => '<p>The name of the fleet to be deleted.</p>', 'DeleteStackRequest$Name' => '<p>The name of the stack to delete.</p>', 'DescribeDirectoryConfigsRequest$NextToken' => '<p>The DescribeDirectoryConfigsResult.NextToken from a previous call to DescribeDirectoryConfigs. If this is the first call, pass null.</p>', 'DescribeDirectoryConfigsResult$NextToken' => '<p>If not null, more results are available. To retrieve the next set of items, pass this value for the NextToken parameter in a subsequent call to DescribeDirectoryConfigs.</p>', 'DescribeFleetsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeFleetsResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DescribeSessionsRequest$StackName' => '<p>The name of the stack for which to list sessions.</p>', 'DescribeSessionsRequest$FleetName' => '<p>The name of the fleet for which to list sessions.</p>', 'DescribeSessionsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeSessionsResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DescribeStacksRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeStacksResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DisassociateFleetRequest$FleetName' => '<p>The name of the fleet to disassociate.</p>', 'DisassociateFleetRequest$StackName' => '<p>The name of the stack with which the fleet is associated.</p>', 'ExpireSessionRequest$SessionId' => '<p>The unique identifier of the streaming session to be stopped.</p>', 'Fleet$Name' => '<p>The name of the fleet.</p>', 'Fleet$DisplayName' => '<p>The name displayed to end users on the AppStream 2.0 portal.</p>', 'Fleet$Description' => '<p>The description displayed to end users on the AppStream 2.0 portal.</p>', 'Fleet$ImageName' => '<p>The image used by the fleet.</p>', 'Fleet$InstanceType' => '<p>The instance type of compute resources for the fleet. The fleet instances are launched from this instance type. </p>', 'FleetError$ErrorMessage' => '<p>The error message generated when the fleet has errors.</p>', 'Image$Name' => '<p>The unique identifier for the image.</p>', 'Image$DisplayName' => '<p>The display name for the image.</p>', 'Image$Description' => '<p>A meaningful description for the image.</p>', 'ImageStateChangeReason$Message' => '<p>The state change reason message to the end user.</p>', 'ListAssociatedFleetsRequest$StackName' => '<p>The name of the stack whose associated fleets are listed.</p>', 'ListAssociatedFleetsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListAssociatedFleetsResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'ListAssociatedStacksRequest$FleetName' => '<p>The name of the fleet whose associated stacks are listed.</p>', 'ListAssociatedStacksRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListAssociatedStacksResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'Metadata$key' => NULL, 'Metadata$value' => NULL, 'SecurityGroupIdList$member' => NULL, 'Session$Id' => '<p>The unique ID for a streaming session.</p>', 'Session$StackName' => '<p>The name of the stack for which the streaming session was created.</p>', 'Session$FleetName' => '<p>The name of the fleet for which the streaming session was created.</p>', 'Stack$Name' => '<p>The unique identifier of the stack.</p>', 'Stack$Description' => '<p>A meaningful description for the stack.</p>', 'Stack$DisplayName' => '<p>A display name for the stack.</p>', 'StackError$ErrorMessage' => '<p>The error message of a stack error.</p>', 'StartFleetRequest$Name' => '<p>The name of the fleet to start.</p>', 'StopFleetRequest$Name' => '<p>The name of the fleet to stop.</p>', 'StringList$member' => NULL, 'SubnetIdList$member' => NULL, 'UpdateFleetRequest$ImageName' => '<p>The image name from which a fleet is created.</p>', 'UpdateFleetRequest$Name' => '<p>The name of the fleet.</p>', 'UpdateFleetRequest$InstanceType' => '<p>The instance type of compute resources for the fleet. Fleet instances are launched from this instance type. Available instance types are:</p> <ul> <li> <p>stream.standard.medium</p> </li> <li> <p>stream.standard.large</p> </li> <li> <p>stream.compute.large</p> </li> <li> <p>stream.compute.xlarge</p> </li> <li> <p>stream.compute.2xlarge</p> </li> <li> <p>stream.compute.4xlarge</p> </li> <li> <p>stream.compute.8xlarge</p> </li> <li> <p>stream.memory.large</p> </li> <li> <p>stream.memory.xlarge</p> </li> <li> <p>stream.memory.2xlarge</p> </li> <li> <p>stream.memory.4xlarge</p> </li> <li> <p>stream.memory.8xlarge</p> </li> </ul>', 'UpdateStackRequest$Name' => '<p>The name of the stack to update.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetsRequest$Names' => '<p>The fleet names to describe. Use null to describe all the fleets for the AWS account.</p>', 'DescribeImagesRequest$Names' => '<p>A specific list of images to describe.</p>', 'DescribeStacksRequest$Names' => '<p>The stack names to describe. Use null to describe all the stacks for the AWS account.</p>', 'ListAssociatedFleetsResult$Names' => '<p>The names of associated fleets.</p>', 'ListAssociatedStacksResult$Names' => '<p>The names of associated stacks.</p>', ], ], 'SubnetIdList' => [ 'base' => '<p>A list of subnet IDs.</p>', 'refs' => [ 'VpcConfig$SubnetIds' => '<p>The list of subnets to which a network interface is established from the fleet instance.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreateStreamingURLResult$Expires' => '<p>Elapsed seconds after the Unix epoch, when this URL expires.</p>', 'DirectoryConfig$CreatedTime' => '<p>The time stamp when the directory configuration was created within AppStream 2.0.</p>', 'Fleet$CreatedTime' => '<p>The time at which the fleet was created.</p>', 'Image$CreatedTime' => '<p>The time stamp when the image was created.</p>', 'Image$PublicBaseImageReleasedDate' => '<p>The AWS release date of the public base image. For private images, this date is the release date of the base image from which the image was created.</p>', 'Stack$CreatedTime' => '<p>The time stamp when the stack was created.</p>', ], ], 'UpdateDirectoryConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDirectoryConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStackResult' => [ 'base' => NULL, 'refs' => [], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'DescribeSessionsRequest$UserId' => '<p>The user for whom to list sessions. Use null to describe all the sessions for the stack and fleet.</p>', 'Session$UserId' => '<p>The identifier of the user for whom the session was created.</p>', ], ], 'VisibilityType' => [ 'base' => NULL, 'refs' => [ 'Image$Visibility' => '<p>The visibility of an image to the user; images can be public or private.</p>', ], ], 'VpcConfig' => [ 'base' => '<p>VPC configuration information.</p>', 'refs' => [ 'CreateFleetRequest$VpcConfig' => '<p>The VPC configuration for the fleet.</p>', 'Fleet$VpcConfig' => '<p>The VPC configuration for the fleet.</p>', 'UpdateFleetRequest$VpcConfig' => '<p>The VPC configuration for the fleet.</p>', ], ], ],];
