<?php
// This file was auto-generated from sdk-root/src/data/athena/2017-05-18/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Athena is an interactive query service that lets you use standard SQL to analyze data directly in Amazon S3. You can point Athena at your data in Amazon S3 and run ad-hoc queries and get results in seconds. Athena is serverless, so there is no infrastructure to set up or manage. You pay only for the queries you run. Athena scales automatically—executing queries in parallel—so results are fast, even with large datasets and complex queries. For more information, see <a href="http://docs.aws.amazon.com/athena/latest/ug/what-is.html">What is Amazon Athena</a> in the <i>Amazon Athena User Guide</i>.</p> <p>For code samples using the AWS SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'operations' => [ 'BatchGetNamedQuery' => '<p>Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query ID strings. Use <a>ListNamedQueries</a> to get the list of named query IDs. If information could not be retrieved for a submitted query ID, information about the query ID submitted is listed under <a>UnprocessedNamedQueryId</a>. Named queries are different from executed queries. Use <a>BatchGetQueryExecution</a> to get details about each unique query execution, and <a>ListQueryExecutions</a> to get a list of query execution IDs.</p>', 'BatchGetQueryExecution' => '<p>Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an array of query execution ID strings. To get a list of query execution IDs, use <a>ListQueryExecutions</a>. Query executions are different from named (saved) queries. Use <a>BatchGetNamedQuery</a> to get details about named queries.</p>', 'CreateNamedQuery' => '<p>Creates a named query.</p> <p>For code samples using the AWS SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'DeleteNamedQuery' => '<p>Deletes a named query.</p> <p>For code samples using the AWS SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'GetNamedQuery' => '<p>Returns information about a single query.</p>', 'GetQueryExecution' => '<p>Returns information about a single execution of a query. Each time a query executes, information about the query execution is saved with a unique ID.</p>', 'GetQueryResults' => '<p>Returns the results of a single query execution specified by <code>QueryExecutionId</code>. This request does not execute the query but returns results. Use <a>StartQueryExecution</a> to run a query.</p>', 'ListNamedQueries' => '<p>Provides a list of all available query IDs.</p> <p>For code samples using the AWS SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'ListQueryExecutions' => '<p>Provides a list of all available query execution IDs.</p> <p>For code samples using the AWS SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'StartQueryExecution' => '<p>Runs (executes) the SQL query statements contained in the <code>Query</code> string.</p> <p>For code samples using the AWS SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'StopQueryExecution' => '<p>Stops a query execution.</p> <p>For code samples using the AWS SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', ], 'shapes' => [ 'BatchGetNamedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetNamedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetQueryExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetQueryExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ColumnInfo$CaseSensitive' => '<p>Indicates whether values in the column are case-sensitive.</p>', ], ], 'ColumnInfo' => [ 'base' => '<p>Information about the columns in a query execution result.</p>', 'refs' => [ 'ColumnInfoList$member' => NULL, ], ], 'ColumnInfoList' => [ 'base' => NULL, 'refs' => [ 'ResultSetMetadata$ColumnInfo' => '<p>Information about the columns in a query execution result.</p>', ], ], 'ColumnNullable' => [ 'base' => NULL, 'refs' => [ 'ColumnInfo$Nullable' => '<p>Indicates the column\'s nullable status.</p>', ], ], 'CreateNamedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'DatabaseString' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryInput$Database' => '<p>The database to which the query belongs.</p>', 'NamedQuery$Database' => '<p>The database to which the query belongs.</p>', 'QueryExecutionContext$Database' => '<p>The name of the database.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'QueryExecutionStatus$SubmissionDateTime' => '<p>The date and time that the query was submitted.</p>', 'QueryExecutionStatus$CompletionDateTime' => '<p>The date and time that the query completed.</p>', ], ], 'Datum' => [ 'base' => '<p>A piece of data (a field in the table).</p>', 'refs' => [ 'datumList$member' => NULL, ], ], 'DeleteNamedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionString' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryInput$Description' => '<p>A brief explanation of the query.</p>', 'NamedQuery$Description' => '<p>A brief description of the query.</p>', ], ], 'EncryptionConfiguration' => [ 'base' => '<p>If query results are encrypted in Amazon S3, indicates the Amazon S3 encryption option used.</p>', 'refs' => [ 'ResultConfiguration$EncryptionConfiguration' => '<p>If query results are encrypted in S3, indicates the S3 encryption option used (for example, <code>SSE-KMS</code> or <code>CSE-KMS</code> and key information.</p>', ], ], 'EncryptionOption' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfiguration$EncryptionOption' => '<p>Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys (<code>SSE-S3</code>), server-side encryption with KMS-managed keys (<code>SSE-KMS</code>), or client-side encryption with KMS-managed keys (CSE-KMS) is used.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'InvalidRequestException$AthenaErrorCode' => NULL, 'UnprocessedNamedQueryId$ErrorCode' => '<p>The error code returned when the processing request for the named query failed, if applicable.</p>', 'UnprocessedQueryExecutionId$ErrorCode' => '<p>The error code returned when the query execution failed to process, if applicable.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'UnprocessedNamedQueryId$ErrorMessage' => '<p>The error message returned when the processing request for the named query failed, if applicable.</p>', 'UnprocessedQueryExecutionId$ErrorMessage' => '<p>The error message returned when the query execution failed to process, if applicable.</p>', ], ], 'GetNamedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetNamedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryResultsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryResultsOutput' => [ 'base' => NULL, 'refs' => [], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryInput$ClientRequestToken' => '<p>A unique case-sensitive string used to ensure the request to create the query is idempotent (executes only once). If another <code>CreateNamedQuery</code> request is received, the same response is returned and another query is not created. If a parameter has changed, for example, the <code>QueryString</code>, an error is returned.</p> <important> <p>This token is listed as not required because AWS SDKs (for example the AWS SDK for Java) auto-generate the token for users. If you are not using the AWS SDK or the AWS CLI, you must provide this token or the action will fail.</p> </important>', 'StartQueryExecutionInput$ClientRequestToken' => '<p>A unique case-sensitive string used to ensure the request to create the query is idempotent (executes only once). If another <code>StartQueryExecution</code> request is received, the same response is returned and another query is not created. If a parameter has changed, for example, the <code>QueryString</code>, an error is returned.</p> <important> <p>This token is listed as not required because AWS SDKs (for example the AWS SDK for Java) auto-generate the token for users. If you are not using the AWS SDK or the AWS CLI, you must provide this token or the action will fail.</p> </important>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ColumnInfo$Precision' => '<p>For <code>DECIMAL</code> data types, specifies the total number of digits, up to 38. For performance reasons, we recommend up to 18 digits.</p>', 'ColumnInfo$Scale' => '<p>For <code>DECIMAL</code> data types, specifies the total number of digits in the fractional part of the value. Defaults to 0.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Indicates a platform issue, which may be due to a transient condition or outage.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>Indicates that something is wrong with the input to the request. For example, a required parameter may be missing or out of range.</p>', 'refs' => [], ], 'ListNamedQueriesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNamedQueriesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListQueryExecutionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListQueryExecutionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'QueryExecutionStatistics$EngineExecutionTimeInMillis' => '<p>The number of milliseconds that the query took to execute.</p>', 'QueryExecutionStatistics$DataScannedInBytes' => '<p>The number of bytes in the data that was queried.</p>', ], ], 'MaxNamedQueriesCount' => [ 'base' => NULL, 'refs' => [ 'ListNamedQueriesInput$MaxResults' => '<p>The maximum number of queries to return in this request.</p>', ], ], 'MaxQueryExecutionsCount' => [ 'base' => NULL, 'refs' => [ 'ListQueryExecutionsInput$MaxResults' => '<p>The maximum number of query executions to return in this request.</p>', ], ], 'MaxQueryResults' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsInput$MaxResults' => '<p>The maximum number of results (rows) to return in this request.</p>', ], ], 'NameString' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryInput$Name' => '<p>The plain language name for the query.</p>', 'NamedQuery$Name' => '<p>The plain-language name of the query.</p>', ], ], 'NamedQuery' => [ 'base' => '<p>A query, where <code>QueryString</code> is the SQL query statements that comprise the query.</p>', 'refs' => [ 'GetNamedQueryOutput$NamedQuery' => '<p>Information about the query.</p>', 'NamedQueryList$member' => NULL, ], ], 'NamedQueryId' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryOutput$NamedQueryId' => '<p>The unique ID of the query.</p>', 'DeleteNamedQueryInput$NamedQueryId' => '<p>The unique ID of the query to delete.</p>', 'GetNamedQueryInput$NamedQueryId' => '<p>The unique ID of the query. Use <a>ListNamedQueries</a> to get query IDs.</p>', 'NamedQuery$NamedQueryId' => '<p>The unique identifier of the query.</p>', 'NamedQueryIdList$member' => NULL, 'UnprocessedNamedQueryId$NamedQueryId' => '<p>The unique identifier of the named query.</p>', ], ], 'NamedQueryIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetNamedQueryInput$NamedQueryIds' => '<p>An array of query IDs.</p>', 'ListNamedQueriesOutput$NamedQueryIds' => '<p>The list of unique query IDs.</p>', ], ], 'NamedQueryList' => [ 'base' => NULL, 'refs' => [ 'BatchGetNamedQueryOutput$NamedQueries' => '<p>Information about the named query IDs submitted.</p>', ], ], 'QueryExecution' => [ 'base' => '<p>Information about a single instance of a query execution.</p>', 'refs' => [ 'GetQueryExecutionOutput$QueryExecution' => '<p>Information about the query execution.</p>', 'QueryExecutionList$member' => NULL, ], ], 'QueryExecutionContext' => [ 'base' => '<p>The database in which the query execution occurs.</p>', 'refs' => [ 'QueryExecution$QueryExecutionContext' => '<p>The database in which the query execution occurred.</p>', 'StartQueryExecutionInput$QueryExecutionContext' => '<p>The database within which the query executes.</p>', ], ], 'QueryExecutionId' => [ 'base' => NULL, 'refs' => [ 'GetQueryExecutionInput$QueryExecutionId' => '<p>The unique ID of the query execution.</p>', 'GetQueryResultsInput$QueryExecutionId' => '<p>The unique ID of the query execution.</p>', 'QueryExecution$QueryExecutionId' => '<p>The unique identifier for each query execution.</p>', 'QueryExecutionIdList$member' => NULL, 'StartQueryExecutionOutput$QueryExecutionId' => '<p>The unique ID of the query that ran as a result of this request.</p>', 'StopQueryExecutionInput$QueryExecutionId' => '<p>The unique ID of the query execution to stop.</p>', 'UnprocessedQueryExecutionId$QueryExecutionId' => '<p>The unique identifier of the query execution.</p>', ], ], 'QueryExecutionIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetQueryExecutionInput$QueryExecutionIds' => '<p>An array of query execution IDs.</p>', 'ListQueryExecutionsOutput$QueryExecutionIds' => '<p>The unique IDs of each query execution as an array of strings.</p>', ], ], 'QueryExecutionList' => [ 'base' => NULL, 'refs' => [ 'BatchGetQueryExecutionOutput$QueryExecutions' => '<p>Information about a query execution.</p>', ], ], 'QueryExecutionState' => [ 'base' => NULL, 'refs' => [ 'QueryExecutionStatus$State' => '<p>The state of query execution. <code>SUBMITTED</code> indicates that the query is queued for execution. <code>RUNNING</code> indicates that the query is scanning data and returning results. <code>SUCCEEDED</code> indicates that the query completed without error. <code>FAILED</code> indicates that the query experienced an error and did not complete processing. <code>CANCELLED</code> indicates that user input interrupted query execution.</p>', ], ], 'QueryExecutionStatistics' => [ 'base' => '<p>The amount of data scanned during the query execution and the amount of time that it took to execute.</p>', 'refs' => [ 'QueryExecution$Statistics' => '<p>The amount of data scanned during the query execution and the amount of time that it took to execute.</p>', ], ], 'QueryExecutionStatus' => [ 'base' => '<p>The completion date, current state, submission time, and state change reason (if applicable) for the query execution.</p>', 'refs' => [ 'QueryExecution$Status' => '<p>The completion date, current state, submission time, and state change reason (if applicable) for the query execution.</p>', ], ], 'QueryString' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryInput$QueryString' => '<p>The text of the query itself. In other words, all query statements.</p>', 'NamedQuery$QueryString' => '<p>The SQL query statements that comprise the query.</p>', 'QueryExecution$Query' => '<p>The SQL query statements which the query execution ran.</p>', 'StartQueryExecutionInput$QueryString' => '<p>The SQL query statements to be executed.</p>', ], ], 'ResultConfiguration' => [ 'base' => '<p>The location in Amazon S3 where query results are stored and the encryption option, if any, used for query results.</p>', 'refs' => [ 'QueryExecution$ResultConfiguration' => '<p>The location in Amazon S3 where query results were stored and the encryption option, if any, used for query results.</p>', 'StartQueryExecutionInput$ResultConfiguration' => '<p>Specifies information about where and how to save the results of the query execution.</p>', ], ], 'ResultSet' => [ 'base' => '<p>The metadata and rows that comprise a query result set. The metadata describes the column structure and data types.</p>', 'refs' => [ 'GetQueryResultsOutput$ResultSet' => '<p>The results of the query execution.</p>', ], ], 'ResultSetMetadata' => [ 'base' => '<p>The metadata that describes the column structure and data types of a table of query results.</p>', 'refs' => [ 'ResultSet$ResultSetMetadata' => '<p>The metadata that describes the column structure and data types of a table of query results.</p>', ], ], 'Row' => [ 'base' => '<p>The rows that comprise a query result table.</p>', 'refs' => [ 'RowList$member' => NULL, ], ], 'RowList' => [ 'base' => NULL, 'refs' => [ 'ResultSet$Rows' => '<p>The rows in the table.</p>', ], ], 'StartQueryExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StartQueryExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopQueryExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StopQueryExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ColumnInfo$CatalogName' => '<p>The catalog to which the query results belong.</p>', 'ColumnInfo$SchemaName' => '<p>The schema name (database name) to which the query results belong.</p>', 'ColumnInfo$TableName' => '<p>The table name for the query results.</p>', 'ColumnInfo$Name' => '<p>The name of the column.</p>', 'ColumnInfo$Label' => '<p>A column label.</p>', 'ColumnInfo$Type' => '<p>The data type of the column.</p>', 'EncryptionConfiguration$KmsKey' => '<p>For <code>SSE-KMS</code> and <code>CSE-KMS</code>, this is the KMS key ARN or ID.</p>', 'QueryExecutionStatus$StateChangeReason' => '<p>Further detail about the status of the query.</p>', 'ResultConfiguration$OutputLocation' => '<p>The location in S3 where query results are stored.</p>', ], ], 'ThrottleReason' => [ 'base' => NULL, 'refs' => [ 'TooManyRequestsException$Reason' => NULL, ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsInput$NextToken' => '<p>The token that specifies where to start pagination if a previous request was truncated.</p>', 'GetQueryResultsOutput$NextToken' => '<p>A token to be used by the next request if this request is truncated.</p>', 'ListNamedQueriesInput$NextToken' => '<p>The token that specifies where to start pagination if a previous request was truncated.</p>', 'ListNamedQueriesOutput$NextToken' => '<p>A token to be used by the next request if this request is truncated.</p>', 'ListQueryExecutionsInput$NextToken' => '<p>The token that specifies where to start pagination if a previous request was truncated.</p>', 'ListQueryExecutionsOutput$NextToken' => '<p>A token to be used by the next request if this request is truncated.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>Indicates that the request was throttled.</p>', 'refs' => [], ], 'UnprocessedNamedQueryId' => [ 'base' => '<p>Information about a named query ID that could not be processed.</p>', 'refs' => [ 'UnprocessedNamedQueryIdList$member' => NULL, ], ], 'UnprocessedNamedQueryIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetNamedQueryOutput$UnprocessedNamedQueryIds' => '<p>Information about provided query IDs.</p>', ], ], 'UnprocessedQueryExecutionId' => [ 'base' => '<p>Describes a query execution that failed to process.</p>', 'refs' => [ 'UnprocessedQueryExecutionIdList$member' => NULL, ], ], 'UnprocessedQueryExecutionIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetQueryExecutionOutput$UnprocessedQueryExecutionIds' => '<p>Information about the query executions that failed to run.</p>', ], ], 'datumList' => [ 'base' => NULL, 'refs' => [ 'Row$Data' => '<p>The data that populates a row in a query result table.</p>', ], ], 'datumString' => [ 'base' => NULL, 'refs' => [ 'Datum$VarCharValue' => '<p>The value of the datum.</p>', ], ], ],];
