<?php
// This file was auto-generated from sdk-root/src/data/autoscaling/2011-01-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Auto Scaling</fullname> <p>Auto Scaling is designed to automatically launch or terminate EC2 instances based on user-defined policies, schedules, and health checks. Use this service in conjunction with the Amazon CloudWatch and Elastic Load Balancing services.</p>', 'operations' => [ 'AttachInstances' => '<p>Attaches one or more EC2 instances to the specified Auto Scaling group.</p> <p>When you attach instances, Auto Scaling increases the desired capacity of the group by the number of instances being attached. If the number of instances being attached plus the desired capacity of the group exceeds the maximum size of the group, the operation fails.</p> <p>If there is a Classic Load Balancer attached to your Auto Scaling group, the instances are also registered with the load balancer. If there are target groups attached to your Auto Scaling group, the instances are also registered with the target groups.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/attach-instance-asg.html">Attach EC2 Instances to Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.</p>', 'AttachLoadBalancerTargetGroups' => '<p>Attaches one or more target groups to the specified Auto Scaling group.</p> <p>To describe the target groups for an Auto Scaling group, use <a>DescribeLoadBalancerTargetGroups</a>. To detach the target group from the Auto Scaling group, use <a>DetachLoadBalancerTargetGroups</a>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/attach-load-balancer-asg.html">Attach a Load Balancer to Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.</p>', 'AttachLoadBalancers' => '<p>Attaches one or more Classic Load Balancers to the specified Auto Scaling group.</p> <p>To attach an Application Load Balancer instead, see <a>AttachLoadBalancerTargetGroups</a>.</p> <p>To describe the load balancers for an Auto Scaling group, use <a>DescribeLoadBalancers</a>. To detach the load balancer from the Auto Scaling group, use <a>DetachLoadBalancers</a>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/attach-load-balancer-asg.html">Attach a Load Balancer to Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.</p>', 'CompleteLifecycleAction' => '<p>Completes the lifecycle action for the specified token or instance with the specified result.</p> <p>This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:</p> <ol> <li> <p>(Optional) Create a Lambda function and a rule that allows CloudWatch Events to invoke your Lambda function when Auto Scaling launches or terminates instances.</p> </li> <li> <p>(Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Auto Scaling to publish lifecycle notifications to the target.</p> </li> <li> <p>Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.</p> </li> <li> <p>If you need more time, record the lifecycle action heartbeat to keep the instance in a pending state.</p> </li> <li> <p> <b>If you finish before the timeout period ends, complete the lifecycle action.</b> </p> </li> </ol> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroupLifecycle.html">Auto Scaling Lifecycle</a> in the <i>Auto Scaling User Guide</i>.</p>', 'CreateAutoScalingGroup' => '<p>Creates an Auto Scaling group with the specified name and attributes.</p> <p>If you exceed your maximum limit of Auto Scaling groups, which by default is 20 per region, the call fails. For information about viewing and updating this limit, see <a>DescribeAccountLimits</a>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroup.html">Auto Scaling Groups</a> in the <i>Auto Scaling User Guide</i>.</p>', 'CreateLaunchConfiguration' => '<p>Creates a launch configuration.</p> <p>If you exceed your maximum limit of launch configurations, which by default is 100 per region, the call fails. For information about viewing and updating this limit, see <a>DescribeAccountLimits</a>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/LaunchConfiguration.html">Launch Configurations</a> in the <i>Auto Scaling User Guide</i>.</p>', 'CreateOrUpdateTags' => '<p>Creates or updates tags for the specified Auto Scaling group.</p> <p>When you specify a tag with a key that already exists, the operation overwrites the previous tag definition, and you do not get an error message.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/autoscaling-tagging.html">Tagging Auto Scaling Groups and Instances</a> in the <i>Auto Scaling User Guide</i>.</p>', 'DeleteAutoScalingGroup' => '<p>Deletes the specified Auto Scaling group.</p> <p>If the group has instances or scaling activities in progress, you must specify the option to force the deletion in order for it to succeed.</p> <p>If the group has policies, deleting the group deletes the policies, the underlying alarm actions, and any alarm that no longer has an associated action.</p> <p>To remove instances from the Auto Scaling group before deleting it, call <a>DetachInstances</a> with the list of instances and the option to decrement the desired capacity so that Auto Scaling does not launch replacement instances.</p> <p>To terminate all instances before deleting the Auto Scaling group, call <a>UpdateAutoScalingGroup</a> and set the minimum size and desired capacity of the Auto Scaling group to zero.</p>', 'DeleteLaunchConfiguration' => '<p>Deletes the specified launch configuration.</p> <p>The launch configuration must not be attached to an Auto Scaling group. When this call completes, the launch configuration is no longer available for use.</p>', 'DeleteLifecycleHook' => '<p>Deletes the specified lifecycle hook.</p> <p>If there are any outstanding lifecycle actions, they are completed first (<code>ABANDON</code> for launching instances, <code>CONTINUE</code> for terminating instances).</p>', 'DeleteNotificationConfiguration' => '<p>Deletes the specified notification.</p>', 'DeletePolicy' => '<p>Deletes the specified Auto Scaling policy.</p> <p>Deleting a policy deletes the underlying alarm action, but does not delete the alarm, even if it no longer has an associated action.</p>', 'DeleteScheduledAction' => '<p>Deletes the specified scheduled action.</p>', 'DeleteTags' => '<p>Deletes the specified tags.</p>', 'DescribeAccountLimits' => '<p>Describes the current Auto Scaling resource limits for your AWS account.</p> <p>For information about requesting an increase in these limits, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">AWS Service Limits</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DescribeAdjustmentTypes' => '<p>Describes the policy adjustment types for use with <a>PutScalingPolicy</a>.</p>', 'DescribeAutoScalingGroups' => '<p>Describes one or more Auto Scaling groups.</p>', 'DescribeAutoScalingInstances' => '<p>Describes one or more Auto Scaling instances.</p>', 'DescribeAutoScalingNotificationTypes' => '<p>Describes the notification types that are supported by Auto Scaling.</p>', 'DescribeLaunchConfigurations' => '<p>Describes one or more launch configurations.</p>', 'DescribeLifecycleHookTypes' => '<p>Describes the available types of lifecycle hooks.</p>', 'DescribeLifecycleHooks' => '<p>Describes the lifecycle hooks for the specified Auto Scaling group.</p>', 'DescribeLoadBalancerTargetGroups' => '<p>Describes the target groups for the specified Auto Scaling group.</p>', 'DescribeLoadBalancers' => '<p>Describes the load balancers for the specified Auto Scaling group.</p> <p>Note that this operation describes only Classic Load Balancers. If you have Application Load Balancers, use <a>DescribeLoadBalancerTargetGroups</a> instead.</p>', 'DescribeMetricCollectionTypes' => '<p>Describes the available CloudWatch metrics for Auto Scaling.</p> <p>Note that the <code>GroupStandbyInstances</code> metric is not returned by default. You must explicitly request this metric when calling <a>EnableMetricsCollection</a>.</p>', 'DescribeNotificationConfigurations' => '<p>Describes the notification actions associated with the specified Auto Scaling group.</p>', 'DescribePolicies' => '<p>Describes the policies for the specified Auto Scaling group.</p>', 'DescribeScalingActivities' => '<p>Describes one or more scaling activities for the specified Auto Scaling group.</p>', 'DescribeScalingProcessTypes' => '<p>Describes the scaling process types for use with <a>ResumeProcesses</a> and <a>SuspendProcesses</a>.</p>', 'DescribeScheduledActions' => '<p>Describes the actions scheduled for your Auto Scaling group that haven\'t run. To describe the actions that have already run, use <a>DescribeScalingActivities</a>.</p>', 'DescribeTags' => '<p>Describes the specified tags.</p> <p>You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it to be included in the results.</p> <p>You can also specify multiple filters. The result includes information for a particular tag only if it matches all the filters. If there\'s no match, no special message is returned.</p>', 'DescribeTerminationPolicyTypes' => '<p>Describes the termination policies supported by Auto Scaling.</p>', 'DetachInstances' => '<p>Removes one or more instances from the specified Auto Scaling group.</p> <p>After the instances are detached, you can manage them independently from the rest of the Auto Scaling group.</p> <p>If you do not specify the option to decrement the desired capacity, Auto Scaling launches instances to replace the ones that are detached.</p> <p>If there is a Classic Load Balancer attached to the Auto Scaling group, the instances are deregistered from the load balancer. If there are target groups attached to the Auto Scaling group, the instances are deregistered from the target groups.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/detach-instance-asg.html">Detach EC2 Instances from Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.</p>', 'DetachLoadBalancerTargetGroups' => '<p>Detaches one or more target groups from the specified Auto Scaling group.</p>', 'DetachLoadBalancers' => '<p>Detaches one or more Classic Load Balancers from the specified Auto Scaling group.</p> <p>Note that this operation detaches only Classic Load Balancers. If you have Application Load Balancers, use <a>DetachLoadBalancerTargetGroups</a> instead.</p> <p>When you detach a load balancer, it enters the <code>Removing</code> state while deregistering the instances in the group. When all instances are deregistered, then you can no longer describe the load balancer using <a>DescribeLoadBalancers</a>. Note that the instances remain running.</p>', 'DisableMetricsCollection' => '<p>Disables group metrics for the specified Auto Scaling group.</p>', 'EnableMetricsCollection' => '<p>Enables group metrics for the specified Auto Scaling group. For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html">Monitoring Your Auto Scaling Groups and Instances</a> in the <i>Auto Scaling User Guide</i>.</p>', 'EnterStandby' => '<p>Moves the specified instances into <code>Standby</code> mode.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroupLifecycle.html">Auto Scaling Lifecycle</a> in the <i>Auto Scaling User Guide</i>.</p>', 'ExecutePolicy' => '<p>Executes the specified policy.</p>', 'ExitStandby' => '<p>Moves the specified instances out of <code>Standby</code> mode.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroupLifecycle.html">Auto Scaling Lifecycle</a> in the <i>Auto Scaling User Guide</i>.</p>', 'PutLifecycleHook' => '<p>Creates or updates a lifecycle hook for the specified Auto Scaling Group.</p> <p>A lifecycle hook tells Auto Scaling that you want to perform an action on an instance that is not actively in service; for example, either when the instance launches or before the instance terminates.</p> <p>This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:</p> <ol> <li> <p>(Optional) Create a Lambda function and a rule that allows CloudWatch Events to invoke your Lambda function when Auto Scaling launches or terminates instances.</p> </li> <li> <p>(Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Auto Scaling to publish lifecycle notifications to the target.</p> </li> <li> <p> <b>Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.</b> </p> </li> <li> <p>If you need more time, record the lifecycle action heartbeat to keep the instance in a pending state.</p> </li> <li> <p>If you finish before the timeout period ends, complete the lifecycle action.</p> </li> </ol> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html">Auto Scaling Lifecycle Hooks</a> in the <i>Auto Scaling User Guide</i>.</p> <p>If you exceed your maximum limit of lifecycle hooks, which by default is 50 per Auto Scaling group, the call fails. For information about updating this limit, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">AWS Service Limits</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'PutNotificationConfiguration' => '<p>Configures an Auto Scaling group to send notifications when specified events take place. Subscribers to the specified topic can have messages delivered to an endpoint such as a web server or an email address.</p> <p>This configuration overwrites any existing configuration.</p> <p>For more information see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/ASGettingNotifications.html">Getting SNS Notifications When Your Auto Scaling Group Scales</a> in the <i>Auto Scaling User Guide</i>.</p>', 'PutScalingPolicy' => '<p>Creates or updates a policy for an Auto Scaling group. To update an existing policy, use the existing policy name and set the parameters you want to change. Any existing parameter not changed in an update to an existing policy is not changed in this update request.</p> <p>If you exceed your maximum limit of step adjustments, which by default is 20 per region, the call fails. For information about updating this limit, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">AWS Service Limits</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'PutScheduledUpdateGroupAction' => '<p>Creates or updates a scheduled scaling action for an Auto Scaling group. When updating a scheduled scaling action, if you leave a parameter unspecified, the corresponding value remains unchanged.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/schedule_time.html">Scheduled Scaling</a> in the <i>Auto Scaling User Guide</i>.</p>', 'RecordLifecycleActionHeartbeat' => '<p>Records a heartbeat for the lifecycle action associated with the specified token or instance. This extends the timeout by the length of time defined using <a>PutLifecycleHook</a>.</p> <p>This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:</p> <ol> <li> <p>(Optional) Create a Lambda function and a rule that allows CloudWatch Events to invoke your Lambda function when Auto Scaling launches or terminates instances.</p> </li> <li> <p>(Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Auto Scaling to publish lifecycle notifications to the target.</p> </li> <li> <p>Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.</p> </li> <li> <p> <b>If you need more time, record the lifecycle action heartbeat to keep the instance in a pending state.</b> </p> </li> <li> <p>If you finish before the timeout period ends, complete the lifecycle action.</p> </li> </ol> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroupLifecycle.html">Auto Scaling Lifecycle</a> in the <i>Auto Scaling User Guide</i>.</p>', 'ResumeProcesses' => '<p>Resumes the specified suspended Auto Scaling processes, or all suspended process, for the specified Auto Scaling group.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-suspend-resume-processes.html">Suspending and Resuming Auto Scaling Processes</a> in the <i>Auto Scaling User Guide</i>.</p>', 'SetDesiredCapacity' => '<p>Sets the size of the specified Auto Scaling group.</p> <p>For more information about desired capacity, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/WhatIsAutoScaling.html">What Is Auto Scaling?</a> in the <i>Auto Scaling User Guide</i>.</p>', 'SetInstanceHealth' => '<p>Sets the health status of the specified instance.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in the <i>Auto Scaling User Guide</i>.</p>', 'SetInstanceProtection' => '<p>Updates the instance protection settings of the specified instances.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <i>Auto Scaling User Guide</i>.</p>', 'SuspendProcesses' => '<p>Suspends the specified Auto Scaling processes, or all processes, for the specified Auto Scaling group.</p> <p>Note that if you suspend either the <code>Launch</code> or <code>Terminate</code> process types, it can prevent other process types from functioning properly.</p> <p>To resume processes that have been suspended, use <a>ResumeProcesses</a>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-suspend-resume-processes.html">Suspending and Resuming Auto Scaling Processes</a> in the <i>Auto Scaling User Guide</i>.</p>', 'TerminateInstanceInAutoScalingGroup' => '<p>Terminates the specified instance and optionally adjusts the desired group size.</p> <p>This call simply makes a termination request. The instance is not terminated immediately.</p>', 'UpdateAutoScalingGroup' => '<p>Updates the configuration for the specified Auto Scaling group.</p> <p>To update an Auto Scaling group with a launch configuration with <code>InstanceMonitoring</code> set to <code>False</code>, you must first disable the collection of group metrics. Otherwise, you will get an error. If you have previously enabled the collection of group metrics, you can disable it using <a>DisableMetricsCollection</a>.</p> <p>The new settings are registered upon the completion of this call. Any launch configuration settings take effect on any triggers after this call returns. Scaling activities that are currently in progress aren\'t affected.</p> <p>Note the following:</p> <ul> <li> <p>If you specify a new value for <code>MinSize</code> without specifying a value for <code>DesiredCapacity</code>, and the new <code>MinSize</code> is larger than the current size of the group, we implicitly call <a>SetDesiredCapacity</a> to set the size of the group to the new value of <code>MinSize</code>.</p> </li> <li> <p>If you specify a new value for <code>MaxSize</code> without specifying a value for <code>DesiredCapacity</code>, and the new <code>MaxSize</code> is smaller than the current size of the group, we implicitly call <a>SetDesiredCapacity</a> to set the size of the group to the new value of <code>MaxSize</code>.</p> </li> <li> <p>All other optional parameters are left unchanged if not specified.</p> </li> </ul>', ], 'shapes' => [ 'Activities' => [ 'base' => NULL, 'refs' => [ 'ActivitiesType$Activities' => '<p>The scaling activities. Activities are sorted by start time. Activities still in progress are described first.</p>', 'DetachInstancesAnswer$Activities' => '<p>The activities related to detaching the instances from the Auto Scaling group.</p>', 'EnterStandbyAnswer$Activities' => '<p>The activities related to moving instances into <code>Standby</code> mode.</p>', 'ExitStandbyAnswer$Activities' => '<p>The activities related to moving instances out of <code>Standby</code> mode.</p>', ], ], 'ActivitiesType' => [ 'base' => '<p>Contains the output of DescribeScalingActivities.</p>', 'refs' => [], ], 'Activity' => [ 'base' => '<p>Describes scaling activity, which is a long-running process that represents a change to your Auto Scaling group, such as changing its size or replacing an instance.</p>', 'refs' => [ 'Activities$member' => NULL, 'ActivityType$Activity' => '<p>A scaling activity.</p>', ], ], 'ActivityIds' => [ 'base' => NULL, 'refs' => [ 'DescribeScalingActivitiesType$ActivityIds' => '<p>The activity IDs of the desired scaling activities. If you omit this parameter, all activities for the past six weeks are described. If you specify an Auto Scaling group, the results are limited to that group. The list of requested activities cannot contain more than 50 items. If unknown activities are requested, they are ignored with no error.</p>', ], ], 'ActivityType' => [ 'base' => '<p>Contains the output of TerminateInstancesInAutoScalingGroup.</p>', 'refs' => [], ], 'AdjustmentType' => [ 'base' => '<p>Describes a policy adjustment type.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/as-scale-based-on-demand.html">Dynamic Scaling</a> in the <i>Auto Scaling User Guide</i>.</p>', 'refs' => [ 'AdjustmentTypes$member' => NULL, ], ], 'AdjustmentTypes' => [ 'base' => NULL, 'refs' => [ 'DescribeAdjustmentTypesAnswer$AdjustmentTypes' => '<p>The policy adjustment types.</p>', ], ], 'Alarm' => [ 'base' => '<p>Describes an alarm.</p>', 'refs' => [ 'Alarms$member' => NULL, ], ], 'Alarms' => [ 'base' => NULL, 'refs' => [ 'PolicyARNType$Alarms' => '<p>The CloudWatch alarms created for the target tracking policy. This parameter will be empty if the policy type is anything other than <code>TargetTrackingScaling</code>.</p>', 'ScalingPolicy$Alarms' => '<p>The CloudWatch alarms related to the policy.</p>', ], ], 'AlreadyExistsFault' => [ 'base' => '<p>You already have an Auto Scaling group or launch configuration with this name.</p>', 'refs' => [], ], 'AsciiStringMaxLen255' => [ 'base' => NULL, 'refs' => [ 'CompleteLifecycleActionType$LifecycleHookName' => '<p>The name of the lifecycle hook.</p>', 'DeleteLifecycleHookType$LifecycleHookName' => '<p>The name of the lifecycle hook.</p>', 'LifecycleHook$LifecycleHookName' => '<p>The name of the lifecycle hook.</p>', 'LifecycleHookNames$member' => NULL, 'PutLifecycleHookType$LifecycleHookName' => '<p>The name of the lifecycle hook.</p>', 'RecordLifecycleActionHeartbeatType$LifecycleHookName' => '<p>The name of the lifecycle hook.</p>', ], ], 'AssociatePublicIpAddress' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$AssociatePublicIpAddress' => '<p>Used for groups that launch instances into a virtual private cloud (VPC). Specifies whether to assign a public IP address to each instance. For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.</p> <p>If you specify this parameter, be sure to specify at least one subnet when you create your group.</p> <p>Default: If the instance is launched into a default subnet, the default is <code>true</code>. If the instance is launched into a nondefault subnet, the default is <code>false</code>. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'LaunchConfiguration$AssociatePublicIpAddress' => '<p>[EC2-VPC] Indicates whether to assign a public IP address to each instance.</p>', ], ], 'AttachInstancesQuery' => [ 'base' => '<p>Contains the parameters for AttachInstances.</p>', 'refs' => [], ], 'AttachLoadBalancerTargetGroupsResultType' => [ 'base' => NULL, 'refs' => [], ], 'AttachLoadBalancerTargetGroupsType' => [ 'base' => '<p>Contains the parameters for AttachLoadBalancerTargetGroups.</p>', 'refs' => [], ], 'AttachLoadBalancersResultType' => [ 'base' => '<p>Contains the output of AttachLoadBalancers.</p>', 'refs' => [], ], 'AttachLoadBalancersType' => [ 'base' => '<p>Contains the parameters for AttachLoadBalancers.</p>', 'refs' => [], ], 'AutoScalingGroup' => [ 'base' => '<p>Describes an Auto Scaling group.</p>', 'refs' => [ 'AutoScalingGroups$member' => NULL, ], ], 'AutoScalingGroupDesiredCapacity' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$DesiredCapacity' => '<p>The desired size of the group.</p>', 'CreateAutoScalingGroupType$DesiredCapacity' => '<p>The number of EC2 instances that should be running in the group. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group.</p>', 'PutScheduledUpdateGroupActionType$DesiredCapacity' => '<p>The number of EC2 instances that should be running in the group.</p>', 'ScheduledUpdateGroupAction$DesiredCapacity' => '<p>The number of instances you prefer to maintain in the group.</p>', 'SetDesiredCapacityType$DesiredCapacity' => '<p>The number of EC2 instances that should be running in the Auto Scaling group.</p>', 'UpdateAutoScalingGroupType$DesiredCapacity' => '<p>The number of EC2 instances that should be running in the Auto Scaling group. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group.</p>', ], ], 'AutoScalingGroupMaxSize' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$MaxSize' => '<p>The maximum size of the group.</p>', 'CreateAutoScalingGroupType$MaxSize' => '<p>The maximum size of the group.</p>', 'PutScheduledUpdateGroupActionType$MaxSize' => '<p>The maximum size for the Auto Scaling group.</p>', 'ScheduledUpdateGroupAction$MaxSize' => '<p>The maximum size of the group.</p>', 'UpdateAutoScalingGroupType$MaxSize' => '<p>The maximum size of the Auto Scaling group.</p>', ], ], 'AutoScalingGroupMinSize' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$MinSize' => '<p>The minimum size of the group.</p>', 'CreateAutoScalingGroupType$MinSize' => '<p>The minimum size of the group.</p>', 'PutScheduledUpdateGroupActionType$MinSize' => '<p>The minimum size for the Auto Scaling group.</p>', 'ScheduledUpdateGroupAction$MinSize' => '<p>The minimum size of the group.</p>', 'UpdateAutoScalingGroupType$MinSize' => '<p>The minimum size of the Auto Scaling group.</p>', ], ], 'AutoScalingGroupNames' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupNamesType$AutoScalingGroupNames' => '<p>The group names. If you omit this parameter, all Auto Scaling groups are described.</p>', 'DescribeNotificationConfigurationsType$AutoScalingGroupNames' => '<p>The name of the group.</p>', ], ], 'AutoScalingGroupNamesType' => [ 'base' => '<p>Contains the parameters for DescribeAutoScalingGroups.</p>', 'refs' => [], ], 'AutoScalingGroups' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupsType$AutoScalingGroups' => '<p>The groups.</p>', ], ], 'AutoScalingGroupsType' => [ 'base' => '<p>Contains the output for DescribeAutoScalingGroups.</p>', 'refs' => [], ], 'AutoScalingInstanceDetails' => [ 'base' => '<p>Describes an EC2 instance associated with an Auto Scaling group.</p>', 'refs' => [ 'AutoScalingInstances$member' => NULL, ], ], 'AutoScalingInstances' => [ 'base' => NULL, 'refs' => [ 'AutoScalingInstancesType$AutoScalingInstances' => '<p>The instances.</p>', ], ], 'AutoScalingInstancesType' => [ 'base' => '<p>Contains the output of DescribeAutoScalingInstances.</p>', 'refs' => [], ], 'AutoScalingNotificationTypes' => [ 'base' => NULL, 'refs' => [ 'DescribeAutoScalingNotificationTypesAnswer$AutoScalingNotificationTypes' => '<p>The notification types.</p>', 'DescribeLifecycleHookTypesAnswer$LifecycleHookTypes' => '<p>The lifecycle hook types.</p>', 'PutNotificationConfigurationType$NotificationTypes' => '<p>The type of event that will cause the notification to be sent. For details about notification types supported by Auto Scaling, see <a>DescribeAutoScalingNotificationTypes</a>.</p>', ], ], 'AvailabilityZones' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$AvailabilityZones' => '<p>One or more Availability Zones for the group.</p>', 'CreateAutoScalingGroupType$AvailabilityZones' => '<p>One or more Availability Zones for the group. This parameter is optional if you specify one or more subnets.</p>', 'UpdateAutoScalingGroupType$AvailabilityZones' => '<p>One or more Availability Zones for the group.</p>', ], ], 'BlockDeviceEbsDeleteOnTermination' => [ 'base' => NULL, 'refs' => [ 'Ebs$DeleteOnTermination' => '<p>Indicates whether the volume is deleted on instance termination.</p> <p>Default: <code>true</code> </p>', ], ], 'BlockDeviceEbsEncrypted' => [ 'base' => NULL, 'refs' => [ 'Ebs$Encrypted' => '<p>Indicates whether the volume should be encrypted. Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are automatically encrypted. There is no way to create an encrypted volume from an unencrypted snapshot or an unencrypted volume from an encrypted snapshot. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'BlockDeviceEbsIops' => [ 'base' => NULL, 'refs' => [ 'Ebs$Iops' => '<p>The number of I/O operations per second (IOPS) to provision for the volume.</p> <p>Constraint: Required when the volume type is <code>io1</code>.</p>', ], ], 'BlockDeviceEbsVolumeSize' => [ 'base' => NULL, 'refs' => [ 'Ebs$VolumeSize' => '<p>The volume size, in GiB. For <code>standard</code> volumes, specify a value from 1 to 1,024. For <code>io1</code> volumes, specify a value from 4 to 16,384. For <code>gp2</code> volumes, specify a value from 1 to 16,384. If you specify a snapshot, the volume size must be equal to or larger than the snapshot size.</p> <p>Default: If you create a volume from a snapshot and you don\'t specify a volume size, the default is the snapshot size.</p>', ], ], 'BlockDeviceEbsVolumeType' => [ 'base' => NULL, 'refs' => [ 'Ebs$VolumeType' => '<p>The volume type. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Valid values: <code>standard</code> | <code>io1</code> | <code>gp2</code> </p> <p>Default: <code>standard</code> </p>', ], ], 'BlockDeviceMapping' => [ 'base' => '<p>Describes a block device mapping.</p>', 'refs' => [ 'BlockDeviceMappings$member' => NULL, ], ], 'BlockDeviceMappings' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$BlockDeviceMappings' => '<p>One or more mappings that specify how block devices are exposed to the instance. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'LaunchConfiguration$BlockDeviceMappings' => '<p>A block device mapping, which specifies the block devices for the instance.</p>', ], ], 'ClassicLinkVPCSecurityGroups' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$ClassicLinkVPCSecurityGroups' => '<p>The IDs of one or more security groups for the specified ClassicLink-enabled VPC. This parameter is required if you specify a ClassicLink-enabled VPC, and is not supported otherwise. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'LaunchConfiguration$ClassicLinkVPCSecurityGroups' => '<p>The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>. This parameter is required if you specify a ClassicLink-enabled VPC, and cannot be used otherwise. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'CompleteLifecycleActionAnswer' => [ 'base' => '<p>Contains the output of CompleteLifecycleAction.</p>', 'refs' => [], ], 'CompleteLifecycleActionType' => [ 'base' => '<p>Contains the parameters for CompleteLifecycleAction.</p>', 'refs' => [], ], 'Cooldown' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$DefaultCooldown' => '<p>The amount of time, in seconds, after a scaling activity completes before another scaling activity can start.</p>', 'CreateAutoScalingGroupType$DefaultCooldown' => '<p>The amount of time, in seconds, after a scaling activity completes before another scaling activity can start. The default is 300.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a> in the <i>Auto Scaling User Guide</i>.</p>', 'PutScalingPolicyType$Cooldown' => '<p>The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start. If this parameter is not specified, the default cooldown period for the group applies.</p> <p>This parameter is supported if the policy type is <code>SimpleScaling</code>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a> in the <i>Auto Scaling User Guide</i>.</p>', 'ScalingPolicy$Cooldown' => '<p>The amount of time, in seconds, after a scaling activity completes before any further trigger-related scaling activities can start.</p>', 'UpdateAutoScalingGroupType$DefaultCooldown' => '<p>The amount of time, in seconds, after a scaling activity completes before another scaling activity can start. The default is 300.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a> in the <i>Auto Scaling User Guide</i>.</p>', ], ], 'CreateAutoScalingGroupType' => [ 'base' => '<p>Contains the parameters for CreateAutoScalingGroup.</p>', 'refs' => [], ], 'CreateLaunchConfigurationType' => [ 'base' => '<p>Contains the parameters for CreateLaunchConfiguration.</p>', 'refs' => [], ], 'CreateOrUpdateTagsType' => [ 'base' => '<p>Contains the parameters for CreateOrUpdateTags.</p>', 'refs' => [], ], 'CustomizedMetricSpecification' => [ 'base' => '<p>Configures a customized metric for a target tracking policy.</p>', 'refs' => [ 'TargetTrackingConfiguration$CustomizedMetricSpecification' => '<p>A customized metric.</p>', ], ], 'DeleteAutoScalingGroupType' => [ 'base' => '<p>Contains the parameters for DeleteAutoScalingGroup.</p>', 'refs' => [], ], 'DeleteLifecycleHookAnswer' => [ 'base' => '<p>Contains the output of DeleteLifecycleHook.</p>', 'refs' => [], ], 'DeleteLifecycleHookType' => [ 'base' => '<p>Contains the parameters for DeleteLifecycleHook.</p>', 'refs' => [], ], 'DeleteNotificationConfigurationType' => [ 'base' => '<p>Contains the parameters for DeleteNotificationConfiguration.</p>', 'refs' => [], ], 'DeletePolicyType' => [ 'base' => '<p>Contains the parameters for DeletePolicy.</p>', 'refs' => [], ], 'DeleteScheduledActionType' => [ 'base' => '<p>Contains the parameters for DeleteScheduledAction.</p>', 'refs' => [], ], 'DeleteTagsType' => [ 'base' => '<p>Contains the parameters for DeleteTags.</p>', 'refs' => [], ], 'DescribeAccountLimitsAnswer' => [ 'base' => '<p>Contains the parameters for DescribeAccountLimits.</p>', 'refs' => [], ], 'DescribeAdjustmentTypesAnswer' => [ 'base' => '<p>Contains the parameters for DescribeAdjustmentTypes.</p>', 'refs' => [], ], 'DescribeAutoScalingInstancesType' => [ 'base' => '<p>Contains the parameters for DescribeAutoScalingInstances.</p>', 'refs' => [], ], 'DescribeAutoScalingNotificationTypesAnswer' => [ 'base' => '<p>Contains the output of DescribeAutoScalingNotificationTypes.</p>', 'refs' => [], ], 'DescribeLifecycleHookTypesAnswer' => [ 'base' => '<p>Contains the output of DescribeLifecycleHookTypes.</p>', 'refs' => [], ], 'DescribeLifecycleHooksAnswer' => [ 'base' => '<p>Contains the output of DescribeLifecycleHooks.</p>', 'refs' => [], ], 'DescribeLifecycleHooksType' => [ 'base' => '<p>Contains the parameters for DescribeLifecycleHooks.</p>', 'refs' => [], ], 'DescribeLoadBalancerTargetGroupsRequest' => [ 'base' => '<p>Contains the parameters for DescribeLoadBalancerTargetGroups.</p>', 'refs' => [], ], 'DescribeLoadBalancerTargetGroupsResponse' => [ 'base' => '<p>Contains the output of DescribeLoadBalancerTargetGroups.</p>', 'refs' => [], ], 'DescribeLoadBalancersRequest' => [ 'base' => '<p>Contains the parameters for DescribeLoadBalancers.</p>', 'refs' => [], ], 'DescribeLoadBalancersResponse' => [ 'base' => '<p>Contains the output of DescribeLoadBalancers.</p>', 'refs' => [], ], 'DescribeMetricCollectionTypesAnswer' => [ 'base' => '<p>Contains the output of DescribeMetricsCollectionTypes.</p>', 'refs' => [], ], 'DescribeNotificationConfigurationsAnswer' => [ 'base' => '<p>Contains the output from DescribeNotificationConfigurations.</p>', 'refs' => [], ], 'DescribeNotificationConfigurationsType' => [ 'base' => '<p>Contains the parameters for DescribeNotificationConfigurations.</p>', 'refs' => [], ], 'DescribePoliciesType' => [ 'base' => '<p>Contains the parameters for DescribePolicies.</p>', 'refs' => [], ], 'DescribeScalingActivitiesType' => [ 'base' => '<p>Contains the parameters for DescribeScalingActivities.</p>', 'refs' => [], ], 'DescribeScheduledActionsType' => [ 'base' => '<p>Contains the parameters for DescribeScheduledActions.</p>', 'refs' => [], ], 'DescribeTagsType' => [ 'base' => '<p>Contains the parameters for DescribeTags.</p>', 'refs' => [], ], 'DescribeTerminationPolicyTypesAnswer' => [ 'base' => '<p>Contains the output of DescribeTerminationPolicyTypes.</p>', 'refs' => [], ], 'DetachInstancesAnswer' => [ 'base' => '<p>Contains the output of DetachInstances.</p>', 'refs' => [], ], 'DetachInstancesQuery' => [ 'base' => '<p>Contains the parameters for DetachInstances.</p>', 'refs' => [], ], 'DetachLoadBalancerTargetGroupsResultType' => [ 'base' => NULL, 'refs' => [], ], 'DetachLoadBalancerTargetGroupsType' => [ 'base' => NULL, 'refs' => [], ], 'DetachLoadBalancersResultType' => [ 'base' => '<p>Contains the output for DetachLoadBalancers.</p>', 'refs' => [], ], 'DetachLoadBalancersType' => [ 'base' => '<p>Contains the parameters for DetachLoadBalancers.</p>', 'refs' => [], ], 'DisableMetricsCollectionQuery' => [ 'base' => '<p>Contains the parameters for DisableMetricsCollection.</p>', 'refs' => [], ], 'DisableScaleIn' => [ 'base' => NULL, 'refs' => [ 'TargetTrackingConfiguration$DisableScaleIn' => '<p>If the parameter is true, then scale-in will be disabled for the target tracking policy, i.e. the target tracking policy will not scale in the Auto Scaling group. The default value is false.</p>', ], ], 'Ebs' => [ 'base' => '<p>Describes an Amazon EBS volume.</p>', 'refs' => [ 'BlockDeviceMapping$Ebs' => '<p>The information about the Amazon EBS volume.</p>', ], ], 'EbsOptimized' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$EbsOptimized' => '<p>Indicates whether the instance is optimized for Amazon EBS I/O. By default, the instance is not optimized for EBS I/O. The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization is not available with all instance types. Additional usage charges apply. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'LaunchConfiguration$EbsOptimized' => '<p>Controls whether the instance is optimized for EBS I/O (<code>true</code>) or not (<code>false</code>).</p>', ], ], 'EnableMetricsCollectionQuery' => [ 'base' => '<p>Contains the parameters for EnableMetricsCollection.</p>', 'refs' => [], ], 'EnabledMetric' => [ 'base' => '<p>Describes an enabled metric.</p>', 'refs' => [ 'EnabledMetrics$member' => NULL, ], ], 'EnabledMetrics' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$EnabledMetrics' => '<p>The metrics enabled for the group.</p>', ], ], 'EnterStandbyAnswer' => [ 'base' => '<p>Contains the output of EnterStandby.</p>', 'refs' => [], ], 'EnterStandbyQuery' => [ 'base' => '<p>Contains the parameters for EnteStandby.</p>', 'refs' => [], ], 'EstimatedInstanceWarmup' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyType$EstimatedInstanceWarmup' => '<p>The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. The default is to use the value specified for the default cooldown period for the group.</p> <p>This parameter is supported if the policy type is <code>StepScaling</code> or <code>TargetTrackingScaling</code>.</p>', 'ScalingPolicy$EstimatedInstanceWarmup' => '<p>The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.</p>', ], ], 'ExecutePolicyType' => [ 'base' => '<p>Contains the parameters for ExecutePolicy.</p>', 'refs' => [], ], 'ExitStandbyAnswer' => [ 'base' => '<p>Contains the parameters for ExitStandby.</p>', 'refs' => [], ], 'ExitStandbyQuery' => [ 'base' => '<p>Contains the parameters for ExitStandby.</p>', 'refs' => [], ], 'Filter' => [ 'base' => '<p>Describes a filter.</p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'DescribeTagsType$Filters' => '<p>A filter used to scope the tags to return.</p>', ], ], 'ForceDelete' => [ 'base' => NULL, 'refs' => [ 'DeleteAutoScalingGroupType$ForceDelete' => '<p>Specifies that the group will be deleted along with all instances associated with the group, without waiting for all instances to be terminated. This parameter also deletes any lifecycle actions associated with the group.</p>', ], ], 'GlobalTimeout' => [ 'base' => NULL, 'refs' => [ 'LifecycleHook$GlobalTimeout' => '<p>The maximum time, in seconds, that an instance can remain in a <code>Pending:Wait</code> or <code>Terminating:Wait</code> state. The maximum is 172800 seconds (48 hours) or 100 times <code>HeartbeatTimeout</code>, whichever is smaller.</p>', ], ], 'HealthCheckGracePeriod' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$HealthCheckGracePeriod' => '<p>The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2 instance that has come into service.</p>', 'CreateAutoScalingGroupType$HealthCheckGracePeriod' => '<p>The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2 instance that has come into service. During this time, any health check failures for the instance are ignored. The default is 0.</p> <p>This parameter is required if you are adding an <code>ELB</code> health check.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in the <i>Auto Scaling User Guide</i>.</p>', 'UpdateAutoScalingGroupType$HealthCheckGracePeriod' => '<p>The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2 instance that has come into service. The default is 0.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in the <i>Auto Scaling User Guide</i>.</p>', ], ], 'HeartbeatTimeout' => [ 'base' => NULL, 'refs' => [ 'LifecycleHook$HeartbeatTimeout' => '<p>The maximum time, in seconds, that can elapse before the lifecycle hook times out. The default is 3600 seconds (1 hour). When the lifecycle hook times out, Auto Scaling performs the default action. You can prevent the lifecycle hook from timing out by calling <a>RecordLifecycleActionHeartbeat</a>.</p>', 'PutLifecycleHookType$HeartbeatTimeout' => '<p>The amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the default action. You can prevent the lifecycle hook from timing out by calling <a>RecordLifecycleActionHeartbeat</a>. The default is 3600 seconds (1 hour).</p>', ], ], 'HonorCooldown' => [ 'base' => NULL, 'refs' => [ 'ExecutePolicyType$HonorCooldown' => '<p>If this parameter is true, Auto Scaling waits for the cooldown period to complete before executing the policy. Otherwise, Auto Scaling executes the policy without waiting for the cooldown period to complete.</p> <p>This parameter is not supported if the policy type is <code>StepScaling</code>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a> in the <i>Auto Scaling User Guide</i>.</p>', 'SetDesiredCapacityType$HonorCooldown' => '<p>By default, <code>SetDesiredCapacity</code> overrides any cooldown period associated with the Auto Scaling group. Specify <code>True</code> to make Auto Scaling to wait for the cool-down period associated with the Auto Scaling group to complete before initiating a scaling activity to set your Auto Scaling group to its new capacity.</p>', ], ], 'Instance' => [ 'base' => '<p>Describes an EC2 instance.</p>', 'refs' => [ 'Instances$member' => NULL, ], ], 'InstanceIds' => [ 'base' => NULL, 'refs' => [ 'AttachInstancesQuery$InstanceIds' => '<p>One or more instance IDs.</p>', 'DescribeAutoScalingInstancesType$InstanceIds' => '<p>The instances to describe; up to 50 instance IDs. If you omit this parameter, all Auto Scaling instances are described. If you specify an ID that does not exist, it is ignored with no error.</p>', 'DetachInstancesQuery$InstanceIds' => '<p>One or more instance IDs.</p>', 'EnterStandbyQuery$InstanceIds' => '<p>One or more instances to move into <code>Standby</code> mode. You must specify at least one instance ID.</p>', 'ExitStandbyQuery$InstanceIds' => '<p>One or more instance IDs. You must specify at least one instance ID.</p>', 'SetInstanceProtectionQuery$InstanceIds' => '<p>One or more instance IDs.</p>', ], ], 'InstanceMonitoring' => [ 'base' => '<p>Describes whether instance monitoring is enabled.</p>', 'refs' => [ 'CreateLaunchConfigurationType$InstanceMonitoring' => '<p>Enables detailed monitoring (<code>true</code>) or basic monitoring (<code>false</code>) for the Auto Scaling instances.</p>', 'LaunchConfiguration$InstanceMonitoring' => '<p>Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (<code>false</code>) monitoring.</p>', ], ], 'InstanceProtected' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$NewInstancesProtectedFromScaleIn' => '<p>Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling in.</p>', 'AutoScalingInstanceDetails$ProtectedFromScaleIn' => '<p>Indicates whether the instance is protected from termination by Auto Scaling when scaling in.</p>', 'CreateAutoScalingGroupType$NewInstancesProtectedFromScaleIn' => '<p>Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling in.</p>', 'Instance$ProtectedFromScaleIn' => '<p>Indicates whether the instance is protected from termination by Auto Scaling when scaling in.</p>', 'UpdateAutoScalingGroupType$NewInstancesProtectedFromScaleIn' => '<p>Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling in.</p>', ], ], 'Instances' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$Instances' => '<p>The EC2 instances associated with the group.</p>', ], ], 'InvalidNextToken' => [ 'base' => '<p>The <code>NextToken</code> value is not valid.</p>', 'refs' => [], ], 'LaunchConfiguration' => [ 'base' => '<p>Describes a launch configuration.</p>', 'refs' => [ 'LaunchConfigurations$member' => NULL, ], ], 'LaunchConfigurationNameType' => [ 'base' => '<p>Contains the parameters for DeleteLaunchConfiguration.</p>', 'refs' => [], ], 'LaunchConfigurationNames' => [ 'base' => NULL, 'refs' => [ 'LaunchConfigurationNamesType$LaunchConfigurationNames' => '<p>The launch configuration names. If you omit this parameter, all launch configurations are described.</p>', ], ], 'LaunchConfigurationNamesType' => [ 'base' => '<p>Contains the parameters for DescribeLaunchConfigurations.</p>', 'refs' => [], ], 'LaunchConfigurations' => [ 'base' => NULL, 'refs' => [ 'LaunchConfigurationsType$LaunchConfigurations' => '<p>The launch configurations.</p>', ], ], 'LaunchConfigurationsType' => [ 'base' => '<p>Contains the output of DescribeLaunchConfigurations.</p>', 'refs' => [], ], 'LifecycleActionResult' => [ 'base' => NULL, 'refs' => [ 'CompleteLifecycleActionType$LifecycleActionResult' => '<p>The action for the group to take. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>.</p>', 'LifecycleHook$DefaultResult' => '<p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. The valid values are <code>CONTINUE</code> and <code>ABANDON</code>. The default value is <code>CONTINUE</code>.</p>', 'PutLifecycleHookType$DefaultResult' => '<p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>. The default value is <code>ABANDON</code>.</p>', ], ], 'LifecycleActionToken' => [ 'base' => NULL, 'refs' => [ 'CompleteLifecycleActionType$LifecycleActionToken' => '<p>A universally unique identifier (UUID) that identifies a specific lifecycle action associated with an instance. Auto Scaling sends this token to the notification target you specified when you created the lifecycle hook.</p>', 'RecordLifecycleActionHeartbeatType$LifecycleActionToken' => '<p>A token that uniquely identifies a specific lifecycle action associated with an instance. Auto Scaling sends this token to the notification target you specified when you created the lifecycle hook.</p>', ], ], 'LifecycleHook' => [ 'base' => '<p>Describes a lifecycle hook, which tells Auto Scaling that you want to perform an action when an instance launches or terminates. When you have a lifecycle hook in place, the Auto Scaling group will either:</p> <ul> <li> <p>Pause the instance after it launches, but before it is put into service</p> </li> <li> <p>Pause the instance as it terminates, but before it is fully terminated</p> </li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroupLifecycle.html">Auto Scaling Lifecycle</a> in the <i>Auto Scaling User Guide</i>.</p>', 'refs' => [ 'LifecycleHooks$member' => NULL, ], ], 'LifecycleHookNames' => [ 'base' => NULL, 'refs' => [ 'DescribeLifecycleHooksType$LifecycleHookNames' => '<p>The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.</p>', ], ], 'LifecycleHooks' => [ 'base' => NULL, 'refs' => [ 'DescribeLifecycleHooksAnswer$LifecycleHooks' => '<p>The lifecycle hooks for the specified group.</p>', ], ], 'LifecycleState' => [ 'base' => NULL, 'refs' => [ 'Instance$LifecycleState' => '<p>A description of the current lifecycle state. Note that the <code>Quarantined</code> state is not used.</p>', ], ], 'LifecycleTransition' => [ 'base' => NULL, 'refs' => [ 'LifecycleHook$LifecycleTransition' => '<p>The state of the EC2 instance to which you want to attach the lifecycle hook. For a list of lifecycle hook types, see <a>DescribeLifecycleHookTypes</a>.</p>', 'PutLifecycleHookType$LifecycleTransition' => '<p>The instance state to which you want to attach the lifecycle hook. For a list of lifecycle hook types, see <a>DescribeLifecycleHookTypes</a>.</p> <p>This parameter is required for new lifecycle hooks, but optional when updating existing hooks.</p>', ], ], 'LimitExceededFault' => [ 'base' => '<p>You have already reached a limit for your Auto Scaling resources (for example, groups, launch configurations, or lifecycle hooks). For more information, see <a>DescribeAccountLimits</a>.</p>', 'refs' => [], ], 'LoadBalancerNames' => [ 'base' => NULL, 'refs' => [ 'AttachLoadBalancersType$LoadBalancerNames' => '<p>One or more load balancer names.</p>', 'AutoScalingGroup$LoadBalancerNames' => '<p>One or more load balancers associated with the group.</p>', 'CreateAutoScalingGroupType$LoadBalancerNames' => '<p>One or more Classic Load Balancers. To specify an Application Load Balancer, use <code>TargetGroupARNs</code> instead.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-asg-from-instance.html">Using a Load Balancer With an Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.</p>', 'DetachLoadBalancersType$LoadBalancerNames' => '<p>One or more load balancer names.</p>', ], ], 'LoadBalancerState' => [ 'base' => '<p>Describes the state of a Classic Load Balancer.</p> <p>If you specify a load balancer when creating the Auto Scaling group, the state of the load balancer is <code>InService</code>.</p> <p>If you attach a load balancer to an existing Auto Scaling group, the initial state is <code>Adding</code>. The state transitions to <code>Added</code> after all instances in the group are registered with the load balancer. If ELB health checks are enabled for the load balancer, the state transitions to <code>InService</code> after at least one instance in the group passes the health check. If EC2 health checks are enabled instead, the load balancer remains in the <code>Added</code> state.</p>', 'refs' => [ 'LoadBalancerStates$member' => NULL, ], ], 'LoadBalancerStates' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBalancersResponse$LoadBalancers' => '<p>The load balancers.</p>', ], ], 'LoadBalancerTargetGroupState' => [ 'base' => '<p>Describes the state of a target group.</p> <p>If you attach a target group to an existing Auto Scaling group, the initial state is <code>Adding</code>. The state transitions to <code>Added</code> after all Auto Scaling instances are registered with the target group. If ELB health checks are enabled, the state transitions to <code>InService</code> after at least one Auto Scaling instance passes the health check. If EC2 health checks are enabled instead, the target group remains in the <code>Added</code> state.</p>', 'refs' => [ 'LoadBalancerTargetGroupStates$member' => NULL, ], ], 'LoadBalancerTargetGroupStates' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBalancerTargetGroupsResponse$LoadBalancerTargetGroups' => '<p>Information about the target groups.</p>', ], ], 'MaxNumberOfAutoScalingGroups' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsAnswer$MaxNumberOfAutoScalingGroups' => '<p>The maximum number of groups allowed for your AWS account. The default limit is 20 per region.</p>', ], ], 'MaxNumberOfLaunchConfigurations' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsAnswer$MaxNumberOfLaunchConfigurations' => '<p>The maximum number of launch configurations allowed for your AWS account. The default limit is 100 per region.</p>', ], ], 'MaxRecords' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupNamesType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.</p>', 'DescribeAutoScalingInstancesType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.</p>', 'DescribeLoadBalancerTargetGroupsRequest$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.</p>', 'DescribeLoadBalancersRequest$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.</p>', 'DescribeNotificationConfigurationsType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.</p>', 'DescribePoliciesType$MaxRecords' => '<p>The maximum number of items to be returned with each call. The default value is 50 and the maximum value is 100.</p>', 'DescribeScalingActivitiesType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is 100.</p>', 'DescribeScheduledActionsType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.</p>', 'DescribeTagsType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.</p>', 'LaunchConfigurationNamesType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.</p>', ], ], 'MetricCollectionType' => [ 'base' => '<p>Describes a metric.</p>', 'refs' => [ 'MetricCollectionTypes$member' => NULL, ], ], 'MetricCollectionTypes' => [ 'base' => NULL, 'refs' => [ 'DescribeMetricCollectionTypesAnswer$Metrics' => '<p>One or more metrics.</p>', ], ], 'MetricDimension' => [ 'base' => '<p>Describes the dimension of a metric.</p>', 'refs' => [ 'MetricDimensions$member' => NULL, ], ], 'MetricDimensionName' => [ 'base' => NULL, 'refs' => [ 'MetricDimension$Name' => '<p>The name of the dimension.</p>', ], ], 'MetricDimensionValue' => [ 'base' => NULL, 'refs' => [ 'MetricDimension$Value' => '<p>The value of the dimension.</p>', ], ], 'MetricDimensions' => [ 'base' => NULL, 'refs' => [ 'CustomizedMetricSpecification$Dimensions' => '<p>The dimensions of the metric.</p>', ], ], 'MetricGranularityType' => [ 'base' => '<p>Describes a granularity of a metric.</p>', 'refs' => [ 'MetricGranularityTypes$member' => NULL, ], ], 'MetricGranularityTypes' => [ 'base' => NULL, 'refs' => [ 'DescribeMetricCollectionTypesAnswer$Granularities' => '<p>The granularities for the metrics.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'CustomizedMetricSpecification$MetricName' => '<p>The name of the metric.</p>', ], ], 'MetricNamespace' => [ 'base' => NULL, 'refs' => [ 'CustomizedMetricSpecification$Namespace' => '<p>The namespace of the metric.</p>', ], ], 'MetricScale' => [ 'base' => NULL, 'refs' => [ 'ExecutePolicyType$MetricValue' => '<p>The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the metric value to 59.</p> <p>If you specify a metric value that doesn\'t correspond to a step adjustment for the policy, the call returns an error.</p> <p>This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.</p>', 'ExecutePolicyType$BreachThreshold' => '<p>The breach threshold for the alarm.</p> <p>This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.</p>', 'StepAdjustment$MetricIntervalLowerBound' => '<p>The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.</p>', 'StepAdjustment$MetricIntervalUpperBound' => '<p>The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.</p> <p>The upper bound must be greater than the lower bound.</p>', 'TargetTrackingConfiguration$TargetValue' => '<p>The target value for the metric.</p>', ], ], 'MetricStatistic' => [ 'base' => NULL, 'refs' => [ 'CustomizedMetricSpecification$Statistic' => '<p>The statistic of the metric.</p>', ], ], 'MetricType' => [ 'base' => NULL, 'refs' => [ 'PredefinedMetricSpecification$PredefinedMetricType' => '<p>The metric type.</p>', ], ], 'MetricUnit' => [ 'base' => NULL, 'refs' => [ 'CustomizedMetricSpecification$Unit' => '<p>The unit of the metric.</p>', ], ], 'Metrics' => [ 'base' => NULL, 'refs' => [ 'DisableMetricsCollectionQuery$Metrics' => '<p>One or more of the following metrics. If you omit this parameter, all metrics are disabled.</p> <ul> <li> <p> <code>GroupMinSize</code> </p> </li> <li> <p> <code>GroupMaxSize</code> </p> </li> <li> <p> <code>GroupDesiredCapacity</code> </p> </li> <li> <p> <code>GroupInServiceInstances</code> </p> </li> <li> <p> <code>GroupPendingInstances</code> </p> </li> <li> <p> <code>GroupStandbyInstances</code> </p> </li> <li> <p> <code>GroupTerminatingInstances</code> </p> </li> <li> <p> <code>GroupTotalInstances</code> </p> </li> </ul>', 'EnableMetricsCollectionQuery$Metrics' => '<p>One or more of the following metrics. If you omit this parameter, all metrics are enabled.</p> <ul> <li> <p> <code>GroupMinSize</code> </p> </li> <li> <p> <code>GroupMaxSize</code> </p> </li> <li> <p> <code>GroupDesiredCapacity</code> </p> </li> <li> <p> <code>GroupInServiceInstances</code> </p> </li> <li> <p> <code>GroupPendingInstances</code> </p> </li> <li> <p> <code>GroupStandbyInstances</code> </p> </li> <li> <p> <code>GroupTerminatingInstances</code> </p> </li> <li> <p> <code>GroupTotalInstances</code> </p> </li> </ul>', ], ], 'MinAdjustmentMagnitude' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyType$MinAdjustmentMagnitude' => '<p>The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the Auto Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>.</p> <p>This parameter is supported if the policy type is <code>SimpleScaling</code> or <code>StepScaling</code>.</p>', 'ScalingPolicy$MinAdjustmentMagnitude' => '<p>The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the Auto Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>.</p>', ], ], 'MinAdjustmentStep' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyType$MinAdjustmentStep' => '<p>Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.</p>', 'ScalingPolicy$MinAdjustmentStep' => '<p>Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.</p>', ], ], 'MonitoringEnabled' => [ 'base' => NULL, 'refs' => [ 'InstanceMonitoring$Enabled' => '<p>If <code>True</code>, instance monitoring is enabled.</p>', ], ], 'NoDevice' => [ 'base' => NULL, 'refs' => [ 'BlockDeviceMapping$NoDevice' => '<p>Suppresses a device mapping.</p> <p>If this parameter is true for the root device, the instance might fail the EC2 health check. Auto Scaling launches a replacement instance if the instance fails the health check.</p>', ], ], 'NotificationConfiguration' => [ 'base' => '<p>Describes a notification.</p>', 'refs' => [ 'NotificationConfigurations$member' => NULL, ], ], 'NotificationConfigurations' => [ 'base' => NULL, 'refs' => [ 'DescribeNotificationConfigurationsAnswer$NotificationConfigurations' => '<p>The notification configurations.</p>', ], ], 'NotificationTargetResourceName' => [ 'base' => NULL, 'refs' => [ 'PutLifecycleHookType$NotificationTargetARN' => '<p>The ARN of the notification target that Auto Scaling will use to notify you when an instance is in the transition state for the lifecycle hook. This target can be either an SQS queue or an SNS topic. If you specify an empty string, this overrides the current ARN.</p> <p>This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email key/value pair format when sending notifications to an Amazon SNS topic.</p> <p>When you specify a notification target, Auto Scaling sends it a test message. Test messages contains the following additional key/value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.</p>', ], ], 'NumberOfAutoScalingGroups' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsAnswer$NumberOfAutoScalingGroups' => '<p>The current number of groups for your AWS account.</p>', ], ], 'NumberOfLaunchConfigurations' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsAnswer$NumberOfLaunchConfigurations' => '<p>The current number of launch configurations for your AWS account.</p>', ], ], 'PoliciesType' => [ 'base' => '<p>Contains the output of DescribePolicies.</p>', 'refs' => [], ], 'PolicyARNType' => [ 'base' => '<p>Contains the output of PutScalingPolicy.</p>', 'refs' => [], ], 'PolicyIncrement' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyType$ScalingAdjustment' => '<p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity.</p> <p>This parameter is required if the policy type is <code>SimpleScaling</code> and not supported otherwise.</p>', 'ScalingPolicy$ScalingAdjustment' => '<p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity.</p>', 'StepAdjustment$ScalingAdjustment' => '<p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity.</p>', ], ], 'PolicyNames' => [ 'base' => NULL, 'refs' => [ 'DescribePoliciesType$PolicyNames' => '<p>One or more policy names or policy ARNs to be described. If you omit this parameter, all policy names are described. If an group name is provided, the results are limited to that group. This list is limited to 50 items. If you specify an unknown policy name, it is ignored with no error.</p>', ], ], 'PolicyTypes' => [ 'base' => NULL, 'refs' => [ 'DescribePoliciesType$PolicyTypes' => '<p>One or more policy types. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>.</p>', ], ], 'PredefinedMetricSpecification' => [ 'base' => '<p>Configures a predefined metric for a target tracking policy. The following predefined metrics are available:</p> <ul> <li> <p> <code>ASGAverageCPUUtilization</code> - average CPU utilization of the Auto Scaling group</p> </li> <li> <p> <code>ASGAverageNetworkIn</code> - average number of bytes received on all network interfaces by the Auto Scaling group</p> </li> <li> <p> <code>ASGAverageNetworkOut</code> - average number of bytes sent out on all network interfaces by the Auto Scaling group</p> </li> <li> <p> <code>ALBRequestCountPerTarget</code> - number of requests completed per target in an Application Load Balancer target group</p> </li> </ul>', 'refs' => [ 'TargetTrackingConfiguration$PredefinedMetricSpecification' => '<p>A predefined metric. You can specify either a predefined metric or a customized metric.</p>', ], ], 'ProcessNames' => [ 'base' => NULL, 'refs' => [ 'ScalingProcessQuery$ScalingProcesses' => '<p>One or more of the following processes. If you omit this parameter, all processes are specified.</p> <ul> <li> <p> <code>Launch</code> </p> </li> <li> <p> <code>Terminate</code> </p> </li> <li> <p> <code>HealthCheck</code> </p> </li> <li> <p> <code>ReplaceUnhealthy</code> </p> </li> <li> <p> <code>AZRebalance</code> </p> </li> <li> <p> <code>AlarmNotification</code> </p> </li> <li> <p> <code>ScheduledActions</code> </p> </li> <li> <p> <code>AddToLoadBalancer</code> </p> </li> </ul>', ], ], 'ProcessType' => [ 'base' => '<p>Describes a process type.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-suspend-resume-processes.html#process-types">Auto Scaling Processes</a> in the <i>Auto Scaling User Guide</i>.</p>', 'refs' => [ 'Processes$member' => NULL, ], ], 'Processes' => [ 'base' => NULL, 'refs' => [ 'ProcessesType$Processes' => '<p>The names of the process types.</p>', ], ], 'ProcessesType' => [ 'base' => '<p>Contains the output of DescribeScalingProcessTypes.</p>', 'refs' => [], ], 'Progress' => [ 'base' => NULL, 'refs' => [ 'Activity$Progress' => '<p>A value between 0 and 100 that indicates the progress of the activity.</p>', ], ], 'PropagateAtLaunch' => [ 'base' => NULL, 'refs' => [ 'Tag$PropagateAtLaunch' => '<p>Determines whether the tag is added to new instances as they are launched in the group.</p>', 'TagDescription$PropagateAtLaunch' => '<p>Determines whether the tag is added to new instances as they are launched in the group.</p>', ], ], 'ProtectedFromScaleIn' => [ 'base' => NULL, 'refs' => [ 'SetInstanceProtectionQuery$ProtectedFromScaleIn' => '<p>Indicates whether the instance is protected from termination by Auto Scaling when scaling in.</p>', ], ], 'PutLifecycleHookAnswer' => [ 'base' => '<p>Contains the output of PutLifecycleHook.</p>', 'refs' => [], ], 'PutLifecycleHookType' => [ 'base' => '<p>Contains the parameters for PutLifecycleHook.</p>', 'refs' => [], ], 'PutNotificationConfigurationType' => [ 'base' => '<p>Contains the parameters for PutNotificationConfiguration.</p>', 'refs' => [], ], 'PutScalingPolicyType' => [ 'base' => '<p>Contains the parameters for PutScalingPolicy.</p>', 'refs' => [], ], 'PutScheduledUpdateGroupActionType' => [ 'base' => '<p>Contains the parameters for PutScheduledUpdateGroupAction.</p>', 'refs' => [], ], 'RecordLifecycleActionHeartbeatAnswer' => [ 'base' => '<p>Contains the output of RecordLifecycleActionHeartBeat.</p>', 'refs' => [], ], 'RecordLifecycleActionHeartbeatType' => [ 'base' => '<p>Contains the parameters for RecordLifecycleActionHeartbeat.</p>', 'refs' => [], ], 'ResourceContentionFault' => [ 'base' => '<p>You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load balancer).</p>', 'refs' => [], ], 'ResourceInUseFault' => [ 'base' => '<p>The operation can\'t be performed because the resource is in use.</p>', 'refs' => [], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'Alarm$AlarmARN' => '<p>The Amazon Resource Name (ARN) of the alarm.</p>', 'AttachInstancesQuery$AutoScalingGroupName' => '<p>The name of the group.</p>', 'AttachLoadBalancerTargetGroupsType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'AttachLoadBalancersType$AutoScalingGroupName' => '<p>The name of the group.</p>', 'AutoScalingGroup$AutoScalingGroupARN' => '<p>The Amazon Resource Name (ARN) of the group.</p>', 'AutoScalingGroupNames$member' => NULL, 'CompleteLifecycleActionType$AutoScalingGroupName' => '<p>The name of the group for the lifecycle hook.</p>', 'CreateAutoScalingGroupType$LaunchConfigurationName' => '<p>The name of the launch configuration. Alternatively, specify an EC2 instance instead of a launch configuration.</p>', 'DeleteAutoScalingGroupType$AutoScalingGroupName' => '<p>The name of the group to delete.</p>', 'DeleteLifecycleHookType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group for the lifecycle hook.</p>', 'DeleteNotificationConfigurationType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DeleteNotificationConfigurationType$TopicARN' => '<p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.</p>', 'DeletePolicyType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DeletePolicyType$PolicyName' => '<p>The name or Amazon Resource Name (ARN) of the policy.</p>', 'DeleteScheduledActionType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DeleteScheduledActionType$ScheduledActionName' => '<p>The name of the action to delete.</p>', 'DescribeLifecycleHooksType$AutoScalingGroupName' => '<p>The name of the group.</p>', 'DescribeLoadBalancerTargetGroupsRequest$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DescribeLoadBalancersRequest$AutoScalingGroupName' => '<p>The name of the group.</p>', 'DescribePoliciesType$AutoScalingGroupName' => '<p>The name of the group.</p>', 'DescribeScalingActivitiesType$AutoScalingGroupName' => '<p>The name of the group.</p>', 'DescribeScheduledActionsType$AutoScalingGroupName' => '<p>The name of the group.</p>', 'DetachInstancesQuery$AutoScalingGroupName' => '<p>The name of the group.</p>', 'DetachLoadBalancerTargetGroupsType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DetachLoadBalancersType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DisableMetricsCollectionQuery$AutoScalingGroupName' => '<p>The name or Amazon Resource Name (ARN) of the group.</p>', 'EnableMetricsCollectionQuery$AutoScalingGroupName' => '<p>The name or ARN of the Auto Scaling group.</p>', 'EnterStandbyQuery$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'ExecutePolicyType$AutoScalingGroupName' => '<p>The name or Amazon Resource Name (ARN) of the Auto Scaling group.</p>', 'ExecutePolicyType$PolicyName' => '<p>The name or ARN of the policy.</p>', 'ExitStandbyQuery$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'LaunchConfiguration$LaunchConfigurationARN' => '<p>The Amazon Resource Name (ARN) of the launch configuration.</p>', 'LaunchConfigurationNameType$LaunchConfigurationName' => '<p>The name of the launch configuration.</p>', 'LaunchConfigurationNames$member' => NULL, 'LifecycleHook$AutoScalingGroupName' => '<p>The name of the Auto Scaling group for the lifecycle hook.</p>', 'LifecycleHook$NotificationTargetARN' => '<p>The ARN of the notification target that Auto Scaling uses to notify you when an instance is in the transition state for the lifecycle hook. This ARN target can be either an SQS queue or an SNS topic. The notification message sent to the target includes the following:</p> <ul> <li> <p>Lifecycle action token</p> </li> <li> <p>User account ID</p> </li> <li> <p>Name of the Auto Scaling group</p> </li> <li> <p>Lifecycle hook name</p> </li> <li> <p>EC2 instance ID</p> </li> <li> <p>Lifecycle transition</p> </li> <li> <p>Notification metadata</p> </li> </ul>', 'LifecycleHook$RoleARN' => '<p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.</p>', 'NotificationConfiguration$AutoScalingGroupName' => '<p>The name of the group.</p>', 'NotificationConfiguration$TopicARN' => '<p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.</p>', 'PolicyARNType$PolicyARN' => '<p>The Amazon Resource Name (ARN) of the policy.</p>', 'PolicyNames$member' => NULL, 'PutLifecycleHookType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group to which you want to assign the lifecycle hook.</p>', 'PutLifecycleHookType$RoleARN' => '<p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.</p> <p>This parameter is required for new lifecycle hooks, but optional when updating existing hooks.</p>', 'PutNotificationConfigurationType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'PutNotificationConfigurationType$TopicARN' => '<p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.</p>', 'PutScalingPolicyType$AutoScalingGroupName' => '<p>The name or ARN of the group.</p>', 'PutScheduledUpdateGroupActionType$AutoScalingGroupName' => '<p>The name or Amazon Resource Name (ARN) of the Auto Scaling group.</p>', 'RecordLifecycleActionHeartbeatType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group for the hook.</p>', 'ScalingPolicy$PolicyARN' => '<p>The Amazon Resource Name (ARN) of the policy.</p>', 'ScalingProcessQuery$AutoScalingGroupName' => '<p>The name or Amazon Resource Name (ARN) of the Auto Scaling group.</p>', 'ScheduledActionNames$member' => NULL, 'ScheduledUpdateGroupAction$ScheduledActionARN' => '<p>The Amazon Resource Name (ARN) of the scheduled action.</p>', 'SetDesiredCapacityType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'SetInstanceProtectionQuery$AutoScalingGroupName' => '<p>The name of the group.</p>', 'UpdateAutoScalingGroupType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'UpdateAutoScalingGroupType$LaunchConfigurationName' => '<p>The name of the launch configuration.</p>', ], ], 'ScalingActivityInProgressFault' => [ 'base' => '<p>The operation can\'t be performed because there are scaling activities in progress.</p>', 'refs' => [], ], 'ScalingActivityStatusCode' => [ 'base' => NULL, 'refs' => [ 'Activity$StatusCode' => '<p>The current status of the activity.</p>', ], ], 'ScalingPolicies' => [ 'base' => NULL, 'refs' => [ 'PoliciesType$ScalingPolicies' => '<p>The scaling policies.</p>', ], ], 'ScalingPolicy' => [ 'base' => '<p>Describes a scaling policy.</p>', 'refs' => [ 'ScalingPolicies$member' => NULL, ], ], 'ScalingProcessQuery' => [ 'base' => '<p>Contains the parameters for SuspendProcesses and ResumeProcesses.</p>', 'refs' => [], ], 'ScheduledActionNames' => [ 'base' => NULL, 'refs' => [ 'DescribeScheduledActionsType$ScheduledActionNames' => '<p>Describes one or more scheduled actions. If you omit this parameter, all scheduled actions are described. If you specify an unknown scheduled action, it is ignored with no error.</p> <p>You can describe up to a maximum of 50 instances with a single call. If there are more items to return, the call returns a token. To get the next set of items, repeat the call with the returned token.</p>', ], ], 'ScheduledActionsType' => [ 'base' => '<p>Contains the output of DescribeScheduledActions.</p>', 'refs' => [], ], 'ScheduledUpdateGroupAction' => [ 'base' => '<p>Describes a scheduled update to an Auto Scaling group.</p>', 'refs' => [ 'ScheduledUpdateGroupActions$member' => NULL, ], ], 'ScheduledUpdateGroupActions' => [ 'base' => NULL, 'refs' => [ 'ScheduledActionsType$ScheduledUpdateGroupActions' => '<p>The scheduled actions.</p>', ], ], 'SecurityGroups' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$SecurityGroups' => '<p>One or more security groups with which to associate the instances.</p> <p>If your instances are launched in EC2-Classic, you can either specify security group names or the security group IDs. For more information about security groups for EC2-Classic, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>If your instances are launched into a VPC, specify security group IDs. For more information, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'LaunchConfiguration$SecurityGroups' => '<p>The security groups to associate with the instances.</p>', ], ], 'SetDesiredCapacityType' => [ 'base' => '<p>Contains the parameters for SetDesiredCapacity.</p>', 'refs' => [], ], 'SetInstanceHealthQuery' => [ 'base' => '<p>Contains the parameters for SetInstanceHealth.</p>', 'refs' => [], ], 'SetInstanceProtectionAnswer' => [ 'base' => '<p>Contains the output of SetInstanceProtection.</p>', 'refs' => [], ], 'SetInstanceProtectionQuery' => [ 'base' => '<p>Contains the parameters for SetInstanceProtection.</p>', 'refs' => [], ], 'ShouldDecrementDesiredCapacity' => [ 'base' => NULL, 'refs' => [ 'DetachInstancesQuery$ShouldDecrementDesiredCapacity' => '<p>If <code>True</code>, the Auto Scaling group decrements the desired capacity value by the number of instances detached.</p>', 'EnterStandbyQuery$ShouldDecrementDesiredCapacity' => '<p>Specifies whether the instances moved to <code>Standby</code> mode count as part of the Auto Scaling group\'s desired capacity. If set, the desired capacity for the Auto Scaling group decrements by the number of instances moved to <code>Standby</code> mode.</p>', 'TerminateInstanceInAutoScalingGroupType$ShouldDecrementDesiredCapacity' => '<p>If <code>true</code>, terminating the instance also decrements the size of the Auto Scaling group.</p>', ], ], 'ShouldRespectGracePeriod' => [ 'base' => NULL, 'refs' => [ 'SetInstanceHealthQuery$ShouldRespectGracePeriod' => '<p>If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code> specified for the group, by default, this call will respect the grace period. Set this to <code>False</code>, if you do not want the call to respect the grace period associated with the group.</p> <p>For more information, see the description of the health check grace period for <a>CreateAutoScalingGroup</a>.</p>', ], ], 'SpotPrice' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$SpotPrice' => '<p>The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are launched when the price you specify exceeds the current Spot market price. For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/US-SpotInstances.html">Launching Spot Instances in Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.</p>', 'LaunchConfiguration$SpotPrice' => '<p>The price to bid when launching Spot Instances.</p>', ], ], 'StepAdjustment' => [ 'base' => '<p>Describes an adjustment based on the difference between the value of the aggregated CloudWatch metric and the breach threshold that you\'ve defined for the alarm.</p> <p>For the following examples, suppose that you have an alarm with a breach threshold of 50:</p> <ul> <li> <p>If you want the adjustment to be triggered when the metric is greater than or equal to 50 and less than 60, specify a lower bound of 0 and an upper bound of 10.</p> </li> <li> <p>If you want the adjustment to be triggered when the metric is greater than 40 and less than or equal to 50, specify a lower bound of -10 and an upper bound of 0.</p> </li> </ul> <p>There are a few rules for the step adjustments for your step policy:</p> <ul> <li> <p>The ranges of your step adjustments can\'t overlap or have a gap.</p> </li> <li> <p>At most one step adjustment can have a null lower bound. If one step adjustment has a negative lower bound, then there must be a step adjustment with a null lower bound.</p> </li> <li> <p>At most one step adjustment can have a null upper bound. If one step adjustment has a positive upper bound, then there must be a step adjustment with a null upper bound.</p> </li> <li> <p>The upper and lower bound can\'t be null in the same step adjustment.</p> </li> </ul>', 'refs' => [ 'StepAdjustments$member' => NULL, ], ], 'StepAdjustments' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyType$StepAdjustments' => '<p>A set of adjustments that enable you to scale based on the size of the alarm breach.</p> <p>This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.</p>', 'ScalingPolicy$StepAdjustments' => '<p>A set of adjustments that enable you to scale based on the size of the alarm breach.</p>', ], ], 'SuspendedProcess' => [ 'base' => '<p>Describes an Auto Scaling process that has been suspended. For more information, see <a>ProcessType</a>.</p>', 'refs' => [ 'SuspendedProcesses$member' => NULL, ], ], 'SuspendedProcesses' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$SuspendedProcesses' => '<p>The suspended processes associated with the group.</p>', ], ], 'Tag' => [ 'base' => '<p>Describes a tag for an Auto Scaling group.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagDescription' => [ 'base' => '<p>Describes a tag for an Auto Scaling group.</p>', 'refs' => [ 'TagDescriptionList$member' => NULL, ], ], 'TagDescriptionList' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$Tags' => '<p>The tags for the group.</p>', 'TagsType$Tags' => '<p>One or more tags.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag key.</p>', 'TagDescription$Key' => '<p>The tag key.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag value.</p>', 'TagDescription$Value' => '<p>The tag value.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateAutoScalingGroupType$Tags' => '<p>One or more tags.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/autoscaling-tagging.html">Tagging Auto Scaling Groups and Instances</a> in the <i>Auto Scaling User Guide</i>.</p>', 'CreateOrUpdateTagsType$Tags' => '<p>One or more tags.</p>', 'DeleteTagsType$Tags' => '<p>One or more tags.</p>', ], ], 'TagsType' => [ 'base' => '<p>Contains the output of DescribeTags.</p>', 'refs' => [], ], 'TargetGroupARNs' => [ 'base' => NULL, 'refs' => [ 'AttachLoadBalancerTargetGroupsType$TargetGroupARNs' => '<p>The Amazon Resource Names (ARN) of the target groups.</p>', 'AutoScalingGroup$TargetGroupARNs' => '<p>The Amazon Resource Names (ARN) of the target groups for your load balancer.</p>', 'CreateAutoScalingGroupType$TargetGroupARNs' => '<p>The Amazon Resource Names (ARN) of the target groups.</p>', 'DetachLoadBalancerTargetGroupsType$TargetGroupARNs' => '<p>The Amazon Resource Names (ARN) of the target groups.</p>', ], ], 'TargetTrackingConfiguration' => [ 'base' => '<p>Represents a target tracking policy configuration.</p>', 'refs' => [ 'PutScalingPolicyType$TargetTrackingConfiguration' => '<p>The configuration of a target tracking policy.</p> <p>This parameter is required if the policy type is <code>TargetTrackingScaling</code> and not supported otherwise.</p>', 'ScalingPolicy$TargetTrackingConfiguration' => '<p>A target tracking policy.</p>', ], ], 'TerminateInstanceInAutoScalingGroupType' => [ 'base' => '<p>Contains the parameters for TerminateInstanceInAutoScalingGroup.</p>', 'refs' => [], ], 'TerminationPolicies' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$TerminationPolicies' => '<p>The termination policies for the group.</p>', 'CreateAutoScalingGroupType$TerminationPolicies' => '<p>One or more termination policies used to select the instance to terminate. These policies are executed in the order that they are listed.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html">Controlling Which Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User Guide</i>.</p>', 'DescribeTerminationPolicyTypesAnswer$TerminationPolicyTypes' => '<p>The termination policies supported by Auto Scaling (<code>OldestInstance</code>, <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>, and <code>Default</code>).</p>', 'UpdateAutoScalingGroupType$TerminationPolicies' => '<p>A standalone termination policy or a list of termination policies used to select the instance to terminate. The policies are executed in the order that they are listed.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html">Controlling Which Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User Guide</i>.</p>', ], ], 'TimestampType' => [ 'base' => NULL, 'refs' => [ 'Activity$StartTime' => '<p>The start time of the activity.</p>', 'Activity$EndTime' => '<p>The end time of the activity.</p>', 'AutoScalingGroup$CreatedTime' => '<p>The date and time the group was created.</p>', 'DescribeScheduledActionsType$StartTime' => '<p>The earliest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.</p>', 'DescribeScheduledActionsType$EndTime' => '<p>The latest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.</p>', 'LaunchConfiguration$CreatedTime' => '<p>The creation date and time for the launch configuration.</p>', 'PutScheduledUpdateGroupActionType$Time' => '<p>This parameter is deprecated.</p>', 'PutScheduledUpdateGroupActionType$StartTime' => '<p>The time for this action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT only (for example, <code>2014-06-01T00:00:00Z</code>).</p> <p>If you specify <code>Recurrence</code> and <code>StartTime</code>, Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.</p> <p>If you try to schedule your action in the past, Auto Scaling returns an error message.</p>', 'PutScheduledUpdateGroupActionType$EndTime' => '<p>The time for the recurring schedule to end. Auto Scaling does not perform the action after this time.</p>', 'ScheduledUpdateGroupAction$Time' => '<p>This parameter is deprecated.</p>', 'ScheduledUpdateGroupAction$StartTime' => '<p>The date and time that the action is scheduled to begin. This date and time can be up to one month in the future.</p> <p>When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they form the boundaries of when the recurring action will start and stop.</p>', 'ScheduledUpdateGroupAction$EndTime' => '<p>The date and time that the action is scheduled to end. This date and time can be up to one month in the future.</p>', ], ], 'UpdateAutoScalingGroupType' => [ 'base' => '<p>Contains the parameters for UpdateAutoScalingGroup.</p>', 'refs' => [], ], 'Values' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>The value of the filter.</p>', ], ], 'XmlString' => [ 'base' => NULL, 'refs' => [ 'ActivitiesType$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'Activity$ActivityId' => '<p>The ID of the activity.</p>', 'Activity$Description' => '<p>A friendly, more verbose description of the activity.</p>', 'Activity$Details' => '<p>The details about the activity.</p>', 'ActivityIds$member' => NULL, 'AutoScalingGroupNamesType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'AutoScalingGroupsType$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'AutoScalingInstancesType$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeAutoScalingInstancesType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeLoadBalancerTargetGroupsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeLoadBalancerTargetGroupsResponse$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeLoadBalancersRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeLoadBalancersResponse$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeNotificationConfigurationsAnswer$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeNotificationConfigurationsType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribePoliciesType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeScalingActivitiesType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeScheduledActionsType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeTagsType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'Filter$Name' => '<p>The name of the filter. The valid values are: <code>"auto-scaling-group"</code>, <code>"key"</code>, <code>"value"</code>, and <code>"propagate-at-launch"</code>.</p>', 'LaunchConfigurationNamesType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'LaunchConfigurationsType$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'PoliciesType$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'ScheduledActionsType$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'SecurityGroups$member' => NULL, 'Tag$ResourceId' => '<p>The name of the group.</p>', 'Tag$ResourceType' => '<p>The type of resource. The only supported value is <code>auto-scaling-group</code>.</p>', 'TagDescription$ResourceId' => '<p>The name of the group.</p>', 'TagDescription$ResourceType' => '<p>The type of resource. The only supported value is <code>auto-scaling-group</code>.</p>', 'TagsType$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'Values$member' => NULL, ], ], 'XmlStringMaxLen1023' => [ 'base' => NULL, 'refs' => [ 'Activity$Cause' => '<p>The reason the activity began.</p>', 'LifecycleHook$NotificationMetadata' => '<p>Additional information that you want to include any time Auto Scaling sends a message to the notification target.</p>', 'PredefinedMetricSpecification$ResourceLabel' => '<p>Identifies the resource associated with the metric type. For predefined metric types <code>ASGAverageCPUUtilization</code>, <code>ASGAverageNetworkIn</code> and <code>ASGAverageNetworkOut</code>, the parameter must not be specified as the resource associated with the metric type is the Auto Scaling group. For predefined metric type <code>ALBRequestCountPerTarget</code>, the parameter must be specified in the format <code>app/<i>load-balancer-name</i>/<i>load-balancer-id</i>/targetgroup/<i>target-group-name</i>/<i>target-group-id</i> </code>, where <code>app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> is the final portion of the load balancer ARN, and <code>targetgroup/<i>target-group-name</i>/<i>target-group-id</i> </code> is the final portion of the target group ARN. The target group must be attached to the Auto Scaling group.</p>', 'PutLifecycleHookType$NotificationMetadata' => '<p>Contains additional information that you want to include any time Auto Scaling sends a message to the notification target.</p>', ], ], 'XmlStringMaxLen1600' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$IamInstanceProfile' => '<p>The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance.</p> <p>EC2 instances launched with an IAM role will automatically have AWS security credentials available. You can use IAM roles with Auto Scaling to automatically enable applications running on your EC2 instances to securely access other AWS resources. For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/us-iam-role.html">Launch Auto Scaling Instances with an IAM Role</a> in the <i>Auto Scaling User Guide</i>.</p>', 'LaunchConfiguration$IamInstanceProfile' => '<p>The name or Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance.</p>', 'TerminationPolicies$member' => NULL, ], ], 'XmlStringMaxLen19' => [ 'base' => NULL, 'refs' => [ 'AutoScalingInstanceDetails$InstanceId' => '<p>The ID of the instance.</p>', 'CompleteLifecycleActionType$InstanceId' => '<p>The ID of the instance.</p>', 'CreateAutoScalingGroupType$InstanceId' => '<p>The ID of the instance used to create a launch configuration for the group. Alternatively, specify a launch configuration instead of an EC2 instance.</p> <p>When you specify an ID of an instance, Auto Scaling creates a new launch configuration and associates it with the group. This launch configuration derives its attributes from the specified instance, with the exception of the block device mapping.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-asg-from-instance.html">Create an Auto Scaling Group Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.</p>', 'CreateLaunchConfigurationType$InstanceId' => '<p>The ID of the instance to use to create the launch configuration.</p> <p>The new launch configuration derives attributes from the instance, with the exception of the block device mapping.</p> <p>To create a launch configuration with a block device mapping or override any other instance attributes, specify them as part of the same request.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-lc-with-instanceID.html">Create a Launch Configuration Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.</p>', 'Instance$InstanceId' => '<p>The ID of the instance.</p>', 'InstanceIds$member' => NULL, 'RecordLifecycleActionHeartbeatType$InstanceId' => '<p>The ID of the instance.</p>', 'SetInstanceHealthQuery$InstanceId' => '<p>The ID of the instance.</p>', 'TerminateInstanceInAutoScalingGroupType$InstanceId' => '<p>The ID of the instance.</p>', ], ], 'XmlStringMaxLen2047' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$VPCZoneIdentifier' => '<p>One or more subnet IDs, if applicable, separated by commas.</p> <p>If you specify <code>VPCZoneIdentifier</code> and <code>AvailabilityZones</code>, ensure that the Availability Zones of the subnets match the values for <code>AvailabilityZones</code>.</p>', 'CreateAutoScalingGroupType$VPCZoneIdentifier' => '<p>A comma-separated list of subnet identifiers for your virtual private cloud (VPC).</p> <p>If you specify subnets and Availability Zones with this call, ensure that the subnets\' Availability Zones match the Availability Zones specified.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.</p>', 'UpdateAutoScalingGroupType$VPCZoneIdentifier' => '<p>The ID of the subnet, if you are launching into a VPC. You can specify several subnets in a comma-separated list.</p> <p>When you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, ensure that the subnets\' Availability Zones match the values you specify for <code>AvailabilityZones</code>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.</p>', ], ], 'XmlStringMaxLen255' => [ 'base' => NULL, 'refs' => [ 'Activity$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'Activity$StatusMessage' => '<p>A friendly, more verbose description of the activity status.</p>', 'AdjustmentType$AdjustmentType' => '<p>The policy adjustment type. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>', 'Alarm$AlarmName' => '<p>The name of the alarm.</p>', 'AlreadyExistsFault$message' => '<p/>', 'AutoScalingGroup$AutoScalingGroupName' => '<p>The name of the group.</p>', 'AutoScalingGroup$LaunchConfigurationName' => '<p>The name of the associated launch configuration.</p>', 'AutoScalingGroup$PlacementGroup' => '<p>The name of the placement group into which you\'ll launch your instances, if any. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'AutoScalingGroup$Status' => '<p>The current state of the group when <a>DeleteAutoScalingGroup</a> is in progress.</p>', 'AutoScalingInstanceDetails$AutoScalingGroupName' => '<p>The name of the Auto Scaling group associated with the instance.</p>', 'AutoScalingInstanceDetails$AvailabilityZone' => '<p>The Availability Zone for the instance.</p>', 'AutoScalingInstanceDetails$LaunchConfigurationName' => '<p>The launch configuration used to launch the instance. This value is not available if you attached the instance to the Auto Scaling group.</p>', 'AutoScalingNotificationTypes$member' => NULL, 'AvailabilityZones$member' => NULL, 'BlockDeviceMapping$VirtualName' => '<p>The name of the virtual device (for example, <code>ephemeral0</code>).</p>', 'BlockDeviceMapping$DeviceName' => '<p>The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>', 'ClassicLinkVPCSecurityGroups$member' => NULL, 'CreateAutoScalingGroupType$AutoScalingGroupName' => '<p>The name of the group. This name must be unique within the scope of your AWS account.</p>', 'CreateAutoScalingGroupType$PlacementGroup' => '<p>The name of the placement group into which you\'ll launch your instances, if any. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateLaunchConfigurationType$LaunchConfigurationName' => '<p>The name of the launch configuration. This name must be unique within the scope of your AWS account.</p>', 'CreateLaunchConfigurationType$ImageId' => '<p>The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateLaunchConfigurationType$KeyName' => '<p>The name of the key pair. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateLaunchConfigurationType$ClassicLinkVPCId' => '<p>The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter is supported only if you are launching EC2-Classic instances. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateLaunchConfigurationType$InstanceType' => '<p>The instance type of the EC2 instance. For information about available instance types, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"> Available Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i> </p>', 'CreateLaunchConfigurationType$KernelId' => '<p>The ID of the kernel associated with the AMI.</p>', 'CreateLaunchConfigurationType$RamdiskId' => '<p>The ID of the RAM disk associated with the AMI.</p>', 'Ebs$SnapshotId' => '<p>The ID of the snapshot.</p>', 'EnableMetricsCollectionQuery$Granularity' => '<p>The granularity to associate with the metrics to collect. The only valid value is <code>1Minute</code>.</p>', 'EnabledMetric$Metric' => '<p>One of the following metrics:</p> <ul> <li> <p> <code>GroupMinSize</code> </p> </li> <li> <p> <code>GroupMaxSize</code> </p> </li> <li> <p> <code>GroupDesiredCapacity</code> </p> </li> <li> <p> <code>GroupInServiceInstances</code> </p> </li> <li> <p> <code>GroupPendingInstances</code> </p> </li> <li> <p> <code>GroupStandbyInstances</code> </p> </li> <li> <p> <code>GroupTerminatingInstances</code> </p> </li> <li> <p> <code>GroupTotalInstances</code> </p> </li> </ul>', 'EnabledMetric$Granularity' => '<p>The granularity of the metric. The only valid value is <code>1Minute</code>.</p>', 'Instance$AvailabilityZone' => '<p>The Availability Zone in which the instance is running.</p>', 'Instance$LaunchConfigurationName' => '<p>The launch configuration associated with the instance.</p>', 'InvalidNextToken$message' => '<p/>', 'LaunchConfiguration$LaunchConfigurationName' => '<p>The name of the launch configuration.</p>', 'LaunchConfiguration$ImageId' => '<p>The ID of the Amazon Machine Image (AMI).</p>', 'LaunchConfiguration$KeyName' => '<p>The name of the key pair.</p>', 'LaunchConfiguration$ClassicLinkVPCId' => '<p>The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter can only be used if you are launching EC2-Classic instances. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'LaunchConfiguration$InstanceType' => '<p>The instance type for the instances.</p>', 'LaunchConfiguration$KernelId' => '<p>The ID of the kernel associated with the AMI.</p>', 'LaunchConfiguration$RamdiskId' => '<p>The ID of the RAM disk associated with the AMI.</p>', 'LimitExceededFault$message' => '<p/>', 'LoadBalancerNames$member' => NULL, 'LoadBalancerState$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'LoadBalancerState$State' => '<p>One of the following load balancer states:</p> <ul> <li> <p> <code>Adding</code> - The instances in the group are being registered with the load balancer.</p> </li> <li> <p> <code>Added</code> - All instances in the group are registered with the load balancer.</p> </li> <li> <p> <code>InService</code> - At least one instance in the group passed an ELB health check.</p> </li> <li> <p> <code>Removing</code> - The instances in the group are being deregistered from the load balancer. If connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before deregistering the instances.</p> </li> <li> <p> <code>Removed</code> - All instances in the group are deregistered from the load balancer.</p> </li> </ul>', 'LoadBalancerTargetGroupState$State' => '<p>The state of the target group.</p> <ul> <li> <p> <code>Adding</code> - The Auto Scaling instances are being registered with the target group.</p> </li> <li> <p> <code>Added</code> - All Auto Scaling instances are registered with the target group.</p> </li> <li> <p> <code>InService</code> - At least one Auto Scaling instance passed an ELB health check.</p> </li> <li> <p> <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before deregistering the instances.</p> </li> <li> <p> <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.</p> </li> </ul>', 'MetricCollectionType$Metric' => '<p>One of the following metrics:</p> <ul> <li> <p> <code>GroupMinSize</code> </p> </li> <li> <p> <code>GroupMaxSize</code> </p> </li> <li> <p> <code>GroupDesiredCapacity</code> </p> </li> <li> <p> <code>GroupInServiceInstances</code> </p> </li> <li> <p> <code>GroupPendingInstances</code> </p> </li> <li> <p> <code>GroupStandbyInstances</code> </p> </li> <li> <p> <code>GroupTerminatingInstances</code> </p> </li> <li> <p> <code>GroupTotalInstances</code> </p> </li> </ul>', 'MetricGranularityType$Granularity' => '<p>The granularity. The only valid value is <code>1Minute</code>.</p>', 'Metrics$member' => NULL, 'NotificationConfiguration$NotificationType' => '<p>One of the following event notification types:</p> <ul> <li> <p> <code>autoscaling:EC2_INSTANCE_LAUNCH</code> </p> </li> <li> <p> <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code> </p> </li> <li> <p> <code>autoscaling:EC2_INSTANCE_TERMINATE</code> </p> </li> <li> <p> <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code> </p> </li> <li> <p> <code>autoscaling:TEST_NOTIFICATION</code> </p> </li> </ul>', 'ProcessNames$member' => NULL, 'ProcessType$ProcessName' => '<p>One of the following processes:</p> <ul> <li> <p> <code>Launch</code> </p> </li> <li> <p> <code>Terminate</code> </p> </li> <li> <p> <code>AddToLoadBalancer</code> </p> </li> <li> <p> <code>AlarmNotification</code> </p> </li> <li> <p> <code>AZRebalance</code> </p> </li> <li> <p> <code>HealthCheck</code> </p> </li> <li> <p> <code>ReplaceUnhealthy</code> </p> </li> <li> <p> <code>ScheduledActions</code> </p> </li> </ul>', 'PutScalingPolicyType$PolicyName' => '<p>The name of the policy.</p>', 'PutScalingPolicyType$AdjustmentType' => '<p>The adjustment type. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p> <p>This parameter is supported if the policy type is <code>SimpleScaling</code> or <code>StepScaling</code>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-scale-based-on-demand.html">Dynamic Scaling</a> in the <i>Auto Scaling User Guide</i>.</p>', 'PutScheduledUpdateGroupActionType$ScheduledActionName' => '<p>The name of this scaling action.</p>', 'PutScheduledUpdateGroupActionType$Recurrence' => '<p>The recurring schedule for this action, in Unix cron syntax format. For more information, see <a href="http://en.wikipedia.org/wiki/Cron">Cron</a> in Wikipedia.</p>', 'ResourceContentionFault$message' => '<p/>', 'ResourceInUseFault$message' => '<p/>', 'ScalingActivityInProgressFault$message' => '<p/>', 'ScalingPolicy$AutoScalingGroupName' => '<p>The name of the Auto Scaling group associated with this scaling policy.</p>', 'ScalingPolicy$PolicyName' => '<p>The name of the scaling policy.</p>', 'ScalingPolicy$AdjustmentType' => '<p>The adjustment type, which specifies how <code>ScalingAdjustment</code> is interpreted. Valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>', 'ScheduledUpdateGroupAction$AutoScalingGroupName' => '<p>The name of the group.</p>', 'ScheduledUpdateGroupAction$ScheduledActionName' => '<p>The name of the scheduled action.</p>', 'ScheduledUpdateGroupAction$Recurrence' => '<p>The recurring schedule for the action.</p>', 'SuspendedProcess$ProcessName' => '<p>The name of the suspended process.</p>', 'SuspendedProcess$SuspensionReason' => '<p>The reason that the process was suspended.</p>', 'UpdateAutoScalingGroupType$PlacementGroup' => '<p>The name of the placement group into which you\'ll launch your instances, if any. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'XmlStringMaxLen32' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$HealthCheckType' => '<p>The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.</p>', 'AutoScalingInstanceDetails$LifecycleState' => '<p>The lifecycle state for the instance. For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroupLifecycle.html">Auto Scaling Lifecycle</a> in the <i>Auto Scaling User Guide</i>.</p>', 'AutoScalingInstanceDetails$HealthStatus' => '<p>The last reported health status of this instance. "Healthy" means that the instance is healthy and should remain in service. "Unhealthy" means that the instance is unhealthy and Auto Scaling should terminate and replace it.</p>', 'CreateAutoScalingGroupType$HealthCheckType' => '<p>The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.</p> <p>By default, health checks use Amazon EC2 instance status checks to determine the health of an instance. For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in the <i>Auto Scaling User Guide</i>.</p>', 'Instance$HealthStatus' => '<p>The last reported health status of the instance. "Healthy" means that the instance is healthy and should remain in service. "Unhealthy" means that the instance is unhealthy and Auto Scaling should terminate and replace it.</p>', 'PutScalingPolicyType$MetricAggregationType' => '<p>The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.</p> <p>This parameter is supported if the policy type is <code>StepScaling</code>.</p>', 'ScalingPolicy$MetricAggregationType' => '<p>The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code>.</p>', 'SetInstanceHealthQuery$HealthStatus' => '<p>The health status of the instance. Set to <code>Healthy</code> if you want the instance to remain in service. Set to <code>Unhealthy</code> if you want the instance to be out of service. Auto Scaling will terminate and replace the unhealthy instance.</p>', 'UpdateAutoScalingGroupType$HealthCheckType' => '<p>The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.</p>', ], ], 'XmlStringMaxLen511' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerTargetGroupState$LoadBalancerTargetGroupARN' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'TargetGroupARNs$member' => NULL, ], ], 'XmlStringMaxLen64' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$PlacementTenancy' => '<p>The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware and can only be launched into a VPC.</p> <p>You must set the value of this parameter to <code>dedicated</code> if want to launch Dedicated Instances into a shared tenancy VPC (VPC with instance placement tenancy attribute set to <code>default</code>).</p> <p>If you specify this parameter, be sure to specify at least one subnet when you create your group.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.</p> <p>Valid values: <code>default</code> | <code>dedicated</code> </p>', 'LaunchConfiguration$PlacementTenancy' => '<p>The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with <code>dedicated</code> tenancy runs in an isolated, single-tenant hardware and can only be launched into a VPC.</p>', 'PolicyTypes$member' => NULL, 'PutScalingPolicyType$PolicyType' => '<p>The policy type. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, and <code>TargetTrackingScaling</code>. If the policy type is null, the value is treated as <code>SimpleScaling</code>.</p>', 'ScalingPolicy$PolicyType' => '<p>The policy type. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>.</p>', ], ], 'XmlStringUserData' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$UserData' => '<p>The user data to make available to the launched EC2 instances. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'LaunchConfiguration$UserData' => '<p>The user data available to the instances.</p>', ], ], ],];
