<?php
// This file was auto-generated from sdk-root/src/data/batch/2016-08-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS Batch enables you to run batch computing workloads on the AWS Cloud. Batch computing is a common way for developers, scientists, and engineers to access large amounts of compute resources, and AWS Batch removes the undifferentiated heavy lifting of configuring and managing the required infrastructure. AWS Batch will be familiar to users of traditional batch computing software. This service can efficiently provision resources in response to jobs submitted in order to eliminate capacity constraints, reduce compute costs, and deliver results quickly.</p> <p>As a fully managed service, AWS Batch enables developers, scientists, and engineers to run batch computing workloads of any scale. AWS Batch automatically provisions compute resources and optimizes the workload distribution based on the quantity and scale of the workloads. With AWS Batch, there is no need to install or manage batch computing software, which allows you to focus on analyzing results and solving problems. AWS Batch reduces operational complexities, saves time, and reduces costs, which makes it easy for developers, scientists, and engineers to run their batch jobs in the AWS Cloud.</p>', 'operations' => [ 'CancelJob' => '<p>Cancels jobs in an AWS Batch job queue. Jobs that are in the <code>SUBMITTED</code>, <code>PENDING</code>, or <code>RUNNABLE</code> state are cancelled. Jobs that have progressed to <code>STARTING</code> or <code>RUNNING</code> are not cancelled (but the API operation still succeeds, even if no jobs are cancelled); these jobs must be terminated with the <a>TerminateJob</a> operation.</p>', 'CreateComputeEnvironment' => '<p>Creates an AWS Batch compute environment. You can create <code>MANAGED</code> or <code>UNMANAGED</code> compute environments.</p> <p>In a managed compute environment, AWS Batch manages the compute resources within the environment, based on the compute resources that you specify. Instances launched into a managed compute environment use the latest Amazon ECS-optimized AMI. You can choose to use Amazon EC2 On-Demand instances in your managed compute environment, or you can use Amazon EC2 Spot instances that only launch when the Spot bid price is below a specified percentage of the On-Demand price.</p> <p>In an unmanaged compute environment, you can manage your own compute resources. This provides more compute resource configuration options, such as using a custom AMI, but you must ensure that your AMI meets the Amazon ECS container instance AMI specification. For more information, see <a href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/container_instance_AMIs.html">Container Instance AMIs</a> in the <i>Amazon EC2 Container Service Developer Guide</i>. After you have created your unmanaged compute environment, you can use the <a>DescribeComputeEnvironments</a> operation to find the Amazon ECS cluster that is associated with it and then manually launch your container instances into that Amazon ECS cluster. For more information, see <a href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_container_instance.html">Launching an Amazon ECS Container Instance</a> in the <i>Amazon EC2 Container Service Developer Guide</i>.</p>', 'CreateJobQueue' => '<p>Creates an AWS Batch job queue. When you create a job queue, you associate one or more compute environments to the queue and assign an order of preference for the compute environments.</p> <p>You also set a priority to the job queue that determines the order in which the AWS Batch scheduler places jobs onto its associated compute environments. For example, if a compute environment is associated with more than one job queue, the job queue with a higher priority is given preference for scheduling jobs to that compute environment.</p>', 'DeleteComputeEnvironment' => '<p>Deletes an AWS Batch compute environment.</p> <p>Before you can delete a compute environment, you must set its state to <code>DISABLED</code> with the <a>UpdateComputeEnvironment</a> API operation and disassociate it from any job queues with the <a>UpdateJobQueue</a> API operation.</p>', 'DeleteJobQueue' => '<p>Deletes the specified job queue. You must first disable submissions for a queue with the <a>UpdateJobQueue</a> operation and terminate any jobs that have not completed with the <a>TerminateJob</a>.</p> <p>It is not necessary to disassociate compute environments from a queue before submitting a <code>DeleteJobQueue</code> request. </p>', 'DeregisterJobDefinition' => '<p>Deregisters an AWS Batch job definition.</p>', 'DescribeComputeEnvironments' => '<p>Describes one or more of your compute environments.</p> <p>If you are using an unmanaged compute environment, you can use the <code>DescribeComputeEnvironment</code> operation to determine the <code>ecsClusterArn</code> that you should launch your Amazon ECS container instances into.</p>', 'DescribeJobDefinitions' => '<p>Describes a list of job definitions. You can specify a <code>status</code> (such as <code>ACTIVE</code>) to only return job definitions that match that status.</p>', 'DescribeJobQueues' => '<p>Describes one or more of your job queues.</p>', 'DescribeJobs' => '<p>Describes a list of AWS Batch jobs.</p>', 'ListJobs' => '<p>Returns a list of task jobs for a specified job queue. You can filter the results by job status with the <code>jobStatus</code> parameter.</p>', 'RegisterJobDefinition' => '<p>Registers an AWS Batch job definition. </p>', 'SubmitJob' => '<p>Submits an AWS Batch job from a job definition. Parameters specified during <a>SubmitJob</a> override parameters defined in the job definition. </p>', 'TerminateJob' => '<p>Terminates jobs in a job queue. Jobs that are in the <code>STARTING</code> or <code>RUNNING</code> state are terminated, which causes them to transition to <code>FAILED</code>. Jobs that have not progressed to the <code>STARTING</code> state are cancelled.</p>', 'UpdateComputeEnvironment' => '<p>Updates an AWS Batch compute environment.</p>', 'UpdateJobQueue' => '<p>Updates a job queue.</p>', ], 'shapes' => [ 'AttemptContainerDetail' => [ 'base' => '<p>An object representing the details of a container that is part of a job attempt.</p>', 'refs' => [ 'AttemptDetail$container' => '<p>Details about the container in this job attempt.</p>', ], ], 'AttemptDetail' => [ 'base' => '<p>An object representing a job attempt.</p>', 'refs' => [ 'AttemptDetails$member' => NULL, ], ], 'AttemptDetails' => [ 'base' => NULL, 'refs' => [ 'JobDetail$attempts' => '<p>A list of job attempts associated with this job.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ContainerDetail$readonlyRootFilesystem' => '<p>When this parameter is true, the container is given read-only access to its root file system.</p>', 'ContainerDetail$privileged' => '<p>When this parameter is true, the container is given elevated privileges on the host container instance (similar to the <code>root</code> user).</p>', 'ContainerProperties$readonlyRootFilesystem' => '<p>When this parameter is true, the container is given read-only access to its root file system. This parameter maps to <code>ReadonlyRootfs</code> in the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/">Docker Remote API</a> and the <code>--read-only</code> option to <code>docker run</code>.</p>', 'ContainerProperties$privileged' => '<p>When this parameter is true, the container is given elevated privileges on the host container instance (similar to the <code>root</code> user). This parameter maps to <code>Privileged</code> in the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>', 'MountPoint$readOnly' => '<p>If this value is <code>true</code>, the container has read-only access to the volume; otherwise, the container can write to the volume. The default value is <code>false</code>.</p>', ], ], 'CEState' => [ 'base' => NULL, 'refs' => [ 'ComputeEnvironmentDetail$state' => '<p>The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>. An <code>ENABLED</code> state indicates that you can register instances with the compute environment and that the associated instances can accept jobs. </p>', 'CreateComputeEnvironmentRequest$state' => '<p>The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment accepts jobs from a queue and can scale out automatically based on queues.</p>', 'UpdateComputeEnvironmentRequest$state' => '<p>The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs from a queue and scale in or out automatically based on the workload demand of its associated queues.</p>', ], ], 'CEStatus' => [ 'base' => NULL, 'refs' => [ 'ComputeEnvironmentDetail$status' => '<p>The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).</p>', ], ], 'CEType' => [ 'base' => NULL, 'refs' => [ 'ComputeEnvironmentDetail$type' => '<p>The type of the compute environment.</p>', 'CreateComputeEnvironmentRequest$type' => '<p>The type of the compute environment. </p>', ], ], 'CRType' => [ 'base' => NULL, 'refs' => [ 'ComputeResource$type' => '<p>The type of compute environment.</p>', ], ], 'CancelJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'ClientException' => [ 'base' => '<p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that doesn\'t have permission to use the action or resource, or specifying an identifier that is not valid. </p>', 'refs' => [], ], 'ComputeEnvironmentDetail' => [ 'base' => '<p>An object representing an AWS Batch compute environment.</p>', 'refs' => [ 'ComputeEnvironmentDetailList$member' => NULL, ], ], 'ComputeEnvironmentDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeComputeEnvironmentsResponse$computeEnvironments' => '<p>The list of compute environments.</p>', ], ], 'ComputeEnvironmentOrder' => [ 'base' => '<p>The order in which compute environments are tried for job placement within a queue. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first.</p>', 'refs' => [ 'ComputeEnvironmentOrders$member' => NULL, ], ], 'ComputeEnvironmentOrders' => [ 'base' => NULL, 'refs' => [ 'CreateJobQueueRequest$computeEnvironmentOrder' => '<p>The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment should execute a given job. Compute environments must be in the <code>VALID</code> state before you can associate them with a job queue. You can associate up to 3 compute environments with a job queue.</p>', 'JobQueueDetail$computeEnvironmentOrder' => '<p>The compute environments that are attached to the job queue and the order in which job placement is preferred. Compute environments are selected for job placement in ascending order.</p>', 'UpdateJobQueueRequest$computeEnvironmentOrder' => '<p>Details the set of compute environments mapped to a job queue and their order relative to each other. This is one of the parameters used by the job scheduler to determine which compute environment should execute a given job. </p>', ], ], 'ComputeResource' => [ 'base' => '<p>An object representing an AWS Batch compute resource.</p>', 'refs' => [ 'ComputeEnvironmentDetail$computeResources' => '<p>The compute resources defined for the compute environment. </p>', 'CreateComputeEnvironmentRequest$computeResources' => '<p>Details of the compute resources managed by the compute environment. This parameter is required for managed compute environments.</p>', ], ], 'ComputeResourceUpdate' => [ 'base' => '<p>An object representing the attributes of a compute environment that can be updated.</p>', 'refs' => [ 'UpdateComputeEnvironmentRequest$computeResources' => '<p>Details of the compute resources managed by the compute environment. Required for a managed compute environment.</p>', ], ], 'ContainerDetail' => [ 'base' => '<p>An object representing the details of a container that is part of a job.</p>', 'refs' => [ 'JobDetail$container' => '<p>An object representing the details of the container that is associated with the job.</p>', ], ], 'ContainerOverrides' => [ 'base' => '<p>The overrides that should be sent to a container.</p>', 'refs' => [ 'SubmitJobRequest$containerOverrides' => '<p>A list of container overrides in JSON format that specify the name of a container in the specified job definition and the overrides it should receive. You can override the default command for a container (that is specified in the job definition or the Docker image) with a <code>command</code> override. You can also override existing environment variables (that are specified in the job definition or Docker image) on a container or add new environment variables to it with an <code>environment</code> override.</p>', ], ], 'ContainerProperties' => [ 'base' => '<p>Container properties are used in job definitions to describe the container that is launched as part of a job.</p>', 'refs' => [ 'JobDefinition$containerProperties' => '<p>An object with various properties specific to container-based jobs. </p>', 'RegisterJobDefinitionRequest$containerProperties' => '<p>An object with various properties specific for container-based jobs. This parameter is required if the <code>type</code> parameter is <code>container</code>.</p>', ], ], 'CreateComputeEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateComputeEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteComputeEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteComputeEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeComputeEnvironmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeComputeEnvironmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobQueuesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'EnvironmentVariables' => [ 'base' => NULL, 'refs' => [ 'ContainerDetail$environment' => '<p>The environment variables to pass to a container.</p>', 'ContainerOverrides$environment' => '<p>The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the job definition.</p>', 'ContainerProperties$environment' => '<p>The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/">Docker Remote API</a> and the <code>--env</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <important> <p>We do not recommend using plain text environment variables for sensitive information, such as credential data.</p> </important>', ], ], 'Host' => [ 'base' => '<p>The contents of the <code>host</code> parameter determine whether your data volume persists on the host container instance and where it is stored. If the host parameter is empty, then the Docker daemon assigns a host path for your data volume, but the data is not guaranteed to persist after the containers associated with it stop running.</p>', 'refs' => [ 'Volume$host' => '<p>The contents of the <code>host</code> parameter determine whether your data volume persists on the host container instance and where it is stored. If the host parameter is empty, then the Docker daemon assigns a host path for your data volume, but the data is not guaranteed to persist after the containers associated with it stop running.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AttemptContainerDetail$exitCode' => '<p>The exit code for the job attempt. A non-zero exit code is considered a failure.</p>', 'ComputeEnvironmentOrder$order' => '<p>The order of the compute environment.</p>', 'ComputeResource$minvCpus' => '<p>The minimum number of EC2 vCPUs that an environment should maintain. </p>', 'ComputeResource$maxvCpus' => '<p>The maximum number of EC2 vCPUs that an environment can reach. </p>', 'ComputeResource$desiredvCpus' => '<p>The desired number of EC2 vCPUS in the compute environment. </p>', 'ComputeResource$bidPercentage' => '<p>The minimum percentage that a Spot Instance price must be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20%, then the Spot price must be below 20% of the current On-Demand price for that EC2 instance.</p>', 'ComputeResourceUpdate$minvCpus' => '<p>The minimum number of EC2 vCPUs that an environment should maintain.</p>', 'ComputeResourceUpdate$maxvCpus' => '<p>The maximum number of EC2 vCPUs that an environment can reach.</p>', 'ComputeResourceUpdate$desiredvCpus' => '<p>The desired number of EC2 vCPUS in the compute environment.</p>', 'ContainerDetail$vcpus' => '<p>The number of VCPUs allocated for the job. </p>', 'ContainerDetail$memory' => '<p>The number of MiB of memory reserved for the job.</p>', 'ContainerDetail$exitCode' => '<p>The exit code to return upon completion.</p>', 'ContainerOverrides$vcpus' => '<p>The number of vCPUs to reserve for the container. This value overrides the value set in the job definition.</p>', 'ContainerOverrides$memory' => '<p>The number of MiB of memory reserved for the job. This value overrides the value set in the job definition.</p>', 'ContainerProperties$vcpus' => '<p>The number of vCPUs reserved for the container. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. Each vCPU is equivalent to 1,024 CPU shares.</p>', 'ContainerProperties$memory' => '<p>The hard limit (in MiB) of memory to present to the container. If your container attempts to exceed the memory specified here, the container is killed. This parameter maps to <code>Memory</code> in the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>', 'CreateJobQueueRequest$priority' => '<p>The priority of the job queue. Job queues with a higher priority (or a lower integer value for the <code>priority</code> parameter) are evaluated first when associated with same compute environment. Priority is determined in ascending order, for example, a job queue with a priority value of <code>1</code> is given scheduling preference over a job queue with a priority value of <code>10</code>.</p>', 'DescribeComputeEnvironmentsRequest$maxResults' => '<p>The maximum number of cluster results returned by <code>DescribeComputeEnvironments</code> in paginated output. When this parameter is used, <code>DescribeComputeEnvironments</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeComputeEnvironments</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>DescribeComputeEnvironments</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'DescribeJobDefinitionsRequest$maxResults' => '<p>The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output. When this parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeJobDefinitions</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>DescribeJobDefinitions</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'DescribeJobQueuesRequest$maxResults' => '<p>The maximum number of results returned by <code>DescribeJobQueues</code> in paginated output. When this parameter is used, <code>DescribeJobQueues</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeJobQueues</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>DescribeJobQueues</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'JobDefinition$revision' => '<p>The revision of the job definition.</p>', 'JobQueueDetail$priority' => '<p>The priority of the job queue. </p>', 'ListJobsRequest$maxResults' => '<p>The maximum number of results returned by <code>ListJobs</code> in paginated output. When this parameter is used, <code>ListJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'RegisterJobDefinitionResponse$revision' => '<p>The revision of the job definition.</p>', 'RetryStrategy$attempts' => '<p>The number of times to move a job to the <code>RUNNABLE</code> status. You may specify between 1 and 10 attempts. If <code>attempts</code> is greater than one, the job is retried if it fails until it has moved to <code>RUNNABLE</code> that many times.</p>', 'Ulimit$hardLimit' => '<p>The hard limit for the <code>ulimit</code> type.</p>', 'Ulimit$softLimit' => '<p>The soft limit for the <code>ulimit</code> type.</p>', 'UpdateJobQueueRequest$priority' => '<p>The priority of the job queue. Job queues with a higher priority (or a lower integer value for the <code>priority</code> parameter) are evaluated first when associated with same compute environment. Priority is determined in ascending order, for example, a job queue with a priority value of <code>1</code> is given scheduling preference over a job queue with a priority value of <code>10</code>.</p>', ], ], 'JQState' => [ 'base' => NULL, 'refs' => [ 'CreateJobQueueRequest$state' => '<p>The state of the job queue. If the job queue state is <code>ENABLED</code>, it is able to accept jobs.</p>', 'JobQueueDetail$state' => '<p>Describes the ability of the queue to accept new jobs.</p>', 'UpdateJobQueueRequest$state' => '<p>Describes the queue\'s ability to accept new jobs.</p>', ], ], 'JQStatus' => [ 'base' => NULL, 'refs' => [ 'JobQueueDetail$status' => '<p>The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).</p>', ], ], 'JobDefinition' => [ 'base' => '<p>An object representing an AWS Batch job definition.</p>', 'refs' => [ 'JobDefinitionList$member' => NULL, ], ], 'JobDefinitionList' => [ 'base' => NULL, 'refs' => [ 'DescribeJobDefinitionsResponse$jobDefinitions' => '<p>The list of job definitions. </p>', ], ], 'JobDefinitionType' => [ 'base' => NULL, 'refs' => [ 'RegisterJobDefinitionRequest$type' => '<p>The type of job definition.</p>', ], ], 'JobDependency' => [ 'base' => '<p>An object representing an AWS Batch job dependency.</p>', 'refs' => [ 'JobDependencyList$member' => NULL, ], ], 'JobDependencyList' => [ 'base' => NULL, 'refs' => [ 'JobDetail$dependsOn' => '<p>A list of job names or IDs on which this job depends.</p>', 'SubmitJobRequest$dependsOn' => '<p>A list of job IDs on which this job depends. A job can depend upon a maximum of 100 jobs. </p>', ], ], 'JobDetail' => [ 'base' => '<p>An object representing an AWS Batch job.</p>', 'refs' => [ 'JobDetailList$member' => NULL, ], ], 'JobDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeJobsResponse$jobs' => '<p>The list of jobs. </p>', ], ], 'JobQueueDetail' => [ 'base' => '<p>An object representing the details of an AWS Batch job queue.</p>', 'refs' => [ 'JobQueueDetailList$member' => NULL, ], ], 'JobQueueDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeJobQueuesResponse$jobQueues' => '<p>The list of job queues. </p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'JobDetail$status' => '<p>The current status for the job.</p>', 'ListJobsRequest$jobStatus' => '<p>The job status with which to filter jobs in the specified queue.</p>', ], ], 'JobSummary' => [ 'base' => '<p>An object representing summary details of a job.</p>', 'refs' => [ 'JobSummaryList$member' => NULL, ], ], 'JobSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListJobsResponse$jobSummaryList' => '<p>A list of job summaries that match the request.</p>', ], ], 'KeyValuePair' => [ 'base' => '<p>A key-value pair object.</p>', 'refs' => [ 'EnvironmentVariables$member' => NULL, ], ], 'ListJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AttemptDetail$startedAt' => '<p>The Unix timestamp for when the attempt was started (when the task transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state).</p>', 'AttemptDetail$stoppedAt' => '<p>The Unix timestamp for when the attempt was stopped (when the task transitioned from the <code>RUNNING</code> state to the <code>STOPPED</code> state).</p>', 'JobDetail$createdAt' => '<p>The Unix timestamp for when the job was created (when the task entered the <code>PENDING</code> state). </p>', 'JobDetail$startedAt' => '<p>The Unix timestamp for when the job was started (when the task transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state). </p>', 'JobDetail$stoppedAt' => '<p>The Unix timestamp for when the job was stopped (when the task transitioned from the <code>RUNNING</code> state to the <code>STOPPED</code> state).</p>', ], ], 'MountPoint' => [ 'base' => '<p>Details on a Docker volume mount point that is used in a job\'s container properties.</p>', 'refs' => [ 'MountPoints$member' => NULL, ], ], 'MountPoints' => [ 'base' => NULL, 'refs' => [ 'ContainerDetail$mountPoints' => '<p>The mount points for data volumes in your container.</p>', 'ContainerProperties$mountPoints' => '<p>The mount points for data volumes in your container. This parameter maps to <code>Volumes</code> in the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/">Docker Remote API</a> and the <code>--volume</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>', ], ], 'ParametersMap' => [ 'base' => NULL, 'refs' => [ 'JobDefinition$parameters' => '<p>Default parameters or parameter substitution placeholders that are set in the job definition. Parameters are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.</p>', 'JobDetail$parameters' => '<p>Additional parameters passed to the job that replace parameter substitution placeholders or override any corresponding parameter defaults from the job definition. </p>', 'RegisterJobDefinitionRequest$parameters' => '<p>Default parameter substitution placeholders to set in the job definition. Parameters are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.</p>', 'SubmitJobRequest$parameters' => '<p>Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.</p>', ], ], 'RegisterJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'RetryStrategy' => [ 'base' => '<p>The retry strategy associated with a job.</p>', 'refs' => [ 'JobDefinition$retryStrategy' => '<p>The retry strategy to use for failed jobs that are submitted with this job definition.</p>', 'JobDetail$retryStrategy' => '<p>The retry strategy to use for this job if an attempt fails.</p>', 'RegisterJobDefinitionRequest$retryStrategy' => '<p>The retry strategy to use for failed jobs that are submitted with this job definition. Any retry strategy that is specified during a <a>SubmitJob</a> operation overrides the retry strategy defined here.</p>', 'SubmitJobRequest$retryStrategy' => '<p>The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition.</p>', ], ], 'ServerException' => [ 'base' => '<p>These errors are usually caused by a server issue.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AttemptContainerDetail$containerInstanceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts the job attempt.</p>', 'AttemptContainerDetail$taskArn' => '<p>The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the job attempt.</p>', 'AttemptContainerDetail$reason' => '<p>A short (255 max characters) human-readable string to provide additional details about a running or stopped container.</p>', 'AttemptContainerDetail$logStreamName' => NULL, 'AttemptDetail$statusReason' => '<p>A short, human-readable string to provide additional details about the current status of the job attempt.</p>', 'CancelJobRequest$jobId' => '<p>A list of up to 100 job IDs to cancel.</p>', 'CancelJobRequest$reason' => '<p>A message to attach to the job that explains the reason for cancelling it. This message is returned by future <a>DescribeJobs</a> operations on the job. This message is also recorded in the AWS Batch activity logs. </p>', 'ClientException$message' => NULL, 'ComputeEnvironmentDetail$computeEnvironmentName' => '<p>The name of the compute environment. </p>', 'ComputeEnvironmentDetail$computeEnvironmentArn' => '<p>The Amazon Resource Name (ARN) of the compute environment. </p>', 'ComputeEnvironmentDetail$ecsClusterArn' => '<p>The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment. </p>', 'ComputeEnvironmentDetail$statusReason' => '<p>A short, human-readable string to provide additional details about the current status of the compute environment.</p>', 'ComputeEnvironmentDetail$serviceRole' => '<p>The service role associated with the compute environment that allows AWS Batch to make calls to AWS API operations on your behalf.</p>', 'ComputeEnvironmentOrder$computeEnvironment' => '<p>The Amazon Resource Name (ARN) of the compute environment.</p>', 'ComputeResource$imageId' => '<p>The Amazon Machine Image (AMI) ID used for instances launched in the compute environment.</p>', 'ComputeResource$ec2KeyPair' => '<p>The EC2 key pair that is used for instances launched in the compute environment.</p>', 'ComputeResource$instanceRole' => '<p>The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment.</p>', 'ComputeResource$spotIamFleetRole' => '<p>The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a <code>SPOT</code> compute environment.</p>', 'ContainerDetail$image' => '<p>The image used to start the container.</p>', 'ContainerDetail$jobRoleArn' => '<p>The Amazon Resource Name (ARN) associated with the job upon execution. </p>', 'ContainerDetail$user' => '<p>The user name to use inside the container.</p>', 'ContainerDetail$reason' => '<p>A short (255 max characters) human-readable string to provide additional details about a running or stopped container.</p>', 'ContainerDetail$containerInstanceArn' => '<p>The Amazon Resource Name (ARN) of the container instance on which the container is running.</p>', 'ContainerDetail$taskArn' => '<p>The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the container job.</p>', 'ContainerDetail$logStreamName' => NULL, 'ContainerProperties$image' => '<p>The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with <code> <i>repository-url</i>/<i>image</i>:<i>tag</i> </code>. Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to <code>Image</code> in the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/">Docker Remote API</a> and the <code>IMAGE</code> parameter of <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <ul> <li> <p>Images in Amazon ECR repositories use the full registry and repository URI (for example, <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;</code>). </p> </li> <li> <p>Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or <code>mongo</code>).</p> </li> <li> <p>Images in other repositories on Docker Hub are qualified with an organization name (for example, <code>amazon/amazon-ecs-agent</code>).</p> </li> <li> <p>Images in other online repositories are qualified further by a domain name (for example, <code>quay.io/assemblyline/ubuntu</code>).</p> </li> </ul>', 'ContainerProperties$jobRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions.</p>', 'ContainerProperties$user' => '<p>The user name to use inside the container. This parameter maps to <code>User</code> in the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/">Docker Remote API</a> and the <code>--user</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>', 'CreateComputeEnvironmentRequest$computeEnvironmentName' => '<p>The name for your compute environment. Up to 128 letters (uppercase and lowercase), numbers, and underscores are allowed.</p>', 'CreateComputeEnvironmentRequest$serviceRole' => '<p>The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf. </p>', 'CreateComputeEnvironmentResponse$computeEnvironmentName' => '<p>The name of the compute environment.</p>', 'CreateComputeEnvironmentResponse$computeEnvironmentArn' => '<p>The Amazon Resource Name (ARN) of the compute environment. </p>', 'CreateJobQueueRequest$jobQueueName' => '<p>The name of the job queue.</p>', 'CreateJobQueueResponse$jobQueueName' => '<p>The name of the job queue.</p>', 'CreateJobQueueResponse$jobQueueArn' => '<p>The Amazon Resource Name (ARN) of the job queue.</p>', 'DeleteComputeEnvironmentRequest$computeEnvironment' => '<p>The name or Amazon Resource Name (ARN) of the compute environment to delete. </p>', 'DeleteJobQueueRequest$jobQueue' => '<p>The short name or full Amazon Resource Name (ARN) of the queue to delete. </p>', 'DeregisterJobDefinitionRequest$jobDefinition' => '<p>The name and revision (<code>name:revision</code>) or full Amazon Resource Name (ARN) of the job definition to deregister. </p>', 'DescribeComputeEnvironmentsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeComputeEnvironments</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'DescribeComputeEnvironmentsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code> request. When the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeJobDefinitionsRequest$jobDefinitionName' => '<p>The name of the job definition to describe.</p>', 'DescribeJobDefinitionsRequest$status' => '<p>The status with which to filter job definitions.</p>', 'DescribeJobDefinitionsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobDefinitions</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'DescribeJobDefinitionsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request. When the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeJobQueuesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobQueues</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'DescribeJobQueuesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeJobQueues</code> request. When the results of a <code>DescribeJobQueues</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'Host$sourcePath' => '<p>The path on the host container instance that is presented to the container. If this parameter is empty, then the Docker daemon has assigned a host path for you. If the <code>host</code> parameter contains a <code>sourcePath</code> file location, then the data volume persists at the specified location on the host container instance until you delete it manually. If the <code>sourcePath</code> value does not exist on the host container instance, the Docker daemon creates it. If the location does exist, the contents of the source path folder are exported.</p>', 'JobDefinition$jobDefinitionName' => '<p>The name of the job definition. </p>', 'JobDefinition$jobDefinitionArn' => '<p>The Amazon Resource Name (ARN) for the job definition. </p>', 'JobDefinition$status' => '<p>The status of the job definition.</p>', 'JobDefinition$type' => '<p>The type of job definition.</p>', 'JobDependency$jobId' => '<p>The job ID of the AWS Batch job associated with this dependency.</p>', 'JobDetail$jobName' => '<p>The name of the job.</p>', 'JobDetail$jobId' => '<p>The ID for the job.</p>', 'JobDetail$jobQueue' => '<p>The Amazon Resource Name (ARN) of the job queue with which the job is associated.</p>', 'JobDetail$statusReason' => '<p>A short, human-readable string to provide additional details about the current status of the job. </p>', 'JobDetail$jobDefinition' => '<p>The job definition that is used by this job.</p>', 'JobQueueDetail$jobQueueName' => '<p>The name of the job queue.</p>', 'JobQueueDetail$jobQueueArn' => '<p>The Amazon Resource Name (ARN) of the job queue.</p>', 'JobQueueDetail$statusReason' => '<p>A short, human-readable string to provide additional details about the current status of the job queue.</p>', 'JobSummary$jobId' => '<p>The ID of the job.</p>', 'JobSummary$jobName' => '<p>The name of the job.</p>', 'KeyValuePair$name' => '<p>The name of the key value pair. For environment variables, this is the name of the environment variable.</p>', 'KeyValuePair$value' => '<p>The value of the key value pair. For environment variables, this is the value of the environment variable.</p>', 'ListJobsRequest$jobQueue' => '<p>The name or full Amazon Resource Name (ARN) of the job queue with which to list jobs.</p>', 'ListJobsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListJobsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the results of a <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'MountPoint$containerPath' => '<p>The path on the container at which to mount the host volume.</p>', 'MountPoint$sourceVolume' => '<p>The name of the volume to mount.</p>', 'ParametersMap$key' => NULL, 'ParametersMap$value' => NULL, 'RegisterJobDefinitionRequest$jobDefinitionName' => '<p>The name of the job definition to register. </p>', 'RegisterJobDefinitionResponse$jobDefinitionName' => '<p>The name of the job definition. </p>', 'RegisterJobDefinitionResponse$jobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the job definition. </p>', 'ServerException$message' => NULL, 'StringList$member' => NULL, 'SubmitJobRequest$jobName' => '<p>The name of the job. A name must be 1 to 128 characters in length.</p> <p>Pattern: ^[a-zA-Z0-9_]+$</p>', 'SubmitJobRequest$jobQueue' => '<p>The job queue into which the job will be submitted. You can specify either the name or the Amazon Resource Name (ARN) of the queue. </p>', 'SubmitJobRequest$jobDefinition' => '<p>The job definition used by this job. This value can be either a <code>name:revision</code> or the Amazon Resource Name (ARN) for the job definition.</p>', 'SubmitJobResponse$jobName' => '<p>The name of the job. </p>', 'SubmitJobResponse$jobId' => '<p>The unique identifier for the job.</p>', 'TagsMap$key' => NULL, 'TagsMap$value' => NULL, 'TerminateJobRequest$jobId' => '<p>Job IDs to be terminated. Up to 100 jobs can be specified.</p>', 'TerminateJobRequest$reason' => '<p>A message to attach to the job that explains the reason for cancelling it. This message is returned by future <a>DescribeJobs</a> operations on the job. This message is also recorded in the AWS Batch activity logs. </p>', 'Ulimit$name' => '<p>The <code>type</code> of the <code>ulimit</code>.</p>', 'UpdateComputeEnvironmentRequest$computeEnvironment' => '<p>The name or full Amazon Resource Name (ARN) of the compute environment to update.</p>', 'UpdateComputeEnvironmentRequest$serviceRole' => '<p>The name or full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to ECS, Auto Scaling, and EC2 on your behalf.</p>', 'UpdateComputeEnvironmentResponse$computeEnvironmentName' => '<p>The name of compute environment.</p>', 'UpdateComputeEnvironmentResponse$computeEnvironmentArn' => '<p>The Amazon Resource Name (ARN) of the compute environment. </p>', 'UpdateJobQueueRequest$jobQueue' => '<p>The name or the Amazon Resource Name (ARN) of the job queue.</p>', 'UpdateJobQueueResponse$jobQueueName' => '<p>The name of the job queue.</p>', 'UpdateJobQueueResponse$jobQueueArn' => '<p>The Amazon Resource Name (ARN) of the job queue.</p>', 'Volume$name' => '<p>The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed. This name is referenced in the <code>sourceVolume</code> parameter of container definition <code>mountPoints</code>.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'ComputeResource$instanceTypes' => '<p>The instances types that may launched.</p>', 'ComputeResource$subnets' => '<p>The VPC subnets into which the compute resources are launched. </p>', 'ComputeResource$securityGroupIds' => '<p>The EC2 security group that is associated with instances launched in the compute environment. </p>', 'ContainerDetail$command' => '<p>The command that is passed to the container. </p>', 'ContainerOverrides$command' => '<p>The command to send to the container that overrides the default command from the Docker image or the job definition.</p>', 'ContainerProperties$command' => '<p>The command that is passed to the container. This parameter maps to <code>Cmd</code> in the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/">Docker Remote API</a> and the <code>COMMAND</code> parameter to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. For more information, see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>.</p>', 'DescribeComputeEnvironmentsRequest$computeEnvironments' => '<p>A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries. </p>', 'DescribeJobDefinitionsRequest$jobDefinitions' => '<p>A space-separated list of up to 100 job definition names or full Amazon Resource Name (ARN) entries.</p>', 'DescribeJobQueuesRequest$jobQueues' => '<p>A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.</p>', 'DescribeJobsRequest$jobs' => '<p>A space-separated list of up to 100 job IDs.</p>', ], ], 'SubmitJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'SubmitJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagsMap' => [ 'base' => NULL, 'refs' => [ 'ComputeResource$tags' => '<p>Key-value pair tags to be applied to resources that are launched in the compute environment. </p>', ], ], 'TerminateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'TerminateJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'Ulimit' => [ 'base' => '<p>The <code>ulimit</code> settings to pass to the container.</p>', 'refs' => [ 'Ulimits$member' => NULL, ], ], 'Ulimits' => [ 'base' => NULL, 'refs' => [ 'ContainerDetail$ulimits' => '<p>A list of <code>ulimit</code> values to set in the container.</p>', 'ContainerProperties$ulimits' => '<p>A list of <code>ulimits</code> to set in the container. This parameter maps to <code>Ulimits</code> in the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>', ], ], 'UpdateComputeEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComputeEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'Volume' => [ 'base' => '<p>A data volume used in a job\'s container properties.</p>', 'refs' => [ 'Volumes$member' => NULL, ], ], 'Volumes' => [ 'base' => NULL, 'refs' => [ 'ContainerDetail$volumes' => '<p>A list of volumes associated with the job.</p>', 'ContainerProperties$volumes' => '<p>A list of data volumes used in a job.</p>', ], ], ],];
