<?php
// This file was auto-generated from sdk-root/src/data/cloudformation/2010-05-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS CloudFormation</fullname> <p>AWS CloudFormation allows you to create and manage AWS infrastructure deployments predictably and repeatedly. You can use AWS CloudFormation to leverage AWS products, such as Amazon Elastic Compute Cloud, Amazon Elastic Block Store, Amazon Simple Notification Service, Elastic Load Balancing, and Auto Scaling to build highly-reliable, highly scalable, cost-effective applications without creating or configuring the underlying AWS infrastructure.</p> <p>With AWS CloudFormation, you declare all of your resources and dependencies in a template file. The template defines a collection of resources as a single unit called a stack. AWS CloudFormation creates and deletes all member resources of the stack together and manages all dependencies between the resources for you.</p> <p>For more information about AWS CloudFormation, see the <a href="http://aws.amazon.com/cloudformation/">AWS CloudFormation Product Page</a>.</p> <p>Amazon CloudFormation makes use of other AWS products. If you need additional technical information about a specific AWS product, you can find the product\'s technical documentation at <a href="http://docs.aws.amazon.com/">docs.aws.amazon.com</a>.</p> <p> <i>APIs for stacks </i> </p> <p>When you use AWS CloudFormation, you manage related resources as a single unit called a stack. You create, update, and delete a collection of resources by creating, updating, and deleting stacks. All the resources in a stack are defined by the stack\'s AWS CloudFormation template. </p> <p>Actions</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html">CancelUpdateStack</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ContinueUpdateRollback.html">ContinueUpdateRollback</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStack.html">CreateStack</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteStack.html">DeleteStack</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackEvents.html">DescribeStackEvents</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackResource.html">DescribeStackResource</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackResources.html">DescribeStackResources</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStacks.html">DescribeStacks</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_EstimateTemplateCost.html">EstimateTemplateCost</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_GetStackPolicy.html">GetStackPolicy</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_GetTemplate.html">GetTemplate</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_GetTemplateSummary.html">GetTemplateSummary</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListExports.html">ListExports</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListImports.html">ListImports</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackResources.html">ListStackResources</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStacks.html">ListStacks</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetStackPolicy.html">SetStackPolicy</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStack.html">UpdateStack</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ValidateTemplate.html">ValidateTemplate</a> </p> </li> </ul> <p>Data Types</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Export.html">Export</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ParameterConstraints.html">ParameterConstraints</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ParameterDeclaration.html">ParameterDeclaration</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Stack.html">Stack</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StackEvent.html">StackEvent</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StackResource.html">StackResource</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StackResourceDetail.html">StackResourceDetail</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StackResourceSummary.html">StackResourceSummary</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StackSummary.html">StackSummary</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Tag.html">Tag</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_TemplateParameter.html">TemplateParameter</a> </p> </li> </ul> <p> <i>APIs for change sets</i> </p> <p>If you need to make changes to the running resources in a stack, you update the stack. Before making changes to your resources, you can generate a change set, which is summary of your proposed changes. Change sets allow you to see how your changes might impact your running resources, especially for critical resources, before implementing them.</p> <p>Actions</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html">CreateChangeSet</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteChangeSet.html">DeleteChangeSet</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeChangeSet.html">DescribeChangeSet</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ExecuteChangeSet.html">ExecuteChangeSet</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListChangeSets.html">ListChangeSets</a> </p> </li> </ul> <p>Data Types</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Change.html">Change</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ChangeSetSummary.html">ChangeSetSummary</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ResourceChange.html">ResourceChange</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ResourceChangeDetail.html">ResourceChangeDetail</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ResourceTargetDefinition.html">ResourceTargetDefinition</a> </p> </li> </ul> <p> <i>APIs for stack sets</i> </p> <p>AWS CloudFormation StackSets lets you create a collection, or stack set, of stacks that can automatically and safely provision a common set of AWS resources across multiple AWS accounts and multiple AWS regions from a single AWS CloudFormation template. When you create a stack set, AWS CloudFormation provisions a stack in each of the specified accounts and regions by using the supplied AWS CloudFormation template and parameters. Stack sets let you manage a common set of AWS resources in a selection of accounts and regions in a single operation. </p> <p>Actions</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html">CreateStackInstances</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackSet.html">CreateStackSet</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteStackInstances.html">DeleteStackInstances</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteStackSet.html">DeleteStackSet</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackInstance.html">DescribeStackInstance</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackSet.html">DescribeStackSet</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackSetOperation.html">DescribeStackSetOperation</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackInstances.html">ListStackInstances</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSetOperationResults">ListStackSetOperationResults</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSetOperations">ListStackSetOperations</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSets">ListStackSets</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StopStackSetOperation.html">StopStackSetOperation</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> </p> </li> </ul> <p>Data Types</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StackInstance.html.html">StackInstance</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StackInstanceSummary.html.html">StackInstanceSummary</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StackSet.html">StackSet</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StackSetOperation.html.html">StackSetOperation</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StackSetOperationPreferences.html.html">StackSetOperationPreferences</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StackSetOperationResultSummary.html.html">StackSetOperationResultSummary</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StackSetOperationSummary.html.html">StackSetOperationSummary</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StackSetSummary.html">StackSetSummary</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Tag.html">Tag</a> </p> </li> </ul>', 'operations' => [ 'CancelUpdateStack' => '<p>Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and reverts to the previous stack configuration.</p> <note> <p>You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.</p> </note>', 'ContinueUpdateRollback' => '<p>For a specified stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state, continues rolling it back to the <code>UPDATE_ROLLBACK_COMPLETE</code> state. Depending on the cause of the failure, you can manually <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"> fix the error</a> and continue the rollback. By continuing the rollback, you can return your stack to a working state (the <code>UPDATE_ROLLBACK_COMPLETE</code> state), and then try to update the stack again.</p> <p>A stack goes into the <code>UPDATE_ROLLBACK_FAILED</code> state when AWS CloudFormation cannot roll back all changes after a failed stack update. For example, you might have a stack that is rolling back to an old database instance that was deleted outside of AWS CloudFormation. Because AWS CloudFormation doesn\'t know the database was deleted, it assumes that the database instance still exists and attempts to roll back to it, causing the update rollback to fail.</p>', 'CreateChangeSet' => '<p>Creates a list of changes that will be applied to a stack so that you can review the changes before executing them. You can create a change set for a stack that doesn\'t exist or an existing stack. If you create a change set for a stack that doesn\'t exist, the change set shows all of the resources that AWS CloudFormation will create. If you create a change set for an existing stack, AWS CloudFormation compares the stack\'s information with the information that you submit in the change set and lists the differences. Use change sets to understand which resources AWS CloudFormation will create or change, and how it will change resources in an existing stack, before you create or update a stack.</p> <p>To create a change set for a stack that doesn\'t exist, for the <code>ChangeSetType</code> parameter, specify <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code> for the <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call successfully completes, AWS CloudFormation starts creating the change set. To check the status of the change set or to review it, use the <a>DescribeChangeSet</a> action.</p> <p>When you are satisfied with the changes the change set will make, execute the change set by using the <a>ExecuteChangeSet</a> action. AWS CloudFormation doesn\'t make changes until you execute the change set.</p>', 'CreateStack' => '<p>Creates a stack as specified in the template. After the call completes successfully, the stack creation starts. You can check the status of the stack via the <a>DescribeStacks</a> API.</p>', 'CreateStackInstances' => '<p>Creates stack instances for the specified accounts, within the specified regions. A stack instance refers to a stack in a specific account and region. <code>Accounts</code> and <code>Regions</code> are required parameters—you must specify at least one account and one region. </p>', 'CreateStackSet' => '<p>Creates a stack set.</p>', 'DeleteChangeSet' => '<p>Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.</p> <p>If the call successfully completes, AWS CloudFormation successfully deleted the change set.</p>', 'DeleteStack' => '<p>Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks do not show up in the <a>DescribeStacks</a> API if the deletion has been completed successfully.</p>', 'DeleteStackInstances' => '<p>Deletes stack instances for the specified accounts, in the specified regions. </p>', 'DeleteStackSet' => '<p>Deletes a stack set. Before you can delete a stack set, all of its member stack instances must be deleted. For more information about how to do this, see <a>DeleteStackInstances</a>. </p>', 'DescribeAccountLimits' => '<p>Retrieves your account\'s AWS CloudFormation limits, such as the maximum number of stacks that you can create in your account.</p>', 'DescribeChangeSet' => '<p>Returns the inputs for the change set and a list of changes that AWS CloudFormation will make if you execute the change set. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html">Updating Stacks Using Change Sets</a> in the AWS CloudFormation User Guide.</p>', 'DescribeStackEvents' => '<p>Returns all stack related events for a specified stack in reverse chronological order. For more information about a stack\'s event history, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the AWS CloudFormation User Guide.</p> <note> <p>You can list events for stacks that have failed to create or have been deleted by specifying the unique stack identifier (stack ID).</p> </note>', 'DescribeStackInstance' => '<p>Returns the stack instance that\'s associated with the specified stack set, AWS account, and region.</p> <p>For a list of stack instances that are associated with a specific stack set, use <a>ListStackInstances</a>.</p>', 'DescribeStackResource' => '<p>Returns a description of the specified resource in the specified stack.</p> <p>For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been deleted.</p>', 'DescribeStackResources' => '<p>Returns AWS resource descriptions for running and deleted stacks. If <code>StackName</code> is specified, all the associated resources that are part of the stack are returned. If <code>PhysicalResourceId</code> is specified, the associated resources of the stack that the resource belongs to are returned.</p> <note> <p>Only the first 100 resources will be returned. If your stack has more resources than this, you should use <code>ListStackResources</code> instead.</p> </note> <p>For deleted stacks, <code>DescribeStackResources</code> returns resource information for up to 90 days after the stack has been deleted.</p> <p>You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>, but not both. In addition, you can specify <code>LogicalResourceId</code> to filter the returned result. For more information about resources, the <code>LogicalResourceId</code> and <code>PhysicalResourceId</code>, go to the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">AWS CloudFormation User Guide</a>.</p> <note> <p>A <code>ValidationError</code> is returned if you specify both <code>StackName</code> and <code>PhysicalResourceId</code> in the same request.</p> </note>', 'DescribeStackSet' => '<p>Returns the description of the specified stack set. </p>', 'DescribeStackSetOperation' => '<p>Returns the description of the specified stack set operation. </p>', 'DescribeStacks' => '<p>Returns the description for the specified stack; if no stack name was specified, then it returns the description for all the stacks created.</p> <note> <p>If the stack does not exist, an <code>AmazonCloudFormationException</code> is returned.</p> </note>', 'EstimateTemplateCost' => '<p>Returns the estimated monthly cost of a template. The return value is an AWS Simple Monthly Calculator URL with a query string that describes the resources required to run the template.</p>', 'ExecuteChangeSet' => '<p>Updates a stack using the input information that was provided when the specified change set was created. After the call successfully completes, AWS CloudFormation starts updating the stack. Use the <a>DescribeStacks</a> action to view the status of the update.</p> <p>When you execute a change set, AWS CloudFormation deletes all other change sets associated with the stack because they aren\'t valid for the updated stack.</p> <p>If a stack policy is associated with the stack, AWS CloudFormation enforces the policy during the update. You can\'t specify a temporary stack policy that overrides the current policy.</p>', 'GetStackPolicy' => '<p>Returns the stack policy for a specified stack. If a stack doesn\'t have a policy, a null value is returned.</p>', 'GetTemplate' => '<p>Returns the template body for a specified stack. You can get the template for running or deleted stacks.</p> <p>For deleted stacks, GetTemplate returns the template for up to 90 days after the stack has been deleted.</p> <note> <p> If the template does not exist, a <code>ValidationError</code> is returned. </p> </note>', 'GetTemplateSummary' => '<p>Returns information about a new or existing template. The <code>GetTemplateSummary</code> action is useful for viewing parameter information, such as default parameter values and parameter types, before you create or update a stack.</p> <p>You can use the <code>GetTemplateSummary</code> action when you submit a template, or you can get template information for a running or deleted stack.</p> <p>For deleted stacks, <code>GetTemplateSummary</code> returns the template information for up to 90 days after the stack has been deleted. If the template does not exist, a <code>ValidationError</code> is returned.</p>', 'ListChangeSets' => '<p>Returns the ID and status of each active change set for a stack. For example, AWS CloudFormation lists change sets that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.</p>', 'ListExports' => '<p>Lists all exported output values in the account and region in which you call this action. Use this action to see the exported output values that you can import into other stacks. To import values, use the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html"> <code>Fn::ImportValue</code> </a> function. </p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html"> AWS CloudFormation Export Stack Output Values</a>.</p>', 'ListImports' => '<p>Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first use this action to see which stacks are using it. To see the exported output values in your account, see <a>ListExports</a>. </p> <p>For more information about importing an exported output value, see the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html"> <code>Fn::ImportValue</code> </a> function. </p>', 'ListStackInstances' => '<p>Returns summary information about stack instances that are associated with the specified stack set. You can filter for stack instances that are associated with a specific AWS account name or region.</p>', 'ListStackResources' => '<p>Returns descriptions of all resources of the specified stack.</p> <p>For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been deleted.</p>', 'ListStackSetOperationResults' => '<p>Returns summary information about the results of a stack set operation. </p>', 'ListStackSetOperations' => '<p>Returns summary information about operations performed on a stack set. </p>', 'ListStackSets' => '<p>Returns summary information about stack sets that are associated with the user.</p>', 'ListStacks' => '<p>Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and stacks that have been deleted).</p>', 'SetStackPolicy' => '<p>Sets a stack policy for a specified stack.</p>', 'SignalResource' => '<p>Sends a signal to the specified resource with a success or failure status. You can use the SignalResource API in conjunction with a creation policy or update policy. AWS CloudFormation doesn\'t proceed with a stack creation or update until resources receive the required number of signals or the timeout period is exceeded. The SignalResource API is useful in cases where you want to send signals from anywhere other than an Amazon EC2 instance.</p>', 'StopStackSetOperation' => '<p>Stops an in-progress operation on a stack set and its associated stack instances. </p>', 'UpdateStack' => '<p>Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You can check the status of the stack via the <a>DescribeStacks</a> action.</p> <p>To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.</p> <p>For more information about creating an update template, updating a stack, and monitoring the progress of the update, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">Updating a Stack</a>.</p>', 'UpdateStackSet' => '<p>Updates the stack set and <i>all</i> associated stack instances.</p> <p>Even if the stack set operation created by updating the stack set fails (completely or partially, below or above a specified failure tolerance), the stack set is updated with your changes. Subsequent <a>CreateStackInstances</a> calls on the specified stack set use the updated stack set.</p>', 'ValidateTemplate' => '<p>Validates a specified template. AWS CloudFormation first checks if the template is valid JSON. If it isn\'t, AWS CloudFormation checks if the template is valid YAML. If both these checks fail, AWS CloudFormation returns a template validation error.</p>', ], 'shapes' => [ 'Account' => [ 'base' => NULL, 'refs' => [ 'AccountList$member' => NULL, 'DescribeStackInstanceInput$StackInstanceAccount' => '<p>The ID of an AWS account that\'s associated with this stack instance.</p>', 'ListStackInstancesInput$StackInstanceAccount' => '<p>The name of the AWS account that you want to list stack instances for.</p>', 'StackInstance$Account' => '<p>The name of the AWS account that the stack instance is associated with.</p>', 'StackInstanceSummary$Account' => '<p>The name of the AWS account that the stack instance is associated with.</p>', 'StackSetOperationResultSummary$Account' => '<p>The name of the AWS account for this operation result.</p>', ], ], 'AccountGateResult' => [ 'base' => '<p>Structure that contains the results of the account gate function AWS CloudFormation StackSets invokes, if present, before proceeding with stack set operations in an account.</p> <p>Account gating enables you to specify a Lamdba function for an account that encapsulates any requirements that must be met before AWS CloudFormation StackSets proceeds with stack set operations in that account. CloudFormation invokes the function each time stack set operations are initiated for that account, and only proceeds if the function returns a success code. </p>', 'refs' => [ 'StackSetOperationResultSummary$AccountGateResult' => '<p>The results of the account gate function AWS CloudFormation invokes, if present, before proceeding with stack set operations in an account</p>', ], ], 'AccountGateStatus' => [ 'base' => NULL, 'refs' => [ 'AccountGateResult$Status' => '<p>The status of the account gate function.</p> <ul> <li> <p> <code>SUCCEEDED</code>: The account gate function has determined that the account passes any requirements for stack set operations to occur. AWS CloudFormation proceeds with stack operations in the account. </p> </li> <li> <p> <code>FAILED</code>: The account gate function has determined that the account does not meet the requirements for stack set operations to occur. AWS CloudFormation cancels the stack set operations in that account, and the stack set operation status is set to FAILED.</p> </li> <li> <p> <code>SKIPPED</code>: An account gate function has not been specified for the account, or the AWSCloudFormationStackSetExecutionRole of the stack set adminstration account lacks permissions to invoke the function. AWS CloudFormation proceeds with stack set operations in the account. </p> </li> </ul>', ], ], 'AccountGateStatusReason' => [ 'base' => NULL, 'refs' => [ 'AccountGateResult$StatusReason' => '<p>The reason for the account gate status assigned to this account.</p>', ], ], 'AccountLimit' => [ 'base' => '<p>The AccountLimit data type.</p>', 'refs' => [ 'AccountLimitList$member' => NULL, ], ], 'AccountLimitList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsOutput$AccountLimits' => '<p>An account limit structure that contain a list of AWS CloudFormation account limits and their values.</p>', ], ], 'AccountList' => [ 'base' => NULL, 'refs' => [ 'CreateStackInstancesInput$Accounts' => '<p>The names of one or more AWS accounts that you want to create stack instances in the specified region(s) for.</p>', 'DeleteStackInstancesInput$Accounts' => '<p>The names of the AWS accounts that you want to delete stack instances for.</p>', ], ], 'AllowedValue' => [ 'base' => NULL, 'refs' => [ 'AllowedValues$member' => NULL, ], ], 'AllowedValues' => [ 'base' => NULL, 'refs' => [ 'ParameterConstraints$AllowedValues' => '<p>A list of values that are permitted for a parameter.</p>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>The resource with the name requested already exists.</p>', 'refs' => [], ], 'CancelUpdateStackInput' => [ 'base' => '<p>The input for the <a>CancelUpdateStack</a> action.</p>', 'refs' => [], ], 'Capabilities' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$Capabilities' => '<p>A list of values that you must specify before AWS CloudFormation can update certain stacks. Some stack templates might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge their capabilities by specifying this parameter.</p> <p>The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The following resources require you to specify this parameter: <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html"> AWS::IAM::AccessKey</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"> AWS::IAM::Group</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html"> AWS::IAM::Policy</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"> AWS::IAM::Role</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html"> AWS::IAM::User</a>, and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.</p> <p>If you have IAM resources, you can specify either capability. If you have IAM resources with custom names, you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don\'t specify this parameter, this action returns an <code>InsufficientCapabilities</code> error.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a>.</p>', 'CreateStackInput$Capabilities' => '<p>A list of values that you must specify before AWS CloudFormation can create certain stacks. Some stack templates might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge their capabilities by specifying this parameter.</p> <p>The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The following resources require you to specify this parameter: <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html"> AWS::IAM::AccessKey</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"> AWS::IAM::Group</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html"> AWS::IAM::Policy</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"> AWS::IAM::Role</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html"> AWS::IAM::User</a>, and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.</p> <p>If you have IAM resources, you can specify either capability. If you have IAM resources with custom names, you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don\'t specify this parameter, this action returns an <code>InsufficientCapabilities</code> error.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a>.</p>', 'CreateStackSetInput$Capabilities' => '<p>A list of values that you must specify before AWS CloudFormation can create certain stack sets. Some stack set templates might include resources that can affect permissions in your AWS account—for example, by creating new AWS Identity and Access Management (IAM) users. For those stack sets, you must explicitly acknowledge their capabilities by specifying this parameter.</p> <p>The only valid values are CAPABILITY_IAM and CAPABILITY_NAMED_IAM. The following resources require you to specify this parameter: </p> <ul> <li> <p>AWS::IAM::AccessKey</p> </li> <li> <p>AWS::IAM::Group</p> </li> <li> <p>AWS::IAM::InstanceProfile</p> </li> <li> <p>AWS::IAM::Policy</p> </li> <li> <p>AWS::IAM::Role</p> </li> <li> <p>AWS::IAM::User</p> </li> <li> <p>AWS::IAM::UserToGroupAddition</p> </li> </ul> <p>If your stack template contains these resources, we recommend that you review all permissions that are associated with them and edit their permissions if necessary.</p> <p>If you have IAM resources, you can specify either capability. If you have IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM. If you don\'t specify this parameter, this action returns an <code>InsufficientCapabilities</code> error.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates.</a> </p>', 'DescribeChangeSetOutput$Capabilities' => '<p>If you execute the change set, the list of capabilities that were explicitly acknowledged when the change set was created.</p>', 'GetTemplateSummaryOutput$Capabilities' => '<p>The capabilities found within the template. If your template contains IAM resources, you must specify the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities error.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a>.</p>', 'Stack$Capabilities' => '<p>The capabilities allowed in the stack.</p>', 'StackSet$Capabilities' => '<p>The capabilities that are allowed in the stack set. Some stack set templates might include resources that can affect permissions in your AWS account—for example, by creating new AWS Identity and Access Management (IAM) users. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates.</a> </p>', 'UpdateStackInput$Capabilities' => '<p>A list of values that you must specify before AWS CloudFormation can update certain stacks. Some stack templates might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge their capabilities by specifying this parameter.</p> <p>The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The following resources require you to specify this parameter: <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html"> AWS::IAM::AccessKey</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"> AWS::IAM::Group</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html"> AWS::IAM::Policy</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"> AWS::IAM::Role</a>, <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html"> AWS::IAM::User</a>, and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.</p> <p>If you have IAM resources, you can specify either capability. If you have IAM resources with custom names, you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don\'t specify this parameter, this action returns an <code>InsufficientCapabilities</code> error.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a>.</p>', 'UpdateStackSetInput$Capabilities' => '<p>A list of values that you must specify before AWS CloudFormation can create certain stack sets. Some stack set templates might include resources that can affect permissions in your AWS account—for example, by creating new AWS Identity and Access Management (IAM) users. For those stack sets, you must explicitly acknowledge their capabilities by specifying this parameter.</p> <p>The only valid values are CAPABILITY_IAM and CAPABILITY_NAMED_IAM. The following resources require you to specify this parameter: </p> <ul> <li> <p>AWS::IAM::AccessKey</p> </li> <li> <p>AWS::IAM::Group</p> </li> <li> <p>AWS::IAM::InstanceProfile</p> </li> <li> <p>AWS::IAM::Policy</p> </li> <li> <p>AWS::IAM::Role</p> </li> <li> <p>AWS::IAM::User</p> </li> <li> <p>AWS::IAM::UserToGroupAddition</p> </li> </ul> <p>If your stack template contains these resources, we recommend that you review all permissions that are associated with them and edit their permissions if necessary.</p> <p>If you have IAM resources, you can specify either capability. If you have IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM. If you don\'t specify this parameter, this action returns an <code>InsufficientCapabilities</code> error.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates.</a> </p>', 'ValidateTemplateOutput$Capabilities' => '<p>The capabilities found within the template. If your template contains IAM resources, you must specify the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities error.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a>.</p>', ], ], 'CapabilitiesReason' => [ 'base' => NULL, 'refs' => [ 'GetTemplateSummaryOutput$CapabilitiesReason' => '<p>The list of resources that generated the values in the <code>Capabilities</code> response element.</p>', 'ValidateTemplateOutput$CapabilitiesReason' => '<p>The list of resources that generated the values in the <code>Capabilities</code> response element.</p>', ], ], 'Capability' => [ 'base' => NULL, 'refs' => [ 'Capabilities$member' => NULL, ], ], 'CausingEntity' => [ 'base' => NULL, 'refs' => [ 'ResourceChangeDetail$CausingEntity' => '<p>The identity of the entity that triggered this change. This entity is a member of the group that is specified by the <code>ChangeSource</code> field. For example, if you modified the value of the <code>KeyPairName</code> parameter, the <code>CausingEntity</code> is the name of the parameter (<code>KeyPairName</code>).</p> <p>If the <code>ChangeSource</code> value is <code>DirectModification</code>, no value is given for <code>CausingEntity</code>.</p>', ], ], 'Change' => [ 'base' => '<p>The <code>Change</code> structure describes the changes AWS CloudFormation will perform if you execute the change set.</p>', 'refs' => [ 'Changes$member' => NULL, ], ], 'ChangeAction' => [ 'base' => NULL, 'refs' => [ 'ResourceChange$Action' => '<p>The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource), <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).</p>', ], ], 'ChangeSetId' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$ChangeSetId' => '<p>The ID of the change set.</p>', 'CreateChangeSetOutput$Id' => '<p>The Amazon Resource Name (ARN) of the change set.</p>', 'DescribeChangeSetOutput$ChangeSetId' => '<p>The ARN of the change set.</p>', 'Stack$ChangeSetId' => '<p>The unique ID of the change set.</p>', ], ], 'ChangeSetName' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$ChangeSetName' => '<p>The name of the change set.</p>', 'CreateChangeSetInput$ChangeSetName' => '<p>The name of the change set. The name must be unique among all change sets that are associated with the specified stack.</p> <p>A change set name can contain only alphanumeric, case sensitive characters and hyphens. It must start with an alphabetic character and cannot exceed 128 characters.</p>', 'DescribeChangeSetOutput$ChangeSetName' => '<p>The name of the change set.</p>', ], ], 'ChangeSetNameOrId' => [ 'base' => NULL, 'refs' => [ 'DeleteChangeSetInput$ChangeSetName' => '<p>The name or Amazon Resource Name (ARN) of the change set that you want to delete.</p>', 'DescribeChangeSetInput$ChangeSetName' => '<p>The name or Amazon Resource Name (ARN) of the change set that you want to describe.</p>', 'ExecuteChangeSetInput$ChangeSetName' => '<p>The name or ARN of the change set that you want use to update the specified stack.</p>', 'GetTemplateInput$ChangeSetName' => '<p>The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation returns the associated template. If you specify a name, you must also specify the <code>StackName</code>.</p>', ], ], 'ChangeSetNotFoundException' => [ 'base' => '<p>The specified change set name or ID doesn\'t exit. To view valid change sets for a stack, use the <code>ListChangeSets</code> action.</p>', 'refs' => [], ], 'ChangeSetStatus' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$Status' => '<p>The state of the change set, such as <code>CREATE_IN_PROGRESS</code>, <code>CREATE_COMPLETE</code>, or <code>FAILED</code>.</p>', 'DescribeChangeSetOutput$Status' => '<p>The current status of the change set, such as <code>CREATE_IN_PROGRESS</code>, <code>CREATE_COMPLETE</code>, or <code>FAILED</code>.</p>', ], ], 'ChangeSetStatusReason' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$StatusReason' => '<p>A description of the change set\'s status. For example, if your change set is in the <code>FAILED</code> state, AWS CloudFormation shows the error message.</p>', 'DescribeChangeSetOutput$StatusReason' => '<p>A description of the change set\'s status. For example, if your attempt to create a change set failed, AWS CloudFormation shows the error message.</p>', ], ], 'ChangeSetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListChangeSetsOutput$Summaries' => '<p>A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set for the specified stack.</p>', ], ], 'ChangeSetSummary' => [ 'base' => '<p>The <code>ChangeSetSummary</code> structure describes a change set, its status, and the stack with which it\'s associated.</p>', 'refs' => [ 'ChangeSetSummaries$member' => NULL, ], ], 'ChangeSetType' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$ChangeSetType' => '<p>The type of change set operation. To create a change set for a new stack, specify <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code>.</p> <p>If you create a change set for a new stack, AWS Cloudformation creates a stack with a unique stack ID, but no template or resources. The stack will be in the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995"> <code>REVIEW_IN_PROGRESS</code> </a> state until you execute the change set.</p> <p>By default, AWS CloudFormation specifies <code>UPDATE</code>. You can\'t use the <code>UPDATE</code> type to create a change set for a new stack or the <code>CREATE</code> type to create a change set for an existing stack.</p>', ], ], 'ChangeSource' => [ 'base' => NULL, 'refs' => [ 'ResourceChangeDetail$ChangeSource' => '<p>The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:</p> <ul> <li> <p> <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to resources in the template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.</p> </li> <li> <p> <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template parameter values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.</p> </li> <li> <p> <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get resource attribute values, such as <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.</p> </li> <li> <p> <code>DirectModification</code> entities are changes that are made directly to the template.</p> </li> <li> <p> <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are also known as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code> resource, AWS CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the nested stack\'s template might have changed. Changes to a nested stack\'s template aren\'t visible to AWS CloudFormation until you run an update on the parent stack.</p> </li> </ul>', ], ], 'ChangeType' => [ 'base' => NULL, 'refs' => [ 'Change$Type' => '<p>The type of entity that AWS CloudFormation changes. Currently, the only entity type is <code>Resource</code>.</p>', ], ], 'Changes' => [ 'base' => NULL, 'refs' => [ 'DescribeChangeSetOutput$Changes' => '<p>A list of <code>Change</code> structures that describes the resources AWS CloudFormation changes if you execute the change set.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'CancelUpdateStackInput$ClientRequestToken' => '<p>A unique identifier for this <code>CancelUpdateStack</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to cancel an update on a stack with the same name. You might retry <code>CancelUpdateStack</code> requests to ensure that AWS CloudFormation successfully received them.</p>', 'ContinueUpdateRollbackInput$ClientRequestToken' => '<p>A unique identifier for this <code>ContinueUpdateRollback</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to continue the rollback to a stack with the same name. You might retry <code>ContinueUpdateRollback</code> requests to ensure that AWS CloudFormation successfully received them.</p>', 'CreateStackInput$ClientRequestToken' => '<p>A unique identifier for this <code>CreateStack</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to create a stack with the same name. You might retry <code>CreateStack</code> requests to ensure that AWS CloudFormation successfully received them.</p> <p>All events triggered by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as <code>token1</code>.</p> <p>In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>', 'CreateStackInstancesInput$OperationId' => '<p>The unique identifier for this stack set operation. </p> <p>The operation ID also functions as an idempotency token, to ensure that AWS CloudFormation performs the stack set operation only once, even if you retry the request multiple times. You might retry stack set operation requests to ensure that AWS CloudFormation successfully received them.</p> <p>If you don\'t specify an operation ID, the SDK generates one automatically. </p> <p>Repeating this stack set operation with a new operation ID retries all stack instances whose status is <code>OUTDATED</code>. </p>', 'CreateStackInstancesOutput$OperationId' => '<p>The unique identifier for this stack set operation.</p>', 'CreateStackSetInput$ClientRequestToken' => '<p>A unique identifier for this <code>CreateStackSet</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to create another stack set with the same name. You might retry <code>CreateStackSet</code> requests to ensure that AWS CloudFormation successfully received them.</p> <p>If you don\'t specify an operation ID, the SDK generates one automatically. </p>', 'DeleteStackInput$ClientRequestToken' => '<p>A unique identifier for this <code>DeleteStack</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to delete a stack with the same name. You might retry <code>DeleteStack</code> requests to ensure that AWS CloudFormation successfully received them.</p> <p>All events triggered by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as <code>token1</code>.</p> <p>In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>', 'DeleteStackInstancesInput$OperationId' => '<p>The unique identifier for this stack set operation. </p> <p>If you don\'t specify an operation ID, the SDK generates one automatically. </p> <p>The operation ID also functions as an idempotency token, to ensure that AWS CloudFormation performs the stack set operation only once, even if you retry the request multiple times. You can retry stack set operation requests to ensure that AWS CloudFormation successfully received them.</p> <p>Repeating this stack set operation with a new operation ID retries all stack instances whose status is <code>OUTDATED</code>. </p>', 'DeleteStackInstancesOutput$OperationId' => '<p>The unique identifier for this stack set operation.</p>', 'DescribeStackSetOperationInput$OperationId' => '<p>The unique ID of the stack set operation. </p>', 'ExecuteChangeSetInput$ClientRequestToken' => '<p>A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to execute a change set to update a stack with the same name. You might retry <code>ExecuteChangeSet</code> requests to ensure that AWS CloudFormation successfully received them.</p>', 'ListStackSetOperationResultsInput$OperationId' => '<p>The ID of the stack set operation.</p>', 'StackEvent$ClientRequestToken' => '<p>The token passed to the operation that generated this event.</p> <p>All events triggered by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as <code>token1</code>.</p> <p>In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>', 'StackSetOperation$OperationId' => '<p>The unique ID of a stack set operation.</p>', 'StackSetOperationSummary$OperationId' => '<p>The unique ID of the stack set operation.</p>', 'StopStackSetOperationInput$OperationId' => '<p>The ID of the stack operation. </p>', 'UpdateStackInput$ClientRequestToken' => '<p>A unique identifier for this <code>UpdateStack</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to update a stack with the same name. You might retry <code>UpdateStack</code> requests to ensure that AWS CloudFormation successfully received them.</p> <p>All events triggered by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as <code>token1</code>.</p> <p>In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>', 'UpdateStackSetInput$OperationId' => '<p>The unique ID for this stack set operation. </p> <p>The operation ID also functions as an idempotency token, to ensure that AWS CloudFormation performs the stack set operation only once, even if you retry the request multiple times. You might retry stack set operation requests to ensure that AWS CloudFormation successfully received them.</p> <p>If you don\'t specify an operation ID, AWS CloudFormation generates one automatically.</p> <p>Repeating this stack set operation with a new operation ID retries all stack instances whose status is <code>OUTDATED</code>. </p>', 'UpdateStackSetOutput$OperationId' => '<p>The unique ID for this stack set operation.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$ClientToken' => '<p>A unique identifier for this <code>CreateChangeSet</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to create another change set with the same name. You might retry <code>CreateChangeSet</code> requests to ensure that AWS CloudFormation successfully received them.</p>', ], ], 'ContinueUpdateRollbackInput' => [ 'base' => '<p>The input for the <a>ContinueUpdateRollback</a> action.</p>', 'refs' => [], ], 'ContinueUpdateRollbackOutput' => [ 'base' => '<p>The output for a <a>ContinueUpdateRollback</a> action.</p>', 'refs' => [], ], 'CreateChangeSetInput' => [ 'base' => '<p>The input for the <a>CreateChangeSet</a> action.</p>', 'refs' => [], ], 'CreateChangeSetOutput' => [ 'base' => '<p>The output for the <a>CreateChangeSet</a> action.</p>', 'refs' => [], ], 'CreateStackInput' => [ 'base' => '<p>The input for <a>CreateStack</a> action.</p>', 'refs' => [], ], 'CreateStackInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStackInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStackOutput' => [ 'base' => '<p>The output for a <a>CreateStack</a> action.</p>', 'refs' => [], ], 'CreateStackSetInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStackSetOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatedButModifiedException' => [ 'base' => '<p>The specified resource exists, but has been changed.</p>', 'refs' => [], ], 'CreationTime' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$CreationTime' => '<p>The start time when the change set was created, in UTC.</p>', 'DescribeChangeSetOutput$CreationTime' => '<p>The start time when the change set was created, in UTC.</p>', 'Stack$CreationTime' => '<p>The time at which the stack was created.</p>', 'StackSummary$CreationTime' => '<p>The time the stack was created.</p>', ], ], 'DeleteChangeSetInput' => [ 'base' => '<p>The input for the <a>DeleteChangeSet</a> action.</p>', 'refs' => [], ], 'DeleteChangeSetOutput' => [ 'base' => '<p>The output for the <a>DeleteChangeSet</a> action.</p>', 'refs' => [], ], 'DeleteStackInput' => [ 'base' => '<p>The input for <a>DeleteStack</a> action.</p>', 'refs' => [], ], 'DeleteStackInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStackInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStackSetInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStackSetOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletionTime' => [ 'base' => NULL, 'refs' => [ 'StackSummary$DeletionTime' => '<p>The time the stack was deleted.</p>', ], ], 'DescribeAccountLimitsInput' => [ 'base' => '<p>The input for the <a>DescribeAccountLimits</a> action.</p>', 'refs' => [], ], 'DescribeAccountLimitsOutput' => [ 'base' => '<p>The output for the <a>DescribeAccountLimits</a> action.</p>', 'refs' => [], ], 'DescribeChangeSetInput' => [ 'base' => '<p>The input for the <a>DescribeChangeSet</a> action.</p>', 'refs' => [], ], 'DescribeChangeSetOutput' => [ 'base' => '<p>The output for the <a>DescribeChangeSet</a> action.</p>', 'refs' => [], ], 'DescribeStackEventsInput' => [ 'base' => '<p>The input for <a>DescribeStackEvents</a> action.</p>', 'refs' => [], ], 'DescribeStackEventsOutput' => [ 'base' => '<p>The output for a <a>DescribeStackEvents</a> action.</p>', 'refs' => [], ], 'DescribeStackInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackResourceInput' => [ 'base' => '<p>The input for <a>DescribeStackResource</a> action.</p>', 'refs' => [], ], 'DescribeStackResourceOutput' => [ 'base' => '<p>The output for a <a>DescribeStackResource</a> action.</p>', 'refs' => [], ], 'DescribeStackResourcesInput' => [ 'base' => '<p>The input for <a>DescribeStackResources</a> action.</p>', 'refs' => [], ], 'DescribeStackResourcesOutput' => [ 'base' => '<p>The output for a <a>DescribeStackResources</a> action.</p>', 'refs' => [], ], 'DescribeStackSetInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackSetOperationInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackSetOperationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackSetOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStacksInput' => [ 'base' => '<p>The input for <a>DescribeStacks</a> action.</p>', 'refs' => [], ], 'DescribeStacksOutput' => [ 'base' => '<p>The output for a <a>DescribeStacks</a> action.</p>', 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$Description' => '<p>Descriptive information about the change set.</p>', 'CreateChangeSetInput$Description' => '<p>A description to help you identify this change set.</p>', 'CreateStackSetInput$Description' => '<p>A description of the stack set. You can use the description to identify the stack set\'s purpose or other important information.</p>', 'DescribeChangeSetOutput$Description' => '<p>Information about the change set.</p>', 'GetTemplateSummaryOutput$Description' => '<p>The value that is defined in the <code>Description</code> property of the template.</p>', 'Output$Description' => '<p>User defined description associated with the output.</p>', 'ParameterDeclaration$Description' => '<p>The description that is associate with the parameter.</p>', 'Stack$Description' => '<p>A user-defined description associated with the stack.</p>', 'StackResource$Description' => '<p>User defined description associated with the resource.</p>', 'StackResourceDetail$Description' => '<p>User defined description associated with the resource.</p>', 'StackSet$Description' => '<p>A description of the stack set that you specify when the stack set is created or updated.</p>', 'StackSetSummary$Description' => '<p>A description of the stack set that you specify when the stack set is created or updated.</p>', 'TemplateParameter$Description' => '<p>User defined description associated with the parameter.</p>', 'UpdateStackSetInput$Description' => '<p>A brief description of updates that you are making.</p>', 'ValidateTemplateOutput$Description' => '<p>The description found within the template.</p>', ], ], 'DisableRollback' => [ 'base' => NULL, 'refs' => [ 'CreateStackInput$DisableRollback' => '<p>Set to <code>true</code> to disable rollback of the stack if stack creation failed. You can specify either <code>DisableRollback</code> or <code>OnFailure</code>, but not both.</p> <p>Default: <code>false</code> </p>', 'Stack$DisableRollback' => '<p>Boolean to enable or disable rollback on stack creation failures:</p> <ul> <li> <p> <code>true</code>: disable rollback</p> </li> <li> <p> <code>false</code>: enable rollback</p> </li> </ul>', ], ], 'EstimateTemplateCostInput' => [ 'base' => '<p>The input for an <a>EstimateTemplateCost</a> action.</p>', 'refs' => [], ], 'EstimateTemplateCostOutput' => [ 'base' => '<p>The output for a <a>EstimateTemplateCost</a> action.</p>', 'refs' => [], ], 'EvaluationType' => [ 'base' => NULL, 'refs' => [ 'ResourceChangeDetail$Evaluation' => '<p>Indicates whether AWS CloudFormation can determine the target value, and whether the target value will change before you execute a change set.</p> <p>For <code>Static</code> evaluations, AWS CloudFormation can determine that the target value will change, and its value. For example, if you directly modify the <code>InstanceType</code> property of an EC2 instance, AWS CloudFormation knows that this property value will change, and its value, so this is a <code>Static</code> evaluation.</p> <p>For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the result of an intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic function, when the stack is updated. For example, if your template includes a reference to a resource that is conditionally recreated, the value of the reference (the physical ID of the resource) might change, depending on if the resource is recreated. If the resource is recreated, it will have a new physical ID, so all references to that resource will also be updated.</p>', ], ], 'EventId' => [ 'base' => NULL, 'refs' => [ 'StackEvent$EventId' => '<p>The unique ID of this event.</p>', ], ], 'ExecuteChangeSetInput' => [ 'base' => '<p>The input for the <a>ExecuteChangeSet</a> action.</p>', 'refs' => [], ], 'ExecuteChangeSetOutput' => [ 'base' => '<p>The output for the <a>ExecuteChangeSet</a> action.</p>', 'refs' => [], ], 'ExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$ExecutionStatus' => '<p>If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can’t execute the change set, the status indicates why. For example, a change set might be in an <code>UNAVAILABLE</code> state because AWS CloudFormation is still creating it or in an <code>OBSOLETE</code> state because the stack was already updated.</p>', 'DescribeChangeSetOutput$ExecutionStatus' => '<p>If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can’t execute the change set, the status indicates why. For example, a change set might be in an <code>UNAVAILABLE</code> state because AWS CloudFormation is still creating it or in an <code>OBSOLETE</code> state because the stack was already updated.</p>', ], ], 'Export' => [ 'base' => '<p>The <code>Export</code> structure describes the exported output values for a stack.</p>', 'refs' => [ 'Exports$member' => NULL, ], ], 'ExportName' => [ 'base' => NULL, 'refs' => [ 'Export$Name' => '<p>The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to import the associated value into other stacks. The name is defined in the <code>Export</code> field in the associated stack\'s <code>Outputs</code> section.</p>', 'ListImportsInput$ExportName' => '<p>The name of the exported output value. AWS CloudFormation returns the stack names that are importing this value. </p>', 'Output$ExportName' => '<p>The name of the export associated with the output.</p>', ], ], 'ExportValue' => [ 'base' => NULL, 'refs' => [ 'Export$Value' => '<p>The value of the exported output, such as a resource physical ID. This value is defined in the <code>Export</code> field in the associated stack\'s <code>Outputs</code> section.</p>', ], ], 'Exports' => [ 'base' => NULL, 'refs' => [ 'ListExportsOutput$Exports' => '<p>The output for the <a>ListExports</a> action.</p>', ], ], 'FailureToleranceCount' => [ 'base' => NULL, 'refs' => [ 'StackSetOperationPreferences$FailureToleranceCount' => '<p>The number of accounts, per region, for which this operation can fail before AWS CloudFormation stops the operation in that region. If the operation is stopped in a region, AWS CloudFormation doesn\'t attempt the operation in any subsequent regions.</p> <p>Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code> (but not both).</p>', ], ], 'FailureTolerancePercentage' => [ 'base' => NULL, 'refs' => [ 'StackSetOperationPreferences$FailureTolerancePercentage' => '<p>The percentage of accounts, per region, for which this stack operation can fail before AWS CloudFormation stops the operation in that region. If the operation is stopped in a region, AWS CloudFormation doesn\'t attempt the operation in any subsequent regions.</p> <p>When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds <i>down</i> to the next whole number.</p> <p>Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code>, but not both.</p>', ], ], 'GetStackPolicyInput' => [ 'base' => '<p>The input for the <a>GetStackPolicy</a> action.</p>', 'refs' => [], ], 'GetStackPolicyOutput' => [ 'base' => '<p>The output for the <a>GetStackPolicy</a> action.</p>', 'refs' => [], ], 'GetTemplateInput' => [ 'base' => '<p>The input for a <a>GetTemplate</a> action.</p>', 'refs' => [], ], 'GetTemplateOutput' => [ 'base' => '<p>The output for <a>GetTemplate</a> action.</p>', 'refs' => [], ], 'GetTemplateSummaryInput' => [ 'base' => '<p>The input for the <a>GetTemplateSummary</a> action.</p>', 'refs' => [], ], 'GetTemplateSummaryOutput' => [ 'base' => '<p>The output for the <a>GetTemplateSummary</a> action.</p>', 'refs' => [], ], 'Imports' => [ 'base' => NULL, 'refs' => [ 'ListImportsOutput$Imports' => '<p>A list of stack names that are importing the specified exported output value. </p>', ], ], 'InsufficientCapabilitiesException' => [ 'base' => '<p>The template contains resources with capabilities that weren\'t specified in the Capabilities parameter.</p>', 'refs' => [], ], 'InvalidChangeSetStatusException' => [ 'base' => '<p>The specified change set can\'t be used to update the stack. For example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.</p>', 'refs' => [], ], 'InvalidOperationException' => [ 'base' => '<p>The specified operation isn\'t valid.</p>', 'refs' => [], ], 'LastUpdatedTime' => [ 'base' => NULL, 'refs' => [ 'Stack$LastUpdatedTime' => '<p>The time the stack was last updated. This field will only be returned if the stack has been updated at least once.</p>', 'StackSummary$LastUpdatedTime' => '<p>The time the stack was last updated. This field will only be returned if the stack has been updated at least once.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The quota for the resource has already been reached.</p>', 'refs' => [], ], 'LimitName' => [ 'base' => NULL, 'refs' => [ 'AccountLimit$Name' => '<p>The name of the account limit. Currently, the only account limit is <code>StackLimit</code>.</p>', ], ], 'LimitValue' => [ 'base' => NULL, 'refs' => [ 'AccountLimit$Value' => '<p>The value that is associated with the account limit name.</p>', ], ], 'ListChangeSetsInput' => [ 'base' => '<p>The input for the <a>ListChangeSets</a> action.</p>', 'refs' => [], ], 'ListChangeSetsOutput' => [ 'base' => '<p>The output for the <a>ListChangeSets</a> action.</p>', 'refs' => [], ], 'ListExportsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListExportsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListImportsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListImportsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackResourcesInput' => [ 'base' => '<p>The input for the <a>ListStackResource</a> action.</p>', 'refs' => [], ], 'ListStackResourcesOutput' => [ 'base' => '<p>The output for a <a>ListStackResources</a> action.</p>', 'refs' => [], ], 'ListStackSetOperationResultsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackSetOperationResultsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackSetOperationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackSetOperationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackSetsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackSetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStacksInput' => [ 'base' => '<p>The input for <a>ListStacks</a> action.</p>', 'refs' => [], ], 'ListStacksOutput' => [ 'base' => '<p>The output for <a>ListStacks</a> action.</p>', 'refs' => [], ], 'LogicalResourceId' => [ 'base' => NULL, 'refs' => [ 'DescribeStackResourceInput$LogicalResourceId' => '<p>The logical name of the resource as specified in the template.</p> <p>Default: There is no default value.</p>', 'DescribeStackResourcesInput$LogicalResourceId' => '<p>The logical name of the resource as specified in the template.</p> <p>Default: There is no default value.</p>', 'ResourceChange$LogicalResourceId' => '<p>The resource\'s logical ID, which is defined in the stack\'s template.</p>', 'RetainResources$member' => NULL, 'SignalResourceInput$LogicalResourceId' => '<p>The logical ID of the resource that you want to signal. The logical ID is the name of the resource that given in the template.</p>', 'StackEvent$LogicalResourceId' => '<p>The logical name of the resource specified in the template.</p>', 'StackResource$LogicalResourceId' => '<p>The logical name of the resource specified in the template.</p>', 'StackResourceDetail$LogicalResourceId' => '<p>The logical name of the resource specified in the template.</p>', 'StackResourceSummary$LogicalResourceId' => '<p>The logical name of the resource specified in the template.</p>', ], ], 'MaxConcurrentCount' => [ 'base' => NULL, 'refs' => [ 'StackSetOperationPreferences$MaxConcurrentCount' => '<p>The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of <code>FailureToleranceCount</code>—<code>MaxConcurrentCount</code> is at most one more than the <code>FailureToleranceCount</code> .</p> <p>Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but not both.</p>', ], ], 'MaxConcurrentPercentage' => [ 'base' => NULL, 'refs' => [ 'StackSetOperationPreferences$MaxConcurrentPercentage' => '<p>The maximum percentage of accounts in which to perform this operation at one time.</p> <p>When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.</p> <p>Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but not both.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListStackInstancesInput$MaxResults' => '<p>The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>', 'ListStackSetOperationResultsInput$MaxResults' => '<p>The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>', 'ListStackSetOperationsInput$MaxResults' => '<p>The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>', 'ListStackSetsInput$MaxResults' => '<p>The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'GetTemplateSummaryOutput$Metadata' => '<p>The value that is defined for the <code>Metadata</code> property of the template.</p>', 'StackResourceDetail$Metadata' => '<p>The content of the <code>Metadata</code> attribute declared for the resource. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html">Metadata Attribute</a> in the AWS CloudFormation User Guide.</p>', ], ], 'NameAlreadyExistsException' => [ 'base' => '<p>The specified name is already in use.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsInput$NextToken' => '<p>A string that identifies the next page of limits that you want to retrieve.</p>', 'DescribeAccountLimitsOutput$NextToken' => '<p>If the output exceeds 1 MB in size, a string that identifies the next page of limits. If no additional page exists, this value is null.</p>', 'DescribeChangeSetInput$NextToken' => '<p>A string (provided by the <a>DescribeChangeSet</a> response output) that identifies the next page of information that you want to retrieve.</p>', 'DescribeChangeSetOutput$NextToken' => '<p>If the output exceeds 1 MB, a string that identifies the next page of changes. If there is no additional page, this value is null.</p>', 'DescribeStackEventsInput$NextToken' => '<p>A string that identifies the next page of events that you want to retrieve.</p>', 'DescribeStackEventsOutput$NextToken' => '<p>If the output exceeds 1 MB in size, a string that identifies the next page of events. If no additional page exists, this value is null.</p>', 'DescribeStacksInput$NextToken' => '<p>A string that identifies the next page of stacks that you want to retrieve.</p>', 'DescribeStacksOutput$NextToken' => '<p>If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional page exists, this value is null.</p>', 'ListChangeSetsInput$NextToken' => '<p>A string (provided by the <a>ListChangeSets</a> response output) that identifies the next page of change sets that you want to retrieve.</p>', 'ListChangeSetsOutput$NextToken' => '<p>If the output exceeds 1 MB, a string that identifies the next page of change sets. If there is no additional page, this value is null.</p>', 'ListExportsInput$NextToken' => '<p>A string (provided by the <a>ListExports</a> response output) that identifies the next page of exported output values that you asked to retrieve.</p>', 'ListExportsOutput$NextToken' => '<p>If the output exceeds 100 exported output values, a string that identifies the next page of exports. If there is no additional page, this value is null.</p>', 'ListImportsInput$NextToken' => '<p>A string (provided by the <a>ListImports</a> response output) that identifies the next page of stacks that are importing the specified exported output value. </p>', 'ListImportsOutput$NextToken' => '<p>A string that identifies the next page of exports. If there is no additional page, this value is null.</p>', 'ListStackInstancesInput$NextToken' => '<p>If the previous request didn\'t return all of the remaining results, the response\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListStackInstances</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'ListStackInstancesOutput$NextToken' => '<p>If the request doesn\'t return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call <code>ListStackInstances</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to <code>null</code>.</p>', 'ListStackResourcesInput$NextToken' => '<p>A string that identifies the next page of stack resources that you want to retrieve.</p>', 'ListStackResourcesOutput$NextToken' => '<p>If the output exceeds 1 MB, a string that identifies the next page of stack resources. If no additional page exists, this value is null.</p>', 'ListStackSetOperationResultsInput$NextToken' => '<p>If the previous request didn\'t return all of the remaining results, the response object\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListStackSetOperationResults</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'ListStackSetOperationResultsOutput$NextToken' => '<p>If the request doesn\'t return all results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call <code>ListOperationResults</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code> is set to <code>null</code>.</p>', 'ListStackSetOperationsInput$NextToken' => '<p>If the previous paginated request didn\'t return all of the remaining results, the response object\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListStackSetOperations</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'ListStackSetOperationsOutput$NextToken' => '<p>If the request doesn\'t return all results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call <code>ListOperationResults</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code> is set to <code>null</code>.</p>', 'ListStackSetsInput$NextToken' => '<p>If the previous paginated request didn\'t return all of the remaining results, the response object\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListStackSets</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'ListStackSetsOutput$NextToken' => '<p>If the request doesn\'t return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call <code>ListStackInstances</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to <code>null</code>.</p>', 'ListStacksInput$NextToken' => '<p>A string that identifies the next page of stacks that you want to retrieve.</p>', 'ListStacksOutput$NextToken' => '<p>If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional page exists, this value is null.</p>', ], ], 'NoEcho' => [ 'base' => NULL, 'refs' => [ 'ParameterDeclaration$NoEcho' => '<p>Flag that indicates whether the parameter value is shown as plain text in logs and in the AWS Management Console.</p>', 'TemplateParameter$NoEcho' => '<p>Flag indicating whether the parameter should be displayed as plain text in logs and UIs.</p>', ], ], 'NotificationARN' => [ 'base' => NULL, 'refs' => [ 'NotificationARNs$member' => NULL, ], ], 'NotificationARNs' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$NotificationARNs' => '<p>The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS) topics that AWS CloudFormation associates with the stack. To remove all associated notification topics, specify an empty list.</p>', 'CreateStackInput$NotificationARNs' => '<p>The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your SNS topic ARNs using the SNS console or your Command Line Interface (CLI).</p>', 'DescribeChangeSetOutput$NotificationARNs' => '<p>The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that will be associated with the stack if you execute the change set.</p>', 'Stack$NotificationARNs' => '<p>SNS topic ARNs to which stack related events are published.</p>', 'UpdateStackInput$NotificationARNs' => '<p>Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that AWS CloudFormation associates with the stack. Specify an empty list to remove all notification topics.</p>', ], ], 'OnFailure' => [ 'base' => NULL, 'refs' => [ 'CreateStackInput$OnFailure' => '<p>Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING, ROLLBACK, or DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>, but not both.</p> <p>Default: <code>ROLLBACK</code> </p>', ], ], 'OperationIdAlreadyExistsException' => [ 'base' => '<p>The specified operation ID already exists.</p>', 'refs' => [], ], 'OperationInProgressException' => [ 'base' => '<p>Another operation is currently in progress for this stack set. Only one operation can be performed for a stack set at a given time.</p>', 'refs' => [], ], 'OperationNotFoundException' => [ 'base' => '<p>The specified ID refers to an operation that doesn\'t exist.</p>', 'refs' => [], ], 'Output' => [ 'base' => '<p>The Output data type.</p>', 'refs' => [ 'Outputs$member' => NULL, ], ], 'OutputKey' => [ 'base' => NULL, 'refs' => [ 'Output$OutputKey' => '<p>The key associated with the output.</p>', ], ], 'OutputValue' => [ 'base' => NULL, 'refs' => [ 'Output$OutputValue' => '<p>The value associated with the output.</p>', ], ], 'Outputs' => [ 'base' => NULL, 'refs' => [ 'Stack$Outputs' => '<p>A list of output structures.</p>', ], ], 'Parameter' => [ 'base' => '<p>The Parameter data type.</p>', 'refs' => [ 'Parameters$member' => NULL, ], ], 'ParameterConstraints' => [ 'base' => '<p>A set of criteria that AWS CloudFormation uses to validate parameter values. Although other constraints might be defined in the stack template, AWS CloudFormation returns only the <code>AllowedValues</code> property.</p>', 'refs' => [ 'ParameterDeclaration$ParameterConstraints' => '<p>The criteria that AWS CloudFormation uses to validate parameter values.</p>', ], ], 'ParameterDeclaration' => [ 'base' => '<p>The ParameterDeclaration data type.</p>', 'refs' => [ 'ParameterDeclarations$member' => NULL, ], ], 'ParameterDeclarations' => [ 'base' => NULL, 'refs' => [ 'GetTemplateSummaryOutput$Parameters' => '<p>A list of parameter declarations that describe various properties for each parameter.</p>', ], ], 'ParameterKey' => [ 'base' => NULL, 'refs' => [ 'Parameter$ParameterKey' => '<p>The key associated with the parameter. If you don\'t specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.</p>', 'ParameterDeclaration$ParameterKey' => '<p>The name that is associated with the parameter.</p>', 'TemplateParameter$ParameterKey' => '<p>The name associated with the parameter.</p>', ], ], 'ParameterType' => [ 'base' => NULL, 'refs' => [ 'ParameterDeclaration$ParameterType' => '<p>The type of parameter.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'Parameter$ParameterValue' => '<p>The value associated with the parameter.</p>', 'ParameterDeclaration$DefaultValue' => '<p>The default value of the parameter.</p>', 'TemplateParameter$DefaultValue' => '<p>The default value associated with the parameter.</p>', ], ], 'Parameters' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$Parameters' => '<p>A list of <code>Parameter</code> structures that specify input parameters for the change set. For more information, see the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data type.</p>', 'CreateStackInput$Parameters' => '<p>A list of <code>Parameter</code> structures that specify input parameters for the stack. For more information, see the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data type.</p>', 'CreateStackSetInput$Parameters' => '<p>The input parameters for the stack set template. </p>', 'DescribeChangeSetOutput$Parameters' => '<p>A list of <code>Parameter</code> structures that describes the input parameters and their values used to create the change set. For more information, see the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data type.</p>', 'EstimateTemplateCostInput$Parameters' => '<p>A list of <code>Parameter</code> structures that specify input parameters.</p>', 'Stack$Parameters' => '<p>A list of <code>Parameter</code> structures.</p>', 'StackSet$Parameters' => '<p>A list of input parameters for a stack set.</p>', 'UpdateStackInput$Parameters' => '<p>A list of <code>Parameter</code> structures that specify input parameters for the stack. For more information, see the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data type.</p>', 'UpdateStackSetInput$Parameters' => '<p>A list of input parameters for the stack set template. </p>', ], ], 'PhysicalResourceId' => [ 'base' => NULL, 'refs' => [ 'DescribeStackResourcesInput$PhysicalResourceId' => '<p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS CloudFormation.</p> <p>For example, for an Amazon Elastic Compute Cloud (EC2) instance, <code>PhysicalResourceId</code> corresponds to the <code>InstanceId</code>. You can pass the EC2 <code>InstanceId</code> to <code>DescribeStackResources</code> to find which stack the instance belongs to and what other resources are part of the stack.</p> <p>Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you must specify <code>StackName</code>.</p> <p>Default: There is no default value.</p>', 'ResourceChange$PhysicalResourceId' => '<p>The resource\'s physical ID (resource name). Resources that you are adding don\'t have physical IDs because they haven\'t been created.</p>', 'StackEvent$PhysicalResourceId' => '<p>The name or unique identifier associated with the physical instance of the resource.</p>', 'StackResource$PhysicalResourceId' => '<p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS CloudFormation.</p>', 'StackResourceDetail$PhysicalResourceId' => '<p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS CloudFormation.</p>', 'StackResourceSummary$PhysicalResourceId' => '<p>The name or unique identifier that corresponds to a physical instance ID of the resource.</p>', ], ], 'PropertyName' => [ 'base' => NULL, 'refs' => [ 'ResourceTargetDefinition$Name' => '<p>If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other attributes, the value is null.</p>', ], ], 'Reason' => [ 'base' => NULL, 'refs' => [ 'StackInstance$StatusReason' => '<p>The explanation for the specific status code that is assigned to this stack instance.</p>', 'StackInstanceSummary$StatusReason' => '<p>The explanation for the specific status code assigned to this stack instance.</p>', 'StackSetOperationResultSummary$StatusReason' => '<p>The reason for the assigned result status.</p>', ], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'DescribeStackInstanceInput$StackInstanceRegion' => '<p>The name of a region that\'s associated with this stack instance.</p>', 'ListStackInstancesInput$StackInstanceRegion' => '<p>The name of the region where you want to list stack instances. </p>', 'RegionList$member' => NULL, 'StackInstance$Region' => '<p>The name of the AWS region that the stack instance is associated with.</p>', 'StackInstanceSummary$Region' => '<p>The name of the AWS region that the stack instance is associated with.</p>', 'StackSetOperationResultSummary$Region' => '<p>The name of the AWS region for this operation result.</p>', ], ], 'RegionList' => [ 'base' => NULL, 'refs' => [ 'CreateStackInstancesInput$Regions' => '<p>The names of one or more regions where you want to create stack instances using the specified AWS account(s). </p>', 'DeleteStackInstancesInput$Regions' => '<p>The regions where you want to delete stack set instances. </p>', 'StackSetOperationPreferences$RegionOrder' => '<p>The order of the regions in where you want to perform the stack operation.</p>', ], ], 'Replacement' => [ 'base' => NULL, 'refs' => [ 'ResourceChange$Replacement' => '<p>For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by creating a new one and deleting the old one. This value depends on the value of the <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>. If the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p> <p>If you have multiple changes with different <code>RequiresRecreation</code> values, the <code>Replacement</code> value depends on the change with the most impact. A <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by <code>Conditionally</code>, and then <code>Never</code>.</p>', ], ], 'RequiresRecreation' => [ 'base' => NULL, 'refs' => [ 'ResourceTargetDefinition$RequiresRecreation' => '<p>If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the update behavior for that <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">property</a> in the AWS CloudFormation User Guide.</p>', ], ], 'ResourceAttribute' => [ 'base' => NULL, 'refs' => [ 'ResourceTargetDefinition$Attribute' => '<p>Indicates which resource attribute is triggering this update, such as a change in the resource attribute\'s <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.</p>', 'Scope$member' => NULL, ], ], 'ResourceChange' => [ 'base' => '<p>The <code>ResourceChange</code> structure describes the resource and the action that AWS CloudFormation will perform on it if you execute this change set.</p>', 'refs' => [ 'Change$ResourceChange' => '<p>A <code>ResourceChange</code> structure that describes the resource and action that AWS CloudFormation will perform.</p>', ], ], 'ResourceChangeDetail' => [ 'base' => '<p>For a resource with <code>Modify</code> as the action, the <code>ResourceChange</code> structure describes the changes AWS CloudFormation will make to that resource.</p>', 'refs' => [ 'ResourceChangeDetails$member' => NULL, ], ], 'ResourceChangeDetails' => [ 'base' => NULL, 'refs' => [ 'ResourceChange$Details' => '<p>For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the changes that AWS CloudFormation will make to the resource. </p>', ], ], 'ResourceProperties' => [ 'base' => NULL, 'refs' => [ 'StackEvent$ResourceProperties' => '<p>BLOB of the properties used to create the resource.</p>', ], ], 'ResourceSignalStatus' => [ 'base' => NULL, 'refs' => [ 'SignalResourceInput$Status' => '<p>The status of the signal, which is either success or failure. A failure signal causes AWS CloudFormation to immediately fail the stack creation or update.</p>', ], ], 'ResourceSignalUniqueId' => [ 'base' => NULL, 'refs' => [ 'SignalResourceInput$UniqueId' => '<p>A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling groups, specify the instance ID that you are signaling as the unique ID. If you send multiple signals to a single resource (such as signaling a wait condition), each signal requires a different unique ID.</p>', ], ], 'ResourceStatus' => [ 'base' => NULL, 'refs' => [ 'StackEvent$ResourceStatus' => '<p>Current status of the resource.</p>', 'StackResource$ResourceStatus' => '<p>Current status of the resource.</p>', 'StackResourceDetail$ResourceStatus' => '<p>Current status of the resource.</p>', 'StackResourceSummary$ResourceStatus' => '<p>Current status of the resource.</p>', ], ], 'ResourceStatusReason' => [ 'base' => NULL, 'refs' => [ 'StackEvent$ResourceStatusReason' => '<p>Success/failure message associated with the resource.</p>', 'StackResource$ResourceStatusReason' => '<p>Success/failure message associated with the resource.</p>', 'StackResourceDetail$ResourceStatusReason' => '<p>Success/failure message associated with the resource.</p>', 'StackResourceSummary$ResourceStatusReason' => '<p>Success/failure message associated with the resource.</p>', ], ], 'ResourceTargetDefinition' => [ 'base' => '<p>The field that AWS CloudFormation will change, such as the name of a resource\'s property, and whether the resource will be recreated.</p>', 'refs' => [ 'ResourceChangeDetail$Target' => '<p>A <code>ResourceTargetDefinition</code> structure that describes the field that AWS CloudFormation will change and whether the resource will be recreated.</p>', ], ], 'ResourceToSkip' => [ 'base' => NULL, 'refs' => [ 'ResourcesToSkip$member' => NULL, ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceChange$ResourceType' => '<p>The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.</p>', 'ResourceTypes$member' => NULL, 'StackEvent$ResourceType' => '<p>Type of resource. (For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)</p>', 'StackResource$ResourceType' => '<p>Type of resource. (For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)</p>', 'StackResourceDetail$ResourceType' => '<p>Type of resource. ((For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)</p>', 'StackResourceSummary$ResourceType' => '<p>Type of resource. (For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)</p>', ], ], 'ResourceTypes' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$ResourceTypes' => '<p>The template resource types that you have permissions to work with if you execute this change set, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.</p> <p>If the list of resource types doesn\'t include a resource type that you\'re updating, the stack update fails. By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management (IAM) uses this parameter for condition keys in IAM policies for AWS CloudFormation. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with AWS Identity and Access Management</a> in the AWS CloudFormation User Guide.</p>', 'CreateStackInput$ResourceTypes' => '<p>The template resource types that you have permissions to work with for this create stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>. Use the following syntax to describe template resource types: <code>AWS::*</code> (for all AWS resource), <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code> (for a specific custom resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a particular AWS service), and <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a specific AWS resource).</p> <p>If the list of resource types doesn\'t include a resource that you\'re creating, the stack creation fails. By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with AWS Identity and Access Management</a>.</p>', 'GetTemplateSummaryOutput$ResourceTypes' => '<p>A list of all the template resource types that are defined in the template, such as <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and <code>Custom::MyCustomInstance</code>.</p>', 'UpdateStackInput$ResourceTypes' => '<p>The template resource types that you have permissions to work with for this update stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.</p> <p>If the list of resource types doesn\'t include a resource that you\'re updating, the stack update fails. By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with AWS Identity and Access Management</a>.</p>', ], ], 'ResourcesToSkip' => [ 'base' => NULL, 'refs' => [ 'ContinueUpdateRollbackInput$ResourcesToSkip' => '<p>A list of the logical IDs of the resources that AWS CloudFormation skips during the continue update rollback operation. You can specify only resources that are in the <code>UPDATE_FAILED</code> state because a rollback failed. You can\'t specify resources that are in the <code>UPDATE_FAILED</code> state for other reasons, for example, because an update was cancelled. To check why a resource update failed, use the <a>DescribeStackResources</a> action, and view the resource status reason. </p> <important> <p>Specify this property to skip rolling back resources that AWS CloudFormation can\'t successfully roll back. We recommend that you <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"> troubleshoot</a> resources before skipping them. AWS CloudFormation sets the status of the specified resources to <code>UPDATE_COMPLETE</code> and continues to roll back the stack. After the rollback is complete, the state of the skipped resources will be inconsistent with the state of the resources in the stack template. Before performing another stack update, you must update the stack or resources to be consistent with each other. If you don\'t, subsequent stack updates might fail, and the stack will become unrecoverable. </p> </important> <p>Specify the minimum number of resources required to successfully roll back your stack. For example, a failed resource update might cause dependent resources to fail. In this case, it might not be necessary to skip the dependent resources. </p> <p>To skip resources that are part of nested stacks, use the following format: <code>NestedStackName.ResourceLogicalID</code>. If you want to specify the logical ID of a stack resource (<code>Type: AWS::CloudFormation::Stack</code>) in the <code>ResourcesToSkip</code> list, then its corresponding embedded stack must be in one of the following states: <code>DELETE_IN_PROGRESS</code>, <code>DELETE_COMPLETE</code>, or <code>DELETE_FAILED</code>. </p> <note> <p>Don\'t confuse a child stack\'s name with its corresponding logical ID defined in the parent stack. For an example of a continue update rollback operation with nested stacks, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html#nested-stacks">Using ResourcesToSkip to recover a nested stacks hierarchy</a>. </p> </note>', ], ], 'RetainResources' => [ 'base' => NULL, 'refs' => [ 'DeleteStackInput$RetainResources' => '<p>For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated with the resources you want to retain. During deletion, AWS CloudFormation deletes the stack but does not delete the retained resources.</p> <p>Retaining resources is useful when you cannot delete a resource, such as a non-empty S3 bucket, but you want to delete the stack.</p>', ], ], 'RetainStacks' => [ 'base' => NULL, 'refs' => [ 'DeleteStackInstancesInput$RetainStacks' => '<p>Removes the stack instances from the specified stack set, but doesn\'t delete the stacks. You can\'t reassociate a retained stack or add an existing, saved stack to a new stack set.</p>', ], ], 'RetainStacksNullable' => [ 'base' => NULL, 'refs' => [ 'StackSetOperation$RetainStacks' => '<p>For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack instances from the specified stack set, but doesn\'t delete the stacks. You can\'t reassociate a retained stack, or add an existing, saved stack to a new stack set.</p>', ], ], 'RoleARN' => [ 'base' => NULL, 'refs' => [ 'ContinueUpdateRollbackInput$RoleARN' => '<p>The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation assumes to roll back the stack. AWS CloudFormation uses the role\'s credentials to make calls on your behalf. AWS CloudFormation always uses this role for all future operations on the stack. As long as users have permission to operate on the stack, AWS CloudFormation uses this role even if the users don\'t have permission to pass it. Ensure that the role grants least privilege.</p> <p>If you don\'t specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.</p>', 'CreateChangeSetInput$RoleARN' => '<p>The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation assumes when executing the change set. AWS CloudFormation uses the role\'s credentials to make calls on your behalf. AWS CloudFormation uses this role for all future operations on the stack. As long as users have permission to operate on the stack, AWS CloudFormation uses this role even if the users don\'t have permission to pass it. Ensure that the role grants least privilege.</p> <p>If you don\'t specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.</p>', 'CreateStackInput$RoleARN' => '<p>The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation assumes to create the stack. AWS CloudFormation uses the role\'s credentials to make calls on your behalf. AWS CloudFormation always uses this role for all future operations on the stack. As long as users have permission to operate on the stack, AWS CloudFormation uses this role even if the users don\'t have permission to pass it. Ensure that the role grants least privilege.</p> <p>If you don\'t specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.</p>', 'DeleteStackInput$RoleARN' => '<p>The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation assumes to delete the stack. AWS CloudFormation uses the role\'s credentials to make calls on your behalf.</p> <p>If you don\'t specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.</p>', 'Stack$RoleARN' => '<p>The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that is associated with the stack. During a stack operation, AWS CloudFormation uses this role\'s credentials to make calls on your behalf.</p>', 'UpdateStackInput$RoleARN' => '<p>The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation assumes to update the stack. AWS CloudFormation uses the role\'s credentials to make calls on your behalf. AWS CloudFormation always uses this role for all future operations on the stack. As long as users have permission to operate on the stack, AWS CloudFormation uses this role even if the users don\'t have permission to pass it. Ensure that the role grants least privilege.</p> <p>If you don\'t specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.</p>', ], ], 'Scope' => [ 'base' => NULL, 'refs' => [ 'ResourceChange$Scope' => '<p>For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a change in the resource attribute\'s <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.</p>', ], ], 'SetStackPolicyInput' => [ 'base' => '<p>The input for the <a>SetStackPolicy</a> action.</p>', 'refs' => [], ], 'SignalResourceInput' => [ 'base' => '<p>The input for the <a>SignalResource</a> action.</p>', 'refs' => [], ], 'Stack' => [ 'base' => '<p>The Stack data type.</p>', 'refs' => [ 'Stacks$member' => NULL, ], ], 'StackEvent' => [ 'base' => '<p>The StackEvent data type.</p>', 'refs' => [ 'StackEvents$member' => NULL, ], ], 'StackEvents' => [ 'base' => NULL, 'refs' => [ 'DescribeStackEventsOutput$StackEvents' => '<p>A list of <code>StackEvents</code> structures.</p>', ], ], 'StackId' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$StackId' => '<p>The ID of the stack with which the change set is associated.</p>', 'CreateChangeSetOutput$StackId' => '<p>The unique ID of the stack.</p>', 'CreateStackOutput$StackId' => '<p>Unique identifier of the stack.</p>', 'DescribeChangeSetOutput$StackId' => '<p>The ARN of the stack that is associated with the change set.</p>', 'Export$ExportingStackId' => '<p>The stack that contains the exported output name and value.</p>', 'Stack$StackId' => '<p>Unique identifier of the stack.</p>', 'StackEvent$StackId' => '<p>The unique ID name of the instance of the stack.</p>', 'StackInstance$StackId' => '<p>The ID of the stack instance.</p>', 'StackInstanceSummary$StackId' => '<p>The ID of the stack instance.</p>', 'StackResource$StackId' => '<p>Unique identifier of the stack.</p>', 'StackResourceDetail$StackId' => '<p>Unique identifier of the stack.</p>', 'StackSummary$StackId' => '<p>Unique stack identifier.</p>', 'UpdateStackOutput$StackId' => '<p>Unique identifier of the stack.</p>', ], ], 'StackInstance' => [ 'base' => '<p>An AWS CloudFormation stack, in a specific account and region, that\'s part of a stack set operation. A stack instance is a reference to an attempted or actual stack in a given account within a given region. A stack instance can exist without a stack—for example, if the stack couldn\'t be created for some reason. A stack instance is associated with only one stack set. Each stack instance contains the ID of its associated stack set, as well as the ID of the actual stack and the stack status.</p>', 'refs' => [ 'DescribeStackInstanceOutput$StackInstance' => '<p>The stack instance that matches the specified request parameters.</p>', ], ], 'StackInstanceNotFoundException' => [ 'base' => '<p>The specified stack instance doesn\'t exist.</p>', 'refs' => [], ], 'StackInstanceStatus' => [ 'base' => NULL, 'refs' => [ 'StackInstance$Status' => '<p>The status of the stack instance, in terms of its synchronization with its associated stack set.</p> <ul> <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> and <code>DeleteStackInstances</code> operations. You might need to clean up the stack manually.</p> </li> <li> <p> <code>OUTDATED</code>: The stack isn\'t currently up to date with the stack set because:</p> <ul> <li> <p>The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation. </p> </li> <li> <p>The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated. </p> </li> </ul> </li> <li> <p> <code>CURRENT</code>: The stack is currently up to date with the stack set.</p> </li> </ul>', 'StackInstanceSummary$Status' => '<p>The status of the stack instance, in terms of its synchronization with its associated stack set.</p> <ul> <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> and <code>DeleteStackInstances</code> operations. You might need to clean up the stack manually.</p> </li> <li> <p> <code>OUTDATED</code>: The stack isn\'t currently up to date with the stack set because:</p> <ul> <li> <p>The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation. </p> </li> <li> <p>The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated. </p> </li> </ul> </li> <li> <p> <code>CURRENT</code>: The stack is currently up to date with the stack set.</p> </li> </ul>', ], ], 'StackInstanceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStackInstancesOutput$Summaries' => '<p>A list of <code>StackInstanceSummary</code> structures that contain information about the specified stack instances.</p>', ], ], 'StackInstanceSummary' => [ 'base' => '<p>The structure that contains summary information about a stack instance.</p>', 'refs' => [ 'StackInstanceSummaries$member' => NULL, ], ], 'StackName' => [ 'base' => NULL, 'refs' => [ 'CancelUpdateStackInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack.</p>', 'ChangeSetSummary$StackName' => '<p>The name of the stack with which the change set is associated.</p>', 'CreateStackInput$StackName' => '<p>The name that is associated with the stack. The name must be unique in the region in which you are creating the stack.</p> <note> <p>A stack name can contain only alphanumeric characters (case sensitive) and hyphens. It must start with an alphabetic character and cannot be longer than 128 characters.</p> </note>', 'DeleteStackInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack.</p>', 'DescribeChangeSetOutput$StackName' => '<p>The name of the stack that is associated with the change set.</p>', 'DescribeStackEventsInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack, which are not always interchangeable:</p> <ul> <li> <p>Running stacks: You can specify either the stack\'s name or its unique stack ID.</p> </li> <li> <p>Deleted stacks: You must specify the unique stack ID.</p> </li> </ul> <p>Default: There is no default value.</p>', 'DescribeStackResourceInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack, which are not always interchangeable:</p> <ul> <li> <p>Running stacks: You can specify either the stack\'s name or its unique stack ID.</p> </li> <li> <p>Deleted stacks: You must specify the unique stack ID.</p> </li> </ul> <p>Default: There is no default value.</p>', 'DescribeStackResourcesInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack, which are not always interchangeable:</p> <ul> <li> <p>Running stacks: You can specify either the stack\'s name or its unique stack ID.</p> </li> <li> <p>Deleted stacks: You must specify the unique stack ID.</p> </li> </ul> <p>Default: There is no default value.</p> <p>Required: Conditional. If you do not specify <code>StackName</code>, you must specify <code>PhysicalResourceId</code>.</p>', 'DescribeStacksInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack, which are not always interchangeable:</p> <ul> <li> <p>Running stacks: You can specify either the stack\'s name or its unique stack ID.</p> </li> <li> <p>Deleted stacks: You must specify the unique stack ID.</p> </li> </ul> <p>Default: There is no default value.</p>', 'GetStackPolicyInput$StackName' => '<p>The name or unique stack ID that is associated with the stack whose policy you want to get.</p>', 'GetTemplateInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack, which are not always interchangeable:</p> <ul> <li> <p>Running stacks: You can specify either the stack\'s name or its unique stack ID.</p> </li> <li> <p>Deleted stacks: You must specify the unique stack ID.</p> </li> </ul> <p>Default: There is no default value.</p>', 'Imports$member' => NULL, 'ListStackResourcesInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack, which are not always interchangeable:</p> <ul> <li> <p>Running stacks: You can specify either the stack\'s name or its unique stack ID.</p> </li> <li> <p>Deleted stacks: You must specify the unique stack ID.</p> </li> </ul> <p>Default: There is no default value.</p>', 'SetStackPolicyInput$StackName' => '<p>The name or unique stack ID that you want to associate a policy with.</p>', 'Stack$StackName' => '<p>The name associated with the stack.</p>', 'StackEvent$StackName' => '<p>The name associated with a stack.</p>', 'StackResource$StackName' => '<p>The name associated with the stack.</p>', 'StackResourceDetail$StackName' => '<p>The name associated with the stack.</p>', 'StackSummary$StackName' => '<p>The name associated with the stack.</p>', 'UpdateStackInput$StackName' => '<p>The name or unique stack ID of the stack to update.</p>', ], ], 'StackNameOrId' => [ 'base' => NULL, 'refs' => [ 'ContinueUpdateRollbackInput$StackName' => '<p>The name or the unique ID of the stack that you want to continue rolling back.</p> <note> <p>Don\'t specify the name of a nested stack (a stack that was created by using the <code>AWS::CloudFormation::Stack</code> resource). Instead, use this operation on the parent stack (the stack that contains the <code>AWS::CloudFormation::Stack</code> resource).</p> </note>', 'CreateChangeSetInput$StackName' => '<p>The name or the unique ID of the stack for which you are creating a change set. AWS CloudFormation generates the change set by comparing this stack\'s information with the information that you submit, such as a modified template or different parameter input values.</p>', 'DeleteChangeSetInput$StackName' => '<p>If you specified the name of a change set to delete, specify the stack name or ID (ARN) that is associated with it.</p>', 'DescribeChangeSetInput$StackName' => '<p>If you specified the name of a change set, specify the stack name or ID (ARN) of the change set you want to describe.</p>', 'ExecuteChangeSetInput$StackName' => '<p>If you specified the name of a change set, specify the stack name or ID (ARN) that is associated with the change set you want to execute.</p>', 'GetTemplateSummaryInput$StackName' => '<p>The name or the stack ID that is associated with the stack, which are not always interchangeable. For running stacks, you can specify either the stack\'s name or its unique stack ID. For deleted stack, you must specify the unique stack ID.</p> <p>Conditional: You must specify only one of the following parameters: <code>StackName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.</p>', 'ListChangeSetsInput$StackName' => '<p>The name or the Amazon Resource Name (ARN) of the stack for which you want to list change sets.</p>', 'SignalResourceInput$StackName' => '<p>The stack name or unique stack ID that includes the resource that you want to signal.</p>', ], ], 'StackPolicyBody' => [ 'base' => NULL, 'refs' => [ 'CreateStackInput$StackPolicyBody' => '<p>Structure containing the stack policy body. For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates to Stack Resources</a> in the <i>AWS CloudFormation User Guide</i>. You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p>', 'GetStackPolicyOutput$StackPolicyBody' => '<p>Structure containing the stack policy body. (For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates to Stack Resources</a> in the AWS CloudFormation User Guide.)</p>', 'SetStackPolicyInput$StackPolicyBody' => '<p>Structure containing the stack policy body. For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates to Stack Resources</a> in the AWS CloudFormation User Guide. You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p>', 'UpdateStackInput$StackPolicyBody' => '<p>Structure containing a new stack policy body. You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p> <p>You might update the stack policy, for example, in order to protect a new resource that you created during a stack update. If you do not specify a stack policy, the current policy that is associated with the stack is unchanged.</p>', ], ], 'StackPolicyDuringUpdateBody' => [ 'base' => NULL, 'refs' => [ 'UpdateStackInput$StackPolicyDuringUpdateBody' => '<p>Structure containing the temporary overriding stack policy body. You can specify either the <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but not both.</p> <p>If you want to update protected resources, specify a temporary overriding stack policy during this update. If you do not specify a stack policy, the current policy that is associated with the stack will be used.</p>', ], ], 'StackPolicyDuringUpdateURL' => [ 'base' => NULL, 'refs' => [ 'UpdateStackInput$StackPolicyDuringUpdateURL' => '<p>Location of a file containing the temporary overriding stack policy. The URL must point to a policy (max size: 16KB) located in an S3 bucket in the same region as the stack. You can specify either the <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but not both.</p> <p>If you want to update protected resources, specify a temporary overriding stack policy during this update. If you do not specify a stack policy, the current policy that is associated with the stack will be used.</p>', ], ], 'StackPolicyURL' => [ 'base' => NULL, 'refs' => [ 'CreateStackInput$StackPolicyURL' => '<p>Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB) located in an S3 bucket in the same region as the stack. You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p>', 'SetStackPolicyInput$StackPolicyURL' => '<p>Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB) located in an S3 bucket in the same region as the stack. You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p>', 'UpdateStackInput$StackPolicyURL' => '<p>Location of a file containing the updated stack policy. The URL must point to a policy (max size: 16KB) located in an S3 bucket in the same region as the stack. You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p> <p>You might update the stack policy, for example, in order to protect a new resource that you created during a stack update. If you do not specify a stack policy, the current policy that is associated with the stack is unchanged.</p>', ], ], 'StackResource' => [ 'base' => '<p>The StackResource data type.</p>', 'refs' => [ 'StackResources$member' => NULL, ], ], 'StackResourceDetail' => [ 'base' => '<p>Contains detailed information about the specified stack resource.</p>', 'refs' => [ 'DescribeStackResourceOutput$StackResourceDetail' => '<p>A <code>StackResourceDetail</code> structure containing the description of the specified resource in the specified stack.</p>', ], ], 'StackResourceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStackResourcesOutput$StackResourceSummaries' => '<p>A list of <code>StackResourceSummary</code> structures.</p>', ], ], 'StackResourceSummary' => [ 'base' => '<p>Contains high-level information about the specified stack resource.</p>', 'refs' => [ 'StackResourceSummaries$member' => NULL, ], ], 'StackResources' => [ 'base' => NULL, 'refs' => [ 'DescribeStackResourcesOutput$StackResources' => '<p>A list of <code>StackResource</code> structures.</p>', ], ], 'StackSet' => [ 'base' => '<p>A structure that contains information about a stack set. A stack set enables you to provision stacks into AWS accounts and across regions by using a single CloudFormation template. In the stack set, you specify the template to use, as well as any parameters and capabilities that the template requires. </p>', 'refs' => [ 'DescribeStackSetOutput$StackSet' => '<p>The specified stack set.</p>', ], ], 'StackSetId' => [ 'base' => NULL, 'refs' => [ 'CreateStackSetOutput$StackSetId' => '<p>The ID of the stack set that you\'re creating.</p>', 'StackInstance$StackSetId' => '<p>The name or unique ID of the stack set that the stack instance is associated with.</p>', 'StackInstanceSummary$StackSetId' => '<p>The name or unique ID of the stack set that the stack instance is associated with.</p>', 'StackSet$StackSetId' => '<p>The ID of the stack set.</p>', 'StackSetOperation$StackSetId' => '<p>The ID of the stack set.</p>', 'StackSetSummary$StackSetId' => '<p>The ID of the stack set.</p>', ], ], 'StackSetName' => [ 'base' => NULL, 'refs' => [ 'CreateStackInstancesInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to create stack instances from.</p>', 'CreateStackSetInput$StackSetName' => '<p>The name to associate with the stack set. The name must be unique in the region where you create your stack set.</p> <note> <p>A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an alphabetic character and can\'t be longer than 128 characters.</p> </note>', 'DeleteStackInstancesInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to delete stack instances for.</p>', 'DeleteStackSetInput$StackSetName' => '<p>The name or unique ID of the stack set that you\'re deleting. You can obtain this value by running <a>ListStackSets</a>.</p>', 'DescribeStackInstanceInput$StackSetName' => '<p>The name or the unique stack ID of the stack set that you want to get stack instance information for.</p>', 'DescribeStackSetInput$StackSetName' => '<p>The name or unique ID of the stack set whose description you want.</p>', 'DescribeStackSetOperationInput$StackSetName' => '<p>The name or the unique stack ID of the stack set for the stack operation.</p>', 'ListStackInstancesInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to list stack instances for.</p>', 'ListStackSetOperationResultsInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to get operation results for.</p>', 'ListStackSetOperationsInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to get operation summaries for.</p>', 'StackSet$StackSetName' => '<p>The name that\'s associated with the stack set.</p>', 'StackSetSummary$StackSetName' => '<p>The name of the stack set.</p>', 'StopStackSetOperationInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to stop the operation for.</p>', 'UpdateStackSetInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to update.</p>', ], ], 'StackSetNameOrId' => [ 'base' => NULL, 'refs' => [ 'GetTemplateSummaryInput$StackSetName' => '<p>The name or unique ID of the stack set from which the stack was created.</p>', ], ], 'StackSetNotEmptyException' => [ 'base' => '<p>You can\'t yet delete this stack set, because it still contains one or more stack instances. Delete all stack instances from the stack set before deleting the stack set.</p>', 'refs' => [], ], 'StackSetNotFoundException' => [ 'base' => '<p>The specified stack set doesn\'t exist.</p>', 'refs' => [], ], 'StackSetOperation' => [ 'base' => '<p>The structure that contains information about a stack set operation. </p>', 'refs' => [ 'DescribeStackSetOperationOutput$StackSetOperation' => '<p>The specified stack set operation.</p>', ], ], 'StackSetOperationAction' => [ 'base' => NULL, 'refs' => [ 'StackSetOperation$Action' => '<p>The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete operations affect only the specified stack set instances that are associated with the specified stack set. Update operations affect both the stack set itself, as well as <i>all</i> associated stack set instances.</p>', 'StackSetOperationSummary$Action' => '<p>The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete operations affect only the specified stack instances that are associated with the specified stack set. Update operations affect both the stack set itself as well as <i>all</i> associated stack set instances.</p>', ], ], 'StackSetOperationPreferences' => [ 'base' => '<p>The user-specified preferences for how AWS CloudFormation performs a stack set operation.</p>', 'refs' => [ 'CreateStackInstancesInput$OperationPreferences' => '<p>Preferences for how AWS CloudFormation performs this stack set operation.</p>', 'DeleteStackInstancesInput$OperationPreferences' => '<p>Preferences for how AWS CloudFormation performs this stack set operation.</p>', 'StackSetOperation$OperationPreferences' => '<p>The preferences for how AWS CloudFormation performs this stack set operation.</p>', 'UpdateStackSetInput$OperationPreferences' => '<p>Preferences for how AWS CloudFormation performs this stack set operation.</p>', ], ], 'StackSetOperationResultStatus' => [ 'base' => NULL, 'refs' => [ 'StackSetOperationResultSummary$Status' => '<p>The result status of the stack set operation for the given account in the given region.</p> <ul> <li> <p> <code>CANCELLED</code>: The operation in the specified account and region has been cancelled. This is either because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation has been exceeded.</p> </li> <li> <p> <code>FAILED</code>: The operation in the specified account and region failed. </p> <p>If the stack set operation fails in enough accounts within a region, the failure tolerance for the stack set operation as a whole might be exceeded. </p> </li> <li> <p> <code>RUNNING</code>: The operation in the specified account and region is currently in progress.</p> </li> <li> <p> <code>PENDING</code>: The operation in the specified account and region has yet to start. </p> </li> <li> <p> <code>SUCCEEDED</code>: The operation in the specified account and region completed successfully.</p> </li> </ul>', ], ], 'StackSetOperationResultSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStackSetOperationResultsOutput$Summaries' => '<p>A list of <code>StackSetOperationResultSummary</code> structures that contain information about the specified operation results, for accounts and regions that are included in the operation.</p>', ], ], 'StackSetOperationResultSummary' => [ 'base' => '<p>The structure that contains information about a specified operation\'s results for a given account in a given region.</p>', 'refs' => [ 'StackSetOperationResultSummaries$member' => NULL, ], ], 'StackSetOperationStatus' => [ 'base' => NULL, 'refs' => [ 'StackSetOperation$Status' => '<p>The status of the operation. </p> <ul> <li> <p> <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that you\'ve set for an operation is applied for each region during stack create and update operations. If the number of failed stacks within a region exceeds the failure tolerance, the status of the operation in the region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and AWS CloudFormation cancels the operation in any remaining regions.</p> </li> <li> <p> <code>RUNNING</code>: The operation is currently being performed.</p> </li> <li> <p> <code>STOPPED</code>: The user has cancelled the operation.</p> </li> <li> <p> <code>STOPPING</code>: The operation is in the process of stopping, at user request. </p> </li> <li> <p> <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.</p> </li> </ul>', 'StackSetOperationSummary$Status' => '<p>The overall status of the operation.</p> <ul> <li> <p> <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that you\'ve set for an operation is applied for each region during stack create and update operations. If the number of failed stacks within a region exceeds the failure tolerance, the status of the operation in the region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and AWS CloudFormation cancels the operation in any remaining regions.</p> </li> <li> <p> <code>RUNNING</code>: The operation is currently being performed.</p> </li> <li> <p> <code>STOPPED</code>: The user has cancelled the operation.</p> </li> <li> <p> <code>STOPPING</code>: The operation is in the process of stopping, at user request. </p> </li> <li> <p> <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.</p> </li> </ul>', ], ], 'StackSetOperationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStackSetOperationsOutput$Summaries' => '<p>A list of <code>StackSetOperationSummary</code> structures that contain summary information about operations for the specified stack set.</p>', ], ], 'StackSetOperationSummary' => [ 'base' => '<p>The structures that contain summary information about the specified operation.</p>', 'refs' => [ 'StackSetOperationSummaries$member' => NULL, ], ], 'StackSetStatus' => [ 'base' => NULL, 'refs' => [ 'ListStackSetsInput$Status' => '<p>The status of the stack sets that you want to get summary information about.</p>', 'StackSet$Status' => '<p>The status of the stack set.</p>', 'StackSetSummary$Status' => '<p>The status of the stack set.</p>', ], ], 'StackSetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStackSetsOutput$Summaries' => '<p>A list of <code>StackSetSummary</code> structures that contain information about the user\'s stack sets.</p>', ], ], 'StackSetSummary' => [ 'base' => '<p>The structures that contain summary information about the specified stack set.</p>', 'refs' => [ 'StackSetSummaries$member' => NULL, ], ], 'StackStatus' => [ 'base' => NULL, 'refs' => [ 'Stack$StackStatus' => '<p>Current status of the stack.</p>', 'StackStatusFilter$member' => NULL, 'StackSummary$StackStatus' => '<p>The current status of the stack.</p>', ], ], 'StackStatusFilter' => [ 'base' => NULL, 'refs' => [ 'ListStacksInput$StackStatusFilter' => '<p>Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter of the <a>Stack</a> data type.</p>', ], ], 'StackStatusReason' => [ 'base' => NULL, 'refs' => [ 'Stack$StackStatusReason' => '<p>Success/failure message associated with the stack status.</p>', 'StackSummary$StackStatusReason' => '<p>Success/Failure message associated with the stack status.</p>', ], ], 'StackSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStacksOutput$StackSummaries' => '<p>A list of <code>StackSummary</code> structures containing information about the specified stacks.</p>', ], ], 'StackSummary' => [ 'base' => '<p>The StackSummary Data Type</p>', 'refs' => [ 'StackSummaries$member' => NULL, ], ], 'Stacks' => [ 'base' => NULL, 'refs' => [ 'DescribeStacksOutput$Stacks' => '<p>A list of stack structures.</p>', ], ], 'StageList' => [ 'base' => NULL, 'refs' => [ 'GetTemplateOutput$StagesAvailable' => '<p>The stage of the template that you can retrieve. For stacks, the <code>Original</code> and <code>Processed</code> templates are always available. For change sets, the <code>Original</code> template is always available. After AWS CloudFormation finishes creating the change set, the <code>Processed</code> template becomes available.</p>', ], ], 'StaleRequestException' => [ 'base' => '<p>Another operation has been performed on this stack set since the specified operation was performed. </p>', 'refs' => [], ], 'StopStackSetOperationInput' => [ 'base' => NULL, 'refs' => [], ], 'StopStackSetOperationOutput' => [ 'base' => NULL, 'refs' => [], ], 'Tag' => [ 'base' => '<p>The Tag type enables you to specify a key-value pair that can be used to store information about an AWS CloudFormation stack.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p> <i>Required</i>. A string used to identify this tag. You can specify a maximum of 128 characters for a tag key. Tags owned by Amazon Web Services (AWS) have the reserved prefix: <code>aws:</code>.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p> <i>Required</i>. A string containing the value for this tag. You can specify a maximum of 256 characters for a tag value.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$Tags' => '<p>Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to resources in the stack. You can specify a maximum of 50 tags.</p>', 'CreateStackInput$Tags' => '<p>Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the resources created in the stack. A maximum number of 50 tags can be specified.</p>', 'CreateStackSetInput$Tags' => '<p>The key-value pairs to associate with this stack set and the stacks created from it. AWS CloudFormation also propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can be specified.</p> <p>If you specify tags as part of a <code>CreateStackSet</code> action, AWS CloudFormation checks to see if you have the required IAM permission to tag resources. If you don\'t, the entire <code>CreateStackSet</code> action fails with an <code>access denied</code> error, and the stack set is not created.</p>', 'DescribeChangeSetOutput$Tags' => '<p>If you execute the change set, the tags that will be associated with the stack.</p>', 'Stack$Tags' => '<p>A list of <code>Tag</code>s that specify information about the stack.</p>', 'StackSet$Tags' => '<p>A list of tags that specify information about the stack set. A maximum number of 50 tags can be specified.</p>', 'UpdateStackInput$Tags' => '<p>Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to supported resources in the stack. You can specify a maximum number of 50 tags.</p> <p>If you don\'t specify this parameter, AWS CloudFormation doesn\'t modify the stack\'s tags. If you specify an empty value, AWS CloudFormation removes all associated tags.</p>', 'UpdateStackSetInput$Tags' => '<p>The key-value pairs to associate with this stack set and the stacks created from it. AWS CloudFormation also propagates these tags to supported resources that are created in the stacks. You can specify a maximum number of 50 tags.</p> <p>If you specify tags for this parameter, those tags replace any list of tags that are currently associated with this stack set. This means:</p> <ul> <li> <p>If you don\'t specify this parameter, AWS CloudFormation doesn\'t modify the stack\'s tags. </p> </li> <li> <p>If you specify <i>any</i> tags using this parameter, you must specify <i>all</i> the tags that you want associated with this stack set, even tags you\'ve specifed before (for example, when creating the stack set or during a previous update of the stack set.). Any tags that you don\'t include in the updated list of tags are removed from the stack set, and therefore from the stacks and resources as well. </p> </li> <li> <p>If you specify an empty value, AWS CloudFormation removes all currently associated tags.</p> </li> </ul> <p>If you specify new tags as part of an <code>UpdateStackSet</code> action, AWS CloudFormation checks to see if you have the required IAM permission to tag resources. If you omit tags that are currently associated with the stack set from the list of tags you specify, AWS CloudFormation assumes that you want to remove those tags from the stack set, and checks to see if you have permission to untag resources. If you don\'t have the necessary permission(s), the entire <code>UpdateStackSet</code> action fails with an <code>access denied</code> error, and the stack set is not updated.</p>', ], ], 'TemplateBody' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$TemplateBody' => '<p>A structure that contains the body of the revised template, with a minimum length of 1 byte and a maximum length of 51,200 bytes. AWS CloudFormation generates the change set by comparing this template with the template of the stack that you specified.</p> <p>Conditional: You must specify only <code>TemplateBody</code> or <code>TemplateURL</code>.</p>', 'CreateStackInput$TemplateBody' => '<p>Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code> parameter, but not both.</p>', 'CreateStackSetInput$TemplateBody' => '<p>The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.</p>', 'EstimateTemplateCostInput$TemplateBody' => '<p>Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. (For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.)</p> <p>Conditional: You must pass <code>TemplateBody</code> or <code>TemplateURL</code>. If both are passed, only <code>TemplateBody</code> is used.</p>', 'GetTemplateOutput$TemplateBody' => '<p>Structure containing the template body. (For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.)</p> <p>AWS CloudFormation returns the same template that was used when the stack was created.</p>', 'GetTemplateSummaryInput$TemplateBody' => '<p>Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. For more information about templates, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify only one of the following parameters: <code>StackName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.</p>', 'StackSet$TemplateBody' => '<p>The structure that contains the body of the template that was used to create or update the stack set.</p>', 'UpdateStackInput$TemplateBody' => '<p>Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. (For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.)</p> <p>Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>, <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.</p>', 'UpdateStackSetInput$TemplateBody' => '<p>The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.</p>', 'ValidateTemplateInput$TemplateBody' => '<p>Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed, only <code>TemplateBody</code> is used.</p>', ], ], 'TemplateDescription' => [ 'base' => NULL, 'refs' => [ 'StackSummary$TemplateDescription' => '<p>The template description of the template used to create the stack.</p>', ], ], 'TemplateParameter' => [ 'base' => '<p>The TemplateParameter data type.</p>', 'refs' => [ 'TemplateParameters$member' => NULL, ], ], 'TemplateParameters' => [ 'base' => NULL, 'refs' => [ 'ValidateTemplateOutput$Parameters' => '<p>A list of <code>TemplateParameter</code> structures.</p>', ], ], 'TemplateStage' => [ 'base' => NULL, 'refs' => [ 'GetTemplateInput$TemplateStage' => '<p>For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get the user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation has processed all transforms, specify <code>Processed</code>. </p> <p>If the template doesn\'t include transforms, <code>Original</code> and <code>Processed</code> return the same template. By default, AWS CloudFormation specifies <code>Original</code>. </p>', 'StageList$member' => NULL, ], ], 'TemplateURL' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$TemplateURL' => '<p>The location of the file that contains the revised template. The URL must point to a template (max size: 460,800 bytes) that is located in an S3 bucket. AWS CloudFormation generates the change set by comparing this template with the stack that you specified.</p> <p>Conditional: You must specify only <code>TemplateBody</code> or <code>TemplateURL</code>.</p>', 'CreateStackInput$TemplateURL' => '<p>Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more information, go to the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code> parameter, but not both.</p>', 'CreateStackSetInput$TemplateURL' => '<p>The location of the file that contains the template body. The URL must point to a template (maximum size: 460,800 bytes) that\'s located in an Amazon S3 bucket. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.</p>', 'EstimateTemplateCostInput$TemplateURL' => '<p>Location of file containing the template body. The URL must point to a template that is located in an Amazon S3 bucket. For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed, only <code>TemplateBody</code> is used.</p>', 'GetTemplateSummaryInput$TemplateURL' => '<p>Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more information about templates, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify only one of the following parameters: <code>StackName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.</p>', 'UpdateStackInput$TemplateURL' => '<p>Location of file containing the template body. The URL must point to a template that is located in an Amazon S3 bucket. For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>, <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.</p>', 'UpdateStackSetInput$TemplateURL' => '<p>The location of the file that contains the template body. The URL must point to a template (maximum size: 460,800 bytes) that is located in an Amazon S3 bucket. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true. </p>', 'ValidateTemplateInput$TemplateURL' => '<p>Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more information, go to <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed, only <code>TemplateBody</code> is used.</p>', ], ], 'TimeoutMinutes' => [ 'base' => NULL, 'refs' => [ 'CreateStackInput$TimeoutInMinutes' => '<p>The amount of time that can pass before the stack status becomes CREATE_FAILED; if <code>DisableRollback</code> is not set or is set to <code>false</code>, the stack will be rolled back.</p>', 'Stack$TimeoutInMinutes' => '<p>The amount of time within which stack creation should complete.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'StackEvent$Timestamp' => '<p>Time the status was updated.</p>', 'StackResource$Timestamp' => '<p>Time the status was updated.</p>', 'StackResourceDetail$LastUpdatedTimestamp' => '<p>Time the status was updated.</p>', 'StackResourceSummary$LastUpdatedTimestamp' => '<p>Time the status was updated.</p>', 'StackSetOperation$CreationTimestamp' => '<p>The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because AWS CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested regions, before actually creating the first stacks.</p>', 'StackSetOperation$EndTimestamp' => '<p>The time at which the stack set operation ended, across all accounts and regions specified. Note that this doesn\'t necessarily mean that the stack set operation was successful, or even attempted, in each account or region.</p>', 'StackSetOperationSummary$CreationTimestamp' => '<p>The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because AWS CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested regions, before actually creating the first stacks.</p>', 'StackSetOperationSummary$EndTimestamp' => '<p>The time at which the stack set operation ended, across all accounts and regions specified. Note that this doesn\'t necessarily mean that the stack set operation was successful, or even attempted, in each account or region.</p>', ], ], 'TokenAlreadyExistsException' => [ 'base' => '<p>A client request token already exists.</p>', 'refs' => [], ], 'TransformName' => [ 'base' => NULL, 'refs' => [ 'TransformsList$member' => NULL, ], ], 'TransformsList' => [ 'base' => NULL, 'refs' => [ 'GetTemplateSummaryOutput$DeclaredTransforms' => '<p>A list of the transforms that are declared in the template.</p>', 'ValidateTemplateOutput$DeclaredTransforms' => '<p>A list of the transforms that are declared in the template.</p>', ], ], 'UpdateStackInput' => [ 'base' => '<p>The input for an <a>UpdateStack</a> action.</p>', 'refs' => [], ], 'UpdateStackOutput' => [ 'base' => '<p>The output for an <a>UpdateStack</a> action.</p>', 'refs' => [], ], 'UpdateStackSetInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStackSetOutput' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'EstimateTemplateCostOutput$Url' => '<p>An AWS Simple Monthly Calculator URL with a query string that describes the resources required to run the template.</p>', ], ], 'UsePreviousTemplate' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$UsePreviousTemplate' => '<p>Whether to reuse the template that is associated with the stack to create the change set.</p>', 'UpdateStackInput$UsePreviousTemplate' => '<p>Reuse the existing template that is associated with the stack that you are updating.</p> <p>Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>, <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.</p>', 'UpdateStackSetInput$UsePreviousTemplate' => '<p>Use the existing template that\'s associated with the stack set that you\'re updating.</p> <p>Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true. </p>', ], ], 'UsePreviousValue' => [ 'base' => NULL, 'refs' => [ 'Parameter$UsePreviousValue' => '<p>During a stack update, use the existing parameter value that the stack is using for a given parameter key. If you specify <code>true</code>, do not specify a parameter value.</p>', ], ], 'ValidateTemplateInput' => [ 'base' => '<p>The input for <a>ValidateTemplate</a> action.</p>', 'refs' => [], ], 'ValidateTemplateOutput' => [ 'base' => '<p>The output for <a>ValidateTemplate</a> action.</p>', 'refs' => [], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'GetTemplateSummaryOutput$Version' => '<p>The AWS template format version, which identifies the capabilities of the template.</p>', ], ], ],];
