<?php
// This file was auto-generated from sdk-root/src/data/codedeploy/2014-10-06/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS CodeDeploy</fullname> <p>AWS CodeDeploy is a deployment service that automates application deployments to Amazon EC2 instances or on-premises instances running in your own facility.</p> <p>You can deploy a nearly unlimited variety of application content, such as code, web and configuration files, executables, packages, scripts, multimedia files, and so on. AWS CodeDeploy can deploy application content stored in Amazon S3 buckets, GitHub repositories, or Bitbucket repositories. You do not need to make changes to your existing code before you can use AWS CodeDeploy.</p> <p>AWS CodeDeploy makes it easier for you to rapidly release new features, helps you avoid downtime during application deployment, and handles the complexity of updating your applications, without many of the risks associated with error-prone manual deployments.</p> <p> <b>AWS CodeDeploy Components</b> </p> <p>Use the information in this guide to help you work with the following AWS CodeDeploy components:</p> <ul> <li> <p> <b>Application</b>: A name that uniquely identifies the application you want to deploy. AWS CodeDeploy uses this name, which functions as a container, to ensure the correct combination of revision, deployment configuration, and deployment group are referenced during a deployment.</p> </li> <li> <p> <b>Deployment group</b>: A set of individual instances. A deployment group contains individually tagged instances, Amazon EC2 instances in Auto Scaling groups, or both. </p> </li> <li> <p> <b>Deployment configuration</b>: A set of deployment rules and deployment success and failure conditions used by AWS CodeDeploy during a deployment.</p> </li> <li> <p> <b>Deployment</b>: The process, and the components involved in the process, of installing content on one or more instances. </p> </li> <li> <p> <b>Application revisions</b>: An archive file containing source content—source code, web pages, executable files, and deployment scripts—along with an application specification file (AppSpec file). Revisions are stored in Amazon S3 buckets or GitHub repositories. For Amazon S3, a revision is uniquely identified by its Amazon S3 object key and its ETag, version, or both. For GitHub, a revision is uniquely identified by its commit ID.</p> </li> </ul> <p>This guide also contains information to help you get details about the instances in your deployments and to make on-premises instances available for AWS CodeDeploy deployments.</p> <p> <b>AWS CodeDeploy Information Resources</b> </p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy User Guide</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/codedeploy/latest/APIReference/">AWS CodeDeploy API Reference Guide</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/cli/latest/reference/deploy/index.html">AWS CLI Reference for AWS CodeDeploy</a> </p> </li> <li> <p> <a href="https://forums.aws.amazon.com/forum.jspa?forumID=179">AWS CodeDeploy Developer Forum</a> </p> </li> </ul>', 'operations' => [ 'AddTagsToOnPremisesInstances' => '<p>Adds tags to on-premises instances.</p>', 'BatchGetApplicationRevisions' => '<p>Gets information about one or more application revisions.</p>', 'BatchGetApplications' => '<p>Gets information about one or more applications.</p>', 'BatchGetDeploymentGroups' => '<p>Gets information about one or more deployment groups.</p>', 'BatchGetDeploymentInstances' => '<p>Gets information about one or more instance that are part of a deployment group.</p>', 'BatchGetDeployments' => '<p>Gets information about one or more deployments.</p>', 'BatchGetOnPremisesInstances' => '<p>Gets information about one or more on-premises instances.</p>', 'ContinueDeployment' => '<p>For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can start as soon as all instances have a status of Ready.) </p>', 'CreateApplication' => '<p>Creates an application.</p>', 'CreateDeployment' => '<p>Deploys an application revision through the specified deployment group.</p>', 'CreateDeploymentConfig' => '<p>Creates a deployment configuration.</p>', 'CreateDeploymentGroup' => '<p>Creates a deployment group to which application revisions will be deployed.</p>', 'DeleteApplication' => '<p>Deletes an application.</p>', 'DeleteDeploymentConfig' => '<p>Deletes a deployment configuration.</p> <note> <p>A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be deleted.</p> </note>', 'DeleteDeploymentGroup' => '<p>Deletes a deployment group.</p>', 'DeregisterOnPremisesInstance' => '<p>Deregisters an on-premises instance.</p>', 'GetApplication' => '<p>Gets information about an application.</p>', 'GetApplicationRevision' => '<p>Gets information about an application revision.</p>', 'GetDeployment' => '<p>Gets information about a deployment.</p>', 'GetDeploymentConfig' => '<p>Gets information about a deployment configuration.</p>', 'GetDeploymentGroup' => '<p>Gets information about a deployment group.</p>', 'GetDeploymentInstance' => '<p>Gets information about an instance as part of a deployment.</p>', 'GetOnPremisesInstance' => '<p>Gets information about an on-premises instance.</p>', 'ListApplicationRevisions' => '<p>Lists information about revisions for an application.</p>', 'ListApplications' => '<p>Lists the applications registered with the applicable IAM user or AWS account.</p>', 'ListDeploymentConfigs' => '<p>Lists the deployment configurations with the applicable IAM user or AWS account.</p>', 'ListDeploymentGroups' => '<p>Lists the deployment groups for an application registered with the applicable IAM user or AWS account.</p>', 'ListDeploymentInstances' => '<p>Lists the instance for a deployment associated with the applicable IAM user or AWS account.</p>', 'ListDeployments' => '<p>Lists the deployments in a deployment group for an application registered with the applicable IAM user or AWS account.</p>', 'ListGitHubAccountTokenNames' => '<p>Lists the names of stored connections to GitHub accounts.</p>', 'ListOnPremisesInstances' => '<p>Gets a list of names for one or more on-premises instances.</p> <p>Unless otherwise specified, both registered and deregistered on-premises instance names will be listed. To list only registered or deregistered on-premises instance names, use the registration status parameter.</p>', 'RegisterApplicationRevision' => '<p>Registers with AWS CodeDeploy a revision for the specified application.</p>', 'RegisterOnPremisesInstance' => '<p>Registers an on-premises instance.</p> <note> <p>Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.</p> </note>', 'RemoveTagsFromOnPremisesInstances' => '<p>Removes one or more tags from one or more on-premises instances.</p>', 'SkipWaitTimeForInstanceTermination' => '<p>In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after the traffic routing is completed.</p>', 'StopDeployment' => '<p>Attempts to stop an ongoing deployment.</p>', 'UpdateApplication' => '<p>Changes the name of an application.</p>', 'UpdateDeploymentGroup' => '<p>Changes information about a deployment group.</p>', ], 'shapes' => [ 'AddTagsToOnPremisesInstancesInput' => [ 'base' => '<p>Represents the input of, and adds tags to, an on-premises instance operation.</p>', 'refs' => [], ], 'AdditionalDeploymentStatusInfo' => [ 'base' => NULL, 'refs' => [ 'DeploymentInfo$additionalDeploymentStatusInfo' => '<p>Provides information about the results of a deployment, such as whether instances in the original environment in a blue/green deployment were not terminated.</p>', ], ], 'Alarm' => [ 'base' => '<p>Information about an alarm.</p>', 'refs' => [ 'AlarmList$member' => NULL, ], ], 'AlarmConfiguration' => [ 'base' => '<p>Information about alarms associated with the deployment group.</p>', 'refs' => [ 'CreateDeploymentGroupInput$alarmConfiguration' => '<p>Information to add about Amazon CloudWatch alarms when the deployment group is created.</p>', 'DeploymentGroupInfo$alarmConfiguration' => '<p>A list of alarms associated with the deployment group.</p>', 'UpdateDeploymentGroupInput$alarmConfiguration' => '<p>Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.</p>', ], ], 'AlarmList' => [ 'base' => NULL, 'refs' => [ 'AlarmConfiguration$alarms' => '<p>A list of alarms configured for the deployment group. A maximum of 10 alarms can be added to a deployment group.</p>', ], ], 'AlarmName' => [ 'base' => NULL, 'refs' => [ 'Alarm$name' => '<p>The name of the alarm. Maximum length is 255 characters. Each alarm name can be used only once in a list of alarms.</p>', ], ], 'AlarmsLimitExceededException' => [ 'base' => '<p>The maximum number of alarms for a deployment group (10) was exceeded.</p>', 'refs' => [], ], 'ApplicationAlreadyExistsException' => [ 'base' => '<p>An application with the specified name already exists with the applicable IAM user or AWS account.</p>', 'refs' => [], ], 'ApplicationDoesNotExistException' => [ 'base' => '<p>The application does not exist with the applicable IAM user or AWS account.</p>', 'refs' => [], ], 'ApplicationId' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$applicationId' => '<p>The application ID.</p>', 'CreateApplicationOutput$applicationId' => '<p>A unique application ID.</p>', ], ], 'ApplicationInfo' => [ 'base' => '<p>Information about an application.</p>', 'refs' => [ 'ApplicationsInfoList$member' => NULL, 'GetApplicationOutput$application' => '<p>Information about the application.</p>', ], ], 'ApplicationLimitExceededException' => [ 'base' => '<p>More applications were attempted to be created than are allowed.</p>', 'refs' => [], ], 'ApplicationName' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$applicationName' => '<p>The application name.</p>', 'ApplicationsList$member' => NULL, 'BatchGetApplicationRevisionsInput$applicationName' => '<p>The name of an AWS CodeDeploy application about which to get revision information.</p>', 'BatchGetApplicationRevisionsOutput$applicationName' => '<p>The name of the application that corresponds to the revisions.</p>', 'BatchGetDeploymentGroupsInput$applicationName' => '<p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>', 'CreateApplicationInput$applicationName' => '<p>The name of the application. This name must be unique with the applicable IAM user or AWS account.</p>', 'CreateDeploymentGroupInput$applicationName' => '<p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>', 'CreateDeploymentInput$applicationName' => '<p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>', 'DeleteApplicationInput$applicationName' => '<p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>', 'DeleteDeploymentGroupInput$applicationName' => '<p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>', 'DeploymentGroupInfo$applicationName' => '<p>The application name.</p>', 'DeploymentInfo$applicationName' => '<p>The application name.</p>', 'GetApplicationInput$applicationName' => '<p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>', 'GetApplicationRevisionInput$applicationName' => '<p>The name of the application that corresponds to the revision.</p>', 'GetApplicationRevisionOutput$applicationName' => '<p>The name of the application that corresponds to the revision.</p>', 'GetDeploymentGroupInput$applicationName' => '<p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>', 'ListApplicationRevisionsInput$applicationName' => '<p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>', 'ListDeploymentGroupsInput$applicationName' => '<p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>', 'ListDeploymentGroupsOutput$applicationName' => '<p>The application name.</p>', 'ListDeploymentsInput$applicationName' => '<p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>', 'RegisterApplicationRevisionInput$applicationName' => '<p>The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.</p>', 'UpdateApplicationInput$applicationName' => '<p>The current name of the application you want to change.</p>', 'UpdateApplicationInput$newApplicationName' => '<p>The new name to give the application.</p>', 'UpdateDeploymentGroupInput$applicationName' => '<p>The application name corresponding to the deployment group to update.</p>', ], ], 'ApplicationNameRequiredException' => [ 'base' => '<p>The minimum number of required application names was not specified.</p>', 'refs' => [], ], 'ApplicationRevisionSortBy' => [ 'base' => NULL, 'refs' => [ 'ListApplicationRevisionsInput$sortBy' => '<p>The column name to use to sort the list results:</p> <ul> <li> <p>registerTime: Sort by the time the revisions were registered with AWS CodeDeploy.</p> </li> <li> <p>firstUsedTime: Sort by the time the revisions were first used in a deployment.</p> </li> <li> <p>lastUsedTime: Sort by the time the revisions were last used in a deployment.</p> </li> </ul> <p>If not specified or set to null, the results will be returned in an arbitrary order.</p>', ], ], 'ApplicationsInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetApplicationsOutput$applicationsInfo' => '<p>Information about the applications.</p>', ], ], 'ApplicationsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetApplicationsInput$applicationNames' => '<p>A list of application names separated by spaces.</p>', 'ListApplicationsOutput$applications' => '<p>A list of application names.</p>', ], ], 'AutoRollbackConfiguration' => [ 'base' => '<p>Information about a configuration for automatically rolling back to a previous version of an application revision when a deployment doesn\'t complete successfully.</p>', 'refs' => [ 'CreateDeploymentGroupInput$autoRollbackConfiguration' => '<p>Configuration information for an automatic rollback that is added when a deployment group is created.</p>', 'CreateDeploymentInput$autoRollbackConfiguration' => '<p>Configuration information for an automatic rollback that is added when a deployment is created.</p>', 'DeploymentGroupInfo$autoRollbackConfiguration' => '<p>Information about the automatic rollback configuration associated with the deployment group.</p>', 'DeploymentInfo$autoRollbackConfiguration' => '<p>Information about the automatic rollback configuration associated with the deployment.</p>', 'UpdateDeploymentGroupInput$autoRollbackConfiguration' => '<p>Information for an automatic rollback configuration that is added or changed when a deployment group is updated.</p>', ], ], 'AutoRollbackEvent' => [ 'base' => NULL, 'refs' => [ 'AutoRollbackEventsList$member' => NULL, ], ], 'AutoRollbackEventsList' => [ 'base' => NULL, 'refs' => [ 'AutoRollbackConfiguration$events' => '<p>The event type or types that trigger a rollback.</p>', ], ], 'AutoScalingGroup' => [ 'base' => '<p>Information about an Auto Scaling group.</p>', 'refs' => [ 'AutoScalingGroupList$member' => NULL, ], ], 'AutoScalingGroupHook' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$hook' => '<p>An Auto Scaling lifecycle event hook name.</p>', ], ], 'AutoScalingGroupList' => [ 'base' => NULL, 'refs' => [ 'DeleteDeploymentGroupOutput$hooksNotCleanedUp' => '<p>If the output contains no data, and the corresponding deployment group contained at least one Auto Scaling group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks from the Amazon EC2 instances in the Auto Scaling group. If the output contains data, AWS CodeDeploy could not remove some Auto Scaling lifecycle event hooks from the Amazon EC2 instances in the Auto Scaling group.</p>', 'DeploymentGroupInfo$autoScalingGroups' => '<p>A list of associated Auto Scaling groups.</p>', 'UpdateDeploymentGroupOutput$hooksNotCleanedUp' => '<p>If the output contains no data, and the corresponding deployment group contained at least one Auto Scaling group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks from the AWS account. If the output contains data, AWS CodeDeploy could not remove some Auto Scaling lifecycle event hooks from the AWS account.</p>', ], ], 'AutoScalingGroupName' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$name' => '<p>The Auto Scaling group name.</p>', 'AutoScalingGroupNameList$member' => NULL, ], ], 'AutoScalingGroupNameList' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$autoScalingGroups' => '<p>A list of associated Auto Scaling groups.</p>', 'TargetInstances$autoScalingGroups' => '<p>The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green deployment.</p>', 'UpdateDeploymentGroupInput$autoScalingGroups' => '<p>The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any Auto Scaling group names.</p>', ], ], 'BatchGetApplicationRevisionsInput' => [ 'base' => '<p>Represents the input of a BatchGetApplicationRevisions operation.</p>', 'refs' => [], ], 'BatchGetApplicationRevisionsOutput' => [ 'base' => '<p>Represents the output of a BatchGetApplicationRevisions operation.</p>', 'refs' => [], ], 'BatchGetApplicationsInput' => [ 'base' => '<p>Represents the input of a BatchGetApplications operation.</p>', 'refs' => [], ], 'BatchGetApplicationsOutput' => [ 'base' => '<p>Represents the output of a BatchGetApplications operation.</p>', 'refs' => [], ], 'BatchGetDeploymentGroupsInput' => [ 'base' => '<p>Represents the input of a BatchGetDeploymentGroups operation.</p>', 'refs' => [], ], 'BatchGetDeploymentGroupsOutput' => [ 'base' => '<p>Represents the output of a BatchGetDeploymentGroups operation.</p>', 'refs' => [], ], 'BatchGetDeploymentInstancesInput' => [ 'base' => '<p>Represents the input of a BatchGetDeploymentInstances operation.</p>', 'refs' => [], ], 'BatchGetDeploymentInstancesOutput' => [ 'base' => '<p>Represents the output of a BatchGetDeploymentInstances operation.</p>', 'refs' => [], ], 'BatchGetDeploymentsInput' => [ 'base' => '<p>Represents the input of a BatchGetDeployments operation.</p>', 'refs' => [], ], 'BatchGetDeploymentsOutput' => [ 'base' => '<p>Represents the output of a BatchGetDeployments operation.</p>', 'refs' => [], ], 'BatchGetOnPremisesInstancesInput' => [ 'base' => '<p>Represents the input of a BatchGetOnPremisesInstances operation.</p>', 'refs' => [], ], 'BatchGetOnPremisesInstancesOutput' => [ 'base' => '<p>Represents the output of a BatchGetOnPremisesInstances operation.</p>', 'refs' => [], ], 'BatchLimitExceededException' => [ 'base' => '<p>The maximum number of names or IDs allowed for this request (100) was exceeded.</p>', 'refs' => [], ], 'BlueGreenDeploymentConfiguration' => [ 'base' => '<p>Information about blue/green deployment options for a deployment group.</p>', 'refs' => [ 'CreateDeploymentGroupInput$blueGreenDeploymentConfiguration' => '<p>Information about blue/green deployment options for a deployment group.</p>', 'DeploymentGroupInfo$blueGreenDeploymentConfiguration' => '<p>Information about blue/green deployment options for a deployment group.</p>', 'DeploymentInfo$blueGreenDeploymentConfiguration' => '<p>Information about blue/green deployment options for this deployment.</p>', 'UpdateDeploymentGroupInput$blueGreenDeploymentConfiguration' => '<p>Information about blue/green deployment options for a deployment group.</p>', ], ], 'BlueInstanceTerminationOption' => [ 'base' => '<p>Information about whether instances in the original environment are terminated when a blue/green deployment is successful.</p>', 'refs' => [ 'BlueGreenDeploymentConfiguration$terminateBlueInstancesOnDeploymentSuccess' => '<p>Information about whether to terminate instances in the original fleet during a blue/green deployment.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AlarmConfiguration$enabled' => '<p>Indicates whether the alarm configuration is enabled.</p>', 'AlarmConfiguration$ignorePollAlarmFailure' => '<p>Indicates whether a deployment should continue if information about the current state of alarms cannot be retrieved from Amazon CloudWatch. The default value is false.</p> <ul> <li> <p>true: The deployment will proceed even if alarm status information can\'t be retrieved from Amazon CloudWatch.</p> </li> <li> <p>false: The deployment will stop if alarm status information can\'t be retrieved from Amazon CloudWatch.</p> </li> </ul>', 'ApplicationInfo$linkedToGitHub' => '<p>True if the user has authenticated with GitHub for the specified application; otherwise, false.</p>', 'AutoRollbackConfiguration$enabled' => '<p>Indicates whether a defined automatic rollback configuration is currently enabled.</p>', 'CreateDeploymentInput$ignoreApplicationStopFailures' => '<p>If set to true, then if the deployment causes the ApplicationStop deployment lifecycle event to an instance to fail, the deployment to that instance will not be considered to have failed at that point and will continue on to the BeforeInstall deployment lifecycle event.</p> <p>If set to false or not specified, then if the deployment causes the ApplicationStop deployment lifecycle event to fail to an instance, the deployment to that instance will stop, and the deployment to that instance will be considered to have failed.</p>', 'CreateDeploymentInput$updateOutdatedInstancesOnly' => '<p>Indicates whether to deploy to all instances or only to instances that are not running the latest application revision.</p>', 'DeploymentInfo$ignoreApplicationStopFailures' => '<p>If true, then if the deployment causes the ApplicationStop deployment lifecycle event to an instance to fail, the deployment to that instance will not be considered to have failed at that point and will continue on to the BeforeInstall deployment lifecycle event.</p> <p>If false or not specified, then if the deployment causes the ApplicationStop deployment lifecycle event to an instance to fail, the deployment to that instance will stop, and the deployment to that instance will be considered to have failed.</p>', 'DeploymentInfo$updateOutdatedInstancesOnly' => '<p>Indicates whether only instances that are not running the latest application revision are to be deployed to.</p>', 'DeploymentInfo$instanceTerminationWaitTimeStarted' => '<p>Indicates whether the wait period set for the termination of instances in the original environment has started. Status is \'false\' if the KEEP_ALIVE option is specified; otherwise, \'true\' as soon as the termination wait period starts.</p>', ], ], 'BucketNameFilterRequiredException' => [ 'base' => '<p>A bucket name is required, but was not provided.</p>', 'refs' => [], ], 'BundleType' => [ 'base' => NULL, 'refs' => [ 'S3Location$bundleType' => '<p>The file type of the application revision. Must be one of the following:</p> <ul> <li> <p>tar: A tar archive file.</p> </li> <li> <p>tgz: A compressed tar archive file.</p> </li> <li> <p>zip: A zip archive file.</p> </li> </ul>', ], ], 'CommitId' => [ 'base' => NULL, 'refs' => [ 'GitHubLocation$commitId' => '<p>The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application revision.</p>', ], ], 'ContinueDeploymentInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateApplicationInput' => [ 'base' => '<p>Represents the input of a CreateApplication operation.</p>', 'refs' => [], ], 'CreateApplicationOutput' => [ 'base' => '<p>Represents the output of a CreateApplication operation.</p>', 'refs' => [], ], 'CreateDeploymentConfigInput' => [ 'base' => '<p>Represents the input of a CreateDeploymentConfig operation.</p>', 'refs' => [], ], 'CreateDeploymentConfigOutput' => [ 'base' => '<p>Represents the output of a CreateDeploymentConfig operation.</p>', 'refs' => [], ], 'CreateDeploymentGroupInput' => [ 'base' => '<p>Represents the input of a CreateDeploymentGroup operation.</p>', 'refs' => [], ], 'CreateDeploymentGroupOutput' => [ 'base' => '<p>Represents the output of a CreateDeploymentGroup operation.</p>', 'refs' => [], ], 'CreateDeploymentInput' => [ 'base' => '<p>Represents the input of a CreateDeployment operation.</p>', 'refs' => [], ], 'CreateDeploymentOutput' => [ 'base' => '<p>Represents the output of a CreateDeployment operation.</p>', 'refs' => [], ], 'DeleteApplicationInput' => [ 'base' => '<p>Represents the input of a DeleteApplication operation.</p>', 'refs' => [], ], 'DeleteDeploymentConfigInput' => [ 'base' => '<p>Represents the input of a DeleteDeploymentConfig operation.</p>', 'refs' => [], ], 'DeleteDeploymentGroupInput' => [ 'base' => '<p>Represents the input of a DeleteDeploymentGroup operation.</p>', 'refs' => [], ], 'DeleteDeploymentGroupOutput' => [ 'base' => '<p>Represents the output of a DeleteDeploymentGroup operation.</p>', 'refs' => [], ], 'DeploymentAlreadyCompletedException' => [ 'base' => '<p>The deployment is already complete.</p>', 'refs' => [], ], 'DeploymentConfigAlreadyExistsException' => [ 'base' => '<p>A deployment configuration with the specified name already exists with the applicable IAM user or AWS account.</p>', 'refs' => [], ], 'DeploymentConfigDoesNotExistException' => [ 'base' => '<p>The deployment configuration does not exist with the applicable IAM user or AWS account.</p>', 'refs' => [], ], 'DeploymentConfigId' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentConfigOutput$deploymentConfigId' => '<p>A unique deployment configuration ID.</p>', 'DeploymentConfigInfo$deploymentConfigId' => '<p>The deployment configuration ID.</p>', ], ], 'DeploymentConfigInUseException' => [ 'base' => '<p>The deployment configuration is still in use.</p>', 'refs' => [], ], 'DeploymentConfigInfo' => [ 'base' => '<p>Information about a deployment configuration.</p>', 'refs' => [ 'GetDeploymentConfigOutput$deploymentConfigInfo' => '<p>Information about the deployment configuration.</p>', ], ], 'DeploymentConfigLimitExceededException' => [ 'base' => '<p>The deployment configurations limit was exceeded.</p>', 'refs' => [], ], 'DeploymentConfigName' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentConfigInput$deploymentConfigName' => '<p>The name of the deployment configuration to create.</p>', 'CreateDeploymentGroupInput$deploymentConfigName' => '<p>If specified, the deployment configuration name can be either one of the predefined configurations provided with AWS CodeDeploy or a custom deployment configuration that you create by calling the create deployment configuration operation.</p> <p>CodeDeployDefault.OneAtATime is the default deployment configuration. It is used if a configuration isn\'t specified for the deployment or the deployment group.</p> <p>For more information about the predefined deployment configurations in AWS CodeDeploy, see <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Groups in AWS CodeDeploy</a> in the AWS CodeDeploy User Guide.</p>', 'CreateDeploymentInput$deploymentConfigName' => '<p>The name of a deployment configuration associated with the applicable IAM user or AWS account.</p> <p>If not specified, the value configured in the deployment group will be used as the default. If the deployment group does not have a deployment configuration associated with it, then CodeDeployDefault.OneAtATime will be used by default.</p>', 'DeleteDeploymentConfigInput$deploymentConfigName' => '<p>The name of a deployment configuration associated with the applicable IAM user or AWS account.</p>', 'DeploymentConfigInfo$deploymentConfigName' => '<p>The deployment configuration name.</p>', 'DeploymentConfigsList$member' => NULL, 'DeploymentGroupInfo$deploymentConfigName' => '<p>The deployment configuration name.</p>', 'DeploymentInfo$deploymentConfigName' => '<p>The deployment configuration name.</p>', 'GetDeploymentConfigInput$deploymentConfigName' => '<p>The name of a deployment configuration associated with the applicable IAM user or AWS account.</p>', 'UpdateDeploymentGroupInput$deploymentConfigName' => '<p>The replacement deployment configuration name to use, if you want to change it.</p>', ], ], 'DeploymentConfigNameRequiredException' => [ 'base' => '<p>The deployment configuration name was not specified.</p>', 'refs' => [], ], 'DeploymentConfigsList' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentConfigsOutput$deploymentConfigsList' => '<p>A list of deployment configurations, including built-in configurations such as CodeDeployDefault.OneAtATime.</p>', ], ], 'DeploymentCreator' => [ 'base' => NULL, 'refs' => [ 'DeploymentInfo$creator' => '<p>The means by which the deployment was created:</p> <ul> <li> <p>user: A user created the deployment.</p> </li> <li> <p>autoscaling: Auto Scaling created the deployment.</p> </li> <li> <p>codeDeployRollback: A rollback process created the deployment.</p> </li> </ul>', ], ], 'DeploymentDoesNotExistException' => [ 'base' => '<p>The deployment does not exist with the applicable IAM user or AWS account.</p>', 'refs' => [], ], 'DeploymentGroupAlreadyExistsException' => [ 'base' => '<p>A deployment group with the specified name already exists with the applicable IAM user or AWS account.</p>', 'refs' => [], ], 'DeploymentGroupDoesNotExistException' => [ 'base' => '<p>The named deployment group does not exist with the applicable IAM user or AWS account.</p>', 'refs' => [], ], 'DeploymentGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupOutput$deploymentGroupId' => '<p>A unique deployment group ID.</p>', 'DeploymentGroupInfo$deploymentGroupId' => '<p>The deployment group ID.</p>', ], ], 'DeploymentGroupInfo' => [ 'base' => '<p>Information about a deployment group.</p>', 'refs' => [ 'DeploymentGroupInfoList$member' => NULL, 'GetDeploymentGroupOutput$deploymentGroupInfo' => '<p>Information about the deployment group.</p>', ], ], 'DeploymentGroupInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentGroupsOutput$deploymentGroupsInfo' => '<p>Information about the deployment groups.</p>', ], ], 'DeploymentGroupLimitExceededException' => [ 'base' => '<p> The deployment groups limit was exceeded.</p>', 'refs' => [], ], 'DeploymentGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$deploymentGroupName' => '<p>The name of a new deployment group for the specified application.</p>', 'CreateDeploymentInput$deploymentGroupName' => '<p>The name of the deployment group.</p>', 'DeleteDeploymentGroupInput$deploymentGroupName' => '<p>The name of an existing deployment group for the specified application.</p>', 'DeploymentGroupInfo$deploymentGroupName' => '<p>The deployment group name.</p>', 'DeploymentGroupsList$member' => NULL, 'DeploymentInfo$deploymentGroupName' => '<p>The deployment group name.</p>', 'GetDeploymentGroupInput$deploymentGroupName' => '<p>The name of an existing deployment group for the specified application.</p>', 'ListDeploymentsInput$deploymentGroupName' => '<p>The name of an existing deployment group for the specified application.</p>', 'UpdateDeploymentGroupInput$currentDeploymentGroupName' => '<p>The current name of the deployment group.</p>', 'UpdateDeploymentGroupInput$newDeploymentGroupName' => '<p>The new name of the deployment group, if you want to change it.</p>', ], ], 'DeploymentGroupNameRequiredException' => [ 'base' => '<p>The deployment group name was not specified.</p>', 'refs' => [], ], 'DeploymentGroupsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentGroupsInput$deploymentGroupNames' => '<p>The deployment groups\' names.</p>', 'GenericRevisionInfo$deploymentGroups' => '<p>The deployment groups for which this is the current target revision.</p>', 'ListDeploymentGroupsOutput$deploymentGroups' => '<p>A list of corresponding deployment group names.</p>', ], ], 'DeploymentId' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentInstancesInput$deploymentId' => '<p>The unique ID of a deployment.</p>', 'ContinueDeploymentInput$deploymentId' => '<p>The deployment ID of the blue/green deployment for which you want to start rerouting traffic to the replacement environment.</p>', 'CreateDeploymentOutput$deploymentId' => '<p>A unique deployment ID.</p>', 'DeploymentInfo$deploymentId' => '<p>The deployment ID.</p>', 'DeploymentsList$member' => NULL, 'GetDeploymentInput$deploymentId' => '<p>A deployment ID associated with the applicable IAM user or AWS account.</p>', 'GetDeploymentInstanceInput$deploymentId' => '<p>The unique ID of a deployment.</p>', 'InstanceSummary$deploymentId' => '<p>The deployment ID.</p>', 'LastDeploymentInfo$deploymentId' => '<p>The deployment ID.</p>', 'ListDeploymentInstancesInput$deploymentId' => '<p>The unique ID of a deployment.</p>', 'RollbackInfo$rollbackDeploymentId' => '<p>The ID of the deployment rollback.</p>', 'RollbackInfo$rollbackTriggeringDeploymentId' => '<p>The deployment ID of the deployment that was underway and triggered a rollback deployment because it failed or was stopped.</p>', 'SkipWaitTimeForInstanceTerminationInput$deploymentId' => '<p>The ID of the blue/green deployment for which you want to skip the instance termination wait time.</p>', 'StopDeploymentInput$deploymentId' => '<p>The unique ID of a deployment.</p>', ], ], 'DeploymentIdRequiredException' => [ 'base' => '<p>At least one deployment ID must be specified.</p>', 'refs' => [], ], 'DeploymentInfo' => [ 'base' => '<p>Information about a deployment.</p>', 'refs' => [ 'DeploymentsInfoList$member' => NULL, 'GetDeploymentOutput$deploymentInfo' => '<p>Information about the deployment.</p>', ], ], 'DeploymentIsNotInReadyStateException' => [ 'base' => '<p>The deployment does not have a status of Ready and can\'t continue yet.</p>', 'refs' => [], ], 'DeploymentLimitExceededException' => [ 'base' => '<p>The number of allowed deployments was exceeded.</p>', 'refs' => [], ], 'DeploymentNotStartedException' => [ 'base' => '<p>The specified deployment has not started.</p>', 'refs' => [], ], 'DeploymentOption' => [ 'base' => NULL, 'refs' => [ 'DeploymentStyle$deploymentOption' => '<p>Indicates whether to route deployment traffic behind a load balancer.</p>', ], ], 'DeploymentOverview' => [ 'base' => '<p>Information about the deployment status of the instances in the deployment.</p>', 'refs' => [ 'DeploymentInfo$deploymentOverview' => '<p>A summary of the deployment status of the instances in the deployment.</p>', ], ], 'DeploymentReadyAction' => [ 'base' => NULL, 'refs' => [ 'DeploymentReadyOption$actionOnTimeout' => '<p>Information about when to reroute traffic from an original environment to a replacement environment in a blue/green deployment.</p> <ul> <li> <p>CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application revision is installed on the instances in the replacement environment.</p> </li> <li> <p>STOP_DEPLOYMENT: Do not register new instances with load balancer unless traffic is rerouted manually. If traffic is not rerouted manually before the end of the specified wait period, the deployment status is changed to Stopped.</p> </li> </ul>', ], ], 'DeploymentReadyOption' => [ 'base' => '<p>Information about how traffic is rerouted to instances in a replacement environment in a blue/green deployment.</p>', 'refs' => [ 'BlueGreenDeploymentConfiguration$deploymentReadyOption' => '<p>Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment.</p>', ], ], 'DeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'DeploymentInfo$status' => '<p>The current state of the deployment as a whole.</p>', 'DeploymentStatusList$member' => NULL, 'LastDeploymentInfo$status' => '<p>The status of the most recent deployment.</p>', ], ], 'DeploymentStatusList' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentsInput$includeOnlyStatuses' => '<p>A subset of deployments to list by status:</p> <ul> <li> <p>Created: Include created deployments in the resulting list.</p> </li> <li> <p>Queued: Include queued deployments in the resulting list.</p> </li> <li> <p>In Progress: Include in-progress deployments in the resulting list.</p> </li> <li> <p>Succeeded: Include successful deployments in the resulting list.</p> </li> <li> <p>Failed: Include failed deployments in the resulting list.</p> </li> <li> <p>Stopped: Include stopped deployments in the resulting list.</p> </li> </ul>', ], ], 'DeploymentStyle' => [ 'base' => '<p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>', 'refs' => [ 'CreateDeploymentGroupInput$deploymentStyle' => '<p>Information about the type of deployment, in-place or blue/green, that you want to run and whether to route deployment traffic behind a load balancer.</p>', 'DeploymentGroupInfo$deploymentStyle' => '<p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>', 'DeploymentInfo$deploymentStyle' => '<p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>', 'UpdateDeploymentGroupInput$deploymentStyle' => '<p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>', ], ], 'DeploymentType' => [ 'base' => NULL, 'refs' => [ 'DeploymentStyle$deploymentType' => '<p>Indicates whether to run an in-place deployment or a blue/green deployment.</p>', ], ], 'DeploymentsInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentsOutput$deploymentsInfo' => '<p>Information about the deployments.</p>', ], ], 'DeploymentsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentsInput$deploymentIds' => '<p>A list of deployment IDs, separated by spaces.</p>', 'ListDeploymentsOutput$deployments' => '<p>A list of deployment IDs.</p>', ], ], 'DeregisterOnPremisesInstanceInput' => [ 'base' => '<p>Represents the input of a DeregisterOnPremisesInstance operation.</p>', 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentInput$description' => '<p>A comment about the deployment.</p>', 'DeploymentInfo$description' => '<p>A comment about the deployment.</p>', 'GenericRevisionInfo$description' => '<p>A comment about the revision.</p>', 'RegisterApplicationRevisionInput$description' => '<p>A comment about the revision.</p>', 'RollbackInfo$rollbackMessage' => '<p>Information describing the status of a deployment rollback; for example, whether the deployment can\'t be rolled back, is in progress, failed, or succeeded. </p>', ], ], 'DescriptionTooLongException' => [ 'base' => '<p>The description is too long.</p>', 'refs' => [], ], 'Diagnostics' => [ 'base' => '<p>Diagnostic information about executable scripts that are part of a deployment.</p>', 'refs' => [ 'LifecycleEvent$diagnostics' => '<p>Diagnostic information about the deployment lifecycle event.</p>', ], ], 'Duration' => [ 'base' => NULL, 'refs' => [ 'BlueInstanceTerminationOption$terminationWaitTimeInMinutes' => '<p>The number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.</p>', 'DeploymentReadyOption$waitTimeInMinutes' => '<p>The number of minutes to wait before the status of a blue/green deployment changed to Stopped if rerouting is not started manually. Applies only to the STOP_DEPLOYMENT option for actionOnTimeout</p>', ], ], 'EC2TagFilter' => [ 'base' => '<p>Information about an EC2 tag filter.</p>', 'refs' => [ 'EC2TagFilterList$member' => NULL, ], ], 'EC2TagFilterList' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$ec2TagFilters' => '<p>The Amazon EC2 tags on which to filter. The deployment group will include EC2 instances with any of the specified tags. Cannot be used in the same call as ec2TagSet.</p>', 'DeploymentGroupInfo$ec2TagFilters' => '<p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags.</p>', 'EC2TagSetList$member' => NULL, 'TargetInstances$tagFilters' => '<p>The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment for a blue/green deployment. Cannot be used in the same call as ec2TagSet.</p>', 'UpdateDeploymentGroupInput$ec2TagFilters' => '<p>The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>', ], ], 'EC2TagFilterType' => [ 'base' => NULL, 'refs' => [ 'EC2TagFilter$Type' => '<p>The tag filter type:</p> <ul> <li> <p>KEY_ONLY: Key only.</p> </li> <li> <p>VALUE_ONLY: Value only.</p> </li> <li> <p>KEY_AND_VALUE: Key and value.</p> </li> </ul>', ], ], 'EC2TagSet' => [ 'base' => '<p>Information about groups of EC2 instance tags.</p>', 'refs' => [ 'CreateDeploymentGroupInput$ec2TagSet' => '<p>Information about groups of tags applied to EC2 instances. The deployment group will include only EC2 instances identified by all the tag groups. Cannot be used in the same call as ec2TagFilters.</p>', 'DeploymentGroupInfo$ec2TagSet' => '<p>Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2 instances identified by all the tag groups. Cannot be used in the same call as ec2TagFilters.</p>', 'TargetInstances$ec2TagSet' => '<p>Information about the groups of EC2 instance tags that an instance must be identified by in order for it to be included in the replacement environment for a blue/green deployment. Cannot be used in the same call as tagFilters.</p>', 'UpdateDeploymentGroupInput$ec2TagSet' => '<p>Information about groups of tags applied to on-premises instances. The deployment group will include only EC2 instances identified by all the tag groups.</p>', ], ], 'EC2TagSetList' => [ 'base' => NULL, 'refs' => [ 'EC2TagSet$ec2TagSetList' => '<p>A list containing other lists of EC2 instance tag groups. In order for an instance to be included in the deployment group, it must be identified by all the tag groups in the list.</p>', ], ], 'ELBInfo' => [ 'base' => '<p>Information about a load balancer in Elastic Load Balancing to use in a deployment. Instances are registered directly with a load balancer, and traffic is routed to the load balancer.</p>', 'refs' => [ 'ELBInfoList$member' => NULL, ], ], 'ELBInfoList' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerInfo$elbInfoList' => '<p>An array containing information about the load balancer to use for load balancing in a deployment. In Elastic Load Balancing, load balancers are used with Classic Load Balancers.</p>', ], ], 'ELBName' => [ 'base' => NULL, 'refs' => [ 'ELBInfo$name' => '<p>For blue/green deployments, the name of the load balancer that will be used to route traffic from original instances to replacement instances in a blue/green deployment. For in-place deployments, the name of the load balancer that instances are deregistered from, so they are not serving traffic during a deployment, and then re-registered with after the deployment completes.</p>', ], ], 'ETag' => [ 'base' => NULL, 'refs' => [ 'S3Location$eTag' => '<p>The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.</p> <p>If the ETag is not specified as an input parameter, ETag validation of the object will be skipped.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'ErrorInformation$code' => '<p>For information about additional error codes, see <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for AWS CodeDeploy</a> in the <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy User Guide</a>.</p> <p>The error code:</p> <ul> <li> <p>APPLICATION_MISSING: The application was missing. This error code will most likely be raised if the application is deleted after the deployment is created but before it is started.</p> </li> <li> <p>DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code will most likely be raised if the deployment group is deleted after the deployment is created but before it is started.</p> </li> <li> <p>HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the instance health constraints specified.</p> </li> <li> <p>HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health constraints specified.</p> </li> <li> <p>IAM_ROLE_MISSING: The service role cannot be accessed.</p> </li> <li> <p>IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.</p> </li> <li> <p>INTERNAL_ERROR: There was an internal error.</p> </li> <li> <p>NO_EC2_SUBSCRIPTION: The calling account is not subscribed to the Amazon EC2 service.</p> </li> <li> <p>NO_INSTANCES: No instance were specified, or no instance can be found.</p> </li> <li> <p>OVER_MAX_INSTANCES: The maximum number of instance was exceeded.</p> </li> <li> <p>THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or more AWS services.</p> </li> <li> <p>TIMEOUT: The deployment has timed out.</p> </li> <li> <p>REVISION_MISSING: The revision ID was missing. This error code will most likely be raised if the revision is deleted after the deployment is created but before it is started.</p> </li> </ul>', ], ], 'ErrorInformation' => [ 'base' => '<p>Information about a deployment error.</p>', 'refs' => [ 'DeploymentInfo$errorInformation' => '<p>Information about any error associated with this deployment.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BatchGetApplicationRevisionsOutput$errorMessage' => '<p>Information about errors that may have occurred during the API call.</p>', 'BatchGetDeploymentGroupsOutput$errorMessage' => '<p>Information about errors that may have occurred during the API call.</p>', 'BatchGetDeploymentInstancesOutput$errorMessage' => '<p>Information about errors that may have occurred during the API call.</p>', 'ErrorInformation$message' => '<p>An accompanying error message.</p>', ], ], 'FileExistsBehavior' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentInput$fileExistsBehavior' => '<p>Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren\'t part of the previous successful deployment.</p> <p>The fileExistsBehavior parameter takes any of the following values:</p> <ul> <li> <p>DISALLOW: The deployment fails. This is also the default behavior if no option is specified.</p> </li> <li> <p>OVERWRITE: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li> <li> <p>RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li> </ul>', 'DeploymentInfo$fileExistsBehavior' => '<p>Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren\'t part of the previous successful deployment.</p> <ul> <li> <p>DISALLOW: The deployment fails. This is also the default behavior if no option is specified.</p> </li> <li> <p>OVERWRITE: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li> <li> <p>RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li> </ul>', ], ], 'GenericRevisionInfo' => [ 'base' => '<p>Information about an application revision.</p>', 'refs' => [ 'GetApplicationRevisionOutput$revisionInfo' => '<p>General information about the revision.</p>', 'RevisionInfo$genericRevisionInfo' => '<p>Information about an application revision, including usage details and associated deployment groups.</p>', ], ], 'GetApplicationInput' => [ 'base' => '<p>Represents the input of a GetApplication operation.</p>', 'refs' => [], ], 'GetApplicationOutput' => [ 'base' => '<p>Represents the output of a GetApplication operation.</p>', 'refs' => [], ], 'GetApplicationRevisionInput' => [ 'base' => '<p>Represents the input of a GetApplicationRevision operation.</p>', 'refs' => [], ], 'GetApplicationRevisionOutput' => [ 'base' => '<p>Represents the output of a GetApplicationRevision operation.</p>', 'refs' => [], ], 'GetDeploymentConfigInput' => [ 'base' => '<p>Represents the input of a GetDeploymentConfig operation.</p>', 'refs' => [], ], 'GetDeploymentConfigOutput' => [ 'base' => '<p>Represents the output of a GetDeploymentConfig operation.</p>', 'refs' => [], ], 'GetDeploymentGroupInput' => [ 'base' => '<p>Represents the input of a GetDeploymentGroup operation.</p>', 'refs' => [], ], 'GetDeploymentGroupOutput' => [ 'base' => '<p>Represents the output of a GetDeploymentGroup operation.</p>', 'refs' => [], ], 'GetDeploymentInput' => [ 'base' => '<p>Represents the input of a GetDeployment operation.</p>', 'refs' => [], ], 'GetDeploymentInstanceInput' => [ 'base' => '<p>Represents the input of a GetDeploymentInstance operation.</p>', 'refs' => [], ], 'GetDeploymentInstanceOutput' => [ 'base' => '<p>Represents the output of a GetDeploymentInstance operation.</p>', 'refs' => [], ], 'GetDeploymentOutput' => [ 'base' => '<p>Represents the output of a GetDeployment operation.</p>', 'refs' => [], ], 'GetOnPremisesInstanceInput' => [ 'base' => '<p>Represents the input of a GetOnPremisesInstance operation.</p>', 'refs' => [], ], 'GetOnPremisesInstanceOutput' => [ 'base' => '<p>Represents the output of a GetOnPremisesInstance operation.</p>', 'refs' => [], ], 'GitHubAccountTokenDoesNotExistException' => [ 'base' => '<p>No GitHub account connection exists with the named specified in the call.</p>', 'refs' => [], ], 'GitHubAccountTokenName' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$gitHubAccountName' => '<p>The name for a connection to a GitHub account.</p>', 'GitHubAccountTokenNameList$member' => NULL, ], ], 'GitHubAccountTokenNameList' => [ 'base' => NULL, 'refs' => [ 'ListGitHubAccountTokenNamesOutput$tokenNameList' => '<p>A list of names of connections to GitHub accounts.</p>', ], ], 'GitHubLocation' => [ 'base' => '<p>Information about the location of application artifacts stored in GitHub.</p>', 'refs' => [ 'RevisionLocation$gitHubLocation' => '<p>Information about the location of application artifacts stored in GitHub.</p>', ], ], 'GreenFleetProvisioningAction' => [ 'base' => NULL, 'refs' => [ 'GreenFleetProvisioningOption$action' => '<p>The method used to add instances to a replacement environment.</p> <ul> <li> <p>DISCOVER_EXISTING: Use instances that already exist or will be created manually.</p> </li> <li> <p>COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create instances in a new Auto Scaling group.</p> </li> </ul>', ], ], 'GreenFleetProvisioningOption' => [ 'base' => '<p>Information about the instances that belong to the replacement environment in a blue/green deployment.</p>', 'refs' => [ 'BlueGreenDeploymentConfiguration$greenFleetProvisioningOption' => '<p>Information about how instances are provisioned for a replacement environment in a blue/green deployment.</p>', ], ], 'IamArnRequiredException' => [ 'base' => '<p>No IAM ARN was included in the request. You must use an IAM session ARN or IAM user ARN in the request.</p>', 'refs' => [], ], 'IamSessionArn' => [ 'base' => NULL, 'refs' => [ 'InstanceInfo$iamSessionArn' => '<p>The ARN of the IAM session associated with the on-premises instance.</p>', 'RegisterOnPremisesInstanceInput$iamSessionArn' => '<p>The ARN of the IAM session to associate with the on-premises instance.</p>', ], ], 'IamSessionArnAlreadyRegisteredException' => [ 'base' => '<p>The request included an IAM session ARN that has already been used to register a different instance.</p>', 'refs' => [], ], 'IamUserArn' => [ 'base' => NULL, 'refs' => [ 'InstanceInfo$iamUserArn' => '<p>The IAM user ARN associated with the on-premises instance.</p>', 'RegisterOnPremisesInstanceInput$iamUserArn' => '<p>The ARN of the IAM user to associate with the on-premises instance.</p>', ], ], 'IamUserArnAlreadyRegisteredException' => [ 'base' => '<p>The specified IAM user ARN is already registered with an on-premises instance.</p>', 'refs' => [], ], 'IamUserArnRequiredException' => [ 'base' => '<p>An IAM user ARN was not specified.</p>', 'refs' => [], ], 'InstanceAction' => [ 'base' => NULL, 'refs' => [ 'BlueInstanceTerminationOption$action' => '<p>The action to take on instances in the original environment after a successful blue/green deployment.</p> <ul> <li> <p>TERMINATE: Instances are terminated after a specified wait time.</p> </li> <li> <p>KEEP_ALIVE: Instances are left running after they are deregistered from the load balancer and removed from the deployment group.</p> </li> </ul>', ], ], 'InstanceArn' => [ 'base' => NULL, 'refs' => [ 'InstanceInfo$instanceArn' => '<p>The ARN of the on-premises instance.</p>', ], ], 'InstanceCount' => [ 'base' => NULL, 'refs' => [ 'DeploymentOverview$Pending' => '<p>The number of instances in the deployment in a pending state.</p>', 'DeploymentOverview$InProgress' => '<p>The number of instances in which the deployment is in progress.</p>', 'DeploymentOverview$Succeeded' => '<p>The number of instances in the deployment to which revisions have been successfully deployed.</p>', 'DeploymentOverview$Failed' => '<p>The number of instances in the deployment in a failed state.</p>', 'DeploymentOverview$Skipped' => '<p>The number of instances in the deployment in a skipped state.</p>', 'DeploymentOverview$Ready' => '<p>The number of instances in a replacement environment ready to receive traffic in a blue/green deployment.</p>', ], ], 'InstanceDoesNotExistException' => [ 'base' => '<p>The specified instance does not exist in the deployment group.</p>', 'refs' => [], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'GetDeploymentInstanceInput$instanceId' => '<p>The unique ID of an instance in the deployment group.</p>', 'InstanceSummary$instanceId' => '<p>The instance ID.</p>', 'InstancesList$member' => NULL, ], ], 'InstanceIdRequiredException' => [ 'base' => '<p>The instance ID was not specified.</p>', 'refs' => [], ], 'InstanceInfo' => [ 'base' => '<p>Information about an on-premises instance.</p>', 'refs' => [ 'GetOnPremisesInstanceOutput$instanceInfo' => '<p>Information about the on-premises instance.</p>', 'InstanceInfoList$member' => NULL, ], ], 'InstanceInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetOnPremisesInstancesOutput$instanceInfos' => '<p>Information about the on-premises instances.</p>', ], ], 'InstanceLimitExceededException' => [ 'base' => '<p>The maximum number of allowed on-premises instances in a single call was exceeded.</p>', 'refs' => [], ], 'InstanceName' => [ 'base' => NULL, 'refs' => [ 'DeregisterOnPremisesInstanceInput$instanceName' => '<p>The name of the on-premises instance to deregister.</p>', 'GetOnPremisesInstanceInput$instanceName' => '<p>The name of the on-premises instance about which to get information.</p>', 'InstanceInfo$instanceName' => '<p>The name of the on-premises instance.</p>', 'InstanceNameList$member' => NULL, 'RegisterOnPremisesInstanceInput$instanceName' => '<p>The name of the on-premises instance to register.</p>', ], ], 'InstanceNameAlreadyRegisteredException' => [ 'base' => '<p>The specified on-premises instance name is already registered.</p>', 'refs' => [], ], 'InstanceNameList' => [ 'base' => NULL, 'refs' => [ 'AddTagsToOnPremisesInstancesInput$instanceNames' => '<p>The names of the on-premises instances to which to add tags.</p>', 'BatchGetOnPremisesInstancesInput$instanceNames' => '<p>The names of the on-premises instances about which to get information.</p>', 'ListOnPremisesInstancesOutput$instanceNames' => '<p>The list of matching on-premises instance names.</p>', 'RemoveTagsFromOnPremisesInstancesInput$instanceNames' => '<p>The names of the on-premises instances from which to remove tags.</p>', ], ], 'InstanceNameRequiredException' => [ 'base' => '<p>An on-premises instance name was not specified.</p>', 'refs' => [], ], 'InstanceNotRegisteredException' => [ 'base' => '<p>The specified on-premises instance is not registered.</p>', 'refs' => [], ], 'InstanceStatus' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusList$member' => NULL, 'InstanceSummary$status' => '<p>The deployment status for this instance:</p> <ul> <li> <p>Pending: The deployment is pending for this instance.</p> </li> <li> <p>In Progress: The deployment is in progress for this instance.</p> </li> <li> <p>Succeeded: The deployment has succeeded for this instance.</p> </li> <li> <p>Failed: The deployment has failed for this instance.</p> </li> <li> <p>Skipped: The deployment has been skipped for this instance.</p> </li> <li> <p>Unknown: The deployment status is unknown for this instance.</p> </li> </ul>', ], ], 'InstanceStatusList' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentInstancesInput$instanceStatusFilter' => '<p>A subset of instances to list by status:</p> <ul> <li> <p>Pending: Include those instance with pending deployments.</p> </li> <li> <p>InProgress: Include those instance where deployments are still in progress.</p> </li> <li> <p>Succeeded: Include those instances with successful deployments.</p> </li> <li> <p>Failed: Include those instance with failed deployments.</p> </li> <li> <p>Skipped: Include those instance with skipped deployments.</p> </li> <li> <p>Unknown: Include those instance with deployments in an unknown state.</p> </li> </ul>', ], ], 'InstanceSummary' => [ 'base' => '<p>Information about an instance in a deployment.</p>', 'refs' => [ 'GetDeploymentInstanceOutput$instanceSummary' => '<p>Information about the instance.</p>', 'InstanceSummaryList$member' => NULL, ], ], 'InstanceSummaryList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentInstancesOutput$instancesSummary' => '<p>Information about the instance.</p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'InstanceSummary$instanceType' => '<p>Information about which environment an instance belongs to in a blue/green deployment.</p> <ul> <li> <p>BLUE: The instance is part of the original environment.</p> </li> <li> <p>GREEN: The instance is part of the replacement environment.</p> </li> </ul>', 'InstanceTypeList$member' => NULL, ], ], 'InstanceTypeList' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentInstancesInput$instanceTypeFilter' => '<p>The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those in the replacement environment ("GREEN"), for which you want to view instance information.</p>', ], ], 'InstancesList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentInstancesInput$instanceIds' => '<p>The unique IDs of instances in the deployment group.</p>', 'ListDeploymentInstancesOutput$instancesList' => '<p>A list of instance IDs.</p>', ], ], 'InvalidAlarmConfigException' => [ 'base' => '<p>The format of the alarm configuration is invalid. Possible causes include:</p> <ul> <li> <p>The alarm list is null.</p> </li> <li> <p>The alarm object is null.</p> </li> <li> <p>The alarm name is empty or null or exceeds the 255 character limit.</p> </li> <li> <p>Two alarms with the same name have been specified.</p> </li> <li> <p>The alarm configuration is enabled but the alarm list is empty.</p> </li> </ul>', 'refs' => [], ], 'InvalidApplicationNameException' => [ 'base' => '<p>The application name was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidAutoRollbackConfigException' => [ 'base' => '<p>The automatic rollback configuration was specified in an invalid format. For example, automatic rollback is enabled but an invalid triggering event type or no event types were listed.</p>', 'refs' => [], ], 'InvalidAutoScalingGroupException' => [ 'base' => '<p>The Auto Scaling group was specified in an invalid format or does not exist.</p>', 'refs' => [], ], 'InvalidBlueGreenDeploymentConfigurationException' => [ 'base' => '<p>The configuration for the blue/green deployment group was provided in an invalid format. For information about deployment configuration format, see <a>CreateDeploymentConfig</a>.</p>', 'refs' => [], ], 'InvalidBucketNameFilterException' => [ 'base' => '<p>The bucket name either doesn\'t exist or was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidDeployedStateFilterException' => [ 'base' => '<p>The deployed state filter was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidDeploymentConfigNameException' => [ 'base' => '<p>The deployment configuration name was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidDeploymentGroupNameException' => [ 'base' => '<p>The deployment group name was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidDeploymentIdException' => [ 'base' => '<p>At least one of the deployment IDs was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidDeploymentInstanceTypeException' => [ 'base' => '<p>An instance type was specified for an in-place deployment. Instance types are supported for blue/green deployments only.</p>', 'refs' => [], ], 'InvalidDeploymentStatusException' => [ 'base' => '<p>The specified deployment status doesn\'t exist or cannot be determined.</p>', 'refs' => [], ], 'InvalidDeploymentStyleException' => [ 'base' => '<p>An invalid deployment style was specified. Valid deployment types include "IN_PLACE" and "BLUE_GREEN". Valid deployment options include "WITH_TRAFFIC_CONTROL" and "WITHOUT_TRAFFIC_CONTROL".</p>', 'refs' => [], ], 'InvalidEC2TagCombinationException' => [ 'base' => '<p>A call was submitted that specified both Ec2TagFilters and Ec2TagSet, but only one of these data types can be used in a single call.</p>', 'refs' => [], ], 'InvalidEC2TagException' => [ 'base' => '<p>The tag was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidFileExistsBehaviorException' => [ 'base' => '<p>An invalid fileExistsBehavior option was specified to determine how AWS CodeDeploy handles files or directories that already exist in a deployment target location but weren\'t part of the previous successful deployment. Valid values include "DISALLOW", "OVERWRITE", and "RETAIN".</p>', 'refs' => [], ], 'InvalidIamSessionArnException' => [ 'base' => '<p>The IAM session ARN was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidIamUserArnException' => [ 'base' => '<p>The IAM user ARN was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidInstanceNameException' => [ 'base' => '<p>The specified on-premises instance name was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidInstanceStatusException' => [ 'base' => '<p>The specified instance status does not exist.</p>', 'refs' => [], ], 'InvalidInstanceTypeException' => [ 'base' => '<p>An invalid instance type was specified for instances in a blue/green deployment. Valid values include "Blue" for an original environment and "Green" for a replacement environment.</p>', 'refs' => [], ], 'InvalidKeyPrefixFilterException' => [ 'base' => '<p>The specified key prefix filter was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidLoadBalancerInfoException' => [ 'base' => '<p>An invalid load balancer name, or no load balancer name, was specified.</p>', 'refs' => [], ], 'InvalidMinimumHealthyHostValueException' => [ 'base' => '<p>The minimum healthy instance value was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The next token was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidOnPremisesTagCombinationException' => [ 'base' => '<p>A call was submitted that specified both OnPremisesTagFilters and OnPremisesTagSet, but only one of these data types can be used in a single call.</p>', 'refs' => [], ], 'InvalidOperationException' => [ 'base' => '<p>An invalid operation was detected.</p>', 'refs' => [], ], 'InvalidRegistrationStatusException' => [ 'base' => '<p>The registration status was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidRevisionException' => [ 'base' => '<p>The revision was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidRoleException' => [ 'base' => '<p>The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the specified service role does not grant the appropriate permissions to Auto Scaling.</p>', 'refs' => [], ], 'InvalidSortByException' => [ 'base' => '<p>The column name to sort by is either not present or was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidSortOrderException' => [ 'base' => '<p>The sort order was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidTagException' => [ 'base' => '<p>The specified tag was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidTagFilterException' => [ 'base' => '<p>The specified tag filter was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidTargetInstancesException' => [ 'base' => '<p>The target instance configuration is invalid. Possible causes include:</p> <ul> <li> <p>Configuration data for target instances was entered for an in-place deployment.</p> </li> <li> <p>The limit of 10 tags for a tag type was exceeded.</p> </li> <li> <p>The combined length of the tag names exceeded the limit. </p> </li> <li> <p>A specified tag is not currently applied to any instances.</p> </li> </ul>', 'refs' => [], ], 'InvalidTimeRangeException' => [ 'base' => '<p>The specified time range was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidTriggerConfigException' => [ 'base' => '<p>The trigger was specified in an invalid format.</p>', 'refs' => [], ], 'Key' => [ 'base' => NULL, 'refs' => [ 'EC2TagFilter$Key' => '<p>The tag filter key.</p>', 'Tag$Key' => '<p>The tag\'s key.</p>', 'TagFilter$Key' => '<p>The on-premises instance tag filter key.</p>', ], ], 'LastDeploymentInfo' => [ 'base' => '<p>Information about the most recent attempted or successful deployment to a deployment group.</p>', 'refs' => [ 'DeploymentGroupInfo$lastSuccessfulDeployment' => '<p>Information about the most recent successful deployment to the deployment group.</p>', 'DeploymentGroupInfo$lastAttemptedDeployment' => '<p>Information about the most recent attempted deployment to the deployment group.</p>', ], ], 'LifecycleErrorCode' => [ 'base' => NULL, 'refs' => [ 'Diagnostics$errorCode' => '<p>The associated error code:</p> <ul> <li> <p>Success: The specified script ran.</p> </li> <li> <p>ScriptMissing: The specified script was not found in the specified location.</p> </li> <li> <p>ScriptNotExecutable: The specified script is not a recognized executable file type.</p> </li> <li> <p>ScriptTimedOut: The specified script did not finish running in the specified time period.</p> </li> <li> <p>ScriptFailed: The specified script failed to run as expected.</p> </li> <li> <p>UnknownError: The specified script did not run for an unknown reason.</p> </li> </ul>', ], ], 'LifecycleEvent' => [ 'base' => '<p>Information about a deployment lifecycle event.</p>', 'refs' => [ 'LifecycleEventList$member' => NULL, ], ], 'LifecycleEventList' => [ 'base' => NULL, 'refs' => [ 'InstanceSummary$lifecycleEvents' => '<p>A list of lifecycle events for this instance.</p>', ], ], 'LifecycleEventName' => [ 'base' => NULL, 'refs' => [ 'LifecycleEvent$lifecycleEventName' => '<p>The deployment lifecycle event name, such as ApplicationStop, BeforeInstall, AfterInstall, ApplicationStart, or ValidateService.</p>', ], ], 'LifecycleEventStatus' => [ 'base' => NULL, 'refs' => [ 'LifecycleEvent$status' => '<p>The deployment lifecycle event status:</p> <ul> <li> <p>Pending: The deployment lifecycle event is pending.</p> </li> <li> <p>InProgress: The deployment lifecycle event is in progress.</p> </li> <li> <p>Succeeded: The deployment lifecycle event ran successfully.</p> </li> <li> <p>Failed: The deployment lifecycle event has failed.</p> </li> <li> <p>Skipped: The deployment lifecycle event has been skipped.</p> </li> <li> <p>Unknown: The deployment lifecycle event is unknown.</p> </li> </ul>', ], ], 'LifecycleHookLimitExceededException' => [ 'base' => '<p>The limit for lifecycle hooks was exceeded.</p>', 'refs' => [], ], 'LifecycleMessage' => [ 'base' => NULL, 'refs' => [ 'Diagnostics$message' => '<p>The message associated with the error.</p>', ], ], 'ListApplicationRevisionsInput' => [ 'base' => '<p>Represents the input of a ListApplicationRevisions operation.</p>', 'refs' => [], ], 'ListApplicationRevisionsOutput' => [ 'base' => '<p>Represents the output of a ListApplicationRevisions operation.</p>', 'refs' => [], ], 'ListApplicationsInput' => [ 'base' => '<p>Represents the input of a ListApplications operation.</p>', 'refs' => [], ], 'ListApplicationsOutput' => [ 'base' => '<p>Represents the output of a ListApplications operation.</p>', 'refs' => [], ], 'ListDeploymentConfigsInput' => [ 'base' => '<p>Represents the input of a ListDeploymentConfigs operation.</p>', 'refs' => [], ], 'ListDeploymentConfigsOutput' => [ 'base' => '<p>Represents the output of a ListDeploymentConfigs operation.</p>', 'refs' => [], ], 'ListDeploymentGroupsInput' => [ 'base' => '<p>Represents the input of a ListDeploymentGroups operation.</p>', 'refs' => [], ], 'ListDeploymentGroupsOutput' => [ 'base' => '<p>Represents the output of a ListDeploymentGroups operation.</p>', 'refs' => [], ], 'ListDeploymentInstancesInput' => [ 'base' => '<p>Represents the input of a ListDeploymentInstances operation.</p>', 'refs' => [], ], 'ListDeploymentInstancesOutput' => [ 'base' => '<p>Represents the output of a ListDeploymentInstances operation.</p>', 'refs' => [], ], 'ListDeploymentsInput' => [ 'base' => '<p>Represents the input of a ListDeployments operation.</p>', 'refs' => [], ], 'ListDeploymentsOutput' => [ 'base' => '<p>Represents the output of a ListDeployments operation.</p>', 'refs' => [], ], 'ListGitHubAccountTokenNamesInput' => [ 'base' => '<p>Represents the input of a ListGitHubAccountTokenNames operation.</p>', 'refs' => [], ], 'ListGitHubAccountTokenNamesOutput' => [ 'base' => '<p>Represents the output of a ListGitHubAccountTokenNames operation.</p>', 'refs' => [], ], 'ListOnPremisesInstancesInput' => [ 'base' => '<p>Represents the input of a ListOnPremisesInstances operation.</p>', 'refs' => [], ], 'ListOnPremisesInstancesOutput' => [ 'base' => '<p>Represents the output of list on-premises instances operation.</p>', 'refs' => [], ], 'ListStateFilterAction' => [ 'base' => NULL, 'refs' => [ 'ListApplicationRevisionsInput$deployed' => '<p>Whether to list revisions based on whether the revision is the target revision of an deployment group:</p> <ul> <li> <p>include: List revisions that are target revisions of a deployment group.</p> </li> <li> <p>exclude: Do not list revisions that are target revisions of a deployment group.</p> </li> <li> <p>ignore: List all revisions.</p> </li> </ul>', ], ], 'LoadBalancerInfo' => [ 'base' => '<p>Information about the Elastic Load Balancing load balancer or target group used in a deployment.</p>', 'refs' => [ 'CreateDeploymentGroupInput$loadBalancerInfo' => '<p>Information about the load balancer used in a deployment.</p>', 'DeploymentGroupInfo$loadBalancerInfo' => '<p>Information about the load balancer to use in a deployment.</p>', 'DeploymentInfo$loadBalancerInfo' => '<p>Information about the load balancer used in the deployment.</p>', 'UpdateDeploymentGroupInput$loadBalancerInfo' => '<p>Information about the load balancer used in a deployment.</p>', ], ], 'LogTail' => [ 'base' => NULL, 'refs' => [ 'Diagnostics$logTail' => '<p>The last portion of the diagnostic log.</p> <p>If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic log.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'StopDeploymentOutput$statusMessage' => '<p>An accompanying status message.</p>', ], ], 'MinimumHealthyHosts' => [ 'base' => '<p>Information about minimum healthy instance.</p>', 'refs' => [ 'CreateDeploymentConfigInput$minimumHealthyHosts' => '<p>The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.</p> <p>The type parameter takes either of the following values:</p> <ul> <li> <p>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</p> </li> <li> <p>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.</p> </li> </ul> <p>The value parameter takes an integer.</p> <p>For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.</p>', 'DeploymentConfigInfo$minimumHealthyHosts' => '<p>Information about the number or percentage of minimum healthy instance.</p>', ], ], 'MinimumHealthyHostsType' => [ 'base' => NULL, 'refs' => [ 'MinimumHealthyHosts$type' => '<p>The minimum healthy instance type:</p> <ul> <li> <p>HOST_COUNT: The minimum number of healthy instance as an absolute value.</p> </li> <li> <p>FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance in the deployment.</p> </li> </ul> <p>In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances at a time. The deployment will be successful if six or more instances are deployed to successfully; otherwise, the deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance at a time. The deployment will be successful if four or more instance are deployed to successfully; otherwise, the deployment fails.</p> <note> <p>In a call to the get deployment configuration operation, CodeDeployDefault.OneAtATime will return a minimum healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy will try to ensure that all instances but one are kept in a healthy state during the deployment. Although this allows one instance at a time to be taken offline for a new deployment, it also means that if the deployment to the last instance fails, the overall deployment still succeeds.</p> </note> <p>For more information, see <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance Health</a> in the <i>AWS CodeDeploy User Guide</i>.</p>', ], ], 'MinimumHealthyHostsValue' => [ 'base' => NULL, 'refs' => [ 'MinimumHealthyHosts$value' => '<p>The minimum healthy instance value.</p>', ], ], 'MultipleIamArnsProvidedException' => [ 'base' => '<p>Both an IAM user ARN and an IAM session ARN were included in the request. Use only one ARN type.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListApplicationRevisionsInput$nextToken' => '<p>An identifier returned from the previous list application revisions call. It can be used to return the next set of applications in the list.</p>', 'ListApplicationRevisionsOutput$nextToken' => '<p>If a large amount of information is returned, an identifier will also be returned. It can be used in a subsequent list application revisions call to return the next set of application revisions in the list.</p>', 'ListApplicationsInput$nextToken' => '<p>An identifier returned from the previous list applications call. It can be used to return the next set of applications in the list.</p>', 'ListApplicationsOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list applications call to return the next set of applications, will also be returned. in the list.</p>', 'ListDeploymentConfigsInput$nextToken' => '<p>An identifier returned from the previous list deployment configurations call. It can be used to return the next set of deployment configurations in the list. </p>', 'ListDeploymentConfigsOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list deployment configurations call to return the next set of deployment configurations in the list.</p>', 'ListDeploymentGroupsInput$nextToken' => '<p>An identifier returned from the previous list deployment groups call. It can be used to return the next set of deployment groups in the list.</p>', 'ListDeploymentGroupsOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list deployment groups call to return the next set of deployment groups in the list.</p>', 'ListDeploymentInstancesInput$nextToken' => '<p>An identifier returned from the previous list deployment instances call. It can be used to return the next set of deployment instances in the list.</p>', 'ListDeploymentInstancesOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list deployment instances call to return the next set of deployment instances in the list.</p>', 'ListDeploymentsInput$nextToken' => '<p>An identifier returned from the previous list deployments call. It can be used to return the next set of deployments in the list.</p>', 'ListDeploymentsOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list deployments call to return the next set of deployments in the list.</p>', 'ListGitHubAccountTokenNamesInput$nextToken' => '<p>An identifier returned from the previous ListGitHubAccountTokenNames call. It can be used to return the next set of names in the list. </p>', 'ListGitHubAccountTokenNamesOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent ListGitHubAccountTokenNames call to return the next set of names in the list. </p>', 'ListOnPremisesInstancesInput$nextToken' => '<p>An identifier returned from the previous list on-premises instances call. It can be used to return the next set of on-premises instances in the list.</p>', 'ListOnPremisesInstancesOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list on-premises instances call to return the next set of on-premises instances in the list.</p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'StopDeploymentInput$autoRollbackEnabled' => '<p>Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to the previous version of the application revision.</p>', ], ], 'OnPremisesTagSet' => [ 'base' => '<p>Information about groups of on-premises instance tags.</p>', 'refs' => [ 'CreateDeploymentGroupInput$onPremisesTagSet' => '<p>Information about groups of tags applied to on-premises instances. The deployment group will include only on-premises instances identified by all the tag groups. Cannot be used in the same call as onPremisesInstanceTagFilters.</p>', 'DeploymentGroupInfo$onPremisesTagSet' => '<p>Information about groups of tags applied to an on-premises instance. The deployment group includes only on-premises instances identified by all the tag groups. Cannot be used in the same call as onPremisesInstanceTagFilters.</p>', 'UpdateDeploymentGroupInput$onPremisesTagSet' => '<p>Information about an on-premises instance tag set. The deployment group will include only on-premises instances identified by all the tag groups.</p>', ], ], 'OnPremisesTagSetList' => [ 'base' => NULL, 'refs' => [ 'OnPremisesTagSet$onPremisesTagSetList' => '<p>A list containing other lists of on-premises instance tag groups. In order for an instance to be included in the deployment group, it must be identified by all the tag groups in the list.</p>', ], ], 'RegisterApplicationRevisionInput' => [ 'base' => '<p>Represents the input of a RegisterApplicationRevision operation.</p>', 'refs' => [], ], 'RegisterOnPremisesInstanceInput' => [ 'base' => '<p>Represents the input of the register on-premises instance operation.</p>', 'refs' => [], ], 'RegistrationStatus' => [ 'base' => NULL, 'refs' => [ 'ListOnPremisesInstancesInput$registrationStatus' => '<p>The registration status of the on-premises instances:</p> <ul> <li> <p>Deregistered: Include deregistered on-premises instances in the resulting list.</p> </li> <li> <p>Registered: Include registered on-premises instances in the resulting list.</p> </li> </ul>', ], ], 'RemoveTagsFromOnPremisesInstancesInput' => [ 'base' => '<p>Represents the input of a RemoveTagsFromOnPremisesInstances operation.</p>', 'refs' => [], ], 'Repository' => [ 'base' => NULL, 'refs' => [ 'GitHubLocation$repository' => '<p>The GitHub account and repository pair that stores a reference to the commit that represents the bundled artifacts for the application revision. </p> <p>Specified as account/repository.</p>', ], ], 'ResourceValidationException' => [ 'base' => '<p>The specified resource could not be validated.</p>', 'refs' => [], ], 'RevisionDoesNotExistException' => [ 'base' => '<p>The named revision does not exist with the applicable IAM user or AWS account.</p>', 'refs' => [], ], 'RevisionInfo' => [ 'base' => '<p>Information about an application revision.</p>', 'refs' => [ 'RevisionInfoList$member' => NULL, ], ], 'RevisionInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetApplicationRevisionsOutput$revisions' => '<p>Additional information about the revisions, including the type and location.</p>', ], ], 'RevisionLocation' => [ 'base' => '<p>Information about the location of an application revision.</p>', 'refs' => [ 'CreateDeploymentInput$revision' => '<p>The type and location of the revision to deploy.</p>', 'DeploymentGroupInfo$targetRevision' => '<p>Information about the deployment group\'s target revision, including type and location.</p>', 'DeploymentInfo$previousRevision' => '<p>Information about the application revision that was deployed to the deployment group before the most recent successful deployment.</p>', 'DeploymentInfo$revision' => '<p>Information about the location of stored application artifacts and the service from which to retrieve them.</p>', 'GetApplicationRevisionInput$revision' => '<p>Information about the application revision to get, including type and location.</p>', 'GetApplicationRevisionOutput$revision' => '<p>Additional information about the revision, including type and location.</p>', 'RegisterApplicationRevisionInput$revision' => '<p>Information about the application revision to register, including type and location.</p>', 'RevisionInfo$revisionLocation' => '<p>Information about the location and type of an application revision.</p>', 'RevisionLocationList$member' => NULL, ], ], 'RevisionLocationList' => [ 'base' => NULL, 'refs' => [ 'BatchGetApplicationRevisionsInput$revisions' => '<p>Information to get about the application revisions, including type and location.</p>', 'ListApplicationRevisionsOutput$revisions' => '<p>A list of locations that contain the matching revisions.</p>', ], ], 'RevisionLocationType' => [ 'base' => NULL, 'refs' => [ 'RevisionLocation$revisionType' => '<p>The type of application revision:</p> <ul> <li> <p>S3: An application revision stored in Amazon S3.</p> </li> <li> <p>GitHub: An application revision stored in GitHub.</p> </li> </ul>', ], ], 'RevisionRequiredException' => [ 'base' => '<p>The revision ID was not specified.</p>', 'refs' => [], ], 'Role' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$serviceRoleArn' => '<p>A service role ARN that allows AWS CodeDeploy to act on the user\'s behalf when interacting with AWS services.</p>', 'DeploymentGroupInfo$serviceRoleArn' => '<p>A service role ARN.</p>', 'UpdateDeploymentGroupInput$serviceRoleArn' => '<p>A replacement ARN for the service role, if you want to change it.</p>', ], ], 'RoleRequiredException' => [ 'base' => '<p>The role ID was not specified.</p>', 'refs' => [], ], 'RollbackInfo' => [ 'base' => '<p>Information about a deployment rollback.</p>', 'refs' => [ 'DeploymentInfo$rollbackInfo' => '<p>Information about a deployment rollback.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'ListApplicationRevisionsInput$s3Bucket' => '<p>An Amazon S3 bucket name to limit the search for revisions.</p> <p>If set to null, all of the user\'s buckets will be searched.</p>', 'S3Location$bucket' => '<p>The name of the Amazon S3 bucket where the application revision is stored.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'ListApplicationRevisionsInput$s3KeyPrefix' => '<p>A key prefix for the set of Amazon S3 objects to limit the search for revisions.</p>', 'S3Location$key' => '<p>The name of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>', ], ], 'S3Location' => [ 'base' => '<p>Information about the location of application artifacts stored in Amazon S3.</p>', 'refs' => [ 'RevisionLocation$s3Location' => '<p>Information about the location of application artifacts stored in Amazon S3. </p>', ], ], 'ScriptName' => [ 'base' => NULL, 'refs' => [ 'Diagnostics$scriptName' => '<p>The name of the script.</p>', ], ], 'SkipWaitTimeForInstanceTerminationInput' => [ 'base' => NULL, 'refs' => [], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListApplicationRevisionsInput$sortOrder' => '<p>The order in which to sort the list results:</p> <ul> <li> <p>ascending: ascending order.</p> </li> <li> <p>descending: descending order.</p> </li> </ul> <p>If not specified, the results will be sorted in ascending order.</p> <p>If set to null, the results will be sorted in an arbitrary order.</p>', ], ], 'StopDeploymentInput' => [ 'base' => '<p>Represents the input of a StopDeployment operation.</p>', 'refs' => [], ], 'StopDeploymentOutput' => [ 'base' => '<p>Represents the output of a StopDeployment operation.</p>', 'refs' => [], ], 'StopStatus' => [ 'base' => NULL, 'refs' => [ 'StopDeploymentOutput$status' => '<p>The status of the stop deployment operation:</p> <ul> <li> <p>Pending: The stop operation is pending.</p> </li> <li> <p>Succeeded: The stop operation was successful.</p> </li> </ul>', ], ], 'Tag' => [ 'base' => '<p>Information about a tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagFilter' => [ 'base' => '<p>Information about an on-premises instance tag filter.</p>', 'refs' => [ 'TagFilterList$member' => NULL, ], ], 'TagFilterList' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$onPremisesInstanceTagFilters' => '<p>The on-premises instance tags on which to filter. The deployment group will include on-premises instances with any of the specified tags. Cannot be used in the same call as OnPremisesTagSet.</p>', 'DeploymentGroupInfo$onPremisesInstanceTagFilters' => '<p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags.</p>', 'ListOnPremisesInstancesInput$tagFilters' => '<p>The on-premises instance tags that will be used to restrict the corresponding on-premises instance names returned.</p>', 'OnPremisesTagSetList$member' => NULL, 'UpdateDeploymentGroupInput$onPremisesInstanceTagFilters' => '<p>The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>', ], ], 'TagFilterType' => [ 'base' => NULL, 'refs' => [ 'TagFilter$Type' => '<p>The on-premises instance tag filter type:</p> <ul> <li> <p>KEY_ONLY: Key only.</p> </li> <li> <p>VALUE_ONLY: Value only.</p> </li> <li> <p>KEY_AND_VALUE: Key and value.</p> </li> </ul>', ], ], 'TagLimitExceededException' => [ 'base' => '<p>The maximum allowed number of tags was exceeded.</p>', 'refs' => [], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsToOnPremisesInstancesInput$tags' => '<p>The tag key-value pairs to add to the on-premises instances.</p> <p>Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.</p>', 'InstanceInfo$tags' => '<p>The tags currently associated with the on-premises instance.</p>', 'RemoveTagsFromOnPremisesInstancesInput$tags' => '<p>The tag key-value pairs to remove from the on-premises instances.</p>', ], ], 'TagRequiredException' => [ 'base' => '<p>A tag was not specified.</p>', 'refs' => [], ], 'TagSetListLimitExceededException' => [ 'base' => '<p>The number of tag groups included in the tag set list exceeded the maximum allowed limit of 3.</p>', 'refs' => [], ], 'TargetGroupInfo' => [ 'base' => '<p>Information about a target group in Elastic Load Balancing to use in a deployment. Instances are registered as targets in a target group, and traffic is routed to the target group.</p>', 'refs' => [ 'TargetGroupInfoList$member' => NULL, ], ], 'TargetGroupInfoList' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerInfo$targetGroupInfoList' => '<p>An array containing information about the target group to use for load balancing in a deployment. In Elastic Load Balancing, target groups are used with Application Load Balancers.</p>', ], ], 'TargetGroupName' => [ 'base' => NULL, 'refs' => [ 'TargetGroupInfo$name' => '<p>For blue/green deployments, the name of the target group that instances in the original environment are deregistered from, and instances in the replacement environment registered with. For in-place deployments, the name of the target group that instances are deregistered from, so they are not serving traffic during a deployment, and then re-registered with after the deployment completes. </p>', ], ], 'TargetInstances' => [ 'base' => '<p>Information about the instances to be used in the replacement environment in a blue/green deployment.</p>', 'refs' => [ 'CreateDeploymentInput$targetInstances' => '<p>Information about the instances that will belong to the replacement environment in a blue/green deployment.</p>', 'DeploymentInfo$targetInstances' => '<p>Information about the instances that belong to the replacement environment in a blue/green deployment.</p>', ], ], 'TimeRange' => [ 'base' => '<p>Information about a time range.</p>', 'refs' => [ 'ListDeploymentsInput$createTimeRange' => '<p>A time range (start and end) for returning a subset of the list of deployments.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$createTime' => '<p>The time at which the application was created.</p>', 'DeploymentConfigInfo$createTime' => '<p>The time at which the deployment configuration was created.</p>', 'DeploymentInfo$createTime' => '<p>A timestamp indicating when the deployment was created.</p>', 'DeploymentInfo$startTime' => '<p>A timestamp indicating when the deployment was deployed to the deployment group.</p> <p>In some cases, the reported value of the start time may be later than the complete time. This is due to differences in the clock settings of back-end servers that participate in the deployment process.</p>', 'DeploymentInfo$completeTime' => '<p>A timestamp indicating when the deployment was complete.</p>', 'GenericRevisionInfo$firstUsedTime' => '<p>When the revision was first used by AWS CodeDeploy.</p>', 'GenericRevisionInfo$lastUsedTime' => '<p>When the revision was last used by AWS CodeDeploy.</p>', 'GenericRevisionInfo$registerTime' => '<p>When the revision was registered with AWS CodeDeploy.</p>', 'InstanceInfo$registerTime' => '<p>The time at which the on-premises instance was registered.</p>', 'InstanceInfo$deregisterTime' => '<p>If the on-premises instance was deregistered, the time at which the on-premises instance was deregistered.</p>', 'InstanceSummary$lastUpdatedAt' => '<p>A timestamp indicating when the instance information was last updated.</p>', 'LastDeploymentInfo$endTime' => '<p>A timestamp indicating when the most recent deployment to the deployment group completed.</p>', 'LastDeploymentInfo$createTime' => '<p>A timestamp indicating when the most recent deployment to the deployment group started.</p>', 'LifecycleEvent$startTime' => '<p>A timestamp indicating when the deployment lifecycle event started.</p>', 'LifecycleEvent$endTime' => '<p>A timestamp indicating when the deployment lifecycle event ended.</p>', 'TimeRange$start' => '<p>The start time of the time range.</p> <note> <p>Specify null to leave the start time open-ended.</p> </note>', 'TimeRange$end' => '<p>The end time of the time range.</p> <note> <p>Specify null to leave the end time open-ended.</p> </note>', ], ], 'TriggerConfig' => [ 'base' => '<p>Information about notification triggers for the deployment group.</p>', 'refs' => [ 'TriggerConfigList$member' => NULL, ], ], 'TriggerConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$triggerConfigurations' => '<p>Information about triggers to create when the deployment group is created. For examples, see <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an AWS CodeDeploy Event</a> in the AWS CodeDeploy User Guide.</p>', 'DeploymentGroupInfo$triggerConfigurations' => '<p>Information about triggers associated with the deployment group.</p>', 'UpdateDeploymentGroupInput$triggerConfigurations' => '<p>Information about triggers to change when the deployment group is updated. For examples, see <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers in an AWS CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.</p>', ], ], 'TriggerEventType' => [ 'base' => NULL, 'refs' => [ 'TriggerEventTypeList$member' => NULL, ], ], 'TriggerEventTypeList' => [ 'base' => NULL, 'refs' => [ 'TriggerConfig$triggerEvents' => '<p>The event type or types for which notifications are triggered.</p>', ], ], 'TriggerName' => [ 'base' => NULL, 'refs' => [ 'TriggerConfig$triggerName' => '<p>The name of the notification trigger.</p>', ], ], 'TriggerTargetArn' => [ 'base' => NULL, 'refs' => [ 'TriggerConfig$triggerTargetArn' => '<p>The ARN of the Amazon Simple Notification Service topic through which notifications about deployment or instance events are sent.</p>', ], ], 'TriggerTargetsLimitExceededException' => [ 'base' => '<p>The maximum allowed number of triggers was exceeded.</p>', 'refs' => [], ], 'UnsupportedActionForDeploymentTypeException' => [ 'base' => '<p>A call was submitted that is not supported for the specified deployment type.</p>', 'refs' => [], ], 'UpdateApplicationInput' => [ 'base' => '<p>Represents the input of an UpdateApplication operation.</p>', 'refs' => [], ], 'UpdateDeploymentGroupInput' => [ 'base' => '<p>Represents the input of an UpdateDeploymentGroup operation.</p>', 'refs' => [], ], 'UpdateDeploymentGroupOutput' => [ 'base' => '<p>Represents the output of an UpdateDeploymentGroup operation.</p>', 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'EC2TagFilter$Value' => '<p>The tag filter value.</p>', 'Tag$Value' => '<p>The tag\'s value.</p>', 'TagFilter$Value' => '<p>The on-premises instance tag filter value.</p>', ], ], 'VersionId' => [ 'base' => NULL, 'refs' => [ 'S3Location$version' => '<p>A specific version of the Amazon S3 object that represents the bundled artifacts for the application revision.</p> <p>If the version is not specified, the system will use the most recent version by default.</p>', ], ], ],];
