<?php
// This file was auto-generated from sdk-root/src/data/cognito-identity/2014-06-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Cognito</fullname> <p>Amazon Cognito is a web service that delivers scoped temporary credentials to mobile devices and other untrusted environments. Amazon Cognito uniquely identifies a device and supplies the user with a consistent identity over the lifetime of an application.</p> <p>Using Amazon Cognito, you can enable authentication with one or more third-party identity providers (Facebook, Google, or Login with Amazon), and you can also choose to support unauthenticated access from your app. Cognito delivers a unique identifier for each user and acts as an OpenID token provider trusted by AWS Security Token Service (STS) to access temporary, limited-privilege AWS credentials.</p> <p>To provide end-user credentials, first make an unsigned call to <a>GetId</a>. If the end user is authenticated with one of the supported identity providers, set the <code>Logins</code> map with the identity provider token. <code>GetId</code> returns a unique identifier for the user.</p> <p>Next, make an unsigned call to <a>GetCredentialsForIdentity</a>. This call expects the same <code>Logins</code> map as the <code>GetId</code> call, as well as the <code>IdentityID</code> originally returned by <code>GetId</code>. Assuming your identity pool has been configured via the <a>SetIdentityPoolRoles</a> operation, <code>GetCredentialsForIdentity</code> will return AWS credentials for your use. If your pool has not been configured with <code>SetIdentityPoolRoles</code>, or if you want to follow legacy flow, make an unsigned call to <a>GetOpenIdToken</a>, which returns the OpenID token necessary to call STS and retrieve AWS credentials. This call expects the same <code>Logins</code> map as the <code>GetId</code> call, as well as the <code>IdentityID</code> originally returned by <code>GetId</code>. The token returned by <code>GetOpenIdToken</code> can be passed to the STS operation <a href="http://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRoleWithWebIdentity.html">AssumeRoleWithWebIdentity</a> to retrieve AWS credentials.</p> <p>If you want to use Amazon Cognito in an Android, iOS, or Unity application, you will probably want to make API calls via the AWS Mobile SDK. To learn more, see the <a href="http://docs.aws.amazon.com/mobile/index.html">AWS Mobile SDK Developer Guide</a>.</p>', 'operations' => [ 'CreateIdentityPool' => '<p>Creates a new identity pool. The identity pool is a store of user identity information that is specific to your AWS account. The limit on identity pools is 60 per account. The keys for <code>SupportedLoginProviders</code> are as follows:</p> <ul> <li> <p>Facebook: <code>graph.facebook.com</code> </p> </li> <li> <p>Google: <code>accounts.google.com</code> </p> </li> <li> <p>Amazon: <code>www.amazon.com</code> </p> </li> <li> <p>Twitter: <code>api.twitter.com</code> </p> </li> <li> <p>Digits: <code>www.digits.com</code> </p> </li> </ul> <p>You must use AWS Developer credentials to call this API.</p>', 'DeleteIdentities' => '<p>Deletes identities from an identity pool. You can specify a list of 1-60 identities that you want to delete.</p> <p>You must use AWS Developer credentials to call this API.</p>', 'DeleteIdentityPool' => '<p>Deletes a user pool. Once a pool is deleted, users will not be able to authenticate with the pool.</p> <p>You must use AWS Developer credentials to call this API.</p>', 'DescribeIdentity' => '<p>Returns metadata related to the given identity, including when the identity was created and any associated linked logins.</p> <p>You must use AWS Developer credentials to call this API.</p>', 'DescribeIdentityPool' => '<p>Gets details about a particular identity pool, including the pool name, ID description, creation date, and current number of users.</p> <p>You must use AWS Developer credentials to call this API.</p>', 'GetCredentialsForIdentity' => '<p>Returns credentials for the provided identity ID. Any provided logins will be validated against supported login providers. If the token is for cognito-identity.amazonaws.com, it will be passed through to AWS Security Token Service with the appropriate role for the token.</p> <p>This is a public API. You do not need any credentials to call this API.</p>', 'GetId' => '<p>Generates (or retrieves) a Cognito ID. Supplying multiple logins will create an implicit linked account.</p> <p>This is a public API. You do not need any credentials to call this API.</p>', 'GetIdentityPoolRoles' => '<p>Gets the roles for an identity pool.</p> <p>You must use AWS Developer credentials to call this API.</p>', 'GetOpenIdToken' => '<p>Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by <a>GetId</a>. You can optionally add additional logins for the identity. Supplying multiple logins creates an implicit link.</p> <p>The OpenId token is valid for 15 minutes.</p> <p>This is a public API. You do not need any credentials to call this API.</p>', 'GetOpenIdTokenForDeveloperIdentity' => '<p>Registers (or retrieves) a Cognito <code>IdentityId</code> and an OpenID Connect token for a user authenticated by your backend authentication process. Supplying multiple logins will create an implicit linked account. You can only specify one developer provider as part of the <code>Logins</code> map, which is linked to the identity pool. The developer provider is the "domain" by which Cognito will refer to your users.</p> <p>You can use <code>GetOpenIdTokenForDeveloperIdentity</code> to create a new identity and to link new logins (that is, user credentials issued by a public provider or developer provider) to an existing identity. When you want to create a new identity, the <code>IdentityId</code> should be null. When you want to associate a new login with an existing authenticated/unauthenticated identity, you can do so by providing the existing <code>IdentityId</code>. This API will create the identity in the specified <code>IdentityPoolId</code>.</p> <p>You must use AWS Developer credentials to call this API.</p>', 'ListIdentities' => '<p>Lists the identities in a pool.</p> <p>You must use AWS Developer credentials to call this API.</p>', 'ListIdentityPools' => '<p>Lists all of the Cognito identity pools registered for your account.</p> <p>You must use AWS Developer credentials to call this API.</p>', 'LookupDeveloperIdentity' => '<p>Retrieves the <code>IdentityID</code> associated with a <code>DeveloperUserIdentifier</code> or the list of <code>DeveloperUserIdentifier</code>s associated with an <code>IdentityId</code> for an existing identity. Either <code>IdentityID</code> or <code>DeveloperUserIdentifier</code> must not be null. If you supply only one of these values, the other value will be searched in the database and returned as a part of the response. If you supply both, <code>DeveloperUserIdentifier</code> will be matched against <code>IdentityID</code>. If the values are verified against the database, the response returns both values and is the same as the request. Otherwise a <code>ResourceConflictException</code> is thrown.</p> <p>You must use AWS Developer credentials to call this API.</p>', 'MergeDeveloperIdentities' => '<p>Merges two users having different <code>IdentityId</code>s, existing in the same identity pool, and identified by the same developer provider. You can use this action to request that discrete users be merged and identified as a single user in the Cognito environment. Cognito associates the given source user (<code>SourceUserIdentifier</code>) with the <code>IdentityId</code> of the <code>DestinationUserIdentifier</code>. Only developer-authenticated users can be merged. If the users to be merged are associated with the same public provider, but as two different users, an exception will be thrown.</p> <p>You must use AWS Developer credentials to call this API.</p>', 'SetIdentityPoolRoles' => '<p>Sets the roles for an identity pool. These roles are used when making calls to <a>GetCredentialsForIdentity</a> action.</p> <p>You must use AWS Developer credentials to call this API.</p>', 'UnlinkDeveloperIdentity' => '<p>Unlinks a <code>DeveloperUserIdentifier</code> from an existing identity. Unlinked developer users will be considered new identities next time they are seen. If, for a given Cognito identity, you remove all federated identities as well as the developer user identifier, the Cognito identity becomes inaccessible.</p> <p>You must use AWS Developer credentials to call this API.</p>', 'UnlinkIdentity' => '<p>Unlinks a federated identity from an existing account. Unlinked logins will be considered new identities next time they are seen. Removing the last linked login will make this identity inaccessible.</p> <p>This is a public API. You do not need any credentials to call this API.</p>', 'UpdateIdentityPool' => '<p>Updates a user pool.</p> <p>You must use AWS Developer credentials to call this API.</p>', ], 'shapes' => [ 'ARNString' => [ 'base' => NULL, 'refs' => [ 'GetCredentialsForIdentityInput$CustomRoleArn' => '<p>The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the token from the identity provider. For example, a SAML-based identity provider. This parameter is optional for identity providers that do not support role customization.</p>', 'MappingRule$RoleARN' => '<p>The role ARN.</p>', 'OIDCProviderList$member' => NULL, 'RolesMap$value' => NULL, 'SAMLProviderList$member' => NULL, ], ], 'AccessKeyString' => [ 'base' => NULL, 'refs' => [ 'Credentials$AccessKeyId' => '<p>The Access Key portion of the credentials.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'GetIdInput$AccountId' => '<p>A standard AWS account ID (9+ digits).</p>', ], ], 'AmbiguousRoleResolutionType' => [ 'base' => NULL, 'refs' => [ 'RoleMapping$AmbiguousRoleResolution' => '<p>If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is required.</p> <p>Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code> type, or there is no <code>cognito:preferred_role</code> claim and there are multiple <code>cognito:roles</code> matches for the <code>Token</code> type.</p>', ], ], 'ClaimName' => [ 'base' => NULL, 'refs' => [ 'MappingRule$Claim' => '<p>The claim name that must be present in the token, for example, "isAdmin" or "paid".</p>', ], ], 'ClaimValue' => [ 'base' => NULL, 'refs' => [ 'MappingRule$Value' => '<p>A brief string that the claim must match, for example, "paid" or "yes".</p>', ], ], 'CognitoIdentityProvider' => [ 'base' => '<p>A provider representing an Amazon Cognito Identity User Pool and its client ID.</p>', 'refs' => [ 'CognitoIdentityProviderList$member' => NULL, ], ], 'CognitoIdentityProviderClientId' => [ 'base' => NULL, 'refs' => [ 'CognitoIdentityProvider$ClientId' => '<p>The client ID for the Amazon Cognito Identity User Pool.</p>', ], ], 'CognitoIdentityProviderList' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityPoolInput$CognitoIdentityProviders' => '<p>An array of Amazon Cognito Identity user pools and their client IDs.</p>', 'IdentityPool$CognitoIdentityProviders' => '<p>A list representing an Amazon Cognito Identity User Pool and its client ID.</p>', ], ], 'CognitoIdentityProviderName' => [ 'base' => NULL, 'refs' => [ 'CognitoIdentityProvider$ProviderName' => '<p>The provider name for an Amazon Cognito Identity User Pool. For example, <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.</p>', ], ], 'CognitoIdentityProviderTokenCheck' => [ 'base' => NULL, 'refs' => [ 'CognitoIdentityProvider$ServerSideTokenCheck' => '<p>TRUE if server-side token validation is enabled for the identity provider’s token.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>Thrown if there are parallel requests to modify a resource.</p>', 'refs' => [], ], 'CreateIdentityPoolInput' => [ 'base' => '<p>Input to the CreateIdentityPool action.</p>', 'refs' => [], ], 'Credentials' => [ 'base' => '<p>Credentials for the provided identity ID.</p>', 'refs' => [ 'GetCredentialsForIdentityResponse$Credentials' => '<p>Credentials for the provided identity ID.</p>', ], ], 'DateType' => [ 'base' => NULL, 'refs' => [ 'Credentials$Expiration' => '<p>The date at which these credentials will expire.</p>', 'IdentityDescription$CreationDate' => '<p>Date on which the identity was created.</p>', 'IdentityDescription$LastModifiedDate' => '<p>Date on which the identity was last modified.</p>', ], ], 'DeleteIdentitiesInput' => [ 'base' => '<p>Input to the <code>DeleteIdentities</code> action.</p>', 'refs' => [], ], 'DeleteIdentitiesResponse' => [ 'base' => '<p>Returned in response to a successful <code>DeleteIdentities</code> operation.</p>', 'refs' => [], ], 'DeleteIdentityPoolInput' => [ 'base' => '<p>Input to the DeleteIdentityPool action.</p>', 'refs' => [], ], 'DescribeIdentityInput' => [ 'base' => '<p>Input to the <code>DescribeIdentity</code> action.</p>', 'refs' => [], ], 'DescribeIdentityPoolInput' => [ 'base' => '<p>Input to the DescribeIdentityPool action.</p>', 'refs' => [], ], 'DeveloperProviderName' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityPoolInput$DeveloperProviderName' => '<p>The "domain" by which Cognito will refer to your users. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well as period (<code>.</code>), underscore (<code>_</code>), and dash (<code>-</code>).</p> <p>Once you have set a developer provider name, you cannot change it. Please take care in setting this parameter.</p>', 'IdentityPool$DeveloperProviderName' => '<p>The "domain" by which Cognito will refer to your users.</p>', 'MergeDeveloperIdentitiesInput$DeveloperProviderName' => '<p>The "domain" by which Cognito will refer to your users. This is a (pseudo) domain name that you provide while creating an identity pool. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well as period (.), underscore (_), and dash (-).</p>', 'UnlinkDeveloperIdentityInput$DeveloperProviderName' => '<p>The "domain" by which Cognito will refer to your users.</p>', ], ], 'DeveloperUserAlreadyRegisteredException' => [ 'base' => '<p>The provided developer user identifier is already registered with Cognito under a different identity ID.</p>', 'refs' => [], ], 'DeveloperUserIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeveloperUserIdentifierList$member' => NULL, 'LookupDeveloperIdentityInput$DeveloperUserIdentifier' => '<p>A unique ID used by your backend authentication process to identify a user. Typically, a developer identity provider would issue many developer user identifiers, in keeping with the number of users.</p>', 'MergeDeveloperIdentitiesInput$SourceUserIdentifier' => '<p>User identifier for the source user. The value should be a <code>DeveloperUserIdentifier</code>.</p>', 'MergeDeveloperIdentitiesInput$DestinationUserIdentifier' => '<p>User identifier for the destination user. The value should be a <code>DeveloperUserIdentifier</code>.</p>', 'UnlinkDeveloperIdentityInput$DeveloperUserIdentifier' => '<p>A unique ID used by your backend authentication process to identify a user.</p>', ], ], 'DeveloperUserIdentifierList' => [ 'base' => NULL, 'refs' => [ 'LookupDeveloperIdentityResponse$DeveloperUserIdentifierList' => '<p>This is the list of developer user identifiers associated with an identity ID. Cognito supports the association of multiple developer user identifiers with an identity ID.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'UnprocessedIdentityId$ErrorCode' => '<p>The error code indicating the type of error that occurred.</p>', ], ], 'ExternalServiceException' => [ 'base' => '<p>An exception thrown when a dependent service such as Facebook or Twitter is not responding</p>', 'refs' => [], ], 'GetCredentialsForIdentityInput' => [ 'base' => '<p>Input to the <code>GetCredentialsForIdentity</code> action.</p>', 'refs' => [], ], 'GetCredentialsForIdentityResponse' => [ 'base' => '<p>Returned in response to a successful <code>GetCredentialsForIdentity</code> operation.</p>', 'refs' => [], ], 'GetIdInput' => [ 'base' => '<p>Input to the GetId action.</p>', 'refs' => [], ], 'GetIdResponse' => [ 'base' => '<p>Returned in response to a GetId request.</p>', 'refs' => [], ], 'GetIdentityPoolRolesInput' => [ 'base' => '<p>Input to the <code>GetIdentityPoolRoles</code> action.</p>', 'refs' => [], ], 'GetIdentityPoolRolesResponse' => [ 'base' => '<p>Returned in response to a successful <code>GetIdentityPoolRoles</code> operation.</p>', 'refs' => [], ], 'GetOpenIdTokenForDeveloperIdentityInput' => [ 'base' => '<p>Input to the <code>GetOpenIdTokenForDeveloperIdentity</code> action.</p>', 'refs' => [], ], 'GetOpenIdTokenForDeveloperIdentityResponse' => [ 'base' => '<p>Returned in response to a successful <code>GetOpenIdTokenForDeveloperIdentity</code> request.</p>', 'refs' => [], ], 'GetOpenIdTokenInput' => [ 'base' => '<p>Input to the GetOpenIdToken action.</p>', 'refs' => [], ], 'GetOpenIdTokenResponse' => [ 'base' => '<p>Returned in response to a successful GetOpenIdToken request.</p>', 'refs' => [], ], 'HideDisabled' => [ 'base' => NULL, 'refs' => [ 'ListIdentitiesInput$HideDisabled' => '<p>An optional boolean parameter that allows you to hide disabled identities. If omitted, the ListIdentities API will include disabled identities in the response.</p>', ], ], 'IdentitiesList' => [ 'base' => NULL, 'refs' => [ 'ListIdentitiesResponse$Identities' => '<p>An object containing a set of identities and associated mappings.</p>', ], ], 'IdentityDescription' => [ 'base' => '<p>A description of the identity.</p>', 'refs' => [ 'IdentitiesList$member' => NULL, ], ], 'IdentityId' => [ 'base' => NULL, 'refs' => [ 'DescribeIdentityInput$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', 'GetCredentialsForIdentityInput$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', 'GetCredentialsForIdentityResponse$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', 'GetIdResponse$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', 'GetOpenIdTokenForDeveloperIdentityInput$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', 'GetOpenIdTokenForDeveloperIdentityResponse$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', 'GetOpenIdTokenInput$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', 'GetOpenIdTokenResponse$IdentityId' => '<p>A unique identifier in the format REGION:GUID. Note that the IdentityId returned may not match the one passed on input.</p>', 'IdentityDescription$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', 'IdentityIdList$member' => NULL, 'LookupDeveloperIdentityInput$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', 'LookupDeveloperIdentityResponse$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', 'MergeDeveloperIdentitiesResponse$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', 'UnlinkDeveloperIdentityInput$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', 'UnlinkIdentityInput$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', 'UnprocessedIdentityId$IdentityId' => '<p>A unique identifier in the format REGION:GUID.</p>', ], ], 'IdentityIdList' => [ 'base' => NULL, 'refs' => [ 'DeleteIdentitiesInput$IdentityIdsToDelete' => '<p>A list of 1-60 identities that you want to delete.</p>', ], ], 'IdentityPool' => [ 'base' => '<p>An object representing an Amazon Cognito identity pool.</p>', 'refs' => [], ], 'IdentityPoolId' => [ 'base' => NULL, 'refs' => [ 'DeleteIdentityPoolInput$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', 'DescribeIdentityPoolInput$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', 'GetIdInput$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', 'GetIdentityPoolRolesInput$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', 'GetIdentityPoolRolesResponse$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', 'GetOpenIdTokenForDeveloperIdentityInput$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', 'IdentityPool$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', 'IdentityPoolShortDescription$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', 'ListIdentitiesInput$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', 'ListIdentitiesResponse$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', 'LookupDeveloperIdentityInput$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', 'MergeDeveloperIdentitiesInput$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', 'SetIdentityPoolRolesInput$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', 'UnlinkDeveloperIdentityInput$IdentityPoolId' => '<p>An identity pool ID in the format REGION:GUID.</p>', ], ], 'IdentityPoolName' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityPoolInput$IdentityPoolName' => '<p>A string that you provide.</p>', 'IdentityPool$IdentityPoolName' => '<p>A string that you provide.</p>', 'IdentityPoolShortDescription$IdentityPoolName' => '<p>A string that you provide.</p>', ], ], 'IdentityPoolShortDescription' => [ 'base' => '<p>A description of the identity pool.</p>', 'refs' => [ 'IdentityPoolsList$member' => NULL, ], ], 'IdentityPoolUnauthenticated' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityPoolInput$AllowUnauthenticatedIdentities' => '<p>TRUE if the identity pool supports unauthenticated logins.</p>', 'IdentityPool$AllowUnauthenticatedIdentities' => '<p>TRUE if the identity pool supports unauthenticated logins.</p>', ], ], 'IdentityPoolsList' => [ 'base' => NULL, 'refs' => [ 'ListIdentityPoolsResponse$IdentityPools' => '<p>The identity pools returned by the ListIdentityPools action.</p>', ], ], 'IdentityProviderId' => [ 'base' => NULL, 'refs' => [ 'IdentityProviders$value' => NULL, ], ], 'IdentityProviderName' => [ 'base' => NULL, 'refs' => [ 'IdentityProviders$key' => NULL, 'LoginsList$member' => NULL, 'LoginsMap$key' => NULL, 'RoleMappingMap$key' => NULL, ], ], 'IdentityProviderToken' => [ 'base' => NULL, 'refs' => [ 'LoginsMap$value' => NULL, ], ], 'IdentityProviders' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityPoolInput$SupportedLoginProviders' => '<p>Optional key:value pairs mapping provider names to provider app IDs.</p>', 'IdentityPool$SupportedLoginProviders' => '<p>Optional key:value pairs mapping provider names to provider app IDs.</p>', ], ], 'InternalErrorException' => [ 'base' => '<p>Thrown when the service encounters an error during processing the request.</p>', 'refs' => [], ], 'InvalidIdentityPoolConfigurationException' => [ 'base' => '<p>Thrown if the identity pool has no role associated for the given auth type (auth/unauth) or if the AssumeRole fails.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>Thrown for missing or bad input parameter(s).</p>', 'refs' => [], ], 'LimitExceededException' => [ 'base' => '<p>Thrown when the total number of user pools has exceeded a preset limit.</p>', 'refs' => [], ], 'ListIdentitiesInput' => [ 'base' => '<p>Input to the ListIdentities action.</p>', 'refs' => [], ], 'ListIdentitiesResponse' => [ 'base' => '<p>The response to a ListIdentities request.</p>', 'refs' => [], ], 'ListIdentityPoolsInput' => [ 'base' => '<p>Input to the ListIdentityPools action.</p>', 'refs' => [], ], 'ListIdentityPoolsResponse' => [ 'base' => '<p>The result of a successful ListIdentityPools action.</p>', 'refs' => [], ], 'LoginsList' => [ 'base' => NULL, 'refs' => [ 'IdentityDescription$Logins' => '<p>A set of optional name-value pairs that map provider names to provider tokens.</p>', 'UnlinkIdentityInput$LoginsToRemove' => '<p>Provider names to unlink from this identity.</p>', ], ], 'LoginsMap' => [ 'base' => NULL, 'refs' => [ 'GetCredentialsForIdentityInput$Logins' => '<p>A set of optional name-value pairs that map provider names to provider tokens.</p>', 'GetIdInput$Logins' => '<p>A set of optional name-value pairs that map provider names to provider tokens. The available provider names for <code>Logins</code> are as follows:</p> <ul> <li> <p>Facebook: <code>graph.facebook.com</code> </p> </li> <li> <p>Amazon Cognito Identity Provider: <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code> </p> </li> <li> <p>Google: <code>accounts.google.com</code> </p> </li> <li> <p>Amazon: <code>www.amazon.com</code> </p> </li> <li> <p>Twitter: <code>api.twitter.com</code> </p> </li> <li> <p>Digits: <code>www.digits.com</code> </p> </li> </ul>', 'GetOpenIdTokenForDeveloperIdentityInput$Logins' => '<p>A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair represents a user from a public provider or developer provider. If the user is from a developer provider, the name-value pair will follow the syntax <code>"developer_provider_name": "developer_user_identifier"</code>. The developer provider is the "domain" by which Cognito will refer to your users; you provided this domain while creating/updating the identity pool. The developer user identifier is an identifier from your backend that uniquely identifies a user. When you create an identity pool, you can specify the supported logins.</p>', 'GetOpenIdTokenInput$Logins' => '<p>A set of optional name-value pairs that map provider names to provider tokens. When using graph.facebook.com and www.amazon.com, supply the access_token returned from the provider\'s authflow. For accounts.google.com, an Amazon Cognito Identity Provider, or any other OpenId Connect provider, always include the <code>id_token</code>.</p>', 'UnlinkIdentityInput$Logins' => '<p>A set of optional name-value pairs that map provider names to provider tokens.</p>', ], ], 'LookupDeveloperIdentityInput' => [ 'base' => '<p>Input to the <code>LookupDeveloperIdentityInput</code> action.</p>', 'refs' => [], ], 'LookupDeveloperIdentityResponse' => [ 'base' => '<p>Returned in response to a successful <code>LookupDeveloperIdentity</code> action.</p>', 'refs' => [], ], 'MappingRule' => [ 'base' => '<p>A rule that maps a claim name, a claim value, and a match type to a role ARN.</p>', 'refs' => [ 'MappingRulesList$member' => NULL, ], ], 'MappingRuleMatchType' => [ 'base' => NULL, 'refs' => [ 'MappingRule$MatchType' => '<p>The match condition that specifies how closely the claim value in the IdP token must match <code>Value</code>.</p>', ], ], 'MappingRulesList' => [ 'base' => NULL, 'refs' => [ 'RulesConfigurationType$Rules' => '<p>An array of rules. You can specify up to 25 rules per identity provider.</p> <p>Rules are evaluated in order. The first one to match specifies the role.</p>', ], ], 'MergeDeveloperIdentitiesInput' => [ 'base' => '<p>Input to the <code>MergeDeveloperIdentities</code> action.</p>', 'refs' => [], ], 'MergeDeveloperIdentitiesResponse' => [ 'base' => '<p>Returned in response to a successful <code>MergeDeveloperIdentities</code> action.</p>', 'refs' => [], ], 'NotAuthorizedException' => [ 'base' => '<p>Thrown when a user is not authorized to access the requested resource.</p>', 'refs' => [], ], 'OIDCProviderList' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityPoolInput$OpenIdConnectProviderARNs' => '<p>A list of OpendID Connect provider ARNs.</p>', 'IdentityPool$OpenIdConnectProviderARNs' => '<p>A list of OpendID Connect provider ARNs.</p>', ], ], 'OIDCToken' => [ 'base' => NULL, 'refs' => [ 'GetOpenIdTokenForDeveloperIdentityResponse$Token' => '<p>An OpenID token.</p>', 'GetOpenIdTokenResponse$Token' => '<p>An OpenID token, valid for 15 minutes.</p>', ], ], 'PaginationKey' => [ 'base' => NULL, 'refs' => [ 'ListIdentitiesInput$NextToken' => '<p>A pagination token.</p>', 'ListIdentitiesResponse$NextToken' => '<p>A pagination token.</p>', 'ListIdentityPoolsInput$NextToken' => '<p>A pagination token.</p>', 'ListIdentityPoolsResponse$NextToken' => '<p>A pagination token.</p>', 'LookupDeveloperIdentityInput$NextToken' => '<p>A pagination token. The first call you make will have <code>NextToken</code> set to null. After that the service will return <code>NextToken</code> values as needed. For example, let\'s say you make a request with <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service will return a pagination token as a part of the response. This token can be used to call the API again and get results starting from the 11th match.</p>', 'LookupDeveloperIdentityResponse$NextToken' => '<p>A pagination token. The first call you make will have <code>NextToken</code> set to null. After that the service will return <code>NextToken</code> values as needed. For example, let\'s say you make a request with <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service will return a pagination token as a part of the response. This token can be used to call the API again and get results starting from the 11th match.</p>', ], ], 'QueryLimit' => [ 'base' => NULL, 'refs' => [ 'ListIdentitiesInput$MaxResults' => '<p>The maximum number of identities to return.</p>', 'ListIdentityPoolsInput$MaxResults' => '<p>The maximum number of identities to return.</p>', 'LookupDeveloperIdentityInput$MaxResults' => '<p>The maximum number of identities to return.</p>', ], ], 'ResourceConflictException' => [ 'base' => '<p>Thrown when a user tries to use a login which is already linked to another account.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>Thrown when the requested resource (for example, a dataset or record) does not exist.</p>', 'refs' => [], ], 'RoleMapping' => [ 'base' => '<p>A role mapping.</p>', 'refs' => [ 'RoleMappingMap$value' => NULL, ], ], 'RoleMappingMap' => [ 'base' => NULL, 'refs' => [ 'GetIdentityPoolRolesResponse$RoleMappings' => '<p>How users for a specific identity provider are to mapped to roles. This is a String-to-<a>RoleMapping</a> object map. The string identifies the identity provider, for example, "graph.facebook.com" or "cognito-idp-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p>', 'SetIdentityPoolRolesInput$RoleMappings' => '<p>How users for a specific identity provider are to mapped to roles. This is a string to <a>RoleMapping</a> object map. The string identifies the identity provider, for example, "graph.facebook.com" or "cognito-idp-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".</p> <p>Up to 25 rules can be specified per identity provider.</p>', ], ], 'RoleMappingType' => [ 'base' => NULL, 'refs' => [ 'RoleMapping$Type' => '<p>The role mapping type. Token will use <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims from the Cognito identity provider token to map groups to roles. Rules will attempt to match claims from the token to map to a role.</p>', ], ], 'RoleType' => [ 'base' => NULL, 'refs' => [ 'RolesMap$key' => NULL, ], ], 'RolesMap' => [ 'base' => NULL, 'refs' => [ 'GetIdentityPoolRolesResponse$Roles' => '<p>The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are supported.</p>', 'SetIdentityPoolRolesInput$Roles' => '<p>The map of roles associated with this pool. For a given role, the key will be either "authenticated" or "unauthenticated" and the value will be the Role ARN.</p>', ], ], 'RulesConfigurationType' => [ 'base' => '<p>A container for rules.</p>', 'refs' => [ 'RoleMapping$RulesConfiguration' => '<p>The rules to be used for mapping users to roles.</p> <p>If you specify Rules as the role mapping type, <code>RulesConfiguration</code> is required.</p>', ], ], 'SAMLProviderList' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityPoolInput$SamlProviderARNs' => '<p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.</p>', 'IdentityPool$SamlProviderARNs' => '<p>An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.</p>', ], ], 'SecretKeyString' => [ 'base' => NULL, 'refs' => [ 'Credentials$SecretKey' => '<p>The Secret Access Key portion of the credentials</p>', ], ], 'SessionTokenString' => [ 'base' => NULL, 'refs' => [ 'Credentials$SessionToken' => '<p>The Session Token portion of the credentials</p>', ], ], 'SetIdentityPoolRolesInput' => [ 'base' => '<p>Input to the <code>SetIdentityPoolRoles</code> action.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ConcurrentModificationException$message' => '<p>The message returned by a ConcurrentModificationException.</p>', 'DeveloperUserAlreadyRegisteredException$message' => '<p>This developer user identifier is already registered with Cognito.</p>', 'ExternalServiceException$message' => '<p>The message returned by an ExternalServiceException</p>', 'InternalErrorException$message' => '<p>The message returned by an InternalErrorException.</p>', 'InvalidIdentityPoolConfigurationException$message' => '<p>The message returned for an <code>InvalidIdentityPoolConfigurationException</code> </p>', 'InvalidParameterException$message' => '<p>The message returned by an InvalidParameterException.</p>', 'LimitExceededException$message' => '<p>The message returned by a LimitExceededException.</p>', 'NotAuthorizedException$message' => '<p>The message returned by a NotAuthorizedException</p>', 'ResourceConflictException$message' => '<p>The message returned by a ResourceConflictException.</p>', 'ResourceNotFoundException$message' => '<p>The message returned by a ResourceNotFoundException.</p>', 'TooManyRequestsException$message' => '<p>Message returned by a TooManyRequestsException</p>', ], ], 'TokenDuration' => [ 'base' => NULL, 'refs' => [ 'GetOpenIdTokenForDeveloperIdentityInput$TokenDuration' => '<p>The expiration time of the token, in seconds. You can specify a custom expiration time for the token so that you can cache it. If you don\'t provide an expiration time, the token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS credentials, which are valid for a maximum of one hour. The maximum token duration you can set is 24 hours. You should take care in setting the expiration time for a token, as there are significant security implications: an attacker could use a leaked token to access your AWS resources for the token\'s duration.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>Thrown when a request is throttled.</p>', 'refs' => [], ], 'UnlinkDeveloperIdentityInput' => [ 'base' => '<p>Input to the <code>UnlinkDeveloperIdentity</code> action.</p>', 'refs' => [], ], 'UnlinkIdentityInput' => [ 'base' => '<p>Input to the UnlinkIdentity action.</p>', 'refs' => [], ], 'UnprocessedIdentityId' => [ 'base' => '<p>An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.</p>', 'refs' => [ 'UnprocessedIdentityIdList$member' => NULL, ], ], 'UnprocessedIdentityIdList' => [ 'base' => NULL, 'refs' => [ 'DeleteIdentitiesResponse$UnprocessedIdentityIds' => '<p>An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.</p>', ], ], ],];
