<?php
// This file was auto-generated from sdk-root/src/data/cognito-idp/2016-04-18/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Using the Amazon Cognito User Pools API, you can create a user pool to manage directories and users. You can authenticate a user to obtain tokens related to user identity and access policies.</p> <p>This API reference provides information about user pools in Amazon Cognito User Pools.</p> <p>For more information, see the Amazon Cognito Documentation.</p>', 'operations' => [ 'AddCustomAttributes' => '<p>Adds additional user attributes to the user pool schema.</p>', 'AdminAddUserToGroup' => '<p>Adds the specified user to the specified group.</p> <p>Requires developer credentials.</p>', 'AdminConfirmSignUp' => '<p>Confirms user registration as an admin without using a confirmation code. Works on any user.</p> <p>Requires developer credentials.</p>', 'AdminCreateUser' => '<p>Creates a new user in the specified user pool and sends a welcome message via email or phone (SMS). This message is based on a template that you configured in your call to <a href="API_CreateUserPool.html">CreateUserPool</a> or <a href="API_UpdateUserPool.html">UpdateUserPool</a>. This template includes your custom sign-up instructions and placeholders for user name and temporary password.</p> <p>Requires developer credentials.</p>', 'AdminDeleteUser' => '<p>Deletes a user as an administrator. Works on any user.</p> <p>Requires developer credentials.</p>', 'AdminDeleteUserAttributes' => '<p>Deletes the user attributes in a user pool as an administrator. Works on any user.</p> <p>Requires developer credentials.</p>', 'AdminDisableProviderForUser' => '<p>Disables the user from signing in with the specified external (SAML or social) identity provider. If the user to disable is a Cognito User Pools native username + password user, they are not permitted to use their password to sign-in. If the user to disable is a linked external IdP user, any link between that user and an existing user is removed. The next time the external user (no longer attached to the previously linked <code>DestinationUser</code>) signs in, they must create a new user account. See <a href="API_AdminLinkProviderForUser.html">AdminLinkProviderForUser</a>.</p> <p>This action is enabled only for admin access and requires developer credentials.</p> <p>The <code>ProviderName</code> must match the value specified when creating an IdP for the pool. </p> <p>To disable a native username + password user, the <code>ProviderName</code> value must be <code>Cognito</code> and the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code>, with the <code>ProviderAttributeValue</code> being the name that is used in the user pool for the user.</p> <p>The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social identity providers. The <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was originally linked as a source user.</p> <p>For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign-in, the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were used for the <code>SourceUser</code> when the identities were originally linked in the <a href="API_AdminLinkProviderForUser.html">AdminLinkProviderForUser</a> call. (If the linking was done with <code>ProviderAttributeName</code> set to <code>Cognito_Subject</code>, the same applies here). However, if the user has already signed in, the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code> and <code>ProviderAttributeValue</code> must be the subject of the SAML assertion.</p>', 'AdminDisableUser' => '<p>Disables the specified user as an administrator. Works on any user.</p> <p>Requires developer credentials.</p>', 'AdminEnableUser' => '<p>Enables the specified user as an administrator. Works on any user.</p> <p>Requires developer credentials.</p>', 'AdminForgetDevice' => '<p>Forgets the device, as an administrator.</p> <p>Requires developer credentials.</p>', 'AdminGetDevice' => '<p>Gets the device, as an administrator.</p> <p>Requires developer credentials.</p>', 'AdminGetUser' => '<p>Gets the specified user by user name in a user pool as an administrator. Works on any user.</p> <p>Requires developer credentials.</p>', 'AdminInitiateAuth' => '<p>Initiates the authentication flow, as an administrator.</p> <p>Requires developer credentials.</p>', 'AdminLinkProviderForUser' => '<p>Links an existing user account in a user pool (<code>DestinationUser</code>) to an identity from an external identity provider (<code>SourceUser</code>) based on a specified attribute name and value from the external identity provider. This allows you to create a link from the existing user account to an external federated user identity that has not yet been used to sign in, so that the federated user identity can be used to sign in as the existing user account. </p> <p> For example, if there is an existing user with a username and password, this API links that user to a federated user identity, so that when the federated user identity is used, the user signs in as the existing user account. </p> <important> <p>Because this API allows a user with an external federated identity to sign in as an existing user in the user pool, it is critical that it only be used with external identity providers and provider attributes that have been trusted by the application owner.</p> </important> <p>See also <a href="API_AdminDisableProviderForUser.html">AdminDisableProviderForUser</a>.</p> <p>This action is enabled only for admin access and requires developer credentials.</p>', 'AdminListDevices' => '<p>Lists devices, as an administrator.</p> <p>Requires developer credentials.</p>', 'AdminListGroupsForUser' => '<p>Lists the groups that the user belongs to.</p> <p>Requires developer credentials.</p>', 'AdminRemoveUserFromGroup' => '<p>Removes the specified user from the specified group.</p> <p>Requires developer credentials.</p>', 'AdminResetUserPassword' => '<p>Resets the specified user\'s password in a user pool as an administrator. Works on any user.</p> <p>When a developer calls this API, the current password is invalidated, so it must be changed. If a user tries to sign in after the API is called, the app will get a PasswordResetRequiredException exception back and should direct the user down the flow to reset the password, which is the same as the forgot password flow. In addition, if the user pool has phone verification selected and a verified phone number exists for the user, or if email verification is selected and a verified email exists for the user, calling this API will also result in sending a message to the end user with the code to change their password.</p> <p>Requires developer credentials.</p>', 'AdminRespondToAuthChallenge' => '<p>Responds to an authentication challenge, as an administrator.</p> <p>Requires developer credentials.</p>', 'AdminSetUserSettings' => '<p>Sets all the user settings for a specified user name. Works on any user.</p> <p>Requires developer credentials.</p>', 'AdminUpdateDeviceStatus' => '<p>Updates the device status as an administrator.</p> <p>Requires developer credentials.</p>', 'AdminUpdateUserAttributes' => '<p>Updates the specified user\'s attributes, including developer attributes, as an administrator. Works on any user.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p> <p>In addition to updating user attributes, this API can also be used to mark phone and email as verified.</p> <p>Requires developer credentials.</p>', 'AdminUserGlobalSignOut' => '<p>Signs out users from all devices, as an administrator.</p> <p>Requires developer credentials.</p>', 'ChangePassword' => '<p>Changes the password for a specified user in a user pool.</p>', 'ConfirmDevice' => '<p>Confirms tracking of the device. This API call is the call that begins device tracking.</p>', 'ConfirmForgotPassword' => '<p>Allows a user to enter a confirmation code to reset a forgotten password.</p>', 'ConfirmSignUp' => '<p>Confirms registration of a user and handles the existing alias from a previous user.</p>', 'CreateGroup' => '<p>Creates a new group in the specified user pool.</p> <p>Requires developer credentials.</p>', 'CreateIdentityProvider' => '<p>Creates an identity provider for a user pool.</p>', 'CreateResourceServer' => '<p>Creates a new OAuth2.0 resource server and defines custom scopes in it.</p>', 'CreateUserImportJob' => '<p>Creates the user import job.</p>', 'CreateUserPool' => '<p>Creates a new Amazon Cognito user pool and sets the password policy for the pool.</p>', 'CreateUserPoolClient' => '<p>Creates the user pool client.</p>', 'CreateUserPoolDomain' => '<p>Creates a new domain for a user pool.</p>', 'DeleteGroup' => '<p>Deletes a group. Currently only groups with no members can be deleted.</p> <p>Requires developer credentials.</p>', 'DeleteIdentityProvider' => '<p>Deletes an identity provider for a user pool.</p>', 'DeleteResourceServer' => '<p>Deletes a resource server.</p>', 'DeleteUser' => '<p>Allows a user to delete himself or herself.</p>', 'DeleteUserAttributes' => '<p>Deletes the attributes for a user.</p>', 'DeleteUserPool' => '<p>Deletes the specified Amazon Cognito user pool.</p>', 'DeleteUserPoolClient' => '<p>Allows the developer to delete the user pool client.</p>', 'DeleteUserPoolDomain' => '<p>Deletes a domain for a user pool.</p>', 'DescribeIdentityProvider' => '<p>Gets information about a specific identity provider.</p>', 'DescribeResourceServer' => '<p>Describes a resource server.</p>', 'DescribeUserImportJob' => '<p>Describes the user import job.</p>', 'DescribeUserPool' => '<p>Returns the configuration information and metadata of the specified user pool.</p>', 'DescribeUserPoolClient' => '<p>Client method for returning the configuration information and metadata of the specified user pool client.</p>', 'DescribeUserPoolDomain' => '<p>Gets information about a domain.</p>', 'ForgetDevice' => '<p>Forgets the specified device.</p>', 'ForgotPassword' => '<p>Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user\'s password. For the <code>Username</code> parameter, you can use the username or user alias. If a verified phone number exists for the user, the confirmation code is sent to the phone number. Otherwise, if a verified email exists, the confirmation code is sent to the email. If neither a verified phone number nor a verified email exists, <code>InvalidParameterException</code> is thrown. To use the confirmation code for resetting the password, call <a href="API_ConfirmForgotPassword.html">ConfirmForgotPassword</a>.</p>', 'GetCSVHeader' => '<p>Gets the header information for the .csv file to be used as input for the user import job.</p>', 'GetDevice' => '<p>Gets the device.</p>', 'GetGroup' => '<p>Gets a group.</p> <p>Requires developer credentials.</p>', 'GetIdentityProviderByIdentifier' => '<p>Gets the specified identity provider.</p>', 'GetUICustomization' => '<p>Gets the UI Customization information for a particular app client\'s app UI, if there is something set. If nothing is set for the particular client, but there is an existing pool level customization (app <code>clientId</code> will be <code>ALL</code>), then that is returned. If nothing is present, then an empty shape is returned.</p>', 'GetUser' => '<p>Gets the user attributes and metadata for a user.</p>', 'GetUserAttributeVerificationCode' => '<p>Gets the user attribute verification code for the specified attribute name.</p>', 'GlobalSignOut' => '<p>Signs out users from all devices.</p>', 'InitiateAuth' => '<p>Initiates the authentication flow.</p>', 'ListDevices' => '<p>Lists the devices.</p>', 'ListGroups' => '<p>Lists the groups associated with a user pool.</p> <p>Requires developer credentials.</p>', 'ListIdentityProviders' => '<p>Lists information about all identity providers for a user pool.</p>', 'ListResourceServers' => '<p>Lists the resource servers for a user pool.</p>', 'ListUserImportJobs' => '<p>Lists the user import jobs.</p>', 'ListUserPoolClients' => '<p>Lists the clients that have been created for the specified user pool.</p>', 'ListUserPools' => '<p>Lists the user pools associated with an AWS account.</p>', 'ListUsers' => '<p>Lists the users in the Amazon Cognito user pool.</p>', 'ListUsersInGroup' => '<p>Lists the users in the specified group.</p> <p>Requires developer credentials.</p>', 'ResendConfirmationCode' => '<p>Resends the confirmation (for confirmation of registration) to a specific user in the user pool.</p>', 'RespondToAuthChallenge' => '<p>Responds to the authentication challenge.</p>', 'SetUICustomization' => '<p>Sets the UI customization information for a user pool\'s built-in app UI.</p> <p>You can specify app UI customization settings for a single client (with a specific <code>clientId</code>) or for all clients (by setting the <code>clientId</code> to <code>ALL</code>). If you specify <code>ALL</code>, the default configuration will be used for every client that has no UI customization set previously. If you specify UI customization settings for a particular client, it will no longer fall back to the <code>ALL</code> configuration. </p> <note> <p>To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the app\'s pages, and the service will throw an error.</p> </note>', 'SetUserSettings' => '<p>Sets the user settings like multi-factor authentication (MFA). If MFA is to be removed for a particular attribute pass the attribute with code delivery as null. If null list is passed, all MFA options are removed.</p>', 'SignUp' => '<p>Registers the user in the specified user pool and creates a user name, password, and user attributes.</p>', 'StartUserImportJob' => '<p>Starts the user import.</p>', 'StopUserImportJob' => '<p>Stops the user import job.</p>', 'UpdateDeviceStatus' => '<p>Updates the device status.</p>', 'UpdateGroup' => '<p>Updates the specified group with the specified attributes.</p> <p>Requires developer credentials.</p>', 'UpdateIdentityProvider' => '<p>Updates identity provider information for a user pool.</p>', 'UpdateResourceServer' => '<p>Updates the name and scopes of resource server. All other fields are read-only.</p>', 'UpdateUserAttributes' => '<p>Allows a user to update a specific attribute (one at a time).</p>', 'UpdateUserPool' => '<p>Updates the specified user pool with the specified attributes.</p>', 'UpdateUserPoolClient' => '<p>Allows the developer to update the specified user pool client and password policy.</p>', 'VerifyUserAttribute' => '<p>Verifies the specified user attributes in the user pool.</p>', ], 'shapes' => [ 'AWSAccountIdType' => [ 'base' => NULL, 'refs' => [ 'DomainDescriptionType$AWSAccountId' => '<p>The AWS account ID for the user pool owner.</p>', ], ], 'AddCustomAttributesRequest' => [ 'base' => '<p>Represents the request to add custom attributes.</p>', 'refs' => [], ], 'AddCustomAttributesResponse' => [ 'base' => '<p>Represents the response from the server for the request to add custom attributes.</p>', 'refs' => [], ], 'AdminAddUserToGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminConfirmSignUpRequest' => [ 'base' => '<p>Represents the request to confirm user registration.</p>', 'refs' => [], ], 'AdminConfirmSignUpResponse' => [ 'base' => '<p>Represents the response from the server for the request to confirm registration.</p>', 'refs' => [], ], 'AdminCreateUserConfigType' => [ 'base' => '<p>The type of configuration for creating a new user profile.</p>', 'refs' => [ 'CreateUserPoolRequest$AdminCreateUserConfig' => '<p>The configuration for <code>AdminCreateUser</code> requests.</p>', 'UpdateUserPoolRequest$AdminCreateUserConfig' => '<p>The configuration for <code>AdminCreateUser</code> requests.</p>', 'UserPoolType$AdminCreateUserConfig' => '<p>The configuration for <code>AdminCreateUser</code> requests.</p>', ], ], 'AdminCreateUserRequest' => [ 'base' => '<p>Represents the request to create a user in the specified user pool.</p>', 'refs' => [], ], 'AdminCreateUserResponse' => [ 'base' => '<p>Represents the response from the server to the request to create the user.</p>', 'refs' => [], ], 'AdminCreateUserUnusedAccountValidityDaysType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserConfigType$UnusedAccountValidityDays' => '<p>The user account expiration limit, in days, after which the account is no longer usable. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter. The default value for this parameter is 7.</p>', ], ], 'AdminDeleteUserAttributesRequest' => [ 'base' => '<p>Represents the request to delete user attributes as an administrator.</p>', 'refs' => [], ], 'AdminDeleteUserAttributesResponse' => [ 'base' => '<p>Represents the response received from the server for a request to delete user attributes.</p>', 'refs' => [], ], 'AdminDeleteUserRequest' => [ 'base' => '<p>Represents the request to delete a user as an administrator.</p>', 'refs' => [], ], 'AdminDisableProviderForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminDisableProviderForUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminDisableUserRequest' => [ 'base' => '<p>Represents the request to disable any user as an administrator.</p>', 'refs' => [], ], 'AdminDisableUserResponse' => [ 'base' => '<p>Represents the response received from the server to disable the user as an administrator.</p>', 'refs' => [], ], 'AdminEnableUserRequest' => [ 'base' => '<p>Represents the request that enables the user as an administrator.</p>', 'refs' => [], ], 'AdminEnableUserResponse' => [ 'base' => '<p>Represents the response from the server for the request to enable a user as an administrator.</p>', 'refs' => [], ], 'AdminForgetDeviceRequest' => [ 'base' => '<p>Sends the forgot device request, as an administrator.</p>', 'refs' => [], ], 'AdminGetDeviceRequest' => [ 'base' => '<p>Represents the request to get the device, as an administrator.</p>', 'refs' => [], ], 'AdminGetDeviceResponse' => [ 'base' => '<p>Gets the device response, as an administrator.</p>', 'refs' => [], ], 'AdminGetUserRequest' => [ 'base' => '<p>Represents the request to get the specified user as an administrator.</p>', 'refs' => [], ], 'AdminGetUserResponse' => [ 'base' => '<p>Represents the response from the server from the request to get the specified user as an administrator.</p>', 'refs' => [], ], 'AdminInitiateAuthRequest' => [ 'base' => '<p>Initiates the authorization request, as an administrator.</p>', 'refs' => [], ], 'AdminInitiateAuthResponse' => [ 'base' => '<p>Initiates the authentication response, as an administrator.</p>', 'refs' => [], ], 'AdminLinkProviderForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminLinkProviderForUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminListDevicesRequest' => [ 'base' => '<p>Represents the request to list devices, as an administrator.</p>', 'refs' => [], ], 'AdminListDevicesResponse' => [ 'base' => '<p>Lists the device\'s response, as an administrator.</p>', 'refs' => [], ], 'AdminListGroupsForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminListGroupsForUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminRemoveUserFromGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminResetUserPasswordRequest' => [ 'base' => '<p>Represents the request to reset a user\'s password as an administrator.</p>', 'refs' => [], ], 'AdminResetUserPasswordResponse' => [ 'base' => '<p>Represents the response from the server to reset a user password as an administrator.</p>', 'refs' => [], ], 'AdminRespondToAuthChallengeRequest' => [ 'base' => '<p>The request to respond to the authentication challenge, as an administrator.</p>', 'refs' => [], ], 'AdminRespondToAuthChallengeResponse' => [ 'base' => '<p>Responds to the authentication challenge, as an administrator.</p>', 'refs' => [], ], 'AdminSetUserSettingsRequest' => [ 'base' => '<p>Represents the request to set user settings as an administrator.</p>', 'refs' => [], ], 'AdminSetUserSettingsResponse' => [ 'base' => '<p>Represents the response from the server to set user settings as an administrator.</p>', 'refs' => [], ], 'AdminUpdateDeviceStatusRequest' => [ 'base' => '<p>The request to update the device status, as an administrator.</p>', 'refs' => [], ], 'AdminUpdateDeviceStatusResponse' => [ 'base' => '<p>The status response from the request to update the device, as an administrator.</p>', 'refs' => [], ], 'AdminUpdateUserAttributesRequest' => [ 'base' => '<p>Represents the request to update the user\'s attributes as an administrator.</p>', 'refs' => [], ], 'AdminUpdateUserAttributesResponse' => [ 'base' => '<p>Represents the response from the server for the request to update user attributes as an administrator.</p>', 'refs' => [], ], 'AdminUserGlobalSignOutRequest' => [ 'base' => '<p>The request to sign out of all devices, as an administrator.</p>', 'refs' => [], ], 'AdminUserGlobalSignOutResponse' => [ 'base' => '<p>The global sign-out response, as an administrator.</p>', 'refs' => [], ], 'AliasAttributeType' => [ 'base' => NULL, 'refs' => [ 'AliasAttributesListType$member' => NULL, ], ], 'AliasAttributesListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$AliasAttributes' => '<p>Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or <b>preferred_username</b>.</p>', 'UserPoolType$AliasAttributes' => '<p>Specifies the attributes that are aliased in a user pool.</p>', ], ], 'AliasExistsException' => [ 'base' => '<p>This exception is thrown when a user tries to confirm the account with an email or phone number that has already been supplied as an alias from a different account. This exception tells user that an account with this email or phone already exists.</p>', 'refs' => [], ], 'ArnType' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$RoleArn' => '<p>The role ARN for the group.</p>', 'CreateUserImportJobRequest$CloudWatchLogsRoleArn' => '<p>The role ARN for the Amazon CloudWatch Logging role for the user import job.</p>', 'DomainDescriptionType$CloudFrontDistribution' => '<p>The ARN of the CloudFront distribution.</p>', 'EmailConfigurationType$SourceArn' => '<p>The Amazon Resource Name (ARN) of the email source.</p>', 'GroupType$RoleArn' => '<p>The role ARN for the group.</p>', 'LambdaConfigType$PreSignUp' => '<p>A pre-registration AWS Lambda trigger.</p>', 'LambdaConfigType$CustomMessage' => '<p>A custom Message AWS Lambda trigger.</p>', 'LambdaConfigType$PostConfirmation' => '<p>A post-confirmation AWS Lambda trigger.</p>', 'LambdaConfigType$PreAuthentication' => '<p>A pre-authentication AWS Lambda trigger.</p>', 'LambdaConfigType$PostAuthentication' => '<p>A post-authentication AWS Lambda trigger.</p>', 'LambdaConfigType$DefineAuthChallenge' => '<p>Defines the authentication challenge.</p>', 'LambdaConfigType$CreateAuthChallenge' => '<p>Creates an authentication challenge.</p>', 'LambdaConfigType$VerifyAuthChallengeResponse' => '<p>Verifies the authentication challenge response.</p>', 'SmsConfigurationType$SnsCallerArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) caller.</p>', 'UpdateGroupRequest$RoleArn' => '<p>The new role ARN for the group. This is used for setting the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in the token.</p>', 'UserImportJobType$CloudWatchLogsRoleArn' => '<p>The role ARN for the Amazon CloudWatch Logging role for the user import job. For more information, see "Creating the CloudWatch Logs IAM Role" in the Amazon Cognito Developer Guide.</p>', ], ], 'AttributeDataType' => [ 'base' => NULL, 'refs' => [ 'SchemaAttributeType$AttributeDataType' => '<p>The attribute data type.</p>', ], ], 'AttributeListType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$UserAttributes' => '<p>An array of name-value pairs that contain user attributes and attribute values to be set for the user to be created. You can create a user without specifying any attributes other than <code>Username</code>. However, any attributes that you specify as required (in <a href="API_CreateUserPool.html">CreateUserPool</a> or in the <b>Attributes</b> tab of the console) must be supplied either by you (in your call to <code>AdminCreateUser</code>) or by the user (when he or she signs up in response to your welcome message).</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p> <p>To send a message inviting the user to sign up, you must specify the user\'s email address or phone number. This can be done in your call to AdminCreateUser or in the <b>Users</b> tab of the Amazon Cognito console for managing your user pools.</p> <p>In your call to <code>AdminCreateUser</code>, you can set the <code>email_verified</code> attribute to <code>True</code>, and you can set the <code>phone_number_verified</code> attribute to <code>True</code>. (You can also do this by calling <a href="API_AdminUpdateUserAttributes.html">AdminUpdateUserAttributes</a>.)</p> <ul> <li> <p> <b>email</b>: The email address of the user to whom the message that contains the code and username will be sent. Required if the <code>email_verified</code> attribute is set to <code>True</code>, or if <code>"EMAIL"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li> <li> <p> <b>phone_number</b>: The phone number of the user to whom the message that contains the code and username will be sent. Required if the <code>phone_number_verified</code> attribute is set to <code>True</code>, or if <code>"SMS"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li> </ul>', 'AdminCreateUserRequest$ValidationData' => '<p>The user\'s validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. For example, you might choose to allow or disallow user sign-up based on the user\'s domain.</p> <p>To configure custom validation, you must create a Pre Sign-up Lambda trigger for the user pool as described in the Amazon Cognito Developer Guide. The Lambda trigger receives the validation data and uses it in the validation process.</p> <p>The user\'s validation data is not persisted.</p>', 'AdminGetUserResponse$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p>', 'AdminUpdateUserAttributesRequest$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', 'DeviceType$DeviceAttributes' => '<p>The device attributes.</p>', 'GetUserResponse$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', 'SignUpRequest$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', 'SignUpRequest$ValidationData' => '<p>The validation data in the request to register a user.</p>', 'UpdateUserAttributesRequest$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', 'UserType$Attributes' => '<p>A container with information about the user type attributes.</p>', ], ], 'AttributeMappingKeyType' => [ 'base' => NULL, 'refs' => [ 'AttributeMappingType$key' => NULL, ], ], 'AttributeMappingType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$AttributeMapping' => '<p>A mapping of identity provider attributes to standard and custom user pool attributes.</p>', 'IdentityProviderType$AttributeMapping' => '<p>A mapping of identity provider attributes to standard and custom user pool attributes.</p>', 'UpdateIdentityProviderRequest$AttributeMapping' => '<p>The identity provider attribute mapping to be changed.</p>', ], ], 'AttributeNameListType' => [ 'base' => NULL, 'refs' => [ 'AdminDeleteUserAttributesRequest$UserAttributeNames' => '<p>An array of strings representing the user attribute names you wish to delete.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', 'DeleteUserAttributesRequest$UserAttributeNames' => '<p>An array of strings representing the user attribute names you wish to delete.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', ], ], 'AttributeNameType' => [ 'base' => NULL, 'refs' => [ 'AttributeNameListType$member' => NULL, 'AttributeType$Name' => '<p>The name of the attribute.</p>', 'CodeDeliveryDetailsType$AttributeName' => '<p>The name of the attribute in the code delivery details type.</p>', 'GetUserAttributeVerificationCodeRequest$AttributeName' => '<p>The attribute name returned by the server response to get the user attribute verification code.</p>', 'MFAOptionType$AttributeName' => '<p>The attribute name of the MFA option type.</p>', 'SearchedAttributeNamesListType$member' => NULL, 'VerifyUserAttributeRequest$AttributeName' => '<p>The attribute name in the request to verify user attributes.</p>', ], ], 'AttributeType' => [ 'base' => '<p>Specifies whether the attribute is standard or custom.</p>', 'refs' => [ 'AttributeListType$member' => NULL, ], ], 'AttributeValueType' => [ 'base' => NULL, 'refs' => [ 'AttributeType$Value' => '<p>The value of the attribute.</p>', ], ], 'AuthFlowType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthRequest$AuthFlow' => '<p>The authentication flow for this call to execute. The API action will depend on this value. For example:</p> <ul> <li> <p> <code>REFRESH_TOKEN_AUTH</code> will take in a valid refresh token and return new tokens.</p> </li> <li> <p> <code>USER_SRP_AUTH</code> will take in <code>USERNAME</code> and <code>SRP_A</code> and return the SRP variables to be used for next challenge execution.</p> </li> </ul> <p>Valid values include:</p> <ul> <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li> <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li> <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li> <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: Non-SRP authentication flow; you can pass in the USERNAME and PASSWORD directly if the flow is enabled for calling the app client.</p> </li> </ul>', 'InitiateAuthRequest$AuthFlow' => '<p>The authentication flow for this call to execute. The API action will depend on this value. For example: </p> <ul> <li> <p> <code>REFRESH_TOKEN_AUTH</code> will take in a valid refresh token and return new tokens.</p> </li> <li> <p> <code>USER_SRP_AUTH</code> will take in <code>USERNAME</code> and <code>SRP_A</code> and return the SRP variables to be used for next challenge execution.</p> </li> </ul> <p>Valid values include:</p> <ul> <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li> <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li> <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li> </ul> <p> <code>ADMIN_NO_SRP_AUTH</code> is not a valid value.</p>', ], ], 'AuthParametersType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthRequest$AuthParameters' => '<p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you are invoking. The required values depend on the value of <code>AuthFlow</code>:</p> <ul> <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code> </p> </li> <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>REFRESH_TOKEN</code> (required), <code>DEVICE_KEY</code> </p> </li> <li> <p>For <code>ADMIN_NO_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>PASSWORD</code> (required), <code>DEVICE_KEY</code> </p> </li> <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code> </p> </li> </ul>', 'InitiateAuthRequest$AuthParameters' => '<p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you are invoking. The required values depend on the value of <code>AuthFlow</code>:</p> <ul> <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code> </p> </li> <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>REFRESH_TOKEN</code> (required), <code>DEVICE_KEY</code> </p> </li> <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code> </p> </li> </ul>', ], ], 'AuthenticationResultType' => [ 'base' => '<p>The result type of the authentication result.</p>', 'refs' => [ 'AdminInitiateAuthResponse$AuthenticationResult' => '<p>The result of the authentication response. This is only returned if the caller does not need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>', 'AdminRespondToAuthChallengeResponse$AuthenticationResult' => '<p>The result returned by the server in response to the authentication request.</p>', 'InitiateAuthResponse$AuthenticationResult' => '<p>The result of the authentication response. This is only returned if the caller does not need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>', 'RespondToAuthChallengeResponse$AuthenticationResult' => '<p>The result returned by the server in response to the request to respond to the authentication challenge.</p>', ], ], 'BooleanType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserConfigType$AllowAdminCreateUserOnly' => '<p>Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to <code>False</code> if users can sign themselves up via an app.</p>', 'AdminGetUserResponse$Enabled' => '<p>Indicates that the status is enabled.</p>', 'ConfirmDeviceResponse$UserConfirmationNecessary' => '<p>Indicates whether the user confirmation is necessary to confirm the device response.</p>', 'CreateUserPoolClientRequest$AllowedOAuthFlowsUserPoolClient' => '<p>Set to <code>True</code> if the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.</p>', 'DeviceConfigurationType$ChallengeRequiredOnNewDevice' => '<p>Indicates whether a challenge is required on a new device. Only applicable to a new device.</p>', 'DeviceConfigurationType$DeviceOnlyRememberedOnUserPrompt' => '<p>If true, a device is only remembered on user prompt.</p>', 'PasswordPolicyType$RequireUppercase' => '<p>In the password policy that you have set, refers to whether you have required users to use at least one uppercase letter in their password.</p>', 'PasswordPolicyType$RequireLowercase' => '<p>In the password policy that you have set, refers to whether you have required users to use at least one lowercase letter in their password.</p>', 'PasswordPolicyType$RequireNumbers' => '<p>In the password policy that you have set, refers to whether you have required users to use at least one number in their password.</p>', 'PasswordPolicyType$RequireSymbols' => '<p>In the password policy that you have set, refers to whether you have required users to use at least one symbol in their password.</p>', 'SchemaAttributeType$DeveloperOnlyAttribute' => '<p>Specifies whether the attribute type is developer only.</p>', 'SchemaAttributeType$Mutable' => '<p>Specifies whether the attribute can be changed once it has been created.</p>', 'SchemaAttributeType$Required' => '<p>Specifies whether a user pool attribute is required. If the attribute is required and the user does not provide a value, registration or sign-in will fail.</p>', 'SignUpResponse$UserConfirmed' => '<p>A response from the server indicating that a user registration has been confirmed.</p>', 'UpdateUserPoolClientRequest$AllowedOAuthFlowsUserPoolClient' => '<p>Set to TRUE if the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.</p>', 'UserPoolClientType$AllowedOAuthFlowsUserPoolClient' => '<p>Set to TRUE if the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.</p>', 'UserType$Enabled' => '<p>Specifies whether the user is enabled.</p>', ], ], 'CSSType' => [ 'base' => NULL, 'refs' => [ 'SetUICustomizationRequest$CSS' => '<p>The CSS values in the UI customization.</p>', 'UICustomizationType$CSS' => '<p>The CSS values in the UI customization.</p>', ], ], 'CSSVersionType' => [ 'base' => NULL, 'refs' => [ 'UICustomizationType$CSSVersion' => '<p>The CSS version number.</p>', ], ], 'CallbackURLsListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$CallbackURLs' => '<p>A list of allowed callback URLs for the identity providers.</p>', 'UpdateUserPoolClientRequest$CallbackURLs' => '<p>A list of allowed callback URLs for the identity providers.</p>', 'UserPoolClientType$CallbackURLs' => '<p>A list of allowed callback URLs for the identity providers.</p>', ], ], 'ChallengeNameType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthResponse$ChallengeName' => '<p>The name of the challenge which you are responding to with this call. This is returned to you in the <code>AdminInitiateAuth</code> response if you need to pass another challenge.</p> <ul> <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li> <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li> <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li> <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was enabled on your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li> <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li> <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: This is returned if you need to authenticate with <code>USERNAME</code> and <code>PASSWORD</code> directly. An app client must be enabled to use this flow.</p> </li> <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users which are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li> </ul>', 'AdminRespondToAuthChallengeRequest$ChallengeName' => '<p>The challenge name. For more information, see <a href="API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>', 'AdminRespondToAuthChallengeResponse$ChallengeName' => '<p>The name of the challenge. For more information, see <a href="API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>', 'InitiateAuthResponse$ChallengeName' => '<p>The name of the challenge which you are responding to with this call. This is returned to you in the <code>AdminInitiateAuth</code> response if you need to pass another challenge.</p> <p>Valid values include the following. Note that all of these challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable) in the parameters.</p> <ul> <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li> <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li> <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li> <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was enabled on your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li> <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li> <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users which are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li> </ul>', 'RespondToAuthChallengeRequest$ChallengeName' => '<p>The challenge name. For more information, see <a href="API_InitiateAuth.html">InitiateAuth</a>.</p> <p> <code>ADMIN_NO_SRP_AUTH</code> is not a valid value.</p>', 'RespondToAuthChallengeResponse$ChallengeName' => '<p>The challenge name. For more information, see <a href="API_InitiateAuth.html">InitiateAuth</a>.</p>', ], ], 'ChallengeParametersType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthResponse$ChallengeParameters' => '<p>The challenge parameters. These are returned to you in the <code>AdminInitiateAuth</code> response if you need to pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>AdminRespondToAuthChallenge</code>).</p> <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p> <p>The value of the <code>USER_IF_FOR_SRP</code> attribute will be the user\'s actual username, not an alias (such as email address or phone number), even if you specified an alias in your call to <code>AdminInitiateAuth</code>. This is because, in the <code>AdminRespondToAuthChallenge</code> API <code>ChallengeResponses</code>, the <code>USERNAME</code> attribute cannot be an alias.</p>', 'AdminRespondToAuthChallengeResponse$ChallengeParameters' => '<p>The challenge parameters. For more information, see <a href="API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>', 'InitiateAuthResponse$ChallengeParameters' => '<p>The challenge parameters. These are returned to you in the <code>InitiateAuth</code> response if you need to pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>RespondToAuthChallenge</code>). </p> <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p>', 'RespondToAuthChallengeResponse$ChallengeParameters' => '<p>The challenge parameters. For more information, see <a href="API_InitiateAuth.html">InitiateAuth</a>.</p>', ], ], 'ChallengeResponsesType' => [ 'base' => NULL, 'refs' => [ 'AdminRespondToAuthChallengeRequest$ChallengeResponses' => '<p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p> <ul> <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> </li> <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> </li> <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: <code>PASSWORD</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li> <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li> </ul> <p>The value of the <code>USERNAME</code> attribute must be the user\'s actual username, not an alias (such as email address or phone number). To make this easier, the <code>AdminInitiateAuth</code> response includes the actual username value in the <code>USERNAMEUSER_ID_FOR_SRP</code> attribute, even if you specified an alias in your call to <code>AdminInitiateAuth</code>.</p>', 'RespondToAuthChallengeRequest$ChallengeResponses' => '<p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p> <ul> <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> </li> <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> </li> <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li> </ul>', ], ], 'ChangePasswordRequest' => [ 'base' => '<p>Represents the request to change a user password.</p>', 'refs' => [], ], 'ChangePasswordResponse' => [ 'base' => '<p>The response from the server to the change password request.</p>', 'refs' => [], ], 'ClientIdType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthRequest$ClientId' => '<p>The app client ID.</p>', 'AdminRespondToAuthChallengeRequest$ClientId' => '<p>The app client ID.</p>', 'ConfirmForgotPasswordRequest$ClientId' => '<p>The app client ID of the app associated with the user pool.</p>', 'ConfirmSignUpRequest$ClientId' => '<p>The ID of the app client associated with the user pool.</p>', 'DeleteUserPoolClientRequest$ClientId' => '<p>The app client ID of the app associated with the user pool.</p>', 'DescribeUserPoolClientRequest$ClientId' => '<p>The app client ID of the app associated with the user pool.</p>', 'ForgotPasswordRequest$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'GetUICustomizationRequest$ClientId' => '<p>The client ID for the client app.</p>', 'InitiateAuthRequest$ClientId' => '<p>The app client ID.</p>', 'ResendConfirmationCodeRequest$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'RespondToAuthChallengeRequest$ClientId' => '<p>The app client ID.</p>', 'SetUICustomizationRequest$ClientId' => '<p>The client ID for the client app.</p>', 'SignUpRequest$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'UICustomizationType$ClientId' => '<p>The client ID for the client app.</p>', 'UpdateUserPoolClientRequest$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'UserPoolClientDescription$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'UserPoolClientType$ClientId' => '<p>The ID of the client associated with the user pool.</p>', ], ], 'ClientMetadataType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthRequest$ClientMetadata' => '<p>This is a random key-value pair map which can contain any key and will be passed to your PreAuthentication Lambda trigger as-is. It can be used to implement additional validations around authentication.</p>', 'InitiateAuthRequest$ClientMetadata' => '<p>This is a random key-value pair map which can contain any key and will be passed to your PreAuthentication Lambda trigger as-is. It can be used to implement additional validations around authentication.</p>', ], ], 'ClientNameType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$ClientName' => '<p>The client name for the user pool client you would like to create.</p>', 'UpdateUserPoolClientRequest$ClientName' => '<p>The client name from the update user pool client request.</p>', 'UserPoolClientDescription$ClientName' => '<p>The client name from the user pool client description.</p>', 'UserPoolClientType$ClientName' => '<p>The client name from the user pool request of the client type.</p>', ], ], 'ClientPermissionListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$ReadAttributes' => '<p>The read attributes.</p>', 'CreateUserPoolClientRequest$WriteAttributes' => '<p>The write attributes.</p>', 'UpdateUserPoolClientRequest$ReadAttributes' => '<p>The read-only attributes of the user pool.</p>', 'UpdateUserPoolClientRequest$WriteAttributes' => '<p>The writeable attributes of the user pool.</p>', 'UserPoolClientType$ReadAttributes' => '<p>The Read-only attributes.</p>', 'UserPoolClientType$WriteAttributes' => '<p>The writeable attributes.</p>', ], ], 'ClientPermissionType' => [ 'base' => NULL, 'refs' => [ 'ClientPermissionListType$member' => NULL, ], ], 'ClientSecretType' => [ 'base' => NULL, 'refs' => [ 'UserPoolClientType$ClientSecret' => '<p>The client secret from the user pool request of the client type.</p>', ], ], 'CodeDeliveryDetailsListType' => [ 'base' => NULL, 'refs' => [ 'UpdateUserAttributesResponse$CodeDeliveryDetailsList' => '<p>The code delivery details list from the server for the request to update user attributes.</p>', ], ], 'CodeDeliveryDetailsType' => [ 'base' => '<p>The type of code delivery details being returned from the server.</p>', 'refs' => [ 'CodeDeliveryDetailsListType$member' => NULL, 'ForgotPasswordResponse$CodeDeliveryDetails' => '<p>The code delivery details returned by the server in response to the request to reset a password.</p>', 'GetUserAttributeVerificationCodeResponse$CodeDeliveryDetails' => '<p>The code delivery details returned by the server in response to the request to get the user attribute verification code.</p>', 'ResendConfirmationCodeResponse$CodeDeliveryDetails' => '<p>The code delivery details returned by the server in response to the request to resend the confirmation code.</p>', 'SignUpResponse$CodeDeliveryDetails' => '<p>The code delivery details returned by the server response to the user registration request.</p>', ], ], 'CodeDeliveryFailureException' => [ 'base' => '<p>This exception is thrown when a verification code fails to deliver successfully.</p>', 'refs' => [], ], 'CodeMismatchException' => [ 'base' => '<p>This exception is thrown if the provided code does not match what the server was expecting.</p>', 'refs' => [], ], 'CompletionMessageType' => [ 'base' => NULL, 'refs' => [ 'UserImportJobType$CompletionMessage' => '<p>The message returned when the user import job is completed.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>This exception is thrown if two or more modifications are happening concurrently.</p>', 'refs' => [], ], 'ConfirmDeviceRequest' => [ 'base' => '<p>Confirms the device request.</p>', 'refs' => [], ], 'ConfirmDeviceResponse' => [ 'base' => '<p>Confirms the device response.</p>', 'refs' => [], ], 'ConfirmForgotPasswordRequest' => [ 'base' => '<p>The request representing the confirmation for a password reset.</p>', 'refs' => [], ], 'ConfirmForgotPasswordResponse' => [ 'base' => '<p>The response from the server that results from a user\'s request to retrieve a forgotten password.</p>', 'refs' => [], ], 'ConfirmSignUpRequest' => [ 'base' => '<p>Represents the request to confirm registration of a user.</p>', 'refs' => [], ], 'ConfirmSignUpResponse' => [ 'base' => '<p>Represents the response from the server for the registration confirmation.</p>', 'refs' => [], ], 'ConfirmationCodeType' => [ 'base' => NULL, 'refs' => [ 'ConfirmForgotPasswordRequest$ConfirmationCode' => '<p>The confirmation code sent by a user\'s request to retrieve a forgotten password. For more information, see <a href="API_ForgotPassword.html">ForgotPassword</a> </p>', 'ConfirmSignUpRequest$ConfirmationCode' => '<p>The confirmation code sent by a user\'s request to confirm registration.</p>', 'VerifyUserAttributeRequest$Code' => '<p>The verification code in the request to verify user attributes.</p>', ], ], 'CreateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserImportJobRequest' => [ 'base' => '<p>Represents the request to create the user import job.</p>', 'refs' => [], ], 'CreateUserImportJobResponse' => [ 'base' => '<p>Represents the response from the server to the request to create the user import job.</p>', 'refs' => [], ], 'CreateUserPoolClientRequest' => [ 'base' => '<p>Represents the request to create a user pool client.</p>', 'refs' => [], ], 'CreateUserPoolClientResponse' => [ 'base' => '<p>Represents the response from the server to create a user pool client.</p>', 'refs' => [], ], 'CreateUserPoolDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserPoolDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserPoolRequest' => [ 'base' => '<p>Represents the request to create a user pool.</p>', 'refs' => [], ], 'CreateUserPoolResponse' => [ 'base' => '<p>Represents the response from the server for the request to create a user pool.</p>', 'refs' => [], ], 'CustomAttributeNameType' => [ 'base' => NULL, 'refs' => [ 'SchemaAttributeType$Name' => '<p>A schema attribute of the name type.</p>', ], ], 'CustomAttributesListType' => [ 'base' => NULL, 'refs' => [ 'AddCustomAttributesRequest$CustomAttributes' => '<p>An array of custom attributes, such as Mutable and Name.</p>', ], ], 'DateType' => [ 'base' => NULL, 'refs' => [ 'AdminGetUserResponse$UserCreateDate' => '<p>The date the user was created.</p>', 'AdminGetUserResponse$UserLastModifiedDate' => '<p>The date the user was last modified.</p>', 'DeviceType$DeviceCreateDate' => '<p>The creation date of the device.</p>', 'DeviceType$DeviceLastModifiedDate' => '<p>The last modified date of the device.</p>', 'DeviceType$DeviceLastAuthenticatedDate' => '<p>The date in which the device was last authenticated.</p>', 'GroupType$LastModifiedDate' => '<p>The date the group was last modified.</p>', 'GroupType$CreationDate' => '<p>The date the group was created.</p>', 'IdentityProviderType$LastModifiedDate' => '<p>The date the identity provider was last modified.</p>', 'IdentityProviderType$CreationDate' => '<p>The date the identity provider was created.</p>', 'ProviderDescription$LastModifiedDate' => '<p>The date the provider was last modified.</p>', 'ProviderDescription$CreationDate' => '<p>The date the provider was added to the user pool.</p>', 'UICustomizationType$LastModifiedDate' => '<p>The last-modified date for the UI customization.</p>', 'UICustomizationType$CreationDate' => '<p>The creation date for the UI customization.</p>', 'UserImportJobType$CreationDate' => '<p>The date the user import job was created.</p>', 'UserImportJobType$StartDate' => '<p>The date when the user import job was started.</p>', 'UserImportJobType$CompletionDate' => '<p>The date when the user import job was completed.</p>', 'UserPoolClientType$LastModifiedDate' => '<p>The date the user pool client was last modified.</p>', 'UserPoolClientType$CreationDate' => '<p>The date the user pool client was created.</p>', 'UserPoolDescriptionType$LastModifiedDate' => '<p>The date the user pool description was last modified.</p>', 'UserPoolDescriptionType$CreationDate' => '<p>The date the user pool description was created.</p>', 'UserPoolType$LastModifiedDate' => '<p>The date the user pool was last modified.</p>', 'UserPoolType$CreationDate' => '<p>The date the user pool was created.</p>', 'UserType$UserCreateDate' => '<p>The creation date of the user.</p>', 'UserType$UserLastModifiedDate' => '<p>The last modified date of the user.</p>', ], ], 'DefaultEmailOptionType' => [ 'base' => NULL, 'refs' => [ 'VerificationMessageTemplateType$DefaultEmailOption' => '<p>The default email option.</p>', ], ], 'DeleteGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserAttributesRequest' => [ 'base' => '<p>Represents the request to delete user attributes.</p>', 'refs' => [], ], 'DeleteUserAttributesResponse' => [ 'base' => '<p>Represents the response from the server to delete user attributes.</p>', 'refs' => [], ], 'DeleteUserPoolClientRequest' => [ 'base' => '<p>Represents the request to delete a user pool client.</p>', 'refs' => [], ], 'DeleteUserPoolDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserPoolDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserPoolRequest' => [ 'base' => '<p>Represents the request to delete a user pool.</p>', 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => '<p>Represents the request to delete a user.</p>', 'refs' => [], ], 'DeliveryMediumListType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$DesiredDeliveryMediums' => '<p>Specify <code>"EMAIL"</code> if email will be used to send the welcome message. Specify <code>"SMS"</code> if the phone number will be used. The default value is <code>"SMS"</code>. More than one value can be specified.</p>', ], ], 'DeliveryMediumType' => [ 'base' => NULL, 'refs' => [ 'CodeDeliveryDetailsType$DeliveryMedium' => '<p>The delivery medium (email message or phone number).</p>', 'DeliveryMediumListType$member' => NULL, 'MFAOptionType$DeliveryMedium' => '<p>The delivery medium (email message or SMS message) to send the MFA code.</p>', ], ], 'DescribeIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserImportJobRequest' => [ 'base' => '<p>Represents the request to describe the user import job.</p>', 'refs' => [], ], 'DescribeUserImportJobResponse' => [ 'base' => '<p>Represents the response from the server to the request to describe the user import job.</p>', 'refs' => [], ], 'DescribeUserPoolClientRequest' => [ 'base' => '<p>Represents the request to describe a user pool client.</p>', 'refs' => [], ], 'DescribeUserPoolClientResponse' => [ 'base' => '<p>Represents the response from the server from a request to describe the user pool client.</p>', 'refs' => [], ], 'DescribeUserPoolDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserPoolDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserPoolRequest' => [ 'base' => '<p>Represents the request to describe the user pool.</p>', 'refs' => [], ], 'DescribeUserPoolResponse' => [ 'base' => '<p>Represents the response to describe the user pool.</p>', 'refs' => [], ], 'DescriptionType' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$Description' => '<p>A string containing the description of the group.</p>', 'GroupType$Description' => '<p>A string containing the description of the group.</p>', 'UpdateGroupRequest$Description' => '<p>A string containing the new description of the group.</p>', ], ], 'DeviceConfigurationType' => [ 'base' => '<p>The type of configuration for the user pool\'s device tracking.</p>', 'refs' => [ 'CreateUserPoolRequest$DeviceConfiguration' => '<p>The device configuration.</p>', 'UpdateUserPoolRequest$DeviceConfiguration' => '<p>Device configuration.</p>', 'UserPoolType$DeviceConfiguration' => '<p>The device configuration.</p>', ], ], 'DeviceKeyType' => [ 'base' => NULL, 'refs' => [ 'AdminForgetDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'AdminGetDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'AdminUpdateDeviceStatusRequest$DeviceKey' => '<p>The device key.</p>', 'ConfirmDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'DeviceType$DeviceKey' => '<p>The device key.</p>', 'ForgetDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'GetDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'NewDeviceMetadataType$DeviceKey' => '<p>The device key.</p>', 'UpdateDeviceStatusRequest$DeviceKey' => '<p>The device key.</p>', ], ], 'DeviceListType' => [ 'base' => NULL, 'refs' => [ 'AdminListDevicesResponse$Devices' => '<p>The devices in the list of devices response.</p>', 'ListDevicesResponse$Devices' => '<p>The devices returned in the list devices response.</p>', ], ], 'DeviceNameType' => [ 'base' => NULL, 'refs' => [ 'ConfirmDeviceRequest$DeviceName' => '<p>The device name.</p>', ], ], 'DeviceRememberedStatusType' => [ 'base' => NULL, 'refs' => [ 'AdminUpdateDeviceStatusRequest$DeviceRememberedStatus' => '<p>The status indicating whether a device has been remembered or not.</p>', 'UpdateDeviceStatusRequest$DeviceRememberedStatus' => '<p>The status of whether a device is remembered.</p>', ], ], 'DeviceSecretVerifierConfigType' => [ 'base' => '<p>The device verifier against which it will be authenticated.</p>', 'refs' => [ 'ConfirmDeviceRequest$DeviceSecretVerifierConfig' => '<p>The configuration of the device secret verifier.</p>', ], ], 'DeviceType' => [ 'base' => '<p>The device type.</p>', 'refs' => [ 'AdminGetDeviceResponse$Device' => '<p>The device.</p>', 'DeviceListType$member' => NULL, 'GetDeviceResponse$Device' => '<p>The device.</p>', ], ], 'DomainDescriptionType' => [ 'base' => '<p>A container for information about a domain.</p>', 'refs' => [ 'DescribeUserPoolDomainResponse$DomainDescription' => '<p>A domain description object containing information about the domain.</p>', ], ], 'DomainStatusType' => [ 'base' => NULL, 'refs' => [ 'DomainDescriptionType$Status' => '<p>The domain status.</p>', ], ], 'DomainType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolDomainRequest$Domain' => '<p>The domain string.</p>', 'DeleteUserPoolDomainRequest$Domain' => '<p>The domain string.</p>', 'DescribeUserPoolDomainRequest$Domain' => '<p>The domain string.</p>', 'DomainDescriptionType$Domain' => '<p>The domain string.</p>', ], ], 'DomainVersionType' => [ 'base' => NULL, 'refs' => [ 'DomainDescriptionType$Version' => '<p>The app version.</p>', ], ], 'DuplicateProviderException' => [ 'base' => '<p>This exception is thrown when the provider is already supported by the user pool.</p>', 'refs' => [], ], 'EmailAddressType' => [ 'base' => NULL, 'refs' => [ 'EmailConfigurationType$ReplyToEmailAddress' => '<p>The REPLY-TO email address.</p>', ], ], 'EmailConfigurationType' => [ 'base' => '<p>The email configuration type.</p>', 'refs' => [ 'CreateUserPoolRequest$EmailConfiguration' => '<p>The email configuration.</p>', 'UpdateUserPoolRequest$EmailConfiguration' => '<p>Email configuration.</p>', 'UserPoolType$EmailConfiguration' => '<p>The email configuration.</p>', ], ], 'EmailVerificationMessageByLinkType' => [ 'base' => NULL, 'refs' => [ 'VerificationMessageTemplateType$EmailMessageByLink' => '<p>The email message template for sending a confirmation link to the user.</p>', ], ], 'EmailVerificationMessageType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$EmailVerificationMessage' => '<p>A string representing the email verification message.</p>', 'MessageTemplateType$EmailMessage' => '<p>The message template for email messages.</p>', 'UpdateUserPoolRequest$EmailVerificationMessage' => '<p>The contents of the email verification message.</p>', 'UserPoolType$EmailVerificationMessage' => '<p>The contents of the email verification message.</p>', 'VerificationMessageTemplateType$EmailMessage' => '<p>The email message template.</p>', ], ], 'EmailVerificationSubjectByLinkType' => [ 'base' => NULL, 'refs' => [ 'VerificationMessageTemplateType$EmailSubjectByLink' => '<p>The subject line for the email message template for sending a confirmation link to the user.</p>', ], ], 'EmailVerificationSubjectType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$EmailVerificationSubject' => '<p>A string representing the email verification subject.</p>', 'MessageTemplateType$EmailSubject' => '<p>The subject line for email messages.</p>', 'UpdateUserPoolRequest$EmailVerificationSubject' => '<p>The subject of the email verification message.</p>', 'UserPoolType$EmailVerificationSubject' => '<p>The subject of the email verification message.</p>', 'VerificationMessageTemplateType$EmailSubject' => '<p>The subject line for the email message template.</p>', ], ], 'ExpiredCodeException' => [ 'base' => '<p>This exception is thrown if a code has expired.</p>', 'refs' => [], ], 'ExplicitAuthFlowsListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$ExplicitAuthFlows' => '<p>The explicit authentication flows.</p>', 'UpdateUserPoolClientRequest$ExplicitAuthFlows' => '<p>Explicit authentication flows.</p>', 'UserPoolClientType$ExplicitAuthFlows' => '<p>The explicit authentication flows.</p>', ], ], 'ExplicitAuthFlowsType' => [ 'base' => NULL, 'refs' => [ 'ExplicitAuthFlowsListType$member' => NULL, ], ], 'ForceAliasCreation' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$ForceAliasCreation' => '<p>This parameter is only used if the <code>phone_number_verified</code> or <code>email_verified</code> attribute is set to <code>True</code>. Otherwise, it is ignored.</p> <p>If this parameter is set to <code>True</code> and the phone number or email address specified in the UserAttributes parameter already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias.</p> <p>If this parameter is set to <code>False</code>, the API throws an <code>AliasExistsException</code> error if the alias already exists. The default value is <code>False</code>.</p>', 'ConfirmSignUpRequest$ForceAliasCreation' => '<p>Boolean to be specified to force user confirmation irrespective of existing alias. By default set to <code>False</code>. If this parameter is set to <code>True</code> and the phone number/email used for sign up confirmation already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user being confirmed. If set to <code>False</code>, the API will throw an <b>AliasExistsException</b> error.</p>', ], ], 'ForgetDeviceRequest' => [ 'base' => '<p>Represents the request to forget the device.</p>', 'refs' => [], ], 'ForgotPasswordRequest' => [ 'base' => '<p>Represents the request to reset a user\'s password.</p>', 'refs' => [], ], 'ForgotPasswordResponse' => [ 'base' => '<p>Respresents the response from the server regarding the request to reset a password.</p>', 'refs' => [], ], 'GenerateSecret' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$GenerateSecret' => '<p>Boolean to specify whether you want to generate a secret for the user pool client being created.</p>', ], ], 'GetCSVHeaderRequest' => [ 'base' => '<p>Represents the request to get the header information for the .csv file for the user import job.</p>', 'refs' => [], ], 'GetCSVHeaderResponse' => [ 'base' => '<p>Represents the response from the server to the request to get the header information for the .csv file for the user import job.</p>', 'refs' => [], ], 'GetDeviceRequest' => [ 'base' => '<p>Represents the request to get the device.</p>', 'refs' => [], ], 'GetDeviceResponse' => [ 'base' => '<p>Gets the device response.</p>', 'refs' => [], ], 'GetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIdentityProviderByIdentifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIdentityProviderByIdentifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUICustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUICustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserAttributeVerificationCodeRequest' => [ 'base' => '<p>Represents the request to get user attribute verification.</p>', 'refs' => [], ], 'GetUserAttributeVerificationCodeResponse' => [ 'base' => '<p>The verification code response returned by the server response to get the user attribute verification code.</p>', 'refs' => [], ], 'GetUserRequest' => [ 'base' => '<p>Represents the request to get information about the user.</p>', 'refs' => [], ], 'GetUserResponse' => [ 'base' => '<p>Represents the response from the server from the request to get information about the user.</p>', 'refs' => [], ], 'GlobalSignOutRequest' => [ 'base' => '<p>Represents the request to sign out all devices.</p>', 'refs' => [], ], 'GlobalSignOutResponse' => [ 'base' => '<p>The response to the request to sign out all devices.</p>', 'refs' => [], ], 'GroupExistsException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters a group that already exists in the user pool.</p>', 'refs' => [], ], 'GroupListType' => [ 'base' => NULL, 'refs' => [ 'AdminListGroupsForUserResponse$Groups' => '<p>The groups that the user belongs to.</p>', 'ListGroupsResponse$Groups' => '<p>The group objects for the groups.</p>', ], ], 'GroupNameType' => [ 'base' => NULL, 'refs' => [ 'AdminAddUserToGroupRequest$GroupName' => '<p>The group name.</p>', 'AdminRemoveUserFromGroupRequest$GroupName' => '<p>The group name.</p>', 'CreateGroupRequest$GroupName' => '<p>The name of the group. Must be unique.</p>', 'DeleteGroupRequest$GroupName' => '<p>The name of the group.</p>', 'GetGroupRequest$GroupName' => '<p>The name of the group.</p>', 'GroupType$GroupName' => '<p>The name of the group.</p>', 'ListUsersInGroupRequest$GroupName' => '<p>The name of the group.</p>', 'UpdateGroupRequest$GroupName' => '<p>The name of the group.</p>', ], ], 'GroupType' => [ 'base' => '<p>The group type.</p>', 'refs' => [ 'CreateGroupResponse$Group' => '<p>The group object for the group.</p>', 'GetGroupResponse$Group' => '<p>The group object for the group.</p>', 'GroupListType$member' => NULL, 'UpdateGroupResponse$Group' => '<p>The group object for the group.</p>', ], ], 'IdentityProviderType' => [ 'base' => '<p>A container for information about an identity provider.</p>', 'refs' => [ 'CreateIdentityProviderResponse$IdentityProvider' => '<p>The newly created identity provider object.</p>', 'DescribeIdentityProviderResponse$IdentityProvider' => '<p>The identity provider that was deleted.</p>', 'GetIdentityProviderByIdentifierResponse$IdentityProvider' => '<p>The identity provider object.</p>', 'UpdateIdentityProviderResponse$IdentityProvider' => '<p>The identity provider object.</p>', ], ], 'IdentityProviderTypeType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$ProviderType' => '<p>The identity provider type.</p>', 'IdentityProviderType$ProviderType' => '<p>The identity provider type.</p>', 'ProviderDescription$ProviderType' => '<p>The identity provider type.</p>', ], ], 'IdpIdentifierType' => [ 'base' => NULL, 'refs' => [ 'GetIdentityProviderByIdentifierRequest$IdpIdentifier' => '<p>The identity provider ID.</p>', 'IdpIdentifiersListType$member' => NULL, ], ], 'IdpIdentifiersListType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$IdpIdentifiers' => '<p>A list of identity provider identifiers.</p>', 'IdentityProviderType$IdpIdentifiers' => '<p>A list of identity provider identifiers.</p>', 'UpdateIdentityProviderRequest$IdpIdentifiers' => '<p>A list of identity provider identifiers.</p>', ], ], 'ImageFileType' => [ 'base' => NULL, 'refs' => [ 'SetUICustomizationRequest$ImageFile' => '<p>The uploaded logo image for the UI customization.</p>', ], ], 'ImageUrlType' => [ 'base' => NULL, 'refs' => [ 'UICustomizationType$ImageUrl' => '<p>The logo image for the UI customization.</p>', ], ], 'InitiateAuthRequest' => [ 'base' => '<p>Initiates the authentication request.</p>', 'refs' => [], ], 'InitiateAuthResponse' => [ 'base' => '<p>Initiates the authentication response.</p>', 'refs' => [], ], 'IntegerType' => [ 'base' => NULL, 'refs' => [ 'AuthenticationResultType$ExpiresIn' => '<p>The expiration period of the authentication result.</p>', 'UserPoolType$EstimatedNumberOfUsers' => '<p>A number estimating the size of the user pool.</p>', ], ], 'InternalErrorException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters an internal error.</p>', 'refs' => [], ], 'InvalidEmailRoleAccessPolicyException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code: 400.</p>', 'refs' => [], ], 'InvalidLambdaResponseException' => [ 'base' => '<p>This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.</p>', 'refs' => [], ], 'InvalidOAuthFlowException' => [ 'base' => '<p>This exception is thrown when the specified OAuth flow is invalid.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>', 'refs' => [], ], 'InvalidPasswordException' => [ 'base' => '<p>This exception is thrown when the Amazon Cognito service encounters an invalid password.</p>', 'refs' => [], ], 'InvalidSmsRoleAccessPolicyException' => [ 'base' => '<p>This exception is returned when the role provided for SMS configuration does not have permission to publish using Amazon SNS.</p>', 'refs' => [], ], 'InvalidSmsRoleTrustRelationshipException' => [ 'base' => '<p>This exception is thrown when the trust relationship is invalid for the role provided for SMS configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>', 'refs' => [], ], 'InvalidUserPoolConfigurationException' => [ 'base' => '<p>This exception is thrown when the user pool configuration is invalid.</p>', 'refs' => [], ], 'LambdaConfigType' => [ 'base' => '<p>Specifies the type of configuration for AWS Lambda triggers.</p>', 'refs' => [ 'CreateUserPoolRequest$LambdaConfig' => '<p>The Lambda trigger configuration information for the new user pool.</p>', 'UpdateUserPoolRequest$LambdaConfig' => '<p>The AWS Lambda configuration information from the request to update the user pool.</p>', 'UserPoolDescriptionType$LambdaConfig' => '<p>The AWS Lambda configuration information in a user pool description.</p>', 'UserPoolType$LambdaConfig' => '<p>A container for the AWS Lambda triggers associated with a user pool.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>This exception is thrown when a user exceeds the limit for a requested AWS resource.</p>', 'refs' => [], ], 'ListDevicesRequest' => [ 'base' => '<p>Represents the request to list the devices.</p>', 'refs' => [], ], 'ListDevicesResponse' => [ 'base' => '<p>Represents the response to list devices.</p>', 'refs' => [], ], 'ListGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentityProvidersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentityProvidersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOfStringTypes' => [ 'base' => NULL, 'refs' => [ 'GetCSVHeaderResponse$CSVHeader' => '<p>The header information for the .csv file for the user import job.</p>', ], ], 'ListProvidersLimitType' => [ 'base' => NULL, 'refs' => [ 'ListIdentityProvidersRequest$MaxResults' => '<p>The maximum number of identity providers to return.</p>', ], ], 'ListResourceServersLimitType' => [ 'base' => NULL, 'refs' => [ 'ListResourceServersRequest$MaxResults' => '<p>The maximum number of resource servers to return.</p>', ], ], 'ListResourceServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserImportJobsRequest' => [ 'base' => '<p>Represents the request to list the user import jobs.</p>', 'refs' => [], ], 'ListUserImportJobsResponse' => [ 'base' => '<p>Represents the response from the server to the request to list the user import jobs.</p>', 'refs' => [], ], 'ListUserPoolClientsRequest' => [ 'base' => '<p>Represents the request to list the user pool clients.</p>', 'refs' => [], ], 'ListUserPoolClientsResponse' => [ 'base' => '<p>Represents the response from the server that lists user pool clients.</p>', 'refs' => [], ], 'ListUserPoolsRequest' => [ 'base' => '<p>Represents the request to list user pools.</p>', 'refs' => [], ], 'ListUserPoolsResponse' => [ 'base' => '<p>Represents the response to list user pools.</p>', 'refs' => [], ], 'ListUsersInGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersInGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => '<p>Represents the request to list users.</p>', 'refs' => [], ], 'ListUsersResponse' => [ 'base' => '<p>The response from the request to list users.</p>', 'refs' => [], ], 'LogoutURLsListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$LogoutURLs' => '<p>A list of allowed logout URLs for the identity providers.</p>', 'UpdateUserPoolClientRequest$LogoutURLs' => '<p>A list of allowed logout URLs for the identity providers.</p>', 'UserPoolClientType$LogoutURLs' => '<p>A list of allowed logout URLs for the identity providers.</p>', ], ], 'LongType' => [ 'base' => NULL, 'refs' => [ 'UserImportJobType$ImportedUsers' => '<p>The number of users that were successfully imported.</p>', 'UserImportJobType$SkippedUsers' => '<p>The number of users that were skipped.</p>', 'UserImportJobType$FailedUsers' => '<p>The number of users that could not be imported.</p>', ], ], 'MFAMethodNotFoundException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito cannot find a multi-factor authentication (MFA) method.</p>', 'refs' => [], ], 'MFAOptionListType' => [ 'base' => NULL, 'refs' => [ 'AdminGetUserResponse$MFAOptions' => '<p>Specifies the options for MFA (e.g., email or phone number).</p>', 'AdminSetUserSettingsRequest$MFAOptions' => '<p>Specifies the options for MFA (e.g., email or phone number).</p>', 'GetUserResponse$MFAOptions' => '<p>Specifies the options for MFA (e.g., email or phone number).</p>', 'SetUserSettingsRequest$MFAOptions' => '<p>Specifies the options for MFA (e.g., email or phone number).</p>', 'UserType$MFAOptions' => '<p>The MFA options for the user.</p>', ], ], 'MFAOptionType' => [ 'base' => '<p>Specifies the different settings for multi-factor authentication (MFA).</p>', 'refs' => [ 'MFAOptionListType$member' => NULL, ], ], 'MessageActionType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$MessageAction' => '<p>Set to <code>"RESEND"</code> to resend the invitation message to a user that already exists and reset the expiration limit on the user\'s account. Set to <code>"SUPPRESS"</code> to suppress sending the message. Only one value can be specified.</p>', ], ], 'MessageTemplateType' => [ 'base' => '<p>The message template structure.</p>', 'refs' => [ 'AdminCreateUserConfigType$InviteMessageTemplate' => '<p>The message template to be used for the welcome message to new users.</p>', ], ], 'MessageType' => [ 'base' => NULL, 'refs' => [ 'AliasExistsException$message' => '<p>The message sent to the user when an alias exists.</p>', 'CodeDeliveryFailureException$message' => '<p>The message sent when a verification code fails to deliver successfully.</p>', 'CodeMismatchException$message' => '<p>The message provided when the code mismatch exception is thrown.</p>', 'ConcurrentModificationException$message' => '<p>The message provided when the concurrent exception is thrown.</p>', 'DuplicateProviderException$message' => NULL, 'ExpiredCodeException$message' => '<p>The message returned when the expired code exception is thrown.</p>', 'GroupExistsException$message' => NULL, 'InternalErrorException$message' => '<p>The message returned when Amazon Cognito throws an internal error exception.</p>', 'InvalidEmailRoleAccessPolicyException$message' => '<p>The message returned when you have an unverified email address or the identity policy is not set on an email address that Amazon Cognito can access.</p>', 'InvalidLambdaResponseException$message' => '<p>The message returned when the Amazon Cognito service throws an invalid AWS Lambda response exception.</p>', 'InvalidOAuthFlowException$message' => NULL, 'InvalidParameterException$message' => '<p>The message returned when the Amazon Cognito service throws an invalid parameter exception.</p>', 'InvalidPasswordException$message' => '<p>The message returned when the Amazon Cognito service throws an invalid user password exception.</p>', 'InvalidSmsRoleAccessPolicyException$message' => '<p>The message retuned when the invalid SMS role access policy exception is thrown.</p>', 'InvalidSmsRoleTrustRelationshipException$message' => '<p>The message returned when the role trust relationship for the SMS message is invalid.</p>', 'InvalidUserPoolConfigurationException$message' => '<p>The message returned when the user pool configuration is invalid.</p>', 'LimitExceededException$message' => '<p>The message returned when Amazon Cognito throws a limit exceeded exception.</p>', 'MFAMethodNotFoundException$message' => '<p>The message returned when Amazon Cognito throws an MFA method not found exception.</p>', 'NotAuthorizedException$message' => '<p>The message returned when the Amazon Cognito service returns a not authorized exception.</p>', 'PasswordResetRequiredException$message' => '<p>The message returned when a password reset is required.</p>', 'PreconditionNotMetException$message' => '<p>The message returned when a precondition is not met.</p>', 'ResourceNotFoundException$message' => '<p>The message returned when the Amazon Cognito service returns a resource not found exception.</p>', 'ScopeDoesNotExistException$message' => NULL, 'TooManyFailedAttemptsException$message' => '<p>The message returned when the Amazon Cognito service returns a too many failed attempts exception.</p>', 'TooManyRequestsException$message' => '<p>The message returned when the Amazon Cognito service returns a too many requests exception.</p>', 'UnexpectedLambdaException$message' => '<p>The message returned when the Amazon Cognito service returns an unexpected AWS Lambda exception.</p>', 'UnsupportedIdentityProviderException$message' => NULL, 'UnsupportedUserStateException$message' => '<p>The message returned when the user is in an unsupported state.</p>', 'UserImportInProgressException$message' => '<p>The message returned when the user pool has an import job running.</p>', 'UserLambdaValidationException$message' => '<p>The message returned when the Amazon Cognito service returns a user validation exception with the AWS Lambda service.</p>', 'UserNotConfirmedException$message' => '<p>The message returned when a user is not confirmed successfully.</p>', 'UserNotFoundException$message' => '<p>The message returned when a user is not found.</p>', 'UserPoolTaggingException$message' => NULL, 'UsernameExistsException$message' => '<p>The message returned when Amazon Cognito throws a user name exists exception.</p>', ], ], 'NewDeviceMetadataType' => [ 'base' => '<p>The new device metadata type.</p>', 'refs' => [ 'AuthenticationResultType$NewDeviceMetadata' => '<p>The new device metadata from an authentication result.</p>', ], ], 'NotAuthorizedException' => [ 'base' => '<p>This exception is thrown when a user is not authorized.</p>', 'refs' => [], ], 'NumberAttributeConstraintsType' => [ 'base' => '<p>The minimum and maximum value of an attribute that is of the number data type.</p>', 'refs' => [ 'SchemaAttributeType$NumberAttributeConstraints' => '<p>Specifies the constraints for an attribute of the number type.</p>', ], ], 'OAuthFlowType' => [ 'base' => NULL, 'refs' => [ 'OAuthFlowsType$member' => NULL, ], ], 'OAuthFlowsType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$AllowedOAuthFlows' => '<p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p> <p>Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>', 'UpdateUserPoolClientRequest$AllowedOAuthFlows' => '<p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p> <p>Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>', 'UserPoolClientType$AllowedOAuthFlows' => '<p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p> <p>Set to <code>token</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>', ], ], 'PaginationKey' => [ 'base' => NULL, 'refs' => [ 'AdminListGroupsForUserRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'AdminListGroupsForUserResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListGroupsRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListGroupsResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUserPoolClientsRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUserPoolClientsResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUsersInGroupRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUsersInGroupResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', ], ], 'PaginationKeyType' => [ 'base' => NULL, 'refs' => [ 'ListIdentityProvidersRequest$NextToken' => '<p>A pagination token.</p>', 'ListIdentityProvidersResponse$NextToken' => '<p>A pagination token.</p>', 'ListResourceServersRequest$NextToken' => '<p>A pagination token.</p>', 'ListResourceServersResponse$NextToken' => '<p>A pagination token.</p>', 'ListUserImportJobsRequest$PaginationToken' => '<p>An identifier that was returned from the previous call to <code>ListUserImportJobs</code>, which can be used to return the next set of import jobs in the list.</p>', 'ListUserImportJobsResponse$PaginationToken' => '<p>An identifier that can be used to return the next set of user import jobs in the list.</p>', 'ListUserPoolsRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUserPoolsResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', ], ], 'PasswordPolicyMinLengthType' => [ 'base' => NULL, 'refs' => [ 'PasswordPolicyType$MinimumLength' => '<p>The minimum length of the password policy that you have set. Cannot be less than 6.</p>', ], ], 'PasswordPolicyType' => [ 'base' => '<p>The password policy type.</p>', 'refs' => [ 'UserPoolPolicyType$PasswordPolicy' => '<p>A container for information about the user pool password policy.</p>', ], ], 'PasswordResetRequiredException' => [ 'base' => '<p>This exception is thrown when a password reset is required.</p>', 'refs' => [], ], 'PasswordType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$TemporaryPassword' => '<p>The user\'s temporary password. This password must conform to the password policy that you specified when you created the user pool.</p> <p>The temporary password is valid only once. To complete the Admin Create User flow, the user must enter the temporary password in the sign-in page along with a new password to be used in all future sign-ins.</p> <p>This parameter is not required. If you do not specify a value, Amazon Cognito generates one for you.</p> <p>The temporary password can only be used until the user account expiration limit that you specified when you created the user pool. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter.</p>', 'ChangePasswordRequest$PreviousPassword' => '<p>The old password in the change password request.</p>', 'ChangePasswordRequest$ProposedPassword' => '<p>The new password in the change password request.</p>', 'ConfirmForgotPasswordRequest$Password' => '<p>The password sent by a user\'s request to retrieve a forgotten password.</p>', 'SignUpRequest$Password' => '<p>The password of the user you wish to register.</p>', ], ], 'PoolQueryLimitType' => [ 'base' => NULL, 'refs' => [ 'ListUserImportJobsRequest$MaxResults' => '<p>The maximum number of import jobs you want the request to return.</p>', 'ListUserPoolsRequest$MaxResults' => '<p>The maximum number of results you want the request to return when listing the user pools.</p>', ], ], 'PreSignedUrlType' => [ 'base' => NULL, 'refs' => [ 'UserImportJobType$PreSignedUrl' => '<p>The pre-signed URL to be used to upload the <code>.csv</code> file.</p>', ], ], 'PrecedenceType' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$Precedence' => '<p>A nonnegative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher or null <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN will be used in the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in the user\'s tokens.</p> <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim is not set in users\' tokens.</p> <p>The default <code>Precedence</code> value is null.</p>', 'GroupType$Precedence' => '<p>A nonnegative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. If a user belongs to two or more groups, it is the group with the highest precedence whose role ARN will be used in the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in the user\'s tokens. Groups with higher <code>Precedence</code> values take precedence over groups with lower <code>Precedence</code> values or with null <code>Precedence</code> values.</p> <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim is not set in users\' tokens.</p> <p>The default <code>Precedence</code> value is null.</p>', 'UpdateGroupRequest$Precedence' => '<p>The new precedence value for the group. For more information about this parameter, see <a href="API_CreateGroup.html">CreateGroup</a>.</p>', ], ], 'PreconditionNotMetException' => [ 'base' => '<p>This exception is thrown when a precondition is not met.</p>', 'refs' => [], ], 'ProviderDescription' => [ 'base' => '<p>A container for identity provider details.</p>', 'refs' => [ 'ProvidersListType$member' => NULL, ], ], 'ProviderDetailsType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$ProviderDetails' => '<p>The identity provider details, such as <code>MetadataURL</code> and <code>MetadataFile</code>.</p>', 'IdentityProviderType$ProviderDetails' => '<p>The identity provider details, such as <code>MetadataURL</code> and <code>MetadataFile</code>.</p>', 'UpdateIdentityProviderRequest$ProviderDetails' => '<p>The identity provider details to be updated, such as <code>MetadataURL</code> and <code>MetadataFile</code>.</p>', ], ], 'ProviderNameType' => [ 'base' => NULL, 'refs' => [ 'DeleteIdentityProviderRequest$ProviderName' => '<p>The identity provider name.</p>', 'DescribeIdentityProviderRequest$ProviderName' => '<p>The identity provider name.</p>', 'IdentityProviderType$ProviderName' => '<p>The identity provider name.</p>', 'ProviderDescription$ProviderName' => '<p>The identity provider name.</p>', 'ProviderUserIdentifierType$ProviderName' => '<p>The name of the provider, for example, Facebook, Google, or Login with Amazon.</p>', 'SupportedIdentityProvidersListType$member' => NULL, 'UpdateIdentityProviderRequest$ProviderName' => '<p>The identity provider name.</p>', ], ], 'ProviderNameTypeV1' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$ProviderName' => '<p>The identity provider name.</p>', ], ], 'ProviderUserIdentifierType' => [ 'base' => '<p>A container for information about an identity provider for a user pool.</p>', 'refs' => [ 'AdminDisableProviderForUserRequest$User' => '<p>The user to be disabled.</p>', 'AdminLinkProviderForUserRequest$DestinationUser' => '<p>The existing user in the user pool to be linked to the external identity provider user account. Can be a native (Username + Password) Cognito User Pools user or a federated user (for example, a SAML or Facebook user). If the user doesn\'t exist, an exception is thrown. This is the user that is returned when the new user (with the linked identity provider attribute) signs in.</p> <p>The <code>ProviderAttributeValue</code> for the <code>DestinationUser</code> must match the username for the user in the user pool. The <code>ProviderAttributeName</code> will always be ignored.</p>', 'AdminLinkProviderForUserRequest$SourceUser' => '<p>An external identity provider account for a user who does not currently exist yet in the user pool. This user must be a federated user (for example, a SAML or Facebook user), not another native user.</p> <p>If the <code>SourceUser</code> is a federated social identity provider user (Facebook, Google, or Login with Amazon), you must set the <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. For social identity providers, the <code>ProviderName</code> will be <code>Facebook</code>, <code>Google</code>, or <code>LoginWithAmazon</code>, and Cognito will automatically parse the Facebook, Google, and Login with Amazon tokens for <code>id</code>, <code>sub</code>, and <code>user_id</code>, respectively. The <code>ProviderAttributeValue</code> for the user must be the same value as the <code>id</code>, <code>sub</code>, or <code>user_id</code> value found in the social identity provider token.</p> <p/> <p>For SAML, the <code>ProviderAttributeName</code> can be any value that matches a claim in the SAML assertion. If you wish to link SAML users based on the subject of the SAML assertion, you should map the subject to a claim through the SAML identity provider and submit that claim name as the <code>ProviderAttributeName</code>. If you set <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>, Cognito will automatically parse the default unique identifier found in the subject from the SAML token.</p>', ], ], 'ProvidersListType' => [ 'base' => NULL, 'refs' => [ 'ListIdentityProvidersResponse$Providers' => '<p>A list of identity provider objects.</p>', ], ], 'QueryLimit' => [ 'base' => NULL, 'refs' => [ 'ListUserPoolClientsRequest$MaxResults' => '<p>The maximum number of results you want the request to return when listing the user pool clients.</p>', ], ], 'QueryLimitType' => [ 'base' => NULL, 'refs' => [ 'AdminListDevicesRequest$Limit' => '<p>The limit of the devices request.</p>', 'AdminListGroupsForUserRequest$Limit' => '<p>The limit of the request to list groups.</p>', 'ListDevicesRequest$Limit' => '<p>The limit of the device request.</p>', 'ListGroupsRequest$Limit' => '<p>The limit of the request to list groups.</p>', 'ListUsersInGroupRequest$Limit' => '<p>The limit of the request to list users.</p>', 'ListUsersRequest$Limit' => '<p>Maximum number of users to be returned.</p>', ], ], 'RedirectUrlType' => [ 'base' => NULL, 'refs' => [ 'CallbackURLsListType$member' => NULL, 'CreateUserPoolClientRequest$DefaultRedirectURI' => '<p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>', 'LogoutURLsListType$member' => NULL, 'UpdateUserPoolClientRequest$DefaultRedirectURI' => '<p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>', 'UserPoolClientType$DefaultRedirectURI' => '<p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>', ], ], 'RefreshTokenValidityType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$RefreshTokenValidity' => '<p>The time limit, in days, after which the refresh token is no longer valid and cannot be used.</p>', 'UpdateUserPoolClientRequest$RefreshTokenValidity' => '<p>The time limit, in days, after which the refresh token is no longer valid and cannot be used.</p>', 'UserPoolClientType$RefreshTokenValidity' => '<p>The time limit, in days, after which the refresh token is no longer valid and cannot be used.</p>', ], ], 'ResendConfirmationCodeRequest' => [ 'base' => '<p>Represents the request to resend the confirmation code.</p>', 'refs' => [], ], 'ResendConfirmationCodeResponse' => [ 'base' => '<p>The response from the server when the Amazon Cognito Your User Pools service makes the request to resend a confirmation code.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>This exception is thrown when the Amazon Cognito service cannot find the requested resource.</p>', 'refs' => [], ], 'ResourceServerIdentifierType' => [ 'base' => NULL, 'refs' => [ 'CreateResourceServerRequest$Identifier' => '<p>A unique resource server identifier for the resource server. This could be an HTTPS endpoint where the resource server is located. For example, <code>https://my-weather-api.example.com</code>.</p>', 'DeleteResourceServerRequest$Identifier' => '<p>The identifier for the resource server.</p>', 'DescribeResourceServerRequest$Identifier' => '<p>The identifier for the resource server</p>', 'ResourceServerType$Identifier' => '<p>The identifier for the resource server.</p>', 'UpdateResourceServerRequest$Identifier' => '<p>The identifier for the resource server.</p>', ], ], 'ResourceServerNameType' => [ 'base' => NULL, 'refs' => [ 'CreateResourceServerRequest$Name' => '<p>A friendly name for the resource server.</p>', 'ResourceServerType$Name' => '<p>The name of the resource server.</p>', 'UpdateResourceServerRequest$Name' => '<p>The name of the resource server.</p>', ], ], 'ResourceServerScopeDescriptionType' => [ 'base' => NULL, 'refs' => [ 'ResourceServerScopeType$ScopeDescription' => '<p>A description of the scope.</p>', ], ], 'ResourceServerScopeListType' => [ 'base' => NULL, 'refs' => [ 'CreateResourceServerRequest$Scopes' => '<p>A list of scopes. Each scope is map, where the keys are <code>name</code> and <code>description</code>.</p>', 'ResourceServerType$Scopes' => '<p>A list of scopes that are defined for the resource server.</p>', 'UpdateResourceServerRequest$Scopes' => '<p>The scope values to be set for the resource server.</p>', ], ], 'ResourceServerScopeNameType' => [ 'base' => NULL, 'refs' => [ 'ResourceServerScopeType$ScopeName' => '<p>The name of the scope.</p>', ], ], 'ResourceServerScopeType' => [ 'base' => '<p>A resource server scope.</p>', 'refs' => [ 'ResourceServerScopeListType$member' => NULL, ], ], 'ResourceServerType' => [ 'base' => '<p>A container for information about a resource server for a user pool.</p>', 'refs' => [ 'CreateResourceServerResponse$ResourceServer' => '<p>The newly created resource server.</p>', 'DescribeResourceServerResponse$ResourceServer' => '<p>The resource server.</p>', 'ResourceServersListType$member' => NULL, 'UpdateResourceServerResponse$ResourceServer' => '<p>The resource server.</p>', ], ], 'ResourceServersListType' => [ 'base' => NULL, 'refs' => [ 'ListResourceServersResponse$ResourceServers' => '<p>The resource servers.</p>', ], ], 'RespondToAuthChallengeRequest' => [ 'base' => '<p>The request to respond to an authentication challenge.</p>', 'refs' => [], ], 'RespondToAuthChallengeResponse' => [ 'base' => '<p>The response to respond to the authentication challenge.</p>', 'refs' => [], ], 'S3BucketType' => [ 'base' => NULL, 'refs' => [ 'DomainDescriptionType$S3Bucket' => '<p>The S3 bucket where the static files for this domain are stored.</p>', ], ], 'SchemaAttributeType' => [ 'base' => '<p>Contains information about the schema attribute.</p>', 'refs' => [ 'CustomAttributesListType$member' => NULL, 'SchemaAttributesListType$member' => NULL, ], ], 'SchemaAttributesListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$Schema' => '<p>An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.</p>', 'UserPoolType$SchemaAttributes' => '<p>A container with the schema attributes of a user pool.</p>', ], ], 'ScopeDoesNotExistException' => [ 'base' => '<p>This exception is thrown when the specified scope does not exist.</p>', 'refs' => [], ], 'ScopeListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$AllowedOAuthScopes' => '<p>A list of allowed <code>OAuth</code> scopes. Currently supported values are <code>"phone"</code>, <code>"email"</code>, <code>"openid"</code>, and <code>"Cognito"</code>.</p>', 'UpdateUserPoolClientRequest$AllowedOAuthScopes' => '<p>A list of allowed <code>OAuth</code> scopes. Currently supported values are <code>"phone"</code>, <code>"email"</code>, <code>"openid"</code>, and <code>"Cognito"</code>.</p>', 'UserPoolClientType$AllowedOAuthScopes' => '<p>A list of allowed <code>OAuth</code> scopes. Currently supported values are <code>"phone"</code>, <code>"email"</code>, <code>"openid"</code>, and <code>"Cognito"</code>.</p>', ], ], 'ScopeType' => [ 'base' => NULL, 'refs' => [ 'ScopeListType$member' => NULL, ], ], 'SearchPaginationTokenType' => [ 'base' => NULL, 'refs' => [ 'AdminListDevicesRequest$PaginationToken' => '<p>The pagination token.</p>', 'AdminListDevicesResponse$PaginationToken' => '<p>The pagination token.</p>', 'ListDevicesRequest$PaginationToken' => '<p>The pagination token for the list request.</p>', 'ListDevicesResponse$PaginationToken' => '<p>The pagination token for the list device response.</p>', 'ListUsersRequest$PaginationToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUsersResponse$PaginationToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', ], ], 'SearchedAttributeNamesListType' => [ 'base' => NULL, 'refs' => [ 'ListUsersRequest$AttributesToGet' => '<p>An array of strings, where each string is the name of a user attribute to be returned for each user in the search results. If the array is empty, all attributes are returned.</p>', ], ], 'SecretHashType' => [ 'base' => NULL, 'refs' => [ 'ConfirmForgotPasswordRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', 'ConfirmSignUpRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', 'ForgotPasswordRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', 'ResendConfirmationCodeRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', 'SignUpRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', ], ], 'SessionType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthResponse$Session' => '<p>The session which should be passed both ways in challenge-response calls to the service. If <code>AdminInitiateAuth</code> or <code>AdminRespondToAuthChallenge</code> API call determines that the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>AdminRespondToAuthChallenge</code> API call.</p>', 'AdminRespondToAuthChallengeRequest$Session' => '<p>The session which should be passed both ways in challenge-response calls to the service. If <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'AdminRespondToAuthChallengeResponse$Session' => '<p>The session which should be passed both ways in challenge-response calls to the service. If the <a href="API_InitiateAuth.html">InitiateAuth</a> or <a href="API_RespondToAuthChallenge.html">RespondToAuthChallenge</a> API call determines that the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'InitiateAuthResponse$Session' => '<p>The session which should be passed both ways in challenge-response calls to the service. If the <a href="API_InitiateAuth.html">InitiateAuth</a> or <a href="API_RespondToAuthChallenge.html">RespondToAuthChallenge</a> API call determines that the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'RespondToAuthChallengeRequest$Session' => '<p>The session which should be passed both ways in challenge-response calls to the service. If <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'RespondToAuthChallengeResponse$Session' => '<p>The session which should be passed both ways in challenge-response calls to the service. If the <a href="API_InitiateAuth.html">InitiateAuth</a> or <a href="API_RespondToAuthChallenge.html">RespondToAuthChallenge</a> API call determines that the caller needs to go through another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', ], ], 'SetUICustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetUICustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'SetUserSettingsRequest' => [ 'base' => '<p>Represents the request to set user settings.</p>', 'refs' => [], ], 'SetUserSettingsResponse' => [ 'base' => '<p>The response from the server for a set user settings request.</p>', 'refs' => [], ], 'SignUpRequest' => [ 'base' => '<p>Represents the request to register a user.</p>', 'refs' => [], ], 'SignUpResponse' => [ 'base' => '<p>The response from the server for a registration request.</p>', 'refs' => [], ], 'SmsConfigurationType' => [ 'base' => '<p>The SMS configuration type.</p>', 'refs' => [ 'CreateUserPoolRequest$SmsConfiguration' => '<p>The SMS configuration.</p>', 'UpdateUserPoolRequest$SmsConfiguration' => '<p>SMS configuration.</p>', 'UserPoolType$SmsConfiguration' => '<p>The SMS configuration.</p>', ], ], 'SmsVerificationMessageType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$SmsVerificationMessage' => '<p>A string representing the SMS verification message.</p>', 'CreateUserPoolRequest$SmsAuthenticationMessage' => '<p>A string representing the SMS authentication message.</p>', 'MessageTemplateType$SMSMessage' => '<p>The message template for SMS messages.</p>', 'UpdateUserPoolRequest$SmsVerificationMessage' => '<p>A container with information about the SMS verification message.</p>', 'UpdateUserPoolRequest$SmsAuthenticationMessage' => '<p>The contents of the SMS authentication message.</p>', 'UserPoolType$SmsVerificationMessage' => '<p>The contents of the SMS verification message.</p>', 'UserPoolType$SmsAuthenticationMessage' => '<p>The contents of the SMS authentication message.</p>', 'VerificationMessageTemplateType$SmsMessage' => '<p>The SMS message template.</p>', ], ], 'StartUserImportJobRequest' => [ 'base' => '<p>Represents the request to start the user import job.</p>', 'refs' => [], ], 'StartUserImportJobResponse' => [ 'base' => '<p>Represents the response from the server to the request to start the user import job.</p>', 'refs' => [], ], 'StatusType' => [ 'base' => NULL, 'refs' => [ 'UserPoolDescriptionType$Status' => '<p>The user pool status in a user pool description.</p>', 'UserPoolType$Status' => '<p>The status of a user pool.</p>', ], ], 'StopUserImportJobRequest' => [ 'base' => '<p>Represents the request to stop the user import job.</p>', 'refs' => [], ], 'StopUserImportJobResponse' => [ 'base' => '<p>Represents the response from the server to the request to stop the user import job.</p>', 'refs' => [], ], 'StringAttributeConstraintsType' => [ 'base' => '<p>The type of constraints associated with an attribute of the string type.</p>', 'refs' => [ 'SchemaAttributeType$StringAttributeConstraints' => '<p>Specifies the constraints for an attribute of the string type.</p>', ], ], 'StringType' => [ 'base' => NULL, 'refs' => [ 'AdminDisableProviderForUserRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AdminLinkProviderForUserRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AttributeMappingType$value' => NULL, 'AuthParametersType$key' => NULL, 'AuthParametersType$value' => NULL, 'AuthenticationResultType$TokenType' => '<p>The token type of the authentication result.</p>', 'ChallengeParametersType$key' => NULL, 'ChallengeParametersType$value' => NULL, 'ChallengeResponsesType$key' => NULL, 'ChallengeResponsesType$value' => NULL, 'ClientMetadataType$key' => NULL, 'ClientMetadataType$value' => NULL, 'CodeDeliveryDetailsType$Destination' => '<p>The destination for the code delivery details.</p>', 'DeviceSecretVerifierConfigType$PasswordVerifier' => '<p>The password verifier.</p>', 'DeviceSecretVerifierConfigType$Salt' => '<p>The salt.</p>', 'ListOfStringTypes$member' => NULL, 'NewDeviceMetadataType$DeviceGroupKey' => '<p>The device group key.</p>', 'NumberAttributeConstraintsType$MinValue' => '<p>The minimum value of an attribute that is of the number data type.</p>', 'NumberAttributeConstraintsType$MaxValue' => '<p>The maximum value of an attribute that is of the number data type.</p>', 'ProviderDetailsType$key' => NULL, 'ProviderDetailsType$value' => NULL, 'ProviderUserIdentifierType$ProviderAttributeName' => '<p>The name of the provider attribute to link to, for example, <code>NameID</code>.</p>', 'ProviderUserIdentifierType$ProviderAttributeValue' => '<p>The value of the provider attribute to link to, for example, <code>xxxxx_account</code>.</p>', 'SignUpResponse$UserSub' => '<p>The UUID of the authenticated user. This is not the same as <code>username</code>.</p>', 'SmsConfigurationType$ExternalId' => '<p>The external ID.</p>', 'StringAttributeConstraintsType$MinLength' => '<p>The minimum length of an attribute value of the string type.</p>', 'StringAttributeConstraintsType$MaxLength' => '<p>The maximum length of an attribute value of the string type.</p>', 'UserPoolTagsType$key' => NULL, 'UserPoolTagsType$value' => NULL, 'UserPoolType$SmsConfigurationFailure' => '<p>The reason why the SMS configuration cannot send the messages to your users.</p>', 'UserPoolType$EmailConfigurationFailure' => '<p>The reason why the email configuration cannot send the messages to your users.</p>', ], ], 'SupportedIdentityProvidersListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$SupportedIdentityProviders' => '<p>A list of provider names for the identity providers that are supported on this client.</p>', 'UpdateUserPoolClientRequest$SupportedIdentityProviders' => '<p>A list of provider names for the identity providers that are supported on this client.</p>', 'UserPoolClientType$SupportedIdentityProviders' => '<p>A list of provider names for the identity providers that are supported on this client.</p>', ], ], 'TokenModelType' => [ 'base' => NULL, 'refs' => [ 'AuthenticationResultType$AccessToken' => '<p>The access token of the authentication result.</p>', 'AuthenticationResultType$RefreshToken' => '<p>The refresh token of the authentication result.</p>', 'AuthenticationResultType$IdToken' => '<p>The ID token of the authentication result.</p>', 'ChangePasswordRequest$AccessToken' => '<p>The access token in the change password request.</p>', 'ConfirmDeviceRequest$AccessToken' => '<p>The access token.</p>', 'DeleteUserAttributesRequest$AccessToken' => '<p>The access token used in the request to delete user attributes.</p>', 'DeleteUserRequest$AccessToken' => '<p>The access token from a request to delete a user.</p>', 'ForgetDeviceRequest$AccessToken' => '<p>The access token for the forgotten device request.</p>', 'GetDeviceRequest$AccessToken' => '<p>The access token.</p>', 'GetUserAttributeVerificationCodeRequest$AccessToken' => '<p>The access token returned by the server response to get the user attribute verification code.</p>', 'GetUserRequest$AccessToken' => '<p>The access token returned by the server response to get information about the user.</p>', 'GlobalSignOutRequest$AccessToken' => '<p>The access token.</p>', 'ListDevicesRequest$AccessToken' => '<p>The access tokens for the request to list devices.</p>', 'SetUserSettingsRequest$AccessToken' => '<p>The access token for the set user settings request.</p>', 'UpdateDeviceStatusRequest$AccessToken' => '<p>The access token.</p>', 'UpdateUserAttributesRequest$AccessToken' => '<p>The access token for the request to update user attributes.</p>', 'VerifyUserAttributeRequest$AccessToken' => '<p>Represents the access token of the request to verify user attributes.</p>', ], ], 'TooManyFailedAttemptsException' => [ 'base' => '<p>This exception is thrown when the user has made too many failed attempts for a given action (e.g., sign in).</p>', 'refs' => [], ], 'TooManyRequestsException' => [ 'base' => '<p>This exception is thrown when the user has made too many requests for a given operation.</p>', 'refs' => [], ], 'UICustomizationType' => [ 'base' => '<p>A container for the UI customization information for a user pool\'s built-in app UI.</p>', 'refs' => [ 'GetUICustomizationResponse$UICustomization' => '<p>The UI customization information.</p>', 'SetUICustomizationResponse$UICustomization' => '<p>The UI customization information.</p>', ], ], 'UnexpectedLambdaException' => [ 'base' => '<p>This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS Lambda service.</p>', 'refs' => [], ], 'UnsupportedIdentityProviderException' => [ 'base' => '<p>This exception is thrown when the specified identifier is not supported.</p>', 'refs' => [], ], 'UnsupportedUserStateException' => [ 'base' => '<p>The request failed because the user is in an unsupported state.</p>', 'refs' => [], ], 'UpdateDeviceStatusRequest' => [ 'base' => '<p>Represents the request to update the device status.</p>', 'refs' => [], ], 'UpdateDeviceStatusResponse' => [ 'base' => '<p>The response to the request to update the device status.</p>', 'refs' => [], ], 'UpdateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserAttributesRequest' => [ 'base' => '<p>Represents the request to update user attributes.</p>', 'refs' => [], ], 'UpdateUserAttributesResponse' => [ 'base' => '<p>Represents the response from the server for the request to update user attributes.</p>', 'refs' => [], ], 'UpdateUserPoolClientRequest' => [ 'base' => '<p>Represents the request to update the user pool client.</p>', 'refs' => [], ], 'UpdateUserPoolClientResponse' => [ 'base' => '<p>Represents the response from the server to the request to update the user pool client.</p>', 'refs' => [], ], 'UpdateUserPoolRequest' => [ 'base' => '<p>Represents the request to update the user pool.</p>', 'refs' => [], ], 'UpdateUserPoolResponse' => [ 'base' => '<p>Represents the response from the server when you make a request to update the user pool.</p>', 'refs' => [], ], 'UserFilterType' => [ 'base' => NULL, 'refs' => [ 'ListUsersRequest$Filter' => '<p>A filter string of the form "<i>AttributeName</i> <i>Filter-Type</i> "<i>AttributeValue</i>"". Quotation marks within the filter string must be escaped using the backslash (\\) character. For example, "<code>family_name</code> = \\"Reddy\\"".</p> <ul> <li> <p> <i>AttributeName</i>: The name of the attribute to search for. You can only search for one attribute at a time.</p> </li> <li> <p> <i>Filter-Type</i>: For an exact match, use =, for example, "<code>given_name</code> = \\"Jon\\"". For a prefix ("starts with") match, use ^=, for example, "<code>given_name</code> ^= \\"Jon\\"". </p> </li> <li> <p> <i>AttributeValue</i>: The attribute value that must be matched for each user.</p> </li> </ul> <p>If the filter string is empty, <code>ListUsers</code> returns all users in the user pool.</p> <p>You can only search for the following standard attributes:</p> <ul> <li> <p> <code>username</code> (case-sensitive)</p> </li> <li> <p> <code>email</code> </p> </li> <li> <p> <code>phone_number</code> </p> </li> <li> <p> <code>name</code> </p> </li> <li> <p> <code>given_name</code> </p> </li> <li> <p> <code>family_name</code> </p> </li> <li> <p> <code>preferred_username</code> </p> </li> <li> <p> <code>cognito:user_status</code> (called <b>Enabled</b> in the Console) (case-sensitive)</p> </li> <li> <p> <code>status</code> (case-insensitive)</p> </li> </ul> <p>Custom attributes are not searchable.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api">Searching for Users Using the ListUsers API</a> and <a href="http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples">Examples of Using the ListUsers API</a> in the <i>Amazon Cognito Developer Guide</i>.</p>', ], ], 'UserImportInProgressException' => [ 'base' => '<p>This exception is thrown when you are trying to modify a user pool while a user import job is in progress for that pool.</p>', 'refs' => [], ], 'UserImportJobIdType' => [ 'base' => NULL, 'refs' => [ 'DescribeUserImportJobRequest$JobId' => '<p>The job ID for the user import job.</p>', 'StartUserImportJobRequest$JobId' => '<p>The job ID for the user import job.</p>', 'StopUserImportJobRequest$JobId' => '<p>The job ID for the user import job.</p>', 'UserImportJobType$JobId' => '<p>The job ID for the user import job.</p>', ], ], 'UserImportJobNameType' => [ 'base' => NULL, 'refs' => [ 'CreateUserImportJobRequest$JobName' => '<p>The job name for the user import job.</p>', 'UserImportJobType$JobName' => '<p>The job name for the user import job.</p>', ], ], 'UserImportJobStatusType' => [ 'base' => NULL, 'refs' => [ 'UserImportJobType$Status' => '<p>The status of the user import job. One of the following:</p> <ul> <li> <p> <code>Created</code> - The job was created but not started.</p> </li> <li> <p> <code>Pending</code> - A transition state. You have started the job, but it has not begun importing users yet.</p> </li> <li> <p> <code>InProgress</code> - The job has started, and users are being imported.</p> </li> <li> <p> <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.</p> </li> <li> <p> <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.</p> </li> <li> <p> <code>Succeeded</code> - The job has completed successfully.</p> </li> <li> <p> <code>Failed</code> - The job has stopped due to an error.</p> </li> <li> <p> <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data associated with the job was deleted, and the job cannot be started.</p> </li> </ul>', ], ], 'UserImportJobType' => [ 'base' => '<p>The user import job type.</p>', 'refs' => [ 'CreateUserImportJobResponse$UserImportJob' => '<p>The job object that represents the user import job.</p>', 'DescribeUserImportJobResponse$UserImportJob' => '<p>The job object that represents the user import job.</p>', 'StartUserImportJobResponse$UserImportJob' => '<p>The job object that represents the user import job.</p>', 'StopUserImportJobResponse$UserImportJob' => '<p>The job object that represents the user import job.</p>', 'UserImportJobsListType$member' => NULL, ], ], 'UserImportJobsListType' => [ 'base' => NULL, 'refs' => [ 'ListUserImportJobsResponse$UserImportJobs' => '<p>The user import jobs.</p>', ], ], 'UserLambdaValidationException' => [ 'base' => '<p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the AWS Lambda service.</p>', 'refs' => [], ], 'UserNotConfirmedException' => [ 'base' => '<p>This exception is thrown when a user is not confirmed successfully.</p>', 'refs' => [], ], 'UserNotFoundException' => [ 'base' => '<p>This exception is thrown when a user is not found.</p>', 'refs' => [], ], 'UserPoolClientDescription' => [ 'base' => '<p>The description of the user pool client.</p>', 'refs' => [ 'UserPoolClientListType$member' => NULL, ], ], 'UserPoolClientListType' => [ 'base' => NULL, 'refs' => [ 'ListUserPoolClientsResponse$UserPoolClients' => '<p>The user pool clients in the response that lists user pool clients.</p>', ], ], 'UserPoolClientType' => [ 'base' => '<p>Contains information about a user pool client.</p>', 'refs' => [ 'CreateUserPoolClientResponse$UserPoolClient' => '<p>The user pool client that was just created.</p>', 'DescribeUserPoolClientResponse$UserPoolClient' => '<p>The user pool client from a server response to describe the user pool client.</p>', 'UpdateUserPoolClientResponse$UserPoolClient' => '<p>The user pool client value from the response from the server when an update user pool client request is made.</p>', ], ], 'UserPoolDescriptionType' => [ 'base' => '<p>A user pool description.</p>', 'refs' => [ 'UserPoolListType$member' => NULL, ], ], 'UserPoolIdType' => [ 'base' => NULL, 'refs' => [ 'AddCustomAttributesRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to add custom attributes.</p>', 'AdminAddUserToGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AdminConfirmSignUpRequest$UserPoolId' => '<p>The user pool ID for which you want to confirm user registration.</p>', 'AdminCreateUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where the user will be created.</p>', 'AdminDeleteUserAttributesRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to delete user attributes.</p>', 'AdminDeleteUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to delete the user.</p>', 'AdminDisableUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to disable the user.</p>', 'AdminEnableUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to enable the user.</p>', 'AdminForgetDeviceRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminGetDeviceRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminGetUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to get information about the user.</p>', 'AdminInitiateAuthRequest$UserPoolId' => '<p>The ID of the Amazon Cognito user pool.</p>', 'AdminListDevicesRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminListGroupsForUserRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AdminRemoveUserFromGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AdminResetUserPasswordRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to reset the user\'s password.</p>', 'AdminRespondToAuthChallengeRequest$UserPoolId' => '<p>The ID of the Amazon Cognito user pool.</p>', 'AdminSetUserSettingsRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to set the user\'s settings, such as MFA options.</p>', 'AdminUpdateDeviceStatusRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminUpdateUserAttributesRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to update user attributes.</p>', 'AdminUserGlobalSignOutRequest$UserPoolId' => '<p>The user pool ID.</p>', 'CreateGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'CreateIdentityProviderRequest$UserPoolId' => '<p>The user pool ID.</p>', 'CreateResourceServerRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'CreateUserImportJobRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'CreateUserPoolClientRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to create a user pool client.</p>', 'CreateUserPoolDomainRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DeleteGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'DeleteIdentityProviderRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DeleteResourceServerRequest$UserPoolId' => '<p>The user pool ID for the user pool that hosts the resource server.</p>', 'DeleteUserPoolClientRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to delete the client.</p>', 'DeleteUserPoolDomainRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DeleteUserPoolRequest$UserPoolId' => '<p>The user pool ID for the user pool you want to delete.</p>', 'DescribeIdentityProviderRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DescribeResourceServerRequest$UserPoolId' => '<p>The user pool ID for the user pool that hosts the resource server.</p>', 'DescribeUserImportJobRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'DescribeUserPoolClientRequest$UserPoolId' => '<p>The user pool ID for the user pool you want to describe.</p>', 'DescribeUserPoolRequest$UserPoolId' => '<p>The user pool ID for the user pool you want to describe.</p>', 'DomainDescriptionType$UserPoolId' => '<p>The user pool ID.</p>', 'GetCSVHeaderRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are to be imported into.</p>', 'GetCSVHeaderResponse$UserPoolId' => '<p>The user pool ID for the user pool that the users are to be imported into.</p>', 'GetGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'GetIdentityProviderByIdentifierRequest$UserPoolId' => '<p>The user pool ID.</p>', 'GetUICustomizationRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'GroupType$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'IdentityProviderType$UserPoolId' => '<p>The user pool ID.</p>', 'ListGroupsRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'ListIdentityProvidersRequest$UserPoolId' => '<p>The user pool ID.</p>', 'ListResourceServersRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'ListUserImportJobsRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'ListUserPoolClientsRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to list user pool clients.</p>', 'ListUsersInGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'ListUsersRequest$UserPoolId' => '<p>The user pool ID for the user pool on which the search should be performed.</p>', 'ResourceServerType$UserPoolId' => '<p>The user pool ID for the user pool that hosts the resource server.</p>', 'SetUICustomizationRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'StartUserImportJobRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'StopUserImportJobRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'UICustomizationType$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'UpdateGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'UpdateIdentityProviderRequest$UserPoolId' => '<p>The user pool ID.</p>', 'UpdateResourceServerRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'UpdateUserPoolClientRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to update the user pool client.</p>', 'UpdateUserPoolRequest$UserPoolId' => '<p>The user pool ID for the user pool you want to update.</p>', 'UserImportJobType$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'UserPoolClientDescription$UserPoolId' => '<p>The user pool ID for the user pool where you want to describe the user pool client.</p>', 'UserPoolClientType$UserPoolId' => '<p>The user pool ID for the user pool client.</p>', 'UserPoolDescriptionType$Id' => '<p>The ID in a user pool description.</p>', 'UserPoolType$Id' => '<p>The ID of the user pool.</p>', ], ], 'UserPoolListType' => [ 'base' => NULL, 'refs' => [ 'ListUserPoolsResponse$UserPools' => '<p>The user pools from the response to list users.</p>', ], ], 'UserPoolMfaType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$MfaConfiguration' => '<p>Specifies MFA configuration details.</p>', 'UpdateUserPoolRequest$MfaConfiguration' => '<p>Can be one of the following values:</p> <ul> <li> <p> <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.</p> </li> <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you are initially creating a user pool.</p> </li> <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li> </ul>', 'UserPoolType$MfaConfiguration' => '<p>Can be one of the following values:</p> <ul> <li> <p> <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.</p> </li> <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you are initially creating a user pool.</p> </li> <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li> </ul>', ], ], 'UserPoolNameType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$PoolName' => '<p>A string used to name the user pool.</p>', 'UserPoolDescriptionType$Name' => '<p>The name in a user pool description.</p>', 'UserPoolType$Name' => '<p>The name of the user pool.</p>', ], ], 'UserPoolPolicyType' => [ 'base' => '<p>The type of policy in a user pool.</p>', 'refs' => [ 'CreateUserPoolRequest$Policies' => '<p>The policies associated with the new user pool.</p>', 'UpdateUserPoolRequest$Policies' => '<p>A container with the policies you wish to update in a user pool.</p>', 'UserPoolType$Policies' => '<p>A container for the policies associated with a user pool.</p>', ], ], 'UserPoolTaggingException' => [ 'base' => '<p>This exception is thrown when a user pool tag cannot be set or updated.</p>', 'refs' => [], ], 'UserPoolTagsType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$UserPoolTags' => '<p>The cost allocation tags for the user pool. For more information, see <a href="http://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-cost-allocation-tagging.html">Adding Cost Allocation Tags to Your User Pool</a> </p>', 'UpdateUserPoolRequest$UserPoolTags' => '<p>The cost allocation tags for the user pool. For more information, see <a href="http://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-cost-allocation-tagging.html">Adding Cost Allocation Tags to Your User Pool</a> </p>', 'UserPoolType$UserPoolTags' => '<p>The cost allocation tags for the user pool. For more information, see <a href="http://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-cost-allocation-tagging.html">Adding Cost Allocation Tags to Your User Pool</a> </p>', ], ], 'UserPoolType' => [ 'base' => '<p>A container for information about the user pool type.</p>', 'refs' => [ 'CreateUserPoolResponse$UserPool' => '<p>A container for the user pool details.</p>', 'DescribeUserPoolResponse$UserPool' => '<p>The container of metadata returned by the server to describe the pool.</p>', ], ], 'UserStatusType' => [ 'base' => NULL, 'refs' => [ 'AdminGetUserResponse$UserStatus' => '<p>The user status. Can be one of the following:</p> <ul> <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li> <li> <p>CONFIRMED - User has been confirmed.</p> </li> <li> <p>ARCHIVED - User is no longer active.</p> </li> <li> <p>COMPROMISED - User is disabled due to a potential security threat.</p> </li> <li> <p>UNKNOWN - User status is not known.</p> </li> </ul>', 'UserType$UserStatus' => '<p>The user status. Can be one of the following:</p> <ul> <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li> <li> <p>CONFIRMED - User has been confirmed.</p> </li> <li> <p>ARCHIVED - User is no longer active.</p> </li> <li> <p>COMPROMISED - User is disabled due to a potential security threat.</p> </li> <li> <p>UNKNOWN - User status is not known.</p> </li> </ul>', ], ], 'UserType' => [ 'base' => '<p>The user type.</p>', 'refs' => [ 'AdminCreateUserResponse$User' => '<p>The newly created user.</p>', 'UsersListType$member' => NULL, ], ], 'UsernameAttributeType' => [ 'base' => NULL, 'refs' => [ 'UsernameAttributesListType$member' => NULL, ], ], 'UsernameAttributesListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$UsernameAttributes' => '<p>Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.</p>', 'UserPoolType$UsernameAttributes' => '<p>Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.</p>', ], ], 'UsernameExistsException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.</p>', 'refs' => [], ], 'UsernameType' => [ 'base' => NULL, 'refs' => [ 'AdminAddUserToGroupRequest$Username' => '<p>The username for the user.</p>', 'AdminConfirmSignUpRequest$Username' => '<p>The user name for which you want to confirm user registration.</p>', 'AdminCreateUserRequest$Username' => '<p>The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.</p>', 'AdminDeleteUserAttributesRequest$Username' => '<p>The user name of the user from which you would like to delete attributes.</p>', 'AdminDeleteUserRequest$Username' => '<p>The user name of the user you wish to delete.</p>', 'AdminDisableUserRequest$Username' => '<p>The user name of the user you wish to disable.</p>', 'AdminEnableUserRequest$Username' => '<p>The user name of the user you wish to enable.</p>', 'AdminForgetDeviceRequest$Username' => '<p>The user name.</p>', 'AdminGetDeviceRequest$Username' => '<p>The user name.</p>', 'AdminGetUserRequest$Username' => '<p>The user name of the user you wish to retrieve.</p>', 'AdminGetUserResponse$Username' => '<p>The user name of the user about whom you are receiving information.</p>', 'AdminListDevicesRequest$Username' => '<p>The user name.</p>', 'AdminListGroupsForUserRequest$Username' => '<p>The username for the user.</p>', 'AdminRemoveUserFromGroupRequest$Username' => '<p>The username for the user.</p>', 'AdminResetUserPasswordRequest$Username' => '<p>The user name of the user whose password you wish to reset.</p>', 'AdminSetUserSettingsRequest$Username' => '<p>The user name of the user for whom you wish to set user settings.</p>', 'AdminUpdateDeviceStatusRequest$Username' => '<p>The user name.</p>', 'AdminUpdateUserAttributesRequest$Username' => '<p>The user name of the user for whom you want to update user attributes.</p>', 'AdminUserGlobalSignOutRequest$Username' => '<p>The user name.</p>', 'ConfirmForgotPasswordRequest$Username' => '<p>The user name of the user for whom you want to enter a code to retrieve a forgotten password.</p>', 'ConfirmSignUpRequest$Username' => '<p>The user name of the user whose registration you wish to confirm.</p>', 'ForgotPasswordRequest$Username' => '<p>The user name of the user for whom you want to enter a code to reset a forgotten password.</p>', 'GetUserResponse$Username' => '<p>The user name of the user you wish to retrieve from the get user request.</p>', 'ResendConfirmationCodeRequest$Username' => '<p>The user name of the user to whom you wish to resend a confirmation code.</p>', 'SignUpRequest$Username' => '<p>The user name of the user you wish to register.</p>', 'UserType$Username' => '<p>The user name of the user you wish to describe.</p>', ], ], 'UsersListType' => [ 'base' => NULL, 'refs' => [ 'ListUsersInGroupResponse$Users' => '<p>The users returned in the request to list users.</p>', 'ListUsersResponse$Users' => '<p>The users returned in the request to list users.</p>', ], ], 'VerificationMessageTemplateType' => [ 'base' => '<p>The template for verification messages.</p>', 'refs' => [ 'CreateUserPoolRequest$VerificationMessageTemplate' => '<p>The template for the verification message that the user sees when the app requests permission to access the user\'s information.</p>', 'UpdateUserPoolRequest$VerificationMessageTemplate' => '<p>The template for verification messages.</p>', 'UserPoolType$VerificationMessageTemplate' => '<p>The template for verification messages.</p>', ], ], 'VerifiedAttributeType' => [ 'base' => NULL, 'refs' => [ 'VerifiedAttributesListType$member' => NULL, ], ], 'VerifiedAttributesListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$AutoVerifiedAttributes' => '<p>The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.</p>', 'UpdateUserPoolRequest$AutoVerifiedAttributes' => '<p>The attributes that are automatically verified when the Amazon Cognito service makes a request to update user pools.</p>', 'UserPoolType$AutoVerifiedAttributes' => '<p>Specifies the attributes that are auto-verified in a user pool.</p>', ], ], 'VerifyUserAttributeRequest' => [ 'base' => '<p>Represents the request to verify user attributes.</p>', 'refs' => [], ], 'VerifyUserAttributeResponse' => [ 'base' => '<p>A container representing the response from the server from the request to verify user attributes.</p>', 'refs' => [], ], ],];
