<?php
// This file was auto-generated from sdk-root/src/data/devicefarm/2015-06-23/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS Device Farm is a service that enables mobile app developers to test Android, iOS, and Fire OS apps on physical phones, tablets, and other devices in the cloud.</p>', 'operations' => [ 'CreateDevicePool' => '<p>Creates a device pool.</p>', 'CreateNetworkProfile' => '<p>Creates a network profile.</p>', 'CreateProject' => '<p>Creates a new project.</p>', 'CreateRemoteAccessSession' => '<p>Specifies and starts a remote access session.</p>', 'CreateUpload' => '<p>Uploads an app or test scripts.</p>', 'DeleteDevicePool' => '<p>Deletes a device pool given the pool ARN. Does not allow deletion of curated pools owned by the system.</p>', 'DeleteNetworkProfile' => '<p>Deletes a network profile.</p>', 'DeleteProject' => '<p>Deletes an AWS Device Farm project, given the project ARN.</p> <p> <b>Note</b> Deleting this resource does not stop an in-progress run.</p>', 'DeleteRemoteAccessSession' => '<p>Deletes a completed remote access session and its results.</p>', 'DeleteRun' => '<p>Deletes the run, given the run ARN.</p> <p> <b>Note</b> Deleting this resource does not stop an in-progress run.</p>', 'DeleteUpload' => '<p>Deletes an upload given the upload ARN.</p>', 'GetAccountSettings' => '<p>Returns the number of unmetered iOS and/or unmetered Android devices that have been purchased by the account.</p>', 'GetDevice' => '<p>Gets information about a unique device type.</p>', 'GetDevicePool' => '<p>Gets information about a device pool.</p>', 'GetDevicePoolCompatibility' => '<p>Gets information about compatibility with a device pool.</p>', 'GetJob' => '<p>Gets information about a job.</p>', 'GetNetworkProfile' => '<p>Returns information about a network profile.</p>', 'GetOfferingStatus' => '<p>Gets the current status and future status of all offerings purchased by an AWS account. The response indicates how many offerings are currently available and the offerings that will be available in the next period. The API returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you should be able to invoke this operation.</p>', 'GetProject' => '<p>Gets information about a project.</p>', 'GetRemoteAccessSession' => '<p>Returns a link to a currently running remote access session.</p>', 'GetRun' => '<p>Gets information about a run.</p>', 'GetSuite' => '<p>Gets information about a suite.</p>', 'GetTest' => '<p>Gets information about a test.</p>', 'GetUpload' => '<p>Gets information about an upload.</p>', 'InstallToRemoteAccessSession' => '<p>Installs an application to the device in a remote access session. For Android applications, the file must be in .apk format. For iOS applications, the file must be in .ipa format.</p>', 'ListArtifacts' => '<p>Gets information about artifacts.</p>', 'ListDevicePools' => '<p>Gets information about device pools.</p>', 'ListDevices' => '<p>Gets information about unique device types.</p>', 'ListJobs' => '<p>Gets information about jobs.</p>', 'ListNetworkProfiles' => '<p>Returns the list of available network profiles.</p>', 'ListOfferingPromotions' => '<p>Returns a list of offering promotions. Each offering promotion record contains the ID and description of the promotion. The API returns a <code>NotEligible</code> error if the caller is not permitted to invoke the operation. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you should be able to invoke this operation.</p>', 'ListOfferingTransactions' => '<p>Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you should be able to invoke this operation.</p>', 'ListOfferings' => '<p>Returns a list of products or offerings that the user can manage through the API. Each offering record indicates the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you should be able to invoke this operation.</p>', 'ListProjects' => '<p>Gets information about projects.</p>', 'ListRemoteAccessSessions' => '<p>Returns a list of all currently running remote access sessions.</p>', 'ListRuns' => '<p>Gets information about runs, given an AWS Device Farm project ARN.</p>', 'ListSamples' => '<p>Gets information about samples, given an AWS Device Farm project ARN</p>', 'ListSuites' => '<p>Gets information about suites.</p>', 'ListTests' => '<p>Gets information about tests.</p>', 'ListUniqueProblems' => '<p>Gets information about unique problems.</p>', 'ListUploads' => '<p>Gets information about uploads, given an AWS Device Farm project ARN.</p>', 'PurchaseOffering' => '<p>Immediately purchases offerings for an AWS account. Offerings renew with the latest total purchased quantity for an offering, unless the renewal was overridden. The API returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you should be able to invoke this operation.</p>', 'RenewOffering' => '<p>Explicitly sets the quantity of devices to renew for an offering, starting from the <code>effectiveDate</code> of the next period. The API returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you should be able to invoke this operation.</p>', 'ScheduleRun' => '<p>Schedules a run.</p>', 'StopRemoteAccessSession' => '<p>Ends a specified remote access session.</p>', 'StopRun' => '<p>Initiates a stop request for the current test run. AWS Device Farm will immediately stop the run on devices where tests have not started executing, and you will not be billed for these devices. On devices where tests have started executing, Setup Suite and Teardown Suite tests will run to completion before stopping execution on those devices. You will be billed for Setup, Teardown, and any tests that were in progress or already completed.</p>', 'UpdateDevicePool' => '<p>Modifies the name, description, and rules in a device pool given the attributes and the pool ARN. Rule updates are all-or-nothing, meaning they can only be updated as a whole (or not at all).</p>', 'UpdateNetworkProfile' => '<p>Updates the network profile with specific settings.</p>', 'UpdateProject' => '<p>Modifies the specified project name, given the project ARN and a new name.</p>', ], 'shapes' => [ 'AWSAccountNumber' => [ 'base' => NULL, 'refs' => [ 'AccountSettings$awsAccountNumber' => '<p>The AWS account number specified in the <code>AccountSettings</code> container.</p>', ], ], 'AccountSettings' => [ 'base' => '<p>A container for account-level settings within AWS Device Farm.</p>', 'refs' => [ 'GetAccountSettingsResult$accountSettings' => '<p>The account settings.</p>', ], ], 'AccountsCleanup' => [ 'base' => NULL, 'refs' => [ 'ExecutionConfiguration$accountsCleanup' => '<p>True if account cleanup is enabled at the beginning of the test; otherwise, false.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'AmazonResourceNames$member' => NULL, 'Artifact$arn' => '<p>The artifact\'s ARN.</p>', 'CreateDevicePoolRequest$projectArn' => '<p>The ARN of the project for the device pool.</p>', 'CreateNetworkProfileRequest$projectArn' => '<p>The Amazon Resource Name (ARN) of the project for which you want to create a network profile.</p>', 'CreateRemoteAccessSessionRequest$projectArn' => '<p>The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.</p>', 'CreateRemoteAccessSessionRequest$deviceArn' => '<p>The Amazon Resource Name (ARN) of the device for which you want to create a remote access session.</p>', 'CreateUploadRequest$projectArn' => '<p>The ARN of the project for the upload.</p>', 'DeleteDevicePoolRequest$arn' => '<p>Represents the Amazon Resource Name (ARN) of the Device Farm device pool you wish to delete.</p>', 'DeleteNetworkProfileRequest$arn' => '<p>The Amazon Resource Name (ARN) of the network profile you want to delete.</p>', 'DeleteProjectRequest$arn' => '<p>Represents the Amazon Resource Name (ARN) of the Device Farm project you wish to delete.</p>', 'DeleteRemoteAccessSessionRequest$arn' => '<p>The Amazon Resource Name (ARN) of the sesssion for which you want to delete remote access.</p>', 'DeleteRunRequest$arn' => '<p>The Amazon Resource Name (ARN) for the run you wish to delete.</p>', 'DeleteUploadRequest$arn' => '<p>Represents the Amazon Resource Name (ARN) of the Device Farm upload you wish to delete.</p>', 'Device$arn' => '<p>The device\'s ARN.</p>', 'DevicePool$arn' => '<p>The device pool\'s ARN.</p>', 'GetDevicePoolCompatibilityRequest$devicePoolArn' => '<p>The device pool\'s ARN.</p>', 'GetDevicePoolCompatibilityRequest$appArn' => '<p>The ARN of the app that is associated with the specified device pool.</p>', 'GetDevicePoolRequest$arn' => '<p>The device pool\'s ARN.</p>', 'GetDeviceRequest$arn' => '<p>The device type\'s ARN.</p>', 'GetJobRequest$arn' => '<p>The job\'s ARN.</p>', 'GetNetworkProfileRequest$arn' => '<p>The Amazon Resource Name (ARN) of the network profile you want to return information about.</p>', 'GetProjectRequest$arn' => '<p>The project\'s ARN.</p>', 'GetRemoteAccessSessionRequest$arn' => '<p>The Amazon Resource Name (ARN) of the remote access session about which you want to get session information.</p>', 'GetRunRequest$arn' => '<p>The run\'s ARN.</p>', 'GetSuiteRequest$arn' => '<p>The suite\'s ARN.</p>', 'GetTestRequest$arn' => '<p>The test\'s ARN.</p>', 'GetUploadRequest$arn' => '<p>The upload\'s ARN.</p>', 'InstallToRemoteAccessSessionRequest$remoteAccessSessionArn' => '<p>The Amazon Resource Name (ARN) of the remote access session about which you are requesting information.</p>', 'InstallToRemoteAccessSessionRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the app about which you are requesting information.</p>', 'Job$arn' => '<p>The job\'s ARN.</p>', 'ListArtifactsRequest$arn' => '<p>The Run, Job, Suite, or Test ARN.</p>', 'ListDevicePoolsRequest$arn' => '<p>The project ARN.</p>', 'ListDevicesRequest$arn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', 'ListJobsRequest$arn' => '<p>The jobs\' ARNs.</p>', 'ListNetworkProfilesRequest$arn' => '<p>The Amazon Resource Name (ARN) of the project for which you want to list network profiles.</p>', 'ListProjectsRequest$arn' => '<p>Optional. If no Amazon Resource Name (ARN) is specified, then AWS Device Farm returns a list of all projects for the AWS account. You can also specify a project ARN.</p>', 'ListRemoteAccessSessionsRequest$arn' => '<p>The Amazon Resource Name (ARN) of the remote access session about which you are requesting information.</p>', 'ListRunsRequest$arn' => '<p>The Amazon Resource Name (ARN) of the project for which you want to list runs.</p>', 'ListSamplesRequest$arn' => '<p>The Amazon Resource Name (ARN) of the project for which you want to list samples.</p>', 'ListSuitesRequest$arn' => '<p>The suites\' ARNs.</p>', 'ListTestsRequest$arn' => '<p>The tests\' ARNs.</p>', 'ListUniqueProblemsRequest$arn' => '<p>The unique problems\' ARNs.</p>', 'ListUploadsRequest$arn' => '<p>The Amazon Resource Name (ARN) of the project for which you want to list uploads.</p>', 'NetworkProfile$arn' => '<p>The Amazon Resource Name (ARN) of the network profile.</p>', 'ProblemDetail$arn' => '<p>The problem detail\'s ARN.</p>', 'Project$arn' => '<p>The project\'s ARN.</p>', 'RemoteAccessSession$arn' => '<p>The Amazon Resource Name (ARN) of the remote access session.</p>', 'Run$arn' => '<p>The run\'s ARN.</p>', 'Sample$arn' => '<p>The sample\'s ARN.</p>', 'ScheduleRunConfiguration$extraDataPackageArn' => '<p>The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will extract to external data for Android or the app\'s sandbox for iOS.</p>', 'ScheduleRunConfiguration$networkProfileArn' => '<p>Reserved for internal use.</p>', 'ScheduleRunRequest$projectArn' => '<p>The ARN of the project for the run to be scheduled.</p>', 'ScheduleRunRequest$appArn' => '<p>The ARN of the app to schedule a run.</p>', 'ScheduleRunRequest$devicePoolArn' => '<p>The ARN of the device pool for the run to be scheduled.</p>', 'ScheduleRunTest$testPackageArn' => '<p>The ARN of the uploaded test that will be run.</p>', 'StopRemoteAccessSessionRequest$arn' => '<p>The Amazon Resource Name (ARN) of the remote access session you wish to stop.</p>', 'StopRunRequest$arn' => '<p>Represents the Amazon Resource Name (ARN) of the Device Farm run you wish to stop.</p>', 'Suite$arn' => '<p>The suite\'s ARN.</p>', 'Test$arn' => '<p>The test\'s ARN.</p>', 'UpdateDevicePoolRequest$arn' => '<p>The Amazon Resourc Name (ARN) of the Device Farm device pool you wish to update.</p>', 'UpdateNetworkProfileRequest$arn' => '<p>The Amazon Resource Name (ARN) of the project that you wish to update network profile settings.</p>', 'UpdateProjectRequest$arn' => '<p>The Amazon Resource Name (ARN) of the project whose name you wish to update.</p>', 'Upload$arn' => '<p>The upload\'s ARN.</p>', ], ], 'AmazonResourceNames' => [ 'base' => NULL, 'refs' => [ 'ScheduleRunConfiguration$auxiliaryApps' => '<p>A list of auxiliary apps for the run.</p>', ], ], 'AppPackagesCleanup' => [ 'base' => NULL, 'refs' => [ 'ExecutionConfiguration$appPackagesCleanup' => '<p>True if app package cleanup is enabled at the beginning of the test; otherwise, false.</p>', ], ], 'ArgumentException' => [ 'base' => '<p>An invalid argument was specified.</p>', 'refs' => [], ], 'Artifact' => [ 'base' => '<p>Represents the output of a test. Examples of artifacts include logs and screenshots.</p>', 'refs' => [ 'Artifacts$member' => NULL, ], ], 'ArtifactCategory' => [ 'base' => NULL, 'refs' => [ 'ListArtifactsRequest$type' => '<p>The artifacts\' type.</p> <p>Allowed values include:</p> <ul> <li> <p>FILE: The artifacts are files.</p> </li> <li> <p>LOG: The artifacts are logs.</p> </li> <li> <p>SCREENSHOT: The artifacts are screenshots.</p> </li> </ul>', ], ], 'ArtifactType' => [ 'base' => NULL, 'refs' => [ 'Artifact$type' => '<p>The artifact\'s type.</p> <p>Allowed values include the following:</p> <ul> <li> <p>UNKNOWN: An unknown type.</p> </li> <li> <p>SCREENSHOT: The screenshot type.</p> </li> <li> <p>DEVICE_LOG: The device log type.</p> </li> <li> <p>MESSAGE_LOG: The message log type.</p> </li> <li> <p>RESULT_LOG: The result log type.</p> </li> <li> <p>SERVICE_LOG: The service log type.</p> </li> <li> <p>WEBKIT_LOG: The web kit log type.</p> </li> <li> <p>INSTRUMENTATION_OUTPUT: The instrumentation type.</p> </li> <li> <p>EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an Android fuzz test.</p> </li> <li> <p>CALABASH_JSON_OUTPUT: The Calabash JSON output type.</p> </li> <li> <p>CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.</p> </li> <li> <p>CALABASH_STANDARD_OUTPUT: The Calabash standard output type.</p> </li> <li> <p>CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.</p> </li> <li> <p>AUTOMATION_OUTPUT: The automation output type.</p> </li> <li> <p>APPIUM_SERVER_OUTPUT: The Appium server output type.</p> </li> <li> <p>APPIUM_JAVA_OUTPUT: The Appium Java output type.</p> </li> <li> <p>APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.</p> </li> <li> <p>APPIUM_PYTHON_OUTPUT: The Appium Python output type.</p> </li> <li> <p>APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.</p> </li> <li> <p>EXPLORER_EVENT_LOG: The Explorer event log output type.</p> </li> <li> <p>EXPLORER_SUMMARY_LOG: The Explorer summary log output type.</p> </li> <li> <p>APPLICATION_CRASH_REPORT: The application crash report output type.</p> </li> <li> <p>XCTEST_LOG: The XCode test output type.</p> </li> </ul>', ], ], 'Artifacts' => [ 'base' => NULL, 'refs' => [ 'ListArtifactsResult$artifacts' => '<p>Information about the artifacts.</p>', ], ], 'BillingMethod' => [ 'base' => NULL, 'refs' => [ 'CreateRemoteAccessSessionConfiguration$billingMethod' => '<p>Returns the billing method for purposes of configuring a remote access session.</p>', 'RemoteAccessSession$billingMethod' => '<p>The billing method of the remote access session. Possible values include <code>METERED</code> or <code>UNMETERED</code>. For more information about metered devices, see <a href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS Device Farm terminology</a>."</p>', 'Run$billingMethod' => '<p>Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter is not specified, the default value is <code>metered</code>.</p>', 'ScheduleRunConfiguration$billingMethod' => '<p>Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter is not specified, the default value is <code>metered</code>.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Device$remoteAccessEnabled' => '<p>Specifies whether remote access has been enabled for the specified device.</p>', 'DevicePoolCompatibilityResult$compatible' => '<p>Whether the result was compatible with the device pool.</p>', 'Radios$wifi' => '<p>True if Wi-Fi is enabled at the beginning of the test; otherwise, false.</p>', 'Radios$bluetooth' => '<p>True if Bluetooth is enabled at the beginning of the test; otherwise, false.</p>', 'Radios$nfc' => '<p>True if NFC is enabled at the beginning of the test; otherwise, false.</p>', 'Radios$gps' => '<p>True if GPS is enabled at the beginning of the test; otherwise, false.</p>', ], ], 'CPU' => [ 'base' => '<p>Represents the amount of CPU that an app is using on a physical device.</p> <p>Note that this does not represent system-wide CPU usage.</p>', 'refs' => [ 'Device$cpu' => '<p>Information about the device\'s CPU.</p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'CreateUploadRequest$contentType' => '<p>The upload\'s content type (for example, "application/octet-stream").</p>', 'Upload$contentType' => '<p>The upload\'s content type (for example, "application/octet-stream").</p>', ], ], 'Counters' => [ 'base' => '<p>Represents entity counters.</p>', 'refs' => [ 'Job$counters' => '<p>The job\'s result counters.</p>', 'Run$counters' => '<p>The run\'s result counters.</p>', 'Suite$counters' => '<p>The suite\'s result counters.</p>', 'Test$counters' => '<p>The test\'s result counters.</p>', ], ], 'CreateDevicePoolRequest' => [ 'base' => '<p>Represents a request to the create device pool operation.</p>', 'refs' => [], ], 'CreateDevicePoolResult' => [ 'base' => '<p>Represents the result of a create device pool request.</p>', 'refs' => [], ], 'CreateNetworkProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectRequest' => [ 'base' => '<p>Represents a request to the create project operation.</p>', 'refs' => [], ], 'CreateProjectResult' => [ 'base' => '<p>Represents the result of a create project request.</p>', 'refs' => [], ], 'CreateRemoteAccessSessionConfiguration' => [ 'base' => '<p>Creates the configuration settings for a remote access session, including the device model and type.</p>', 'refs' => [ 'CreateRemoteAccessSessionRequest$configuration' => '<p>The configuration information for the remote access session request.</p>', ], ], 'CreateRemoteAccessSessionRequest' => [ 'base' => '<p>Creates and submits a request to start a remote access session.</p>', 'refs' => [], ], 'CreateRemoteAccessSessionResult' => [ 'base' => '<p>Represents the server response from a request to create a remote access session.</p>', 'refs' => [], ], 'CreateUploadRequest' => [ 'base' => '<p>Represents a request to the create upload operation.</p>', 'refs' => [], ], 'CreateUploadResult' => [ 'base' => '<p>Represents the result of a create upload request.</p>', 'refs' => [], ], 'CurrencyCode' => [ 'base' => NULL, 'refs' => [ 'MonetaryAmount$currencyCode' => '<p>The currency code of a monetary amount. For example, <code>USD</code> means "U.S. dollars."</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'Job$created' => '<p>When the job was created.</p>', 'Job$started' => '<p>The job\'s start time.</p>', 'Job$stopped' => '<p>The job\'s stop time.</p>', 'OfferingStatus$effectiveOn' => '<p>The date on which the offering is effective.</p>', 'OfferingTransaction$createdOn' => '<p>The date on which an offering transaction was created.</p>', 'Project$created' => '<p>When the project was created.</p>', 'RemoteAccessSession$created' => '<p>The date and time the remote access session was created.</p>', 'RemoteAccessSession$started' => '<p>The date and time the remote access session was started.</p>', 'RemoteAccessSession$stopped' => '<p>The date and time the remote access session was stopped.</p>', 'Run$created' => '<p>When the run was created.</p>', 'Run$started' => '<p>The run\'s start time.</p>', 'Run$stopped' => '<p>The run\'s stop time.</p>', 'Suite$created' => '<p>When the suite was created.</p>', 'Suite$started' => '<p>The suite\'s start time.</p>', 'Suite$stopped' => '<p>The suite\'s stop time.</p>', 'Test$created' => '<p>When the test was created.</p>', 'Test$started' => '<p>The test\'s start time.</p>', 'Test$stopped' => '<p>The test\'s stop time.</p>', 'Upload$created' => '<p>When the upload was created.</p>', ], ], 'DeleteDevicePoolRequest' => [ 'base' => '<p>Represents a request to the delete device pool operation.</p>', 'refs' => [], ], 'DeleteDevicePoolResult' => [ 'base' => '<p>Represents the result of a delete device pool request.</p>', 'refs' => [], ], 'DeleteNetworkProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectRequest' => [ 'base' => '<p>Represents a request to the delete project operation.</p>', 'refs' => [], ], 'DeleteProjectResult' => [ 'base' => '<p>Represents the result of a delete project request.</p>', 'refs' => [], ], 'DeleteRemoteAccessSessionRequest' => [ 'base' => '<p>Represents the request to delete the specified remote access session.</p>', 'refs' => [], ], 'DeleteRemoteAccessSessionResult' => [ 'base' => '<p>The response from the server when a request is made to delete the remote access session.</p>', 'refs' => [], ], 'DeleteRunRequest' => [ 'base' => '<p>Represents a request to the delete run operation.</p>', 'refs' => [], ], 'DeleteRunResult' => [ 'base' => '<p>Represents the result of a delete run request.</p>', 'refs' => [], ], 'DeleteUploadRequest' => [ 'base' => '<p>Represents a request to the delete upload operation.</p>', 'refs' => [], ], 'DeleteUploadResult' => [ 'base' => '<p>Represents the result of a delete upload request.</p>', 'refs' => [], ], 'Device' => [ 'base' => '<p>Represents a device type that an app is tested against.</p>', 'refs' => [ 'DevicePoolCompatibilityResult$device' => '<p>The device (phone or tablet) that you wish to return information about.</p>', 'Devices$member' => NULL, 'GetDeviceResult$device' => '<p>An object containing information about the requested device.</p>', 'Job$device' => '<p>The device (phone or tablet).</p>', 'Problem$device' => '<p>Information about the associated device.</p>', 'RemoteAccessSession$device' => '<p>The device (phone or tablet) used in the remote access session.</p>', ], ], 'DeviceAttribute' => [ 'base' => NULL, 'refs' => [ 'IncompatibilityMessage$type' => '<p>The type of incompatibility.</p> <p>Allowed values include:</p> <ul> <li> <p>ARN: The ARN.</p> </li> <li> <p>FORM_FACTOR: The form factor (for example, phone or tablet).</p> </li> <li> <p>MANUFACTURER: The manufacturer.</p> </li> <li> <p>PLATFORM: The platform (for example, Android or iOS).</p> </li> <li> <p>REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.</p> </li> <li> <p>APPIUM_VERSION: The Appium version for the test.</p> </li> </ul>', 'Rule$attribute' => '<p>The rule\'s stringified attribute. For example, specify the value as <code>"\\"abc\\""</code>.</p> <p>Allowed values include:</p> <ul> <li> <p>ARN: The ARN.</p> </li> <li> <p>FORM_FACTOR: The form factor (for example, phone or tablet).</p> </li> <li> <p>MANUFACTURER: The manufacturer.</p> </li> <li> <p>PLATFORM: The platform (for example, Android or iOS).</p> </li> <li> <p>REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.</p> </li> <li> <p>APPIUM_VERSION: The Appium version for the test.</p> </li> </ul>', ], ], 'DeviceFormFactor' => [ 'base' => NULL, 'refs' => [ 'Device$formFactor' => '<p>The device\'s form factor.</p> <p>Allowed values include:</p> <ul> <li> <p>PHONE: The phone form factor.</p> </li> <li> <p>TABLET: The tablet form factor.</p> </li> </ul>', ], ], 'DeviceMinutes' => [ 'base' => '<p>Represents the total (metered or unmetered) minutes used by the resource to run tests. Contains the sum of minutes consumed by all children.</p>', 'refs' => [ 'Job$deviceMinutes' => '<p>Represents the total (metered or unmetered) minutes used by the job.</p>', 'RemoteAccessSession$deviceMinutes' => '<p>The number of minutes a device is used in a remote access sesssion (including setup and teardown minutes).</p>', 'Run$deviceMinutes' => '<p>Represents the total (metered or unmetered) minutes used by the test run.</p>', 'Suite$deviceMinutes' => '<p>Represents the total (metered or unmetered) minutes used by the test suite.</p>', 'Test$deviceMinutes' => '<p>Represents the total (metered or unmetered) minutes used by the test.</p>', ], ], 'DevicePlatform' => [ 'base' => NULL, 'refs' => [ 'Device$platform' => '<p>The device\'s platform.</p> <p>Allowed values include:</p> <ul> <li> <p>ANDROID: The Android platform.</p> </li> <li> <p>IOS: The iOS platform.</p> </li> </ul>', 'Offering$platform' => '<p>The platform of the device (e.g., ANDROID or IOS).</p>', 'PurchasedDevicesMap$key' => NULL, 'Run$platform' => '<p>The run\'s platform.</p> <p>Allowed values include:</p> <ul> <li> <p>ANDROID: The Android platform.</p> </li> <li> <p>IOS: The iOS platform.</p> </li> </ul>', ], ], 'DevicePool' => [ 'base' => '<p>Represents a collection of device types.</p>', 'refs' => [ 'CreateDevicePoolResult$devicePool' => '<p>The newly created device pool.</p>', 'DevicePools$member' => NULL, 'GetDevicePoolResult$devicePool' => '<p>An object containing information about the requested device pool.</p>', 'UpdateDevicePoolResult$devicePool' => '<p>The device pool you just updated.</p>', ], ], 'DevicePoolCompatibilityResult' => [ 'base' => '<p>Represents a device pool compatibility result.</p>', 'refs' => [ 'DevicePoolCompatibilityResults$member' => NULL, ], ], 'DevicePoolCompatibilityResults' => [ 'base' => NULL, 'refs' => [ 'GetDevicePoolCompatibilityResult$compatibleDevices' => '<p>Information about compatible devices.</p>', 'GetDevicePoolCompatibilityResult$incompatibleDevices' => '<p>Information about incompatible devices.</p>', ], ], 'DevicePoolType' => [ 'base' => NULL, 'refs' => [ 'DevicePool$type' => '<p>The device pool\'s type.</p> <p>Allowed values include:</p> <ul> <li> <p>CURATED: A device pool that is created and managed by AWS Device Farm.</p> </li> <li> <p>PRIVATE: A device pool that is created and managed by the device pool developer.</p> </li> </ul>', 'ListDevicePoolsRequest$type' => '<p>The device pools\' type.</p> <p>Allowed values include:</p> <ul> <li> <p>CURATED: A device pool that is created and managed by AWS Device Farm.</p> </li> <li> <p>PRIVATE: A device pool that is created and managed by the device pool developer.</p> </li> </ul>', ], ], 'DevicePools' => [ 'base' => NULL, 'refs' => [ 'ListDevicePoolsResult$devicePools' => '<p>Information about the device pools.</p>', ], ], 'Devices' => [ 'base' => NULL, 'refs' => [ 'ListDevicesResult$devices' => '<p>Information about the devices.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'CPU$clock' => '<p>The clock speed of the device\'s CPU, expressed in hertz (Hz). For example, a 1.2 GHz CPU is expressed as 1200000000.</p>', 'DeviceMinutes$total' => '<p>When specified, represents the total minutes used by the resource to run tests.</p>', 'DeviceMinutes$metered' => '<p>When specified, represents only the sum of metered minutes used by the resource to run tests.</p>', 'DeviceMinutes$unmetered' => '<p>When specified, represents only the sum of unmetered minutes used by the resource to run tests.</p>', 'Location$latitude' => '<p>The latitude.</p>', 'Location$longitude' => '<p>The longitude.</p>', 'MonetaryAmount$amount' => '<p>The numerical amount of an offering or transaction.</p>', 'TrialMinutes$total' => '<p>The total number of free trial minutes that the account started with.</p>', 'TrialMinutes$remaining' => '<p>The number of free trial minutes remaining in the account.</p>', ], ], 'ExecutionConfiguration' => [ 'base' => '<p>Represents configuration information about a test run, such as the execution timeout (in minutes).</p>', 'refs' => [ 'ScheduleRunRequest$executionConfiguration' => '<p>Specifies configuration information about a test run, such as the execution timeout (in minutes).</p>', ], ], 'ExecutionResult' => [ 'base' => NULL, 'refs' => [ 'Job$result' => '<p>The job\'s result.</p> <p>Allowed values include:</p> <ul> <li> <p>PENDING: A pending condition.</p> </li> <li> <p>PASSED: A passing condition.</p> </li> <li> <p>WARNED: A warning condition.</p> </li> <li> <p>FAILED: A failed condition.</p> </li> <li> <p>SKIPPED: A skipped condition.</p> </li> <li> <p>ERRORED: An error condition.</p> </li> <li> <p>STOPPED: A stopped condition.</p> </li> </ul>', 'Problem$result' => '<p>The problem\'s result.</p> <p>Allowed values include:</p> <ul> <li> <p>PENDING: A pending condition.</p> </li> <li> <p>PASSED: A passing condition.</p> </li> <li> <p>WARNED: A warning condition.</p> </li> <li> <p>FAILED: A failed condition.</p> </li> <li> <p>SKIPPED: A skipped condition.</p> </li> <li> <p>ERRORED: An error condition.</p> </li> <li> <p>STOPPED: A stopped condition.</p> </li> </ul>', 'RemoteAccessSession$result' => '<p>The result of the remote access session. Can be any of the following:</p> <ul> <li> <p>PENDING: A pending condition.</p> </li> <li> <p>PASSED: A passing condition.</p> </li> <li> <p>WARNED: A warning condition.</p> </li> <li> <p>FAILED: A failed condition.</p> </li> <li> <p>SKIPPED: A skipped condition.</p> </li> <li> <p>ERRORED: An error condition.</p> </li> <li> <p>STOPPED: A stopped condition.</p> </li> </ul>', 'Run$result' => '<p>The run\'s result.</p> <p>Allowed values include:</p> <ul> <li> <p>PENDING: A pending condition.</p> </li> <li> <p>PASSED: A passing condition.</p> </li> <li> <p>WARNED: A warning condition.</p> </li> <li> <p>FAILED: A failed condition.</p> </li> <li> <p>SKIPPED: A skipped condition.</p> </li> <li> <p>ERRORED: An error condition.</p> </li> <li> <p>STOPPED: A stopped condition.</p> </li> </ul>', 'Suite$result' => '<p>The suite\'s result.</p> <p>Allowed values include:</p> <ul> <li> <p>PENDING: A pending condition.</p> </li> <li> <p>PASSED: A passing condition.</p> </li> <li> <p>WARNED: A warning condition.</p> </li> <li> <p>FAILED: A failed condition.</p> </li> <li> <p>SKIPPED: A skipped condition.</p> </li> <li> <p>ERRORED: An error condition.</p> </li> <li> <p>STOPPED: A stopped condition.</p> </li> </ul>', 'Test$result' => '<p>The test\'s result.</p> <p>Allowed values include:</p> <ul> <li> <p>PENDING: A pending condition.</p> </li> <li> <p>PASSED: A passing condition.</p> </li> <li> <p>WARNED: A warning condition.</p> </li> <li> <p>FAILED: A failed condition.</p> </li> <li> <p>SKIPPED: A skipped condition.</p> </li> <li> <p>ERRORED: An error condition.</p> </li> <li> <p>STOPPED: A stopped condition.</p> </li> </ul>', 'UniqueProblemsByExecutionResultMap$key' => NULL, ], ], 'ExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'Job$status' => '<p>The job\'s status.</p> <p>Allowed values include:</p> <ul> <li> <p>PENDING: A pending status.</p> </li> <li> <p>PENDING_CONCURRENCY: A pending concurrency status.</p> </li> <li> <p>PENDING_DEVICE: A pending device status.</p> </li> <li> <p>PROCESSING: A processing status.</p> </li> <li> <p>SCHEDULING: A scheduling status.</p> </li> <li> <p>PREPARING: A preparing status.</p> </li> <li> <p>RUNNING: A running status.</p> </li> <li> <p>COMPLETED: A completed status.</p> </li> <li> <p>STOPPING: A stopping status.</p> </li> </ul>', 'RemoteAccessSession$status' => '<p>The status of the remote access session. Can be any of the following:</p> <ul> <li> <p>PENDING: A pending status.</p> </li> <li> <p>PENDING_CONCURRENCY: A pending concurrency status.</p> </li> <li> <p>PENDING_DEVICE: A pending device status.</p> </li> <li> <p>PROCESSING: A processing status.</p> </li> <li> <p>SCHEDULING: A scheduling status.</p> </li> <li> <p>PREPARING: A preparing status.</p> </li> <li> <p>RUNNING: A running status.</p> </li> <li> <p>COMPLETED: A completed status.</p> </li> <li> <p>STOPPING: A stopping status.</p> </li> </ul>', 'Run$status' => '<p>The run\'s status.</p> <p>Allowed values include:</p> <ul> <li> <p>PENDING: A pending status.</p> </li> <li> <p>PENDING_CONCURRENCY: A pending concurrency status.</p> </li> <li> <p>PENDING_DEVICE: A pending device status.</p> </li> <li> <p>PROCESSING: A processing status.</p> </li> <li> <p>SCHEDULING: A scheduling status.</p> </li> <li> <p>PREPARING: A preparing status.</p> </li> <li> <p>RUNNING: A running status.</p> </li> <li> <p>COMPLETED: A completed status.</p> </li> <li> <p>STOPPING: A stopping status.</p> </li> </ul>', 'Suite$status' => '<p>The suite\'s status.</p> <p>Allowed values include:</p> <ul> <li> <p>PENDING: A pending status.</p> </li> <li> <p>PENDING_CONCURRENCY: A pending concurrency status.</p> </li> <li> <p>PENDING_DEVICE: A pending device status.</p> </li> <li> <p>PROCESSING: A processing status.</p> </li> <li> <p>SCHEDULING: A scheduling status.</p> </li> <li> <p>PREPARING: A preparing status.</p> </li> <li> <p>RUNNING: A running status.</p> </li> <li> <p>COMPLETED: A completed status.</p> </li> <li> <p>STOPPING: A stopping status.</p> </li> </ul>', 'Test$status' => '<p>The test\'s status.</p> <p>Allowed values include:</p> <ul> <li> <p>PENDING: A pending status.</p> </li> <li> <p>PENDING_CONCURRENCY: A pending concurrency status.</p> </li> <li> <p>PENDING_DEVICE: A pending device status.</p> </li> <li> <p>PROCESSING: A processing status.</p> </li> <li> <p>SCHEDULING: A scheduling status.</p> </li> <li> <p>PREPARING: A preparing status.</p> </li> <li> <p>RUNNING: A running status.</p> </li> <li> <p>COMPLETED: A completed status.</p> </li> <li> <p>STOPPING: A stopping status.</p> </li> </ul>', ], ], 'Filter' => [ 'base' => NULL, 'refs' => [ 'ScheduleRunTest$filter' => '<p>The test\'s filter.</p>', ], ], 'GetAccountSettingsRequest' => [ 'base' => '<p>Represents the request sent to retrieve the account settings.</p>', 'refs' => [], ], 'GetAccountSettingsResult' => [ 'base' => '<p>Represents the account settings return values from the <code>GetAccountSettings</code> request.</p>', 'refs' => [], ], 'GetDevicePoolCompatibilityRequest' => [ 'base' => '<p>Represents a request to the get device pool compatibility operation.</p>', 'refs' => [], ], 'GetDevicePoolCompatibilityResult' => [ 'base' => '<p>Represents the result of describe device pool compatibility request.</p>', 'refs' => [], ], 'GetDevicePoolRequest' => [ 'base' => '<p>Represents a request to the get device pool operation.</p>', 'refs' => [], ], 'GetDevicePoolResult' => [ 'base' => '<p>Represents the result of a get device pool request.</p>', 'refs' => [], ], 'GetDeviceRequest' => [ 'base' => '<p>Represents a request to the get device request.</p>', 'refs' => [], ], 'GetDeviceResult' => [ 'base' => '<p>Represents the result of a get device request.</p>', 'refs' => [], ], 'GetJobRequest' => [ 'base' => '<p>Represents a request to the get job operation.</p>', 'refs' => [], ], 'GetJobResult' => [ 'base' => '<p>Represents the result of a get job request.</p>', 'refs' => [], ], 'GetNetworkProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'GetOfferingStatusRequest' => [ 'base' => '<p>Represents the request to retrieve the offering status for the specified customer or account.</p>', 'refs' => [], ], 'GetOfferingStatusResult' => [ 'base' => '<p>Returns the status result for a device offering.</p>', 'refs' => [], ], 'GetProjectRequest' => [ 'base' => '<p>Represents a request to the get project operation.</p>', 'refs' => [], ], 'GetProjectResult' => [ 'base' => '<p>Represents the result of a get project request.</p>', 'refs' => [], ], 'GetRemoteAccessSessionRequest' => [ 'base' => '<p>Represents the request to get information about the specified remote access session.</p>', 'refs' => [], ], 'GetRemoteAccessSessionResult' => [ 'base' => '<p>Represents the response from the server that lists detailed information about the remote access session.</p>', 'refs' => [], ], 'GetRunRequest' => [ 'base' => '<p>Represents a request to the get run operation.</p>', 'refs' => [], ], 'GetRunResult' => [ 'base' => '<p>Represents the result of a get run request.</p>', 'refs' => [], ], 'GetSuiteRequest' => [ 'base' => '<p>Represents a request to the get suite operation.</p>', 'refs' => [], ], 'GetSuiteResult' => [ 'base' => '<p>Represents the result of a get suite request.</p>', 'refs' => [], ], 'GetTestRequest' => [ 'base' => '<p>Represents a request to the get test operation.</p>', 'refs' => [], ], 'GetTestResult' => [ 'base' => '<p>Represents the result of a get test request.</p>', 'refs' => [], ], 'GetUploadRequest' => [ 'base' => '<p>Represents a request to the get upload operation.</p>', 'refs' => [], ], 'GetUploadResult' => [ 'base' => '<p>Represents the result of a get upload request.</p>', 'refs' => [], ], 'IdempotencyException' => [ 'base' => '<p>An entity with the same name already exists.</p>', 'refs' => [], ], 'IncompatibilityMessage' => [ 'base' => '<p>Represents information about incompatibility.</p>', 'refs' => [ 'IncompatibilityMessages$member' => NULL, ], ], 'IncompatibilityMessages' => [ 'base' => NULL, 'refs' => [ 'DevicePoolCompatibilityResult$incompatibilityMessages' => '<p>Information about the compatibility.</p>', ], ], 'InstallToRemoteAccessSessionRequest' => [ 'base' => '<p>Represents the request to install an Android application (in .apk format) or an iOS application (in .ipa format) as part of a remote access session.</p>', 'refs' => [], ], 'InstallToRemoteAccessSessionResult' => [ 'base' => '<p>Represents the response from the server after AWS Device Farm makes a request to install to a remote access session.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Counters$total' => '<p>The total number of entities.</p>', 'Counters$passed' => '<p>The number of passed entities.</p>', 'Counters$failed' => '<p>The number of failed entities.</p>', 'Counters$warned' => '<p>The number of warned entities.</p>', 'Counters$errored' => '<p>The number of errored entities.</p>', 'Counters$stopped' => '<p>The number of stopped entities.</p>', 'Counters$skipped' => '<p>The number of skipped entities.</p>', 'MaxSlotMap$value' => NULL, 'OfferingStatus$quantity' => '<p>The number of available devices in the offering.</p>', 'PurchaseOfferingRequest$quantity' => '<p>The number of device slots you wish to purchase in an offering request.</p>', 'PurchasedDevicesMap$value' => NULL, 'RenewOfferingRequest$quantity' => '<p>The quantity requested in an offering renewal.</p>', 'Resolution$width' => '<p>The screen resolution\'s width, expressed in pixels.</p>', 'Resolution$height' => '<p>The screen resolution\'s height, expressed in pixels.</p>', 'Run$totalJobs' => '<p>The total number of jobs for the run.</p>', 'Run$completedJobs' => '<p>The total number of completed jobs.</p>', ], ], 'Job' => [ 'base' => '<p>Represents a device.</p>', 'refs' => [ 'GetJobResult$job' => '<p>An object containing information about the requested job.</p>', 'Jobs$member' => NULL, ], ], 'JobTimeoutMinutes' => [ 'base' => NULL, 'refs' => [ 'AccountSettings$maxJobTimeoutMinutes' => '<p>The maximum number of minutes a test run will execute before it times out.</p>', 'AccountSettings$defaultJobTimeoutMinutes' => '<p>The default number of minutes (at the account level) a test run will execute before it times out. Default value is 60 minutes.</p>', 'CreateProjectRequest$defaultJobTimeoutMinutes' => '<p>Sets the execution timeout value (in minutes) for a project. All test runs in this project will use the specified execution timeout value unless overridden when scheduling a run.</p>', 'ExecutionConfiguration$jobTimeoutMinutes' => '<p>The number of minutes a test run will execute before it times out.</p>', 'Project$defaultJobTimeoutMinutes' => '<p>The default number of minutes (at the project level) a test run will execute before it times out. Default value is 60 minutes.</p>', 'UpdateProjectRequest$defaultJobTimeoutMinutes' => '<p>The number of minutes a test run in the project will execute before it times out.</p>', ], ], 'Jobs' => [ 'base' => NULL, 'refs' => [ 'ListJobsResult$jobs' => '<p>Information about the jobs.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>A limit was exceeded.</p>', 'refs' => [], ], 'ListArtifactsRequest' => [ 'base' => '<p>Represents a request to the list artifacts operation.</p>', 'refs' => [], ], 'ListArtifactsResult' => [ 'base' => '<p>Represents the result of a list artifacts operation.</p>', 'refs' => [], ], 'ListDevicePoolsRequest' => [ 'base' => '<p>Represents the result of a list device pools request.</p>', 'refs' => [], ], 'ListDevicePoolsResult' => [ 'base' => '<p>Represents the result of a list device pools request.</p>', 'refs' => [], ], 'ListDevicesRequest' => [ 'base' => '<p>Represents the result of a list devices request.</p>', 'refs' => [], ], 'ListDevicesResult' => [ 'base' => '<p>Represents the result of a list devices operation.</p>', 'refs' => [], ], 'ListJobsRequest' => [ 'base' => '<p>Represents a request to the list jobs operation.</p>', 'refs' => [], ], 'ListJobsResult' => [ 'base' => '<p>Represents the result of a list jobs request.</p>', 'refs' => [], ], 'ListNetworkProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNetworkProfilesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListOfferingPromotionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOfferingPromotionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListOfferingTransactionsRequest' => [ 'base' => '<p>Represents the request to list the offering transaction history.</p>', 'refs' => [], ], 'ListOfferingTransactionsResult' => [ 'base' => '<p>Returns the transaction log of the specified offerings.</p>', 'refs' => [], ], 'ListOfferingsRequest' => [ 'base' => '<p>Represents the request to list all offerings.</p>', 'refs' => [], ], 'ListOfferingsResult' => [ 'base' => '<p>Represents the return values of the list of offerings.</p>', 'refs' => [], ], 'ListProjectsRequest' => [ 'base' => '<p>Represents a request to the list projects operation.</p>', 'refs' => [], ], 'ListProjectsResult' => [ 'base' => '<p>Represents the result of a list projects request.</p>', 'refs' => [], ], 'ListRemoteAccessSessionsRequest' => [ 'base' => '<p>Represents the request to return information about the remote access session.</p>', 'refs' => [], ], 'ListRemoteAccessSessionsResult' => [ 'base' => '<p>Represents the response from the server after AWS Device Farm makes a request to return information about the remote access session.</p>', 'refs' => [], ], 'ListRunsRequest' => [ 'base' => '<p>Represents a request to the list runs operation.</p>', 'refs' => [], ], 'ListRunsResult' => [ 'base' => '<p>Represents the result of a list runs request.</p>', 'refs' => [], ], 'ListSamplesRequest' => [ 'base' => '<p>Represents a request to the list samples operation.</p>', 'refs' => [], ], 'ListSamplesResult' => [ 'base' => '<p>Represents the result of a list samples request.</p>', 'refs' => [], ], 'ListSuitesRequest' => [ 'base' => '<p>Represents a request to the list suites operation.</p>', 'refs' => [], ], 'ListSuitesResult' => [ 'base' => '<p>Represents the result of a list suites request.</p>', 'refs' => [], ], 'ListTestsRequest' => [ 'base' => '<p>Represents a request to the list tests operation.</p>', 'refs' => [], ], 'ListTestsResult' => [ 'base' => '<p>Represents the result of a list tests request.</p>', 'refs' => [], ], 'ListUniqueProblemsRequest' => [ 'base' => '<p>Represents a request to the list unique problems operation.</p>', 'refs' => [], ], 'ListUniqueProblemsResult' => [ 'base' => '<p>Represents the result of a list unique problems request.</p>', 'refs' => [], ], 'ListUploadsRequest' => [ 'base' => '<p>Represents a request to the list uploads operation.</p>', 'refs' => [], ], 'ListUploadsResult' => [ 'base' => '<p>Represents the result of a list uploads request.</p>', 'refs' => [], ], 'Location' => [ 'base' => '<p>Represents a latitude and longitude pair, expressed in geographic coordinate system degrees (for example 47.6204, -122.3491).</p> <p>Elevation is currently not supported.</p>', 'refs' => [ 'ScheduleRunConfiguration$location' => '<p>Information about the location that is used for the run.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkProfileRequest$uplinkBandwidthBits' => '<p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>', 'CreateNetworkProfileRequest$downlinkBandwidthBits' => '<p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>', 'CreateNetworkProfileRequest$uplinkDelayMs' => '<p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>', 'CreateNetworkProfileRequest$downlinkDelayMs' => '<p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>', 'CreateNetworkProfileRequest$uplinkJitterMs' => '<p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>', 'CreateNetworkProfileRequest$downlinkJitterMs' => '<p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>', 'Device$heapSize' => '<p>The device\'s heap size, expressed in bytes.</p>', 'Device$memory' => '<p>The device\'s total memory size, expressed in bytes.</p>', 'NetworkProfile$uplinkBandwidthBits' => '<p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>', 'NetworkProfile$downlinkBandwidthBits' => '<p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>', 'NetworkProfile$uplinkDelayMs' => '<p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>', 'NetworkProfile$downlinkDelayMs' => '<p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>', 'NetworkProfile$uplinkJitterMs' => '<p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>', 'NetworkProfile$downlinkJitterMs' => '<p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>', 'UpdateNetworkProfileRequest$uplinkBandwidthBits' => '<p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>', 'UpdateNetworkProfileRequest$downlinkBandwidthBits' => '<p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>', 'UpdateNetworkProfileRequest$uplinkDelayMs' => '<p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>', 'UpdateNetworkProfileRequest$downlinkDelayMs' => '<p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>', 'UpdateNetworkProfileRequest$uplinkJitterMs' => '<p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>', 'UpdateNetworkProfileRequest$downlinkJitterMs' => '<p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>', ], ], 'MaxSlotMap' => [ 'base' => NULL, 'refs' => [ 'AccountSettings$maxSlots' => '<p>The maximum number of device slots that the AWS account can purchase. Each maximum is expressed as an <code>offering-id:number</code> pair, where the <code>offering-id</code> represents one of the IDs returned by the <code>ListOfferings</code> command.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'ArgumentException$message' => '<p>Any additional information about the exception.</p>', 'CreateDevicePoolRequest$description' => '<p>The device pool\'s description.</p>', 'CreateNetworkProfileRequest$description' => '<p>The description of the network profile.</p>', 'DevicePool$description' => '<p>The device pool\'s description.</p>', 'IdempotencyException$message' => '<p>Any additional information about the exception.</p>', 'IncompatibilityMessage$message' => '<p>A message about the incompatibility.</p>', 'Job$message' => '<p>A message about the job\'s result.</p>', 'LimitExceededException$message' => '<p>Any additional information about the exception.</p>', 'NetworkProfile$description' => '<p>The description of the network profile.</p>', 'NotEligibleException$message' => '<p>The HTTP response code of a Not Eligible exception.</p>', 'NotFoundException$message' => '<p>Any additional information about the exception.</p>', 'Offering$description' => '<p>A string describing the offering.</p>', 'OfferingPromotion$description' => '<p>A string describing the offering promotion.</p>', 'Problem$message' => '<p>A message about the problem\'s result.</p>', 'RemoteAccessSession$message' => '<p>A message about the remote access session.</p>', 'Run$message' => '<p>A message about the run\'s result.</p>', 'ServiceAccountException$message' => '<p>Any additional information about the exception.</p>', 'Suite$message' => '<p>A message about the suite\'s result.</p>', 'Test$message' => '<p>A message about the test\'s result.</p>', 'UniqueProblem$message' => '<p>A message about the unique problems\' result.</p>', 'UpdateDevicePoolRequest$description' => '<p>A description of the device pool you wish to update.</p>', 'UpdateNetworkProfileRequest$description' => '<p>The descriptoin of the network profile about which you are returning information.</p>', 'Upload$message' => '<p>A message about the upload\'s result.</p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'Upload$metadata' => '<p>The upload\'s metadata. For example, for Android, this contains information that is parsed from the manifest and is displayed in the AWS Device Farm console after the associated app is uploaded.</p>', ], ], 'MonetaryAmount' => [ 'base' => '<p>A number representing the monetary amount for an offering or transaction.</p>', 'refs' => [ 'OfferingTransaction$cost' => '<p>The cost of an offering transaction.</p>', 'RecurringCharge$cost' => '<p>The cost of the recurring charge.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'Artifact$name' => '<p>The artifact\'s name.</p>', 'CreateDevicePoolRequest$name' => '<p>The device pool\'s name.</p>', 'CreateNetworkProfileRequest$name' => '<p>The name you wish to specify for the new network profile.</p>', 'CreateProjectRequest$name' => '<p>The project\'s name.</p>', 'CreateRemoteAccessSessionRequest$name' => '<p>The name of the remote access session that you wish to create.</p>', 'CreateUploadRequest$name' => '<p>The upload\'s file name. The name should not contain the \'/\' character. If uploading an iOS app, the file name needs to end with the <code>.ipa</code> extension. If uploading an Android app, the file name needs to end with the <code>.apk</code> extension. For all others, the file name must end with the <code>.zip</code> file extension.</p>', 'Device$name' => '<p>The device\'s display name.</p>', 'DevicePool$name' => '<p>The device pool\'s name.</p>', 'Job$name' => '<p>The job\'s name.</p>', 'NetworkProfile$name' => '<p>The name of the network profile.</p>', 'ProblemDetail$name' => '<p>The problem detail\'s name.</p>', 'Project$name' => '<p>The project\'s name.</p>', 'RemoteAccessSession$name' => '<p>The name of the remote access session.</p>', 'Run$name' => '<p>The run\'s name.</p>', 'ScheduleRunRequest$name' => '<p>The name for the run to be scheduled.</p>', 'Suite$name' => '<p>The suite\'s name.</p>', 'Test$name' => '<p>The test\'s name.</p>', 'UpdateDevicePoolRequest$name' => '<p>A string representing the name of the device pool you wish to update.</p>', 'UpdateNetworkProfileRequest$name' => '<p>The name of the network profile about which you are returning information.</p>', 'UpdateProjectRequest$name' => '<p>A string representing the new name of the project that you are updating.</p>', 'Upload$name' => '<p>The upload\'s file name.</p>', ], ], 'NetworkProfile' => [ 'base' => '<p>An array of settings that describes characteristics of a network profile.</p>', 'refs' => [ 'CreateNetworkProfileResult$networkProfile' => '<p>The network profile that is returned by the create network profile request.</p>', 'GetNetworkProfileResult$networkProfile' => '<p>The network profile.</p>', 'NetworkProfiles$member' => NULL, 'Run$networkProfile' => '<p>The network profile being used for a test run.</p>', 'UpdateNetworkProfileResult$networkProfile' => '<p>A list of the available network profiles.</p>', ], ], 'NetworkProfileType' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkProfileRequest$type' => '<p>The type of network profile you wish to create. Valid values are listed below.</p>', 'ListNetworkProfilesRequest$type' => '<p>The type of network profile you wish to return information about. Valid values are listed below.</p>', 'NetworkProfile$type' => '<p>The type of network profile. Valid values are listed below.</p>', 'UpdateNetworkProfileRequest$type' => '<p>The type of network profile you wish to return information about. Valid values are listed below.</p>', ], ], 'NetworkProfiles' => [ 'base' => NULL, 'refs' => [ 'ListNetworkProfilesResult$networkProfiles' => '<p>A list of the available network profiles.</p>', ], ], 'NotEligibleException' => [ 'base' => '<p>Exception gets thrown when a user is not eligible to perform the specified transaction.</p>', 'refs' => [], ], 'NotFoundException' => [ 'base' => '<p>The specified entity was not found.</p>', 'refs' => [], ], 'Offering' => [ 'base' => '<p>Represents the metadata of a device offering.</p>', 'refs' => [ 'OfferingStatus$offering' => '<p>Represents the metadata of an offering status.</p>', 'Offerings$member' => NULL, ], ], 'OfferingIdentifier' => [ 'base' => NULL, 'refs' => [ 'Offering$id' => '<p>The ID that corresponds to a device offering.</p>', 'OfferingStatusMap$key' => NULL, 'PurchaseOfferingRequest$offeringId' => '<p>The ID of the offering.</p>', 'RenewOfferingRequest$offeringId' => '<p>The ID of a request to renew an offering.</p>', ], ], 'OfferingPromotion' => [ 'base' => '<p>Represents information about an offering promotion.</p>', 'refs' => [ 'OfferingPromotions$member' => NULL, ], ], 'OfferingPromotionIdentifier' => [ 'base' => NULL, 'refs' => [ 'OfferingPromotion$id' => '<p>The ID of the offering promotion.</p>', 'OfferingTransaction$offeringPromotionId' => '<p>The ID that corresponds to a device offering promotion.</p>', 'PurchaseOfferingRequest$offeringPromotionId' => '<p>The ID of the offering promotion to be applied to the purchase.</p>', ], ], 'OfferingPromotions' => [ 'base' => NULL, 'refs' => [ 'ListOfferingPromotionsResult$offeringPromotions' => '<p>Information about the offering promotions.</p>', ], ], 'OfferingStatus' => [ 'base' => '<p>The status of the offering.</p>', 'refs' => [ 'OfferingStatusMap$value' => NULL, 'OfferingTransaction$offeringStatus' => '<p>The status of an offering transaction.</p>', ], ], 'OfferingStatusMap' => [ 'base' => NULL, 'refs' => [ 'GetOfferingStatusResult$current' => '<p>When specified, gets the offering status for the current period.</p>', 'GetOfferingStatusResult$nextPeriod' => '<p>When specified, gets the offering status for the next period.</p>', ], ], 'OfferingTransaction' => [ 'base' => '<p>Represents the metadata of an offering transaction.</p>', 'refs' => [ 'OfferingTransactions$member' => NULL, 'PurchaseOfferingResult$offeringTransaction' => '<p>Represents the offering transaction for the purchase result.</p>', 'RenewOfferingResult$offeringTransaction' => '<p>Represents the status of the offering transaction for the renewal.</p>', ], ], 'OfferingTransactionType' => [ 'base' => NULL, 'refs' => [ 'OfferingStatus$type' => '<p>The type specified for the offering status.</p>', ], ], 'OfferingTransactions' => [ 'base' => NULL, 'refs' => [ 'ListOfferingTransactionsResult$offeringTransactions' => '<p>The audit log of subscriptions you have purchased and modified through AWS Device Farm.</p>', ], ], 'OfferingType' => [ 'base' => NULL, 'refs' => [ 'Offering$type' => '<p>The type of offering (e.g., "RECURRING") for a device.</p>', ], ], 'Offerings' => [ 'base' => NULL, 'refs' => [ 'ListOfferingsResult$offerings' => '<p>A value representing the list offering results.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'GetOfferingStatusRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'GetOfferingStatusResult$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListArtifactsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListArtifactsResult$nextToken' => '<p>If the number of items that are returned is significantly large, this is an identifier that is also returned, which can be used in a subsequent call to this operation to return the next set of items in the list.</p>', 'ListDevicePoolsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListDevicePoolsResult$nextToken' => '<p>If the number of items that are returned is significantly large, this is an identifier that is also returned, which can be used in a subsequent call to this operation to return the next set of items in the list.</p>', 'ListDevicesRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListDevicesResult$nextToken' => '<p>If the number of items that are returned is significantly large, this is an identifier that is also returned, which can be used in a subsequent call to this operation to return the next set of items in the list.</p>', 'ListJobsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListJobsResult$nextToken' => '<p>If the number of items that are returned is significantly large, this is an identifier that is also returned, which can be used in a subsequent call to this operation to return the next set of items in the list.</p>', 'ListNetworkProfilesRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListNetworkProfilesResult$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListOfferingPromotionsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListOfferingPromotionsResult$nextToken' => '<p>An identifier to be used in the next call to this operation, to return the next set of items in the list.</p>', 'ListOfferingTransactionsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListOfferingTransactionsResult$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListOfferingsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListOfferingsResult$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListProjectsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListProjectsResult$nextToken' => '<p>If the number of items that are returned is significantly large, this is an identifier that is also returned, which can be used in a subsequent call to this operation to return the next set of items in the list.</p>', 'ListRemoteAccessSessionsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListRemoteAccessSessionsResult$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListRunsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListRunsResult$nextToken' => '<p>If the number of items that are returned is significantly large, this is an identifier that is also returned, which can be used in a subsequent call to this operation to return the next set of items in the list.</p>', 'ListSamplesRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListSamplesResult$nextToken' => '<p>If the number of items that are returned is significantly large, this is an identifier that is also returned, which can be used in a subsequent call to this operation to return the next set of items in the list.</p>', 'ListSuitesRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListSuitesResult$nextToken' => '<p>If the number of items that are returned is significantly large, this is an identifier that is also returned, which can be used in a subsequent call to this operation to return the next set of items in the list.</p>', 'ListTestsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListTestsResult$nextToken' => '<p>If the number of items that are returned is significantly large, this is an identifier that is also returned, which can be used in a subsequent call to this operation to return the next set of items in the list.</p>', 'ListUniqueProblemsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUniqueProblemsResult$nextToken' => '<p>If the number of items that are returned is significantly large, this is an identifier that is also returned, which can be used in a subsequent call to this operation to return the next set of items in the list.</p>', 'ListUploadsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUploadsResult$nextToken' => '<p>If the number of items that are returned is significantly large, this is an identifier that is also returned, which can be used in a subsequent call to this operation to return the next set of items in the list.</p>', ], ], 'PercentInteger' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkProfileRequest$uplinkLossPercent' => '<p>Proportion of transmitted packets that fail to arrive from 0 to 100 percent.</p>', 'CreateNetworkProfileRequest$downlinkLossPercent' => '<p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>', 'NetworkProfile$uplinkLossPercent' => '<p>Proportion of transmitted packets that fail to arrive from 0 to 100 percent.</p>', 'NetworkProfile$downlinkLossPercent' => '<p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>', 'UpdateNetworkProfileRequest$uplinkLossPercent' => '<p>Proportion of transmitted packets that fail to arrive from 0 to 100 percent.</p>', 'UpdateNetworkProfileRequest$downlinkLossPercent' => '<p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>', ], ], 'Problem' => [ 'base' => '<p>Represents a specific warning or failure.</p>', 'refs' => [ 'Problems$member' => NULL, ], ], 'ProblemDetail' => [ 'base' => '<p>Information about a problem detail.</p>', 'refs' => [ 'Problem$run' => '<p>Information about the associated run.</p>', 'Problem$job' => '<p>Information about the associated job.</p>', 'Problem$suite' => '<p>Information about the associated suite.</p>', 'Problem$test' => '<p>Information about the associated test.</p>', ], ], 'Problems' => [ 'base' => NULL, 'refs' => [ 'UniqueProblem$problems' => '<p>Information about the problems.</p>', ], ], 'Project' => [ 'base' => '<p>Represents an operating-system neutral workspace for running and managing tests.</p>', 'refs' => [ 'CreateProjectResult$project' => '<p>The newly created project.</p>', 'GetProjectResult$project' => '<p>The project you wish to get information about.</p>', 'Projects$member' => NULL, 'UpdateProjectResult$project' => '<p>The project you wish to update.</p>', ], ], 'Projects' => [ 'base' => NULL, 'refs' => [ 'ListProjectsResult$projects' => '<p>Information about the projects.</p>', ], ], 'PurchaseOfferingRequest' => [ 'base' => '<p>Represents a request for a purchase offering.</p>', 'refs' => [], ], 'PurchaseOfferingResult' => [ 'base' => '<p>The result of the purchase offering (e.g., success or failure).</p>', 'refs' => [], ], 'PurchasedDevicesMap' => [ 'base' => NULL, 'refs' => [ 'AccountSettings$unmeteredDevices' => '<p>Returns the unmetered devices you have purchased or want to purchase.</p>', 'AccountSettings$unmeteredRemoteAccessDevices' => '<p>Returns the unmetered remote access devices you have purchased or want to purchase.</p>', ], ], 'Radios' => [ 'base' => '<p>Represents the set of radios and their states on a device. Examples of radios include Wi-Fi, GPS, Bluetooth, and NFC.</p>', 'refs' => [ 'ScheduleRunConfiguration$radios' => '<p>Information about the radio states for the run.</p>', ], ], 'RecurringCharge' => [ 'base' => '<p>Specifies whether charges for devices will be recurring.</p>', 'refs' => [ 'RecurringCharges$member' => NULL, ], ], 'RecurringChargeFrequency' => [ 'base' => NULL, 'refs' => [ 'RecurringCharge$frequency' => '<p>The frequency in which charges will recur.</p>', ], ], 'RecurringCharges' => [ 'base' => NULL, 'refs' => [ 'Offering$recurringCharges' => '<p>Specifies whether there are recurring charges for the offering.</p>', ], ], 'RemoteAccessSession' => [ 'base' => '<p>Represents information about the remote access session.</p>', 'refs' => [ 'CreateRemoteAccessSessionResult$remoteAccessSession' => '<p>A container that describes the remote access session when the request to create a remote access session is sent.</p>', 'GetRemoteAccessSessionResult$remoteAccessSession' => '<p>A container that lists detailed information about the remote access session.</p>', 'RemoteAccessSessions$member' => NULL, 'StopRemoteAccessSessionResult$remoteAccessSession' => '<p>A container representing the metadata from the service about the remote access session you are stopping.</p>', ], ], 'RemoteAccessSessions' => [ 'base' => NULL, 'refs' => [ 'ListRemoteAccessSessionsResult$remoteAccessSessions' => '<p>A container representing the metadata from the service about each remote access session you are requesting.</p>', ], ], 'RenewOfferingRequest' => [ 'base' => '<p>A request representing an offering renewal.</p>', 'refs' => [], ], 'RenewOfferingResult' => [ 'base' => '<p>The result of a renewal offering.</p>', 'refs' => [], ], 'Resolution' => [ 'base' => '<p>Represents the screen resolution of a device in height and width, expressed in pixels.</p>', 'refs' => [ 'Device$resolution' => '<p>The resolution of the device.</p>', ], ], 'Rule' => [ 'base' => '<p>Represents a condition for a device pool.</p>', 'refs' => [ 'Rules$member' => NULL, ], ], 'RuleOperator' => [ 'base' => NULL, 'refs' => [ 'Rule$operator' => '<p>The rule\'s operator.</p> <ul> <li> <p>EQUALS: The equals operator.</p> </li> <li> <p>GREATER_THAN: The greater-than operator.</p> </li> <li> <p>IN: The in operator.</p> </li> <li> <p>LESS_THAN: The less-than operator.</p> </li> <li> <p>NOT_IN: The not-in operator.</p> </li> <li> <p>CONTAINS: The contains operator.</p> </li> </ul>', ], ], 'Rules' => [ 'base' => NULL, 'refs' => [ 'CreateDevicePoolRequest$rules' => '<p>The device pool\'s rules.</p>', 'DevicePool$rules' => '<p>Information about the device pool\'s rules.</p>', 'UpdateDevicePoolRequest$rules' => '<p>Represents the rules you wish to modify for the device pool. Updating rules is optional; however, if you choose to update rules for your request, the update will replace the existing rules.</p>', ], ], 'Run' => [ 'base' => '<p>Represents an app on a set of devices with a specific test and configuration.</p>', 'refs' => [ 'GetRunResult$run' => '<p>The run you wish to get results from.</p>', 'Runs$member' => NULL, 'ScheduleRunResult$run' => '<p>Information about the scheduled run.</p>', 'StopRunResult$run' => '<p>The run that was stopped.</p>', ], ], 'Runs' => [ 'base' => NULL, 'refs' => [ 'ListRunsResult$runs' => '<p>Information about the runs.</p>', ], ], 'Sample' => [ 'base' => '<p>Represents a sample of performance data.</p>', 'refs' => [ 'Samples$member' => NULL, ], ], 'SampleType' => [ 'base' => NULL, 'refs' => [ 'Sample$type' => '<p>The sample\'s type.</p> <p>Must be one of the following values:</p> <ul> <li> <p>CPU: A CPU sample type. This is expressed as the app processing CPU time (including child processes) as reported by process, as a percentage.</p> </li> <li> <p>MEMORY: A memory usage sample type. This is expressed as the total proportional set size of an app process, in kilobytes.</p> </li> <li> <p>NATIVE_AVG_DRAWTIME</p> </li> <li> <p>NATIVE_FPS</p> </li> <li> <p>NATIVE_FRAMES</p> </li> <li> <p>NATIVE_MAX_DRAWTIME</p> </li> <li> <p>NATIVE_MIN_DRAWTIME</p> </li> <li> <p>OPENGL_AVG_DRAWTIME</p> </li> <li> <p>OPENGL_FPS</p> </li> <li> <p>OPENGL_FRAMES</p> </li> <li> <p>OPENGL_MAX_DRAWTIME</p> </li> <li> <p>OPENGL_MIN_DRAWTIME</p> </li> <li> <p>RX</p> </li> <li> <p>RX_RATE: The total number of bytes per second (TCP and UDP) that are sent, by app process.</p> </li> <li> <p>THREADS: A threads sample type. This is expressed as the total number of threads per app process.</p> </li> <li> <p>TX</p> </li> <li> <p>TX_RATE: The total number of bytes per second (TCP and UDP) that are received, by app process.</p> </li> </ul>', ], ], 'Samples' => [ 'base' => NULL, 'refs' => [ 'ListSamplesResult$samples' => '<p>Information about the samples.</p>', ], ], 'ScheduleRunConfiguration' => [ 'base' => '<p>Represents the settings for a run. Includes things like location, radio states, auxiliary apps, and network profiles.</p>', 'refs' => [ 'ScheduleRunRequest$configuration' => '<p>Information about the settings for the run to be scheduled.</p>', ], ], 'ScheduleRunRequest' => [ 'base' => '<p>Represents a request to the schedule run operation.</p>', 'refs' => [], ], 'ScheduleRunResult' => [ 'base' => '<p>Represents the result of a schedule run request.</p>', 'refs' => [], ], 'ScheduleRunTest' => [ 'base' => '<p>Represents additional test settings.</p>', 'refs' => [ 'GetDevicePoolCompatibilityRequest$test' => '<p>Information about the uploaded test to be run against the device pool.</p>', 'ScheduleRunRequest$test' => '<p>Information about the test for the run to be scheduled.</p>', ], ], 'ServiceAccountException' => [ 'base' => '<p>There was a problem with the service account.</p>', 'refs' => [], ], 'StopRemoteAccessSessionRequest' => [ 'base' => '<p>Represents the request to stop the remote access session.</p>', 'refs' => [], ], 'StopRemoteAccessSessionResult' => [ 'base' => '<p>Represents the response from the server that describes the remote access session when AWS Device Farm stops the session.</p>', 'refs' => [], ], 'StopRunRequest' => [ 'base' => '<p>Represents the request to stop a specific run.</p>', 'refs' => [], ], 'StopRunResult' => [ 'base' => '<p>Represents the results of your stop run attempt.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'Artifact$extension' => '<p>The artifact\'s file extension.</p>', 'CPU$frequency' => '<p>The CPU\'s frequency.</p>', 'CPU$architecture' => '<p>The CPU\'s architecture, for example x86 or ARM.</p>', 'Device$manufacturer' => '<p>The device\'s manufacturer name.</p>', 'Device$model' => '<p>The device\'s model name.</p>', 'Device$os' => '<p>The device\'s operating system type.</p>', 'Device$image' => '<p>The device\'s image name.</p>', 'Device$carrier' => '<p>The device\'s carrier.</p>', 'Device$radio' => '<p>The device\'s radio.</p>', 'Device$fleetType' => '<p>The type of fleet to which this device belongs. Possible values for fleet type are PRIVATE and PUBLIC.</p>', 'Device$fleetName' => '<p>The name of the fleet to which this device belongs.</p>', 'MaxSlotMap$key' => NULL, 'RemoteAccessSession$endpoint' => '<p>The endpoint for the remote access sesssion.</p>', 'Rule$value' => '<p>The rule\'s value.</p>', 'ScheduleRunConfiguration$locale' => '<p>Information about the locale that is used for the run.</p>', 'TestParameters$key' => NULL, 'TestParameters$value' => NULL, ], ], 'Suite' => [ 'base' => '<p>Represents a collection of one or more tests.</p>', 'refs' => [ 'GetSuiteResult$suite' => '<p>A collection of one or more tests.</p>', 'Suites$member' => NULL, ], ], 'Suites' => [ 'base' => NULL, 'refs' => [ 'ListSuitesResult$suites' => '<p>Information about the suites.</p>', ], ], 'Test' => [ 'base' => '<p>Represents a condition that is evaluated.</p>', 'refs' => [ 'GetTestResult$test' => '<p>A test condition that is evaluated.</p>', 'Tests$member' => NULL, ], ], 'TestParameters' => [ 'base' => NULL, 'refs' => [ 'ScheduleRunTest$parameters' => '<p>The test\'s parameters, such as the following test framework parameters and fixture settings:</p> <p>For Calabash tests:</p> <ul> <li> <p>profile: A cucumber profile, for example, "my_profile_name".</p> </li> <li> <p>tags: You can limit execution to features or scenarios that have (or don\'t have) certain tags, for example, "@smoke" or "@smoke,~@wip".</p> </li> </ul> <p>For Appium tests (all types):</p> <ul> <li> <p>appium_version: The Appium version. Currently supported values are "1.4.16", "1.6.3", "latest", and "default".</p> <ul> <li> <p>“latest” will run the latest Appium version supported by Device Farm (1.6.3).</p> </li> <li> <p>For “default”, Device Farm will choose a compatible version of Appium for the device. The current behavior is to run 1.4.16 on Android devices and iOS 9 and earlier, 1.6.3 for iOS 10 and later.</p> </li> <li> <p>This behavior is subject to change.</p> </li> </ul> </li> </ul> <p>For Fuzz tests (Android only):</p> <ul> <li> <p>event_count: The number of events, between 1 and 10000, that the UI fuzz test should perform.</p> </li> <li> <p>throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should wait between events.</p> </li> <li> <p>seed: A seed to use for randomizing the UI fuzz test. Using the same seed value between tests ensures identical event sequences.</p> </li> </ul> <p>For Explorer tests:</p> <ul> <li> <p>username: A username to use if the Explorer encounters a login form. If not supplied, no username will be inserted.</p> </li> <li> <p>password: A password to use if the Explorer encounters a login form. If not supplied, no password will be inserted.</p> </li> </ul> <p>For Instrumentation:</p> <ul> <li> <p>filter: A test filter string. Examples:</p> <ul> <li> <p>Running a single test case: "com.android.abc.Test1"</p> </li> <li> <p>Running a single test: "com.android.abc.Test1#smoke"</p> </li> <li> <p>Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"</p> </li> </ul> </li> </ul> <p>For XCTest and XCTestUI:</p> <ul> <li> <p>filter: A test filter string. Examples:</p> <ul> <li> <p>Running a single test class: "LoginTests"</p> </li> <li> <p>Running a multiple test classes: "LoginTests,SmokeTests"</p> </li> <li> <p>Running a single test: "LoginTests/testValid"</p> </li> <li> <p>Running multiple tests: "LoginTests/testValid,LoginTests/testInvalid"</p> </li> </ul> </li> </ul> <p>For UIAutomator:</p> <ul> <li> <p>filter: A test filter string. Examples:</p> <ul> <li> <p>Running a single test case: "com.android.abc.Test1"</p> </li> <li> <p>Running a single test: "com.android.abc.Test1#smoke"</p> </li> <li> <p>Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"</p> </li> </ul> </li> </ul>', ], ], 'TestType' => [ 'base' => NULL, 'refs' => [ 'GetDevicePoolCompatibilityRequest$testType' => '<p>The test type for the specified device pool.</p> <p>Allowed values include the following:</p> <ul> <li> <p>BUILTIN_FUZZ: The built-in fuzz type.</p> </li> <li> <p>BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and capturing screenshots at the same time.</p> </li> <li> <p>APPIUM_JAVA_JUNIT: The Appium Java JUnit type.</p> </li> <li> <p>APPIUM_JAVA_TESTNG: The Appium Java TestNG type.</p> </li> <li> <p>APPIUM_PYTHON: The Appium Python type.</p> </li> <li> <p>APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.</p> </li> <li> <p>APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.</p> </li> <li> <p>APPIUM_WEB_PYTHON: The Appium Python type for Web apps.</p> </li> <li> <p>CALABASH: The Calabash type.</p> </li> <li> <p>INSTRUMENTATION: The Instrumentation type.</p> </li> <li> <p>UIAUTOMATION: The uiautomation type.</p> </li> <li> <p>UIAUTOMATOR: The uiautomator type.</p> </li> <li> <p>XCTEST: The XCode test type.</p> </li> <li> <p>XCTEST_UI: The XCode UI test type.</p> </li> </ul>', 'Job$type' => '<p>The job\'s type.</p> <p>Allowed values include the following:</p> <ul> <li> <p>BUILTIN_FUZZ: The built-in fuzz type.</p> </li> <li> <p>BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and capturing screenshots at the same time.</p> </li> <li> <p>APPIUM_JAVA_JUNIT: The Appium Java JUnit type.</p> </li> <li> <p>APPIUM_JAVA_TESTNG: The Appium Java TestNG type.</p> </li> <li> <p>APPIUM_PYTHON: The Appium Python type.</p> </li> <li> <p>APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.</p> </li> <li> <p>APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.</p> </li> <li> <p>APPIUM_WEB_PYTHON: The Appium Python type for Web apps.</p> </li> <li> <p>CALABASH: The Calabash type.</p> </li> <li> <p>INSTRUMENTATION: The Instrumentation type.</p> </li> <li> <p>UIAUTOMATION: The uiautomation type.</p> </li> <li> <p>UIAUTOMATOR: The uiautomator type.</p> </li> <li> <p>XCTEST: The XCode test type.</p> </li> <li> <p>XCTEST_UI: The XCode UI test type.</p> </li> </ul>', 'Run$type' => '<p>The run\'s type.</p> <p>Must be one of the following values:</p> <ul> <li> <p>BUILTIN_FUZZ: The built-in fuzz type.</p> </li> <li> <p>BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and capturing screenshots at the same time.</p> </li> <li> <p>APPIUM_JAVA_JUNIT: The Appium Java JUnit type.</p> </li> <li> <p>APPIUM_JAVA_TESTNG: The Appium Java TestNG type.</p> </li> <li> <p>APPIUM_PYTHON: The Appium Python type.</p> </li> <li> <p>APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.</p> </li> <li> <p>APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.</p> </li> <li> <p>APPIUM_WEB_PYTHON: The Appium Python type for Web apps.</p> </li> <li> <p>CALABASH: The Calabash type.</p> </li> <li> <p>INSTRUMENTATION: The Instrumentation type.</p> </li> <li> <p>UIAUTOMATION: The uiautomation type.</p> </li> <li> <p>UIAUTOMATOR: The uiautomator type.</p> </li> <li> <p>XCTEST: The XCode test type.</p> </li> <li> <p>XCTEST_UI: The XCode UI test type.</p> </li> </ul>', 'ScheduleRunTest$type' => '<p>The test\'s type.</p> <p>Must be one of the following values:</p> <ul> <li> <p>BUILTIN_FUZZ: The built-in fuzz type.</p> </li> <li> <p>BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and capturing screenshots at the same time.</p> </li> <li> <p>APPIUM_JAVA_JUNIT: The Appium Java JUnit type.</p> </li> <li> <p>APPIUM_JAVA_TESTNG: The Appium Java TestNG type.</p> </li> <li> <p>APPIUM_PYTHON: The Appium Python type.</p> </li> <li> <p>APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.</p> </li> <li> <p>APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.</p> </li> <li> <p>APPIUM_WEB_PYTHON: The Appium Python type for Web apps.</p> </li> <li> <p>CALABASH: The Calabash type.</p> </li> <li> <p>INSTRUMENTATION: The Instrumentation type.</p> </li> <li> <p>UIAUTOMATION: The uiautomation type.</p> </li> <li> <p>UIAUTOMATOR: The uiautomator type.</p> </li> <li> <p>XCTEST: The XCode test type.</p> </li> <li> <p>XCTEST_UI: The XCode UI test type.</p> </li> </ul>', 'Suite$type' => '<p>The suite\'s type.</p> <p>Must be one of the following values:</p> <ul> <li> <p>BUILTIN_FUZZ: The built-in fuzz type.</p> </li> <li> <p>BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and capturing screenshots at the same time.</p> </li> <li> <p>APPIUM_JAVA_JUNIT: The Appium Java JUnit type.</p> </li> <li> <p>APPIUM_JAVA_TESTNG: The Appium Java TestNG type.</p> </li> <li> <p>APPIUM_PYTHON: The Appium Python type.</p> </li> <li> <p>APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.</p> </li> <li> <p>APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.</p> </li> <li> <p>APPIUM_WEB_PYTHON: The Appium Python type for Web apps.</p> </li> <li> <p>CALABASH: The Calabash type.</p> </li> <li> <p>INSTRUMENTATION: The Instrumentation type.</p> </li> <li> <p>UIAUTOMATION: The uiautomation type.</p> </li> <li> <p>UIAUTOMATOR: The uiautomator type.</p> </li> <li> <p>XCTEST: The XCode test type.</p> </li> <li> <p>XCTEST_UI: The XCode UI test type.</p> </li> </ul>', 'Test$type' => '<p>The test\'s type.</p> <p>Must be one of the following values:</p> <ul> <li> <p>BUILTIN_FUZZ: The built-in fuzz type.</p> </li> <li> <p>BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and capturing screenshots at the same time.</p> </li> <li> <p>APPIUM_JAVA_JUNIT: The Appium Java JUnit type.</p> </li> <li> <p>APPIUM_JAVA_TESTNG: The Appium Java TestNG type.</p> </li> <li> <p>APPIUM_PYTHON: The Appium Python type.</p> </li> <li> <p>APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.</p> </li> <li> <p>APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.</p> </li> <li> <p>APPIUM_WEB_PYTHON: The Appium Python type for Web apps.</p> </li> <li> <p>CALABASH: The Calabash type.</p> </li> <li> <p>INSTRUMENTATION: The Instrumentation type.</p> </li> <li> <p>UIAUTOMATION: The uiautomation type.</p> </li> <li> <p>UIAUTOMATOR: The uiautomator type.</p> </li> <li> <p>XCTEST: The XCode test type.</p> </li> <li> <p>XCTEST_UI: The XCode UI test type.</p> </li> </ul>', ], ], 'Tests' => [ 'base' => NULL, 'refs' => [ 'ListTestsResult$tests' => '<p>Information about the tests.</p>', ], ], 'TransactionIdentifier' => [ 'base' => NULL, 'refs' => [ 'OfferingTransaction$transactionId' => '<p>The transaction ID of the offering transaction.</p>', ], ], 'TrialMinutes' => [ 'base' => '<p>Represents information about free trial device minutes for an AWS account.</p>', 'refs' => [ 'AccountSettings$trialMinutes' => '<p>Information about an AWS account\'s usage of free trial device minutes.</p>', ], ], 'URL' => [ 'base' => NULL, 'refs' => [ 'Artifact$url' => '<p>The pre-signed Amazon S3 URL that can be used with a corresponding GET request to download the artifact\'s file.</p>', 'Sample$url' => '<p>The pre-signed Amazon S3 URL that can be used with a corresponding GET request to download the sample\'s file.</p>', 'Upload$url' => '<p>The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT request.</p>', ], ], 'UniqueProblem' => [ 'base' => '<p>A collection of one or more problems, grouped by their result.</p>', 'refs' => [ 'UniqueProblems$member' => NULL, ], ], 'UniqueProblems' => [ 'base' => NULL, 'refs' => [ 'UniqueProblemsByExecutionResultMap$value' => NULL, ], ], 'UniqueProblemsByExecutionResultMap' => [ 'base' => NULL, 'refs' => [ 'ListUniqueProblemsResult$uniqueProblems' => '<p>Information about the unique problems.</p> <p>Allowed values include:</p> <ul> <li> <p>PENDING: A pending condition.</p> </li> <li> <p>PASSED: A passing condition.</p> </li> <li> <p>WARNED: A warning condition.</p> </li> <li> <p>FAILED: A failed condition.</p> </li> <li> <p>SKIPPED: A skipped condition.</p> </li> <li> <p>ERRORED: An error condition.</p> </li> <li> <p>STOPPED: A stopped condition.</p> </li> </ul>', ], ], 'UpdateDevicePoolRequest' => [ 'base' => '<p>Represents a request to the update device pool operation.</p>', 'refs' => [], ], 'UpdateDevicePoolResult' => [ 'base' => '<p>Represents the result of an update device pool request.</p>', 'refs' => [], ], 'UpdateNetworkProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNetworkProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProjectRequest' => [ 'base' => '<p>Represents a request to the update project operation.</p>', 'refs' => [], ], 'UpdateProjectResult' => [ 'base' => '<p>Represents the result of an update project request.</p>', 'refs' => [], ], 'Upload' => [ 'base' => '<p>An app or a set of one or more tests to upload or that have been uploaded.</p>', 'refs' => [ 'CreateUploadResult$upload' => '<p>The newly created upload.</p>', 'GetUploadResult$upload' => '<p>An app or a set of one or more tests to upload or that have been uploaded.</p>', 'InstallToRemoteAccessSessionResult$appUpload' => '<p>An app to upload or that has been uploaded.</p>', 'Uploads$member' => NULL, ], ], 'UploadStatus' => [ 'base' => NULL, 'refs' => [ 'Upload$status' => '<p>The upload\'s status.</p> <p>Must be one of the following values:</p> <ul> <li> <p>FAILED: A failed status.</p> </li> <li> <p>INITIALIZED: An initialized status.</p> </li> <li> <p>PROCESSING: A processing status.</p> </li> <li> <p>SUCCEEDED: A succeeded status.</p> </li> </ul>', ], ], 'UploadType' => [ 'base' => NULL, 'refs' => [ 'CreateUploadRequest$type' => '<p>The upload\'s upload type.</p> <p>Must be one of the following values:</p> <ul> <li> <p>ANDROID_APP: An Android upload.</p> </li> <li> <p>IOS_APP: An iOS upload.</p> </li> <li> <p>WEB_APP: A web appliction upload.</p> </li> <li> <p>EXTERNAL_DATA: An external data upload.</p> </li> <li> <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.</p> </li> <li> <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.</p> </li> <li> <p>APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.</p> </li> <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.</p> </li> <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.</p> </li> <li> <p>APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.</p> </li> <li> <p>CALABASH_TEST_PACKAGE: A Calabash test package upload.</p> </li> <li> <p>INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.</p> </li> <li> <p>UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.</p> </li> <li> <p>UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.</p> </li> <li> <p>XCTEST_TEST_PACKAGE: An XCode test package upload.</p> </li> <li> <p>XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.</p> </li> </ul> <p> <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm throws an <code>ArgumentException</code> error.</p>', 'Upload$type' => '<p>The upload\'s type.</p> <p>Must be one of the following values:</p> <ul> <li> <p>ANDROID_APP: An Android upload.</p> </li> <li> <p>IOS_APP: An iOS upload.</p> </li> <li> <p>WEB_APP: A web appliction upload.</p> </li> <li> <p>EXTERNAL_DATA: An external data upload.</p> </li> <li> <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.</p> </li> <li> <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.</p> </li> <li> <p>APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.</p> </li> <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.</p> </li> <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.</p> </li> <li> <p>APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.</p> </li> <li> <p>CALABASH_TEST_PACKAGE: A Calabash test package upload.</p> </li> <li> <p>INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.</p> </li> <li> <p>UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.</p> </li> <li> <p>UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.</p> </li> <li> <p>XCTEST_TEST_PACKAGE: An XCode test package upload.</p> </li> <li> <p>XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.</p> </li> </ul>', ], ], 'Uploads' => [ 'base' => NULL, 'refs' => [ 'ListUploadsResult$uploads' => '<p>Information about the uploads.</p>', ], ], ],];
