<?php
// This file was auto-generated from sdk-root/src/data/elasticache/2015-02-02/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon ElastiCache</fullname> <p>Amazon ElastiCache is a web service that makes it easier to set up, operate, and scale a distributed cache in the cloud.</p> <p>With ElastiCache, customers get all of the benefits of a high-performance, in-memory cache with less of the administrative burden involved in launching and managing a distributed cache. The service makes setup, scaling, and cluster failure handling much simpler than in a self-managed cache deployment.</p> <p>In addition, through integration with Amazon CloudWatch, customers get enhanced visibility into the key performance statistics associated with their cache and can receive alarms if a part of their cache runs hot.</p>', 'operations' => [ 'AddTagsToResource' => '<p>Adds up to 50 cost allocation tags to the named resource. A cost allocation tag is a key-value pair where the key and value are case-sensitive. You can use cost allocation tags to categorize and track your AWS costs.</p> <p> When you apply tags to your ElastiCache resources, AWS generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/Tagging.html">Using Cost Allocation Tags in Amazon ElastiCache</a> in the <i>ElastiCache User Guide</i>.</p>', 'AuthorizeCacheSecurityGroupIngress' => '<p>Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2, and Amazon EC2 security groups are used as the authorization mechanism.</p> <note> <p>You cannot authorize ingress from an Amazon EC2 security group in one region to an ElastiCache cluster in another region.</p> </note>', 'CopySnapshot' => '<p>Makes a copy of an existing snapshot.</p> <note> <p>This operation is valid for Redis only.</p> </note> <important> <p>Users or groups that have permissions to use the <code>CopySnapshot</code> operation can create their own Amazon S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy to control who has the ability to use the <code>CopySnapshot</code> operation. For more information about using IAM to control the use of ElastiCache operations, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/Snapshots.Exporting.html">Exporting Snapshots</a> and <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/IAM.html">Authentication &amp; Access Control</a>.</p> </important> <p>You could receive the following error messages.</p> <p class="title"> <b>Error Messages</b> </p> <ul> <li> <p> <b>Error Message:</b> The S3 bucket %s is outside of the region.</p> <p> <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/Snapshots.Exporting.html#Snapshots.Exporting.CreateBucket">Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li> <li> <p> <b>Error Message:</b> The S3 bucket %s does not exist.</p> <p> <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/Snapshots.Exporting.html#Snapshots.Exporting.CreateBucket">Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li> <li> <p> <b>Error Message:</b> The S3 bucket %s is not owned by the authenticated user.</p> <p> <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/Snapshots.Exporting.html#Snapshots.Exporting.CreateBucket">Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li> <li> <p> <b>Error Message:</b> The authenticated user does not have sufficient permissions to perform the desired activity.</p> <p> <b>Solution:</b> Contact your system administrator to get the needed permissions.</p> </li> <li> <p> <b>Error Message:</b> The S3 bucket %s already contains an object with key %s.</p> <p> <b>Solution:</b> Give the <code>TargetSnapshotName</code> a new and unique value. If exporting a snapshot, you could alternatively create a new Amazon S3 bucket and use this same value for <code>TargetSnapshotName</code>.</p> </li> <li> <p> <b>Error Message: </b> ElastiCache has not been granted READ permissions %s on the S3 Bucket.</p> <p> <b>Solution:</b> Add List and Read permissions on the bucket. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/Snapshots.Exporting.html#Snapshots.Exporting.GrantAccess">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li> <li> <p> <b>Error Message: </b> ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.</p> <p> <b>Solution:</b> Add Upload/Delete permissions on the bucket. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/Snapshots.Exporting.html#Snapshots.Exporting.GrantAccess">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li> <li> <p> <b>Error Message: </b> ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.</p> <p> <b>Solution:</b> Add View Permissions on the bucket. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/Snapshots.Exporting.html#Snapshots.Exporting.GrantAccess">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li> </ul>', 'CreateCacheCluster' => '<p>Creates a cache cluster. All nodes in the cache cluster run the same protocol-compliant cache engine software, either Memcached or Redis.</p> <important> <p>Due to current limitations on Redis (cluster mode disabled), this operation or parameter is not supported on Redis (cluster mode enabled) replication groups.</p> </important>', 'CreateCacheParameterGroup' => '<p>Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of parameters and their values that are applied to all of the nodes in any cache cluster or replication group using the CacheParameterGroup.</p> <p>A newly created CacheParameterGroup is an exact duplicate of the default parameter group for the CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can change the values of specific parameters. For more information, see:</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html">ModifyCacheParameterGroup</a> in the ElastiCache API Reference.</p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/ParameterGroups.html">Parameters and Parameter Groups</a> in the ElastiCache User Guide.</p> </li> </ul>', 'CreateCacheSecurityGroup' => '<p>Creates a new cache security group. Use a cache security group to control access to one or more cache clusters.</p> <p>Cache security groups are only used when you are creating a cache cluster outside of an Amazon Virtual Private Cloud (Amazon VPC). If you are creating a cache cluster inside of a VPC, use a cache subnet group instead. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html">CreateCacheSubnetGroup</a>.</p>', 'CreateCacheSubnetGroup' => '<p>Creates a new cache subnet group.</p> <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p>', 'CreateReplicationGroup' => '<p>Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group.</p> <p>A Redis (cluster mode disabled) replication group is a collection of cache clusters, where one of the cache clusters is a read/write primary and the others are read-only replicas. Writes to the primary are asynchronously propagated to the replicas.</p> <p>A Redis (cluster mode enabled) replication group is a collection of 1 to 15 node groups (shards). Each node group (shard) has one read/write primary node and up to 5 read-only replica nodes. Writes to the primary are asynchronously propagated to the replicas. Redis (cluster mode enabled) replication groups partition the data across node groups (shards).</p> <p>When a Redis (cluster mode disabled) replication group has been successfully created, you can add one or more read replicas to it, up to a total of 5 read replicas. You cannot alter a Redis (cluster mode enabled) replication group after it has been created. However, if you need to increase or decrease the number of node groups (console: shards), you can avail yourself of ElastiCache for Redis\' enhanced backup and restore. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/backups-restoring.html">Restoring From a Backup with Cluster Resizing</a> in the <i>ElastiCache User Guide</i>.</p> <note> <p>This operation is valid for Redis only.</p> </note>', 'CreateSnapshot' => '<p>Creates a copy of an entire cache cluster or replication group at a specific moment in time.</p> <note> <p>This operation is valid for Redis only.</p> </note>', 'DeleteCacheCluster' => '<p>Deletes a previously provisioned cache cluster. <code>DeleteCacheCluster</code> deletes all associated cache nodes, node endpoints and the cache cluster itself. When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the cache cluster; you cannot cancel or revert this operation.</p> <p>This operation cannot be used to delete a cache cluster that is the last read replica of a replication group or node group (shard) that has Multi-AZ mode enabled or a cache cluster from a Redis (cluster mode enabled) replication group.</p> <important> <p>Due to current limitations on Redis (cluster mode disabled), this operation or parameter is not supported on Redis (cluster mode enabled) replication groups.</p> </important>', 'DeleteCacheParameterGroup' => '<p>Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with any cache clusters.</p>', 'DeleteCacheSecurityGroup' => '<p>Deletes a cache security group.</p> <note> <p>You cannot delete a cache security group if it is associated with any cache clusters.</p> </note>', 'DeleteCacheSubnetGroup' => '<p>Deletes a cache subnet group.</p> <note> <p>You cannot delete a cache subnet group if it is associated with any cache clusters.</p> </note>', 'DeleteReplicationGroup' => '<p>Deletes an existing replication group. By default, this operation deletes the entire replication group, including the primary/primaries and all of the read replicas. If the replication group has only one primary, you can optionally delete only the read replicas, while retaining the primary by setting <code>RetainPrimaryCluster=true</code>.</p> <p>When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.</p> <note> <p>This operation is valid for Redis only.</p> </note>', 'DeleteSnapshot' => '<p>Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately begins deleting the snapshot; you cannot cancel or revert this operation.</p> <note> <p>This operation is valid for Redis only.</p> </note>', 'DescribeCacheClusters' => '<p>Returns information about all provisioned cache clusters if no cache cluster identifier is specified, or about a specific cache cluster if a cache cluster identifier is supplied.</p> <p>By default, abbreviated information about the cache clusters is returned. You can use the optional <i>ShowCacheNodeInfo</i> flag to retrieve detailed information about the cache nodes associated with the cache clusters. These details include the DNS address and port for the cache node endpoint.</p> <p>If the cluster is in the <i>creating</i> state, only cluster-level information is displayed until all of the nodes are successfully provisioned.</p> <p>If the cluster is in the <i>deleting</i> state, only cluster-level information is displayed.</p> <p>If cache nodes are currently being added to the cache cluster, node endpoint information and creation time for the additional nodes are not displayed until they are completely provisioned. When the cache cluster state is <i>available</i>, the cluster is ready for use.</p> <p>If cache nodes are currently being removed from the cache cluster, no endpoint information for the removed nodes is displayed.</p>', 'DescribeCacheEngineVersions' => '<p>Returns a list of the available cache engines and their versions.</p>', 'DescribeCacheParameterGroups' => '<p>Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list contains only the descriptions for that group.</p>', 'DescribeCacheParameters' => '<p>Returns the detailed parameter list for a particular cache parameter group.</p>', 'DescribeCacheSecurityGroups' => '<p>Returns a list of cache security group descriptions. If a cache security group name is specified, the list contains only the description of that group.</p>', 'DescribeCacheSubnetGroups' => '<p>Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group.</p>', 'DescribeEngineDefaultParameters' => '<p>Returns the default engine and system parameter information for the specified cache engine.</p>', 'DescribeEvents' => '<p>Returns events related to cache clusters, cache security groups, and cache parameter groups. You can obtain events specific to a particular cache cluster, cache security group, or cache parameter group by providing the name as a parameter.</p> <p>By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days\' worth of events if necessary.</p>', 'DescribeReplicationGroups' => '<p>Returns information about a particular replication group. If no identifier is specified, <code>DescribeReplicationGroups</code> returns information about all replication groups.</p> <note> <p>This operation is valid for Redis only.</p> </note>', 'DescribeReservedCacheNodes' => '<p>Returns information about reserved cache nodes for this account, or about a specified reserved cache node.</p>', 'DescribeReservedCacheNodesOfferings' => '<p>Lists available reserved cache node offerings.</p>', 'DescribeSnapshots' => '<p>Returns information about cache cluster or replication group snapshots. By default, <code>DescribeSnapshots</code> lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cache cluster.</p> <note> <p>This operation is valid for Redis only.</p> </note>', 'ListAllowedNodeTypeModifications' => '<p>Lists all available node types that you can scale your Redis cluster\'s or replication group\'s current node type up to.</p> <p>When you use the <code>ModifyCacheCluster</code> or <code>ModifyReplicationGroup</code> operations to scale up your cluster or replication group, the value of the <code>CacheNodeType</code> parameter must be one of the node types returned by this operation.</p>', 'ListTagsForResource' => '<p>Lists all cost allocation tags currently on the named resource. A <code>cost allocation tag</code> is a key-value pair where the key is case-sensitive and the value is optional. You can use cost allocation tags to categorize and track your AWS costs.</p> <p>You can have a maximum of 50 cost allocation tags on an ElastiCache resource. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/BestPractices.html">Using Cost Allocation Tags in Amazon ElastiCache</a>.</p>', 'ModifyCacheCluster' => '<p>Modifies the settings for a cache cluster. You can use this operation to change one or more cluster configuration parameters by specifying the parameters and the new values.</p>', 'ModifyCacheParameterGroup' => '<p>Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.</p>', 'ModifyCacheSubnetGroup' => '<p>Modifies an existing cache subnet group.</p>', 'ModifyReplicationGroup' => '<p>Modifies the settings for a replication group.</p> <important> <p>Due to current limitations on Redis (cluster mode disabled), this operation or parameter is not supported on Redis (cluster mode enabled) replication groups.</p> </important> <note> <p>This operation is valid for Redis only.</p> </note>', 'PurchaseReservedCacheNodesOffering' => '<p>Allows you to purchase a reserved cache node offering.</p>', 'RebootCacheCluster' => '<p>Reboots some, or all, of the cache nodes within a provisioned cache cluster. This operation applies any modified cache parameter groups to the cache cluster. The reboot operation takes place as soon as possible, and results in a momentary outage to the cache cluster. During the reboot, the cache cluster status is set to REBOOTING.</p> <p>The reboot causes the contents of the cache (for each cache node being rebooted) to be lost.</p> <p>When the reboot is complete, a cache cluster event is created.</p>', 'RemoveTagsFromResource' => '<p>Removes the tags identified by the <code>TagKeys</code> list from the named resource.</p>', 'ResetCacheParameterGroup' => '<p>Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the <code>ResetAllParameters</code> and <code>CacheParameterGroupName</code> parameters.</p>', 'RevokeCacheSecurityGroupIngress' => '<p>Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security group that had been previously authorized.</p>', 'TestFailover' => '<p>Represents the input of a <code>TestFailover</code> operation which test automatic failover on a specified node group (called shard in the console) in a replication group (called cluster in the console).</p> <p class="title"> <b>Note the following</b> </p> <ul> <li> <p>A customer can use this operation to test automatic failover on up to 5 shards (called node groups in the ElastiCache API and AWS CLI) in any rolling 24-hour period.</p> </li> <li> <p>If calling this operation on shards in different clusters (called replication groups in the API and CLI), the calls can be made concurrently.</p> <p> </p> </li> <li> <p>If calling this operation multiple times on different shards in the same Redis (cluster mode enabled) replication group, the first node replacement must complete before a subsequent call can be made.</p> </li> <li> <p>To determine whether the node replacement is complete you can check Events using the Amazon ElastiCache console, the AWS CLI, or the ElastiCache API. Look for the following automatic failover related events, listed here in order of occurrance:</p> <ol> <li> <p>Replication group message: <code>Test Failover API called for node group &lt;node-group-id&gt;</code> </p> </li> <li> <p>Cache cluster message: <code>Failover from master node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed</code> </p> </li> <li> <p>Replication group message: <code>Failover from master node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed</code> </p> </li> <li> <p>Cache cluster message: <code>Recovering cache nodes &lt;node-id&gt;</code> </p> </li> <li> <p>Cache cluster message: <code>Finished recovery for cache nodes &lt;node-id&gt;</code> </p> </li> </ol> <p>For more information see:</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/ECEvents.Viewing.html">Viewing ElastiCache Events</a> in the <i>ElastiCache User Guide</i> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html">DescribeEvents</a> in the ElastiCache API Reference</p> </li> </ul> </li> </ul> <p>Also see, <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/AutoFailover.html#auto-failover-test">Testing Multi-AZ with Automatic Failover</a> in the <i>ElastiCache User Guide</i>.</p>', ], 'shapes' => [ 'APICallRateForCustomerExceededFault' => [ 'base' => '<p>The customer has exceeded the allowed rate of API calls.</p>', 'refs' => [], ], 'AZMode' => [ 'base' => NULL, 'refs' => [ 'CreateCacheClusterMessage$AZMode' => '<p>Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster\'s region.</p> <p>This parameter is only supported for Memcached cache clusters.</p> <p>If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes <code>single-az</code> mode.</p>', 'ModifyCacheClusterMessage$AZMode' => '<p>Specifies whether the new nodes in this Memcached cache cluster are all created in a single Availability Zone or created across multiple Availability Zones.</p> <p>Valid values: <code>single-az</code> | <code>cross-az</code>.</p> <p>This option is only supported for Memcached cache clusters.</p> <note> <p>You cannot specify <code>single-az</code> if the Memcached cache cluster already has cache nodes in different Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone.</p> <p>Only newly created nodes are located in different Availability Zones. For instructions on how to move existing Memcached nodes to different Availability Zones, see the <b>Availability Zone Considerations</b> section of <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheNode.Memcached.html">Cache Node Considerations for Memcached</a>.</p> </note>', ], ], 'AddTagsToResourceMessage' => [ 'base' => '<p>Represents the input of an AddTagsToResource operation.</p>', 'refs' => [], ], 'AllowedNodeTypeModificationsMessage' => [ 'base' => '<p>Represents the allowed node types you can use to modify your cache cluster or replication group.</p>', 'refs' => [], ], 'AuthorizationAlreadyExistsFault' => [ 'base' => '<p>The specified Amazon EC2 security group is already authorized for the specified cache security group.</p>', 'refs' => [], ], 'AuthorizationNotFoundFault' => [ 'base' => '<p>The specified Amazon EC2 security group is not authorized for the specified cache security group.</p>', 'refs' => [], ], 'AuthorizeCacheSecurityGroupIngressMessage' => [ 'base' => '<p>Represents the input of an AuthorizeCacheSecurityGroupIngress operation.</p>', 'refs' => [], ], 'AuthorizeCacheSecurityGroupIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'AutomaticFailoverStatus' => [ 'base' => NULL, 'refs' => [ 'ReplicationGroup$AutomaticFailover' => '<p>Indicates the status of Multi-AZ for this replication group.</p> <note> <p>ElastiCache Multi-AZ replication groups are not supported on:</p> <ul> <li> <p>Redis versions earlier than 2.8.6.</p> </li> <li> <p>Redis (cluster mode disabled):T1 and T2 cache node types.</p> <p>Redis (cluster mode enabled): T1 node types.</p> </li> </ul> </note>', 'Snapshot$AutomaticFailover' => '<p>Indicates the status of Multi-AZ for the source replication group.</p> <note> <p>ElastiCache Multi-AZ replication groups are not supported on:</p> <ul> <li> <p>Redis versions earlier than 2.8.6.</p> </li> <li> <p>Redis (cluster mode disabled):T1 and T2 cache node types.</p> <p>Redis (cluster mode enabled): T1 node types.</p> </li> </ul> </note>', ], ], 'AvailabilityZone' => [ 'base' => '<p>Describes an Availability Zone in which the cache cluster is launched.</p>', 'refs' => [ 'Subnet$SubnetAvailabilityZone' => '<p>The Availability Zone associated with the subnet.</p>', ], ], 'AvailabilityZonesList' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationGroupMessage$PreferredCacheClusterAZs' => '<p>A list of EC2 Availability Zones in which the replication group\'s cache clusters are created. The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.</p> <p>This parameter is not used if there is more than one node group (shard). You should use <code>NodeGroupConfiguration</code> instead.</p> <note> <p>If you are creating your replication group in an Amazon VPC (recommended), you can only locate cache clusters in Availability Zones associated with the subnets in the selected subnet group.</p> <p>The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.</p> </note> <p>Default: system chosen Availability Zones.</p>', 'NodeGroupConfiguration$ReplicaAvailabilityZones' => '<p>A list of Availability Zones to be used for the read replicas. The number of Availability Zones in this list must match the value of <code>ReplicaCount</code> or <code>ReplicasPerNodeGroup</code> if not specified.</p>', ], ], 'AwsQueryErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidParameterCombinationException$message' => '<p>Two or more parameters that must not be used together were used together.</p>', 'InvalidParameterValueException$message' => '<p>A parameter value is invalid.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$AutoMinorVersionUpgrade' => '<p>This parameter is currently disabled.</p>', 'CacheNodeTypeSpecificParameter$IsModifiable' => '<p>Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.</p>', 'DescribeCacheEngineVersionsMessage$DefaultOnly' => '<p>If <code>true</code>, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>', 'ModifyCacheClusterMessage$ApplyImmediately' => '<p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the cache cluster.</p> <p>If <code>false</code>, changes to the cache cluster are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p> <important> <p>If you perform a <code>ModifyCacheCluster</code> before a pending modification is applied, the pending modification is replaced by the newer modification.</p> </important> <p>Valid values: <code>true</code> | <code>false</code> </p> <p>Default: <code>false</code> </p>', 'ModifyReplicationGroupMessage$ApplyImmediately' => '<p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the replication group.</p> <p>If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p> <p>Valid values: <code>true</code> | <code>false</code> </p> <p>Default: <code>false</code> </p>', 'Parameter$IsModifiable' => '<p>Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.</p>', 'ResetCacheParameterGroupMessage$ResetAllParameters' => '<p>If <code>true</code>, all parameters in the cache parameter group are reset to their default values. If <code>false</code>, only the parameters listed by <code>ParameterNameValues</code> are reset to their default values.</p> <p>Valid values: <code>true</code> | <code>false</code> </p>', 'Snapshot$AutoMinorVersionUpgrade' => '<p>This parameter is currently disabled.</p>', ], ], 'BooleanOptional' => [ 'base' => NULL, 'refs' => [ 'CreateCacheClusterMessage$AutoMinorVersionUpgrade' => '<p>This parameter is currently disabled.</p>', 'CreateReplicationGroupMessage$AutomaticFailoverEnabled' => '<p>Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.</p> <p>If <code>true</code>, Multi-AZ is enabled for this replication group. If <code>false</code>, Multi-AZ is disabled for this replication group.</p> <p> <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.</p> <p>Default: false</p> <note> <p>ElastiCache Multi-AZ replication groups is not supported on:</p> <ul> <li> <p>Redis versions earlier than 2.8.6.</p> </li> <li> <p>Redis (cluster mode disabled): T1 and T2 node types.</p> <p>Redis (cluster mode enabled): T2 node types.</p> </li> </ul> </note>', 'CreateReplicationGroupMessage$AutoMinorVersionUpgrade' => '<p>This parameter is currently disabled.</p>', 'DeleteReplicationGroupMessage$RetainPrimaryCluster' => '<p>If set to <code>true</code>, all of the read replicas are deleted, but the primary node is retained.</p>', 'DescribeCacheClustersMessage$ShowCacheNodeInfo' => '<p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to retrieve information about the individual cache nodes.</p>', 'DescribeCacheClustersMessage$ShowCacheClustersNotInReplicationGroups' => '<p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to show only nodes (API/CLI: clusters) that are not members of a replication group. In practice, this mean Memcached and single node Redis clusters.</p>', 'DescribeSnapshotsMessage$ShowNodeGroupConfig' => '<p>A Boolean value which if true, the node group (shard) configuration is included in the snapshot description.</p>', 'ModifyCacheClusterMessage$AutoMinorVersionUpgrade' => '<p>This parameter is currently disabled.</p>', 'ModifyReplicationGroupMessage$AutomaticFailoverEnabled' => '<p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure.</p> <p>Valid values: <code>true</code> | <code>false</code> </p> <note> <p>ElastiCache Multi-AZ replication groups are not supported on:</p> <ul> <li> <p>Redis versions earlier than 2.8.6.</p> </li> <li> <p>Redis (cluster mode disabled):T1 and T2 cache node types.</p> <p>Redis (cluster mode enabled): T1 node types.</p> </li> </ul> </note>', 'ModifyReplicationGroupMessage$AutoMinorVersionUpgrade' => '<p>This parameter is currently disabled.</p>', 'ReplicationGroup$ClusterEnabled' => '<p>A flag indicating whether or not this replication group is cluster enabled; i.e., whether its data can be partitioned across multiple shards (API/CLI: node groups).</p> <p>Valid values: <code>true</code> | <code>false</code> </p>', ], ], 'CacheCluster' => [ 'base' => '<p>Contains all of the attributes of a specific cache cluster.</p>', 'refs' => [ 'CacheClusterList$member' => NULL, 'CreateCacheClusterResult$CacheCluster' => NULL, 'DeleteCacheClusterResult$CacheCluster' => NULL, 'ModifyCacheClusterResult$CacheCluster' => NULL, 'RebootCacheClusterResult$CacheCluster' => NULL, ], ], 'CacheClusterAlreadyExistsFault' => [ 'base' => '<p>You already have a cache cluster with the given identifier.</p>', 'refs' => [], ], 'CacheClusterList' => [ 'base' => NULL, 'refs' => [ 'CacheClusterMessage$CacheClusters' => '<p>A list of cache clusters. Each item in the list contains detailed information about one cache cluster.</p>', ], ], 'CacheClusterMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeCacheClusters</code> operation.</p>', 'refs' => [], ], 'CacheClusterNotFoundFault' => [ 'base' => '<p>The requested cache cluster ID does not refer to an existing cache cluster.</p>', 'refs' => [], ], 'CacheEngineVersion' => [ 'base' => '<p>Provides all of the details about a particular cache engine version.</p>', 'refs' => [ 'CacheEngineVersionList$member' => NULL, ], ], 'CacheEngineVersionList' => [ 'base' => NULL, 'refs' => [ 'CacheEngineVersionMessage$CacheEngineVersions' => '<p>A list of cache engine version details. Each element in the list contains detailed information about one cache engine version.</p>', ], ], 'CacheEngineVersionMessage' => [ 'base' => '<p>Represents the output of a <a>DescribeCacheEngineVersions</a> operation.</p>', 'refs' => [], ], 'CacheNode' => [ 'base' => '<p>Represents an individual cache node within a cache cluster. Each cache node runs its own instance of the cluster\'s protocol-compliant caching software - either Memcached or Redis.</p> <p>Valid node types are as follows:</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>, <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>, <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.t1.micro</code>, <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized: <code>cache.c1.xlarge</code> </p> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Notes:</b> </p> <ul> <li> <p>All T2 instances are created in an Amazon Virtual Private Cloud (Amazon VPC).</p> </li> <li> <p>Redis backup/restore is not supported for Redis (cluster mode disabled) T1 and T2 instances. Backup/restore is supported on Redis (cluster mode enabled) T2 instances.</p> </li> <li> <p>Redis Append-only files (AOF) functionality is not supported for T1 or T2 instances.</p> </li> </ul> <p>For a complete listing of node types and specifications, see <a href="http://aws.amazon.com/elasticache/details">Amazon ElastiCache Product Features and Details</a> and either <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#ParameterGroups.Memcached.NodeSpecific">Cache Node Type-Specific Parameters for Memcached</a> or <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#ParameterGroups.Redis.NodeSpecific">Cache Node Type-Specific Parameters for Redis</a>.</p>', 'refs' => [ 'CacheNodeList$member' => NULL, ], ], 'CacheNodeIdsList' => [ 'base' => NULL, 'refs' => [ 'CacheParameterGroupStatus$CacheNodeIdsToReboot' => '<p>A list of the cache node IDs which need to be rebooted for parameter changes to be applied. A node ID is a numeric identifier (0001, 0002, etc.).</p>', 'ModifyCacheClusterMessage$CacheNodeIdsToRemove' => '<p>A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter is only valid when <code>NumCacheNodes</code> is less than the existing number of cache nodes. The number of cache node IDs supplied in this parameter must match the difference between the existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the value of <code>NumCacheNodes</code> in the request.</p> <p>For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this <code>ModifyCacheCluser</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.</p>', 'PendingModifiedValues$CacheNodeIdsToRemove' => '<p>A list of cache node IDs that are being removed (or will be removed) from the cache cluster. A node ID is a numeric identifier (0001, 0002, etc.).</p>', 'RebootCacheClusterMessage$CacheNodeIdsToReboot' => '<p>A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an entire cache cluster, specify all of the cache node IDs.</p>', ], ], 'CacheNodeList' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$CacheNodes' => '<p>A list of cache nodes that are members of the cache cluster.</p>', ], ], 'CacheNodeTypeSpecificParameter' => [ 'base' => '<p>A parameter that has a different value for each cache node type it is applied to. For example, in a Redis cache cluster, a <code>cache.m1.large</code> cache node type would have a larger <code>maxmemory</code> value than a <code>cache.m1.small</code> type.</p>', 'refs' => [ 'CacheNodeTypeSpecificParametersList$member' => NULL, ], ], 'CacheNodeTypeSpecificParametersList' => [ 'base' => NULL, 'refs' => [ 'CacheParameterGroupDetails$CacheNodeTypeSpecificParameters' => '<p>A list of parameters specific to a particular cache node type. Each element in the list contains detailed information about one parameter.</p>', 'EngineDefaults$CacheNodeTypeSpecificParameters' => '<p>A list of parameters specific to a particular cache node type. Each element in the list contains detailed information about one parameter.</p>', ], ], 'CacheNodeTypeSpecificValue' => [ 'base' => '<p>A value that applies only to a certain cache node type.</p>', 'refs' => [ 'CacheNodeTypeSpecificValueList$member' => NULL, ], ], 'CacheNodeTypeSpecificValueList' => [ 'base' => NULL, 'refs' => [ 'CacheNodeTypeSpecificParameter$CacheNodeTypeSpecificValues' => '<p>A list of cache node types and their corresponding values for this parameter.</p>', ], ], 'CacheParameterGroup' => [ 'base' => '<p>Represents the output of a <code>CreateCacheParameterGroup</code> operation.</p>', 'refs' => [ 'CacheParameterGroupList$member' => NULL, 'CreateCacheParameterGroupResult$CacheParameterGroup' => NULL, ], ], 'CacheParameterGroupAlreadyExistsFault' => [ 'base' => '<p>A cache parameter group with the requested name already exists.</p>', 'refs' => [], ], 'CacheParameterGroupDetails' => [ 'base' => '<p>Represents the output of a <code>DescribeCacheParameters</code> operation.</p>', 'refs' => [], ], 'CacheParameterGroupList' => [ 'base' => NULL, 'refs' => [ 'CacheParameterGroupsMessage$CacheParameterGroups' => '<p>A list of cache parameter groups. Each element in the list contains detailed information about one cache parameter group.</p>', ], ], 'CacheParameterGroupNameMessage' => [ 'base' => '<p>Represents the output of one of the following operations:</p> <ul> <li> <p> <code>ModifyCacheParameterGroup</code> </p> </li> <li> <p> <code>ResetCacheParameterGroup</code> </p> </li> </ul>', 'refs' => [], ], 'CacheParameterGroupNotFoundFault' => [ 'base' => '<p>The requested cache parameter group name does not refer to an existing cache parameter group.</p>', 'refs' => [], ], 'CacheParameterGroupQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the maximum number of cache security groups.</p>', 'refs' => [], ], 'CacheParameterGroupStatus' => [ 'base' => '<p>Status of the cache parameter group.</p>', 'refs' => [ 'CacheCluster$CacheParameterGroup' => NULL, ], ], 'CacheParameterGroupsMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeCacheParameterGroups</code> operation.</p>', 'refs' => [], ], 'CacheSecurityGroup' => [ 'base' => '<p>Represents the output of one of the following operations:</p> <ul> <li> <p> <code>AuthorizeCacheSecurityGroupIngress</code> </p> </li> <li> <p> <code>CreateCacheSecurityGroup</code> </p> </li> <li> <p> <code>RevokeCacheSecurityGroupIngress</code> </p> </li> </ul>', 'refs' => [ 'AuthorizeCacheSecurityGroupIngressResult$CacheSecurityGroup' => NULL, 'CacheSecurityGroups$member' => NULL, 'CreateCacheSecurityGroupResult$CacheSecurityGroup' => NULL, 'RevokeCacheSecurityGroupIngressResult$CacheSecurityGroup' => NULL, ], ], 'CacheSecurityGroupAlreadyExistsFault' => [ 'base' => '<p>A cache security group with the specified name already exists.</p>', 'refs' => [], ], 'CacheSecurityGroupMembership' => [ 'base' => '<p>Represents a cache cluster\'s status within a particular cache security group.</p>', 'refs' => [ 'CacheSecurityGroupMembershipList$member' => NULL, ], ], 'CacheSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$CacheSecurityGroups' => '<p>A list of cache security group elements, composed of name and status sub-elements.</p>', ], ], 'CacheSecurityGroupMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeCacheSecurityGroups</code> operation.</p>', 'refs' => [], ], 'CacheSecurityGroupNameList' => [ 'base' => NULL, 'refs' => [ 'CreateCacheClusterMessage$CacheSecurityGroupNames' => '<p>A list of security group names to associate with this cache cluster.</p> <p>Use this parameter only when you are creating a cache cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>', 'CreateReplicationGroupMessage$CacheSecurityGroupNames' => '<p>A list of cache security group names to associate with this replication group.</p>', 'ModifyCacheClusterMessage$CacheSecurityGroupNames' => '<p>A list of cache security group names to authorize on this cache cluster. This change is asynchronously applied as soon as possible.</p> <p>You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud (Amazon VPC).</p> <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".</p>', 'ModifyReplicationGroupMessage$CacheSecurityGroupNames' => '<p>A list of cache security group names to authorize for the clusters in this replication group. This change is asynchronously applied as soon as possible.</p> <p>This parameter can be used only with replication group containing cache clusters running outside of an Amazon Virtual Private Cloud (Amazon VPC).</p> <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.</p>', ], ], 'CacheSecurityGroupNotFoundFault' => [ 'base' => '<p>The requested cache security group name does not refer to an existing cache security group.</p>', 'refs' => [], ], 'CacheSecurityGroupQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the allowed number of cache security groups.</p>', 'refs' => [], ], 'CacheSecurityGroups' => [ 'base' => NULL, 'refs' => [ 'CacheSecurityGroupMessage$CacheSecurityGroups' => '<p>A list of cache security groups. Each element in the list contains detailed information about one group.</p>', ], ], 'CacheSubnetGroup' => [ 'base' => '<p>Represents the output of one of the following operations:</p> <ul> <li> <p> <code>CreateCacheSubnetGroup</code> </p> </li> <li> <p> <code>ModifyCacheSubnetGroup</code> </p> </li> </ul>', 'refs' => [ 'CacheSubnetGroups$member' => NULL, 'CreateCacheSubnetGroupResult$CacheSubnetGroup' => NULL, 'ModifyCacheSubnetGroupResult$CacheSubnetGroup' => NULL, ], ], 'CacheSubnetGroupAlreadyExistsFault' => [ 'base' => '<p>The requested cache subnet group name is already in use by an existing cache subnet group.</p>', 'refs' => [], ], 'CacheSubnetGroupInUse' => [ 'base' => '<p>The requested cache subnet group is currently in use.</p>', 'refs' => [], ], 'CacheSubnetGroupMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeCacheSubnetGroups</code> operation.</p>', 'refs' => [], ], 'CacheSubnetGroupNotFoundFault' => [ 'base' => '<p>The requested cache subnet group name does not refer to an existing cache subnet group.</p>', 'refs' => [], ], 'CacheSubnetGroupQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the allowed number of cache subnet groups.</p>', 'refs' => [], ], 'CacheSubnetGroups' => [ 'base' => NULL, 'refs' => [ 'CacheSubnetGroupMessage$CacheSubnetGroups' => '<p>A list of cache subnet groups. Each element in the list contains detailed information about one group.</p>', ], ], 'CacheSubnetQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the allowed number of subnets in a cache subnet group.</p>', 'refs' => [], ], 'ChangeType' => [ 'base' => NULL, 'refs' => [ 'CacheNodeTypeSpecificParameter$ChangeType' => '<p>Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to be applied. You can force a reboot or wait until the next maintenance window\'s reboot. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/Clusters.Rebooting.html">Rebooting a Cluster</a>.</p>', 'Parameter$ChangeType' => '<p>Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to be applied. You can force a reboot or wait until the next maintenance window\'s reboot. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/Clusters.Rebooting.html">Rebooting a Cluster</a>.</p>', ], ], 'ClusterIdList' => [ 'base' => NULL, 'refs' => [ 'ReplicationGroup$MemberClusters' => '<p>The names of all the cache clusters that are part of this replication group.</p>', ], ], 'ClusterQuotaForCustomerExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the allowed number of cache clusters per customer.</p>', 'refs' => [], ], 'CopySnapshotMessage' => [ 'base' => '<p>Represents the input of a <code>CopySnapshotMessage</code> operation.</p>', 'refs' => [], ], 'CopySnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCacheClusterMessage' => [ 'base' => '<p>Represents the input of a CreateCacheCluster operation.</p>', 'refs' => [], ], 'CreateCacheClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCacheParameterGroupMessage' => [ 'base' => '<p>Represents the input of a <code>CreateCacheParameterGroup</code> operation.</p>', 'refs' => [], ], 'CreateCacheParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCacheSecurityGroupMessage' => [ 'base' => '<p>Represents the input of a <code>CreateCacheSecurityGroup</code> operation.</p>', 'refs' => [], ], 'CreateCacheSecurityGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCacheSubnetGroupMessage' => [ 'base' => '<p>Represents the input of a <code>CreateCacheSubnetGroup</code> operation.</p>', 'refs' => [], ], 'CreateCacheSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateReplicationGroupMessage' => [ 'base' => '<p>Represents the input of a <code>CreateReplicationGroup</code> operation.</p>', 'refs' => [], ], 'CreateReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotMessage' => [ 'base' => '<p>Represents the input of a <code>CreateSnapshot</code> operation.</p>', 'refs' => [], ], 'CreateSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCacheClusterMessage' => [ 'base' => '<p>Represents the input of a <code>DeleteCacheCluster</code> operation.</p>', 'refs' => [], ], 'DeleteCacheClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCacheParameterGroupMessage' => [ 'base' => '<p>Represents the input of a <code>DeleteCacheParameterGroup</code> operation.</p>', 'refs' => [], ], 'DeleteCacheSecurityGroupMessage' => [ 'base' => '<p>Represents the input of a <code>DeleteCacheSecurityGroup</code> operation.</p>', 'refs' => [], ], 'DeleteCacheSubnetGroupMessage' => [ 'base' => '<p>Represents the input of a <code>DeleteCacheSubnetGroup</code> operation.</p>', 'refs' => [], ], 'DeleteReplicationGroupMessage' => [ 'base' => '<p>Represents the input of a <code>DeleteReplicationGroup</code> operation.</p>', 'refs' => [], ], 'DeleteReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotMessage' => [ 'base' => '<p>Represents the input of a <code>DeleteSnapshot</code> operation.</p>', 'refs' => [], ], 'DeleteSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCacheClustersMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeCacheClusters</code> operation.</p>', 'refs' => [], ], 'DescribeCacheEngineVersionsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeCacheEngineVersions</code> operation.</p>', 'refs' => [], ], 'DescribeCacheParameterGroupsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeCacheParameterGroups</code> operation.</p>', 'refs' => [], ], 'DescribeCacheParametersMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeCacheParameters</code> operation.</p>', 'refs' => [], ], 'DescribeCacheSecurityGroupsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeCacheSecurityGroups</code> operation.</p>', 'refs' => [], ], 'DescribeCacheSubnetGroupsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeCacheSubnetGroups</code> operation.</p>', 'refs' => [], ], 'DescribeEngineDefaultParametersMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeEngineDefaultParameters</code> operation.</p>', 'refs' => [], ], 'DescribeEngineDefaultParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeEvents</code> operation.</p>', 'refs' => [], ], 'DescribeReplicationGroupsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeReplicationGroups</code> operation.</p>', 'refs' => [], ], 'DescribeReservedCacheNodesMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeReservedCacheNodes</code> operation.</p>', 'refs' => [], ], 'DescribeReservedCacheNodesOfferingsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeReservedCacheNodesOfferings</code> operation.</p>', 'refs' => [], ], 'DescribeSnapshotsListMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeSnapshots</code> operation.</p>', 'refs' => [], ], 'DescribeSnapshotsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeSnapshotsMessage</code> operation.</p>', 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'RecurringCharge$RecurringChargeAmount' => '<p>The monetary amount of the recurring charge.</p>', 'ReservedCacheNode$FixedPrice' => '<p>The fixed price charged for this reserved cache node.</p>', 'ReservedCacheNode$UsagePrice' => '<p>The hourly price charged for this reserved cache node.</p>', 'ReservedCacheNodesOffering$FixedPrice' => '<p>The fixed price charged for this offering.</p>', 'ReservedCacheNodesOffering$UsagePrice' => '<p>The hourly price charged for this offering.</p>', ], ], 'EC2SecurityGroup' => [ 'base' => '<p>Provides ownership and status information for an Amazon EC2 security group.</p>', 'refs' => [ 'EC2SecurityGroupList$member' => NULL, ], ], 'EC2SecurityGroupList' => [ 'base' => NULL, 'refs' => [ 'CacheSecurityGroup$EC2SecurityGroups' => '<p>A list of Amazon EC2 security groups that are associated with this cache security group.</p>', ], ], 'Endpoint' => [ 'base' => '<p>Represents the information required for client programs to connect to a cache node.</p>', 'refs' => [ 'CacheCluster$ConfigurationEndpoint' => '<p>Represents a Memcached cluster endpoint which, if Automatic Discovery is enabled on the cluster, can be used by an application to connect to any node in the cluster. The configuration endpoint will always have <code>.cfg</code> in it.</p> <p>Example: <code>mem-3.9dvc4r<u>.cfg</u>.usw2.cache.amazonaws.com:11211</code> </p>', 'CacheNode$Endpoint' => '<p>The hostname for connecting to this cache node.</p>', 'NodeGroup$PrimaryEndpoint' => '<p>The endpoint of the primary node in this node group (shard).</p>', 'NodeGroupMember$ReadEndpoint' => NULL, 'ReplicationGroup$ConfigurationEndpoint' => '<p>The configuration endpoint for this replicaiton group. Use the configuration endpoint to connect to this replication group.</p>', ], ], 'EngineDefaults' => [ 'base' => '<p>Represents the output of a <code>DescribeEngineDefaultParameters</code> operation.</p>', 'refs' => [ 'DescribeEngineDefaultParametersResult$EngineDefaults' => NULL, ], ], 'Event' => [ 'base' => '<p>Represents a single occurrence of something interesting within the system. Some examples of events are creating a cache cluster, adding or removing a cache node, or rebooting a node.</p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'EventsMessage$Events' => '<p>A list of events. Each element in the list contains detailed information about one event.</p>', ], ], 'EventsMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeEvents</code> operation.</p>', 'refs' => [], ], 'InsufficientCacheClusterCapacityFault' => [ 'base' => '<p>The requested cache node type is not available in the specified Availability Zone.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Endpoint$Port' => '<p>The port number that the cache engine is listening on.</p>', 'ReservedCacheNode$Duration' => '<p>The duration of the reservation in seconds.</p>', 'ReservedCacheNode$CacheNodeCount' => '<p>The number of cache nodes that have been reserved.</p>', 'ReservedCacheNodesOffering$Duration' => '<p>The duration of the offering. in seconds.</p>', ], ], 'IntegerOptional' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$NumCacheNodes' => '<p>The number of cache nodes in the cache cluster.</p> <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 20.</p>', 'CacheCluster$SnapshotRetentionLimit' => '<p>The number of days for which ElastiCache retains automatic cache cluster snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <important> <p> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p> </important>', 'CreateCacheClusterMessage$NumCacheNodes' => '<p>The initial number of cache nodes that the cache cluster has.</p> <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 20.</p> <p>If you need more than 20 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase Request form at <a href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http://aws.amazon.com/contact-us/elasticache-node-limit-request/</a>.</p>', 'CreateCacheClusterMessage$Port' => '<p>The port number on which each of the cache nodes accepts connections.</p>', 'CreateCacheClusterMessage$SnapshotRetentionLimit' => '<p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note> <p>Default: 0 (i.e., automatic backups are disabled for this cache cluster).</p>', 'CreateReplicationGroupMessage$NumCacheClusters' => '<p>The number of clusters this replication group initially has.</p> <p>This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.</p> <p>If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.</p> <p>The maximum permitted value for <code>NumCacheClusters</code> is 6 (primary plus 5 replicas).</p>', 'CreateReplicationGroupMessage$NumNodeGroups' => '<p>An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.</p> <p>Default: 1</p>', 'CreateReplicationGroupMessage$ReplicasPerNodeGroup' => '<p>An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0 to 5.</p>', 'CreateReplicationGroupMessage$Port' => '<p>The port number on which each member of the replication group accepts connections.</p>', 'CreateReplicationGroupMessage$SnapshotRetentionLimit' => '<p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note> <p>Default: 0 (i.e., automatic backups are disabled for this cache cluster).</p>', 'DescribeCacheClustersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeCacheEngineVersionsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeCacheParameterGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeCacheParametersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeCacheSecurityGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeCacheSubnetGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeEngineDefaultParametersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeEventsMessage$Duration' => '<p>The number of minutes worth of events to retrieve.</p>', 'DescribeEventsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeReplicationGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeReservedCacheNodesMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeReservedCacheNodesOfferingsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeSnapshotsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 50</p> <p>Constraints: minimum 20; maximum 50.</p>', 'ModifyCacheClusterMessage$NumCacheNodes' => '<p>The number of cache nodes that the cache cluster should have. If the value for <code>NumCacheNodes</code> is greater than the sum of the number of current cache nodes and the number of cache nodes pending creation (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes, nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove requests are canceled.</p> <p>If you are removing cache nodes, you must use the <code>CacheNodeIdsToRemove</code> parameter to provide the IDs of the specific cache nodes to remove.</p> <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 20.</p> <note> <p>Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see <code>ApplyImmediately</code>).</p> <p>A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The customer\'s latest request to add or remove nodes to the cluster overrides any previous pending operations to modify the number of cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache nodes may now be provisioned in different Availability Zones with flexible cache node placement, a request to add nodes does not automatically override a previous pending operation to add nodes. The customer can modify the previous pending operation to add more nodes or explicitly cancel the pending request and retry the new request. To cancel pending operations to modify the number of cache nodes in a cluster, use the <code>ModifyCacheCluster</code> request and set <code>NumCacheNodes</code> equal to the number of cache nodes currently in the cache cluster.</p> </note>', 'ModifyCacheClusterMessage$SnapshotRetentionLimit' => '<p>The number of days for which ElastiCache retains automatic cache cluster snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <note> <p>If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p> </note>', 'ModifyReplicationGroupMessage$SnapshotRetentionLimit' => '<p>The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <p> <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>', 'NodeGroupConfiguration$ReplicaCount' => '<p>The number of read replica nodes in this node group (shard).</p>', 'PendingModifiedValues$NumCacheNodes' => '<p>The new number of cache nodes for the cache cluster.</p> <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 20.</p>', 'PurchaseReservedCacheNodesOfferingMessage$CacheNodeCount' => '<p>The number of cache node instances to reserve.</p> <p>Default: <code>1</code> </p>', 'ReplicationGroup$SnapshotRetentionLimit' => '<p>The number of days for which ElastiCache retains automatic cache cluster snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <important> <p> If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p> </important>', 'Snapshot$NumCacheNodes' => '<p>The number of cache nodes in the source cache cluster.</p> <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 20.</p>', 'Snapshot$Port' => '<p>The port number used by each cache nodes in the source cache cluster.</p>', 'Snapshot$SnapshotRetentionLimit' => '<p>For an automatic snapshot, the number of days for which ElastiCache retains the snapshot before deleting it.</p> <p>For manual snapshots, this field reflects the <code>SnapshotRetentionLimit</code> for the source cache cluster when the snapshot was created. This field is otherwise ignored: Manual snapshots do not expire, and can only be deleted using the <code>DeleteSnapshot</code> operation. </p> <p> <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>', 'Snapshot$NumNodeGroups' => '<p>The number of node groups (shards) in this snapshot. When restoring from a snapshot, the number of node groups (shards) in the snapshot and in the restored replication group must be the same.</p>', ], ], 'InvalidARNFault' => [ 'base' => '<p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>', 'refs' => [], ], 'InvalidCacheClusterStateFault' => [ 'base' => '<p>The requested cache cluster is not in the <code>available</code> state.</p>', 'refs' => [], ], 'InvalidCacheParameterGroupStateFault' => [ 'base' => '<p>The current state of the cache parameter group does not allow the requested operation to occur.</p>', 'refs' => [], ], 'InvalidCacheSecurityGroupStateFault' => [ 'base' => '<p>The current state of the cache security group does not allow deletion.</p>', 'refs' => [], ], 'InvalidParameterCombinationException' => [ 'base' => '<p>Two or more incompatible parameters were specified.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>The value for a parameter is invalid.</p>', 'refs' => [], ], 'InvalidReplicationGroupStateFault' => [ 'base' => '<p>The requested replication group is not in the <code>available</code> state.</p>', 'refs' => [], ], 'InvalidSnapshotStateFault' => [ 'base' => '<p>The current state of the snapshot does not allow the requested operation to occur.</p>', 'refs' => [], ], 'InvalidSubnet' => [ 'base' => '<p>An invalid subnet identifier was specified.</p>', 'refs' => [], ], 'InvalidVPCNetworkStateFault' => [ 'base' => '<p>The VPC network is in an invalid state.</p>', 'refs' => [], ], 'KeyList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsFromResourceMessage$TagKeys' => '<p>A list of <code>TagKeys</code> identifying the tags you want removed from the named resource.</p>', ], ], 'ListAllowedNodeTypeModificationsMessage' => [ 'base' => '<p>The input parameters for the <code>ListAllowedNodeTypeModifications</code> operation.</p>', 'refs' => [], ], 'ListTagsForResourceMessage' => [ 'base' => '<p>The input parameters for the <code>ListTagsForResource</code> operation.</p>', 'refs' => [], ], 'ModifyCacheClusterMessage' => [ 'base' => '<p>Represents the input of a <code>ModifyCacheCluster</code> operation.</p>', 'refs' => [], ], 'ModifyCacheClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyCacheParameterGroupMessage' => [ 'base' => '<p>Represents the input of a <code>ModifyCacheParameterGroup</code> operation.</p>', 'refs' => [], ], 'ModifyCacheSubnetGroupMessage' => [ 'base' => '<p>Represents the input of a <code>ModifyCacheSubnetGroup</code> operation.</p>', 'refs' => [], ], 'ModifyCacheSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyReplicationGroupMessage' => [ 'base' => '<p>Represents the input of a <code>ModifyReplicationGroups</code> operation.</p>', 'refs' => [], ], 'ModifyReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'NodeGroup' => [ 'base' => '<p>Represents a collection of cache nodes in a replication group. One node in the node group is the read/write primary node. All the other nodes are read-only Replica nodes.</p>', 'refs' => [ 'NodeGroupList$member' => NULL, ], ], 'NodeGroupConfiguration' => [ 'base' => '<p>node group (shard) configuration options. Each node group (shard) configuration has the following: <code>Slots</code>, <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>.</p>', 'refs' => [ 'NodeGroupConfigurationList$member' => NULL, 'NodeSnapshot$NodeGroupConfiguration' => '<p>The configuration for the source node group (shard).</p>', ], ], 'NodeGroupConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationGroupMessage$NodeGroupConfiguration' => '<p>A list of node group (shard) configuration options. Each node group (shard) configuration has the following: Slots, PrimaryAvailabilityZone, ReplicaAvailabilityZones, ReplicaCount.</p> <p>If you\'re creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can use this parameter to individually configure each node group (shard), or you can omit this parameter.</p>', ], ], 'NodeGroupList' => [ 'base' => NULL, 'refs' => [ 'ReplicationGroup$NodeGroups' => '<p>A single element list with information about the nodes in the replication group.</p>', ], ], 'NodeGroupMember' => [ 'base' => '<p>Represents a single node within a node group (shard).</p>', 'refs' => [ 'NodeGroupMemberList$member' => NULL, ], ], 'NodeGroupMemberList' => [ 'base' => NULL, 'refs' => [ 'NodeGroup$NodeGroupMembers' => '<p>A list containing information about individual nodes within the node group (shard).</p>', ], ], 'NodeGroupNotFoundFault' => [ 'base' => '<p>The node group specified by the <code>NodeGroupId</code> parameter could not be found. Please verify that the node group exists and that you spelled the <code>NodeGroupId</code> value correctly.</p>', 'refs' => [], ], 'NodeGroupsPerReplicationGroupQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the maximum of 15 node groups (shards) in a single replication group.</p>', 'refs' => [], ], 'NodeQuotaForClusterExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the allowed number of cache nodes in a single cache cluster.</p>', 'refs' => [], ], 'NodeQuotaForCustomerExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the allowed number of cache nodes per customer.</p>', 'refs' => [], ], 'NodeSnapshot' => [ 'base' => '<p>Represents an individual cache node in a snapshot of a cache cluster.</p>', 'refs' => [ 'NodeSnapshotList$member' => NULL, ], ], 'NodeSnapshotList' => [ 'base' => NULL, 'refs' => [ 'Snapshot$NodeSnapshots' => '<p>A list of the cache nodes in the source cache cluster.</p>', ], ], 'NodeTypeList' => [ 'base' => NULL, 'refs' => [ 'AllowedNodeTypeModificationsMessage$ScaleUpModifications' => '<p>A string list, each element of which specifies a cache node type which you can use to scale your cache cluster or replication group.</p> <p>When scaling up a Redis cluster or replication group using <code>ModifyCacheCluster</code> or <code>ModifyReplicationGroup</code>, use a value from this list for the <code>CacheNodeType</code> parameter.</p>', ], ], 'NotificationConfiguration' => [ 'base' => '<p>Describes a notification topic and its status. Notification topics are used for publishing ElastiCache events to subscribers using Amazon Simple Notification Service (SNS).</p>', 'refs' => [ 'CacheCluster$NotificationConfiguration' => NULL, ], ], 'Parameter' => [ 'base' => '<p>Describes an individual setting that controls some aspect of ElastiCache behavior.</p>', 'refs' => [ 'ParametersList$member' => NULL, ], ], 'ParameterNameValue' => [ 'base' => '<p>Describes a name-value pair that is used to update the value of a parameter.</p>', 'refs' => [ 'ParameterNameValueList$member' => NULL, ], ], 'ParameterNameValueList' => [ 'base' => NULL, 'refs' => [ 'ModifyCacheParameterGroupMessage$ParameterNameValues' => '<p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.</p>', 'ResetCacheParameterGroupMessage$ParameterNameValues' => '<p>An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is <code>false</code>, you must specify the name of at least one parameter to reset.</p>', ], ], 'ParametersList' => [ 'base' => NULL, 'refs' => [ 'CacheParameterGroupDetails$Parameters' => '<p>A list of <a>Parameter</a> instances.</p>', 'EngineDefaults$Parameters' => '<p>Contains a list of engine default parameters.</p>', ], ], 'PendingAutomaticFailoverStatus' => [ 'base' => NULL, 'refs' => [ 'ReplicationGroupPendingModifiedValues$AutomaticFailoverStatus' => '<p>Indicates the status of Multi-AZ for this Redis replication group.</p> <note> <p>ElastiCache Multi-AZ replication groups are not supported on:</p> <ul> <li> <p>Redis versions earlier than 2.8.6.</p> </li> <li> <p>Redis (cluster mode disabled):T1 and T2 cache node types.</p> <p>Redis (cluster mode enabled): T1 node types.</p> </li> </ul> </note>', ], ], 'PendingModifiedValues' => [ 'base' => '<p>A group of settings that are applied to the cache cluster in the future, or that are currently being applied.</p>', 'refs' => [ 'CacheCluster$PendingModifiedValues' => NULL, ], ], 'PreferredAvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'CreateCacheClusterMessage$PreferredAvailabilityZones' => '<p>A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not important.</p> <p>This option is only supported on Memcached.</p> <note> <p>If you are creating your cache cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.</p> <p>The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.</p> </note> <p>If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or repeat the Availability Zone multiple times in the list.</p> <p>Default: System chosen Availability Zones.</p>', 'ModifyCacheClusterMessage$NewAvailabilityZones' => '<p>The list of Availability Zones where the new Memcached cache nodes are created.</p> <p>This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of the number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number of Availability Zones supplied in this list must match the cache nodes being added in this request.</p> <p>This option is only supported on Memcached clusters.</p> <p>Scenarios:</p> <ul> <li> <p> <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify <code>NumCacheNodes=5</code> (3 + 2) and optionally specify two Availability Zones for the two new nodes.</p> </li> <li> <p> <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an Availability Zone for the new node.</p> </li> <li> <p> <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to cancel all pending operations.</p> </li> </ul> <p>The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current nodes.</p> <p>If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing Memcached nodes to different Availability Zones, see the <b>Availability Zone Considerations</b> section of <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheNode.Memcached.html">Cache Node Considerations for Memcached</a>.</p> <p> <b>Impact of new add/remove requests upon pending requests</b> </p> <ul> <li> <p>Scenario-1</p> <ul> <li> <p>Pending Action: Delete</p> </li> <li> <p>New Request: Delete</p> </li> <li> <p>Result: The new delete, pending or immediate, replaces the pending delete.</p> </li> </ul> </li> <li> <p>Scenario-2</p> <ul> <li> <p>Pending Action: Delete</p> </li> <li> <p>New Request: Create</p> </li> <li> <p>Result: The new create, pending or immediate, replaces the pending delete.</p> </li> </ul> </li> <li> <p>Scenario-3</p> <ul> <li> <p>Pending Action: Create</p> </li> <li> <p>New Request: Delete</p> </li> <li> <p>Result: The new delete, pending or immediate, replaces the pending create.</p> </li> </ul> </li> <li> <p>Scenario-4</p> <ul> <li> <p>Pending Action: Create</p> </li> <li> <p>New Request: Create</p> </li> <li> <p>Result: The new create is added to the pending create.</p> <important> <p> <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are performed immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are pending.</p> </important> </li> </ul> </li> </ul>', ], ], 'PurchaseReservedCacheNodesOfferingMessage' => [ 'base' => '<p>Represents the input of a <code>PurchaseReservedCacheNodesOffering</code> operation.</p>', 'refs' => [], ], 'PurchaseReservedCacheNodesOfferingResult' => [ 'base' => NULL, 'refs' => [], ], 'RebootCacheClusterMessage' => [ 'base' => '<p>Represents the input of a <code>RebootCacheCluster</code> operation.</p>', 'refs' => [], ], 'RebootCacheClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'RecurringCharge' => [ 'base' => '<p>Contains the specific price and frequency of a recurring charges for a reserved cache node, or for a reserved cache node offering.</p>', 'refs' => [ 'RecurringChargeList$member' => NULL, ], ], 'RecurringChargeList' => [ 'base' => NULL, 'refs' => [ 'ReservedCacheNode$RecurringCharges' => '<p>The recurring price charged to run this reserved cache node.</p>', 'ReservedCacheNodesOffering$RecurringCharges' => '<p>The recurring price charged to run this reserved cache node.</p>', ], ], 'RemoveTagsFromResourceMessage' => [ 'base' => '<p>Represents the input of a <code>RemoveTagsFromResource</code> operation.</p>', 'refs' => [], ], 'ReplicationGroup' => [ 'base' => '<p>Contains all of the attributes of a specific Redis replication group.</p>', 'refs' => [ 'CreateReplicationGroupResult$ReplicationGroup' => NULL, 'DeleteReplicationGroupResult$ReplicationGroup' => NULL, 'ModifyReplicationGroupResult$ReplicationGroup' => NULL, 'ReplicationGroupList$member' => NULL, 'TestFailoverResult$ReplicationGroup' => NULL, ], ], 'ReplicationGroupAlreadyExistsFault' => [ 'base' => '<p>The specified replication group already exists.</p>', 'refs' => [], ], 'ReplicationGroupList' => [ 'base' => NULL, 'refs' => [ 'ReplicationGroupMessage$ReplicationGroups' => '<p>A list of replication groups. Each item in the list contains detailed information about one replication group.</p>', ], ], 'ReplicationGroupMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeReplicationGroups</code> operation.</p>', 'refs' => [], ], 'ReplicationGroupNotFoundFault' => [ 'base' => '<p>The specified replication group does not exist.</p>', 'refs' => [], ], 'ReplicationGroupPendingModifiedValues' => [ 'base' => '<p>The settings to be applied to the Redis replication group, either immediately or during the next maintenance window.</p>', 'refs' => [ 'ReplicationGroup$PendingModifiedValues' => '<p>A group of settings to be applied to the replication group, either immediately or during the next maintenance window.</p>', ], ], 'ReservedCacheNode' => [ 'base' => '<p>Represents the output of a <code>PurchaseReservedCacheNodesOffering</code> operation.</p>', 'refs' => [ 'PurchaseReservedCacheNodesOfferingResult$ReservedCacheNode' => NULL, 'ReservedCacheNodeList$member' => NULL, ], ], 'ReservedCacheNodeAlreadyExistsFault' => [ 'base' => '<p>You already have a reservation with the given identifier.</p>', 'refs' => [], ], 'ReservedCacheNodeList' => [ 'base' => NULL, 'refs' => [ 'ReservedCacheNodeMessage$ReservedCacheNodes' => '<p>A list of reserved cache nodes. Each element in the list contains detailed information about one node.</p>', ], ], 'ReservedCacheNodeMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeReservedCacheNodes</code> operation.</p>', 'refs' => [], ], 'ReservedCacheNodeNotFoundFault' => [ 'base' => '<p>The requested reserved cache node was not found.</p>', 'refs' => [], ], 'ReservedCacheNodeQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the user\'s cache node quota.</p>', 'refs' => [], ], 'ReservedCacheNodesOffering' => [ 'base' => '<p>Describes all of the attributes of a reserved cache node offering.</p>', 'refs' => [ 'ReservedCacheNodesOfferingList$member' => NULL, ], ], 'ReservedCacheNodesOfferingList' => [ 'base' => NULL, 'refs' => [ 'ReservedCacheNodesOfferingMessage$ReservedCacheNodesOfferings' => '<p>A list of reserved cache node offerings. Each element in the list contains detailed information about one offering.</p>', ], ], 'ReservedCacheNodesOfferingMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeReservedCacheNodesOfferings</code> operation.</p>', 'refs' => [], ], 'ReservedCacheNodesOfferingNotFoundFault' => [ 'base' => '<p>The requested cache node offering does not exist.</p>', 'refs' => [], ], 'ResetCacheParameterGroupMessage' => [ 'base' => '<p>Represents the input of a <code>ResetCacheParameterGroup</code> operation.</p>', 'refs' => [], ], 'RevokeCacheSecurityGroupIngressMessage' => [ 'base' => '<p>Represents the input of a <code>RevokeCacheSecurityGroupIngress</code> operation.</p>', 'refs' => [], ], 'RevokeCacheSecurityGroupIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'SecurityGroupIdsList' => [ 'base' => NULL, 'refs' => [ 'CreateCacheClusterMessage$SecurityGroupIds' => '<p>One or more VPC security groups associated with the cache cluster.</p> <p>Use this parameter only when you are creating a cache cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p>', 'CreateReplicationGroupMessage$SecurityGroupIds' => '<p>One or more Amazon VPC security groups associated with this replication group.</p> <p>Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).</p>', 'ModifyCacheClusterMessage$SecurityGroupIds' => '<p>Specifies the VPC Security Groups associated with the cache cluster.</p> <p>This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon VPC).</p>', 'ModifyReplicationGroupMessage$SecurityGroupIds' => '<p>Specifies the VPC Security Groups associated with the cache clusters in the replication group.</p> <p>This parameter can be used only with replication group containing cache clusters running in an Amazon Virtual Private Cloud (Amazon VPC).</p>', ], ], 'SecurityGroupMembership' => [ 'base' => '<p>Represents a single cache security group and its status.</p>', 'refs' => [ 'SecurityGroupMembershipList$member' => NULL, ], ], 'SecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$SecurityGroups' => '<p>A list of VPC Security Groups associated with the cache cluster.</p>', ], ], 'Snapshot' => [ 'base' => '<p>Represents a copy of an entire Redis cache cluster as of the time when the snapshot was taken.</p>', 'refs' => [ 'CopySnapshotResult$Snapshot' => NULL, 'CreateSnapshotResult$Snapshot' => NULL, 'DeleteSnapshotResult$Snapshot' => NULL, 'SnapshotList$member' => NULL, ], ], 'SnapshotAlreadyExistsFault' => [ 'base' => '<p>You already have a snapshot with the given name.</p>', 'refs' => [], ], 'SnapshotArnsList' => [ 'base' => NULL, 'refs' => [ 'CreateCacheClusterMessage$SnapshotArns' => '<p>A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note> <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>', 'CreateReplicationGroupMessage$SnapshotArns' => '<p>A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note> <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>', ], ], 'SnapshotFeatureNotSupportedFault' => [ 'base' => '<p>You attempted one of the following operations:</p> <ul> <li> <p>Creating a snapshot of a Redis cache cluster running on a <code>cache.t1.micro</code> cache node.</p> </li> <li> <p>Creating a snapshot of a cache cluster that is running Memcached rather than Redis.</p> </li> </ul> <p>Neither of these are supported by ElastiCache.</p>', 'refs' => [], ], 'SnapshotList' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotsListMessage$Snapshots' => '<p>A list of snapshots. Each item in the list contains detailed information about one snapshot.</p>', ], ], 'SnapshotNotFoundFault' => [ 'base' => '<p>The requested snapshot name does not refer to an existing snapshot.</p>', 'refs' => [], ], 'SnapshotQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the maximum number of snapshots.</p>', 'refs' => [], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeEventsMessage$SourceType' => '<p>The event source to retrieve events for. If no value is specified, all events are returned.</p>', 'Event$SourceType' => '<p>Specifies the origin of this event - a cache cluster, a parameter group, a security group, etc.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceMessage$ResourceName' => '<p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'AuthorizeCacheSecurityGroupIngressMessage$CacheSecurityGroupName' => '<p>The cache security group that allows network ingress.</p>', 'AuthorizeCacheSecurityGroupIngressMessage$EC2SecurityGroupName' => '<p>The Amazon EC2 security group to be authorized for ingress to the cache security group.</p>', 'AuthorizeCacheSecurityGroupIngressMessage$EC2SecurityGroupOwnerId' => '<p>The AWS account number of the Amazon EC2 security group owner. Note that this is not the same thing as an AWS access key ID - you must provide a valid AWS account number for this parameter.</p>', 'AvailabilityZone$Name' => '<p>The name of the Availability Zone.</p>', 'AvailabilityZonesList$member' => NULL, 'CacheCluster$CacheClusterId' => '<p>The user-supplied identifier of the cache cluster. This identifier is a unique key that identifies a cache cluster.</p>', 'CacheCluster$ClientDownloadLandingPage' => '<p>The URL of the web page where you can download the latest ElastiCache client library.</p>', 'CacheCluster$CacheNodeType' => '<p>The name of the compute and memory capacity node type for the cache cluster.</p> <p>Valid node types are as follows:</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>, <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>, <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.t1.micro</code>, <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized: <code>cache.c1.xlarge</code> </p> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Notes:</b> </p> <ul> <li> <p>All T2 instances are created in an Amazon Virtual Private Cloud (Amazon VPC).</p> </li> <li> <p>Redis backup/restore is not supported for Redis (cluster mode disabled) T1 and T2 instances. Backup/restore is supported on Redis (cluster mode enabled) T2 instances.</p> </li> <li> <p>Redis Append-only files (AOF) functionality is not supported for T1 or T2 instances.</p> </li> </ul> <p>For a complete listing of node types and specifications, see <a href="http://aws.amazon.com/elasticache/details">Amazon ElastiCache Product Features and Details</a> and either <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#ParameterGroups.Memcached.NodeSpecific">Cache Node Type-Specific Parameters for Memcached</a> or <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#ParameterGroups.Redis.NodeSpecific">Cache Node Type-Specific Parameters for Redis</a>.</p>', 'CacheCluster$Engine' => '<p>The name of the cache engine (<code>memcached</code> or <code>redis</code>) to be used for this cache cluster.</p>', 'CacheCluster$EngineVersion' => '<p>The version of the cache engine that is used in this cache cluster.</p>', 'CacheCluster$CacheClusterStatus' => '<p>The current state of this cache cluster, one of the following values: <code>available</code>, <code>creating</code>, <code>deleted</code>, <code>deleting</code>, <code>incompatible-network</code>, <code>modifying</code>, <code>rebooting cache cluster nodes</code>, <code>restore-failed</code>, or <code>snapshotting</code>.</p>', 'CacheCluster$PreferredAvailabilityZone' => '<p>The name of the Availability Zone in which the cache cluster is located or "Multiple" if the cache nodes are located in different Availability Zones.</p>', 'CacheCluster$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p> <p>Valid values for <code>ddd</code> are:</p> <ul> <li> <p> <code>sun</code> </p> </li> <li> <p> <code>mon</code> </p> </li> <li> <p> <code>tue</code> </p> </li> <li> <p> <code>wed</code> </p> </li> <li> <p> <code>thu</code> </p> </li> <li> <p> <code>fri</code> </p> </li> <li> <p> <code>sat</code> </p> </li> </ul> <p>Example: <code>sun:23:00-mon:01:30</code> </p>', 'CacheCluster$CacheSubnetGroupName' => '<p>The name of the cache subnet group associated with the cache cluster.</p>', 'CacheCluster$ReplicationGroupId' => '<p>The replication group to which this cache cluster belongs. If this field is empty, the cache cluster is not associated with any replication group.</p>', 'CacheCluster$SnapshotWindow' => '<p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cache cluster.</p> <p>Example: <code>05:00-09:00</code> </p>', 'CacheClusterMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'CacheEngineVersion$Engine' => '<p>The name of the cache engine.</p>', 'CacheEngineVersion$EngineVersion' => '<p>The version number of the cache engine.</p>', 'CacheEngineVersion$CacheParameterGroupFamily' => '<p>The name of the cache parameter group family associated with this cache engine.</p> <p>Valid values are: <code>memcached1.4</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> </p>', 'CacheEngineVersion$CacheEngineDescription' => '<p>The description of the cache engine.</p>', 'CacheEngineVersion$CacheEngineVersionDescription' => '<p>The description of the cache engine version.</p>', 'CacheEngineVersionMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'CacheNode$CacheNodeId' => '<p>The cache node identifier. A node ID is a numeric identifier (0001, 0002, etc.). The combination of cluster ID and node ID uniquely identifies every cache node used in a customer\'s AWS account.</p>', 'CacheNode$CacheNodeStatus' => '<p>The current state of this cache node.</p>', 'CacheNode$ParameterGroupStatus' => '<p>The status of the parameter group applied to this cache node.</p>', 'CacheNode$SourceCacheNodeId' => '<p>The ID of the primary node to which this read replica node is synchronized. If this field is empty, this node is not associated with a primary cache cluster.</p>', 'CacheNode$CustomerAvailabilityZone' => '<p>The Availability Zone where this node was created and now resides.</p>', 'CacheNodeIdsList$member' => NULL, 'CacheNodeTypeSpecificParameter$ParameterName' => '<p>The name of the parameter.</p>', 'CacheNodeTypeSpecificParameter$Description' => '<p>A description of the parameter.</p>', 'CacheNodeTypeSpecificParameter$Source' => '<p>The source of the parameter value.</p>', 'CacheNodeTypeSpecificParameter$DataType' => '<p>The valid data type for the parameter.</p>', 'CacheNodeTypeSpecificParameter$AllowedValues' => '<p>The valid range of values for the parameter.</p>', 'CacheNodeTypeSpecificParameter$MinimumEngineVersion' => '<p>The earliest cache engine version to which the parameter can apply.</p>', 'CacheNodeTypeSpecificValue$CacheNodeType' => '<p>The cache node type for which this value applies.</p>', 'CacheNodeTypeSpecificValue$Value' => '<p>The value for the cache node type.</p>', 'CacheParameterGroup$CacheParameterGroupName' => '<p>The name of the cache parameter group.</p>', 'CacheParameterGroup$CacheParameterGroupFamily' => '<p>The name of the cache parameter group family that this cache parameter group is compatible with.</p> <p>Valid values are: <code>memcached1.4</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> </p>', 'CacheParameterGroup$Description' => '<p>The description for this cache parameter group.</p>', 'CacheParameterGroupDetails$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'CacheParameterGroupNameMessage$CacheParameterGroupName' => '<p>The name of the cache parameter group.</p>', 'CacheParameterGroupStatus$CacheParameterGroupName' => '<p>The name of the cache parameter group.</p>', 'CacheParameterGroupStatus$ParameterApplyStatus' => '<p>The status of parameter updates.</p>', 'CacheParameterGroupsMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'CacheSecurityGroup$OwnerId' => '<p>The AWS account ID of the cache security group owner.</p>', 'CacheSecurityGroup$CacheSecurityGroupName' => '<p>The name of the cache security group.</p>', 'CacheSecurityGroup$Description' => '<p>The description of the cache security group.</p>', 'CacheSecurityGroupMembership$CacheSecurityGroupName' => '<p>The name of the cache security group.</p>', 'CacheSecurityGroupMembership$Status' => '<p>The membership status in the cache security group. The status changes when a cache security group is modified, or when the cache security groups assigned to a cache cluster are modified.</p>', 'CacheSecurityGroupMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'CacheSecurityGroupNameList$member' => NULL, 'CacheSubnetGroup$CacheSubnetGroupName' => '<p>The name of the cache subnet group.</p>', 'CacheSubnetGroup$CacheSubnetGroupDescription' => '<p>The description of the cache subnet group.</p>', 'CacheSubnetGroup$VpcId' => '<p>The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group.</p>', 'CacheSubnetGroupMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'ClusterIdList$member' => NULL, 'CopySnapshotMessage$SourceSnapshotName' => '<p>The name of an existing snapshot from which to make a copy.</p>', 'CopySnapshotMessage$TargetSnapshotName' => '<p>A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name must be unique within its context - ElastiCache or an Amazon S3 bucket if exporting.</p>', 'CopySnapshotMessage$TargetBucket' => '<p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.</p> <p>When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions to this S3 bucket. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/Snapshots.Exporting.html#Snapshots.Exporting.GrantAccess">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the <i>Amazon ElastiCache User Guide</i>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/Snapshots.Exporting.html">Exporting a Snapshot</a> in the <i>Amazon ElastiCache User Guide</i>.</p>', 'CreateCacheClusterMessage$CacheClusterId' => '<p>The node group (shard) identifier. This parameter is stored as a lowercase string.</p> <p> <b>Constraints:</b> </p> <ul> <li> <p>A name must contain from 1 to 20 alphanumeric characters or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'CreateCacheClusterMessage$ReplicationGroupId' => '<important> <p>Due to current limitations on Redis (cluster mode disabled), this operation or parameter is not supported on Redis (cluster mode enabled) replication groups.</p> </important> <p>The ID of the replication group to which this cache cluster should belong. If this parameter is specified, the cache cluster is added to the specified replication group as a read replica; otherwise, the cache cluster is a standalone primary that is not part of any replication group.</p> <p>If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the cache cluster is created in Availability Zones that provide the best spread of read replicas across Availability Zones.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note>', 'CreateCacheClusterMessage$PreferredAvailabilityZone' => '<p>The EC2 Availability Zone in which the cache cluster is created.</p> <p>All nodes belonging to this Memcached cache cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.</p> <p>Default: System chosen Availability Zone.</p>', 'CreateCacheClusterMessage$CacheNodeType' => '<p>The compute and memory capacity of the nodes in the node group (shard).</p> <p>Valid node types are as follows:</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>, <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>, <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.t1.micro</code>, <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized: <code>cache.c1.xlarge</code> </p> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Notes:</b> </p> <ul> <li> <p>All T2 instances are created in an Amazon Virtual Private Cloud (Amazon VPC).</p> </li> <li> <p>Redis backup/restore is not supported for Redis (cluster mode disabled) T1 and T2 instances. Backup/restore is supported on Redis (cluster mode enabled) T2 instances.</p> </li> <li> <p>Redis Append-only files (AOF) functionality is not supported for T1 or T2 instances.</p> </li> </ul> <p>For a complete listing of node types and specifications, see <a href="http://aws.amazon.com/elasticache/details">Amazon ElastiCache Product Features and Details</a> and either <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#ParameterGroups.Memcached.NodeSpecific">Cache Node Type-Specific Parameters for Memcached</a> or <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#ParameterGroups.Redis.NodeSpecific">Cache Node Type-Specific Parameters for Redis</a>.</p>', 'CreateCacheClusterMessage$Engine' => '<p>The name of the cache engine to be used for this cache cluster.</p> <p>Valid values for this parameter are: <code>memcached</code> | <code>redis</code> </p>', 'CreateCacheClusterMessage$EngineVersion' => '<p>The version number of the cache engine to be used for this cache cluster. To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.</p> <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cache cluster or replication group and create it anew with the earlier engine version. </p>', 'CreateCacheClusterMessage$CacheParameterGroupName' => '<p>The name of the parameter group to associate with this cache cluster. If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has <code>cluster-enabled=\'yes\'</code> when creating a cluster.</p>', 'CreateCacheClusterMessage$CacheSubnetGroupName' => '<p>The name of the subnet group to be used for the cache cluster.</p> <p>Use this parameter only when you are creating a cache cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p> <important> <p>If you\'re going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/SubnetGroups.html">Subnets and Subnet Groups</a>.</p> </important>', 'CreateCacheClusterMessage$SnapshotName' => '<p>The name of a Redis snapshot from which to restore data into the new node group (shard). The snapshot status changes to <code>restoring</code> while the new node group (shard) is being created.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note>', 'CreateCacheClusterMessage$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cache cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for <code>ddd</code> are:</p> <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p> <p>Valid values for <code>ddd</code> are:</p> <ul> <li> <p> <code>sun</code> </p> </li> <li> <p> <code>mon</code> </p> </li> <li> <p> <code>tue</code> </p> </li> <li> <p> <code>wed</code> </p> </li> <li> <p> <code>thu</code> </p> </li> <li> <p> <code>fri</code> </p> </li> <li> <p> <code>sat</code> </p> </li> </ul> <p>Example: <code>sun:23:00-mon:01:30</code> </p>', 'CreateCacheClusterMessage$NotificationTopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note> <p>The Amazon SNS topic owner must be the same as the cache cluster owner.</p> </note>', 'CreateCacheClusterMessage$SnapshotWindow' => '<p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p> <p>Example: <code>05:00-09:00</code> </p> <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p> <p> <b>Note:</b> This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>', 'CreateCacheClusterMessage$AuthToken' => '<p> <b>Reserved parameter.</b> The password used to access a password protected server.</p> <p>Password constraints:</p> <ul> <li> <p>Must be only printable ASCII characters.</p> </li> <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li> <li> <p>Cannot contain any of the following characters: \'/\', \'"\', or "@". </p> </li> </ul> <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at Redis.</p>', 'CreateCacheParameterGroupMessage$CacheParameterGroupName' => '<p>A user-specified name for the cache parameter group.</p>', 'CreateCacheParameterGroupMessage$CacheParameterGroupFamily' => '<p>The name of the cache parameter group family that the cache parameter group can be used with.</p> <p>Valid values are: <code>memcached1.4</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> </p>', 'CreateCacheParameterGroupMessage$Description' => '<p>A user-specified description for the cache parameter group.</p>', 'CreateCacheSecurityGroupMessage$CacheSecurityGroupName' => '<p>A name for the cache security group. This value is stored as a lowercase string.</p> <p>Constraints: Must contain no more than 255 alphanumeric characters. Cannot be the word "Default".</p> <p>Example: <code>mysecuritygroup</code> </p>', 'CreateCacheSecurityGroupMessage$Description' => '<p>A description for the cache security group.</p>', 'CreateCacheSubnetGroupMessage$CacheSubnetGroupName' => '<p>A name for the cache subnet group. This value is stored as a lowercase string.</p> <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p> <p>Example: <code>mysubnetgroup</code> </p>', 'CreateCacheSubnetGroupMessage$CacheSubnetGroupDescription' => '<p>A description for the cache subnet group.</p>', 'CreateReplicationGroupMessage$ReplicationGroupId' => '<p>The replication group identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>A name must contain from 1 to 20 alphanumeric characters or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'CreateReplicationGroupMessage$ReplicationGroupDescription' => '<p>A user-created description for the replication group.</p>', 'CreateReplicationGroupMessage$PrimaryClusterId' => '<p>The identifier of the cache cluster that serves as the primary for this replication group. This cache cluster must already exist and have a status of <code>available</code>.</p> <p>This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or <code>ReplicasPerNodeGroup</code> is specified.</p>', 'CreateReplicationGroupMessage$CacheNodeType' => '<p>The compute and memory capacity of the nodes in the node group (shard).</p> <p>Valid node types are as follows:</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>, <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>, <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.t1.micro</code>, <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized: <code>cache.c1.xlarge</code> </p> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Notes:</b> </p> <ul> <li> <p>All T2 instances are created in an Amazon Virtual Private Cloud (Amazon VPC).</p> </li> <li> <p>Redis backup/restore is not supported for Redis (cluster mode disabled) T1 and T2 instances. Backup/restore is supported on Redis (cluster mode enabled) T2 instances.</p> </li> <li> <p>Redis Append-only files (AOF) functionality is not supported for T1 or T2 instances.</p> </li> </ul> <p>For a complete listing of node types and specifications, see <a href="http://aws.amazon.com/elasticache/details">Amazon ElastiCache Product Features and Details</a> and either <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#ParameterGroups.Memcached.NodeSpecific">Cache Node Type-Specific Parameters for Memcached</a> or <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#ParameterGroups.Redis.NodeSpecific">Cache Node Type-Specific Parameters for Redis</a>.</p>', 'CreateReplicationGroupMessage$Engine' => '<p>The name of the cache engine to be used for the cache clusters in this replication group.</p>', 'CreateReplicationGroupMessage$EngineVersion' => '<p>The version number of the cache engine to be used for the cache clusters in this replication group. To view the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p> <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cache cluster or replication group and create it anew with the earlier engine version. </p>', 'CreateReplicationGroupMessage$CacheParameterGroupName' => '<p>The name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used.</p> <p>If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name. </p> <ul> <li> <p>To create a Redis (cluster mode disabled) replication group, use <code>CacheParameterGroupName=default.redis3.2</code>.</p> </li> <li> <p>To create a Redis (cluster mode enabled) replication group, use <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.</p> </li> </ul>', 'CreateReplicationGroupMessage$CacheSubnetGroupName' => '<p>The name of the cache subnet group to be used for the replication group.</p> <important> <p>If you\'re going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/SubnetGroups.html">Subnets and Subnet Groups</a>.</p> </important>', 'CreateReplicationGroupMessage$SnapshotName' => '<p>The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to <code>restoring</code> while the new replication group is being created.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note>', 'CreateReplicationGroupMessage$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cache cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for <code>ddd</code> are:</p> <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p> <p>Valid values for <code>ddd</code> are:</p> <ul> <li> <p> <code>sun</code> </p> </li> <li> <p> <code>mon</code> </p> </li> <li> <p> <code>tue</code> </p> </li> <li> <p> <code>wed</code> </p> </li> <li> <p> <code>thu</code> </p> </li> <li> <p> <code>fri</code> </p> </li> <li> <p> <code>sat</code> </p> </li> </ul> <p>Example: <code>sun:23:00-mon:01:30</code> </p>', 'CreateReplicationGroupMessage$NotificationTopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note> <p>The Amazon SNS topic owner must be the same as the cache cluster owner.</p> </note>', 'CreateReplicationGroupMessage$SnapshotWindow' => '<p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p> <p>Example: <code>05:00-09:00</code> </p> <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note>', 'CreateReplicationGroupMessage$AuthToken' => '<p> <b>Reserved parameter.</b> The password used to access a password protected server.</p> <p>Password constraints:</p> <ul> <li> <p>Must be only printable ASCII characters.</p> </li> <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li> <li> <p>Cannot contain any of the following characters: \'/\', \'"\', or "@". </p> </li> </ul> <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at Redis.</p>', 'CreateSnapshotMessage$ReplicationGroupId' => '<p>The identifier of an existing replication group. The snapshot is created from this replication group.</p>', 'CreateSnapshotMessage$CacheClusterId' => '<p>The identifier of an existing cache cluster. The snapshot is created from this cache cluster.</p>', 'CreateSnapshotMessage$SnapshotName' => '<p>A name for the snapshot being created.</p>', 'DeleteCacheClusterMessage$CacheClusterId' => '<p>The cache cluster identifier for the cluster to be deleted. This parameter is not case sensitive.</p>', 'DeleteCacheClusterMessage$FinalSnapshotIdentifier' => '<p>The user-supplied name of a final cache cluster snapshot. This is the unique name that identifies the snapshot. ElastiCache creates the snapshot, and then deletes the cache cluster immediately afterward.</p>', 'DeleteCacheParameterGroupMessage$CacheParameterGroupName' => '<p>The name of the cache parameter group to delete.</p> <note> <p>The specified cache security group must not be associated with any cache clusters.</p> </note>', 'DeleteCacheSecurityGroupMessage$CacheSecurityGroupName' => '<p>The name of the cache security group to delete.</p> <note> <p>You cannot delete the default security group.</p> </note>', 'DeleteCacheSubnetGroupMessage$CacheSubnetGroupName' => '<p>The name of the cache subnet group to delete.</p> <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>', 'DeleteReplicationGroupMessage$ReplicationGroupId' => '<p>The identifier for the cluster to be deleted. This parameter is not case sensitive.</p>', 'DeleteReplicationGroupMessage$FinalSnapshotIdentifier' => '<p>The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster, rather than one of the replicas; this is to ensure that it captures the freshest data. After the final snapshot is taken, the replication group is immediately deleted.</p>', 'DeleteSnapshotMessage$SnapshotName' => '<p>The name of the snapshot to be deleted.</p>', 'DescribeCacheClustersMessage$CacheClusterId' => '<p>The user-supplied cluster identifier. If this parameter is specified, only information about that specific cache cluster is returned. This parameter isn\'t case sensitive.</p>', 'DescribeCacheClustersMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeCacheEngineVersionsMessage$Engine' => '<p>The cache engine to return. Valid values: <code>memcached</code> | <code>redis</code> </p>', 'DescribeCacheEngineVersionsMessage$EngineVersion' => '<p>The cache engine version to return.</p> <p>Example: <code>1.4.14</code> </p>', 'DescribeCacheEngineVersionsMessage$CacheParameterGroupFamily' => '<p>The name of a specific cache parameter group family to return details for.</p> <p>Valid values are: <code>memcached1.4</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> </p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul>', 'DescribeCacheEngineVersionsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeCacheParameterGroupsMessage$CacheParameterGroupName' => '<p>The name of a specific cache parameter group to return details for.</p>', 'DescribeCacheParameterGroupsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeCacheParametersMessage$CacheParameterGroupName' => '<p>The name of a specific cache parameter group to return details for.</p>', 'DescribeCacheParametersMessage$Source' => '<p>The parameter types to return.</p> <p>Valid values: <code>user</code> | <code>system</code> | <code>engine-default</code> </p>', 'DescribeCacheParametersMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeCacheSecurityGroupsMessage$CacheSecurityGroupName' => '<p>The name of the cache security group to return details for.</p>', 'DescribeCacheSecurityGroupsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeCacheSubnetGroupsMessage$CacheSubnetGroupName' => '<p>The name of the cache subnet group to return details for.</p>', 'DescribeCacheSubnetGroupsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEngineDefaultParametersMessage$CacheParameterGroupFamily' => '<p>The name of the cache parameter group family.</p> <p>Valid values are: <code>memcached1.4</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> </p>', 'DescribeEngineDefaultParametersMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEventsMessage$SourceIdentifier' => '<p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>', 'DescribeEventsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeReplicationGroupsMessage$ReplicationGroupId' => '<p>The identifier for the replication group to be described. This parameter is not case sensitive.</p> <p>If you do not specify this parameter, information about all replication groups is returned.</p>', 'DescribeReplicationGroupsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeReservedCacheNodesMessage$ReservedCacheNodeId' => '<p>The reserved cache node identifier filter value. Use this parameter to show only the reservation that matches the specified reservation ID.</p>', 'DescribeReservedCacheNodesMessage$ReservedCacheNodesOfferingId' => '<p>The offering identifier filter value. Use this parameter to show only purchased reservations matching the specified offering identifier.</p>', 'DescribeReservedCacheNodesMessage$CacheNodeType' => '<p>The cache node type filter value. Use this parameter to show only those reservations matching the specified cache node type.</p> <p>Valid node types are as follows:</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>, <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>, <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.t1.micro</code>, <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized: <code>cache.c1.xlarge</code> </p> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Notes:</b> </p> <ul> <li> <p>All T2 instances are created in an Amazon Virtual Private Cloud (Amazon VPC).</p> </li> <li> <p>Redis backup/restore is not supported for Redis (cluster mode disabled) T1 and T2 instances. Backup/restore is supported on Redis (cluster mode enabled) T2 instances.</p> </li> <li> <p>Redis Append-only files (AOF) functionality is not supported for T1 or T2 instances.</p> </li> </ul> <p>For a complete listing of node types and specifications, see <a href="http://aws.amazon.com/elasticache/details">Amazon ElastiCache Product Features and Details</a> and either <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#ParameterGroups.Memcached.NodeSpecific">Cache Node Type-Specific Parameters for Memcached</a> or <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#ParameterGroups.Redis.NodeSpecific">Cache Node Type-Specific Parameters for Redis</a>.</p>', 'DescribeReservedCacheNodesMessage$Duration' => '<p>The duration filter value, specified in years or seconds. Use this parameter to show only reservations for this duration.</p> <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>', 'DescribeReservedCacheNodesMessage$ProductDescription' => '<p>The product description filter value. Use this parameter to show only those reservations matching the specified product description.</p>', 'DescribeReservedCacheNodesMessage$OfferingType' => '<p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p> <p>Valid values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization"</code> </p>', 'DescribeReservedCacheNodesMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeReservedCacheNodesOfferingsMessage$ReservedCacheNodesOfferingId' => '<p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p> <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>', 'DescribeReservedCacheNodesOfferingsMessage$CacheNodeType' => '<p>The cache node type filter value. Use this parameter to show only the available offerings matching the specified cache node type.</p> <p>Valid node types are as follows:</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>, <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>, <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.t1.micro</code>, <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized: <code>cache.c1.xlarge</code> </p> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Notes:</b> </p> <ul> <li> <p>All T2 instances are created in an Amazon Virtual Private Cloud (Amazon VPC).</p> </li> <li> <p>Redis backup/restore is not supported for Redis (cluster mode disabled) T1 and T2 instances. Backup/restore is supported on Redis (cluster mode enabled) T2 instances.</p> </li> <li> <p>Redis Append-only files (AOF) functionality is not supported for T1 or T2 instances.</p> </li> </ul> <p>For a complete listing of node types and specifications, see <a href="http://aws.amazon.com/elasticache/details">Amazon ElastiCache Product Features and Details</a> and either <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#ParameterGroups.Memcached.NodeSpecific">Cache Node Type-Specific Parameters for Memcached</a> or <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#ParameterGroups.Redis.NodeSpecific">Cache Node Type-Specific Parameters for Redis</a>.</p>', 'DescribeReservedCacheNodesOfferingsMessage$Duration' => '<p>Duration filter value, specified in years or seconds. Use this parameter to show only reservations for a given duration.</p> <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>', 'DescribeReservedCacheNodesOfferingsMessage$ProductDescription' => '<p>The product description filter value. Use this parameter to show only the available offerings matching the specified product description.</p>', 'DescribeReservedCacheNodesOfferingsMessage$OfferingType' => '<p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p> <p>Valid Values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization"</code> </p>', 'DescribeReservedCacheNodesOfferingsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeSnapshotsListMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeSnapshotsMessage$ReplicationGroupId' => '<p>A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with that specific replication group are described.</p>', 'DescribeSnapshotsMessage$CacheClusterId' => '<p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cache cluster are described.</p>', 'DescribeSnapshotsMessage$SnapshotName' => '<p>A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.</p>', 'DescribeSnapshotsMessage$SnapshotSource' => '<p>If set to <code>system</code>, the output shows snapshots that were automatically created by ElastiCache. If set to <code>user</code> the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>', 'DescribeSnapshotsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'EC2SecurityGroup$Status' => '<p>The status of the Amazon EC2 security group.</p>', 'EC2SecurityGroup$EC2SecurityGroupName' => '<p>The name of the Amazon EC2 security group.</p>', 'EC2SecurityGroup$EC2SecurityGroupOwnerId' => '<p>The AWS account ID of the Amazon EC2 security group owner.</p>', 'Endpoint$Address' => '<p>The DNS hostname of the cache node.</p>', 'EngineDefaults$CacheParameterGroupFamily' => '<p>Specifies the name of the cache parameter group family to which the engine default parameters apply.</p> <p>Valid values are: <code>memcached1.4</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> </p>', 'EngineDefaults$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'Event$SourceIdentifier' => '<p>The identifier for the source of the event. For example, if the event occurred at the cache cluster level, the identifier would be the name of the cache cluster.</p>', 'Event$Message' => '<p>The text of the event.</p>', 'EventsMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'KeyList$member' => NULL, 'ListAllowedNodeTypeModificationsMessage$CacheClusterId' => '<p>The name of the cache cluster you want to scale up to a larger node instanced type. ElastiCache uses the cluster id to identify the current node type of this cluster and from that to create a list of node types you can scale up to.</p> <important> <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p> </important>', 'ListAllowedNodeTypeModificationsMessage$ReplicationGroupId' => '<p>The name of the replication group want to scale up to a larger node type. ElastiCache uses the replication group id to identify the current node type being used by this replication group, and from that to create a list of node types you can scale up to.</p> <important> <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p> </important>', 'ListTagsForResourceMessage$ResourceName' => '<p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'ModifyCacheClusterMessage$CacheClusterId' => '<p>The cache cluster identifier. This value is stored as a lowercase string.</p>', 'ModifyCacheClusterMessage$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p> <p>Valid values for <code>ddd</code> are:</p> <ul> <li> <p> <code>sun</code> </p> </li> <li> <p> <code>mon</code> </p> </li> <li> <p> <code>tue</code> </p> </li> <li> <p> <code>wed</code> </p> </li> <li> <p> <code>thu</code> </p> </li> <li> <p> <code>fri</code> </p> </li> <li> <p> <code>sat</code> </p> </li> </ul> <p>Example: <code>sun:23:00-mon:01:30</code> </p>', 'ModifyCacheClusterMessage$NotificationTopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note> <p>The Amazon SNS topic owner must be same as the cache cluster owner.</p> </note>', 'ModifyCacheClusterMessage$CacheParameterGroupName' => '<p>The name of the cache parameter group to apply to this cache cluster. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>', 'ModifyCacheClusterMessage$NotificationTopicStatus' => '<p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is <code>active</code>.</p> <p>Valid values: <code>active</code> | <code>inactive</code> </p>', 'ModifyCacheClusterMessage$EngineVersion' => '<p>The upgraded version of the cache engine to be run on the cache nodes.</p> <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cache cluster and create it anew with the earlier engine version. </p>', 'ModifyCacheClusterMessage$SnapshotWindow' => '<p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cache cluster. </p>', 'ModifyCacheClusterMessage$CacheNodeType' => '<p>A valid cache node type that you want to scale this cache cluster up to.</p>', 'ModifyCacheParameterGroupMessage$CacheParameterGroupName' => '<p>The name of the cache parameter group to modify.</p>', 'ModifyCacheSubnetGroupMessage$CacheSubnetGroupName' => '<p>The name for the cache subnet group. This value is stored as a lowercase string.</p> <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p> <p>Example: <code>mysubnetgroup</code> </p>', 'ModifyCacheSubnetGroupMessage$CacheSubnetGroupDescription' => '<p>A description of the cache subnet group.</p>', 'ModifyReplicationGroupMessage$ReplicationGroupId' => '<p>The identifier of the replication group to modify.</p>', 'ModifyReplicationGroupMessage$ReplicationGroupDescription' => '<p>A description for the replication group. Maximum length is 255 characters.</p>', 'ModifyReplicationGroupMessage$PrimaryClusterId' => '<p>For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the specified cluster in the specified replication group to the primary role. The nodes of all other clusters in the replication group are read replicas.</p>', 'ModifyReplicationGroupMessage$SnapshottingClusterId' => '<p>The cache cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be set for Redis (cluster mode enabled) replication groups.</p>', 'ModifyReplicationGroupMessage$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p> <p>Valid values for <code>ddd</code> are:</p> <ul> <li> <p> <code>sun</code> </p> </li> <li> <p> <code>mon</code> </p> </li> <li> <p> <code>tue</code> </p> </li> <li> <p> <code>wed</code> </p> </li> <li> <p> <code>thu</code> </p> </li> <li> <p> <code>fri</code> </p> </li> <li> <p> <code>sat</code> </p> </li> </ul> <p>Example: <code>sun:23:00-mon:01:30</code> </p>', 'ModifyReplicationGroupMessage$NotificationTopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note> <p>The Amazon SNS topic owner must be same as the replication group owner. </p> </note>', 'ModifyReplicationGroupMessage$CacheParameterGroupName' => '<p>The name of the cache parameter group to apply to all of the clusters in this replication group. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>', 'ModifyReplicationGroupMessage$NotificationTopicStatus' => '<p>The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the status is <code>active</code>.</p> <p>Valid values: <code>active</code> | <code>inactive</code> </p>', 'ModifyReplicationGroupMessage$EngineVersion' => '<p>The upgraded version of the cache engine to be run on the cache clusters in the replication group.</p> <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing replication group and create it anew with the earlier engine version. </p>', 'ModifyReplicationGroupMessage$SnapshotWindow' => '<p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group (shard) specified by <code>SnapshottingClusterId</code>.</p> <p>Example: <code>05:00-09:00</code> </p> <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>', 'ModifyReplicationGroupMessage$CacheNodeType' => '<p>A valid cache node type that you want to scale this replication group to.</p>', 'ModifyReplicationGroupMessage$NodeGroupId' => '<p>The name of the Node Group (called shard in the console).</p>', 'NodeGroup$NodeGroupId' => '<p>The identifier for the node group (shard). A Redis (cluster mode disabled) replication group contains only 1 node group; therefore, the node group ID is 0001. A Redis (cluster mode enabled) replication group contains 1 to 15 node groups numbered 0001 to 0015. </p>', 'NodeGroup$Status' => '<p>The current state of this replication group - <code>creating</code>, <code>available</code>, etc.</p>', 'NodeGroup$Slots' => '<p>The keyspace for this node group (shard).</p>', 'NodeGroupConfiguration$Slots' => '<p>A string that specifies the keyspace for a particular node group. Keyspaces range from 0 to 16,383. The string is in the format <code>startkey-endkey</code>.</p> <p>Example: <code>"0-3999"</code> </p>', 'NodeGroupConfiguration$PrimaryAvailabilityZone' => '<p>The Availability Zone where the primary node of this node group (shard) is launched.</p>', 'NodeGroupMember$CacheClusterId' => '<p>The ID of the cache cluster to which the node belongs.</p>', 'NodeGroupMember$CacheNodeId' => '<p>The ID of the node within its cache cluster. A node ID is a numeric identifier (0001, 0002, etc.).</p>', 'NodeGroupMember$PreferredAvailabilityZone' => '<p>The name of the Availability Zone in which the node is located.</p>', 'NodeGroupMember$CurrentRole' => '<p>The role that is currently assigned to the node - <code>primary</code> or <code>replica</code>.</p>', 'NodeSnapshot$CacheClusterId' => '<p>A unique identifier for the source cache cluster.</p>', 'NodeSnapshot$NodeGroupId' => '<p>A unique identifier for the source node group (shard).</p>', 'NodeSnapshot$CacheNodeId' => '<p>The cache node identifier for the node in the source cache cluster.</p>', 'NodeSnapshot$CacheSize' => '<p>The size of the cache on the source cache node.</p>', 'NodeTypeList$member' => NULL, 'NotificationConfiguration$TopicArn' => '<p>The Amazon Resource Name (ARN) that identifies the topic.</p>', 'NotificationConfiguration$TopicStatus' => '<p>The current state of the topic.</p>', 'Parameter$ParameterName' => '<p>The name of the parameter.</p>', 'Parameter$ParameterValue' => '<p>The value of the parameter.</p>', 'Parameter$Description' => '<p>A description of the parameter.</p>', 'Parameter$Source' => '<p>The source of the parameter.</p>', 'Parameter$DataType' => '<p>The valid data type for the parameter.</p>', 'Parameter$AllowedValues' => '<p>The valid range of values for the parameter.</p>', 'Parameter$MinimumEngineVersion' => '<p>The earliest cache engine version to which the parameter can apply.</p>', 'ParameterNameValue$ParameterName' => '<p>The name of the parameter.</p>', 'ParameterNameValue$ParameterValue' => '<p>The value of the parameter.</p>', 'PendingModifiedValues$EngineVersion' => '<p>The new cache engine version that the cache cluster runs.</p>', 'PendingModifiedValues$CacheNodeType' => '<p>The cache node type that this cache cluster or replication group is scaled to.</p>', 'PreferredAvailabilityZoneList$member' => NULL, 'PurchaseReservedCacheNodesOfferingMessage$ReservedCacheNodesOfferingId' => '<p>The ID of the reserved cache node offering to purchase.</p> <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>', 'PurchaseReservedCacheNodesOfferingMessage$ReservedCacheNodeId' => '<p>A customer-specified identifier to track this reservation.</p> <note> <p>The Reserved Cache Node ID is an unique customer-specified identifier to track this reservation. If this parameter is not specified, ElastiCache automatically generates an identifier for the reservation.</p> </note> <p>Example: myreservationID</p>', 'RebootCacheClusterMessage$CacheClusterId' => '<p>The cache cluster identifier. This parameter is stored as a lowercase string.</p>', 'RecurringCharge$RecurringChargeFrequency' => '<p>The frequency of the recurring charge.</p>', 'RemoveTagsFromResourceMessage$ResourceName' => '<p>The Amazon Resource Name (ARN) of the resource from which you want the tags removed, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'ReplicationGroup$ReplicationGroupId' => '<p>The identifier for the replication group.</p>', 'ReplicationGroup$Description' => '<p>The description of the replication group.</p>', 'ReplicationGroup$Status' => '<p>The current state of this replication group - <code>creating</code>, <code>available</code>, <code>modifying</code>, <code>deleting</code>, <code>create-failed</code>, <code>snapshotting</code>.</p>', 'ReplicationGroup$SnapshottingClusterId' => '<p>The cache cluster ID that is used as the daily snapshot source for the replication group.</p>', 'ReplicationGroup$SnapshotWindow' => '<p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p> <p>Example: <code>05:00-09:00</code> </p> <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p> <p> <b>Note:</b> This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>', 'ReplicationGroup$CacheNodeType' => '<p>The name of the compute and memory capacity node type for each node in the replication group.</p>', 'ReplicationGroupMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'ReplicationGroupPendingModifiedValues$PrimaryClusterId' => '<p>The primary cluster ID that is applied immediately (if <code>--apply-immediately</code> was specified), or during the next maintenance window.</p>', 'ReservedCacheNode$ReservedCacheNodeId' => '<p>The unique identifier for the reservation.</p>', 'ReservedCacheNode$ReservedCacheNodesOfferingId' => '<p>The offering identifier.</p>', 'ReservedCacheNode$CacheNodeType' => '<p>The cache node type for the reserved cache nodes.</p> <p>Valid node types are as follows:</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>, <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>, <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.t1.micro</code>, <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized: <code>cache.c1.xlarge</code> </p> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Notes:</b> </p> <ul> <li> <p>All T2 instances are created in an Amazon Virtual Private Cloud (Amazon VPC).</p> </li> <li> <p>Redis backup/restore is not supported for Redis (cluster mode disabled) T1 and T2 instances. Backup/restore is supported on Redis (cluster mode enabled) T2 instances.</p> </li> <li> <p>Redis Append-only files (AOF) functionality is not supported for T1 or T2 instances.</p> </li> </ul> <p>For a complete listing of node types and specifications, see <a href="http://aws.amazon.com/elasticache/details">Amazon ElastiCache Product Features and Details</a> and either <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#ParameterGroups.Memcached.NodeSpecific">Cache Node Type-Specific Parameters for Memcached</a> or <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#ParameterGroups.Redis.NodeSpecific">Cache Node Type-Specific Parameters for Redis</a>.</p>', 'ReservedCacheNode$ProductDescription' => '<p>The description of the reserved cache node.</p>', 'ReservedCacheNode$OfferingType' => '<p>The offering type of this reserved cache node.</p>', 'ReservedCacheNode$State' => '<p>The state of the reserved cache node.</p>', 'ReservedCacheNodeMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'ReservedCacheNodesOffering$ReservedCacheNodesOfferingId' => '<p>A unique identifier for the reserved cache node offering.</p>', 'ReservedCacheNodesOffering$CacheNodeType' => '<p>The cache node type for the reserved cache node.</p> <p>Valid node types are as follows:</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>, <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>, <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.t1.micro</code>, <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized: <code>cache.c1.xlarge</code> </p> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Notes:</b> </p> <ul> <li> <p>All T2 instances are created in an Amazon Virtual Private Cloud (Amazon VPC).</p> </li> <li> <p>Redis backup/restore is not supported for Redis (cluster mode disabled) T1 and T2 instances. Backup/restore is supported on Redis (cluster mode enabled) T2 instances.</p> </li> <li> <p>Redis Append-only files (AOF) functionality is not supported for T1 or T2 instances.</p> </li> </ul> <p>For a complete listing of node types and specifications, see <a href="http://aws.amazon.com/elasticache/details">Amazon ElastiCache Product Features and Details</a> and either <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#ParameterGroups.Memcached.NodeSpecific">Cache Node Type-Specific Parameters for Memcached</a> or <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#ParameterGroups.Redis.NodeSpecific">Cache Node Type-Specific Parameters for Redis</a>.</p>', 'ReservedCacheNodesOffering$ProductDescription' => '<p>The cache engine used by the offering.</p>', 'ReservedCacheNodesOffering$OfferingType' => '<p>The offering type.</p>', 'ReservedCacheNodesOfferingMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'ResetCacheParameterGroupMessage$CacheParameterGroupName' => '<p>The name of the cache parameter group to reset.</p>', 'RevokeCacheSecurityGroupIngressMessage$CacheSecurityGroupName' => '<p>The name of the cache security group to revoke ingress from.</p>', 'RevokeCacheSecurityGroupIngressMessage$EC2SecurityGroupName' => '<p>The name of the Amazon EC2 security group to revoke access from.</p>', 'RevokeCacheSecurityGroupIngressMessage$EC2SecurityGroupOwnerId' => '<p>The AWS account number of the Amazon EC2 security group owner. Note that this is not the same thing as an AWS access key ID - you must provide a valid AWS account number for this parameter.</p>', 'SecurityGroupIdsList$member' => NULL, 'SecurityGroupMembership$SecurityGroupId' => '<p>The identifier of the cache security group.</p>', 'SecurityGroupMembership$Status' => '<p>The status of the cache security group membership. The status changes whenever a cache security group is modified, or when the cache security groups assigned to a cache cluster are modified.</p>', 'Snapshot$SnapshotName' => '<p>The name of a snapshot. For an automatic snapshot, the name is system-generated. For a manual snapshot, this is the user-provided name.</p>', 'Snapshot$ReplicationGroupId' => '<p>The unique identifier of the source replication group.</p>', 'Snapshot$ReplicationGroupDescription' => '<p>A description of the source replication group.</p>', 'Snapshot$CacheClusterId' => '<p>The user-supplied identifier of the source cache cluster.</p>', 'Snapshot$SnapshotStatus' => '<p>The status of the snapshot. Valid values: <code>creating</code> | <code>available</code> | <code>restoring</code> | <code>copying</code> | <code>deleting</code>.</p>', 'Snapshot$SnapshotSource' => '<p>Indicates whether the snapshot is from an automatic backup (<code>automated</code>) or was created manually (<code>manual</code>).</p>', 'Snapshot$CacheNodeType' => '<p>The name of the compute and memory capacity node type for the source cache cluster.</p> <p>Valid node types are as follows:</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>, <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>, <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.t1.micro</code>, <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized: <code>cache.c1.xlarge</code> </p> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> <li> <p>Previous generation: <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Notes:</b> </p> <ul> <li> <p>All T2 instances are created in an Amazon Virtual Private Cloud (Amazon VPC).</p> </li> <li> <p>Redis backup/restore is not supported for Redis (cluster mode disabled) T1 and T2 instances. Backup/restore is supported on Redis (cluster mode enabled) T2 instances.</p> </li> <li> <p>Redis Append-only files (AOF) functionality is not supported for T1 or T2 instances.</p> </li> </ul> <p>For a complete listing of node types and specifications, see <a href="http://aws.amazon.com/elasticache/details">Amazon ElastiCache Product Features and Details</a> and either <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#ParameterGroups.Memcached.NodeSpecific">Cache Node Type-Specific Parameters for Memcached</a> or <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#ParameterGroups.Redis.NodeSpecific">Cache Node Type-Specific Parameters for Redis</a>.</p>', 'Snapshot$Engine' => '<p>The name of the cache engine (<code>memcached</code> or <code>redis</code>) used by the source cache cluster.</p>', 'Snapshot$EngineVersion' => '<p>The version of the cache engine version that is used by the source cache cluster.</p>', 'Snapshot$PreferredAvailabilityZone' => '<p>The name of the Availability Zone in which the source cache cluster is located.</p>', 'Snapshot$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p> <p>Valid values for <code>ddd</code> are:</p> <ul> <li> <p> <code>sun</code> </p> </li> <li> <p> <code>mon</code> </p> </li> <li> <p> <code>tue</code> </p> </li> <li> <p> <code>wed</code> </p> </li> <li> <p> <code>thu</code> </p> </li> <li> <p> <code>fri</code> </p> </li> <li> <p> <code>sat</code> </p> </li> </ul> <p>Example: <code>sun:23:00-mon:01:30</code> </p>', 'Snapshot$TopicArn' => '<p>The Amazon Resource Name (ARN) for the topic used by the source cache cluster for publishing notifications.</p>', 'Snapshot$CacheParameterGroupName' => '<p>The cache parameter group that is associated with the source cache cluster.</p>', 'Snapshot$CacheSubnetGroupName' => '<p>The name of the cache subnet group associated with the source cache cluster.</p>', 'Snapshot$VpcId' => '<p>The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group for the source cache cluster.</p>', 'Snapshot$SnapshotWindow' => '<p>The daily time range during which ElastiCache takes daily snapshots of the source cache cluster.</p>', 'SnapshotArnsList$member' => NULL, 'Subnet$SubnetIdentifier' => '<p>The unique identifier for the subnet.</p>', 'SubnetIdentifierList$member' => NULL, 'Tag$Key' => '<p>The key for the tag. May not be null.</p>', 'Tag$Value' => '<p>The tag\'s value. May be null.</p>', 'TestFailoverMessage$ReplicationGroupId' => '<p>The name of the replication group (console: cluster) whose automatic failover is being tested by this operation.</p>', 'TestFailoverMessage$NodeGroupId' => '<p>The name of the node group (called shard in the console) in this replication group on which automatic failover is to be tested. You may test automatic failover on up to 5 node groups in any rolling 24-hour period.</p>', ], ], 'Subnet' => [ 'base' => '<p>Represents the subnet associated with a cache cluster. This parameter refers to subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used with ElastiCache.</p>', 'refs' => [ 'SubnetList$member' => NULL, ], ], 'SubnetIdentifierList' => [ 'base' => NULL, 'refs' => [ 'CreateCacheSubnetGroupMessage$SubnetIds' => '<p>A list of VPC subnet IDs for the cache subnet group.</p>', 'ModifyCacheSubnetGroupMessage$SubnetIds' => '<p>The EC2 subnet IDs for the cache subnet group.</p>', ], ], 'SubnetInUse' => [ 'base' => '<p>The requested subnet is being used by another cache subnet group.</p>', 'refs' => [], ], 'SubnetList' => [ 'base' => NULL, 'refs' => [ 'CacheSubnetGroup$Subnets' => '<p>A list of subnets associated with the cache subnet group.</p>', ], ], 'TStamp' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$CacheClusterCreateTime' => '<p>The date and time when the cache cluster was created.</p>', 'CacheNode$CacheNodeCreateTime' => '<p>The date and time when the cache node was created.</p>', 'DescribeEventsMessage$StartTime' => '<p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.</p> <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>', 'DescribeEventsMessage$EndTime' => '<p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.</p> <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>', 'Event$Date' => '<p>The date and time when the event occurred.</p>', 'NodeSnapshot$CacheNodeCreateTime' => '<p>The date and time when the cache node was created in the source cache cluster.</p>', 'NodeSnapshot$SnapshotCreateTime' => '<p>The date and time when the source node\'s metadata and cache data set was obtained for the snapshot.</p>', 'ReservedCacheNode$StartTime' => '<p>The time the reservation started.</p>', 'Snapshot$CacheClusterCreateTime' => '<p>The date and time when the source cache cluster was created.</p>', ], ], 'Tag' => [ 'base' => '<p>A cost allocation Tag that can be added to an ElastiCache cluster or replication group. Tags are composed of a Key/Value pair. A tag with a null Value is permitted.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceMessage$Tags' => '<p>A list of cost allocation tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value.</p>', 'CreateCacheClusterMessage$Tags' => '<p>A list of cost allocation tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value.</p>', 'CreateReplicationGroupMessage$Tags' => '<p>A list of cost allocation tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value.</p>', 'TagListMessage$TagList' => '<p>A list of cost allocation tags as key-value pairs.</p>', ], ], 'TagListMessage' => [ 'base' => '<p>Represents the output from the <code>AddTagsToResource</code>, <code>ListTagsForResource</code>, and <code>RemoveTagsFromResource</code> operations.</p>', 'refs' => [], ], 'TagNotFoundFault' => [ 'base' => '<p>The requested tag was not found on this resource.</p>', 'refs' => [], ], 'TagQuotaPerResourceExceeded' => [ 'base' => '<p>The request cannot be processed because it would cause the resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource is 50.</p>', 'refs' => [], ], 'TestFailoverMessage' => [ 'base' => NULL, 'refs' => [], ], 'TestFailoverNotAvailableFault' => [ 'base' => NULL, 'refs' => [], ], 'TestFailoverResult' => [ 'base' => NULL, 'refs' => [], ], ],];
