<?php
// This file was auto-generated from sdk-root/src/data/elasticloadbalancing/2012-06-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Elastic Load Balancing</fullname> <p>A load balancer distributes incoming traffic across your EC2 instances. This enables you to increase the availability of your application. The load balancer also monitors the health of its registered instances and ensures that it routes traffic only to healthy instances. You configure your load balancer to accept incoming traffic by specifying one or more listeners, which are configured with a protocol and port number for connections from clients to the load balancer and a protocol and port number for connections from the load balancer to the instances.</p> <p>Elastic Load Balancing supports two types of load balancers: Classic Load Balancers and Application Load Balancers (new). A Classic Load Balancer makes routing and load balancing decisions either at the transport layer (TCP/SSL) or the application layer (HTTP/HTTPS), and supports either EC2-Classic or a VPC. An Application Load Balancer makes routing and load balancing decisions at the application layer (HTTP/HTTPS), supports path-based routing, and can route requests to one or more ports on each EC2 instance or container instance in your virtual private cloud (VPC). For more information, see the <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/what-is-load-balancing.html">Elastic Load Balancing User Guide</a>.</p> <p>This reference covers the 2012-06-01 API, which supports Classic Load Balancers. The 2015-12-01 API supports Application Load Balancers.</p> <p>To get started, create a load balancer with one or more listeners using <a>CreateLoadBalancer</a>. Register your instances with the load balancer using <a>RegisterInstancesWithLoadBalancer</a>.</p> <p>All Elastic Load Balancing operations are <i>idempotent</i>, which means that they complete at most one time. If you repeat an operation, it succeeds with a 200 OK response code.</p>', 'operations' => [ 'AddTags' => '<p>Adds the specified tags to the specified load balancer. Each load balancer can have a maximum of 10 tags.</p> <p>Each tag consists of a key and an optional value. If a tag with the same key is already associated with the load balancer, <code>AddTags</code> updates its value.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic Load Balancer</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'ApplySecurityGroupsToLoadBalancer' => '<p>Associates one or more security groups with your load balancer in a virtual private cloud (VPC). The specified security groups override the previously associated security groups.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-security-groups.html#elb-vpc-security-groups">Security Groups for Load Balancers in a VPC</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'AttachLoadBalancerToSubnets' => '<p>Adds one or more subnets to the set of configured subnets for the specified load balancer.</p> <p>The load balancer evenly distributes requests across all registered subnets. For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-manage-subnets.html">Add or Remove Subnets for Your Load Balancer in a VPC</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'ConfigureHealthCheck' => '<p>Specifies the health check settings to use when evaluating the health state of your EC2 instances.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-healthchecks.html">Configure Health Checks for Your Load Balancer</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'CreateAppCookieStickinessPolicy' => '<p>Generates a stickiness policy with sticky session lifetimes that follow that of an application-generated cookie. This policy can be associated only with HTTP/HTTPS listeners.</p> <p>This policy is similar to the policy created by <a>CreateLBCookieStickinessPolicy</a>, except that the lifetime of the special Elastic Load Balancing cookie, <code>AWSELB</code>, follows the lifetime of the application-generated cookie specified in the policy configuration. The load balancer only inserts a new stickiness cookie when the application response includes a new application cookie.</p> <p>If the application cookie is explicitly removed or expires, the session stops being sticky until a new application cookie is issued.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application">Application-Controlled Session Stickiness</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'CreateLBCookieStickinessPolicy' => '<p>Generates a stickiness policy with sticky session lifetimes controlled by the lifetime of the browser (user-agent) or a specified expiration period. This policy can be associated only with HTTP/HTTPS listeners.</p> <p>When a load balancer implements this policy, the load balancer uses a special cookie to track the instance for each request. When the load balancer receives a request, it first checks to see if this cookie is present in the request. If so, the load balancer sends the request to the application server specified in the cookie. If not, the load balancer sends the request to a server that is chosen based on the existing load-balancing algorithm.</p> <p>A cookie is inserted into the response for binding subsequent requests from the same user to that server. The validity of the cookie is based on the cookie expiration time, which is specified in the policy configuration.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration">Duration-Based Session Stickiness</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'CreateLoadBalancer' => '<p>Creates a Classic Load Balancer.</p> <p>You can add listeners, security groups, subnets, and tags when you create your load balancer, or you can add them later using <a>CreateLoadBalancerListeners</a>, <a>ApplySecurityGroupsToLoadBalancer</a>, <a>AttachLoadBalancerToSubnets</a>, and <a>AddTags</a>.</p> <p>To describe your current load balancers, see <a>DescribeLoadBalancers</a>. When you are finished with a load balancer, you can delete it using <a>DeleteLoadBalancer</a>.</p> <p>You can create up to 20 load balancers per region per account. You can request an increase for the number of load balancers for your account. For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html">Limits for Your Classic Load Balancer</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'CreateLoadBalancerListeners' => '<p>Creates one or more listeners for the specified load balancer. If a listener with the specified port does not already exist, it is created; otherwise, the properties of the new listener must match the properties of the existing listener.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'CreateLoadBalancerPolicy' => '<p>Creates a policy with the specified attributes for the specified load balancer.</p> <p>Policies are settings that are saved for your load balancer and that can be applied to the listener or the application server, depending on the policy type.</p>', 'DeleteLoadBalancer' => '<p>Deletes the specified load balancer.</p> <p>If you are attempting to recreate a load balancer, you must reconfigure all settings. The DNS name associated with a deleted load balancer are no longer usable. The name and associated DNS record of the deleted load balancer no longer exist and traffic sent to any of its IP addresses is no longer delivered to your instances.</p> <p>If the load balancer does not exist or has already been deleted, the call to <code>DeleteLoadBalancer</code> still succeeds.</p>', 'DeleteLoadBalancerListeners' => '<p>Deletes the specified listeners from the specified load balancer.</p>', 'DeleteLoadBalancerPolicy' => '<p>Deletes the specified policy from the specified load balancer. This policy must not be enabled for any listeners.</p>', 'DeregisterInstancesFromLoadBalancer' => '<p>Deregisters the specified instances from the specified load balancer. After the instance is deregistered, it no longer receives traffic from the load balancer.</p> <p>You can use <a>DescribeLoadBalancers</a> to verify that the instance is deregistered from the load balancer.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html">Register or De-Register EC2 Instances</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'DescribeAccountLimits' => '<p>Describes the current Elastic Load Balancing resource limits for your AWS account.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html">Limits for Your Classic Load Balancer</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'DescribeInstanceHealth' => '<p>Describes the state of the specified instances with respect to the specified load balancer. If no instances are specified, the call describes the state of all instances that are currently registered with the load balancer. If instances are specified, their state is returned even if they are no longer registered with the load balancer. The state of terminated instances is not returned.</p>', 'DescribeLoadBalancerAttributes' => '<p>Describes the attributes for the specified load balancer.</p>', 'DescribeLoadBalancerPolicies' => '<p>Describes the specified policies.</p> <p>If you specify a load balancer name, the action returns the descriptions of all policies created for the load balancer. If you specify a policy name associated with your load balancer, the action returns the description of that policy. If you don\'t specify a load balancer name, the action returns descriptions of the specified sample policies, or descriptions of all sample policies. The names of the sample policies have the <code>ELBSample-</code> prefix.</p>', 'DescribeLoadBalancerPolicyTypes' => '<p>Describes the specified load balancer policy types or all load balancer policy types.</p> <p>The description of each type indicates how it can be used. For example, some policies can be used only with layer 7 listeners, some policies can be used only with layer 4 listeners, and some policies can be used only with your EC2 instances.</p> <p>You can use <a>CreateLoadBalancerPolicy</a> to create a policy configuration for any of these policy types. Then, depending on the policy type, use either <a>SetLoadBalancerPoliciesOfListener</a> or <a>SetLoadBalancerPoliciesForBackendServer</a> to set the policy.</p>', 'DescribeLoadBalancers' => '<p>Describes the specified the load balancers. If no load balancers are specified, the call describes all of your load balancers.</p>', 'DescribeTags' => '<p>Describes the tags associated with the specified load balancers.</p>', 'DetachLoadBalancerFromSubnets' => '<p>Removes the specified subnets from the set of configured subnets for the load balancer.</p> <p>After a subnet is removed, all EC2 instances registered with the load balancer in the removed subnet go into the <code>OutOfService</code> state. Then, the load balancer balances the traffic among the remaining routable subnets.</p>', 'DisableAvailabilityZonesForLoadBalancer' => '<p>Removes the specified Availability Zones from the set of Availability Zones for the specified load balancer.</p> <p>There must be at least one Availability Zone registered with a load balancer at all times. After an Availability Zone is removed, all instances registered with the load balancer that are in the removed Availability Zone go into the <code>OutOfService</code> state. Then, the load balancer attempts to equally balance the traffic among its remaining Availability Zones.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html">Add or Remove Availability Zones</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'EnableAvailabilityZonesForLoadBalancer' => '<p>Adds the specified Availability Zones to the set of Availability Zones for the specified load balancer.</p> <p>The load balancer evenly distributes requests across all its registered Availability Zones that contain instances.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html">Add or Remove Availability Zones</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'ModifyLoadBalancerAttributes' => '<p>Modifies the attributes of the specified load balancer.</p> <p>You can modify the load balancer attributes, such as <code>AccessLogs</code>, <code>ConnectionDraining</code>, and <code>CrossZoneLoadBalancing</code> by either enabling or disabling them. Or, you can modify the load balancer attribute <code>ConnectionSettings</code> by specifying an idle connection timeout value for your load balancer.</p> <p>For more information, see the following in the <i>Classic Load Balancer Guide</i>:</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Cross-Zone Load Balancing</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Connection Draining</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/access-log-collection.html">Access Logs</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Idle Connection Timeout</a> </p> </li> </ul>', 'RegisterInstancesWithLoadBalancer' => '<p>Adds the specified instances to the specified load balancer.</p> <p>The instance must be a running instance in the same network as the load balancer (EC2-Classic or the same VPC). If you have EC2-Classic instances and a load balancer in a VPC with ClassicLink enabled, you can link the EC2-Classic instances to that VPC and then register the linked EC2-Classic instances with the load balancer in the VPC.</p> <p>Note that <code>RegisterInstanceWithLoadBalancer</code> completes when the request has been registered. Instance registration takes a little time to complete. To check the state of the registered instances, use <a>DescribeLoadBalancers</a> or <a>DescribeInstanceHealth</a>.</p> <p>After the instance is registered, it starts receiving traffic and requests from the load balancer. Any instance that is not in one of the Availability Zones registered for the load balancer is moved to the <code>OutOfService</code> state. If an Availability Zone is added to the load balancer later, any instances registered with the load balancer move to the <code>InService</code> state.</p> <p>To deregister instances from a load balancer, use <a>DeregisterInstancesFromLoadBalancer</a>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html">Register or De-Register EC2 Instances</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'RemoveTags' => '<p>Removes one or more tags from the specified load balancer.</p>', 'SetLoadBalancerListenerSSLCertificate' => '<p>Sets the certificate that terminates the specified listener\'s SSL connections. The specified certificate replaces any prior certificate that was used on the same load balancer and port.</p> <p>For more information about updating your SSL certificate, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-update-ssl-cert.html">Replace the SSL Certificate for Your Load Balancer</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'SetLoadBalancerPoliciesForBackendServer' => '<p>Replaces the set of policies associated with the specified port on which the EC2 instance is listening with a new set of policies. At this time, only the back-end server authentication policy type can be applied to the instance ports; this policy type is composed of multiple public key policies.</p> <p>Each time you use <code>SetLoadBalancerPoliciesForBackendServer</code> to enable the policies, use the <code>PolicyNames</code> parameter to list the policies that you want to enable.</p> <p>You can use <a>DescribeLoadBalancers</a> or <a>DescribeLoadBalancerPolicies</a> to verify that the policy is associated with the EC2 instance.</p> <p>For more information about enabling back-end instance authentication, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-create-https-ssl-load-balancer.html#configure_backendauth_clt">Configure Back-end Instance Authentication</a> in the <i>Classic Load Balancer Guide</i>. For more information about Proxy Protocol, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-proxy-protocol.html">Configure Proxy Protocol Support</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'SetLoadBalancerPoliciesOfListener' => '<p>Replaces the current set of policies for the specified load balancer port with the specified set of policies.</p> <p>To enable back-end server authentication, use <a>SetLoadBalancerPoliciesForBackendServer</a>.</p> <p>For more information about setting policies, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/ssl-config-update.html">Update the SSL Negotiation Configuration</a>, <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration">Duration-Based Session Stickiness</a>, and <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application">Application-Controlled Session Stickiness</a> in the <i>Classic Load Balancer Guide</i>.</p>', ], 'shapes' => [ 'AccessLog' => [ 'base' => '<p>Information about the <code>AccessLog</code> attribute.</p>', 'refs' => [ 'LoadBalancerAttributes$AccessLog' => '<p>If enabled, the load balancer captures detailed information of all requests and delivers the information to the Amazon S3 bucket that you specify.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html">Enable Access Logs</a> in the <i>Classic Load Balancer Guide</i>.</p>', ], ], 'AccessLogEnabled' => [ 'base' => NULL, 'refs' => [ 'AccessLog$Enabled' => '<p>Specifies whether access logs are enabled for the load balancer.</p>', ], ], 'AccessLogInterval' => [ 'base' => NULL, 'refs' => [ 'AccessLog$EmitInterval' => '<p>The interval for publishing the access logs. You can specify an interval of either 5 minutes or 60 minutes.</p> <p>Default: 60 minutes</p>', ], ], 'AccessLogPrefix' => [ 'base' => NULL, 'refs' => [ 'AccessLog$S3BucketPrefix' => '<p>The logical hierarchy you created for your Amazon S3 bucket, for example <code>my-bucket-prefix/prod</code>. If the prefix is not provided, the log is placed at the root level of the bucket.</p>', ], ], 'AccessPointName' => [ 'base' => NULL, 'refs' => [ 'AddAvailabilityZonesInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'ApplySecurityGroupsToLoadBalancerInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'AttachLoadBalancerToSubnetsInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'ConfigureHealthCheckInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'CreateAccessPointInput$LoadBalancerName' => '<p>The name of the load balancer.</p> <p>This name must be unique within your set of load balancers for the region, must have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.</p>', 'CreateAppCookieStickinessPolicyInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'CreateLBCookieStickinessPolicyInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'CreateLoadBalancerListenerInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'CreateLoadBalancerPolicyInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DeleteAccessPointInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DeleteLoadBalancerListenerInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DeleteLoadBalancerPolicyInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DeregisterEndPointsInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DescribeEndPointStateInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DescribeLoadBalancerAttributesInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DescribeLoadBalancerPoliciesInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DetachLoadBalancerFromSubnetsInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'LoadBalancerDescription$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'LoadBalancerNames$member' => NULL, 'LoadBalancerNamesMax20$member' => NULL, 'ModifyLoadBalancerAttributesInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'ModifyLoadBalancerAttributesOutput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'RegisterEndPointsInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'RemoveAvailabilityZonesInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'SetLoadBalancerListenerSSLCertificateInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'SetLoadBalancerPoliciesForBackendServerInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'SetLoadBalancerPoliciesOfListenerInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'TagDescription$LoadBalancerName' => '<p>The name of the load balancer.</p>', ], ], 'AccessPointNotFoundException' => [ 'base' => '<p>The specified load balancer does not exist.</p>', 'refs' => [], ], 'AccessPointPort' => [ 'base' => NULL, 'refs' => [ 'Listener$LoadBalancerPort' => '<p>The port on which the load balancer is listening. On EC2-VPC, you can specify any port from the range 1-65535. On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.</p>', 'Ports$member' => NULL, 'SetLoadBalancerListenerSSLCertificateInput$LoadBalancerPort' => '<p>The port that uses the specified SSL certificate.</p>', 'SetLoadBalancerPoliciesOfListenerInput$LoadBalancerPort' => '<p>The external port of the load balancer.</p>', ], ], 'AddAvailabilityZonesInput' => [ 'base' => '<p>Contains the parameters for EnableAvailabilityZonesForLoadBalancer.</p>', 'refs' => [], ], 'AddAvailabilityZonesOutput' => [ 'base' => '<p>Contains the output of EnableAvailabilityZonesForLoadBalancer.</p>', 'refs' => [], ], 'AddTagsInput' => [ 'base' => '<p>Contains the parameters for AddTags.</p>', 'refs' => [], ], 'AddTagsOutput' => [ 'base' => '<p>Contains the output of AddTags.</p>', 'refs' => [], ], 'AdditionalAttribute' => [ 'base' => '<p>This data type is reserved.</p>', 'refs' => [ 'AdditionalAttributes$member' => NULL, ], ], 'AdditionalAttributeKey' => [ 'base' => NULL, 'refs' => [ 'AdditionalAttribute$Key' => '<p>This parameter is reserved.</p>', ], ], 'AdditionalAttributeValue' => [ 'base' => NULL, 'refs' => [ 'AdditionalAttribute$Value' => '<p>This parameter is reserved.</p>', ], ], 'AdditionalAttributes' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerAttributes$AdditionalAttributes' => '<p>This parameter is reserved.</p>', ], ], 'AppCookieStickinessPolicies' => [ 'base' => NULL, 'refs' => [ 'Policies$AppCookieStickinessPolicies' => '<p>The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.</p>', ], ], 'AppCookieStickinessPolicy' => [ 'base' => '<p>Information about a policy for application-controlled session stickiness.</p>', 'refs' => [ 'AppCookieStickinessPolicies$member' => NULL, ], ], 'ApplySecurityGroupsToLoadBalancerInput' => [ 'base' => '<p>Contains the parameters for ApplySecurityGroupsToLoadBalancer.</p>', 'refs' => [], ], 'ApplySecurityGroupsToLoadBalancerOutput' => [ 'base' => '<p>Contains the output of ApplySecurityGroupsToLoadBalancer.</p>', 'refs' => [], ], 'AttachLoadBalancerToSubnetsInput' => [ 'base' => '<p>Contains the parameters for AttachLoaBalancerToSubnets.</p>', 'refs' => [], ], 'AttachLoadBalancerToSubnetsOutput' => [ 'base' => '<p>Contains the output of AttachLoadBalancerToSubnets.</p>', 'refs' => [], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'PolicyAttribute$AttributeName' => '<p>The name of the attribute.</p>', 'PolicyAttributeDescription$AttributeName' => '<p>The name of the attribute.</p>', 'PolicyAttributeTypeDescription$AttributeName' => '<p>The name of the attribute.</p>', ], ], 'AttributeType' => [ 'base' => NULL, 'refs' => [ 'PolicyAttributeTypeDescription$AttributeType' => '<p>The type of the attribute. For example, <code>Boolean</code> or <code>Integer</code>.</p>', ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'PolicyAttribute$AttributeValue' => '<p>The value of the attribute.</p>', 'PolicyAttributeDescription$AttributeValue' => '<p>The value of the attribute.</p>', ], ], 'AvailabilityZone' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZones$member' => NULL, ], ], 'AvailabilityZones' => [ 'base' => NULL, 'refs' => [ 'AddAvailabilityZonesInput$AvailabilityZones' => '<p>The Availability Zones. These must be in the same region as the load balancer.</p>', 'AddAvailabilityZonesOutput$AvailabilityZones' => '<p>The updated list of Availability Zones for the load balancer.</p>', 'CreateAccessPointInput$AvailabilityZones' => '<p>One or more Availability Zones from the same region as the load balancer.</p> <p>You must specify at least one Availability Zone.</p> <p>You can add more Availability Zones after you create the load balancer using <a>EnableAvailabilityZonesForLoadBalancer</a>.</p>', 'LoadBalancerDescription$AvailabilityZones' => '<p>The Availability Zones for the load balancer.</p>', 'RemoveAvailabilityZonesInput$AvailabilityZones' => '<p>The Availability Zones.</p>', 'RemoveAvailabilityZonesOutput$AvailabilityZones' => '<p>The remaining Availability Zones for the load balancer.</p>', ], ], 'BackendServerDescription' => [ 'base' => '<p>Information about the configuration of an EC2 instance.</p>', 'refs' => [ 'BackendServerDescriptions$member' => NULL, ], ], 'BackendServerDescriptions' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerDescription$BackendServerDescriptions' => '<p>Information about your EC2 instances.</p>', ], ], 'Cardinality' => [ 'base' => NULL, 'refs' => [ 'PolicyAttributeTypeDescription$Cardinality' => '<p>The cardinality of the attribute.</p> <p>Valid values:</p> <ul> <li> <p>ONE(1) : Single value required</p> </li> <li> <p>ZERO_OR_ONE(0..1) : Up to one value is allowed</p> </li> <li> <p>ZERO_OR_MORE(0..*) : Optional. Multiple values are allowed</p> </li> <li> <p>ONE_OR_MORE(1..*0) : Required. Multiple values are allowed</p> </li> </ul>', ], ], 'CertificateNotFoundException' => [ 'base' => '<p>The specified ARN does not refer to a valid SSL certificate in AWS Identity and Access Management (IAM) or AWS Certificate Manager (ACM). Note that if you recently uploaded the certificate to IAM, this error might indicate that the certificate is not fully available yet.</p>', 'refs' => [], ], 'ConfigureHealthCheckInput' => [ 'base' => '<p>Contains the parameters for ConfigureHealthCheck.</p>', 'refs' => [], ], 'ConfigureHealthCheckOutput' => [ 'base' => '<p>Contains the output of ConfigureHealthCheck.</p>', 'refs' => [], ], 'ConnectionDraining' => [ 'base' => '<p>Information about the <code>ConnectionDraining</code> attribute.</p>', 'refs' => [ 'LoadBalancerAttributes$ConnectionDraining' => '<p>If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic away from a deregistered or unhealthy instance.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure Connection Draining</a> in the <i>Classic Load Balancer Guide</i>.</p>', ], ], 'ConnectionDrainingEnabled' => [ 'base' => NULL, 'refs' => [ 'ConnectionDraining$Enabled' => '<p>Specifies whether connection draining is enabled for the load balancer.</p>', ], ], 'ConnectionDrainingTimeout' => [ 'base' => NULL, 'refs' => [ 'ConnectionDraining$Timeout' => '<p>The maximum time, in seconds, to keep the existing connections open before deregistering the instances.</p>', ], ], 'ConnectionSettings' => [ 'base' => '<p>Information about the <code>ConnectionSettings</code> attribute.</p>', 'refs' => [ 'LoadBalancerAttributes$ConnectionSettings' => '<p>If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection) for the specified duration.</p> <p>By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and back-end connections of your load balancer. For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure Idle Connection Timeout</a> in the <i>Classic Load Balancer Guide</i>.</p>', ], ], 'CookieExpirationPeriod' => [ 'base' => NULL, 'refs' => [ 'CreateLBCookieStickinessPolicyInput$CookieExpirationPeriod' => '<p>The time period, in seconds, after which the cookie should be considered stale. If you do not specify this parameter, the default value is 0, which indicates that the sticky session should last for the duration of the browser session.</p>', 'LBCookieStickinessPolicy$CookieExpirationPeriod' => '<p>The time period, in seconds, after which the cookie should be considered stale. If this parameter is not specified, the stickiness session lasts for the duration of the browser session.</p>', ], ], 'CookieName' => [ 'base' => NULL, 'refs' => [ 'AppCookieStickinessPolicy$CookieName' => '<p>The name of the application cookie used for stickiness.</p>', 'CreateAppCookieStickinessPolicyInput$CookieName' => '<p>The name of the application cookie used for stickiness.</p>', ], ], 'CreateAccessPointInput' => [ 'base' => '<p>Contains the parameters for CreateLoadBalancer.</p>', 'refs' => [], ], 'CreateAccessPointOutput' => [ 'base' => '<p>Contains the output for CreateLoadBalancer.</p>', 'refs' => [], ], 'CreateAppCookieStickinessPolicyInput' => [ 'base' => '<p>Contains the parameters for CreateAppCookieStickinessPolicy.</p>', 'refs' => [], ], 'CreateAppCookieStickinessPolicyOutput' => [ 'base' => '<p>Contains the output for CreateAppCookieStickinessPolicy.</p>', 'refs' => [], ], 'CreateLBCookieStickinessPolicyInput' => [ 'base' => '<p>Contains the parameters for CreateLBCookieStickinessPolicy.</p>', 'refs' => [], ], 'CreateLBCookieStickinessPolicyOutput' => [ 'base' => '<p>Contains the output for CreateLBCookieStickinessPolicy.</p>', 'refs' => [], ], 'CreateLoadBalancerListenerInput' => [ 'base' => '<p>Contains the parameters for CreateLoadBalancerListeners.</p>', 'refs' => [], ], 'CreateLoadBalancerListenerOutput' => [ 'base' => '<p>Contains the parameters for CreateLoadBalancerListener.</p>', 'refs' => [], ], 'CreateLoadBalancerPolicyInput' => [ 'base' => '<p>Contains the parameters for CreateLoadBalancerPolicy.</p>', 'refs' => [], ], 'CreateLoadBalancerPolicyOutput' => [ 'base' => '<p>Contains the output of CreateLoadBalancerPolicy.</p>', 'refs' => [], ], 'CreatedTime' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerDescription$CreatedTime' => '<p>The date and time the load balancer was created.</p>', ], ], 'CrossZoneLoadBalancing' => [ 'base' => '<p>Information about the <code>CrossZoneLoadBalancing</code> attribute.</p>', 'refs' => [ 'LoadBalancerAttributes$CrossZoneLoadBalancing' => '<p>If enabled, the load balancer routes the request traffic evenly across all instances regardless of the Availability Zones.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Configure Cross-Zone Load Balancing</a> in the <i>Classic Load Balancer Guide</i>.</p>', ], ], 'CrossZoneLoadBalancingEnabled' => [ 'base' => NULL, 'refs' => [ 'CrossZoneLoadBalancing$Enabled' => '<p>Specifies whether cross-zone load balancing is enabled for the load balancer.</p>', ], ], 'DNSName' => [ 'base' => NULL, 'refs' => [ 'CreateAccessPointOutput$DNSName' => '<p>The DNS name of the load balancer.</p>', 'LoadBalancerDescription$DNSName' => '<p>The DNS name of the load balancer.</p>', 'LoadBalancerDescription$CanonicalHostedZoneName' => '<p>The DNS name of the load balancer.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/using-domain-names-with-elb.html">Configure a Custom Domain Name</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'LoadBalancerDescription$CanonicalHostedZoneNameID' => '<p>The ID of the Amazon Route 53 hosted zone for the load balancer.</p>', ], ], 'DefaultValue' => [ 'base' => NULL, 'refs' => [ 'PolicyAttributeTypeDescription$DefaultValue' => '<p>The default value of the attribute, if applicable.</p>', ], ], 'DeleteAccessPointInput' => [ 'base' => '<p>Contains the parameters for DeleteLoadBalancer.</p>', 'refs' => [], ], 'DeleteAccessPointOutput' => [ 'base' => '<p>Contains the output of DeleteLoadBalancer.</p>', 'refs' => [], ], 'DeleteLoadBalancerListenerInput' => [ 'base' => '<p>Contains the parameters for DeleteLoadBalancerListeners.</p>', 'refs' => [], ], 'DeleteLoadBalancerListenerOutput' => [ 'base' => '<p>Contains the output of DeleteLoadBalancerListeners.</p>', 'refs' => [], ], 'DeleteLoadBalancerPolicyInput' => [ 'base' => '<p>Contains the parameters for DeleteLoadBalancerPolicy.</p>', 'refs' => [], ], 'DeleteLoadBalancerPolicyOutput' => [ 'base' => '<p>Contains the output of DeleteLoadBalancerPolicy.</p>', 'refs' => [], ], 'DependencyThrottleException' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterEndPointsInput' => [ 'base' => '<p>Contains the parameters for DeregisterInstancesFromLoadBalancer.</p>', 'refs' => [], ], 'DeregisterEndPointsOutput' => [ 'base' => '<p>Contains the output of DeregisterInstancesFromLoadBalancer.</p>', 'refs' => [], ], 'DescribeAccessPointsInput' => [ 'base' => '<p>Contains the parameters for DescribeLoadBalancers.</p>', 'refs' => [], ], 'DescribeAccessPointsOutput' => [ 'base' => '<p>Contains the parameters for DescribeLoadBalancers.</p>', 'refs' => [], ], 'DescribeAccountLimitsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountLimitsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndPointStateInput' => [ 'base' => '<p>Contains the parameters for DescribeInstanceHealth.</p>', 'refs' => [], ], 'DescribeEndPointStateOutput' => [ 'base' => '<p>Contains the output for DescribeInstanceHealth.</p>', 'refs' => [], ], 'DescribeLoadBalancerAttributesInput' => [ 'base' => '<p>Contains the parameters for DescribeLoadBalancerAttributes.</p>', 'refs' => [], ], 'DescribeLoadBalancerAttributesOutput' => [ 'base' => '<p>Contains the output of DescribeLoadBalancerAttributes.</p>', 'refs' => [], ], 'DescribeLoadBalancerPoliciesInput' => [ 'base' => '<p>Contains the parameters for DescribeLoadBalancerPolicies.</p>', 'refs' => [], ], 'DescribeLoadBalancerPoliciesOutput' => [ 'base' => '<p>Contains the output of DescribeLoadBalancerPolicies.</p>', 'refs' => [], ], 'DescribeLoadBalancerPolicyTypesInput' => [ 'base' => '<p>Contains the parameters for DescribeLoadBalancerPolicyTypes.</p>', 'refs' => [], ], 'DescribeLoadBalancerPolicyTypesOutput' => [ 'base' => '<p>Contains the output of DescribeLoadBalancerPolicyTypes.</p>', 'refs' => [], ], 'DescribeTagsInput' => [ 'base' => '<p>Contains the parameters for DescribeTags.</p>', 'refs' => [], ], 'DescribeTagsOutput' => [ 'base' => '<p>Contains the output for DescribeTags.</p>', 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'InstanceState$Description' => '<p>A description of the instance state. This string can contain one or more of the following messages.</p> <ul> <li> <p> <code>N/A</code> </p> </li> <li> <p> <code>A transient error occurred. Please try again later.</code> </p> </li> <li> <p> <code>Instance has failed at least the UnhealthyThreshold number of health checks consecutively.</code> </p> </li> <li> <p> <code>Instance has not passed the configured HealthyThreshold number of health checks consecutively.</code> </p> </li> <li> <p> <code>Instance registration is still in progress.</code> </p> </li> <li> <p> <code>Instance is in the EC2 Availability Zone for which LoadBalancer is not configured to route traffic to.</code> </p> </li> <li> <p> <code>Instance is not currently registered with the LoadBalancer.</code> </p> </li> <li> <p> <code>Instance deregistration currently in progress.</code> </p> </li> <li> <p> <code>Disable Availability Zone is currently in progress.</code> </p> </li> <li> <p> <code>Instance is in pending state.</code> </p> </li> <li> <p> <code>Instance is in stopped state.</code> </p> </li> <li> <p> <code>Instance is in terminated state.</code> </p> </li> </ul>', 'PolicyAttributeTypeDescription$Description' => '<p>A description of the attribute.</p>', 'PolicyTypeDescription$Description' => '<p>A description of the policy type.</p>', ], ], 'DetachLoadBalancerFromSubnetsInput' => [ 'base' => '<p>Contains the parameters for DetachLoadBalancerFromSubnets.</p>', 'refs' => [], ], 'DetachLoadBalancerFromSubnetsOutput' => [ 'base' => '<p>Contains the output of DetachLoadBalancerFromSubnets.</p>', 'refs' => [], ], 'DuplicateAccessPointNameException' => [ 'base' => '<p>The specified load balancer name already exists for this account.</p>', 'refs' => [], ], 'DuplicateListenerException' => [ 'base' => '<p>A listener already exists for the specified load balancer name and port, but with a different instance port, protocol, or SSL certificate.</p>', 'refs' => [], ], 'DuplicatePolicyNameException' => [ 'base' => '<p>A policy with the specified name already exists for this load balancer.</p>', 'refs' => [], ], 'DuplicateTagKeysException' => [ 'base' => '<p>A tag key was specified more than once.</p>', 'refs' => [], ], 'EndPointPort' => [ 'base' => NULL, 'refs' => [ 'SetLoadBalancerPoliciesForBackendServerInput$InstancePort' => '<p>The port number associated with the EC2 instance.</p>', ], ], 'HealthCheck' => [ 'base' => '<p>Information about a health check.</p>', 'refs' => [ 'ConfigureHealthCheckInput$HealthCheck' => '<p>The configuration information.</p>', 'ConfigureHealthCheckOutput$HealthCheck' => '<p>The updated health check.</p>', 'LoadBalancerDescription$HealthCheck' => '<p>Information about the health checks conducted on the load balancer.</p>', ], ], 'HealthCheckInterval' => [ 'base' => NULL, 'refs' => [ 'HealthCheck$Interval' => '<p>The approximate interval, in seconds, between health checks of an individual instance.</p>', ], ], 'HealthCheckTarget' => [ 'base' => NULL, 'refs' => [ 'HealthCheck$Target' => '<p>The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL. The range of valid ports is one (1) through 65535.</p> <p>TCP is the default, specified as a TCP: port pair, for example "TCP:5000". In this case, a health check simply attempts to open a TCP connection to the instance on the specified port. Failure to connect within the configured timeout is considered unhealthy.</p> <p>SSL is also specified as SSL: port pair, for example, SSL:5000.</p> <p>For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified as a HTTP:port;/;PathToPing; grouping, for example "HTTP:80/weather/us/wa/seattle". In this case, a HTTP GET request is issued to the instance on the given port and path. Any answer other than "200 OK" within the timeout period is considered unhealthy.</p> <p>The total length of the HTTP ping target must be 1024 16-bit Unicode characters or less.</p>', ], ], 'HealthCheckTimeout' => [ 'base' => NULL, 'refs' => [ 'HealthCheck$Timeout' => '<p>The amount of time, in seconds, during which no response means a failed health check.</p> <p>This value must be less than the <code>Interval</code> value.</p>', ], ], 'HealthyThreshold' => [ 'base' => NULL, 'refs' => [ 'HealthCheck$HealthyThreshold' => '<p>The number of consecutive health checks successes required before moving the instance to the <code>Healthy</code> state.</p>', ], ], 'IdleTimeout' => [ 'base' => NULL, 'refs' => [ 'ConnectionSettings$IdleTimeout' => '<p>The time, in seconds, that the connection is allowed to be idle (no data has been sent over the connection) before it is closed by the load balancer.</p>', ], ], 'Instance' => [ 'base' => '<p>The ID of an EC2 instance.</p>', 'refs' => [ 'Instances$member' => NULL, ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'Instance$InstanceId' => '<p>The instance ID.</p>', 'InstanceState$InstanceId' => '<p>The ID of the instance.</p>', ], ], 'InstancePort' => [ 'base' => NULL, 'refs' => [ 'BackendServerDescription$InstancePort' => '<p>The port on which the EC2 instance is listening.</p>', 'Listener$InstancePort' => '<p>The port on which the instance is listening.</p>', ], ], 'InstanceState' => [ 'base' => '<p>Information about the state of an EC2 instance.</p>', 'refs' => [ 'InstanceStates$member' => NULL, ], ], 'InstanceStates' => [ 'base' => NULL, 'refs' => [ 'DescribeEndPointStateOutput$InstanceStates' => '<p>Information about the health of the instances.</p>', ], ], 'Instances' => [ 'base' => NULL, 'refs' => [ 'DeregisterEndPointsInput$Instances' => '<p>The IDs of the instances.</p>', 'DeregisterEndPointsOutput$Instances' => '<p>The remaining instances registered with the load balancer.</p>', 'DescribeEndPointStateInput$Instances' => '<p>The IDs of the instances.</p>', 'LoadBalancerDescription$Instances' => '<p>The IDs of the instances for the load balancer.</p>', 'RegisterEndPointsInput$Instances' => '<p>The IDs of the instances.</p>', 'RegisterEndPointsOutput$Instances' => '<p>The updated list of instances for the load balancer.</p>', ], ], 'InvalidConfigurationRequestException' => [ 'base' => '<p>The requested configuration change is not valid.</p>', 'refs' => [], ], 'InvalidEndPointException' => [ 'base' => '<p>The specified endpoint is not valid.</p>', 'refs' => [], ], 'InvalidSchemeException' => [ 'base' => '<p>The specified value for the schema is not valid. You can only specify a scheme for load balancers in a VPC.</p>', 'refs' => [], ], 'InvalidSecurityGroupException' => [ 'base' => '<p>One or more of the specified security groups do not exist.</p>', 'refs' => [], ], 'InvalidSubnetException' => [ 'base' => '<p>The specified VPC has no associated Internet gateway.</p>', 'refs' => [], ], 'LBCookieStickinessPolicies' => [ 'base' => NULL, 'refs' => [ 'Policies$LBCookieStickinessPolicies' => '<p>The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.</p>', ], ], 'LBCookieStickinessPolicy' => [ 'base' => '<p>Information about a policy for duration-based session stickiness.</p>', 'refs' => [ 'LBCookieStickinessPolicies$member' => NULL, ], ], 'Limit' => [ 'base' => '<p>Information about an Elastic Load Balancing resource limit for your AWS account.</p>', 'refs' => [ 'Limits$member' => NULL, ], ], 'Limits' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsOutput$Limits' => '<p>Information about the limits.</p>', ], ], 'Listener' => [ 'base' => '<p>Information about a listener.</p> <p>For information about the protocols and the ports supported by Elastic Load Balancing, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'refs' => [ 'ListenerDescription$Listener' => '<p>The listener.</p>', 'Listeners$member' => NULL, ], ], 'ListenerDescription' => [ 'base' => '<p>The policies enabled for a listener.</p>', 'refs' => [ 'ListenerDescriptions$member' => NULL, ], ], 'ListenerDescriptions' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerDescription$ListenerDescriptions' => '<p>The listeners for the load balancer.</p>', ], ], 'ListenerNotFoundException' => [ 'base' => '<p>The load balancer does not have a listener configured at the specified port.</p>', 'refs' => [], ], 'Listeners' => [ 'base' => NULL, 'refs' => [ 'CreateAccessPointInput$Listeners' => '<p>The listeners.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'CreateLoadBalancerListenerInput$Listeners' => '<p>The listeners.</p>', ], ], 'LoadBalancerAttributeNotFoundException' => [ 'base' => '<p>The specified load balancer attribute does not exist.</p>', 'refs' => [], ], 'LoadBalancerAttributes' => [ 'base' => '<p>The attributes for a load balancer.</p>', 'refs' => [ 'DescribeLoadBalancerAttributesOutput$LoadBalancerAttributes' => '<p>Information about the load balancer attributes.</p>', 'ModifyLoadBalancerAttributesInput$LoadBalancerAttributes' => '<p>The attributes for the load balancer.</p>', 'ModifyLoadBalancerAttributesOutput$LoadBalancerAttributes' => '<p>Information about the load balancer attributes.</p>', ], ], 'LoadBalancerDescription' => [ 'base' => '<p>Information about a load balancer.</p>', 'refs' => [ 'LoadBalancerDescriptions$member' => NULL, ], ], 'LoadBalancerDescriptions' => [ 'base' => NULL, 'refs' => [ 'DescribeAccessPointsOutput$LoadBalancerDescriptions' => '<p>Information about the load balancers.</p>', ], ], 'LoadBalancerNames' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$LoadBalancerNames' => '<p>The name of the load balancer. You can specify one load balancer only.</p>', 'DescribeAccessPointsInput$LoadBalancerNames' => '<p>The names of the load balancers.</p>', 'RemoveTagsInput$LoadBalancerNames' => '<p>The name of the load balancer. You can specify a maximum of one load balancer name.</p>', ], ], 'LoadBalancerNamesMax20' => [ 'base' => NULL, 'refs' => [ 'DescribeTagsInput$LoadBalancerNames' => '<p>The names of the load balancers.</p>', ], ], 'LoadBalancerScheme' => [ 'base' => NULL, 'refs' => [ 'CreateAccessPointInput$Scheme' => '<p>The type of a load balancer. Valid only for load balancers in a VPC.</p> <p>By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that resolves to public IP addresses. For more information about Internet-facing and Internal load balancers, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme">Load Balancer Scheme</a> in the <i>Elastic Load Balancing User Guide</i>.</p> <p>Specify <code>internal</code> to create a load balancer with a DNS name that resolves to private IP addresses.</p>', 'LoadBalancerDescription$Scheme' => '<p>The type of load balancer. Valid only for load balancers in a VPC.</p> <p>If <code>Scheme</code> is <code>internet-facing</code>, the load balancer has a public DNS name that resolves to a public IP address.</p> <p>If <code>Scheme</code> is <code>internal</code>, the load balancer has a public DNS name that resolves to a private IP address.</p>', ], ], 'Marker' => [ 'base' => NULL, 'refs' => [ 'DescribeAccessPointsInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeAccessPointsOutput$NextMarker' => '<p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>', 'DescribeAccountLimitsInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeAccountLimitsOutput$NextMarker' => '<p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>', ], ], 'Max' => [ 'base' => NULL, 'refs' => [ 'Limit$Max' => '<p>The maximum value of the limit.</p>', ], ], 'ModifyLoadBalancerAttributesInput' => [ 'base' => '<p>Contains the parameters for ModifyLoadBalancerAttributes.</p>', 'refs' => [], ], 'ModifyLoadBalancerAttributesOutput' => [ 'base' => '<p>Contains the output of ModifyLoadBalancerAttributes.</p>', 'refs' => [], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'Limit$Name' => '<p>The name of the limit. The possible values are:</p> <ul> <li> <p>classic-listeners</p> </li> <li> <p>classic-load-balancers</p> </li> </ul>', ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'DescribeAccessPointsInput$PageSize' => '<p>The maximum number of results to return with this call (a number from 1 to 400). The default is 400.</p>', 'DescribeAccountLimitsInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', ], ], 'Policies' => [ 'base' => '<p>The policies for a load balancer.</p>', 'refs' => [ 'LoadBalancerDescription$Policies' => '<p>The policies defined for the load balancer.</p>', ], ], 'PolicyAttribute' => [ 'base' => '<p>Information about a policy attribute.</p>', 'refs' => [ 'PolicyAttributes$member' => NULL, ], ], 'PolicyAttributeDescription' => [ 'base' => '<p>Information about a policy attribute.</p>', 'refs' => [ 'PolicyAttributeDescriptions$member' => NULL, ], ], 'PolicyAttributeDescriptions' => [ 'base' => NULL, 'refs' => [ 'PolicyDescription$PolicyAttributeDescriptions' => '<p>The policy attributes.</p>', ], ], 'PolicyAttributeTypeDescription' => [ 'base' => '<p>Information about a policy attribute type.</p>', 'refs' => [ 'PolicyAttributeTypeDescriptions$member' => NULL, ], ], 'PolicyAttributeTypeDescriptions' => [ 'base' => NULL, 'refs' => [ 'PolicyTypeDescription$PolicyAttributeTypeDescriptions' => '<p>The description of the policy attributes associated with the policies defined by Elastic Load Balancing.</p>', ], ], 'PolicyAttributes' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerPolicyInput$PolicyAttributes' => '<p>The policy attributes.</p>', ], ], 'PolicyDescription' => [ 'base' => '<p>Information about a policy.</p>', 'refs' => [ 'PolicyDescriptions$member' => NULL, ], ], 'PolicyDescriptions' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBalancerPoliciesOutput$PolicyDescriptions' => '<p>Information about the policies.</p>', ], ], 'PolicyName' => [ 'base' => NULL, 'refs' => [ 'AppCookieStickinessPolicy$PolicyName' => '<p>The mnemonic name for the policy being created. The name must be unique within a set of policies for this load balancer.</p>', 'CreateAppCookieStickinessPolicyInput$PolicyName' => '<p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>', 'CreateLBCookieStickinessPolicyInput$PolicyName' => '<p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>', 'CreateLoadBalancerPolicyInput$PolicyName' => '<p>The name of the load balancer policy to be created. This name must be unique within the set of policies for this load balancer.</p>', 'DeleteLoadBalancerPolicyInput$PolicyName' => '<p>The name of the policy.</p>', 'LBCookieStickinessPolicy$PolicyName' => '<p>The name of the policy. This name must be unique within the set of policies for this load balancer.</p>', 'PolicyDescription$PolicyName' => '<p>The name of the policy.</p>', 'PolicyNames$member' => NULL, ], ], 'PolicyNames' => [ 'base' => NULL, 'refs' => [ 'BackendServerDescription$PolicyNames' => '<p>The names of the policies enabled for the EC2 instance.</p>', 'DescribeLoadBalancerPoliciesInput$PolicyNames' => '<p>The names of the policies.</p>', 'ListenerDescription$PolicyNames' => '<p>The policies. If there are no policies enabled, the list is empty.</p>', 'Policies$OtherPolicies' => '<p>The policies other than the stickiness policies.</p>', 'SetLoadBalancerPoliciesForBackendServerInput$PolicyNames' => '<p>The names of the policies. If the list is empty, then all current polices are removed from the EC2 instance.</p>', 'SetLoadBalancerPoliciesOfListenerInput$PolicyNames' => '<p>The names of the policies. This list must include all policies to be enabled. If you omit a policy that is currently enabled, it is disabled. If the list is empty, all current policies are disabled.</p>', ], ], 'PolicyNotFoundException' => [ 'base' => '<p>One or more of the specified policies do not exist.</p>', 'refs' => [], ], 'PolicyTypeDescription' => [ 'base' => '<p>Information about a policy type.</p>', 'refs' => [ 'PolicyTypeDescriptions$member' => NULL, ], ], 'PolicyTypeDescriptions' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBalancerPolicyTypesOutput$PolicyTypeDescriptions' => '<p>Information about the policy types.</p>', ], ], 'PolicyTypeName' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerPolicyInput$PolicyTypeName' => '<p>The name of the base policy type. To get the list of policy types, use <a>DescribeLoadBalancerPolicyTypes</a>.</p>', 'PolicyDescription$PolicyTypeName' => '<p>The name of the policy type.</p>', 'PolicyTypeDescription$PolicyTypeName' => '<p>The name of the policy type.</p>', 'PolicyTypeNames$member' => NULL, ], ], 'PolicyTypeNames' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBalancerPolicyTypesInput$PolicyTypeNames' => '<p>The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load Balancing.</p>', ], ], 'PolicyTypeNotFoundException' => [ 'base' => '<p>One or more of the specified policy types do not exist.</p>', 'refs' => [], ], 'Ports' => [ 'base' => NULL, 'refs' => [ 'DeleteLoadBalancerListenerInput$LoadBalancerPorts' => '<p>The client port numbers of the listeners.</p>', ], ], 'Protocol' => [ 'base' => NULL, 'refs' => [ 'Listener$Protocol' => '<p>The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP, or SSL.</p>', 'Listener$InstanceProtocol' => '<p>The protocol to use for routing traffic to instances: HTTP, HTTPS, TCP, or SSL.</p> <p>If the front-end protocol is HTTP, HTTPS, TCP, or SSL, <code>InstanceProtocol</code> must be at the same protocol.</p> <p>If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is secure, (HTTPS or SSL), the listener\'s <code>InstanceProtocol</code> must also be secure.</p> <p>If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is HTTP or TCP, the listener\'s <code>InstanceProtocol</code> must be HTTP or TCP.</p>', ], ], 'ReasonCode' => [ 'base' => NULL, 'refs' => [ 'InstanceState$ReasonCode' => '<p>Information about the cause of <code>OutOfService</code> instances. Specifically, whether the cause is Elastic Load Balancing or the instance.</p> <p>Valid values: <code>ELB</code> | <code>Instance</code> | <code>N/A</code> </p>', ], ], 'RegisterEndPointsInput' => [ 'base' => '<p>Contains the parameters for RegisterInstancesWithLoadBalancer.</p>', 'refs' => [], ], 'RegisterEndPointsOutput' => [ 'base' => '<p>Contains the output of RegisterInstancesWithLoadBalancer.</p>', 'refs' => [], ], 'RemoveAvailabilityZonesInput' => [ 'base' => '<p>Contains the parameters for DisableAvailabilityZonesForLoadBalancer.</p>', 'refs' => [], ], 'RemoveAvailabilityZonesOutput' => [ 'base' => '<p>Contains the output for DisableAvailabilityZonesForLoadBalancer.</p>', 'refs' => [], ], 'RemoveTagsInput' => [ 'base' => '<p>Contains the parameters for RemoveTags.</p>', 'refs' => [], ], 'RemoveTagsOutput' => [ 'base' => '<p>Contains the output of RemoveTags.</p>', 'refs' => [], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'AccessLog$S3BucketName' => '<p>The name of the Amazon S3 bucket where the access logs are stored.</p>', ], ], 'SSLCertificateId' => [ 'base' => NULL, 'refs' => [ 'Listener$SSLCertificateId' => '<p>The Amazon Resource Name (ARN) of the server certificate.</p>', 'SetLoadBalancerListenerSSLCertificateInput$SSLCertificateId' => '<p>The Amazon Resource Name (ARN) of the SSL certificate.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroups$member' => NULL, ], ], 'SecurityGroupName' => [ 'base' => NULL, 'refs' => [ 'SourceSecurityGroup$GroupName' => '<p>The name of the security group.</p>', ], ], 'SecurityGroupOwnerAlias' => [ 'base' => NULL, 'refs' => [ 'SourceSecurityGroup$OwnerAlias' => '<p>The owner of the security group.</p>', ], ], 'SecurityGroups' => [ 'base' => NULL, 'refs' => [ 'ApplySecurityGroupsToLoadBalancerInput$SecurityGroups' => '<p>The IDs of the security groups to associate with the load balancer. Note that you cannot specify the name of the security group.</p>', 'ApplySecurityGroupsToLoadBalancerOutput$SecurityGroups' => '<p>The IDs of the security groups associated with the load balancer.</p>', 'CreateAccessPointInput$SecurityGroups' => '<p>The IDs of the security groups to assign to the load balancer.</p>', 'LoadBalancerDescription$SecurityGroups' => '<p>The security groups for the load balancer. Valid only for load balancers in a VPC.</p>', ], ], 'SetLoadBalancerListenerSSLCertificateInput' => [ 'base' => '<p>Contains the parameters for SetLoadBalancerListenerSSLCertificate.</p>', 'refs' => [], ], 'SetLoadBalancerListenerSSLCertificateOutput' => [ 'base' => '<p>Contains the output of SetLoadBalancerListenerSSLCertificate.</p>', 'refs' => [], ], 'SetLoadBalancerPoliciesForBackendServerInput' => [ 'base' => '<p>Contains the parameters for SetLoadBalancerPoliciesForBackendServer.</p>', 'refs' => [], ], 'SetLoadBalancerPoliciesForBackendServerOutput' => [ 'base' => '<p>Contains the output of SetLoadBalancerPoliciesForBackendServer.</p>', 'refs' => [], ], 'SetLoadBalancerPoliciesOfListenerInput' => [ 'base' => '<p>Contains the parameters for SetLoadBalancePoliciesOfListener.</p>', 'refs' => [], ], 'SetLoadBalancerPoliciesOfListenerOutput' => [ 'base' => '<p>Contains the output of SetLoadBalancePoliciesOfListener.</p>', 'refs' => [], ], 'SourceSecurityGroup' => [ 'base' => '<p>Information about a source security group.</p>', 'refs' => [ 'LoadBalancerDescription$SourceSecurityGroup' => '<p>The security group for the load balancer, which you can use as part of your inbound rules for your registered instances. To only allow traffic from load balancers, add a security group rule that specifies this source security group as the inbound source.</p>', ], ], 'State' => [ 'base' => NULL, 'refs' => [ 'InstanceState$State' => '<p>The current state of the instance.</p> <p>Valid values: <code>InService</code> | <code>OutOfService</code> | <code>Unknown</code> </p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'Subnets$member' => NULL, ], ], 'SubnetNotFoundException' => [ 'base' => '<p>One or more of the specified subnets do not exist.</p>', 'refs' => [], ], 'Subnets' => [ 'base' => NULL, 'refs' => [ 'AttachLoadBalancerToSubnetsInput$Subnets' => '<p>The IDs of the subnets to add. You can add only one subnet per Availability Zone.</p>', 'AttachLoadBalancerToSubnetsOutput$Subnets' => '<p>The IDs of the subnets attached to the load balancer.</p>', 'CreateAccessPointInput$Subnets' => '<p>The IDs of the subnets in your VPC to attach to the load balancer. Specify one subnet per Availability Zone specified in <code>AvailabilityZones</code>.</p>', 'DetachLoadBalancerFromSubnetsInput$Subnets' => '<p>The IDs of the subnets.</p>', 'DetachLoadBalancerFromSubnetsOutput$Subnets' => '<p>The IDs of the remaining subnets for the load balancer.</p>', 'LoadBalancerDescription$Subnets' => '<p>The IDs of the subnets for the load balancer.</p>', ], ], 'Tag' => [ 'base' => '<p>Information about a tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagDescription' => [ 'base' => '<p>The tags associated with a load balancer.</p>', 'refs' => [ 'TagDescriptions$member' => NULL, ], ], 'TagDescriptions' => [ 'base' => NULL, 'refs' => [ 'DescribeTagsOutput$TagDescriptions' => '<p>Information about the tags.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the tag.</p>', 'TagKeyOnly$Key' => '<p>The name of the key.</p>', ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsInput$Tags' => '<p>The list of tag keys to remove.</p>', ], ], 'TagKeyOnly' => [ 'base' => '<p>The key of a tag.</p>', 'refs' => [ 'TagKeyList$member' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$Tags' => '<p>The tags.</p>', 'CreateAccessPointInput$Tags' => '<p>A list of tags to assign to the load balancer.</p> <p>For more information about tagging your load balancer, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic Load Balancer</a> in the <i>Classic Load Balancer Guide</i>.</p>', 'TagDescription$Tags' => '<p>The tags.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'TooManyAccessPointsException' => [ 'base' => '<p>The quota for the number of load balancers has been reached.</p>', 'refs' => [], ], 'TooManyPoliciesException' => [ 'base' => '<p>The quota for the number of policies for this load balancer has been reached.</p>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>The quota for the number of tags that can be assigned to a load balancer has been reached.</p>', 'refs' => [], ], 'UnhealthyThreshold' => [ 'base' => NULL, 'refs' => [ 'HealthCheck$UnhealthyThreshold' => '<p>The number of consecutive health check failures required before moving the instance to the <code>Unhealthy</code> state.</p>', ], ], 'UnsupportedProtocolException' => [ 'base' => '<p>The specified protocol or signature version is not supported.</p>', 'refs' => [], ], 'VPCId' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerDescription$VPCId' => '<p>The ID of the VPC for the load balancer.</p>', ], ], ],];
