<?php
// This file was auto-generated from sdk-root/src/data/elasticloadbalancingv2/2015-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Elastic Load Balancing</fullname> <p>A load balancer distributes incoming traffic across targets, such as your EC2 instances. This enables you to increase the availability of your application. The load balancer also monitors the health of its registered targets and ensures that it routes traffic only to healthy targets. You configure your load balancer to accept incoming traffic by specifying one or more listeners, which are configured with a protocol and port number for connections from clients to the load balancer. You configure a target group with a protocol and port number for connections from the load balancer to the targets, and with health check settings to be used when checking the health status of the targets.</p> <p>Elastic Load Balancing supports two types of load balancers: Classic Load Balancers and Application Load Balancers. A Classic Load Balancer makes routing and load balancing decisions either at the transport layer (TCP/SSL) or the application layer (HTTP/HTTPS), and supports either EC2-Classic or a VPC. An Application Load Balancer makes routing and load balancing decisions at the application layer (HTTP/HTTPS), supports path-based routing, and can route requests to one or more ports on each EC2 instance or container instance in your virtual private cloud (VPC). For more information, see the <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/">Elastic Load Balancing User Guide</a>.</p> <p>This reference covers the 2015-12-01 API, which supports Application Load Balancers. The 2012-06-01 API supports Classic Load Balancers.</p> <p>To get started, complete the following tasks:</p> <ol> <li> <p>Create an Application Load Balancer using <a>CreateLoadBalancer</a>.</p> </li> <li> <p>Create a target group using <a>CreateTargetGroup</a>.</p> </li> <li> <p>Register targets for the target group using <a>RegisterTargets</a>.</p> </li> <li> <p>Create one or more listeners for your load balancer using <a>CreateListener</a>.</p> </li> <li> <p>(Optional) Create one or more rules for content routing based on URL using <a>CreateRule</a>.</p> </li> </ol> <p>To delete an Application Load Balancer and its related resources, complete the following tasks:</p> <ol> <li> <p>Delete the load balancer using <a>DeleteLoadBalancer</a>.</p> </li> <li> <p>Delete the target group using <a>DeleteTargetGroup</a>.</p> </li> </ol> <p>All Elastic Load Balancing operations are idempotent, which means that they complete at most one time. If you repeat an operation, it succeeds.</p>', 'operations' => [ 'AddTags' => '<p>Adds the specified tags to the specified resource. You can tag your Application Load Balancers and your target groups.</p> <p>Each tag consists of a key and an optional value. If a resource already has a tag with the same key, <code>AddTags</code> updates its value.</p> <p>To list the current tags for your resources, use <a>DescribeTags</a>. To remove tags from your resources, use <a>RemoveTags</a>.</p>', 'CreateListener' => '<p>Creates a listener for the specified Application Load Balancer.</p> <p>You can create up to 10 listeners per load balancer.</p> <p>To update a listener, use <a>ModifyListener</a>. When you are finished with a listener, you can delete it using <a>DeleteListener</a>. If you are finished with both the listener and the load balancer, you can delete them both using <a>DeleteLoadBalancer</a>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html">Listeners for Your Application Load Balancers</a> in the <i>Application Load Balancers Guide</i>.</p>', 'CreateLoadBalancer' => '<p>Creates an Application Load Balancer.</p> <p>When you create a load balancer, you can specify security groups, subnets, IP address type, and tags. Otherwise, you could do so later using <a>SetSecurityGroups</a>, <a>SetSubnets</a>, <a>SetIpAddressType</a>, and <a>AddTags</a>.</p> <p>To create listeners for your load balancer, use <a>CreateListener</a>. To describe your current load balancers, see <a>DescribeLoadBalancers</a>. When you are finished with a load balancer, you can delete it using <a>DeleteLoadBalancer</a>.</p> <p>You can create up to 20 load balancers per region per account. You can request an increase for the number of load balancers for your account. For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Limits for Your Application Load Balancer</a> in the <i>Application Load Balancers Guide</i>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html">Application Load Balancers</a> in the <i>Application Load Balancers Guide</i>.</p>', 'CreateRule' => '<p>Creates a rule for the specified listener.</p> <p>Each rule can have one action and one condition. Rules are evaluated in priority order, from the lowest value to the highest value. When the condition for a rule is met, the specified action is taken. If no conditions are met, the default action for the default rule is taken. For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules">Listener Rules</a> in the <i>Application Load Balancers Guide</i>.</p> <p>To view your current rules, use <a>DescribeRules</a>. To update a rule, use <a>ModifyRule</a>. To set the priorities of your rules, use <a>SetRulePriorities</a>. To delete a rule, use <a>DeleteRule</a>.</p>', 'CreateTargetGroup' => '<p>Creates a target group.</p> <p>To register targets with the target group, use <a>RegisterTargets</a>. To update the health check settings for the target group, use <a>ModifyTargetGroup</a>. To monitor the health of targets in the target group, use <a>DescribeTargetHealth</a>.</p> <p>To route traffic to the targets in a target group, specify the target group in an action using <a>CreateListener</a> or <a>CreateRule</a>.</p> <p>To delete a target group, use <a>DeleteTargetGroup</a>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html">Target Groups for Your Application Load Balancers</a> in the <i>Application Load Balancers Guide</i>.</p>', 'DeleteListener' => '<p>Deletes the specified listener.</p> <p>Alternatively, your listener is deleted when you delete the load balancer it is attached to using <a>DeleteLoadBalancer</a>.</p>', 'DeleteLoadBalancer' => '<p>Deletes the specified Application Load Balancer and its attached listeners.</p> <p>You can\'t delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has already been deleted, the call succeeds.</p> <p>Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or terminate them.</p>', 'DeleteRule' => '<p>Deletes the specified rule.</p>', 'DeleteTargetGroup' => '<p>Deletes the specified target group.</p> <p>You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any associated health checks.</p>', 'DeregisterTargets' => '<p>Deregisters the specified targets from the specified target group. After the targets are deregistered, they no longer receive traffic from the load balancer.</p>', 'DescribeAccountLimits' => '<p>Describes the current Elastic Load Balancing resource limits for your AWS account.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Limits for Your Application Load Balancer</a> in the <i>Application Load Balancer Guide</i>.</p>', 'DescribeListeners' => '<p>Describes the specified listeners or the listeners for the specified Application Load Balancer. You must specify either a load balancer or one or more listeners.</p>', 'DescribeLoadBalancerAttributes' => '<p>Describes the attributes for the specified Application Load Balancer.</p>', 'DescribeLoadBalancers' => '<p>Describes the specified Application Load Balancers or all of your Application Load Balancers.</p> <p>To describe the listeners for a load balancer, use <a>DescribeListeners</a>. To describe the attributes for a load balancer, use <a>DescribeLoadBalancerAttributes</a>.</p>', 'DescribeRules' => '<p>Describes the specified rules or the rules for the specified listener. You must specify either a listener or one or more rules.</p>', 'DescribeSSLPolicies' => '<p>Describes the specified policies or all policies used for SSL negotiation.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security Policies</a> in the <i>Application Load Balancers Guide</i>.</p>', 'DescribeTags' => '<p>Describes the tags for the specified resources. You can describe the tags for one or more Application Load Balancers and target groups.</p>', 'DescribeTargetGroupAttributes' => '<p>Describes the attributes for the specified target group.</p>', 'DescribeTargetGroups' => '<p>Describes the specified target groups or all of your target groups. By default, all target groups are described. Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the names of one or more target groups, or the ARNs of one or more target groups.</p> <p>To describe the targets for a target group, use <a>DescribeTargetHealth</a>. To describe the attributes of a target group, use <a>DescribeTargetGroupAttributes</a>.</p>', 'DescribeTargetHealth' => '<p>Describes the health of the specified targets or all of your targets.</p>', 'ModifyListener' => '<p>Modifies the specified properties of the specified listener.</p> <p>Any properties that you do not specify retain their current values. However, changing the protocol from HTTPS to HTTP removes the security policy and SSL certificate properties. If you change the protocol from HTTP to HTTPS, you must add the security policy and server certificate.</p>', 'ModifyLoadBalancerAttributes' => '<p>Modifies the specified attributes of the specified Application Load Balancer.</p> <p>If any of the specified attributes can\'t be modified as requested, the call fails. Any existing attributes that you do not modify retain their current values.</p>', 'ModifyRule' => '<p>Modifies the specified rule.</p> <p>Any existing properties that you do not modify retain their current values.</p> <p>To modify the default action, use <a>ModifyListener</a>.</p>', 'ModifyTargetGroup' => '<p>Modifies the health checks used when evaluating the health state of the targets in the specified target group.</p> <p>To monitor the health of the targets, use <a>DescribeTargetHealth</a>.</p>', 'ModifyTargetGroupAttributes' => '<p>Modifies the specified attributes of the specified target group.</p>', 'RegisterTargets' => '<p>Registers the specified targets with the specified target group.</p> <p>By default, the load balancer routes requests to registered targets using the protocol and port number for the target group. Alternatively, you can override the port for a target when you register it.</p> <p>The target must be in the virtual private cloud (VPC) that you specified for the target group. If the target is an EC2 instance, it must be in the <code>running</code> state when you register it.</p> <p>To remove a target from a target group, use <a>DeregisterTargets</a>.</p>', 'RemoveTags' => '<p>Removes the specified tags from the specified resource.</p> <p>To list the current tags for your resources, use <a>DescribeTags</a>.</p>', 'SetIpAddressType' => '<p>Sets the type of IP addresses used by the subnets of the specified Application Load Balancer.</p>', 'SetRulePriorities' => '<p>Sets the priorities of the specified rules.</p> <p>You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that you do not specify retain their current priority.</p>', 'SetSecurityGroups' => '<p>Associates the specified security groups with the specified load balancer. The specified security groups override the previously associated security groups.</p>', 'SetSubnets' => '<p>Enables the Availability Zone for the specified subnets for the specified load balancer. The specified subnets replace the previously enabled subnets.</p>', ], 'shapes' => [ 'Action' => [ 'base' => '<p>Information about an action.</p>', 'refs' => [ 'Actions$member' => NULL, ], ], 'ActionTypeEnum' => [ 'base' => NULL, 'refs' => [ 'Action$Type' => '<p>The type of action.</p>', ], ], 'Actions' => [ 'base' => NULL, 'refs' => [ 'CreateListenerInput$DefaultActions' => '<p>The default action for the listener.</p>', 'CreateRuleInput$Actions' => '<p>An action. Each action has the type <code>forward</code> and specifies a target group.</p>', 'Listener$DefaultActions' => '<p>The default actions for the listener.</p>', 'ModifyListenerInput$DefaultActions' => '<p>The default actions.</p>', 'ModifyRuleInput$Actions' => '<p>The actions.</p>', 'Rule$Actions' => '<p>The actions.</p>', ], ], 'AddTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'AvailabilityZone' => [ 'base' => '<p>Information about an Availability Zone.</p>', 'refs' => [ 'AvailabilityZones$member' => NULL, ], ], 'AvailabilityZones' => [ 'base' => NULL, 'refs' => [ 'LoadBalancer$AvailabilityZones' => '<p>The Availability Zones for the load balancer.</p>', 'SetSubnetsOutput$AvailabilityZones' => '<p>Information about the subnet and Availability Zone.</p>', ], ], 'CanonicalHostedZoneId' => [ 'base' => NULL, 'refs' => [ 'LoadBalancer$CanonicalHostedZoneId' => '<p>The ID of the Amazon Route 53 hosted zone associated with the load balancer.</p>', ], ], 'Certificate' => [ 'base' => '<p>Information about an SSL server certificate deployed on a load balancer.</p>', 'refs' => [ 'CertificateList$member' => NULL, ], ], 'CertificateArn' => [ 'base' => NULL, 'refs' => [ 'Certificate$CertificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate.</p>', ], ], 'CertificateList' => [ 'base' => NULL, 'refs' => [ 'CreateListenerInput$Certificates' => '<p>The SSL server certificate. You must provide exactly one certificate if the protocol is HTTPS.</p>', 'Listener$Certificates' => '<p>The SSL server certificate. You must provide a certificate if the protocol is HTTPS.</p>', 'ModifyListenerInput$Certificates' => '<p>The SSL server certificate.</p>', ], ], 'CertificateNotFoundException' => [ 'base' => '<p>The specified certificate does not exist.</p>', 'refs' => [], ], 'Cipher' => [ 'base' => '<p>Information about a cipher used in a policy.</p>', 'refs' => [ 'Ciphers$member' => NULL, ], ], 'CipherName' => [ 'base' => NULL, 'refs' => [ 'Cipher$Name' => '<p>The name of the cipher.</p>', ], ], 'CipherPriority' => [ 'base' => NULL, 'refs' => [ 'Cipher$Priority' => '<p>The priority of the cipher.</p>', ], ], 'Ciphers' => [ 'base' => NULL, 'refs' => [ 'SslPolicy$Ciphers' => '<p>The ciphers.</p>', ], ], 'ConditionFieldName' => [ 'base' => NULL, 'refs' => [ 'RuleCondition$Field' => '<p>The name of the field. The possible values are <code>host-header</code> and <code>path-pattern</code>.</p>', ], ], 'CreateListenerInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateListenerOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLoadBalancerInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLoadBalancerOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTargetGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTargetGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatedTime' => [ 'base' => NULL, 'refs' => [ 'LoadBalancer$CreatedTime' => '<p>The date and time the load balancer was created.</p>', ], ], 'DNSName' => [ 'base' => NULL, 'refs' => [ 'LoadBalancer$DNSName' => '<p>The public DNS name of the load balancer.</p>', ], ], 'DeleteListenerInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteListenerOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLoadBalancerInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLoadBalancerOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTargetGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTargetGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTargetsInput' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTargetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountLimitsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountLimitsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeListenersInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeListenersOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoadBalancerAttributesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoadBalancerAttributesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoadBalancersInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoadBalancersOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRulesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRulesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSSLPoliciesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSSLPoliciesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetGroupAttributesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetGroupAttributesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetHealthInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetHealthOutput' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'TargetHealth$Description' => '<p>A description of the target health that provides additional details. If the state is <code>healthy</code>, a description is not provided.</p>', ], ], 'DuplicateListenerException' => [ 'base' => '<p>A listener with the specified port already exists.</p>', 'refs' => [], ], 'DuplicateLoadBalancerNameException' => [ 'base' => '<p>A load balancer with the specified name already exists.</p>', 'refs' => [], ], 'DuplicateTagKeysException' => [ 'base' => '<p>A tag key was specified more than once.</p>', 'refs' => [], ], 'DuplicateTargetGroupNameException' => [ 'base' => '<p>A target group with the specified name already exists.</p>', 'refs' => [], ], 'HealthCheckIntervalSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$HealthCheckIntervalSeconds' => '<p>The approximate amount of time, in seconds, between health checks of an individual target. The default is 30 seconds.</p>', 'ModifyTargetGroupInput$HealthCheckIntervalSeconds' => '<p>The approximate amount of time, in seconds, between health checks of an individual target.</p>', 'TargetGroup$HealthCheckIntervalSeconds' => '<p>The approximate amount of time, in seconds, between health checks of an individual target.</p>', ], ], 'HealthCheckPort' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$HealthCheckPort' => '<p>The port the load balancer uses when performing health checks on targets. The default is <code>traffic-port</code>, which indicates the port on which each target receives traffic from the load balancer.</p>', 'ModifyTargetGroupInput$HealthCheckPort' => '<p>The port to use to connect with the target.</p>', 'TargetGroup$HealthCheckPort' => '<p>The port to use to connect with the target.</p>', 'TargetHealthDescription$HealthCheckPort' => '<p>The port to use to connect with the target.</p>', ], ], 'HealthCheckThresholdCount' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$HealthyThresholdCount' => '<p>The number of consecutive health checks successes required before considering an unhealthy target healthy. The default is 5.</p>', 'CreateTargetGroupInput$UnhealthyThresholdCount' => '<p>The number of consecutive health check failures required before considering a target unhealthy. The default is 2.</p>', 'ModifyTargetGroupInput$HealthyThresholdCount' => '<p>The number of consecutive health checks successes required before considering an unhealthy target healthy.</p>', 'ModifyTargetGroupInput$UnhealthyThresholdCount' => '<p>The number of consecutive health check failures required before considering the target unhealthy.</p>', 'TargetGroup$HealthyThresholdCount' => '<p>The number of consecutive health checks successes required before considering an unhealthy target healthy.</p>', 'TargetGroup$UnhealthyThresholdCount' => '<p>The number of consecutive health check failures required before considering the target unhealthy.</p>', ], ], 'HealthCheckTimeoutSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$HealthCheckTimeoutSeconds' => '<p>The amount of time, in seconds, during which no response from a target means a failed health check. The default is 5 seconds.</p>', 'ModifyTargetGroupInput$HealthCheckTimeoutSeconds' => '<p>The amount of time, in seconds, during which no response means a failed health check.</p>', 'TargetGroup$HealthCheckTimeoutSeconds' => '<p>The amount of time, in seconds, during which no response means a failed health check.</p>', ], ], 'HealthUnavailableException' => [ 'base' => '<p>The health of the specified targets could not be retrieved due to an internal error.</p>', 'refs' => [], ], 'HttpCode' => [ 'base' => NULL, 'refs' => [ 'Matcher$HttpCode' => '<p>The HTTP codes. You can specify values between 200 and 499. The default value is 200. You can specify multiple values (for example, "200,202") or a range of values (for example, "200-299").</p>', ], ], 'IncompatibleProtocolsException' => [ 'base' => '<p>The specified configuration is not valid with this protocol.</p>', 'refs' => [], ], 'InvalidConfigurationRequestException' => [ 'base' => '<p>The requested configuration is not valid.</p>', 'refs' => [], ], 'InvalidSchemeException' => [ 'base' => '<p>The requested scheme is not valid.</p>', 'refs' => [], ], 'InvalidSecurityGroupException' => [ 'base' => '<p>The specified security group does not exist.</p>', 'refs' => [], ], 'InvalidSubnetException' => [ 'base' => '<p>The specified subnet is out of available addresses.</p>', 'refs' => [], ], 'InvalidTargetException' => [ 'base' => '<p>The specified target does not exist or is not in the same VPC as the target group.</p>', 'refs' => [], ], 'IpAddressType' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerInput$IpAddressType' => '<p>The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). Internal load balancers must use <code>ipv4</code>.</p>', 'LoadBalancer$IpAddressType' => '<p>The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).</p>', 'SetIpAddressTypeInput$IpAddressType' => '<p>The IP address type. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). Internal load balancers must use <code>ipv4</code>.</p>', 'SetIpAddressTypeOutput$IpAddressType' => '<p>The IP address type.</p>', ], ], 'IsDefault' => [ 'base' => NULL, 'refs' => [ 'Rule$IsDefault' => '<p>Indicates whether this is the default rule.</p>', ], ], 'Limit' => [ 'base' => '<p>Information about an Elastic Load Balancing resource limit for your AWS account.</p>', 'refs' => [ 'Limits$member' => NULL, ], ], 'Limits' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsOutput$Limits' => '<p>Information about the limits.</p>', ], ], 'ListOfString' => [ 'base' => NULL, 'refs' => [ 'RuleCondition$Values' => '<p>The condition value.</p> <p>If the field name is <code>host-header</code>, you can specify a single host name (for example, my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain any of the following characters. Note that you can include up to three wildcard characters.</p> <ul> <li> <p>A-Z, a-z, 0-9</p> </li> <li> <p>- .</p> </li> <li> <p>* (matches 0 or more characters)</p> </li> <li> <p>? (matches exactly 1 character)</p> </li> </ul> <p>If the field name is <code>path-pattern</code>, you can specify a single path pattern (for example, /img/*). A path pattern is case sensitive, can be up to 128 characters in length, and can contain any of the following characters. Note that you can include up to three wildcard characters.</p> <ul> <li> <p>A-Z, a-z, 0-9</p> </li> <li> <p>_ - . $ / ~ " \' @ : +</p> </li> <li> <p>&amp; (using &amp;amp;)</p> </li> <li> <p>* (matches 0 or more characters)</p> </li> <li> <p>? (matches exactly 1 character)</p> </li> </ul>', ], ], 'Listener' => [ 'base' => '<p>Information about a listener.</p>', 'refs' => [ 'Listeners$member' => NULL, ], ], 'ListenerArn' => [ 'base' => NULL, 'refs' => [ 'CreateRuleInput$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'DeleteListenerInput$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'DescribeRulesInput$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'Listener$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'ListenerArns$member' => NULL, 'ModifyListenerInput$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', ], ], 'ListenerArns' => [ 'base' => NULL, 'refs' => [ 'DescribeListenersInput$ListenerArns' => '<p>The Amazon Resource Names (ARN) of the listeners.</p>', ], ], 'ListenerNotFoundException' => [ 'base' => '<p>The specified listener does not exist.</p>', 'refs' => [], ], 'Listeners' => [ 'base' => NULL, 'refs' => [ 'CreateListenerOutput$Listeners' => '<p>Information about the listener.</p>', 'DescribeListenersOutput$Listeners' => '<p>Information about the listeners.</p>', 'ModifyListenerOutput$Listeners' => '<p>Information about the modified listeners.</p>', ], ], 'LoadBalancer' => [ 'base' => '<p>Information about a load balancer.</p>', 'refs' => [ 'LoadBalancers$member' => NULL, ], ], 'LoadBalancerArn' => [ 'base' => NULL, 'refs' => [ 'CreateListenerInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'DeleteLoadBalancerInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'DescribeListenersInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'DescribeLoadBalancerAttributesInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'DescribeTargetGroupsInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'Listener$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'LoadBalancer$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'LoadBalancerArns$member' => NULL, 'ModifyLoadBalancerAttributesInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'SetIpAddressTypeInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'SetSecurityGroupsInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'SetSubnetsInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', ], ], 'LoadBalancerArns' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBalancersInput$LoadBalancerArns' => '<p>The Amazon Resource Names (ARN) of the load balancers. You can specify up to 20 load balancers in a single call.</p>', 'TargetGroup$LoadBalancerArns' => '<p>The Amazon Resource Names (ARN) of the load balancers that route traffic to this target group.</p>', ], ], 'LoadBalancerAttribute' => [ 'base' => '<p>Information about a load balancer attribute.</p>', 'refs' => [ 'LoadBalancerAttributes$member' => NULL, ], ], 'LoadBalancerAttributeKey' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerAttribute$Key' => '<p>The name of the attribute.</p> <ul> <li> <p> <code>access_logs.s3.enabled</code> - Indicates whether access logs stored in Amazon S3 are enabled. The value is <code>true</code> or <code>false</code>.</p> </li> <li> <p> <code>access_logs.s3.bucket</code> - The name of the S3 bucket for the access logs. This attribute is required if access logs in Amazon S3 are enabled. The bucket must exist in the same region as the load balancer and have a bucket policy that grants Elastic Load Balancing permission to write to the bucket.</p> </li> <li> <p> <code>access_logs.s3.prefix</code> - The prefix for the location in the S3 bucket. If you don\'t specify a prefix, the access logs are stored in the root of the bucket.</p> </li> <li> <p> <code>deletion_protection.enabled</code> - Indicates whether deletion protection is enabled. The value is <code>true</code> or <code>false</code>.</p> </li> <li> <p> <code>idle_timeout.timeout_seconds</code> - The idle timeout value, in seconds. The valid range is 1-3600. The default is 60 seconds.</p> </li> </ul>', ], ], 'LoadBalancerAttributeValue' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerAttribute$Value' => '<p>The value of the attribute.</p>', ], ], 'LoadBalancerAttributes' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBalancerAttributesOutput$Attributes' => '<p>Information about the load balancer attributes.</p>', 'ModifyLoadBalancerAttributesInput$Attributes' => '<p>The load balancer attributes.</p>', 'ModifyLoadBalancerAttributesOutput$Attributes' => '<p>Information about the load balancer attributes.</p>', ], ], 'LoadBalancerName' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerInput$Name' => '<p>The name of the load balancer.</p> <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.</p>', 'LoadBalancer$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'LoadBalancerNames$member' => NULL, ], ], 'LoadBalancerNames' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBalancersInput$Names' => '<p>The names of the load balancers.</p>', ], ], 'LoadBalancerNotFoundException' => [ 'base' => '<p>The specified load balancer does not exist.</p>', 'refs' => [], ], 'LoadBalancerSchemeEnum' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerInput$Scheme' => '<p>The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the Internet.</p> <p>The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can only route requests from clients with access to the VPC for the load balancer.</p> <p>The default is an Internet-facing load balancer.</p>', 'LoadBalancer$Scheme' => '<p>The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the Internet.</p> <p>The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can only route requests from clients with access to the VPC for the load balancer.</p>', ], ], 'LoadBalancerState' => [ 'base' => '<p>Information about the state of the load balancer.</p>', 'refs' => [ 'LoadBalancer$State' => '<p>The state of the load balancer.</p>', ], ], 'LoadBalancerStateEnum' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerState$Code' => '<p>The state code. The initial state of the load balancer is <code>provisioning</code>. After the load balancer is fully set up and ready to route traffic, its state is <code>active</code>. If the load balancer could not be set up, its state is <code>failed</code>.</p>', ], ], 'LoadBalancerTypeEnum' => [ 'base' => NULL, 'refs' => [ 'LoadBalancer$Type' => '<p>The type of load balancer.</p>', ], ], 'LoadBalancers' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerOutput$LoadBalancers' => '<p>Information about the load balancer.</p>', 'DescribeLoadBalancersOutput$LoadBalancers' => '<p>Information about the load balancers.</p>', ], ], 'Marker' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeAccountLimitsOutput$NextMarker' => '<p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>', 'DescribeListenersInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeListenersOutput$NextMarker' => '<p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>', 'DescribeLoadBalancersInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeLoadBalancersOutput$NextMarker' => '<p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>', 'DescribeRulesInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeRulesOutput$NextMarker' => '<p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>', 'DescribeSSLPoliciesInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeSSLPoliciesOutput$NextMarker' => '<p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>', 'DescribeTargetGroupsInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeTargetGroupsOutput$NextMarker' => '<p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>', ], ], 'Matcher' => [ 'base' => '<p>Information to use when checking for a successful response from a target.</p>', 'refs' => [ 'CreateTargetGroupInput$Matcher' => '<p>The HTTP codes to use when checking for a successful response from a target. The default is 200.</p>', 'ModifyTargetGroupInput$Matcher' => '<p>The HTTP codes to use when checking for a successful response from a target.</p>', 'TargetGroup$Matcher' => '<p>The HTTP codes to use when checking for a successful response from a target.</p>', ], ], 'Max' => [ 'base' => NULL, 'refs' => [ 'Limit$Max' => '<p>The maximum value of the limit.</p>', ], ], 'ModifyListenerInput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyListenerOutput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyLoadBalancerAttributesInput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyLoadBalancerAttributesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTargetGroupAttributesInput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTargetGroupAttributesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTargetGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTargetGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'Limit$Name' => '<p>The name of the limit. The possible values are:</p> <ul> <li> <p>application-load-balancers</p> </li> <li> <p>listeners-per-application-load-balancer</p> </li> <li> <p>rules-per-application-load-balancer</p> </li> <li> <p>target-groups</p> </li> <li> <p>targets-per-application-load-balancer</p> </li> </ul>', ], ], 'OperationNotPermittedException' => [ 'base' => '<p>This operation is not allowed.</p>', 'refs' => [], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeListenersInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeLoadBalancersInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeRulesInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeSSLPoliciesInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeTargetGroupsInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', ], ], 'Path' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$HealthCheckPath' => '<p>The ping path that is the destination on the targets for health checks. The default is /.</p>', 'ModifyTargetGroupInput$HealthCheckPath' => '<p>The ping path that is the destination for the health check request.</p>', 'TargetGroup$HealthCheckPath' => '<p>The destination for the health check request.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'CreateListenerInput$Port' => '<p>The port on which the load balancer is listening.</p>', 'CreateTargetGroupInput$Port' => '<p>The port on which the targets receive traffic. This port is used unless you specify a port override when registering the target.</p>', 'Listener$Port' => '<p>The port on which the load balancer is listening.</p>', 'ModifyListenerInput$Port' => '<p>The port for connections from clients to the load balancer.</p>', 'TargetDescription$Port' => '<p>The port on which the target is listening.</p>', 'TargetGroup$Port' => '<p>The port on which the targets are listening.</p>', ], ], 'PriorityInUseException' => [ 'base' => '<p>The specified priority is in use.</p>', 'refs' => [], ], 'ProtocolEnum' => [ 'base' => NULL, 'refs' => [ 'CreateListenerInput$Protocol' => '<p>The protocol for connections from clients to the load balancer.</p>', 'CreateTargetGroupInput$Protocol' => '<p>The protocol to use for routing traffic to the targets.</p>', 'CreateTargetGroupInput$HealthCheckProtocol' => '<p>The protocol the load balancer uses when performing health checks on targets. The default is the HTTP protocol.</p>', 'Listener$Protocol' => '<p>The protocol for connections from clients to the load balancer.</p>', 'ModifyListenerInput$Protocol' => '<p>The protocol for connections from clients to the load balancer.</p>', 'ModifyTargetGroupInput$HealthCheckProtocol' => '<p>The protocol to use to connect with the target.</p>', 'TargetGroup$Protocol' => '<p>The protocol to use for routing traffic to the targets.</p>', 'TargetGroup$HealthCheckProtocol' => '<p>The protocol to use to connect with the target.</p>', ], ], 'RegisterTargetsInput' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTargetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ResourceArns$member' => NULL, 'TagDescription$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'ResourceArns' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$ResourceArns' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DescribeTagsInput$ResourceArns' => '<p>The Amazon Resource Names (ARN) of the resources.</p>', 'RemoveTagsInput$ResourceArns' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>A specified resource is in use.</p>', 'refs' => [], ], 'Rule' => [ 'base' => '<p>Information about a rule.</p>', 'refs' => [ 'Rules$member' => NULL, ], ], 'RuleArn' => [ 'base' => NULL, 'refs' => [ 'DeleteRuleInput$RuleArn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', 'ModifyRuleInput$RuleArn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', 'Rule$RuleArn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', 'RuleArns$member' => NULL, 'RulePriorityPair$RuleArn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', ], ], 'RuleArns' => [ 'base' => NULL, 'refs' => [ 'DescribeRulesInput$RuleArns' => '<p>The Amazon Resource Names (ARN) of the rules.</p>', ], ], 'RuleCondition' => [ 'base' => '<p>Information about a condition for a rule.</p>', 'refs' => [ 'RuleConditionList$member' => NULL, ], ], 'RuleConditionList' => [ 'base' => NULL, 'refs' => [ 'CreateRuleInput$Conditions' => '<p>A condition. Each condition specifies a field name and a single value.</p> <p>If the field name is <code>host-header</code>, you can specify a single host name (for example, my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain any of the following characters. Note that you can include up to three wildcard characters.</p> <ul> <li> <p>A-Z, a-z, 0-9</p> </li> <li> <p>- .</p> </li> <li> <p>* (matches 0 or more characters)</p> </li> <li> <p>? (matches exactly 1 character)</p> </li> </ul> <p>If the field name is <code>path-pattern</code>, you can specify a single path pattern. A path pattern is case sensitive, can be up to 128 characters in length, and can contain any of the following characters. Note that you can include up to three wildcard characters.</p> <ul> <li> <p>A-Z, a-z, 0-9</p> </li> <li> <p>_ - . $ / ~ " \' @ : +</p> </li> <li> <p>&amp; (using &amp;amp;)</p> </li> <li> <p>* (matches 0 or more characters)</p> </li> <li> <p>? (matches exactly 1 character)</p> </li> </ul>', 'ModifyRuleInput$Conditions' => '<p>The conditions.</p>', 'Rule$Conditions' => '<p>The conditions.</p>', ], ], 'RuleNotFoundException' => [ 'base' => '<p>The specified rule does not exist.</p>', 'refs' => [], ], 'RulePriority' => [ 'base' => NULL, 'refs' => [ 'CreateRuleInput$Priority' => '<p>The priority for the rule. A listener can\'t have multiple rules with the same priority.</p>', 'RulePriorityPair$Priority' => '<p>The rule priority.</p>', ], ], 'RulePriorityList' => [ 'base' => NULL, 'refs' => [ 'SetRulePrioritiesInput$RulePriorities' => '<p>The rule priorities.</p>', ], ], 'RulePriorityPair' => [ 'base' => '<p>Information about the priorities for the rules for a listener.</p>', 'refs' => [ 'RulePriorityList$member' => NULL, ], ], 'Rules' => [ 'base' => NULL, 'refs' => [ 'CreateRuleOutput$Rules' => '<p>Information about the rule.</p>', 'DescribeRulesOutput$Rules' => '<p>Information about the rules.</p>', 'ModifyRuleOutput$Rules' => '<p>Information about the rule.</p>', 'SetRulePrioritiesOutput$Rules' => '<p>Information about the rules.</p>', ], ], 'SSLPolicyNotFoundException' => [ 'base' => '<p>The specified SSL policy does not exist.</p>', 'refs' => [], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroups$member' => NULL, ], ], 'SecurityGroups' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerInput$SecurityGroups' => '<p>The IDs of the security groups to assign to the load balancer.</p>', 'LoadBalancer$SecurityGroups' => '<p>The IDs of the security groups for the load balancer.</p>', 'SetSecurityGroupsInput$SecurityGroups' => '<p>The IDs of the security groups.</p>', 'SetSecurityGroupsOutput$SecurityGroupIds' => '<p>The IDs of the security groups associated with the load balancer.</p>', ], ], 'SetIpAddressTypeInput' => [ 'base' => NULL, 'refs' => [], ], 'SetIpAddressTypeOutput' => [ 'base' => NULL, 'refs' => [], ], 'SetRulePrioritiesInput' => [ 'base' => NULL, 'refs' => [], ], 'SetRulePrioritiesOutput' => [ 'base' => NULL, 'refs' => [], ], 'SetSecurityGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'SetSecurityGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'SetSubnetsInput' => [ 'base' => NULL, 'refs' => [], ], 'SetSubnetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'SslPolicies' => [ 'base' => NULL, 'refs' => [ 'DescribeSSLPoliciesOutput$SslPolicies' => '<p>Information about the policies.</p>', ], ], 'SslPolicy' => [ 'base' => '<p>Information about a policy used for SSL negotiation.</p>', 'refs' => [ 'SslPolicies$member' => NULL, ], ], 'SslPolicyName' => [ 'base' => NULL, 'refs' => [ 'CreateListenerInput$SslPolicy' => '<p>The security policy that defines which ciphers and protocols are supported. The default is the current predefined security policy.</p>', 'Listener$SslPolicy' => '<p>The security policy that defines which ciphers and protocols are supported. The default is the current predefined security policy.</p>', 'ModifyListenerInput$SslPolicy' => '<p>The security policy that defines which protocols and ciphers are supported. For more information, see <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security Policies</a> in the <i>Application Load Balancers Guide</i>.</p>', 'SslPolicy$Name' => '<p>The name of the policy.</p>', 'SslPolicyNames$member' => NULL, ], ], 'SslPolicyNames' => [ 'base' => NULL, 'refs' => [ 'DescribeSSLPoliciesInput$Names' => '<p>The names of the policies.</p>', ], ], 'SslProtocol' => [ 'base' => NULL, 'refs' => [ 'SslProtocols$member' => NULL, ], ], 'SslProtocols' => [ 'base' => NULL, 'refs' => [ 'SslPolicy$SslProtocols' => '<p>The protocols.</p>', ], ], 'StateReason' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerState$Reason' => '<p>A description of the state.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'Rule$Priority' => '<p>The priority.</p>', ], ], 'StringValue' => [ 'base' => NULL, 'refs' => [ 'ListOfString$member' => NULL, ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$SubnetId' => '<p>The ID of the subnet.</p>', 'Subnets$member' => NULL, ], ], 'SubnetNotFoundException' => [ 'base' => '<p>The specified subnet does not exist.</p>', 'refs' => [], ], 'Subnets' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerInput$Subnets' => '<p>The IDs of the subnets to attach to the load balancer. You can specify only one subnet per Availability Zone. You must specify subnets from at least two Availability Zones.</p>', 'SetSubnetsInput$Subnets' => '<p>The IDs of the subnets. You must specify at least two subnets. You can add only one subnet per Availability Zone.</p>', ], ], 'Tag' => [ 'base' => '<p>Information about a tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagDescription' => [ 'base' => '<p>The tags associated with a resource.</p>', 'refs' => [ 'TagDescriptions$member' => NULL, ], ], 'TagDescriptions' => [ 'base' => NULL, 'refs' => [ 'DescribeTagsOutput$TagDescriptions' => '<p>Information about the tags.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the tag.</p>', 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsInput$TagKeys' => '<p>The tag keys for the tags to remove.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$Tags' => '<p>The tags. Each resource can have a maximum of 10 tags.</p>', 'CreateLoadBalancerInput$Tags' => '<p>One or more tags to assign to the load balancer.</p>', 'TagDescription$Tags' => '<p>Information about the tags.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'TargetDescription' => [ 'base' => '<p>Information about a target.</p>', 'refs' => [ 'TargetDescriptions$member' => NULL, 'TargetHealthDescription$Target' => '<p>The description of the target.</p>', ], ], 'TargetDescriptions' => [ 'base' => NULL, 'refs' => [ 'DeregisterTargetsInput$Targets' => '<p>The targets. If you specified a port override when you registered a target, you must specify both the target ID and the port when you deregister it.</p>', 'DescribeTargetHealthInput$Targets' => '<p>The targets.</p>', 'RegisterTargetsInput$Targets' => '<p>The targets. The default port for a target is the port for the target group. You can specify a port override. If a target is already registered, you can register it again using a different port.</p>', ], ], 'TargetGroup' => [ 'base' => '<p>Information about a target group.</p>', 'refs' => [ 'TargetGroups$member' => NULL, ], ], 'TargetGroupArn' => [ 'base' => NULL, 'refs' => [ 'Action$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'DeleteTargetGroupInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'DeregisterTargetsInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'DescribeTargetGroupAttributesInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'DescribeTargetHealthInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'ModifyTargetGroupAttributesInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'ModifyTargetGroupInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'RegisterTargetsInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'TargetGroup$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'TargetGroupArns$member' => NULL, ], ], 'TargetGroupArns' => [ 'base' => NULL, 'refs' => [ 'DescribeTargetGroupsInput$TargetGroupArns' => '<p>The Amazon Resource Names (ARN) of the target groups.</p>', ], ], 'TargetGroupAssociationLimitException' => [ 'base' => '<p>You\'ve reached the limit on the number of load balancers per target group.</p>', 'refs' => [], ], 'TargetGroupAttribute' => [ 'base' => '<p>Information about a target group attribute.</p>', 'refs' => [ 'TargetGroupAttributes$member' => NULL, ], ], 'TargetGroupAttributeKey' => [ 'base' => NULL, 'refs' => [ 'TargetGroupAttribute$Key' => '<p>The name of the attribute.</p> <ul> <li> <p> <code>deregistration_delay.timeout_seconds</code> - The amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from <code>draining</code> to <code>unused</code>. The range is 0-3600 seconds. The default value is 300 seconds.</p> </li> <li> <p> <code>stickiness.enabled</code> - Indicates whether sticky sessions are enabled. The value is <code>true</code> or <code>false</code>.</p> </li> <li> <p> <code>stickiness.type</code> - The type of sticky sessions. The possible value is <code>lb_cookie</code>.</p> </li> <li> <p> <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).</p> </li> </ul>', ], ], 'TargetGroupAttributeValue' => [ 'base' => NULL, 'refs' => [ 'TargetGroupAttribute$Value' => '<p>The value of the attribute.</p>', ], ], 'TargetGroupAttributes' => [ 'base' => NULL, 'refs' => [ 'DescribeTargetGroupAttributesOutput$Attributes' => '<p>Information about the target group attributes</p>', 'ModifyTargetGroupAttributesInput$Attributes' => '<p>The attributes.</p>', 'ModifyTargetGroupAttributesOutput$Attributes' => '<p>Information about the attributes.</p>', ], ], 'TargetGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$Name' => '<p>The name of the target group.</p> <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.</p>', 'TargetGroup$TargetGroupName' => '<p>The name of the target group.</p>', 'TargetGroupNames$member' => NULL, ], ], 'TargetGroupNames' => [ 'base' => NULL, 'refs' => [ 'DescribeTargetGroupsInput$Names' => '<p>The names of the target groups.</p>', ], ], 'TargetGroupNotFoundException' => [ 'base' => '<p>The specified target group does not exist.</p>', 'refs' => [], ], 'TargetGroups' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupOutput$TargetGroups' => '<p>Information about the target group.</p>', 'DescribeTargetGroupsOutput$TargetGroups' => '<p>Information about the target groups.</p>', 'ModifyTargetGroupOutput$TargetGroups' => '<p>Information about the target group.</p>', ], ], 'TargetHealth' => [ 'base' => '<p>Information about the current health of a target.</p>', 'refs' => [ 'TargetHealthDescription$TargetHealth' => '<p>The health information for the target.</p>', ], ], 'TargetHealthDescription' => [ 'base' => '<p>Information about the health of a target.</p>', 'refs' => [ 'TargetHealthDescriptions$member' => NULL, ], ], 'TargetHealthDescriptions' => [ 'base' => NULL, 'refs' => [ 'DescribeTargetHealthOutput$TargetHealthDescriptions' => '<p>Information about the health of the targets.</p>', ], ], 'TargetHealthReasonEnum' => [ 'base' => NULL, 'refs' => [ 'TargetHealth$Reason' => '<p>The reason code. If the target state is <code>healthy</code>, a reason code is not provided.</p> <p>If the target state is <code>initial</code>, the reason code can be one of the following values:</p> <ul> <li> <p> <code>Elb.RegistrationInProgress</code> - The target is in the process of being registered with the load balancer.</p> </li> <li> <p> <code>Elb.InitialHealthChecking</code> - The load balancer is still sending the target the minimum number of health checks required to determine its health status.</p> </li> </ul> <p>If the target state is <code>unhealthy</code>, the reason code can be one of the following values:</p> <ul> <li> <p> <code>Target.ResponseCodeMismatch</code> - The health checks did not return an expected HTTP code.</p> </li> <li> <p> <code>Target.Timeout</code> - The health check requests timed out.</p> </li> <li> <p> <code>Target.FailedHealthChecks</code> - The health checks failed because the connection to the target timed out, the target response was malformed, or the target failed the health check for an unknown reason.</p> </li> <li> <p> <code>Elb.InternalError</code> - The health checks failed due to an internal error.</p> </li> </ul> <p>If the target state is <code>unused</code>, the reason code can be one of the following values:</p> <ul> <li> <p> <code>Target.NotRegistered</code> - The target is not registered with the target group.</p> </li> <li> <p> <code>Target.NotInUse</code> - The target group is not used by any load balancer or the target is in an Availability Zone that is not enabled for its load balancer.</p> </li> <li> <p> <code>Target.InvalidState</code> - The target is in the stopped or terminated state.</p> </li> </ul> <p>If the target state is <code>draining</code>, the reason code can be the following value:</p> <ul> <li> <p> <code>Target.DeregistrationInProgress</code> - The target is in the process of being deregistered and the deregistration delay period has not expired.</p> </li> </ul>', ], ], 'TargetHealthStateEnum' => [ 'base' => NULL, 'refs' => [ 'TargetHealth$State' => '<p>The state of the target.</p>', ], ], 'TargetId' => [ 'base' => NULL, 'refs' => [ 'TargetDescription$Id' => '<p>The ID of the target.</p>', ], ], 'TooManyCertificatesException' => [ 'base' => '<p>You\'ve reached the limit on the number of certificates per listener.</p>', 'refs' => [], ], 'TooManyListenersException' => [ 'base' => '<p>You\'ve reached the limit on the number of listeners per load balancer.</p>', 'refs' => [], ], 'TooManyLoadBalancersException' => [ 'base' => '<p>You\'ve reached the limit on the number of load balancers for your AWS account.</p>', 'refs' => [], ], 'TooManyRegistrationsForTargetIdException' => [ 'base' => '<p>You\'ve reached the limit on the number of times a target can be registered with a load balancer.</p>', 'refs' => [], ], 'TooManyRulesException' => [ 'base' => '<p>You\'ve reached the limit on the number of rules per load balancer.</p>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>You\'ve reached the limit on the number of tags per load balancer.</p>', 'refs' => [], ], 'TooManyTargetGroupsException' => [ 'base' => '<p>You\'ve reached the limit on the number of target groups for your AWS account.</p>', 'refs' => [], ], 'TooManyTargetsException' => [ 'base' => '<p>You\'ve reached the limit on the number of targets.</p>', 'refs' => [], ], 'UnsupportedProtocolException' => [ 'base' => '<p>The specified protocol is not supported.</p>', 'refs' => [], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$VpcId' => '<p>The identifier of the virtual private cloud (VPC).</p>', 'LoadBalancer$VpcId' => '<p>The ID of the VPC for the load balancer.</p>', 'TargetGroup$VpcId' => '<p>The ID of the VPC for the targets.</p>', ], ], 'ZoneName' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$ZoneName' => '<p>The name of the Availability Zone.</p>', ], ], ],];
