<?php
// This file was auto-generated from sdk-root/src/data/email/2010-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Simple Email Service</fullname> <p> This is the API Reference for Amazon Simple Email Service (Amazon SES). This documentation is intended to be used in conjunction with the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/Welcome.html">Amazon SES Developer Guide</a>. </p> <note> <p> For a list of Amazon SES endpoints to use in service requests, see <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/regions.html">Regions and Amazon SES</a> in the Amazon SES Developer Guide. </p> </note>', 'operations' => [ 'CloneReceiptRuleSet' => '<p>Creates a receipt rule set by cloning an existing one. All receipt rules and configurations are copied to the new receipt rule set and are completely independent of the source rule set.</p> <p>For information about setting up rule sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'CreateConfigurationSet' => '<p>Creates a configuration set.</p> <p>Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'CreateConfigurationSetEventDestination' => '<p>Creates a configuration set event destination.</p> <note> <p>When you create or update an event destination, you must provide one, and only one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).</p> </note> <p>An event destination is the AWS service to which Amazon SES publishes the email sending events associated with a configuration set. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'CreateReceiptFilter' => '<p>Creates a new IP address filter.</p> <p>For information about setting up IP address filters, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'CreateReceiptRule' => '<p>Creates a receipt rule.</p> <p>For information about setting up receipt rules, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'CreateReceiptRuleSet' => '<p>Creates an empty receipt rule set.</p> <p>For information about setting up receipt rule sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'DeleteConfigurationSet' => '<p>Deletes a configuration set.</p> <p>Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'DeleteConfigurationSetEventDestination' => '<p>Deletes a configuration set event destination.</p> <p>Configuration set event destinations are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'DeleteIdentity' => '<p>Deletes the specified identity (an email address or a domain) from the list of verified identities.</p> <p>This action is throttled at one request per second.</p>', 'DeleteIdentityPolicy' => '<p>Deletes the specified sending authorization policy for the given identity (an email address or a domain). This API returns successfully even if a policy with the specified name does not exist.</p> <note> <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p> </note> <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'DeleteReceiptFilter' => '<p>Deletes the specified IP address filter.</p> <p>For information about managing IP address filters, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'DeleteReceiptRule' => '<p>Deletes the specified receipt rule.</p> <p>For information about managing receipt rules, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'DeleteReceiptRuleSet' => '<p>Deletes the specified receipt rule set and all of the receipt rules it contains.</p> <note> <p>The currently active rule set cannot be deleted.</p> </note> <p>For information about managing receipt rule sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'DeleteVerifiedEmailAddress' => '<p>Deletes the specified email address from the list of verified addresses.</p> <important> <p>The DeleteVerifiedEmailAddress action is deprecated as of the May 15, 2012 release of Domain Verification. The DeleteIdentity action is now preferred.</p> </important> <p>This action is throttled at one request per second.</p>', 'DescribeActiveReceiptRuleSet' => '<p>Returns the metadata and receipt rules for the receipt rule set that is currently active.</p> <p>For information about setting up receipt rule sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'DescribeConfigurationSet' => '<p>Returns the details of the specified configuration set.</p> <p>Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'DescribeReceiptRule' => '<p>Returns the details of the specified receipt rule.</p> <p>For information about setting up receipt rules, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'DescribeReceiptRuleSet' => '<p>Returns the details of the specified receipt rule set.</p> <p>For information about managing receipt rule sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'GetIdentityDkimAttributes' => '<p>Returns the current status of Easy DKIM signing for an entity. For domain name identities, this action also returns the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES has successfully verified that these tokens have been published.</p> <p>This action takes a list of identities as input and returns the following information for each:</p> <ul> <li> <p>Whether Easy DKIM signing is enabled or disabled.</p> </li> <li> <p>A set of DKIM tokens that represent the identity. If the identity is an email address, the tokens represent the domain of that address.</p> </li> <li> <p>Whether Amazon SES has successfully verified the DKIM tokens published in the domain\'s DNS. This information is only returned for domain name identities, not for email addresses.</p> </li> </ul> <p>This action is throttled at one request per second and can only get DKIM attributes for up to 100 identities at a time.</p> <p>For more information about creating DNS records using DKIM tokens, go to the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer Guide</a>.</p>', 'GetIdentityMailFromDomainAttributes' => '<p>Returns the custom MAIL FROM attributes for a list of identities (email addresses and/or domains).</p> <p>This action is throttled at one request per second and can only get custom MAIL FROM attributes for up to 100 identities at a time.</p>', 'GetIdentityNotificationAttributes' => '<p>Given a list of verified identities (email addresses and/or domains), returns a structure describing identity notification attributes.</p> <p>This action is throttled at one request per second and can only get notification attributes for up to 100 identities at a time.</p> <p>For more information about using notifications with Amazon SES, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.</p>', 'GetIdentityPolicies' => '<p>Returns the requested sending authorization policies for the given identity (an email address or a domain). The policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a time.</p> <note> <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p> </note> <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'GetIdentityVerificationAttributes' => '<p>Given a list of identities (email addresses and/or domains), returns the verification status and (for domain identities) the verification token for each identity.</p> <p>The verification status of an email address is "Pending" until the email address owner clicks the link within the verification email that Amazon SES sent to that address. If the email address owner clicks the link within 24 hours, the verification status of the email address changes to "Success". If the link is not clicked within 24 hours, the verification status changes to "Failed." In that case, if you still want to verify the email address, you must restart the verification process from the beginning.</p> <p>For domain identities, the domain\'s verification status is "Pending" as Amazon SES searches for the required TXT record in the DNS settings of the domain. When Amazon SES detects the record, the domain\'s verification status changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain\'s verification status changes to "Failed." In that case, if you still want to verify the domain, you must restart the verification process from the beginning.</p> <p>This action is throttled at one request per second and can only get verification attributes for up to 100 identities at a time.</p>', 'GetSendQuota' => '<p>Returns the user\'s current sending limits.</p> <p>This action is throttled at one request per second.</p>', 'GetSendStatistics' => '<p>Returns the user\'s sending statistics. The result is a list of data points, representing the last two weeks of sending activity.</p> <p>Each data point in the list contains statistics for a 15-minute interval.</p> <p>This action is throttled at one request per second.</p>', 'ListConfigurationSets' => '<p>Lists the configuration sets associated with your AWS account.</p> <p>Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second and can return up to 50 configuration sets at a time.</p>', 'ListIdentities' => '<p>Returns a list containing all of the identities (email addresses and domains) for your AWS account, regardless of verification status.</p> <p>This action is throttled at one request per second.</p>', 'ListIdentityPolicies' => '<p>Returns a list of sending authorization policies that are attached to the given identity (an email address or a domain). This API returns only a list. If you want the actual policy content, you can use <code>GetIdentityPolicies</code>.</p> <note> <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p> </note> <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'ListReceiptFilters' => '<p>Lists the IP address filters associated with your AWS account.</p> <p>For information about managing IP address filters, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'ListReceiptRuleSets' => '<p>Lists the receipt rule sets that exist under your AWS account. If there are additional receipt rule sets to be retrieved, you will receive a <code>NextToken</code> that you can provide to the next call to <code>ListReceiptRuleSets</code> to retrieve the additional entries.</p> <p>For information about managing receipt rule sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'ListVerifiedEmailAddresses' => '<p>Returns a list containing all of the email addresses that have been verified.</p> <important> <p>The ListVerifiedEmailAddresses action is deprecated as of the May 15, 2012 release of Domain Verification. The ListIdentities action is now preferred.</p> </important> <p>This action is throttled at one request per second.</p>', 'PutIdentityPolicy' => '<p>Adds or updates a sending authorization policy for the specified identity (an email address or a domain).</p> <note> <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p> </note> <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'ReorderReceiptRuleSet' => '<p>Reorders the receipt rules within a receipt rule set.</p> <note> <p>All of the rules in the rule set must be represented in this request. That is, this API will return an error if the reorder request doesn\'t explicitly position all of the rules.</p> </note> <p>For information about managing receipt rule sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'SendBounce' => '<p>Generates and sends a bounce message to the sender of an email you received through Amazon SES. You can only use this API on an email up to 24 hours after you receive it.</p> <note> <p>You cannot use this API to send generic bounces for mail that was not received by Amazon SES.</p> </note> <p>For information about receiving email through Amazon SES, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'SendEmail' => '<p>Composes an email message based on input data, and then immediately queues the message for sending.</p> <p>There are several important points to know about <code>SendEmail</code>:</p> <ul> <li> <p>You can only send email from verified email addresses and domains; otherwise, you will get an "Email address not verified" error. If your account is still in the Amazon SES sandbox, you must also verify every recipient email address except for the recipients provided by the Amazon SES mailbox simulator. For more information, go to the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer Guide</a>.</p> </li> <li> <p>The total size of the message cannot exceed 10 MB. This includes any attachments that are part of the message.</p> </li> <li> <p>You must provide at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If any email address you provide is invalid, Amazon SES rejects the entire email.</p> </li> <li> <p>Amazon SES has a limit on the total number of recipients per message. The combined number of To:, CC: and BCC: email addresses cannot exceed 50. If you need to send an email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call Amazon SES repeatedly to send the message to each group.</p> </li> <li> <p>For every message that you send, the total number of recipients (To:, CC: and BCC:) is counted against your sending quota - the maximum number of emails you can send in a 24-hour period. For information about your sending quota, go to the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Amazon SES Developer Guide</a>.</p> </li> </ul>', 'SendRawEmail' => '<p>Sends an email message, with header and content specified by the client. The <code>SendRawEmail</code> action is useful for sending multipart MIME emails. The raw text of the message must comply with Internet email standards; otherwise, the message cannot be sent. </p> <p>There are several important points to know about <code>SendRawEmail</code>:</p> <ul> <li> <p>You can only send email from verified email addresses and domains; otherwise, you will get an "Email address not verified" error. If your account is still in the Amazon SES sandbox, you must also verify every recipient email address except for the recipients provided by the Amazon SES mailbox simulator. For more information, go to the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer Guide</a>.</p> </li> <li> <p>The total size of the message cannot exceed 10 MB. This includes any attachments that are part of the message.</p> </li> <li> <p>You must provide at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If any email address you provide is invalid, Amazon SES rejects the entire email.</p> </li> <li> <p>Amazon SES has a limit on the total number of recipients per message. The combined number of To:, CC: and BCC: email addresses cannot exceed 50. If you need to send an email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call Amazon SES repeatedly to send the message to each group.</p> </li> <li> <p>The To:, CC:, and BCC: headers in the raw message can contain a group list. Note that each recipient in a group list counts towards the 50-recipient limit.</p> </li> <li> <p>Amazon SES overrides any Message-ID and Date headers you provide.</p> </li> <li> <p>For every message that you send, the total number of recipients (To:, CC: and BCC:) is counted against your sending quota - the maximum number of emails you can send in a 24-hour period. For information about your sending quota, go to the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Amazon SES Developer Guide</a>.</p> </li> <li> <p>If you are using sending authorization to send on behalf of another user, <code>SendRawEmail</code> enables you to specify the cross-account identity for the email\'s "Source," "From," and "Return-Path" parameters in one of two ways: you can pass optional parameters <code>SourceArn</code>, <code>FromArn</code>, and/or <code>ReturnPathArn</code> to the API, or you can include the following X-headers in the header of your raw email:</p> <ul> <li> <p> <code>X-SES-SOURCE-ARN</code> </p> </li> <li> <p> <code>X-SES-FROM-ARN</code> </p> </li> <li> <p> <code>X-SES-RETURN-PATH-ARN</code> </p> </li> </ul> <important> <p>Do not include these X-headers in the DKIM signature, because they are removed by Amazon SES before sending the email.</p> </important> <p>For the most common sending authorization use case, we recommend that you specify the <code>SourceIdentityArn</code> and do not specify either the <code>FromIdentityArn</code> or <code>ReturnPathIdentityArn</code>. (The same note applies to the corresponding X-headers.) If you only specify the <code>SourceIdentityArn</code>, Amazon SES will simply set the "From" address and the "Return Path" address to the identity specified in <code>SourceIdentityArn</code>. For more information about sending authorization, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> </li> </ul>', 'SetActiveReceiptRuleSet' => '<p>Sets the specified receipt rule set as the active receipt rule set.</p> <note> <p>To disable your email-receiving through Amazon SES completely, you can call this API with RuleSetName set to null.</p> </note> <p>For information about managing receipt rule sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'SetIdentityDkimEnabled' => '<p>Enables or disables Easy DKIM signing of email sent from an identity:</p> <ul> <li> <p>If Easy DKIM signing is enabled for a domain name identity (e.g., <code>example.com</code>), then Amazon SES will DKIM-sign all email sent by addresses under that domain name (e.g., <code>user@example.com</code>).</p> </li> <li> <p>If Easy DKIM signing is enabled for an email address, then Amazon SES will DKIM-sign all email sent by that email address.</p> </li> </ul> <p>For email addresses (e.g., <code>user@example.com</code>), you can only enable Easy DKIM signing if the corresponding domain (e.g., <code>example.com</code>) has been set up for Easy DKIM using the AWS Console or the <code>VerifyDomainDkim</code> action.</p> <p>This action is throttled at one request per second.</p> <p>For more information about Easy DKIM signing, go to the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.</p>', 'SetIdentityFeedbackForwardingEnabled' => '<p>Given an identity (an email address or a domain), enables or disables whether Amazon SES forwards bounce and complaint notifications as email. Feedback forwarding can only be disabled when Amazon Simple Notification Service (Amazon SNS) topics are specified for both bounces and complaints.</p> <note> <p>Feedback forwarding does not apply to delivery notifications. Delivery notifications are only available through Amazon SNS.</p> </note> <p>This action is throttled at one request per second.</p> <p>For more information about using notifications with Amazon SES, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.</p>', 'SetIdentityHeadersInNotificationsEnabled' => '<p>Given an identity (an email address or a domain), sets whether Amazon SES includes the original email headers in the Amazon Simple Notification Service (Amazon SNS) notifications of a specified type.</p> <p>This action is throttled at one request per second.</p> <p>For more information about using notifications with Amazon SES, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.</p>', 'SetIdentityMailFromDomain' => '<p>Enables or disables the custom MAIL FROM domain setup for a verified identity (an email address or a domain).</p> <important> <p>To send emails using the specified MAIL FROM domain, you must add an MX record to your MAIL FROM domain\'s DNS settings. If you want your emails to pass Sender Policy Framework (SPF) checks, you must also add or update an SPF record. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-set.html">Amazon SES Developer Guide</a>.</p> </important> <p>This action is throttled at one request per second.</p>', 'SetIdentityNotificationTopic' => '<p>Given an identity (an email address or a domain), sets the Amazon Simple Notification Service (Amazon SNS) topic to which Amazon SES will publish bounce, complaint, and/or delivery notifications for emails sent with that identity as the <code>Source</code>.</p> <note> <p>Unless feedback forwarding is enabled, you must specify Amazon SNS topics for bounce and complaint notifications. For more information, see <code>SetIdentityFeedbackForwardingEnabled</code>.</p> </note> <p>This action is throttled at one request per second.</p> <p>For more information about feedback notification, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.</p>', 'SetReceiptRulePosition' => '<p>Sets the position of the specified receipt rule in the receipt rule set.</p> <p>For information about managing receipt rules, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'UpdateConfigurationSetEventDestination' => '<p>Updates the event destination of a configuration set.</p> <note> <p>When you create or update an event destination, you must provide one, and only one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).</p> </note> <p>Event destinations are associated with configuration sets, which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS). For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'UpdateReceiptRule' => '<p>Updates a receipt rule.</p> <p>For information about managing receipt rules, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon SES Developer Guide</a>.</p> <p>This action is throttled at one request per second.</p>', 'VerifyDomainDkim' => '<p>Returns a set of DKIM tokens for a domain. DKIM <i>tokens</i> are character strings that represent your domain\'s identity. Using these tokens, you will need to create DNS CNAME records that point to DKIM public keys hosted by Amazon SES. Amazon Web Services will eventually detect that you have updated your DNS records; this detection process may take up to 72 hours. Upon successful detection, Amazon SES will be able to DKIM-sign email originating from that domain.</p> <p>This action is throttled at one request per second.</p> <p>To enable or disable Easy DKIM signing for a domain, use the <code>SetIdentityDkimEnabled</code> action.</p> <p>For more information about creating DNS records using DKIM tokens, go to the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer Guide</a>.</p>', 'VerifyDomainIdentity' => '<p>Verifies a domain.</p> <p>This action is throttled at one request per second.</p>', 'VerifyEmailAddress' => '<p>Verifies an email address. This action causes a confirmation email message to be sent to the specified address.</p> <important> <p>The VerifyEmailAddress action is deprecated as of the May 15, 2012 release of Domain Verification. The VerifyEmailIdentity action is now preferred.</p> </important> <p>This action is throttled at one request per second.</p>', 'VerifyEmailIdentity' => '<p>Verifies an email address. This action causes a confirmation email message to be sent to the specified address.</p> <p>This action is throttled at one request per second.</p>', ], 'shapes' => [ 'AddHeaderAction' => [ 'base' => '<p>When included in a receipt rule, this action adds a header to the received email.</p> <p>For information about adding a header using a receipt rule, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-add-header.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'ReceiptAction$AddHeaderAction' => '<p>Adds a header to the received email.</p>', ], ], 'Address' => [ 'base' => NULL, 'refs' => [ 'AddressList$member' => NULL, 'BounceAction$Sender' => '<p>The email address of the sender of the bounced email. This is the address from which the bounce message will be sent.</p>', 'BouncedRecipientInfo$Recipient' => '<p>The email address of the recipient of the bounced email.</p>', 'DeleteVerifiedEmailAddressRequest$EmailAddress' => '<p>An email address to be removed from the list of verified addresses.</p>', 'RecipientDsnFields$FinalRecipient' => '<p>The email address to which the message was ultimately delivered. This corresponds to the <code>Final-Recipient</code> in the DSN. If not specified, <code>FinalRecipient</code> will be set to the <code>Recipient</code> specified in the <code>BouncedRecipientInfo</code> structure. Either <code>FinalRecipient</code> or the recipient in <code>BouncedRecipientInfo</code> must be a recipient of the original bounced message.</p> <note> <p>Do not prepend the <code>FinalRecipient</code> email address with <code>rfc 822;</code>, as described in <a href="https://tools.ietf.org/html/rfc3798">RFC 3798</a>.</p> </note>', 'SendBounceRequest$BounceSender' => '<p>The address to use in the "From" header of the bounce message. This must be an identity that you have verified with Amazon SES.</p>', 'SendEmailRequest$Source' => '<p>The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer Guide</a>.</p> <p>If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the <code>SourceArn</code> parameter. For more information about sending authorization, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <p> In all cases, the email address must be 7-bit ASCII. If the text must contain any other characters, then you must use MIME encoded-word syntax (RFC 2047) instead of a literal string. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>. For more information, see <a href="http://tools.ietf.org/html/rfc2047">RFC 2047</a>. </p>', 'SendEmailRequest$ReturnPath' => '<p>The email address to which bounces and complaints are to be forwarded when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message will be returned from the recipient\'s ISP; this message will then be forwarded to the email address specified by the <code>ReturnPath</code> parameter. The <code>ReturnPath</code> parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. </p>', 'SendRawEmailRequest$Source' => '<p>The identity\'s email address. If you do not provide a value for this parameter, you must specify a "From" address in the raw text of the message. (You can also specify both.)</p> <p> By default, the string must be 7-bit ASCII. If the text must contain any other characters, then you must use MIME encoded-word syntax (RFC 2047) instead of a literal string. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>. For more information, see <a href="http://tools.ietf.org/html/rfc2047">RFC 2047</a>. </p> <note> <p>If you specify the <code>Source</code> parameter and have feedback forwarding enabled, then bounces and complaints will be sent to this email address. This takes precedence over any <i>Return-Path</i> header that you might include in the raw text of the message.</p> </note>', 'VerifyEmailAddressRequest$EmailAddress' => '<p>The email address to be verified.</p>', 'VerifyEmailIdentityRequest$EmailAddress' => '<p>The email address to be verified.</p>', ], ], 'AddressList' => [ 'base' => NULL, 'refs' => [ 'Destination$ToAddresses' => '<p>The To: field(s) of the message.</p>', 'Destination$CcAddresses' => '<p>The CC: field(s) of the message.</p>', 'Destination$BccAddresses' => '<p>The BCC: field(s) of the message.</p>', 'ListVerifiedEmailAddressesResponse$VerifiedEmailAddresses' => '<p>A list of email addresses that have been verified.</p>', 'SendEmailRequest$ReplyToAddresses' => '<p>The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address will receive the reply.</p>', 'SendRawEmailRequest$Destinations' => '<p>A list of destinations for the message, consisting of To:, CC:, and BCC: addresses.</p>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>Indicates that a resource could not be created because of a naming conflict.</p>', 'refs' => [], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'BounceAction$TopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken. An example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>', 'BouncedRecipientInfo$RecipientArn' => '<p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to receive email for the recipient of the bounced email. For more information about sending authorization, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>', 'InvalidLambdaFunctionException$FunctionArn' => NULL, 'InvalidSnsTopicException$Topic' => NULL, 'KinesisFirehoseDestination$IAMRoleARN' => '<p>The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose stream.</p>', 'KinesisFirehoseDestination$DeliveryStreamARN' => '<p>The ARN of the Amazon Kinesis Firehose stream to which to publish email sending events.</p>', 'LambdaAction$TopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is taken. An example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>', 'LambdaAction$FunctionArn' => '<p>The Amazon Resource Name (ARN) of the AWS Lambda function. An example of an AWS Lambda function ARN is <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code>. For more information about AWS Lambda, see the <a href="http://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda Developer Guide</a>.</p>', 'S3Action$TopicArn' => '<p>The ARN of the Amazon SNS topic to notify when the message is saved to the Amazon S3 bucket. An example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>', 'S3Action$KmsKeyArn' => '<p>The customer master key that Amazon SES should use to encrypt your emails before saving them to the Amazon S3 bucket. You can use the default master key or a custom master key you created in AWS KMS as follows:</p> <ul> <li> <p>To use the default master key, provide an ARN in the form of <code>arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses</code>. For example, if your AWS account ID is 123456789012 and you want to use the default master key in the US West (Oregon) region, the ARN of the default master key would be <code>arn:aws:kms:us-west-2:123456789012:alias/aws/ses</code>. If you use the default master key, you don\'t need to perform any extra steps to give Amazon SES permission to use the key.</p> </li> <li> <p>To use a custom master key you created in AWS KMS, provide the ARN of the master key and ensure that you add a statement to your key\'s policy to give Amazon SES permission to use it. For more information about giving permissions, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer Guide</a>.</p> </li> </ul> <p>For more information about key policies, see the <a href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">AWS KMS Developer Guide</a>. If you do not specify a master key, Amazon SES will not encrypt your emails.</p> <important> <p>Your mail is encrypted by Amazon SES using the Amazon S3 encryption client before the mail is submitted to Amazon S3 for storage. It is not encrypted using Amazon S3 server-side encryption. This means that you must use the Amazon S3 encryption client to decrypt the email after retrieving it from Amazon S3, as the service has no access to use your AWS KMS keys for decryption. This encryption client is currently available with the <a href="http://aws.amazon.com/sdk-for-java/">AWS Java SDK</a> and <a href="http://aws.amazon.com/sdk-for-ruby/">AWS Ruby SDK</a> only. For more information about client-side encryption using AWS KMS master keys, see the <a href="http://alpha-docs-aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">Amazon S3 Developer Guide</a>.</p> </important>', 'SNSAction$TopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify. An example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>', 'SNSDestination$TopicARN' => '<p>The ARN of the Amazon SNS topic to which you want to publish email sending events. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic. For more information about Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/http:/alpha-docs-aws.amazon.com/sns/latest/dg/CreateTopic.html"> <i>Amazon SNS Developer Guide</i> </a>.</p>', 'SendBounceRequest$BounceSenderArn' => '<p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the address in the "From" header of the bounce. For more information about sending authorization, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>', 'SendEmailRequest$SourceArn' => '<p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p> <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p> <p>For more information about sending authorization, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>. </p>', 'SendEmailRequest$ReturnPathArn' => '<p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p> <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p> <p>For more information about sending authorization, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>. </p>', 'SendRawEmailRequest$FromArn' => '<p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to specify a particular "From" address in the header of the raw email.</p> <p>Instead of using this parameter, you can use the X-header <code>X-SES-FROM-ARN</code> in the raw message of the email. If you use both the <code>FromArn</code> parameter and the corresponding X-header, Amazon SES uses the value of the <code>FromArn</code> parameter.</p> <note> <p>For information about when to use this parameter, see the description of <code>SendRawEmail</code> in this guide, or see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p> </note>', 'SendRawEmailRequest$SourceArn' => '<p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p> <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p> <p>Instead of using this parameter, you can use the X-header <code>X-SES-SOURCE-ARN</code> in the raw message of the email. If you use both the <code>SourceArn</code> parameter and the corresponding X-header, Amazon SES uses the value of the <code>SourceArn</code> parameter.</p> <note> <p>For information about when to use this parameter, see the description of <code>SendRawEmail</code> in this guide, or see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p> </note>', 'SendRawEmailRequest$ReturnPathArn' => '<p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p> <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p> <p>Instead of using this parameter, you can use the X-header <code>X-SES-RETURN-PATH-ARN</code> in the raw message of the email. If you use both the <code>ReturnPathArn</code> parameter and the corresponding X-header, Amazon SES uses the value of the <code>ReturnPathArn</code> parameter.</p> <note> <p>For information about when to use this parameter, see the description of <code>SendRawEmail</code> in this guide, or see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p> </note>', 'StopAction$TopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop action is taken. An example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>', 'WorkmailAction$TopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action is called. An example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>', 'WorkmailAction$OrganizationArn' => '<p>The ARN of the Amazon WorkMail organization. An example of an Amazon WorkMail organization ARN is <code>arn:aws:workmail:us-west-2:123456789012:organization/m-68755160c4cb4e29a2b2f8fb58f359d7</code>. For information about Amazon WorkMail organizations, see the <a href="http://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon WorkMail Administrator Guide</a>.</p>', ], ], 'ArrivalDate' => [ 'base' => NULL, 'refs' => [ 'MessageDsn$ArrivalDate' => '<p>When the message was received by the reporting mail transfer agent (MTA), in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a> date-time format.</p>', ], ], 'BehaviorOnMXFailure' => [ 'base' => NULL, 'refs' => [ 'IdentityMailFromDomainAttributes$BehaviorOnMXFailure' => '<p>The action that Amazon SES takes if it cannot successfully read the required MX record when you send an email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES returns a <code>MailFromDomainNotVerified</code> error and does not send the email.</p> <p>The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code>.</p>', 'SetIdentityMailFromDomainRequest$BehaviorOnMXFailure' => '<p>The action that you want Amazon SES to take if it cannot successfully read the required MX record when you send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will use amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose <code>RejectMessage</code>, Amazon SES will return a <code>MailFromDomainNotVerified</code> error and not send the email.</p> <p>The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL FROM domain setup is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>', ], ], 'Body' => [ 'base' => '<p>Represents the body of the message. You can specify text, HTML, or both. If you use both, then the message should display correctly in the widest variety of email clients.</p>', 'refs' => [ 'Message$Body' => '<p>The message body.</p>', ], ], 'BounceAction' => [ 'base' => '<p>When included in a receipt rule, this action rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).</p> <p>For information about sending a bounce message in response to a received email, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-bounce.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'ReceiptAction$BounceAction' => '<p>Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).</p>', ], ], 'BounceMessage' => [ 'base' => NULL, 'refs' => [ 'BounceAction$Message' => '<p>Human-readable text to include in the bounce message.</p>', ], ], 'BounceSmtpReplyCode' => [ 'base' => NULL, 'refs' => [ 'BounceAction$SmtpReplyCode' => '<p>The SMTP reply code, as defined by <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p>', ], ], 'BounceStatusCode' => [ 'base' => NULL, 'refs' => [ 'BounceAction$StatusCode' => '<p>The SMTP enhanced status code, as defined by <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a>.</p>', ], ], 'BounceType' => [ 'base' => NULL, 'refs' => [ 'BouncedRecipientInfo$BounceType' => '<p>The reason for the bounce. You must provide either this parameter or <code>RecipientDsnFields</code>.</p>', ], ], 'BouncedRecipientInfo' => [ 'base' => '<p>Recipient-related information to include in the Delivery Status Notification (DSN) when an email that Amazon SES receives on your behalf bounces.</p> <p>For information about receiving email through Amazon SES, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'BouncedRecipientInfoList$member' => NULL, ], ], 'BouncedRecipientInfoList' => [ 'base' => NULL, 'refs' => [ 'SendBounceRequest$BouncedRecipientInfoList' => '<p>A list of recipients of the bounced message, including the information required to create the Delivery Status Notifications (DSNs) for the recipients. You must specify at least one <code>BouncedRecipientInfo</code> in the list.</p>', ], ], 'CannotDeleteException' => [ 'base' => '<p>Indicates that the delete operation could not be completed.</p>', 'refs' => [], ], 'Charset' => [ 'base' => NULL, 'refs' => [ 'Content$Charset' => '<p>The character set of the content.</p>', ], ], 'Cidr' => [ 'base' => NULL, 'refs' => [ 'ReceiptIpFilter$Cidr' => '<p>A single IP address or a range of IP addresses that you want to block or allow, specified in Classless Inter-Domain Routing (CIDR) notation. An example of a single email address is 10.0.0.1. An example of a range of IP addresses is 10.0.0.1/24. For more information about CIDR notation, see <a href="https://tools.ietf.org/html/rfc2317">RFC 2317</a>.</p>', ], ], 'CloneReceiptRuleSetRequest' => [ 'base' => '<p>Represents a request to create a receipt rule set by cloning an existing one. You use receipt rule sets to receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'CloneReceiptRuleSetResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'CloudWatchDestination' => [ 'base' => '<p>Contains information associated with an Amazon CloudWatch event destination to which email sending events are published.</p> <p>Event destinations, such as Amazon CloudWatch, are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'EventDestination$CloudWatchDestination' => '<p>An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.</p>', ], ], 'CloudWatchDimensionConfiguration' => [ 'base' => '<p>Contains the dimension configuration to use when you publish email sending events to Amazon CloudWatch.</p> <p>For information about publishing email sending events to Amazon CloudWatch, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'CloudWatchDimensionConfigurations$member' => NULL, ], ], 'CloudWatchDimensionConfigurations' => [ 'base' => NULL, 'refs' => [ 'CloudWatchDestination$DimensionConfigurations' => '<p>A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.</p>', ], ], 'ConfigurationSet' => [ 'base' => '<p>The name of the configuration set.</p> <p>Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'ConfigurationSets$member' => NULL, 'CreateConfigurationSetRequest$ConfigurationSet' => '<p>A data structure that contains the name of the configuration set.</p>', 'DescribeConfigurationSetResponse$ConfigurationSet' => '<p>The configuration set object associated with the specified configuration set.</p>', ], ], 'ConfigurationSetAlreadyExistsException' => [ 'base' => '<p>Indicates that the configuration set could not be created because of a naming conflict.</p>', 'refs' => [], ], 'ConfigurationSetAttribute' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetAttributeList$member' => NULL, ], ], 'ConfigurationSetAttributeList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationSetRequest$ConfigurationSetAttributeNames' => '<p>A list of configuration set attributes to return.</p>', ], ], 'ConfigurationSetDoesNotExistException' => [ 'base' => '<p>Indicates that the configuration set does not exist.</p>', 'refs' => [], ], 'ConfigurationSetName' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSet$Name' => '<p>The name of the configuration set. The name must:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</p> </li> <li> <p>Contain less than 64 characters.</p> </li> </ul>', 'ConfigurationSetAlreadyExistsException$ConfigurationSetName' => NULL, 'ConfigurationSetDoesNotExistException$ConfigurationSetName' => NULL, 'CreateConfigurationSetEventDestinationRequest$ConfigurationSetName' => '<p>The name of the configuration set to which to apply the event destination.</p>', 'DeleteConfigurationSetEventDestinationRequest$ConfigurationSetName' => '<p>The name of the configuration set from which to delete the event destination.</p>', 'DeleteConfigurationSetRequest$ConfigurationSetName' => '<p>The name of the configuration set to delete.</p>', 'DescribeConfigurationSetRequest$ConfigurationSetName' => '<p>The name of the configuration set to describe.</p>', 'EventDestinationAlreadyExistsException$ConfigurationSetName' => NULL, 'EventDestinationDoesNotExistException$ConfigurationSetName' => NULL, 'InvalidCloudWatchDestinationException$ConfigurationSetName' => NULL, 'InvalidFirehoseDestinationException$ConfigurationSetName' => NULL, 'InvalidSNSDestinationException$ConfigurationSetName' => '<p>Indicates that the configuration set does not exist.</p>', 'SendEmailRequest$ConfigurationSetName' => '<p>The name of the configuration set to use when you send an email using <code>SendEmail</code>.</p>', 'SendRawEmailRequest$ConfigurationSetName' => '<p>The name of the configuration set to use when you send an email using <code>SendRawEmail</code>.</p>', 'UpdateConfigurationSetEventDestinationRequest$ConfigurationSetName' => '<p>The name of the configuration set that you want to update.</p>', ], ], 'ConfigurationSets' => [ 'base' => NULL, 'refs' => [ 'ListConfigurationSetsResponse$ConfigurationSets' => '<p>A list of configuration sets.</p>', ], ], 'Content' => [ 'base' => '<p>Represents textual data, plus an optional character set specification.</p> <p>By default, the text must be 7-bit ASCII, due to the constraints of the SMTP protocol. If the text must contain any other characters, then you must also specify a character set. Examples include UTF-8, ISO-8859-1, and Shift_JIS.</p>', 'refs' => [ 'Body$Text' => '<p>The content of the message, in text format. Use this for text-based email clients, or clients on high-latency networks (such as mobile devices).</p>', 'Body$Html' => '<p>The content of the message, in HTML format. Use this for email clients that can process HTML. You can include clickable links, formatted text, and much more in an HTML message.</p>', 'Message$Subject' => '<p>The subject of the message: A short summary of the content, which will appear in the recipient\'s inbox.</p>', ], ], 'Counter' => [ 'base' => NULL, 'refs' => [ 'SendDataPoint$DeliveryAttempts' => '<p>Number of emails that have been sent.</p>', 'SendDataPoint$Bounces' => '<p>Number of emails that have bounced.</p>', 'SendDataPoint$Complaints' => '<p>Number of unwanted emails that were rejected by recipients.</p>', 'SendDataPoint$Rejects' => '<p>Number of emails rejected by Amazon SES.</p>', ], ], 'CreateConfigurationSetEventDestinationRequest' => [ 'base' => '<p>Represents a request to create a configuration set event destination. A configuration set event destination, which can be either Amazon CloudWatch or Amazon Kinesis Firehose, describes an AWS service in which Amazon SES publishes the email sending events associated with a configuration set. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'CreateConfigurationSetEventDestinationResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'CreateConfigurationSetRequest' => [ 'base' => '<p>Represents a request to create a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'CreateConfigurationSetResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'CreateReceiptFilterRequest' => [ 'base' => '<p>Represents a request to create a new IP address filter. You use IP address filters when you receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'CreateReceiptFilterResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'CreateReceiptRuleRequest' => [ 'base' => '<p>Represents a request to create a receipt rule. You use receipt rules to receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'CreateReceiptRuleResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'CreateReceiptRuleSetRequest' => [ 'base' => '<p>Represents a request to create an empty receipt rule set. You use receipt rule sets to receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'CreateReceiptRuleSetResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'CustomMailFromStatus' => [ 'base' => NULL, 'refs' => [ 'IdentityMailFromDomainAttributes$MailFromDomainStatus' => '<p>The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM domain when the verified identity sends an email. All other states indicate that Amazon SES takes the action described by <code>BehaviorOnMXFailure</code>.</p>', ], ], 'DefaultDimensionValue' => [ 'base' => NULL, 'refs' => [ 'CloudWatchDimensionConfiguration$DefaultDimensionValue' => '<p>The default value of the dimension that is published to Amazon CloudWatch if you do not provide the value of the dimension when you send an email. The default value must:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</p> </li> <li> <p>Contain less than 256 characters.</p> </li> </ul>', ], ], 'DeleteConfigurationSetEventDestinationRequest' => [ 'base' => '<p>Represents a request to delete a configuration set event destination. Configuration set event destinations are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'DeleteConfigurationSetEventDestinationResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'DeleteConfigurationSetRequest' => [ 'base' => '<p>Represents a request to delete a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'DeleteConfigurationSetResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'DeleteIdentityPolicyRequest' => [ 'base' => '<p>Represents a request to delete a sending authorization policy for an identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'DeleteIdentityPolicyResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'DeleteIdentityRequest' => [ 'base' => '<p>Represents a request to delete one of your Amazon SES identities (an email address or domain).</p>', 'refs' => [], ], 'DeleteIdentityResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'DeleteReceiptFilterRequest' => [ 'base' => '<p>Represents a request to delete an IP address filter. You use IP address filters when you receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'DeleteReceiptFilterResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'DeleteReceiptRuleRequest' => [ 'base' => '<p>Represents a request to delete a receipt rule. You use receipt rules to receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'DeleteReceiptRuleResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'DeleteReceiptRuleSetRequest' => [ 'base' => '<p>Represents a request to delete a receipt rule set and all of the receipt rules it contains. You use receipt rule sets to receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'DeleteReceiptRuleSetResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'DeleteVerifiedEmailAddressRequest' => [ 'base' => '<p>Represents a request to delete an email address from the list of email addresses you have attempted to verify under your AWS account.</p>', 'refs' => [], ], 'DescribeActiveReceiptRuleSetRequest' => [ 'base' => '<p>Represents a request to return the metadata and receipt rules for the receipt rule set that is currently active. You use receipt rule sets to receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'DescribeActiveReceiptRuleSetResponse' => [ 'base' => '<p>Represents the metadata and receipt rules for the receipt rule set that is currently active.</p>', 'refs' => [], ], 'DescribeConfigurationSetRequest' => [ 'base' => '<p>Represents a request to return the details of a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'DescribeConfigurationSetResponse' => [ 'base' => '<p>Represents the details of a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'DescribeReceiptRuleRequest' => [ 'base' => '<p>Represents a request to return the details of a receipt rule. You use receipt rules to receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'DescribeReceiptRuleResponse' => [ 'base' => '<p>Represents the details of a receipt rule.</p>', 'refs' => [], ], 'DescribeReceiptRuleSetRequest' => [ 'base' => '<p>Represents a request to return the details of a receipt rule set. You use receipt rule sets to receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'DescribeReceiptRuleSetResponse' => [ 'base' => '<p>Represents the details of the specified receipt rule set.</p>', 'refs' => [], ], 'Destination' => [ 'base' => '<p>Represents the destination of the message, consisting of To:, CC:, and BCC: fields.</p> <p> By default, the string must be 7-bit ASCII. If the text must contain any other characters, then you must use MIME encoded-word syntax (RFC 2047) instead of a literal string. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>. For more information, see <a href="http://tools.ietf.org/html/rfc2047">RFC 2047</a>. </p>', 'refs' => [ 'SendEmailRequest$Destination' => '<p>The destination for this email, composed of To:, CC:, and BCC: fields.</p>', ], ], 'DiagnosticCode' => [ 'base' => NULL, 'refs' => [ 'RecipientDsnFields$DiagnosticCode' => '<p>An extended explanation of what went wrong; this is usually an SMTP response. See <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a> for the correct formatting of this parameter.</p>', ], ], 'DimensionName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchDimensionConfiguration$DimensionName' => '<p>The name of an Amazon CloudWatch dimension associated with an email sending metric. The name must:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</p> </li> <li> <p>Contain less than 256 characters.</p> </li> </ul>', ], ], 'DimensionValueSource' => [ 'base' => NULL, 'refs' => [ 'CloudWatchDimensionConfiguration$DimensionValueSource' => '<p>The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. If you want Amazon SES to use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the <code>SendEmail</code>/<code>SendRawEmail</code> API, choose <code>messageTag</code>. If you want Amazon SES to use your own email headers, choose <code>emailHeader</code>.</p>', ], ], 'DkimAttributes' => [ 'base' => NULL, 'refs' => [ 'GetIdentityDkimAttributesResponse$DkimAttributes' => '<p>The DKIM attributes for an email address or a domain.</p>', ], ], 'Domain' => [ 'base' => NULL, 'refs' => [ 'VerifyDomainDkimRequest$Domain' => '<p>The name of the domain to be verified for Easy DKIM signing.</p>', 'VerifyDomainIdentityRequest$Domain' => '<p>The domain to be verified.</p>', ], ], 'DsnAction' => [ 'base' => NULL, 'refs' => [ 'RecipientDsnFields$Action' => '<p>The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver the message to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.</p>', ], ], 'DsnStatus' => [ 'base' => NULL, 'refs' => [ 'RecipientDsnFields$Status' => '<p>The status code that indicates what went wrong. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.</p>', ], ], 'Enabled' => [ 'base' => NULL, 'refs' => [ 'EventDestination$Enabled' => '<p>Sets whether Amazon SES publishes events to this destination when you send an email with the associated configuration set. Set to <code>true</code> to enable publishing to this destination; set to <code>false</code> to prevent publishing to this destination. The default value is <code>false</code>.</p>', 'IdentityDkimAttributes$DkimEnabled' => '<p>True if DKIM signing is enabled for email sent from the identity; false otherwise. The default value is true.</p>', 'IdentityNotificationAttributes$ForwardingEnabled' => '<p>Describes whether Amazon SES will forward bounce and complaint notifications as email. <code>true</code> indicates that Amazon SES will forward bounce and complaint notifications as email, while <code>false</code> indicates that bounce and complaint notifications will be published only to the specified bounce and complaint Amazon SNS topics.</p>', 'IdentityNotificationAttributes$HeadersInBounceNotificationsEnabled' => '<p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type <code>Bounce</code>. A value of <code>true</code> specifies that Amazon SES will include headers in bounce notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers in bounce notifications.</p>', 'IdentityNotificationAttributes$HeadersInComplaintNotificationsEnabled' => '<p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type <code>Complaint</code>. A value of <code>true</code> specifies that Amazon SES will include headers in complaint notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers in complaint notifications.</p>', 'IdentityNotificationAttributes$HeadersInDeliveryNotificationsEnabled' => '<p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type <code>Delivery</code>. A value of <code>true</code> specifies that Amazon SES will include headers in delivery notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers in delivery notifications.</p>', 'ReceiptRule$Enabled' => '<p>If <code>true</code>, the receipt rule is active. The default value is <code>false</code>.</p>', 'ReceiptRule$ScanEnabled' => '<p>If <code>true</code>, then messages to which this receipt rule applies are scanned for spam and viruses. The default value is <code>false</code>.</p>', 'SetIdentityDkimEnabledRequest$DkimEnabled' => '<p>Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to enable DKIM signing for this identity; <code>false</code> to disable it. </p>', 'SetIdentityFeedbackForwardingEnabledRequest$ForwardingEnabled' => '<p>Sets whether Amazon SES will forward bounce and complaint notifications as email. <code>true</code> specifies that Amazon SES will forward bounce and complaint notifications as email, in addition to any Amazon SNS topic publishing otherwise specified. <code>false</code> specifies that Amazon SES will publish bounce and complaint notifications only through Amazon SNS. This value can only be set to <code>false</code> when Amazon SNS topics are set for both <code>Bounce</code> and <code>Complaint</code> notification types.</p>', 'SetIdentityHeadersInNotificationsEnabledRequest$Enabled' => '<p>Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the specified notification type. A value of <code>true</code> specifies that Amazon SES will include headers in notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers in notifications.</p> <p>This value can only be set when <code>NotificationType</code> is already set to use a particular Amazon SNS topic.</p>', ], ], 'EventDestination' => [ 'base' => '<p>Contains information about the event destination to which the specified email sending events are published.</p> <note> <p>When you create or update an event destination, you must provide one, and only one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis Firehose or Amazon Simple Notification Service (Amazon SNS).</p> </note> <p>Event destinations are associated with configuration sets, which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS). For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'CreateConfigurationSetEventDestinationRequest$EventDestination' => '<p>An object that describes the AWS service to which Amazon SES will publish the email sending events associated with the specified configuration set.</p>', 'EventDestinations$member' => NULL, 'UpdateConfigurationSetEventDestinationRequest$EventDestination' => '<p>The event destination object that you want to apply to the specified configuration set.</p>', ], ], 'EventDestinationAlreadyExistsException' => [ 'base' => '<p>Indicates that the event destination could not be created because of a naming conflict.</p>', 'refs' => [], ], 'EventDestinationDoesNotExistException' => [ 'base' => '<p>Indicates that the event destination does not exist.</p>', 'refs' => [], ], 'EventDestinationName' => [ 'base' => NULL, 'refs' => [ 'DeleteConfigurationSetEventDestinationRequest$EventDestinationName' => '<p>The name of the event destination to delete.</p>', 'EventDestination$Name' => '<p>The name of the event destination. The name must:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</p> </li> <li> <p>Contain less than 64 characters.</p> </li> </ul>', 'EventDestinationAlreadyExistsException$EventDestinationName' => NULL, 'EventDestinationDoesNotExistException$EventDestinationName' => NULL, 'InvalidCloudWatchDestinationException$EventDestinationName' => NULL, 'InvalidFirehoseDestinationException$EventDestinationName' => NULL, 'InvalidSNSDestinationException$EventDestinationName' => '<p>Indicates that the event destination does not exist.</p>', ], ], 'EventDestinations' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationSetResponse$EventDestinations' => '<p>A list of event destinations associated with the configuration set. </p>', ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'EventTypes$member' => NULL, ], ], 'EventTypes' => [ 'base' => NULL, 'refs' => [ 'EventDestination$MatchingEventTypes' => '<p>The type of email sending events to publish to the event destination.</p>', ], ], 'Explanation' => [ 'base' => NULL, 'refs' => [ 'SendBounceRequest$Explanation' => '<p>Human-readable text for the bounce message to explain the failure. If not specified, the text will be auto-generated based on the bounced recipient information.</p>', ], ], 'ExtensionField' => [ 'base' => '<p>Additional X-headers to include in the Delivery Status Notification (DSN) when an email that Amazon SES receives on your behalf bounces.</p> <p>For information about receiving email through Amazon SES, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'ExtensionFieldList$member' => NULL, ], ], 'ExtensionFieldList' => [ 'base' => NULL, 'refs' => [ 'MessageDsn$ExtensionFields' => '<p>Additional X-headers to include in the DSN.</p>', 'RecipientDsnFields$ExtensionFields' => '<p>Additional X-headers to include in the DSN.</p>', ], ], 'ExtensionFieldName' => [ 'base' => NULL, 'refs' => [ 'ExtensionField$Name' => '<p>The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.</p>', ], ], 'ExtensionFieldValue' => [ 'base' => NULL, 'refs' => [ 'ExtensionField$Value' => '<p>The value of the header to add. Must be less than 2048 characters, and must not contain newline characters ("\\r" or "\\n").</p>', ], ], 'GetIdentityDkimAttributesRequest' => [ 'base' => '<p>Represents a request for the status of Amazon SES Easy DKIM signing for an identity. For domain identities, this request also returns the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES successfully verified that these tokens were published. For more information about Easy DKIM, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'GetIdentityDkimAttributesResponse' => [ 'base' => '<p>Represents the status of Amazon SES Easy DKIM signing for an identity. For domain identities, this response also contains the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES successfully verified that these tokens were published.</p>', 'refs' => [], ], 'GetIdentityMailFromDomainAttributesRequest' => [ 'base' => '<p>Represents a request to return the Amazon SES custom MAIL FROM attributes for a list of identities. For information about using a custom MAIL FROM domain, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'GetIdentityMailFromDomainAttributesResponse' => [ 'base' => '<p>Represents the custom MAIL FROM attributes for a list of identities.</p>', 'refs' => [], ], 'GetIdentityNotificationAttributesRequest' => [ 'base' => '<p>Represents a request to return the notification attributes for a list of identities you verified with Amazon SES. For information about Amazon SES notifications, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'GetIdentityNotificationAttributesResponse' => [ 'base' => '<p>Represents the notification attributes for a list of identities.</p>', 'refs' => [], ], 'GetIdentityPoliciesRequest' => [ 'base' => '<p>Represents a request to return the requested sending authorization policies for an identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'GetIdentityPoliciesResponse' => [ 'base' => '<p>Represents the requested sending authorization policies.</p>', 'refs' => [], ], 'GetIdentityVerificationAttributesRequest' => [ 'base' => '<p>Represents a request to return the Amazon SES verification status of a list of identities. For domain identities, this request also returns the verification token. For information about verifying identities with Amazon SES, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'GetIdentityVerificationAttributesResponse' => [ 'base' => '<p>The Amazon SES verification status of a list of identities. For domain identities, this response also contains the verification token.</p>', 'refs' => [], ], 'GetSendQuotaResponse' => [ 'base' => '<p>Represents your Amazon SES daily sending quota, maximum send rate, and the number of emails you have sent in the last 24 hours.</p>', 'refs' => [], ], 'GetSendStatisticsResponse' => [ 'base' => '<p>Represents a list of data points. This list contains aggregated data from the previous two weeks of your sending activity with Amazon SES.</p>', 'refs' => [], ], 'HeaderName' => [ 'base' => NULL, 'refs' => [ 'AddHeaderAction$HeaderName' => '<p>The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.</p>', ], ], 'HeaderValue' => [ 'base' => NULL, 'refs' => [ 'AddHeaderAction$HeaderValue' => '<p>Must be less than 2048 characters, and must not contain newline characters ("\\r" or "\\n").</p>', ], ], 'Identity' => [ 'base' => NULL, 'refs' => [ 'DeleteIdentityPolicyRequest$Identity' => '<p>The identity that is associated with the policy that you want to delete. You can specify the identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p> <p>To successfully call this API, you must own the identity.</p>', 'DeleteIdentityRequest$Identity' => '<p>The identity to be removed from the list of identities for the AWS Account.</p>', 'DkimAttributes$key' => NULL, 'GetIdentityPoliciesRequest$Identity' => '<p>The identity for which the policies will be retrieved. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p> <p>To successfully call this API, you must own the identity.</p>', 'IdentityList$member' => NULL, 'ListIdentityPoliciesRequest$Identity' => '<p>The identity that is associated with the policy for which the policies will be listed. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p> <p>To successfully call this API, you must own the identity.</p>', 'MailFromDomainAttributes$key' => NULL, 'NotificationAttributes$key' => NULL, 'PutIdentityPolicyRequest$Identity' => '<p>The identity to which the policy will apply. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p> <p>To successfully call this API, you must own the identity.</p>', 'SetIdentityDkimEnabledRequest$Identity' => '<p>The identity for which DKIM signing should be enabled or disabled.</p>', 'SetIdentityFeedbackForwardingEnabledRequest$Identity' => '<p>The identity for which to set bounce and complaint notification forwarding. Examples: <code>user@example.com</code>, <code>example.com</code>.</p>', 'SetIdentityHeadersInNotificationsEnabledRequest$Identity' => '<p>The identity for which to enable or disable headers in notifications. Examples: <code>user@example.com</code>, <code>example.com</code>.</p>', 'SetIdentityMailFromDomainRequest$Identity' => '<p>The verified identity for which you want to enable or disable the specified custom MAIL FROM domain.</p>', 'SetIdentityNotificationTopicRequest$Identity' => '<p>The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>', 'VerificationAttributes$key' => NULL, ], ], 'IdentityDkimAttributes' => [ 'base' => '<p>Represents the DKIM attributes of a verified email address or a domain.</p>', 'refs' => [ 'DkimAttributes$value' => NULL, ], ], 'IdentityList' => [ 'base' => NULL, 'refs' => [ 'GetIdentityDkimAttributesRequest$Identities' => '<p>A list of one or more verified identities - email addresses, domains, or both.</p>', 'GetIdentityMailFromDomainAttributesRequest$Identities' => '<p>A list of one or more identities.</p>', 'GetIdentityNotificationAttributesRequest$Identities' => '<p>A list of one or more identities. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>', 'GetIdentityVerificationAttributesRequest$Identities' => '<p>A list of identities.</p>', 'ListIdentitiesResponse$Identities' => '<p>A list of identities.</p>', ], ], 'IdentityMailFromDomainAttributes' => [ 'base' => '<p>Represents the custom MAIL FROM domain attributes of a verified identity (email address or domain).</p>', 'refs' => [ 'MailFromDomainAttributes$value' => NULL, ], ], 'IdentityNotificationAttributes' => [ 'base' => '<p>Represents the notification attributes of an identity, including whether an identity has Amazon Simple Notification Service (Amazon SNS) topics set for bounce, complaint, and/or delivery notifications, and whether feedback forwarding is enabled for bounce and complaint notifications.</p>', 'refs' => [ 'NotificationAttributes$value' => NULL, ], ], 'IdentityType' => [ 'base' => NULL, 'refs' => [ 'ListIdentitiesRequest$IdentityType' => '<p>The type of the identities to list. Possible values are "EmailAddress" and "Domain". If this parameter is omitted, then all identities will be listed.</p>', ], ], 'IdentityVerificationAttributes' => [ 'base' => '<p>Represents the verification attributes of a single identity.</p>', 'refs' => [ 'VerificationAttributes$value' => NULL, ], ], 'InvalidCloudWatchDestinationException' => [ 'base' => '<p>Indicates that the Amazon CloudWatch destination is invalid. See the error message for details.</p>', 'refs' => [], ], 'InvalidConfigurationSetException' => [ 'base' => '<p>Indicates that the configuration set is invalid. See the error message for details.</p>', 'refs' => [], ], 'InvalidFirehoseDestinationException' => [ 'base' => '<p>Indicates that the Amazon Kinesis Firehose destination is invalid. See the error message for details.</p>', 'refs' => [], ], 'InvalidLambdaFunctionException' => [ 'base' => '<p>Indicates that the provided AWS Lambda function is invalid, or that Amazon SES could not execute the provided function, possibly due to permissions issues. For information about giving permissions, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'InvalidPolicyException' => [ 'base' => '<p>Indicates that the provided policy is invalid. Check the error stack for more information about what caused the error.</p>', 'refs' => [], ], 'InvalidS3ConfigurationException' => [ 'base' => '<p>Indicates that the provided Amazon S3 bucket or AWS KMS encryption key is invalid, or that Amazon SES could not publish to the bucket, possibly due to permissions issues. For information about giving permissions, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'InvalidSNSDestinationException' => [ 'base' => '<p>Indicates that the Amazon Simple Notification Service (Amazon SNS) destination is invalid. See the error message for details.</p>', 'refs' => [], ], 'InvalidSnsTopicException' => [ 'base' => '<p>Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES could not publish to the topic, possibly due to permissions issues. For information about giving permissions, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'InvocationType' => [ 'base' => NULL, 'refs' => [ 'LambdaAction$InvocationType' => '<p>The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code> means that the execution of the function will immediately result in a response, and a value of <code>Event</code> means that the function will be invoked asynchronously. The default value is <code>Event</code>. For information about AWS Lambda invocation types, see the <a href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.</p> <important> <p>There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use <code>Event</code> invocation in most cases. Use <code>RequestResponse</code> only when you want to make a mail flow decision, such as whether to stop the receipt rule or the receipt rule set.</p> </important>', ], ], 'KinesisFirehoseDestination' => [ 'base' => '<p>Contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.</p> <p>Event destinations, such as Amazon Kinesis Firehose, are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'EventDestination$KinesisFirehoseDestination' => '<p>An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.</p>', ], ], 'LambdaAction' => [ 'base' => '<p>When included in a receipt rule, this action calls an AWS Lambda function and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).</p> <p>To enable Amazon SES to call your AWS Lambda function or to publish to an Amazon SNS topic of another account, Amazon SES must have permission to access those resources. For information about giving permissions, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer Guide</a>.</p> <p>For information about using AWS Lambda actions in receipt rules, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'ReceiptAction$LambdaAction' => '<p>Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.</p>', ], ], 'LastAttemptDate' => [ 'base' => NULL, 'refs' => [ 'RecipientDsnFields$LastAttemptDate' => '<p>The time the final delivery attempt was made, in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a> date-time format.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>Indicates that a resource could not be created because of service limits. For a list of Amazon SES limits, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'ListConfigurationSetsRequest' => [ 'base' => '<p>Represents a request to list the configuration sets associated with your AWS account. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'ListConfigurationSetsResponse' => [ 'base' => '<p>A list of configuration sets associated with your AWS account. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'ListIdentitiesRequest' => [ 'base' => '<p>Represents a request to return a list of all identities (email addresses and domains) that you have attempted to verify under your AWS account, regardless of verification status.</p>', 'refs' => [], ], 'ListIdentitiesResponse' => [ 'base' => '<p>A list of all identities that you have attempted to verify under your AWS account, regardless of verification status.</p>', 'refs' => [], ], 'ListIdentityPoliciesRequest' => [ 'base' => '<p>Represents a request to return a list of sending authorization policies that are attached to an identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'ListIdentityPoliciesResponse' => [ 'base' => '<p>A list of names of sending authorization policies that apply to an identity.</p>', 'refs' => [], ], 'ListReceiptFiltersRequest' => [ 'base' => '<p>Represents a request to list the IP address filters that exist under your AWS account. You use IP address filters when you receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'ListReceiptFiltersResponse' => [ 'base' => '<p>A list of IP address filters that exist under your AWS account.</p>', 'refs' => [], ], 'ListReceiptRuleSetsRequest' => [ 'base' => '<p>Represents a request to list the receipt rule sets that exist under your AWS account. You use receipt rule sets to receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'ListReceiptRuleSetsResponse' => [ 'base' => '<p>A list of receipt rule sets that exist under your AWS account.</p>', 'refs' => [], ], 'ListVerifiedEmailAddressesResponse' => [ 'base' => '<p>A list of email addresses that you have verified with Amazon SES under your AWS account.</p>', 'refs' => [], ], 'MailFromDomainAttributes' => [ 'base' => NULL, 'refs' => [ 'GetIdentityMailFromDomainAttributesResponse$MailFromDomainAttributes' => '<p>A map of identities to custom MAIL FROM attributes.</p>', ], ], 'MailFromDomainName' => [ 'base' => NULL, 'refs' => [ 'IdentityMailFromDomainAttributes$MailFromDomain' => '<p>The custom MAIL FROM domain that the identity is configured to use.</p>', 'SetIdentityMailFromDomainRequest$MailFromDomain' => '<p>The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must 1) be a subdomain of the verified identity, 2) not be used in a "From" address if the MAIL FROM domain is the destination of email feedback forwarding (for more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>), and 3) not be used to receive emails. A value of <code>null</code> disables the custom MAIL FROM setting for the identity.</p>', ], ], 'MailFromDomainNotVerifiedException' => [ 'base' => '<p> Indicates that the message could not be sent because Amazon SES could not read the MX record required to use the specified MAIL FROM domain. For information about editing the custom MAIL FROM domain settings for an identity, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'Max24HourSend' => [ 'base' => NULL, 'refs' => [ 'GetSendQuotaResponse$Max24HourSend' => '<p>The maximum number of emails the user is allowed to send in a 24-hour interval. A value of -1 signifies an unlimited quota.</p>', ], ], 'MaxItems' => [ 'base' => NULL, 'refs' => [ 'ListConfigurationSetsRequest$MaxItems' => '<p>The number of configuration sets to return.</p>', 'ListIdentitiesRequest$MaxItems' => '<p>The maximum number of identities per page. Possible values are 1-1000 inclusive.</p>', ], ], 'MaxSendRate' => [ 'base' => NULL, 'refs' => [ 'GetSendQuotaResponse$MaxSendRate' => '<p>The maximum number of emails that Amazon SES can accept from the user\'s account per second.</p> <note> <p>The rate at which Amazon SES accepts the user\'s messages might be less than the maximum send rate.</p> </note>', ], ], 'Message' => [ 'base' => '<p>Represents the message to be sent, composed of a subject and a body.</p>', 'refs' => [ 'SendEmailRequest$Message' => '<p>The message to be sent.</p>', ], ], 'MessageData' => [ 'base' => NULL, 'refs' => [ 'Content$Data' => '<p>The textual data of the content.</p>', ], ], 'MessageDsn' => [ 'base' => '<p>Message-related information to include in the Delivery Status Notification (DSN) when an email that Amazon SES receives on your behalf bounces.</p> <p>For information about receiving email through Amazon SES, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'SendBounceRequest$MessageDsn' => '<p>Message-related DSN fields. If not specified, Amazon SES will choose the values.</p>', ], ], 'MessageId' => [ 'base' => NULL, 'refs' => [ 'SendBounceRequest$OriginalMessageId' => '<p>The message ID of the message to be bounced.</p>', 'SendBounceResponse$MessageId' => '<p>The message ID of the bounce message.</p>', 'SendEmailResponse$MessageId' => '<p>The unique message identifier returned from the <code>SendEmail</code> action. </p>', 'SendRawEmailResponse$MessageId' => '<p>The unique message identifier returned from the <code>SendRawEmail</code> action. </p>', ], ], 'MessageRejected' => [ 'base' => '<p>Indicates that the action failed, and the message could not be sent. Check the error stack for more information about what caused the error.</p>', 'refs' => [], ], 'MessageTag' => [ 'base' => '<p>Contains the name and value of a tag that you can provide to <code>SendEmail</code> or <code>SendRawEmail</code> to apply to an email.</p> <p>Message tags, which you use with configuration sets, enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'MessageTagList$member' => NULL, ], ], 'MessageTagList' => [ 'base' => NULL, 'refs' => [ 'SendEmailRequest$Tags' => '<p>A list of tags, in the form of name/value pairs, to apply to an email that you send using <code>SendEmail</code>. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>', 'SendRawEmailRequest$Tags' => '<p>A list of tags, in the form of name/value pairs, to apply to an email that you send using <code>SendRawEmail</code>. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>', ], ], 'MessageTagName' => [ 'base' => NULL, 'refs' => [ 'MessageTag$Name' => '<p>The name of the tag. The name must:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</p> </li> <li> <p>Contain less than 256 characters.</p> </li> </ul>', ], ], 'MessageTagValue' => [ 'base' => NULL, 'refs' => [ 'MessageTag$Value' => '<p>The value of the tag. The value must:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</p> </li> <li> <p>Contain less than 256 characters.</p> </li> </ul>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListConfigurationSetsRequest$NextToken' => '<p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position of the configuration set in the configuration set list.</p>', 'ListConfigurationSetsResponse$NextToken' => '<p>A token indicating that there are additional configuration sets available to be listed. Pass this token to successive calls of <code>ListConfigurationSets</code>. </p>', 'ListIdentitiesRequest$NextToken' => '<p>The token to use for pagination.</p>', 'ListIdentitiesResponse$NextToken' => '<p>The token used for pagination.</p>', 'ListReceiptRuleSetsRequest$NextToken' => '<p>A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate the position in the receipt rule set list.</p>', 'ListReceiptRuleSetsResponse$NextToken' => '<p>A token indicating that there are additional receipt rule sets available to be listed. Pass this token to successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a time.</p>', ], ], 'NotificationAttributes' => [ 'base' => NULL, 'refs' => [ 'GetIdentityNotificationAttributesResponse$NotificationAttributes' => '<p>A map of Identity to IdentityNotificationAttributes.</p>', ], ], 'NotificationTopic' => [ 'base' => NULL, 'refs' => [ 'IdentityNotificationAttributes$BounceTopic' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish bounce notifications.</p>', 'IdentityNotificationAttributes$ComplaintTopic' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish complaint notifications.</p>', 'IdentityNotificationAttributes$DeliveryTopic' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish delivery notifications.</p>', 'SetIdentityNotificationTopicRequest$SnsTopic' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter is omitted from the request or a null value is passed, <code>SnsTopic</code> is cleared and publishing is disabled.</p>', ], ], 'NotificationType' => [ 'base' => NULL, 'refs' => [ 'SetIdentityHeadersInNotificationsEnabledRequest$NotificationType' => '<p>The notification type for which to enable or disable headers in notifications. </p>', 'SetIdentityNotificationTopicRequest$NotificationType' => '<p>The type of notifications that will be published to the specified Amazon SNS topic.</p>', ], ], 'Policy' => [ 'base' => NULL, 'refs' => [ 'PolicyMap$value' => NULL, 'PutIdentityPolicyRequest$Policy' => '<p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p> <p>For information about the syntax of sending authorization policies, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>. </p>', ], ], 'PolicyMap' => [ 'base' => NULL, 'refs' => [ 'GetIdentityPoliciesResponse$Policies' => '<p>A map of policy names to policies.</p>', ], ], 'PolicyName' => [ 'base' => NULL, 'refs' => [ 'DeleteIdentityPolicyRequest$PolicyName' => '<p>The name of the policy to be deleted.</p>', 'PolicyMap$key' => NULL, 'PolicyNameList$member' => NULL, 'PutIdentityPolicyRequest$PolicyName' => '<p>The name of the policy.</p> <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>', ], ], 'PolicyNameList' => [ 'base' => NULL, 'refs' => [ 'GetIdentityPoliciesRequest$PolicyNames' => '<p>A list of the names of policies to be retrieved. You can retrieve a maximum of 20 policies at a time. If you do not know the names of the policies that are attached to the identity, you can use <code>ListIdentityPolicies</code>.</p>', 'ListIdentityPoliciesResponse$PolicyNames' => '<p>A list of names of policies that apply to the specified identity.</p>', ], ], 'PutIdentityPolicyRequest' => [ 'base' => '<p>Represents a request to add or update a sending authorization policy for an identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'PutIdentityPolicyResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'RawMessage' => [ 'base' => '<p>Represents the raw data of the message.</p>', 'refs' => [ 'SendRawEmailRequest$RawMessage' => '<p>The raw text of the message. The client is responsible for ensuring the following:</p> <ul> <li> <p>Message must contain a header and a body, separated by a blank line.</p> </li> <li> <p>All required header fields must be present.</p> </li> <li> <p>Each part of a multipart MIME message must be formatted properly.</p> </li> <li> <p>MIME content types must be among those supported by Amazon SES. For more information, go to the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html">Amazon SES Developer Guide</a>.</p> </li> <li> <p>Must be base64-encoded.</p> </li> <li> <p>Per <a href="https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6">RFC 5321</a>, the maximum length of each line of text, including the &lt;CRLF&gt;, must not exceed 1,000 characters.</p> </li> </ul>', ], ], 'RawMessageData' => [ 'base' => NULL, 'refs' => [ 'RawMessage$Data' => '<p>The raw data of the message. This data needs to base64-encoded if you are accessing Amazon SES directly through the HTTPS interface. If you are accessing Amazon SES using an AWS SDK, the SDK takes care of the base 64-encoding for you. In all cases, the client must ensure that the message format complies with Internet email standards regarding email header fields, MIME types, and MIME encoding.</p> <p>The To:, CC:, and BCC: headers in the raw message can contain a group list.</p> <p>If you are using <code>SendRawEmail</code> with sending authorization, you can include X-headers in the raw message to specify the "Source," "From," and "Return-Path" addresses. For more information, see the documentation for <code>SendRawEmail</code>. </p> <important> <p>Do not include these X-headers in the DKIM signature, because they are removed by Amazon SES before sending the email.</p> </important> <p>For more information, go to the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer Guide</a>. </p>', ], ], 'ReceiptAction' => [ 'base' => '<p>An action that Amazon SES can take when it receives an email on behalf of one or more email addresses or domains that you own. An instance of this data type can represent only one action.</p> <p>For information about setting up receipt rules, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'ReceiptActionsList$member' => NULL, ], ], 'ReceiptActionsList' => [ 'base' => NULL, 'refs' => [ 'ReceiptRule$Actions' => '<p>An ordered list of actions to perform on messages that match at least one of the recipient email addresses or domains specified in the receipt rule.</p>', ], ], 'ReceiptFilter' => [ 'base' => '<p>A receipt IP address filter enables you to specify whether to accept or reject mail originating from an IP address or range of IP addresses.</p> <p>For information about setting up IP address filters, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'CreateReceiptFilterRequest$Filter' => '<p>A data structure that describes the IP address filter to create, which consists of a name, an IP address range, and whether to allow or block mail from it.</p>', 'ReceiptFilterList$member' => NULL, ], ], 'ReceiptFilterList' => [ 'base' => NULL, 'refs' => [ 'ListReceiptFiltersResponse$Filters' => '<p>A list of IP address filter data structures, which each consist of a name, an IP address range, and whether to allow or block mail from it.</p>', ], ], 'ReceiptFilterName' => [ 'base' => NULL, 'refs' => [ 'DeleteReceiptFilterRequest$FilterName' => '<p>The name of the IP address filter to delete.</p>', 'ReceiptFilter$Name' => '<p>The name of the IP address filter. The name must:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-).</p> </li> <li> <p>Start and end with a letter or number.</p> </li> <li> <p>Contain less than 64 characters.</p> </li> </ul>', ], ], 'ReceiptFilterPolicy' => [ 'base' => NULL, 'refs' => [ 'ReceiptIpFilter$Policy' => '<p>Indicates whether to block or allow incoming mail from the specified IP addresses.</p>', ], ], 'ReceiptIpFilter' => [ 'base' => '<p>A receipt IP address filter enables you to specify whether to accept or reject mail originating from an IP address or range of IP addresses.</p> <p>For information about setting up IP address filters, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'ReceiptFilter$IpFilter' => '<p>A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail from them.</p>', ], ], 'ReceiptRule' => [ 'base' => '<p>Receipt rules enable you to specify which actions Amazon SES should take when it receives mail on behalf of one or more email addresses or domains that you own.</p> <p>Each receipt rule defines a set of email addresses or domains to which it applies. If the email addresses or domains match at least one recipient address of the message, Amazon SES executes all of the receipt rule\'s actions on the message.</p> <p>For information about setting up receipt rules, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'CreateReceiptRuleRequest$Rule' => '<p>A data structure that contains the specified rule\'s name, actions, recipients, domains, enabled status, scan status, and TLS policy.</p>', 'DescribeReceiptRuleResponse$Rule' => '<p>A data structure that contains the specified receipt rule\'s name, actions, recipients, domains, enabled status, scan status, and Transport Layer Security (TLS) policy.</p>', 'ReceiptRulesList$member' => NULL, 'UpdateReceiptRuleRequest$Rule' => '<p>A data structure that contains the updated receipt rule information.</p>', ], ], 'ReceiptRuleName' => [ 'base' => NULL, 'refs' => [ 'CreateReceiptRuleRequest$After' => '<p>The name of an existing rule after which the new rule will be placed. If this parameter is null, the new rule will be inserted at the beginning of the rule list.</p>', 'DeleteReceiptRuleRequest$RuleName' => '<p>The name of the receipt rule to delete.</p>', 'DescribeReceiptRuleRequest$RuleName' => '<p>The name of the receipt rule.</p>', 'ReceiptRule$Name' => '<p>The name of the receipt rule. The name must:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-).</p> </li> <li> <p>Start and end with a letter or number.</p> </li> <li> <p>Contain less than 64 characters.</p> </li> </ul>', 'ReceiptRuleNamesList$member' => NULL, 'SetReceiptRulePositionRequest$RuleName' => '<p>The name of the receipt rule to reposition.</p>', 'SetReceiptRulePositionRequest$After' => '<p>The name of the receipt rule after which to place the specified receipt rule.</p>', ], ], 'ReceiptRuleNamesList' => [ 'base' => NULL, 'refs' => [ 'ReorderReceiptRuleSetRequest$RuleNames' => '<p>A list of the specified receipt rule set\'s receipt rules in the order that you want to put them.</p>', ], ], 'ReceiptRuleSetMetadata' => [ 'base' => '<p>Information about a receipt rule set.</p> <p>A receipt rule set is a collection of rules that specify what Amazon SES should do with mail it receives on behalf of your account\'s verified domains.</p> <p>For information about setting up receipt rule sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'DescribeActiveReceiptRuleSetResponse$Metadata' => '<p>The metadata for the currently active receipt rule set. The metadata consists of the rule set name and a timestamp of when the rule set was created.</p>', 'DescribeReceiptRuleSetResponse$Metadata' => '<p>The metadata for the receipt rule set, which consists of the rule set name and the timestamp of when the rule set was created.</p>', 'ReceiptRuleSetsLists$member' => NULL, ], ], 'ReceiptRuleSetName' => [ 'base' => NULL, 'refs' => [ 'CloneReceiptRuleSetRequest$RuleSetName' => '<p>The name of the rule set to create. The name must:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-).</p> </li> <li> <p>Start and end with a letter or number.</p> </li> <li> <p>Contain less than 64 characters.</p> </li> </ul>', 'CloneReceiptRuleSetRequest$OriginalRuleSetName' => '<p>The name of the rule set to clone.</p>', 'CreateReceiptRuleRequest$RuleSetName' => '<p>The name of the rule set to which to add the rule.</p>', 'CreateReceiptRuleSetRequest$RuleSetName' => '<p>The name of the rule set to create. The name must:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-).</p> </li> <li> <p>Start and end with a letter or number.</p> </li> <li> <p>Contain less than 64 characters.</p> </li> </ul>', 'DeleteReceiptRuleRequest$RuleSetName' => '<p>The name of the receipt rule set that contains the receipt rule to delete.</p>', 'DeleteReceiptRuleSetRequest$RuleSetName' => '<p>The name of the receipt rule set to delete.</p>', 'DescribeReceiptRuleRequest$RuleSetName' => '<p>The name of the receipt rule set to which the receipt rule belongs.</p>', 'DescribeReceiptRuleSetRequest$RuleSetName' => '<p>The name of the receipt rule set to describe.</p>', 'ReceiptRuleSetMetadata$Name' => '<p>The name of the receipt rule set. The name must:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-).</p> </li> <li> <p>Start and end with a letter or number.</p> </li> <li> <p>Contain less than 64 characters.</p> </li> </ul>', 'ReorderReceiptRuleSetRequest$RuleSetName' => '<p>The name of the receipt rule set to reorder.</p>', 'SetActiveReceiptRuleSetRequest$RuleSetName' => '<p>The name of the receipt rule set to make active. Setting this value to null disables all email receiving.</p>', 'SetReceiptRulePositionRequest$RuleSetName' => '<p>The name of the receipt rule set that contains the receipt rule to reposition.</p>', 'UpdateReceiptRuleRequest$RuleSetName' => '<p>The name of the receipt rule set to which the receipt rule belongs.</p>', ], ], 'ReceiptRuleSetsLists' => [ 'base' => NULL, 'refs' => [ 'ListReceiptRuleSetsResponse$RuleSets' => '<p>The metadata for the currently active receipt rule set. The metadata consists of the rule set name and the timestamp of when the rule set was created.</p>', ], ], 'ReceiptRulesList' => [ 'base' => NULL, 'refs' => [ 'DescribeActiveReceiptRuleSetResponse$Rules' => '<p>The receipt rules that belong to the active rule set.</p>', 'DescribeReceiptRuleSetResponse$Rules' => '<p>A list of the receipt rules that belong to the specified receipt rule set.</p>', ], ], 'Recipient' => [ 'base' => NULL, 'refs' => [ 'RecipientsList$member' => NULL, ], ], 'RecipientDsnFields' => [ 'base' => '<p>Recipient-related information to include in the Delivery Status Notification (DSN) when an email that Amazon SES receives on your behalf bounces.</p> <p>For information about receiving email through Amazon SES, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'BouncedRecipientInfo$RecipientDsnFields' => '<p>Recipient-related DSN fields, most of which would normally be filled in automatically when provided with a <code>BounceType</code>. You must provide either this parameter or <code>BounceType</code>.</p>', ], ], 'RecipientsList' => [ 'base' => NULL, 'refs' => [ 'ReceiptRule$Recipients' => '<p>The recipient domains and email addresses to which the receipt rule applies. If this field is not specified, this rule will match all recipients under all verified domains.</p>', ], ], 'RemoteMta' => [ 'base' => NULL, 'refs' => [ 'RecipientDsnFields$RemoteMta' => '<p>The MTA to which the remote MTA attempted to deliver the message, formatted as specified in <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a> (<code>mta-name-type; mta-name</code>). This parameter typically applies only to propagating synchronous bounces.</p>', ], ], 'ReorderReceiptRuleSetRequest' => [ 'base' => '<p>Represents a request to reorder the receipt rules within a receipt rule set. You use receipt rule sets to receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'ReorderReceiptRuleSetResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'ReportingMta' => [ 'base' => NULL, 'refs' => [ 'MessageDsn$ReportingMta' => '<p>The reporting MTA that attempted to deliver the message, formatted as specified in <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a> (<code>mta-name-type; mta-name</code>). The default value is <code>dns; inbound-smtp.[region].amazonaws.com</code>.</p>', ], ], 'RuleDoesNotExistException' => [ 'base' => '<p>Indicates that the provided receipt rule does not exist.</p>', 'refs' => [], ], 'RuleOrRuleSetName' => [ 'base' => NULL, 'refs' => [ 'AlreadyExistsException$Name' => NULL, 'CannotDeleteException$Name' => NULL, 'RuleDoesNotExistException$Name' => NULL, 'RuleSetDoesNotExistException$Name' => NULL, ], ], 'RuleSetDoesNotExistException' => [ 'base' => '<p>Indicates that the provided receipt rule set does not exist.</p>', 'refs' => [], ], 'S3Action' => [ 'base' => '<p>When included in a receipt rule, this action saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).</p> <p>To enable Amazon SES to write emails to your Amazon S3 bucket, use an AWS KMS key to encrypt your emails, or publish to an Amazon SNS topic of another account, Amazon SES must have permission to access those resources. For information about giving permissions, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer Guide</a>.</p> <note> <p>When you save your emails to an Amazon S3 bucket, the maximum email size (including headers) is 30 MB. Emails larger than that will bounce.</p> </note> <p>For information about specifying Amazon S3 actions in receipt rules, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-s3.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'ReceiptAction$S3Action' => '<p>Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a notification to Amazon SNS.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'InvalidS3ConfigurationException$Bucket' => NULL, 'S3Action$BucketName' => '<p>The name of the Amazon S3 bucket to which to save the received email.</p>', ], ], 'S3KeyPrefix' => [ 'base' => NULL, 'refs' => [ 'S3Action$ObjectKeyPrefix' => '<p>The key prefix of the Amazon S3 bucket. The key prefix is similar to a directory name that enables you to store similar data under the same directory in a bucket.</p>', ], ], 'SNSAction' => [ 'base' => '<p>When included in a receipt rule, this action publishes a notification to Amazon Simple Notification Service (Amazon SNS). This action includes a complete copy of the email content in the Amazon SNS notifications. Amazon SNS notifications for all other actions simply provide information about the email. They do not include the email content itself.</p> <p>If you own the Amazon SNS topic, you don\'t need to do anything to give Amazon SES permission to publish emails to it. However, if you don\'t own the Amazon SNS topic, you need to attach a policy to the topic to give Amazon SES permissions to access it. For information about giving permissions, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer Guide</a>.</p> <important> <p>You can only publish emails that are 150 KB or less (including the header) to Amazon SNS. Larger emails will bounce. If you anticipate emails larger than 150 KB, use the S3 action instead.</p> </important> <p>For information about using a receipt rule to publish an Amazon SNS notification, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-sns.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'ReceiptAction$SNSAction' => '<p>Publishes the email content within a notification to Amazon SNS.</p>', ], ], 'SNSActionEncoding' => [ 'base' => NULL, 'refs' => [ 'SNSAction$Encoding' => '<p>The encoding to use for the email within the Amazon SNS notification. UTF-8 is easier to use, but may not preserve all special characters when a message was encoded with a different encoding format. Base64 preserves all special characters. The default value is UTF-8.</p>', ], ], 'SNSDestination' => [ 'base' => '<p>Contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event destination.</p> <p>Event destinations, such as Amazon SNS, are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'EventDestination$SNSDestination' => '<p>An object that contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event destination.</p>', ], ], 'SendBounceRequest' => [ 'base' => '<p>Represents a request to send a bounce message to the sender of an email you received through Amazon SES.</p>', 'refs' => [], ], 'SendBounceResponse' => [ 'base' => '<p>Represents a unique message ID.</p>', 'refs' => [], ], 'SendDataPoint' => [ 'base' => '<p>Represents sending statistics data. Each <code>SendDataPoint</code> contains statistics for a 15-minute period of sending activity. </p>', 'refs' => [ 'SendDataPointList$member' => NULL, ], ], 'SendDataPointList' => [ 'base' => NULL, 'refs' => [ 'GetSendStatisticsResponse$SendDataPoints' => '<p>A list of data points, each of which represents 15 minutes of activity.</p>', ], ], 'SendEmailRequest' => [ 'base' => '<p>Represents a request to send a single formatted email using Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'SendEmailResponse' => [ 'base' => '<p>Represents a unique message ID.</p>', 'refs' => [], ], 'SendRawEmailRequest' => [ 'base' => '<p>Represents a request to send a single raw email using Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'SendRawEmailResponse' => [ 'base' => '<p>Represents a unique message ID.</p>', 'refs' => [], ], 'SentLast24Hours' => [ 'base' => NULL, 'refs' => [ 'GetSendQuotaResponse$SentLast24Hours' => '<p>The number of emails sent during the previous 24 hours.</p>', ], ], 'SetActiveReceiptRuleSetRequest' => [ 'base' => '<p>Represents a request to set a receipt rule set as the active receipt rule set. You use receipt rule sets to receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'SetActiveReceiptRuleSetResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'SetIdentityDkimEnabledRequest' => [ 'base' => '<p>Represents a request to enable or disable Amazon SES Easy DKIM signing for an identity. For more information about setting up Easy DKIM, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'SetIdentityDkimEnabledResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'SetIdentityFeedbackForwardingEnabledRequest' => [ 'base' => '<p>Represents a request to enable or disable whether Amazon SES forwards you bounce and complaint notifications through email. For information about email feedback forwarding, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-email.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'SetIdentityFeedbackForwardingEnabledResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'SetIdentityHeadersInNotificationsEnabledRequest' => [ 'base' => '<p>Represents a request to set whether Amazon SES includes the original email headers in the Amazon SNS notifications of a specified type. For information about notifications, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'SetIdentityHeadersInNotificationsEnabledResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'SetIdentityMailFromDomainRequest' => [ 'base' => '<p>Represents a request to enable or disable the Amazon SES custom MAIL FROM domain setup for a verified identity. For information about using a custom MAIL FROM domain, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'SetIdentityMailFromDomainResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'SetIdentityNotificationTopicRequest' => [ 'base' => '<p>Represents a request to specify the Amazon SNS topic to which Amazon SES will publish bounce, complaint, or delivery notifications for emails sent with that identity as the Source. For information about Amazon SES notifications, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'SetIdentityNotificationTopicResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'SetReceiptRulePositionRequest' => [ 'base' => '<p>Represents a request to set the position of a receipt rule in a receipt rule set. You use receipt rule sets to receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'SetReceiptRulePositionResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'StopAction' => [ 'base' => '<p>When included in a receipt rule, this action terminates the evaluation of the receipt rule set and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).</p> <p>For information about setting a stop action in a receipt rule, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-stop.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'ReceiptAction$StopAction' => '<p>Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.</p>', ], ], 'StopScope' => [ 'base' => NULL, 'refs' => [ 'StopAction$Scope' => '<p>The scope to which the Stop action applies. That is, what is being stopped.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ReceiptRuleSetMetadata$CreatedTimestamp' => '<p>The date and time the receipt rule set was created.</p>', 'SendDataPoint$Timestamp' => '<p>Time of the data point.</p>', ], ], 'TlsPolicy' => [ 'base' => NULL, 'refs' => [ 'ReceiptRule$TlsPolicy' => '<p>Specifies whether Amazon SES should require that incoming email is delivered over a connection encrypted with Transport Layer Security (TLS). If this parameter is set to <code>Require</code>, Amazon SES will bounce emails that are not received over TLS. The default is <code>Optional</code>.</p>', ], ], 'UpdateConfigurationSetEventDestinationRequest' => [ 'base' => '<p>Represents a request to update the event destination of a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'UpdateConfigurationSetEventDestinationResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'UpdateReceiptRuleRequest' => [ 'base' => '<p>Represents a request to update a receipt rule. You use receipt rules to receive email with Amazon SES. For more information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'UpdateReceiptRuleResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'VerificationAttributes' => [ 'base' => NULL, 'refs' => [ 'GetIdentityVerificationAttributesResponse$VerificationAttributes' => '<p>A map of Identities to IdentityVerificationAttributes objects.</p>', ], ], 'VerificationStatus' => [ 'base' => NULL, 'refs' => [ 'IdentityDkimAttributes$DkimVerificationStatus' => '<p>Describes whether Amazon SES has successfully verified the DKIM DNS records (tokens) published in the domain name\'s DNS. (This only applies to domain identities, not email address identities.)</p>', 'IdentityVerificationAttributes$VerificationStatus' => '<p>The verification status of the identity: "Pending", "Success", "Failed", or "TemporaryFailure".</p>', ], ], 'VerificationToken' => [ 'base' => NULL, 'refs' => [ 'IdentityVerificationAttributes$VerificationToken' => '<p>The verification token for a domain identity. Null for email address identities.</p>', 'VerificationTokenList$member' => NULL, 'VerifyDomainIdentityResponse$VerificationToken' => '<p>A TXT record that you must place in the DNS settings of the domain to complete domain verification with Amazon SES.</p> <p>As Amazon SES searches for the TXT record, the domain\'s verification status is "Pending". When Amazon SES detects the record, the domain\'s verification status changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain\'s verification status changes to "Failed." In that case, if you still want to verify the domain, you must restart the verification process from the beginning.</p>', ], ], 'VerificationTokenList' => [ 'base' => NULL, 'refs' => [ 'IdentityDkimAttributes$DkimTokens' => '<p>A set of character strings that represent the domain\'s identity. Using these tokens, you will need to create DNS CNAME records that point to DKIM public keys hosted by Amazon SES. Amazon Web Services will eventually detect that you have updated your DNS records; this detection process may take up to 72 hours. Upon successful detection, Amazon SES will be able to DKIM-sign email originating from that domain. (This only applies to domain identities, not email address identities.)</p> <p>For more information about creating DNS records using DKIM tokens, go to the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer Guide</a>.</p>', 'VerifyDomainDkimResponse$DkimTokens' => '<p>A set of character strings that represent the domain\'s identity. If the identity is an email address, the tokens represent the domain of that address.</p> <p>Using these tokens, you will need to create DNS CNAME records that point to DKIM public keys hosted by Amazon SES. Amazon Web Services will eventually detect that you have updated your DNS records; this detection process may take up to 72 hours. Upon successful detection, Amazon SES will be able to DKIM-sign emails originating from that domain.</p> <p>For more information about creating DNS records using DKIM tokens, go to the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer Guide</a>.</p>', ], ], 'VerifyDomainDkimRequest' => [ 'base' => '<p>Represents a request to generate the CNAME records needed to set up Easy DKIM with Amazon SES. For more information about setting up Easy DKIM, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'VerifyDomainDkimResponse' => [ 'base' => '<p>Returns CNAME records that you must publish to the DNS server of your domain to set up Easy DKIM with Amazon SES.</p>', 'refs' => [], ], 'VerifyDomainIdentityRequest' => [ 'base' => '<p>Represents a request to begin Amazon SES domain verification and to generate the TXT records that you must publish to the DNS server of your domain to complete the verification. For information about domain verification, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'VerifyDomainIdentityResponse' => [ 'base' => '<p>Returns a TXT record that you must publish to the DNS server of your domain to complete domain verification with Amazon SES.</p>', 'refs' => [], ], 'VerifyEmailAddressRequest' => [ 'base' => '<p>Represents a request to begin email address verification with Amazon SES. For information about email address verification, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'VerifyEmailIdentityRequest' => [ 'base' => '<p>Represents a request to begin email address verification with Amazon SES. For information about email address verification, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'VerifyEmailIdentityResponse' => [ 'base' => '<p>An empty element returned on a successful request.</p>', 'refs' => [], ], 'WorkmailAction' => [ 'base' => '<p>When included in a receipt rule, this action calls Amazon WorkMail and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS). You will typically not use this action directly because Amazon WorkMail adds the rule automatically during its setup procedure.</p> <p>For information using a receipt rule to call Amazon WorkMail, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-workmail.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'ReceiptAction$WorkmailAction' => '<p>Calls Amazon WorkMail and, optionally, publishes a notification to Amazon SNS.</p>', ], ], ],];
