<?php
// This file was auto-generated from sdk-root/src/data/es/2015-01-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Elasticsearch Configuration Service</fullname> <p>Use the Amazon Elasticsearch configuration API to create, configure, and manage Elasticsearch domains.</p> <p>The endpoint for configuration service requests is region-specific: es.<i>region</i>.amazonaws.com. For example, es.us-east-1.amazonaws.com. For a current list of supported regions and endpoints, see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#elasticsearch-service-regions" target="_blank">Regions and Endpoints</a>.</p>', 'operations' => [ 'AddTags' => '<p>Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An Elasticsearch domain may have up to 10 tags. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging" target="_blank"> Tagging Amazon Elasticsearch Service Domains for more information.</a></p>', 'CreateElasticsearchDomain' => '<p>Creates a new Elasticsearch domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>', 'DeleteElasticsearchDomain' => '<p>Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot be recovered.</p>', 'DescribeElasticsearchDomain' => '<p>Returns domain configuration information about the specified Elasticsearch domain, including the domain ID, domain endpoint, and domain ARN.</p>', 'DescribeElasticsearchDomainConfig' => '<p>Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation date, update version, and update date for cluster options.</p>', 'DescribeElasticsearchDomains' => '<p>Returns domain configuration information about the specified Elasticsearch domains, including the domain ID, domain endpoint, and domain ARN.</p>', 'DescribeElasticsearchInstanceTypeLimits' => '<p> Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain, specify the <code> <a>DomainName</a> </code> to know what Limits are supported for modifying. </p>', 'ListDomainNames' => '<p>Returns the name of all Elasticsearch domains owned by the current user\'s account. </p>', 'ListElasticsearchInstanceTypes' => '<p>List all Elasticsearch instance types that are supported for given ElasticsearchVersion</p>', 'ListElasticsearchVersions' => '<p>List all supported Elasticsearch versions</p>', 'ListTags' => '<p>Returns all tags for the given Elasticsearch domain.</p>', 'RemoveTags' => '<p>Removes the specified set of tags from the specified Elasticsearch domain.</p>', 'UpdateElasticsearchDomainConfig' => '<p>Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type and the number of instances. </p>', ], 'shapes' => [ 'ARN' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the Elasticsearch domain. See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities</a> in <i>Using AWS Identity and Access Management</i> for more information.</p>', 'refs' => [ 'AddTagsRequest$ARN' => '<p> Specify the <code>ARN</code> for which you want to add the tags.</p>', 'ElasticsearchDomainStatus$ARN' => '<p>The Amazon resource name (ARN) of an Elasticsearch domain. See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities</a> in <i>Using AWS Identity and Access Management</i> for more information.</p>', 'ListTagsRequest$ARN' => '<p> Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view.</p>', 'RemoveTagsRequest$ARN' => '<p>Specifies the <code>ARN</code> for the Elasticsearch domain from which you want to delete the specified tags.</p>', ], ], 'AccessPoliciesStatus' => [ 'base' => '<p>The configured access rules for the domain\'s document and search endpoints, and the current status of those rules.</p>', 'refs' => [ 'ElasticsearchDomainConfig$AccessPolicies' => '<p>IAM access policy as a JSON-formatted string.</p>', ], ], 'AddTagsRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>AddTags</a></code> operation. Specify the tags that you want to attach to the Elasticsearch domain.</p>', 'refs' => [], ], 'AdditionalLimit' => [ 'base' => '<p> List of limits that are specific to a given InstanceType and for each of it\'s <code> <a>InstanceRole</a> </code> . </p>', 'refs' => [ 'AdditionalLimitList$member' => NULL, ], ], 'AdditionalLimitList' => [ 'base' => NULL, 'refs' => [ 'Limits$AdditionalLimits' => '<p> List of additional limits that are specific to a given InstanceType and for each of it\'s <code> <a>InstanceRole</a> </code> . </p>', ], ], 'AdvancedOptions' => [ 'base' => '<p> Exposes select native Elasticsearch configuration values from <code>elasticsearch.yml</code>. Currently, the following advanced options are available:</p> <ul> <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</li> <li>Option to specify the percentage of heap space that is allocated to field data. By default, this setting is unbounded.</li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options">Configuring Advanced Options</a>.</p>', 'refs' => [ 'AdvancedOptionsStatus$Options' => '<p> Specifies the status of advanced options for the specified Elasticsearch domain.</p>', 'CreateElasticsearchDomainRequest$AdvancedOptions' => '<p> Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>', 'ElasticsearchDomainStatus$AdvancedOptions' => '<p>Specifies the status of the <code>AdvancedOptions</code></p>', 'UpdateElasticsearchDomainConfigRequest$AdvancedOptions' => '<p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>', ], ], 'AdvancedOptionsStatus' => [ 'base' => '<p> Status of the advanced options for the specified Elasticsearch domain. Currently, the following advanced options are available:</p> <ul> <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</li> <li>Option to specify the percentage of heap space that is allocated to field data. By default, this setting is unbounded.</li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options">Configuring Advanced Options</a>.</p>', 'refs' => [ 'ElasticsearchDomainConfig$AdvancedOptions' => '<p>Specifies the <code>AdvancedOptions</code> for the domain. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuring Advanced Options</a> for more information.</p>', ], ], 'BaseException' => [ 'base' => '<p>An error occurred while processing the request.</p>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'EBSOptions$EBSEnabled' => '<p>Specifies whether EBS-based storage is enabled.</p>', 'ElasticsearchClusterConfig$DedicatedMasterEnabled' => '<p>A boolean value to indicate whether a dedicated master node is enabled. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes" target="_blank">About Dedicated Master Nodes</a> for more information.</p>', 'ElasticsearchClusterConfig$ZoneAwarenessEnabled' => '<p>A boolean value to indicate whether zone awareness is enabled. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness" target="_blank">About Zone Awareness</a> for more information.</p>', 'ElasticsearchDomainStatus$Created' => '<p>The domain creation status. <code>True</code> if the creation of an Elasticsearch domain is complete. <code>False</code> if domain creation is still in progress.</p>', 'ElasticsearchDomainStatus$Deleted' => '<p>The domain deletion status. <code>True</code> if a delete request has been received for the domain but resource cleanup is still in progress. <code>False</code> if the domain has not been deleted. Once domain deletion is complete, the status of the domain is no longer returned.</p>', 'ElasticsearchDomainStatus$Processing' => '<p>The status of the Elasticsearch domain configuration. <code>True</code> if Amazon Elasticsearch Service is processing configuration changes. <code>False</code> if the configuration is active.</p>', 'OptionStatus$PendingDeletion' => '<p>Indicates whether the Elasticsearch domain is being deleted.</p>', ], ], 'CreateElasticsearchDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateElasticsearchDomainResponse' => [ 'base' => '<p>The result of a <code>CreateElasticsearchDomain</code> operation. Contains the status of the newly created Elasticsearch domain.</p>', 'refs' => [], ], 'DeleteElasticsearchDomainRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>DeleteElasticsearchDomain</a></code> operation. Specifies the name of the Elasticsearch domain that you want to delete.</p>', 'refs' => [], ], 'DeleteElasticsearchDomainResponse' => [ 'base' => '<p>The result of a <code>DeleteElasticsearchDomain</code> request. Contains the status of the pending deletion, or no status if the domain and all of its resources have been deleted.</p>', 'refs' => [], ], 'DescribeElasticsearchDomainConfigRequest' => [ 'base' => '<p> Container for the parameters to the <code>DescribeElasticsearchDomainConfig</code> operation. Specifies the domain name for which you want configuration information.</p>', 'refs' => [], ], 'DescribeElasticsearchDomainConfigResponse' => [ 'base' => '<p>The result of a <code>DescribeElasticsearchDomainConfig</code> request. Contains the configuration information of the requested domain.</p>', 'refs' => [], ], 'DescribeElasticsearchDomainRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>DescribeElasticsearchDomain</a></code> operation.</p>', 'refs' => [], ], 'DescribeElasticsearchDomainResponse' => [ 'base' => '<p>The result of a <code>DescribeElasticsearchDomain</code> request. Contains the status of the domain specified in the request.</p>', 'refs' => [], ], 'DescribeElasticsearchDomainsRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>DescribeElasticsearchDomains</a></code> operation. By default, the API returns the status of all Elasticsearch domains.</p>', 'refs' => [], ], 'DescribeElasticsearchDomainsResponse' => [ 'base' => '<p>The result of a <code>DescribeElasticsearchDomains</code> request. Contains the status of the specified domains or all domains owned by the account.</p>', 'refs' => [], ], 'DescribeElasticsearchInstanceTypeLimitsRequest' => [ 'base' => '<p> Container for the parameters to <code> <a>DescribeElasticsearchInstanceTypeLimits</a> </code> operation. </p>', 'refs' => [], ], 'DescribeElasticsearchInstanceTypeLimitsResponse' => [ 'base' => '<p> Container for the parameters received from <code> <a>DescribeElasticsearchInstanceTypeLimits</a> </code> operation. </p>', 'refs' => [], ], 'DisabledOperationException' => [ 'base' => '<p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>', 'refs' => [], ], 'DomainId' => [ 'base' => '<p>Unique identifier for an Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainStatus$DomainId' => '<p>The unique identifier for the specified Elasticsearch domain.</p>', ], ], 'DomainInfo' => [ 'base' => NULL, 'refs' => [ 'DomainInfoList$member' => NULL, ], ], 'DomainInfoList' => [ 'base' => '<p> Contains the list of Elasticsearch domain information.</p>', 'refs' => [ 'ListDomainNamesResponse$DomainNames' => '<p>List of Elasticsearch domain names.</p>', ], ], 'DomainName' => [ 'base' => '<p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>', 'refs' => [ 'CreateElasticsearchDomainRequest$DomainName' => '<p>The name of the Elasticsearch domain that you are creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>', 'DeleteElasticsearchDomainRequest$DomainName' => '<p>The name of the Elasticsearch domain that you want to permanently delete.</p>', 'DescribeElasticsearchDomainConfigRequest$DomainName' => '<p>The Elasticsearch domain that you want to get information about.</p>', 'DescribeElasticsearchDomainRequest$DomainName' => '<p>The name of the Elasticsearch domain for which you want information.</p>', 'DescribeElasticsearchInstanceTypeLimitsRequest$DomainName' => '<p> DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for Elasticsearch <code> <a>Limits</a> </code> for existing domain. </p>', 'DomainInfo$DomainName' => '<p> Specifies the <code>DomainName</code>.</p>', 'DomainNameList$member' => NULL, 'ElasticsearchDomainStatus$DomainName' => '<p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>', 'ListElasticsearchInstanceTypesRequest$DomainName' => '<p>DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for list of available Elasticsearch instance types when modifying existing domain. </p>', 'UpdateElasticsearchDomainConfigRequest$DomainName' => '<p>The name of the Elasticsearch domain that you are updating. </p>', ], ], 'DomainNameList' => [ 'base' => '<p>A list of Elasticsearch domain names.</p>', 'refs' => [ 'DescribeElasticsearchDomainsRequest$DomainNames' => '<p>The Elasticsearch domains for which you want information.</p>', ], ], 'EBSOptions' => [ 'base' => '<p>Options to enable, disable, and specify the properties of EBS storage volumes. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs" target="_blank"> Configuring EBS-based Storage</a>.</p>', 'refs' => [ 'CreateElasticsearchDomainRequest$EBSOptions' => '<p>Options to enable, disable and specify the type and size of EBS storage volumes. </p>', 'EBSOptionsStatus$Options' => '<p> Specifies the EBS options for the specified Elasticsearch domain.</p>', 'ElasticsearchDomainStatus$EBSOptions' => '<p>The <code>EBSOptions</code> for the specified domain. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs" target="_blank">Configuring EBS-based Storage</a> for more information.</p>', 'UpdateElasticsearchDomainConfigRequest$EBSOptions' => '<p>Specify the type and size of the EBS volume that you want to use. </p>', ], ], 'EBSOptionsStatus' => [ 'base' => '<p> Status of the EBS options for the specified Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainConfig$EBSOptions' => '<p>Specifies the <code>EBSOptions</code> for the Elasticsearch domain.</p>', ], ], 'ESPartitionInstanceType' => [ 'base' => NULL, 'refs' => [ 'DescribeElasticsearchInstanceTypeLimitsRequest$InstanceType' => '<p> The instance type for an Elasticsearch cluster for which Elasticsearch <code> <a>Limits</a> </code> are needed. </p>', 'ElasticsearchClusterConfig$InstanceType' => '<p>The instance type for an Elasticsearch cluster.</p>', 'ElasticsearchClusterConfig$DedicatedMasterType' => '<p>The instance type for a dedicated master node.</p>', 'ElasticsearchInstanceTypeList$member' => NULL, ], ], 'ElasticsearchClusterConfig' => [ 'base' => '<p>Specifies the configuration for the domain cluster, such as the type and number of instances.</p>', 'refs' => [ 'CreateElasticsearchDomainRequest$ElasticsearchClusterConfig' => '<p>Configuration options for an Elasticsearch domain. Specifies the instance type and number of instances in the domain cluster. </p>', 'ElasticsearchClusterConfigStatus$Options' => '<p> Specifies the cluster configuration for the specified Elasticsearch domain.</p>', 'ElasticsearchDomainStatus$ElasticsearchClusterConfig' => '<p>The type and number of instances in the domain cluster.</p>', 'UpdateElasticsearchDomainConfigRequest$ElasticsearchClusterConfig' => '<p>The type and number of instances to instantiate for the domain cluster.</p>', ], ], 'ElasticsearchClusterConfigStatus' => [ 'base' => '<p> Specifies the configuration status for the specified Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainConfig$ElasticsearchClusterConfig' => '<p>Specifies the <code>ElasticsearchClusterConfig</code> for the Elasticsearch domain.</p>', ], ], 'ElasticsearchDomainConfig' => [ 'base' => '<p>The configuration of an Elasticsearch domain.</p>', 'refs' => [ 'DescribeElasticsearchDomainConfigResponse$DomainConfig' => '<p>The configuration information of the domain requested in the <code>DescribeElasticsearchDomainConfig</code> request.</p>', 'UpdateElasticsearchDomainConfigResponse$DomainConfig' => '<p>The status of the updated Elasticsearch domain. </p>', ], ], 'ElasticsearchDomainStatus' => [ 'base' => '<p>The current status of an Elasticsearch domain.</p>', 'refs' => [ 'CreateElasticsearchDomainResponse$DomainStatus' => '<p>The status of the newly created Elasticsearch domain. </p>', 'DeleteElasticsearchDomainResponse$DomainStatus' => '<p>The status of the Elasticsearch domain being deleted.</p>', 'DescribeElasticsearchDomainResponse$DomainStatus' => '<p>The current status of the Elasticsearch domain.</p>', 'ElasticsearchDomainStatusList$member' => NULL, ], ], 'ElasticsearchDomainStatusList' => [ 'base' => '<p>A list that contains the status of each requested Elasticsearch domain.</p>', 'refs' => [ 'DescribeElasticsearchDomainsResponse$DomainStatusList' => '<p>The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.</p>', ], ], 'ElasticsearchInstanceTypeList' => [ 'base' => '<p> List of instance types supported by Amazon Elasticsearch service. </p>', 'refs' => [ 'ListElasticsearchInstanceTypesResponse$ElasticsearchInstanceTypes' => '<p> List of instance types supported by Amazon Elasticsearch service for given <code> <a>ElasticsearchVersion</a> </code> </p>', ], ], 'ElasticsearchVersionList' => [ 'base' => '<p>List of supported elastic search versions. </p>', 'refs' => [ 'ListElasticsearchVersionsResponse$ElasticsearchVersions' => NULL, ], ], 'ElasticsearchVersionStatus' => [ 'base' => '<p> Status of the Elasticsearch version options for the specified Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainConfig$ElasticsearchVersion' => '<p>String of format X.Y to specify version for the Elasticsearch domain.</p>', ], ], 'ElasticsearchVersionString' => [ 'base' => NULL, 'refs' => [ 'CreateElasticsearchDomainRequest$ElasticsearchVersion' => '<p>String of format X.Y to specify version for the Elasticsearch domain eg. "1.5" or "2.3". For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>', 'DescribeElasticsearchInstanceTypeLimitsRequest$ElasticsearchVersion' => '<p> Version of Elasticsearch for which <code> <a>Limits</a> </code> are needed. </p>', 'ElasticsearchDomainStatus$ElasticsearchVersion' => NULL, 'ElasticsearchVersionList$member' => NULL, 'ElasticsearchVersionStatus$Options' => '<p> Specifies the Elasticsearch version for the specified Elasticsearch domain.</p>', 'ListElasticsearchInstanceTypesRequest$ElasticsearchVersion' => '<p>Version of Elasticsearch for which list of supported elasticsearch instance types are needed. </p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BaseException$message' => '<p>A description of the error.</p>', ], ], 'InstanceCountLimits' => [ 'base' => '<p> InstanceCountLimits represents the limits on number of instances that be created in Amazon Elasticsearch for given InstanceType. </p>', 'refs' => [ 'InstanceLimits$InstanceCountLimits' => NULL, ], ], 'InstanceLimits' => [ 'base' => '<p>InstanceLimits represents the list of instance related attributes that are available for given InstanceType. </p>', 'refs' => [ 'Limits$InstanceLimits' => NULL, ], ], 'InstanceRole' => [ 'base' => NULL, 'refs' => [ 'LimitsByRole$key' => NULL, ], ], 'IntegerClass' => [ 'base' => NULL, 'refs' => [ 'EBSOptions$VolumeSize' => '<p> Integer to specify the size of an EBS volume.</p>', 'EBSOptions$Iops' => '<p>Specifies the IOPD for a Provisioned IOPS EBS volume (SSD).</p>', 'ElasticsearchClusterConfig$InstanceCount' => '<p>The number of instances in the specified domain cluster.</p>', 'ElasticsearchClusterConfig$DedicatedMasterCount' => '<p>Total number of dedicated master nodes, active and on standby, for the cluster.</p>', 'SnapshotOptions$AutomatedSnapshotStartHour' => '<p>Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified Elasticsearch domain. Default value is <code>0</code> hours.</p>', ], ], 'InternalException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>', 'refs' => [], ], 'InvalidTypeException' => [ 'base' => '<p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>', 'refs' => [], ], 'LimitExceededException' => [ 'base' => '<p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>', 'refs' => [], ], 'LimitName' => [ 'base' => NULL, 'refs' => [ 'AdditionalLimit$LimitName' => '<p> Name of Additional Limit is specific to a given InstanceType and for each of it\'s <code> <a>InstanceRole</a> </code> etc. <br/> Attributes and their details: <br/> <ul> <li>MaximumNumberOfDataNodesSupported</li> This attribute will be present in Master node only to specify how much data nodes upto which given <code> <a>ESPartitionInstanceType</a> </code> can support as master node. <li>MaximumNumberOfDataNodesWithoutMasterNode</li> This attribute will be present in Data node only to specify how much data nodes of given <code> <a>ESPartitionInstanceType</a> </code> upto which you don\'t need any master nodes to govern them. </ul> </p>', 'StorageTypeLimit$LimitName' => '<p> Name of storage limits that are applicable for given storage type. If <code> <a>StorageType</a> </code> is ebs, following storage options are applicable <ol> <li>MinimumVolumeSize</li> Minimum amount of volume size that is applicable for given storage type.It can be empty if it is not applicable. <li>MaximumVolumeSize</li> Maximum amount of volume size that is applicable for given storage type.It can be empty if it is not applicable. <li>MaximumIops</li> Maximum amount of Iops that is applicable for given storage type.It can be empty if it is not applicable. <li>MinimumIops</li> Minimum amount of Iops that is applicable for given storage type.It can be empty if it is not applicable. </ol> </p>', ], ], 'LimitValue' => [ 'base' => NULL, 'refs' => [ 'LimitValueList$member' => NULL, ], ], 'LimitValueList' => [ 'base' => NULL, 'refs' => [ 'AdditionalLimit$LimitValues' => '<p> Value for given <code> <a>AdditionalLimit$LimitName</a> </code> . </p>', 'StorageTypeLimit$LimitValues' => '<p> Values for the <code> <a>StorageTypeLimit$LimitName</a> </code> . </p>', ], ], 'Limits' => [ 'base' => '<p> Limits for given InstanceType and for each of it\'s role. <br/> Limits contains following <code> <a>StorageTypes,</a> </code> <code> <a>InstanceLimits</a> </code> and <code> <a>AdditionalLimits</a> </code> </p>', 'refs' => [ 'LimitsByRole$value' => NULL, ], ], 'LimitsByRole' => [ 'base' => '<p> Map of Role of the Instance and Limits that are applicable. Role performed by given Instance in Elasticsearch can be one of the following: <ul> <li>Data: If the given InstanceType is used as Data node</li> <li>Master: If the given InstanceType is used as Master node</li> </ul> </p>', 'refs' => [ 'DescribeElasticsearchInstanceTypeLimitsResponse$LimitsByRole' => NULL, ], ], 'ListDomainNamesResponse' => [ 'base' => '<p>The result of a <code>ListDomainNames</code> operation. Contains the names of all Elasticsearch domains owned by this account.</p>', 'refs' => [], ], 'ListElasticsearchInstanceTypesRequest' => [ 'base' => '<p> Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code> operation. </p>', 'refs' => [], ], 'ListElasticsearchInstanceTypesResponse' => [ 'base' => '<p> Container for the parameters returned by <code> <a>ListElasticsearchInstanceTypes</a> </code> operation. </p>', 'refs' => [], ], 'ListElasticsearchVersionsRequest' => [ 'base' => '<p> Container for the parameters to the <code> <a>ListElasticsearchVersions</a> </code> operation. <p> Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single call. </p> <p> Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does not contain a NextToken, then there are no more results to retrieve. </p> </p>', 'refs' => [], ], 'ListElasticsearchVersionsResponse' => [ 'base' => '<p> Container for the parameters for response received from <code> <a>ListElasticsearchVersions</a> </code> operation. </p>', 'refs' => [], ], 'ListTagsRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>ListTags</a></code> operation. Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view are attached.</p>', 'refs' => [], ], 'ListTagsResponse' => [ 'base' => '<p>The result of a <code>ListTags</code> operation. Contains tags for all requested Elasticsearch domains.</p>', 'refs' => [], ], 'MaxResults' => [ 'base' => '<p> Set this value to limit the number of results returned. </p>', 'refs' => [ 'ListElasticsearchInstanceTypesRequest$MaxResults' => '<p> Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont be honored. </p>', 'ListElasticsearchVersionsRequest$MaxResults' => '<p> Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored. </p>', ], ], 'MaximumInstanceCount' => [ 'base' => '<p> Maximum number of Instances that can be instantiated for given InstanceType. </p>', 'refs' => [ 'InstanceCountLimits$MaximumInstanceCount' => NULL, ], ], 'MinimumInstanceCount' => [ 'base' => '<p> Minimum number of Instances that can be instantiated for given InstanceType. </p>', 'refs' => [ 'InstanceCountLimits$MinimumInstanceCount' => NULL, ], ], 'NextToken' => [ 'base' => '<p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>', 'refs' => [ 'ListElasticsearchInstanceTypesRequest$NextToken' => '<p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. </p>', 'ListElasticsearchInstanceTypesResponse$NextToken' => '<p>In case if there are more results available NextToken would be present, make further request to the same API with received NextToken to paginate remaining results. </p>', 'ListElasticsearchVersionsRequest$NextToken' => NULL, 'ListElasticsearchVersionsResponse$NextToken' => NULL, ], ], 'OptionState' => [ 'base' => '<p>The state of a requested change. One of the following:</p> <ul> <li>Processing: The request change is still in-process.</li> <li>Active: The request change is processed and deployed to the Elasticsearch domain.</li> </ul>', 'refs' => [ 'OptionStatus$State' => '<p>Provides the <code>OptionState</code> for the Elasticsearch domain.</p>', ], ], 'OptionStatus' => [ 'base' => '<p>Provides the current status of the entity.</p>', 'refs' => [ 'AccessPoliciesStatus$Status' => '<p>The status of the access policy for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that\'s included. </p>', 'AdvancedOptionsStatus$Status' => '<p> Specifies the status of <code>OptionStatus</code> for advanced options for the specified Elasticsearch domain.</p>', 'EBSOptionsStatus$Status' => '<p> Specifies the status of the EBS options for the specified Elasticsearch domain.</p>', 'ElasticsearchClusterConfigStatus$Status' => '<p> Specifies the status of the configuration for the specified Elasticsearch domain.</p>', 'ElasticsearchVersionStatus$Status' => '<p> Specifies the status of the Elasticsearch version options for the specified Elasticsearch domain.</p>', 'SnapshotOptionsStatus$Status' => '<p>Specifies the status of a daily automated snapshot.</p>', ], ], 'PolicyDocument' => [ 'base' => '<p>Access policy rules for an Elasticsearch domain service endpoints. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies" target="_blank">Configuring Access Policies</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>. The maximum size of a policy document is 100 KB.</p>', 'refs' => [ 'AccessPoliciesStatus$Options' => '<p>The access policy configured for the Elasticsearch domain. Access policies may be resource-based, IP-based, or IAM-based. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies" target="_blank"> Configuring Access Policies</a>for more information.</p>', 'CreateElasticsearchDomainRequest$AccessPolicies' => '<p> IAM access policy as a JSON-formatted string.</p>', 'ElasticsearchDomainStatus$AccessPolicies' => '<p> IAM access policy as a JSON-formatted string.</p>', 'UpdateElasticsearchDomainConfigRequest$AccessPolicies' => '<p>IAM access policy as a JSON-formatted string.</p>', ], ], 'RemoveTagsRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>RemoveTags</a></code> operation. Specify the <code>ARN</code> for the Elasticsearch domain from which you want to remove the specified <code>TagKey</code>.</p>', 'refs' => [], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>An exception for creating a resource that already exists. Gives http status code of 400.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>', 'refs' => [], ], 'ServiceUrl' => [ 'base' => '<p>The endpoint to which service requests are submitted. For example, <code>search-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.es.amazonaws.com</code> or <code>doc-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.es.amazonaws.com</code>.</p>', 'refs' => [ 'ElasticsearchDomainStatus$Endpoint' => '<p>The Elasticsearch domain endpoint that you use to submit index and search requests.</p>', ], ], 'SnapshotOptions' => [ 'base' => '<p>Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified Elasticsearch domain. Default value is <code>0</code> hours.</p>', 'refs' => [ 'CreateElasticsearchDomainRequest$SnapshotOptions' => '<p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours. </p>', 'ElasticsearchDomainStatus$SnapshotOptions' => '<p>Specifies the status of the <code>SnapshotOptions</code></p>', 'SnapshotOptionsStatus$Options' => '<p>Specifies the daily snapshot options specified for the Elasticsearch domain.</p>', 'UpdateElasticsearchDomainConfigRequest$SnapshotOptions' => '<p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>', ], ], 'SnapshotOptionsStatus' => [ 'base' => '<p>Status of a daily automated snapshot.</p>', 'refs' => [ 'ElasticsearchDomainConfig$SnapshotOptions' => '<p>Specifies the <code>SnapshotOptions</code> for the Elasticsearch domain.</p>', ], ], 'StorageSubTypeName' => [ 'base' => '<p> SubType of the given storage type. List of available sub-storage options: For "instance" storageType we wont have any storageSubType, in case of "ebs" storageType we will have following valid storageSubTypes <ol> <li>standard</li> <li>gp2</li> <li>io1</li> </ol> Refer <code><a>VolumeType</a></code> for more information regarding above EBS storage options. </p>', 'refs' => [ 'StorageType$StorageSubTypeName' => NULL, ], ], 'StorageType' => [ 'base' => '<p>StorageTypes represents the list of storage related types and their attributes that are available for given InstanceType. </p>', 'refs' => [ 'StorageTypeList$member' => NULL, ], ], 'StorageTypeLimit' => [ 'base' => '<p>Limits that are applicable for given storage type. </p>', 'refs' => [ 'StorageTypeLimitList$member' => NULL, ], ], 'StorageTypeLimitList' => [ 'base' => NULL, 'refs' => [ 'StorageType$StorageTypeLimits' => '<p>List of limits that are applicable for given storage type. </p>', ], ], 'StorageTypeList' => [ 'base' => NULL, 'refs' => [ 'Limits$StorageTypes' => '<p>StorageType represents the list of storage related types and attributes that are available for given InstanceType. </p>', ], ], 'StorageTypeName' => [ 'base' => '<p> Type of the storage. List of available storage options: <ol> <li>instance</li> Inbuilt storage available for the given Instance <li>ebs</li> Elastic block storage that would be attached to the given Instance </ol> </p>', 'refs' => [ 'StorageType$StorageTypeName' => NULL, ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AdvancedOptions$key' => NULL, 'AdvancedOptions$value' => NULL, 'StringList$member' => NULL, ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsRequest$TagKeys' => '<p>Specifies the <code>TagKey</code> list which you want to remove from the Elasticsearch domain.</p>', ], ], 'Tag' => [ 'base' => '<p>Specifies a key value pair for a resource tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => '<p>A string of length from 1 to 128 characters that specifies the key for a Tag. Tag keys must be unique for the Elasticsearch domain to which they are attached.</p>', 'refs' => [ 'Tag$Key' => '<p>Specifies the <code>TagKey</code>, the name of the tag. Tag keys must be unique for the Elasticsearch domain to which they are attached.</p>', ], ], 'TagList' => [ 'base' => '<p>A list of <code>Tag</code> </p>', 'refs' => [ 'AddTagsRequest$TagList' => '<p> List of <code>Tag</code> that need to be added for the Elasticsearch domain. </p>', 'ListTagsResponse$TagList' => '<p> List of <code>Tag</code> for the requested Elasticsearch domain.</p>', ], ], 'TagValue' => [ 'base' => '<p>A string of length from 0 to 256 characters that specifies the value for a Tag. Tag values can be null and do not have to be unique in a tag set.</p>', 'refs' => [ 'Tag$Value' => '<p>Specifies the <code>TagValue</code>, the value assigned to the corresponding tag key. Tag values can be null and do not have to be unique in a tag set. For example, you can have a key value pair in a tag set of <code>project : Trinity</code> and <code>cost-center : Trinity</code></p>', ], ], 'UIntValue' => [ 'base' => NULL, 'refs' => [ 'OptionStatus$UpdateVersion' => '<p>Specifies the latest version for the entity.</p>', ], ], 'UpdateElasticsearchDomainConfigRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>UpdateElasticsearchDomain</a></code> operation. Specifies the type and number of instances in the domain cluster.</p>', 'refs' => [], ], 'UpdateElasticsearchDomainConfigResponse' => [ 'base' => '<p>The result of an <code>UpdateElasticsearchDomain</code> request. Contains the status of the Elasticsearch domain being updated.</p>', 'refs' => [], ], 'UpdateTimestamp' => [ 'base' => NULL, 'refs' => [ 'OptionStatus$CreationDate' => '<p>Timestamp which tells the creation date for the entity.</p>', 'OptionStatus$UpdateDate' => '<p>Timestamp which tells the last updated time for the entity.</p>', ], ], 'ValidationException' => [ 'base' => '<p>An exception for missing / invalid input fields. Gives http status code of 400.</p>', 'refs' => [], ], 'VolumeType' => [ 'base' => '<p> The type of EBS volume, standard, gp2, or io1. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs" target="_blank">Configuring EBS-based Storage</a>for more information.</p>', 'refs' => [ 'EBSOptions$VolumeType' => '<p> Specifies the volume type for EBS-based storage.</p>', ], ], ],];
