<?php
// This file was auto-generated from sdk-root/src/data/gamelift/2015-10-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon GameLift Service</fullname> <p> Amazon GameLift is a managed service for developers who need a scalable, dedicated server solution for their multiplayer games. Amazon GameLift provides tools for the following tasks: (1) acquire computing resources and deploy game servers, (2) scale game server capacity to meet player demand, (3) host game sessions and manage player access, and (4) track in-depth metrics on player usage and server performance.</p> <p>The Amazon GameLift service API includes two important function sets:</p> <ul> <li> <p> <b>Manage game sessions and player access</b> – Retrieve information on available game sessions; create new game sessions; send player requests to join a game session.</p> </li> <li> <p> <b>Configure and manage game server resources</b> – Manage builds, fleets, queues, and aliases; set autoscaling policies; retrieve logs and metrics.</p> </li> </ul> <p>This reference guide describes the low-level service API for Amazon GameLift. You can use the API functionality with these tools: </p> <ul> <li> <p>The Amazon Web Services software development kit (<a href="http://aws.amazon.com/tools/#sdk">AWS SDK</a>) is available in <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-supported.html#gamelift-supported-clients">multiple languages</a> including C++ and C#. Use the SDK to access the API programmatically from an application, such as a game client.</p> </li> <li> <p>The <a href="http://aws.amazon.com/cli/">AWS command-line interface</a> (CLI) tool is primarily useful for handling administrative actions, such as setting up and managing Amazon GameLift settings and resources. You can use the AWS CLI to manage all of your AWS services.</p> </li> <li> <p>The <a href="https://console.aws.amazon.com/gamelift/home">AWS Management Console</a> for Amazon GameLift provides a web interface to manage your Amazon GameLift settings and resources. The console includes a dashboard for tracking key resources, including builds and fleets, and displays usage and performance metrics for your games as customizable graphs.</p> </li> <li> <p>Amazon GameLift Local is a tool for testing your game\'s integration with Amazon GameLift before deploying it on the service. This tools supports a subset of key API actions, which can be called from either the AWS CLI or programmatically. See <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing-local.html">Testing an Integration</a>.</p> </li> </ul> <p> <b>MORE RESOURCES</b> </p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/">Amazon GameLift Developer Guide</a> – Learn more about Amazon GameLift features and how to use them. </p> </li> <li> <p> <a href="https://gamedev.amazon.com/forums/tutorials">Lumberyard and Amazon GameLift Tutorials</a> – Get started fast with walkthroughs and sample projects.</p> </li> <li> <p> <a href="http://aws.amazon.com/blogs/gamedev/">GameDev Blog</a> – Stay up to date with new features and techniques.</p> </li> <li> <p> <a href="https://gamedev.amazon.com/forums/spaces/123/gamelift-discussion.html">GameDev Forums</a> – Connect with the GameDev community.</p> </li> <li> <p> <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/doc-history.html">Amazon GameLift Document History</a> – See changes to the Amazon GameLift service, SDKs, and documentation, as well as links to release notes. </p> </li> </ul> <p> <b>API SUMMARY</b> </p> <p>This list offers a functional overview of the Amazon GameLift service API.</p> <p> <b>Managing Games and Players</b> </p> <p>Use these actions to start new game sessions, find existing game sessions, track game session status and other information, and enable player access to game sessions.</p> <ul> <li> <p> <b>Discover existing game sessions</b> </p> <ul> <li> <p> <a>SearchGameSessions</a> – Retrieve all available game sessions or search for game sessions that match a set of criteria. </p> </li> </ul> </li> <li> <p> <b>Start new game sessions</b> </p> <ul> <li> <p>Start new games with Queues to find the best available hosting resources across multiple regions, minimize player latency, and balance game session activity for efficiency and cost effectiveness. </p> <ul> <li> <p> <a>StartGameSessionPlacement</a> – Request a new game session placement and add one or more players to it.</p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> – Get details on a placement request, including status.</p> </li> <li> <p> <a>StopGameSessionPlacement</a> – Cancel a placement request. </p> </li> </ul> </li> <li> <p> <a>CreateGameSession</a> – Start a new game session on a specific fleet. <i>Available in Amazon GameLift Local.</i> </p> </li> </ul> </li> <li> <p> <b>Start new game sessions with FlexMatch matchmaking</b> </p> <ul> <li> <p> <a>StartMatchmaking</a> – Request matchmaking for one players or a group who want to play together. </p> </li> <li> <p> <a>DescribeMatchmaking</a> – Get details on a matchmaking request, including status.</p> </li> <li> <p> <a>AcceptMatch</a> – Register that a player accepts a proposed match, for matches that require player acceptance. </p> </li> <li> <p> <a>StopMatchmaking</a> – Cancel a matchmaking request. </p> </li> </ul> </li> <li> <p> <b>Manage game session data</b> </p> <ul> <li> <p> <a>DescribeGameSessions</a> – Retrieve metadata for one or more game sessions, including length of time active and current player count. <i>Available in Amazon GameLift Local.</i> </p> </li> <li> <p> <a>DescribeGameSessionDetails</a> – Retrieve metadata and the game session protection setting for one or more game sessions.</p> </li> <li> <p> <a>UpdateGameSession</a> – Change game session settings, such as maximum player count and join policy.</p> </li> <li> <p> <a>GetGameSessionLogUrl</a> – Get the location of saved logs for a game session.</p> </li> </ul> </li> <li> <p> <b>Manage player sessions</b> </p> <ul> <li> <p> <a>CreatePlayerSession</a> – Send a request for a player to join a game session. <i>Available in Amazon GameLift Local.</i> </p> </li> <li> <p> <a>CreatePlayerSessions</a> – Send a request for multiple players to join a game session. <i>Available in Amazon GameLift Local.</i> </p> </li> <li> <p> <a>DescribePlayerSessions</a> – Get details on player activity, including status, playing time, and player data. <i>Available in Amazon GameLift Local.</i> </p> </li> </ul> </li> </ul> <p> <b>Setting Up and Managing Game Servers</b> </p> <p>When setting up Amazon GameLift resources for your game, you first <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html">create a game build</a> and upload it to Amazon GameLift. You can then use these actions to configure and manage a fleet of resources to run your game servers, scale capacity to meet player demand, access performance and utilization metrics, and more.</p> <ul> <li> <p> <b>Manage game builds</b> </p> <ul> <li> <p> <a>CreateBuild</a> – Create a new build using files stored in an Amazon S3 bucket. (Update uploading permissions with <a>RequestUploadCredentials</a>.) To create a build and upload files from a local path, use the AWS CLI command <code>upload-build</code>.</p> </li> <li> <p> <a>ListBuilds</a> – Get a list of all builds uploaded to a Amazon GameLift region.</p> </li> <li> <p> <a>DescribeBuild</a> – Retrieve information associated with a build.</p> </li> <li> <p> <a>UpdateBuild</a> – Change build metadata, including build name and version.</p> </li> <li> <p> <a>DeleteBuild</a> – Remove a build from Amazon GameLift.</p> </li> </ul> </li> <li> <p> <b>Manage fleets</b> </p> <ul> <li> <p> <a>CreateFleet</a> – Configure and activate a new fleet to run a build\'s game servers.</p> </li> <li> <p> <a>ListFleets</a> – Get a list of all fleet IDs in a Amazon GameLift region (all statuses).</p> </li> <li> <p> <a>DeleteFleet</a> – Terminate a fleet that is no longer running game servers or hosting players.</p> </li> <li> <p>View / update fleet configurations.</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> / <a>UpdateFleetAttributes</a> – View or change a fleet\'s metadata and settings for game session protection and resource creation limits.</p> </li> <li> <p> <a>DescribeFleetPortSettings</a> / <a>UpdateFleetPortSettings</a> – View or change the inbound permissions (IP address and port setting ranges) allowed for a fleet.</p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> / <a>UpdateRuntimeConfiguration</a> – View or change what server processes (and how many) to run on each instance in a fleet.</p> </li> </ul> </li> </ul> </li> <li> <p> <b>Control fleet capacity</b> </p> <ul> <li> <p> <a>DescribeEC2InstanceLimits</a> – Retrieve maximum number of instances allowed for the current AWS account and the current usage level.</p> </li> <li> <p> <a>DescribeFleetCapacity</a> / <a>UpdateFleetCapacity</a> – Retrieve the capacity settings and the current number of instances in a fleet; adjust fleet capacity settings to scale up or down.</p> </li> <li> <p>Autoscale – Manage autoscaling rules and apply them to a fleet.</p> <ul> <li> <p> <a>PutScalingPolicy</a> – Create a new autoscaling policy, or update an existing one.</p> </li> <li> <p> <a>DescribeScalingPolicies</a> – Retrieve an existing autoscaling policy.</p> </li> <li> <p> <a>DeleteScalingPolicy</a> – Delete an autoscaling policy and stop it from affecting a fleet\'s capacity.</p> </li> </ul> </li> </ul> </li> <li> <p> <b>Access fleet activity statistics</b> </p> <ul> <li> <p> <a>DescribeFleetUtilization</a> – Get current data on the number of server processes, game sessions, and players currently active on a fleet.</p> </li> <li> <p> <a>DescribeFleetEvents</a> – Get a fleet\'s logged events for a specified time span.</p> </li> <li> <p> <a>DescribeGameSessions</a> – Retrieve metadata associated with one or more game sessions, including length of time active and current player count.</p> </li> </ul> </li> <li> <p> <b>Remotely access an instance</b> </p> <ul> <li> <p> <a>DescribeInstances</a> – Get information on each instance in a fleet, including instance ID, IP address, and status.</p> </li> <li> <p> <a>GetInstanceAccess</a> – Request access credentials needed to remotely connect to a specified instance in a fleet.</p> </li> </ul> </li> <li> <p> <b>Manage fleet aliases</b> </p> <ul> <li> <p> <a>CreateAlias</a> – Define a new alias and optionally assign it to a fleet.</p> </li> <li> <p> <a>ListAliases</a> – Get all fleet aliases defined in a Amazon GameLift region.</p> </li> <li> <p> <a>DescribeAlias</a> – Retrieve information on an existing alias.</p> </li> <li> <p> <a>UpdateAlias</a> – Change settings for a alias, such as redirecting it from one fleet to another.</p> </li> <li> <p> <a>DeleteAlias</a> – Remove an alias from the region.</p> </li> <li> <p> <a>ResolveAlias</a> – Get the fleet ID that a specified alias points to.</p> </li> </ul> </li> <li> <p> <b>Manage game session queues</b> </p> <ul> <li> <p> <a>CreateGameSessionQueue</a> – Create a queue for processing requests for new game sessions. </p> </li> <li> <p> <a>DescribeGameSessionQueues</a> – Retrieve game session queues defined in a Amazon GameLift region.</p> </li> <li> <p> <a>UpdateGameSessionQueue</a> – Change the configuration of a game session queue.</p> </li> <li> <p> <a>DeleteGameSessionQueue</a> – Remove a game session queue from the region.</p> </li> </ul> </li> <li> <p> <b>Manage FlexMatch resources</b> </p> <ul> <li> <p> <a>CreateMatchmakingConfiguration</a> – Create a matchmaking configuration with instructions for building a player group and placing in a new game session. </p> </li> <li> <p> <a>DescribeMatchmakingConfigurations</a> – Retrieve matchmaking configurations defined a Amazon GameLift region.</p> </li> <li> <p> <a>UpdateMatchmakingConfiguration</a> – Change settings for matchmaking configuration. queue.</p> </li> <li> <p> <a>DeleteMatchmakingConfiguration</a> – Remove a matchmaking configuration from the region.</p> </li> <li> <p> <a>CreateMatchmakingRuleSet</a> – Create a set of rules to use when searching for player matches. </p> </li> <li> <p> <a>DescribeMatchmakingRuleSets</a> – Retrieve matchmaking rule sets defined in a Amazon GameLift region.</p> </li> <li> <p> <a>ValidateMatchmakingRuleSet</a> – Verify syntax for a set of matchmaking rules. </p> </li> </ul> </li> </ul>', 'operations' => [ 'AcceptMatch' => '<p>Registers a player\'s acceptance or rejection of a proposed FlexMatch match. A matchmaking configuration may require player acceptance; if so, then matches built with that configuration cannot be completed unless all players accept the proposed match within a specified time limit. </p> <p>When FlexMatch builds a match, all the matchmaking tickets involved in the proposed match are placed into status <code>REQUIRES_ACCEPTANCE</code>. This is a trigger for your game to get acceptance from all players in the ticket. Acceptances are only valid for tickets when they are in this status; all other acceptances result in an error.</p> <p>To register acceptance, specify the ticket ID, a response, and one or more players. Once all players have registered acceptance, the matchmaking tickets advance to status <code>PLACING</code>, where a new game session is created for the match. </p> <p>If any player rejects the match, or if acceptances are not received before a specified timeout, the proposed match is dropped. The matchmaking tickets are then handled in one of two ways: For tickets where all players accepted the match, the ticket status is returned to <code>SEARCHING</code> to find a new match. For tickets where one or more players failed to accept the match, the ticket status is set to <code>FAILED</code>, and processing is terminated. A new matchmaking request for these players can be submitted as needed. </p> <p>Matchmaking-related operations include:</p> <ul> <li> <p> <a>StartMatchmaking</a> </p> </li> <li> <p> <a>DescribeMatchmaking</a> </p> </li> <li> <p> <a>StopMatchmaking</a> </p> </li> <li> <p> <a>AcceptMatch</a> </p> </li> </ul>', 'CreateAlias' => '<p>Creates an alias for a fleet. In most situations, you can use an alias ID in place of a fleet ID. By using a fleet alias instead of a specific fleet ID, you can switch gameplay and players to a new fleet without changing your game client or other game components. For example, for games in production, using an alias allows you to seamlessly redirect your player base to a new game server update. </p> <p>Amazon GameLift supports two types of routing strategies for aliases: simple and terminal. A simple alias points to an active fleet. A terminal alias is used to display messaging or link to a URL instead of routing players to an active fleet. For example, you might use a terminal alias when a game version is no longer supported and you want to direct players to an upgrade site. </p> <p>To create a fleet alias, specify an alias name, routing strategy, and optional description. Each simple alias can point to only one fleet, but a fleet can have multiple aliases. If successful, a new alias record is returned, including an alias ID, which you can reference when creating a game session. You can reassign an alias to another fleet by calling <code>UpdateAlias</code>.</p> <p>Alias-related operations include:</p> <ul> <li> <p> <a>CreateAlias</a> </p> </li> <li> <p> <a>ListAliases</a> </p> </li> <li> <p> <a>DescribeAlias</a> </p> </li> <li> <p> <a>UpdateAlias</a> </p> </li> <li> <p> <a>DeleteAlias</a> </p> </li> <li> <p> <a>ResolveAlias</a> </p> </li> </ul>', 'CreateBuild' => '<p>Creates a new Amazon GameLift build from a set of game server binary files stored in an Amazon Simple Storage Service (Amazon S3) location. To use this API call, create a <code>.zip</code> file containing all of the files for the build and store it in an Amazon S3 bucket under your AWS account. For help on packaging your build files and creating a build, see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html">Uploading Your Game to Amazon GameLift</a>.</p> <important> <p>Use this API action ONLY if you are storing your game build files in an Amazon S3 bucket. To create a build using files stored locally, use the CLI command <a href="http://docs.aws.amazon.com/cli/latest/reference/gamelift/upload-build.html"> <code>upload-build</code> </a>, which uploads the build files from a file location you specify.</p> </important> <p>To create a new build using <code>CreateBuild</code>, identify the storage location and operating system of your game build. You also have the option of specifying a build name and version. If successful, this action creates a new build record with an unique build ID and in <code>INITIALIZED</code> status. Use the API call <a>DescribeBuild</a> to check the status of your build. A build must be in <code>READY</code> status before it can be used to create fleets to host your game.</p> <p>Build-related operations include:</p> <ul> <li> <p> <a>CreateBuild</a> </p> </li> <li> <p> <a>ListBuilds</a> </p> </li> <li> <p> <a>DescribeBuild</a> </p> </li> <li> <p> <a>UpdateBuild</a> </p> </li> <li> <p> <a>DeleteBuild</a> </p> </li> </ul>', 'CreateFleet' => '<p>Creates a new fleet to run your game servers. A fleet is a set of Amazon Elastic Compute Cloud (Amazon EC2) instances, each of which can run multiple server processes to host game sessions. You configure a fleet to create instances with certain hardware specifications (see <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for more information), and deploy a specified game build to each instance. A newly created fleet passes through several statuses; once it reaches the <code>ACTIVE</code> status, it can begin hosting game sessions.</p> <p>To create a new fleet, you must specify the following: (1) fleet name, (2) build ID of an uploaded game build, (3) an EC2 instance type, and (4) a run-time configuration that describes which server processes to run on each instance in the fleet. (Although the run-time configuration is not a required parameter, the fleet cannot be successfully activated without it.)</p> <p>You can also configure the new fleet with the following settings:</p> <ul> <li> <p>Fleet description</p> </li> <li> <p>Access permissions for inbound traffic</p> </li> <li> <p>Fleet-wide game session protection</p> </li> <li> <p>Resource creation limit</p> </li> </ul> <p>If you use Amazon CloudWatch for metrics, you can add the new fleet to a metric group. This allows you to view aggregated metrics for a set of fleets. Once you specify a metric group, the new fleet\'s metrics are included in the metric group\'s data.</p> <p>If the CreateFleet call is successful, Amazon GameLift performs the following tasks:</p> <ul> <li> <p>Creates a fleet record and sets the status to <code>NEW</code> (followed by other statuses as the fleet is activated).</p> </li> <li> <p>Sets the fleet\'s target capacity to 1 (desired instances), which causes Amazon GameLift to start one new EC2 instance.</p> </li> <li> <p>Starts launching server processes on the instance. If the fleet is configured to run multiple server processes per instance, Amazon GameLift staggers each launch by a few seconds.</p> </li> <li> <p>Begins writing events to the fleet event log, which can be accessed in the Amazon GameLift console.</p> </li> <li> <p>Sets the fleet\'s status to <code>ACTIVE</code> as soon as one server process in the fleet is ready to host a game session.</p> </li> </ul> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'CreateGameSession' => '<p>Creates a multiplayer game session for players. This action creates a game session record and assigns an available server process in the specified fleet to host the game session. A fleet must have an <code>ACTIVE</code> status before a game session can be created in it.</p> <p>To create a game session, specify either fleet ID or alias ID and indicate a maximum number of players to allow in the game session. You can also provide a name and game-specific properties for this game session. If successful, a <a>GameSession</a> object is returned containing the game session properties and other settings you specified.</p> <p> <b>Idempotency tokens.</b> You can add a token that uniquely identifies game session requests. This is useful for ensuring that game session requests are idempotent. Multiple requests with the same idempotency token are processed only once; subsequent requests return the original result. All response values are the same with the exception of game session status, which may change.</p> <p> <b>Resource creation limits.</b> If you are creating a game session on a fleet with a resource creation limit policy in force, then you must specify a creator ID. Without this ID, Amazon GameLift has no way to evaluate the policy for this new game session request.</p> <p> <b>Player acceptance policy.</b> By default, newly created game sessions are open to new players. You can restrict new player access by using <a>UpdateGameSession</a> to change the game session\'s player session creation policy.</p> <p> <b>Game session logs.</b> Logs are retained for all active game sessions for 14 days. To access the logs, call <a>GetGameSessionLogUrl</a> to download the log files.</p> <p> <i>Available in Amazon GameLift Local.</i> </p> <p>Game-session-related operations include:</p> <ul> <li> <p> <a>CreateGameSession</a> </p> </li> <li> <p> <a>DescribeGameSessions</a> </p> </li> <li> <p> <a>DescribeGameSessionDetails</a> </p> </li> <li> <p> <a>SearchGameSessions</a> </p> </li> <li> <p> <a>UpdateGameSession</a> </p> </li> <li> <p> <a>GetGameSessionLogUrl</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'CreateGameSessionQueue' => '<p>Establishes a new queue for processing requests to place new game sessions. A queue identifies where new game sessions can be hosted -- by specifying a list of destinations (fleets or aliases) -- and how long requests can wait in the queue before timing out. You can set up a queue to try to place game sessions on fleets in multiple regions. To add placement requests to a queue, call <a>StartGameSessionPlacement</a> and reference the queue name.</p> <p> <b>Destination order.</b> When processing a request for a game session, Amazon GameLift tries each destination in order until it finds one with available resources to host the new game session. A queue\'s default order is determined by how destinations are listed. The default order is overridden when a game session placement request provides player latency information. Player latency information enables Amazon GameLift to prioritize destinations where players report the lowest average latency, as a result placing the new game session where the majority of players will have the best possible gameplay experience.</p> <p> <b>Player latency policies.</b> For placement requests containing player latency information, use player latency policies to protect individual players from very high latencies. With a latency cap, even when a destination can deliver a low latency for most players, the game is not placed where any individual player is reporting latency higher than a policy\'s maximum. A queue can have multiple latency policies, which are enforced consecutively starting with the policy with the lowest latency cap. Use multiple policies to gradually relax latency controls; for example, you might set a policy with a low latency cap for the first 60 seconds, a second policy with a higher cap for the next 60 seconds, etc. </p> <p>To create a new queue, provide a name, timeout value, a list of destinations and, if desired, a set of latency policies. If successful, a new queue object is returned.</p> <p>Queue-related operations include:</p> <ul> <li> <p> <a>CreateGameSessionQueue</a> </p> </li> <li> <p> <a>DescribeGameSessionQueues</a> </p> </li> <li> <p> <a>UpdateGameSessionQueue</a> </p> </li> <li> <p> <a>DeleteGameSessionQueue</a> </p> </li> </ul>', 'CreateMatchmakingConfiguration' => '<p>Defines a new matchmaking configuration for use with FlexMatch. A matchmaking configuration sets out guidelines for matching players and getting the matches into games. You can set up multiple matchmaking configurations to handle the scenarios needed for your game. Each matchmaking request (<a>StartMatchmaking</a>) specifies a configuration for the match and provides player attributes to support the configuration being used. </p> <p>To create a matchmaking configuration, at a minimum you must specify the following: configuration name; a rule set that governs how to evaluate players and find acceptable matches; a game session queue to use when placing a new game session for the match; and the maximum time allowed for a matchmaking attempt.</p> <p> <b>Player acceptance</b> -- In each configuration, you have the option to require that all players accept participation in a proposed match. To enable this feature, set <i>AcceptanceRequired</i> to true and specify a time limit for player acceptance. Players have the option to accept or reject a proposed match, and a match does not move ahead to game session placement unless all matched players accept. </p> <p> <b>Matchmaking status notification</b> -- There are two ways to track the progress of matchmaking tickets: (1) polling ticket status with <a>DescribeMatchmaking</a>; or (2) receiving notifications with Amazon Simple Notification Service (SNS). To use notifications, you first need to set up an SNS topic to receive the notifications, and provide the topic ARN in the matchmaking configuration (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/match-notification.html"> Setting up Notifications for Matchmaking</a>). Since notifications promise only "best effort" delivery, we recommend calling <code>DescribeMatchmaking</code> if no notifications are received within 30 seconds.</p> <p>Operations related to match configurations and rule sets include:</p> <ul> <li> <p> <a>CreateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DescribeMatchmakingConfigurations</a> </p> </li> <li> <p> <a>UpdateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DeleteMatchmakingConfiguration</a> </p> </li> <li> <p> <a>CreateMatchmakingRuleSet</a> </p> </li> <li> <p> <a>DescribeMatchmakingRuleSets</a> </p> </li> <li> <p> <a>ValidateMatchmakingRuleSet</a> </p> </li> </ul>', 'CreateMatchmakingRuleSet' => '<p>Creates a new rule set for FlexMatch matchmaking. A rule set describes the type of match to create, such as the number and size of teams, and sets the parameters for acceptable player matches, such as minimum skill level or character type. Rule sets are used in matchmaking configurations, which define how matchmaking requests are handled. Each <a>MatchmakingConfiguration</a> uses one rule set; you can set up multiple rule sets to handle the scenarios that suit your game (such as for different game modes), and create a separate matchmaking configuration for each rule set. See additional information on rule set content in the <a>MatchmakingRuleSet</a> structure. For help creating rule sets, including useful examples, see the topic <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/match-intro.html"> Adding FlexMatch to Your Game</a>.</p> <p>Once created, matchmaking rule sets cannot be changed or deleted, so we recommend checking the rule set syntax using <a>ValidateMatchmakingRuleSet</a>before creating the rule set.</p> <p>To create a matchmaking rule set, provide the set of rules and a unique name. Rule sets must be defined in the same region as the matchmaking configuration they will be used with. Rule sets cannot be edited or deleted. If you need to change a rule set, create a new one with the necessary edits and then update matchmaking configurations to use the new rule set.</p> <p>Operations related to match configurations and rule sets include:</p> <ul> <li> <p> <a>CreateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DescribeMatchmakingConfigurations</a> </p> </li> <li> <p> <a>UpdateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DeleteMatchmakingConfiguration</a> </p> </li> <li> <p> <a>CreateMatchmakingRuleSet</a> </p> </li> <li> <p> <a>DescribeMatchmakingRuleSets</a> </p> </li> <li> <p> <a>ValidateMatchmakingRuleSet</a> </p> </li> </ul>', 'CreatePlayerSession' => '<p>Adds a player to a game session and creates a player session record. Before a player can be added, a game session must have an <code>ACTIVE</code> status, have a creation policy of <code>ALLOW_ALL</code>, and have an open player slot. To add a group of players to a game session, use <a>CreatePlayerSessions</a>.</p> <p>To create a player session, specify a game session ID, player ID, and optionally a string of player data. If successful, the player is added to the game session and a new <a>PlayerSession</a> object is returned. Player sessions cannot be updated. </p> <p> <i>Available in Amazon GameLift Local.</i> </p> <p>Player-session-related operations include:</p> <ul> <li> <p> <a>CreatePlayerSession</a> </p> </li> <li> <p> <a>CreatePlayerSessions</a> </p> </li> <li> <p> <a>DescribePlayerSessions</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'CreatePlayerSessions' => '<p>Adds a group of players to a game session. This action is useful with a team matching feature. Before players can be added, a game session must have an <code>ACTIVE</code> status, have a creation policy of <code>ALLOW_ALL</code>, and have an open player slot. To add a single player to a game session, use <a>CreatePlayerSession</a>.</p> <p>To create player sessions, specify a game session ID, a list of player IDs, and optionally a set of player data strings. If successful, the players are added to the game session and a set of new <a>PlayerSession</a> objects is returned. Player sessions cannot be updated.</p> <p> <i>Available in Amazon GameLift Local.</i> </p> <p>Player-session-related operations include:</p> <ul> <li> <p> <a>CreatePlayerSession</a> </p> </li> <li> <p> <a>CreatePlayerSessions</a> </p> </li> <li> <p> <a>DescribePlayerSessions</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'DeleteAlias' => '<p>Deletes an alias. This action removes all record of the alias. Game clients attempting to access a server process using the deleted alias receive an error. To delete an alias, specify the alias ID to be deleted.</p> <p>Alias-related operations include:</p> <ul> <li> <p> <a>CreateAlias</a> </p> </li> <li> <p> <a>ListAliases</a> </p> </li> <li> <p> <a>DescribeAlias</a> </p> </li> <li> <p> <a>UpdateAlias</a> </p> </li> <li> <p> <a>DeleteAlias</a> </p> </li> <li> <p> <a>ResolveAlias</a> </p> </li> </ul>', 'DeleteBuild' => '<p>Deletes a build. This action permanently deletes the build record and any uploaded build files.</p> <p>To delete a build, specify its ID. Deleting a build does not affect the status of any active fleets using the build, but you can no longer create new fleets with the deleted build.</p> <p>Build-related operations include:</p> <ul> <li> <p> <a>CreateBuild</a> </p> </li> <li> <p> <a>ListBuilds</a> </p> </li> <li> <p> <a>DescribeBuild</a> </p> </li> <li> <p> <a>UpdateBuild</a> </p> </li> <li> <p> <a>DeleteBuild</a> </p> </li> </ul>', 'DeleteFleet' => '<p>Deletes everything related to a fleet. Before deleting a fleet, you must set the fleet\'s desired capacity to zero. See <a>UpdateFleetCapacity</a>.</p> <p>This action removes the fleet\'s resources and the fleet record. Once a fleet is deleted, you can no longer use that fleet.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'DeleteGameSessionQueue' => '<p>Deletes a game session queue. This action means that any <a>StartGameSessionPlacement</a> requests that reference this queue will fail. To delete a queue, specify the queue name.</p> <p>Queue-related operations include:</p> <ul> <li> <p> <a>CreateGameSessionQueue</a> </p> </li> <li> <p> <a>DescribeGameSessionQueues</a> </p> </li> <li> <p> <a>UpdateGameSessionQueue</a> </p> </li> <li> <p> <a>DeleteGameSessionQueue</a> </p> </li> </ul>', 'DeleteMatchmakingConfiguration' => '<p>Permanently removes a FlexMatch matchmaking configuration. To delete, specify the configuration name. A matchmaking configuration cannot be deleted if it is being used in any active matchmaking tickets.</p> <p>Operations related to match configurations and rule sets include:</p> <ul> <li> <p> <a>CreateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DescribeMatchmakingConfigurations</a> </p> </li> <li> <p> <a>UpdateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DeleteMatchmakingConfiguration</a> </p> </li> <li> <p> <a>CreateMatchmakingRuleSet</a> </p> </li> <li> <p> <a>DescribeMatchmakingRuleSets</a> </p> </li> <li> <p> <a>ValidateMatchmakingRuleSet</a> </p> </li> </ul>', 'DeleteScalingPolicy' => '<p>Deletes a fleet scaling policy. This action means that the policy is no longer in force and removes all record of it. To delete a scaling policy, specify both the scaling policy name and the fleet ID it is associated with.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'DescribeAlias' => '<p>Retrieves properties for an alias. This operation returns all alias metadata and settings. To get an alias\'s target fleet ID only, use <code>ResolveAlias</code>. </p> <p>To get alias properties, specify the alias ID. If successful, the requested alias record is returned.</p> <p>Alias-related operations include:</p> <ul> <li> <p> <a>CreateAlias</a> </p> </li> <li> <p> <a>ListAliases</a> </p> </li> <li> <p> <a>DescribeAlias</a> </p> </li> <li> <p> <a>UpdateAlias</a> </p> </li> <li> <p> <a>DeleteAlias</a> </p> </li> <li> <p> <a>ResolveAlias</a> </p> </li> </ul>', 'DescribeBuild' => '<p>Retrieves properties for a build. To get a build record, specify a build ID. If successful, an object containing the build properties is returned.</p> <p>Build-related operations include:</p> <ul> <li> <p> <a>CreateBuild</a> </p> </li> <li> <p> <a>ListBuilds</a> </p> </li> <li> <p> <a>DescribeBuild</a> </p> </li> <li> <p> <a>UpdateBuild</a> </p> </li> <li> <p> <a>DeleteBuild</a> </p> </li> </ul>', 'DescribeEC2InstanceLimits' => '<p>Retrieves the following information for the specified EC2 instance type:</p> <ul> <li> <p>maximum number of instances allowed per AWS account (service limit)</p> </li> <li> <p>current usage level for the AWS account</p> </li> </ul> <p>Service limits vary depending on region. Available regions for Amazon GameLift can be found in the AWS Management Console for Amazon GameLift (see the drop-down list in the upper right corner).</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'DescribeFleetAttributes' => '<p>Retrieves fleet properties, including metadata, status, and configuration, for one or more fleets. You can request attributes for all fleets, or specify a list of one or more fleet IDs. When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages. If successful, a <a>FleetAttributes</a> object is returned for each requested fleet ID. When specifying a list of fleet IDs, attribute objects are returned only for fleets that currently exist. </p> <note> <p>Some API actions may limit the number of fleet IDs allowed in one request. If a request exceeds this limit, the request fails and the error message includes the maximum allowed.</p> </note> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'DescribeFleetCapacity' => '<p>Retrieves the current status of fleet capacity for one or more fleets. This information includes the number of instances that have been requested for the fleet and the number currently active. You can request capacity for all fleets, or specify a list of one or more fleet IDs. When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages. If successful, a <a>FleetCapacity</a> object is returned for each requested fleet ID. When specifying a list of fleet IDs, attribute objects are returned only for fleets that currently exist. </p> <note> <p>Some API actions may limit the number of fleet IDs allowed in one request. If a request exceeds this limit, the request fails and the error message includes the maximum allowed.</p> </note> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'DescribeFleetEvents' => '<p>Retrieves entries from the specified fleet\'s event log. You can specify a time range to limit the result set. Use the pagination parameters to retrieve results as a set of sequential pages. If successful, a collection of event log entries matching the request are returned.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'DescribeFleetPortSettings' => '<p>Retrieves the inbound connection permissions for a fleet. Connection permissions include a range of IP addresses and port settings that incoming traffic can use to access server processes in the fleet. To get a fleet\'s inbound connection permissions, specify a fleet ID. If successful, a collection of <a>IpPermission</a> objects is returned for the requested fleet ID. If the requested fleet has been deleted, the result set is empty.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'DescribeFleetUtilization' => '<p>Retrieves utilization statistics for one or more fleets. You can request utilization data for all fleets, or specify a list of one or more fleet IDs. When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages. If successful, a <a>FleetUtilization</a> object is returned for each requested fleet ID. When specifying a list of fleet IDs, utilization objects are returned only for fleets that currently exist. </p> <note> <p>Some API actions may limit the number of fleet IDs allowed in one request. If a request exceeds this limit, the request fails and the error message includes the maximum allowed.</p> </note> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'DescribeGameSessionDetails' => '<p>Retrieves properties, including the protection policy in force, for one or more game sessions. This action can be used in several ways: (1) provide a <code>GameSessionId</code> or <code>GameSessionArn</code> to request details for a specific game session; (2) provide either a <code>FleetId</code> or an <code>AliasId</code> to request properties for all game sessions running on a fleet. </p> <p>To get game session record(s), specify just one of the following: game session ID, fleet ID, or alias ID. You can filter this request by game session status. Use the pagination parameters to retrieve results as a set of sequential pages. If successful, a <a>GameSessionDetail</a> object is returned for each session matching the request.</p> <p>Game-session-related operations include:</p> <ul> <li> <p> <a>CreateGameSession</a> </p> </li> <li> <p> <a>DescribeGameSessions</a> </p> </li> <li> <p> <a>DescribeGameSessionDetails</a> </p> </li> <li> <p> <a>SearchGameSessions</a> </p> </li> <li> <p> <a>UpdateGameSession</a> </p> </li> <li> <p> <a>GetGameSessionLogUrl</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'DescribeGameSessionPlacement' => '<p>Retrieves properties and current status of a game session placement request. To get game session placement details, specify the placement ID. If successful, a <a>GameSessionPlacement</a> object is returned.</p> <p>Game-session-related operations include:</p> <ul> <li> <p> <a>CreateGameSession</a> </p> </li> <li> <p> <a>DescribeGameSessions</a> </p> </li> <li> <p> <a>DescribeGameSessionDetails</a> </p> </li> <li> <p> <a>SearchGameSessions</a> </p> </li> <li> <p> <a>UpdateGameSession</a> </p> </li> <li> <p> <a>GetGameSessionLogUrl</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'DescribeGameSessionQueues' => '<p>Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination parameters to retrieve results as a set of sequential pages. If successful, a <a>GameSessionQueue</a> object is returned for each requested queue. When specifying a list of queues, objects are returned only for queues that currently exist in the region.</p> <p>Queue-related operations include:</p> <ul> <li> <p> <a>CreateGameSessionQueue</a> </p> </li> <li> <p> <a>DescribeGameSessionQueues</a> </p> </li> <li> <p> <a>UpdateGameSessionQueue</a> </p> </li> <li> <p> <a>DeleteGameSessionQueue</a> </p> </li> </ul>', 'DescribeGameSessions' => '<p>Retrieves a set of one or more game sessions. Request a specific game session or request all game sessions on a fleet. Alternatively, use <a>SearchGameSessions</a> to request a set of active game sessions that are filtered by certain criteria. To retrieve protection policy settings for game sessions, use <a>DescribeGameSessionDetails</a>.</p> <p>To get game sessions, specify one of the following: game session ID, fleet ID, or alias ID. You can filter this request by game session status. Use the pagination parameters to retrieve results as a set of sequential pages. If successful, a <a>GameSession</a> object is returned for each game session matching the request.</p> <p> <i>Available in Amazon GameLift Local.</i> </p> <p>Game-session-related operations include:</p> <ul> <li> <p> <a>CreateGameSession</a> </p> </li> <li> <p> <a>DescribeGameSessions</a> </p> </li> <li> <p> <a>DescribeGameSessionDetails</a> </p> </li> <li> <p> <a>SearchGameSessions</a> </p> </li> <li> <p> <a>UpdateGameSession</a> </p> </li> <li> <p> <a>GetGameSessionLogUrl</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'DescribeInstances' => '<p>Retrieves information about a fleet\'s instances, including instance IDs. Use this action to get details on all instances in the fleet or get details on one specific instance.</p> <p>To get a specific instance, specify fleet ID and instance ID. To get all instances in a fleet, specify a fleet ID only. Use the pagination parameters to retrieve results as a set of sequential pages. If successful, an <a>Instance</a> object is returned for each result.</p>', 'DescribeMatchmaking' => '<p>Retrieves a set of one or more matchmaking tickets. Use this operation to retrieve ticket information, including status and--once a successful match is made--acquire connection information for the resulting new game session. </p> <p>You can use this operation to track the progress of matchmaking requests (through polling) as an alternative to using event notifications. See more details on tracking matchmaking requests through polling or notifications in <a>StartMatchmaking</a>. </p> <p>You can request data for a one or a list of ticket IDs. If the request is successful, a ticket object is returned for each requested ID. When specifying a list of ticket IDs, objects are returned only for tickets that currently exist. </p> <p>Matchmaking-related operations include:</p> <ul> <li> <p> <a>StartMatchmaking</a> </p> </li> <li> <p> <a>DescribeMatchmaking</a> </p> </li> <li> <p> <a>StopMatchmaking</a> </p> </li> <li> <p> <a>AcceptMatch</a> </p> </li> </ul>', 'DescribeMatchmakingConfigurations' => '<p>Retrieves the details of FlexMatch matchmaking configurations. with this operation, you have the following options: (1) retrieve all existing configurations, (2) provide the names of one or more configurations to retrieve, or (3) retrieve all configurations that use a specified rule set name. When requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages. If successful, a configuration is returned for each requested name. When specifying a list of names, only configurations that currently exist are returned. </p> <p>Operations related to match configurations and rule sets include:</p> <ul> <li> <p> <a>CreateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DescribeMatchmakingConfigurations</a> </p> </li> <li> <p> <a>UpdateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DeleteMatchmakingConfiguration</a> </p> </li> <li> <p> <a>CreateMatchmakingRuleSet</a> </p> </li> <li> <p> <a>DescribeMatchmakingRuleSets</a> </p> </li> <li> <p> <a>ValidateMatchmakingRuleSet</a> </p> </li> </ul>', 'DescribeMatchmakingRuleSets' => '<p>Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the region, or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name. </p> <p>Operations related to match configurations and rule sets include:</p> <ul> <li> <p> <a>CreateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DescribeMatchmakingConfigurations</a> </p> </li> <li> <p> <a>UpdateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DeleteMatchmakingConfiguration</a> </p> </li> <li> <p> <a>CreateMatchmakingRuleSet</a> </p> </li> <li> <p> <a>DescribeMatchmakingRuleSets</a> </p> </li> <li> <p> <a>ValidateMatchmakingRuleSet</a> </p> </li> </ul>', 'DescribePlayerSessions' => '<p>Retrieves properties for one or more player sessions. This action can be used in several ways: (1) provide a <code>PlayerSessionId</code> to request properties for a specific player session; (2) provide a <code>GameSessionId</code> to request properties for all player sessions in the specified game session; (3) provide a <code>PlayerId</code> to request properties for all player sessions of a specified player. </p> <p>To get game session record(s), specify only one of the following: a player session ID, a game session ID, or a player ID. You can filter this request by player session status. Use the pagination parameters to retrieve results as a set of sequential pages. If successful, a <a>PlayerSession</a> object is returned for each session matching the request.</p> <p> <i>Available in Amazon GameLift Local.</i> </p> <p>Player-session-related operations include:</p> <ul> <li> <p> <a>CreatePlayerSession</a> </p> </li> <li> <p> <a>CreatePlayerSessions</a> </p> </li> <li> <p> <a>DescribePlayerSessions</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'DescribeRuntimeConfiguration' => '<p>Retrieves the current run-time configuration for the specified fleet. The run-time configuration tells Amazon GameLift how to launch server processes on instances in the fleet.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'DescribeScalingPolicies' => '<p>Retrieves all scaling policies applied to a fleet.</p> <p>To get a fleet\'s scaling policies, specify the fleet ID. You can filter this request by policy status, such as to retrieve only active scaling policies. Use the pagination parameters to retrieve results as a set of sequential pages. If successful, set of <a>ScalingPolicy</a> objects is returned for the fleet.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'GetGameSessionLogUrl' => '<p>Retrieves the location of stored game session logs for a specified game session. When a game session is terminated, Amazon GameLift automatically stores the logs in Amazon S3 and retains them for 14 days. Use this URL to download the logs.</p> <note> <p>See the <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift">AWS Service Limits</a> page for maximum log file sizes. Log files that exceed this limit are not saved.</p> </note> <p>Game-session-related operations include:</p> <ul> <li> <p> <a>CreateGameSession</a> </p> </li> <li> <p> <a>DescribeGameSessions</a> </p> </li> <li> <p> <a>DescribeGameSessionDetails</a> </p> </li> <li> <p> <a>SearchGameSessions</a> </p> </li> <li> <p> <a>UpdateGameSession</a> </p> </li> <li> <p> <a>GetGameSessionLogUrl</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'GetInstanceAccess' => '<p>Requests remote access to a fleet instance. Remote access is useful for debugging, gathering benchmarking data, or watching activity in real time. </p> <p>Access requires credentials that match the operating system of the instance. For a Windows instance, Amazon GameLift returns a user name and password as strings for use with a Windows Remote Desktop client. For a Linux instance, Amazon GameLift returns a user name and RSA private key, also as strings, for use with an SSH client. The private key must be saved in the proper format to a <code>.pem</code> file before using. If you\'re making this request using the AWS CLI, saving the secret can be handled as part of the GetInstanceAccess request. (See the example later in this topic). For more information on remote access, see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely Accessing an Instance</a>.</p> <p>To request access to a specific instance, specify the IDs of the instance and the fleet it belongs to. If successful, an <a>InstanceAccess</a> object is returned containing the instance\'s IP address and a set of credentials.</p>', 'ListAliases' => '<p>Retrieves all aliases for this AWS account. You can filter the result set by alias name and/or routing strategy type. Use the pagination parameters to retrieve results in sequential pages.</p> <note> <p>Returned aliases are not listed in any particular order.</p> </note> <p>Alias-related operations include:</p> <ul> <li> <p> <a>CreateAlias</a> </p> </li> <li> <p> <a>ListAliases</a> </p> </li> <li> <p> <a>DescribeAlias</a> </p> </li> <li> <p> <a>UpdateAlias</a> </p> </li> <li> <p> <a>DeleteAlias</a> </p> </li> <li> <p> <a>ResolveAlias</a> </p> </li> </ul>', 'ListBuilds' => '<p>Retrieves build records for all builds associated with the AWS account in use. You can limit results to builds that are in a specific status by using the <code>Status</code> parameter. Use the pagination parameters to retrieve results in a set of sequential pages. </p> <note> <p>Build records are not listed in any particular order.</p> </note> <p>Build-related operations include:</p> <ul> <li> <p> <a>CreateBuild</a> </p> </li> <li> <p> <a>ListBuilds</a> </p> </li> <li> <p> <a>DescribeBuild</a> </p> </li> <li> <p> <a>UpdateBuild</a> </p> </li> <li> <p> <a>DeleteBuild</a> </p> </li> </ul>', 'ListFleets' => '<p>Retrieves a collection of fleet records for this AWS account. You can filter the result set by build ID. Use the pagination parameters to retrieve results in sequential pages.</p> <note> <p>Fleet records are not listed in any particular order.</p> </note> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'PutScalingPolicy' => '<p>Creates or updates a scaling policy for a fleet. An active scaling policy prompts Amazon GameLift to track a certain metric for a fleet and automatically change the fleet\'s capacity in specific circumstances. Each scaling policy contains one rule statement. Fleets can have multiple scaling policies in force simultaneously.</p> <p>A scaling policy rule statement has the following structure:</p> <p>If <code>[MetricName]</code> is <code>[ComparisonOperator]</code> <code>[Threshold]</code> for <code>[EvaluationPeriods]</code> minutes, then <code>[ScalingAdjustmentType]</code> to/by <code>[ScalingAdjustment]</code>.</p> <p>For example, this policy: "If the number of idle instances exceeds 20 for more than 15 minutes, then reduce the fleet capacity by 10 instances" could be implemented as the following rule statement:</p> <p>If [IdleInstances] is [GreaterThanOrEqualToThreshold] [20] for [15] minutes, then [ChangeInCapacity] by [-10].</p> <p>To create or update a scaling policy, specify a unique combination of name and fleet ID, and set the rule values. All parameters for this action are required. If successful, the policy name is returned. Scaling policies cannot be suspended or made inactive. To stop enforcing a scaling policy, call <a>DeleteScalingPolicy</a>.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'RequestUploadCredentials' => '<p> <i>This API call is not currently in use. </i> Retrieves a fresh set of upload credentials and the assigned Amazon S3 storage location for a specific build. Valid credentials are required to upload your game build files to Amazon S3.</p>', 'ResolveAlias' => '<p>Retrieves the fleet ID that a specified alias is currently pointing to.</p> <p>Alias-related operations include:</p> <ul> <li> <p> <a>CreateAlias</a> </p> </li> <li> <p> <a>ListAliases</a> </p> </li> <li> <p> <a>DescribeAlias</a> </p> </li> <li> <p> <a>UpdateAlias</a> </p> </li> <li> <p> <a>DeleteAlias</a> </p> </li> <li> <p> <a>ResolveAlias</a> </p> </li> </ul>', 'SearchGameSessions' => '<p>Retrieves a set of game sessions that match a set of search criteria and sorts them in a specified order. A game session search is limited to a single fleet. Search results include only game sessions that are in <code>ACTIVE</code> status. If you need to retrieve game sessions with a status other than active, use <a>DescribeGameSessions</a>. If you need to retrieve the protection policy for each game session, use <a>DescribeGameSessionDetails</a>.</p> <p>You can search or sort by the following game session attributes:</p> <ul> <li> <p> <b>gameSessionId</b> -- Unique identifier for the game session. You can use either a <code>GameSessionId</code> or <code>GameSessionArn</code> value. </p> </li> <li> <p> <b>gameSessionName</b> -- Name assigned to a game session. This value is set when requesting a new game session with <a>CreateGameSession</a> or updating with <a>UpdateGameSession</a>. Game session names do not need to be unique to a game session.</p> </li> <li> <p> <b>creationTimeMillis</b> -- Value indicating when a game session was created. It is expressed in Unix time as milliseconds.</p> </li> <li> <p> <b>playerSessionCount</b> -- Number of players currently connected to a game session. This value changes rapidly as players join the session or drop out.</p> </li> <li> <p> <b>maximumSessions</b> -- Maximum number of player sessions allowed for a game session. This value is set when requesting a new game session with <a>CreateGameSession</a> or updating with <a>UpdateGameSession</a>.</p> </li> <li> <p> <b>hasAvailablePlayerSessions</b> -- Boolean value indicating whether a game session has reached its maximum number of players. When searching with this attribute, the search value must be <code>true</code> or <code>false</code>. It is highly recommended that all search requests include this filter attribute to optimize search performance and return only sessions that players can join. </p> </li> </ul> <p>To search or sort, specify either a fleet ID or an alias ID, and provide a search filter expression, a sort expression, or both. Use the pagination parameters to retrieve results as a set of sequential pages. If successful, a collection of <a>GameSession</a> objects matching the request is returned.</p> <note> <p>Returned values for <code>playerSessionCount</code> and <code>hasAvailablePlayerSessions</code> change quickly as players join sessions and others drop out. Results should be considered a snapshot in time. Be sure to refresh search results often, and handle sessions that fill up before a player can join. </p> </note> <p>Game-session-related operations include:</p> <ul> <li> <p> <a>CreateGameSession</a> </p> </li> <li> <p> <a>DescribeGameSessions</a> </p> </li> <li> <p> <a>DescribeGameSessionDetails</a> </p> </li> <li> <p> <a>SearchGameSessions</a> </p> </li> <li> <p> <a>UpdateGameSession</a> </p> </li> <li> <p> <a>GetGameSessionLogUrl</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'StartGameSessionPlacement' => '<p>Places a request for a new game session in a queue (see <a>CreateGameSessionQueue</a>). When processing a placement request, Amazon GameLift searches for available resources on the queue\'s destinations, scanning each until it finds resources or the placement request times out.</p> <p>A game session placement request can also request player sessions. When a new game session is successfully created, Amazon GameLift creates a player session for each player included in the request.</p> <p>When placing a game session, by default Amazon GameLift tries each fleet in the order they are listed in the queue configuration. Ideally, a queue\'s destinations are listed in preference order.</p> <p>Alternatively, when requesting a game session with players, you can also provide latency data for each player in relevant regions. Latency data indicates the performance lag a player experiences when connected to a fleet in the region. Amazon GameLift uses latency data to reorder the list of destinations to place the game session in a region with minimal lag. If latency data is provided for multiple players, Amazon GameLift calculates each region\'s average lag for all players and reorders to get the best game play across all players. </p> <p>To place a new game session request, specify the following:</p> <ul> <li> <p>The queue name and a set of game session properties and settings</p> </li> <li> <p>A unique ID (such as a UUID) for the placement. You use this ID to track the status of the placement request</p> </li> <li> <p>(Optional) A set of IDs and player data for each player you want to join to the new game session</p> </li> <li> <p>Latency data for all players (if you want to optimize game play for the players)</p> </li> </ul> <p>If successful, a new game session placement is created.</p> <p>To track the status of a placement request, call <a>DescribeGameSessionPlacement</a> and check the request\'s status. If the status is <code>FULFILLED</code>, a new game session has been created and a game session ARN and region are referenced. If the placement request times out, you can resubmit the request or retry it with a different queue. </p> <p>Game-session-related operations include:</p> <ul> <li> <p> <a>CreateGameSession</a> </p> </li> <li> <p> <a>DescribeGameSessions</a> </p> </li> <li> <p> <a>DescribeGameSessionDetails</a> </p> </li> <li> <p> <a>SearchGameSessions</a> </p> </li> <li> <p> <a>UpdateGameSession</a> </p> </li> <li> <p> <a>GetGameSessionLogUrl</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'StartMatchmaking' => '<p>Uses FlexMatch to create a game match for a group of players based on custom matchmaking rules, and starts a new game for the matched players. Each matchmaking request specifies the type of match to build (team configuration, rules for an acceptable match, etc.). The request also specifies the players to find a match for and where to host the new game session for optimal performance. A matchmaking request might start with a single player or a group of players who want to play together. FlexMatch finds additional players as needed to fill the match. Match type, rules, and the queue used to place a new game session are defined in a <code>MatchmakingConfiguration</code>. For complete information on setting up and using FlexMatch, see the topic <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/match-intro.html"> Adding FlexMatch to Your Game</a>.</p> <p>To start matchmaking, provide a unique ticket ID, specify a matchmaking configuration, and include the players to be matched. You must also include a set of player attributes relevant for the matchmaking configuration. If successful, a matchmaking ticket is returned with status set to <code>QUEUED</code>. Track the status of the ticket to respond as needed and acquire game session connection information for sucessfully completed matches.</p> <p> <b>Tracking ticket status</b> -- A couple of options are available for tracking the status of matchmaking requests: </p> <ul> <li> <p>Polling -- Call <code>DescribeMatchmaking</code>. This operation returns the full ticket object, including current status and (for completed tickets) game session connection info. We recommend polling no more than once every 10 seconds.</p> </li> <li> <p>Notifications -- Get event notifications for changes in ticket status using Amazon Simple Notification Service (SNS). Notifications are easy to set up (see <a>CreateMatchmakingConfiguration</a>) and typically deliver match status changes faster and more efficiently than polling. We recommend that you use polling to back up to notifications (since delivery is not guaranteed) and call <code>DescribeMatchmaking</code> only when notifications are not received within 30 seconds.</p> </li> </ul> <p> <b>Processing a matchmaking request</b> -- FlexMatch handles a matchmaking request as follows: </p> <ol> <li> <p>Your client code submits a <code>StartMatchmaking</code> request for one or more players and tracks the status of the request ticket. </p> </li> <li> <p>FlexMatch uses this ticket and others in process to build an acceptable match. When a potential match is identified, all tickets in the proposed match are advanced to the next status. </p> </li> <li> <p>If the match requires player acceptance (set in the matchmaking configuration), the tickets move into status <code>REQUIRES_ACCEPTANCE</code>. This status triggers your client code to solicit acceptance from all players in every ticket involved in the match, and then call <a>AcceptMatch</a> for each player. If any player rejects or fails to accept the match before a specified timeout, the proposed match is dropped (see <code>AcceptMatch</code> for more details).</p> </li> <li> <p>Once a match is proposed and accepted, the matchmaking tickets move into status <code>PLACING</code>. FlexMatch locates resources for a new game session using the game session queue (set in the matchmaking configuration) and creates the game session based on the match data. </p> </li> <li> <p>When the match is successfully placed, the matchmaking tickets move into <code>COMPLETED</code> status. Connection information (including game session endpoint and player session) is added to the matchmaking tickets. Matched players can use the connection information to join the game. </p> </li> </ol> <p>Matchmaking-related operations include:</p> <ul> <li> <p> <a>StartMatchmaking</a> </p> </li> <li> <p> <a>DescribeMatchmaking</a> </p> </li> <li> <p> <a>StopMatchmaking</a> </p> </li> <li> <p> <a>AcceptMatch</a> </p> </li> </ul>', 'StopGameSessionPlacement' => '<p>Cancels a game session placement that is in <code>PENDING</code> status. To stop a placement, provide the placement ID values. If successful, the placement is moved to <code>CANCELLED</code> status.</p> <p>Game-session-related operations include:</p> <ul> <li> <p> <a>CreateGameSession</a> </p> </li> <li> <p> <a>DescribeGameSessions</a> </p> </li> <li> <p> <a>DescribeGameSessionDetails</a> </p> </li> <li> <p> <a>SearchGameSessions</a> </p> </li> <li> <p> <a>UpdateGameSession</a> </p> </li> <li> <p> <a>GetGameSessionLogUrl</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'StopMatchmaking' => '<p>Cancels a matchmaking ticket that is currently being processed. To stop the matchmaking operation, specify the ticket ID. If successful, work on the ticket is stopped, and the ticket status is changed to <code>CANCELLED</code>.</p> <p>Matchmaking-related operations include:</p> <ul> <li> <p> <a>StartMatchmaking</a> </p> </li> <li> <p> <a>DescribeMatchmaking</a> </p> </li> <li> <p> <a>StopMatchmaking</a> </p> </li> <li> <p> <a>AcceptMatch</a> </p> </li> </ul>', 'UpdateAlias' => '<p>Updates properties for an alias. To update properties, specify the alias ID to be updated and provide the information to be changed. To reassign an alias to another fleet, provide an updated routing strategy. If successful, the updated alias record is returned.</p> <p>Alias-related operations include:</p> <ul> <li> <p> <a>CreateAlias</a> </p> </li> <li> <p> <a>ListAliases</a> </p> </li> <li> <p> <a>DescribeAlias</a> </p> </li> <li> <p> <a>UpdateAlias</a> </p> </li> <li> <p> <a>DeleteAlias</a> </p> </li> <li> <p> <a>ResolveAlias</a> </p> </li> </ul>', 'UpdateBuild' => '<p>Updates metadata in a build record, including the build name and version. To update the metadata, specify the build ID to update and provide the new values. If successful, a build object containing the updated metadata is returned.</p> <p>Build-related operations include:</p> <ul> <li> <p> <a>CreateBuild</a> </p> </li> <li> <p> <a>ListBuilds</a> </p> </li> <li> <p> <a>DescribeBuild</a> </p> </li> <li> <p> <a>UpdateBuild</a> </p> </li> <li> <p> <a>DeleteBuild</a> </p> </li> </ul>', 'UpdateFleetAttributes' => '<p>Updates fleet properties, including name and description, for a fleet. To update metadata, specify the fleet ID and the property values that you want to change. If successful, the fleet ID for the updated fleet is returned.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'UpdateFleetCapacity' => '<p>Updates capacity settings for a fleet. Use this action to specify the number of EC2 instances (hosts) that you want this fleet to contain. Before calling this action, you may want to call <a>DescribeEC2InstanceLimits</a> to get the maximum capacity based on the fleet\'s EC2 instance type.</p> <p>If you\'re using autoscaling (see <a>PutScalingPolicy</a>), you may want to specify a minimum and/or maximum capacity. If you don\'t provide these, autoscaling can set capacity anywhere between zero and the <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift">service limits</a>.</p> <p>To update fleet capacity, specify the fleet ID and the number of instances you want the fleet to host. If successful, Amazon GameLift starts or terminates instances so that the fleet\'s active instance count matches the desired instance count. You can view a fleet\'s current capacity information by calling <a>DescribeFleetCapacity</a>. If the desired instance count is higher than the instance type\'s limit, the "Limit Exceeded" exception occurs.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'UpdateFleetPortSettings' => '<p>Updates port settings for a fleet. To update settings, specify the fleet ID to be updated and list the permissions you want to update. List the permissions you want to add in <code>InboundPermissionAuthorizations</code>, and permissions you want to remove in <code>InboundPermissionRevocations</code>. Permissions to be removed must match existing fleet permissions. If successful, the fleet ID for the updated fleet is returned.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'UpdateGameSession' => '<p>Updates game session properties. This includes the session name, maximum player count, protection policy, which controls whether or not an active game session can be terminated during a scale-down event, and the player session creation policy, which controls whether or not new players can join the session. To update a game session, specify the game session ID and the values you want to change. If successful, an updated <a>GameSession</a> object is returned. </p> <p>Game-session-related operations include:</p> <ul> <li> <p> <a>CreateGameSession</a> </p> </li> <li> <p> <a>DescribeGameSessions</a> </p> </li> <li> <p> <a>DescribeGameSessionDetails</a> </p> </li> <li> <p> <a>SearchGameSessions</a> </p> </li> <li> <p> <a>UpdateGameSession</a> </p> </li> <li> <p> <a>GetGameSessionLogUrl</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'UpdateGameSessionQueue' => '<p>Updates settings for a game session queue, which determines how new game session requests in the queue are processed. To update settings, specify the queue name to be updated and provide the new settings. When updating destinations, provide a complete list of destinations. </p> <p>Queue-related operations include:</p> <ul> <li> <p> <a>CreateGameSessionQueue</a> </p> </li> <li> <p> <a>DescribeGameSessionQueues</a> </p> </li> <li> <p> <a>UpdateGameSessionQueue</a> </p> </li> <li> <p> <a>DeleteGameSessionQueue</a> </p> </li> </ul>', 'UpdateMatchmakingConfiguration' => '<p>Updates settings for a FlexMatch matchmaking configuration. To update settings, specify the configuration name to be updated and provide the new settings. </p> <p>Operations related to match configurations and rule sets include:</p> <ul> <li> <p> <a>CreateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DescribeMatchmakingConfigurations</a> </p> </li> <li> <p> <a>UpdateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DeleteMatchmakingConfiguration</a> </p> </li> <li> <p> <a>CreateMatchmakingRuleSet</a> </p> </li> <li> <p> <a>DescribeMatchmakingRuleSets</a> </p> </li> <li> <p> <a>ValidateMatchmakingRuleSet</a> </p> </li> </ul>', 'UpdateRuntimeConfiguration' => '<p>Updates the current run-time configuration for the specified fleet, which tells Amazon GameLift how to launch server processes on instances in the fleet. You can update a fleet\'s run-time configuration at any time after the fleet is created; it does not need to be in an <code>ACTIVE</code> status.</p> <p>To update run-time configuration, specify the fleet ID and provide a <code>RuntimeConfiguration</code> object with the updated collection of server process configurations.</p> <p>Each instance in a Amazon GameLift fleet checks regularly for an updated run-time configuration and changes how it launches server processes to comply with the latest version. Existing server processes are not affected by the update; they continue to run until they end, while Amazon GameLift simply adds new server processes to fit the current run-time configuration. As a result, the run-time configuration changes are applied gradually as existing processes shut down and new processes are launched in Amazon GameLift\'s normal process recycling activity.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'ValidateMatchmakingRuleSet' => '<p>Validates the syntax of a matchmaking rule or rule set. This operation checks that the rule set uses syntactically correct JSON and that it conforms to allowed property expressions. To validate syntax, provide a rule set string.</p> <p>Operations related to match configurations and rule sets include:</p> <ul> <li> <p> <a>CreateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DescribeMatchmakingConfigurations</a> </p> </li> <li> <p> <a>UpdateMatchmakingConfiguration</a> </p> </li> <li> <p> <a>DeleteMatchmakingConfiguration</a> </p> </li> <li> <p> <a>CreateMatchmakingRuleSet</a> </p> </li> <li> <p> <a>DescribeMatchmakingRuleSets</a> </p> </li> <li> <p> <a>ValidateMatchmakingRuleSet</a> </p> </li> </ul>', ], 'shapes' => [ 'AcceptMatchInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'AcceptMatchOutput' => [ 'base' => NULL, 'refs' => [], ], 'AcceptanceType' => [ 'base' => NULL, 'refs' => [ 'AcceptMatchInput$AcceptanceType' => '<p>Player response to the proposed match.</p>', ], ], 'Alias' => [ 'base' => '<p>Properties describing a fleet alias.</p> <p>Alias-related operations include:</p> <ul> <li> <p> <a>CreateAlias</a> </p> </li> <li> <p> <a>ListAliases</a> </p> </li> <li> <p> <a>DescribeAlias</a> </p> </li> <li> <p> <a>UpdateAlias</a> </p> </li> <li> <p> <a>DeleteAlias</a> </p> </li> <li> <p> <a>ResolveAlias</a> </p> </li> </ul>', 'refs' => [ 'AliasList$member' => NULL, 'CreateAliasOutput$Alias' => '<p>Object that describes the newly created alias record.</p>', 'DescribeAliasOutput$Alias' => '<p>Object that contains the requested alias.</p>', 'UpdateAliasOutput$Alias' => '<p>Object that contains the updated alias configuration.</p>', ], ], 'AliasId' => [ 'base' => NULL, 'refs' => [ 'Alias$AliasId' => '<p>Unique identifier for an alias; alias IDs are unique within a region.</p>', 'CreateGameSessionInput$AliasId' => '<p>Unique identifier for an alias associated with the fleet to create a game session in. Each request must reference either a fleet ID or alias ID, but not both.</p>', 'DeleteAliasInput$AliasId' => '<p>Unique identifier for a fleet alias. Specify the alias you want to delete.</p>', 'DescribeAliasInput$AliasId' => '<p>Unique identifier for a fleet alias. Specify the alias you want to retrieve.</p>', 'DescribeGameSessionDetailsInput$AliasId' => '<p>Unique identifier for an alias associated with the fleet to retrieve all game sessions for.</p>', 'DescribeGameSessionsInput$AliasId' => '<p>Unique identifier for an alias associated with the fleet to retrieve all game sessions for. </p>', 'ResolveAliasInput$AliasId' => '<p>Unique identifier for the alias you want to resolve.</p>', 'SearchGameSessionsInput$AliasId' => '<p>Unique identifier for an alias associated with the fleet to search for active game sessions. Each request must reference either a fleet ID or alias ID, but not both.</p>', 'UpdateAliasInput$AliasId' => '<p>Unique identifier for a fleet alias. Specify the alias you want to update.</p>', ], ], 'AliasList' => [ 'base' => NULL, 'refs' => [ 'ListAliasesOutput$Aliases' => '<p>Collection of alias records that match the list request.</p>', ], ], 'ArnStringModel' => [ 'base' => NULL, 'refs' => [ 'Alias$AliasArn' => '<p>Unique identifier for an alias; alias ARNs are unique across all regions.</p>', 'CreatePlayerSessionInput$GameSessionId' => '<p>Unique identifier for the game session to add a player to.</p>', 'CreatePlayerSessionsInput$GameSessionId' => '<p>Unique identifier for the game session to add players to.</p>', 'DescribeGameSessionDetailsInput$GameSessionId' => '<p>Unique identifier for the game session to retrieve.</p>', 'DescribeGameSessionsInput$GameSessionId' => '<p>Unique identifier for the game session to retrieve. You can use either a <code>GameSessionId</code> or <code>GameSessionArn</code> value. </p>', 'DescribePlayerSessionsInput$GameSessionId' => '<p>Unique identifier for the game session to retrieve player sessions for.</p>', 'FleetAttributes$FleetArn' => '<p>Identifier for a fleet that is unique across all regions.</p>', 'GameSessionConnectionInfo$GameSessionArn' => '<p>Amazon Resource Name (<a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a game session and uniquely identifies it.</p>', 'GameSessionQueue$GameSessionQueueArn' => '<p>Amazon Resource Name (<a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a game session queue and uniquely identifies it. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.</p>', 'GameSessionQueueDestination$DestinationArn' => '<p>Amazon Resource Name (ARN) assigned to fleet or fleet alias. ARNs, which include a fleet ID or alias ID and a region name, provide a unique identifier across all regions. </p>', 'GetGameSessionLogUrlInput$GameSessionId' => '<p>Unique identifier for the game session to get logs for.</p>', 'QueueArnsList$member' => NULL, 'UpdateGameSessionInput$GameSessionId' => '<p>Unique identifier for the game session to update.</p>', ], ], 'AttributeValue' => [ 'base' => '<p>Values for use in <a>Player</a> attribute type:value pairs. This object lets you specify an attribute value using any of the valid data types: string, number, string array or data map. Each <code>AttributeValue</code> object can use only one of the available properties.</p>', 'refs' => [ 'PlayerAttributeMap$value' => NULL, ], ], 'AwsCredentials' => [ 'base' => '<p>Temporary access credentials used for uploading game build files to Amazon GameLift. They are valid for a limited time. If they expire before you upload your game build, get a new set by calling <a>RequestUploadCredentials</a>.</p>', 'refs' => [ 'CreateBuildOutput$UploadCredentials' => '<p>This element is not currently in use.</p>', 'RequestUploadCredentialsOutput$UploadCredentials' => '<p>AWS credentials required when uploading a game build to the storage location. These credentials have a limited lifespan and are valid only for the build they were issued for.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$AcceptanceRequired' => '<p>Flag that determines whether or not a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE.</p>', 'MatchmakingConfiguration$AcceptanceRequired' => '<p>Flag that determines whether or not a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE.</p>', 'UpdateMatchmakingConfigurationInput$AcceptanceRequired' => '<p>Flag that determines whether or not a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE.</p>', 'ValidateMatchmakingRuleSetOutput$Valid' => '<p>Response indicating whether or not the rule set is valid.</p>', ], ], 'Build' => [ 'base' => '<p>Properties describing a game build.</p> <p>Build-related operations include:</p> <ul> <li> <p> <a>CreateBuild</a> </p> </li> <li> <p> <a>ListBuilds</a> </p> </li> <li> <p> <a>DescribeBuild</a> </p> </li> <li> <p> <a>UpdateBuild</a> </p> </li> <li> <p> <a>DeleteBuild</a> </p> </li> </ul>', 'refs' => [ 'BuildList$member' => NULL, 'CreateBuildOutput$Build' => '<p>The newly created build record, including a unique build ID and status. </p>', 'DescribeBuildOutput$Build' => '<p>Set of properties describing the requested build.</p>', 'UpdateBuildOutput$Build' => '<p>Object that contains the updated build record.</p>', ], ], 'BuildId' => [ 'base' => NULL, 'refs' => [ 'Build$BuildId' => '<p>Unique identifier for a build.</p>', 'CreateFleetInput$BuildId' => '<p>Unique identifier for a build to be deployed on the new fleet. The build must have been successfully uploaded to Amazon GameLift and be in a <code>READY</code> status. This fleet setting cannot be changed once the fleet is created.</p>', 'DeleteBuildInput$BuildId' => '<p>Unique identifier for a build to delete.</p>', 'DescribeBuildInput$BuildId' => '<p>Unique identifier for a build to retrieve properties for.</p>', 'FleetAttributes$BuildId' => '<p>Unique identifier for a build.</p>', 'ListFleetsInput$BuildId' => '<p>Unique identifier for a build to return fleets for. Use this parameter to return only fleets using the specified build. To retrieve all fleets, leave this parameter empty.</p>', 'RequestUploadCredentialsInput$BuildId' => '<p>Unique identifier for a build to get credentials for.</p>', 'UpdateBuildInput$BuildId' => '<p>Unique identifier for a build to update.</p>', ], ], 'BuildList' => [ 'base' => NULL, 'refs' => [ 'ListBuildsOutput$Builds' => '<p>Collection of build records that match the request.</p>', ], ], 'BuildStatus' => [ 'base' => NULL, 'refs' => [ 'Build$Status' => '<p>Current status of the build.</p> <p>Possible build statuses include the following:</p> <ul> <li> <p> <b>INITIALIZED</b> – A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value. </p> </li> <li> <p> <b>READY</b> – The game build has been successfully uploaded. You can now create new fleets for this build.</p> </li> <li> <p> <b>FAILED</b> – The game build upload failed. You cannot create new fleets for this build. </p> </li> </ul>', 'ListBuildsInput$Status' => '<p>Build status to filter results by. To retrieve all builds, leave this parameter empty.</p> <p>Possible build statuses include the following:</p> <ul> <li> <p> <b>INITIALIZED</b> – A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value. </p> </li> <li> <p> <b>READY</b> – The game build has been successfully uploaded. You can now create new fleets for this build.</p> </li> <li> <p> <b>FAILED</b> – The game build upload failed. You cannot create new fleets for this build. </p> </li> </ul>', ], ], 'ComparisonOperatorType' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyInput$ComparisonOperator' => '<p>Comparison operator to use when measuring the metric against the threshold value.</p>', 'ScalingPolicy$ComparisonOperator' => '<p>Comparison operator to use when measuring a metric against the threshold value.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>', 'refs' => [], ], 'CreateAliasInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'CreateAliasOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'CreateBuildInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'CreateBuildOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'CreateFleetInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'CreateFleetOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'CreateGameSessionInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'CreateGameSessionOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'CreateGameSessionQueueInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'CreateGameSessionQueueOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'CreateMatchmakingConfigurationInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'CreateMatchmakingConfigurationOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'CreateMatchmakingRuleSetInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'CreateMatchmakingRuleSetOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'CreatePlayerSessionInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'CreatePlayerSessionOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'CreatePlayerSessionsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'CreatePlayerSessionsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'CustomEventData' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$CustomEventData' => '<p>Information to attached to all events related to the matchmaking configuration. </p>', 'MatchmakingConfiguration$CustomEventData' => '<p>Information to attached to all events related to the matchmaking configuration. </p>', 'UpdateMatchmakingConfigurationInput$CustomEventData' => '<p>Information to attached to all events related to the matchmaking configuration. </p>', ], ], 'DeleteAliasInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DeleteBuildInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DeleteFleetInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DeleteGameSessionQueueInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DeleteGameSessionQueueOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMatchmakingConfigurationInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DeleteMatchmakingConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteScalingPolicyInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeAliasInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeAliasOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeBuildInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeBuildOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeEC2InstanceLimitsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeEC2InstanceLimitsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeFleetAttributesInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeFleetAttributesOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeFleetCapacityInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeFleetCapacityOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeFleetEventsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeFleetEventsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeFleetPortSettingsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeFleetPortSettingsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeFleetUtilizationInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeFleetUtilizationOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeGameSessionDetailsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeGameSessionDetailsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeGameSessionPlacementInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeGameSessionPlacementOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeGameSessionQueuesInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeGameSessionQueuesOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeGameSessionsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeGameSessionsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeInstancesInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeInstancesOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeMatchmakingConfigurationsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeMatchmakingConfigurationsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeMatchmakingInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeMatchmakingOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeMatchmakingRuleSetsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeMatchmakingRuleSetsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribePlayerSessionsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribePlayerSessionsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeRuntimeConfigurationInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeRuntimeConfigurationOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DescribeScalingPoliciesInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'DescribeScalingPoliciesOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'DesiredPlayerSession' => [ 'base' => '<p>Player information for use when creating player sessions using a game session placement request with <a>StartGameSessionPlacement</a>.</p>', 'refs' => [ 'DesiredPlayerSessionList$member' => NULL, ], ], 'DesiredPlayerSessionList' => [ 'base' => NULL, 'refs' => [ 'StartGameSessionPlacementInput$DesiredPlayerSessions' => '<p>Set of information on each player to create a player session for.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyInput$Threshold' => '<p>Metric value used to trigger a scaling event.</p>', 'ScalingPolicy$Threshold' => '<p>Metric value used to trigger a scaling event.</p>', ], ], 'DoubleObject' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$N' => '<p>For number values, expressed as double.</p>', 'StringDoubleMap$value' => NULL, ], ], 'EC2InstanceCounts' => [ 'base' => '<p>Current status of fleet capacity. The number of active instances should match or be in the process of matching the number of desired instances. Pending and terminating counts are non-zero only if fleet capacity is adjusting to an <a>UpdateFleetCapacity</a> request, or if access to resources is temporarily affected.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'refs' => [ 'FleetCapacity$InstanceCounts' => '<p>Current status of fleet capacity.</p>', ], ], 'EC2InstanceLimit' => [ 'base' => '<p>Maximum number of instances allowed based on the Amazon Elastic Compute Cloud (Amazon EC2) instance type. Instance limits can be retrieved by calling <a>DescribeEC2InstanceLimits</a>.</p>', 'refs' => [ 'EC2InstanceLimitList$member' => NULL, ], ], 'EC2InstanceLimitList' => [ 'base' => NULL, 'refs' => [ 'DescribeEC2InstanceLimitsOutput$EC2InstanceLimits' => '<p>Object that contains the maximum number of instances for the specified instance type.</p>', ], ], 'EC2InstanceType' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$EC2InstanceType' => '<p>Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.</p>', 'DescribeEC2InstanceLimitsInput$EC2InstanceType' => '<p>Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions. Leave this parameter blank to retrieve limits for all types.</p>', 'EC2InstanceLimit$EC2InstanceType' => '<p>Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.</p>', 'FleetCapacity$InstanceType' => '<p>Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.</p>', 'Instance$Type' => '<p>EC2 instance type that defines the computing resources of this instance. </p>', ], ], 'Event' => [ 'base' => '<p>Log entry describing an event that involves Amazon GameLift resources (such as a fleet). In addition to tracking activity, event codes and messages can provide additional information for troubleshooting and debugging problems.</p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventCode' => [ 'base' => NULL, 'refs' => [ 'Event$EventCode' => '<p>Type of event being logged. The following events are currently in use:</p> <ul> <li> <p>General events:</p> <ul> <li> <p> <b>GENERIC_EVENT</b> – An unspecified event has occurred.</p> </li> </ul> </li> <li> <p>Fleet creation events:</p> <ul> <li> <p> <b>FLEET_CREATED</b> – A fleet record was successfully created with a status of <code>NEW</code>. Event messaging includes the fleet ID.</p> </li> <li> <p> <b>FLEET_STATE_DOWNLOADING</b> – Fleet status changed from <code>NEW</code> to <code>DOWNLOADING</code>. The compressed build has started downloading to a fleet instance for installation.</p> </li> <li> <p> <b>FLEET_BINARY_DOWNLOAD_FAILED</b> – The build failed to download to the fleet instance.</p> </li> <li> <p> <b>FLEET_CREATION_EXTRACTING_BUILD</b> – The game server build was successfully downloaded to an instance, and the build files are now being extracted from the uploaded build and saved to an instance. Failure at this stage prevents a fleet from moving to <code>ACTIVE</code> status. Logs for this stage display a list of the files that are extracted and saved on the instance. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li> <li> <p> <b>FLEET_CREATION_RUNNING_INSTALLER</b> – The game server build files were successfully extracted, and the Amazon GameLift is now running the build\'s install script (if one is included). Failure in this stage prevents a fleet from moving to <code>ACTIVE</code> status. Logs for this stage list the installation steps and whether or not the install completed successfully. Access the logs by using the URL in <i>PreSignedLogUrl</i>. </p> </li> <li> <p> <b>FLEET_CREATION_VALIDATING_RUNTIME_CONFIG</b> – The build process was successful, and the Amazon GameLift is now verifying that the game server launch paths, which are specified in the fleet\'s run-time configuration, exist. If any listed launch path exists, Amazon GameLift tries to launch a game server process and waits for the process to report ready. Failures in this stage prevent a fleet from moving to <code>ACTIVE</code> status. Logs for this stage list the launch paths in the run-time configuration and indicate whether each is found. Access the logs by using the URL in <i>PreSignedLogUrl</i>. </p> </li> <li> <p> <b>FLEET_STATE_VALIDATING</b> – Fleet status changed from <code>DOWNLOADING</code> to <code>VALIDATING</code>.</p> </li> <li> <p> <b>FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND</b> – Validation of the run-time configuration failed because the executable specified in a launch path does not exist on the instance.</p> </li> <li> <p> <b>FLEET_STATE_BUILDING</b> – Fleet status changed from <code>VALIDATING</code> to <code>BUILDING</code>.</p> </li> <li> <p> <b>FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE</b> – Validation of the run-time configuration failed because the executable specified in a launch path failed to run on the fleet instance.</p> </li> <li> <p> <b>FLEET_STATE_ACTIVATING</b> – Fleet status changed from <code>BUILDING</code> to <code>ACTIVATING</code>. </p> </li> <li> <p> <b>FLEET_ACTIVATION_FAILED</b> - The fleet failed to successfully complete one of the steps in the fleet activation process. This event code indicates that the game build was successfully downloaded to a fleet instance, built, and validated, but was not able to start a server process. A possible reason for failure is that the game server is not reporting "process ready" to the Amazon GameLift service.</p> </li> <li> <p> <b>FLEET_STATE_ACTIVE</b> – The fleet\'s status changed from <code>ACTIVATING</code> to <code>ACTIVE</code>. The fleet is now ready to host game sessions.</p> </li> </ul> </li> <li> <p>Other fleet events:</p> <ul> <li> <p> <b>FLEET_SCALING_EVENT</b> – A change was made to the fleet\'s capacity settings (desired instances, minimum/maximum scaling limits). Event messaging includes the new capacity settings.</p> </li> <li> <p> <b>FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED</b> – A change was made to the fleet\'s game session protection policy setting. Event messaging includes both the old and new policy setting. </p> </li> <li> <p> <b>FLEET_DELETED</b> – A request to delete a fleet was initiated.</p> </li> </ul> </li> </ul>', ], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetEventsOutput$Events' => '<p>Collection of objects containing event log entries for the specified fleet.</p>', ], ], 'FleetAttributes' => [ 'base' => '<p>General properties describing a fleet.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'refs' => [ 'CreateFleetOutput$FleetAttributes' => '<p>Properties for the newly created fleet.</p>', 'FleetAttributesList$member' => NULL, ], ], 'FleetAttributesList' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetAttributesOutput$FleetAttributes' => '<p>Collection of objects containing attribute metadata for each requested fleet ID.</p>', ], ], 'FleetCapacity' => [ 'base' => '<p>Information about the fleet\'s capacity. Fleet capacity is measured in EC2 instances. By default, new fleets have a capacity of one instance, but can be updated as needed. The maximum number of instances for a fleet is determined by the fleet\'s instance type.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'refs' => [ 'FleetCapacityList$member' => NULL, ], ], 'FleetCapacityExceededException' => [ 'base' => '<p>The specified fleet has no available instances to fulfill a <code>CreateGameSession</code> request. Clients can retry such requests immediately or after a waiting period.</p>', 'refs' => [], ], 'FleetCapacityList' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetCapacityOutput$FleetCapacity' => '<p>Collection of objects containing capacity information for each requested fleet ID. Leave this parameter empty to retrieve capacity information for all fleets.</p>', ], ], 'FleetId' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionInput$FleetId' => '<p>Unique identifier for a fleet to create a game session in. Each request must reference either a fleet ID or alias ID, but not both.</p>', 'DeleteFleetInput$FleetId' => '<p>Unique identifier for a fleet to be deleted.</p>', 'DeleteScalingPolicyInput$FleetId' => '<p>Unique identifier for a fleet to be deleted.</p>', 'DescribeFleetEventsInput$FleetId' => '<p>Unique identifier for a fleet to get event logs for.</p>', 'DescribeFleetPortSettingsInput$FleetId' => '<p>Unique identifier for a fleet to retrieve port settings for.</p>', 'DescribeGameSessionDetailsInput$FleetId' => '<p>Unique identifier for a fleet to retrieve all game sessions active on the fleet.</p>', 'DescribeGameSessionsInput$FleetId' => '<p>Unique identifier for a fleet to retrieve all game sessions for.</p>', 'DescribeInstancesInput$FleetId' => '<p>Unique identifier for a fleet to retrieve instance information for.</p>', 'DescribeRuntimeConfigurationInput$FleetId' => '<p>Unique identifier for a fleet to get the run-time configuration for.</p>', 'DescribeScalingPoliciesInput$FleetId' => '<p>Unique identifier for a fleet to retrieve scaling policies for.</p>', 'FleetAttributes$FleetId' => '<p>Unique identifier for a fleet.</p>', 'FleetCapacity$FleetId' => '<p>Unique identifier for a fleet.</p>', 'FleetIdList$member' => NULL, 'FleetUtilization$FleetId' => '<p>Unique identifier for a fleet.</p>', 'GameSession$FleetId' => '<p>Unique identifier for a fleet the game session is running on.</p>', 'GetInstanceAccessInput$FleetId' => '<p>Unique identifier for a fleet that contains the instance you want access to. The fleet can be in any of the following statuses: <code>ACTIVATING</code>, <code>ACTIVE</code>, or <code>ERROR</code>. Fleets with an <code>ERROR</code> status may be accessible for a short time before they are deleted.</p>', 'Instance$FleetId' => '<p>Unique identifier for a fleet that the instance is in.</p>', 'InstanceAccess$FleetId' => '<p>Unique identifier for a fleet containing the instance being accessed.</p>', 'PlayerSession$FleetId' => '<p>Unique identifier for a fleet that the player\'s game session is running on.</p>', 'PutScalingPolicyInput$FleetId' => '<p>Unique identifier for a fleet to apply this policy to.</p>', 'ResolveAliasOutput$FleetId' => '<p>Fleet identifier that is associated with the requested alias.</p>', 'RoutingStrategy$FleetId' => '<p>Unique identifier for a fleet that the alias points to.</p>', 'ScalingPolicy$FleetId' => '<p>Unique identifier for a fleet that is associated with this scaling policy.</p>', 'SearchGameSessionsInput$FleetId' => '<p>Unique identifier for a fleet to search for active game sessions. Each request must reference either a fleet ID or alias ID, but not both.</p>', 'UpdateFleetAttributesInput$FleetId' => '<p>Unique identifier for a fleet to update attribute metadata for.</p>', 'UpdateFleetAttributesOutput$FleetId' => '<p>Unique identifier for a fleet that was updated.</p>', 'UpdateFleetCapacityInput$FleetId' => '<p>Unique identifier for a fleet to update capacity for.</p>', 'UpdateFleetCapacityOutput$FleetId' => '<p>Unique identifier for a fleet that was updated.</p>', 'UpdateFleetPortSettingsInput$FleetId' => '<p>Unique identifier for a fleet to update port settings for.</p>', 'UpdateFleetPortSettingsOutput$FleetId' => '<p>Unique identifier for a fleet that was updated.</p>', 'UpdateRuntimeConfigurationInput$FleetId' => '<p>Unique identifier for a fleet to update run-time configuration for.</p>', ], ], 'FleetIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetAttributesInput$FleetIds' => '<p>Unique identifier for a fleet(s) to retrieve attributes for. To request attributes for all fleets, leave this parameter empty.</p>', 'DescribeFleetCapacityInput$FleetIds' => '<p>Unique identifier for a fleet(s) to retrieve capacity information for. To request capacity information for all fleets, leave this parameter empty.</p>', 'DescribeFleetUtilizationInput$FleetIds' => '<p>Unique identifier for a fleet(s) to retrieve utilization data for. To request utilization data for all fleets, leave this parameter empty.</p>', 'ListFleetsOutput$FleetIds' => '<p>Set of fleet IDs matching the list request. You can retrieve additional information about all returned fleets by passing this result set to a call to <a>DescribeFleetAttributes</a>, <a>DescribeFleetCapacity</a>, or <a>DescribeFleetUtilization</a>.</p>', ], ], 'FleetStatus' => [ 'base' => NULL, 'refs' => [ 'FleetAttributes$Status' => '<p>Current status of the fleet.</p> <p>Possible fleet statuses include the following:</p> <ul> <li> <p> <b>NEW</b> – A new fleet has been defined and desired instances is set to 1. </p> </li> <li> <p> <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> – Amazon GameLift is setting up the new fleet, creating new instances with the game build and starting server processes.</p> </li> <li> <p> <b>ACTIVE</b> – Hosts can now accept game sessions.</p> </li> <li> <p> <b>ERROR</b> – An error occurred when downloading, validating, building, or activating the fleet.</p> </li> <li> <p> <b>DELETING</b> – Hosts are responding to a delete fleet request.</p> </li> <li> <p> <b>TERMINATED</b> – The fleet no longer exists.</p> </li> </ul>', ], ], 'FleetUtilization' => [ 'base' => '<p>Current status of fleet utilization, including the number of game and player sessions being hosted.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'refs' => [ 'FleetUtilizationList$member' => NULL, ], ], 'FleetUtilizationList' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetUtilizationOutput$FleetUtilization' => '<p>Collection of objects containing utilization information for each requested fleet ID.</p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'PlayerLatency$LatencyInMilliseconds' => '<p>Amount of time that represents the time lag experienced by the player when connected to the specified region.</p>', ], ], 'FreeText' => [ 'base' => NULL, 'refs' => [ 'Alias$Description' => '<p>Human-readable description of an alias.</p>', 'Build$Name' => '<p>Descriptive label that is associated with a build. Build names do not need to be unique. It can be set using <a>CreateBuild</a> or <a>UpdateBuild</a>.</p>', 'Build$Version' => '<p>Version that is associated with this build. Version strings do not need to be unique. This value can be set using <a>CreateBuild</a> or <a>UpdateBuild</a>.</p>', 'RoutingStrategy$Message' => '<p>Message text to be used with a terminal routing strategy.</p>', ], ], 'GameProperty' => [ 'base' => '<p>Set of key-value pairs that contain information about a game session. When included in a game session request, these properties communicate details to be used when setting up the new game session, such as to specify a game mode, level, or map. Game properties are passed to the game server process when initiating a new game session; the server process uses the properties as appropriate. For more information, see the <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-create"> Amazon GameLift Developer Guide</a>.</p>', 'refs' => [ 'GamePropertyList$member' => NULL, ], ], 'GamePropertyKey' => [ 'base' => NULL, 'refs' => [ 'GameProperty$Key' => '<p>Game property identifier.</p>', ], ], 'GamePropertyList' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionInput$GameProperties' => '<p>Set of developer-defined properties for a game session, formatted as a set of type:value pairs. These properties are included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'CreateMatchmakingConfigurationInput$GameProperties' => '<p>Set of developer-defined properties for a game session, formatted as a set of type:value pairs. These properties are included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <a>GameSession</a> object that is created for a successful match. </p>', 'GameSession$GameProperties' => '<p>Set of developer-defined properties for a game session, formatted as a set of type:value pairs. These properties are included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'GameSessionPlacement$GameProperties' => '<p>Set of developer-defined properties for a game session, formatted as a set of type:value pairs. These properties are included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'MatchmakingConfiguration$GameProperties' => '<p>Set of developer-defined properties for a game session, formatted as a set of type:value pairs. These properties are included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <a>GameSession</a> object that is created for a successful match. </p>', 'StartGameSessionPlacementInput$GameProperties' => '<p>Set of developer-defined properties for a game session, formatted as a set of type:value pairs. These properties are included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'UpdateMatchmakingConfigurationInput$GameProperties' => '<p>Set of developer-defined properties for a game session, formatted as a set of type:value pairs. These properties are included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <a>GameSession</a> object that is created for a successful match. </p>', ], ], 'GamePropertyValue' => [ 'base' => NULL, 'refs' => [ 'GameProperty$Value' => '<p>Game property value.</p>', ], ], 'GameSession' => [ 'base' => '<p>Properties describing a game session.</p> <p>A game session in ACTIVE status can host players. When a game session ends, its status is set to <code>TERMINATED</code>. </p> <p>Once the session ends, the game session object is retained for 30 days. This means you can reuse idempotency token values after this time. Game session logs are retained for 14 days.</p> <p>Game-session-related operations include:</p> <ul> <li> <p> <a>CreateGameSession</a> </p> </li> <li> <p> <a>DescribeGameSessions</a> </p> </li> <li> <p> <a>DescribeGameSessionDetails</a> </p> </li> <li> <p> <a>SearchGameSessions</a> </p> </li> <li> <p> <a>UpdateGameSession</a> </p> </li> <li> <p> <a>GetGameSessionLogUrl</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'refs' => [ 'CreateGameSessionOutput$GameSession' => '<p>Object that describes the newly created game session record.</p>', 'GameSessionDetail$GameSession' => '<p>Object that describes a game session.</p>', 'GameSessionList$member' => NULL, 'UpdateGameSessionOutput$GameSession' => '<p>Object that contains the updated game session metadata.</p>', ], ], 'GameSessionActivationTimeoutSeconds' => [ 'base' => NULL, 'refs' => [ 'RuntimeConfiguration$GameSessionActivationTimeoutSeconds' => '<p>Maximum amount of time (in seconds) that a game session can remain in status <code>ACTIVATING</code>. If the game session is not active before the timeout, activation is terminated and the game session status is changed to <code>TERMINATED</code>.</p>', ], ], 'GameSessionConnectionInfo' => [ 'base' => '<p>Connection information for the new game session that is created with matchmaking. (with <a>StartMatchmaking</a>). Once a match is set, the FlexMatch engine places the match and creates a new game session for it. This information, including the game session endpoint and player sessions for each player in the original matchmaking request, is added to the <a>MatchmakingTicket</a>, which can be retrieved by calling <a>DescribeMatchmaking</a>.</p>', 'refs' => [ 'MatchmakingTicket$GameSessionConnectionInfo' => '<p>Identifier and connection information of the game session created for the match. This information is added to the ticket only after the matchmaking request has been successfully completed.</p>', ], ], 'GameSessionData' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionInput$GameSessionData' => '<p>Set of developer-defined game session properties, formatted as a single string value. This data is included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'CreateMatchmakingConfigurationInput$GameSessionData' => '<p>Set of developer-defined game session properties, formatted as a single string value. This data is included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <a>GameSession</a> object that is created for a successful match.</p>', 'GameSession$GameSessionData' => '<p>Set of developer-defined game session properties, formatted as a single string value. This data is included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'GameSessionPlacement$GameSessionData' => '<p>Set of developer-defined game session properties, formatted as a single string value. This data is included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'MatchmakingConfiguration$GameSessionData' => '<p>Set of developer-defined game session properties, formatted as a single string value. This data is included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <a>GameSession</a> object that is created for a successful match. </p>', 'StartGameSessionPlacementInput$GameSessionData' => '<p>Set of developer-defined game session properties, formatted as a single string value. This data is included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'UpdateMatchmakingConfigurationInput$GameSessionData' => '<p>Set of developer-defined game session properties, formatted as a single string value. This data is included in the <a>GameSession</a> object, which is passed to the game server with a request to start a new game session (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <a>GameSession</a> object that is created for a successful match. </p>', ], ], 'GameSessionDetail' => [ 'base' => '<p>A game session\'s properties plus the protection policy currently in force.</p>', 'refs' => [ 'GameSessionDetailList$member' => NULL, ], ], 'GameSessionDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeGameSessionDetailsOutput$GameSessionDetails' => '<p>Collection of objects containing game session properties and the protection policy currently in force for each session matching the request.</p>', ], ], 'GameSessionFullException' => [ 'base' => '<p>The game instance is currently full and cannot allow the requested player(s) to join. Clients can retry such requests immediately or after a waiting period.</p>', 'refs' => [], ], 'GameSessionList' => [ 'base' => NULL, 'refs' => [ 'DescribeGameSessionsOutput$GameSessions' => '<p>Collection of objects containing game session properties for each session matching the request.</p>', 'SearchGameSessionsOutput$GameSessions' => '<p>Collection of objects containing game session properties for each session matching the request.</p>', ], ], 'GameSessionPlacement' => [ 'base' => '<p>Object that describes a <a>StartGameSessionPlacement</a> request. This object includes the full details of the original request plus the current status and start/end time stamps.</p> <p>Game session placement-related operations include:</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul>', 'refs' => [ 'DescribeGameSessionPlacementOutput$GameSessionPlacement' => '<p>Object that describes the requested game session placement.</p>', 'StartGameSessionPlacementOutput$GameSessionPlacement' => '<p>Object that describes the newly created game session placement. This object includes all the information provided in the request, as well as start/end time stamps and placement status. </p>', 'StopGameSessionPlacementOutput$GameSessionPlacement' => '<p>Object that describes the canceled game session placement, with <code>CANCELLED</code> status and an end time stamp. </p>', ], ], 'GameSessionPlacementState' => [ 'base' => NULL, 'refs' => [ 'GameSessionPlacement$Status' => '<p>Current status of the game session placement request.</p> <ul> <li> <p> <b>PENDING</b> – The placement request is currently in the queue waiting to be processed.</p> </li> <li> <p> <b>FULFILLED</b> – A new game session and player sessions (if requested) have been successfully created. Values for <i>GameSessionArn</i> and <i>GameSessionRegion</i> are available. </p> </li> <li> <p> <b>CANCELLED</b> – The placement request was canceled with a call to <a>StopGameSessionPlacement</a>.</p> </li> <li> <p> <b>TIMED_OUT</b> – A new game session was not successfully created before the time limit expired. You can resubmit the placement request as needed.</p> </li> </ul>', ], ], 'GameSessionQueue' => [ 'base' => '<p>Configuration of a queue that is used to process game session placement requests. The queue configuration identifies several game features:</p> <ul> <li> <p>The destinations where a new game session can potentially be hosted. Amazon GameLift tries these destinations in an order based on either the queue\'s default order or player latency information, if provided in a placement request. With latency information, Amazon GameLift can place game sessions where the majority of players are reporting the lowest possible latency. </p> </li> <li> <p>The length of time that placement requests can wait in the queue before timing out. </p> </li> <li> <p>A set of optional latency policies that protect individual players from high latencies, preventing game sessions from being placed where any individual player is reporting latency higher than a policy\'s maximum.</p> </li> </ul> <p>Queue-related operations include:</p> <ul> <li> <p> <a>CreateGameSessionQueue</a> </p> </li> <li> <p> <a>DescribeGameSessionQueues</a> </p> </li> <li> <p> <a>UpdateGameSessionQueue</a> </p> </li> <li> <p> <a>DeleteGameSessionQueue</a> </p> </li> </ul>', 'refs' => [ 'CreateGameSessionQueueOutput$GameSessionQueue' => '<p>Object that describes the newly created game session queue.</p>', 'GameSessionQueueList$member' => NULL, 'UpdateGameSessionQueueOutput$GameSessionQueue' => '<p>Object that describes the newly updated game session queue.</p>', ], ], 'GameSessionQueueDestination' => [ 'base' => '<p>Fleet designated in a game session queue. Requests for new game sessions in the queue are fulfilled by starting a new game session on any destination configured for a queue. </p> <p>Queue-related operations include:</p> <ul> <li> <p> <a>CreateGameSessionQueue</a> </p> </li> <li> <p> <a>DescribeGameSessionQueues</a> </p> </li> <li> <p> <a>UpdateGameSessionQueue</a> </p> </li> <li> <p> <a>DeleteGameSessionQueue</a> </p> </li> </ul>', 'refs' => [ 'GameSessionQueueDestinationList$member' => NULL, ], ], 'GameSessionQueueDestinationList' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionQueueInput$Destinations' => '<p>List of fleets that can be used to fulfill game session placement requests in the queue. Fleets are identified by either a fleet ARN or a fleet alias ARN. Destinations are listed in default preference order.</p>', 'GameSessionQueue$Destinations' => '<p>List of fleets that can be used to fulfill game session placement requests in the queue. Fleets are identified by either a fleet ARN or a fleet alias ARN. Destinations are listed in default preference order.</p>', 'UpdateGameSessionQueueInput$Destinations' => '<p>List of fleets that can be used to fulfill game session placement requests in the queue. Fleets are identified by either a fleet ARN or a fleet alias ARN. Destinations are listed in default preference order. When updating this list, provide a complete list of destinations.</p>', ], ], 'GameSessionQueueList' => [ 'base' => NULL, 'refs' => [ 'DescribeGameSessionQueuesOutput$GameSessionQueues' => '<p>Collection of objects that describes the requested game session queues.</p>', ], ], 'GameSessionQueueName' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionQueueInput$Name' => '<p>Descriptive label that is associated with game session queue. Queue names must be unique within each region.</p>', 'DeleteGameSessionQueueInput$Name' => '<p>Descriptive label that is associated with game session queue. Queue names must be unique within each region.</p>', 'GameSessionPlacement$GameSessionQueueName' => '<p>Descriptive label that is associated with game session queue. Queue names must be unique within each region.</p>', 'GameSessionQueue$Name' => '<p>Descriptive label that is associated with game session queue. Queue names must be unique within each region.</p>', 'GameSessionQueueNameList$member' => NULL, 'StartGameSessionPlacementInput$GameSessionQueueName' => '<p>Name of the queue to use to place the new game session.</p>', 'UpdateGameSessionQueueInput$Name' => '<p>Descriptive label that is associated with game session queue. Queue names must be unique within each region.</p>', ], ], 'GameSessionQueueNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeGameSessionQueuesInput$Names' => '<p>List of queue names to retrieve information for. To request settings for all queues, leave this parameter empty.</p>', ], ], 'GameSessionStatus' => [ 'base' => NULL, 'refs' => [ 'GameSession$Status' => '<p>Current status of the game session. A game session must have an <code>ACTIVE</code> status to have player sessions.</p>', ], ], 'GetGameSessionLogUrlInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'GetGameSessionLogUrlOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'GetInstanceAccessInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'GetInstanceAccessOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'IdStringModel' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionInput$GameSessionId' => '<p> <i>This parameter is no longer preferred. Please use <code>IdempotencyToken</code> instead.</i> Custom string that uniquely identifies a request for a new game session. Maximum token length is 48 characters. If provided, this string is included in the new game session\'s ID. (A game session ID has the following format: <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>.) </p>', 'CreateGameSessionInput$IdempotencyToken' => '<p>Custom string that uniquely identifies a request for a new game session. Maximum token length is 48 characters. If provided, this string is included in the new game session\'s ID. (A game session ID has the following format: <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>.) Idempotency tokens remain in use for 30 days after a game session has ended; game session objects are retained for this time period and then deleted.</p>', 'DescribeGameSessionPlacementInput$PlacementId' => '<p>Unique identifier for a game session placement to retrieve.</p>', 'GameSessionPlacement$PlacementId' => '<p>Unique identifier for a game session placement.</p>', 'StartGameSessionPlacementInput$PlacementId' => '<p>Unique identifier to assign to the new game session placement. This value is developer-defined. The value must be unique across all regions and cannot be reused unless you are resubmitting a canceled or timed-out placement request.</p>', 'StopGameSessionPlacementInput$PlacementId' => '<p>Unique identifier for a game session placement to cancel.</p>', ], ], 'IdempotentParameterMismatchException' => [ 'base' => '<p>A game session with this custom ID string already exists in this fleet. Resolve this conflict before retrying this request.</p>', 'refs' => [], ], 'Instance' => [ 'base' => '<p>Properties that describe an instance of a virtual computing resource that hosts one or more game servers. A fleet may contain zero or more instances.</p>', 'refs' => [ 'InstanceList$member' => NULL, ], ], 'InstanceAccess' => [ 'base' => '<p>Information required to remotely connect to a fleet instance. Access is requested by calling <a>GetInstanceAccess</a>. </p>', 'refs' => [ 'GetInstanceAccessOutput$InstanceAccess' => '<p>Object that contains connection information for a fleet instance, including IP address and access credentials.</p>', ], ], 'InstanceCredentials' => [ 'base' => '<p>Set of credentials required to remotely access a fleet instance. Access credentials are requested by calling <a>GetInstanceAccess</a> and returned in an <a>InstanceAccess</a> object.</p>', 'refs' => [ 'InstanceAccess$Credentials' => '<p>Credentials required to access the instance.</p>', ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancesInput$InstanceId' => '<p>Unique identifier for an instance to retrieve. Specify an instance ID or leave blank to retrieve all instances in the fleet.</p>', 'GetInstanceAccessInput$InstanceId' => '<p>Unique identifier for an instance you want to get access to. You can access an instance in any status.</p>', 'Instance$InstanceId' => '<p>Unique identifier for an instance.</p>', 'InstanceAccess$InstanceId' => '<p>Unique identifier for an instance being accessed.</p>', ], ], 'InstanceList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancesOutput$Instances' => '<p>Collection of objects containing properties for each instance returned.</p>', ], ], 'InstanceStatus' => [ 'base' => NULL, 'refs' => [ 'Instance$Status' => '<p>Current status of the instance. Possible statuses include the following:</p> <ul> <li> <p> <b>PENDING</b> – The instance is in the process of being created and launching server processes as defined in the fleet\'s run-time configuration. </p> </li> <li> <p> <b>ACTIVE</b> – The instance has been successfully created and at least one server process has successfully launched and reported back to Amazon GameLift that it is ready to host a game session. The instance is now considered ready to host game sessions. </p> </li> <li> <p> <b>TERMINATING</b> – The instance is in the process of shutting down. This may happen to reduce capacity during a scaling down event or to recycle resources in the event of a problem.</p> </li> </ul>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyInput$ScalingAdjustment' => '<p>Amount of adjustment to make, based on the scaling adjustment type.</p>', 'ScalingPolicy$ScalingAdjustment' => '<p>Amount of adjustment to make, based on the scaling adjustment type.</p>', ], ], 'InternalServiceException' => [ 'base' => '<p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>', 'refs' => [], ], 'InvalidFleetStatusException' => [ 'base' => '<p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</p>', 'refs' => [], ], 'InvalidGameSessionStatusException' => [ 'base' => '<p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the game instance. Resolve the conflict before retrying.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>', 'refs' => [], ], 'IpAddress' => [ 'base' => NULL, 'refs' => [ 'GameSession$IpAddress' => '<p>IP address of the game session. To connect to a Amazon GameLift game server, an app needs both the IP address and port number.</p>', 'GameSessionPlacement$IpAddress' => '<p>IP address of the game session. To connect to a Amazon GameLift game server, an app needs both the IP address and port number. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>). </p>', 'Instance$IpAddress' => '<p>IP address assigned to the instance.</p>', 'InstanceAccess$IpAddress' => '<p>IP address assigned to the instance.</p>', 'PlayerSession$IpAddress' => '<p>IP address of the game session. To connect to a Amazon GameLift game server, an app needs both the IP address and port number.</p>', ], ], 'IpPermission' => [ 'base' => '<p>A range of IP addresses and port settings that allow inbound traffic to connect to server processes on Amazon GameLift. Each game session hosted on a fleet is assigned a unique combination of IP address and port number, which must fall into the fleet\'s allowed ranges. This combination is included in the <a>GameSession</a> object. </p>', 'refs' => [ 'IpPermissionsList$member' => NULL, ], ], 'IpPermissionsList' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$EC2InboundPermissions' => '<p>Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. If no inbound permissions are set, including both IP address range and port range, the server processes in the fleet cannot accept connections. You can specify one or more sets of permissions for a fleet.</p>', 'DescribeFleetPortSettingsOutput$InboundPermissions' => '<p>Object that contains port settings for the requested fleet ID.</p>', 'UpdateFleetPortSettingsInput$InboundPermissionAuthorizations' => '<p>Collection of port settings to be added to the fleet record.</p>', 'UpdateFleetPortSettingsInput$InboundPermissionRevocations' => '<p>Collection of port settings to be removed from the fleet record.</p>', ], ], 'IpProtocol' => [ 'base' => NULL, 'refs' => [ 'IpPermission$Protocol' => '<p>Network communication protocol used by the fleet.</p>', ], ], 'LatencyMap' => [ 'base' => NULL, 'refs' => [ 'Player$LatencyInMs' => '<p>Set of values, expressed in milliseconds, indicating the amount of latency that a player experiences when connected to AWS regions. If this property is present, FlexMatch considers placing the match only in regions that are included in the object map. If not present (that is, null), FlexMatch ignores latency issues and may place the match in any region in the queue.</p> <note> <p>If this property contains an empty map, FlexMatch assumes that no regions are available to the player. In this scenario, the ticket is not matchable and always times out unless canceled. </p> </note>', ], ], 'LimitExceededException' => [ 'base' => '<p>The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue before retrying.</p>', 'refs' => [], ], 'ListAliasesInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'ListAliasesOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'ListBuildsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'ListBuildsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'ListFleetsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'ListFleetsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'MatchedPlayerSession' => [ 'base' => '<p>New player session created as a result of a successful FlexMatch match. A successful match automatically creates new player sessions for every player ID in the original matchmaking request. </p> <p>When players connect to the match\'s game session, they must include both player ID and player session ID in order to claim their assigned player slot.</p>', 'refs' => [ 'MatchedPlayerSessionList$member' => NULL, ], ], 'MatchedPlayerSessionList' => [ 'base' => NULL, 'refs' => [ 'GameSessionConnectionInfo$MatchedPlayerSessions' => '<p>Collection of player session IDs, one for each player ID that was included in the original matchmaking request. </p>', ], ], 'MatchmakingAcceptanceTimeoutInteger' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$AcceptanceTimeoutSeconds' => '<p>Length of time (in seconds) to wait for players to accept a proposed match. If any player rejects the match or fails to accept before the timeout, the ticket continues to look for an acceptable match.</p>', 'MatchmakingConfiguration$AcceptanceTimeoutSeconds' => '<p>Length of time (in seconds) to wait for players to accept a proposed match. If any player rejects the match or fails to accept before the timeout, the ticket continues to look for an acceptable match.</p>', 'UpdateMatchmakingConfigurationInput$AcceptanceTimeoutSeconds' => '<p>Length of time (in seconds) to wait for players to accept a proposed match. If any player rejects the match or fails to accept before the timeout, the ticket continues to look for an acceptable match.</p>', ], ], 'MatchmakingConfiguration' => [ 'base' => '<p>Guidelines for use with FlexMatch to match players into games. All matchmaking requests must specify a matchmaking configuration.</p>', 'refs' => [ 'CreateMatchmakingConfigurationOutput$Configuration' => '<p>Object that describes the newly created matchmaking configuration.</p>', 'MatchmakingConfigurationList$member' => NULL, 'UpdateMatchmakingConfigurationOutput$Configuration' => '<p>Object that describes the updated matchmaking configuration.</p>', ], ], 'MatchmakingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'DescribeMatchmakingConfigurationsOutput$Configurations' => '<p>Collection of requested matchmaking configuration objects.</p>', ], ], 'MatchmakingConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'MatchmakingTicket$Status' => '<p>Current status of the matchmaking request.</p> <ul> <li> <p> <b>QUEUED</b> – The matchmaking request has been received and is currently waiting to be processed.</p> </li> <li> <p> <b>SEARCHING</b> – The matchmaking request is currently being processed. </p> </li> <li> <p> <b>REQUIRES_ACCEPTANCE</b> – A match has been proposed and the players must accept the match (see <a>AcceptMatch</a>). This status is used only with requests that use a matchmaking configuration with a player acceptance requirement.</p> </li> <li> <p> <b>PLACING</b> – The FlexMatch engine has matched players and is in the process of placing a new game session for the match.</p> </li> <li> <p> <b>COMPLETED</b> – Players have been matched and a game session is ready to host the players. A ticket in this state contains the necessary connection information for players.</p> </li> <li> <p> <b>FAILED</b> – The matchmaking request was not completed. Tickets with players who fail to accept a proposed match are placed in <code>FAILED</code> status; new matchmaking requests can be submitted for these players.</p> </li> <li> <p> <b>CANCELLED</b> – The matchmaking request was canceled with a call to <a>StopMatchmaking</a>.</p> </li> <li> <p> <b>TIMED_OUT</b> – The matchmaking request was not completed within the duration specified in the matchmaking configuration. Matchmaking requests that time out can be resubmitted.</p> </li> </ul>', ], ], 'MatchmakingIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeMatchmakingConfigurationsInput$Names' => '<p>Unique identifier for a matchmaking configuration(s) to retrieve. To request all existing configurations, leave this parameter empty.</p>', 'DescribeMatchmakingInput$TicketIds' => '<p>Unique identifier for a matchmaking ticket. To request all existing tickets, leave this parameter empty.</p>', ], ], 'MatchmakingIdStringModel' => [ 'base' => NULL, 'refs' => [ 'AcceptMatchInput$TicketId' => '<p>Unique identifier for a matchmaking ticket. The ticket must be in status <code>REQUIRES_ACCEPTANCE</code>; otherwise this request will fail.</p>', 'CreateMatchmakingConfigurationInput$Name' => '<p>Unique identifier for a matchmaking configuration. This name is used to identify the configuration associated with a matchmaking request or ticket.</p>', 'CreateMatchmakingConfigurationInput$RuleSetName' => '<p>Unique identifier for a matchmaking rule set to use with this configuration. A matchmaking configuration can only use rule sets that are defined in the same region.</p>', 'CreateMatchmakingRuleSetInput$Name' => '<p>Unique identifier for a matchmaking rule set. This name is used to identify the rule set associated with a matchmaking configuration.</p>', 'DeleteMatchmakingConfigurationInput$Name' => '<p>Unique identifier for a matchmaking configuration</p>', 'DescribeMatchmakingConfigurationsInput$RuleSetName' => '<p>Unique identifier for a matchmaking rule set. Use this parameter to retrieve all matchmaking configurations that use this rule set.</p>', 'MatchmakingConfiguration$Name' => '<p>Unique identifier for a matchmaking configuration. This name is used to identify the configuration associated with a matchmaking request or ticket.</p>', 'MatchmakingConfiguration$RuleSetName' => '<p>Unique identifier for a matchmaking rule set to use with this configuration. A matchmaking configuration can only use rule sets that are defined in the same region.</p>', 'MatchmakingIdList$member' => NULL, 'MatchmakingRuleSet$RuleSetName' => '<p>Unique identifier for a matchmaking rule set</p>', 'MatchmakingRuleSetNameList$member' => NULL, 'MatchmakingTicket$TicketId' => '<p>Unique identifier for a matchmaking ticket.</p>', 'MatchmakingTicket$ConfigurationName' => '<p>Name of the <a>MatchmakingConfiguration</a> that is used with this ticket. Matchmaking configurations determine how players are grouped into a match and how a new game session is created for the match.</p>', 'StartMatchmakingInput$TicketId' => '<p>Unique identifier for a matchmaking ticket. Use this identifier to track the matchmaking ticket status and retrieve match results.</p>', 'StartMatchmakingInput$ConfigurationName' => '<p>Name of the matchmaking configuration to use for this request. Matchmaking configurations must exist in the same region as this request.</p>', 'StopMatchmakingInput$TicketId' => '<p>Unique identifier for a matchmaking ticket.</p>', 'UpdateMatchmakingConfigurationInput$Name' => '<p>Unique identifier for a matchmaking configuration to update.</p>', 'UpdateMatchmakingConfigurationInput$RuleSetName' => '<p>Unique identifier for a matchmaking rule set to use with this configuration. A matchmaking configuration can only use rule sets that are defined in the same region.</p>', ], ], 'MatchmakingPlayerIdList' => [ 'base' => NULL, 'refs' => [ 'AcceptMatchInput$PlayerIds' => '<p>Unique identifier for a player delivering the response. This parameter can include one or multiple player IDs.</p>', ], ], 'MatchmakingRequestTimeoutInteger' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$RequestTimeoutSeconds' => '<p>Maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that time out can be resubmitted as needed.</p>', 'MatchmakingConfiguration$RequestTimeoutSeconds' => '<p>Maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that time out can be resubmitted as needed.</p>', 'UpdateMatchmakingConfigurationInput$RequestTimeoutSeconds' => '<p>Maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that time out can be resubmitted as needed.</p>', ], ], 'MatchmakingRuleSet' => [ 'base' => '<p>Set of rule statements, used with FlexMatch, that determine how to build a certain kind of player match. Each rule set describes a type of group to be created and defines the parameters for acceptable player matches. Rule sets are used in <a>MatchmakingConfiguration</a> objects.</p> <p>A rule set may define the following elements for a match. For detailed information and examples showing how to construct a rule set, see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/match-rules.html">Create Matchmaking Rules for Your Game</a>. </p> <ul> <li> <p>Teams -- Required. A rule set must define one or multiple teams for the match and set minimum and maximum team sizes. For example, a rule set might describe a 4x4 match that requires all eight slots to be filled. </p> </li> <li> <p>Player attributes -- Optional. These attributes specify a set of player characteristics to evaluate when looking for a match. Matchmaking requests that use a rule set with player attributes must provide the corresponding attribute values. For example, an attribute might specify a player\'s skill or level.</p> </li> <li> <p>Rules -- Optional. Rules define how to evaluate potential players for a match based on player attributes. A rule might specify minimum requirements for individual players--such as each player must meet a certain skill level, or may describe an entire group--such as all teams must be evenly matched or have at least one player in a certain role. </p> </li> <li> <p>Expansions -- Optional. Expansions allow you to relax the rules after a period of time if no acceptable matches are found. This feature lets you balance getting players into games in a reasonable amount of time instead of making them wait indefinitely for the best possible match. For example, you might use an expansion to increase the maximum skill variance between players after 30 seconds.</p> </li> </ul>', 'refs' => [ 'CreateMatchmakingRuleSetOutput$RuleSet' => '<p>Object that describes the newly created matchmaking rule set.</p>', 'MatchmakingRuleSetList$member' => NULL, ], ], 'MatchmakingRuleSetList' => [ 'base' => NULL, 'refs' => [ 'DescribeMatchmakingRuleSetsOutput$RuleSets' => '<p>Collection of requested matchmaking rule set objects. </p>', ], ], 'MatchmakingRuleSetNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeMatchmakingRuleSetsInput$Names' => '<p>Unique identifier for a matchmaking rule set. This name is used to identify the rule set associated with a matchmaking configuration.</p>', ], ], 'MatchmakingTicket' => [ 'base' => '<p>Ticket generated to track the progress of a matchmaking request. Each ticket is uniquely identified by a ticket ID, supplied by the requester, when creating a matchmaking request with <a>StartMatchmaking</a>. Tickets can be retrieved by calling <a>DescribeMatchmaking</a> with the ticket ID.</p>', 'refs' => [ 'MatchmakingTicketList$member' => NULL, 'StartMatchmakingOutput$MatchmakingTicket' => '<p>Ticket representing the matchmaking request. This object include the information included in the request, ticket status, and match results as generated during the matchmaking process.</p>', ], ], 'MatchmakingTicketList' => [ 'base' => NULL, 'refs' => [ 'DescribeMatchmakingOutput$TicketList' => '<p>Collection of existing matchmaking ticket objects matching the request.</p>', ], ], 'MaxConcurrentGameSessionActivations' => [ 'base' => NULL, 'refs' => [ 'RuntimeConfiguration$MaxConcurrentGameSessionActivations' => '<p>Maximum number of game sessions with status <code>ACTIVATING</code> to allow on an instance simultaneously. This setting limits the amount of instance resources that can be used for new game activations at any one time.</p>', ], ], 'MetricGroup' => [ 'base' => NULL, 'refs' => [ 'MetricGroupList$member' => NULL, ], ], 'MetricGroupList' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$MetricGroups' => '<p>Names of metric groups to add this fleet to. Use an existing metric group name to add this fleet to the group. Or use a new name to create a new metric group. A fleet can only be included in one metric group at a time.</p>', 'FleetAttributes$MetricGroups' => '<p>Names of metric groups that this fleet is included in. In Amazon CloudWatch, you can view metrics for an individual fleet or aggregated metrics for fleets that are in a fleet metric group. A fleet can be included in only one metric group at a time.</p>', 'UpdateFleetAttributesInput$MetricGroups' => '<p>Names of metric groups to include this fleet in. Amazon CloudWatch uses a fleet metric group is to aggregate metrics from multiple fleets. Use an existing metric group name to add this fleet to the group. Or use a new name to create a new metric group. A fleet can only be included in one metric group at a time.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyInput$MetricName' => '<p>Name of the Amazon GameLift-defined metric that is used to trigger an adjustment.</p> <ul> <li> <p> <b>ActivatingGameSessions</b> – number of game sessions in the process of being created (game session status = <code>ACTIVATING</code>).</p> </li> <li> <p> <b>ActiveGameSessions</b> – number of game sessions currently running (game session status = <code>ACTIVE</code>).</p> </li> <li> <p> <b>CurrentPlayerSessions</b> – number of active or reserved player sessions (player session status = <code>ACTIVE</code> or <code>RESERVED</code>). </p> </li> <li> <p> <b>AvailablePlayerSessions</b> – number of player session slots currently available in active game sessions across the fleet, calculated by subtracting a game session\'s current player session count from its maximum player session count. This number includes game sessions that are not currently accepting players (game session <code>PlayerSessionCreationPolicy</code> = <code>DENY_ALL</code>).</p> </li> <li> <p> <b>ActiveInstances</b> – number of instances currently running a game session.</p> </li> <li> <p> <b>IdleInstances</b> – number of instances not currently running a game session.</p> </li> </ul>', 'ScalingPolicy$MetricName' => '<p>Name of the Amazon GameLift-defined metric that is used to trigger an adjustment.</p> <ul> <li> <p> <b>ActivatingGameSessions</b> – number of game sessions in the process of being created (game session status = <code>ACTIVATING</code>).</p> </li> <li> <p> <b>ActiveGameSessions</b> – number of game sessions currently running (game session status = <code>ACTIVE</code>).</p> </li> <li> <p> <b>CurrentPlayerSessions</b> – number of active or reserved player sessions (player session status = <code>ACTIVE</code> or <code>RESERVED</code>). </p> </li> <li> <p> <b>AvailablePlayerSessions</b> – number of player session slots currently available in active game sessions across the fleet, calculated by subtracting a game session\'s current player session count from its maximum player session count. This number does include game sessions that are not currently accepting players (game session <code>PlayerSessionCreationPolicy</code> = <code>DENY_ALL</code>).</p> </li> <li> <p> <b>ActiveInstances</b> – number of instances currently running a game session.</p> </li> <li> <p> <b>IdleInstances</b> – number of instances not currently running a game session.</p> </li> </ul>', ], ], 'NonBlankAndLengthConstraintString' => [ 'base' => NULL, 'refs' => [ 'Alias$Name' => '<p>Descriptive label that is associated with an alias. Alias names do not need to be unique.</p>', 'CreateAliasInput$Name' => '<p>Descriptive label that is associated with an alias. Alias names do not need to be unique.</p>', 'UpdateAliasInput$Name' => '<p>Descriptive label that is associated with an alias. Alias names do not need to be unique.</p>', ], ], 'NonBlankString' => [ 'base' => NULL, 'refs' => [ 'IpPermission$IpRange' => '<p>Range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "<code>000.000.000.000/[subnet mask]</code>" or optionally the shortened version "<code>0.0.0.0/[subnet mask]</code>".</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AwsCredentials$AccessKeyId' => '<p>Temporary key allowing access to the Amazon GameLift S3 account.</p>', 'AwsCredentials$SecretAccessKey' => '<p>Temporary secret key allowing access to the Amazon GameLift S3 account.</p>', 'AwsCredentials$SessionToken' => '<p>Token used to associate a specific build ID with the files uploaded using these credentials.</p>', 'ConflictException$Message' => NULL, 'Event$Message' => '<p>Additional information related to the event.</p>', 'FleetCapacityExceededException$Message' => NULL, 'GameSessionFullException$Message' => NULL, 'IdempotentParameterMismatchException$Message' => NULL, 'InstanceCredentials$UserName' => '<p>User login string.</p>', 'InstanceCredentials$Secret' => '<p>Secret string. For Windows instances, the secret is a password for use with Windows Remote Desktop. For Linux instances, it is a private key (which must be saved as a <code>.pem</code> file) for use with SSH.</p>', 'InternalServiceException$Message' => NULL, 'InvalidFleetStatusException$Message' => NULL, 'InvalidGameSessionStatusException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'LatencyMap$key' => NULL, 'LimitExceededException$Message' => NULL, 'ListAliasesInput$Name' => '<p>Descriptive label that is associated with an alias. Alias names do not need to be unique.</p>', 'ListAliasesInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value.</p>', 'ListAliasesOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'ListBuildsInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value.</p>', 'ListBuildsOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'NotFoundException$Message' => NULL, 'S3Location$Bucket' => '<p>Amazon S3 bucket identifier. This is the name of your S3 bucket.</p>', 'S3Location$Key' => '<p>Name of the zip file containing your build files. </p>', 'S3Location$RoleArn' => '<p>Amazon Resource Name (<a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for the access role that allows Amazon GameLift to access your S3 bucket.</p>', 'TerminalRoutingStrategyException$Message' => NULL, 'UnauthorizedException$Message' => NULL, 'UnsupportedRegionException$Message' => NULL, ], ], 'NonZeroAndMaxString' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$S' => '<p>For single string values. Maximum string length is 100 characters.</p>', 'CreateAliasInput$Description' => '<p>Human-readable description of an alias.</p>', 'CreateBuildInput$Name' => '<p>Descriptive label that is associated with a build. Build names do not need to be unique. You can use <a>UpdateBuild</a> to change this value later. </p>', 'CreateBuildInput$Version' => '<p>Version that is associated with this build. Version strings do not need to be unique. You can use <a>UpdateBuild</a> to change this value later. </p>', 'CreateFleetInput$Name' => '<p>Descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>', 'CreateFleetInput$Description' => '<p>Human-readable description of a fleet.</p>', 'CreateFleetInput$ServerLaunchPath' => '<p>This parameter is no longer used. Instead, specify a server launch path using the <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch parameters instead of a run-time configuration will continue to work.)</p>', 'CreateFleetInput$ServerLaunchParameters' => '<p>This parameter is no longer used. Instead, specify server launch parameters in the <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch parameters instead of a run-time configuration will continue to work.)</p>', 'CreateGameSessionInput$Name' => '<p>Descriptive label that is associated with a game session. Session names do not need to be unique.</p>', 'CreateGameSessionInput$CreatorId' => '<p>Unique identifier for a player or entity creating the game session. This ID is used to enforce a resource protection policy (if one exists) that limits the number of concurrent active game sessions one player can have.</p>', 'CreateMatchmakingConfigurationInput$Description' => '<p>Meaningful description of the matchmaking configuration. </p>', 'CreatePlayerSessionInput$PlayerId' => '<p>Unique identifier for a player. Player IDs are developer-defined.</p>', 'DeleteScalingPolicyInput$Name' => '<p>Descriptive label that is associated with a scaling policy. Policy names do not need to be unique.</p>', 'DescribeFleetAttributesInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>', 'DescribeFleetAttributesOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'DescribeFleetCapacityInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>', 'DescribeFleetCapacityOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'DescribeFleetEventsInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeFleetEventsOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'DescribeFleetUtilizationInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>', 'DescribeFleetUtilizationOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'DescribeGameSessionDetailsInput$StatusFilter' => '<p>Game session status to filter results on. Possible game session statuses include <code>ACTIVE</code>, <code>TERMINATED</code>, <code>ACTIVATING</code> and <code>TERMINATING</code> (the last two are transitory). </p>', 'DescribeGameSessionDetailsInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeGameSessionDetailsOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'DescribeGameSessionQueuesInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeGameSessionQueuesOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'DescribeGameSessionsInput$StatusFilter' => '<p>Game session status to filter results on. Possible game session statuses include <code>ACTIVE</code>, <code>TERMINATED</code>, <code>ACTIVATING</code>, and <code>TERMINATING</code> (the last two are transitory). </p>', 'DescribeGameSessionsInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeGameSessionsOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'DescribeInstancesInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeInstancesOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'DescribeMatchmakingConfigurationsInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeMatchmakingConfigurationsOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'DescribeMatchmakingRuleSetsInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeMatchmakingRuleSetsOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'DescribePlayerSessionsInput$PlayerId' => '<p>Unique identifier for a player to retrieve player sessions for.</p>', 'DescribePlayerSessionsInput$PlayerSessionStatusFilter' => '<p>Player session status to filter results on.</p> <p>Possible player session statuses include the following:</p> <ul> <li> <p> <b>RESERVED</b> – The player session request has been received, but the player has not yet connected to the server process and/or been validated. </p> </li> <li> <p> <b>ACTIVE</b> – The player has been validated by the server process and is currently connected.</p> </li> <li> <p> <b>COMPLETED</b> – The player connection has been dropped.</p> </li> <li> <p> <b>TIMEDOUT</b> – A player session request was received, but the player did not connect and/or was not validated within the time-out limit (60 seconds).</p> </li> </ul>', 'DescribePlayerSessionsInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value. If a player session ID is specified, this parameter is ignored.</p>', 'DescribePlayerSessionsOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'DescribeScalingPoliciesInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeScalingPoliciesOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'DesiredPlayerSession$PlayerId' => '<p>Unique identifier for a player to associate with the player session.</p>', 'Event$EventId' => '<p>Unique identifier for a fleet event.</p>', 'Event$ResourceId' => '<p>Unique identifier for an event resource, such as a fleet ID.</p>', 'Event$PreSignedLogUrl' => '<p>Location of stored logs with additional detail that is related to the event. This is useful for debugging issues. The URL is valid for 15 minutes. You can also access fleet creation logs through the Amazon GameLift console.</p>', 'FleetAttributes$Description' => '<p>Human-readable description of the fleet.</p>', 'FleetAttributes$Name' => '<p>Descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>', 'FleetAttributes$ServerLaunchPath' => '<p>Path to a game server executable in the fleet\'s build, specified for fleets created before 2016-08-04 (or AWS SDK v. 0.12.16). Server launch paths for fleets created after this date are specified in the fleet\'s <a>RuntimeConfiguration</a>.</p>', 'FleetAttributes$ServerLaunchParameters' => '<p>Game server launch parameters specified for fleets created before 2016-08-04 (or AWS SDK v. 0.12.16). Server launch parameters for fleets created after this date are specified in the fleet\'s <a>RuntimeConfiguration</a>.</p>', 'GameSession$GameSessionId' => '<p>Unique identifier for the game session. A game session ID has the following format: <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>.</p>', 'GameSession$Name' => '<p>Descriptive label that is associated with a game session. Session names do not need to be unique.</p>', 'GameSession$CreatorId' => '<p>Unique identifier for a player. This ID is used to enforce a resource protection policy (if one exists), that limits the number of game sessions a player can create.</p>', 'GameSessionPlacement$GameSessionName' => '<p>Descriptive label that is associated with a game session. Session names do not need to be unique.</p>', 'GameSessionPlacement$GameSessionId' => '<p>Unique identifier for the game session. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>', 'GameSessionPlacement$GameSessionArn' => '<p>Identifier for the game session created by this placement request. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>). This identifier is unique across all regions. You can use this value as a <code>GameSessionId</code> value as needed.</p>', 'GameSessionPlacement$GameSessionRegion' => '<p>Name of the region where the game session created by this placement request is running. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>', 'GetGameSessionLogUrlOutput$PreSignedUrl' => '<p>Location of the requested game session logs, available for download.</p>', 'ListFleetsInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value.</p>', 'ListFleetsOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'MatchedPlayerSession$PlayerId' => '<p>Unique identifier for a player </p>', 'MatchmakingConfiguration$Description' => '<p>Descriptive label that is associated with matchmaking configuration.</p>', 'PlacedPlayerSession$PlayerId' => '<p>Unique identifier for a player that is associated with this player session.</p>', 'Player$Team' => '<p>Name of the team that the player is assigned to in a match. Team names are defined in a matchmaking rule set.</p>', 'PlayerAttributeMap$key' => NULL, 'PlayerDataMap$key' => NULL, 'PlayerIdList$member' => NULL, 'PlayerLatency$PlayerId' => '<p>Unique identifier for a player associated with the latency data.</p>', 'PlayerLatency$RegionIdentifier' => '<p>Name of the region that is associated with the latency value.</p>', 'PlayerSession$PlayerId' => '<p>Unique identifier for a player that is associated with this player session.</p>', 'PlayerSession$GameSessionId' => '<p>Unique identifier for the game session that the player session is connected to.</p>', 'PutScalingPolicyInput$Name' => '<p>Descriptive label that is associated with a scaling policy. Policy names do not need to be unique. A fleet can have only one scaling policy with the same name.</p>', 'PutScalingPolicyOutput$Name' => '<p>Descriptive label that is associated with a scaling policy. Policy names do not need to be unique.</p>', 'ScalingPolicy$Name' => '<p>Descriptive label that is associated with a scaling policy. Policy names do not need to be unique.</p>', 'SearchGameSessionsInput$FilterExpression' => '<p>String containing the search criteria for the session search. If no filter expression is included, the request returns results for all game sessions in the fleet that are in <code>ACTIVE</code> status.</p> <p>A filter expression can contain one or multiple conditions. Each condition consists of the following:</p> <ul> <li> <p> <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>, <code>gameSessionId</code>, <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>maximumSessions</code>, <code>hasAvailablePlayerSessions</code>.</p> </li> <li> <p> <b>Comparator</b> -- Valid comparators are: <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&lt;=</code>, <code>&gt;=</code>. </p> </li> <li> <p> <b>Value</b> -- Value to be searched for. Values can be numbers, boolean values (true/false) or strings. String values are case sensitive, enclosed in single quotes. Special characters must be escaped. Boolean and string values can only be used with the comparators <code>=</code> and <code>&lt;&gt;</code>. For example, the following filter expression searches on <code>gameSessionName</code>: "<code>FilterExpression": "gameSessionName = \'Matt\\\\\'s Awesome Game 1\'"</code>. </p> </li> </ul> <p>To chain multiple conditions in a single expression, use the logical keywords <code>AND</code>, <code>OR</code>, and <code>NOT</code> and parentheses as needed. For example: <code>x AND y AND NOT z</code>, <code>NOT (x OR y)</code>.</p> <p>Session search evaluates conditions from left to right using the following precedence rules:</p> <ol> <li> <p> <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&lt;=</code>, <code>&gt;=</code> </p> </li> <li> <p>Parentheses</p> </li> <li> <p>NOT</p> </li> <li> <p>AND</p> </li> <li> <p>OR</p> </li> </ol> <p>For example, this filter expression retrieves game sessions hosting at least ten players that have an open player slot: <code>"maximumSessions&gt;=10 AND hasAvailablePlayerSessions=true"</code>. </p>', 'SearchGameSessionsInput$SortExpression' => '<p>Instructions on how to sort the search results. If no sort expression is included, the request returns results in random order. A sort expression consists of the following elements:</p> <ul> <li> <p> <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>, <code>gameSessionId</code>, <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>maximumSessions</code>, <code>hasAvailablePlayerSessions</code>.</p> </li> <li> <p> <b>Order</b> -- Valid sort orders are <code>ASC</code> (ascending) and <code>DESC</code> (descending).</p> </li> </ul> <p>For example, this sort expression returns the oldest active sessions first: <code>"SortExpression": "creationTimeMillis ASC"</code>. Results with a null value for the sort operand are returned at the end of the list.</p>', 'SearchGameSessionsInput$NextToken' => '<p>Token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this action. To start at the beginning of the result set, do not specify a value.</p>', 'SearchGameSessionsOutput$NextToken' => '<p>Token that indicates where to resume retrieving results on the next call to this action. If no token is returned, these results represent the end of the list.</p>', 'ServerProcess$LaunchPath' => '<p>Location of the server executable in a game build. All game builds are installed on instances at the root : for Windows instances <code>C:\\game</code>, and for Linux instances <code>/local/game</code>. A Windows game build with an executable file located at <code>MyGame\\latest\\server.exe</code> must have a launch path of "<code>C:\\game\\MyGame\\latest\\server.exe</code>". A Linux game build with an executable file located at <code>MyGame/latest/server.exe</code> must have a launch path of "<code>/local/game/MyGame/latest/server.exe</code>". </p>', 'ServerProcess$Parameters' => '<p>Optional list of parameters to pass to the server executable on launch.</p>', 'StartGameSessionPlacementInput$GameSessionName' => '<p>Descriptive label that is associated with a game session. Session names do not need to be unique.</p>', 'StringDoubleMap$key' => NULL, 'StringList$member' => NULL, 'UpdateAliasInput$Description' => '<p>Human-readable description of an alias.</p>', 'UpdateBuildInput$Name' => '<p>Descriptive label that is associated with a build. Build names do not need to be unique. </p>', 'UpdateBuildInput$Version' => '<p>Version that is associated with this build. Version strings do not need to be unique.</p>', 'UpdateFleetAttributesInput$Name' => '<p>Descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>', 'UpdateFleetAttributesInput$Description' => '<p>Human-readable description of a fleet.</p>', 'UpdateGameSessionInput$Name' => '<p>Descriptive label that is associated with a game session. Session names do not need to be unique.</p>', 'UpdateMatchmakingConfigurationInput$Description' => '<p>Descriptive label that is associated with matchmaking configuration.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>', 'refs' => [], ], 'OperatingSystem' => [ 'base' => NULL, 'refs' => [ 'Build$OperatingSystem' => '<p>Operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build.</p>', 'CreateBuildInput$OperatingSystem' => '<p>Operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build. If your game build contains multiple executables, they all must run on the same operating system.</p>', 'FleetAttributes$OperatingSystem' => '<p>Operating system of the fleet\'s computing resources. A fleet\'s operating system depends on the OS specified for the build that is deployed on this fleet.</p>', 'Instance$OperatingSystem' => '<p>Operating system that is running on this instance. </p>', 'InstanceAccess$OperatingSystem' => '<p>Operating system that is running on the instance.</p>', ], ], 'PlacedPlayerSession' => [ 'base' => '<p>Information about a player session that was created as part of a <a>StartGameSessionPlacement</a> request. This object contains only the player ID and player session ID. To retrieve full details on a player session, call <a>DescribePlayerSessions</a> with the player session ID.</p> <p>Player-session-related operations include:</p> <ul> <li> <p> <a>CreatePlayerSession</a> </p> </li> <li> <p> <a>CreatePlayerSessions</a> </p> </li> <li> <p> <a>DescribePlayerSessions</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'refs' => [ 'PlacedPlayerSessionList$member' => NULL, ], ], 'PlacedPlayerSessionList' => [ 'base' => NULL, 'refs' => [ 'GameSessionPlacement$PlacedPlayerSessions' => '<p>Collection of information on player sessions created in response to the game session placement request. These player sessions are created only once a new game session is successfully placed (placement status is <code>FULFILLED</code>). This information includes the player ID (as provided in the placement request) and the corresponding player session ID. Retrieve full player sessions by calling <a>DescribePlayerSessions</a> with the player session ID.</p>', ], ], 'Player' => [ 'base' => '<p>Object used in matchmaking to represent a player. When starting a matchmaking request, a player has a player ID and may have latency data. Team information is added after a match has been successfully completed.</p>', 'refs' => [ 'PlayerList$member' => NULL, ], ], 'PlayerAttributeMap' => [ 'base' => NULL, 'refs' => [ 'Player$PlayerAttributes' => '<p>Collection of name:value pairs containing player information for use in matchmaking. Player attribute names need to match <i>playerAttributes</i> names in the rule set being used. Example: <code>"PlayerAttributes": {"skill": {"N": "23"}, "gameMode": {"S": "deathmatch"}}</code>.</p>', ], ], 'PlayerData' => [ 'base' => NULL, 'refs' => [ 'CreatePlayerSessionInput$PlayerData' => '<p>Developer-defined information related to a player. Amazon GameLift does not use this data, so it can be formatted as needed for use in the game.</p>', 'DesiredPlayerSession$PlayerData' => '<p>Developer-defined information related to a player. Amazon GameLift does not use this data, so it can be formatted as needed for use in the game.</p>', 'PlayerDataMap$value' => NULL, 'PlayerSession$PlayerData' => '<p>Developer-defined information related to a player. Amazon GameLift does not use this data, so it can be formatted as needed for use in the game. </p>', ], ], 'PlayerDataMap' => [ 'base' => NULL, 'refs' => [ 'CreatePlayerSessionsInput$PlayerDataMap' => '<p>Map of string pairs, each specifying a player ID and a set of developer-defined information related to the player. Amazon GameLift does not use this data, so it can be formatted as needed for use in the game. Player data strings for player IDs not included in the <code>PlayerIds</code> parameter are ignored. </p>', ], ], 'PlayerIdList' => [ 'base' => NULL, 'refs' => [ 'CreatePlayerSessionsInput$PlayerIds' => '<p>List of unique identifiers for the players to be added.</p>', ], ], 'PlayerIdStringModel' => [ 'base' => NULL, 'refs' => [ 'MatchmakingPlayerIdList$member' => NULL, 'Player$PlayerId' => '<p>Unique identifier for a player</p>', ], ], 'PlayerLatency' => [ 'base' => '<p>Regional latency information for a player, used when requesting a new game session with <a>StartGameSessionPlacement</a>. This value indicates the amount of time lag that exists when the player is connected to a fleet in the specified region. The relative difference between a player\'s latency values for multiple regions are used to determine which fleets are best suited to place a new game session for the player. </p>', 'refs' => [ 'PlayerLatencyList$member' => NULL, ], ], 'PlayerLatencyList' => [ 'base' => NULL, 'refs' => [ 'GameSessionPlacement$PlayerLatencies' => '<p>Set of values, expressed in milliseconds, indicating the amount of latency that a player experiences when connected to AWS regions.</p>', 'StartGameSessionPlacementInput$PlayerLatencies' => '<p>Set of values, expressed in milliseconds, indicating the amount of latency that a player experiences when connected to AWS regions. This information is used to try to place the new game session where it can offer the best possible gameplay experience for the players. </p>', ], ], 'PlayerLatencyPolicy' => [ 'base' => '<p>Queue setting that determines the highest latency allowed for individual players when placing a game session. When a latency policy is in force, a game session cannot be placed at any destination in a region where a player is reporting latency higher than the cap. Latency policies are only enforced when the placement request contains player latency information.</p> <p>Queue-related operations include:</p> <ul> <li> <p> <a>CreateGameSessionQueue</a> </p> </li> <li> <p> <a>DescribeGameSessionQueues</a> </p> </li> <li> <p> <a>UpdateGameSessionQueue</a> </p> </li> <li> <p> <a>DeleteGameSessionQueue</a> </p> </li> </ul>', 'refs' => [ 'PlayerLatencyPolicyList$member' => NULL, ], ], 'PlayerLatencyPolicyList' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionQueueInput$PlayerLatencyPolicies' => '<p>Collection of latency policies to apply when processing game sessions placement requests with player latency information. Multiple policies are evaluated in order of the maximum latency value, starting with the lowest latency values. With just one policy, it is enforced at the start of the game session placement for the duration period. With multiple policies, each policy is enforced consecutively for its duration period. For example, a queue might enforce a 60-second policy followed by a 120-second policy, and then no policy for the remainder of the placement. A player latency policy must set a value for MaximumIndividualPlayerLatencyMilliseconds; if none is set, this API requests will fail.</p>', 'GameSessionQueue$PlayerLatencyPolicies' => '<p>Collection of latency policies to apply when processing game sessions placement requests with player latency information. Multiple policies are evaluated in order of the maximum latency value, starting with the lowest latency values. With just one policy, it is enforced at the start of the game session placement for the duration period. With multiple policies, each policy is enforced consecutively for its duration period. For example, a queue might enforce a 60-second policy followed by a 120-second policy, and then no policy for the remainder of the placement. </p>', 'UpdateGameSessionQueueInput$PlayerLatencyPolicies' => '<p>Collection of latency policies to apply when processing game sessions placement requests with player latency information. Multiple policies are evaluated in order of the maximum latency value, starting with the lowest latency values. With just one policy, it is enforced at the start of the game session placement for the duration period. With multiple policies, each policy is enforced consecutively for its duration period. For example, a queue might enforce a 60-second policy followed by a 120-second policy, and then no policy for the remainder of the placement. When updating policies, provide a complete collection of policies.</p>', ], ], 'PlayerList' => [ 'base' => NULL, 'refs' => [ 'MatchmakingTicket$Players' => '<p>A set of <code>Player</code> objects, each representing a player to find matches for. Players are identified by a unique player ID and may include latency data for use during matchmaking. If the ticket is in status <code>COMPLETED</code>, the <code>Player</code> objects include the team the players were assigned to in the resulting match.</p>', 'StartMatchmakingInput$Players' => '<p>Information on each player to be matched. This information must include a player ID, and may contain player attributes and latency data to be used in the matchmaking process. After a successful match, <code>Player</code> objects contain the name of the team the player is assigned to.</p>', ], ], 'PlayerSession' => [ 'base' => '<p>Properties describing a player session. Player session objects are created either by creating a player session for a specific game session, or as part of a game session placement. A player session represents either a player reservation for a game session (status <code>RESERVED</code>) or actual player activity in a game session (status <code>ACTIVE</code>). A player session object (including player data) is automatically passed to a game session when the player connects to the game session and is validated.</p> <p>When a player disconnects, the player session status changes to <code>COMPLETED</code>. Once the session ends, the player session object is retained for 30 days and then removed.</p> <p>Player-session-related operations include:</p> <ul> <li> <p> <a>CreatePlayerSession</a> </p> </li> <li> <p> <a>CreatePlayerSessions</a> </p> </li> <li> <p> <a>DescribePlayerSessions</a> </p> </li> <li> <p>Game session placements</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul> </li> </ul>', 'refs' => [ 'CreatePlayerSessionOutput$PlayerSession' => '<p>Object that describes the newly created player session record.</p>', 'PlayerSessionList$member' => NULL, ], ], 'PlayerSessionCreationPolicy' => [ 'base' => NULL, 'refs' => [ 'GameSession$PlayerSessionCreationPolicy' => '<p>Indicates whether or not the game session is accepting new players.</p>', 'UpdateGameSessionInput$PlayerSessionCreationPolicy' => '<p>Policy determining whether or not the game session accepts new players.</p>', ], ], 'PlayerSessionId' => [ 'base' => NULL, 'refs' => [ 'DescribePlayerSessionsInput$PlayerSessionId' => '<p>Unique identifier for a player session to retrieve.</p>', 'MatchedPlayerSession$PlayerSessionId' => '<p>Unique identifier for a player session</p>', 'PlacedPlayerSession$PlayerSessionId' => '<p>Unique identifier for a player session.</p>', 'PlayerSession$PlayerSessionId' => '<p>Unique identifier for a player session.</p>', ], ], 'PlayerSessionList' => [ 'base' => NULL, 'refs' => [ 'CreatePlayerSessionsOutput$PlayerSessions' => '<p>Collection of player session objects created for the added players.</p>', 'DescribePlayerSessionsOutput$PlayerSessions' => '<p>Collection of objects containing properties for each player session that matches the request.</p>', ], ], 'PlayerSessionStatus' => [ 'base' => NULL, 'refs' => [ 'PlayerSession$Status' => '<p>Current status of the player session.</p> <p>Possible player session statuses include the following:</p> <ul> <li> <p> <b>RESERVED</b> – The player session request has been received, but the player has not yet connected to the server process and/or been validated. </p> </li> <li> <p> <b>ACTIVE</b> – The player has been validated by the server process and is currently connected.</p> </li> <li> <p> <b>COMPLETED</b> – The player connection has been dropped.</p> </li> <li> <p> <b>TIMEDOUT</b> – A player session request was received, but the player did not connect and/or was not validated within the time-out limit (60 seconds).</p> </li> </ul>', ], ], 'PortNumber' => [ 'base' => NULL, 'refs' => [ 'GameSession$Port' => '<p>Port number for the game session. To connect to a Amazon GameLift game server, an app needs both the IP address and port number.</p>', 'GameSessionPlacement$Port' => '<p>Port number for the game session. To connect to a Amazon GameLift game server, an app needs both the IP address and port number. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>', 'IpPermission$FromPort' => '<p>Starting value for a range of allowed port numbers.</p>', 'IpPermission$ToPort' => '<p>Ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than <code>FromPort</code>.</p>', 'PlayerSession$Port' => '<p>Port number for the game session. To connect to a Amazon GameLift server process, an app needs both the IP address and port number.</p>', ], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetAttributesInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>', 'DescribeFleetCapacityInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>', 'DescribeFleetEventsInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'DescribeFleetUtilizationInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>', 'DescribeGameSessionDetailsInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'DescribeGameSessionQueuesInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'DescribeGameSessionsInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'DescribeInstancesInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'DescribeMatchmakingConfigurationsInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is limited to 10.</p>', 'DescribePlayerSessionsInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. If a player session ID is specified, this parameter is ignored.</p>', 'DescribeScalingPoliciesInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'GameSessionConnectionInfo$Port' => '<p>Port number for the game session. To connect to a Amazon GameLift game server, an app needs both the IP address and port number.</p>', 'LatencyMap$value' => NULL, 'ListAliasesInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListBuildsInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListFleetsInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'PutScalingPolicyInput$EvaluationPeriods' => '<p>Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.</p>', 'ScalingPolicy$EvaluationPeriods' => '<p>Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.</p>', 'SearchGameSessionsInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. The maximum number of results returned is 20, even if this value is not set or is set higher than 20. </p>', 'ServerProcess$ConcurrentExecutions' => '<p>Number of server processes using this configuration to run concurrently on an instance.</p>', ], ], 'PositiveLong' => [ 'base' => NULL, 'refs' => [ 'Build$SizeOnDisk' => '<p>File size of the uploaded game build, expressed in bytes. When the build status is <code>INITIALIZED</code>, this value is 0.</p>', ], ], 'ProtectionPolicy' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$NewGameSessionProtectionPolicy' => '<p>Game session protection policy to apply to all instances in this fleet. If this parameter is not set, instances in this fleet default to no protection. You can change a fleet\'s protection policy using UpdateFleetAttributes, but this change will only affect sessions created after the policy change. You can also set protection for individual instances using <a>UpdateGameSession</a>.</p> <ul> <li> <p> <b>NoProtection</b> – The game session can be terminated during a scale-down event.</p> </li> <li> <p> <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li> </ul>', 'FleetAttributes$NewGameSessionProtectionPolicy' => '<p>Type of game session protection to set for all new instances started in the fleet.</p> <ul> <li> <p> <b>NoProtection</b> – The game session can be terminated during a scale-down event.</p> </li> <li> <p> <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li> </ul>', 'GameSessionDetail$ProtectionPolicy' => '<p>Current status of protection for the game session.</p> <ul> <li> <p> <b>NoProtection</b> – The game session can be terminated during a scale-down event.</p> </li> <li> <p> <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li> </ul>', 'UpdateFleetAttributesInput$NewGameSessionProtectionPolicy' => '<p>Game session protection policy to apply to all new instances created in this fleet. Instances that already exist are not affected. You can set protection for individual instances using <a>UpdateGameSession</a>.</p> <ul> <li> <p> <b>NoProtection</b> – The game session can be terminated during a scale-down event.</p> </li> <li> <p> <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li> </ul>', 'UpdateGameSessionInput$ProtectionPolicy' => '<p>Game session protection policy to apply to this game session only.</p> <ul> <li> <p> <b>NoProtection</b> – The game session can be terminated during a scale-down event.</p> </li> <li> <p> <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li> </ul>', ], ], 'PutScalingPolicyInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'PutScalingPolicyOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'QueueArnsList' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$GameSessionQueueArns' => '<p>Amazon Resource Name (<a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a game session queue and uniquely identifies it. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>. These queues are used when placing game sessions for matches that are created with this matchmaking configuration. Queues can be located in any region.</p>', 'MatchmakingConfiguration$GameSessionQueueArns' => '<p>Amazon Resource Name (<a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a game session queue and uniquely identifies it. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>. These queues are used when placing game sessions for matches that are created with this matchmaking configuration. Queues can be located in any region.</p>', 'UpdateMatchmakingConfigurationInput$GameSessionQueueArns' => '<p>Amazon Resource Name (<a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a game session queue and uniquely identifies it. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>. These queues are used when placing game sessions for matches that are created with this matchmaking configuration. Queues can be located in any region.</p>', ], ], 'RequestUploadCredentialsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'RequestUploadCredentialsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'ResolveAliasInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'ResolveAliasOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'ResourceCreationLimitPolicy' => [ 'base' => '<p>Policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".</p> <p>The policy is evaluated when a player tries to create a new game session. For example, with a policy of 10 new game sessions and a time period of 60 minutes, on receiving a <code>CreateGameSession</code> request, Amazon GameLift checks that the player (identified by <code>CreatorId</code>) has created fewer than 10 game sessions in the past 60 minutes.</p>', 'refs' => [ 'CreateFleetInput$ResourceCreationLimitPolicy' => '<p>Policy that limits the number of game sessions an individual player can create over a span of time for this fleet.</p>', 'FleetAttributes$ResourceCreationLimitPolicy' => '<p>Fleet policy to limit the number of game sessions an individual player can create over a span of time.</p>', 'UpdateFleetAttributesInput$ResourceCreationLimitPolicy' => '<p>Policy that limits the number of game sessions an individual player can create over a span of time. </p>', ], ], 'RoutingStrategy' => [ 'base' => '<p>Routing configuration for a fleet alias.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'refs' => [ 'Alias$RoutingStrategy' => '<p>Alias configuration for the alias, including routing type and settings.</p>', 'CreateAliasInput$RoutingStrategy' => '<p>Object that specifies the fleet and routing type to use for the alias.</p>', 'UpdateAliasInput$RoutingStrategy' => '<p>Object that specifies the fleet and routing type to use for the alias.</p>', ], ], 'RoutingStrategyType' => [ 'base' => NULL, 'refs' => [ 'ListAliasesInput$RoutingStrategyType' => '<p>Type of routing to filter results on. Use this parameter to retrieve only aliases of a certain type. To retrieve all aliases, leave this parameter empty.</p> <p>Possible routing types include the following:</p> <ul> <li> <p> <b>SIMPLE</b> – The alias resolves to one specific fleet. Use this type when routing to active fleets.</p> </li> <li> <p> <b>TERMINAL</b> – The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a> message embedded.</p> </li> </ul>', 'RoutingStrategy$Type' => '<p>Type of routing strategy.</p> <p>Possible routing types include the following:</p> <ul> <li> <p> <b>SIMPLE</b> – The alias resolves to one specific fleet. Use this type when routing to active fleets.</p> </li> <li> <p> <b>TERMINAL</b> – The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a> message embedded.</p> </li> </ul>', ], ], 'RuleSetBody' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingRuleSetInput$RuleSetBody' => '<p>Collection of matchmaking rules, formatted as a JSON string. (Note that comments are not allowed in JSON, but most elements support a description field.)</p>', 'MatchmakingRuleSet$RuleSetBody' => '<p>Collection of matchmaking rules, formatted as a JSON string. (Note that comments14 are not allowed in JSON, but most elements support a description field.)</p>', 'ValidateMatchmakingRuleSetInput$RuleSetBody' => '<p>Collection of matchmaking rules to validate, formatted as a JSON string.</p>', ], ], 'RuleSetLimit' => [ 'base' => NULL, 'refs' => [ 'DescribeMatchmakingRuleSetsInput$Limit' => '<p>Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', ], ], 'RuntimeConfiguration' => [ 'base' => '<p>A collection of server process configurations that describe what processes to run on each instance in a fleet. All fleets must have a run-time configuration. Each instance in the fleet launches the server processes specified in the run-time configuration and launches new ones as existing processes end. Each instance regularly checks for an updated run-time configuration and follows the new instructions. </p> <p>The run-time configuration enables the instances in a fleet to run multiple processes simultaneously. Potential scenarios are as follows: (1) Run multiple processes of a single game server executable to maximize usage of your hosting resources. (2) Run one or more processes of different build executables, such as your game server executable and a related program, or two or more different versions of a game server. (3) Run multiple processes of a single game server but with different launch parameters, for example to run one process on each instance in debug mode.</p> <p>A Amazon GameLift instance is limited to 50 processes running simultaneously. A run-time configuration must specify fewer than this limit. To calculate the total number of processes specified in a run-time configuration, add the values of the <code>ConcurrentExecutions</code> parameter for each <code> <a>ServerProcess</a> </code> object in the run-time configuration.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'refs' => [ 'CreateFleetInput$RuntimeConfiguration' => '<p>Instructions for launching server processes on each instance in the fleet. The run-time configuration for a fleet has a collection of server process configurations, one for each type of server process to run on an instance. A server process configuration specifies the location of the server executable, launch parameters, and the number of concurrent processes with that configuration to maintain on each instance. A CreateFleet request must include a run-time configuration with at least one server process configuration; otherwise the request fails with an invalid request exception. (This parameter replaces the parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>; requests that contain values for these parameters instead of a run-time configuration will continue to work.) </p>', 'DescribeRuntimeConfigurationOutput$RuntimeConfiguration' => '<p>Instructions describing how server processes should be launched and maintained on each instance in the fleet.</p>', 'UpdateRuntimeConfigurationInput$RuntimeConfiguration' => '<p>Instructions for launching server processes on each instance in the fleet. The run-time configuration for a fleet has a collection of server process configurations, one for each type of server process to run on an instance. A server process configuration specifies the location of the server executable, launch parameters, and the number of concurrent processes with that configuration to maintain on each instance.</p>', 'UpdateRuntimeConfigurationOutput$RuntimeConfiguration' => '<p>The run-time configuration currently in force. If the update was successful, this object matches the one in the request.</p>', ], ], 'S3Location' => [ 'base' => '<p>Location in Amazon Simple Storage Service (Amazon S3) where build files can be stored for access by Amazon GameLift. This location is specified in a <a>CreateBuild</a> request. For more details, see the <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build">Create a Build with Files in Amazon S3</a>.</p>', 'refs' => [ 'CreateBuildInput$StorageLocation' => '<p>Amazon S3 location of the game build files to be uploaded. The S3 bucket must be owned by the same AWS account that you\'re using to manage Amazon GameLift. It also must in the same region that you want to create a new build in. Before calling <code>CreateBuild</code> with this location, you must allow Amazon GameLift to access your Amazon S3 bucket (see <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build">Create a Build with Files in Amazon S3</a>).</p>', 'CreateBuildOutput$StorageLocation' => '<p>Amazon S3 location specified in the request.</p>', 'RequestUploadCredentialsOutput$StorageLocation' => '<p>Amazon S3 path and key, identifying where the game build files are stored.</p>', ], ], 'ScalingAdjustmentType' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyInput$ScalingAdjustmentType' => '<p>Type of adjustment to make to a fleet\'s instance count (see <a>FleetCapacity</a>):</p> <ul> <li> <p> <b>ChangeInCapacity</b> – add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</p> </li> <li> <p> <b>ExactCapacity</b> – set the instance count to the scaling adjustment value.</p> </li> <li> <p> <b>PercentChangeInCapacity</b> – increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down; for example, a value of "-10" scales the fleet down by 10%.</p> </li> </ul>', 'ScalingPolicy$ScalingAdjustmentType' => '<p>Type of adjustment to make to a fleet\'s instance count (see <a>FleetCapacity</a>):</p> <ul> <li> <p> <b>ChangeInCapacity</b> – add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</p> </li> <li> <p> <b>ExactCapacity</b> – set the instance count to the scaling adjustment value.</p> </li> <li> <p> <b>PercentChangeInCapacity</b> – increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down.</p> </li> </ul>', ], ], 'ScalingPolicy' => [ 'base' => '<p>Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.</p> <p>Fleet-related operations include:</p> <ul> <li> <p> <a>CreateFleet</a> </p> </li> <li> <p> <a>ListFleets</a> </p> </li> <li> <p>Describe fleets:</p> <ul> <li> <p> <a>DescribeFleetAttributes</a> </p> </li> <li> <p> <a>DescribeFleetPortSettings</a> </p> </li> <li> <p> <a>DescribeFleetUtilization</a> </p> </li> <li> <p> <a>DescribeRuntimeConfiguration</a> </p> </li> <li> <p> <a>DescribeFleetEvents</a> </p> </li> </ul> </li> <li> <p>Update fleets:</p> <ul> <li> <p> <a>UpdateFleetAttributes</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetPortSettings</a> </p> </li> <li> <p> <a>UpdateRuntimeConfiguration</a> </p> </li> </ul> </li> <li> <p>Manage fleet capacity:</p> <ul> <li> <p> <a>DescribeFleetCapacity</a> </p> </li> <li> <p> <a>UpdateFleetCapacity</a> </p> </li> <li> <p> <a>PutScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeScalingPolicies</a> (automatic scaling)</p> </li> <li> <p> <a>DeleteScalingPolicy</a> (automatic scaling)</p> </li> <li> <p> <a>DescribeEC2InstanceLimits</a> </p> </li> </ul> </li> <li> <p> <a>DeleteFleet</a> </p> </li> </ul>', 'refs' => [ 'ScalingPolicyList$member' => NULL, ], ], 'ScalingPolicyList' => [ 'base' => NULL, 'refs' => [ 'DescribeScalingPoliciesOutput$ScalingPolicies' => '<p>Collection of objects containing the scaling policies matching the request.</p>', ], ], 'ScalingStatusType' => [ 'base' => NULL, 'refs' => [ 'DescribeScalingPoliciesInput$StatusFilter' => '<p>Scaling policy status to filter results on. A scaling policy is only in force when in an <code>ACTIVE</code> status.</p> <ul> <li> <p> <b>ACTIVE</b> – The scaling policy is currently in force.</p> </li> <li> <p> <b>UPDATEREQUESTED</b> – A request to update the scaling policy has been received.</p> </li> <li> <p> <b>UPDATING</b> – A change is being made to the scaling policy.</p> </li> <li> <p> <b>DELETEREQUESTED</b> – A request to delete the scaling policy has been received.</p> </li> <li> <p> <b>DELETING</b> – The scaling policy is being deleted.</p> </li> <li> <p> <b>DELETED</b> – The scaling policy has been deleted.</p> </li> <li> <p> <b>ERROR</b> – An error occurred in creating the policy. It should be removed and recreated.</p> </li> </ul>', 'ScalingPolicy$Status' => '<p>Current status of the scaling policy. The scaling policy is only in force when in an <code>ACTIVE</code> status.</p> <ul> <li> <p> <b>ACTIVE</b> – The scaling policy is currently in force.</p> </li> <li> <p> <b>UPDATE_REQUESTED</b> – A request to update the scaling policy has been received.</p> </li> <li> <p> <b>UPDATING</b> – A change is being made to the scaling policy.</p> </li> <li> <p> <b>DELETE_REQUESTED</b> – A request to delete the scaling policy has been received.</p> </li> <li> <p> <b>DELETING</b> – The scaling policy is being deleted.</p> </li> <li> <p> <b>DELETED</b> – The scaling policy has been deleted.</p> </li> <li> <p> <b>ERROR</b> – An error occurred in creating the policy. It should be removed and recreated.</p> </li> </ul>', ], ], 'SearchGameSessionsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'SearchGameSessionsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'ServerProcess' => [ 'base' => '<p>A set of instructions for launching server processes on each instance in a fleet. Each instruction set identifies the location of the server executable, optional launch parameters, and the number of server processes with this configuration to maintain concurrently on the instance. Server process configurations make up a fleet\'s <code> <a>RuntimeConfiguration</a> </code>.</p>', 'refs' => [ 'ServerProcessList$member' => NULL, ], ], 'ServerProcessList' => [ 'base' => NULL, 'refs' => [ 'RuntimeConfiguration$ServerProcesses' => '<p>Collection of server process configurations that describe which server processes to run on each instance in a fleet.</p>', ], ], 'SnsArnStringModel' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$NotificationTarget' => '<p>SNS topic ARN that is set up to receive matchmaking notifications.</p>', 'MatchmakingConfiguration$NotificationTarget' => '<p>SNS topic ARN that is set up to receive matchmaking notifications.</p>', 'UpdateMatchmakingConfigurationInput$NotificationTarget' => '<p>SNS topic ARN that is set up to receive matchmaking notifications. See <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/match-notification.html"> Setting up Notifications for Matchmaking</a> for more information.</p>', ], ], 'StartGameSessionPlacementInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'StartGameSessionPlacementOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'StartMatchmakingInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'StartMatchmakingOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'StopGameSessionPlacementInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'StopGameSessionPlacementOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'StopMatchmakingInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'StopMatchmakingOutput' => [ 'base' => NULL, 'refs' => [], ], 'StringDoubleMap' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$SDM' => '<p>For a map of up to 10 type:value pairs. Maximum length for each string value is 100 characters. </p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$SL' => '<p>For a list of up to 10 strings. Maximum length for each string is 100 characters. Duplicate values are not recognized; all occurances of the the repeated value after the first of a repeated value are ignored.</p>', 'CreateFleetInput$LogPaths' => '<p>This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a server process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one or more directory paths in <code>logParameters</code>. See more information in the <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process">Server API Reference</a>. </p>', 'FleetAttributes$LogPaths' => '<p>Location of default log files. When a server process is shut down, Amazon GameLift captures and stores any log files in this location. These logs are in addition to game session logs; see more on game session logs in the <a href="http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-api-server-code">Amazon GameLift Developer Guide</a>. If no default log path for a fleet is specified, Amazon GameLift automatically uploads logs that are stored on each instance at <code>C:\\game\\logs</code> (for Windows) or <code>/local/game/logs</code> (for Linux). Use the Amazon GameLift console to access stored logs. </p>', ], ], 'StringModel' => [ 'base' => NULL, 'refs' => [ 'GameSessionConnectionInfo$IpAddress' => '<p>IP address of the game session. To connect to a Amazon GameLift game server, an app needs both the IP address and port number.</p>', 'MatchmakingTicket$StatusReason' => '<p>Code to explain the current status. For example, a status reason may indicate when a ticket has returned to <code>SEARCHING</code> status after a proposed match fails to receive player acceptances.</p>', 'MatchmakingTicket$StatusMessage' => '<p>Additional information about the current status.</p>', ], ], 'TerminalRoutingStrategyException' => [ 'base' => '<p>The service is unable to resolve the routing for a particular alias because it has a terminal <a>RoutingStrategy</a> associated with it. The message returned in this exception is the message defined in the routing strategy itself. Such requests should only be retried if the routing strategy for the specified alias is modified. </p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Alias$CreationTime' => '<p>Time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'Alias$LastUpdatedTime' => '<p>Time stamp indicating when this data object was last modified. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'Build$CreationTime' => '<p>Time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'DescribeFleetEventsInput$StartTime' => '<p>Earliest date to retrieve event logs for. If no start time is specified, this call returns entries starting from when the fleet was created to the specified end time. Format is a number expressed in Unix time as milliseconds (ex: "1469498468.057").</p>', 'DescribeFleetEventsInput$EndTime' => '<p>Most recent date to retrieve event logs for. If no end time is specified, this call returns entries from the specified start time up to the present. Format is a number expressed in Unix time as milliseconds (ex: "1469498468.057").</p>', 'Event$EventTime' => '<p>Time stamp indicating when this event occurred. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'FleetAttributes$CreationTime' => '<p>Time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'FleetAttributes$TerminationTime' => '<p>Time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'GameSession$CreationTime' => '<p>Time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'GameSession$TerminationTime' => '<p>Time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'GameSessionPlacement$StartTime' => '<p>Time stamp indicating when this request was placed in the queue. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'GameSessionPlacement$EndTime' => '<p>Time stamp indicating when this request was completed, canceled, or timed out.</p>', 'Instance$CreationTime' => '<p>Time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'MatchmakingConfiguration$CreationTime' => '<p>Time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'MatchmakingRuleSet$CreationTime' => '<p>Time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'MatchmakingTicket$StartTime' => '<p>Time stamp indicating when this matchmaking request was received. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'PlayerSession$CreationTime' => '<p>Time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', 'PlayerSession$TerminationTime' => '<p>Time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>The client failed authentication. Clients should not retry such requests.</p>', 'refs' => [], ], 'UnsupportedRegionException' => [ 'base' => '<p>The requested operation is not supported in the region specified.</p>', 'refs' => [], ], 'UpdateAliasInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'UpdateAliasOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'UpdateBuildInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'UpdateBuildOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'UpdateFleetAttributesInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'UpdateFleetAttributesOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'UpdateFleetCapacityInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'UpdateFleetCapacityOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'UpdateFleetPortSettingsInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'UpdateFleetPortSettingsOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'UpdateGameSessionInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'UpdateGameSessionOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'UpdateGameSessionQueueInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'UpdateGameSessionQueueOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'UpdateMatchmakingConfigurationInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'UpdateMatchmakingConfigurationOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'UpdateRuntimeConfigurationInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'UpdateRuntimeConfigurationOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'ValidateMatchmakingRuleSetInput' => [ 'base' => '<p>Represents the input for a request action.</p>', 'refs' => [], ], 'ValidateMatchmakingRuleSetOutput' => [ 'base' => '<p>Represents the returned data in response to a request action.</p>', 'refs' => [], ], 'WholeNumber' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionInput$MaximumPlayerSessionCount' => '<p>Maximum number of players that can be connected simultaneously to the game session.</p>', 'CreateGameSessionQueueInput$TimeoutInSeconds' => '<p>Maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>', 'CreateMatchmakingConfigurationInput$AdditionalPlayerCount' => '<p>Number of player slots in a match to keep open for future players. For example, if the configuration\'s rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match.</p>', 'EC2InstanceCounts$DESIRED' => '<p>Ideal number of active instances in the fleet.</p>', 'EC2InstanceCounts$MINIMUM' => '<p>Minimum value allowed for the fleet\'s instance count.</p>', 'EC2InstanceCounts$MAXIMUM' => '<p>Maximum value allowed for the fleet\'s instance count.</p>', 'EC2InstanceCounts$PENDING' => '<p>Number of instances in the fleet that are starting but not yet active.</p>', 'EC2InstanceCounts$ACTIVE' => '<p>Actual number of active instances in the fleet.</p>', 'EC2InstanceCounts$IDLE' => '<p>Number of active instances in the fleet that are not currently hosting a game session.</p>', 'EC2InstanceCounts$TERMINATING' => '<p>Number of instances in the fleet that are no longer active but haven\'t yet been terminated.</p>', 'EC2InstanceLimit$CurrentInstances' => '<p>Number of instances of the specified type that are currently in use by this AWS account.</p>', 'EC2InstanceLimit$InstanceLimit' => '<p>Number of instances allowed.</p>', 'FleetUtilization$ActiveServerProcessCount' => '<p>Number of server processes in an <code>ACTIVE</code> status currently running across all instances in the fleet</p>', 'FleetUtilization$ActiveGameSessionCount' => '<p>Number of active game sessions currently being hosted on all instances in the fleet.</p>', 'FleetUtilization$CurrentPlayerSessionCount' => '<p>Number of active player sessions currently being hosted on all instances in the fleet.</p>', 'FleetUtilization$MaximumPlayerSessionCount' => '<p>Maximum players allowed across all game sessions currently being hosted on all instances in the fleet.</p>', 'GameSession$CurrentPlayerSessionCount' => '<p>Number of players currently in the game session.</p>', 'GameSession$MaximumPlayerSessionCount' => '<p>Maximum number of players that can be connected simultaneously to the game session.</p>', 'GameSessionPlacement$MaximumPlayerSessionCount' => '<p>Maximum number of players that can be connected simultaneously to the game session.</p>', 'GameSessionQueue$TimeoutInSeconds' => '<p>Maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>', 'MatchmakingConfiguration$AdditionalPlayerCount' => '<p>Number of player slots in a match to keep open for future players. For example, if the configuration\'s rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match.</p>', 'PlayerLatencyPolicy$MaximumIndividualPlayerLatencyMilliseconds' => '<p>The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.</p>', 'PlayerLatencyPolicy$PolicyDurationSeconds' => '<p>The length of time, in seconds, that the policy is enforced while placing a new game session. A null value for this property means that the policy is enforced until the queue times out.</p>', 'ResourceCreationLimitPolicy$NewGameSessionsPerCreator' => '<p>Maximum number of game sessions that an individual can create during the policy period. </p>', 'ResourceCreationLimitPolicy$PolicyPeriodInMinutes' => '<p>Time span used in evaluating the resource creation limit policy. </p>', 'StartGameSessionPlacementInput$MaximumPlayerSessionCount' => '<p>Maximum number of players that can be connected simultaneously to the game session.</p>', 'UpdateFleetCapacityInput$DesiredInstances' => '<p>Number of EC2 instances you want this fleet to host.</p>', 'UpdateFleetCapacityInput$MinSize' => '<p>Minimum value allowed for the fleet\'s instance count. Default if not set is 0.</p>', 'UpdateFleetCapacityInput$MaxSize' => '<p>Maximum value allowed for the fleet\'s instance count. Default if not set is 1.</p>', 'UpdateGameSessionInput$MaximumPlayerSessionCount' => '<p>Maximum number of players that can be connected simultaneously to the game session.</p>', 'UpdateGameSessionQueueInput$TimeoutInSeconds' => '<p>Maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>', 'UpdateMatchmakingConfigurationInput$AdditionalPlayerCount' => '<p>Number of player slots in a match to keep open for future players. For example, if the configuration\'s rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match.</p>', ], ], ],];
