<?php
// This file was auto-generated from sdk-root/src/data/glue/2017-03-31/docs-2.json
return [ 'version' => '2.0', 'service' => 'Defines service operations used by the GlueFrontendService', 'operations' => [ 'BatchCreatePartition' => '<p>Creates one or more partitions in a batch operation.</p>', 'BatchDeleteConnection' => '<p>Deletes a list of connection definitions from the Data Catalog.</p>', 'BatchDeletePartition' => '<p>Deletes one or more partitions in a batch operation.</p>', 'BatchDeleteTable' => '<p>Deletes multiple tables at once.</p>', 'BatchGetPartition' => '<p>Retrieves partitions in a batch request.</p>', 'CreateClassifier' => '<p>Creates a <code>Classifier</code> in the user\'s account.</p>', 'CreateConnection' => '<p>Creates a connection definition in the Data Catalog.</p>', 'CreateCrawler' => '<p>Creates a new <code>Crawler</code> with specified targets, role, configuration, and optional schedule. At least one crawl target must be specified, in either the <i>s3Targets</i> or the <i>jdbcTargets</i> field.</p>', 'CreateDatabase' => '<p>Creates a new database in a Data Catalog.</p>', 'CreateDevEndpoint' => '<p>Creates a new DevEndpoint.</p>', 'CreateJob' => '<p>Creates a new job.</p>', 'CreatePartition' => '<p>Creates a new partition.</p>', 'CreateScript' => '<p>Transforms a directed acyclic graph (DAG) into a Python script.</p>', 'CreateTable' => '<p>Creates a new table definition in the Data Catalog.</p>', 'CreateTrigger' => '<p>Creates a new trigger.</p>', 'CreateUserDefinedFunction' => '<p>Creates a new function definition in the Data Catalog.</p>', 'DeleteClassifier' => '<p>Removes a <code>Classifier</code> from the metadata store.</p>', 'DeleteConnection' => '<p>Deletes a connection from the Data Catalog.</p>', 'DeleteCrawler' => '<p>Removes a specified <code>Crawler</code> from the metadata store, unless the <code>Crawler</code> state is <code>RUNNING</code>.</p>', 'DeleteDatabase' => '<p>Removes a specified Database from a Data Catalog.</p>', 'DeleteDevEndpoint' => '<p>Deletes a specified DevEndpoint.</p>', 'DeleteJob' => '<p>Deletes a specified job.</p>', 'DeletePartition' => '<p>Deletes a specified partition.</p>', 'DeleteTable' => '<p>Removes a table definition from the Data Catalog.</p>', 'DeleteTrigger' => '<p>Deletes a specified trigger.</p>', 'DeleteUserDefinedFunction' => '<p>Deletes an existing function definition from the Data Catalog.</p>', 'GetCatalogImportStatus' => '<p>Retrieves the status of a migration operation.</p>', 'GetClassifier' => '<p>Retrieve a <code>Classifier</code> by name.</p>', 'GetClassifiers' => '<p>Lists all Classifier objects in the metadata store.</p>', 'GetConnection' => '<p>Retrieves a connection definition from the Data Catalog.</p>', 'GetConnections' => '<p>Retrieves a list of connection definitions from the Data Catalog.</p>', 'GetCrawler' => '<p>Retrieves metadata for a specified <code>Crawler</code>.</p>', 'GetCrawlerMetrics' => '<p>Retrieves metrics about specified crawlers.</p>', 'GetCrawlers' => '<p>Retrieves metadata for all <code>Crawlers</code> defined in the customer account.</p>', 'GetDatabase' => '<p>Retrieves the definition of a specified database.</p>', 'GetDatabases' => '<p>Retrieves all Databases defined in a given Data Catalog.</p>', 'GetDataflowGraph' => '<p>Transforms a Python script into a directed acyclic graph (DAG). </p>', 'GetDevEndpoint' => '<p>Retrieves information about a specified DevEndpoint.</p>', 'GetDevEndpoints' => '<p>Retrieves all the DevEndpoints in this AWS account.</p>', 'GetJob' => '<p>Retrieves an existing job definition.</p>', 'GetJobRun' => '<p>Retrieves the metadata for a given job run.</p>', 'GetJobRuns' => '<p>Retrieves metadata for all runs of a given job.</p>', 'GetJobs' => '<p>Retrieves all current jobs.</p>', 'GetMapping' => '<p>Creates mappings.</p>', 'GetPartition' => '<p>Retrieves information about a specified partition.</p>', 'GetPartitions' => '<p>Retrieves information about the partitions in a table.</p>', 'GetPlan' => '<p>Gets a Python script to perform a specified mapping.</p>', 'GetTable' => '<p>Retrieves the <code>Table</code> definition in a Data Catalog for a specified table.</p>', 'GetTableVersions' => '<p>Retrieves a list of strings that identify available versions of a specified table.</p>', 'GetTables' => '<p>Retrieves the definitions of some or all of the tables in a given <code>Database</code>.</p>', 'GetTrigger' => '<p>Retrieves the definition of a trigger.</p>', 'GetTriggers' => '<p>Gets all the triggers associated with a job.</p>', 'GetUserDefinedFunction' => '<p>Retrieves a specified function definition from the Data Catalog.</p>', 'GetUserDefinedFunctions' => '<p>Retrieves a multiple function definitions from the Data Catalog.</p>', 'ImportCatalogToGlue' => '<p>Imports an existing Athena Data Catalog to AWS Glue</p>', 'ResetJobBookmark' => '<p>Resets a bookmark entry.</p>', 'StartCrawler' => '<p>Starts a crawl using the specified <code>Crawler</code>, regardless of what is scheduled. If the <code>Crawler</code> is already running, does nothing.</p>', 'StartCrawlerSchedule' => '<p>Changes the schedule state of the specified crawler to <code>SCHEDULED</code>, unless the crawler is already running or the schedule state is already <code>SCHEDULED</code>.</p>', 'StartJobRun' => '<p>Runs a job.</p>', 'StartTrigger' => '<p>Starts an existing trigger.</p>', 'StopCrawler' => '<p>If the specified <code>Crawler</code> is running, stops the crawl.</p>', 'StopCrawlerSchedule' => '<p>Sets the schedule state of the specified crawler to <code>NOT_SCHEDULED</code>, but does not stop the crawler if it is already running.</p>', 'StopTrigger' => '<p>Stops a specified trigger.</p>', 'UpdateClassifier' => '<p>Modifies an existing <code>Classifier</code>.</p>', 'UpdateConnection' => '<p>Updates a connection definition in the Data Catalog.</p>', 'UpdateCrawler' => '<p>Updates a <code>Crawler</code>. If a <code>Crawler</code> is running, you must stop it using <code>StopCrawler</code> before updating it.</p>', 'UpdateCrawlerSchedule' => '<p>Updates the schedule of a crawler using a Cron expression. </p>', 'UpdateDatabase' => '<p>Updates an existing database definition in a Data Catalog.</p>', 'UpdateDevEndpoint' => '<p>Updates a specified DevEndpoint.</p>', 'UpdateJob' => '<p>Updates an existing job definition.</p>', 'UpdatePartition' => '<p>Updates a partition.</p>', 'UpdateTable' => '<p>Updates a metadata table in the Data Catalog.</p>', 'UpdateTrigger' => '<p>Updates a trigger definition.</p>', 'UpdateUserDefinedFunction' => '<p>Updates an existing function definition in the Data Catalog.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Access to a resource was denied.</p>', 'refs' => [], ], 'Action' => [ 'base' => NULL, 'refs' => [ 'ActionList$member' => NULL, ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'CreateTriggerRequest$Actions' => '<p>The actions initiated by this trigger when it fires.</p>', 'Trigger$Actions' => '<p>The actions initiated by this trigger.</p>', 'TriggerUpdate$Actions' => '<p>The actions initiated by this trigger.</p>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>A resource to be created or added already exists.</p>', 'refs' => [], ], 'AttemptCount' => [ 'base' => NULL, 'refs' => [ 'JobRun$Attempt' => '<p>The number or the attempt to run this job.</p>', ], ], 'BatchCreatePartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreatePartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeletePartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeletePartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeletePartitionValueList' => [ 'base' => NULL, 'refs' => [ 'BatchDeletePartitionRequest$PartitionsToDelete' => '<p>A list of <code>PartitionInput</code> structures that define the partitions to be deleted.</p>', ], ], 'BatchDeleteTableNameList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteTableRequest$TablesToDelete' => '<p>A list of the table to delete.</p>', ], ], 'BatchDeleteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetPartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetPartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetPartitionValueList' => [ 'base' => NULL, 'refs' => [ 'BatchGetPartitionRequest$PartitionsToGet' => '<p>A list of partition values identifying the partitions to retrieve.</p>', 'BatchGetPartitionResponse$UnprocessedKeys' => '<p>A list of the partition values in the request for which partions were not returned.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CatalogImportStatus$ImportCompleted' => '<p>True if the migration has completed, or False otherwise.</p>', 'CodeGenNodeArg$Param' => '<p>True if the value is used as a parameter.</p>', 'CrawlerMetrics$StillEstimating' => '<p>True if the crawler is estimating its </p>', 'StorageDescriptor$Compressed' => '<p>True if the data in the table is compressed, or False if not.</p>', 'StorageDescriptor$StoredAsSubDirectories' => '<p>True if the table data is stored in subdirectories, or False if not.</p>', ], ], 'BooleanValue' => [ 'base' => NULL, 'refs' => [ 'GetJobRunRequest$PredecessorsIncluded' => '<p>A list of the predecessor runs to return as well.</p>', ], ], 'BoundedPartitionValueList' => [ 'base' => NULL, 'refs' => [ 'UpdatePartitionRequest$PartitionValueList' => '<p>A list of the values defining the partition.</p>', ], ], 'CatalogEntries' => [ 'base' => NULL, 'refs' => [ 'GetMappingRequest$Sinks' => '<p>A list of target tables.</p>', 'GetPlanRequest$Sinks' => '<p>The target tables.</p>', ], ], 'CatalogEntry' => [ 'base' => '<p>Specifies a table definition in the Data Catalog.</p>', 'refs' => [ 'CatalogEntries$member' => NULL, 'GetMappingRequest$Source' => '<p>Specifies the source table.</p>', 'GetPlanRequest$Source' => '<p>The source table.</p>', ], ], 'CatalogIdString' => [ 'base' => NULL, 'refs' => [ 'BatchCreatePartitionRequest$CatalogId' => '<p>The ID of the catalog in which the partion is to be created. Currently, this should be the AWS account ID.</p>', 'BatchDeleteConnectionRequest$CatalogId' => '<p>The ID of the Data Catalog in which the connections reside. If none is supplied, the AWS account ID is used by default.</p>', 'BatchDeletePartitionRequest$CatalogId' => '<p>The ID of the Data Catalog where the partition to be deleted resides. If none is supplied, the AWS account ID is used by default.</p>', 'BatchDeleteTableRequest$CatalogId' => '<p>The ID of the Data Catalog where the table resides. If none is supplied, the AWS account ID is used by default.</p>', 'BatchGetPartitionRequest$CatalogId' => '<p>The ID of the Data Catalog where the partitions in question reside. If none is supplied, the AWS account ID is used by default.</p>', 'CreateConnectionRequest$CatalogId' => '<p>The ID of the Data Catalog in which to create the connection. If none is supplied, the AWS account ID is used by default.</p>', 'CreateDatabaseRequest$CatalogId' => '<p>The ID of the Data Catalog in which to create the database. If none is supplied, the AWS account ID is used by default.</p>', 'CreatePartitionRequest$CatalogId' => '<p>The ID of the catalog in which the partion is to be created. Currently, this should be the AWS account ID.</p>', 'CreateTableRequest$CatalogId' => '<p>The ID of the Data Catalog in which to create the <code>Table</code>. If none is supplied, the AWS account ID is used by default.</p>', 'CreateUserDefinedFunctionRequest$CatalogId' => '<p>The ID of the Data Catalog in which to create the function. If none is supplied, the AWS account ID is used by default.</p>', 'DeleteConnectionRequest$CatalogId' => '<p>The ID of the Data Catalog in which the connection resides. If none is supplied, the AWS account ID is used by default.</p>', 'DeleteDatabaseRequest$CatalogId' => '<p>The ID of the Data Catalog in which the database resides. If none is supplied, the AWS account ID is used by default.</p>', 'DeletePartitionRequest$CatalogId' => '<p>The ID of the Data Catalog where the partition to be deleted resides. If none is supplied, the AWS account ID is used by default.</p>', 'DeleteTableRequest$CatalogId' => '<p>The ID of the Data Catalog where the table resides. If none is supplied, the AWS account ID is used by default.</p>', 'DeleteUserDefinedFunctionRequest$CatalogId' => '<p>The ID of the Data Catalog where the function to be deleted is located. If none is supplied, the AWS account ID is used by default.</p>', 'GetCatalogImportStatusRequest$CatalogId' => '<p>The ID of the catalog to migrate. Currently, this should be the AWS account ID.</p>', 'GetConnectionRequest$CatalogId' => '<p>The ID of the Data Catalog in which the connection resides. If none is supplied, the AWS account ID is used by default.</p>', 'GetConnectionsRequest$CatalogId' => '<p>The ID of the Data Catalog in which the connections reside. If none is supplied, the AWS account ID is used by default.</p>', 'GetDatabaseRequest$CatalogId' => '<p>The ID of the Data Catalog in which the database resides. If none is supplied, the AWS account ID is used by default.</p>', 'GetDatabasesRequest$CatalogId' => '<p>The ID of the Data Catalog from which to retrieve <code>Databases</code>. If none is supplied, the AWS account ID is used by default.</p>', 'GetPartitionRequest$CatalogId' => '<p>The ID of the Data Catalog where the partition in question resides. If none is supplied, the AWS account ID is used by default.</p>', 'GetPartitionsRequest$CatalogId' => '<p>The ID of the Data Catalog where the partitions in question reside. If none is supplied, the AWS account ID is used by default.</p>', 'GetTableRequest$CatalogId' => '<p>The ID of the Data Catalog where the table resides. If none is supplied, the AWS account ID is used by default.</p>', 'GetTableVersionsRequest$CatalogId' => '<p>The ID of the Data Catalog where the tables reside. If none is supplied, the AWS account ID is used by default.</p>', 'GetTablesRequest$CatalogId' => '<p>The ID of the Data Catalog where the tables reside. If none is supplied, the AWS account ID is used by default.</p>', 'GetUserDefinedFunctionRequest$CatalogId' => '<p>The ID of the Data Catalog where the function to be retrieved is located. If none is supplied, the AWS account ID is used by default.</p>', 'GetUserDefinedFunctionsRequest$CatalogId' => '<p>The ID of the Data Catalog where the functions to be retrieved are located. If none is supplied, the AWS account ID is used by default.</p>', 'ImportCatalogToGlueRequest$CatalogId' => '<p>The ID of the catalog to import. Currently, this should be the AWS account ID.</p>', 'UpdateConnectionRequest$CatalogId' => '<p>The ID of the Data Catalog in which the connection resides. If none is supplied, the AWS account ID is used by default.</p>', 'UpdateDatabaseRequest$CatalogId' => '<p>The ID of the Data Catalog in which the metadata database resides. If none is supplied, the AWS account ID is used by default.</p>', 'UpdatePartitionRequest$CatalogId' => '<p>The ID of the Data Catalog where the partition to be updated resides. If none is supplied, the AWS account ID is used by default.</p>', 'UpdateTableRequest$CatalogId' => '<p>The ID of the Data Catalog where the table resides. If none is supplied, the AWS account ID is used by default.</p>', 'UpdateUserDefinedFunctionRequest$CatalogId' => '<p>The ID of the Data Catalog where the function to be updated is located. If none is supplied, the AWS account ID is used by default.</p>', ], ], 'CatalogImportStatus' => [ 'base' => '<p>A structure containing migration status information.</p>', 'refs' => [ 'GetCatalogImportStatusResponse$ImportStatus' => '<p>The status of the specified catalog migration.</p>', ], ], 'Classification' => [ 'base' => NULL, 'refs' => [ 'CreateGrokClassifierRequest$Classification' => '<p>The type of result that the classifier matches, such as Twitter Json, Omniture logs, Cloudwatch logs, and so forth.</p>', 'GrokClassifier$Classification' => '<p>The data form that the classifier matches, such as Twitter, JSON, Omniture Logs, and so forth.</p>', 'UpdateGrokClassifierRequest$Classification' => '<p>The type of result that the classifier matches, such as Twitter Json, Omniture logs, Cloudwatch logs, and so forth.</p>', ], ], 'Classifier' => [ 'base' => '<p>Classifiers are written in Python and triggered during a Crawl Task. You can write your own Classifiers to best categorize your data sources and specify the appropriate schemas to use for them. A Classifier first checks whether a given file is in a format it can handle, and then, if so, creates a schema in the form of a <code>StructType</code> object that matches that data format.</p>', 'refs' => [ 'ClassifierList$member' => NULL, 'GetClassifierResponse$Classifier' => '<p>The requested <code>Classifier</code>.</p>', ], ], 'ClassifierList' => [ 'base' => NULL, 'refs' => [ 'GetClassifiersResponse$Classifiers' => '<p>The requested list of <code>Classifier</code> objects.</p>', ], ], 'ClassifierNameList' => [ 'base' => NULL, 'refs' => [ 'Crawler$Classifiers' => '<p>A list of custom <code>Classifier</code>s associated with this Crawler.</p>', 'CreateCrawlerRequest$Classifiers' => '<p>A list of custom <code>Classifier</code> names that the user has registered. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.</p>', 'UpdateCrawlerRequest$Classifiers' => '<p>A list of custom <code>Classifier</code> names that the user has registered. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.</p>', ], ], 'CodeGenArgName' => [ 'base' => NULL, 'refs' => [ 'CodeGenEdge$TargetParameter' => '<p>The target of the edge.</p>', 'CodeGenNodeArg$Name' => '<p>The name of the argument or property.</p>', ], ], 'CodeGenArgValue' => [ 'base' => NULL, 'refs' => [ 'CodeGenNodeArg$Value' => '<p>The value of the argument or property.</p>', ], ], 'CodeGenEdge' => [ 'base' => '<p>Represents a directional edge in a directed acyclic graph (DAG).</p>', 'refs' => [ 'DagEdges$member' => NULL, ], ], 'CodeGenIdentifier' => [ 'base' => NULL, 'refs' => [ 'CodeGenEdge$Source' => '<p>The ID of the node at which the edge starts.</p>', 'CodeGenEdge$Target' => '<p>The ID of the node at which the edge ends.</p>', 'CodeGenNode$Id' => '<p>A node identifier that is unique within the node\'s graph.</p>', ], ], 'CodeGenNode' => [ 'base' => '<p>Represents a node in a directed acyclic graph (DAG)</p>', 'refs' => [ 'DagNodes$member' => NULL, ], ], 'CodeGenNodeArg' => [ 'base' => '<p>An argument or property of a node.</p>', 'refs' => [ 'CodeGenNodeArgs$member' => NULL, ], ], 'CodeGenNodeArgs' => [ 'base' => NULL, 'refs' => [ 'CodeGenNode$Args' => '<p>Properties of the node, in the form of name-value pairs.</p>', 'Location$Jdbc' => '<p>A JDBC location.</p>', 'Location$S3' => '<p>An AWS S3 location.</p>', ], ], 'CodeGenNodeType' => [ 'base' => NULL, 'refs' => [ 'CodeGenNode$NodeType' => '<p>The type of node this is.</p>', ], ], 'Column' => [ 'base' => '<p>A column in a <code>Table</code>.</p>', 'refs' => [ 'ColumnList$member' => NULL, ], ], 'ColumnList' => [ 'base' => NULL, 'refs' => [ 'StorageDescriptor$Columns' => '<p>A list of the <code>Columns</code> in the table.</p>', 'Table$PartitionKeys' => '<p>A list of columns by which the table is partitioned. Only primitive types are supported as partition keys.</p>', 'TableInput$PartitionKeys' => '<p>A list of columns by which the table is partitioned. Only primitive types are supported as partition keys.</p>', ], ], 'ColumnTypeString' => [ 'base' => NULL, 'refs' => [ 'Column$Type' => '<p>The datatype of data in the <code>Column</code>.</p>', ], ], 'ColumnValueStringList' => [ 'base' => NULL, 'refs' => [ 'SkewedInfo$SkewedColumnValues' => '<p>A list of values that appear so frequently as to be considered skewed.</p>', ], ], 'ColumnValuesString' => [ 'base' => NULL, 'refs' => [ 'ColumnValueStringList$member' => NULL, 'LocationMap$key' => NULL, 'LocationMap$value' => NULL, ], ], 'CommentString' => [ 'base' => NULL, 'refs' => [ 'Column$Comment' => '<p>Free-form text comment.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>Two processes are trying to modify a resource simultaneously.</p>', 'refs' => [], ], 'ConcurrentRunsExceededException' => [ 'base' => '<p>Too many jobs are being run concurrently.</p>', 'refs' => [], ], 'Condition' => [ 'base' => NULL, 'refs' => [ 'ConditionList$member' => NULL, ], ], 'ConditionList' => [ 'base' => NULL, 'refs' => [ 'Predicate$Conditions' => '<p>A list of the conditions that determine when the trigger will fire.</p>', ], ], 'Connection' => [ 'base' => '<p>Defines a connection to a data source.</p>', 'refs' => [ 'ConnectionList$member' => NULL, 'GetConnectionResponse$Connection' => '<p>The requested connection definition.</p>', ], ], 'ConnectionInput' => [ 'base' => '<p>A structure used to specify a connection to create or update.</p>', 'refs' => [ 'CreateConnectionRequest$ConnectionInput' => '<p>A <code>ConnectionInput</code> object defining the connection to create.</p>', 'UpdateConnectionRequest$ConnectionInput' => '<p>A <code>ConnectionInput</code> object that redefines the connection in question.</p>', ], ], 'ConnectionList' => [ 'base' => NULL, 'refs' => [ 'GetConnectionsResponse$ConnectionList' => '<p>A list of requested connection definitions.</p>', ], ], 'ConnectionName' => [ 'base' => NULL, 'refs' => [ 'JdbcTarget$ConnectionName' => '<p>The name of the connection to use for the JDBC target.</p>', ], ], 'ConnectionProperties' => [ 'base' => NULL, 'refs' => [ 'Connection$ConnectionProperties' => '<p>A list of key-value pairs used as parameters for this connection.</p>', 'ConnectionInput$ConnectionProperties' => '<p>A list of key-value pairs used as parameters for this connection.</p>', ], ], 'ConnectionPropertyKey' => [ 'base' => NULL, 'refs' => [ 'ConnectionProperties$key' => NULL, ], ], 'ConnectionType' => [ 'base' => NULL, 'refs' => [ 'Connection$ConnectionType' => '<p>The type of the connection.</p>', 'ConnectionInput$ConnectionType' => '<p>The type of the connection.</p>', 'GetConnectionsFilter$ConnectionType' => '<p>The type of connections to return.</p>', ], ], 'ConnectionsList' => [ 'base' => '<p>Specifies the connections used by a job.</p>', 'refs' => [ 'CreateJobRequest$Connections' => '<p>The connections used for this job.</p>', 'Job$Connections' => '<p>The connections used for this job.</p>', 'JobUpdate$Connections' => '<p>The connections used for this job.</p>', ], ], 'Crawler' => [ 'base' => '<p>Specifies a crawler program that examines a data source and uses classifiers to try to its schema. If successful, the crawler records metatdata concerning the data source in the Data Catalog.</p>', 'refs' => [ 'CrawlerList$member' => NULL, 'GetCrawlerResponse$Crawler' => '<p>The metadata for the specified <code>Crawler</code>.</p>', ], ], 'CrawlerList' => [ 'base' => NULL, 'refs' => [ 'GetCrawlersResponse$Crawlers' => '<p>A list of <code>Crawler</code> metadata.</p>', ], ], 'CrawlerMetrics' => [ 'base' => '<p>Metrics for a specified crawler.</p>', 'refs' => [ 'CrawlerMetricsList$member' => NULL, ], ], 'CrawlerMetricsList' => [ 'base' => NULL, 'refs' => [ 'GetCrawlerMetricsResponse$CrawlerMetricsList' => '<p>A list of metrics for the specified crawler.</p>', ], ], 'CrawlerNameList' => [ 'base' => NULL, 'refs' => [ 'GetCrawlerMetricsRequest$CrawlerNameList' => '<p>A list of the names of crawlers about which to retrieve metrics.</p>', ], ], 'CrawlerNotRunningException' => [ 'base' => '<p>The specified crawler is not running.</p>', 'refs' => [], ], 'CrawlerRunningException' => [ 'base' => '<p>The operation cannot be performed because the crawler is already running.</p>', 'refs' => [], ], 'CrawlerState' => [ 'base' => NULL, 'refs' => [ 'Crawler$State' => '<p>Indicates whether this Crawler is running, or whether a run is pending.</p>', ], ], 'CrawlerStoppingException' => [ 'base' => '<p>The specified crawler is stopping.</p>', 'refs' => [], ], 'CrawlerTargets' => [ 'base' => '<p>Specifies crawler targets.</p>', 'refs' => [ 'Crawler$Targets' => '<p>A collection of targets to crawl.</p>', 'CreateCrawlerRequest$Targets' => '<p>A list of collection of targets to crawl.</p>', 'UpdateCrawlerRequest$Targets' => '<p>A list of collection of targets to crawl.</p>', ], ], 'CreateClassifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateClassifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCrawlerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCrawlerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDevEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDevEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGrokClassifierRequest' => [ 'base' => '<p>Specifies a Grok classifier for CreateClassifier to create.</p>', 'refs' => [ 'CreateClassifierRequest$GrokClassifier' => '<p>A grok classifier to create.</p>', ], ], 'CreateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateScriptRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateScriptResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTriggerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTriggerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserDefinedFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserDefinedFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CronExpression' => [ 'base' => NULL, 'refs' => [ 'CreateCrawlerRequest$Schedule' => '<p>A cron expression that can be used as a Cloudwatch event (see <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">CloudWatch Schedule Expression Syntax</a>. For example, to run every day at 12:15 UTC, specify: <code>cron(15 12 * * ? *)</code>.</p>', 'Schedule$ScheduleExpression' => '<p>A <code>cron</code> expression that can be used as a Cloudwatch event to schedule something (see <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">CloudWatch Schedule Expression Syntax</a>. For example, to run something every day at 12:15 UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>', 'UpdateCrawlerRequest$Schedule' => '<p>A cron expression that can be used as a Cloudwatch event (see <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">CloudWatch Schedule Expression Syntax</a>. For example, to run every day at 12:15 UTC, specify: <code>cron(15 12 * * ? *)</code>.</p>', 'UpdateCrawlerScheduleRequest$Schedule' => '<p>Cron expression of the updated schedule.</p>', ], ], 'CustomPatterns' => [ 'base' => NULL, 'refs' => [ 'CreateGrokClassifierRequest$CustomPatterns' => '<p>Custom grok patterns used by this classifier.</p>', 'GrokClassifier$CustomPatterns' => '<p>Custom grok patterns used by this classifier.</p>', 'UpdateGrokClassifierRequest$CustomPatterns' => '<p>Custom grok patterns used by this classifier.</p>', ], ], 'DagEdges' => [ 'base' => NULL, 'refs' => [ 'CreateScriptRequest$DagEdges' => '<p>A list of the edges in the DAG.</p>', 'GetDataflowGraphResponse$DagEdges' => '<p>A list of the edges in the resulting DAG.</p>', ], ], 'DagNodes' => [ 'base' => NULL, 'refs' => [ 'CreateScriptRequest$DagNodes' => '<p>A list of the nodes in the DAG.</p>', 'GetDataflowGraphResponse$DagNodes' => '<p>A list of the nodes in the resulting DAG.</p>', ], ], 'Database' => [ 'base' => '<p>The <code>Database</code> object represents a logical grouping of tables that may reside in a Hive metastore or an RDBMS.</p>', 'refs' => [ 'DatabaseList$member' => NULL, 'GetDatabaseResponse$Database' => '<p>The definition of the specified database in the catalog.</p>', ], ], 'DatabaseInput' => [ 'base' => '<p>The structure used to create or updata a database.</p>', 'refs' => [ 'CreateDatabaseRequest$DatabaseInput' => '<p>A <code>DatabaseInput</code> object defining the metadata database to create in the catalog.</p>', 'UpdateDatabaseRequest$DatabaseInput' => '<p>A <code>DatabaseInput</code> object specifying the new definition of the metadata database in the catalog.</p>', ], ], 'DatabaseList' => [ 'base' => NULL, 'refs' => [ 'GetDatabasesResponse$DatabaseList' => '<p>A list of <code>Database</code> objects from the specified catalog.</p>', ], ], 'DatabaseName' => [ 'base' => NULL, 'refs' => [ 'Crawler$DatabaseName' => '<p>The <code>Database</code> where this Crawler\'s output should be stored.</p>', 'CreateCrawlerRequest$DatabaseName' => '<p>The Glue <code>Database</code> where results will be stored, such as: <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.</p>', 'UpdateCrawlerRequest$DatabaseName' => '<p>The Glue <code>Database</code> where results will be stored, such as: <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.</p>', ], ], 'DeleteBehavior' => [ 'base' => NULL, 'refs' => [ 'SchemaChangePolicy$DeleteBehavior' => '<p>The deletion behavior.</p>', ], ], 'DeleteClassifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClassifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionNameList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteConnectionRequest$ConnectionNameList' => '<p>A list of names of the connections to delete.</p>', ], ], 'DeleteConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCrawlerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCrawlerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDevEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDevEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTriggerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTriggerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserDefinedFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserDefinedFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionString' => [ 'base' => NULL, 'refs' => [ 'Connection$Description' => '<p>Description of the connection.</p>', 'ConnectionInput$Description' => '<p>Description of the connection.</p>', 'Crawler$Description' => '<p>A description of this Crawler and where it should be used.</p>', 'CreateCrawlerRequest$Description' => '<p>A description of the new <code>Crawler</code>.</p>', 'CreateJobRequest$Description' => '<p>Description of the job.</p>', 'CreateTriggerRequest$Description' => '<p>A description of the new trigger.</p>', 'Database$Description' => '<p>Description of the database.</p>', 'DatabaseInput$Description' => '<p>Description of the database</p>', 'ErrorDetail$ErrorMessage' => '<p>A message describing the error.</p>', 'Job$Description' => '<p>Description of this job.</p>', 'JobUpdate$Description' => '<p>Description of the job.</p>', 'LastCrawlInfo$ErrorMessage' => '<p>Error information about the last crawl, if an error occurred.</p>', 'Table$Description' => '<p>Description of the table.</p>', 'TableInput$Description' => '<p>Description of the table.</p>', 'Trigger$Description' => '<p>A description of this trigger.</p>', 'TriggerUpdate$Description' => '<p>A description of this trigger.</p>', ], ], 'DescriptionStringRemovable' => [ 'base' => NULL, 'refs' => [ 'UpdateCrawlerRequest$Description' => '<p>A description of the new <code>Crawler</code>.</p>', ], ], 'DevEndpoint' => [ 'base' => '<p>A development endpoint where a developer can remotely debug ETL scripts.</p>', 'refs' => [ 'DevEndpointList$member' => NULL, 'GetDevEndpointResponse$DevEndpoint' => '<p>A DevEndpoint definition.</p>', ], ], 'DevEndpointCustomLibraries' => [ 'base' => '<p>Custom libraries to be loaded into a DevEndpoint.</p>', 'refs' => [ 'UpdateDevEndpointRequest$CustomLibraries' => '<p>Custom Python or Java custom libraries to be loaded in the DevEndpoint.</p>', ], ], 'DevEndpointList' => [ 'base' => NULL, 'refs' => [ 'GetDevEndpointsResponse$DevEndpoints' => '<p>A list of DevEndpoint definitions.</p>', ], ], 'EntityNotFoundException' => [ 'base' => '<p>A specified entity does not exist</p>', 'refs' => [], ], 'ErrorByName' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteConnectionResponse$Errors' => '<p>A map of the names of connections that were not successfully deleted to error details.</p>', ], ], 'ErrorDetail' => [ 'base' => '<p>Contains details about an error.</p>', 'refs' => [ 'ErrorByName$value' => NULL, 'PartitionError$ErrorDetail' => '<p>Details about the partition error.</p>', 'TableError$ErrorDetail' => '<p>Detail about the error.</p>', ], ], 'ErrorString' => [ 'base' => NULL, 'refs' => [ 'JobRun$ErrorMessage' => '<p>An error message associated with this job run.</p>', ], ], 'ExecutionProperty' => [ 'base' => '<p>An execution property of a job.</p>', 'refs' => [ 'CreateJobRequest$ExecutionProperty' => '<p>An ExecutionProperty specifying the maximum number of concurrent runs allowed for this job.</p>', 'Job$ExecutionProperty' => '<p>An ExecutionProperty specifying the maximum number of concurrent runs allowed for this job.</p>', 'JobUpdate$ExecutionProperty' => '<p>An ExecutionProperty specifying the maximum number of concurrent runs allowed for this job.</p>', ], ], 'FieldType' => [ 'base' => NULL, 'refs' => [ 'MappingEntry$SourceType' => '<p>The source type.</p>', 'MappingEntry$TargetType' => '<p>The target type.</p>', ], ], 'FilterString' => [ 'base' => NULL, 'refs' => [ 'GetTablesRequest$Expression' => '<p>A regular expression pattern. If present, only those tables whose names match the pattern are returned.</p>', ], ], 'FormatString' => [ 'base' => NULL, 'refs' => [ 'StorageDescriptor$InputFormat' => '<p>The input format: <code>SequenceFileInputFormat</code> (binary), or <code>TextInputFormat</code>, or a custom format.</p>', 'StorageDescriptor$OutputFormat' => '<p>The output format: <code>SequenceFileOutputFormat</code> (binary), or <code>IgnoreKeyTextOutputFormat</code>, or a custom format.</p>', ], ], 'GenericMap' => [ 'base' => NULL, 'refs' => [ 'Action$Arguments' => NULL, 'CreateJobRequest$DefaultArguments' => '<p>The default parameters for this job.</p>', 'Job$DefaultArguments' => '<p>The default parameters for this job.</p>', 'JobRun$Arguments' => '<p>The job arguments associated with this run.</p>', 'JobUpdate$DefaultArguments' => '<p>The default parameters for this job.</p>', 'StartJobRunRequest$Arguments' => '<p>Specific arguments for this job run.</p>', ], ], 'GenericString' => [ 'base' => NULL, 'refs' => [ 'CreateDevEndpointRequest$EndpointName' => '<p>The name to be assigned to the new DevEndpoint.</p>', 'CreateDevEndpointRequest$SubnetId' => '<p>The subnet ID for the new DevEndpoint to use.</p>', 'CreateDevEndpointRequest$PublicKey' => '<p>The public key to use for authentication.</p>', 'CreateDevEndpointRequest$ExtraPythonLibsS3Path' => '<p>Path to one or more Python libraries in an S3 bucket that should be loaded in your DevEndpoint.</p>', 'CreateDevEndpointRequest$ExtraJarsS3Path' => '<p>Path to one or more Java Jars in an S3 bucket that should be loaded in your DevEndpoint.</p>', 'CreateDevEndpointResponse$EndpointName' => '<p>The name assigned to the new DevEndpoint.</p>', 'CreateDevEndpointResponse$Status' => '<p>The current status of the new DevEndpoint.</p>', 'CreateDevEndpointResponse$SubnetId' => '<p>The subnet ID assigned to the new DevEndpoint.</p>', 'CreateDevEndpointResponse$YarnEndpointAddress' => '<p>The address of the YARN endpoint used by this DevEndpoint.</p>', 'CreateDevEndpointResponse$AvailabilityZone' => '<p>The AWS availability zone where this DevEndpoint is located.</p>', 'CreateDevEndpointResponse$VpcId' => '<p>The ID of the VPC used by this DevEndpoint.</p>', 'CreateDevEndpointResponse$ExtraPythonLibsS3Path' => '<p>Path to one or more Python libraries in an S3 bucket that will be loaded in your DevEndpoint.</p>', 'CreateDevEndpointResponse$ExtraJarsS3Path' => '<p>Path to one or more Java Jars in an S3 bucket that will be loaded in your DevEndpoint.</p>', 'CreateDevEndpointResponse$FailureReason' => '<p>The reason for a current failure in this DevEndpoint.</p>', 'CreateTriggerRequest$Schedule' => '<p>A cron schedule expression for the new trigger.</p>', 'DeleteDevEndpointRequest$EndpointName' => '<p>The name of the DevEndpoint.</p>', 'DevEndpoint$EndpointName' => '<p>The name of the DevEndpoint.</p>', 'DevEndpoint$SubnetId' => '<p>The subnet ID for this DevEndpoint.</p>', 'DevEndpoint$YarnEndpointAddress' => '<p>The YARN endpoint address used by this DevEndpoint.</p>', 'DevEndpoint$PublicAddress' => '<p>The public address used by this DevEndpoint.</p>', 'DevEndpoint$Status' => '<p>The current status of this DevEndpoint.</p>', 'DevEndpoint$AvailabilityZone' => '<p>The AWS availability zone where this DevEndpoint is located.</p>', 'DevEndpoint$VpcId' => '<p>The ID of the virtual private cloud (VPC) used by this DevEndpoint.</p>', 'DevEndpoint$ExtraPythonLibsS3Path' => '<p>Path to one or more Python libraries in an S3 bucket that should be loaded in your DevEndpoint.</p>', 'DevEndpoint$ExtraJarsS3Path' => '<p>Path to one or more Java Jars in an S3 bucket that should be loaded in your DevEndpoint.</p>', 'DevEndpoint$FailureReason' => '<p>The reason for a current failure in this DevEndpoint.</p>', 'DevEndpoint$LastUpdateStatus' => '<p>The status of the last update.</p>', 'DevEndpoint$PublicKey' => '<p>The public key to be used by this DevEndpoint for authentication.</p>', 'DevEndpointCustomLibraries$ExtraPythonLibsS3Path' => '<p>Path to one or more Python libraries in an S3 bucket that should be loaded in your DevEndpoint.</p>', 'DevEndpointCustomLibraries$ExtraJarsS3Path' => '<p>Path to one or more Java Jars in an S3 bucket that should be loaded in your DevEndpoint.</p>', 'GenericMap$key' => NULL, 'GenericMap$value' => NULL, 'GetDevEndpointRequest$EndpointName' => '<p>Name of the DevEndpoint for which to retrieve information.</p>', 'GetDevEndpointsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetDevEndpointsResponse$NextToken' => '<p>A continuation token, if not all DevEndpoint definitions have yet been returned.</p>', 'GetJobRunsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetJobRunsResponse$NextToken' => '<p>A continuation token, if not all reequested job runs have been returned.</p>', 'GetJobsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetJobsResponse$NextToken' => '<p>A continuation token, if not all jobs have yet been returned.</p>', 'GetTriggersRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetTriggersResponse$NextToken' => '<p>A continuation token, if not all the requested triggers have yet been returned.</p>', 'JobCommand$Name' => '<p>The name of this job command.</p>', 'StringList$member' => NULL, 'Trigger$Schedule' => '<p>A cron schedule expression.</p>', 'TriggerUpdate$Schedule' => '<p>A cron expression specifying the schedule.</p>', 'UpdateDevEndpointRequest$EndpointName' => '<p>The name of the DevEndpoint to be updated.</p>', 'UpdateDevEndpointRequest$PublicKey' => '<p>The public key for the DevEndpoint to use.</p>', ], ], 'GetCatalogImportStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCatalogImportStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetClassifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetClassifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetClassifiersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetClassifiersResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionsFilter' => [ 'base' => '<p>Filters the connection definitions returned by the <code>GetConnections</code> API.</p>', 'refs' => [ 'GetConnectionsRequest$Filter' => '<p>A filter that controls which connections will be returned.</p>', ], ], 'GetConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCrawlerMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCrawlerMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCrawlerRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCrawlerResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCrawlersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCrawlersResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDataflowGraphRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataflowGraphResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDevEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDevEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDevEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDevEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetJobRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetJobRunsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobRunsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMappingResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPartitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPartitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPlanRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPlanResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTableVersionsList' => [ 'base' => NULL, 'refs' => [ 'GetTableVersionsResponse$TableVersions' => '<p>A list of strings identifying available versions of the specified table.</p>', ], ], 'GetTableVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTableVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTablesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTriggerRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTriggerResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTriggersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTriggersResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserDefinedFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserDefinedFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserDefinedFunctionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserDefinedFunctionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GrokClassifier' => [ 'base' => '<p>A classifier that uses <code>grok</code>.</p>', 'refs' => [ 'Classifier$GrokClassifier' => '<p>A GrokClassifier object.</p>', ], ], 'GrokPattern' => [ 'base' => NULL, 'refs' => [ 'CreateGrokClassifierRequest$GrokPattern' => '<p>The grok pattern used by this classifier.</p>', 'GrokClassifier$GrokPattern' => '<p>The grok pattern used by this classifier.</p>', 'UpdateGrokClassifierRequest$GrokPattern' => '<p>The grok pattern used by this classifier.</p>', ], ], 'IdString' => [ 'base' => NULL, 'refs' => [ 'GetJobRunRequest$RunId' => '<p>The ID of the job run.</p>', 'JobRun$Id' => '<p>The ID of this job run.</p>', 'JobRun$PreviousRunId' => '<p>The ID of the previous run of this job.</p>', 'Predecessor$RunId' => '<p>The job-run ID of the precessor job run.</p>', 'StartJobRunRequest$JobRunId' => '<p>The ID of the job run to start.</p>', 'StartJobRunResponse$JobRunId' => '<p>The ID assigned to this job run.</p>', 'Trigger$Id' => '<p>The trigger ID.</p>', ], ], 'IdempotentParameterMismatchException' => [ 'base' => '<p>The same unique identifier was associated with two different records.</p>', 'refs' => [], ], 'ImportCatalogToGlueRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportCatalogToGlueResponse' => [ 'base' => NULL, 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'CodeGenNode$LineNumber' => '<p>The line number of the node.</p>', 'StorageDescriptor$NumberOfBuckets' => '<p>Must be specified if the table contains any dimension columns.</p>', ], ], 'IntegerFlag' => [ 'base' => NULL, 'refs' => [ 'Order$SortOrder' => '<p>Indicates that the column is sorted in ascending order (<code>== 1</code>), or in descending order (<code>==0</code>).</p>', ], ], 'IntegerValue' => [ 'base' => NULL, 'refs' => [ 'CreateDevEndpointRequest$NumberOfNodes' => '<p>The number of nodes to use.</p>', 'CreateDevEndpointResponse$NumberOfNodes' => '<p>The number of nodes in this DevEndpoint.</p>', 'CreateJobRequest$AllocatedCapacity' => '<p>The number of capacity units allocated to this job.</p>', 'DevEndpoint$NumberOfNodes' => '<p>The number of nodes used by this DevEndpoint.</p>', 'Job$AllocatedCapacity' => '<p>The number of capacity units allocated to this job.</p>', 'JobBookmarkEntry$Version' => '<p>Version of the job.</p>', 'JobBookmarkEntry$Run' => '<p>The run ID number.</p>', 'JobBookmarkEntry$Attempt' => '<p>The attempt ID number.</p>', 'JobRun$AllocatedCapacity' => '<p>The amount of infrastructure capacity allocated to this job run.</p>', 'JobUpdate$AllocatedCapacity' => '<p>The number of capacity units allocated to this job.</p>', 'StartJobRunRequest$AllocatedCapacity' => '<p>The infrastructure capacity to allocate to this job.</p>', ], ], 'InternalServiceException' => [ 'base' => '<p>An internal service error occurred.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>The input provided was not valid.</p>', 'refs' => [], ], 'JdbcTarget' => [ 'base' => '<p>Specifies a JDBC target for a crawl.</p>', 'refs' => [ 'JdbcTargetList$member' => NULL, ], ], 'JdbcTargetList' => [ 'base' => NULL, 'refs' => [ 'CrawlerTargets$JdbcTargets' => '<p>Specifies JDBC targets.</p>', ], ], 'Job' => [ 'base' => '<p>Specifies a job in the Data Catalog.</p>', 'refs' => [ 'GetJobResponse$Job' => '<p>The requested job definition.</p>', 'JobList$member' => NULL, ], ], 'JobBookmarkEntry' => [ 'base' => '<p>Defines a point which a job can resume processing.</p>', 'refs' => [ 'ResetJobBookmarkResponse$JobBookmarkEntry' => '<p>The reset bookmark entry.</p>', ], ], 'JobCommand' => [ 'base' => '<p>Specifies code that executes a job.</p>', 'refs' => [ 'CreateJobRequest$Command' => '<p>The JobCommand that executes this job.</p>', 'Job$Command' => '<p>The JobCommand that executes this job.</p>', 'JobUpdate$Command' => '<p>The JobCommand that executes this job.</p>', ], ], 'JobList' => [ 'base' => NULL, 'refs' => [ 'GetJobsResponse$Jobs' => '<p>A list of jobs.</p>', ], ], 'JobName' => [ 'base' => NULL, 'refs' => [ 'JobBookmarkEntry$JobName' => '<p>Name of the job in question.</p>', 'ResetJobBookmarkRequest$JobName' => '<p>The name of the job in question.</p>', ], ], 'JobRun' => [ 'base' => '<p>Contains information about a job run.</p>', 'refs' => [ 'GetJobRunResponse$JobRun' => '<p>The requested job-run metadata.</p>', 'JobRunList$member' => NULL, ], ], 'JobRunList' => [ 'base' => NULL, 'refs' => [ 'GetJobRunsResponse$JobRuns' => '<p>A list of job-run metatdata objects.</p>', ], ], 'JobRunState' => [ 'base' => NULL, 'refs' => [ 'Condition$State' => NULL, 'JobRun$JobRunState' => '<p>The current state of the job run.</p>', ], ], 'JobUpdate' => [ 'base' => '<p>Specifies information used to update an existing job.</p>', 'refs' => [ 'UpdateJobRequest$JobUpdate' => '<p>Specifies the values with which to update the job.</p>', ], ], 'JsonValue' => [ 'base' => NULL, 'refs' => [ 'JobBookmarkEntry$JobBookmark' => '<p>The bookmark itself.</p>', ], ], 'KeyString' => [ 'base' => NULL, 'refs' => [ 'ParametersMap$key' => NULL, ], ], 'LastCrawlInfo' => [ 'base' => '<p>Status and error information about the most recent crawl.</p>', 'refs' => [ 'Crawler$LastCrawl' => '<p>The status of the last crawl, and potentially error information if an error occurred.</p>', ], ], 'LastCrawlStatus' => [ 'base' => NULL, 'refs' => [ 'LastCrawlInfo$Status' => '<p>Status of the last crawl.</p>', ], ], 'Location' => [ 'base' => '<p>The location of resources.</p>', 'refs' => [ 'GetMappingRequest$Location' => '<p>Parameters for the mapping.</p>', 'GetPlanRequest$Location' => '<p>Parameters for the mapping.</p>', ], ], 'LocationMap' => [ 'base' => NULL, 'refs' => [ 'SkewedInfo$SkewedColumnValueLocationMaps' => '<p>A mapping of skewed values to the columns that contain them.</p>', ], ], 'LocationString' => [ 'base' => NULL, 'refs' => [ 'StorageDescriptor$Location' => '<p>The physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.</p>', ], ], 'LogGroup' => [ 'base' => NULL, 'refs' => [ 'LastCrawlInfo$LogGroup' => '<p>The log group for the last crawl.</p>', ], ], 'LogStream' => [ 'base' => NULL, 'refs' => [ 'LastCrawlInfo$LogStream' => '<p>The log stream for the last crawl.</p>', ], ], 'Logical' => [ 'base' => NULL, 'refs' => [ 'Predicate$Logical' => '<p>Currently "OR" is not supported.</p>', ], ], 'LogicalOperator' => [ 'base' => NULL, 'refs' => [ 'Condition$LogicalOperator' => NULL, ], ], 'MappingEntry' => [ 'base' => '<p>Defines a mapping.</p>', 'refs' => [ 'MappingList$member' => NULL, ], ], 'MappingList' => [ 'base' => NULL, 'refs' => [ 'GetMappingResponse$Mapping' => '<p>A list of mappings to the specified targets.</p>', 'GetPlanRequest$Mapping' => '<p>The list of mappings from a source table to target tables.</p>', ], ], 'MatchCriteria' => [ 'base' => NULL, 'refs' => [ 'Connection$MatchCriteria' => '<p>A list of criteria that can be used in selecting this connection.</p>', 'ConnectionInput$MatchCriteria' => '<p>A list of criteria that can be used in selecting this connection.</p>', 'GetConnectionsFilter$MatchCriteria' => '<p>A criteria string that must match the criteria recorded in the connection definition for that connection definition to be returned.</p>', ], ], 'MaxConcurrentRuns' => [ 'base' => NULL, 'refs' => [ 'ExecutionProperty$MaxConcurrentRuns' => '<p>The maximum number of concurrent runs allowed for a job.</p>', ], ], 'MaxRetries' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$MaxRetries' => '<p>The maximum number of times to retry this job if it fails.</p>', 'Job$MaxRetries' => '<p>The maximum number of times to retry this job if it fails.</p>', 'JobUpdate$MaxRetries' => '<p>The maximum number of times to retry this job if it fails.</p>', ], ], 'MessagePrefix' => [ 'base' => NULL, 'refs' => [ 'LastCrawlInfo$MessagePrefix' => '<p>The prefix for a message about this crawl.</p>', ], ], 'MessageString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => '<p>A message describing the problem.</p>', 'AlreadyExistsException$Message' => '<p>A message describing the problem.</p>', 'ConcurrentModificationException$Message' => '<p>A message describing the problem.</p>', 'ConcurrentRunsExceededException$Message' => '<p>A message describing the problem.</p>', 'CrawlerNotRunningException$Message' => '<p>A message describing the problem.</p>', 'CrawlerRunningException$Message' => '<p>A message describing the problem.</p>', 'CrawlerStoppingException$Message' => '<p>A message describing the problem.</p>', 'EntityNotFoundException$Message' => '<p>A message describing the problem.</p>', 'IdempotentParameterMismatchException$Message' => '<p>A message describing the problem.</p>', 'InternalServiceException$Message' => '<p>A message describing the problem.</p>', 'InvalidInputException$Message' => '<p>A message describing the problem.</p>', 'NoScheduleException$Message' => '<p>A message describing the problem.</p>', 'OperationTimeoutException$Message' => '<p>A message describing the problem.</p>', 'ResourceNumberLimitExceededException$Message' => '<p>A message describing the problem.</p>', 'SchedulerNotRunningException$Message' => '<p>A message describing the problem.</p>', 'SchedulerRunningException$Message' => '<p>A message describing the problem.</p>', 'SchedulerTransitioningException$Message' => '<p>A message describing the problem.</p>', 'ValidationException$Message' => '<p>A message describing the problem.</p>', 'VersionMismatchException$Message' => '<p>A message describing the problem.</p>', ], ], 'MillisecondsCount' => [ 'base' => NULL, 'refs' => [ 'Crawler$CrawlElapsedTime' => '<p>If this Crawler is running, contains the total time elapsed since the last crawl began.</p>', ], ], 'NameString' => [ 'base' => NULL, 'refs' => [ 'Action$JobName' => NULL, 'BatchCreatePartitionRequest$DatabaseName' => '<p>The name of the metadata database in which the partition is to be created.</p>', 'BatchCreatePartitionRequest$TableName' => '<p>The name of the metadata table in which the partition is to be created.</p>', 'BatchDeletePartitionRequest$DatabaseName' => '<p>The name of the catalog database in which the table in question resides.</p>', 'BatchDeletePartitionRequest$TableName' => '<p>The name of the table where the partitions to be deleted is located.</p>', 'BatchDeleteTableNameList$member' => NULL, 'BatchDeleteTableRequest$DatabaseName' => '<p>The name of the catalog database where the tables to delete reside.</p>', 'BatchGetPartitionRequest$DatabaseName' => '<p>The name of the catalog database where the partitions reside.</p>', 'BatchGetPartitionRequest$TableName' => '<p>The name of the partitions\' table.</p>', 'CatalogEntry$DatabaseName' => '<p>The database in which the table metadata resides.</p>', 'CatalogEntry$TableName' => '<p>The name of the table in question.</p>', 'CatalogImportStatus$ImportedBy' => '<p>The name of the person who initiated the migration.</p>', 'ClassifierNameList$member' => NULL, 'Column$Name' => '<p>The name of the <code>Column</code>.</p>', 'Condition$JobName' => NULL, 'Connection$Name' => '<p>The name of the connection definition.</p>', 'Connection$LastUpdatedBy' => '<p>The user, group or role that last updated this connection definition.</p>', 'ConnectionInput$Name' => '<p>The name of the connection.</p>', 'Crawler$Name' => '<p>The <code>Crawler</code> name.</p>', 'CrawlerMetrics$CrawlerName' => '<p>The name of the crawler.</p>', 'CrawlerNameList$member' => NULL, 'CreateCrawlerRequest$Name' => '<p>Name of the new <code>Crawler</code>.</p>', 'CreateGrokClassifierRequest$Name' => '<p>The name of the new Classifier.</p>', 'CreateJobRequest$Name' => '<p>The name you assign to this job.</p>', 'CreateJobResponse$Name' => '<p>The unique name of the new job that has been created.</p>', 'CreatePartitionRequest$DatabaseName' => '<p>The name of the metadata database in which the partition is to be created.</p>', 'CreatePartitionRequest$TableName' => '<p>The name of the metadata table in which the partition is to be created.</p>', 'CreateTableRequest$DatabaseName' => '<p>The catalog database in which to create the new table.</p>', 'CreateTriggerRequest$Name' => '<p>The name to assign to the new trigger.</p>', 'CreateTriggerResponse$Name' => '<p>The name assigned to the new trigger.</p>', 'CreateUserDefinedFunctionRequest$DatabaseName' => '<p>The name of the catalog database in which to create the function.</p>', 'Database$Name' => '<p>Name of the database.</p>', 'DatabaseInput$Name' => '<p>Name of the database.</p>', 'DeleteClassifierRequest$Name' => '<p>Name of the <code>Classifier</code> to remove.</p>', 'DeleteConnectionNameList$member' => NULL, 'DeleteConnectionRequest$ConnectionName' => '<p>The name of the connection to delete.</p>', 'DeleteCrawlerRequest$Name' => '<p>Name of the <code>Crawler</code> to remove.</p>', 'DeleteDatabaseRequest$Name' => '<p>The name of the Database to delete.</p>', 'DeleteJobRequest$JobName' => '<p>The name of the job to delete.</p>', 'DeleteJobResponse$JobName' => '<p>The name of the job that was deleted.</p>', 'DeletePartitionRequest$DatabaseName' => '<p>The name of the catalog database in which the table in question resides.</p>', 'DeletePartitionRequest$TableName' => '<p>The name of the table where the partition to be deleted is located.</p>', 'DeleteTableRequest$DatabaseName' => '<p>The name of the catalog database in which the table resides.</p>', 'DeleteTableRequest$Name' => '<p>The name of the table to be deleted.</p>', 'DeleteTriggerRequest$Name' => '<p>The name of the trigger to delete.</p>', 'DeleteTriggerResponse$Name' => '<p>The name of the trigger that was deleted.</p>', 'DeleteUserDefinedFunctionRequest$DatabaseName' => '<p>The name of the catalog database where the function is located.</p>', 'DeleteUserDefinedFunctionRequest$FunctionName' => '<p>The name of the function definition to be deleted.</p>', 'ErrorByName$key' => NULL, 'ErrorDetail$ErrorCode' => '<p>The code associated with this error.</p>', 'GetClassifierRequest$Name' => '<p>Name of the <code>Classifier</code> to retrieve.</p>', 'GetConnectionRequest$Name' => '<p>The name of the connection definition to retrieve.</p>', 'GetCrawlerRequest$Name' => '<p>Name of the <code>Crawler</code> to retrieve metadata for.</p>', 'GetDatabaseRequest$Name' => '<p>The name of the database to retrieve.</p>', 'GetJobRequest$JobName' => '<p>The name of the job to retrieve.</p>', 'GetJobRunRequest$JobName' => '<p>Name of the job being run.</p>', 'GetJobRunsRequest$JobName' => '<p>The name of the job for which to retrieve all job runs.</p>', 'GetPartitionRequest$DatabaseName' => '<p>The name of the catalog database where the partition resides.</p>', 'GetPartitionRequest$TableName' => '<p>The name of the partition\'s table.</p>', 'GetPartitionsRequest$DatabaseName' => '<p>The name of the catalog database where the partitions reside.</p>', 'GetPartitionsRequest$TableName' => '<p>The name of the partitions\' table.</p>', 'GetTableRequest$DatabaseName' => '<p>The name of the database in the catalog in which the table resides.</p>', 'GetTableRequest$Name' => '<p>The name of the table for which to retrieve the definition.</p>', 'GetTableVersionsRequest$DatabaseName' => '<p>The database in the catalog in which the table resides.</p>', 'GetTableVersionsRequest$TableName' => '<p>The name of the table.</p>', 'GetTablesRequest$DatabaseName' => '<p>The database in the catalog whose tables to list.</p>', 'GetTriggerRequest$Name' => '<p>The name of the trigger to retrieve.</p>', 'GetTriggersRequest$DependentJobName' => '<p>The name of the job for which to retrieve triggers.</p>', 'GetUserDefinedFunctionRequest$DatabaseName' => '<p>The name of the catalog database where the function is located.</p>', 'GetUserDefinedFunctionRequest$FunctionName' => '<p>The name of the function.</p>', 'GetUserDefinedFunctionsRequest$DatabaseName' => '<p>The name of the catalog database where the functions are located.</p>', 'GetUserDefinedFunctionsRequest$Pattern' => '<p>An optional function-name pattern string that filters the function definitions returned.</p>', 'GrokClassifier$Name' => '<p>The name of the classifier.</p>', 'Job$Name' => '<p>The name you assign to this job.</p>', 'JobRun$TriggerName' => '<p>The name of the trigger for this job run.</p>', 'JobRun$JobName' => '<p>The name of the job being run.</p>', 'MatchCriteria$member' => NULL, 'NameStringList$member' => NULL, 'Order$Column' => '<p>The name of the column.</p>', 'Partition$DatabaseName' => '<p>The name of the catalog database where the table in question is located.</p>', 'Partition$TableName' => '<p>The name of the table in question.</p>', 'PhysicalConnectionRequirements$SubnetId' => '<p>The subnet ID used by the connection.</p>', 'PhysicalConnectionRequirements$AvailabilityZone' => '<p>The connection\'s availability zone.</p>', 'Predecessor$JobName' => '<p>The name of the predecessor job.</p>', 'SecurityGroupIdList$member' => NULL, 'SerDeInfo$Name' => '<p>Name of the SerDe.</p>', 'SerDeInfo$SerializationLibrary' => '<p>Usually the class that implements the SerDe. An example is: <code>org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe</code>.</p>', 'StartCrawlerRequest$Name' => '<p>Name of the <code>Crawler</code> to start.</p>', 'StartCrawlerScheduleRequest$CrawlerName' => '<p>Name of the crawler to schedule.</p>', 'StartJobRunRequest$JobName' => '<p>The name of the job to start.</p>', 'StartTriggerRequest$Name' => '<p>The name of the trigger to start.</p>', 'StartTriggerResponse$Name' => '<p>The name of the trigger that was started.</p>', 'StopCrawlerRequest$Name' => '<p>Name of the <code>Crawler</code> to stop.</p>', 'StopCrawlerScheduleRequest$CrawlerName' => '<p>Name of the crawler whose schedule state to set.</p>', 'StopTriggerRequest$Name' => '<p>The name of the trigger to stop.</p>', 'StopTriggerResponse$Name' => '<p>The name of the trigger that was stopped.</p>', 'Table$Name' => '<p>Name of the table.</p>', 'Table$DatabaseName' => '<p>Name of the metadata database where the table metadata resides.</p>', 'Table$Owner' => '<p>Owner of the table.</p>', 'Table$CreatedBy' => '<p>Person or entity who created the table.</p>', 'TableError$TableName' => '<p>Name of the table.</p>', 'TableInput$Name' => '<p>Name of the table.</p>', 'TableInput$Owner' => '<p>Owner of the table.</p>', 'Trigger$Name' => '<p>Name of the trigger.</p>', 'TriggerUpdate$Name' => '<p>The name of the trigger.</p>', 'UpdateConnectionRequest$Name' => '<p>The name of the connection definition to update.</p>', 'UpdateCrawlerRequest$Name' => '<p>Name of the new <code>Crawler</code>.</p>', 'UpdateCrawlerScheduleRequest$CrawlerName' => '<p>Name of the crawler whose schedule to update.</p>', 'UpdateDatabaseRequest$Name' => '<p>The name of the metadata database to update in the catalog.</p>', 'UpdateGrokClassifierRequest$Name' => '<p>The name of the <code>GrokClassifier</code>.</p>', 'UpdateJobRequest$JobName' => '<p>Name of the job definition to update.</p>', 'UpdateJobResponse$JobName' => '<p>Returns the name of the updated job.</p>', 'UpdatePartitionRequest$DatabaseName' => '<p>The name of the catalog database in which the table in question resides.</p>', 'UpdatePartitionRequest$TableName' => '<p>The name of the table where the partition to be updated is located.</p>', 'UpdateTableRequest$DatabaseName' => '<p>The name of the catalog database in which the table resides.</p>', 'UpdateTriggerRequest$Name' => '<p>The name of the trigger to update.</p>', 'UpdateUserDefinedFunctionRequest$DatabaseName' => '<p>The name of the catalog database where the function to be updated is located.</p>', 'UpdateUserDefinedFunctionRequest$FunctionName' => '<p>The name of the function.</p>', 'UserDefinedFunction$FunctionName' => '<p>The name of the function.</p>', 'UserDefinedFunction$ClassName' => '<p>The Java class that contains the function code.</p>', 'UserDefinedFunction$OwnerName' => '<p>The owner of the function.</p>', 'UserDefinedFunctionInput$FunctionName' => '<p>The name of the function.</p>', 'UserDefinedFunctionInput$ClassName' => '<p>The Java class that contains the function code.</p>', 'UserDefinedFunctionInput$OwnerName' => '<p>The owner of the function.</p>', ], ], 'NameStringList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteConnectionResponse$Succeeded' => '<p>A list of names of the connection definitions that were successfully deleted.</p>', 'SkewedInfo$SkewedColumnNames' => '<p>A list of names of columns that contain skewed values.</p>', 'StorageDescriptor$BucketColumns' => '<p>A list of reducer grouping columns, clustering columns, and bucketing columns in the table.</p>', ], ], 'NoScheduleException' => [ 'base' => '<p>There is no applicable schedule.</p>', 'refs' => [], ], 'NonNegativeDouble' => [ 'base' => NULL, 'refs' => [ 'CrawlerMetrics$TimeLeftSeconds' => '<p>The estimated time left to complete a running crawl.</p>', 'CrawlerMetrics$LastRuntimeSeconds' => '<p>The duration of the crawler\'s most recent run, in seconds.</p>', 'CrawlerMetrics$MedianRuntimeSeconds' => '<p>The median duration of this crawler\'s runs, in seconds.</p>', ], ], 'NonNegativeInteger' => [ 'base' => NULL, 'refs' => [ 'CrawlerMetrics$TablesCreated' => '<p>A list of the tables created by this crawler.</p>', 'CrawlerMetrics$TablesUpdated' => '<p>A list of the tables created by this crawler.</p>', 'CrawlerMetrics$TablesDeleted' => '<p>A list of the tables deleted by this crawler.</p>', 'Segment$SegmentNumber' => '<p>The zero-based index number of the this segment. For example, if the total number of segments is 4, SegmentNumber values will range from zero through three.</p>', 'Table$Retention' => '<p>Retention time for this table.</p>', 'TableInput$Retention' => '<p>Retention time for this table.</p>', ], ], 'OperationTimeoutException' => [ 'base' => '<p>The operation timed out.</p>', 'refs' => [], ], 'Order' => [ 'base' => '<p>Specifies the sort order of a sorted column.</p>', 'refs' => [ 'OrderList$member' => NULL, ], ], 'OrderList' => [ 'base' => NULL, 'refs' => [ 'StorageDescriptor$SortColumns' => '<p>A list specifying the sort order of each bucket in the table.</p>', ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'GetClassifiersRequest$MaxResults' => '<p>Size of the list to return (optional).</p>', 'GetConnectionsRequest$MaxResults' => '<p>The maximum number of connections to return in one response.</p>', 'GetCrawlerMetricsRequest$MaxResults' => '<p>The maximum size of a list to return.</p>', 'GetCrawlersRequest$MaxResults' => '<p>The number of Crawlers to return on each call.</p>', 'GetDatabasesRequest$MaxResults' => '<p>The maximum number of databases to return in one response.</p>', 'GetDevEndpointsRequest$MaxResults' => '<p>The maximum size of information to return.</p>', 'GetJobRunsRequest$MaxResults' => '<p>The maximum size of the response.</p>', 'GetJobsRequest$MaxResults' => '<p>The maximum size of the response.</p>', 'GetPartitionsRequest$MaxResults' => '<p>The maximum number of partitions to return in a single response.</p>', 'GetTableVersionsRequest$MaxResults' => '<p>The maximum number of table versions to return in one response.</p>', 'GetTablesRequest$MaxResults' => '<p>The maximum number of tables to return in a single response.</p>', 'GetTriggersRequest$MaxResults' => '<p>The maximum size of the response.</p>', 'GetUserDefinedFunctionsRequest$MaxResults' => '<p>The maximum number of functions to return in one response.</p>', ], ], 'ParametersMap' => [ 'base' => NULL, 'refs' => [ 'Database$Parameters' => '<p>A list of key-value pairs that define parameters and properties of the database.</p>', 'DatabaseInput$Parameters' => '<p>A list of key-value pairs that define parameters and properties of the database.</p>', 'Partition$Parameters' => '<p>Partition parameters, in the form of a list of key-value pairs.</p>', 'PartitionInput$Parameters' => '<p>Partition parameters, in the form of a list of key-value pairs.</p>', 'SerDeInfo$Parameters' => '<p>A list of initialization parameters for the SerDe, in key-value form.</p>', 'StorageDescriptor$Parameters' => '<p>User-supplied properties in key-value form.</p>', 'Table$Parameters' => '<p>Properties associated with this table, as a list of key-value pairs.</p>', 'TableInput$Parameters' => '<p>Properties associated with this table, as a list of key-value pairs.</p>', ], ], 'ParametersMapValue' => [ 'base' => NULL, 'refs' => [ 'ParametersMap$value' => NULL, ], ], 'Partition' => [ 'base' => '<p>Represents a slice of table data.</p>', 'refs' => [ 'GetPartitionResponse$Partition' => '<p>The requested information, in the form of a <code>Partition</code> object.</p>', 'PartitionList$member' => NULL, ], ], 'PartitionError' => [ 'base' => '<p>Contains information about a partition error.</p>', 'refs' => [ 'PartitionErrors$member' => NULL, ], ], 'PartitionErrors' => [ 'base' => NULL, 'refs' => [ 'BatchCreatePartitionResponse$Errors' => '<p>Errors encountered when trying to create the requested partitions.</p>', 'BatchDeletePartitionResponse$Errors' => '<p>Errors encountered when trying to delete the requested partitions.</p>', ], ], 'PartitionInput' => [ 'base' => '<p>The structure used to create and update a partion.</p>', 'refs' => [ 'CreatePartitionRequest$PartitionInput' => '<p>A <code>PartitionInput</code> structure defining the partition to be created.</p>', 'PartitionInputList$member' => NULL, 'UpdatePartitionRequest$PartitionInput' => '<p>The new partition object to which to update the partition.</p>', ], ], 'PartitionInputList' => [ 'base' => NULL, 'refs' => [ 'BatchCreatePartitionRequest$PartitionInputList' => '<p>A list of <code>PartitionInput</code> structures that define the partitions to be created.</p>', ], ], 'PartitionList' => [ 'base' => NULL, 'refs' => [ 'BatchGetPartitionResponse$Partitions' => '<p>A list of the requested partitions.</p>', 'GetPartitionsResponse$Partitions' => '<p>A list of requested partitions.</p>', ], ], 'PartitionValueList' => [ 'base' => NULL, 'refs' => [ 'BatchDeletePartitionValueList$member' => NULL, 'BatchGetPartitionValueList$member' => NULL, ], ], 'Path' => [ 'base' => NULL, 'refs' => [ 'JdbcTarget$Path' => '<p>The path of the JDBC target.</p>', 'PathList$member' => NULL, 'S3Target$Path' => '<p>The path to the S3 target.</p>', ], ], 'PathList' => [ 'base' => NULL, 'refs' => [ 'JdbcTarget$Exclusions' => '<p>A list of items to exclude from the crawl.</p>', 'S3Target$Exclusions' => '<p>A list of S3 objects to exclude from the crawl.</p>', ], ], 'PhysicalConnectionRequirements' => [ 'base' => '<p>Specifies the physical requirements for a connection.</p>', 'refs' => [ 'Connection$PhysicalConnectionRequirements' => '<p>A map of physical connection requirements, such as VPC and SecurityGroup, needed for making this connection successfully.</p>', 'ConnectionInput$PhysicalConnectionRequirements' => '<p>A map of physical connection requirements, such as VPC and SecurityGroup, needed for making this connection successfully.</p>', ], ], 'Predecessor' => [ 'base' => '<p>A job run that preceded this one.</p>', 'refs' => [ 'PredecessorList$member' => NULL, ], ], 'PredecessorList' => [ 'base' => NULL, 'refs' => [ 'JobRun$PredecessorRuns' => '<p>A list of predecessors to this job run.</p>', ], ], 'Predicate' => [ 'base' => '<p>Defines the predicate of the trigger, which determines when it fires.</p>', 'refs' => [ 'CreateTriggerRequest$Predicate' => '<p>A predicate to specify when the new trigger should fire.</p>', 'Trigger$Predicate' => '<p>The predicate of this trigger.</p>', 'TriggerUpdate$Predicate' => '<p>The predicate of this trigger, which defines when it will fire.</p>', ], ], 'PredicateString' => [ 'base' => NULL, 'refs' => [ 'GetPartitionsRequest$Expression' => '<p>An expression filtering the partitions to be returned.</p>', ], ], 'PrincipalType' => [ 'base' => NULL, 'refs' => [ 'UserDefinedFunction$OwnerType' => '<p>The owner type.</p>', 'UserDefinedFunctionInput$OwnerType' => '<p>The owner type.</p>', ], ], 'PythonScript' => [ 'base' => NULL, 'refs' => [ 'CreateScriptResponse$PythonScript' => '<p>The Python script generated from the DAG.</p>', 'GetDataflowGraphRequest$PythonScript' => '<p>The Python script to transform.</p>', 'GetPlanResponse$PythonScript' => '<p>A python script to perform the mapping.</p>', ], ], 'ResetJobBookmarkRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetJobBookmarkResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceNumberLimitExceededException' => [ 'base' => '<p>A resource numerical limit was exceeded.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceUri$ResourceType' => '<p>The type of the resource.</p>', ], ], 'ResourceUri' => [ 'base' => '<p>URIs for function resources.</p>', 'refs' => [ 'ResourceUriList$member' => NULL, ], ], 'ResourceUriList' => [ 'base' => NULL, 'refs' => [ 'UserDefinedFunction$ResourceUris' => '<p>The resource URIs for the function.</p>', 'UserDefinedFunctionInput$ResourceUris' => '<p>The resource URIs for the function.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'Crawler$Role' => '<p>The ARN of an IAM role used to access customer resources such as data in S3.</p>', 'CreateCrawlerRequest$Role' => '<p>The AWS ARN of the IAM role used by the new <code>Crawler</code> to access customer resources.</p>', 'CreateDevEndpointRequest$RoleArn' => '<p>The IAM role for the DevEndpoint.</p>', 'CreateDevEndpointResponse$RoleArn' => '<p>The AWS ARN of the role assigned to the new DevEndpoint.</p>', 'DevEndpoint$RoleArn' => '<p>The AWS ARN of the IAM role used in this DevEndpoint.</p>', 'UpdateCrawlerRequest$Role' => '<p>The AWS ARN of the IAM role used by the new <code>Crawler</code> to access customer resources.</p>', ], ], 'RoleString' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$Role' => '<p>The role associated with this job.</p>', 'Job$Role' => '<p>The role associated with this job.</p>', 'JobUpdate$Role' => '<p>The role associated with this job.</p>', ], ], 'S3Target' => [ 'base' => '<p>Specifies a crawler target in AWS S3.</p>', 'refs' => [ 'S3TargetList$member' => NULL, ], ], 'S3TargetList' => [ 'base' => NULL, 'refs' => [ 'CrawlerTargets$S3Targets' => '<p>Specifies targets in AWS S3.</p>', ], ], 'Schedule' => [ 'base' => '<p>A scheduling object using a <code>cron</code> statement to schedule an event.</p>', 'refs' => [ 'Crawler$Schedule' => '<p>A <code>Schedule</code> object that specifies the schedule on which this Crawler is to be run.</p>', ], ], 'ScheduleState' => [ 'base' => NULL, 'refs' => [ 'Schedule$State' => '<p>The state of the schedule.</p>', ], ], 'SchedulerNotRunningException' => [ 'base' => '<p>The specified scheduler is not running.</p>', 'refs' => [], ], 'SchedulerRunningException' => [ 'base' => '<p>The specified scheduler is already running.</p>', 'refs' => [], ], 'SchedulerTransitioningException' => [ 'base' => '<p>The specified scheduler is transitioning.</p>', 'refs' => [], ], 'SchemaChangePolicy' => [ 'base' => '<p>Crawler policy for update and deletion behavior.</p>', 'refs' => [ 'Crawler$SchemaChangePolicy' => '<p>Sets policy for the crawler\'s update and delete behavior.</p>', 'CreateCrawlerRequest$SchemaChangePolicy' => '<p>Policy for the crawler\'s update and deletion behavior.</p>', 'UpdateCrawlerRequest$SchemaChangePolicy' => '<p>Policy for the crawler\'s update and deletion behavior.</p>', ], ], 'SchemaPathString' => [ 'base' => NULL, 'refs' => [ 'MappingEntry$SourcePath' => '<p>The source path.</p>', 'MappingEntry$TargetPath' => '<p>The target path.</p>', ], ], 'ScriptLocationString' => [ 'base' => NULL, 'refs' => [ 'JobCommand$ScriptLocation' => '<p>Specifies the location of a script that executes a job.</p>', ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'PhysicalConnectionRequirements$SecurityGroupIdList' => '<p>The security group ID list used by the connection.</p>', ], ], 'Segment' => [ 'base' => '<p>Defines a non-overlapping region of a table\'s partitions, allowing multiple requests to be executed in parallel.</p>', 'refs' => [ 'GetPartitionsRequest$Segment' => '<p>The segment of the table\'s partitions to scan in this request.</p>', ], ], 'SerDeInfo' => [ 'base' => '<p>Information about a serialization/deserialization program (SerDe) which serves as an extractor and loader.</p>', 'refs' => [ 'StorageDescriptor$SerdeInfo' => '<p>Serialization/deserialization (SerDe) information.</p>', ], ], 'SkewedInfo' => [ 'base' => '<p>Specifies skewed values in a table. Skewed are ones that occur with very high frequency.</p>', 'refs' => [ 'StorageDescriptor$SkewedInfo' => '<p>Information about values that appear very frequently in a column (skewed values).</p>', ], ], 'StartCrawlerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCrawlerResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartCrawlerScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCrawlerScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartJobRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartJobRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTriggerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTriggerResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopCrawlerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopCrawlerResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopCrawlerScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopCrawlerScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopTriggerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopTriggerResponse' => [ 'base' => NULL, 'refs' => [], ], 'StorageDescriptor' => [ 'base' => '<p>Describes the physical storage of table data.</p>', 'refs' => [ 'Partition$StorageDescriptor' => '<p>Provides information about the physical location where the partition is stored.</p>', 'PartitionInput$StorageDescriptor' => '<p>Provides information about the physical location where the partition is stored.</p>', 'Table$StorageDescriptor' => '<p>A storage descriptor containing information about the physical storage of this table.</p>', 'TableInput$StorageDescriptor' => '<p>A storage descriptor containing information about the physical storage of this table.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'ConnectionsList$Connections' => '<p>A list of connections used by the job.</p>', 'CreateDevEndpointRequest$SecurityGroupIds' => '<p>Security group IDs for the security groups to be used by the new DevEndpoint.</p>', 'CreateDevEndpointResponse$SecurityGroupIds' => '<p>The security groups assigned to the new DevEndpoint.</p>', 'DevEndpoint$SecurityGroupIds' => '<p>A list of security group identifiers used in this DevEndpoint.</p>', ], ], 'Table' => [ 'base' => '<p>Represents a collection of related data organized in columns and rows.</p>', 'refs' => [ 'GetTableResponse$Table' => '<p>The <code>Table</code> object that defines the specified table.</p>', 'TableList$member' => NULL, 'TableVersion$Table' => NULL, ], ], 'TableError' => [ 'base' => '<p>An error record for table operations.</p>', 'refs' => [ 'TableErrors$member' => NULL, ], ], 'TableErrors' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteTableResponse$Errors' => '<p>A list of errors encountered in attempting to delete the specified tables.</p>', ], ], 'TableInput' => [ 'base' => '<p>Structure used to create or update the table.</p>', 'refs' => [ 'CreateTableRequest$TableInput' => '<p>The <code>TableInput</code> object that defines the metadata table to create in the catalog.</p>', 'UpdateTableRequest$TableInput' => '<p>An updated <code>TableInput</code> object to define the metadata table in the catalog.</p>', ], ], 'TableList' => [ 'base' => NULL, 'refs' => [ 'GetTablesResponse$TableList' => '<p>A list of the requested <code>Table</code> objects.</p>', ], ], 'TableName' => [ 'base' => NULL, 'refs' => [ 'MappingEntry$SourceTable' => '<p>The name of the source table.</p>', 'MappingEntry$TargetTable' => '<p>The target table.</p>', ], ], 'TablePrefix' => [ 'base' => NULL, 'refs' => [ 'Crawler$TablePrefix' => '<p>The table prefix used for catalog tables created.</p>', 'CreateCrawlerRequest$TablePrefix' => '<p>The table prefix used for catalog tables created.</p>', 'UpdateCrawlerRequest$TablePrefix' => '<p>The table prefix used for catalog tables created.</p>', ], ], 'TableTypeString' => [ 'base' => NULL, 'refs' => [ 'Table$TableType' => '<p>The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).</p>', 'TableInput$TableType' => '<p>The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).</p>', ], ], 'TableVersion' => [ 'base' => NULL, 'refs' => [ 'GetTableVersionsList$member' => NULL, ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CatalogImportStatus$ImportTime' => '<p>The time that the migration was started.</p>', 'Connection$CreationTime' => '<p>The time this connection definition was created.</p>', 'Connection$LastUpdatedTime' => '<p>The last time this connection definition was updated.</p>', 'Crawler$CreationTime' => '<p>The time when the Crawler was created.</p>', 'Crawler$LastUpdated' => '<p>The time the Crawler was last updated.</p>', 'Database$CreateTime' => '<p>The time at which the metadata database was created in the catalog.</p>', 'GrokClassifier$CreationTime' => '<p>The time this classifier was registered.</p>', 'GrokClassifier$LastUpdated' => '<p>The time this classifier was last updated.</p>', 'LastCrawlInfo$StartTime' => '<p>The time at which the crawl started.</p>', 'Partition$CreationTime' => '<p>The time at which the partition was created.</p>', 'Partition$LastAccessTime' => '<p>The last time at which the partition was accessed.</p>', 'Partition$LastAnalyzedTime' => '<p>The last time at which column statistics were computed for this partition.</p>', 'PartitionInput$LastAccessTime' => '<p>The last time at which the partition was accessed.</p>', 'PartitionInput$LastAnalyzedTime' => '<p>The last time at which column statistics were computed for this partition.</p>', 'Table$CreateTime' => '<p>Time when the table definition was created in the Data Catalog.</p>', 'Table$UpdateTime' => '<p>Last time the table was updated.</p>', 'Table$LastAccessTime' => '<p>Last time the table was accessed. This is usually taken from HDFS, and may not be reliable.</p>', 'Table$LastAnalyzedTime' => '<p>Last time column statistics were computed for this table.</p>', 'TableInput$LastAccessTime' => '<p>Last time the table was accessed.</p>', 'TableInput$LastAnalyzedTime' => '<p>Last time column statistics were computed for this table.</p>', 'UserDefinedFunction$CreateTime' => '<p>The time at which the function was created.</p>', ], ], 'TimestampValue' => [ 'base' => NULL, 'refs' => [ 'CreateDevEndpointResponse$CreatedTimestamp' => '<p>The point in time at which this DevEndpoint was created.</p>', 'DevEndpoint$CreatedTimestamp' => '<p>The point in time at which this DevEndpoint was created.</p>', 'DevEndpoint$LastModifiedTimestamp' => '<p>The point in time at which this DevEndpoint was last modified.</p>', 'Job$CreatedOn' => '<p>The time and date that this job specification was created.</p>', 'Job$LastModifiedOn' => '<p>The last point in time when this job specification was modified.</p>', 'JobRun$StartedOn' => '<p>The date and time at which this job run was started.</p>', 'JobRun$LastModifiedOn' => '<p>The last time this job run was modified.</p>', 'JobRun$CompletedOn' => '<p>The date and time this job run completed.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'GetClassifiersRequest$NextToken' => '<p>An optional continuation token.</p>', 'GetClassifiersResponse$NextToken' => '<p>A continuation token.</p>', 'GetConnectionsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetConnectionsResponse$NextToken' => '<p>A continuation token, if the list of connections returned does not include the last of the filtered connections.</p>', 'GetCrawlerMetricsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetCrawlerMetricsResponse$NextToken' => '<p>A continuation token, if the returned list does not contain the last metric available.</p>', 'GetCrawlersRequest$NextToken' => '<p>A continuation token, if this is a continuation request.</p>', 'GetCrawlersResponse$NextToken' => '<p>A continuation token, if the returned list has not reached the end of those defined in this customer account.</p>', 'GetDatabasesRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetDatabasesResponse$NextToken' => '<p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>', 'GetPartitionsRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve these partitions.</p>', 'GetPartitionsResponse$NextToken' => '<p>A continuation token, if the returned list of partitions does not does not include the last one.</p>', 'GetTableVersionsRequest$NextToken' => '<p>A continuation token, if this is not the first call.</p>', 'GetTableVersionsResponse$NextToken' => '<p>A continuation token, if the list of available versions does not include the last one.</p>', 'GetTablesRequest$NextToken' => '<p>A continuation token, included if this is a continuation call.</p>', 'GetTablesResponse$NextToken' => '<p>A continuation token, present if the current list segment is not the last.</p>', 'GetUserDefinedFunctionsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetUserDefinedFunctionsResponse$NextToken' => '<p>A continuation token, if the list of functions returned does not include the last requested function.</p>', ], ], 'TotalSegmentsInteger' => [ 'base' => NULL, 'refs' => [ 'Segment$TotalSegments' => '<p>The total numer of segments.</p>', ], ], 'Trigger' => [ 'base' => '<p>Information about a specific trigger.</p>', 'refs' => [ 'GetTriggerResponse$Trigger' => '<p>The requested trigger definition.</p>', 'TriggerList$member' => NULL, 'UpdateTriggerResponse$Trigger' => '<p>The resulting trigger definition.</p>', ], ], 'TriggerList' => [ 'base' => NULL, 'refs' => [ 'GetTriggersResponse$Triggers' => '<p>A list of triggers for the specified job.</p>', ], ], 'TriggerState' => [ 'base' => NULL, 'refs' => [ 'Trigger$State' => '<p>The current state of the trigger.</p>', ], ], 'TriggerType' => [ 'base' => NULL, 'refs' => [ 'CreateTriggerRequest$Type' => '<p>The type of the new trigger.</p>', 'Trigger$Type' => '<p>The type of trigger that this is.</p>', ], ], 'TriggerUpdate' => [ 'base' => '<p>A structure used to provide information used to updata a trigger.</p>', 'refs' => [ 'UpdateTriggerRequest$TriggerUpdate' => '<p>The new values with which to update the trigger.</p>', ], ], 'URI' => [ 'base' => NULL, 'refs' => [ 'Database$LocationUri' => '<p>The location of the database (for example, an HDFS path).</p>', 'DatabaseInput$LocationUri' => '<p>The location of the database (for example, an HDFS path).</p>', 'ResourceUri$Uri' => '<p>The URI for accessing the resource.</p>', ], ], 'UpdateBehavior' => [ 'base' => NULL, 'refs' => [ 'SchemaChangePolicy$UpdateBehavior' => '<p>The update behavior.</p>', ], ], 'UpdateClassifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClassifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCrawlerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCrawlerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCrawlerScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCrawlerScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDevEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDevEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGrokClassifierRequest' => [ 'base' => '<p>Specifies a Grok classifier to update when passed to UpdateClassifier.</p>', 'refs' => [ 'UpdateClassifierRequest$GrokClassifier' => '<p>A <code>GrokClassifier</code> object with updated fields.</p>', ], ], 'UpdateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTriggerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTriggerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserDefinedFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserDefinedFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UriString' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$LogUri' => '<p>Location of the logs for this job.</p>', 'Job$LogUri' => '<p>Location of the logs for this job.</p>', 'JobUpdate$LogUri' => '<p>Location of the logs for this job.</p>', ], ], 'UserDefinedFunction' => [ 'base' => '<p>Represents the equivalent of a Hive user-defined function (<code>UDF</code>) definition.</p>', 'refs' => [ 'GetUserDefinedFunctionResponse$UserDefinedFunction' => '<p>The requested function definition.</p>', 'UserDefinedFunctionList$member' => NULL, ], ], 'UserDefinedFunctionInput' => [ 'base' => '<p>A structure used to create or updata a user-defined function.</p>', 'refs' => [ 'CreateUserDefinedFunctionRequest$FunctionInput' => '<p>A <code>FunctionInput</code> object that defines the function to create in the Data Catalog.</p>', 'UpdateUserDefinedFunctionRequest$FunctionInput' => '<p>A <code>FunctionInput</code> object that re-defines the function in the Data Catalog.</p>', ], ], 'UserDefinedFunctionList' => [ 'base' => NULL, 'refs' => [ 'GetUserDefinedFunctionsResponse$UserDefinedFunctions' => '<p>A list of requested function definitions.</p>', ], ], 'ValidationException' => [ 'base' => '<p>A value could not be validated.</p>', 'refs' => [], ], 'ValueString' => [ 'base' => NULL, 'refs' => [ 'BoundedPartitionValueList$member' => NULL, 'ConnectionProperties$value' => NULL, 'ValueStringList$member' => NULL, ], ], 'ValueStringList' => [ 'base' => NULL, 'refs' => [ 'DeletePartitionRequest$PartitionValues' => '<p>The values that define the partition.</p>', 'GetPartitionRequest$PartitionValues' => '<p>The values that define the partition.</p>', 'Partition$Values' => '<p>The values of the partition.</p>', 'PartitionError$PartitionValues' => '<p>The values that define the partition.</p>', 'PartitionInput$Values' => '<p>The values of the partition.</p>', 'PartitionValueList$Values' => NULL, ], ], 'VersionId' => [ 'base' => NULL, 'refs' => [ 'Crawler$Version' => '<p>The version of the Crawler.</p>', 'GrokClassifier$Version' => '<p>The version of this classifier.</p>', ], ], 'VersionMismatchException' => [ 'base' => '<p>There was a version conflict.</p>', 'refs' => [], ], 'VersionString' => [ 'base' => NULL, 'refs' => [ 'TableVersion$VersionId' => NULL, ], ], 'ViewTextString' => [ 'base' => NULL, 'refs' => [ 'Table$ViewOriginalText' => '<p>If the table is a view, the original text of the view; otherwise <code>null</code>.</p>', 'Table$ViewExpandedText' => '<p>If the table is a view, the expanded text of the view; otherwise <code>null</code>.</p>', 'TableInput$ViewOriginalText' => '<p>If the table is a view, the original text of the view; otherwise <code>null</code>.</p>', 'TableInput$ViewExpandedText' => '<p>If the table is a view, the expanded text of the view; otherwise <code>null</code>.</p>', ], ], ],];
