<?php
// This file was auto-generated from sdk-root/src/data/greengrass/2017-06-07/docs-2.json
return [ 'version' => '1.0', 'service' => 'AWS Greengrass seamlessly extends AWS onto physical devices so they can act locally on the data they generate, while still using the cloud for management, analytics, and durable storage. AWS Greengrass ensures your devices can respond quickly to local events and operate with intermittent connectivity. AWS Greengrass minimizes the cost of transmitting data to the cloud by allowing you to author AWS Lambda functions that execute locally.', 'operations' => [ 'AssociateRoleToGroup' => 'Associates a role with a group. The role will be used by the AWS Greengrass core in order to access AWS cloud services. The role\'s permissions will allow Greengrass core Lambda functions to perform actions against the cloud.', 'AssociateServiceRoleToAccount' => 'Associates a role which is used by AWS Greengrass. AWS Greengrass uses the role to access your Lambda functions and AWS IoT resources. This is necessary for deployments to succeed. It needs to have minimum permissions in policy ``AWSGreengrassResourceAccessRolePolicy``', 'CreateCoreDefinition' => 'Creates a core definition. You may optionally provide the initial version of the core definition or use \'\'CreateCoreDefinitionVersion\'\' at a later time. AWS Greengrass Groups must each contain exactly 1 AWS Greengrass Core.', 'CreateCoreDefinitionVersion' => 'Creates a version of a core definition that has already been defined. AWS Greengrass Groups must each contain exactly 1 AWS Greengrass Core.', 'CreateDeployment' => 'Creates a deployment.', 'CreateDeviceDefinition' => 'Creates a device definition. You may optinally provide the initial version of the device definition or use ``CreateDeviceDefinitionVersion`` at a later time.', 'CreateDeviceDefinitionVersion' => 'Creates a version of a device definition that has already been defined.', 'CreateFunctionDefinition' => 'Creates a Lambda function definition which contains a list of Lambda functions and their configurations to be used in a group. You can create an initial version of the definition by providing a list of Lambda functions and their configurations now, or use ``CreateFunctionDefinitionVersion`` later.', 'CreateFunctionDefinitionVersion' => 'Create a version of a Lambda function definition that has already been defined.', 'CreateGroup' => 'Creates a group. You may optionally provide the initial version of the group or use \'\'CreateGroupVersion\'\' at a later time.', 'CreateGroupCertificateAuthority' => 'Creates a CA for the group. If a CA already exists, it will rotate the existing CA.', 'CreateGroupVersion' => 'Creates a version of a group which has already been defined.', 'CreateLoggerDefinition' => 'Creates a logger definition. You may optionally provide the initial version of the logger definition or use ``CreateLoggerDefinitionVersion`` at a later time.', 'CreateLoggerDefinitionVersion' => 'Creates a version of a logger definition that has already been defined.', 'CreateSubscriptionDefinition' => 'Creates a subscription definition. You may optionally provide the initial version of the subscription definition or use ``CreateSubscriptionDefinitionVersion`` at a later time.', 'CreateSubscriptionDefinitionVersion' => 'Creates a version of a subscription definition which has already been defined.', 'DeleteCoreDefinition' => 'Deletes a core definition. The core definition must not have been used in a deployment.', 'DeleteDeviceDefinition' => 'Deletes a device definition. The device definition must not have been used in a deployment.', 'DeleteFunctionDefinition' => 'Deletes a Lambda function definition. The Lambda function definition must not have been used in a deployment.', 'DeleteGroup' => 'Deletes a group. The group must not have been used in deployment.', 'DeleteLoggerDefinition' => 'Deletes a logger definition. The logger definition must not have been used in a deployment.', 'DeleteSubscriptionDefinition' => 'Deletes a subscription definition. The subscription definition must not have been used in a deployment.', 'DisassociateRoleFromGroup' => 'Disassociates the role from a group.', 'DisassociateServiceRoleFromAccount' => 'Disassociates the service role from the account. Without a service role, deployments will not work.', 'GetAssociatedRole' => 'Retrieves the role associated with a particular group.', 'GetConnectivityInfo' => 'Retrieves the connectivity information for a core.', 'GetCoreDefinition' => 'Retrieves information about a core definition version.', 'GetCoreDefinitionVersion' => 'Retrieves information about a core definition version.', 'GetDeploymentStatus' => 'Returns the status of a deployment.', 'GetDeviceDefinition' => 'Retrieves information about a device definition.', 'GetDeviceDefinitionVersion' => 'Retrieves information about a device definition version.', 'GetFunctionDefinition' => 'Retrieves information about a Lambda function definition, such as its creation time and latest version.', 'GetFunctionDefinitionVersion' => 'Retrieves information about a Lambda function definition version, such as which Lambda functions are included in the version and their configurations.', 'GetGroup' => 'Retrieves information about a group.', 'GetGroupCertificateAuthority' => 'Retreives the CA associated with a group. Returns the public key of the CA.', 'GetGroupCertificateConfiguration' => 'Retrieves the current configuration for the CA used by the group.', 'GetGroupVersion' => 'Retrieves information about a group version.', 'GetLoggerDefinition' => 'Retrieves information about a logger definition.', 'GetLoggerDefinitionVersion' => 'Retrieves information about a logger definition version.', 'GetServiceRoleForAccount' => 'Retrieves the service role that is attached to the account.', 'GetSubscriptionDefinition' => 'Retrieves information about a subscription definition.', 'GetSubscriptionDefinitionVersion' => 'Retrieves information about a subscription definition version.', 'ListCoreDefinitionVersions' => 'Lists versions of a core definition.', 'ListCoreDefinitions' => 'Retrieves a list of core definitions.', 'ListDeployments' => 'Returns a history of deployments for the group.', 'ListDeviceDefinitionVersions' => 'Lists the versions of a device definition.', 'ListDeviceDefinitions' => 'Retrieves a list of device definitions.', 'ListFunctionDefinitionVersions' => 'Lists the versions of a Lambda function definition.', 'ListFunctionDefinitions' => 'Retrieves a list of Lambda function definitions.', 'ListGroupCertificateAuthorities' => 'Retrieves the current CAs for a group.', 'ListGroupVersions' => 'List the versions of a group.', 'ListGroups' => 'Retrieves a list of groups.', 'ListLoggerDefinitionVersions' => 'Lists the versions of a logger definition.', 'ListLoggerDefinitions' => 'Retrieves a list of logger definitions.', 'ListSubscriptionDefinitionVersions' => 'Lists the versions of a subscription definition.', 'ListSubscriptionDefinitions' => 'Retrieves a list of subscription definitions.', 'UpdateConnectivityInfo' => 'Updates the connectivity information for the core. Any devices that belong to the group which has this core will receive this information in order to find the location of the core and connect to it.', 'UpdateCoreDefinition' => 'Updates a core definition.', 'UpdateDeviceDefinition' => 'Updates a device definition.', 'UpdateFunctionDefinition' => 'Updates a Lambda function definition.', 'UpdateGroup' => 'Updates a group.', 'UpdateGroupCertificateConfiguration' => 'Updates the Cert expiry time for a group.', 'UpdateLoggerDefinition' => 'Updates a logger definition.', 'UpdateSubscriptionDefinition' => 'Updates a subscription definition.', ], 'shapes' => [ 'AssociateRoleToGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateRoleToGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateServiceRoleToAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateServiceRoleToAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'BadRequestException' => [ 'base' => 'user error', 'refs' => [], ], 'ConnectivityInfo' => [ 'base' => 'Connectivity Info', 'refs' => [ 'GetConnectivityInfoResponse$ConnectivityInfo' => 'Connectivity info array', 'UpdateConnectivityInfoRequest$ConnectivityInfo' => 'Connectivity info array', ], ], 'Core' => [ 'base' => 'Information on the core', 'refs' => [ 'CoreDefinitionVersion$Cores' => 'Cores in the definition version.', ], ], 'CoreDefinitionVersion' => [ 'base' => 'Information on core definition version', 'refs' => [ 'GetCoreDefinitionVersionResponse$Definition' => 'Information on definition', ], ], 'CreateDeploymentRequest' => [ 'base' => 'Information on Deployment', 'refs' => [], ], 'CreateDeploymentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupCertificateAuthorityResponse' => [ 'base' => NULL, 'refs' => [], ], 'DefinitionInformation' => [ 'base' => 'Information on the Definition', 'refs' => [ 'ListDefinitionsResponse$Definitions' => 'Definitions', ], ], 'Deployment' => [ 'base' => 'Information on the deployment', 'refs' => [ 'Deployments' => NULL, ], ], 'DeploymentType' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentRequest$DeploymentType' => 'Type of deployment', ], ], 'Deployments' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentsResponse$Deployments' => 'Information on deployments', ], ], 'Device' => [ 'base' => 'Information on a Device', 'refs' => [ 'DeviceDefinitionVersion$Devices' => 'Devices in the definition version.', ], ], 'DeviceDefinitionVersion' => [ 'base' => 'Information on device definition version', 'refs' => [ 'GetDeviceDefinitionVersionResponse$Definition' => 'Device definition version', ], ], 'DisassociateRoleFromGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateServiceRoleFromAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'Empty' => [ 'base' => 'Empty', 'refs' => [], ], 'ErrorDetail' => [ 'base' => 'ErrorDetail', 'refs' => [ 'ErrorDetails' => 'Error Details', ], ], 'ErrorDetails' => [ 'base' => 'Error Details', 'refs' => [ 'GeneralError$ErrorDetails' => 'Error Details', ], ], 'Function' => [ 'base' => 'Information on function', 'refs' => [ 'FunctionDefinitionVersion$Functions' => 'Lambda functions in this function definition version.', ], ], 'FunctionConfiguration' => [ 'base' => 'Configuration of the function', 'refs' => [ 'Function$FunctionConfiguration' => 'Configuration of the function', ], ], 'FunctionConfigurationEnvironment' => [ 'base' => 'Environment of the function configuration', 'refs' => [ 'FunctionConfiguration$Environment' => 'Environment of the function configuration', ], ], 'FunctionDefinitionVersion' => [ 'base' => 'Information on the function definition version', 'refs' => [ 'GetFunctionDefinitionVersionResponse$Definition' => 'Information on the definition', ], ], 'GeneralError' => [ 'base' => 'General Error', 'refs' => [], ], 'GetAssociatedRoleResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectivityInfoResponse' => [ 'base' => 'connectivity info response', 'refs' => [], ], 'GetCoreDefinitionVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDeploymentStatusResponse' => [ 'base' => 'The response body contains the status of a deployment for a group.', 'refs' => [], ], 'GetDeviceDefinitionVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionDefinitionVersionResponse' => [ 'base' => 'Function definition version', 'refs' => [], ], 'GetGroupCertificateAuthorityResponse' => [ 'base' => 'Certificate authority for the group.', 'refs' => [], ], 'GetGroupVersionResponse' => [ 'base' => 'Information on the group version', 'refs' => [], ], 'GetLoggerDefinitionVersionResponse' => [ 'base' => 'Information on logger definition version response', 'refs' => [], ], 'GetServiceRoleForAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionDefinitionVersionResponse' => [ 'base' => 'Information on the Subscription Definition Version', 'refs' => [], ], 'GroupCertificateAuthorityProperties' => [ 'base' => 'Information on group certificate authority properties', 'refs' => [ 'ListGroupCertificateAuthoritiesResponse$GroupCertificateAuthorities' => 'List of certificate authorities associated with the group.', ], ], 'GroupCertificateConfiguration' => [ 'base' => 'Information on the group certificate configuration', 'refs' => [], ], 'GroupInformation' => [ 'base' => 'Information of a group', 'refs' => [ 'ListGroupsResponse$Groups' => 'Groups', ], ], 'GroupVersion' => [ 'base' => 'Information on group version', 'refs' => [ 'GetGroupVersionResponse$Definition' => 'Information on the definition', ], ], 'InternalServerErrorException' => [ 'base' => 'This request was invalid.', 'refs' => [], ], 'ListDefinitionsResponse' => [ 'base' => 'List of definition response', 'refs' => [], ], 'ListDeploymentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupCertificateAuthoritiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOfConnectivityInfo' => [ 'base' => NULL, 'refs' => [], ], 'ListOfCore' => [ 'base' => NULL, 'refs' => [], ], 'ListOfDefinitionInformation' => [ 'base' => NULL, 'refs' => [], ], 'ListOfDevice' => [ 'base' => NULL, 'refs' => [], ], 'ListOfFunction' => [ 'base' => NULL, 'refs' => [], ], 'ListOfGroupCertificateAuthorityProperties' => [ 'base' => NULL, 'refs' => [], ], 'ListOfGroupInformation' => [ 'base' => NULL, 'refs' => [], ], 'ListOfLogger' => [ 'base' => NULL, 'refs' => [], ], 'ListOfSubscription' => [ 'base' => NULL, 'refs' => [], ], 'ListOfVersionInformation' => [ 'base' => NULL, 'refs' => [], ], 'ListVersionsResponse' => [ 'base' => 'List of versions response', 'refs' => [], ], 'Logger' => [ 'base' => 'Information on the Logger', 'refs' => [ 'LoggerDefinitionVersion$Loggers' => 'List of loggers.', ], ], 'LoggerComponent' => [ 'base' => NULL, 'refs' => [ 'Logger$Component' => 'The component that will be subject to logs', ], ], 'LoggerDefinitionVersion' => [ 'base' => 'Information on logger definition version', 'refs' => [ 'GetLoggerDefinitionVersionResponse$Definition' => 'Information on definition', ], ], 'LoggerLevel' => [ 'base' => NULL, 'refs' => [ 'Logger$Level' => 'The level of the logs', ], ], 'LoggerType' => [ 'base' => NULL, 'refs' => [ 'Logger$Type' => 'The type which will be use for log output', ], ], 'MapOf__string' => [ 'base' => NULL, 'refs' => [], ], 'Subscription' => [ 'base' => 'Information on subscription', 'refs' => [ 'SubscriptionDefinitionVersion$Subscriptions' => 'Subscriptions in the version.', ], ], 'SubscriptionDefinitionVersion' => [ 'base' => 'Information on subscription definition version', 'refs' => [ 'GetSubscriptionDefinitionVersionResponse$Definition' => 'Information on the definition', ], ], 'UpdateConnectivityInfoRequest' => [ 'base' => 'Information on connectivity info', 'refs' => [], ], 'UpdateConnectivityInfoResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupCertificateConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'VersionInformation' => [ 'base' => 'Information on the version', 'refs' => [ 'ListVersionsResponse$Versions' => 'Versions', ], ], '__boolean' => [ 'base' => NULL, 'refs' => [ 'Core$SyncShadow' => 'If true, the local shadow value automatically syncs with the cloud\'s shadow state.', 'Device$SyncShadow' => 'If true, the local shadow value automatically syncs with the cloud\'s shadow state.', 'FunctionConfiguration$Pinned' => 'Whether the function is pinned or not. Pinned means the function is long-lived and starts when the core starts.', ], ], '__integer' => [ 'base' => NULL, 'refs' => [ 'ConnectivityInfo$PortNumber' => 'Port of the GGC. Usually 8883.', 'FunctionConfiguration$MemorySize' => 'The memory size, in KB, you configured for the function.', 'FunctionConfiguration$Timeout' => 'The function execution time at which Lambda should terminate the function. This timeout still applies to pinned lambdas for each request.', 'Logger$Space' => 'Amount of hardware space, in KB, to use if file system is used for logging purposes.', ], ], '__string' => [ 'base' => NULL, 'refs' => [ 'AssociateRoleToGroupRequest$RoleArn' => 'Role arn you wish to associate with this group.', 'AssociateRoleToGroupResponse$AssociatedAt' => 'Time the role arn was associated to your group.', 'AssociateServiceRoleToAccountRequest$RoleArn' => 'Role arn you wish to associate with this account.', 'AssociateServiceRoleToAccountResponse$AssociatedAt' => 'Time when the service role was associated to the account.', 'ConnectivityInfo$HostAddress' => 'Endpoint for the GGC. Can be an IP address or DNS.', 'ConnectivityInfo$Id' => 'Element Id for this entry in the list.', 'ConnectivityInfo$Metadata' => 'Metadata for this endpoint.', 'Core$CertificateArn' => 'Certificate arn of the core.', 'Core$Id' => 'Element Id for this entry in the list.', 'Core$ThingArn' => 'Thing arn of the core.', 'CreateDeploymentRequest$DeploymentId' => 'Id of the deployment if you wish to redeploy a previous deployment.', 'CreateDeploymentRequest$GroupVersionId' => 'Group Version you wish to deploy.', 'CreateDeploymentResponse$DeploymentArn' => 'Arn of the deployment.', 'CreateDeploymentResponse$DeploymentId' => 'Id of the deployment.', 'CreateGroupCertificateAuthorityResponse$GroupCertificateAuthorityArn' => 'Arn of the group certificate authority.', 'DefinitionInformation$Arn' => 'Arn of the definition.', 'DefinitionInformation$CreationTimestamp' => 'Timestamp of when the definition was created.', 'DefinitionInformation$Id' => 'Id of the definition.', 'DefinitionInformation$LastUpdatedTimestamp' => 'Last updated timestamp of the definition.', 'DefinitionInformation$LatestVersion' => 'Last version of the definition.', 'DefinitionInformation$LatestVersionArn' => 'Latest version arn of the definition.', 'DefinitionInformation$Name' => 'Name of the definition.', 'Deployment$CreatedAt' => 'Timestamp when the deployment was created.', 'Deployment$DeploymentArn' => 'Arn of the deployment.', 'Deployment$DeploymentId' => 'Id of the deployment.', 'Deployment$GroupArn' => 'Arn of the group for this deployment.', 'Device$CertificateArn' => 'Certificate arn of the device.', 'Device$Id' => 'Element Id for this entry in the list.', 'Device$ThingArn' => 'Thing arn of the device.', 'DisassociateRoleFromGroupResponse$DisassociatedAt' => 'Time when the role was disassociated from the group.', 'DisassociateServiceRoleFromAccountResponse$DisassociatedAt' => 'Time when the service role was disassociated from the account.', 'ErrorDetail$DetailedErrorCode' => 'Detailed Error Code', 'ErrorDetail$DetailedErrorMessage' => 'Detailed Error Message', 'Function$FunctionArn' => 'Arn of the Lambda function.', 'Function$Id' => 'Id of the function in this version.', 'FunctionConfiguration$ExecArgs' => 'Execution Arguments', 'FunctionConfiguration$Executable' => 'Executable', 'GeneralError$Message' => 'Message', 'GetAssociatedRoleResponse$AssociatedAt' => 'Time when the role was associated for the group.', 'GetAssociatedRoleResponse$RoleArn' => 'Arn of the role that is associated with the group.', 'GetConnectivityInfoResponse$message' => 'Response Text', 'GetCoreDefinitionVersionResponse$Arn' => 'Arn of the core definition version.', 'GetCoreDefinitionVersionResponse$CreationTimestamp' => 'Timestamp of when the core definition version was created.', 'GetCoreDefinitionVersionResponse$Id' => 'Id of the core definition the version belongs to.', 'GetCoreDefinitionVersionResponse$Version' => 'Version of the core definition version.', 'GetDeploymentStatusResponse$DeploymentStatus' => 'Status of the deployment.', 'GetDeploymentStatusResponse$ErrorMessage' => 'Error Message', 'GetDeploymentStatusResponse$UpdatedAt' => 'Last time the deployment status was updated.', 'GetDeviceDefinitionVersionResponse$Arn' => 'Arn of the device definition version.', 'GetDeviceDefinitionVersionResponse$CreationTimestamp' => 'Timestamp of when the device definition version was created.', 'GetDeviceDefinitionVersionResponse$Id' => 'Id of the device definition the version belongs to.', 'GetDeviceDefinitionVersionResponse$Version' => 'Version of the device definition version.', 'GetFunctionDefinitionVersionResponse$Arn' => 'Arn of the function definition version.', 'GetFunctionDefinitionVersionResponse$CreationTimestamp' => 'Timestamp when the funtion definition version was created.', 'GetFunctionDefinitionVersionResponse$Id' => 'Id of the function definition the version belongs to.', 'GetFunctionDefinitionVersionResponse$Version' => 'Version of the function definition version.', 'GetGroupCertificateAuthorityResponse$GroupCertificateAuthorityArn' => 'Arn of the certificate authority for the group.', 'GetGroupCertificateAuthorityResponse$GroupCertificateAuthorityId' => 'Id of the certificate authority for the group.', 'GetGroupCertificateAuthorityResponse$PemEncodedCertificate' => 'PEM encoded certificate for the group.', 'GetGroupVersionResponse$Arn' => 'Arn of the group version.', 'GetGroupVersionResponse$CreationTimestamp' => 'Timestamp when the group version was created.', 'GetGroupVersionResponse$Id' => 'Id of the group version.', 'GetGroupVersionResponse$Version' => 'Unique Id for a version of the Group.', 'GetLoggerDefinitionVersionResponse$Arn' => 'Arn of the logger definition version.', 'GetLoggerDefinitionVersionResponse$CreationTimestamp' => 'Timestamp of when the logger definition version was created.', 'GetLoggerDefinitionVersionResponse$Id' => 'Id of the logger definition the version belongs to.', 'GetLoggerDefinitionVersionResponse$Version' => 'Version of the logger definition version.', 'GetServiceRoleForAccountResponse$AssociatedAt' => 'Time when the service role was associated to the account.', 'GetServiceRoleForAccountResponse$RoleArn' => 'Role arn which is associated to the account.', 'GetSubscriptionDefinitionVersionResponse$Arn' => 'Arn of the subscription definition version.', 'GetSubscriptionDefinitionVersionResponse$CreationTimestamp' => 'Timestamp of when the subscription definition version was created.', 'GetSubscriptionDefinitionVersionResponse$Id' => 'Id of the subscription definition the version belongs to.', 'GetSubscriptionDefinitionVersionResponse$Version' => 'Version of the subscription definition version.', 'GroupCertificateAuthorityProperties$GroupCertificateAuthorityArn' => 'Arn of the certificate authority for the group.', 'GroupCertificateAuthorityProperties$GroupCertificateAuthorityId' => 'Id of the certificate authority for the group.', 'GroupCertificateConfiguration$CertificateAuthorityExpiryInMilliseconds' => 'Amount of time when the certificate authority expires in milliseconds.', 'GroupCertificateConfiguration$CertificateExpiryInMilliseconds' => 'Amount of time when the certificate expires in milliseconds.', 'GroupCertificateConfiguration$GroupId' => 'Id of the group the certificate configuration belongs to.', 'GroupInformation$Arn' => 'Arn of a group.', 'GroupInformation$CreationTimestamp' => 'Timestamp of when the group was created.', 'GroupInformation$Id' => 'Id of a group.', 'GroupInformation$LastUpdatedTimestamp' => 'Last updated timestamp of the group.', 'GroupInformation$LatestVersion' => 'Last version of the group.', 'GroupInformation$LatestVersionArn' => 'Latest version arn of the group.', 'GroupInformation$Name' => 'Name of a group.', 'GroupVersion$CoreDefinitionVersionArn' => 'Core definition version arn for this group.', 'GroupVersion$DeviceDefinitionVersionArn' => 'Device definition version arn for this group.', 'GroupVersion$FunctionDefinitionVersionArn' => 'Function definition version arn for this group.', 'GroupVersion$LoggerDefinitionVersionArn' => 'Logger definitionv ersion arn for this group.', 'GroupVersion$SubscriptionDefinitionVersionArn' => 'Subscription definition version arn for this group.', 'ListDefinitionsResponse$NextToken' => 'The token for the next set of results, or \'\'null\'\' if there are no additional results.', 'ListDeploymentsResponse$NextToken' => 'The token for the next set of results, or \'\'null\'\' if there are no additional results.', 'ListGroupsResponse$NextToken' => 'The token for the next set of results, or \'\'null\'\' if there are no additional results.', 'ListVersionsResponse$NextToken' => 'The token for the next set of results, or \'\'null\'\' if there are no additional results.', 'Logger$Id' => 'Element Id for this entry in the list.', 'Subscription$Id' => 'Element Id for this entry in the list.', 'Subscription$Source' => 'Source of the subscription. Can be a thing arn, lambda arn or word \'cloud\'', 'Subscription$Subject' => 'Subject of the message.', 'Subscription$Target' => 'Where the message is sent to. Can be a thing arn, lambda arn or word \'cloud\'.', 'UpdateConnectivityInfoResponse$Version' => 'New Version', 'UpdateConnectivityInfoResponse$message' => 'Response Text', 'UpdateGroupCertificateConfigurationRequest$CertificateExpiryInMilliseconds' => 'Amount of time when the certificate expires in milliseconds.', 'VersionInformation$Arn' => 'Arn of the version.', 'VersionInformation$CreationTimestamp' => 'Timestamp of when the version was created.', 'VersionInformation$Id' => 'Id of the resource container.', 'VersionInformation$Version' => 'Unique Id of a version.', ], ], ],];
