<?php
// This file was auto-generated from sdk-root/src/data/iam/2010-05-08/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Identity and Access Management</fullname> <p>AWS Identity and Access Management (IAM) is a web service that you can use to manage users and user permissions under your AWS account. This guide provides descriptions of IAM actions that you can call programmatically. For general information about IAM, see <a href="http://aws.amazon.com/iam/">AWS Identity and Access Management (IAM)</a>. For the user guide for IAM, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/">Using IAM</a>. </p> <note> <p>AWS provides SDKs that consist of libraries and sample code for various programming languages and platforms (Java, Ruby, .NET, iOS, Android, etc.). The SDKs provide a convenient way to create programmatic access to IAM and AWS. For example, the SDKs take care of tasks such as cryptographically signing requests (see below), managing errors, and retrying requests automatically. For information about the AWS SDKs, including how to download and install them, see the <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a> page. </p> </note> <p>We recommend that you use the AWS SDKs to make programmatic API calls to IAM. However, you can also use the IAM Query API to make direct calls to the IAM web service. To learn more about the IAM Query API, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making Query Requests</a> in the <i>Using IAM</i> guide. IAM supports GET and POST requests for all actions. That is, the API does not require you to use GET for some actions and POST for others. However, GET requests are subject to the limitation size of a URL. Therefore, for operations that require larger sizes, use a POST request. </p> <p> <b>Signing Requests</b> </p> <p>Requests must be signed using an access key ID and a secret access key. We strongly recommend that you do not use your AWS account access key ID and secret access key for everyday work with IAM. You can use the access key ID and secret access key for an IAM user or you can use the AWS Security Token Service to generate temporary security credentials and use those to sign requests.</p> <p>To sign requests, we recommend that you use <a href="http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>. If you have an existing application that uses Signature Version 2, you do not have to update it to use Signature Version 4. However, some operations now require Signature Version 4. The documentation for operations that require version 4 indicate this requirement. </p> <p> <b>Additional Resources</b> </p> <p>For more information, see the following:</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html">AWS Security Credentials</a>. This topic provides general information about the types of credentials used for accessing AWS. </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/IAMBestPractices.html">IAM Best Practices</a>. This topic presents a list of suggestions for using the IAM service to help secure your AWS resources. </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html">Signing AWS API Requests</a>. This set of topics walk you through the process of signing a request using an access key ID and secret access key. </p> </li> </ul>', 'operations' => [ 'AddClientIDToOpenIDConnectProvider' => '<p>Adds a new client ID (also known as audience) to the list of client IDs already registered for the specified IAM OpenID Connect (OIDC) provider resource.</p> <p>This action is idempotent; it does not fail or return an error if you add an existing client ID to the provider.</p>', 'AddRoleToInstanceProfile' => '<p>Adds the specified IAM role to the specified instance profile. An instance profile can contain only one role, and this limit cannot be increased.</p> <note> <p>The caller of this API must be granted the <code>PassRole</code> permission on the IAM role by a permission policy.</p> </note> <p>For more information about roles, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with Roles</a>. For more information about instance profiles, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.</p>', 'AddUserToGroup' => '<p>Adds the specified user to the specified group.</p>', 'AttachGroupPolicy' => '<p>Attaches the specified managed policy to the specified IAM group.</p> <p>You use this API to attach a managed policy to a group. To embed an inline policy in a group, use <a>PutGroupPolicy</a>.</p> <p>For more information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'AttachRolePolicy' => '<p>Attaches the specified managed policy to the specified IAM role. When you attach a managed policy to a role, the managed policy becomes part of the role\'s permission (access) policy.</p> <note> <p>You cannot use a managed policy as the role\'s trust policy. The role\'s trust policy is created at the same time as the role, using <a>CreateRole</a>. You can update a role\'s trust policy using <a>UpdateAssumeRolePolicy</a>.</p> </note> <p>Use this API to attach a <i>managed</i> policy to a role. To embed an inline policy in a role, use <a>PutRolePolicy</a>. For more information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'AttachUserPolicy' => '<p>Attaches the specified managed policy to the specified user.</p> <p>You use this API to attach a <i>managed</i> policy to a user. To embed an inline policy in a user, use <a>PutUserPolicy</a>.</p> <p>For more information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'ChangePassword' => '<p>Changes the password of the IAM user who is calling this action. The root account password is not affected by this action.</p> <p>To change the password for a different user, see <a>UpdateLoginProfile</a>. For more information about modifying passwords, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing Passwords</a> in the <i>IAM User Guide</i>.</p>', 'CreateAccessKey' => '<p> Creates a new AWS secret access key and corresponding AWS access key ID for the specified user. The default status for new keys is <code>Active</code>.</p> <p>If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing the request. Because this action works for access keys under the AWS account, you can use this action to manage root credentials even if the AWS account has no associated users.</p> <p> For information about limits on the number of keys you can create, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html">Limitations on IAM Entities</a> in the <i>IAM User Guide</i>.</p> <important> <p>To ensure the security of your AWS account, the secret access key is accessible only during key and user creation. You must save the key (for example, in a text file) if you want to be able to access it again. If a secret key is lost, you can delete the access keys for the associated user and then create new keys.</p> </important>', 'CreateAccountAlias' => '<p>Creates an alias for your AWS account. For information about using an AWS account alias, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an Alias for Your AWS Account ID</a> in the <i>IAM User Guide</i>.</p>', 'CreateGroup' => '<p>Creates a new group.</p> <p> For information about the number of groups you can create, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html">Limitations on IAM Entities</a> in the <i>IAM User Guide</i>.</p>', 'CreateInstanceProfile' => '<p> Creates a new instance profile. For information about instance profiles, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.</p> <p> For information about the number of instance profiles you can create, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html">Limitations on IAM Entities</a> in the <i>IAM User Guide</i>.</p>', 'CreateLoginProfile' => '<p> Creates a password for the specified user, giving the user the ability to access AWS services through the AWS Management Console. For more information about managing passwords, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing Passwords</a> in the <i>IAM User Guide</i>.</p>', 'CreateOpenIDConnectProvider' => '<p>Creates an IAM entity to describe an identity provider (IdP) that supports <a href="http://openid.net/connect/">OpenID Connect (OIDC)</a>.</p> <p>The OIDC provider that you create with this operation can be used as a principal in a role\'s trust policy to establish a trust relationship between AWS and the OIDC provider.</p> <p>When you create the IAM OIDC provider, you specify the URL of the OIDC identity provider (IdP) to trust, a list of client IDs (also known as audiences) that identify the application or applications that are allowed to authenticate using the OIDC provider, and a list of thumbprints of the server certificate(s) that the IdP uses. You get all of this information from the OIDC IdP that you want to use for access to AWS.</p> <note> <p>Because trust for the OIDC provider is ultimately derived from the IAM provider that this action creates, it is a best practice to limit access to the <a>CreateOpenIDConnectProvider</a> action to highly-privileged users.</p> </note>', 'CreatePolicy' => '<p>Creates a new managed policy for your AWS account.</p> <p>This operation creates a policy version with a version identifier of <code>v1</code> and sets v1 as the policy\'s default version. For more information about policy versions, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for Managed Policies</a> in the <i>IAM User Guide</i>.</p> <p>For more information about managed policies in general, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'CreatePolicyVersion' => '<p>Creates a new version of the specified managed policy. To update a managed policy, you create a new policy version. A managed policy can have up to five versions. If the policy has five versions, you must delete an existing version using <a>DeletePolicyVersion</a> before you create a new version.</p> <p>Optionally, you can set the new version as the policy\'s default version. The default version is the version that is in effect for the IAM users, groups, and roles to which the policy is attached.</p> <p>For more information about managed policy versions, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for Managed Policies</a> in the <i>IAM User Guide</i>.</p>', 'CreateRole' => '<p>Creates a new role for your AWS account. For more information about roles, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with Roles</a>. For information about limitations on role names and the number of roles you can create, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html">Limitations on IAM Entities</a> in the <i>IAM User Guide</i>.</p>', 'CreateSAMLProvider' => '<p>Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.</p> <p>The SAML provider resource that you create with this operation can be used as a principal in an IAM role\'s trust policy to enable federated users who sign-in using the SAML IdP to assume the role. You can create an IAM role that supports Web-based single sign-on (SSO) to the AWS Management Console or one that supports API access to AWS.</p> <p>When you create the SAML provider resource, you upload an a SAML metadata document that you get from your IdP and that includes the issuer\'s name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that the IdP sends. You must generate the metadata document using the identity management software that is used as your organization\'s IdP.</p> <note> <p> This operation requires <a href="http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p> </note> <p> For more information, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">Enabling SAML 2.0 Federated Users to Access the AWS Management Console</a> and <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based Federation</a> in the <i>IAM User Guide</i>.</p>', 'CreateServiceLinkedRole' => '<p>Creates an IAM role that is linked to a specific AWS service. The service controls the attached policies and when the role can be deleted. This helps ensure that the service is not broken by an unexpectedly changed or deleted role, which could put your AWS resources into an unknown state. Allowing the service to control the role helps improve service stability and proper cleanup when a service and its role are no longer needed.</p> <p>The name of the role is autogenerated by combining the string that you specify for the <code>AWSServiceName</code> parameter with the string that you specify for the <code>CustomSuffix</code> parameter. The resulting name must be unique in your account or the request fails.</p> <p>To attach a policy to this service-linked role, you must make the request using the AWS service that depends on this role.</p>', 'CreateServiceSpecificCredential' => '<p>Generates a set of credentials consisting of a user name and password that can be used to access the service specified in the request. These credentials are generated by IAM, and can be used only for the specified service. </p> <p>You can have a maximum of two sets of service-specific credentials for each supported service per user.</p> <p>The only supported service at this time is AWS CodeCommit.</p> <p>You can reset the password to a new service-generated value by calling <a>ResetServiceSpecificCredential</a>.</p> <p>For more information about service-specific credentials, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_ssh-keys.html">Using IAM with AWS CodeCommit: Git Credentials, SSH Keys, and AWS Access Keys</a> in the <i>IAM User Guide</i>.</p>', 'CreateUser' => '<p>Creates a new IAM user for your AWS account.</p> <p> For information about limitations on the number of IAM users you can create, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html">Limitations on IAM Entities</a> in the <i>IAM User Guide</i>.</p>', 'CreateVirtualMFADevice' => '<p>Creates a new virtual MFA device for the AWS account. After creating the virtual MFA, use <a>EnableMFADevice</a> to attach the MFA device to an IAM user. For more information about creating and working with virtual MFA devices, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a Virtual MFA Device</a> in the <i>IAM User Guide</i>.</p> <p>For information about limits on the number of MFA devices you can create, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html">Limitations on Entities</a> in the <i>IAM User Guide</i>.</p> <important> <p>The seed information contained in the QR code and the Base32 string should be treated like any other secret access information, such as your AWS access keys or your passwords. After you provision your virtual device, you should ensure that the information is destroyed following secure procedures.</p> </important>', 'DeactivateMFADevice' => '<p>Deactivates the specified MFA device and removes it from association with the user name for which it was originally enabled.</p> <p>For more information about creating and working with virtual MFA devices, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a Virtual MFA Device</a> in the <i>IAM User Guide</i>.</p>', 'DeleteAccessKey' => '<p>Deletes the access key pair associated with the specified IAM user.</p> <p>If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing the request. Because this action works for access keys under the AWS account, you can use this action to manage root credentials even if the AWS account has no associated users.</p>', 'DeleteAccountAlias' => '<p> Deletes the specified AWS account alias. For information about using an AWS account alias, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an Alias for Your AWS Account ID</a> in the <i>IAM User Guide</i>.</p>', 'DeleteAccountPasswordPolicy' => '<p>Deletes the password policy for the AWS account. There are no parameters.</p>', 'DeleteGroup' => '<p>Deletes the specified IAM group. The group must not contain any users or have any attached policies.</p>', 'DeleteGroupPolicy' => '<p>Deletes the specified inline policy that is embedded in the specified IAM group.</p> <p>A group can also have managed policies attached to it. To detach a managed policy from a group, use <a>DetachGroupPolicy</a>. For more information about policies, refer to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'DeleteInstanceProfile' => '<p>Deletes the specified instance profile. The instance profile must not have an associated role.</p> <important> <p>Make sure you do not have any Amazon EC2 instances running with the instance profile you are about to delete. Deleting a role or instance profile that is associated with a running instance will break any applications running on the instance.</p> </important> <p>For more information about instance profiles, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.</p>', 'DeleteLoginProfile' => '<p>Deletes the password for the specified IAM user, which terminates the user\'s ability to access AWS services through the AWS Management Console.</p> <important> <p> Deleting a user\'s password does not prevent a user from accessing AWS through the command line interface or the API. To prevent all user access you must also either make any access keys inactive or delete them. For more information about making keys inactive or deleting them, see <a>UpdateAccessKey</a> and <a>DeleteAccessKey</a>. </p> </important>', 'DeleteOpenIDConnectProvider' => '<p>Deletes an OpenID Connect identity provider (IdP) resource object in IAM.</p> <p>Deleting an IAM OIDC provider resource does not update any roles that reference the provider as a principal in their trust policies. Any attempt to assume a role that references a deleted provider fails.</p> <p>This action is idempotent; it does not fail or return an error if you call the action for a provider that does not exist.</p>', 'DeletePolicy' => '<p>Deletes the specified managed policy.</p> <p>Before you can delete a managed policy, you must first detach the policy from all users, groups, and roles that it is attached to, and you must delete all of the policy\'s versions. The following steps describe the process for deleting a managed policy:</p> <ul> <li> <p>Detach the policy from all users, groups, and roles that the policy is attached to, using the <a>DetachUserPolicy</a>, <a>DetachGroupPolicy</a>, or <a>DetachRolePolicy</a> APIs. To list all the users, groups, and roles that a policy is attached to, use <a>ListEntitiesForPolicy</a>.</p> </li> <li> <p>Delete all versions of the policy using <a>DeletePolicyVersion</a>. To list the policy\'s versions, use <a>ListPolicyVersions</a>. You cannot use <a>DeletePolicyVersion</a> to delete the version that is marked as the default version. You delete the policy\'s default version in the next step of the process.</p> </li> <li> <p>Delete the policy (this automatically deletes the policy\'s default version) using this API.</p> </li> </ul> <p>For information about managed policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'DeletePolicyVersion' => '<p>Deletes the specified version from the specified managed policy.</p> <p>You cannot delete the default version from a policy using this API. To delete the default version from a policy, use <a>DeletePolicy</a>. To find out which version of a policy is marked as the default version, use <a>ListPolicyVersions</a>.</p> <p>For information about versions for managed policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for Managed Policies</a> in the <i>IAM User Guide</i>.</p>', 'DeleteRole' => '<p>Deletes the specified role. The role must not have any policies attached. For more information about roles, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with Roles</a>.</p> <important> <p>Make sure you do not have any Amazon EC2 instances running with the role you are about to delete. Deleting a role or instance profile that is associated with a running instance will break any applications running on the instance.</p> </important>', 'DeleteRolePolicy' => '<p>Deletes the specified inline policy that is embedded in the specified IAM role.</p> <p>A role can also have managed policies attached to it. To detach a managed policy from a role, use <a>DetachRolePolicy</a>. For more information about policies, refer to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'DeleteSAMLProvider' => '<p>Deletes a SAML provider resource in IAM.</p> <p>Deleting the provider resource from IAM does not update any roles that reference the SAML provider resource\'s ARN as a principal in their trust policies. Any attempt to assume a role that references a non-existent provider resource ARN fails.</p> <note> <p> This operation requires <a href="http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p> </note>', 'DeleteSSHPublicKey' => '<p>Deletes the specified SSH public key.</p> <p>The SSH public key deleted by this action is used only for authenticating the associated IAM user to an AWS CodeCommit repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository, see <a href="http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS CodeCommit for SSH Connections</a> in the <i>AWS CodeCommit User Guide</i>.</p>', 'DeleteServerCertificate' => '<p>Deletes the specified server certificate.</p> <p>For more information about working with server certificates, including a list of AWS services that can use the server certificates that you manage with IAM, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with Server Certificates</a> in the <i>IAM User Guide</i>.</p> <important> <p> If you are using a server certificate with Elastic Load Balancing, deleting the certificate could have implications for your application. If Elastic Load Balancing doesn\'t detect the deletion of bound certificates, it may continue to use the certificates. This could cause Elastic Load Balancing to stop accepting traffic. We recommend that you remove the reference to the certificate from Elastic Load Balancing before using this command to delete the certificate. For more information, go to <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html">DeleteLoadBalancerListeners</a> in the <i>Elastic Load Balancing API Reference</i>.</p> </important>', 'DeleteServiceSpecificCredential' => '<p>Deletes the specified service-specific credential.</p>', 'DeleteSigningCertificate' => '<p>Deletes a signing certificate associated with the specified IAM user.</p> <p>If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing the request. Because this action works for access keys under the AWS account, you can use this action to manage root credentials even if the AWS account has no associated IAM users.</p>', 'DeleteUser' => '<p>Deletes the specified IAM user. The user must not belong to any groups or have any access keys, signing certificates, or attached policies.</p>', 'DeleteUserPolicy' => '<p>Deletes the specified inline policy that is embedded in the specified IAM user.</p> <p>A user can also have managed policies attached to it. To detach a managed policy from a user, use <a>DetachUserPolicy</a>. For more information about policies, refer to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'DeleteVirtualMFADevice' => '<p>Deletes a virtual MFA device.</p> <note> <p> You must deactivate a user\'s virtual MFA device before you can delete it. For information about deactivating MFA devices, see <a>DeactivateMFADevice</a>. </p> </note>', 'DetachGroupPolicy' => '<p>Removes the specified managed policy from the specified IAM group.</p> <p>A group can also have inline policies embedded with it. To delete an inline policy, use the <a>DeleteGroupPolicy</a> API. For information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'DetachRolePolicy' => '<p>Removes the specified managed policy from the specified role.</p> <p>A role can also have inline policies embedded with it. To delete an inline policy, use the <a>DeleteRolePolicy</a> API. For information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'DetachUserPolicy' => '<p>Removes the specified managed policy from the specified user.</p> <p>A user can also have inline policies embedded with it. To delete an inline policy, use the <a>DeleteUserPolicy</a> API. For information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'EnableMFADevice' => '<p>Enables the specified MFA device and associates it with the specified IAM user. When enabled, the MFA device is required for every subsequent login by the IAM user associated with the device.</p>', 'GenerateCredentialReport' => '<p> Generates a credential report for the AWS account. For more information about the credential report, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting Credential Reports</a> in the <i>IAM User Guide</i>.</p>', 'GetAccessKeyLastUsed' => '<p>Retrieves information about when the specified access key was last used. The information includes the date and time of last use, along with the AWS service and region that were specified in the last request made with that key.</p>', 'GetAccountAuthorizationDetails' => '<p>Retrieves information about all IAM users, groups, roles, and policies in your AWS account, including their relationships to one another. Use this API to obtain a snapshot of the configuration of IAM permissions (users, groups, roles, and policies) in your account.</p> <p>You can optionally filter the results using the <code>Filter</code> parameter. You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>', 'GetAccountPasswordPolicy' => '<p>Retrieves the password policy for the AWS account. For more information about using a password policy, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM Password Policy</a>.</p>', 'GetAccountSummary' => '<p>Retrieves information about IAM entity usage and IAM quotas in the AWS account.</p> <p> For information about limitations on IAM entities, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html">Limitations on IAM Entities</a> in the <i>IAM User Guide</i>.</p>', 'GetContextKeysForCustomPolicy' => '<p>Gets a list of all of the context keys referenced in the input policies. The policies are supplied as a list of one or more strings. To get the context keys from policies associated with an IAM user, group, or role, use <a>GetContextKeysForPrincipalPolicy</a>.</p> <p>Context keys are variables maintained by AWS and its services that provide details about the context of an API query request, and can be evaluated by testing against a value specified in an IAM policy. Use GetContextKeysForCustomPolicy to understand what key names and values you must supply when you call <a>SimulateCustomPolicy</a>. Note that all parameters are shown in unencoded form here for clarity, but must be URL encoded to be included as a part of a real HTML request.</p>', 'GetContextKeysForPrincipalPolicy' => '<p>Gets a list of all of the context keys referenced in all of the IAM policies attached to the specified IAM entity. The entity can be an IAM user, group, or role. If you specify a user, then the request also includes all of the policies attached to groups that the user is a member of.</p> <p>You can optionally include a list of one or more additional policies, specified as strings. If you want to include <i>only</i> a list of policies by string, use <a>GetContextKeysForCustomPolicy</a> instead.</p> <p> <b>Note:</b> This API discloses information about the permissions granted to other users. If you do not want users to see other user\'s permissions, then consider allowing them to use <a>GetContextKeysForCustomPolicy</a> instead.</p> <p>Context keys are variables maintained by AWS and its services that provide details about the context of an API query request, and can be evaluated by testing against a value in an IAM policy. Use <a>GetContextKeysForPrincipalPolicy</a> to understand what key names and values you must supply when you call <a>SimulatePrincipalPolicy</a>.</p>', 'GetCredentialReport' => '<p> Retrieves a credential report for the AWS account. For more information about the credential report, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting Credential Reports</a> in the <i>IAM User Guide</i>.</p>', 'GetGroup' => '<p> Returns a list of IAM users that are in the specified IAM group. You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>', 'GetGroupPolicy' => '<p>Retrieves the specified inline policy document that is embedded in the specified IAM group.</p> <note> <p>Policies returned by this API are URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar functionality.</p> </note> <p>An IAM group can also have managed policies attached to it. To retrieve a managed policy document that is attached to a group, use <a>GetPolicy</a> to determine the policy\'s default version, then use <a>GetPolicyVersion</a> to retrieve the policy document.</p> <p>For more information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'GetInstanceProfile' => '<p> Retrieves information about the specified instance profile, including the instance profile\'s path, GUID, ARN, and role. For more information about instance profiles, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a> in the <i>IAM User Guide</i>.</p>', 'GetLoginProfile' => '<p>Retrieves the user name and password-creation date for the specified IAM user. If the user has not been assigned a password, the action returns a 404 (<code>NoSuchEntity</code>) error.</p>', 'GetOpenIDConnectProvider' => '<p>Returns information about the specified OpenID Connect (OIDC) provider resource object in IAM.</p>', 'GetPolicy' => '<p>Retrieves information about the specified managed policy, including the policy\'s default version and the total number of IAM users, groups, and roles to which the policy is attached. To retrieve the list of the specific users, groups, and roles that the policy is attached to, use the <a>ListEntitiesForPolicy</a> API. This API returns metadata about the policy. To retrieve the actual policy document for a specific version of the policy, use <a>GetPolicyVersion</a>.</p> <p>This API retrieves information about managed policies. To retrieve information about an inline policy that is embedded with an IAM user, group, or role, use the <a>GetUserPolicy</a>, <a>GetGroupPolicy</a>, or <a>GetRolePolicy</a> API.</p> <p>For more information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'GetPolicyVersion' => '<p>Retrieves information about the specified version of the specified managed policy, including the policy document.</p> <note> <p>Policies returned by this API are URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar functionality.</p> </note> <p>To list the available versions for a policy, use <a>ListPolicyVersions</a>.</p> <p>This API retrieves information about managed policies. To retrieve information about an inline policy that is embedded in a user, group, or role, use the <a>GetUserPolicy</a>, <a>GetGroupPolicy</a>, or <a>GetRolePolicy</a> API.</p> <p>For more information about the types of policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p> <p>For more information about managed policy versions, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for Managed Policies</a> in the <i>IAM User Guide</i>.</p>', 'GetRole' => '<p>Retrieves information about the specified role, including the role\'s path, GUID, ARN, and the role\'s trust policy that grants permission to assume the role. For more information about roles, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with Roles</a>.</p> <note> <p>Policies returned by this API are URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar functionality.</p> </note>', 'GetRolePolicy' => '<p>Retrieves the specified inline policy document that is embedded with the specified IAM role.</p> <note> <p>Policies returned by this API are URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar functionality.</p> </note> <p>An IAM role can also have managed policies attached to it. To retrieve a managed policy document that is attached to a role, use <a>GetPolicy</a> to determine the policy\'s default version, then use <a>GetPolicyVersion</a> to retrieve the policy document.</p> <p>For more information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p> <p>For more information about roles, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using Roles to Delegate Permissions and Federate Identities</a>.</p>', 'GetSAMLProvider' => '<p>Returns the SAML provider metadocument that was uploaded when the IAM SAML provider resource object was created or updated.</p> <note> <p>This operation requires <a href="http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p> </note>', 'GetSSHPublicKey' => '<p>Retrieves the specified SSH public key, including metadata about the key.</p> <p>The SSH public key retrieved by this action is used only for authenticating the associated IAM user to an AWS CodeCommit repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository, see <a href="http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS CodeCommit for SSH Connections</a> in the <i>AWS CodeCommit User Guide</i>.</p>', 'GetServerCertificate' => '<p>Retrieves information about the specified server certificate stored in IAM.</p> <p>For more information about working with server certificates, including a list of AWS services that can use the server certificates that you manage with IAM, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with Server Certificates</a> in the <i>IAM User Guide</i>.</p>', 'GetUser' => '<p>Retrieves information about the specified IAM user, including the user\'s creation date, path, unique ID, and ARN.</p> <p>If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID used to sign the request to this API.</p>', 'GetUserPolicy' => '<p>Retrieves the specified inline policy document that is embedded in the specified IAM user.</p> <note> <p>Policies returned by this API are URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar functionality.</p> </note> <p>An IAM user can also have managed policies attached to it. To retrieve a managed policy document that is attached to a user, use <a>GetPolicy</a> to determine the policy\'s default version, then use <a>GetPolicyVersion</a> to retrieve the policy document.</p> <p>For more information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'ListAccessKeys' => '<p>Returns information about the access key IDs associated with the specified IAM user. If there are none, the action returns an empty list.</p> <p>Although each user is limited to a small number of keys, you can still paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p> <p>If the <code>UserName</code> field is not specified, the UserName is determined implicitly based on the AWS access key ID used to sign the request. Because this action works for access keys under the AWS account, you can use this action to manage root credentials even if the AWS account has no associated users.</p> <note> <p>To ensure the security of your AWS account, the secret access key is accessible only during key and user creation.</p> </note>', 'ListAccountAliases' => '<p>Lists the account alias associated with the AWS account (Note: you can have only one). For information about using an AWS account alias, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an Alias for Your AWS Account ID</a> in the <i>IAM User Guide</i>.</p>', 'ListAttachedGroupPolicies' => '<p>Lists all managed policies that are attached to the specified IAM group.</p> <p>An IAM group can also have inline policies embedded with it. To list the inline policies for a group, use the <a>ListGroupPolicies</a> API. For information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix. If there are no policies attached to the specified group (or none that match the specified path prefix), the action returns an empty list.</p>', 'ListAttachedRolePolicies' => '<p>Lists all managed policies that are attached to the specified IAM role.</p> <p>An IAM role can also have inline policies embedded with it. To list the inline policies for a role, use the <a>ListRolePolicies</a> API. For information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix. If there are no policies attached to the specified role (or none that match the specified path prefix), the action returns an empty list.</p>', 'ListAttachedUserPolicies' => '<p>Lists all managed policies that are attached to the specified IAM user.</p> <p>An IAM user can also have inline policies embedded with it. To list the inline policies for a user, use the <a>ListUserPolicies</a> API. For information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix. If there are no policies attached to the specified group (or none that match the specified path prefix), the action returns an empty list.</p>', 'ListEntitiesForPolicy' => '<p>Lists all IAM users, groups, and roles that the specified managed policy is attached to.</p> <p>You can use the optional <code>EntityFilter</code> parameter to limit the results to a particular type of entity (users, groups, or roles). For example, to list only the roles that are attached to the specified policy, set <code>EntityFilter</code> to <code>Role</code>.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>', 'ListGroupPolicies' => '<p>Lists the names of the inline policies that are embedded in the specified IAM group.</p> <p>An IAM group can also have managed policies attached to it. To list the managed policies that are attached to a group, use <a>ListAttachedGroupPolicies</a>. For more information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no inline policies embedded with the specified group, the action returns an empty list.</p>', 'ListGroups' => '<p>Lists the IAM groups that have the specified path prefix.</p> <p> You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>', 'ListGroupsForUser' => '<p>Lists the IAM groups that the specified IAM user belongs to.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>', 'ListInstanceProfiles' => '<p>Lists the instance profiles that have the specified path prefix. If there are none, the action returns an empty list. For more information about instance profiles, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>', 'ListInstanceProfilesForRole' => '<p>Lists the instance profiles that have the specified associated IAM role. If there are none, the action returns an empty list. For more information about instance profiles, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>', 'ListMFADevices' => '<p>Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this action lists all the MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing the request for this API.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>', 'ListOpenIDConnectProviders' => '<p>Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in the AWS account.</p>', 'ListPolicies' => '<p>Lists all the managed policies that are available in your AWS account, including your own customer-defined managed policies and all AWS managed policies.</p> <p>You can filter the list of policies that is returned using the optional <code>OnlyAttached</code>, <code>Scope</code>, and <code>PathPrefix</code> parameters. For example, to list only the customer managed policies in your AWS account, set <code>Scope</code> to <code>Local</code>. To list only AWS managed policies, set <code>Scope</code> to <code>AWS</code>.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p> <p>For more information about managed policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'ListPolicyVersions' => '<p>Lists information about the versions of the specified managed policy, including the version that is currently set as the policy\'s default version.</p> <p>For more information about managed policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'ListRolePolicies' => '<p>Lists the names of the inline policies that are embedded in the specified IAM role.</p> <p>An IAM role can also have managed policies attached to it. To list the managed policies that are attached to a role, use <a>ListAttachedRolePolicies</a>. For more information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no inline policies embedded with the specified role, the action returns an empty list.</p>', 'ListRoles' => '<p>Lists the IAM roles that have the specified path prefix. If there are none, the action returns an empty list. For more information about roles, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with Roles</a>.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>', 'ListSAMLProviders' => '<p>Lists the SAML provider resource objects defined in IAM in the account.</p> <note> <p> This operation requires <a href="http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p> </note>', 'ListSSHPublicKeys' => '<p>Returns information about the SSH public keys associated with the specified IAM user. If there are none, the action returns an empty list.</p> <p>The SSH public keys returned by this action are used only for authenticating the IAM user to an AWS CodeCommit repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository, see <a href="http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS CodeCommit for SSH Connections</a> in the <i>AWS CodeCommit User Guide</i>.</p> <p>Although each user is limited to a small number of keys, you can still paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>', 'ListServerCertificates' => '<p>Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the action returns an empty list.</p> <p> You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p> <p>For more information about working with server certificates, including a list of AWS services that can use the server certificates that you manage with IAM, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with Server Certificates</a> in the <i>IAM User Guide</i>.</p>', 'ListServiceSpecificCredentials' => '<p>Returns information about the service-specific credentials associated with the specified IAM user. If there are none, the action returns an empty list. The service-specific credentials returned by this action are used only for authenticating the IAM user to a specific service. For more information about using service-specific credentials to authenticate to an AWS service, see <a href="http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html">Set Up service-specific credentials</a> in the AWS CodeCommit User Guide.</p>', 'ListSigningCertificates' => '<p>Returns information about the signing certificates associated with the specified IAM user. If there are none, the action returns an empty list.</p> <p>Although each user is limited to a small number of signing certificates, you can still paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p> <p>If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS access key ID used to sign the request for this API. Because this action works for access keys under the AWS account, you can use this action to manage root credentials even if the AWS account has no associated users.</p>', 'ListUserPolicies' => '<p>Lists the names of the inline policies embedded in the specified IAM user.</p> <p>An IAM user can also have managed policies attached to it. To list the managed policies that are attached to a user, use <a>ListAttachedUserPolicies</a>. For more information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no inline policies embedded with the specified user, the action returns an empty list.</p>', 'ListUsers' => '<p>Lists the IAM users that have the specified path prefix. If no path prefix is specified, the action returns all users in the AWS account. If there are none, the action returns an empty list.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>', 'ListVirtualMFADevices' => '<p>Lists the virtual MFA devices defined in the AWS account by assignment status. If you do not specify an assignment status, the action returns a list of all virtual MFA devices. Assignment status can be <code>Assigned</code>, <code>Unassigned</code>, or <code>Any</code>.</p> <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>', 'PutGroupPolicy' => '<p>Adds or updates an inline policy document that is embedded in the specified IAM group.</p> <p>A user can also have managed policies attached to it. To attach a managed policy to a group, use <a>AttachGroupPolicy</a>. To create a new managed policy, use <a>CreatePolicy</a>. For information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p> <p>For information about limits on the number of inline policies that you can embed in a group, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html">Limitations on IAM Entities</a> in the <i>IAM User Guide</i>.</p> <note> <p>Because policy documents can be large, you should use POST rather than GET when calling <code>PutGroupPolicy</code>. For general information about using the Query API with IAM, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making Query Requests</a> in the <i>IAM User Guide</i>.</p> </note>', 'PutRolePolicy' => '<p>Adds or updates an inline policy document that is embedded in the specified IAM role.</p> <p>When you embed an inline policy in a role, the inline policy is used as part of the role\'s access (permissions) policy. The role\'s trust policy is created at the same time as the role, using <a>CreateRole</a>. You can update a role\'s trust policy using <a>UpdateAssumeRolePolicy</a>. For more information about IAM roles, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using Roles to Delegate Permissions and Federate Identities</a>.</p> <p>A role can also have a managed policy attached to it. To attach a managed policy to a role, use <a>AttachRolePolicy</a>. To create a new managed policy, use <a>CreatePolicy</a>. For information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p> <p>For information about limits on the number of inline policies that you can embed with a role, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html">Limitations on IAM Entities</a> in the <i>IAM User Guide</i>.</p> <note> <p>Because policy documents can be large, you should use POST rather than GET when calling <code>PutRolePolicy</code>. For general information about using the Query API with IAM, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making Query Requests</a> in the <i>IAM User Guide</i>.</p> </note>', 'PutUserPolicy' => '<p>Adds or updates an inline policy document that is embedded in the specified IAM user.</p> <p>An IAM user can also have a managed policy attached to it. To attach a managed policy to a user, use <a>AttachUserPolicy</a>. To create a new managed policy, use <a>CreatePolicy</a>. For information about policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p> <p>For information about limits on the number of inline policies that you can embed in a user, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html">Limitations on IAM Entities</a> in the <i>IAM User Guide</i>.</p> <note> <p>Because policy documents can be large, you should use POST rather than GET when calling <code>PutUserPolicy</code>. For general information about using the Query API with IAM, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making Query Requests</a> in the <i>IAM User Guide</i>.</p> </note>', 'RemoveClientIDFromOpenIDConnectProvider' => '<p>Removes the specified client ID (also known as audience) from the list of client IDs registered for the specified IAM OpenID Connect (OIDC) provider resource object.</p> <p>This action is idempotent; it does not fail or return an error if you try to remove a client ID that does not exist.</p>', 'RemoveRoleFromInstanceProfile' => '<p>Removes the specified IAM role from the specified EC2 instance profile.</p> <important> <p>Make sure you do not have any Amazon EC2 instances running with the role you are about to remove from the instance profile. Removing a role from an instance profile that is associated with a running instance might break any applications running on the instance.</p> </important> <p> For more information about IAM roles, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with Roles</a>. For more information about instance profiles, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.</p>', 'RemoveUserFromGroup' => '<p>Removes the specified user from the specified group.</p>', 'ResetServiceSpecificCredential' => '<p>Resets the password for a service-specific credential. The new password is AWS generated and cryptographically strong. It cannot be configured by the user. Resetting the password immediately invalidates the previous password associated with this user.</p>', 'ResyncMFADevice' => '<p>Synchronizes the specified MFA device with its IAM resource object on the AWS servers.</p> <p>For more information about creating and working with virtual MFA devices, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a Virtual MFA Device</a> in the <i>IAM User Guide</i>.</p>', 'SetDefaultPolicyVersion' => '<p>Sets the specified version of the specified policy as the policy\'s default (operative) version.</p> <p>This action affects all users, groups, and roles that the policy is attached to. To list the users, groups, and roles that the policy is attached to, use the <a>ListEntitiesForPolicy</a> API.</p> <p>For information about managed policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>IAM User Guide</i>.</p>', 'SimulateCustomPolicy' => '<p>Simulate how a set of IAM policies and optionally a resource-based policy works with a list of API actions and AWS resources to determine the policies\' effective permissions. The policies are provided as strings.</p> <p>The simulation does not perform the API actions; it only checks the authorization to determine if the simulated policies allow or deny the actions.</p> <p>If you want to simulate existing policies attached to an IAM user, group, or role, use <a>SimulatePrincipalPolicy</a> instead.</p> <p>Context keys are variables maintained by AWS and its services that provide details about the context of an API query request. You can use the <code>Condition</code> element of an IAM policy to evaluate context keys. To get the list of context keys that the policies require for correct simulation, use <a>GetContextKeysForCustomPolicy</a>.</p> <p>If the output is long, you can use <code>MaxItems</code> and <code>Marker</code> parameters to paginate the results.</p>', 'SimulatePrincipalPolicy' => '<p>Simulate how a set of IAM policies attached to an IAM entity works with a list of API actions and AWS resources to determine the policies\' effective permissions. The entity can be an IAM user, group, or role. If you specify a user, then the simulation also includes all of the policies that are attached to groups that the user belongs to .</p> <p>You can optionally include a list of one or more additional policies specified as strings to include in the simulation. If you want to simulate only policies specified as strings, use <a>SimulateCustomPolicy</a> instead.</p> <p>You can also optionally include one resource-based policy to be evaluated with each of the resources included in the simulation.</p> <p>The simulation does not perform the API actions, it only checks the authorization to determine if the simulated policies allow or deny the actions.</p> <p> <b>Note:</b> This API discloses information about the permissions granted to other users. If you do not want users to see other user\'s permissions, then consider allowing them to use <a>SimulateCustomPolicy</a> instead.</p> <p>Context keys are variables maintained by AWS and its services that provide details about the context of an API query request. You can use the <code>Condition</code> element of an IAM policy to evaluate context keys. To get the list of context keys that the policies require for correct simulation, use <a>GetContextKeysForPrincipalPolicy</a>.</p> <p>If the output is long, you can use the <code>MaxItems</code> and <code>Marker</code> parameters to paginate the results.</p>', 'UpdateAccessKey' => '<p>Changes the status of the specified access key from Active to Inactive, or vice versa. This action can be used to disable a user\'s key as part of a key rotation work flow.</p> <p>If the <code>UserName</code> field is not specified, the UserName is determined implicitly based on the AWS access key ID used to sign the request. Because this action works for access keys under the AWS account, you can use this action to manage root credentials even if the AWS account has no associated users.</p> <p>For information about rotating keys, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/ManagingCredentials.html">Managing Keys and Certificates</a> in the <i>IAM User Guide</i>.</p>', 'UpdateAccountPasswordPolicy' => '<p>Updates the password policy settings for the AWS account.</p> <note> <p>This action does not support partial updates. No parameters are required, but if you do not specify a parameter, that parameter\'s value reverts to its default value. See the <b>Request Parameters</b> section for each parameter\'s default value.</p> </note> <p> For more information about using a password policy, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM Password Policy</a> in the <i>IAM User Guide</i>.</p>', 'UpdateAssumeRolePolicy' => '<p>Updates the policy that grants an IAM entity permission to assume a role. This is typically referred to as the "role trust policy". For more information about roles, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using Roles to Delegate Permissions and Federate Identities</a>.</p>', 'UpdateGroup' => '<p>Updates the name and/or the path of the specified IAM group.</p> <important> <p> You should understand the implications of changing a group\'s path or name. For more information, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_WorkingWithGroupsAndUsers.html">Renaming Users and Groups</a> in the <i>IAM User Guide</i>.</p> </important> <note> <p>To change an IAM group name the requester must have appropriate permissions on both the source object and the target object. For example, to change "Managers" to "MGRs", the entity making the request must have permission on both "Managers" and "MGRs", or must have permission on all (*). For more information about permissions, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html">Permissions and Policies</a>. </p> </note>', 'UpdateLoginProfile' => '<p>Changes the password for the specified IAM user.</p> <p>IAM users can change their own passwords by calling <a>ChangePassword</a>. For more information about modifying passwords, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing Passwords</a> in the <i>IAM User Guide</i>.</p>', 'UpdateOpenIDConnectProviderThumbprint' => '<p>Replaces the existing list of server certificate thumbprints associated with an OpenID Connect (OIDC) provider resource object with a new list of thumbprints.</p> <p>The list that you pass with this action completely replaces the existing list of thumbprints. (The lists are not merged.)</p> <p>Typically, you need to update a thumbprint only when the identity provider\'s certificate changes, which occurs rarely. However, if the provider\'s certificate <i>does</i> change, any attempt to assume an IAM role that specifies the OIDC provider as a principal fails until the certificate thumbprint is updated.</p> <note> <p>Because trust for the OIDC provider is ultimately derived from the provider\'s certificate and is validated by the thumbprint, it is a best practice to limit access to the <code>UpdateOpenIDConnectProviderThumbprint</code> action to highly-privileged users.</p> </note>', 'UpdateRoleDescription' => '<p>Modifies the description of a role.</p>', 'UpdateSAMLProvider' => '<p>Updates the metadata document for an existing SAML provider resource object.</p> <note> <p>This operation requires <a href="http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p> </note>', 'UpdateSSHPublicKey' => '<p>Sets the status of an IAM user\'s SSH public key to active or inactive. SSH public keys that are inactive cannot be used for authentication. This action can be used to disable a user\'s SSH public key as part of a key rotation work flow.</p> <p>The SSH public key affected by this action is used only for authenticating the associated IAM user to an AWS CodeCommit repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository, see <a href="http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS CodeCommit for SSH Connections</a> in the <i>AWS CodeCommit User Guide</i>.</p>', 'UpdateServerCertificate' => '<p>Updates the name and/or the path of the specified server certificate stored in IAM.</p> <p>For more information about working with server certificates, including a list of AWS services that can use the server certificates that you manage with IAM, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with Server Certificates</a> in the <i>IAM User Guide</i>.</p> <important> <p>You should understand the implications of changing a server certificate\'s path or name. For more information, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs_manage.html#RenamingServerCerts">Renaming a Server Certificate</a> in the <i>IAM User Guide</i>.</p> </important> <note> <p>To change a server certificate name the requester must have appropriate permissions on both the source object and the target object. For example, to change the name from "ProductionCert" to "ProdCert", the entity making the request must have permission on "ProductionCert" and "ProdCert", or must have permission on all (*). For more information about permissions, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>.</p> </note>', 'UpdateServiceSpecificCredential' => '<p>Sets the status of a service-specific credential to <code>Active</code> or <code>Inactive</code>. Service-specific credentials that are inactive cannot be used for authentication to the service. This action can be used to disable a user’s service-specific credential as part of a credential rotation work flow.</p>', 'UpdateSigningCertificate' => '<p>Changes the status of the specified user signing certificate from active to disabled, or vice versa. This action can be used to disable an IAM user\'s signing certificate as part of a certificate rotation work flow.</p> <p>If the <code>UserName</code> field is not specified, the UserName is determined implicitly based on the AWS access key ID used to sign the request. Because this action works for access keys under the AWS account, you can use this action to manage root credentials even if the AWS account has no associated users.</p>', 'UpdateUser' => '<p>Updates the name and/or the path of the specified IAM user.</p> <important> <p> You should understand the implications of changing an IAM user\'s path or name. For more information, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_renaming">Renaming an IAM User</a> and <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_rename.html">Renaming an IAM Group</a> in the <i>IAM User Guide</i>.</p> </important> <note> <p> To change a user name the requester must have appropriate permissions on both the source object and the target object. For example, to change Bob to Robert, the entity making the request must have permission on Bob and Robert, or must have permission on all (*). For more information about permissions, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html">Permissions and Policies</a>. </p> </note>', 'UploadSSHPublicKey' => '<p>Uploads an SSH public key and associates it with the specified IAM user.</p> <p>The SSH public key uploaded by this action can be used only for authenticating the associated IAM user to an AWS CodeCommit repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository, see <a href="http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS CodeCommit for SSH Connections</a> in the <i>AWS CodeCommit User Guide</i>.</p>', 'UploadServerCertificate' => '<p>Uploads a server certificate entity for the AWS account. The server certificate entity includes a public key certificate, a private key, and an optional certificate chain, which should all be PEM-encoded.</p> <p>We recommend that you use <a href="https://aws.amazon.com/certificate-manager/">AWS Certificate Manager</a> to provision, manage, and deploy your server certificates. With ACM you can request a certificate, deploy it to AWS resources, and let ACM handle certificate renewals for you. Certificates provided by ACM are free. For more information about using ACM, see the <a href="http://docs.aws.amazon.com/acm/latest/userguide/">AWS Certificate Manager User Guide</a>.</p> <p>For more information about working with server certificates, including a list of AWS services that can use the server certificates that you manage with IAM, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with Server Certificates</a> in the <i>IAM User Guide</i>.</p> <p>For information about the number of server certificates you can upload, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-limits.html">Limitations on IAM Entities and Objects</a> in the <i>IAM User Guide</i>.</p> <note> <p>Because the body of the public key certificate, private key, and the certificate chain can be large, you should use POST rather than GET when calling <code>UploadServerCertificate</code>. For information about setting up signatures and authorization through the API, go to <a href="http://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html">Signing AWS API Requests</a> in the <i>AWS General Reference</i>. For general information about using the Query API with IAM, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/programming.html">Calling the API by Making HTTP Query Requests</a> in the <i>IAM User Guide</i>.</p> </note>', 'UploadSigningCertificate' => '<p>Uploads an X.509 signing certificate and associates it with the specified IAM user. Some AWS services use X.509 signing certificates to validate requests that are signed with a corresponding private key. When you upload the certificate, its default status is <code>Active</code>.</p> <p>If the <code>UserName</code> field is not specified, the IAM user name is determined implicitly based on the AWS access key ID used to sign the request. Because this action works for access keys under the AWS account, you can use this action to manage root credentials even if the AWS account has no associated users.</p> <note> <p>Because the body of a X.509 certificate can be large, you should use POST rather than GET when calling <code>UploadSigningCertificate</code>. For information about setting up signatures and authorization through the API, go to <a href="http://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html">Signing AWS API Requests</a> in the <i>AWS General Reference</i>. For general information about using the Query API with IAM, go to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making Query Requests</a> in the <i>IAM User Guide</i>.</p> </note>', ], 'shapes' => [ 'AccessKey' => [ 'base' => '<p>Contains information about an AWS access key.</p> <p> This data type is used as a response element in the <a>CreateAccessKey</a> and <a>ListAccessKeys</a> actions. </p> <note> <p>The <code>SecretAccessKey</code> value is returned only in response to <a>CreateAccessKey</a>. You can get a secret access key only when you first create an access key; you cannot recover the secret access key later. If you lose a secret access key, you must create a new access key.</p> </note>', 'refs' => [ 'CreateAccessKeyResponse$AccessKey' => '<p>A structure with details about the access key.</p>', ], ], 'AccessKeyLastUsed' => [ 'base' => '<p>Contains information about the last time an AWS access key was used.</p> <p>This data type is used as a response element in the <a>GetAccessKeyLastUsed</a> action.</p>', 'refs' => [ 'GetAccessKeyLastUsedResponse$AccessKeyLastUsed' => '<p>Contains information about the last time the access key was used.</p>', ], ], 'AccessKeyMetadata' => [ 'base' => '<p>Contains information about an AWS access key, without its secret key.</p> <p>This data type is used as a response element in the <a>ListAccessKeys</a> action.</p>', 'refs' => [ 'accessKeyMetadataListType$member' => NULL, ], ], 'ActionNameListType' => [ 'base' => NULL, 'refs' => [ 'SimulateCustomPolicyRequest$ActionNames' => '<p>A list of names of API actions to evaluate in the simulation. Each action is evaluated against each resource. Each action must include the service identifier, such as <code>iam:CreateUser</code>.</p>', 'SimulatePrincipalPolicyRequest$ActionNames' => '<p>A list of names of API actions to evaluate in the simulation. Each action is evaluated for each resource. Each action must include the service identifier, such as <code>iam:CreateUser</code>.</p>', ], ], 'ActionNameType' => [ 'base' => NULL, 'refs' => [ 'ActionNameListType$member' => NULL, 'EvaluationResult$EvalActionName' => '<p>The name of the API action tested on the indicated resource.</p>', ], ], 'AddClientIDToOpenIDConnectProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddRoleToInstanceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddUserToGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachGroupPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachRolePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachUserPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachedPolicy' => [ 'base' => '<p>Contains information about an attached policy.</p> <p>An attached policy is a managed policy that has been attached to a user, group, or role. This data type is used as a response element in the <a>ListAttachedGroupPolicies</a>, <a>ListAttachedRolePolicies</a>, <a>ListAttachedUserPolicies</a>, and <a>GetAccountAuthorizationDetails</a> actions. </p> <p>For more information about managed policies, refer to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>Using IAM</i> guide. </p>', 'refs' => [ 'attachedPoliciesListType$member' => NULL, ], ], 'BootstrapDatum' => [ 'base' => NULL, 'refs' => [ 'VirtualMFADevice$Base32StringSeed' => '<p> The Base32 seed defined as specified in <a href="https://tools.ietf.org/html/rfc3548.txt">RFC3548</a>. The <code>Base32StringSeed</code> is Base64-encoded. </p>', 'VirtualMFADevice$QRCodePNG' => '<p> A QR code PNG image that encodes <code>otpauth://totp/$virtualMFADeviceName@$AccountName?secret=$Base32String</code> where <code>$virtualMFADeviceName</code> is one of the create call arguments, <code>AccountName</code> is the user name if set (otherwise, the account ID otherwise), and <code>Base32String</code> is the seed in Base32 format. The <code>Base32String</code> value is Base64-encoded. </p>', ], ], 'ChangePasswordRequest' => [ 'base' => NULL, 'refs' => [], ], 'ColumnNumber' => [ 'base' => NULL, 'refs' => [ 'Position$Column' => '<p>The column in the line containing the specified position in the document.</p>', ], ], 'ContextEntry' => [ 'base' => '<p>Contains information about a condition context key. It includes the name of the key and specifies the value (or values, if the context key supports multiple values) to use in the simulation. This information is used when evaluating the <code>Condition</code> elements of the input policies.</p> <p>This data type is used as an input parameter to <code> <a>SimulateCustomPolicy</a> </code> and <code> <a>SimulateCustomPolicy</a> </code>.</p>', 'refs' => [ 'ContextEntryListType$member' => NULL, ], ], 'ContextEntryListType' => [ 'base' => NULL, 'refs' => [ 'SimulateCustomPolicyRequest$ContextEntries' => '<p>A list of context keys and corresponding values for the simulation to use. Whenever a context key is evaluated in one of the simulated IAM permission policies, the corresponding value is supplied.</p>', 'SimulatePrincipalPolicyRequest$ContextEntries' => '<p>A list of context keys and corresponding values for the simulation to use. Whenever a context key is evaluated in one of the simulated IAM permission policies, the corresponding value is supplied.</p>', ], ], 'ContextKeyNameType' => [ 'base' => NULL, 'refs' => [ 'ContextEntry$ContextKeyName' => '<p>The full name of a condition context key, including the service prefix. For example, <code>aws:SourceIp</code> or <code>s3:VersionId</code>.</p>', 'ContextKeyNamesResultListType$member' => NULL, ], ], 'ContextKeyNamesResultListType' => [ 'base' => NULL, 'refs' => [ 'EvaluationResult$MissingContextValues' => '<p>A list of context keys that are required by the included input policies but that were not provided by one of the input parameters. This list is used when the resource in a simulation is "*", either explicitly, or when the <code>ResourceArns</code> parameter blank. If you include a list of resources, then any missing context values are instead included under the <code>ResourceSpecificResults</code> section. To discover the context keys used by a set of policies, you can call <a>GetContextKeysForCustomPolicy</a> or <a>GetContextKeysForPrincipalPolicy</a>.</p>', 'GetContextKeysForPolicyResponse$ContextKeyNames' => '<p>The list of context keys that are referenced in the input policies.</p>', 'ResourceSpecificResult$MissingContextValues' => '<p>A list of context keys that are required by the included input policies but that were not provided by one of the input parameters. This list is used when a list of ARNs is included in the <code>ResourceArns</code> parameter instead of "*". If you do not specify individual resources, by setting <code>ResourceArns</code> to "*" or by not including the <code>ResourceArns</code> parameter, then any missing context values are instead included under the <code>EvaluationResults</code> section. To discover the context keys used by a set of policies, you can call <a>GetContextKeysForCustomPolicy</a> or <a>GetContextKeysForPrincipalPolicy</a>.</p>', ], ], 'ContextKeyTypeEnum' => [ 'base' => NULL, 'refs' => [ 'ContextEntry$ContextKeyType' => '<p>The data type of the value (or values) specified in the <code>ContextKeyValues</code> parameter.</p>', ], ], 'ContextKeyValueListType' => [ 'base' => NULL, 'refs' => [ 'ContextEntry$ContextKeyValues' => '<p>The value (or values, if the condition context key supports multiple values) to provide to the simulation for use when the key is referenced by a <code>Condition</code> element in an input policy.</p>', ], ], 'ContextKeyValueType' => [ 'base' => NULL, 'refs' => [ 'ContextKeyValueListType$member' => NULL, ], ], 'CreateAccessKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessKeyResponse' => [ 'base' => '<p>Contains the response to a successful <a>CreateAccessKey</a> request. </p>', 'refs' => [], ], 'CreateAccountAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupResponse' => [ 'base' => '<p>Contains the response to a successful <a>CreateGroup</a> request. </p>', 'refs' => [], ], 'CreateInstanceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceProfileResponse' => [ 'base' => '<p>Contains the response to a successful <a>CreateInstanceProfile</a> request. </p>', 'refs' => [], ], 'CreateLoginProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLoginProfileResponse' => [ 'base' => '<p>Contains the response to a successful <a>CreateLoginProfile</a> request. </p>', 'refs' => [], ], 'CreateOpenIDConnectProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOpenIDConnectProviderResponse' => [ 'base' => '<p>Contains the response to a successful <a>CreateOpenIDConnectProvider</a> request. </p>', 'refs' => [], ], 'CreatePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePolicyResponse' => [ 'base' => '<p>Contains the response to a successful <a>CreatePolicy</a> request. </p>', 'refs' => [], ], 'CreatePolicyVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePolicyVersionResponse' => [ 'base' => '<p>Contains the response to a successful <a>CreatePolicyVersion</a> request. </p>', 'refs' => [], ], 'CreateRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoleResponse' => [ 'base' => '<p>Contains the response to a successful <a>CreateRole</a> request. </p>', 'refs' => [], ], 'CreateSAMLProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSAMLProviderResponse' => [ 'base' => '<p>Contains the response to a successful <a>CreateSAMLProvider</a> request. </p>', 'refs' => [], ], 'CreateServiceLinkedRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceLinkedRoleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceSpecificCredentialRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceSpecificCredentialResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserResponse' => [ 'base' => '<p>Contains the response to a successful <a>CreateUser</a> request. </p>', 'refs' => [], ], 'CreateVirtualMFADeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVirtualMFADeviceResponse' => [ 'base' => '<p>Contains the response to a successful <a>CreateVirtualMFADevice</a> request. </p>', 'refs' => [], ], 'CredentialReportExpiredException' => [ 'base' => '<p>The request was rejected because the most recent credential report has expired. To generate a new credential report, use <a>GenerateCredentialReport</a>. For more information about credential report expiration, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting Credential Reports</a> in the <i>IAM User Guide</i>.</p>', 'refs' => [], ], 'CredentialReportNotPresentException' => [ 'base' => '<p>The request was rejected because the credential report does not exist. To generate a credential report, use <a>GenerateCredentialReport</a>.</p>', 'refs' => [], ], 'CredentialReportNotReadyException' => [ 'base' => '<p>The request was rejected because the credential report is still being generated.</p>', 'refs' => [], ], 'DeactivateMFADeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccountAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConflictException' => [ 'base' => '<p>The request was rejected because it attempted to delete a resource that has attached subordinate entities. The error message describes these entities.</p>', 'refs' => [], ], 'DeleteGroupPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLoginProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOpenIDConnectProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRolePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSAMLProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSSHPublicKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServerCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceSpecificCredentialRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSigningCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVirtualMFADeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachGroupPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachRolePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachUserPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DuplicateCertificateException' => [ 'base' => '<p>The request was rejected because the same certificate is associated with an IAM user in the account.</p>', 'refs' => [], ], 'DuplicateSSHPublicKeyException' => [ 'base' => '<p>The request was rejected because the SSH public key is already associated with the specified IAM user.</p>', 'refs' => [], ], 'EnableMFADeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'EntityAlreadyExistsException' => [ 'base' => '<p>The request was rejected because it attempted to create a resource that already exists.</p>', 'refs' => [], ], 'EntityTemporarilyUnmodifiableException' => [ 'base' => '<p>The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates that the request is likely to succeed if you try again after waiting several minutes. The error message describes the entity.</p>', 'refs' => [], ], 'EntityType' => [ 'base' => NULL, 'refs' => [ 'ListEntitiesForPolicyRequest$EntityFilter' => '<p>The entity type to use for filtering the results.</p> <p>For example, when <code>EntityFilter</code> is <code>Role</code>, only the roles that are attached to the specified policy are returned. This parameter is optional. If it is not included, all attached entities (users, groups, and roles) are returned. The argument for this parameter must be one of the valid values listed below.</p>', 'entityListType$member' => NULL, ], ], 'EvalDecisionDetailsType' => [ 'base' => NULL, 'refs' => [ 'EvaluationResult$EvalDecisionDetails' => '<p>Additional details about the results of the evaluation decision. When there are both IAM policies and resource policies, this parameter explains how each set of policies contributes to the final evaluation decision. When simulating cross-account access to a resource, both the resource-based policy and the caller\'s IAM policy must grant access. See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_compare-resource-policies.html">How IAM Roles Differ from Resource-based Policies</a> </p>', 'ResourceSpecificResult$EvalDecisionDetails' => '<p>Additional details about the results of the evaluation decision. When there are both IAM policies and resource policies, this parameter explains how each set of policies contributes to the final evaluation decision. When simulating cross-account access to a resource, both the resource-based policy and the caller\'s IAM policy must grant access.</p>', ], ], 'EvalDecisionSourceType' => [ 'base' => NULL, 'refs' => [ 'EvalDecisionDetailsType$key' => NULL, ], ], 'EvaluationResult' => [ 'base' => '<p>Contains the results of a simulation.</p> <p>This data type is used by the return parameter of <code> <a>SimulateCustomPolicy</a> </code> and <code> <a>SimulatePrincipalPolicy</a> </code>.</p>', 'refs' => [ 'EvaluationResultsListType$member' => NULL, ], ], 'EvaluationResultsListType' => [ 'base' => NULL, 'refs' => [ 'SimulatePolicyResponse$EvaluationResults' => '<p>The results of the simulation.</p>', ], ], 'GenerateCredentialReportResponse' => [ 'base' => '<p>Contains the response to a successful <a>GenerateCredentialReport</a> request. </p>', 'refs' => [], ], 'GetAccessKeyLastUsedRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessKeyLastUsedResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetAccessKeyLastUsed</a> request. It is also returned as a member of the <a>AccessKeyMetaData</a> structure returned by the <a>ListAccessKeys</a> action.</p>', 'refs' => [], ], 'GetAccountAuthorizationDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccountAuthorizationDetailsResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetAccountAuthorizationDetails</a> request. </p>', 'refs' => [], ], 'GetAccountPasswordPolicyResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetAccountPasswordPolicy</a> request. </p>', 'refs' => [], ], 'GetAccountSummaryResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetAccountSummary</a> request. </p>', 'refs' => [], ], 'GetContextKeysForCustomPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContextKeysForPolicyResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetContextKeysForPrincipalPolicy</a> or <a>GetContextKeysForCustomPolicy</a> request. </p>', 'refs' => [], ], 'GetContextKeysForPrincipalPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCredentialReportResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetCredentialReport</a> request. </p>', 'refs' => [], ], 'GetGroupPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupPolicyResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetGroupPolicy</a> request. </p>', 'refs' => [], ], 'GetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetGroup</a> request. </p>', 'refs' => [], ], 'GetInstanceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInstanceProfileResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetInstanceProfile</a> request. </p>', 'refs' => [], ], 'GetLoginProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLoginProfileResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetLoginProfile</a> request. </p>', 'refs' => [], ], 'GetOpenIDConnectProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOpenIDConnectProviderResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetOpenIDConnectProvider</a> request. </p>', 'refs' => [], ], 'GetPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetPolicy</a> request. </p>', 'refs' => [], ], 'GetPolicyVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyVersionResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetPolicyVersion</a> request. </p>', 'refs' => [], ], 'GetRolePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRolePolicyResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetRolePolicy</a> request. </p>', 'refs' => [], ], 'GetRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRoleResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetRole</a> request. </p>', 'refs' => [], ], 'GetSAMLProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSAMLProviderResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetSAMLProvider</a> request. </p>', 'refs' => [], ], 'GetSSHPublicKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSSHPublicKeyResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetSSHPublicKey</a> request.</p>', 'refs' => [], ], 'GetServerCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServerCertificateResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetServerCertificate</a> request. </p>', 'refs' => [], ], 'GetUserPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserPolicyResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetUserPolicy</a> request. </p>', 'refs' => [], ], 'GetUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserResponse' => [ 'base' => '<p>Contains the response to a successful <a>GetUser</a> request. </p>', 'refs' => [], ], 'Group' => [ 'base' => '<p>Contains information about an IAM group entity.</p> <p>This data type is used as a response element in the following actions:</p> <ul> <li> <p> <a>CreateGroup</a> </p> </li> <li> <p> <a>GetGroup</a> </p> </li> <li> <p> <a>ListGroups</a> </p> </li> </ul>', 'refs' => [ 'CreateGroupResponse$Group' => '<p>A structure containing details about the new group.</p>', 'GetGroupResponse$Group' => '<p>A structure that contains details about the group.</p>', 'groupListType$member' => NULL, ], ], 'GroupDetail' => [ 'base' => '<p>Contains information about an IAM group, including all of the group\'s policies.</p> <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> action.</p>', 'refs' => [ 'groupDetailListType$member' => NULL, ], ], 'InstanceProfile' => [ 'base' => '<p>Contains information about an instance profile.</p> <p>This data type is used as a response element in the following actions:</p> <ul> <li> <p> <a>CreateInstanceProfile</a> </p> </li> <li> <p> <a>GetInstanceProfile</a> </p> </li> <li> <p> <a>ListInstanceProfiles</a> </p> </li> <li> <p> <a>ListInstanceProfilesForRole</a> </p> </li> </ul>', 'refs' => [ 'CreateInstanceProfileResponse$InstanceProfile' => '<p>A structure containing details about the new instance profile.</p>', 'GetInstanceProfileResponse$InstanceProfile' => '<p>A structure containing details about the instance profile.</p>', 'instanceProfileListType$member' => NULL, ], ], 'InvalidAuthenticationCodeException' => [ 'base' => '<p>The request was rejected because the authentication code was not recognized. The error message describes the specific error.</p>', 'refs' => [], ], 'InvalidCertificateException' => [ 'base' => '<p>The request was rejected because the certificate is invalid.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>', 'refs' => [], ], 'InvalidPublicKeyException' => [ 'base' => '<p>The request was rejected because the public key is malformed or otherwise invalid.</p>', 'refs' => [], ], 'InvalidUserTypeException' => [ 'base' => '<p>The request was rejected because the type of user for the transaction was incorrect.</p>', 'refs' => [], ], 'KeyPairMismatchException' => [ 'base' => '<p>The request was rejected because the public key certificate and the private key do not match.</p>', 'refs' => [], ], 'LimitExceededException' => [ 'base' => '<p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error message describes the limit exceeded.</p>', 'refs' => [], ], 'LineNumber' => [ 'base' => NULL, 'refs' => [ 'Position$Line' => '<p>The line containing the specified position in the document.</p>', ], ], 'ListAccessKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessKeysResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListAccessKeys</a> request. </p>', 'refs' => [], ], 'ListAccountAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAliasesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListAccountAliases</a> request. </p>', 'refs' => [], ], 'ListAttachedGroupPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAttachedGroupPoliciesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListAttachedGroupPolicies</a> request. </p>', 'refs' => [], ], 'ListAttachedRolePoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAttachedRolePoliciesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListAttachedRolePolicies</a> request. </p>', 'refs' => [], ], 'ListAttachedUserPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAttachedUserPoliciesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListAttachedUserPolicies</a> request. </p>', 'refs' => [], ], 'ListEntitiesForPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEntitiesForPolicyResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListEntitiesForPolicy</a> request. </p>', 'refs' => [], ], 'ListGroupPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupPoliciesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListGroupPolicies</a> request. </p>', 'refs' => [], ], 'ListGroupsForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsForUserResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListGroupsForUser</a> request. </p>', 'refs' => [], ], 'ListGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListGroups</a> request. </p>', 'refs' => [], ], 'ListInstanceProfilesForRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceProfilesForRoleResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListInstanceProfilesForRole</a> request. </p>', 'refs' => [], ], 'ListInstanceProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceProfilesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListInstanceProfiles</a> request. </p>', 'refs' => [], ], 'ListMFADevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMFADevicesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListMFADevices</a> request. </p>', 'refs' => [], ], 'ListOpenIDConnectProvidersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOpenIDConnectProvidersResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListOpenIDConnectProviders</a> request. </p>', 'refs' => [], ], 'ListPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPoliciesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListPolicies</a> request. </p>', 'refs' => [], ], 'ListPolicyVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPolicyVersionsResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListPolicyVersions</a> request. </p>', 'refs' => [], ], 'ListRolePoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRolePoliciesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListRolePolicies</a> request. </p>', 'refs' => [], ], 'ListRolesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRolesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListRoles</a> request. </p>', 'refs' => [], ], 'ListSAMLProvidersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSAMLProvidersResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListSAMLProviders</a> request. </p>', 'refs' => [], ], 'ListSSHPublicKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSSHPublicKeysResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListSSHPublicKeys</a> request.</p>', 'refs' => [], ], 'ListServerCertificatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServerCertificatesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListServerCertificates</a> request. </p>', 'refs' => [], ], 'ListServiceSpecificCredentialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceSpecificCredentialsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSigningCertificatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSigningCertificatesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListSigningCertificates</a> request. </p>', 'refs' => [], ], 'ListUserPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUserPoliciesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListUserPolicies</a> request. </p>', 'refs' => [], ], 'ListUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListUsers</a> request. </p>', 'refs' => [], ], 'ListVirtualMFADevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVirtualMFADevicesResponse' => [ 'base' => '<p>Contains the response to a successful <a>ListVirtualMFADevices</a> request. </p>', 'refs' => [], ], 'LoginProfile' => [ 'base' => '<p>Contains the user name and password create date for a user.</p> <p> This data type is used as a response element in the <a>CreateLoginProfile</a> and <a>GetLoginProfile</a> actions. </p>', 'refs' => [ 'CreateLoginProfileResponse$LoginProfile' => '<p>A structure containing the user name and password create date.</p>', 'GetLoginProfileResponse$LoginProfile' => '<p>A structure containing the user name and password create date for the user.</p>', ], ], 'MFADevice' => [ 'base' => '<p>Contains information about an MFA device.</p> <p>This data type is used as a response element in the <a>ListMFADevices</a> action.</p>', 'refs' => [ 'mfaDeviceListType$member' => NULL, ], ], 'MalformedCertificateException' => [ 'base' => '<p>The request was rejected because the certificate was malformed or expired. The error message describes the specific error.</p>', 'refs' => [], ], 'MalformedPolicyDocumentException' => [ 'base' => '<p>The request was rejected because the policy document was malformed. The error message describes the specific error.</p>', 'refs' => [], ], 'ManagedPolicyDetail' => [ 'base' => '<p>Contains information about a managed policy, including the policy\'s ARN, versions, and the number of principal entities (users, groups, and roles) that the policy is attached to.</p> <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> action.</p> <p>For more information about managed policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>Using IAM</i> guide. </p>', 'refs' => [ 'ManagedPolicyDetailListType$member' => NULL, ], ], 'ManagedPolicyDetailListType' => [ 'base' => NULL, 'refs' => [ 'GetAccountAuthorizationDetailsResponse$Policies' => '<p>A list containing information about managed policies.</p>', ], ], 'NoSuchEntityException' => [ 'base' => '<p>The request was rejected because it referenced an entity that does not exist. The error message describes the entity.</p>', 'refs' => [], ], 'OpenIDConnectProviderListEntry' => [ 'base' => '<p>Contains the Amazon Resource Name (ARN) for an IAM OpenID Connect provider.</p>', 'refs' => [ 'OpenIDConnectProviderListType$member' => NULL, ], ], 'OpenIDConnectProviderListType' => [ 'base' => '<p>Contains a list of IAM OpenID Connect providers.</p>', 'refs' => [ 'ListOpenIDConnectProvidersResponse$OpenIDConnectProviderList' => '<p>The list of IAM OIDC provider resource objects defined in the AWS account.</p>', ], ], 'OpenIDConnectProviderUrlType' => [ 'base' => '<p>Contains a URL that specifies the endpoint for an OpenID Connect provider.</p>', 'refs' => [ 'CreateOpenIDConnectProviderRequest$Url' => '<p>The URL of the identity provider. The URL must begin with "https://" and should correspond to the <code>iss</code> claim in the provider\'s OpenID Connect ID tokens. Per the OIDC standard, path components are allowed but query parameters are not. Typically the URL consists of only a host name, like "https://server.example.org" or "https://example.com".</p> <p>You cannot register the same provider multiple times in a single AWS account. If you try to submit a URL that has already been used for an OpenID Connect provider in the AWS account, you will get an error.</p>', 'GetOpenIDConnectProviderResponse$Url' => '<p>The URL that the IAM OIDC provider resource object is associated with. For more information, see <a>CreateOpenIDConnectProvider</a>.</p>', ], ], 'OrganizationsDecisionDetail' => [ 'base' => '<p>Contains information about AWS Organizations\'s affect on a policy simulation.</p>', 'refs' => [ 'EvaluationResult$OrganizationsDecisionDetail' => '<p>A structure that details how AWS Organizations and its service control policies affect the results of the simulation. Only applies if the simulated user\'s account is part of an organization.</p>', ], ], 'PasswordPolicy' => [ 'base' => '<p>Contains information about the account password policy.</p> <p> This data type is used as a response element in the <a>GetAccountPasswordPolicy</a> action. </p>', 'refs' => [ 'GetAccountPasswordPolicyResponse$PasswordPolicy' => '<p>A structure that contains details about the account\'s password policy.</p>', ], ], 'PasswordPolicyViolationException' => [ 'base' => '<p>The request was rejected because the provided password did not meet the requirements imposed by the account password policy.</p>', 'refs' => [], ], 'Policy' => [ 'base' => '<p>Contains information about a managed policy.</p> <p>This data type is used as a response element in the <a>CreatePolicy</a>, <a>GetPolicy</a>, and <a>ListPolicies</a> actions. </p> <p>For more information about managed policies, refer to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>Using IAM</i> guide. </p>', 'refs' => [ 'CreatePolicyResponse$Policy' => '<p>A structure containing details about the new policy.</p>', 'GetPolicyResponse$Policy' => '<p>A structure containing details about the policy.</p>', 'policyListType$member' => NULL, ], ], 'PolicyDetail' => [ 'base' => '<p>Contains information about an IAM policy, including the policy document.</p> <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> action.</p>', 'refs' => [ 'policyDetailListType$member' => NULL, ], ], 'PolicyEvaluationDecisionType' => [ 'base' => NULL, 'refs' => [ 'EvalDecisionDetailsType$value' => NULL, 'EvaluationResult$EvalDecision' => '<p>The result of the simulation.</p>', 'ResourceSpecificResult$EvalResourceDecision' => '<p>The result of the simulation of the simulated API action on the resource specified in <code>EvalResourceName</code>.</p>', ], ], 'PolicyEvaluationException' => [ 'base' => '<p>The request failed because a provided policy could not be successfully evaluated. An additional detail message indicates the source of the failure.</p>', 'refs' => [], ], 'PolicyGroup' => [ 'base' => '<p>Contains information about a group that a managed policy is attached to.</p> <p>This data type is used as a response element in the <a>ListEntitiesForPolicy</a> action. </p> <p>For more information about managed policies, refer to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>Using IAM</i> guide. </p>', 'refs' => [ 'PolicyGroupListType$member' => NULL, ], ], 'PolicyGroupListType' => [ 'base' => NULL, 'refs' => [ 'ListEntitiesForPolicyResponse$PolicyGroups' => '<p>A list of IAM groups that the policy is attached to.</p>', ], ], 'PolicyIdentifierType' => [ 'base' => NULL, 'refs' => [ 'Statement$SourcePolicyId' => '<p>The identifier of the policy that was provided as an input.</p>', ], ], 'PolicyRole' => [ 'base' => '<p>Contains information about a role that a managed policy is attached to.</p> <p>This data type is used as a response element in the <a>ListEntitiesForPolicy</a> action. </p> <p>For more information about managed policies, refer to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>Using IAM</i> guide. </p>', 'refs' => [ 'PolicyRoleListType$member' => NULL, ], ], 'PolicyRoleListType' => [ 'base' => NULL, 'refs' => [ 'ListEntitiesForPolicyResponse$PolicyRoles' => '<p>A list of IAM roles that the policy is attached to.</p>', ], ], 'PolicySourceType' => [ 'base' => NULL, 'refs' => [ 'Statement$SourcePolicyType' => '<p>The type of the policy.</p>', ], ], 'PolicyUser' => [ 'base' => '<p>Contains information about a user that a managed policy is attached to.</p> <p>This data type is used as a response element in the <a>ListEntitiesForPolicy</a> action. </p> <p>For more information about managed policies, refer to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>Using IAM</i> guide. </p>', 'refs' => [ 'PolicyUserListType$member' => NULL, ], ], 'PolicyUserListType' => [ 'base' => NULL, 'refs' => [ 'ListEntitiesForPolicyResponse$PolicyUsers' => '<p>A list of IAM users that the policy is attached to.</p>', ], ], 'PolicyVersion' => [ 'base' => '<p>Contains information about a version of a managed policy.</p> <p>This data type is used as a response element in the <a>CreatePolicyVersion</a>, <a>GetPolicyVersion</a>, <a>ListPolicyVersions</a>, and <a>GetAccountAuthorizationDetails</a> actions. </p> <p>For more information about managed policies, refer to <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and Inline Policies</a> in the <i>Using IAM</i> guide. </p>', 'refs' => [ 'CreatePolicyVersionResponse$PolicyVersion' => '<p>A structure containing details about the new policy version.</p>', 'GetPolicyVersionResponse$PolicyVersion' => '<p>A structure containing details about the policy version.</p>', 'policyDocumentVersionListType$member' => NULL, ], ], 'Position' => [ 'base' => '<p>Contains the row and column of a location of a <code>Statement</code> element in a policy document.</p> <p>This data type is used as a member of the <code> <a>Statement</a> </code> type.</p>', 'refs' => [ 'Statement$StartPosition' => '<p>The row and column of the beginning of the <code>Statement</code> in an IAM policy.</p>', 'Statement$EndPosition' => '<p>The row and column of the end of a <code>Statement</code> in an IAM policy.</p>', ], ], 'PutGroupPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRolePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutUserPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveClientIDFromOpenIDConnectProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveRoleFromInstanceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveUserFromGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReportContentType' => [ 'base' => NULL, 'refs' => [ 'GetCredentialReportResponse$Content' => '<p>Contains the credential report. The report is Base64-encoded.</p>', ], ], 'ReportFormatType' => [ 'base' => NULL, 'refs' => [ 'GetCredentialReportResponse$ReportFormat' => '<p>The format (MIME type) of the credential report.</p>', ], ], 'ReportStateDescriptionType' => [ 'base' => NULL, 'refs' => [ 'GenerateCredentialReportResponse$Description' => '<p>Information about the credential report.</p>', ], ], 'ReportStateType' => [ 'base' => NULL, 'refs' => [ 'GenerateCredentialReportResponse$State' => '<p>Information about the state of the credential report.</p>', ], ], 'ResetServiceSpecificCredentialRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetServiceSpecificCredentialResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceHandlingOptionType' => [ 'base' => NULL, 'refs' => [ 'SimulateCustomPolicyRequest$ResourceHandlingOption' => '<p>Specifies the type of simulation to run. Different APIs that support resource-based policies require different combinations of resources. By specifying the type of simulation to run, you enable the policy simulator to enforce the presence of the required resources to ensure reliable simulation results. If your simulation does not match one of the following scenarios, then you can omit this parameter. The following list shows each of the supported scenario values and the resources that you must define to run the simulation.</p> <p>Each of the EC2 scenarios requires that you specify instance, image, and security-group resources. If your scenario includes an EBS volume, then you must specify that volume as a resource. If the EC2 scenario includes VPC, then you must supply the network-interface resource. If it includes an IP subnet, then you must specify the subnet resource. For more information on the EC2 scenario options, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a> in the <i>AWS EC2 User Guide</i>.</p> <ul> <li> <p> <b>EC2-Classic-InstanceStore</b> </p> <p>instance, image, security-group</p> </li> <li> <p> <b>EC2-Classic-EBS</b> </p> <p>instance, image, security-group, volume</p> </li> <li> <p> <b>EC2-VPC-InstanceStore</b> </p> <p>instance, image, security-group, network-interface</p> </li> <li> <p> <b>EC2-VPC-InstanceStore-Subnet</b> </p> <p>instance, image, security-group, network-interface, subnet</p> </li> <li> <p> <b>EC2-VPC-EBS</b> </p> <p>instance, image, security-group, network-interface, volume</p> </li> <li> <p> <b>EC2-VPC-EBS-Subnet</b> </p> <p>instance, image, security-group, network-interface, subnet, volume</p> </li> </ul>', 'SimulatePrincipalPolicyRequest$ResourceHandlingOption' => '<p>Specifies the type of simulation to run. Different APIs that support resource-based policies require different combinations of resources. By specifying the type of simulation to run, you enable the policy simulator to enforce the presence of the required resources to ensure reliable simulation results. If your simulation does not match one of the following scenarios, then you can omit this parameter. The following list shows each of the supported scenario values and the resources that you must define to run the simulation.</p> <p>Each of the EC2 scenarios requires that you specify instance, image, and security-group resources. If your scenario includes an EBS volume, then you must specify that volume as a resource. If the EC2 scenario includes VPC, then you must supply the network-interface resource. If it includes an IP subnet, then you must specify the subnet resource. For more information on the EC2 scenario options, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a> in the <i>AWS EC2 User Guide</i>.</p> <ul> <li> <p> <b>EC2-Classic-InstanceStore</b> </p> <p>instance, image, security-group</p> </li> <li> <p> <b>EC2-Classic-EBS</b> </p> <p>instance, image, security-group, volume</p> </li> <li> <p> <b>EC2-VPC-InstanceStore</b> </p> <p>instance, image, security-group, network-interface</p> </li> <li> <p> <b>EC2-VPC-InstanceStore-Subnet</b> </p> <p>instance, image, security-group, network-interface, subnet</p> </li> <li> <p> <b>EC2-VPC-EBS</b> </p> <p>instance, image, security-group, network-interface, volume</p> </li> <li> <p> <b>EC2-VPC-EBS-Subnet</b> </p> <p>instance, image, security-group, network-interface, subnet, volume</p> </li> </ul>', ], ], 'ResourceNameListType' => [ 'base' => NULL, 'refs' => [ 'SimulateCustomPolicyRequest$ResourceArns' => '<p>A list of ARNs of AWS resources to include in the simulation. If this parameter is not provided then the value defaults to <code>*</code> (all resources). Each API in the <code>ActionNames</code> parameter is evaluated for each resource in this list. The simulation determines the access result (allowed or denied) of each combination and reports it in the response.</p> <p>The simulation does not automatically retrieve policies for the specified resources. If you want to include a resource policy in the simulation, then you must include the policy as a string in the <code>ResourcePolicy</code> parameter.</p> <p>If you include a <code>ResourcePolicy</code>, then it must be applicable to all of the resources included in the simulation or you receive an invalid input error.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'SimulatePrincipalPolicyRequest$ResourceArns' => '<p>A list of ARNs of AWS resources to include in the simulation. If this parameter is not provided then the value defaults to <code>*</code> (all resources). Each API in the <code>ActionNames</code> parameter is evaluated for each resource in this list. The simulation determines the access result (allowed or denied) of each combination and reports it in the response.</p> <p>The simulation does not automatically retrieve policies for the specified resources. If you want to include a resource policy in the simulation, then you must include the policy as a string in the <code>ResourcePolicy</code> parameter.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', ], ], 'ResourceNameType' => [ 'base' => NULL, 'refs' => [ 'EvaluationResult$EvalResourceName' => '<p>The ARN of the resource that the indicated API action was tested on.</p>', 'ResourceNameListType$member' => NULL, 'ResourceSpecificResult$EvalResourceName' => '<p>The name of the simulated resource, in Amazon Resource Name (ARN) format.</p>', 'SimulateCustomPolicyRequest$ResourceOwner' => '<p>An AWS account ID that specifies the owner of any simulated resource that does not identify its owner in the resource ARN, such as an S3 bucket or object. If <code>ResourceOwner</code> is specified, it is also used as the account owner of any <code>ResourcePolicy</code> included in the simulation. If the <code>ResourceOwner</code> parameter is not specified, then the owner of the resources and the resource policy defaults to the account of the identity provided in <code>CallerArn</code>. This parameter is required only if you specify a resource-based policy and account that owns the resource is different from the account that owns the simulated calling user <code>CallerArn</code>.</p>', 'SimulateCustomPolicyRequest$CallerArn' => '<p>The ARN of the IAM user that you want to use as the simulated caller of the APIs. <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> so that the policy\'s <code>Principal</code> element has a value to use in evaluating the policy.</p> <p>You can specify only the ARN of an IAM user. You cannot specify the ARN of an assumed role, federated user, or a service principal.</p>', 'SimulatePrincipalPolicyRequest$ResourceOwner' => '<p>An AWS account ID that specifies the owner of any simulated resource that does not identify its owner in the resource ARN, such as an S3 bucket or object. If <code>ResourceOwner</code> is specified, it is also used as the account owner of any <code>ResourcePolicy</code> included in the simulation. If the <code>ResourceOwner</code> parameter is not specified, then the owner of the resources and the resource policy defaults to the account of the identity provided in <code>CallerArn</code>. This parameter is required only if you specify a resource-based policy and account that owns the resource is different from the account that owns the simulated calling user <code>CallerArn</code>.</p>', 'SimulatePrincipalPolicyRequest$CallerArn' => '<p>The ARN of the IAM user that you want to specify as the simulated caller of the APIs. If you do not specify a <code>CallerArn</code>, it defaults to the ARN of the user that you specify in <code>PolicySourceArn</code>, if you specified a user. If you include both a <code>PolicySourceArn</code> (for example, <code>arn:aws:iam::123456789012:user/David</code>) and a <code>CallerArn</code> (for example, <code>arn:aws:iam::123456789012:user/Bob</code>), the result is that you simulate calling the APIs as Bob, as if Bob had David\'s policies.</p> <p>You can specify only the ARN of an IAM user. You cannot specify the ARN of an assumed role, federated user, or a service principal.</p> <p> <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> and the <code>PolicySourceArn</code> is not the ARN for an IAM user. This is required so that the resource-based policy\'s <code>Principal</code> element has a value to use in evaluating the policy.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', ], ], 'ResourceSpecificResult' => [ 'base' => '<p>Contains the result of the simulation of a single API action call on a single resource.</p> <p>This data type is used by a member of the <a>EvaluationResult</a> data type.</p>', 'refs' => [ 'ResourceSpecificResultListType$member' => NULL, ], ], 'ResourceSpecificResultListType' => [ 'base' => NULL, 'refs' => [ 'EvaluationResult$ResourceSpecificResults' => '<p>The individual results of the simulation of the API action specified in EvalActionName on each resource.</p>', ], ], 'ResyncMFADeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'Role' => [ 'base' => '<p>Contains information about an IAM role. This structure is returned as a response element in several APIs that interact with roles.</p>', 'refs' => [ 'CreateRoleResponse$Role' => '<p>A structure containing details about the new role.</p>', 'CreateServiceLinkedRoleResponse$Role' => '<p>A <a>Role</a> object that contains details about the newly created role.</p>', 'GetRoleResponse$Role' => '<p>A structure containing details about the IAM role.</p>', 'UpdateRoleDescriptionResponse$Role' => '<p>A structure that contains details about the modified role.</p>', 'roleListType$member' => NULL, ], ], 'RoleDetail' => [ 'base' => '<p>Contains information about an IAM role, including all of the role\'s policies.</p> <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> action.</p>', 'refs' => [ 'roleDetailListType$member' => NULL, ], ], 'SAMLMetadataDocumentType' => [ 'base' => NULL, 'refs' => [ 'CreateSAMLProviderRequest$SAMLMetadataDocument' => '<p>An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer\'s name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization\'s IdP.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based Federation</a> in the <i>IAM User Guide</i> </p>', 'GetSAMLProviderResponse$SAMLMetadataDocument' => '<p>The XML metadata document that includes information about an identity provider.</p>', 'UpdateSAMLProviderRequest$SAMLMetadataDocument' => '<p>An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer\'s name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization\'s IdP.</p>', ], ], 'SAMLProviderListEntry' => [ 'base' => '<p>Contains the list of SAML providers for this account.</p>', 'refs' => [ 'SAMLProviderListType$member' => NULL, ], ], 'SAMLProviderListType' => [ 'base' => NULL, 'refs' => [ 'ListSAMLProvidersResponse$SAMLProviderList' => '<p>The list of SAML provider resource objects defined in IAM for this AWS account.</p>', ], ], 'SAMLProviderNameType' => [ 'base' => NULL, 'refs' => [ 'CreateSAMLProviderRequest$Name' => '<p>The name of the provider to create.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', ], ], 'SSHPublicKey' => [ 'base' => '<p>Contains information about an SSH public key.</p> <p>This data type is used as a response element in the <a>GetSSHPublicKey</a> and <a>UploadSSHPublicKey</a> actions. </p>', 'refs' => [ 'GetSSHPublicKeyResponse$SSHPublicKey' => '<p>A structure containing details about the SSH public key.</p>', 'UploadSSHPublicKeyResponse$SSHPublicKey' => '<p>Contains information about the SSH public key.</p>', ], ], 'SSHPublicKeyListType' => [ 'base' => NULL, 'refs' => [ 'ListSSHPublicKeysResponse$SSHPublicKeys' => '<p>A list of the SSH public keys assigned to IAM user.</p>', ], ], 'SSHPublicKeyMetadata' => [ 'base' => '<p>Contains information about an SSH public key, without the key\'s body or fingerprint.</p> <p>This data type is used as a response element in the <a>ListSSHPublicKeys</a> action.</p>', 'refs' => [ 'SSHPublicKeyListType$member' => NULL, ], ], 'ServerCertificate' => [ 'base' => '<p>Contains information about a server certificate.</p> <p> This data type is used as a response element in the <a>GetServerCertificate</a> action. </p>', 'refs' => [ 'GetServerCertificateResponse$ServerCertificate' => '<p>A structure containing details about the server certificate.</p>', ], ], 'ServerCertificateMetadata' => [ 'base' => '<p>Contains information about a server certificate without its certificate body, certificate chain, and private key.</p> <p> This data type is used as a response element in the <a>UploadServerCertificate</a> and <a>ListServerCertificates</a> actions. </p>', 'refs' => [ 'ServerCertificate$ServerCertificateMetadata' => '<p>The meta information of the server certificate, such as its name, path, ID, and ARN.</p>', 'UploadServerCertificateResponse$ServerCertificateMetadata' => '<p>The meta information of the uploaded server certificate without its certificate body, certificate chain, and private key.</p>', 'serverCertificateMetadataListType$member' => NULL, ], ], 'ServiceFailureException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure.</p>', 'refs' => [], ], 'ServiceNotSupportedException' => [ 'base' => '<p>The specified service does not support service-specific credentials.</p>', 'refs' => [], ], 'ServiceSpecificCredential' => [ 'base' => '<p>Contains the details of a service specific credential.</p>', 'refs' => [ 'CreateServiceSpecificCredentialResponse$ServiceSpecificCredential' => '<p>A structure that contains information about the newly created service-specific credential.</p> <important> <p>This is the only time that the password for this credential set is available. It cannot be recovered later. Instead, you will have to reset the password with <a>ResetServiceSpecificCredential</a>.</p> </important>', 'ResetServiceSpecificCredentialResponse$ServiceSpecificCredential' => '<p>A structure with details about the updated service-specific credential, including the new password.</p> <important> <p>This is the <b>only</b> time that you can access the password. You cannot recover the password later, but you can reset it again.</p> </important>', ], ], 'ServiceSpecificCredentialMetadata' => [ 'base' => '<p>Contains additional details about a service-specific credential.</p>', 'refs' => [ 'ServiceSpecificCredentialsListType$member' => NULL, ], ], 'ServiceSpecificCredentialsListType' => [ 'base' => NULL, 'refs' => [ 'ListServiceSpecificCredentialsResponse$ServiceSpecificCredentials' => '<p>A list of structures that each contain details about a service-specific credential.</p>', ], ], 'SetDefaultPolicyVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'SigningCertificate' => [ 'base' => '<p>Contains information about an X.509 signing certificate.</p> <p>This data type is used as a response element in the <a>UploadSigningCertificate</a> and <a>ListSigningCertificates</a> actions. </p>', 'refs' => [ 'UploadSigningCertificateResponse$Certificate' => '<p>Information about the certificate.</p>', 'certificateListType$member' => NULL, ], ], 'SimulateCustomPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'SimulatePolicyResponse' => [ 'base' => '<p>Contains the response to a successful <a>SimulatePrincipalPolicy</a> or <a>SimulateCustomPolicy</a> request.</p>', 'refs' => [], ], 'SimulatePrincipalPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'SimulationPolicyListType' => [ 'base' => NULL, 'refs' => [ 'GetContextKeysForCustomPolicyRequest$PolicyInputList' => '<p>A list of policies for which you want the list of context keys referenced in those policies. Each document is specified as a string containing the complete, valid JSON text of an IAM policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', 'GetContextKeysForPrincipalPolicyRequest$PolicyInputList' => '<p>An optional list of additional policies for which you want the list of context keys that are referenced.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', 'SimulateCustomPolicyRequest$PolicyInputList' => '<p>A list of policy documents to include in the simulation. Each document is specified as a string containing the complete, valid JSON text of an IAM policy. Do not include any resource-based policies in this parameter. Any resource-based policy must be submitted with the <code>ResourcePolicy</code> parameter. The policies cannot be "scope-down" policies, such as you could include in a call to <a href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_GetFederationToken.html">GetFederationToken</a> or one of the <a href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_AssumeRole.html">AssumeRole</a> APIs to restrict what a user can do while using the temporary credentials.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', 'SimulatePrincipalPolicyRequest$PolicyInputList' => '<p>An optional list of additional policy documents to include in the simulation. Each document is specified as a string containing the complete, valid JSON text of an IAM policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', ], ], 'Statement' => [ 'base' => '<p>Contains a reference to a <code>Statement</code> element in a policy document that determines the result of the simulation.</p> <p>This data type is used by the <code>MatchedStatements</code> member of the <code> <a>EvaluationResult</a> </code> type.</p>', 'refs' => [ 'StatementListType$member' => NULL, ], ], 'StatementListType' => [ 'base' => NULL, 'refs' => [ 'EvaluationResult$MatchedStatements' => '<p>A list of the statements in the input policies that determine the result for this scenario. Remember that even if multiple statements allow the action on the resource, if only one statement denies that action, then the explicit deny overrides any allow, and the deny statement is the only entry included in the result.</p>', 'ResourceSpecificResult$MatchedStatements' => '<p>A list of the statements in the input policies that determine the result for this part of the simulation. Remember that even if multiple statements allow the action on the resource, if <i>any</i> statement denies that action, then the explicit deny overrides any allow, and the deny statement is the only entry included in the result.</p>', ], ], 'UnmodifiableEntityException' => [ 'base' => '<p>The request was rejected because only the service that depends on the service-linked role can modify or delete the role on your behalf. The error message includes the name of the service that depends on this service-linked role. You must request the change through that service.</p>', 'refs' => [], ], 'UnrecognizedPublicKeyEncodingException' => [ 'base' => '<p>The request was rejected because the public key encoding format is unsupported or unrecognized.</p>', 'refs' => [], ], 'UpdateAccessKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountPasswordPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssumeRolePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLoginProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOpenIDConnectProviderThumbprintRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoleDescriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoleDescriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSAMLProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSAMLProviderResponse' => [ 'base' => '<p>Contains the response to a successful <a>UpdateSAMLProvider</a> request. </p>', 'refs' => [], ], 'UpdateSSHPublicKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServerCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceSpecificCredentialRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSigningCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UploadSSHPublicKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UploadSSHPublicKeyResponse' => [ 'base' => '<p>Contains the response to a successful <a>UploadSSHPublicKey</a> request.</p>', 'refs' => [], ], 'UploadServerCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UploadServerCertificateResponse' => [ 'base' => '<p>Contains the response to a successful <a>UploadServerCertificate</a> request. </p>', 'refs' => [], ], 'UploadSigningCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UploadSigningCertificateResponse' => [ 'base' => '<p>Contains the response to a successful <a>UploadSigningCertificate</a> request. </p>', 'refs' => [], ], 'User' => [ 'base' => '<p>Contains information about an IAM user entity.</p> <p>This data type is used as a response element in the following actions:</p> <ul> <li> <p> <a>CreateUser</a> </p> </li> <li> <p> <a>GetUser</a> </p> </li> <li> <p> <a>ListUsers</a> </p> </li> </ul>', 'refs' => [ 'CreateUserResponse$User' => '<p>A structure with details about the new IAM user.</p>', 'GetUserResponse$User' => '<p>A structure containing details about the IAM user.</p>', 'VirtualMFADevice$User' => '<p>The IAM user associated with this virtual MFA device.</p>', 'userListType$member' => NULL, ], ], 'UserDetail' => [ 'base' => '<p>Contains information about an IAM user, including all the user\'s policies and all the IAM groups the user is in.</p> <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> action.</p>', 'refs' => [ 'userDetailListType$member' => NULL, ], ], 'VirtualMFADevice' => [ 'base' => '<p>Contains information about a virtual MFA device.</p>', 'refs' => [ 'CreateVirtualMFADeviceResponse$VirtualMFADevice' => '<p>A structure containing details about the new virtual MFA device.</p>', 'virtualMFADeviceListType$member' => NULL, ], ], 'accessKeyIdType' => [ 'base' => NULL, 'refs' => [ 'AccessKey$AccessKeyId' => '<p>The ID for this access key.</p>', 'AccessKeyMetadata$AccessKeyId' => '<p>The ID for this access key.</p>', 'DeleteAccessKeyRequest$AccessKeyId' => '<p>The access key ID for the access key ID and secret access key you want to delete.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>', 'GetAccessKeyLastUsedRequest$AccessKeyId' => '<p>The identifier of an access key.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>', 'UpdateAccessKeyRequest$AccessKeyId' => '<p>The access key ID of the secret access key you want to update.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>', ], ], 'accessKeyMetadataListType' => [ 'base' => '<p>Contains a list of access key metadata.</p> <p>This data type is used as a response element in the <a>ListAccessKeys</a> action.</p>', 'refs' => [ 'ListAccessKeysResponse$AccessKeyMetadata' => '<p>A list of objects containing metadata about the access keys.</p>', ], ], 'accessKeySecretType' => [ 'base' => NULL, 'refs' => [ 'AccessKey$SecretAccessKey' => '<p>The secret key used to sign requests.</p>', ], ], 'accountAliasListType' => [ 'base' => NULL, 'refs' => [ 'ListAccountAliasesResponse$AccountAliases' => '<p>A list of aliases associated with the account. AWS supports only one alias per account.</p>', ], ], 'accountAliasType' => [ 'base' => NULL, 'refs' => [ 'CreateAccountAliasRequest$AccountAlias' => '<p>The account alias to create.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have two dashes in a row.</p>', 'DeleteAccountAliasRequest$AccountAlias' => '<p>The name of the account alias to delete.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have two dashes in a row.</p>', 'accountAliasListType$member' => NULL, ], ], 'arnType' => [ 'base' => '<p>The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.</p> <p>For more information about ARNs, go to <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>. </p>', 'refs' => [ 'AddClientIDToOpenIDConnectProviderRequest$OpenIDConnectProviderArn' => '<p>The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider resource to add the client ID to. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> action.</p>', 'AttachGroupPolicyRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'AttachRolePolicyRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'AttachUserPolicyRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'AttachedPolicy$PolicyArn' => NULL, 'CreateOpenIDConnectProviderResponse$OpenIDConnectProviderArn' => '<p>The Amazon Resource Name (ARN) of the new IAM OpenID Connect provider that is created. For more information, see <a>OpenIDConnectProviderListEntry</a>. </p>', 'CreatePolicyVersionRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the IAM policy to which you want to add a new version.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'CreateSAMLProviderResponse$SAMLProviderArn' => '<p>The Amazon Resource Name (ARN) of the new SAML provider resource in IAM.</p>', 'DeleteOpenIDConnectProviderRequest$OpenIDConnectProviderArn' => '<p>The Amazon Resource Name (ARN) of the IAM OpenID Connect provider resource object to delete. You can get a list of OpenID Connect provider resource ARNs by using the <a>ListOpenIDConnectProviders</a> action.</p>', 'DeletePolicyRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the IAM policy you want to delete.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'DeletePolicyVersionRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the IAM policy from which you want to delete a version.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'DeleteSAMLProviderRequest$SAMLProviderArn' => '<p>The Amazon Resource Name (ARN) of the SAML provider to delete.</p>', 'DetachGroupPolicyRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'DetachRolePolicyRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'DetachUserPolicyRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'GetContextKeysForPrincipalPolicyRequest$PolicySourceArn' => '<p>The ARN of a user, group, or role whose policies contain the context keys that you want listed. If you specify a user, the list includes context keys that are found in all policies attached to the user as well as to all groups that the user is a member of. If you pick a group or a role, then it includes only those context keys that are found in policies attached to that entity. Note that all parameters are shown in unencoded form here for clarity, but must be URL encoded to be included as a part of a real HTML request.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'GetOpenIDConnectProviderRequest$OpenIDConnectProviderArn' => '<p>The Amazon Resource Name (ARN) of the OIDC provider resource object in IAM to get information for. You can get a list of OIDC provider resource ARNs by using the <a>ListOpenIDConnectProviders</a> action.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'GetPolicyRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the managed policy that you want information about.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'GetPolicyVersionRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the managed policy that you want information about.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'GetSAMLProviderRequest$SAMLProviderArn' => '<p>The Amazon Resource Name (ARN) of the SAML provider resource object in IAM to get information about.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'Group$Arn' => '<p> The Amazon Resource Name (ARN) specifying the group. For more information about ARNs and how to use them in policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide. </p>', 'GroupDetail$Arn' => NULL, 'InstanceProfile$Arn' => '<p> The Amazon Resource Name (ARN) specifying the instance profile. For more information about ARNs and how to use them in policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide. </p>', 'ListEntitiesForPolicyRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the IAM policy for which you want the versions.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'ListPolicyVersionsRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the IAM policy for which you want the versions.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'ManagedPolicyDetail$Arn' => NULL, 'OpenIDConnectProviderListEntry$Arn' => NULL, 'Policy$Arn' => NULL, 'RemoveClientIDFromOpenIDConnectProviderRequest$OpenIDConnectProviderArn' => '<p>The Amazon Resource Name (ARN) of the IAM OIDC provider resource to remove the client ID from. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> action.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'Role$Arn' => '<p> The Amazon Resource Name (ARN) specifying the role. For more information about ARNs and how to use them in policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i> guide. </p>', 'RoleDetail$Arn' => NULL, 'SAMLProviderListEntry$Arn' => '<p>The Amazon Resource Name (ARN) of the SAML provider.</p>', 'ServerCertificateMetadata$Arn' => '<p> The Amazon Resource Name (ARN) specifying the server certificate. For more information about ARNs and how to use them in policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide. </p>', 'SetDefaultPolicyVersionRequest$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the IAM policy whose default version you want to set.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'SimulatePrincipalPolicyRequest$PolicySourceArn' => '<p>The Amazon Resource Name (ARN) of a user, group, or role whose policies you want to include in the simulation. If you specify a user, group, or role, the simulation includes all policies that are associated with that entity. If you specify a user, the simulation also includes all policies that are attached to any groups the user belongs to.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'UpdateOpenIDConnectProviderThumbprintRequest$OpenIDConnectProviderArn' => '<p>The Amazon Resource Name (ARN) of the IAM OIDC provider resource object for which you want to update the thumbprint. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> action.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'UpdateSAMLProviderRequest$SAMLProviderArn' => '<p>The Amazon Resource Name (ARN) of the SAML provider to update.</p> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'UpdateSAMLProviderResponse$SAMLProviderArn' => '<p>The Amazon Resource Name (ARN) of the SAML provider that was updated.</p>', 'User$Arn' => '<p>The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs and how to use ARNs in policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide. </p>', 'UserDetail$Arn' => NULL, ], ], 'assignmentStatusType' => [ 'base' => NULL, 'refs' => [ 'ListVirtualMFADevicesRequest$AssignmentStatus' => '<p> The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list. If you do not specify an <code>AssignmentStatus</code>, the action defaults to <code>Any</code> which lists both assigned and unassigned virtual MFA devices.</p>', ], ], 'attachedPoliciesListType' => [ 'base' => NULL, 'refs' => [ 'GroupDetail$AttachedManagedPolicies' => '<p>A list of the managed policies attached to the group.</p>', 'ListAttachedGroupPoliciesResponse$AttachedPolicies' => '<p>A list of the attached policies.</p>', 'ListAttachedRolePoliciesResponse$AttachedPolicies' => '<p>A list of the attached policies.</p>', 'ListAttachedUserPoliciesResponse$AttachedPolicies' => '<p>A list of the attached policies.</p>', 'RoleDetail$AttachedManagedPolicies' => '<p>A list of managed policies attached to the role. These policies are the role\'s access (permissions) policies.</p>', 'UserDetail$AttachedManagedPolicies' => '<p>A list of the managed policies attached to the user.</p>', ], ], 'attachmentCountType' => [ 'base' => NULL, 'refs' => [ 'ManagedPolicyDetail$AttachmentCount' => '<p>The number of principal entities (users, groups, and roles) that the policy is attached to.</p>', 'Policy$AttachmentCount' => '<p>The number of entities (users, groups, and roles) that the policy is attached to.</p>', ], ], 'authenticationCodeType' => [ 'base' => NULL, 'refs' => [ 'EnableMFADeviceRequest$AuthenticationCode1' => '<p>An authentication code emitted by the device. </p> <p>The format for this parameter is a string of 6 digits.</p> <important> <p>Submit your request immediately after generating the authentication codes. If you generate the codes and then wait too long to submit the request, the MFA device successfully associates with the user but the MFA device becomes out of sync. This happens because time-based one-time passwords (TOTP) expire after a short period of time. If this happens, you can <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html">resync the device</a>.</p> </important>', 'EnableMFADeviceRequest$AuthenticationCode2' => '<p>A subsequent authentication code emitted by the device.</p> <p>The format for this parameter is a string of 6 digits.</p> <important> <p>Submit your request immediately after generating the authentication codes. If you generate the codes and then wait too long to submit the request, the MFA device successfully associates with the user but the MFA device becomes out of sync. This happens because time-based one-time passwords (TOTP) expire after a short period of time. If this happens, you can <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html">resync the device</a>.</p> </important>', 'ResyncMFADeviceRequest$AuthenticationCode1' => '<p>An authentication code emitted by the device.</p> <p>The format for this parameter is a sequence of six digits.</p>', 'ResyncMFADeviceRequest$AuthenticationCode2' => '<p>A subsequent authentication code emitted by the device.</p> <p>The format for this parameter is a sequence of six digits.</p>', ], ], 'booleanObjectType' => [ 'base' => NULL, 'refs' => [ 'PasswordPolicy$HardExpiry' => '<p>Specifies whether IAM users are prevented from setting a new password after their password has expired.</p>', 'UpdateAccountPasswordPolicyRequest$HardExpiry' => '<p>Prevents IAM users from setting a new password after their password has expired.</p> <p>Default value: false</p>', 'UpdateLoginProfileRequest$PasswordResetRequired' => '<p>Allows this new password to be used only once by requiring the specified IAM user to set a new password on next sign-in.</p>', ], ], 'booleanType' => [ 'base' => NULL, 'refs' => [ 'CreateLoginProfileRequest$PasswordResetRequired' => '<p>Specifies whether the user is required to set a new password on next sign-in.</p>', 'CreatePolicyVersionRequest$SetAsDefault' => '<p>Specifies whether to set this version as the policy\'s default version.</p> <p>When this parameter is <code>true</code>, the new policy version becomes the operative version; that is, the version that is in effect for the IAM users, groups, and roles that the policy is attached to.</p> <p>For more information about managed policy versions, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for Managed Policies</a> in the <i>IAM User Guide</i>.</p>', 'GetAccountAuthorizationDetailsResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'GetGroupResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListAccessKeysResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListAccountAliasesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListAttachedGroupPoliciesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListAttachedRolePoliciesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListAttachedUserPoliciesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListEntitiesForPolicyResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListGroupPoliciesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListGroupsForUserResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListGroupsResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListInstanceProfilesForRoleResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListInstanceProfilesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListMFADevicesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListPoliciesRequest$OnlyAttached' => '<p>A flag to filter the results to only the attached policies.</p> <p>When <code>OnlyAttached</code> is <code>true</code>, the returned list contains only the policies that are attached to an IAM user, group, or role. When <code>OnlyAttached</code> is <code>false</code>, or when the parameter is not included, all policies are returned.</p>', 'ListPoliciesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListPolicyVersionsResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListRolePoliciesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListRolesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListSSHPublicKeysResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListServerCertificatesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListSigningCertificatesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListUserPoliciesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListUsersResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'ListVirtualMFADevicesResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'LoginProfile$PasswordResetRequired' => '<p>Specifies whether the user is required to set a new password on next sign-in.</p>', 'ManagedPolicyDetail$IsAttachable' => '<p>Specifies whether the policy can be attached to an IAM user, group, or role.</p>', 'OrganizationsDecisionDetail$AllowedByOrganizations' => '<p>Specifies whether the simulated action is allowed by the AWS Organizations service control policies that impact the simulated user\'s account.</p>', 'PasswordPolicy$RequireSymbols' => '<p>Specifies whether to require symbols for IAM user passwords.</p>', 'PasswordPolicy$RequireNumbers' => '<p>Specifies whether to require numbers for IAM user passwords.</p>', 'PasswordPolicy$RequireUppercaseCharacters' => '<p>Specifies whether to require uppercase characters for IAM user passwords.</p>', 'PasswordPolicy$RequireLowercaseCharacters' => '<p>Specifies whether to require lowercase characters for IAM user passwords.</p>', 'PasswordPolicy$AllowUsersToChangePassword' => '<p>Specifies whether IAM users are allowed to change their own password.</p>', 'PasswordPolicy$ExpirePasswords' => '<p>Indicates whether passwords in the account expire. Returns true if MaxPasswordAge is contains a value greater than 0. Returns false if MaxPasswordAge is 0 or not present.</p>', 'Policy$IsAttachable' => '<p>Specifies whether the policy can be attached to an IAM user, group, or role.</p>', 'PolicyVersion$IsDefaultVersion' => '<p>Specifies whether the policy version is set as the policy\'s default version.</p>', 'SimulatePolicyResponse$IsTruncated' => '<p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all of your results.</p>', 'UpdateAccountPasswordPolicyRequest$RequireSymbols' => '<p>Specifies whether IAM user passwords must contain at least one of the following non-alphanumeric characters:</p> <p>! @ # $ % ^ &amp;amp; * ( ) _ + - = [ ] { } | \'</p> <p>Default value: false</p>', 'UpdateAccountPasswordPolicyRequest$RequireNumbers' => '<p>Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).</p> <p>Default value: false</p>', 'UpdateAccountPasswordPolicyRequest$RequireUppercaseCharacters' => '<p>Specifies whether IAM user passwords must contain at least one uppercase character from the ISO basic Latin alphabet (A to Z).</p> <p>Default value: false</p>', 'UpdateAccountPasswordPolicyRequest$RequireLowercaseCharacters' => '<p>Specifies whether IAM user passwords must contain at least one lowercase character from the ISO basic Latin alphabet (a to z).</p> <p>Default value: false</p>', 'UpdateAccountPasswordPolicyRequest$AllowUsersToChangePassword' => '<p> Allows all IAM users in your account to use the AWS Management Console to change their own passwords. For more information, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/HowToPwdIAMUser.html">Letting IAM Users Change Their Own Passwords</a> in the <i>IAM User Guide</i>.</p> <p>Default value: false</p>', ], ], 'certificateBodyType' => [ 'base' => NULL, 'refs' => [ 'ServerCertificate$CertificateBody' => '<p>The contents of the public key certificate.</p>', 'SigningCertificate$CertificateBody' => '<p>The contents of the signing certificate.</p>', 'UploadServerCertificateRequest$CertificateBody' => '<p>The contents of the public key certificate in PEM-encoded format.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', 'UploadSigningCertificateRequest$CertificateBody' => '<p>The contents of the signing certificate.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', ], ], 'certificateChainType' => [ 'base' => NULL, 'refs' => [ 'ServerCertificate$CertificateChain' => '<p>The contents of the public key certificate chain.</p>', 'UploadServerCertificateRequest$CertificateChain' => '<p>The contents of the certificate chain. This is typically a concatenation of the PEM-encoded public key certificates of the chain.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', ], ], 'certificateIdType' => [ 'base' => NULL, 'refs' => [ 'DeleteSigningCertificateRequest$CertificateId' => '<p>The ID of the signing certificate to delete.</p> <p>The format of this parameter, as described by its <a href="http://wikipedia.org/wiki/regex">regex</a> pattern, is a string of characters that can be upper- or lower-cased letters or digits.</p>', 'SigningCertificate$CertificateId' => '<p>The ID for the signing certificate.</p>', 'UpdateSigningCertificateRequest$CertificateId' => '<p>The ID of the signing certificate you want to update.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>', ], ], 'certificateListType' => [ 'base' => '<p>Contains a list of signing certificates.</p> <p>This data type is used as a response element in the <a>ListSigningCertificates</a> action.</p>', 'refs' => [ 'ListSigningCertificatesResponse$Certificates' => '<p>A list of the user\'s signing certificate information.</p>', ], ], 'clientIDListType' => [ 'base' => NULL, 'refs' => [ 'CreateOpenIDConnectProviderRequest$ClientIDList' => '<p>A list of client IDs (also known as audiences). When a mobile or web app registers with an OpenID Connect provider, they establish a value that identifies the application. (This is the value that\'s sent as the <code>client_id</code> parameter on OAuth requests.)</p> <p>You can register multiple client IDs with the same provider. For example, you might have multiple applications that use the same OIDC provider. You cannot register more than 100 client IDs with a single IAM OIDC provider.</p> <p>There is no defined format for a client ID. The <code>CreateOpenIDConnectProviderRequest</code> action accepts client IDs up to 255 characters long.</p>', 'GetOpenIDConnectProviderResponse$ClientIDList' => '<p>A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC provider resource object. For more information, see <a>CreateOpenIDConnectProvider</a>.</p>', ], ], 'clientIDType' => [ 'base' => NULL, 'refs' => [ 'AddClientIDToOpenIDConnectProviderRequest$ClientID' => '<p>The client ID (also known as audience) to add to the IAM OpenID Connect provider resource.</p>', 'RemoveClientIDFromOpenIDConnectProviderRequest$ClientID' => '<p>The client ID (also known as audience) to remove from the IAM OIDC provider resource. For more information about client IDs, see <a>CreateOpenIDConnectProvider</a>.</p>', 'clientIDListType$member' => NULL, ], ], 'credentialReportExpiredExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'CredentialReportExpiredException$message' => NULL, ], ], 'credentialReportNotPresentExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'CredentialReportNotPresentException$message' => NULL, ], ], 'credentialReportNotReadyExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'CredentialReportNotReadyException$message' => NULL, ], ], 'customSuffixType' => [ 'base' => NULL, 'refs' => [ 'CreateServiceLinkedRoleRequest$CustomSuffix' => '<p>A string that you provide, which is combined with the service name to form the complete role name. If you make multiple requests for the same service, then you must supply a different <code>CustomSuffix</code> for each request. Otherwise the request fails with a duplicate role name error. For example, you could add <code>-1</code> or <code>-debug</code> to the suffix.</p>', ], ], 'dateType' => [ 'base' => NULL, 'refs' => [ 'AccessKey$CreateDate' => '<p>The date when the access key was created.</p>', 'AccessKeyLastUsed$LastUsedDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the access key was most recently used. This field is null when:</p> <ul> <li> <p>The user does not have an access key.</p> </li> <li> <p>An access key exists but has never been used, at least not since IAM started tracking this information on April 22nd, 2015.</p> </li> <li> <p>There is no sign-in data associated with the user</p> </li> </ul>', 'AccessKeyMetadata$CreateDate' => '<p>The date when the access key was created.</p>', 'GetCredentialReportResponse$GeneratedTime' => '<p> The date and time when the credential report was created, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>.</p>', 'GetOpenIDConnectProviderResponse$CreateDate' => '<p>The date and time when the IAM OIDC provider resource object was created in the AWS account.</p>', 'GetSAMLProviderResponse$CreateDate' => '<p>The date and time when the SAML provider was created.</p>', 'GetSAMLProviderResponse$ValidUntil' => '<p>The expiration date and time for the SAML provider.</p>', 'Group$CreateDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the group was created.</p>', 'GroupDetail$CreateDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the group was created.</p>', 'InstanceProfile$CreateDate' => '<p>The date when the instance profile was created.</p>', 'LoginProfile$CreateDate' => '<p>The date when the password for the user was created.</p>', 'MFADevice$EnableDate' => '<p>The date when the MFA device was enabled for the user.</p>', 'ManagedPolicyDetail$CreateDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the policy was created.</p>', 'ManagedPolicyDetail$UpdateDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the policy was last updated.</p> <p>When a policy has only one version, this field contains the date and time when the policy was created. When a policy has more than one version, this field contains the date and time when the most recent policy version was created.</p>', 'Policy$CreateDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the policy was created.</p>', 'Policy$UpdateDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the policy was last updated.</p> <p>When a policy has only one version, this field contains the date and time when the policy was created. When a policy has more than one version, this field contains the date and time when the most recent policy version was created.</p>', 'PolicyVersion$CreateDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the policy version was created.</p>', 'Role$CreateDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the role was created.</p>', 'RoleDetail$CreateDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the role was created.</p>', 'SAMLProviderListEntry$ValidUntil' => '<p>The expiration date and time for the SAML provider.</p>', 'SAMLProviderListEntry$CreateDate' => '<p>The date and time when the SAML provider was created.</p>', 'SSHPublicKey$UploadDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the SSH public key was uploaded.</p>', 'SSHPublicKeyMetadata$UploadDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the SSH public key was uploaded.</p>', 'ServerCertificateMetadata$UploadDate' => '<p>The date when the server certificate was uploaded.</p>', 'ServerCertificateMetadata$Expiration' => '<p>The date on which the certificate is set to expire.</p>', 'ServiceSpecificCredential$CreateDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the service-specific credential were created.</p>', 'ServiceSpecificCredentialMetadata$CreateDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the service-specific credential were created.</p>', 'SigningCertificate$UploadDate' => '<p>The date when the signing certificate was uploaded.</p>', 'User$CreateDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the user was created.</p>', 'User$PasswordLastUsed' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the user\'s password was last used to sign in to an AWS website. For a list of AWS websites that capture a user\'s last sign-in time, see the <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Credential Reports</a> topic in the <i>Using IAM</i> guide. If a password is used more than once in a five-minute span, only the first use is returned in this field. This field is null (not present) when:</p> <ul> <li> <p>The user does not have a password</p> </li> <li> <p>The password exists but has never been used (at least not since IAM started tracking this information on October 20th, 2014</p> </li> <li> <p>there is no sign-in data associated with the user</p> </li> </ul> <p>This value is returned only in the <a>GetUser</a> and <a>ListUsers</a> actions. </p>', 'UserDetail$CreateDate' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the user was created.</p>', 'VirtualMFADevice$EnableDate' => '<p>The date and time on which the virtual MFA device was enabled.</p>', ], ], 'deleteConflictMessage' => [ 'base' => NULL, 'refs' => [ 'DeleteConflictException$message' => NULL, ], ], 'duplicateCertificateMessage' => [ 'base' => NULL, 'refs' => [ 'DuplicateCertificateException$message' => NULL, ], ], 'duplicateSSHPublicKeyMessage' => [ 'base' => NULL, 'refs' => [ 'DuplicateSSHPublicKeyException$message' => NULL, ], ], 'encodingType' => [ 'base' => NULL, 'refs' => [ 'GetSSHPublicKeyRequest$Encoding' => '<p>Specifies the public key encoding format to use in the response. To retrieve the public key in ssh-rsa format, use <code>SSH</code>. To retrieve the public key in PEM format, use <code>PEM</code>.</p>', ], ], 'entityAlreadyExistsMessage' => [ 'base' => NULL, 'refs' => [ 'EntityAlreadyExistsException$message' => NULL, ], ], 'entityListType' => [ 'base' => NULL, 'refs' => [ 'GetAccountAuthorizationDetailsRequest$Filter' => '<p>A list of entity types used to filter the results. Only the entities that match the types you specify are included in the output. Use the value <code>LocalManagedPolicy</code> to include customer managed policies.</p> <p>The format for this parameter is a comma-separated (if more than one) list of strings. Each string value in the list must be one of the valid values listed below.</p>', ], ], 'entityTemporarilyUnmodifiableMessage' => [ 'base' => NULL, 'refs' => [ 'EntityTemporarilyUnmodifiableException$message' => NULL, ], ], 'existingUserNameType' => [ 'base' => NULL, 'refs' => [ 'AddUserToGroupRequest$UserName' => '<p>The name of the user to add.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'CreateAccessKeyRequest$UserName' => '<p>The name of the IAM user that the new key will belong to.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DeactivateMFADeviceRequest$UserName' => '<p>The name of the user whose MFA device you want to deactivate.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DeleteAccessKeyRequest$UserName' => '<p>The name of the user whose access key pair you want to delete.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DeleteSigningCertificateRequest$UserName' => '<p>The name of the user the signing certificate belongs to.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DeleteUserPolicyRequest$UserName' => '<p>The name (friendly name, not ARN) identifying the user that the policy is embedded in.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DeleteUserRequest$UserName' => '<p>The name of the user to delete.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'EnableMFADeviceRequest$UserName' => '<p>The name of the IAM user for whom you want to enable the MFA device.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'GetAccessKeyLastUsedResponse$UserName' => '<p>The name of the AWS IAM user that owns this access key.</p> <p/>', 'GetUserPolicyRequest$UserName' => '<p>The name of the user who the policy is associated with.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'GetUserPolicyResponse$UserName' => '<p>The user the policy is associated with.</p>', 'GetUserRequest$UserName' => '<p>The name of the user to get information about.</p> <p>This parameter is optional. If it is not included, it defaults to the user making the request. This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'ListAccessKeysRequest$UserName' => '<p>The name of the user.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'ListGroupsForUserRequest$UserName' => '<p>The name of the user to list groups for.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'ListMFADevicesRequest$UserName' => '<p>The name of the user whose MFA devices you want to list.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'ListSigningCertificatesRequest$UserName' => '<p>The name of the IAM user whose signing certificates you want to examine.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'ListUserPoliciesRequest$UserName' => '<p>The name of the user to list policies for.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'PutUserPolicyRequest$UserName' => '<p>The name of the user to associate the policy with.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'RemoveUserFromGroupRequest$UserName' => '<p>The name of the user to remove.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'ResyncMFADeviceRequest$UserName' => '<p>The name of the user whose MFA device you want to resynchronize.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'UpdateAccessKeyRequest$UserName' => '<p>The name of the user whose key you want to update.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'UpdateSigningCertificateRequest$UserName' => '<p>The name of the IAM user the signing certificate belongs to.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'UpdateUserRequest$UserName' => '<p>Name of the user to update. If you\'re changing the name of the user, this is the original user name.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'UploadSigningCertificateRequest$UserName' => '<p>The name of the user the signing certificate is for.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', ], ], 'groupDetailListType' => [ 'base' => NULL, 'refs' => [ 'GetAccountAuthorizationDetailsResponse$GroupDetailList' => '<p>A list containing information about IAM groups.</p>', ], ], 'groupListType' => [ 'base' => '<p>Contains a list of IAM groups.</p> <p>This data type is used as a response element in the <a>ListGroups</a> action.</p>', 'refs' => [ 'ListGroupsForUserResponse$Groups' => '<p>A list of groups.</p>', 'ListGroupsResponse$Groups' => '<p>A list of groups.</p>', ], ], 'groupNameListType' => [ 'base' => NULL, 'refs' => [ 'UserDetail$GroupList' => '<p>A list of IAM groups that the user is in.</p>', ], ], 'groupNameType' => [ 'base' => NULL, 'refs' => [ 'AddUserToGroupRequest$GroupName' => '<p>The name of the group to update.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'AttachGroupPolicyRequest$GroupName' => '<p>The name (friendly name, not ARN) of the group to attach the policy to.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'CreateGroupRequest$GroupName' => '<p>The name of the group to create. Do not include the path in this value.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-. The group name must be unique within the account. Group names are not distinguished by case. For example, you cannot create groups named both "ADMINS" and "admins".</p>', 'CreateServiceLinkedRoleRequest$AWSServiceName' => '<p>The AWS service to which this role is attached. You use a string similar to a URL but without the http:// in front. For example: <code>elasticbeanstalk.amazonaws.com</code> </p>', 'DeleteGroupPolicyRequest$GroupName' => '<p>The name (friendly name, not ARN) identifying the group that the policy is embedded in.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DeleteGroupRequest$GroupName' => '<p>The name of the IAM group to delete.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DetachGroupPolicyRequest$GroupName' => '<p>The name (friendly name, not ARN) of the IAM group to detach the policy from.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'GetGroupPolicyRequest$GroupName' => '<p>The name of the group the policy is associated with.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'GetGroupPolicyResponse$GroupName' => '<p>The group the policy is associated with.</p>', 'GetGroupRequest$GroupName' => '<p>The name of the group.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'Group$GroupName' => '<p>The friendly name that identifies the group.</p>', 'GroupDetail$GroupName' => '<p>The friendly name that identifies the group.</p>', 'ListAttachedGroupPoliciesRequest$GroupName' => '<p>The name (friendly name, not ARN) of the group to list attached policies for.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'ListGroupPoliciesRequest$GroupName' => '<p>The name of the group to list policies for.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'PolicyGroup$GroupName' => '<p>The name (friendly name, not ARN) identifying the group.</p>', 'PutGroupPolicyRequest$GroupName' => '<p>The name of the group to associate the policy with.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'RemoveUserFromGroupRequest$GroupName' => '<p>The name of the group to update.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'UpdateGroupRequest$GroupName' => '<p>Name of the IAM group to update. If you\'re changing the name of the group, this is the original name.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'UpdateGroupRequest$NewGroupName' => '<p>New name for the IAM group. Only include this if changing the group\'s name.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'groupNameListType$member' => NULL, ], ], 'idType' => [ 'base' => NULL, 'refs' => [ 'Group$GroupId' => '<p> The stable and unique string identifying the group. For more information about IDs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide. </p>', 'GroupDetail$GroupId' => '<p>The stable and unique string identifying the group. For more information about IDs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide.</p>', 'InstanceProfile$InstanceProfileId' => '<p> The stable and unique string identifying the instance profile. For more information about IDs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide. </p>', 'ManagedPolicyDetail$PolicyId' => '<p>The stable and unique string identifying the policy.</p> <p>For more information about IDs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide.</p>', 'Policy$PolicyId' => '<p>The stable and unique string identifying the policy.</p> <p>For more information about IDs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide.</p>', 'PolicyGroup$GroupId' => '<p>The stable and unique string identifying the group. For more information about IDs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>', 'PolicyRole$RoleId' => '<p>The stable and unique string identifying the role. For more information about IDs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>', 'PolicyUser$UserId' => '<p>The stable and unique string identifying the user. For more information about IDs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>', 'Role$RoleId' => '<p> The stable and unique string identifying the role. For more information about IDs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide. </p>', 'RoleDetail$RoleId' => '<p>The stable and unique string identifying the role. For more information about IDs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide.</p>', 'ServerCertificateMetadata$ServerCertificateId' => '<p> The stable and unique string identifying the server certificate. For more information about IDs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide. </p>', 'User$UserId' => '<p>The stable and unique string identifying the user. For more information about IDs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide.</p>', 'UserDetail$UserId' => '<p>The stable and unique string identifying the user. For more information about IDs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide.</p>', ], ], 'instanceProfileListType' => [ 'base' => '<p>Contains a list of instance profiles.</p>', 'refs' => [ 'ListInstanceProfilesForRoleResponse$InstanceProfiles' => '<p>A list of instance profiles.</p>', 'ListInstanceProfilesResponse$InstanceProfiles' => '<p>A list of instance profiles.</p>', 'RoleDetail$InstanceProfileList' => '<p>A list of instance profiles that contain this role.</p>', ], ], 'instanceProfileNameType' => [ 'base' => NULL, 'refs' => [ 'AddRoleToInstanceProfileRequest$InstanceProfileName' => '<p>The name of the instance profile to update.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'CreateInstanceProfileRequest$InstanceProfileName' => '<p>The name of the instance profile to create.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DeleteInstanceProfileRequest$InstanceProfileName' => '<p>The name of the instance profile to delete.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'GetInstanceProfileRequest$InstanceProfileName' => '<p>The name of the instance profile to get information about.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'InstanceProfile$InstanceProfileName' => '<p>The name identifying the instance profile.</p>', 'RemoveRoleFromInstanceProfileRequest$InstanceProfileName' => '<p>The name of the instance profile to update.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', ], ], 'invalidAuthenticationCodeMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidAuthenticationCodeException$message' => NULL, ], ], 'invalidCertificateMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidCertificateException$message' => NULL, ], ], 'invalidInputMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidInputException$message' => NULL, ], ], 'invalidPublicKeyMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidPublicKeyException$message' => NULL, ], ], 'invalidUserTypeMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidUserTypeException$message' => NULL, ], ], 'keyPairMismatchMessage' => [ 'base' => NULL, 'refs' => [ 'KeyPairMismatchException$message' => NULL, ], ], 'limitExceededMessage' => [ 'base' => NULL, 'refs' => [ 'LimitExceededException$message' => NULL, ], ], 'malformedCertificateMessage' => [ 'base' => NULL, 'refs' => [ 'MalformedCertificateException$message' => NULL, ], ], 'malformedPolicyDocumentMessage' => [ 'base' => NULL, 'refs' => [ 'MalformedPolicyDocumentException$message' => NULL, ], ], 'markerType' => [ 'base' => NULL, 'refs' => [ 'GetAccountAuthorizationDetailsRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'GetAccountAuthorizationDetailsResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'GetGroupRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'GetGroupResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListAccessKeysRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListAccessKeysResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListAccountAliasesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListAccountAliasesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListAttachedGroupPoliciesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListAttachedGroupPoliciesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListAttachedRolePoliciesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListAttachedRolePoliciesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListAttachedUserPoliciesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListAttachedUserPoliciesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListEntitiesForPolicyRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListEntitiesForPolicyResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListGroupPoliciesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListGroupPoliciesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListGroupsForUserRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListGroupsForUserResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListGroupsRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListGroupsResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListInstanceProfilesForRoleRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListInstanceProfilesForRoleResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListInstanceProfilesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListInstanceProfilesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListMFADevicesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListMFADevicesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListPoliciesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListPoliciesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListPolicyVersionsRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListPolicyVersionsResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListRolePoliciesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListRolePoliciesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListRolesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListRolesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListSSHPublicKeysRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListSSHPublicKeysResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListServerCertificatesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListServerCertificatesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListSigningCertificatesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListSigningCertificatesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListUserPoliciesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListUserPoliciesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListUsersRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListUsersResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'ListVirtualMFADevicesRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'ListVirtualMFADevicesResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'SimulateCustomPolicyRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', 'SimulatePolicyResponse$Marker' => '<p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>', 'SimulatePrincipalPolicyRequest$Marker' => '<p>Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to indicate where the next call should start.</p>', ], ], 'maxItemsType' => [ 'base' => NULL, 'refs' => [ 'GetAccountAuthorizationDetailsRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'GetGroupRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListAccessKeysRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListAccountAliasesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListAttachedGroupPoliciesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListAttachedRolePoliciesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListAttachedUserPoliciesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListEntitiesForPolicyRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListGroupPoliciesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListGroupsForUserRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListGroupsRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListInstanceProfilesForRoleRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListInstanceProfilesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListMFADevicesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListPoliciesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListPolicyVersionsRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListRolePoliciesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListRolesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListSSHPublicKeysRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListServerCertificatesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListSigningCertificatesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListUserPoliciesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListUsersRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'ListVirtualMFADevicesRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'SimulateCustomPolicyRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', 'SimulatePrincipalPolicyRequest$MaxItems' => '<p>(Optional) Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p> <p>If you do not include this parameter, it defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the <code>IsTruncated</code> response element returns <code>true</code> and <code>Marker</code> contains a value to include in the subsequent call that tells the service where to continue from.</p>', ], ], 'maxPasswordAgeType' => [ 'base' => NULL, 'refs' => [ 'PasswordPolicy$MaxPasswordAge' => '<p>The number of days that an IAM user password is valid.</p>', 'UpdateAccountPasswordPolicyRequest$MaxPasswordAge' => '<p>The number of days that an IAM user password is valid. The default value of 0 means IAM user passwords never expire.</p> <p>Default value: 0</p>', ], ], 'mfaDeviceListType' => [ 'base' => '<p>Contains a list of MFA devices.</p> <p>This data type is used as a response element in the <a>ListMFADevices</a> and <a>ListVirtualMFADevices</a> actions. </p>', 'refs' => [ 'ListMFADevicesResponse$MFADevices' => '<p>A list of MFA devices.</p>', ], ], 'minimumPasswordLengthType' => [ 'base' => NULL, 'refs' => [ 'PasswordPolicy$MinimumPasswordLength' => '<p>Minimum length to require for IAM user passwords.</p>', 'UpdateAccountPasswordPolicyRequest$MinimumPasswordLength' => '<p>The minimum number of characters allowed in an IAM user password.</p> <p>Default value: 6</p>', ], ], 'noSuchEntityMessage' => [ 'base' => NULL, 'refs' => [ 'NoSuchEntityException$message' => NULL, ], ], 'passwordPolicyViolationMessage' => [ 'base' => NULL, 'refs' => [ 'PasswordPolicyViolationException$message' => NULL, ], ], 'passwordReusePreventionType' => [ 'base' => NULL, 'refs' => [ 'PasswordPolicy$PasswordReusePrevention' => '<p>Specifies the number of previous passwords that IAM users are prevented from reusing.</p>', 'UpdateAccountPasswordPolicyRequest$PasswordReusePrevention' => '<p>Specifies the number of previous passwords that IAM users are prevented from reusing. The default value of 0 means IAM users are not prevented from reusing previous passwords.</p> <p>Default value: 0</p>', ], ], 'passwordType' => [ 'base' => NULL, 'refs' => [ 'ChangePasswordRequest$OldPassword' => '<p>The IAM user\'s current password.</p>', 'ChangePasswordRequest$NewPassword' => '<p>The new password. The new password must conform to the AWS account\'s password policy, if one exists.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of almost any printable ASCII character from the space (\\u0020) through the end of the ASCII character range (\\u00FF). You can also include the tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D) characters. Although any of these characters are valid in a password, note that many tools, such as the AWS Management Console, might restrict the ability to enter certain characters because they have special meaning within that tool.</p>', 'CreateLoginProfileRequest$Password' => '<p>The new password for the user.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of almost any printable ASCII character from the space (\\u0020) through the end of the ASCII character range (\\u00FF). You can also include the tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D) characters. Although any of these characters are valid in a password, note that many tools, such as the AWS Management Console, might restrict the ability to enter certain characters because they have special meaning within that tool.</p>', 'UpdateLoginProfileRequest$Password' => '<p>The new password for the specified IAM user.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D). However, the format can be further restricted by the account administrator by setting a password policy on the AWS account. For more information, see <a>UpdateAccountPasswordPolicy</a>.</p>', ], ], 'pathPrefixType' => [ 'base' => NULL, 'refs' => [ 'ListGroupsRequest$PathPrefix' => '<p> The path prefix for filtering the results. For example, the prefix <code>/division_abc/subdivision_xyz/</code> gets all groups whose path starts with <code>/division_abc/subdivision_xyz/</code>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing all groups. This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'ListInstanceProfilesRequest$PathPrefix' => '<p> The path prefix for filtering the results. For example, the prefix <code>/application_abc/component_xyz/</code> gets all instance profiles whose path starts with <code>/application_abc/component_xyz/</code>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing all instance profiles. This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'ListRolesRequest$PathPrefix' => '<p> The path prefix for filtering the results. For example, the prefix <code>/application_abc/component_xyz/</code> gets all roles whose path starts with <code>/application_abc/component_xyz/</code>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing all roles. This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'ListServerCertificatesRequest$PathPrefix' => '<p> The path prefix for filtering the results. For example: <code>/company/servercerts</code> would get all server certificates for which the path starts with <code>/company/servercerts</code>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing all server certificates. This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'ListUsersRequest$PathPrefix' => '<p> The path prefix for filtering the results. For example: <code>/division_abc/subdivision_xyz/</code>, which would get all user names whose path starts with <code>/division_abc/subdivision_xyz/</code>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing all user names. This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', ], ], 'pathType' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$Path' => '<p> The path to the group. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p> <p>This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'CreateInstanceProfileRequest$Path' => '<p> The path to the instance profile. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p> <p>This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'CreateRoleRequest$Path' => '<p> The path to the role. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p> <p>This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'CreateUserRequest$Path' => '<p> The path for the user name. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p> <p>This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'CreateVirtualMFADeviceRequest$Path' => '<p> The path for the virtual MFA device. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p> <p>This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'Group$Path' => '<p>The path to the group. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide. </p>', 'GroupDetail$Path' => '<p>The path to the group. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide.</p>', 'InstanceProfile$Path' => '<p> The path to the instance profile. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide. </p>', 'ListEntitiesForPolicyRequest$PathPrefix' => '<p>The path prefix for filtering the results. This parameter is optional. If it is not included, it defaults to a slash (/), listing all entities.</p> <p>This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'Role$Path' => '<p> The path to the role. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide. </p>', 'RoleDetail$Path' => '<p>The path to the role. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide.</p>', 'ServerCertificateMetadata$Path' => '<p> The path to the server certificate. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide. </p>', 'UpdateGroupRequest$NewPath' => '<p>New path for the IAM group. Only include this if changing the group\'s path.</p> <p>This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'UpdateServerCertificateRequest$NewPath' => '<p>The new path for the server certificate. Include this only if you are updating the server certificate\'s path.</p> <p>This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'UpdateUserRequest$NewPath' => '<p>New path for the IAM user. Include this parameter only if you\'re changing the user\'s path.</p> <p>This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'UploadServerCertificateRequest$Path' => '<p>The path for the server certificate. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/). This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p> <note> <p> If you are uploading a server certificate specifically for use with Amazon CloudFront distributions, you must specify a path using the <code>--path</code> option. The path must begin with <code>/cloudfront</code> and must include a trailing slash (for example, <code>/cloudfront/test/</code>).</p> </note>', 'User$Path' => '<p>The path to the user. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide.</p>', 'UserDetail$Path' => '<p>The path to the user. For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide.</p>', ], ], 'policyDescriptionType' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyRequest$Description' => '<p>A friendly description of the policy.</p> <p>Typically used to store information about the permissions defined in the policy. For example, "Grants access to production DynamoDB tables."</p> <p>The policy description is immutable. After a value is assigned, it cannot be changed.</p>', 'ManagedPolicyDetail$Description' => '<p>A friendly description of the policy.</p>', 'Policy$Description' => '<p>A friendly description of the policy.</p> <p>This element is included in the response to the <a>GetPolicy</a> operation. It is not included in the response to the <a>ListPolicies</a> operation. </p>', ], ], 'policyDetailListType' => [ 'base' => NULL, 'refs' => [ 'GroupDetail$GroupPolicyList' => '<p>A list of the inline policies embedded in the group.</p>', 'RoleDetail$RolePolicyList' => '<p>A list of inline policies embedded in the role. These policies are the role\'s access (permissions) policies.</p>', 'UserDetail$UserPolicyList' => '<p>A list of the inline policies embedded in the user.</p>', ], ], 'policyDocumentType' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyRequest$PolicyDocument' => '<p>The JSON policy document that you want to use as the content for the new policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', 'CreatePolicyVersionRequest$PolicyDocument' => '<p>The JSON policy document that you want to use as the content for this new version of the policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', 'CreateRoleRequest$AssumeRolePolicyDocument' => '<p>The trust relationship policy document that grants an entity permission to assume the role.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', 'GetGroupPolicyResponse$PolicyDocument' => '<p>The policy document.</p>', 'GetRolePolicyResponse$PolicyDocument' => '<p>The policy document.</p>', 'GetUserPolicyResponse$PolicyDocument' => '<p>The policy document.</p>', 'PolicyDetail$PolicyDocument' => '<p>The policy document.</p>', 'PolicyVersion$Document' => '<p>The policy document.</p> <p>The policy document is returned in the response to the <a>GetPolicyVersion</a> and <a>GetAccountAuthorizationDetails</a> operations. It is not returned in the response to the <a>CreatePolicyVersion</a> or <a>ListPolicyVersions</a> operations. </p>', 'PutGroupPolicyRequest$PolicyDocument' => '<p>The policy document.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', 'PutRolePolicyRequest$PolicyDocument' => '<p>The policy document.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', 'PutUserPolicyRequest$PolicyDocument' => '<p>The policy document.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', 'Role$AssumeRolePolicyDocument' => '<p>The policy that grants an entity permission to assume the role.</p>', 'RoleDetail$AssumeRolePolicyDocument' => '<p>The trust policy that grants permission to assume the role.</p>', 'SimulateCustomPolicyRequest$ResourcePolicy' => '<p>A resource-based policy to include in the simulation provided as a string. Each resource in the simulation is treated as if it had this policy attached. You can include only one resource-based policy in a simulation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', 'SimulatePrincipalPolicyRequest$ResourcePolicy' => '<p>A resource-based policy to include in the simulation provided as a string. Each resource in the simulation is treated as if it had this policy attached. You can include only one resource-based policy in a simulation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', 'SimulationPolicyListType$member' => NULL, 'UpdateAssumeRolePolicyRequest$PolicyDocument' => '<p>The policy that grants an entity permission to assume the role.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', ], ], 'policyDocumentVersionListType' => [ 'base' => NULL, 'refs' => [ 'ListPolicyVersionsResponse$Versions' => '<p>A list of policy versions.</p> <p>For more information about managed policy versions, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for Managed Policies</a> in the <i>IAM User Guide</i>.</p>', 'ManagedPolicyDetail$PolicyVersionList' => '<p>A list containing information about the versions of the policy.</p>', ], ], 'policyEvaluationErrorMessage' => [ 'base' => NULL, 'refs' => [ 'PolicyEvaluationException$message' => NULL, ], ], 'policyListType' => [ 'base' => NULL, 'refs' => [ 'ListPoliciesResponse$Policies' => '<p>A list of policies.</p>', ], ], 'policyNameListType' => [ 'base' => '<p>Contains a list of policy names.</p> <p>This data type is used as a response element in the <a>ListPolicies</a> action.</p>', 'refs' => [ 'ListGroupPoliciesResponse$PolicyNames' => '<p>A list of policy names.</p>', 'ListRolePoliciesResponse$PolicyNames' => '<p>A list of policy names.</p>', 'ListUserPoliciesResponse$PolicyNames' => '<p>A list of policy names.</p>', ], ], 'policyNameType' => [ 'base' => NULL, 'refs' => [ 'AttachedPolicy$PolicyName' => '<p>The friendly name of the attached policy.</p>', 'CreatePolicyRequest$PolicyName' => '<p>The friendly name of the policy.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DeleteGroupPolicyRequest$PolicyName' => '<p>The name identifying the policy document to delete.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DeleteRolePolicyRequest$PolicyName' => '<p>The name of the inline policy to delete from the specified IAM role.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DeleteUserPolicyRequest$PolicyName' => '<p>The name identifying the policy document to delete.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'GetGroupPolicyRequest$PolicyName' => '<p>The name of the policy document to get.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'GetGroupPolicyResponse$PolicyName' => '<p>The name of the policy.</p>', 'GetRolePolicyRequest$PolicyName' => '<p>The name of the policy document to get.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'GetRolePolicyResponse$PolicyName' => '<p>The name of the policy.</p>', 'GetUserPolicyRequest$PolicyName' => '<p>The name of the policy document to get.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'GetUserPolicyResponse$PolicyName' => '<p>The name of the policy.</p>', 'ManagedPolicyDetail$PolicyName' => '<p>The friendly name (not ARN) identifying the policy.</p>', 'Policy$PolicyName' => '<p>The friendly name (not ARN) identifying the policy.</p>', 'PolicyDetail$PolicyName' => '<p>The name of the policy.</p>', 'PutGroupPolicyRequest$PolicyName' => '<p>The name of the policy document.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'PutRolePolicyRequest$PolicyName' => '<p>The name of the policy document.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'PutUserPolicyRequest$PolicyName' => '<p>The name of the policy document.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'policyNameListType$member' => NULL, ], ], 'policyPathType' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyRequest$Path' => '<p>The path for the policy.</p> <p>For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p> <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p> <p>This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'ListAttachedGroupPoliciesRequest$PathPrefix' => '<p>The path prefix for filtering the results. This parameter is optional. If it is not included, it defaults to a slash (/), listing all policies.</p> <p>This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'ListAttachedRolePoliciesRequest$PathPrefix' => '<p>The path prefix for filtering the results. This parameter is optional. If it is not included, it defaults to a slash (/), listing all policies.</p> <p>This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'ListAttachedUserPoliciesRequest$PathPrefix' => '<p>The path prefix for filtering the results. This parameter is optional. If it is not included, it defaults to a slash (/), listing all policies.</p> <p>This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'ListPoliciesRequest$PathPrefix' => '<p>The path prefix for filtering the results. This parameter is optional. If it is not included, it defaults to a slash (/), listing all policies. This paramater allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes, containing any ASCII character from the ! (\\u0021) thru the DEL character (\\u007F), including most punctuation characters, digits, and upper and lowercased letters.</p>', 'ManagedPolicyDetail$Path' => '<p>The path to the policy.</p> <p>For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide.</p>', 'Policy$Path' => '<p>The path to the policy.</p> <p>For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>Using IAM</i> guide.</p>', ], ], 'policyScopeType' => [ 'base' => NULL, 'refs' => [ 'ListPoliciesRequest$Scope' => '<p>The scope to use for filtering the results.</p> <p>To list only AWS managed policies, set <code>Scope</code> to <code>AWS</code>. To list only the customer managed policies in your AWS account, set <code>Scope</code> to <code>Local</code>.</p> <p>This parameter is optional. If it is not included, or if it is set to <code>All</code>, all policies are returned.</p>', ], ], 'policyVersionIdType' => [ 'base' => NULL, 'refs' => [ 'DeletePolicyVersionRequest$VersionId' => '<p>The policy version to delete.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consists of the lowercase letter \'v\' followed by one or two digits, and optionally followed by a period \'.\' and a string of letters and digits.</p> <p>For more information about managed policy versions, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for Managed Policies</a> in the <i>IAM User Guide</i>.</p>', 'GetPolicyVersionRequest$VersionId' => '<p>Identifies the policy version to retrieve.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consists of the lowercase letter \'v\' followed by one or two digits, and optionally followed by a period \'.\' and a string of letters and digits.</p>', 'ManagedPolicyDetail$DefaultVersionId' => '<p>The identifier for the version of the policy that is set as the default (operative) version.</p> <p>For more information about policy versions, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for Managed Policies</a> in the <i>Using IAM</i> guide. </p>', 'Policy$DefaultVersionId' => '<p>The identifier for the version of the policy that is set as the default version.</p>', 'PolicyVersion$VersionId' => '<p>The identifier for the policy version.</p> <p>Policy version identifiers always begin with <code>v</code> (always lowercase). When a policy is created, the first policy version is <code>v1</code>. </p>', 'SetDefaultPolicyVersionRequest$VersionId' => '<p>The version of the policy to set as the default (operative) version.</p> <p>For more information about managed policy versions, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for Managed Policies</a> in the <i>IAM User Guide</i>.</p>', ], ], 'privateKeyType' => [ 'base' => NULL, 'refs' => [ 'UploadServerCertificateRequest$PrivateKey' => '<p>The contents of the private key in PEM-encoded format.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', ], ], 'publicKeyFingerprintType' => [ 'base' => NULL, 'refs' => [ 'SSHPublicKey$Fingerprint' => '<p>The MD5 message digest of the SSH public key.</p>', ], ], 'publicKeyIdType' => [ 'base' => NULL, 'refs' => [ 'DeleteSSHPublicKeyRequest$SSHPublicKeyId' => '<p>The unique identifier for the SSH public key.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>', 'GetSSHPublicKeyRequest$SSHPublicKeyId' => '<p>The unique identifier for the SSH public key.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>', 'SSHPublicKey$SSHPublicKeyId' => '<p>The unique identifier for the SSH public key.</p>', 'SSHPublicKeyMetadata$SSHPublicKeyId' => '<p>The unique identifier for the SSH public key.</p>', 'UpdateSSHPublicKeyRequest$SSHPublicKeyId' => '<p>The unique identifier for the SSH public key.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>', ], ], 'publicKeyMaterialType' => [ 'base' => NULL, 'refs' => [ 'SSHPublicKey$SSHPublicKeyBody' => '<p>The SSH public key.</p>', 'UploadSSHPublicKeyRequest$SSHPublicKeyBody' => '<p>The SSH public key. The public key must be encoded in ssh-rsa format or PEM format.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of any printable ASCII character ranging from the space character (\\u0020) through end of the ASCII character range as well as the printable characters in the Basic Latin and Latin-1 Supplement character set (through \\u00FF). It also includes the special characters tab (\\u0009), line feed (\\u000A), and carriage return (\\u000D).</p>', ], ], 'roleDescriptionType' => [ 'base' => NULL, 'refs' => [ 'CreateRoleRequest$Description' => '<p>A customer-provided description of the role.</p>', 'CreateServiceLinkedRoleRequest$Description' => '<p>The description of the role.</p>', 'Role$Description' => '<p>A description of the role that you provide.</p>', 'UpdateRoleDescriptionRequest$Description' => '<p>The new description that you want to apply to the specified role.</p>', ], ], 'roleDetailListType' => [ 'base' => NULL, 'refs' => [ 'GetAccountAuthorizationDetailsResponse$RoleDetailList' => '<p>A list containing information about IAM roles.</p>', ], ], 'roleListType' => [ 'base' => '<p>Contains a list of IAM roles.</p> <p>This data type is used as a response element in the <a>ListRoles</a> action.</p>', 'refs' => [ 'InstanceProfile$Roles' => '<p>The role associated with the instance profile.</p>', 'ListRolesResponse$Roles' => '<p>A list of roles.</p>', ], ], 'roleNameType' => [ 'base' => NULL, 'refs' => [ 'AddRoleToInstanceProfileRequest$RoleName' => '<p>The name of the role to add.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>', 'AttachRolePolicyRequest$RoleName' => '<p>The name (friendly name, not ARN) of the role to attach the policy to.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>', 'CreateRoleRequest$RoleName' => '<p>The name of the role to create.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p> <p>Role names are not distinguished by case. For example, you cannot create roles named both "PRODROLE" and "prodrole".</p>', 'DeleteRolePolicyRequest$RoleName' => '<p>The name (friendly name, not ARN) identifying the role that the policy is embedded in.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>', 'DeleteRoleRequest$RoleName' => '<p>The name of the role to delete.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>', 'DetachRolePolicyRequest$RoleName' => '<p>The name (friendly name, not ARN) of the IAM role to detach the policy from.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>', 'GetRolePolicyRequest$RoleName' => '<p>The name of the role associated with the policy.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>', 'GetRolePolicyResponse$RoleName' => '<p>The role the policy is associated with.</p>', 'GetRoleRequest$RoleName' => '<p>The name of the IAM role to get information about.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>', 'ListAttachedRolePoliciesRequest$RoleName' => '<p>The name (friendly name, not ARN) of the role to list attached policies for.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>', 'ListInstanceProfilesForRoleRequest$RoleName' => '<p>The name of the role to list instance profiles for.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>', 'ListRolePoliciesRequest$RoleName' => '<p>The name of the role to list policies for.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>', 'PolicyRole$RoleName' => '<p>The name (friendly name, not ARN) identifying the role.</p>', 'PutRolePolicyRequest$RoleName' => '<p>The name of the role to associate the policy with.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>', 'RemoveRoleFromInstanceProfileRequest$RoleName' => '<p>The name of the role to remove.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>', 'Role$RoleName' => '<p>The friendly name that identifies the role.</p>', 'RoleDetail$RoleName' => '<p>The friendly name that identifies the role.</p>', 'UpdateAssumeRolePolicyRequest$RoleName' => '<p>The name of the role to update with the new policy.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>', 'UpdateRoleDescriptionRequest$RoleName' => '<p>The name of the role that you want to modify.</p>', ], ], 'serialNumberType' => [ 'base' => NULL, 'refs' => [ 'DeactivateMFADeviceRequest$SerialNumber' => '<p>The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@:/-</p>', 'DeleteVirtualMFADeviceRequest$SerialNumber' => '<p>The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the same as the ARN.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@:/-</p>', 'EnableMFADeviceRequest$SerialNumber' => '<p>The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@:/-</p>', 'MFADevice$SerialNumber' => '<p>The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN.</p>', 'ResyncMFADeviceRequest$SerialNumber' => '<p>Serial number that uniquely identifies the MFA device.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'VirtualMFADevice$SerialNumber' => '<p>The serial number associated with <code>VirtualMFADevice</code>.</p>', ], ], 'serverCertificateMetadataListType' => [ 'base' => NULL, 'refs' => [ 'ListServerCertificatesResponse$ServerCertificateMetadataList' => '<p>A list of server certificates.</p>', ], ], 'serverCertificateNameType' => [ 'base' => NULL, 'refs' => [ 'DeleteServerCertificateRequest$ServerCertificateName' => '<p>The name of the server certificate you want to delete.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'GetServerCertificateRequest$ServerCertificateName' => '<p>The name of the server certificate you want to retrieve information about.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'ServerCertificateMetadata$ServerCertificateName' => '<p>The name that identifies the server certificate.</p>', 'UpdateServerCertificateRequest$ServerCertificateName' => '<p>The name of the server certificate that you want to update.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'UpdateServerCertificateRequest$NewServerCertificateName' => '<p>The new name for the server certificate. Include this only if you are updating the server certificate\'s name. The name of the certificate cannot contain any spaces.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'UploadServerCertificateRequest$ServerCertificateName' => '<p>The name for the server certificate. Do not include the path in this value. The name of the certificate cannot contain any spaces.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', ], ], 'serviceFailureExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'ServiceFailureException$message' => NULL, ], ], 'serviceName' => [ 'base' => NULL, 'refs' => [ 'CreateServiceSpecificCredentialRequest$ServiceName' => '<p>The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials.</p>', 'ListServiceSpecificCredentialsRequest$ServiceName' => '<p>Filters the returned results to only those for the specified AWS service. If not specified, then AWS returns service-specific credentials for all services.</p>', 'ServiceSpecificCredential$ServiceName' => '<p>The name of the service associated with the service-specific credential.</p>', 'ServiceSpecificCredentialMetadata$ServiceName' => '<p>The name of the service associated with the service-specific credential.</p>', ], ], 'serviceNotSupportedMessage' => [ 'base' => NULL, 'refs' => [ 'ServiceNotSupportedException$message' => NULL, ], ], 'servicePassword' => [ 'base' => NULL, 'refs' => [ 'ServiceSpecificCredential$ServicePassword' => '<p>The generated password for the service-specific credential.</p>', ], ], 'serviceSpecificCredentialId' => [ 'base' => NULL, 'refs' => [ 'DeleteServiceSpecificCredentialRequest$ServiceSpecificCredentialId' => '<p>The unique identifier of the service-specific credential. You can get this value by calling <a>ListServiceSpecificCredentials</a>.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>', 'ResetServiceSpecificCredentialRequest$ServiceSpecificCredentialId' => '<p>The unique identifier of the service-specific credential.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>', 'ServiceSpecificCredential$ServiceSpecificCredentialId' => '<p>The unique identifier for the service-specific credential.</p>', 'ServiceSpecificCredentialMetadata$ServiceSpecificCredentialId' => '<p>The unique identifier for the service-specific credential.</p>', 'UpdateServiceSpecificCredentialRequest$ServiceSpecificCredentialId' => '<p>The unique identifier of the service-specific credential.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can consist of any upper or lowercased letter or digit.</p>', ], ], 'serviceUserName' => [ 'base' => NULL, 'refs' => [ 'ServiceSpecificCredential$ServiceUserName' => '<p>The generated user name for the service-specific credential. This value is generated by combining the IAM user\'s name combined with the ID number of the AWS account, as in <code>jane-at-123456789012</code>, for example. This value cannot be configured by the user.</p>', 'ServiceSpecificCredentialMetadata$ServiceUserName' => '<p>The generated user name for the service-specific credential.</p>', ], ], 'statusType' => [ 'base' => NULL, 'refs' => [ 'AccessKey$Status' => '<p>The status of the access key. <code>Active</code> means the key is valid for API calls, while <code>Inactive</code> means it is not. </p>', 'AccessKeyMetadata$Status' => '<p>The status of the access key. <code>Active</code> means the key is valid for API calls; <code>Inactive</code> means it is not.</p>', 'SSHPublicKey$Status' => '<p>The status of the SSH public key. <code>Active</code> means the key can be used for authentication with an AWS CodeCommit repository. <code>Inactive</code> means the key cannot be used.</p>', 'SSHPublicKeyMetadata$Status' => '<p>The status of the SSH public key. <code>Active</code> means the key can be used for authentication with an AWS CodeCommit repository. <code>Inactive</code> means the key cannot be used.</p>', 'ServiceSpecificCredential$Status' => '<p>The status of the service-specific credential. <code>Active</code> means the key is valid for API calls, while <code>Inactive</code> means it is not.</p>', 'ServiceSpecificCredentialMetadata$Status' => '<p>The status of the service-specific credential. <code>Active</code> means the key is valid for API calls, while <code>Inactive</code> means it is not.</p>', 'SigningCertificate$Status' => '<p>The status of the signing certificate. <code>Active</code> means the key is valid for API calls, while <code>Inactive</code> means it is not.</p>', 'UpdateAccessKeyRequest$Status' => '<p> The status you want to assign to the secret access key. <code>Active</code> means the key can be used for API calls to AWS, while <code>Inactive</code> means the key cannot be used.</p>', 'UpdateSSHPublicKeyRequest$Status' => '<p>The status to assign to the SSH public key. <code>Active</code> means the key can be used for authentication with an AWS CodeCommit repository. <code>Inactive</code> means the key cannot be used.</p>', 'UpdateServiceSpecificCredentialRequest$Status' => '<p>The status to be assigned to the service-specific credential.</p>', 'UpdateSigningCertificateRequest$Status' => '<p> The status you want to assign to the certificate. <code>Active</code> means the certificate can be used for API calls to AWS, while <code>Inactive</code> means the certificate cannot be used.</p>', ], ], 'stringType' => [ 'base' => NULL, 'refs' => [ 'AccessKeyLastUsed$ServiceName' => '<p>The name of the AWS service with which this access key was most recently used. This field displays "N/A" when:</p> <ul> <li> <p>The user does not have an access key.</p> </li> <li> <p>An access key exists but has never been used, at least not since IAM started tracking this information on April 22nd, 2015.</p> </li> <li> <p>There is no sign-in data associated with the user</p> </li> </ul>', 'AccessKeyLastUsed$Region' => '<p>The AWS region where this access key was most recently used. This field is displays "N/A" when:</p> <ul> <li> <p>The user does not have an access key.</p> </li> <li> <p>An access key exists but has never been used, at least not since IAM started tracking this information on April 22nd, 2015.</p> </li> <li> <p>There is no sign-in data associated with the user</p> </li> </ul> <p>For more information about AWS regions, see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>', ], ], 'summaryKeyType' => [ 'base' => NULL, 'refs' => [ 'summaryMapType$key' => NULL, ], ], 'summaryMapType' => [ 'base' => NULL, 'refs' => [ 'GetAccountSummaryResponse$SummaryMap' => '<p>A set of key value pairs containing information about IAM entity usage and IAM quotas.</p>', ], ], 'summaryValueType' => [ 'base' => NULL, 'refs' => [ 'summaryMapType$value' => NULL, ], ], 'thumbprintListType' => [ 'base' => '<p>Contains a list of thumbprints of identity provider server certificates.</p>', 'refs' => [ 'CreateOpenIDConnectProviderRequest$ThumbprintList' => '<p>A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider\'s server certificate(s). Typically this list includes only one entry. However, IAM lets you have up to five thumbprints for an OIDC provider. This lets you maintain multiple thumbprints if the identity provider is rotating certificates.</p> <p>The server certificate thumbprint is the hex-encoded SHA-1 hash value of the X.509 certificate used by the domain where the OpenID Connect provider makes its keys available. It is always a 40-character string.</p> <p>You must provide at least one thumbprint when creating an IAM OIDC provider. For example, if the OIDC provider is <code>server.example.com</code> and the provider stores its keys at "https://keys.server.example.com/openid-connect", the thumbprint string would be the hex-encoded SHA-1 hash value of the certificate used by https://keys.server.example.com.</p> <p>For more information about obtaining the OIDC provider\'s thumbprint, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html">Obtaining the Thumbprint for an OpenID Connect Provider</a> in the <i>IAM User Guide</i>.</p>', 'GetOpenIDConnectProviderResponse$ThumbprintList' => '<p>A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource object. For more information, see <a>CreateOpenIDConnectProvider</a>. </p>', 'UpdateOpenIDConnectProviderThumbprintRequest$ThumbprintList' => '<p>A list of certificate thumbprints that are associated with the specified IAM OpenID Connect provider. For more information, see <a>CreateOpenIDConnectProvider</a>. </p>', ], ], 'thumbprintType' => [ 'base' => '<p>Contains a thumbprint for an identity provider\'s server certificate.</p> <p>The identity provider\'s server certificate thumbprint is the hex-encoded SHA-1 hash value of the self-signed X.509 certificate used by the domain where the OpenID Connect provider makes its keys available. It is always a 40-character string.</p>', 'refs' => [ 'thumbprintListType$member' => NULL, ], ], 'unmodifiableEntityMessage' => [ 'base' => NULL, 'refs' => [ 'UnmodifiableEntityException$message' => NULL, ], ], 'unrecognizedPublicKeyEncodingMessage' => [ 'base' => NULL, 'refs' => [ 'UnrecognizedPublicKeyEncodingException$message' => NULL, ], ], 'userDetailListType' => [ 'base' => NULL, 'refs' => [ 'GetAccountAuthorizationDetailsResponse$UserDetailList' => '<p>A list containing information about IAM users.</p>', ], ], 'userListType' => [ 'base' => '<p>Contains a list of users.</p> <p>This data type is used as a response element in the <a>GetGroup</a> and <a>ListUsers</a> actions. </p>', 'refs' => [ 'GetGroupResponse$Users' => '<p>A list of users in the group.</p>', 'ListUsersResponse$Users' => '<p>A list of users.</p>', ], ], 'userNameType' => [ 'base' => NULL, 'refs' => [ 'AccessKey$UserName' => '<p>The name of the IAM user that the access key is associated with.</p>', 'AccessKeyMetadata$UserName' => '<p>The name of the IAM user that the key is associated with.</p>', 'AttachUserPolicyRequest$UserName' => '<p>The name (friendly name, not ARN) of the IAM user to attach the policy to.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'CreateLoginProfileRequest$UserName' => '<p>The name of the IAM user to create a password for. The user must already exist.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'CreateServiceSpecificCredentialRequest$UserName' => '<p>The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'CreateUserRequest$UserName' => '<p>The name of the user to create.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-. User names are not distinguished by case. For example, you cannot create users named both "TESTUSER" and "testuser".</p>', 'DeleteLoginProfileRequest$UserName' => '<p>The name of the user whose password you want to delete.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DeleteSSHPublicKeyRequest$UserName' => '<p>The name of the IAM user associated with the SSH public key.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DeleteServiceSpecificCredentialRequest$UserName' => '<p>The name of the IAM user associated with the service-specific credential. If this value is not specified, then the operation assumes the user whose credentials are used to call the operation.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'DetachUserPolicyRequest$UserName' => '<p>The name (friendly name, not ARN) of the IAM user to detach the policy from.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'GetLoginProfileRequest$UserName' => '<p>The name of the user whose login profile you want to retrieve.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'GetSSHPublicKeyRequest$UserName' => '<p>The name of the IAM user associated with the SSH public key.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'ListAttachedUserPoliciesRequest$UserName' => '<p>The name (friendly name, not ARN) of the user to list attached policies for.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'ListSSHPublicKeysRequest$UserName' => '<p>The name of the IAM user to list SSH public keys for. If none is specified, the UserName field is determined implicitly based on the AWS access key used to sign the request.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'ListServiceSpecificCredentialsRequest$UserName' => '<p>The name of the user whose service-specific credentials you want information about. If this value is not specified then the operation assumes the user whose credentials are used to call the operation.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'LoginProfile$UserName' => '<p>The name of the user, which can be used for signing in to the AWS Management Console.</p>', 'MFADevice$UserName' => '<p>The user with whom the MFA device is associated.</p>', 'PolicyUser$UserName' => '<p>The name (friendly name, not ARN) identifying the user.</p>', 'ResetServiceSpecificCredentialRequest$UserName' => '<p>The name of the IAM user associated with the service-specific credential. If this value is not specified, then the operation assumes the user whose credentials are used to call the operation.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'SSHPublicKey$UserName' => '<p>The name of the IAM user associated with the SSH public key.</p>', 'SSHPublicKeyMetadata$UserName' => '<p>The name of the IAM user associated with the SSH public key.</p>', 'ServiceSpecificCredential$UserName' => '<p>The name of the IAM user associated with the service-specific credential.</p>', 'ServiceSpecificCredentialMetadata$UserName' => '<p>The name of the IAM user associated with the service-specific credential.</p>', 'SigningCertificate$UserName' => '<p>The name of the user the signing certificate is associated with.</p>', 'UpdateLoginProfileRequest$UserName' => '<p>The name of the user whose password you want to update.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'UpdateSSHPublicKeyRequest$UserName' => '<p>The name of the IAM user associated with the SSH public key.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'UpdateServiceSpecificCredentialRequest$UserName' => '<p>The name of the IAM user associated with the service-specific credential. If you do not specify this value, then the operation assumes the user whose credentials are used to call the operation.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'UpdateUserRequest$NewUserName' => '<p>New name for the user. Include this parameter only if you\'re changing the user\'s name.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'UploadSSHPublicKeyRequest$UserName' => '<p>The name of the IAM user to associate the SSH public key with.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', 'User$UserName' => '<p>The friendly name identifying the user.</p>', 'UserDetail$UserName' => '<p>The friendly name identifying the user.</p>', ], ], 'virtualMFADeviceListType' => [ 'base' => NULL, 'refs' => [ 'ListVirtualMFADevicesResponse$VirtualMFADevices' => '<p> The list of virtual MFA devices in the current account that match the <code>AssignmentStatus</code> value that was passed in the request.</p>', ], ], 'virtualMFADeviceName' => [ 'base' => NULL, 'refs' => [ 'CreateVirtualMFADeviceRequest$VirtualMFADeviceName' => '<p>The name of the virtual MFA device. Use with path to uniquely identify a virtual MFA device.</p> <p>This parameter allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@-</p>', ], ], ],];
