<?php
// This file was auto-generated from sdk-root/src/data/inspector/2016-02-16/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Inspector</fullname> <p>Amazon Inspector enables you to analyze the behavior of your AWS resources and to identify potential security issues. For more information, see <a href="http://docs.aws.amazon.com/inspector/latest/userguide/inspector_introduction.html"> Amazon Inspector User Guide</a>.</p>', 'operations' => [ 'AddAttributesToFindings' => '<p>Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.</p>', 'CreateAssessmentTarget' => '<p>Creates a new assessment target using the ARN of the resource group that is generated by <a>CreateResourceGroup</a>. You can create up to 50 assessment targets per AWS account. You can run up to 500 concurrent agents per AWS account. For more information, see <a href="http://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html"> Amazon Inspector Assessment Targets</a>.</p>', 'CreateAssessmentTemplate' => '<p>Creates an assessment template for the assessment target that is specified by the ARN of the assessment target.</p>', 'CreateResourceGroup' => '<p>Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target. The created resource group is then used to create an Amazon Inspector assessment target. For more information, see <a>CreateAssessmentTarget</a>.</p>', 'DeleteAssessmentRun' => '<p>Deletes the assessment run that is specified by the ARN of the assessment run.</p>', 'DeleteAssessmentTarget' => '<p>Deletes the assessment target that is specified by the ARN of the assessment target.</p>', 'DeleteAssessmentTemplate' => '<p>Deletes the assessment template that is specified by the ARN of the assessment template.</p>', 'DescribeAssessmentRuns' => '<p>Describes the assessment runs that are specified by the ARNs of the assessment runs.</p>', 'DescribeAssessmentTargets' => '<p>Describes the assessment targets that are specified by the ARNs of the assessment targets.</p>', 'DescribeAssessmentTemplates' => '<p>Describes the assessment templates that are specified by the ARNs of the assessment templates.</p>', 'DescribeCrossAccountAccessRole' => '<p>Describes the IAM role that enables Amazon Inspector to access your AWS account.</p>', 'DescribeFindings' => '<p>Describes the findings that are specified by the ARNs of the findings.</p>', 'DescribeResourceGroups' => '<p>Describes the resource groups that are specified by the ARNs of the resource groups.</p>', 'DescribeRulesPackages' => '<p>Describes the rules packages that are specified by the ARNs of the rules packages.</p>', 'GetAssessmentReport' => '<p>Produces an assessment report that includes detailed and comprehensive results of a specified assessment run. </p>', 'GetTelemetryMetadata' => '<p>Information about the data that is collected for the specified assessment run.</p>', 'ListAssessmentRunAgents' => '<p>Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.</p>', 'ListAssessmentRuns' => '<p>Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.</p>', 'ListAssessmentTargets' => '<p>Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets, see <a href="http://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector Assessment Targets</a>.</p>', 'ListAssessmentTemplates' => '<p>Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.</p>', 'ListEventSubscriptions' => '<p>Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.</p>', 'ListFindings' => '<p>Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.</p>', 'ListRulesPackages' => '<p>Lists all available Amazon Inspector rules packages.</p>', 'ListTagsForResource' => '<p>Lists all tags associated with an assessment template.</p>', 'PreviewAgents' => '<p>Previews the agents installed on the EC2 instances that are part of the specified assessment target.</p>', 'RegisterCrossAccountAccessRole' => '<p>Registers the IAM role that Amazon Inspector uses to list your EC2 instances at the start of the assessment run or when you call the <a>PreviewAgents</a> action.</p>', 'RemoveAttributesFromFindings' => '<p>Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.</p>', 'SetTagsForResource' => '<p>Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.</p>', 'StartAssessmentRun' => '<p>Starts the assessment run specified by the ARN of the assessment template. For this API to function properly, you must not exceed the limit of running up to 500 concurrent agents per AWS account.</p>', 'StopAssessmentRun' => '<p>Stops the assessment run that is specified by the ARN of the assessment run.</p>', 'SubscribeToEvent' => '<p>Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.</p>', 'UnsubscribeFromEvent' => '<p>Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.</p>', 'UpdateAssessmentTarget' => '<p>Updates the assessment target that is specified by the ARN of the assessment target.</p>', ], 'shapes' => [ 'AccessDeniedErrorCode' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$errorCode' => '<p>Code that indicates the type of error that is generated.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You do not have required permissions to access the requested resource.</p>', 'refs' => [], ], 'AddAttributesToFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddAttributesToFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AddRemoveAttributesFindingArnList' => [ 'base' => NULL, 'refs' => [ 'AddAttributesToFindingsRequest$findingArns' => '<p>The ARNs that specify the findings that you want to assign attributes to.</p>', 'RemoveAttributesFromFindingsRequest$findingArns' => '<p>The ARNs that specify the findings that you want to remove attributes from.</p>', ], ], 'AgentAlreadyRunningAssessment' => [ 'base' => '<p>Used in the exception error that is thrown if you start an assessment run for an assessment target that includes an EC2 instance that is already participating in another started assessment run.</p>', 'refs' => [ 'AgentAlreadyRunningAssessmentList$member' => NULL, ], ], 'AgentAlreadyRunningAssessmentList' => [ 'base' => NULL, 'refs' => [ 'AgentsAlreadyRunningAssessmentException$agents' => '<p/>', ], ], 'AgentFilter' => [ 'base' => '<p>Contains information about an Amazon Inspector agent. This data type is used as a request parameter in the <a>ListAssessmentRunAgents</a> action.</p>', 'refs' => [ 'ListAssessmentRunAgentsRequest$filter' => '<p>You can use this parameter to specify a subset of data to be included in the action\'s response.</p> <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>', ], ], 'AgentHealth' => [ 'base' => NULL, 'refs' => [ 'AgentHealthList$member' => NULL, 'AssessmentRunAgent$agentHealth' => '<p>The current health state of the agent.</p>', ], ], 'AgentHealthCode' => [ 'base' => NULL, 'refs' => [ 'AgentHealthCodeList$member' => NULL, 'AssessmentRunAgent$agentHealthCode' => '<p>The detailed health state of the agent.</p>', ], ], 'AgentHealthCodeList' => [ 'base' => NULL, 'refs' => [ 'AgentFilter$agentHealthCodes' => '<p>The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>. </p>', ], ], 'AgentHealthList' => [ 'base' => NULL, 'refs' => [ 'AgentFilter$agentHealths' => '<p>The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.</p>', ], ], 'AgentId' => [ 'base' => NULL, 'refs' => [ 'AgentAlreadyRunningAssessment$agentId' => '<p>ID of the agent that is running on an EC2 instance that is already participating in another started assessment run.</p>', 'AgentIdList$member' => NULL, 'AgentPreview$agentId' => '<p>The ID of the EC2 instance where the agent is installed.</p>', 'AssessmentRunAgent$agentId' => '<p>The AWS account of the EC2 instance where the agent is installed.</p>', 'AssetAttributes$agentId' => '<p>The ID of the agent that is installed on the EC2 instance where the finding is generated.</p>', ], ], 'AgentIdList' => [ 'base' => NULL, 'refs' => [ 'FindingFilter$agentIds' => '<p>For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the <b>agentId</b> property of the <a>Finding</a> data type.</p>', ], ], 'AgentPreview' => [ 'base' => '<p>Used as a response element in the <a>PreviewAgents</a> action.</p>', 'refs' => [ 'AgentPreviewList$member' => NULL, ], ], 'AgentPreviewList' => [ 'base' => NULL, 'refs' => [ 'PreviewAgentsResponse$agentPreviews' => '<p>The resulting list of agents.</p>', ], ], 'AgentsAlreadyRunningAssessmentException' => [ 'base' => '<p>You started an assessment run, but one of the instances is already participating in another assessment run.</p>', 'refs' => [], ], 'AmiId' => [ 'base' => NULL, 'refs' => [ 'AssetAttributes$amiId' => '<p>The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance where the finding is generated.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AddRemoveAttributesFindingArnList$member' => NULL, 'AgentAlreadyRunningAssessment$assessmentRunArn' => '<p>The ARN of the assessment run that has already been started.</p>', 'AssessmentRulesPackageArnList$member' => NULL, 'AssessmentRun$arn' => '<p>The ARN of the assessment run.</p>', 'AssessmentRun$assessmentTemplateArn' => '<p>The ARN of the assessment template that is associated with the assessment run.</p>', 'AssessmentRunAgent$assessmentRunArn' => '<p>The ARN of the assessment run that is associated with the agent.</p>', 'AssessmentRunInProgressArnList$member' => NULL, 'AssessmentRunNotification$snsTopicArn' => '<p>The SNS topic to which the SNS notification is sent.</p>', 'AssessmentTarget$arn' => '<p>The ARN that specifies the Amazon Inspector assessment target.</p>', 'AssessmentTarget$resourceGroupArn' => '<p>The ARN that specifies the resource group that is associated with the assessment target.</p>', 'AssessmentTemplate$arn' => '<p>The ARN of the assessment template.</p>', 'AssessmentTemplate$assessmentTargetArn' => '<p>The ARN of the assessment target that corresponds to this assessment template.</p>', 'AssessmentTemplateRulesPackageArnList$member' => NULL, 'BatchDescribeArnList$member' => NULL, 'CreateAssessmentTargetRequest$resourceGroupArn' => '<p>The ARN that specifies the resource group that is used to create the assessment target.</p>', 'CreateAssessmentTargetResponse$assessmentTargetArn' => '<p>The ARN that specifies the assessment target that is created.</p>', 'CreateAssessmentTemplateRequest$assessmentTargetArn' => '<p>The ARN that specifies the assessment target for which you want to create the assessment template.</p>', 'CreateAssessmentTemplateResponse$assessmentTemplateArn' => '<p>The ARN that specifies the assessment template that is created.</p>', 'CreateResourceGroupResponse$resourceGroupArn' => '<p>The ARN that specifies the resource group that is created.</p>', 'DeleteAssessmentRunRequest$assessmentRunArn' => '<p>The ARN that specifies the assessment run that you want to delete.</p>', 'DeleteAssessmentTargetRequest$assessmentTargetArn' => '<p>The ARN that specifies the assessment target that you want to delete.</p>', 'DeleteAssessmentTemplateRequest$assessmentTemplateArn' => '<p>The ARN that specifies the assessment template that you want to delete.</p>', 'DescribeCrossAccountAccessRoleResponse$roleArn' => '<p>The ARN that specifies the IAM role that Amazon Inspector uses to access your AWS account.</p>', 'FailedItems$key' => NULL, 'FilterRulesPackageArnList$member' => NULL, 'Finding$arn' => '<p>The ARN that specifies the finding.</p>', 'GetAssessmentReportRequest$assessmentRunArn' => '<p>The ARN that specifies the assessment run for which you want to generate a report.</p>', 'GetTelemetryMetadataRequest$assessmentRunArn' => '<p>The ARN that specifies the assessment run that has the telemetry data that you want to obtain.</p>', 'InspectorServiceAttributes$assessmentRunArn' => '<p>The ARN of the assessment run during which the finding is generated.</p>', 'InspectorServiceAttributes$rulesPackageArn' => '<p>The ARN of the rules package that is used to generate the finding.</p>', 'ListAssessmentRunAgentsRequest$assessmentRunArn' => '<p>The ARN that specifies the assessment run whose agents you want to list.</p>', 'ListEventSubscriptionsRequest$resourceArn' => '<p>The ARN of the assessment template for which you want to list the existing event subscriptions.</p>', 'ListParentArnList$member' => NULL, 'ListReturnedArnList$member' => NULL, 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN that specifies the assessment template whose tags you want to list.</p>', 'PreviewAgentsRequest$previewAgentsArn' => '<p>The ARN of the assessment target whose agents you want to preview.</p>', 'RegisterCrossAccountAccessRoleRequest$roleArn' => '<p>The ARN of the IAM role that Amazon Inspector uses to list your EC2 instances during the assessment run or when you call the <a>PreviewAgents</a> action. </p>', 'ResourceGroup$arn' => '<p>The ARN of the resource group.</p>', 'RulesPackage$arn' => '<p>The ARN of the rules package.</p>', 'SetTagsForResourceRequest$resourceArn' => '<p>The ARN of the assessment template that you want to set tags to.</p>', 'StartAssessmentRunRequest$assessmentTemplateArn' => '<p>The ARN of the assessment template of the assessment run that you want to start.</p>', 'StartAssessmentRunResponse$assessmentRunArn' => '<p>The ARN of the assessment run that has been started.</p>', 'StopAssessmentRunRequest$assessmentRunArn' => '<p>The ARN of the assessment run that you want to stop.</p>', 'SubscribeToEventRequest$resourceArn' => '<p>The ARN of the assessment template that is used during the event for which you want to receive SNS notifications.</p>', 'SubscribeToEventRequest$topicArn' => '<p>The ARN of the SNS topic to which the SNS notifications are sent.</p>', 'Subscription$resourceArn' => '<p>The ARN of the assessment template that is used during the event for which the SNS notification is sent.</p>', 'Subscription$topicArn' => '<p>The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS notifications are sent.</p>', 'UnsubscribeFromEventRequest$resourceArn' => '<p>The ARN of the assessment template that is used during the event for which you want to stop receiving SNS notifications.</p>', 'UnsubscribeFromEventRequest$topicArn' => '<p>The ARN of the SNS topic to which SNS notifications are sent.</p>', 'UpdateAssessmentTargetRequest$assessmentTargetArn' => '<p>The ARN of the assessment target that you want to update.</p>', 'UpdateAssessmentTargetRequest$resourceGroupArn' => '<p>The ARN of the resource group that is used to specify the new resource group to associate with the assessment target.</p>', ], ], 'AssessmentRulesPackageArnList' => [ 'base' => NULL, 'refs' => [ 'AssessmentRun$rulesPackageArns' => '<p>The rules packages selected for the assessment run.</p>', ], ], 'AssessmentRun' => [ 'base' => '<p>A snapshot of an Amazon Inspector assessment run that contains the findings of the assessment run .</p> <p>Used as the response element in the <a>DescribeAssessmentRuns</a> action.</p>', 'refs' => [ 'AssessmentRunList$member' => NULL, ], ], 'AssessmentRunAgent' => [ 'base' => '<p>Contains information about an Amazon Inspector agent. This data type is used as a response element in the <a>ListAssessmentRunAgents</a> action.</p>', 'refs' => [ 'AssessmentRunAgentList$member' => NULL, ], ], 'AssessmentRunAgentList' => [ 'base' => NULL, 'refs' => [ 'ListAssessmentRunAgentsResponse$assessmentRunAgents' => '<p>A list of ARNs that specifies the agents returned by the action.</p>', ], ], 'AssessmentRunDuration' => [ 'base' => NULL, 'refs' => [ 'AssessmentRun$durationInSeconds' => '<p>The duration of the assessment run.</p>', 'AssessmentTemplate$durationInSeconds' => '<p>The duration in seconds specified for this assessment tempate. The default value is 3600 seconds (one hour). The maximum value is 86400 seconds (one day).</p>', 'CreateAssessmentTemplateRequest$durationInSeconds' => '<p>The duration of the assessment run in seconds. The default value is 3600 seconds (one hour).</p>', 'DurationRange$minSeconds' => '<p>The minimum value of the duration range. Must be greater than zero.</p>', 'DurationRange$maxSeconds' => '<p>The maximum value of the duration range. Must be less than or equal to 604800 seconds (1 week).</p>', ], ], 'AssessmentRunFilter' => [ 'base' => '<p>Used as the request parameter in the <a>ListAssessmentRuns</a> action.</p>', 'refs' => [ 'ListAssessmentRunsRequest$filter' => '<p>You can use this parameter to specify a subset of data to be included in the action\'s response.</p> <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>', ], ], 'AssessmentRunFindingCounts' => [ 'base' => NULL, 'refs' => [ 'AssessmentRun$findingCounts' => '<p>Provides a total count of generated findings per severity.</p>', ], ], 'AssessmentRunInProgressArnList' => [ 'base' => NULL, 'refs' => [ 'AssessmentRunInProgressException$assessmentRunArns' => '<p>The ARNs of the assessment runs that are currently in progress.</p>', ], ], 'AssessmentRunInProgressException' => [ 'base' => '<p>You cannot perform a specified action if an assessment run is currently in progress.</p>', 'refs' => [], ], 'AssessmentRunList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssessmentRunsResponse$assessmentRuns' => '<p>Information about the assessment run.</p>', ], ], 'AssessmentRunName' => [ 'base' => NULL, 'refs' => [ 'AssessmentRun$name' => '<p>The auto-generated name for the assessment run.</p>', 'StartAssessmentRunRequest$assessmentRunName' => '<p>You can specify the name for the assessment run. The name must be unique for the assessment template whose ARN is used to start the assessment run.</p>', ], ], 'AssessmentRunNotification' => [ 'base' => '<p>Used as one of the elements of the <a>AssessmentRun</a> data type.</p>', 'refs' => [ 'AssessmentRunNotificationList$member' => NULL, ], ], 'AssessmentRunNotificationList' => [ 'base' => NULL, 'refs' => [ 'AssessmentRun$notifications' => '<p>A list of notifications for the event subscriptions. A notification about a particular generated finding is added to this list only once.</p>', ], ], 'AssessmentRunNotificationSnsStatusCode' => [ 'base' => NULL, 'refs' => [ 'AssessmentRunNotification$snsPublishStatusCode' => '<p>The status code of the SNS notification.</p>', ], ], 'AssessmentRunState' => [ 'base' => NULL, 'refs' => [ 'AssessmentRun$state' => '<p>The state of the assessment run.</p>', 'AssessmentRunStateChange$state' => '<p>The assessment run state.</p>', 'AssessmentRunStateList$member' => NULL, ], ], 'AssessmentRunStateChange' => [ 'base' => '<p>Used as one of the elements of the <a>AssessmentRun</a> data type.</p>', 'refs' => [ 'AssessmentRunStateChangeList$member' => NULL, ], ], 'AssessmentRunStateChangeList' => [ 'base' => NULL, 'refs' => [ 'AssessmentRun$stateChanges' => '<p>A list of the assessment run state changes.</p>', ], ], 'AssessmentRunStateList' => [ 'base' => NULL, 'refs' => [ 'AssessmentRunFilter$states' => '<p>For a record to match a filter, one of the values specified for this data type property must be the exact match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data type.</p>', ], ], 'AssessmentTarget' => [ 'base' => '<p>Contains information about an Amazon Inspector application. This data type is used as the response element in the <a>DescribeAssessmentTargets</a> action.</p>', 'refs' => [ 'AssessmentTargetList$member' => NULL, ], ], 'AssessmentTargetFilter' => [ 'base' => '<p>Used as the request parameter in the <a>ListAssessmentTargets</a> action.</p>', 'refs' => [ 'ListAssessmentTargetsRequest$filter' => '<p>You can use this parameter to specify a subset of data to be included in the action\'s response.</p> <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>', ], ], 'AssessmentTargetList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssessmentTargetsResponse$assessmentTargets' => '<p>Information about the assessment targets.</p>', ], ], 'AssessmentTargetName' => [ 'base' => NULL, 'refs' => [ 'AssessmentTarget$name' => '<p>The name of the Amazon Inspector assessment target.</p>', 'CreateAssessmentTargetRequest$assessmentTargetName' => '<p>The user-defined name that identifies the assessment target that you want to create. The name must be unique within the AWS account.</p>', 'UpdateAssessmentTargetRequest$assessmentTargetName' => '<p>The name of the assessment target that you want to update.</p>', ], ], 'AssessmentTemplate' => [ 'base' => '<p>Contains information about an Amazon Inspector assessment template. This data type is used as the response element in the <a>DescribeAssessmentTemplates</a> action.</p>', 'refs' => [ 'AssessmentTemplateList$member' => NULL, ], ], 'AssessmentTemplateFilter' => [ 'base' => '<p>Used as the request parameter in the <a>ListAssessmentTemplates</a> action.</p>', 'refs' => [ 'ListAssessmentTemplatesRequest$filter' => '<p>You can use this parameter to specify a subset of data to be included in the action\'s response.</p> <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>', ], ], 'AssessmentTemplateList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssessmentTemplatesResponse$assessmentTemplates' => '<p>Information about the assessment templates.</p>', ], ], 'AssessmentTemplateName' => [ 'base' => NULL, 'refs' => [ 'AssessmentTemplate$name' => '<p>The name of the assessment template.</p>', 'CreateAssessmentTemplateRequest$assessmentTemplateName' => '<p>The user-defined name that identifies the assessment template that you want to create. You can create several assessment templates for an assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.</p>', ], ], 'AssessmentTemplateRulesPackageArnList' => [ 'base' => NULL, 'refs' => [ 'AssessmentTemplate$rulesPackageArns' => '<p>The rules packages that are specified for this assessment template.</p>', 'CreateAssessmentTemplateRequest$rulesPackageArns' => '<p>The ARNs that specify the rules packages that you want to attach to the assessment template.</p>', ], ], 'AssetAttributes' => [ 'base' => '<p>A collection of attributes of the host from which the finding is generated.</p>', 'refs' => [ 'Finding$assetAttributes' => '<p>A collection of attributes of the host from which the finding is generated.</p>', ], ], 'AssetType' => [ 'base' => NULL, 'refs' => [ 'Finding$assetType' => '<p>The type of the host from which the finding is generated.</p>', ], ], 'Attribute' => [ 'base' => '<p>This data type is used as a request parameter in the <a>AddAttributesToFindings</a> and <a>CreateAssessmentTemplate</a> actions.</p>', 'refs' => [ 'AttributeList$member' => NULL, 'UserAttributeList$member' => NULL, ], ], 'AttributeKey' => [ 'base' => NULL, 'refs' => [ 'Attribute$key' => '<p>The attribute key.</p>', 'UserAttributeKeyList$member' => NULL, ], ], 'AttributeList' => [ 'base' => NULL, 'refs' => [ 'Finding$attributes' => '<p>The system-defined attributes for the finding.</p>', 'FindingFilter$attributes' => '<p>For a record to match a filter, the list of values that are specified for this data type property must be contained in the list of values of the <b>attributes</b> property of the <a>Finding</a> data type.</p>', 'FindingFilter$userAttributes' => '<p>For a record to match a filter, the value that is specified for this data type property must be contained in the list of values of the <b>userAttributes</b> property of the <a>Finding</a> data type.</p>', ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'Attribute$value' => '<p>The value assigned to the attribute key.</p>', ], ], 'AutoScalingGroup' => [ 'base' => NULL, 'refs' => [ 'AgentPreview$autoScalingGroup' => '<p>The Auto Scaling group for the EC2 instance where the agent is installed.</p>', 'AssessmentRunAgent$autoScalingGroup' => '<p>The Auto Scaling group of the EC2 instance that is specified by the agent ID.</p>', 'AssetAttributes$autoScalingGroup' => '<p>The Auto Scaling group of the EC2 instance where the finding is generated.</p>', 'AutoScalingGroupList$member' => NULL, ], ], 'AutoScalingGroupList' => [ 'base' => NULL, 'refs' => [ 'FindingFilter$autoScalingGroups' => '<p>For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the <b>autoScalingGroup</b> property of the <a>Finding</a> data type.</p>', ], ], 'BatchDescribeArnList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssessmentRunsRequest$assessmentRunArns' => '<p>The ARN that specifies the assessment run that you want to describe.</p>', 'DescribeAssessmentTargetsRequest$assessmentTargetArns' => '<p>The ARNs that specifies the assessment targets that you want to describe.</p>', 'DescribeAssessmentTemplatesRequest$assessmentTemplateArns' => NULL, 'DescribeFindingsRequest$findingArns' => '<p>The ARN that specifies the finding that you want to describe.</p>', 'DescribeResourceGroupsRequest$resourceGroupArns' => '<p>The ARN that specifies the resource group that you want to describe.</p>', 'DescribeRulesPackagesRequest$rulesPackageArns' => '<p>The ARN that specifies the rules package that you want to describe.</p>', ], ], 'Bool' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$canRetry' => '<p>You can immediately retry your request.</p>', 'AgentsAlreadyRunningAssessmentException$agentsTruncated' => '<p/>', 'AgentsAlreadyRunningAssessmentException$canRetry' => '<p>You can immediately retry your request.</p>', 'AssessmentRun$dataCollected' => '<p>A Boolean value (true or false) that specifies whether the process of collecting data from the agents is completed.</p>', 'AssessmentRunInProgressException$assessmentRunArnsTruncated' => '<p>Boolean value that indicates whether the ARN list of the assessment runs is truncated.</p>', 'AssessmentRunInProgressException$canRetry' => '<p>You can immediately retry your request.</p>', 'AssessmentRunNotification$error' => '<p>The Boolean value that specifies whether the notification represents an error.</p>', 'DescribeCrossAccountAccessRoleResponse$valid' => '<p>A Boolean value that specifies whether the IAM role has the necessary policies attached to enable Amazon Inspector to access your AWS account.</p>', 'FailedItemDetails$retryable' => '<p>Indicates whether you can immediately retry a request for this item for a specified resource.</p>', 'Finding$indicatorOfCompromise' => '<p>This data element is currently not used.</p>', 'InternalException$canRetry' => '<p>You can immediately retry your request.</p>', 'InvalidCrossAccountRoleException$canRetry' => '<p>You can immediately retry your request.</p>', 'InvalidInputException$canRetry' => '<p>You can immediately retry your request.</p>', 'LimitExceededException$canRetry' => '<p>You can immediately retry your request.</p>', 'NoSuchEntityException$canRetry' => '<p>You can immediately retry your request.</p>', 'UnsupportedFeatureException$canRetry' => NULL, ], ], 'CreateAssessmentTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssessmentTargetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssessmentTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssessmentTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssessmentRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssessmentTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssessmentTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssessmentRunsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssessmentRunsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssessmentTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssessmentTargetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssessmentTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssessmentTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCrossAccountAccessRoleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRulesPackagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRulesPackagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DurationRange' => [ 'base' => '<p>This data type is used in the <a>AssessmentTemplateFilter</a> data type.</p>', 'refs' => [ 'AssessmentRunFilter$durationRange' => '<p>For a record to match a filter, the value that is specified for this data type property must inclusively match any value between the specified minimum and maximum values of the <b>durationInSeconds</b> property of the <a>AssessmentRun</a> data type.</p>', 'AssessmentTemplateFilter$durationRange' => '<p>For a record to match a filter, the value specified for this data type property must inclusively match any value between the specified minimum and maximum values of the <b>durationInSeconds</b> property of the <a>AssessmentTemplate</a> data type.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => '<p>Details of the exception error.</p>', 'AgentsAlreadyRunningAssessmentException$message' => '<p>Details of the exception error.</p>', 'AssessmentRunInProgressException$message' => '<p>Details of the exception error.</p>', 'InternalException$message' => '<p>Details of the exception error.</p>', 'InvalidCrossAccountRoleException$message' => '<p>Details of the exception error.</p>', 'InvalidInputException$message' => '<p>Details of the exception error.</p>', 'LimitExceededException$message' => '<p>Details of the exception error.</p>', 'NoSuchEntityException$message' => '<p>Details of the exception error.</p>', 'UnsupportedFeatureException$message' => NULL, ], ], 'EventSubscription' => [ 'base' => '<p>This data type is used in the <a>Subscription</a> data type.</p>', 'refs' => [ 'EventSubscriptionList$member' => NULL, ], ], 'EventSubscriptionList' => [ 'base' => NULL, 'refs' => [ 'Subscription$eventSubscriptions' => '<p>The list of existing event subscriptions.</p>', ], ], 'FailedItemDetails' => [ 'base' => '<p>Includes details about the failed items.</p>', 'refs' => [ 'FailedItems$value' => NULL, ], ], 'FailedItemErrorCode' => [ 'base' => NULL, 'refs' => [ 'FailedItemDetails$failureCode' => '<p>The status code of a failed item.</p>', ], ], 'FailedItems' => [ 'base' => NULL, 'refs' => [ 'AddAttributesToFindingsResponse$failedItems' => '<p>Attribute details that cannot be described. An error code is provided for each failed item.</p>', 'DescribeAssessmentRunsResponse$failedItems' => '<p>Assessment run details that cannot be described. An error code is provided for each failed item.</p>', 'DescribeAssessmentTargetsResponse$failedItems' => '<p>Assessment target details that cannot be described. An error code is provided for each failed item.</p>', 'DescribeAssessmentTemplatesResponse$failedItems' => '<p>Assessment template details that cannot be described. An error code is provided for each failed item.</p>', 'DescribeFindingsResponse$failedItems' => '<p>Finding details that cannot be described. An error code is provided for each failed item.</p>', 'DescribeResourceGroupsResponse$failedItems' => '<p>Resource group details that cannot be described. An error code is provided for each failed item.</p>', 'DescribeRulesPackagesResponse$failedItems' => '<p>Rules package details that cannot be described. An error code is provided for each failed item.</p>', 'RemoveAttributesFromFindingsResponse$failedItems' => '<p>Attributes details that cannot be described. An error code is provided for each failed item.</p>', ], ], 'FilterRulesPackageArnList' => [ 'base' => NULL, 'refs' => [ 'AssessmentRunFilter$rulesPackageArns' => '<p>For a record to match a filter, the value that is specified for this data type property must be contained in the list of values of the <b>rulesPackages</b> property of the <a>AssessmentRun</a> data type.</p>', 'AssessmentTemplateFilter$rulesPackageArns' => '<p>For a record to match a filter, the values that are specified for this data type property must be contained in the list of values of the <b>rulesPackageArns</b> property of the <a>AssessmentTemplate</a> data type.</p>', 'FindingFilter$rulesPackageArns' => '<p>For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the <b>rulesPackageArn</b> property of the <a>Finding</a> data type.</p>', ], ], 'Finding' => [ 'base' => '<p>Contains information about an Amazon Inspector finding. This data type is used as the response element in the <a>DescribeFindings</a> action.</p>', 'refs' => [ 'FindingList$member' => NULL, ], ], 'FindingCount' => [ 'base' => NULL, 'refs' => [ 'AssessmentRunFindingCounts$value' => NULL, ], ], 'FindingFilter' => [ 'base' => '<p>This data type is used as a request parameter in the <a>ListFindings</a> action.</p>', 'refs' => [ 'ListFindingsRequest$filter' => '<p>You can use this parameter to specify a subset of data to be included in the action\'s response.</p> <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>', ], ], 'FindingId' => [ 'base' => NULL, 'refs' => [ 'Finding$id' => '<p>The ID of the finding.</p>', ], ], 'FindingList' => [ 'base' => NULL, 'refs' => [ 'DescribeFindingsResponse$findings' => '<p>Information about the finding.</p>', ], ], 'GetAssessmentReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAssessmentReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTelemetryMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTelemetryMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'Hostname' => [ 'base' => NULL, 'refs' => [ 'AssetAttributes$hostname' => '<p>The hostname of the EC2 instance where the finding is generated.</p>', ], ], 'InspectorEvent' => [ 'base' => NULL, 'refs' => [ 'AssessmentRunNotification$event' => '<p>The event for which a notification is sent.</p>', 'EventSubscription$event' => '<p>The event for which Amazon Simple Notification Service (SNS) notifications are sent.</p>', 'SubscribeToEventRequest$event' => '<p>The event for which you want to receive SNS notifications.</p>', 'UnsubscribeFromEventRequest$event' => '<p>The event for which you want to stop receiving SNS notifications.</p>', ], ], 'InspectorServiceAttributes' => [ 'base' => '<p>This data type is used in the <a>Finding</a> data type.</p>', 'refs' => [ 'Finding$serviceAttributes' => '<p>This data type is used in the <a>Finding</a> data type.</p>', ], ], 'InternalException' => [ 'base' => '<p>Internal server error.</p>', 'refs' => [], ], 'InvalidCrossAccountRoleErrorCode' => [ 'base' => NULL, 'refs' => [ 'InvalidCrossAccountRoleException$errorCode' => '<p>Code that indicates the type of error that is generated.</p>', ], ], 'InvalidCrossAccountRoleException' => [ 'base' => '<p>Amazon Inspector cannot assume the cross-account role that it needs to list your EC2 instances during the assessment run.</p>', 'refs' => [], ], 'InvalidInputErrorCode' => [ 'base' => NULL, 'refs' => [ 'InvalidInputException$errorCode' => '<p>Code that indicates the type of error that is generated.</p>', ], ], 'InvalidInputException' => [ 'base' => '<p>The request was rejected because an invalid or out-of-range value was supplied for an input parameter.</p>', 'refs' => [], ], 'IocConfidence' => [ 'base' => NULL, 'refs' => [ 'Finding$confidence' => '<p>This data element is currently not used.</p>', ], ], 'Ipv4Address' => [ 'base' => NULL, 'refs' => [ 'Ipv4AddressList$member' => NULL, ], ], 'Ipv4AddressList' => [ 'base' => NULL, 'refs' => [ 'AssetAttributes$ipv4Addresses' => '<p>The list of IP v4 addresses of the EC2 instance where the finding is generated.</p>', ], ], 'LimitExceededErrorCode' => [ 'base' => NULL, 'refs' => [ 'LimitExceededException$errorCode' => '<p>Code that indicates the type of error that is generated.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error code describes the limit exceeded.</p>', 'refs' => [], ], 'ListAssessmentRunAgentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssessmentRunAgentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssessmentRunsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssessmentRunsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssessmentTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssessmentTargetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssessmentTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssessmentTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEventSubscriptionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListEventSubscriptionsRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', ], ], 'ListEventSubscriptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEventSubscriptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAssessmentRunAgentsRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 10. The maximum value is 500.</p>', 'ListAssessmentRunsRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 10. The maximum value is 500.</p>', 'ListAssessmentTargetsRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', 'ListAssessmentTemplatesRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', 'ListFindingsRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', 'ListRulesPackagesRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', ], ], 'ListParentArnList' => [ 'base' => NULL, 'refs' => [ 'ListAssessmentRunsRequest$assessmentTemplateArns' => '<p>The ARNs that specify the assessment templates whose assessment runs you want to list.</p>', 'ListAssessmentTemplatesRequest$assessmentTargetArns' => '<p>A list of ARNs that specifies the assessment targets whose assessment templates you want to list.</p>', 'ListFindingsRequest$assessmentRunArns' => '<p>The ARNs of the assessment runs that generate the findings that you want to list.</p>', ], ], 'ListReturnedArnList' => [ 'base' => NULL, 'refs' => [ 'ListAssessmentRunsResponse$assessmentRunArns' => '<p>A list of ARNs that specifies the assessment runs that are returned by the action.</p>', 'ListAssessmentTargetsResponse$assessmentTargetArns' => '<p>A list of ARNs that specifies the assessment targets that are returned by the action.</p>', 'ListAssessmentTemplatesResponse$assessmentTemplateArns' => '<p>A list of ARNs that specifies the assessment templates returned by the action.</p>', 'ListFindingsResponse$findingArns' => '<p>A list of ARNs that specifies the findings returned by the action.</p>', 'ListRulesPackagesResponse$rulesPackageArns' => '<p>The list of ARNs that specifies the rules packages returned by the action.</p>', ], ], 'ListRulesPackagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRulesPackagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Locale' => [ 'base' => NULL, 'refs' => [ 'DescribeFindingsRequest$locale' => '<p>The locale into which you want to translate a finding description, recommendation, and the short description that identifies the finding.</p>', 'DescribeRulesPackagesRequest$locale' => '<p>The locale that you want to translate a rules package description into.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'TelemetryMetadata$count' => '<p>The count of messages that the agent sends to the Amazon Inspector service.</p>', 'TelemetryMetadata$dataSize' => '<p>The data size of messages that the agent sends to the Amazon Inspector service.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'AssessmentRunAgent$agentHealthDetails' => '<p>The description for the agent health code.</p>', 'AssessmentRunNotification$message' => '<p>The message included in the notification.</p>', ], ], 'MessageType' => [ 'base' => NULL, 'refs' => [ 'TelemetryMetadata$messageType' => '<p>A specific type of behavioral data that is collected by the agent.</p>', ], ], 'NamePattern' => [ 'base' => NULL, 'refs' => [ 'AssessmentRunFilter$namePattern' => '<p>For a record to match a filter, an explicit value or a string containing a wildcard that is specified for this data type property must match the value of the <b>assessmentRunName</b> property of the <a>AssessmentRun</a> data type.</p>', 'AssessmentTargetFilter$assessmentTargetNamePattern' => '<p>For a record to match a filter, an explicit value or a string that contains a wildcard that is specified for this data type property must match the value of the <b>assessmentTargetName</b> property of the <a>AssessmentTarget</a> data type.</p>', 'AssessmentTemplateFilter$namePattern' => '<p>For a record to match a filter, an explicit value or a string that contains a wildcard that is specified for this data type property must match the value of the <b>assessmentTemplateName</b> property of the <a>AssessmentTemplate</a> data type.</p>', ], ], 'NoSuchEntityErrorCode' => [ 'base' => NULL, 'refs' => [ 'NoSuchEntityException$errorCode' => '<p>Code that indicates the type of error that is generated.</p>', ], ], 'NoSuchEntityException' => [ 'base' => '<p>The request was rejected because it referenced an entity that does not exist. The error code describes the entity.</p>', 'refs' => [], ], 'NumericSeverity' => [ 'base' => NULL, 'refs' => [ 'Finding$numericSeverity' => '<p>The numeric value of the finding severity.</p>', ], ], 'NumericVersion' => [ 'base' => NULL, 'refs' => [ 'AssetAttributes$schemaVersion' => '<p>The schema version of this data type.</p>', 'Finding$schemaVersion' => '<p>The schema version of this data type.</p>', 'InspectorServiceAttributes$schemaVersion' => '<p>The schema version of this data type.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListAssessmentRunAgentsRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentRunAgents</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>', 'ListAssessmentRunAgentsResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>', 'ListAssessmentRunsRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentRuns</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>', 'ListAssessmentRunsResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>', 'ListAssessmentTargetsRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentTargets</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>', 'ListAssessmentTargetsResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>', 'ListAssessmentTemplatesRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentTemplates</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>', 'ListAssessmentTemplatesResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>', 'ListEventSubscriptionsRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListEventSubscriptions</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>', 'ListEventSubscriptionsResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>', 'ListFindingsRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListFindings</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>', 'ListFindingsResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>', 'ListRulesPackagesRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListRulesPackages</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>', 'ListRulesPackagesResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>', 'PreviewAgentsRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>PreviewAgents</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>', 'PreviewAgentsResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>', ], ], 'PreviewAgentsMaxResults' => [ 'base' => NULL, 'refs' => [ 'PreviewAgentsRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', ], ], 'PreviewAgentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PreviewAgentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ProviderName' => [ 'base' => NULL, 'refs' => [ 'RulesPackage$provider' => '<p>The provider of the rules package.</p>', ], ], 'RegisterCrossAccountAccessRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveAttributesFromFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveAttributesFromFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReportFileFormat' => [ 'base' => NULL, 'refs' => [ 'GetAssessmentReportRequest$reportFileFormat' => '<p>Specifies the file format (html or pdf) of the assessment report that you want to generate.</p>', ], ], 'ReportStatus' => [ 'base' => NULL, 'refs' => [ 'GetAssessmentReportResponse$status' => '<p>Specifies the status of the request to generate an assessment report. </p>', ], ], 'ReportType' => [ 'base' => NULL, 'refs' => [ 'GetAssessmentReportRequest$reportType' => '<p>Specifies the type of the assessment report that you want to generate. There are two types of assessment reports: a finding report and a full report. For more information, see <a href="http://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>. </p>', ], ], 'ResourceGroup' => [ 'base' => '<p>Contains information about a resource group. The resource group defines a set of tags that, when queried, identify the AWS resources that make up the assessment target. This data type is used as the response element in the <a>DescribeResourceGroups</a> action.</p>', 'refs' => [ 'ResourceGroupList$member' => NULL, ], ], 'ResourceGroupList' => [ 'base' => NULL, 'refs' => [ 'DescribeResourceGroupsResponse$resourceGroups' => '<p>Information about a resource group.</p>', ], ], 'ResourceGroupTag' => [ 'base' => '<p>This data type is used as one of the elements of the <a>ResourceGroup</a> data type.</p>', 'refs' => [ 'ResourceGroupTags$member' => NULL, ], ], 'ResourceGroupTags' => [ 'base' => NULL, 'refs' => [ 'CreateResourceGroupRequest$resourceGroupTags' => '<p>A collection of keys and an array of possible values, \'[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]\'.</p> <p>For example,\'[{"key":"Name","values":["TestEC2Instance"]}]\'.</p>', 'ResourceGroup$tags' => '<p>The tags (key and value pairs) of the resource group. This data type property is used in the <a>CreateResourceGroup</a> action.</p>', ], ], 'RuleName' => [ 'base' => NULL, 'refs' => [ 'RuleNameList$member' => NULL, ], ], 'RuleNameList' => [ 'base' => NULL, 'refs' => [ 'FindingFilter$ruleNames' => '<p>For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the <b>ruleName</b> property of the <a>Finding</a> data type.</p>', ], ], 'RulesPackage' => [ 'base' => '<p>Contains information about an Amazon Inspector rules package. This data type is used as the response element in the <a>DescribeRulesPackages</a> action.</p>', 'refs' => [ 'RulesPackageList$member' => NULL, ], ], 'RulesPackageList' => [ 'base' => NULL, 'refs' => [ 'DescribeRulesPackagesResponse$rulesPackages' => '<p>Information about the rules package.</p>', ], ], 'RulesPackageName' => [ 'base' => NULL, 'refs' => [ 'RulesPackage$name' => '<p>The name of the rules package.</p>', ], ], 'ServiceName' => [ 'base' => NULL, 'refs' => [ 'Finding$service' => '<p>The data element is set to "Inspector".</p>', ], ], 'SetTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'Severity' => [ 'base' => NULL, 'refs' => [ 'AssessmentRunFindingCounts$key' => NULL, 'Finding$severity' => '<p>The finding severity. Values can be set to High, Medium, Low, and Informational.</p>', 'SeverityList$member' => NULL, ], ], 'SeverityList' => [ 'base' => NULL, 'refs' => [ 'FindingFilter$severities' => '<p>For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.</p>', ], ], 'StartAssessmentRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAssessmentRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopAction' => [ 'base' => NULL, 'refs' => [ 'StopAssessmentRunRequest$stopAction' => '<p>An input option that can be set to either START_EVALUATION or SKIP_EVALUATION. START_EVALUATION (the default value), stops the AWS agent from collecting data and begins the results evaluation and the findings generation process. SKIP_EVALUATION cancels the assessment run immediately, after which no findings are generated.</p>', ], ], 'StopAssessmentRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'SubscribeToEventRequest' => [ 'base' => NULL, 'refs' => [], ], 'Subscription' => [ 'base' => '<p>This data type is used as a response element in the <a>ListEventSubscriptions</a> action.</p>', 'refs' => [ 'SubscriptionList$member' => NULL, ], ], 'SubscriptionList' => [ 'base' => NULL, 'refs' => [ 'ListEventSubscriptionsResponse$subscriptions' => '<p>Details of the returned event subscriptions.</p>', ], ], 'Tag' => [ 'base' => '<p>A key and value pair. This data type is used as a request parameter in the <a>SetTagsForResource</a> action and a response element in the <a>ListTagsForResource</a> action.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'ResourceGroupTag$key' => '<p>A tag key.</p>', 'Tag$key' => '<p>A tag key.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$tags' => '<p>A collection of key and value pairs.</p>', 'SetTagsForResourceRequest$tags' => '<p>A collection of key and value pairs that you want to set to the assessment template.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'ResourceGroupTag$value' => '<p>The value assigned to a tag key.</p>', 'Tag$value' => '<p>A value assigned to a tag key.</p>', ], ], 'TelemetryMetadata' => [ 'base' => '<p>The metadata about the Amazon Inspector application data metrics collected by the agent. This data type is used as the response element in the <a>GetTelemetryMetadata</a> action.</p>', 'refs' => [ 'TelemetryMetadataList$member' => NULL, ], ], 'TelemetryMetadataList' => [ 'base' => NULL, 'refs' => [ 'AssessmentRunAgent$telemetryMetadata' => '<p>The Amazon Inspector application data metrics that are collected by the agent.</p>', 'GetTelemetryMetadataResponse$telemetryMetadata' => '<p>Telemetry details.</p>', ], ], 'Text' => [ 'base' => NULL, 'refs' => [ 'Finding$title' => '<p>The name of the finding.</p>', 'Finding$description' => '<p>The description of the finding.</p>', 'Finding$recommendation' => '<p>The recommendation for the finding.</p>', 'RulesPackage$description' => '<p>The description of the rules package.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AssessmentRun$createdAt' => '<p>The time when <a>StartAssessmentRun</a> was called.</p>', 'AssessmentRun$startedAt' => '<p>The time when <a>StartAssessmentRun</a> was called.</p>', 'AssessmentRun$completedAt' => '<p>The assessment run completion time that corresponds to the rules packages evaluation completion time or failure.</p>', 'AssessmentRun$stateChangedAt' => '<p>The last time when the assessment run\'s state changed.</p>', 'AssessmentRunNotification$date' => '<p>The date of the notification.</p>', 'AssessmentRunStateChange$stateChangedAt' => '<p>The last time the assessment run state changed.</p>', 'AssessmentTarget$createdAt' => '<p>The time at which the assessment target is created.</p>', 'AssessmentTarget$updatedAt' => '<p>The time at which <a>UpdateAssessmentTarget</a> is called.</p>', 'AssessmentTemplate$createdAt' => '<p>The time at which the assessment template is created.</p>', 'DescribeCrossAccountAccessRoleResponse$registeredAt' => '<p>The date when the cross-account access role was registered.</p>', 'EventSubscription$subscribedAt' => '<p>The time at which <a>SubscribeToEvent</a> is called.</p>', 'Finding$createdAt' => '<p>The time when the finding was generated.</p>', 'Finding$updatedAt' => '<p>The time when <a>AddAttributesToFindings</a> is called.</p>', 'ResourceGroup$createdAt' => '<p>The time at which resource group is created.</p>', 'TimestampRange$beginDate' => '<p>The minimum value of the timestamp range.</p>', 'TimestampRange$endDate' => '<p>The maximum value of the timestamp range.</p>', ], ], 'TimestampRange' => [ 'base' => '<p>This data type is used in the <a>AssessmentRunFilter</a> data type.</p>', 'refs' => [ 'AssessmentRunFilter$startTimeRange' => '<p>For a record to match a filter, the value that is specified for this data type property must inclusively match any value between the specified minimum and maximum values of the <b>startTime</b> property of the <a>AssessmentRun</a> data type.</p>', 'AssessmentRunFilter$completionTimeRange' => '<p>For a record to match a filter, the value that is specified for this data type property must inclusively match any value between the specified minimum and maximum values of the <b>completedAt</b> property of the <a>AssessmentRun</a> data type.</p>', 'AssessmentRunFilter$stateChangeTimeRange' => '<p>For a record to match a filter, the value that is specified for this data type property must match the <b>stateChangedAt</b> property of the <a>AssessmentRun</a> data type.</p>', 'FindingFilter$creationTimeRange' => '<p>The time range during which the finding is generated.</p>', ], ], 'UnsubscribeFromEventRequest' => [ 'base' => NULL, 'refs' => [], ], 'UnsupportedFeatureException' => [ 'base' => '<p>Used by the <a>GetAssessmentReport</a> API. The request was rejected because you tried to generate a report for an assessment run that existed before reporting was supported in Amazon Inspector. You can only generate reports for assessment runs that took place or will take place after generating reports in Amazon Inspector became available.</p>', 'refs' => [], ], 'UpdateAssessmentTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'GetAssessmentReportResponse$url' => '<p>Specifies the URL where you can find the generated assessment report. This parameter is only returned if the report is successfully generated.</p>', ], ], 'UserAttributeKeyList' => [ 'base' => NULL, 'refs' => [ 'RemoveAttributesFromFindingsRequest$attributeKeys' => '<p>The array of attribute keys that you want to remove from specified findings.</p>', ], ], 'UserAttributeList' => [ 'base' => NULL, 'refs' => [ 'AddAttributesToFindingsRequest$attributes' => '<p>The array of attributes that you want to assign to specified findings.</p>', 'AssessmentRun$userAttributesForFindings' => '<p>The user-defined attributes that are assigned to every generated finding.</p>', 'AssessmentTemplate$userAttributesForFindings' => '<p>The user-defined attributes that are assigned to every generated finding from the assessment run that uses this assessment template.</p>', 'CreateAssessmentTemplateRequest$userAttributesForFindings' => '<p>The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template. An attribute is a key and value pair (an <a>Attribute</a> object). Within an assessment template, each key must be unique.</p>', 'Finding$userAttributes' => '<p>The user-defined attributes that are assigned to the finding.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'RulesPackage$version' => '<p>The version ID of the rules package.</p>', ], ], ],];
