<?php
// This file was auto-generated from sdk-root/src/data/iot/2015-05-28/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS IoT</fullname> <p>AWS IoT provides secure, bi-directional communication between Internet-connected things (such as sensors, actuators, embedded devices, or smart appliances) and the AWS cloud. You can discover your custom IoT-Data endpoint to communicate with, configure rules for data processing and integration with other services, organize resources associated with each thing (Thing Registry), configure logging, and create and manage policies and credentials to authenticate things.</p> <p>For more information about how AWS IoT works, see the <a href="http://docs.aws.amazon.com/iot/latest/developerguide/aws-iot-how-it-works.html">Developer Guide</a>.</p>', 'operations' => [ 'AcceptCertificateTransfer' => '<p>Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.</p> <p>To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.</p>', 'AttachPrincipalPolicy' => '<p>Attaches the specified policy to the specified principal (certificate or other credential).</p>', 'AttachThingPrincipal' => '<p>Attaches the specified principal to the specified thing.</p>', 'CancelCertificateTransfer' => '<p>Cancels a pending transfer for the specified certificate.</p> <p> <b>Note</b> Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations can use <a>RejectCertificateTransfer</a> instead.) After transfer, AWS IoT returns the certificate to the source account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be cancelled.</p> <p>After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to INACTIVE.</p>', 'CreateCertificateFromCsr' => '<p>Creates an X.509 certificate using the specified certificate signing request.</p> <p> <b>Note:</b> The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or an ECC key from NIST P-256 or NIST P-384 curves. </p> <p> <b>Note:</b> Reusing the same certificate signing request (CSR) results in a distinct certificate.</p> <p>You can create multiple certificates in a batch by creating a directory, copying multiple .csr files into that directory, and then specifying that directory on the command line. The following commands show how to create a batch of certificates given a batch of CSRs.</p> <p>Assuming a set of CSRs are located inside of the directory my-csr-directory:</p> <p>On Linux and OS X, the command is:</p> <p>$ ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}</p> <p>This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the aws iot create-certificate-from-csr AWS CLI command to create a certificate for the corresponding CSR.</p> <p>The aws iot create-certificate-from-csr part of the command can also be run in parallel to speed up the certificate creation process:</p> <p>$ ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}</p> <p>On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:</p> <p>&gt; ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/$_}</p> <p>On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:</p> <p>&gt; forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path"</p>', 'CreateKeysAndCertificate' => '<p>Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key.</p> <p> <b>Note</b> This is the only time AWS IoT issues the private key for this certificate, so it is important to keep it in a secure location.</p>', 'CreatePolicy' => '<p>Creates an AWS IoT policy.</p> <p>The created policy is the default version for the policy. This operation creates a policy version with a version identifier of <b>1</b> and sets <b>1</b> as the policy\'s default version.</p>', 'CreatePolicyVersion' => '<p>Creates a new version of the specified AWS IoT policy. To update a policy, create a new policy version. A managed policy can have up to five versions. If the policy has five versions, you must use <a>DeletePolicyVersion</a> to delete an existing version before you create a new one.</p> <p>Optionally, you can set the new version as the policy\'s default version. The default version is the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>', 'CreateThing' => '<p>Creates a thing record in the thing registry.</p>', 'CreateThingType' => '<p>Creates a new thing type.</p>', 'CreateTopicRule' => '<p>Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will be able to access data processed by the rule.</p>', 'DeleteCACertificate' => '<p>Deletes a registered CA certificate.</p>', 'DeleteCertificate' => '<p>Deletes the specified certificate.</p> <p>A certificate cannot be deleted if it has a policy attached to it or if its status is set to ACTIVE. To delete a certificate, first use the <a>DetachPrincipalPolicy</a> API to detach all policies. Next, use the <a>UpdateCertificate</a> API to set the certificate to the INACTIVE status.</p>', 'DeletePolicy' => '<p>Deletes the specified policy.</p> <p>A policy cannot be deleted if it has non-default versions or it is attached to any certificate.</p> <p>To delete a policy, use the DeletePolicyVersion API to delete all non-default versions of the policy; use the DetachPrincipalPolicy API to detach the policy from any certificate; and then use the DeletePolicy API to delete the policy.</p> <p>When a policy is deleted using DeletePolicy, its default version is deleted with it.</p>', 'DeletePolicyVersion' => '<p>Deletes the specified version of the specified policy. You cannot delete the default version of a policy using this API. To delete the default version of a policy, use <a>DeletePolicy</a>. To find out which version of a policy is marked as the default version, use ListPolicyVersions.</p>', 'DeleteRegistrationCode' => '<p>Deletes a CA certificate registration code.</p>', 'DeleteThing' => '<p>Deletes the specified thing.</p>', 'DeleteThingType' => '<p>Deletes the specified thing type . You cannot delete a thing type if it has things associated with it. To delete a thing type, first mark it as deprecated by calling <a>DeprecateThingType</a>, then remove any associated things by calling <a>UpdateThing</a> to change the thing type on any associated thing, and finally use <a>DeleteThingType</a> to delete the thing type.</p>', 'DeleteTopicRule' => '<p>Deletes the specified rule.</p>', 'DeprecateThingType' => '<p>Deprecates a thing type. You can not associate new things with deprecated thing type.</p>', 'DescribeCACertificate' => '<p>Describes a registered CA certificate.</p>', 'DescribeCertificate' => '<p>Gets information about the specified certificate.</p>', 'DescribeEndpoint' => '<p>Returns a unique endpoint specific to the AWS account making the call.</p>', 'DescribeThing' => '<p>Gets information about the specified thing.</p>', 'DescribeThingType' => '<p>Gets information about the specified thing type.</p>', 'DetachPrincipalPolicy' => '<p>Removes the specified policy from the specified certificate.</p>', 'DetachThingPrincipal' => '<p>Detaches the specified principal from the specified thing.</p>', 'DisableTopicRule' => '<p>Disables the specified rule.</p>', 'EnableTopicRule' => '<p>Enables the specified rule.</p>', 'GetLoggingOptions' => '<p>Gets the logging options.</p>', 'GetPolicy' => '<p>Gets information about the specified policy with the policy document of the default version.</p>', 'GetPolicyVersion' => '<p>Gets information about the specified policy version.</p>', 'GetRegistrationCode' => '<p>Gets a registration code used to register a CA certificate with AWS IoT.</p>', 'GetTopicRule' => '<p>Gets information about the specified rule.</p>', 'ListCACertificates' => '<p>Lists the CA certificates registered for your AWS account.</p> <p>The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional results.</p>', 'ListCertificates' => '<p>Lists the certificates registered in your AWS account.</p> <p>The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional results.</p>', 'ListCertificatesByCA' => '<p>List the device certificates signed by the specified CA certificate.</p>', 'ListOutgoingCertificates' => '<p>Lists certificates that are being transfered but not yet accepted.</p>', 'ListPolicies' => '<p>Lists your policies.</p>', 'ListPolicyPrincipals' => '<p>Lists the principals associated with the specified policy.</p>', 'ListPolicyVersions' => '<p>Lists the versions of the specified policy and identifies the default version.</p>', 'ListPrincipalPolicies' => '<p>Lists the policies attached to the specified principal. If you use an Cognito identity, the ID must be in <a href="http://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html#API_GetCredentialsForIdentity_RequestSyntax">AmazonCognito Identity format</a>.</p>', 'ListPrincipalThings' => '<p>Lists the things associated with the specified principal.</p>', 'ListThingPrincipals' => '<p>Lists the principals associated with the specified thing.</p>', 'ListThingTypes' => '<p>Lists the existing thing types.</p>', 'ListThings' => '<p>Lists your things. Use the <b>attributeName</b> and <b>attributeValue</b> parameters to filter your things. For example, calling <code>ListThings</code> with attributeName=Color and attributeValue=Red retrieves all things in the registry that contain an attribute <b>Color</b> with the value <b>Red</b>. </p>', 'ListTopicRules' => '<p>Lists the rules for the specific topic.</p>', 'RegisterCACertificate' => '<p>Registers a CA certificate with AWS IoT. This CA certificate can then be used to sign device certificates, which can be then registered with AWS IoT. You can register up to 10 CA certificates per AWS account that have the same subject field. This enables you to have up to 10 certificate authorities sign your device certificates. If you have more than one CA certificate registered, make sure you pass the CA certificate when you register your device certificates with the RegisterCertificate API.</p>', 'RegisterCertificate' => '<p>Registers a device certificate with AWS IoT. If you have more than one CA certificate that has the same subject field, you must specify the CA certificate that was used to sign the device certificate being registered.</p>', 'RejectCertificateTransfer' => '<p>Rejects a pending certificate transfer. After AWS IoT rejects a certificate transfer, the certificate status changes from <b>PENDING_TRANSFER</b> to <b>INACTIVE</b>.</p> <p>To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.</p> <p>This operation can only be called by the transfer destination. After it is called, the certificate will be returned to the source\'s account in the INACTIVE state.</p>', 'ReplaceTopicRule' => '<p>Replaces the specified rule. You must specify all parameters for the new rule. Creating rules is an administrator-level action. Any user who has permission to create rules will be able to access data processed by the rule.</p>', 'SetDefaultPolicyVersion' => '<p>Sets the specified version of the specified policy as the policy\'s default (operative) version. This action affects all certificates to which the policy is attached. To list the principals the policy is attached to, use the ListPrincipalPolicy API.</p>', 'SetLoggingOptions' => '<p>Sets the logging options.</p>', 'TransferCertificate' => '<p>Transfers the specified certificate to the specified AWS account.</p> <p>You can cancel the transfer until it is acknowledged by the recipient.</p> <p>No notification is sent to the transfer destination\'s account. It is up to the caller to notify the transfer target.</p> <p>The certificate being transferred must not be in the ACTIVE state. You can use the UpdateCertificate API to deactivate it.</p> <p>The certificate must not have any policies attached to it. You can use the DetachPrincipalPolicy API to detach them.</p>', 'UpdateCACertificate' => '<p>Updates a registered CA certificate.</p>', 'UpdateCertificate' => '<p>Updates the status of the specified certificate. This operation is idempotent.</p> <p>Moving a certificate from the ACTIVE state (including REVOKED) will not disconnect currently connected devices, but these devices will be unable to reconnect.</p> <p>The ACTIVE state is required to authenticate devices connecting to AWS IoT using a certificate.</p>', 'UpdateThing' => '<p>Updates the data for a thing.</p>', ], 'shapes' => [ 'AcceptCertificateTransferRequest' => [ 'base' => '<p>The input for the AcceptCertificateTransfer operation.</p>', 'refs' => [], ], 'Action' => [ 'base' => '<p>Describes the actions associated with a rule.</p>', 'refs' => [ 'ActionList$member' => NULL, ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'TopicRule$actions' => '<p>The actions associated with the rule.</p>', 'TopicRulePayload$actions' => '<p>The actions associated with the rule.</p>', ], ], 'AlarmName' => [ 'base' => NULL, 'refs' => [ 'CloudwatchAlarmAction$alarmName' => '<p>The CloudWatch alarm name.</p>', ], ], 'AllowAutoRegistration' => [ 'base' => NULL, 'refs' => [ 'RegisterCACertificateRequest$allowAutoRegistration' => '<p>Allows this CA certificate to be used for auto registration of device certificates.</p>', ], ], 'AscendingOrder' => [ 'base' => NULL, 'refs' => [ 'ListCACertificatesRequest$ascendingOrder' => '<p>Determines the order of the results.</p>', 'ListCertificatesByCARequest$ascendingOrder' => '<p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>', 'ListCertificatesRequest$ascendingOrder' => '<p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>', 'ListOutgoingCertificatesRequest$ascendingOrder' => '<p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>', 'ListPoliciesRequest$ascendingOrder' => '<p>Specifies the order for results. If true, the results are returned in ascending creation order.</p>', 'ListPolicyPrincipalsRequest$ascendingOrder' => '<p>Specifies the order for results. If true, the results are returned in ascending creation order.</p>', 'ListPrincipalPoliciesRequest$ascendingOrder' => '<p>Specifies the order for results. If true, results are returned in ascending creation order.</p>', ], ], 'AttachPrincipalPolicyRequest' => [ 'base' => '<p>The input for the AttachPrincipalPolicy operation.</p>', 'refs' => [], ], 'AttachThingPrincipalRequest' => [ 'base' => '<p>The input for the AttachThingPrincipal operation.</p>', 'refs' => [], ], 'AttachThingPrincipalResponse' => [ 'base' => '<p>The output from the AttachThingPrincipal operation.</p>', 'refs' => [], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'Attributes$key' => NULL, 'ListThingsRequest$attributeName' => '<p>The attribute name used to search for things.</p>', 'SearchableAttributes$member' => NULL, ], ], 'AttributePayload' => [ 'base' => '<p>The attribute payload.</p>', 'refs' => [ 'CreateThingRequest$attributePayload' => '<p>The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:</p> <p> <code>{\\"attributes\\":{\\"string1\\":\\"string2\\"}}</code> </p>', 'UpdateThingRequest$attributePayload' => '<p>A list of thing attributes, a JSON string containing name-value pairs. For example:</p> <p> <code>{\\"attributes\\":{\\"name1\\":\\"value2\\"}}</code> </p> <p>This data is used to add new attributes or update existing attributes.</p>', ], ], 'AttributeValue' => [ 'base' => 'An attribute value for an Thing. An empty or null value in Update means that existing value for that attribute should be deleted. Empty and null values in create are ignored.', 'refs' => [ 'Attributes$value' => NULL, 'ListThingsRequest$attributeValue' => '<p>The attribute value used to search for things.</p>', ], ], 'Attributes' => [ 'base' => NULL, 'refs' => [ 'AttributePayload$attributes' => '<p>A JSON string containing up to three key-value pair in JSON format. For example:</p> <p> <code>{\\"attributes\\":{\\"string1\\":\\"string2\\"}}</code> </p>', 'DescribeThingResponse$attributes' => '<p>The thing attributes.</p>', 'ThingAttribute$attributes' => '<p>A list of thing attributes which are name-value pairs.</p>', ], ], 'AutoRegistrationStatus' => [ 'base' => NULL, 'refs' => [ 'CACertificateDescription$autoRegistrationStatus' => '<p>Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE" and "DISABLE"</p>', 'UpdateCACertificateRequest$newAutoRegistrationStatus' => '<p>The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'CACertificateDescription$ownedBy' => '<p>The owner of the CA certificate.</p>', 'CertificateDescription$ownedBy' => '<p>The ID of the AWS account that owns the certificate.</p>', 'CertificateDescription$previousOwnedBy' => '<p>The ID of the AWS account of the previous owner of the certificate.</p>', 'OutgoingCertificate$transferredTo' => '<p>The AWS account to which the transfer was made.</p>', 'TransferCertificateRequest$targetAwsAccount' => '<p>The AWS account.</p>', ], ], 'AwsArn' => [ 'base' => NULL, 'refs' => [ 'CloudwatchAlarmAction$roleArn' => '<p>The IAM role that allows access to the CloudWatch alarm.</p>', 'CloudwatchMetricAction$roleArn' => '<p>The IAM role that allows access to the CloudWatch metric.</p>', 'DynamoDBAction$roleArn' => '<p>The ARN of the IAM role that grants access to the DynamoDB table.</p>', 'DynamoDBv2Action$roleArn' => '<p>The ARN of the IAM role that grants access to the DynamoDB table.</p>', 'ElasticsearchAction$roleArn' => '<p>The IAM role ARN that has access to Elasticsearch.</p>', 'FirehoseAction$roleArn' => '<p>The IAM role that grants access to the Amazon Kinesis Firehost stream.</p>', 'GetLoggingOptionsResponse$roleArn' => '<p>The ARN of the IAM role that grants access.</p>', 'KinesisAction$roleArn' => '<p>The ARN of the IAM role that grants access to the Amazon Kinesis stream.</p>', 'LoggingOptionsPayload$roleArn' => '<p>The ARN of the IAM role that grants access.</p>', 'RepublishAction$roleArn' => '<p>The ARN of the IAM role that grants access.</p>', 'S3Action$roleArn' => '<p>The ARN of the IAM role that grants access.</p>', 'SnsAction$targetArn' => '<p>The ARN of the SNS topic.</p>', 'SnsAction$roleArn' => '<p>The ARN of the IAM role that grants access.</p>', 'SqsAction$roleArn' => '<p>The ARN of the IAM role that grants access.</p>', ], ], 'AwsIotSqlVersion' => [ 'base' => NULL, 'refs' => [ 'TopicRule$awsIotSqlVersion' => '<p>The version of the SQL rules engine to use when evaluating the rule.</p>', 'TopicRulePayload$awsIotSqlVersion' => '<p>The version of the SQL rules engine to use when evaluating the rule.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ThingTypeMetadata$deprecated' => '<p>Whether the thing type is deprecated. If <b>true</b>, no new things could be associated with this type.</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'S3Action$bucketName' => '<p>The Amazon S3 bucket.</p>', ], ], 'CACertificate' => [ 'base' => '<p>A CA certificate.</p>', 'refs' => [ 'CACertificates$member' => NULL, ], ], 'CACertificateDescription' => [ 'base' => '<p>Describes a CA certificate.</p>', 'refs' => [ 'DescribeCACertificateResponse$certificateDescription' => '<p>The CA certificate description.</p>', ], ], 'CACertificateStatus' => [ 'base' => NULL, 'refs' => [ 'CACertificate$status' => '<p>The status of the CA certificate.</p> <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>', 'CACertificateDescription$status' => '<p>The status of a CA certificate.</p>', 'UpdateCACertificateRequest$newStatus' => '<p>The updated status of the CA certificate.</p> <p> <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.</p>', ], ], 'CACertificates' => [ 'base' => NULL, 'refs' => [ 'ListCACertificatesResponse$certificates' => '<p>The CA certificates registered in your AWS account.</p>', ], ], 'CancelCertificateTransferRequest' => [ 'base' => '<p>The input for the CancelCertificateTransfer operation.</p>', 'refs' => [], ], 'CannedAccessControlList' => [ 'base' => NULL, 'refs' => [ 'S3Action$cannedAcl' => '<p>The Amazon S3 canned ACL that controls access to the object identified by the object key. For more information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.</p>', ], ], 'Certificate' => [ 'base' => '<p>Information about a certificate.</p>', 'refs' => [ 'Certificates$member' => NULL, ], ], 'CertificateArn' => [ 'base' => NULL, 'refs' => [ 'CACertificate$certificateArn' => '<p>The ARN of the CA certificate.</p>', 'CACertificateDescription$certificateArn' => '<p>The CA certificate ARN.</p>', 'Certificate$certificateArn' => '<p>The ARN of the certificate.</p>', 'CertificateDescription$certificateArn' => '<p>The ARN of the certificate.</p>', 'CreateCertificateFromCsrResponse$certificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate. You can use the ARN as a principal for policy operations.</p>', 'CreateKeysAndCertificateResponse$certificateArn' => '<p>The ARN of the certificate.</p>', 'OutgoingCertificate$certificateArn' => '<p>The certificate ARN.</p>', 'RegisterCACertificateResponse$certificateArn' => '<p>The CA certificate ARN.</p>', 'RegisterCertificateResponse$certificateArn' => '<p>The certificate ARN.</p>', 'TransferCertificateResponse$transferredCertificateArn' => '<p>The ARN of the certificate.</p>', ], ], 'CertificateConflictException' => [ 'base' => '<p>Unable to verify the CA certificate used to sign the device certificate you are attempting to register. This is happens when you have registered more than one CA certificate that has the same subject field and public key.</p>', 'refs' => [], ], 'CertificateDescription' => [ 'base' => '<p>Describes a certificate.</p>', 'refs' => [ 'DescribeCertificateResponse$certificateDescription' => '<p>The description of the certificate.</p>', ], ], 'CertificateId' => [ 'base' => NULL, 'refs' => [ 'AcceptCertificateTransferRequest$certificateId' => '<p>The ID of the certificate.</p>', 'CACertificate$certificateId' => '<p>The ID of the CA certificate.</p>', 'CACertificateDescription$certificateId' => '<p>The CA certificate ID.</p>', 'CancelCertificateTransferRequest$certificateId' => '<p>The ID of the certificate.</p>', 'Certificate$certificateId' => '<p>The ID of the certificate.</p>', 'CertificateDescription$certificateId' => '<p>The ID of the certificate.</p>', 'CertificateDescription$caCertificateId' => '<p>The certificate ID of the CA certificate used to sign this certificate.</p>', 'CreateCertificateFromCsrResponse$certificateId' => '<p>The ID of the certificate. Certificate management operations only take a certificateId.</p>', 'CreateKeysAndCertificateResponse$certificateId' => '<p>The ID of the certificate. AWS IoT issues a default subject name for the certificate (for example, AWS IoT Certificate).</p>', 'DeleteCACertificateRequest$certificateId' => '<p>The ID of the certificate to delete.</p>', 'DeleteCertificateRequest$certificateId' => '<p>The ID of the certificate.</p>', 'DescribeCACertificateRequest$certificateId' => '<p>The CA certificate identifier.</p>', 'DescribeCertificateRequest$certificateId' => '<p>The ID of the certificate.</p>', 'ListCertificatesByCARequest$caCertificateId' => '<p>The ID of the CA certificate. This operation will list all registered device certificate that were signed by this CA certificate.</p>', 'OutgoingCertificate$certificateId' => '<p>The certificate ID.</p>', 'RegisterCACertificateResponse$certificateId' => '<p>The CA certificate identifier.</p>', 'RegisterCertificateResponse$certificateId' => '<p>The certificate identifier.</p>', 'RejectCertificateTransferRequest$certificateId' => '<p>The ID of the certificate.</p>', 'TransferCertificateRequest$certificateId' => '<p>The ID of the certificate.</p>', 'UpdateCACertificateRequest$certificateId' => '<p>The CA certificate identifier.</p>', 'UpdateCertificateRequest$certificateId' => '<p>The ID of the certificate.</p>', ], ], 'CertificatePem' => [ 'base' => NULL, 'refs' => [ 'CACertificateDescription$certificatePem' => '<p>The CA certificate data, in PEM format.</p>', 'CertificateDescription$certificatePem' => '<p>The certificate data, in PEM format.</p>', 'CreateCertificateFromCsrResponse$certificatePem' => '<p>The certificate data, in PEM format.</p>', 'CreateKeysAndCertificateResponse$certificatePem' => '<p>The certificate data, in PEM format.</p>', 'RegisterCACertificateRequest$caCertificate' => '<p>The CA certificate.</p>', 'RegisterCACertificateRequest$verificationCertificate' => '<p>The private key verification certificate.</p>', 'RegisterCertificateRequest$certificatePem' => '<p>The certificate data, in PEM format.</p>', 'RegisterCertificateRequest$caCertificatePem' => '<p>The CA certificate used to sign the device certificate being registered.</p>', ], ], 'CertificateSigningRequest' => [ 'base' => NULL, 'refs' => [ 'CreateCertificateFromCsrRequest$certificateSigningRequest' => '<p>The certificate signing request (CSR).</p>', ], ], 'CertificateStateException' => [ 'base' => '<p>The certificate operation is not allowed.</p>', 'refs' => [], ], 'CertificateStatus' => [ 'base' => NULL, 'refs' => [ 'Certificate$status' => '<p>The status of the certificate.</p> <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>', 'CertificateDescription$status' => '<p>The status of the certificate.</p>', 'RegisterCertificateRequest$status' => '<p>The status of the register certificate request.</p>', 'UpdateCertificateRequest$newStatus' => '<p>The new status.</p> <p> <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown. PENDING_TRANSFER is a status used internally by AWS IoT. It is not intended for developer use.</p> <p> <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.</p>', ], ], 'CertificateValidationException' => [ 'base' => '<p>The certificate is invalid.</p>', 'refs' => [], ], 'Certificates' => [ 'base' => NULL, 'refs' => [ 'ListCertificatesByCAResponse$certificates' => '<p>The device certificates signed by the specified CA certificate.</p>', 'ListCertificatesResponse$certificates' => '<p>The descriptions of the certificates.</p>', ], ], 'ClientId' => [ 'base' => NULL, 'refs' => [ 'DescribeThingResponse$defaultClientId' => '<p>The default client ID.</p>', ], ], 'CloudwatchAlarmAction' => [ 'base' => '<p>Describes an action that updates a CloudWatch alarm.</p>', 'refs' => [ 'Action$cloudwatchAlarm' => '<p>Change the state of a CloudWatch alarm.</p>', ], ], 'CloudwatchMetricAction' => [ 'base' => '<p>Describes an action that captures a CloudWatch metric.</p>', 'refs' => [ 'Action$cloudwatchMetric' => '<p>Capture a CloudWatch metric.</p>', ], ], 'CreateCertificateFromCsrRequest' => [ 'base' => '<p>The input for the CreateCertificateFromCsr operation.</p>', 'refs' => [], ], 'CreateCertificateFromCsrResponse' => [ 'base' => '<p>The output from the CreateCertificateFromCsr operation.</p>', 'refs' => [], ], 'CreateKeysAndCertificateRequest' => [ 'base' => '<p>The input for the CreateKeysAndCertificate operation.</p>', 'refs' => [], ], 'CreateKeysAndCertificateResponse' => [ 'base' => '<p>The output of the CreateKeysAndCertificate operation.</p>', 'refs' => [], ], 'CreatePolicyRequest' => [ 'base' => '<p>The input for the CreatePolicy operation.</p>', 'refs' => [], ], 'CreatePolicyResponse' => [ 'base' => '<p>The output from the CreatePolicy operation.</p>', 'refs' => [], ], 'CreatePolicyVersionRequest' => [ 'base' => '<p>The input for the CreatePolicyVersion operation.</p>', 'refs' => [], ], 'CreatePolicyVersionResponse' => [ 'base' => '<p>The output of the CreatePolicyVersion operation.</p>', 'refs' => [], ], 'CreateThingRequest' => [ 'base' => '<p>The input for the CreateThing operation.</p>', 'refs' => [], ], 'CreateThingResponse' => [ 'base' => '<p>The output of the CreateThing operation.</p>', 'refs' => [], ], 'CreateThingTypeRequest' => [ 'base' => '<p>The input for the CreateThingType operation.</p>', 'refs' => [], ], 'CreateThingTypeResponse' => [ 'base' => '<p>The output of the CreateThingType operation.</p>', 'refs' => [], ], 'CreateTopicRuleRequest' => [ 'base' => '<p>The input for the CreateTopicRule operation.</p>', 'refs' => [], ], 'CreatedAtDate' => [ 'base' => NULL, 'refs' => [ 'TopicRule$createdAt' => '<p>The date and time the rule was created.</p>', 'TopicRuleListItem$createdAt' => '<p>The date and time the rule was created.</p>', ], ], 'CreationDate' => [ 'base' => NULL, 'refs' => [ 'ThingTypeMetadata$creationDate' => '<p>The date and time when the thing type was created.</p>', ], ], 'DateType' => [ 'base' => NULL, 'refs' => [ 'CACertificate$creationDate' => '<p>The date the CA certificate was created.</p>', 'CACertificateDescription$creationDate' => '<p>The date the CA certificate was created.</p>', 'Certificate$creationDate' => '<p>The date and time the certificate was created.</p>', 'CertificateDescription$creationDate' => '<p>The date and time the certificate was created.</p>', 'CertificateDescription$lastModifiedDate' => '<p>The date and time the certificate was last modified.</p>', 'OutgoingCertificate$transferDate' => '<p>The date the transfer was initiated.</p>', 'OutgoingCertificate$creationDate' => '<p>The certificate creation date.</p>', 'PolicyVersion$createDate' => '<p>The date and time the policy was created.</p>', 'TransferData$transferDate' => '<p>The date the transfer took place.</p>', 'TransferData$acceptDate' => '<p>The date the transfer was accepted.</p>', 'TransferData$rejectDate' => '<p>The date the transfer was rejected.</p>', ], ], 'DeleteCACertificateRequest' => [ 'base' => '<p>Input for the DeleteCACertificate operation.</p>', 'refs' => [], ], 'DeleteCACertificateResponse' => [ 'base' => '<p>The output for the DeleteCACertificate operation.</p>', 'refs' => [], ], 'DeleteCertificateRequest' => [ 'base' => '<p>The input for the DeleteCertificate operation.</p>', 'refs' => [], ], 'DeleteConflictException' => [ 'base' => '<p>You can\'t delete the resource because it is attached to one or more resources.</p>', 'refs' => [], ], 'DeletePolicyRequest' => [ 'base' => '<p>The input for the DeletePolicy operation.</p>', 'refs' => [], ], 'DeletePolicyVersionRequest' => [ 'base' => '<p>The input for the DeletePolicyVersion operation.</p>', 'refs' => [], ], 'DeleteRegistrationCodeRequest' => [ 'base' => '<p>The input for the DeleteRegistrationCode operation.</p>', 'refs' => [], ], 'DeleteRegistrationCodeResponse' => [ 'base' => '<p>The output for the DeleteRegistrationCode operation.</p>', 'refs' => [], ], 'DeleteThingRequest' => [ 'base' => '<p>The input for the DeleteThing operation.</p>', 'refs' => [], ], 'DeleteThingResponse' => [ 'base' => '<p>The output of the DeleteThing operation.</p>', 'refs' => [], ], 'DeleteThingTypeRequest' => [ 'base' => '<p>The input for the DeleteThingType operation.</p>', 'refs' => [], ], 'DeleteThingTypeResponse' => [ 'base' => '<p>The output for the DeleteThingType operation.</p>', 'refs' => [], ], 'DeleteTopicRuleRequest' => [ 'base' => '<p>The input for the DeleteTopicRule operation.</p>', 'refs' => [], ], 'DeliveryStreamName' => [ 'base' => NULL, 'refs' => [ 'FirehoseAction$deliveryStreamName' => '<p>The delivery stream name.</p>', ], ], 'DeprecateThingTypeRequest' => [ 'base' => '<p>The input for the DeprecateThingType operation.</p>', 'refs' => [], ], 'DeprecateThingTypeResponse' => [ 'base' => '<p>The output for the DeprecateThingType operation.</p>', 'refs' => [], ], 'DeprecationDate' => [ 'base' => NULL, 'refs' => [ 'ThingTypeMetadata$deprecationDate' => '<p>The date and time when the thing type was deprecated.</p>', ], ], 'DescribeCACertificateRequest' => [ 'base' => '<p>The input for the DescribeCACertificate operation.</p>', 'refs' => [], ], 'DescribeCACertificateResponse' => [ 'base' => '<p>The output from the DescribeCACertificate operation.</p>', 'refs' => [], ], 'DescribeCertificateRequest' => [ 'base' => '<p>The input for the DescribeCertificate operation.</p>', 'refs' => [], ], 'DescribeCertificateResponse' => [ 'base' => '<p>The output of the DescribeCertificate operation.</p>', 'refs' => [], ], 'DescribeEndpointRequest' => [ 'base' => '<p>The input for the DescribeEndpoint operation.</p>', 'refs' => [], ], 'DescribeEndpointResponse' => [ 'base' => '<p>The output from the DescribeEndpoint operation.</p>', 'refs' => [], ], 'DescribeThingRequest' => [ 'base' => '<p>The input for the DescribeThing operation.</p>', 'refs' => [], ], 'DescribeThingResponse' => [ 'base' => '<p>The output from the DescribeThing operation.</p>', 'refs' => [], ], 'DescribeThingTypeRequest' => [ 'base' => '<p>The input for the DescribeThingType operation.</p>', 'refs' => [], ], 'DescribeThingTypeResponse' => [ 'base' => '<p>The output for the DescribeThingType operation.</p>', 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'TopicRule$description' => '<p>The description of the rule.</p>', 'TopicRulePayload$description' => '<p>The description of the rule.</p>', ], ], 'DetachPrincipalPolicyRequest' => [ 'base' => '<p>The input for the DetachPrincipalPolicy operation.</p>', 'refs' => [], ], 'DetachThingPrincipalRequest' => [ 'base' => '<p>The input for the DetachThingPrincipal operation.</p>', 'refs' => [], ], 'DetachThingPrincipalResponse' => [ 'base' => '<p>The output from the DetachThingPrincipal operation.</p>', 'refs' => [], ], 'DisableTopicRuleRequest' => [ 'base' => '<p>The input for the DisableTopicRuleRequest operation.</p>', 'refs' => [], ], 'DynamoDBAction' => [ 'base' => '<p>Describes an action to write to a DynamoDB table.</p> <p>The <code>tableName</code>, <code>hashKeyField</code>, and <code>rangeKeyField</code> values must match the values used when you created the table.</p> <p>The <code>hashKeyValue</code> and <code>rangeKeyvalue</code> fields use a substitution template syntax. These templates provide data at runtime. The syntax is as follows: ${<i>sql-expression</i>}.</p> <p>You can specify any valid expression in a WHERE or SELECT clause, including JSON properties, comparisons, calculations, and functions. For example, the following field uses the third level of the topic:</p> <p> <code>"hashKeyValue": "${topic(3)}"</code> </p> <p>The following field uses the timestamp:</p> <p> <code>"rangeKeyValue": "${timestamp()}"</code> </p>', 'refs' => [ 'Action$dynamoDB' => '<p>Write to a DynamoDB table.</p>', ], ], 'DynamoDBv2Action' => [ 'base' => '<p>Describes an action to write to a DynamoDB table.</p> <p>This DynamoDB action writes each attribute in the message payload into it\'s own column in the DynamoDB table.</p>', 'refs' => [ 'Action$dynamoDBv2' => '<p>Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each attribute in an MQTT message payload into a separate DynamoDB column.</p>', ], ], 'DynamoKeyType' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$hashKeyType' => '<p>The hash key type. Valid values are "STRING" or "NUMBER"</p>', 'DynamoDBAction$rangeKeyType' => '<p>The range key type. Valid values are "STRING" or "NUMBER"</p>', ], ], 'DynamoOperation' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$operation' => '<p>The type of operation to be performed. This follows the substitution template, so it can be <code>${operation}</code>, but the substitution must result in one of the following: <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>.</p>', ], ], 'ElasticsearchAction' => [ 'base' => '<p>Describes an action that writes data to an Amazon Elasticsearch Service domain.</p>', 'refs' => [ 'Action$elasticsearch' => '<p>Write data to an Amazon Elasticsearch Service domain.</p>', ], ], 'ElasticsearchEndpoint' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchAction$endpoint' => '<p>The endpoint of your Elasticsearch domain.</p>', ], ], 'ElasticsearchId' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchAction$id' => '<p>The unique identifier for the document you are storing.</p>', ], ], 'ElasticsearchIndex' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchAction$index' => '<p>The Elasticsearch index where you want to store your data.</p>', ], ], 'ElasticsearchType' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchAction$type' => '<p>The type of document you are storing.</p>', ], ], 'EnableTopicRuleRequest' => [ 'base' => '<p>The input for the EnableTopicRuleRequest operation.</p>', 'refs' => [], ], 'EndpointAddress' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointResponse$endpointAddress' => '<p>The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.</p>', ], ], 'FirehoseAction' => [ 'base' => '<p>Describes an action that writes data to an Amazon Kinesis Firehose stream.</p>', 'refs' => [ 'Action$firehose' => '<p>Write to an Amazon Kinesis Firehose stream.</p>', ], ], 'FirehoseSeparator' => [ 'base' => NULL, 'refs' => [ 'FirehoseAction$separator' => '<p>A character separator that will be used to separate records written to the Firehose stream. Valid values are: \'\\n\' (newline), \'\\t\' (tab), \'\\r\\n\' (Windows newline), \',\' (comma).</p>', ], ], 'Flag' => [ 'base' => NULL, 'refs' => [ 'AttributePayload$merge' => '<p>Specifies whether the list of attributes provided in the <code>AttributePayload</code> is merged with the attributes stored in the registry, instead of overwriting them.</p> <p>To remove an attribute, call <code>UpdateThing</code> with an empty attribute value.</p> <note> <p>The <code>merge</code> attribute is only valid when calling <code>UpdateThing</code>.</p> </note>', ], ], 'FunctionArn' => [ 'base' => NULL, 'refs' => [ 'LambdaAction$functionArn' => '<p>The ARN of the Lambda function.</p>', ], ], 'GetLoggingOptionsRequest' => [ 'base' => '<p>The input for the GetLoggingOptions operation.</p>', 'refs' => [], ], 'GetLoggingOptionsResponse' => [ 'base' => '<p>The output from the GetLoggingOptions operation.</p>', 'refs' => [], ], 'GetPolicyRequest' => [ 'base' => '<p>The input for the GetPolicy operation.</p>', 'refs' => [], ], 'GetPolicyResponse' => [ 'base' => '<p>The output from the GetPolicy operation.</p>', 'refs' => [], ], 'GetPolicyVersionRequest' => [ 'base' => '<p>The input for the GetPolicyVersion operation.</p>', 'refs' => [], ], 'GetPolicyVersionResponse' => [ 'base' => '<p>The output from the GetPolicyVersion operation.</p>', 'refs' => [], ], 'GetRegistrationCodeRequest' => [ 'base' => '<p>The input to the GetRegistrationCode operation.</p>', 'refs' => [], ], 'GetRegistrationCodeResponse' => [ 'base' => '<p>The output from the GetRegistrationCode operation.</p>', 'refs' => [], ], 'GetTopicRuleRequest' => [ 'base' => '<p>The input for the GetTopicRule operation.</p>', 'refs' => [], ], 'GetTopicRuleResponse' => [ 'base' => '<p>The output from the GetTopicRule operation.</p>', 'refs' => [], ], 'HashKeyField' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$hashKeyField' => '<p>The hash key name.</p>', ], ], 'HashKeyValue' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$hashKeyValue' => '<p>The hash key value.</p>', ], ], 'InternalException' => [ 'base' => '<p>An unexpected error has occurred.</p>', 'refs' => [], ], 'InternalFailureException' => [ 'base' => '<p>An unexpected error has occurred.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request is not valid.</p>', 'refs' => [], ], 'IsDefaultVersion' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyVersionResponse$isDefaultVersion' => '<p>Specifies whether the policy version is the default.</p>', 'GetPolicyVersionResponse$isDefaultVersion' => '<p>Specifies whether the policy version is the default.</p>', 'PolicyVersion$isDefaultVersion' => '<p>Specifies whether the policy version is the default.</p>', ], ], 'IsDisabled' => [ 'base' => NULL, 'refs' => [ 'ListTopicRulesRequest$ruleDisabled' => '<p>Specifies whether the rule is disabled.</p>', 'TopicRule$ruleDisabled' => '<p>Specifies whether the rule is disabled.</p>', 'TopicRuleListItem$ruleDisabled' => '<p>Specifies whether the rule is disabled.</p>', 'TopicRulePayload$ruleDisabled' => '<p>Specifies whether the rule is disabled.</p>', ], ], 'Key' => [ 'base' => NULL, 'refs' => [ 'S3Action$key' => '<p>The object key.</p>', ], ], 'KeyPair' => [ 'base' => '<p>Describes a key pair.</p>', 'refs' => [ 'CreateKeysAndCertificateResponse$keyPair' => '<p>The generated key pair.</p>', ], ], 'KinesisAction' => [ 'base' => '<p>Describes an action to write data to an Amazon Kinesis stream.</p>', 'refs' => [ 'Action$kinesis' => '<p>Write data to an Amazon Kinesis stream.</p>', ], ], 'LambdaAction' => [ 'base' => '<p>Describes an action to invoke a Lambda function.</p>', 'refs' => [ 'Action$lambda' => '<p>Invoke a Lambda function.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The number of attached entities exceeds the limit.</p>', 'refs' => [], ], 'ListCACertificatesRequest' => [ 'base' => '<p>Input for the ListCACertificates operation.</p>', 'refs' => [], ], 'ListCACertificatesResponse' => [ 'base' => '<p>The output from the ListCACertificates operation.</p>', 'refs' => [], ], 'ListCertificatesByCARequest' => [ 'base' => '<p>The input to the ListCertificatesByCA operation.</p>', 'refs' => [], ], 'ListCertificatesByCAResponse' => [ 'base' => '<p>The output of the ListCertificatesByCA operation.</p>', 'refs' => [], ], 'ListCertificatesRequest' => [ 'base' => '<p>The input for the ListCertificates operation.</p>', 'refs' => [], ], 'ListCertificatesResponse' => [ 'base' => '<p>The output of the ListCertificates operation.</p>', 'refs' => [], ], 'ListOutgoingCertificatesRequest' => [ 'base' => '<p>The input to the ListOutgoingCertificates operation.</p>', 'refs' => [], ], 'ListOutgoingCertificatesResponse' => [ 'base' => '<p>The output from the ListOutgoingCertificates operation.</p>', 'refs' => [], ], 'ListPoliciesRequest' => [ 'base' => '<p>The input for the ListPolicies operation.</p>', 'refs' => [], ], 'ListPoliciesResponse' => [ 'base' => '<p>The output from the ListPolicies operation.</p>', 'refs' => [], ], 'ListPolicyPrincipalsRequest' => [ 'base' => '<p>The input for the ListPolicyPrincipals operation.</p>', 'refs' => [], ], 'ListPolicyPrincipalsResponse' => [ 'base' => '<p>The output from the ListPolicyPrincipals operation.</p>', 'refs' => [], ], 'ListPolicyVersionsRequest' => [ 'base' => '<p>The input for the ListPolicyVersions operation.</p>', 'refs' => [], ], 'ListPolicyVersionsResponse' => [ 'base' => '<p>The output from the ListPolicyVersions operation.</p>', 'refs' => [], ], 'ListPrincipalPoliciesRequest' => [ 'base' => '<p>The input for the ListPrincipalPolicies operation.</p>', 'refs' => [], ], 'ListPrincipalPoliciesResponse' => [ 'base' => '<p>The output from the ListPrincipalPolicies operation.</p>', 'refs' => [], ], 'ListPrincipalThingsRequest' => [ 'base' => '<p>The input for the ListPrincipalThings operation.</p>', 'refs' => [], ], 'ListPrincipalThingsResponse' => [ 'base' => '<p>The output from the ListPrincipalThings operation.</p>', 'refs' => [], ], 'ListThingPrincipalsRequest' => [ 'base' => '<p>The input for the ListThingPrincipal operation.</p>', 'refs' => [], ], 'ListThingPrincipalsResponse' => [ 'base' => '<p>The output from the ListThingPrincipals operation.</p>', 'refs' => [], ], 'ListThingTypesRequest' => [ 'base' => '<p>The input for the ListThingTypes operation.</p>', 'refs' => [], ], 'ListThingTypesResponse' => [ 'base' => '<p>The output for the ListThingTypes operation.</p>', 'refs' => [], ], 'ListThingsRequest' => [ 'base' => '<p>The input for the ListThings operation.</p>', 'refs' => [], ], 'ListThingsResponse' => [ 'base' => '<p>The output from the ListThings operation.</p>', 'refs' => [], ], 'ListTopicRulesRequest' => [ 'base' => '<p>The input for the ListTopicRules operation.</p>', 'refs' => [], ], 'ListTopicRulesResponse' => [ 'base' => '<p>The output from the ListTopicRules operation.</p>', 'refs' => [], ], 'LogLevel' => [ 'base' => NULL, 'refs' => [ 'GetLoggingOptionsResponse$logLevel' => '<p>The logging level.</p>', 'LoggingOptionsPayload$logLevel' => '<p>The logging level.</p>', ], ], 'LoggingOptionsPayload' => [ 'base' => '<p>Describes the logging options payload.</p>', 'refs' => [ 'SetLoggingOptionsRequest$loggingOptionsPayload' => '<p>The logging options payload.</p>', ], ], 'MalformedPolicyException' => [ 'base' => '<p>The policy documentation is not valid.</p>', 'refs' => [], ], 'Marker' => [ 'base' => NULL, 'refs' => [ 'ListCACertificatesRequest$marker' => '<p>The marker for the next set of results.</p>', 'ListCACertificatesResponse$nextMarker' => '<p>The current position within the list of CA certificates.</p>', 'ListCertificatesByCARequest$marker' => '<p>The marker for the next set of results.</p>', 'ListCertificatesByCAResponse$nextMarker' => '<p>The marker for the next set of results, or null if there are no additional results.</p>', 'ListCertificatesRequest$marker' => '<p>The marker for the next set of results.</p>', 'ListCertificatesResponse$nextMarker' => '<p>The marker for the next set of results, or null if there are no additional results.</p>', 'ListOutgoingCertificatesRequest$marker' => '<p>The marker for the next set of results.</p>', 'ListOutgoingCertificatesResponse$nextMarker' => '<p>The marker for the next set of results.</p>', 'ListPoliciesRequest$marker' => '<p>The marker for the next set of results.</p>', 'ListPoliciesResponse$nextMarker' => '<p>The marker for the next set of results, or null if there are no additional results.</p>', 'ListPolicyPrincipalsRequest$marker' => '<p>The marker for the next set of results.</p>', 'ListPolicyPrincipalsResponse$nextMarker' => '<p>The marker for the next set of results, or null if there are no additional results.</p>', 'ListPrincipalPoliciesRequest$marker' => '<p>The marker for the next set of results.</p>', 'ListPrincipalPoliciesResponse$nextMarker' => '<p>The marker for the next set of results, or null if there are no additional results.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTopicRulesRequest$maxResults' => '<p>The maximum number of results to return.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'OutgoingCertificate$transferMessage' => '<p>The transfer message.</p>', 'RejectCertificateTransferRequest$rejectReason' => '<p>The reason the certificate transfer was rejected.</p>', 'TransferCertificateRequest$transferMessage' => '<p>The transfer message.</p>', 'TransferData$transferMessage' => '<p>The transfer message.</p>', 'TransferData$rejectReason' => '<p>The reason why the transfer was rejected.</p>', ], ], 'MessageFormat' => [ 'base' => NULL, 'refs' => [ 'SnsAction$messageFormat' => '<p>The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The default value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and relevant platform-specific bits of the payload should be extracted. To read more about SNS message formats, see <a href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html">http://docs.aws.amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'CloudwatchMetricAction$metricName' => '<p>The CloudWatch metric name.</p>', ], ], 'MetricNamespace' => [ 'base' => NULL, 'refs' => [ 'CloudwatchMetricAction$metricNamespace' => '<p>The CloudWatch metric namespace name.</p>', ], ], 'MetricTimestamp' => [ 'base' => NULL, 'refs' => [ 'CloudwatchMetricAction$metricTimestamp' => '<p>An optional <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp">Unix timestamp</a>.</p>', ], ], 'MetricUnit' => [ 'base' => NULL, 'refs' => [ 'CloudwatchMetricAction$metricUnit' => '<p>The <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit">metric unit</a> supported by CloudWatch.</p>', ], ], 'MetricValue' => [ 'base' => NULL, 'refs' => [ 'CloudwatchMetricAction$metricValue' => '<p>The CloudWatch metric value.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListPrincipalThingsRequest$nextToken' => '<p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListPrincipalThingsResponse$nextToken' => '<p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListThingTypesRequest$nextToken' => '<p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListThingTypesResponse$nextToken' => '<p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListThingsRequest$nextToken' => '<p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListThingsResponse$nextToken' => '<p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListTopicRulesRequest$nextToken' => '<p>A token used to retrieve the next value.</p>', 'ListTopicRulesResponse$nextToken' => '<p>A token used to retrieve the next value.</p>', ], ], 'OptionalVersion' => [ 'base' => NULL, 'refs' => [ 'DeleteThingRequest$expectedVersion' => '<p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>DeleteThing</code> request is rejected with a <code>VersionConflictException</code>.</p>', 'UpdateThingRequest$expectedVersion' => '<p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>UpdateThing</code> request is rejected with a <code>VersionConflictException</code>.</p>', ], ], 'OutgoingCertificate' => [ 'base' => '<p>A certificate that has been transfered but not yet accepted.</p>', 'refs' => [ 'OutgoingCertificates$member' => NULL, ], ], 'OutgoingCertificates' => [ 'base' => NULL, 'refs' => [ 'ListOutgoingCertificatesResponse$outgoingCertificates' => '<p>The certificates that are being transfered but not yet accepted.</p>', ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'ListCACertificatesRequest$pageSize' => '<p>The result page size.</p>', 'ListCertificatesByCARequest$pageSize' => '<p>The result page size.</p>', 'ListCertificatesRequest$pageSize' => '<p>The result page size.</p>', 'ListOutgoingCertificatesRequest$pageSize' => '<p>The result page size.</p>', 'ListPoliciesRequest$pageSize' => '<p>The result page size.</p>', 'ListPolicyPrincipalsRequest$pageSize' => '<p>The result page size.</p>', 'ListPrincipalPoliciesRequest$pageSize' => '<p>The result page size.</p>', ], ], 'PartitionKey' => [ 'base' => NULL, 'refs' => [ 'KinesisAction$partitionKey' => '<p>The partition key.</p>', ], ], 'PayloadField' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$payloadField' => '<p>The action payload. This name can be customized.</p>', ], ], 'Policies' => [ 'base' => NULL, 'refs' => [ 'ListPoliciesResponse$policies' => '<p>The descriptions of the policies.</p>', 'ListPrincipalPoliciesResponse$policies' => '<p>The policies.</p>', ], ], 'Policy' => [ 'base' => '<p>Describes an AWS IoT policy.</p>', 'refs' => [ 'Policies$member' => NULL, ], ], 'PolicyArn' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyResponse$policyArn' => '<p>The policy ARN.</p>', 'CreatePolicyVersionResponse$policyArn' => '<p>The policy ARN.</p>', 'GetPolicyResponse$policyArn' => '<p>The policy ARN.</p>', 'GetPolicyVersionResponse$policyArn' => '<p>The policy ARN.</p>', 'Policy$policyArn' => '<p>The policy ARN.</p>', ], ], 'PolicyDocument' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyRequest$policyDocument' => '<p>The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1, with a maximum length of 2048, excluding whitespace.</p>', 'CreatePolicyResponse$policyDocument' => '<p>The JSON document that describes the policy.</p>', 'CreatePolicyVersionRequest$policyDocument' => '<p>The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding whitespaces</p>', 'CreatePolicyVersionResponse$policyDocument' => '<p>The JSON document that describes the policy.</p>', 'GetPolicyResponse$policyDocument' => '<p>The JSON document that describes the policy.</p>', 'GetPolicyVersionResponse$policyDocument' => '<p>The JSON document that describes the policy.</p>', ], ], 'PolicyName' => [ 'base' => NULL, 'refs' => [ 'AttachPrincipalPolicyRequest$policyName' => '<p>The policy name.</p>', 'CreatePolicyRequest$policyName' => '<p>The policy name.</p>', 'CreatePolicyResponse$policyName' => '<p>The policy name.</p>', 'CreatePolicyVersionRequest$policyName' => '<p>The policy name.</p>', 'DeletePolicyRequest$policyName' => '<p>The name of the policy to delete.</p>', 'DeletePolicyVersionRequest$policyName' => '<p>The name of the policy.</p>', 'DetachPrincipalPolicyRequest$policyName' => '<p>The name of the policy to detach.</p>', 'GetPolicyRequest$policyName' => '<p>The name of the policy.</p>', 'GetPolicyResponse$policyName' => '<p>The policy name.</p>', 'GetPolicyVersionRequest$policyName' => '<p>The name of the policy.</p>', 'GetPolicyVersionResponse$policyName' => '<p>The policy name.</p>', 'ListPolicyPrincipalsRequest$policyName' => '<p>The policy name.</p>', 'ListPolicyVersionsRequest$policyName' => '<p>The policy name.</p>', 'Policy$policyName' => '<p>The policy name.</p>', 'SetDefaultPolicyVersionRequest$policyName' => '<p>The policy name.</p>', ], ], 'PolicyVersion' => [ 'base' => '<p>Describes a policy version.</p>', 'refs' => [ 'PolicyVersions$member' => NULL, ], ], 'PolicyVersionId' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyResponse$policyVersionId' => '<p>The policy version ID.</p>', 'CreatePolicyVersionResponse$policyVersionId' => '<p>The policy version ID.</p>', 'DeletePolicyVersionRequest$policyVersionId' => '<p>The policy version ID.</p>', 'GetPolicyResponse$defaultVersionId' => '<p>The default policy version ID.</p>', 'GetPolicyVersionRequest$policyVersionId' => '<p>The policy version ID.</p>', 'GetPolicyVersionResponse$policyVersionId' => '<p>The policy version ID.</p>', 'PolicyVersion$versionId' => '<p>The policy version ID.</p>', 'SetDefaultPolicyVersionRequest$policyVersionId' => '<p>The policy version ID.</p>', ], ], 'PolicyVersions' => [ 'base' => NULL, 'refs' => [ 'ListPolicyVersionsResponse$policyVersions' => '<p>The policy versions.</p>', ], ], 'Principal' => [ 'base' => NULL, 'refs' => [ 'AttachPrincipalPolicyRequest$principal' => '<p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>', 'AttachThingPrincipalRequest$principal' => '<p>The principal, such as a certificate or other credential.</p>', 'DetachPrincipalPolicyRequest$principal' => '<p>The principal.</p> <p>If the principal is a certificate, specify the certificate ARN. If the principal is an Amazon Cognito identity, specify the identity ID.</p>', 'DetachThingPrincipalRequest$principal' => '<p>If the principal is a certificate, this value must be ARN of the certificate. If the principal is an Amazon Cognito identity, this value must be the ID of the Amazon Cognito identity.</p>', 'ListPrincipalPoliciesRequest$principal' => '<p>The principal.</p>', 'ListPrincipalThingsRequest$principal' => '<p>The principal.</p>', ], ], 'PrincipalArn' => [ 'base' => NULL, 'refs' => [ 'Principals$member' => NULL, ], ], 'Principals' => [ 'base' => NULL, 'refs' => [ 'ListPolicyPrincipalsResponse$principals' => '<p>The descriptions of the principals.</p>', 'ListThingPrincipalsResponse$principals' => '<p>The principals associated with the thing.</p>', ], ], 'PrivateKey' => [ 'base' => NULL, 'refs' => [ 'KeyPair$PrivateKey' => '<p>The private key.</p>', ], ], 'PublicKey' => [ 'base' => NULL, 'refs' => [ 'KeyPair$PublicKey' => '<p>The public key.</p>', ], ], 'PutItemInput' => [ 'base' => '<p>The input for the DynamoActionVS action that specifies the DynamoDB table to which the message data will be written.</p>', 'refs' => [ 'DynamoDBv2Action$putItem' => '<p>Specifies the DynamoDB table to which the message data will be written. For example:</p> <p> <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code> </p> <p>Each attribute in the message payload will be written to a separate column in the DynamoDB database.</p>', ], ], 'QueueUrl' => [ 'base' => NULL, 'refs' => [ 'SqsAction$queueUrl' => '<p>The URL of the Amazon SQS queue.</p>', ], ], 'RangeKeyField' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$rangeKeyField' => '<p>The range key name.</p>', ], ], 'RangeKeyValue' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$rangeKeyValue' => '<p>The range key value.</p>', ], ], 'RegisterCACertificateRequest' => [ 'base' => '<p>The input to the RegisterCACertificate operation.</p>', 'refs' => [], ], 'RegisterCACertificateResponse' => [ 'base' => '<p>The output from the RegisterCACertificateResponse operation.</p>', 'refs' => [], ], 'RegisterCertificateRequest' => [ 'base' => '<p>The input to the RegisterCertificate operation.</p>', 'refs' => [], ], 'RegisterCertificateResponse' => [ 'base' => '<p>The output from the RegisterCertificate operation.</p>', 'refs' => [], ], 'RegistrationCode' => [ 'base' => NULL, 'refs' => [ 'GetRegistrationCodeResponse$registrationCode' => '<p>The CA certificate registration code.</p>', ], ], 'RegistrationCodeValidationException' => [ 'base' => '<p>The registration code is invalid.</p>', 'refs' => [], ], 'RegistryMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListPrincipalThingsRequest$maxResults' => '<p>The maximum number of results to return in this operation.</p>', 'ListThingTypesRequest$maxResults' => '<p>The maximum number of results to return in this operation.</p>', 'ListThingsRequest$maxResults' => '<p>The maximum number of results to return in this operation.</p>', ], ], 'RejectCertificateTransferRequest' => [ 'base' => '<p>The input for the RejectCertificateTransfer operation.</p>', 'refs' => [], ], 'RemoveThingType' => [ 'base' => NULL, 'refs' => [ 'UpdateThingRequest$removeThingType' => '<p>Remove a thing type association. If <b>true</b>, the assocation is removed.</p>', ], ], 'ReplaceTopicRuleRequest' => [ 'base' => '<p>The input for the ReplaceTopicRule operation.</p>', 'refs' => [], ], 'RepublishAction' => [ 'base' => '<p>Describes an action to republish to another topic.</p>', 'refs' => [ 'Action$republish' => '<p>Publish to another MQTT topic.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The resource already exists.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource does not exist.</p>', 'refs' => [], ], 'RuleArn' => [ 'base' => NULL, 'refs' => [ 'GetTopicRuleResponse$ruleArn' => '<p>The rule ARN.</p>', 'TopicRuleListItem$ruleArn' => '<p>The rule ARN.</p>', ], ], 'RuleName' => [ 'base' => NULL, 'refs' => [ 'CreateTopicRuleRequest$ruleName' => '<p>The name of the rule.</p>', 'DeleteTopicRuleRequest$ruleName' => '<p>The name of the rule.</p>', 'DisableTopicRuleRequest$ruleName' => '<p>The name of the rule to disable.</p>', 'EnableTopicRuleRequest$ruleName' => '<p>The name of the topic rule to enable.</p>', 'GetTopicRuleRequest$ruleName' => '<p>The name of the rule.</p>', 'ReplaceTopicRuleRequest$ruleName' => '<p>The name of the rule.</p>', 'TopicRule$ruleName' => '<p>The name of the rule.</p>', 'TopicRuleListItem$ruleName' => '<p>The name of the rule.</p>', ], ], 'S3Action' => [ 'base' => '<p>Describes an action to write data to an Amazon S3 bucket.</p>', 'refs' => [ 'Action$s3' => '<p>Write to an Amazon S3 bucket.</p>', ], ], 'SQL' => [ 'base' => NULL, 'refs' => [ 'TopicRule$sql' => '<p>The SQL statement used to query the topic. When using a SQL query with multiple lines, be sure to escape the newline characters.</p>', 'TopicRulePayload$sql' => '<p>The SQL statement used to query the topic. For more information, see <a href="http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference">AWS IoT SQL Reference</a> in the <i>AWS IoT Developer Guide</i>.</p>', ], ], 'SalesforceAction' => [ 'base' => '<p>Describes an action to write a message to a Salesforce IoT Cloud Input Stream.</p>', 'refs' => [ 'Action$salesforce' => '<p>Send a message to a Salesforce IoT Cloud Input Stream.</p>', ], ], 'SalesforceEndpoint' => [ 'base' => NULL, 'refs' => [ 'SalesforceAction$url' => '<p>The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from the Salesforce IoT Cloud platform after creation of the Input Stream.</p>', ], ], 'SalesforceToken' => [ 'base' => NULL, 'refs' => [ 'SalesforceAction$token' => '<p>The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The token is available from the Salesforce IoT Cloud platform after creation of the Input Stream.</p>', ], ], 'SearchableAttributes' => [ 'base' => NULL, 'refs' => [ 'ThingTypeProperties$searchableAttributes' => '<p>A list of searchable thing attribute names.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is temporarily unavailable.</p>', 'refs' => [], ], 'SetAsActive' => [ 'base' => NULL, 'refs' => [ 'AcceptCertificateTransferRequest$setAsActive' => '<p>Specifies whether the certificate is active.</p>', 'CreateCertificateFromCsrRequest$setAsActive' => '<p>Specifies whether the certificate is active.</p>', 'CreateKeysAndCertificateRequest$setAsActive' => '<p>Specifies whether the certificate is active.</p>', 'RegisterCACertificateRequest$setAsActive' => '<p>A boolean value that specifies if the CA certificate is set to active.</p>', ], ], 'SetAsActiveFlag' => [ 'base' => NULL, 'refs' => [ 'RegisterCertificateRequest$setAsActive' => '<p>A boolean value that specifies if the CA certificate is set to active.</p>', ], ], 'SetAsDefault' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyVersionRequest$setAsDefault' => '<p>Specifies whether the policy version is set as the default. When this parameter is true, the new policy version becomes the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>', ], ], 'SetDefaultPolicyVersionRequest' => [ 'base' => '<p>The input for the SetDefaultPolicyVersion operation.</p>', 'refs' => [], ], 'SetLoggingOptionsRequest' => [ 'base' => '<p>The input for the SetLoggingOptions operation.</p>', 'refs' => [], ], 'SnsAction' => [ 'base' => '<p>Describes an action to publish to an Amazon SNS topic.</p>', 'refs' => [ 'Action$sns' => '<p>Publish to an Amazon SNS topic.</p>', ], ], 'SqlParseException' => [ 'base' => '<p>The Rule-SQL expression can\'t be parsed correctly.</p>', 'refs' => [], ], 'SqsAction' => [ 'base' => '<p>Describes an action to publish data to an Amazon SQS queue.</p>', 'refs' => [ 'Action$sqs' => '<p>Publish to an Amazon SQS queue.</p>', ], ], 'StateReason' => [ 'base' => NULL, 'refs' => [ 'CloudwatchAlarmAction$stateReason' => '<p>The reason for the alarm change.</p>', ], ], 'StateValue' => [ 'base' => NULL, 'refs' => [ 'CloudwatchAlarmAction$stateValue' => '<p>The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.</p>', ], ], 'StreamName' => [ 'base' => NULL, 'refs' => [ 'KinesisAction$streamName' => '<p>The name of the Amazon Kinesis stream.</p>', ], ], 'TableName' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$tableName' => '<p>The name of the DynamoDB table.</p>', 'PutItemInput$tableName' => '<p>The table where the message data will be written</p>', ], ], 'ThingArn' => [ 'base' => NULL, 'refs' => [ 'CreateThingResponse$thingArn' => '<p>The ARN of the new thing.</p>', ], ], 'ThingAttribute' => [ 'base' => '<p>The properties of the thing, including thing name, thing type name, and a list of thing attributes.</p>', 'refs' => [ 'ThingAttributeList$member' => NULL, ], ], 'ThingAttributeList' => [ 'base' => NULL, 'refs' => [ 'ListThingsResponse$things' => '<p>The things.</p>', ], ], 'ThingName' => [ 'base' => NULL, 'refs' => [ 'AttachThingPrincipalRequest$thingName' => '<p>The name of the thing.</p>', 'CreateThingRequest$thingName' => '<p>The name of the thing to create.</p>', 'CreateThingResponse$thingName' => '<p>The name of the new thing.</p>', 'DeleteThingRequest$thingName' => '<p>The name of the thing to delete.</p>', 'DescribeThingRequest$thingName' => '<p>The name of the thing.</p>', 'DescribeThingResponse$thingName' => '<p>The name of the thing.</p>', 'DetachThingPrincipalRequest$thingName' => '<p>The name of the thing.</p>', 'ListThingPrincipalsRequest$thingName' => '<p>The name of the thing.</p>', 'ThingAttribute$thingName' => '<p>The name of the thing.</p>', 'ThingNameList$member' => NULL, 'UpdateThingRequest$thingName' => '<p>The name of the thing to update.</p>', ], ], 'ThingNameList' => [ 'base' => NULL, 'refs' => [ 'ListPrincipalThingsResponse$things' => '<p>The things.</p>', ], ], 'ThingTypeArn' => [ 'base' => NULL, 'refs' => [ 'CreateThingTypeResponse$thingTypeArn' => '<p>The Amazon Resource Name (ARN) of the thing type.</p>', ], ], 'ThingTypeDefinition' => [ 'base' => '<p>The definition of the thing type, including thing type name and description.</p>', 'refs' => [ 'ThingTypeList$member' => NULL, ], ], 'ThingTypeDescription' => [ 'base' => NULL, 'refs' => [ 'ThingTypeProperties$thingTypeDescription' => '<p>The description of the thing type.</p>', ], ], 'ThingTypeList' => [ 'base' => NULL, 'refs' => [ 'ListThingTypesResponse$thingTypes' => '<p>The thing types.</p>', ], ], 'ThingTypeMetadata' => [ 'base' => '<p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when time was deprecated.</p>', 'refs' => [ 'DescribeThingTypeResponse$thingTypeMetadata' => '<p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.</p>', 'ThingTypeDefinition$thingTypeMetadata' => '<p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.</p>', ], ], 'ThingTypeName' => [ 'base' => NULL, 'refs' => [ 'CreateThingRequest$thingTypeName' => '<p>The name of the thing type associated with the new thing.</p>', 'CreateThingTypeRequest$thingTypeName' => '<p>The name of the thing type.</p>', 'CreateThingTypeResponse$thingTypeName' => '<p>The name of the thing type.</p>', 'DeleteThingTypeRequest$thingTypeName' => '<p>The name of the thing type.</p>', 'DeprecateThingTypeRequest$thingTypeName' => '<p>The name of the thing type to deprecate.</p>', 'DescribeThingResponse$thingTypeName' => '<p>The thing type name.</p>', 'DescribeThingTypeRequest$thingTypeName' => '<p>The name of the thing type.</p>', 'DescribeThingTypeResponse$thingTypeName' => '<p>The name of the thing type.</p>', 'ListThingTypesRequest$thingTypeName' => '<p>The name of the thing type.</p>', 'ListThingsRequest$thingTypeName' => '<p>The name of the thing type used to search for things.</p>', 'ThingAttribute$thingTypeName' => '<p>The name of the thing type, if the thing has been associated with a type.</p>', 'ThingTypeDefinition$thingTypeName' => '<p>The name of the thing type.</p>', 'UpdateThingRequest$thingTypeName' => '<p>The name of the thing type.</p>', ], ], 'ThingTypeProperties' => [ 'base' => '<p>The ThingTypeProperties contains information about the thing type including: a thing type description, and a list of searchable thing attribute names.</p>', 'refs' => [ 'CreateThingTypeRequest$thingTypeProperties' => '<p>The ThingTypeProperties for the thing type to create. It contains information about the new thing type including a description, and a list of searchable thing attribute names.</p>', 'DescribeThingTypeResponse$thingTypeProperties' => '<p>The ThingTypeProperties contains information about the thing type including description, and a list of searchable thing attribute names.</p>', 'ThingTypeDefinition$thingTypeProperties' => '<p>The ThingTypeProperties for the thing type.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The rate exceeds the limit.</p>', 'refs' => [], ], 'Topic' => [ 'base' => NULL, 'refs' => [ 'ListTopicRulesRequest$topic' => '<p>The topic.</p>', ], ], 'TopicPattern' => [ 'base' => NULL, 'refs' => [ 'RepublishAction$topic' => '<p>The name of the MQTT topic.</p>', 'TopicRuleListItem$topicPattern' => '<p>The pattern for the topic names that apply.</p>', ], ], 'TopicRule' => [ 'base' => '<p>Describes a rule.</p>', 'refs' => [ 'GetTopicRuleResponse$rule' => '<p>The rule.</p>', ], ], 'TopicRuleList' => [ 'base' => NULL, 'refs' => [ 'ListTopicRulesResponse$rules' => '<p>The rules.</p>', ], ], 'TopicRuleListItem' => [ 'base' => '<p>Describes a rule.</p>', 'refs' => [ 'TopicRuleList$member' => NULL, ], ], 'TopicRulePayload' => [ 'base' => '<p>Describes a rule.</p>', 'refs' => [ 'CreateTopicRuleRequest$topicRulePayload' => '<p>The rule payload.</p>', 'ReplaceTopicRuleRequest$topicRulePayload' => '<p>The rule payload.</p>', ], ], 'TransferAlreadyCompletedException' => [ 'base' => '<p>You can\'t revert the certificate transfer because the transfer is already complete.</p>', 'refs' => [], ], 'TransferCertificateRequest' => [ 'base' => '<p>The input for the TransferCertificate operation.</p>', 'refs' => [], ], 'TransferCertificateResponse' => [ 'base' => '<p>The output from the TransferCertificate operation.</p>', 'refs' => [], ], 'TransferConflictException' => [ 'base' => '<p>You can\'t transfer the certificate because authorization policies are still attached.</p>', 'refs' => [], ], 'TransferData' => [ 'base' => '<p>Data used to transfer a certificate to an AWS account.</p>', 'refs' => [ 'CertificateDescription$transferData' => '<p>The transfer data.</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>You are not authorized to perform this operation.</p>', 'refs' => [], ], 'UndoDeprecate' => [ 'base' => NULL, 'refs' => [ 'DeprecateThingTypeRequest$undoDeprecate' => '<p>Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore and you can associate it with things.</p>', ], ], 'UpdateCACertificateRequest' => [ 'base' => '<p>The input to the UpdateCACertificate operation.</p>', 'refs' => [], ], 'UpdateCertificateRequest' => [ 'base' => '<p>The input for the UpdateCertificate operation.</p>', 'refs' => [], ], 'UpdateThingRequest' => [ 'base' => '<p>The input for the UpdateThing operation.</p>', 'refs' => [], ], 'UpdateThingResponse' => [ 'base' => '<p>The output from the UpdateThing operation.</p>', 'refs' => [], ], 'UseBase64' => [ 'base' => NULL, 'refs' => [ 'SqsAction$useBase64' => '<p>Specifies whether to use Base64 encoding.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'DescribeThingResponse$version' => '<p>The current version of the thing record in the registry.</p> <note> <p>To avoid unintentional changes to the information in the registry, you can pass the version information in the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and <code>DeleteThing</code> calls.</p> </note>', 'ThingAttribute$version' => '<p>The version of the thing record in the registry.</p>', ], ], 'VersionConflictException' => [ 'base' => '<p>An exception thrown when the version of a thing passed to a command is different than the version specified with the --version parameter.</p>', 'refs' => [], ], 'VersionsLimitExceededException' => [ 'base' => '<p>The number of policy versions exceeds the limit.</p>', 'refs' => [], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'CertificateConflictException$message' => '<p>The message for the exception.</p>', 'CertificateStateException$message' => '<p>The message for the exception.</p>', 'CertificateValidationException$message' => '<p>Additional information about the exception.</p>', 'DeleteConflictException$message' => '<p>The message for the exception.</p>', 'InternalException$message' => '<p>The message for the exception.</p>', 'InternalFailureException$message' => '<p>The message for the exception.</p>', 'InvalidRequestException$message' => '<p>The message for the exception.</p>', 'LimitExceededException$message' => '<p>The message for the exception.</p>', 'MalformedPolicyException$message' => '<p>The message for the exception.</p>', 'RegistrationCodeValidationException$message' => '<p>Additional information about the exception.</p>', 'ResourceAlreadyExistsException$message' => '<p>The message for the exception.</p>', 'ResourceNotFoundException$message' => '<p>The message for the exception.</p>', 'ServiceUnavailableException$message' => '<p>The message for the exception.</p>', 'SqlParseException$message' => '<p>The message for the exception.</p>', 'ThrottlingException$message' => '<p>The message for the exception.</p>', 'TransferAlreadyCompletedException$message' => '<p>The message for the exception.</p>', 'TransferConflictException$message' => '<p>The message for the exception.</p>', 'UnauthorizedException$message' => '<p>The message for the exception.</p>', 'VersionConflictException$message' => '<p>The message for the exception.</p>', 'VersionsLimitExceededException$message' => '<p>The message for the exception.</p>', ], ], 'resourceArn' => [ 'base' => NULL, 'refs' => [ 'ResourceAlreadyExistsException$resourceArn' => '<p>The ARN of the resource that caused the exception.</p>', ], ], 'resourceId' => [ 'base' => NULL, 'refs' => [ 'ResourceAlreadyExistsException$resourceId' => '<p>The ID of the resource that caused the exception.</p>', ], ], ],];
