<?php
// This file was auto-generated from sdk-root/src/data/kms/2014-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Key Management Service</fullname> <p>AWS Key Management Service (AWS KMS) is an encryption and key management web service. This guide describes the AWS KMS operations that you can call programmatically. For general information about AWS KMS, see the <a href="http://docs.aws.amazon.com/kms/latest/developerguide/">AWS Key Management Service Developer Guide</a>.</p> <note> <p>AWS provides SDKs that consist of libraries and sample code for various programming languages and platforms (Java, Ruby, .Net, iOS, Android, etc.). The SDKs provide a convenient way to create programmatic access to AWS KMS and other AWS services. For example, the SDKs take care of tasks such as signing requests (see below), managing errors, and retrying requests automatically. For more information about the AWS SDKs, including how to download and install them, see <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>.</p> </note> <p>We recommend that you use the AWS SDKs to make programmatic API calls to AWS KMS.</p> <p>Clients must support TLS (Transport Layer Security) 1.0. We recommend TLS 1.2. Clients must also support cipher suites with Perfect Forward Secrecy (PFS) such as Ephemeral Diffie-Hellman (DHE) or Elliptic Curve Ephemeral Diffie-Hellman (ECDHE). Most modern systems such as Java 7 and later support these modes.</p> <p> <b>Signing Requests</b> </p> <p>Requests must be signed by using an access key ID and a secret access key. We strongly recommend that you <i>do not</i> use your AWS account (root) access key ID and secret key for everyday work with AWS KMS. Instead, use the access key ID and secret access key for an IAM user, or you can use the AWS Security Token Service to generate temporary security credentials that you can use to sign requests.</p> <p>All AWS KMS operations require <a href="http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p> <p> <b>Logging API Requests</b> </p> <p>AWS KMS supports AWS CloudTrail, a service that logs AWS API calls and related events for your AWS account and delivers them to an Amazon S3 bucket that you specify. By using the information collected by CloudTrail, you can determine what requests were made to AWS KMS, who made the request, when it was made, and so on. To learn more about CloudTrail, including how to turn it on and find your log files, see the <a href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/">AWS CloudTrail User Guide</a>.</p> <p> <b>Additional Resources</b> </p> <p>For more information about credentials and request signing, see the following:</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html">AWS Security Credentials</a> - This topic provides general information about the types of credentials used for accessing AWS.</p> </li> <li> <p> <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp.html">Temporary Security Credentials</a> - This section of the <i>IAM User Guide</i> describes how to create and use temporary security credentials.</p> </li> <li> <p> <a href="http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a> - This set of topics walks you through the process of signing a request using an access key ID and a secret access key.</p> </li> </ul> <p> <b>Commonly Used APIs</b> </p> <p>Of the APIs discussed in this guide, the following will prove the most useful for most applications. You will likely perform actions other than these, such as creating keys and assigning policies, by using the console.</p> <ul> <li> <p> <a>Encrypt</a> </p> </li> <li> <p> <a>Decrypt</a> </p> </li> <li> <p> <a>GenerateDataKey</a> </p> </li> <li> <p> <a>GenerateDataKeyWithoutPlaintext</a> </p> </li> </ul>', 'operations' => [ 'CancelKeyDeletion' => '<p>Cancels the deletion of a customer master key (CMK). When this operation is successful, the CMK is set to the <code>Disabled</code> state. To enable a CMK, use <a>EnableKey</a>.</p> <p>For more information about scheduling and canceling deletion of a CMK, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html">Deleting Customer Master Keys</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'CreateAlias' => '<p>Creates a display name for a customer master key. An alias can be used to identify a key and should be unique. The console enforces a one-to-one mapping between the alias and a key. An alias name can contain only alphanumeric characters, forward slashes (/), underscores (_), and dashes (-). An alias must start with the word "alias" followed by a forward slash (alias/). An alias that begins with "aws" after the forward slash (alias/aws...) is reserved by Amazon Web Services (AWS).</p> <p>The alias and the key it is mapped to must be in the same AWS account and the same region.</p> <p>To map an alias to a different key, call <a>UpdateAlias</a>.</p>', 'CreateGrant' => '<p>Adds a grant to a key to specify who can use the key and under what conditions. Grants are alternate permission mechanisms to key policies.</p> <p>For more information about grants, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/grants.html">Grants</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'CreateKey' => '<p>Creates a customer master key (CMK).</p> <p>You can use a CMK to encrypt small amounts of data (4 KiB or less) directly, but CMKs are more commonly used to encrypt data encryption keys (DEKs), which are used to encrypt raw data. For more information about DEKs and the difference between CMKs and DEKs, see the following:</p> <ul> <li> <p>The <a>GenerateDataKey</a> operation</p> </li> <li> <p> <a href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">AWS Key Management Service Concepts</a> in the <i>AWS Key Management Service Developer Guide</i> </p> </li> </ul>', 'Decrypt' => '<p>Decrypts ciphertext. Ciphertext is plaintext that has been previously encrypted by using any of the following functions:</p> <ul> <li> <p> <a>GenerateDataKey</a> </p> </li> <li> <p> <a>GenerateDataKeyWithoutPlaintext</a> </p> </li> <li> <p> <a>Encrypt</a> </p> </li> </ul> <p>Note that if a caller has been granted access permissions to all keys (through, for example, IAM user policies that grant <code>Decrypt</code> permission on all resources), then ciphertext encrypted by using keys in other accounts where the key grants access to the caller can be decrypted. To remedy this, we recommend that you do not grant <code>Decrypt</code> access in an IAM user policy. Instead grant <code>Decrypt</code> access only in key policies. If you must grant <code>Decrypt</code> access in an IAM user policy, you should scope the resource to specific keys or to specific trusted accounts.</p>', 'DeleteAlias' => '<p>Deletes the specified alias. To map an alias to a different key, call <a>UpdateAlias</a>.</p>', 'DeleteImportedKeyMaterial' => '<p>Deletes key material that you previously imported and makes the specified customer master key (CMK) unusable. For more information about importing key material into AWS KMS, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.</p> <p>When the specified CMK is in the <code>PendingDeletion</code> state, this operation does not change the CMK\'s state. Otherwise, it changes the CMK\'s state to <code>PendingImport</code>.</p> <p>After you delete key material, you can use <a>ImportKeyMaterial</a> to reimport the same key material into the CMK.</p>', 'DescribeKey' => '<p>Provides detailed information about the specified customer master key.</p>', 'DisableKey' => '<p>Sets the state of a customer master key (CMK) to disabled, thereby preventing its use for cryptographic operations. For more information about how key state affects the use of a CMK, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects the Use of a Customer Master Key</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'DisableKeyRotation' => '<p>Disables rotation of the specified key.</p>', 'EnableKey' => '<p>Marks a key as enabled, thereby permitting its use.</p>', 'EnableKeyRotation' => '<p>Enables rotation of the specified customer master key.</p>', 'Encrypt' => '<p>Encrypts plaintext into ciphertext by using a customer master key. The <code>Encrypt</code> function has two primary use cases:</p> <ul> <li> <p>You can encrypt up to 4 KB of arbitrary data such as an RSA key, a database password, or other sensitive customer information.</p> </li> <li> <p>If you are moving encrypted data from one region to another, you can use this API to encrypt in the new region the plaintext data key that was used to encrypt the data in the original region. This provides you with an encrypted copy of the data key that can be decrypted in the new region and used there to decrypt the encrypted data.</p> </li> </ul> <p>Unless you are moving encrypted data from one region to another, you don\'t use this function to encrypt a generated data key within a region. You retrieve data keys already encrypted by calling the <a>GenerateDataKey</a> or <a>GenerateDataKeyWithoutPlaintext</a> function. Data keys don\'t need to be encrypted again by calling <code>Encrypt</code>.</p> <p>If you want to encrypt data locally in your application, you can use the <code>GenerateDataKey</code> function to return a plaintext data encryption key and a copy of the key encrypted under the customer master key (CMK) of your choosing.</p>', 'GenerateDataKey' => '<p>Returns a data encryption key that you can use in your application to encrypt data locally.</p> <p>You must specify the customer master key (CMK) under which to generate the data key. You must also specify the length of the data key using either the <code>KeySpec</code> or <code>NumberOfBytes</code> field. You must specify one field or the other, but not both. For common key lengths (128-bit and 256-bit symmetric keys), we recommend that you use <code>KeySpec</code>.</p> <p>This operation returns a plaintext copy of the data key in the <code>Plaintext</code> field of the response, and an encrypted copy of the data key in the <code>CiphertextBlob</code> field. The data key is encrypted under the CMK specified in the <code>KeyId</code> field of the request.</p> <p>We recommend that you use the following pattern to encrypt data locally in your application:</p> <ol> <li> <p>Use this operation (<code>GenerateDataKey</code>) to retrieve a data encryption key.</p> </li> <li> <p>Use the plaintext data encryption key (returned in the <code>Plaintext</code> field of the response) to encrypt data locally, then erase the plaintext data key from memory.</p> </li> <li> <p>Store the encrypted data key (returned in the <code>CiphertextBlob</code> field of the response) alongside the locally encrypted data.</p> </li> </ol> <p>To decrypt data locally:</p> <ol> <li> <p>Use the <a>Decrypt</a> operation to decrypt the encrypted data key into a plaintext copy of the data key.</p> </li> <li> <p>Use the plaintext data key to decrypt data locally, then erase the plaintext data key from memory.</p> </li> </ol> <p>To return only an encrypted copy of the data key, use <a>GenerateDataKeyWithoutPlaintext</a>. To return a random byte string that is cryptographically secure, use <a>GenerateRandom</a>.</p> <p>If you use the optional <code>EncryptionContext</code> field, you must store at least enough information to be able to reconstruct the full encryption context when you later send the ciphertext to the <a>Decrypt</a> operation. It is a good practice to choose an encryption context that you can reconstruct on the fly to better secure the ciphertext. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption Context</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'GenerateDataKeyWithoutPlaintext' => '<p>Returns a data encryption key encrypted under a customer master key (CMK). This operation is identical to <a>GenerateDataKey</a> but returns only the encrypted copy of the data key.</p> <p>This operation is useful in a system that has multiple components with different degrees of trust. For example, consider a system that stores encrypted data in containers. Each container stores the encrypted data and an encrypted copy of the data key. One component of the system, called the <i>control plane</i>, creates new containers. When it creates a new container, it uses this operation (<code>GenerateDataKeyWithoutPlaintext</code>) to get an encrypted data key and then stores it in the container. Later, a different component of the system, called the <i>data plane</i>, puts encrypted data into the containers. To do this, it passes the encrypted data key to the <a>Decrypt</a> operation, then uses the returned plaintext data key to encrypt data, and finally stores the encrypted data in the container. In this system, the control plane never sees the plaintext data key.</p>', 'GenerateRandom' => '<p>Returns a random byte string that is cryptographically secure.</p> <p>For more information about entropy and random number generation, see the <a href="https://d0.awsstatic.com/whitepapers/KMS-Cryptographic-Details.pdf">AWS Key Management Service Cryptographic Details</a> whitepaper.</p>', 'GetKeyPolicy' => '<p>Retrieves a policy attached to the specified key.</p>', 'GetKeyRotationStatus' => '<p>Retrieves a Boolean value that indicates whether key rotation is enabled for the specified key.</p>', 'GetParametersForImport' => '<p>Returns the items you need in order to import key material into AWS KMS from your existing key management infrastructure. For more information about importing key material into AWS KMS, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.</p> <p>You must specify the key ID of the customer master key (CMK) into which you will import key material. This CMK\'s <code>Origin</code> must be <code>EXTERNAL</code>. You must also specify the wrapping algorithm and type of wrapping key (public key) that you will use to encrypt the key material.</p> <p>This operation returns a public key and an import token. Use the public key to encrypt the key material. Store the import token to send with a subsequent <a>ImportKeyMaterial</a> request. The public key and import token from the same response must be used together. These items are valid for 24 hours, after which they cannot be used for a subsequent <a>ImportKeyMaterial</a> request. To retrieve new ones, send another <code>GetParametersForImport</code> request.</p>', 'ImportKeyMaterial' => '<p>Imports key material into an AWS KMS customer master key (CMK) from your existing key management infrastructure. For more information about importing key material into AWS KMS, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.</p> <p>You must specify the key ID of the CMK to import the key material into. This CMK\'s <code>Origin</code> must be <code>EXTERNAL</code>. You must also send an import token and the encrypted key material. Send the import token that you received in the same <a>GetParametersForImport</a> response that contained the public key that you used to encrypt the key material. You must also specify whether the key material expires and if so, when. When the key material expires, AWS KMS deletes the key material and the CMK becomes unusable. To use the CMK again, you can reimport the same key material. If you set an expiration date, you can change it only by reimporting the same key material and specifying a new expiration date.</p> <p>When this operation is successful, the specified CMK\'s key state changes to <code>Enabled</code>, and you can use the CMK.</p> <p>After you successfully import key material into a CMK, you can reimport the same key material into that CMK, but you cannot import different key material.</p>', 'ListAliases' => '<p>Lists all of the key aliases in the account.</p>', 'ListGrants' => '<p>List the grants for a specified key.</p>', 'ListKeyPolicies' => '<p>Retrieves a list of policies attached to a key.</p>', 'ListKeys' => '<p>Lists the customer master keys.</p>', 'ListResourceTags' => '<p>Returns a list of all tags for the specified customer master key (CMK).</p>', 'ListRetirableGrants' => '<p>Returns a list of all grants for which the grant\'s <code>RetiringPrincipal</code> matches the one specified.</p> <p>A typical use is to list all grants that you are able to retire. To retire a grant, use <a>RetireGrant</a>.</p>', 'PutKeyPolicy' => '<p>Attaches a key policy to the specified customer master key (CMK).</p> <p>For more information about key policies, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Key Policies</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'ReEncrypt' => '<p>Encrypts data on the server side with a new customer master key (CMK) without exposing the plaintext of the data on the client side. The data is first decrypted and then reencrypted. You can also use this operation to change the encryption context of a ciphertext.</p> <p>Unlike other operations, <code>ReEncrypt</code> is authorized twice, once as <code>ReEncryptFrom</code> on the source CMK and once as <code>ReEncryptTo</code> on the destination CMK. We recommend that you include the <code>"kms:ReEncrypt*"</code> permission in your <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">key policies</a> to permit reencryption from or to the CMK. This permission is automatically included in the key policy when you create a CMK through the console, but you must include it manually when you create a CMK programmatically or when you set a key policy with the <a>PutKeyPolicy</a> operation.</p>', 'RetireGrant' => '<p>Retires a grant. To clean up, you can retire a grant when you\'re done using it. You should revoke a grant when you intend to actively deny operations that depend on it. The following are permitted to call this API:</p> <ul> <li> <p>The AWS account (root user) under which the grant was created</p> </li> <li> <p>The <code>RetiringPrincipal</code>, if present in the grant</p> </li> <li> <p>The <code>GranteePrincipal</code>, if <code>RetireGrant</code> is an operation specified in the grant</p> </li> </ul> <p>You must identify the grant to retire by its grant token or by a combination of the grant ID and the Amazon Resource Name (ARN) of the customer master key (CMK). A grant token is a unique variable-length base64-encoded string. A grant ID is a 64 character unique identifier of a grant. The <a>CreateGrant</a> operation returns both.</p>', 'RevokeGrant' => '<p>Revokes a grant. You can revoke a grant to actively deny operations that depend on it.</p>', 'ScheduleKeyDeletion' => '<p>Schedules the deletion of a customer master key (CMK). You may provide a waiting period, specified in days, before deletion occurs. If you do not provide a waiting period, the default period of 30 days is used. When this operation is successful, the state of the CMK changes to <code>PendingDeletion</code>. Before the waiting period ends, you can use <a>CancelKeyDeletion</a> to cancel the deletion of the CMK. After the waiting period ends, AWS KMS deletes the CMK and all AWS KMS data associated with it, including all aliases that refer to it.</p> <important> <p>Deleting a CMK is a destructive and potentially dangerous operation. When a CMK is deleted, all data that was encrypted under the CMK is rendered unrecoverable. To restrict the use of a CMK without deleting it, use <a>DisableKey</a>.</p> </important> <p>For more information about scheduling a CMK for deletion, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html">Deleting Customer Master Keys</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'TagResource' => '<p>Adds or overwrites one or more tags for the specified customer master key (CMK). </p> <p>Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty (null) strings.</p> <p>You cannot use the same tag key more than once per CMK. For example, consider a CMK with one tag whose tag key is <code>Purpose</code> and tag value is <code>Test</code>. If you send a <code>TagResource</code> request for this CMK with a tag key of <code>Purpose</code> and a tag value of <code>Prod</code>, it does not create a second tag. Instead, the original tag is overwritten with the new tag value.</p>', 'UntagResource' => '<p>Removes the specified tag or tags from the specified customer master key (CMK). </p> <p>To remove a tag, you specify the tag key for each tag to remove. You do not specify the tag value. To overwrite the tag value for an existing tag, use <a>TagResource</a>.</p>', 'UpdateAlias' => '<p>Updates an alias to map it to a different key.</p> <p>An alias is not a property of a key. Therefore, an alias can be mapped to and unmapped from an existing key without changing the properties of the key.</p> <p>An alias name can contain only alphanumeric characters, forward slashes (/), underscores (_), and dashes (-). An alias must start with the word "alias" followed by a forward slash (alias/). An alias that begins with "aws" after the forward slash (alias/aws...) is reserved by Amazon Web Services (AWS).</p> <p>The alias and the key it is mapped to must be in the same AWS account and the same region.</p>', 'UpdateKeyDescription' => '<p>Updates the description of a customer master key (CMK).</p>', ], 'shapes' => [ 'AWSAccountIdType' => [ 'base' => NULL, 'refs' => [ 'KeyMetadata$AWSAccountId' => '<p>The twelve-digit account ID of the AWS account that owns the CMK.</p>', ], ], 'AlgorithmSpec' => [ 'base' => NULL, 'refs' => [ 'GetParametersForImportRequest$WrappingAlgorithm' => '<p>The algorithm you will use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html">Encrypt the Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', ], ], 'AliasList' => [ 'base' => NULL, 'refs' => [ 'ListAliasesResponse$Aliases' => '<p>A list of key aliases in the user\'s account.</p>', ], ], 'AliasListEntry' => [ 'base' => '<p>Contains information about an alias.</p>', 'refs' => [ 'AliasList$member' => NULL, ], ], 'AliasNameType' => [ 'base' => NULL, 'refs' => [ 'AliasListEntry$AliasName' => '<p>String that contains the alias.</p>', 'CreateAliasRequest$AliasName' => '<p>String that contains the display name. The name must start with the word "alias" followed by a forward slash (alias/). Aliases that begin with "alias/AWS" are reserved.</p>', 'DeleteAliasRequest$AliasName' => '<p>The alias to be deleted. The name must start with the word "alias" followed by a forward slash (alias/). Aliases that begin with "alias/AWS" are reserved.</p>', 'UpdateAliasRequest$AliasName' => '<p>String that contains the name of the alias to be modified. The name must start with the word "alias" followed by a forward slash (alias/). Aliases that begin with "alias/aws" are reserved.</p>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>The request was rejected because it attempted to create a resource that already exists.</p>', 'refs' => [], ], 'ArnType' => [ 'base' => NULL, 'refs' => [ 'AliasListEntry$AliasArn' => '<p>String that contains the key ARN.</p>', 'KeyListEntry$KeyArn' => '<p>ARN of the key.</p>', 'KeyMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the CMK. For examples, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">AWS Key Management Service (AWS KMS)</a> in the Example ARNs section of the <i>AWS General Reference</i>.</p>', ], ], 'BooleanType' => [ 'base' => NULL, 'refs' => [ 'CreateKeyRequest$BypassPolicyLockoutSafetyCheck' => '<p>A flag to indicate whether to bypass the key policy lockout safety check.</p> <important> <p>Setting this value to true increases the likelihood that the CMK becomes unmanageable. Do not set this value to true indiscriminately.</p> <p>For more information, refer to the scenario in the <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.</p> </important> <p>Use this parameter only when you include a policy in the request and you intend to prevent the principal that is making the request from making a subsequent <a>PutKeyPolicy</a> request on the CMK.</p> <p>The default value is false.</p>', 'GetKeyRotationStatusResponse$KeyRotationEnabled' => '<p>A Boolean value that specifies whether key rotation is enabled.</p>', 'KeyMetadata$Enabled' => '<p>Specifies whether the CMK is enabled. When <code>KeyState</code> is <code>Enabled</code> this value is true, otherwise it is false.</p>', 'ListAliasesResponse$Truncated' => '<p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To retrieve more items, pass the value of the <code>NextMarker</code> element in this response to the <code>Marker</code> parameter in a subsequent request.</p>', 'ListGrantsResponse$Truncated' => '<p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To retrieve more items, pass the value of the <code>NextMarker</code> element in this response to the <code>Marker</code> parameter in a subsequent request.</p>', 'ListKeyPoliciesResponse$Truncated' => '<p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To retrieve more items, pass the value of the <code>NextMarker</code> element in this response to the <code>Marker</code> parameter in a subsequent request.</p>', 'ListKeysResponse$Truncated' => '<p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To retrieve more items, pass the value of the <code>NextMarker</code> element in this response to the <code>Marker</code> parameter in a subsequent request.</p>', 'ListResourceTagsResponse$Truncated' => '<p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To retrieve more items, pass the value of the <code>NextMarker</code> element in this response to the <code>Marker</code> parameter in a subsequent request.</p>', 'PutKeyPolicyRequest$BypassPolicyLockoutSafetyCheck' => '<p>A flag to indicate whether to bypass the key policy lockout safety check.</p> <important> <p>Setting this value to true increases the likelihood that the CMK becomes unmanageable. Do not set this value to true indiscriminately.</p> <p>For more information, refer to the scenario in the <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.</p> </important> <p>Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent <code>PutKeyPolicy</code> request on the CMK.</p> <p>The default value is false.</p>', ], ], 'CancelKeyDeletionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelKeyDeletionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CiphertextType' => [ 'base' => NULL, 'refs' => [ 'DecryptRequest$CiphertextBlob' => '<p>Ciphertext to be decrypted. The blob includes metadata.</p>', 'EncryptResponse$CiphertextBlob' => '<p>The encrypted plaintext. If you are using the CLI, the value is Base64 encoded. Otherwise, it is not encoded.</p>', 'GenerateDataKeyResponse$CiphertextBlob' => '<p>The encrypted data encryption key.</p>', 'GenerateDataKeyWithoutPlaintextResponse$CiphertextBlob' => '<p>The encrypted data encryption key.</p>', 'GetParametersForImportResponse$ImportToken' => '<p>The import token to send in a subsequent <a>ImportKeyMaterial</a> request.</p>', 'ImportKeyMaterialRequest$ImportToken' => '<p>The import token that you received in the response to a previous <a>GetParametersForImport</a> request. It must be from the same response that contained the public key that you used to encrypt the key material.</p>', 'ImportKeyMaterialRequest$EncryptedKeyMaterial' => '<p>The encrypted key material to import. It must be encrypted with the public key that you received in the response to a previous <a>GetParametersForImport</a> request, using the wrapping algorithm that you specified in that request.</p>', 'ReEncryptRequest$CiphertextBlob' => '<p>Ciphertext of the data to reencrypt.</p>', 'ReEncryptResponse$CiphertextBlob' => '<p>The reencrypted data.</p>', ], ], 'CreateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGrantResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataKeySpec' => [ 'base' => NULL, 'refs' => [ 'GenerateDataKeyRequest$KeySpec' => '<p>The length of the data encryption key. Use <code>AES_128</code> to generate a 128-bit symmetric key, or <code>AES_256</code> to generate a 256-bit symmetric key.</p>', 'GenerateDataKeyWithoutPlaintextRequest$KeySpec' => '<p>The length of the data encryption key. Use <code>AES_128</code> to generate a 128-bit symmetric key, or <code>AES_256</code> to generate a 256-bit symmetric key.</p>', ], ], 'DateType' => [ 'base' => NULL, 'refs' => [ 'GetParametersForImportResponse$ParametersValidTo' => '<p>The time at which the import token and public key are no longer valid. After this time, you cannot use them to make an <a>ImportKeyMaterial</a> request and you must send another <code>GetParametersForImport</code> request to retrieve new ones.</p>', 'GrantListEntry$CreationDate' => '<p>The date and time when the grant was created.</p>', 'ImportKeyMaterialRequest$ValidTo' => '<p>The time at which the imported key material expires. When the key material expires, AWS KMS deletes the key material and the CMK becomes unusable. You must omit this parameter when the <code>ExpirationModel</code> parameter is set to <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>. Otherwise it is required.</p>', 'KeyMetadata$CreationDate' => '<p>The date and time when the CMK was created.</p>', 'KeyMetadata$DeletionDate' => '<p>The date and time after which AWS KMS deletes the CMK. This value is present only when <code>KeyState</code> is <code>PendingDeletion</code>, otherwise this value is omitted.</p>', 'KeyMetadata$ValidTo' => '<p>The time at which the imported key material expires. When the key material expires, AWS KMS deletes the key material and the CMK becomes unusable. This value is present only for CMKs whose <code>Origin</code> is <code>EXTERNAL</code> and whose <code>ExpirationModel</code> is <code>KEY_MATERIAL_EXPIRES</code>, otherwise this value is omitted.</p>', 'ScheduleKeyDeletionResponse$DeletionDate' => '<p>The date and time after which AWS KMS deletes the customer master key (CMK).</p>', ], ], 'DecryptRequest' => [ 'base' => NULL, 'refs' => [], ], 'DecryptResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImportedKeyMaterialRequest' => [ 'base' => NULL, 'refs' => [], ], 'DependencyTimeoutException' => [ 'base' => '<p>The system timed out while trying to fulfill the request. The request can be retried.</p>', 'refs' => [], ], 'DescribeKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionType' => [ 'base' => NULL, 'refs' => [ 'CreateKeyRequest$Description' => '<p>A description of the CMK.</p> <p>Use a description that helps you decide whether the CMK is appropriate for a task.</p>', 'KeyMetadata$Description' => '<p>The description of the CMK.</p>', 'UpdateKeyDescriptionRequest$Description' => '<p>New description for the CMK.</p>', ], ], 'DisableKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableKeyRotationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisabledException' => [ 'base' => '<p>The request was rejected because the specified CMK is not enabled.</p>', 'refs' => [], ], 'EnableKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableKeyRotationRequest' => [ 'base' => NULL, 'refs' => [], ], 'EncryptRequest' => [ 'base' => NULL, 'refs' => [], ], 'EncryptResponse' => [ 'base' => NULL, 'refs' => [], ], 'EncryptionContextKey' => [ 'base' => NULL, 'refs' => [ 'EncryptionContextType$key' => NULL, ], ], 'EncryptionContextType' => [ 'base' => NULL, 'refs' => [ 'DecryptRequest$EncryptionContext' => '<p>The encryption context. If this was specified in the <a>Encrypt</a> function, it must be specified here or the decryption operation will fail. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption Context</a>.</p>', 'EncryptRequest$EncryptionContext' => '<p>Name-value pair that specifies the encryption context to be used for authenticated encryption. If used here, the same value must be supplied to the <code>Decrypt</code> API or decryption will fail. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption Context</a>.</p>', 'GenerateDataKeyRequest$EncryptionContext' => '<p>A set of key-value pairs that represents additional authenticated data.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption Context</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'GenerateDataKeyWithoutPlaintextRequest$EncryptionContext' => '<p>A set of key-value pairs that represents additional authenticated data.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption Context</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'GrantConstraints$EncryptionContextSubset' => '<p>A list of key-value pairs, all of which must be present in the encryption context of certain subsequent operations that the grant allows. When certain subsequent operations allowed by the grant include encryption context that matches this list or is a superset of this list, the grant allows the operation. Otherwise, the grant does not allow the operation.</p>', 'GrantConstraints$EncryptionContextEquals' => '<p>A list of key-value pairs that must be present in the encryption context of certain subsequent operations that the grant allows. When certain subsequent operations allowed by the grant include encryption context that matches this list, the grant allows the operation. Otherwise, the grant does not allow the operation.</p>', 'ReEncryptRequest$SourceEncryptionContext' => '<p>Encryption context used to encrypt and decrypt the data specified in the <code>CiphertextBlob</code> parameter.</p>', 'ReEncryptRequest$DestinationEncryptionContext' => '<p>Encryption context to use when the data is reencrypted.</p>', ], ], 'EncryptionContextValue' => [ 'base' => NULL, 'refs' => [ 'EncryptionContextType$value' => NULL, ], ], 'ErrorMessageType' => [ 'base' => NULL, 'refs' => [ 'AlreadyExistsException$message' => NULL, 'DependencyTimeoutException$message' => NULL, 'DisabledException$message' => NULL, 'ExpiredImportTokenException$message' => NULL, 'IncorrectKeyMaterialException$message' => NULL, 'InvalidAliasNameException$message' => NULL, 'InvalidArnException$message' => NULL, 'InvalidCiphertextException$message' => NULL, 'InvalidGrantIdException$message' => NULL, 'InvalidGrantTokenException$message' => NULL, 'InvalidImportTokenException$message' => NULL, 'InvalidKeyUsageException$message' => NULL, 'InvalidMarkerException$message' => NULL, 'KMSInternalException$message' => NULL, 'KMSInvalidStateException$message' => NULL, 'KeyUnavailableException$message' => NULL, 'LimitExceededException$message' => NULL, 'MalformedPolicyDocumentException$message' => NULL, 'NotFoundException$message' => NULL, 'TagException$message' => NULL, 'UnsupportedOperationException$message' => NULL, ], ], 'ExpirationModelType' => [ 'base' => NULL, 'refs' => [ 'ImportKeyMaterialRequest$ExpirationModel' => '<p>Specifies whether the key material expires. The default is <code>KEY_MATERIAL_EXPIRES</code>, in which case you must include the <code>ValidTo</code> parameter. When this parameter is set to <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>, you must omit the <code>ValidTo</code> parameter.</p>', 'KeyMetadata$ExpirationModel' => '<p>Specifies whether the CMK\'s key material expires. This value is present only when <code>Origin</code> is <code>EXTERNAL</code>, otherwise this value is omitted.</p>', ], ], 'ExpiredImportTokenException' => [ 'base' => '<p>The request was rejected because the provided import token is expired. Use <a>GetParametersForImport</a> to retrieve a new import token and public key, use the new public key to encrypt the key material, and then try the request again.</p>', 'refs' => [], ], 'GenerateDataKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GenerateDataKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GenerateDataKeyWithoutPlaintextRequest' => [ 'base' => NULL, 'refs' => [], ], 'GenerateDataKeyWithoutPlaintextResponse' => [ 'base' => NULL, 'refs' => [], ], 'GenerateRandomRequest' => [ 'base' => NULL, 'refs' => [], ], 'GenerateRandomResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyRotationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyRotationStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersForImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersForImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'GrantConstraints' => [ 'base' => '<p>A structure that you can use to allow certain operations in the grant only when the desired encryption context is present. For more information about encryption context, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption Context</a> in the <i>AWS Key Management Service Developer Guide</i>.</p> <p>Grant constraints apply only to operations that accept encryption context as input. For example, the <code> <a>DescribeKey</a> </code> operation does not accept encryption context as input. A grant that allows the <code>DescribeKey</code> operation does so regardless of the grant constraints. In constrast, the <code> <a>Encrypt</a> </code> operation accepts encryption context as input. A grant that allows the <code>Encrypt</code> operation does so only when the encryption context of the <code>Encrypt</code> operation satisfies the grant constraints.</p>', 'refs' => [ 'CreateGrantRequest$Constraints' => '<p>A structure that you can use to allow certain operations in the grant only when the desired encryption context is present. For more information about encryption context, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html">Encryption Context</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'GrantListEntry$Constraints' => '<p>A list of key-value pairs that must be present in the encryption context of certain subsequent operations that the grant allows.</p>', ], ], 'GrantIdType' => [ 'base' => NULL, 'refs' => [ 'CreateGrantResponse$GrantId' => '<p>The unique identifier for the grant.</p> <p>You can use the <code>GrantId</code> in a subsequent <a>RetireGrant</a> or <a>RevokeGrant</a> operation.</p>', 'GrantListEntry$GrantId' => '<p>The unique identifier for the grant.</p>', 'RetireGrantRequest$GrantId' => '<p>Unique identifier of the grant to retire. The grant ID is returned in the response to a <code>CreateGrant</code> operation.</p> <ul> <li> <p>Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123</p> </li> </ul>', 'RevokeGrantRequest$GrantId' => '<p>Identifier of the grant to be revoked.</p>', ], ], 'GrantList' => [ 'base' => NULL, 'refs' => [ 'ListGrantsResponse$Grants' => '<p>A list of grants.</p>', ], ], 'GrantListEntry' => [ 'base' => '<p>Contains information about an entry in a list of grants.</p>', 'refs' => [ 'GrantList$member' => NULL, ], ], 'GrantNameType' => [ 'base' => NULL, 'refs' => [ 'CreateGrantRequest$Name' => '<p>A friendly name for identifying the grant. Use this value to prevent unintended creation of duplicate grants when retrying this request.</p> <p>When this value is absent, all <code>CreateGrant</code> requests result in a new grant with a unique <code>GrantId</code> even if all the supplied parameters are identical. This can result in unintended duplicates when you retry the <code>CreateGrant</code> request.</p> <p>When this value is present, you can retry a <code>CreateGrant</code> request with identical parameters; if the grant already exists, the original <code>GrantId</code> is returned without creating a new grant. Note that the returned grant token is unique with every <code>CreateGrant</code> request, even when a duplicate <code>GrantId</code> is returned. All grant tokens obtained in this way can be used interchangeably.</p>', 'GrantListEntry$Name' => '<p>The friendly name that identifies the grant. If a name was provided in the <a>CreateGrant</a> request, that name is returned. Otherwise this value is null.</p>', ], ], 'GrantOperation' => [ 'base' => NULL, 'refs' => [ 'GrantOperationList$member' => NULL, ], ], 'GrantOperationList' => [ 'base' => NULL, 'refs' => [ 'CreateGrantRequest$Operations' => '<p>A list of operations that the grant permits.</p>', 'GrantListEntry$Operations' => '<p>The list of operations permitted by the grant.</p>', ], ], 'GrantTokenList' => [ 'base' => NULL, 'refs' => [ 'CreateGrantRequest$GrantTokens' => '<p>A list of grant tokens.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'DecryptRequest$GrantTokens' => '<p>A list of grant tokens.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'DescribeKeyRequest$GrantTokens' => '<p>A list of grant tokens.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'EncryptRequest$GrantTokens' => '<p>A list of grant tokens.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'GenerateDataKeyRequest$GrantTokens' => '<p>A list of grant tokens.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'GenerateDataKeyWithoutPlaintextRequest$GrantTokens' => '<p>A list of grant tokens.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'ReEncryptRequest$GrantTokens' => '<p>A list of grant tokens.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', ], ], 'GrantTokenType' => [ 'base' => NULL, 'refs' => [ 'CreateGrantResponse$GrantToken' => '<p>The grant token.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'GrantTokenList$member' => NULL, 'RetireGrantRequest$GrantToken' => '<p>Token that identifies the grant to be retired.</p>', ], ], 'ImportKeyMaterialRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportKeyMaterialResponse' => [ 'base' => NULL, 'refs' => [], ], 'IncorrectKeyMaterialException' => [ 'base' => '<p>The request was rejected because the provided key material is invalid or is not the same key material that was previously imported into this customer master key (CMK).</p>', 'refs' => [], ], 'InvalidAliasNameException' => [ 'base' => '<p>The request was rejected because the specified alias name is not valid.</p>', 'refs' => [], ], 'InvalidArnException' => [ 'base' => '<p>The request was rejected because a specified ARN was not valid.</p>', 'refs' => [], ], 'InvalidCiphertextException' => [ 'base' => '<p>The request was rejected because the specified ciphertext has been corrupted or is otherwise invalid.</p>', 'refs' => [], ], 'InvalidGrantIdException' => [ 'base' => '<p>The request was rejected because the specified <code>GrantId</code> is not valid.</p>', 'refs' => [], ], 'InvalidGrantTokenException' => [ 'base' => '<p>The request was rejected because the specified grant token is not valid.</p>', 'refs' => [], ], 'InvalidImportTokenException' => [ 'base' => '<p>The request was rejected because the provided import token is invalid or is associated with a different customer master key (CMK).</p>', 'refs' => [], ], 'InvalidKeyUsageException' => [ 'base' => '<p>The request was rejected because the specified <code>KeySpec</code> value is not valid.</p>', 'refs' => [], ], 'InvalidMarkerException' => [ 'base' => '<p>The request was rejected because the marker that specifies where pagination should next begin is not valid.</p>', 'refs' => [], ], 'KMSInternalException' => [ 'base' => '<p>The request was rejected because an internal exception occurred. The request can be retried.</p>', 'refs' => [], ], 'KMSInvalidStateException' => [ 'base' => '<p>The request was rejected because the state of the specified resource is not valid for this request.</p> <p>For more information about how key state affects the use of a CMK, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a Customer Master Key</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'refs' => [], ], 'KeyIdType' => [ 'base' => NULL, 'refs' => [ 'AliasListEntry$TargetKeyId' => '<p>String that contains the key identifier referred to by the alias.</p>', 'CancelKeyDeletionRequest$KeyId' => '<p>The unique identifier for the customer master key (CMK) for which to cancel deletion.</p> <p>To specify this value, use the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:</p> <ul> <li> <p>Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab</p> </li> <li> <p>Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</p> </li> </ul> <p>To obtain the unique key ID and key ARN for a given CMK, use <a>ListKeys</a> or <a>DescribeKey</a>.</p>', 'CancelKeyDeletionResponse$KeyId' => '<p>The unique identifier of the master key for which deletion is canceled.</p>', 'CreateAliasRequest$TargetKeyId' => '<p>An identifier of the key for which you are creating the alias. This value cannot be another alias but can be a globally unique identifier or a fully specified ARN to a key.</p> <ul> <li> <p>Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012</p> </li> </ul>', 'CreateGrantRequest$KeyId' => '<p>The unique identifier for the customer master key (CMK) that the grant applies to.</p> <p>To specify this value, use the globally unique key ID or the Amazon Resource Name (ARN) of the key. Examples:</p> <ul> <li> <p>Globally unique key ID: 12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Key ARN: arn:aws:kms:us-west-2:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> </ul>', 'DecryptResponse$KeyId' => '<p>ARN of the key used to perform the decryption. This value is returned if no errors are encountered during the operation.</p>', 'DeleteImportedKeyMaterialRequest$KeyId' => '<p>The identifier of the CMK whose key material to delete. The CMK\'s <code>Origin</code> must be <code>EXTERNAL</code>.</p> <p>A valid identifier is the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:</p> <ul> <li> <p>Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> </ul>', 'DescribeKeyRequest$KeyId' => '<p>A unique identifier for the customer master key. This value can be a globally unique identifier, a fully specified ARN to either an alias or a key, or an alias name prefixed by "alias/".</p> <ul> <li> <p>Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</p> </li> <li> <p>Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Alias Name Example - alias/MyAliasName</p> </li> </ul>', 'DisableKeyRequest$KeyId' => '<p>A unique identifier for the CMK.</p> <p>Use the CMK\'s unique identifier or its Amazon Resource Name (ARN). For example:</p> <ul> <li> <p>Unique ID: 1234abcd-12ab-34cd-56ef-1234567890ab</p> </li> <li> <p>ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</p> </li> </ul>', 'DisableKeyRotationRequest$KeyId' => '<p>A unique identifier for the customer master key. This value can be a globally unique identifier or the fully specified ARN to a key.</p> <ul> <li> <p>Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012</p> </li> </ul>', 'EnableKeyRequest$KeyId' => '<p>A unique identifier for the customer master key. This value can be a globally unique identifier or the fully specified ARN to a key.</p> <ul> <li> <p>Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012</p> </li> </ul>', 'EnableKeyRotationRequest$KeyId' => '<p>A unique identifier for the customer master key. This value can be a globally unique identifier or the fully specified ARN to a key.</p> <ul> <li> <p>Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012</p> </li> </ul>', 'EncryptRequest$KeyId' => '<p>A unique identifier for the customer master key. This value can be a globally unique identifier, a fully specified ARN to either an alias or a key, or an alias name prefixed by "alias/".</p> <ul> <li> <p>Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</p> </li> <li> <p>Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Alias Name Example - alias/MyAliasName</p> </li> </ul>', 'EncryptResponse$KeyId' => '<p>The ID of the key used during encryption.</p>', 'GenerateDataKeyRequest$KeyId' => '<p>The identifier of the CMK under which to generate and encrypt the data encryption key.</p> <p>A valid identifier is the unique key ID or the Amazon Resource Name (ARN) of the CMK, or the alias name or ARN of an alias that refers to the CMK. Examples:</p> <ul> <li> <p>Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>CMK ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul>', 'GenerateDataKeyResponse$KeyId' => '<p>The identifier of the CMK under which the data encryption key was generated and encrypted.</p>', 'GenerateDataKeyWithoutPlaintextRequest$KeyId' => '<p>The identifier of the CMK under which to generate and encrypt the data encryption key.</p> <p>A valid identifier is the unique key ID or the Amazon Resource Name (ARN) of the CMK, or the alias name or ARN of an alias that refers to the CMK. Examples:</p> <ul> <li> <p>Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>CMK ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul>', 'GenerateDataKeyWithoutPlaintextResponse$KeyId' => '<p>The identifier of the CMK under which the data encryption key was generated and encrypted.</p>', 'GetKeyPolicyRequest$KeyId' => '<p>A unique identifier for the customer master key. This value can be a globally unique identifier or the fully specified ARN to a key.</p> <ul> <li> <p>Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012</p> </li> </ul>', 'GetKeyRotationStatusRequest$KeyId' => '<p>A unique identifier for the customer master key. This value can be a globally unique identifier or the fully specified ARN to a key.</p> <ul> <li> <p>Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012</p> </li> </ul>', 'GetParametersForImportRequest$KeyId' => '<p>The identifier of the CMK into which you will import key material. The CMK\'s <code>Origin</code> must be <code>EXTERNAL</code>.</p> <p>A valid identifier is the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:</p> <ul> <li> <p>Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> </ul>', 'GetParametersForImportResponse$KeyId' => '<p>The identifier of the CMK to use in a subsequent <a>ImportKeyMaterial</a> request. This is the same CMK specified in the <code>GetParametersForImport</code> request.</p>', 'GrantListEntry$KeyId' => '<p>The unique identifier for the customer master key (CMK) to which the grant applies.</p>', 'ImportKeyMaterialRequest$KeyId' => '<p>The identifier of the CMK to import the key material into. The CMK\'s <code>Origin</code> must be <code>EXTERNAL</code>.</p> <p>A valid identifier is the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:</p> <ul> <li> <p>Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> </ul>', 'KeyListEntry$KeyId' => '<p>Unique identifier of the key.</p>', 'KeyMetadata$KeyId' => '<p>The globally unique identifier for the CMK.</p>', 'ListGrantsRequest$KeyId' => '<p>A unique identifier for the customer master key. This value can be a globally unique identifier or the fully specified ARN to a key.</p> <ul> <li> <p>Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012</p> </li> </ul>', 'ListKeyPoliciesRequest$KeyId' => '<p>A unique identifier for the customer master key (CMK). You can use the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:</p> <ul> <li> <p>Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> </ul>', 'ListResourceTagsRequest$KeyId' => '<p>A unique identifier for the CMK whose tags you are listing. You can use the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:</p> <ul> <li> <p>Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> </ul>', 'PutKeyPolicyRequest$KeyId' => '<p>A unique identifier for the CMK.</p> <p>Use the CMK\'s unique identifier or its Amazon Resource Name (ARN). For example:</p> <ul> <li> <p>Unique ID: 1234abcd-12ab-34cd-56ef-1234567890ab</p> </li> <li> <p>ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</p> </li> </ul>', 'ReEncryptRequest$DestinationKeyId' => '<p>A unique identifier for the CMK to use to reencrypt the data. This value can be a globally unique identifier, a fully specified ARN to either an alias or a key, or an alias name prefixed by "alias/".</p> <ul> <li> <p>Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</p> </li> <li> <p>Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Alias Name Example - alias/MyAliasName</p> </li> </ul>', 'ReEncryptResponse$SourceKeyId' => '<p>Unique identifier of the CMK used to originally encrypt the data.</p>', 'ReEncryptResponse$KeyId' => '<p>Unique identifier of the CMK used to reencrypt the data.</p>', 'RetireGrantRequest$KeyId' => '<p>The Amazon Resource Name of the CMK associated with the grant. Example:</p> <ul> <li> <p>arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab</p> </li> </ul>', 'RevokeGrantRequest$KeyId' => '<p>A unique identifier for the customer master key associated with the grant. This value can be a globally unique identifier or the fully specified ARN to a key.</p> <ul> <li> <p>Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012</p> </li> </ul>', 'ScheduleKeyDeletionRequest$KeyId' => '<p>The unique identifier for the customer master key (CMK) to delete.</p> <p>To specify this value, use the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:</p> <ul> <li> <p>Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab</p> </li> <li> <p>Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</p> </li> </ul> <p>To obtain the unique key ID and key ARN for a given CMK, use <a>ListKeys</a> or <a>DescribeKey</a>.</p>', 'ScheduleKeyDeletionResponse$KeyId' => '<p>The unique identifier of the customer master key (CMK) for which deletion is scheduled.</p>', 'TagResourceRequest$KeyId' => '<p>A unique identifier for the CMK you are tagging. You can use the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:</p> <ul> <li> <p>Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> </ul>', 'UntagResourceRequest$KeyId' => '<p>A unique identifier for the CMK from which you are removing tags. You can use the unique key ID or the Amazon Resource Name (ARN) of the CMK. Examples:</p> <ul> <li> <p>Unique key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> </ul>', 'UpdateAliasRequest$TargetKeyId' => '<p>Unique identifier of the customer master key to be mapped to the alias. This value can be a globally unique identifier or the fully specified ARN of a key.</p> <ul> <li> <p>Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012</p> </li> </ul> <p>You can call <a>ListAliases</a> to verify that the alias is mapped to the correct <code>TargetKeyId</code>.</p>', 'UpdateKeyDescriptionRequest$KeyId' => '<p>A unique identifier for the CMK. This value can be a globally unique identifier or the fully specified ARN to a key.</p> <ul> <li> <p>Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012</p> </li> </ul>', ], ], 'KeyList' => [ 'base' => NULL, 'refs' => [ 'ListKeysResponse$Keys' => '<p>A list of keys.</p>', ], ], 'KeyListEntry' => [ 'base' => '<p>Contains information about each entry in the key list.</p>', 'refs' => [ 'KeyList$member' => NULL, ], ], 'KeyManagerType' => [ 'base' => NULL, 'refs' => [ 'KeyMetadata$KeyManager' => '<p>The CMK\'s manager. CMKs are either customer-managed or AWS-managed. For more information about the difference, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', ], ], 'KeyMetadata' => [ 'base' => '<p>Contains metadata about a customer master key (CMK).</p> <p>This data type is used as a response element for the <a>CreateKey</a> and <a>DescribeKey</a> operations.</p>', 'refs' => [ 'CreateKeyResponse$KeyMetadata' => '<p>Metadata associated with the CMK.</p>', 'DescribeKeyResponse$KeyMetadata' => '<p>Metadata associated with the key.</p>', ], ], 'KeyState' => [ 'base' => NULL, 'refs' => [ 'KeyMetadata$KeyState' => '<p>The state of the CMK.</p> <p>For more information about how key state affects the use of a CMK, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects the Use of a Customer Master Key</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', ], ], 'KeyUnavailableException' => [ 'base' => '<p>The request was rejected because the specified CMK was not available. The request can be retried.</p>', 'refs' => [], ], 'KeyUsageType' => [ 'base' => NULL, 'refs' => [ 'CreateKeyRequest$KeyUsage' => '<p>The intended use of the CMK.</p> <p>You can use CMKs only for symmetric encryption and decryption.</p>', 'KeyMetadata$KeyUsage' => '<p>The cryptographic operations for which you can use the CMK. Currently the only allowed value is <code>ENCRYPT_DECRYPT</code>, which means you can use the CMK for the <a>Encrypt</a> and <a>Decrypt</a> operations.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request was rejected because a limit was exceeded. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/limits.html">Limits</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'refs' => [], ], 'LimitType' => [ 'base' => NULL, 'refs' => [ 'ListAliasesRequest$Limit' => '<p>Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS does not return more than the specified number of items, but it might return fewer.</p> <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>', 'ListGrantsRequest$Limit' => '<p>Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS does not return more than the specified number of items, but it might return fewer.</p> <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>', 'ListKeyPoliciesRequest$Limit' => '<p>Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS does not return more than the specified number of items, but it might return fewer.</p> <p>This value is optional. If you include a value, it must be between 1 and 1000, inclusive. If you do not include a value, it defaults to 100.</p> <p>Currently only 1 policy can be attached to a key.</p>', 'ListKeysRequest$Limit' => '<p>Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS does not return more than the specified number of items, but it might return fewer.</p> <p>This value is optional. If you include a value, it must be between 1 and 1000, inclusive. If you do not include a value, it defaults to 100.</p>', 'ListResourceTagsRequest$Limit' => '<p>Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS does not return more than the specified number of items, but it might return fewer.</p> <p>This value is optional. If you include a value, it must be between 1 and 50, inclusive. If you do not include a value, it defaults to 50.</p>', 'ListRetirableGrantsRequest$Limit' => '<p>Use this parameter to specify the maximum number of items to return. When this value is present, AWS KMS does not return more than the specified number of items, but it might return fewer.</p> <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>', ], ], 'ListAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGrantsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGrantsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKeyPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKeyPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKeysResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRetirableGrantsRequest' => [ 'base' => NULL, 'refs' => [], ], 'MalformedPolicyDocumentException' => [ 'base' => '<p>The request was rejected because the specified policy is not syntactically or semantically correct.</p>', 'refs' => [], ], 'MarkerType' => [ 'base' => NULL, 'refs' => [ 'ListAliasesRequest$Marker' => '<p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>', 'ListAliasesResponse$NextMarker' => '<p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>', 'ListGrantsRequest$Marker' => '<p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>', 'ListGrantsResponse$NextMarker' => '<p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>', 'ListKeyPoliciesRequest$Marker' => '<p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>', 'ListKeyPoliciesResponse$NextMarker' => '<p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>', 'ListKeysRequest$Marker' => '<p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>', 'ListKeysResponse$NextMarker' => '<p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>', 'ListResourceTagsRequest$Marker' => '<p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p> <p>Do not attempt to construct this value. Use only the value of <code>NextMarker</code> from the truncated response you just received.</p>', 'ListResourceTagsResponse$NextMarker' => '<p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p> <p>Do not assume or infer any information from this value.</p>', 'ListRetirableGrantsRequest$Marker' => '<p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>The request was rejected because the specified entity or resource could not be found.</p>', 'refs' => [], ], 'NumberOfBytesType' => [ 'base' => NULL, 'refs' => [ 'GenerateDataKeyRequest$NumberOfBytes' => '<p>The length of the data encryption key in bytes. For example, use the value 64 to generate a 512-bit data key (64 bytes is 512 bits). For common key lengths (128-bit and 256-bit symmetric keys), we recommend that you use the <code>KeySpec</code> field instead of this one.</p>', 'GenerateDataKeyWithoutPlaintextRequest$NumberOfBytes' => '<p>The length of the data encryption key in bytes. For example, use the value 64 to generate a 512-bit data key (64 bytes is 512 bits). For common key lengths (128-bit and 256-bit symmetric keys), we recommend that you use the <code>KeySpec</code> field instead of this one.</p>', 'GenerateRandomRequest$NumberOfBytes' => '<p>The length of the byte string.</p>', ], ], 'OriginType' => [ 'base' => NULL, 'refs' => [ 'CreateKeyRequest$Origin' => '<p>The source of the CMK\'s key material.</p> <p>The default is <code>AWS_KMS</code>, which means AWS KMS creates the key material. When this parameter is set to <code>EXTERNAL</code>, the request creates a CMK without key material so that you can import key material from your existing key management infrastructure. For more information about importing key material into AWS KMS, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.</p> <p>The CMK\'s <code>Origin</code> is immutable and is set when the CMK is created.</p>', 'KeyMetadata$Origin' => '<p>The source of the CMK\'s key material. When this value is <code>AWS_KMS</code>, AWS KMS created the key material. When this value is <code>EXTERNAL</code>, the key material was imported from your existing key management infrastructure or the CMK lacks key material.</p>', ], ], 'PendingWindowInDaysType' => [ 'base' => NULL, 'refs' => [ 'ScheduleKeyDeletionRequest$PendingWindowInDays' => '<p>The waiting period, specified in number of days. After the waiting period ends, AWS KMS deletes the customer master key (CMK).</p> <p>This value is optional. If you include a value, it must be between 7 and 30, inclusive. If you do not include a value, it defaults to 30.</p>', ], ], 'PlaintextType' => [ 'base' => NULL, 'refs' => [ 'DecryptResponse$Plaintext' => '<p>Decrypted plaintext data. This value may not be returned if the customer master key is not available or if you didn\'t have permission to use it.</p>', 'EncryptRequest$Plaintext' => '<p>Data to be encrypted.</p>', 'GenerateDataKeyResponse$Plaintext' => '<p>The data encryption key. Use this data key for local encryption and decryption, then remove it from memory as soon as possible.</p>', 'GenerateRandomResponse$Plaintext' => '<p>The random byte string.</p>', 'GetParametersForImportResponse$PublicKey' => '<p>The public key to use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>.</p>', ], ], 'PolicyNameList' => [ 'base' => NULL, 'refs' => [ 'ListKeyPoliciesResponse$PolicyNames' => '<p>A list of policy names. Currently, there is only one policy and it is named "Default".</p>', ], ], 'PolicyNameType' => [ 'base' => NULL, 'refs' => [ 'GetKeyPolicyRequest$PolicyName' => '<p>String that contains the name of the policy. Currently, this must be "default". Policy names can be discovered by calling <a>ListKeyPolicies</a>.</p>', 'PolicyNameList$member' => NULL, 'PutKeyPolicyRequest$PolicyName' => '<p>The name of the key policy.</p> <p>This value must be <code>default</code>.</p>', ], ], 'PolicyType' => [ 'base' => NULL, 'refs' => [ 'CreateKeyRequest$Policy' => '<p>The key policy to attach to the CMK.</p> <p>If you specify a policy and do not set <code>BypassPolicyLockoutSafetyCheck</code> to true, the policy must meet the following criteria:</p> <ul> <li> <p>It must allow the principal that is making the <code>CreateKey</code> request to make a subsequent <a>PutKeyPolicy</a> request on the CMK. This reduces the likelihood that the CMK becomes unmanageable. For more information, refer to the scenario in the <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.</p> </li> <li> <p>The principals that are specified in the key policy must exist and be visible to AWS KMS. When you create a new AWS principal (for example, an IAM user or role), you might need to enforce a delay before specifying the new principal in a key policy because the new principal might not immediately be visible to AWS KMS. For more information, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <i>IAM User Guide</i>.</p> </li> </ul> <p>If you do not specify a policy, AWS KMS attaches a default key policy to the CMK. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default Key Policy</a> in the <i>AWS Key Management Service Developer Guide</i>.</p> <p>The policy size limit is 32 KiB (32768 bytes).</p>', 'GetKeyPolicyResponse$Policy' => '<p>A policy document in JSON format.</p>', 'PutKeyPolicyRequest$Policy' => '<p>The key policy to attach to the CMK.</p> <p>If you do not set <code>BypassPolicyLockoutSafetyCheck</code> to true, the policy must meet the following criteria:</p> <ul> <li> <p>It must allow the principal that is making the <code>PutKeyPolicy</code> request to make a subsequent <code>PutKeyPolicy</code> request on the CMK. This reduces the likelihood that the CMK becomes unmanageable. For more information, refer to the scenario in the <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section in the <i>AWS Key Management Service Developer Guide</i>.</p> </li> <li> <p>The principals that are specified in the key policy must exist and be visible to AWS KMS. When you create a new AWS principal (for example, an IAM user or role), you might need to enforce a delay before specifying the new principal in a key policy because the new principal might not immediately be visible to AWS KMS. For more information, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <i>IAM User Guide</i>.</p> </li> </ul> <p>The policy size limit is 32 KiB (32768 bytes).</p>', ], ], 'PrincipalIdType' => [ 'base' => NULL, 'refs' => [ 'CreateGrantRequest$GranteePrincipal' => '<p>The principal that is given permission to perform the operations that the grant permits.</p> <p>To specify the principal, use the <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, IAM roles, federated users, and assumed role users. For examples of the ARN syntax to use for specifying a principal, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>AWS General Reference</i>.</p>', 'CreateGrantRequest$RetiringPrincipal' => '<p>The principal that is given permission to retire the grant by using <a>RetireGrant</a> operation.</p> <p>To specify the principal, use the <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, federated users, and assumed role users. For examples of the ARN syntax to use for specifying a principal, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>AWS General Reference</i>.</p>', 'GrantListEntry$GranteePrincipal' => '<p>The principal that receives the grant\'s permissions.</p>', 'GrantListEntry$RetiringPrincipal' => '<p>The principal that can retire the grant.</p>', 'GrantListEntry$IssuingAccount' => '<p>The AWS account under which the grant was issued.</p>', 'ListRetirableGrantsRequest$RetiringPrincipal' => '<p>The retiring principal for which to list grants.</p> <p>To specify the retiring principal, use the <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an AWS principal. Valid AWS principals include AWS accounts (root), IAM users, federated users, and assumed role users. For examples of the ARN syntax for specifying a principal, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>', ], ], 'PutKeyPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReEncryptRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReEncryptResponse' => [ 'base' => NULL, 'refs' => [], ], 'RetireGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevokeGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'ScheduleKeyDeletionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ScheduleKeyDeletionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Tag' => [ 'base' => '<p>A key-value pair. A tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty (null) strings.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagException' => [ 'base' => '<p>The request was rejected because one or more tags are not valid.</p>', 'refs' => [], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>One or more tag keys. Specify only the tag keys, not the tag values.</p>', ], ], 'TagKeyType' => [ 'base' => NULL, 'refs' => [ 'Tag$TagKey' => '<p>The key of the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateKeyRequest$Tags' => '<p>One or more tags. Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty (null) strings.</p> <p>Use this parameter to tag the CMK when it is created. Alternately, you can omit this parameter and instead tag the CMK after it is created using <a>TagResource</a>.</p>', 'ListResourceTagsResponse$Tags' => '<p>A list of tags. Each tag consists of a tag key and a tag value.</p>', 'TagResourceRequest$Tags' => '<p>One or more tags. Each tag consists of a tag key and a tag value.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValueType' => [ 'base' => NULL, 'refs' => [ 'Tag$TagValue' => '<p>The value of the tag.</p>', ], ], 'UnsupportedOperationException' => [ 'base' => '<p>The request was rejected because a specified parameter is not supported or a specified resource is not valid for this operation.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKeyDescriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'WrappingKeySpec' => [ 'base' => NULL, 'refs' => [ 'GetParametersForImportRequest$WrappingKeySpec' => '<p>The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are supported.</p>', ], ], ],];
