<?php
// This file was auto-generated from sdk-root/src/data/lambda/2015-03-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Lambda</fullname> <p> <b>Overview</b> </p> <p>This is the <i>AWS Lambda API Reference</i>. The AWS Lambda Developer Guide provides additional information. For the service overview, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/welcome.html">What is AWS Lambda</a>, and for information about how the service works, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html">AWS Lambda: How it Works</a> in the <i>AWS Lambda Developer Guide</i>.</p>', 'operations' => [ 'AddPermission' => '<p>Adds a permission to the resource policy associated with the specified AWS Lambda function. You use resource policies to grant permissions to event sources that use <i>push</i> model. In a <i>push</i> model, event sources (such as Amazon S3 and custom applications) invoke your Lambda function. Each permission you add to the resource policy allows an event source, permission to invoke the Lambda function. </p> <p>For information about the push model, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html">AWS Lambda: How it Works</a>. </p> <p>If you are using versioning, the permissions you add are specific to the Lambda function version or alias you specify in the <code>AddPermission</code> request via the <code>Qualifier</code> parameter. For more information about versioning, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p> <p>This operation requires permission for the <code>lambda:AddPermission</code> action.</p>', 'CreateAlias' => '<p>Creates an alias that points to the specified Lambda function version. For more information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS Lambda Aliases</a>.</p> <p>Alias names are unique for a given function. This requires permission for the lambda:CreateAlias action.</p>', 'CreateEventSourceMapping' => '<p>Identifies a stream as an event source for a Lambda function. It can be either an Amazon Kinesis stream or an Amazon DynamoDB stream. AWS Lambda invokes the specified function when records are posted to the stream.</p> <p>This association between a stream source and a Lambda function is called the event source mapping.</p> <important> <p>This event source mapping is relevant only in the AWS Lambda pull model, where AWS Lambda invokes the function. For more information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html">AWS Lambda: How it Works</a> in the <i>AWS Lambda Developer Guide</i>.</p> </important> <p>You provide mapping information (for example, which stream to read from and which Lambda function to invoke) in the request body.</p> <p>Each event source, such as an Amazon Kinesis or a DynamoDB stream, can be associated with multiple AWS Lambda function. A given Lambda function can be associated with multiple AWS event sources.</p> <p>If you are using versioning, you can specify a specific function version or an alias via the function name parameter. For more information about versioning, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p> <p>This operation requires permission for the <code>lambda:CreateEventSourceMapping</code> action.</p>', 'CreateFunction' => '<p>Creates a new Lambda function. The function metadata is created from the request parameters, and the code for the function is provided by a .zip file in the request body. If the function name already exists, the operation will fail. Note that the function name is case-sensitive.</p> <p> If you are using versioning, you can also publish a version of the Lambda function you are creating using the <code>Publish</code> parameter. For more information about versioning, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p> <p>This operation requires permission for the <code>lambda:CreateFunction</code> action.</p>', 'DeleteAlias' => '<p>Deletes the specified Lambda function alias. For more information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS Lambda Aliases</a>.</p> <p>This requires permission for the lambda:DeleteAlias action.</p>', 'DeleteEventSourceMapping' => '<p>Removes an event source mapping. This means AWS Lambda will no longer invoke the function for events in the associated source.</p> <p>This operation requires permission for the <code>lambda:DeleteEventSourceMapping</code> action.</p>', 'DeleteFunction' => '<p>Deletes the specified Lambda function code and configuration.</p> <p>If you are using the versioning feature and you don\'t specify a function version in your <code>DeleteFunction</code> request, AWS Lambda will delete the function, including all its versions, and any aliases pointing to the function versions. To delete a specific function version, you must provide the function version via the <code>Qualifier</code> parameter. For information about function versioning, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p> <p>When you delete a function the associated resource policy is also deleted. You will need to delete the event source mappings explicitly.</p> <p>This operation requires permission for the <code>lambda:DeleteFunction</code> action.</p>', 'GetAccountSettings' => '<p>Returns a customer\'s account settings.</p> <p>You can use this operation to retrieve Lambda limits information, such as code size and concurrency limits. For more information about limits, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">AWS Lambda Limits</a>. You can also retrieve resource usage statistics, such as code storage usage and function count.</p>', 'GetAlias' => '<p>Returns the specified alias information such as the alias ARN, description, and function version it is pointing to. For more information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS Lambda Aliases</a>.</p> <p>This requires permission for the <code>lambda:GetAlias</code> action.</p>', 'GetEventSourceMapping' => '<p>Returns configuration information for the specified event source mapping (see <a>CreateEventSourceMapping</a>).</p> <p>This operation requires permission for the <code>lambda:GetEventSourceMapping</code> action.</p>', 'GetFunction' => '<p>Returns the configuration information of the Lambda function and a presigned URL link to the .zip file you uploaded with <a>CreateFunction</a> so you can download the .zip file. Note that the URL is valid for up to 10 minutes. The configuration information is the same information you provided as parameters when uploading the function.</p> <p>Using the optional <code>Qualifier</code> parameter, you can specify a specific function version for which you want this information. If you don\'t specify this parameter, the API uses unqualified function ARN which return information about the <code>$LATEST</code> version of the Lambda function. For more information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>.</p> <p>This operation requires permission for the <code>lambda:GetFunction</code> action.</p>', 'GetFunctionConfiguration' => '<p>Returns the configuration information of the Lambda function. This the same information you provided as parameters when uploading the function by using <a>CreateFunction</a>.</p> <p>If you are using the versioning feature, you can retrieve this information for a specific function version by using the optional <code>Qualifier</code> parameter and specifying the function version or alias that points to it. If you don\'t provide it, the API returns information about the $LATEST version of the function. For more information about versioning, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>.</p> <p>This operation requires permission for the <code>lambda:GetFunctionConfiguration</code> operation.</p>', 'GetPolicy' => '<p>Returns the resource policy associated with the specified Lambda function.</p> <p> If you are using the versioning feature, you can get the resource policy associated with the specific Lambda function version or alias by specifying the version or alias name using the <code>Qualifier</code> parameter. For more information about versioning, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p> <p>You need permission for the <code>lambda:GetPolicy action.</code> </p>', 'Invoke' => '<p>Invokes a specific Lambda function. For an example, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/with-dynamodb-create-function.html#with-dbb-invoke-manually">Create the Lambda Function and Test It Manually</a>. </p> <p>If you are using the versioning feature, you can invoke the specific function version by providing function version or alias name that is pointing to the function version using the <code>Qualifier</code> parameter in the request. If you don\'t provide the <code>Qualifier</code> parameter, the <code>$LATEST</code> version of the Lambda function is invoked. Invocations occur at least once in response to an event and functions must be idempotent to handle this. For information about the versioning feature, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p> <p>This operation requires permission for the <code>lambda:InvokeFunction</code> action.</p>', 'InvokeAsync' => '<important> <p>This API is deprecated. We recommend you use <code>Invoke</code> API (see <a>Invoke</a>).</p> </important> <p>Submits an invocation request to AWS Lambda. Upon receiving the request, Lambda executes the specified function asynchronously. To see the logs generated by the Lambda function execution, see the CloudWatch Logs console.</p> <p>This operation requires permission for the <code>lambda:InvokeFunction</code> action.</p>', 'ListAliases' => '<p>Returns list of aliases created for a Lambda function. For each alias, the response includes information such as the alias ARN, description, alias name, and the function version to which it points. For more information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS Lambda Aliases</a>.</p> <p>This requires permission for the lambda:ListAliases action.</p>', 'ListEventSourceMappings' => '<p>Returns a list of event source mappings you created using the <code>CreateEventSourceMapping</code> (see <a>CreateEventSourceMapping</a>). </p> <p>For each mapping, the API returns configuration information. You can optionally specify filters to retrieve specific event source mappings.</p> <p>If you are using the versioning feature, you can get list of event source mappings for a specific Lambda function version or an alias as described in the <code>FunctionName</code> parameter. For information about the versioning feature, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p> <p>This operation requires permission for the <code>lambda:ListEventSourceMappings</code> action.</p>', 'ListFunctions' => '<p>Returns a list of your Lambda functions. For each function, the response includes the function configuration information. You must use <a>GetFunction</a> to retrieve the code for your function.</p> <p>This operation requires permission for the <code>lambda:ListFunctions</code> action.</p> <p>If you are using the versioning feature, you can list all of your functions or only <code>$LATEST</code> versions. For information about the versioning feature, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p>', 'ListTags' => '<p>Returns a list of tags assigned to a function when supplied the function ARN (Amazon Resource Name).</p>', 'ListVersionsByFunction' => '<p>List all versions of a function. For information about the versioning feature, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p>', 'PublishVersion' => '<p>Publishes a version of your function from the current snapshot of $LATEST. That is, AWS Lambda takes a snapshot of the function code and configuration information from $LATEST and publishes a new version. The code and configuration cannot be modified after publication. For information about the versioning feature, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p>', 'RemovePermission' => '<p>You can remove individual permissions from an resource policy associated with a Lambda function by providing a statement ID that you provided when you added the permission.</p> <p>If you are using versioning, the permissions you remove are specific to the Lambda function version or alias you specify in the <code>AddPermission</code> request via the <code>Qualifier</code> parameter. For more information about versioning, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p> <p>Note that removal of a permission will cause an active event source to lose permission to the function.</p> <p>You need permission for the <code>lambda:RemovePermission</code> action.</p>', 'TagResource' => '<p>Creates a list of tags (key-value pairs) on the Lambda function. Requires the Lambda function ARN (Amazon Resource Name). If a key is specified without a value, Lambda creates a tag with the specified key and a value of null. </p>', 'UntagResource' => '<p>Removes tags from a Lambda function. Requires the function ARN (Amazon Resource Name). </p>', 'UpdateAlias' => '<p>Using this API you can update the function version to which the alias points and the alias description. For more information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS Lambda Aliases</a>.</p> <p>This requires permission for the lambda:UpdateAlias action.</p>', 'UpdateEventSourceMapping' => '<p>You can update an event source mapping. This is useful if you want to change the parameters of the existing mapping without losing your position in the stream. You can change which function will receive the stream records, but to change the stream itself, you must create a new mapping.</p> <p>If you are using the versioning feature, you can update the event source mapping to map to a specific Lambda function version or alias as described in the <code>FunctionName</code> parameter. For information about the versioning feature, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p> <p>If you disable the event source mapping, AWS Lambda stops polling. If you enable again, it will resume polling from the time it had stopped polling, so you don\'t lose processing of any records. However, if you delete event source mapping and create it again, it will reset.</p> <p>This operation requires permission for the <code>lambda:UpdateEventSourceMapping</code> action.</p>', 'UpdateFunctionCode' => '<p>Updates the code for the specified Lambda function. This operation must only be used on an existing Lambda function and cannot be used to update the function configuration.</p> <p>If you are using the versioning feature, note this API will always update the $LATEST version of your Lambda function. For information about the versioning feature, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p> <p>This operation requires permission for the <code>lambda:UpdateFunctionCode</code> action.</p>', 'UpdateFunctionConfiguration' => '<p>Updates the configuration parameters for the specified Lambda function by using the values provided in the request. You provide only the parameters you want to change. This operation must only be used on an existing Lambda function and cannot be used to update the function\'s code.</p> <p>If you are using the versioning feature, note this API will always update the $LATEST version of your Lambda function. For information about the versioning feature, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a>. </p> <p>This operation requires permission for the <code>lambda:UpdateFunctionConfiguration</code> action.</p>', ], 'shapes' => [ 'AccountLimit' => [ 'base' => '<p>Provides limits of code size and concurrency associated with the current account and region.</p>', 'refs' => [ 'GetAccountSettingsResponse$AccountLimit' => NULL, ], ], 'AccountUsage' => [ 'base' => '<p>Provides code size usage and function count associated with the current account and region.</p>', 'refs' => [ 'GetAccountSettingsResponse$AccountUsage' => NULL, ], ], 'Action' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$Action' => '<p>The AWS Lambda action you want to allow in this statement. Each Lambda action is a string starting with <code>lambda:</code> followed by the API name . For example, <code>lambda:CreateFunction</code>. You can use wildcard (<code>lambda:*</code>) to grant permission for all AWS Lambda actions. </p>', ], ], 'AddPermissionRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'AddPermissionResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'Alias' => [ 'base' => NULL, 'refs' => [ 'AliasConfiguration$Name' => '<p>Alias name.</p>', 'CreateAliasRequest$Name' => '<p>Name for the alias you are creating.</p>', 'DeleteAliasRequest$Name' => '<p>Name of the alias to delete.</p>', 'GetAliasRequest$Name' => '<p>Name of the alias for which you want to retrieve information.</p>', 'UpdateAliasRequest$Name' => '<p>The alias name.</p>', ], ], 'AliasConfiguration' => [ 'base' => '<p>Provides configuration information about a Lambda function version alias.</p>', 'refs' => [ 'AliasList$member' => NULL, ], ], 'AliasList' => [ 'base' => NULL, 'refs' => [ 'ListAliasesResponse$Aliases' => '<p>A list of aliases.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$SourceArn' => '<p>This is optional; however, when granting permission to invoke your function, you should specify this field with the Amazon Resource Name (ARN) as its value. This ensures that only events generated from the specified source can invoke the function.</p> <important> <p>If you add a permission without providing the source ARN, any AWS account that creates a mapping to your function ARN can send events to invoke your Lambda function.</p> </important>', 'CreateEventSourceMappingRequest$EventSourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Kinesis or the Amazon DynamoDB stream that is the event source. Any record added to this stream could cause AWS Lambda to invoke your Lambda function, it depends on the <code>BatchSize</code>. AWS Lambda POSTs the Amazon Kinesis event, containing records, to your Lambda function as JSON.</p>', 'EventSourceMappingConfiguration$EventSourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Kinesis stream that is the source of events.</p>', 'ListEventSourceMappingsRequest$EventSourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Kinesis stream. (This parameter is optional.)</p>', ], ], 'BatchSize' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$BatchSize' => '<p>The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function. Your function receives an event with all the retrieved records. The default is 100 records.</p>', 'EventSourceMappingConfiguration$BatchSize' => '<p>The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function. Your function receives an event with all the retrieved records.</p>', 'UpdateEventSourceMappingRequest$BatchSize' => '<p>The maximum number of stream records that can be sent to your Lambda function for a single invocation.</p>', ], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'FunctionCode$ZipFile' => '<p>The contents of your zip file containing your deployment package. If you are using the web API directly, the contents of the zip file must be base64-encoded. If you are using the AWS SDKs or the AWS CLI, the SDKs or CLI will do the encoding for you. For more information about creating a .zip file, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role.html">Execution Permissions</a> in the <i>AWS Lambda Developer Guide</i>. </p>', 'InvocationRequest$Payload' => '<p>JSON that you want to provide to your Lambda function as input.</p>', 'InvocationResponse$Payload' => '<p> It is the JSON representation of the object returned by the Lambda function. This is present only if the invocation type is <code>RequestResponse</code>. </p> <p>In the event of a function error this field contains a message describing the error. For the <code>Handled</code> errors the Lambda function will report this message. For <code>Unhandled</code> errors AWS Lambda reports the message. </p>', 'UpdateFunctionCodeRequest$ZipFile' => '<p>The contents of your zip file containing your deployment package. If you are using the web API directly, the contents of the zip file must be base64-encoded. If you are using the AWS SDKs or the AWS CLI, the SDKs or CLI will do the encoding for you. For more information about creating a .zip file, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role.html">Execution Permissions</a> in the <i>AWS Lambda Developer Guide</i>. </p>', ], ], 'BlobStream' => [ 'base' => NULL, 'refs' => [ 'InvokeAsyncRequest$InvokeArgs' => '<p>JSON that you want to provide to your Lambda function as input.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Publish' => '<p>This boolean parameter can be used to request AWS Lambda to create the Lambda function and publish a version as an atomic operation.</p>', 'UpdateFunctionCodeRequest$Publish' => '<p>This boolean parameter can be used to request AWS Lambda to update the Lambda function and publish a version as an atomic operation.</p>', 'UpdateFunctionCodeRequest$DryRun' => '<p>This boolean parameter can be used to test your request to AWS Lambda to update the Lambda function and publish a version as an atomic operation. It will do all necessary computation and validation of your code but will not upload it or a publish a version. Each time this operation is invoked, the <code>CodeSha256</code> hash value the provided code will also be computed and returned in the response.</p>', ], ], 'CodeStorageExceededException' => [ 'base' => '<p>You have exceeded your maximum total code size per account. <a href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a> </p>', 'refs' => [], ], 'CreateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventSourceMappingRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateFunctionRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$StartingPositionTimestamp' => '<p>The timestamp of the data record from which to start reading. Used with <a href="http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType">shard iterator type</a> AT_TIMESTAMP. If a record with this exact timestamp does not exist, the iterator returned is for the next (later) record. If the timestamp is older than the current trim horizon, the iterator returned is for the oldest untrimmed data record (TRIM_HORIZON). Valid only for Kinesis streams. </p>', 'EventSourceMappingConfiguration$LastModified' => '<p>The UTC time string indicating the last time the event mapping was updated.</p>', ], ], 'DeadLetterConfig' => [ 'base' => '<p>The parent object that contains the target ARN (Amazon Resource Name) of an Amazon SQS queue or Amazon SNS topic.</p>', 'refs' => [ 'CreateFunctionRequest$DeadLetterConfig' => '<p>The parent object that contains the target ARN (Amazon Resource Name) of an Amazon SQS queue or Amazon SNS topic. </p>', 'FunctionConfiguration$DeadLetterConfig' => '<p>The parent object that contains the target ARN (Amazon Resource Name) of an Amazon SQS queue or Amazon SNS topic.</p>', 'UpdateFunctionConfigurationRequest$DeadLetterConfig' => '<p>The parent object that contains the target ARN (Amazon Resource Name) of an Amazon SQS queue or Amazon SNS topic.</p>', ], ], 'DeleteAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventSourceMappingRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'AliasConfiguration$Description' => '<p>Alias description.</p>', 'CreateAliasRequest$Description' => '<p>Description of the alias.</p>', 'CreateFunctionRequest$Description' => '<p>A short, user-defined function description. Lambda does not use this value. Assign a meaningful description as you see fit.</p>', 'FunctionConfiguration$Description' => '<p>The user-provided description.</p>', 'PublishVersionRequest$Description' => '<p>The description for the version you are publishing. If not provided, AWS Lambda copies the description from the $LATEST version.</p>', 'UpdateAliasRequest$Description' => '<p>You can change the description of the alias using this parameter.</p>', 'UpdateFunctionConfigurationRequest$Description' => '<p>A short user-defined function description. AWS Lambda does not use this value. Assign a meaningful description as you see fit.</p>', ], ], 'EC2AccessDeniedException' => [ 'base' => '<p/>', 'refs' => [], ], 'EC2ThrottledException' => [ 'base' => '<p>AWS Lambda was throttled by Amazon EC2 during Lambda function initialization using the execution role provided for the Lambda function.</p>', 'refs' => [], ], 'EC2UnexpectedException' => [ 'base' => '<p>AWS Lambda received an unexpected EC2 client exception while setting up for the Lambda function.</p>', 'refs' => [], ], 'ENILimitReachedException' => [ 'base' => '<p>AWS Lambda was not able to create an Elastic Network Interface (ENI) in the VPC, specified as part of Lambda function configuration, because the limit for network interfaces has been reached.</p>', 'refs' => [], ], 'Enabled' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$Enabled' => '<p>Indicates whether AWS Lambda should begin polling the event source. By default, <code>Enabled</code> is true. </p>', 'UpdateEventSourceMappingRequest$Enabled' => '<p>Specifies whether AWS Lambda should actively poll the stream or not. If disabled, AWS Lambda will not poll the stream.</p>', ], ], 'Environment' => [ 'base' => '<p>The parent object that contains your environment\'s configuration settings.</p>', 'refs' => [ 'CreateFunctionRequest$Environment' => NULL, 'UpdateFunctionConfigurationRequest$Environment' => '<p>The parent object that contains your environment\'s configuration settings.</p>', ], ], 'EnvironmentError' => [ 'base' => '<p>The parent object that contains error information associated with your configuration settings.</p>', 'refs' => [ 'EnvironmentResponse$Error' => NULL, ], ], 'EnvironmentResponse' => [ 'base' => '<p>The parent object returned that contains your environment\'s configuration settings or any error information associated with your configuration settings.</p>', 'refs' => [ 'FunctionConfiguration$Environment' => '<p>The parent object that contains your environment\'s configuration settings.</p>', ], ], 'EnvironmentVariableName' => [ 'base' => NULL, 'refs' => [ 'EnvironmentVariables$key' => NULL, ], ], 'EnvironmentVariableValue' => [ 'base' => NULL, 'refs' => [ 'EnvironmentVariables$value' => NULL, ], ], 'EnvironmentVariables' => [ 'base' => NULL, 'refs' => [ 'Environment$Variables' => '<p>The key-value pairs that represent your environment\'s configuration settings.</p>', 'EnvironmentResponse$Variables' => '<p>The key-value pairs returned that represent your environment\'s configuration settings or error information.</p>', ], ], 'EventSourceMappingConfiguration' => [ 'base' => '<p>Describes mapping between an Amazon Kinesis stream and a Lambda function.</p>', 'refs' => [ 'EventSourceMappingsList$member' => NULL, ], ], 'EventSourceMappingsList' => [ 'base' => NULL, 'refs' => [ 'ListEventSourceMappingsResponse$EventSourceMappings' => '<p>An array of <code>EventSourceMappingConfiguration</code> objects.</p>', ], ], 'EventSourcePosition' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$StartingPosition' => '<p>The position in the stream where AWS Lambda should start reading. Valid only for Kinesis streams. For more information, see <a href="http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType">ShardIteratorType</a> in the <i>Amazon Kinesis API Reference</i>. </p>', ], ], 'EventSourceToken' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$EventSourceToken' => '<p>A unique token that must be supplied by the principal invoking the function. This is currently only used for Alexa Smart Home functions.</p>', ], ], 'FunctionArn' => [ 'base' => NULL, 'refs' => [ 'AliasConfiguration$AliasArn' => '<p>Lambda function ARN that is qualified using the alias name as the suffix. For example, if you create an alias called <code>BETA</code> that points to a helloworld function version, the ARN is <code>arn:aws:lambda:aws-regions:acct-id:function:helloworld:BETA</code>.</p>', 'EventSourceMappingConfiguration$FunctionArn' => '<p>The Lambda function to invoke when AWS Lambda detects an event on the stream.</p>', 'FunctionConfiguration$MasterArn' => '<p>Returns the ARN (Amazon Resource Name) of the master function.</p>', 'ListTagsRequest$Resource' => '<p>The ARN (Amazon Resource Name) of the function.</p>', 'TagResourceRequest$Resource' => '<p>The ARN (Amazon Resource Name) of the Lambda function.</p>', 'UntagResourceRequest$Resource' => '<p>The ARN (Amazon Resource Name) of the function.</p>', ], ], 'FunctionCode' => [ 'base' => '<p>The code for the Lambda function.</p>', 'refs' => [ 'CreateFunctionRequest$Code' => '<p>The code for the Lambda function.</p>', ], ], 'FunctionCodeLocation' => [ 'base' => '<p>The object for the Lambda function location.</p>', 'refs' => [ 'GetFunctionResponse$Code' => NULL, ], ], 'FunctionConfiguration' => [ 'base' => '<p>A complex type that describes function metadata.</p>', 'refs' => [ 'FunctionList$member' => NULL, 'GetFunctionResponse$Configuration' => NULL, ], ], 'FunctionList' => [ 'base' => NULL, 'refs' => [ 'ListFunctionsResponse$Functions' => '<p>A list of Lambda functions.</p>', 'ListVersionsByFunctionResponse$Versions' => '<p>A list of Lambda function versions.</p>', ], ], 'FunctionName' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$FunctionName' => '<p>Name of the Lambda function whose resource policy you are updating by adding a new permission.</p> <p> You can specify a function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). AWS Lambda also allows you to specify partial ARN (for example, <code>account-id:Thumbnail</code>). Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length. </p>', 'CreateAliasRequest$FunctionName' => '<p>Name of the Lambda function for which you want to create an alias. Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'CreateEventSourceMappingRequest$FunctionName' => '<p>The Lambda function to invoke when AWS Lambda detects an event on the stream.</p> <p> You can specify the function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). </p> <p> If you are using versioning, you can also provide a qualified function ARN (ARN that is qualified with function version or alias name as suffix). For more information about versioning, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a> </p> <p>AWS Lambda also allows you to specify only the function name with the account ID qualifier (for example, <code>account-id:Thumbnail</code>). </p> <p>Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'CreateFunctionRequest$FunctionName' => '<p>The name you want to assign to the function you are uploading. The function names appear in the console and are returned in the <a>ListFunctions</a> API. Function names are used to specify functions to other AWS Lambda API operations, such as <a>Invoke</a>. Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length. </p>', 'DeleteAliasRequest$FunctionName' => '<p>The Lambda function name for which the alias is created. Deleting an alias does not delete the function version to which it is pointing. Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'DeleteFunctionRequest$FunctionName' => '<p>The Lambda function to delete.</p> <p> You can specify the function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). If you are using versioning, you can also provide a qualified function ARN (ARN that is qualified with function version or alias name as suffix). AWS Lambda also allows you to specify only the function name with the account ID qualifier (for example, <code>account-id:Thumbnail</code>). Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length. </p>', 'GetAliasRequest$FunctionName' => '<p>Function name for which the alias is created. An alias is a subresource that exists only in the context of an existing Lambda function so you must specify the function name. Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'ListAliasesRequest$FunctionName' => '<p>Lambda function name for which the alias is created. Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'ListEventSourceMappingsRequest$FunctionName' => '<p>The name of the Lambda function.</p> <p> You can specify the function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). If you are using versioning, you can also provide a qualified function ARN (ARN that is qualified with function version or alias name as suffix). AWS Lambda also allows you to specify only the function name with the account ID qualifier (for example, <code>account-id:Thumbnail</code>). Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length. </p>', 'PublishVersionRequest$FunctionName' => '<p>The Lambda function name. You can specify a function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). AWS Lambda also allows you to specify a partial ARN (for example, <code>account-id:Thumbnail</code>). Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length. </p>', 'RemovePermissionRequest$FunctionName' => '<p>Lambda function whose resource policy you want to remove a permission from.</p> <p> You can specify a function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). AWS Lambda also allows you to specify a partial ARN (for example, <code>account-id:Thumbnail</code>). Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length. </p>', 'UpdateAliasRequest$FunctionName' => '<p>The function name for which the alias is created. Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'UpdateEventSourceMappingRequest$FunctionName' => '<p>The Lambda function to which you want the stream records sent.</p> <p> You can specify a function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). AWS Lambda also allows you to specify a partial ARN (for example, <code>account-id:Thumbnail</code>). Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length. </p> <p>If you are using versioning, you can also provide a qualified function ARN (ARN that is qualified with function version or alias name as suffix). For more information about versioning, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and Aliases</a> </p> <p>Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 character in length.</p>', 'UpdateFunctionCodeRequest$FunctionName' => '<p>The existing Lambda function name whose code you want to replace.</p> <p> You can specify a function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). AWS Lambda also allows you to specify a partial ARN (for example, <code>account-id:Thumbnail</code>). Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length. </p>', 'UpdateFunctionConfigurationRequest$FunctionName' => '<p>The name of the Lambda function.</p> <p> You can specify a function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). AWS Lambda also allows you to specify a partial ARN (for example, <code>account-id:Thumbnail</code>). Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 character in length. </p>', ], ], 'FunctionVersion' => [ 'base' => NULL, 'refs' => [ 'ListFunctionsRequest$FunctionVersion' => '<p>Optional string. If not specified, only the unqualified functions ARNs (Amazon Resource Names) will be returned.</p> <p>Valid value:</p> <p> <code>ALL</code> _ Will return all versions, including <code>$LATEST</code> which will have fully qualified ARNs (Amazon Resource Names).</p>', ], ], 'GetAccountSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccountSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEventSourceMappingRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'GetFunctionConfigurationRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'GetFunctionRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'GetFunctionResponse' => [ 'base' => '<p>This response contains the object for the Lambda function location (see <a>FunctionCodeLocation</a>.</p>', 'refs' => [], ], 'GetPolicyRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'GetPolicyResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'Handler' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Handler' => '<p>The function within your code that Lambda calls to begin execution. For Node.js, it is the <i>module-name</i>.<i>export</i> value in your function. For Java, it can be <code>package.class-name::handler</code> or <code>package.class-name</code>. For more information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/java-programming-model-handler-types.html">Lambda Function Handler (Java)</a>. </p>', 'FunctionConfiguration$Handler' => '<p>The function Lambda calls to begin executing your function.</p>', 'UpdateFunctionConfigurationRequest$Handler' => '<p>The function that Lambda calls to begin executing your function. For Node.js, it is the <code>module-name.export</code> value in your function. </p>', ], ], 'HttpStatus' => [ 'base' => NULL, 'refs' => [ 'InvokeAsyncResponse$Status' => '<p>It will be 202 upon success.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AccountLimit$ConcurrentExecutions' => '<p>Number of simultaneous executions of your function per region. For more information or to request a limit increase for concurrent executions, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Lambda Function Concurrent Executions</a>. The default limit is 100.</p>', 'InvocationResponse$StatusCode' => '<p>The HTTP status code will be in the 200 range for successful request. For the <code>RequestResponse</code> invocation type this status code will be 200. For the <code>Event</code> invocation type this status code will be 202. For the <code>DryRun</code> invocation type the status code will be 204. </p>', ], ], 'InvalidParameterValueException' => [ 'base' => '<p>One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this exception. You will also get this exception if you have selected a deprecated runtime, such as Node v0.10.42. </p>', 'refs' => [], ], 'InvalidRequestContentException' => [ 'base' => '<p>The request body could not be parsed as JSON.</p>', 'refs' => [], ], 'InvalidRuntimeException' => [ 'base' => '<p>The runtime or runtime version specified is not supported.</p>', 'refs' => [], ], 'InvalidSecurityGroupIDException' => [ 'base' => '<p>The Security Group ID provided in the Lambda function VPC configuration is invalid.</p>', 'refs' => [], ], 'InvalidSubnetIDException' => [ 'base' => '<p>The Subnet ID provided in the Lambda function VPC configuration is invalid.</p>', 'refs' => [], ], 'InvalidZipFileException' => [ 'base' => '<p>AWS Lambda could not unzip the function zip file.</p>', 'refs' => [], ], 'InvocationRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'InvocationResponse' => [ 'base' => '<p>Upon success, returns an empty response. Otherwise, throws an exception.</p>', 'refs' => [], ], 'InvocationType' => [ 'base' => NULL, 'refs' => [ 'InvocationRequest$InvocationType' => '<p>By default, the <code>Invoke</code> API assumes <code>RequestResponse</code> invocation type. You can optionally request asynchronous execution by specifying <code>Event</code> as the <code>InvocationType</code>. You can also use this parameter to request AWS Lambda to not execute the function but do some verification, such as if the caller is authorized to invoke the function and if the inputs are valid. You request this by specifying <code>DryRun</code> as the <code>InvocationType</code>. This is useful in a cross-account scenario when you want to verify access to a function without running it. </p>', ], ], 'InvokeAsyncRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'InvokeAsyncResponse' => [ 'base' => '<p>Upon success, it returns empty response. Otherwise, throws an exception.</p>', 'refs' => [], ], 'KMSAccessDeniedException' => [ 'base' => '<p>Lambda was unable to decrypt the environment variables because KMS access was denied. Check the Lambda function\'s KMS permissions.</p>', 'refs' => [], ], 'KMSDisabledException' => [ 'base' => '<p>Lambda was unable to decrypt the environment variables because the KMS key used is disabled. Check the Lambda function\'s KMS key settings.</p>', 'refs' => [], ], 'KMSInvalidStateException' => [ 'base' => '<p>Lambda was unable to decrypt the environment variables because the KMS key used is in an invalid state for Decrypt. Check the function\'s KMS key settings.</p>', 'refs' => [], ], 'KMSKeyArn' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$KMSKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key used to encrypt your function\'s environment variables. If not provided, AWS Lambda will use a default service key.</p>', 'FunctionConfiguration$KMSKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key used to encrypt your function\'s environment variables. If empty, it means you are using the AWS Lambda default service key.</p>', 'UpdateFunctionConfigurationRequest$KMSKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key used to encrypt your function\'s environment variables. If you elect to use the AWS Lambda default service key, pass in an empty string ("") for this parameter.</p>', ], ], 'KMSNotFoundException' => [ 'base' => '<p>Lambda was unable to decrypt the environment variables because the KMS key was not found. Check the function\'s KMS key settings. </p>', 'refs' => [], ], 'ListAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEventSourceMappingsRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'ListEventSourceMappingsResponse' => [ 'base' => '<p>Contains a list of event sources (see <a>EventSourceMappingConfiguration</a>)</p>', 'refs' => [], ], 'ListFunctionsRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'ListFunctionsResponse' => [ 'base' => '<p>Contains a list of AWS Lambda function configurations (see <a>FunctionConfiguration</a>.</p>', 'refs' => [], ], 'ListTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVersionsByFunctionRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'ListVersionsByFunctionResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'LogType' => [ 'base' => NULL, 'refs' => [ 'InvocationRequest$LogType' => '<p>You can set this optional parameter to <code>Tail</code> in the request only if you specify the <code>InvocationType</code> parameter with value <code>RequestResponse</code>. In this case, AWS Lambda returns the base64-encoded last 4 KB of log data produced by your Lambda function in the <code>x-amz-log-result</code> header. </p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AccountLimit$TotalCodeSize' => '<p>Maximum size, in bytes, of a code package you can upload per region. The default size is 75 GB. </p>', 'AccountLimit$CodeSizeUnzipped' => '<p>Size, in bytes, of code/dependencies that you can zip into a deployment package (uncompressed zip/jar size) for uploading. The default limit is 250 MB.</p>', 'AccountLimit$CodeSizeZipped' => '<p>Size, in bytes, of a single zipped code/dependencies package you can upload for your Lambda function(.zip/.jar file). Try using Amazon S3 for uploading larger files. Default limit is 50 MB.</p>', 'AccountUsage$TotalCodeSize' => '<p>Total size, in bytes, of the account\'s deployment packages per region.</p>', 'AccountUsage$FunctionCount' => '<p>The number of your account\'s existing functions per region.</p>', 'FunctionConfiguration$CodeSize' => '<p>The size, in bytes, of the function .zip file you uploaded.</p>', ], ], 'MasterRegion' => [ 'base' => NULL, 'refs' => [ 'ListFunctionsRequest$MasterRegion' => '<p>Optional string. If not specified, will return only regular function versions (i.e., non-replicated versions).</p> <p>Valid values are:</p> <p>The region from which the functions are replicated. For example, if you specify <code>us-east-1</code>, only functions replicated from that region will be returned.</p> <p> <code>ALL</code> _ Will return all functions from any region. If specified, you also must specify a valid FunctionVersion parameter.</p>', ], ], 'MaxListItems' => [ 'base' => NULL, 'refs' => [ 'ListAliasesRequest$MaxItems' => '<p>Optional integer. Specifies the maximum number of aliases to return in response. This parameter value must be greater than 0.</p>', 'ListEventSourceMappingsRequest$MaxItems' => '<p>Optional integer. Specifies the maximum number of event sources to return in response. This value must be greater than 0.</p>', 'ListFunctionsRequest$MaxItems' => '<p>Optional integer. Specifies the maximum number of AWS Lambda functions to return in response. This parameter value must be greater than 0.</p>', 'ListVersionsByFunctionRequest$MaxItems' => '<p>Optional integer. Specifies the maximum number of AWS Lambda function versions to return in response. This parameter value must be greater than 0.</p>', ], ], 'MemorySize' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$MemorySize' => '<p>The amount of memory, in MB, your Lambda function is given. Lambda uses this memory size to infer the amount of CPU and memory allocated to your function. Your function use-case determines your CPU and memory requirements. For example, a database operation might need less memory compared to an image processing function. The default value is 128 MB. The value must be a multiple of 64 MB.</p>', 'FunctionConfiguration$MemorySize' => '<p>The memory size, in MB, you configured for the function. Must be a multiple of 64 MB.</p>', 'UpdateFunctionConfigurationRequest$MemorySize' => '<p>The amount of memory, in MB, your Lambda function is given. AWS Lambda uses this memory size to infer the amount of CPU allocated to your function. Your function use-case determines your CPU and memory requirements. For example, a database operation might need less memory compared to an image processing function. The default value is 128 MB. The value must be a multiple of 64 MB.</p>', ], ], 'NameSpacedFunctionArn' => [ 'base' => NULL, 'refs' => [ 'FunctionConfiguration$FunctionArn' => '<p>The Amazon Resource Name (ARN) assigned to the function.</p>', ], ], 'NamespacedFunctionName' => [ 'base' => NULL, 'refs' => [ 'FunctionConfiguration$FunctionName' => '<p>The name of the function. Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'GetFunctionConfigurationRequest$FunctionName' => '<p>The name of the Lambda function for which you want to retrieve the configuration information.</p> <p> You can specify a function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). AWS Lambda also allows you to specify a partial ARN (for example, <code>account-id:Thumbnail</code>). Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length. </p>', 'GetFunctionRequest$FunctionName' => '<p>The Lambda function name.</p> <p> You can specify a function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). AWS Lambda also allows you to specify a partial ARN (for example, <code>account-id:Thumbnail</code>). Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length. </p>', 'GetPolicyRequest$FunctionName' => '<p>Function name whose resource policy you want to retrieve.</p> <p> You can specify the function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). If you are using versioning, you can also provide a qualified function ARN (ARN that is qualified with function version or alias name as suffix). AWS Lambda also allows you to specify only the function name with the account ID qualifier (for example, <code>account-id:Thumbnail</code>). Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length. </p>', 'InvocationRequest$FunctionName' => '<p>The Lambda function name.</p> <p> You can specify a function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). AWS Lambda also allows you to specify a partial ARN (for example, <code>account-id:Thumbnail</code>). Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length. </p>', 'InvokeAsyncRequest$FunctionName' => '<p>The Lambda function name. Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'ListVersionsByFunctionRequest$FunctionName' => '<p>Function name whose versions to list. You can specify a function name (for example, <code>Thumbnail</code>) or you can specify Amazon Resource Name (ARN) of the function (for example, <code>arn:aws:lambda:us-west-2:account-id:function:ThumbNail</code>). AWS Lambda also allows you to specify a partial ARN (for example, <code>account-id:Thumbnail</code>). Note that the length constraint applies only to the ARN. If you specify only the function name, it is limited to 64 characters in length. </p>', ], ], 'NamespacedStatementId' => [ 'base' => NULL, 'refs' => [ 'RemovePermissionRequest$StatementId' => '<p>Statement ID of the permission to remove.</p>', ], ], 'PolicyLengthExceededException' => [ 'base' => '<p>Lambda function access policy is limited to 20 KB.</p>', 'refs' => [], ], 'Principal' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$Principal' => '<p>The principal who is getting this permission. It can be Amazon S3 service Principal (<code>s3.amazonaws.com</code>) if you want Amazon S3 to invoke the function, an AWS account ID if you are granting cross-account permission, or any valid AWS service principal such as <code>sns.amazonaws.com</code>. For example, you might want to allow a custom application in another AWS account to push events to AWS Lambda by invoking your function. </p>', ], ], 'PublishVersionRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'Qualifier' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$Qualifier' => '<p>You can use this optional query parameter to describe a qualified ARN using a function version or an alias name. The permission will then apply to the specific qualified ARN. For example, if you specify function version 2 as the qualifier, then permission applies only when request is made using qualified function ARN:</p> <p> <code>arn:aws:lambda:aws-region:acct-id:function:function-name:2</code> </p> <p>If you specify an alias name, for example <code>PROD</code>, then the permission is valid only for requests made using the alias ARN:</p> <p> <code>arn:aws:lambda:aws-region:acct-id:function:function-name:PROD</code> </p> <p>If the qualifier is not specified, the permission is valid only when requests is made using unqualified function ARN.</p> <p> <code>arn:aws:lambda:aws-region:acct-id:function:function-name</code> </p>', 'DeleteFunctionRequest$Qualifier' => '<p>Using this optional parameter you can specify a function version (but not the <code>$LATEST</code> version) to direct AWS Lambda to delete a specific function version. If the function version has one or more aliases pointing to it, you will get an error because you cannot have aliases pointing to it. You can delete any function version but not the <code>$LATEST</code>, that is, you cannot specify <code>$LATEST</code> as the value of this parameter. The <code>$LATEST</code> version can be deleted only when you want to delete all the function versions and aliases.</p> <p>You can only specify a function version, not an alias name, using this parameter. You cannot delete a function version using its alias.</p> <p>If you don\'t specify this parameter, AWS Lambda will delete the function, including all of its versions and aliases.</p>', 'GetFunctionConfigurationRequest$Qualifier' => '<p>Using this optional parameter you can specify a function version or an alias name. If you specify function version, the API uses qualified function ARN and returns information about the specific function version. If you specify an alias name, the API uses the alias ARN and returns information about the function version to which the alias points.</p> <p>If you don\'t specify this parameter, the API uses unqualified function ARN, and returns information about the <code>$LATEST</code> function version.</p>', 'GetFunctionRequest$Qualifier' => '<p>Using this optional parameter to specify a function version or an alias name. If you specify function version, the API uses qualified function ARN for the request and returns information about the specific Lambda function version. If you specify an alias name, the API uses the alias ARN and returns information about the function version to which the alias points. If you don\'t provide this parameter, the API uses unqualified function ARN and returns information about the <code>$LATEST</code> version of the Lambda function.</p>', 'GetPolicyRequest$Qualifier' => '<p>You can specify this optional query parameter to specify a function version or an alias name in which case this API will return all permissions associated with the specific qualified ARN. If you don\'t provide this parameter, the API will return permissions that apply to the unqualified function ARN.</p>', 'InvocationRequest$Qualifier' => '<p>You can use this optional parameter to specify a Lambda function version or alias name. If you specify a function version, the API uses the qualified function ARN to invoke a specific Lambda function. If you specify an alias name, the API uses the alias ARN to invoke the Lambda function version to which the alias points.</p> <p>If you don\'t provide this parameter, then the API uses unqualified function ARN which results in invocation of the <code>$LATEST</code> version.</p>', 'RemovePermissionRequest$Qualifier' => '<p>You can specify this optional parameter to remove permission associated with a specific function version or function alias. If you don\'t specify this parameter, the API removes permission associated with the unqualified function ARN.</p>', ], ], 'RemovePermissionRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'RequestTooLargeException' => [ 'base' => '<p>The request payload exceeded the <code>Invoke</code> request body JSON input limit. For more information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>. </p>', 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'DeadLetterConfig$TargetArn' => '<p>The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic you specify as your Dead Letter Queue (DLQ).</p>', ], ], 'ResourceConflictException' => [ 'base' => '<p>The resource already exists.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource (for example, a Lambda function or access policy statement) specified in the request does not exist.</p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Role' => '<p>The Amazon Resource Name (ARN) of the IAM role that Lambda assumes when it executes your function to access any other Amazon Web Services (AWS) resources. For more information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html">AWS Lambda: How it Works</a>. </p>', 'FunctionConfiguration$Role' => '<p>The Amazon Resource Name (ARN) of the IAM role that Lambda assumes when it executes your function to access any other Amazon Web Services (AWS) resources.</p>', 'UpdateFunctionConfigurationRequest$Role' => '<p>The Amazon Resource Name (ARN) of the IAM role that Lambda will assume when it executes your function.</p>', ], ], 'Runtime' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Runtime' => '<p>The runtime environment for the Lambda function you are uploading.</p> <p>To use the Python runtime v3.6, set the value to "python3.6". To use the Python runtime v2.7, set the value to "python2.7". To use the Node.js runtime v6.10, set the value to "nodejs6.10". To use the Node.js runtime v4.3, set the value to "nodejs4.3".</p> <note> <p>Node v0.10.42 is currently marked as deprecated. You must migrate existing functions to the newer Node.js runtime versions available on AWS Lambda (nodejs4.3 or nodejs6.10) as soon as possible. You can request a one-time extension until June 30, 2017 by going to the Lambda console and following the instructions provided. Failure to do so will result in an invalid parmaeter error being returned. Note that you will have to follow this procedure for each region that contains functions written in the Node v0.10.42 runtime.</p> </note>', 'FunctionConfiguration$Runtime' => '<p>The runtime environment for the Lambda function.</p>', 'UpdateFunctionConfigurationRequest$Runtime' => '<p>The runtime environment for the Lambda function.</p> <p>To use the Python runtime v3.6, set the value to "python3.6". To use the Python runtime v2.7, set the value to "python2.7". To use the Node.js runtime v6.10, set the value to "nodejs6.10". To use the Node.js runtime v4.3, set the value to "nodejs4.3". To use the Python runtime v3.6, set the value to "python3.6".</p> <note> <p>Node v0.10.42 is currently marked as deprecated. You must migrate existing functions to the newer Node.js runtime versions available on AWS Lambda (nodejs4.3 or nodejs6.10) as soon as possible. You can request a one-time extension until June 30, 2017 by going to the Lambda console and following the instructions provided. Failure to do so will result in an invalid parameter error being returned. Note that you will have to follow this procedure for each region that contains functions written in the Node v0.10.42 runtime.</p> </note>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'FunctionCode$S3Bucket' => '<p>Amazon S3 bucket name where the .zip file containing your deployment package is stored. This bucket must reside in the same AWS region where you are creating the Lambda function.</p>', 'UpdateFunctionCodeRequest$S3Bucket' => '<p>Amazon S3 bucket name where the .zip file containing your deployment package is stored. This bucket must reside in the same AWS Region where you are creating the Lambda function.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'FunctionCode$S3Key' => '<p>The Amazon S3 object (the deployment package) key name you want to upload.</p>', 'UpdateFunctionCodeRequest$S3Key' => '<p>The Amazon S3 object (the deployment package) key name you want to upload.</p>', ], ], 'S3ObjectVersion' => [ 'base' => NULL, 'refs' => [ 'FunctionCode$S3ObjectVersion' => '<p>The Amazon S3 object (the deployment package) version you want to upload.</p>', 'UpdateFunctionCodeRequest$S3ObjectVersion' => '<p>The Amazon S3 object (the deployment package) version you want to upload.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfig$SecurityGroupIds' => '<p>A list of one or more security groups IDs in your VPC.</p>', 'VpcConfigResponse$SecurityGroupIds' => '<p>A list of security group IDs associated with the Lambda function.</p>', ], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'EnvironmentError$Message' => '<p>The message returned by the environment error object.</p>', ], ], 'ServiceException' => [ 'base' => '<p>The AWS Lambda service encountered an internal error.</p>', 'refs' => [], ], 'SourceOwner' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$SourceAccount' => '<p>This parameter is used for S3 and SES. The AWS account ID (without a hyphen) of the source owner. For example, if the <code>SourceArn</code> identifies a bucket, then this is the bucket owner\'s account ID. You can use this additional condition to ensure the bucket you specify is owned by a specific account (it is possible the bucket owner deleted the bucket and some other AWS account created the bucket). You can also use this condition to specify all sources (that is, you don\'t specify the <code>SourceArn</code>) owned by a specific account. </p>', ], ], 'StatementId' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$StatementId' => '<p>A unique statement identifier.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AddPermissionResponse$Statement' => '<p>The permission statement you specified in the request. The response returns the same as a string using a backslash ("\\") as an escape character in the JSON.</p>', 'CodeStorageExceededException$Type' => '<p/>', 'CodeStorageExceededException$message' => NULL, 'DeleteEventSourceMappingRequest$UUID' => '<p>The event source mapping ID.</p>', 'EC2AccessDeniedException$Type' => NULL, 'EC2AccessDeniedException$Message' => NULL, 'EC2ThrottledException$Type' => NULL, 'EC2ThrottledException$Message' => NULL, 'EC2UnexpectedException$Type' => NULL, 'EC2UnexpectedException$Message' => NULL, 'EC2UnexpectedException$EC2ErrorCode' => NULL, 'ENILimitReachedException$Type' => NULL, 'ENILimitReachedException$Message' => NULL, 'EnvironmentError$ErrorCode' => '<p>The error code returned by the environment error object.</p>', 'EventSourceMappingConfiguration$UUID' => '<p>The AWS Lambda assigned opaque identifier for the mapping.</p>', 'EventSourceMappingConfiguration$LastProcessingResult' => '<p>The result of the last AWS Lambda invocation of your Lambda function.</p>', 'EventSourceMappingConfiguration$State' => '<p>The state of the event source mapping. It can be <code>Creating</code>, <code>Enabled</code>, <code>Disabled</code>, <code>Enabling</code>, <code>Disabling</code>, <code>Updating</code>, or <code>Deleting</code>.</p>', 'EventSourceMappingConfiguration$StateTransitionReason' => '<p>The reason the event source mapping is in its current state. It is either user-requested or an AWS Lambda-initiated state transition.</p>', 'FunctionCodeLocation$RepositoryType' => '<p>The repository from which you can download the function.</p>', 'FunctionCodeLocation$Location' => '<p>The presigned URL you can use to download the function\'s .zip file that you previously uploaded. The URL is valid for up to 10 minutes.</p>', 'FunctionConfiguration$CodeSha256' => '<p>It is the SHA256 hash of your function deployment package.</p>', 'GetEventSourceMappingRequest$UUID' => '<p>The AWS Lambda assigned ID of the event source mapping.</p>', 'GetPolicyResponse$Policy' => '<p>The resource policy associated with the specified function. The response returns the same as a string using a backslash ("\\") as an escape character in the JSON.</p>', 'InvalidParameterValueException$Type' => '<p/>', 'InvalidParameterValueException$message' => '<p/>', 'InvalidRequestContentException$Type' => '<p/>', 'InvalidRequestContentException$message' => '<p/>', 'InvalidRuntimeException$Type' => NULL, 'InvalidRuntimeException$Message' => NULL, 'InvalidSecurityGroupIDException$Type' => NULL, 'InvalidSecurityGroupIDException$Message' => NULL, 'InvalidSubnetIDException$Type' => NULL, 'InvalidSubnetIDException$Message' => NULL, 'InvalidZipFileException$Type' => NULL, 'InvalidZipFileException$Message' => NULL, 'InvocationRequest$ClientContext' => '<p>Using the <code>ClientContext</code> you can pass client-specific information to the Lambda function you are invoking. You can then process the client information in your Lambda function as you choose through the context variable. For an example of a <code>ClientContext</code> JSON, see <a href="http://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html">PutEvents</a> in the <i>Amazon Mobile Analytics API Reference and User Guide</i>.</p> <p>The ClientContext JSON must be base64-encoded.</p>', 'InvocationResponse$FunctionError' => '<p>Indicates whether an error occurred while executing the Lambda function. If an error occurred this field will have one of two values; <code>Handled</code> or <code>Unhandled</code>. <code>Handled</code> errors are errors that are reported by the function while the <code>Unhandled</code> errors are those detected and reported by AWS Lambda. Unhandled errors include out of memory errors and function timeouts. For information about how to report an <code>Handled</code> error, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/programming-model.html">Programming Model</a>. </p>', 'InvocationResponse$LogResult' => '<p> It is the base64-encoded logs for the Lambda function invocation. This is present only if the invocation type is <code>RequestResponse</code> and the logs were requested. </p>', 'KMSAccessDeniedException$Type' => NULL, 'KMSAccessDeniedException$Message' => NULL, 'KMSDisabledException$Type' => NULL, 'KMSDisabledException$Message' => NULL, 'KMSInvalidStateException$Type' => NULL, 'KMSInvalidStateException$Message' => NULL, 'KMSNotFoundException$Type' => NULL, 'KMSNotFoundException$Message' => NULL, 'ListAliasesRequest$Marker' => '<p>Optional string. An opaque pagination token returned from a previous <code>ListAliases</code> operation. If present, indicates where to continue the listing.</p>', 'ListAliasesResponse$NextMarker' => '<p>A string, present if there are more aliases.</p>', 'ListEventSourceMappingsRequest$Marker' => '<p>Optional string. An opaque pagination token returned from a previous <code>ListEventSourceMappings</code> operation. If present, specifies to continue the list from where the returning call left off. </p>', 'ListEventSourceMappingsResponse$NextMarker' => '<p>A string, present if there are more event source mappings.</p>', 'ListFunctionsRequest$Marker' => '<p>Optional string. An opaque pagination token returned from a previous <code>ListFunctions</code> operation. If present, indicates where to continue the listing. </p>', 'ListFunctionsResponse$NextMarker' => '<p>A string, present if there are more functions.</p>', 'ListVersionsByFunctionRequest$Marker' => '<p> Optional string. An opaque pagination token returned from a previous <code>ListVersionsByFunction</code> operation. If present, indicates where to continue the listing. </p>', 'ListVersionsByFunctionResponse$NextMarker' => '<p>A string, present if there are more function versions.</p>', 'PolicyLengthExceededException$Type' => NULL, 'PolicyLengthExceededException$message' => NULL, 'PublishVersionRequest$CodeSha256' => '<p>The SHA256 hash of the deployment package you want to publish. This provides validation on the code you are publishing. If you provide this parameter value must match the SHA256 of the $LATEST version for the publication to succeed.</p>', 'RequestTooLargeException$Type' => NULL, 'RequestTooLargeException$message' => NULL, 'ResourceConflictException$Type' => '<p/>', 'ResourceConflictException$message' => '<p/>', 'ResourceNotFoundException$Type' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceException$Type' => NULL, 'ServiceException$Message' => NULL, 'SubnetIPAddressLimitReachedException$Type' => NULL, 'SubnetIPAddressLimitReachedException$Message' => NULL, 'TooManyRequestsException$retryAfterSeconds' => '<p>The number of seconds the caller should wait before retrying.</p>', 'TooManyRequestsException$Type' => NULL, 'TooManyRequestsException$message' => NULL, 'UnsupportedMediaTypeException$Type' => NULL, 'UnsupportedMediaTypeException$message' => NULL, 'UpdateEventSourceMappingRequest$UUID' => '<p>The event source mapping identifier.</p>', ], ], 'SubnetIPAddressLimitReachedException' => [ 'base' => '<p>AWS Lambda was not able to set up VPC access for the Lambda function because one or more configured subnets has no available IP addresses.</p>', 'refs' => [], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIds$member' => NULL, ], ], 'SubnetIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfig$SubnetIds' => '<p>A list of one or more subnet IDs in your VPC.</p>', 'VpcConfigResponse$SubnetIds' => '<p>A list of subnet IDs associated with the Lambda function.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The list of tag keys to be deleted from the function.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Tags' => '<p>The list of tags (key-value pairs) assigned to the new function.</p>', 'GetFunctionResponse$Tags' => '<p>Returns the list of tags associated with the function.</p>', 'ListTagsResponse$Tags' => '<p>The list of tags assigned to the function.</p>', 'TagResourceRequest$Tags' => '<p>The list of tags (key-value pairs) you are assigning to the Lambda function.</p>', ], ], 'ThrottleReason' => [ 'base' => NULL, 'refs' => [ 'TooManyRequestsException$Reason' => NULL, ], ], 'Timeout' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Timeout' => '<p>The function execution time at which Lambda should terminate the function. Because the execution time has cost implications, we recommend you set this value based on your expected execution time. The default is 3 seconds.</p>', 'FunctionConfiguration$Timeout' => '<p>The function execution time at which Lambda should terminate the function. Because the execution time has cost implications, we recommend you set this value based on your expected execution time. The default is 3 seconds.</p>', 'UpdateFunctionConfigurationRequest$Timeout' => '<p>The function execution time at which AWS Lambda should terminate the function. Because the execution time has cost implications, we recommend you set this value based on your expected execution time. The default is 3 seconds.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'FunctionConfiguration$LastModified' => '<p>The time stamp of the last time you updated the function. The time stamp is conveyed as a string complying with ISO-8601 in this way YYYY-MM-DDThh:mm:ssTZD (e.g., 1997-07-16T19:20:30+01:00). For more information, see <a href="https://www.w3.org/TR/NOTE-datetime">Date and Time Formats</a>.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p/>', 'refs' => [], ], 'TracingConfig' => [ 'base' => '<p>The parent object that contains your function\'s tracing settings.</p>', 'refs' => [ 'CreateFunctionRequest$TracingConfig' => '<p>The parent object that contains your function\'s tracing settings.</p>', 'UpdateFunctionConfigurationRequest$TracingConfig' => '<p>The parent object that contains your function\'s tracing settings.</p>', ], ], 'TracingConfigResponse' => [ 'base' => '<p>Parent object of the tracing information associated with your Lambda function.</p>', 'refs' => [ 'FunctionConfiguration$TracingConfig' => '<p>The parent object that contains your function\'s tracing settings.</p>', ], ], 'TracingMode' => [ 'base' => NULL, 'refs' => [ 'TracingConfig$Mode' => '<p>Can be either PassThrough or Active. If PassThrough, Lambda will only trace the request from an upstream service if it contains a tracing header with "sampled=1". If Active, Lambda will respect any tracing header it receives from an upstream service. If no tracing header is received, Lambda will call X-Ray for a tracing decision.</p>', 'TracingConfigResponse$Mode' => '<p>The tracing mode associated with your Lambda function.</p>', ], ], 'UnsupportedMediaTypeException' => [ 'base' => '<p>The content type of the <code>Invoke</code> request body is not JSON.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventSourceMappingRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'UpdateFunctionCodeRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'UpdateFunctionConfigurationRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'AliasConfiguration$FunctionVersion' => '<p>Function version to which the alias points.</p>', 'CreateAliasRequest$FunctionVersion' => '<p>Lambda function version for which you are creating the alias.</p>', 'FunctionConfiguration$Version' => '<p>The version of the Lambda function.</p>', 'ListAliasesRequest$FunctionVersion' => '<p>If you specify this optional parameter, the API returns only the aliases that are pointing to the specific Lambda function version, otherwise the API returns all of the aliases created for the Lambda function.</p>', 'UpdateAliasRequest$FunctionVersion' => '<p>Using this parameter you can change the Lambda function version to which the alias points.</p>', ], ], 'VpcConfig' => [ 'base' => '<p>If your Lambda function accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and one subnet ID.</p>', 'refs' => [ 'CreateFunctionRequest$VpcConfig' => '<p>If your Lambda function accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and one subnet ID.</p>', 'UpdateFunctionConfigurationRequest$VpcConfig' => NULL, ], ], 'VpcConfigResponse' => [ 'base' => '<p>VPC configuration associated with your Lambda function.</p>', 'refs' => [ 'FunctionConfiguration$VpcConfig' => '<p>VPC configuration associated with your Lambda function.</p>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'VpcConfigResponse$VpcId' => '<p>The VPC ID associated with you Lambda function.</p>', ], ], ],];
