<?php
// This file was auto-generated from sdk-root/src/data/lex-models/2017-04-19/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Lex Build-Time Actions</fullname> <p> Amazon Lex is an AWS service for building conversational voice and text interfaces. Use these actions to create, update, and delete conversational bots for new and existing client applications. </p>', 'operations' => [ 'CreateBotVersion' => '<p>Creates a new version of the bot based on the <code>$LATEST</code> version. If the <code>$LATEST</code> version of this resource hasn\'t changed since you created the last version, Amazon Lex doesn\'t create a new version. It returns the last created version.</p> <note> <p>You can update only the <code>$LATEST</code> version of the bot. You can\'t update the numbered versions that you create with the <code>CreateBotVersion</code> operation.</p> </note> <p> When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For more information, see <a>versioning-intro</a>. </p> <p> This operation requires permission for the <code>lex:CreateBotVersion</code> action. </p>', 'CreateIntentVersion' => '<p>Creates a new version of an intent based on the <code>$LATEST</code> version of the intent. If the <code>$LATEST</code> version of this intent hasn\'t changed since you last updated it, Amazon Lex doesn\'t create a new version. It returns the last version you created.</p> <note> <p>You can update only the <code>$LATEST</code> version of the intent. You can\'t update the numbered versions that you create with the <code>CreateIntentVersion</code> operation.</p> </note> <p> When you create a version of an intent, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For more information, see <a>versioning-intro</a>. </p> <p>This operation requires permissions to perform the <code>lex:CreateIntentVersion</code> action. </p>', 'CreateSlotTypeVersion' => '<p>Creates a new version of a slot type based on the <code>$LATEST</code> version of the specified slot type. If the <code>$LATEST</code> version of this resource has not changed since the last version that you created, Amazon Lex doesn\'t create a new version. It returns the last version that you created. </p> <note> <p>You can update only the <code>$LATEST</code> version of a slot type. You can\'t update the numbered versions that you create with the <code>CreateSlotTypeVersion</code> operation.</p> </note> <p>When you create a version of a slot type, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For more information, see <a>versioning-intro</a>. </p> <p>This operation requires permissions for the <code>lex:CreateSlotTypeVersion</code> action.</p>', 'DeleteBot' => '<p>Deletes all versions of the bot, including the <code>$LATEST</code> version. To delete a specific version of the bot, use the <a>DeleteBotVersion</a> operation.</p> <p>If a bot has an alias, you can\'t delete it. Instead, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code> exception that includes a reference to the alias that refers to the bot. To remove the reference to the bot, delete the alias. If you get the same exception again, delete the referring alias until the <code>DeleteBot</code> operation is successful.</p> <p>This operation requires permissions for the <code>lex:DeleteBot</code> action.</p>', 'DeleteBotAlias' => '<p>Deletes an alias for the specified bot. </p> <p>You can\'t delete an alias that is used in the association between a bot and a messaging channel. If an alias is used in a channel association, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code> exception that includes a reference to the channel association that refers to the bot. You can remove the reference to the alias by deleting the channel association. If you get the same exception again, delete the referring association until the <code>DeleteBotAlias</code> operation is successful.</p>', 'DeleteBotChannelAssociation' => '<p>Deletes the association between an Amazon Lex bot and a messaging platform.</p> <p>This operation requires permission for the <code>lex:DeleteBotChannelAssociation</code> action.</p>', 'DeleteBotVersion' => '<p>Deletes a specific version of a bot. To delete all versions of a bot, use the <a>DeleteBot</a> operation. </p> <p>This operation requires permissions for the <code>lex:DeleteBotVersion</code> action.</p>', 'DeleteIntent' => '<p>Deletes all versions of the intent, including the <code>$LATEST</code> version. To delete a specific version of the intent, use the <a>DeleteIntentVersion</a> operation.</p> <p> You can delete a version of an intent only if it is not referenced. To delete an intent that is referred to in one or more bots (see <a>how-it-works</a>), you must remove those references first. </p> <note> <p> If you get the <code>ResourceInUseException</code> exception, it provides an example reference that shows where the intent is referenced. To remove the reference to the intent, either update the bot or delete it. If you get the same exception when you attempt to delete the intent again, repeat until the intent has no references and the call to <code>DeleteIntent</code> is successful. </p> </note> <p> This operation requires permission for the <code>lex:DeleteIntent</code> action. </p>', 'DeleteIntentVersion' => '<p>Deletes a specific version of an intent. To delete all versions of a intent, use the <a>DeleteIntent</a> operation. </p> <p>This operation requires permissions for the <code>lex:DeleteIntentVersion</code> action.</p>', 'DeleteSlotType' => '<p>Deletes all versions of the slot type, including the <code>$LATEST</code> version. To delete a specific version of the slot type, use the <a>DeleteSlotTypeVersion</a> operation.</p> <p> You can delete a version of a slot type only if it is not referenced. To delete a slot type that is referred to in one or more intents, you must remove those references first. </p> <note> <p> If you get the <code>ResourceInUseException</code> exception, the exception provides an example reference that shows the intent where the slot type is referenced. To remove the reference to the slot type, either update the intent or delete it. If you get the same exception when you attempt to delete the slot type again, repeat until the slot type has no references and the <code>DeleteSlotType</code> call is successful. </p> </note> <p>This operation requires permission for the <code>lex:DeleteSlotType</code> action.</p>', 'DeleteSlotTypeVersion' => '<p>Deletes a specific version of a slot type. To delete all versions of a slot type, use the <a>DeleteSlotType</a> operation. </p> <p>This operation requires permissions for the <code>lex:DeleteSlotTypeVersion</code> action.</p>', 'DeleteUtterances' => '<p>Deletes stored utterances.</p> <p>Amazon Lex stores the utterances that users send to your bot unless the <code>childDirected</code> field in the bot is set to <code>true</code>. Utterances are stored for 15 days for use with the <a>GetUtterancesView</a> operation, and then stored indefinately for use in improving the ability of your bot to respond to user input.</p> <p>Use the <code>DeleteStoredUtterances</code> operation to manually delete stored utterances for a specific user.</p> <p>This operation requires permissions for the <code>lex:DeleteUtterances</code> action.</p>', 'GetBot' => '<p>Returns metadata information for a specific bot. You must provide the bot name and the bot version or alias. </p> <p> The GetBot operation requires permissions for the <code>lex:GetBot</code> action. </p>', 'GetBotAlias' => '<p>Returns information about an Amazon Lex bot alias. For more information about aliases, see <a>versioning-aliases</a>.</p> <p>This operation requires permissions for the <code>lex:GetBotAlias</code> action.</p>', 'GetBotAliases' => '<p>Returns a list of aliases for a specified Amazon Lex bot.</p> <p>This operation requires permissions for the <code>lex:GetBotAliases</code> action.</p>', 'GetBotChannelAssociation' => '<p>Returns information about the association between an Amazon Lex bot and a messaging platform.</p> <p>This operation requires permissions for the <code>lex:GetBotChannelAssociation</code> action.</p>', 'GetBotChannelAssociations' => '<p> Returns a list of all of the channels associated with the specified bot. </p> <p>The <code>GetBotChannelAssociations</code> operation requires permissions for the <code>lex:GetBotChannelAssociations</code> action.</p>', 'GetBotVersions' => '<p>Gets information about all of the versions of a bot.</p> <p>The <code>GetBotVersions</code> operation returns a <code>BotMetadata</code> object for each version of a bot. For example, if a bot has three numbered versions, the <code>GetBotVersions</code> operation returns four <code>BotMetadata</code> objects in the response, one for each numbered version and one for the <code>$LATEST</code> version. </p> <p>The <code>GetBotVersions</code> operation always returns at least one version, the <code>$LATEST</code> version.</p> <p>This operation requires permissions for the <code>lex:GetBotVersions</code> action.</p>', 'GetBots' => '<p>Returns bot information as follows: </p> <ul> <li> <p>If you provide the <code>nameContains</code> field, the response includes information for the <code>$LATEST</code> version of all bots whose name contains the specified string.</p> </li> <li> <p>If you don\'t specify the <code>nameContains</code> field, the operation returns information about the <code>$LATEST</code> version of all of your bots.</p> </li> </ul> <p>This operation requires permission for the <code>lex:GetBots</code> action.</p>', 'GetBuiltinIntent' => '<p>Returns information about a built-in intent.</p> <p>This operation requires permission for the <code>lex:GetBuiltinIntent</code> action.</p>', 'GetBuiltinIntents' => '<p>Gets a list of built-in intents that meet the specified criteria.</p> <p>This operation requires permission for the <code>lex:GetBuiltinIntents</code> action.</p>', 'GetBuiltinSlotTypes' => '<p>Gets a list of built-in slot types that meet the specified criteria.</p> <p>For a list of built-in slot types, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.</p> <p>This operation requires permission for the <code>lex:GetBuiltInSlotTypes</code> action.</p>', 'GetIntent' => '<p> Returns information about an intent. In addition to the intent name, you must specify the intent version. </p> <p> This operation requires permissions to perform the <code>lex:GetIntent</code> action. </p>', 'GetIntentVersions' => '<p>Gets information about all of the versions of an intent.</p> <p>The <code>GetIntentVersions</code> operation returns an <code>IntentMetadata</code> object for each version of an intent. For example, if an intent has three numbered versions, the <code>GetIntentVersions</code> operation returns four <code>IntentMetadata</code> objects in the response, one for each numbered version and one for the <code>$LATEST</code> version. </p> <p>The <code>GetIntentVersions</code> operation always returns at least one version, the <code>$LATEST</code> version.</p> <p>This operation requires permissions for the <code>lex:GetIntentVersions</code> action.</p>', 'GetIntents' => '<p>Returns intent information as follows: </p> <ul> <li> <p>If you specify the <code>nameContains</code> field, returns the <code>$LATEST</code> version of all intents that contain the specified string.</p> </li> <li> <p> If you don\'t specify the <code>nameContains</code> field, returns information about the <code>$LATEST</code> version of all intents. </p> </li> </ul> <p> The operation requires permission for the <code>lex:GetIntents</code> action. </p>', 'GetSlotType' => '<p>Returns information about a specific version of a slot type. In addition to specifying the slot type name, you must specify the slot type version.</p> <p>This operation requires permissions for the <code>lex:GetSlotType</code> action.</p>', 'GetSlotTypeVersions' => '<p>Gets information about all versions of a slot type.</p> <p>The <code>GetSlotTypeVersions</code> operation returns a <code>SlotTypeMetadata</code> object for each version of a slot type. For example, if a slot type has three numbered versions, the <code>GetSlotTypeVersions</code> operation returns four <code>SlotTypeMetadata</code> objects in the response, one for each numbered version and one for the <code>$LATEST</code> version. </p> <p>The <code>GetSlotTypeVersions</code> operation always returns at least one version, the <code>$LATEST</code> version.</p> <p>This operation requires permissions for the <code>lex:GetSlotTypeVersions</code> action.</p>', 'GetSlotTypes' => '<p>Returns slot type information as follows: </p> <ul> <li> <p>If you specify the <code>nameContains</code> field, returns the <code>$LATEST</code> version of all slot types that contain the specified string.</p> </li> <li> <p> If you don\'t specify the <code>nameContains</code> field, returns information about the <code>$LATEST</code> version of all slot types. </p> </li> </ul> <p> The operation requires permission for the <code>lex:GetSlotTypes</code> action. </p>', 'GetUtterancesView' => '<p>Use the <code>GetUtterancesView</code> operation to get information about the utterances that your users have made to your bot. You can use this list to tune the utterances that your bot responds to.</p> <p>For example, say that you have created a bot to order flowers. After your users have used your bot for a while, use the <code>GetUtterancesView</code> operation to see the requests that they have made and whether they have been successful. You might find that the utterance "I want flowers" is not being recognized. You could add this utterance to the <code>OrderFlowers</code> intent so that your bot recognizes that utterance.</p> <p>After you publish a new version of a bot, you can get information about the old version and the new so that you can compare the performance across the two versions. </p> <p>Data is available for the last 15 days. You can request information for up to 5 versions in each request. The response contains information about a maximum of 100 utterances for each version.</p> <p>If the bot\'s <code>childDirected</code> field is set to <code>true</code>, utterances for the bot are not stored and cannot be retrieved with the <code>GetUtterancesView</code> operation. For more information, see <a>PutBot</a>.</p> <p>This operation requires permissions for the <code>lex:GetUtterancesView</code> action.</p>', 'PutBot' => '<p>Creates an Amazon Lex conversational bot or replaces an existing bot. When you create or update a bot you are only required to specify a name. You can use this to add intents later, or to remove intents from an existing bot. When you create a bot with a name only, the bot is created or updated but Amazon Lex returns the <code/> response <code>FAILED</code>. You can build the bot after you add one or more intents. For more information about Amazon Lex bots, see <a>how-it-works</a>. </p> <p>If you specify the name of an existing bot, the fields in the request replace the existing values in the <code>$LATEST</code> version of the bot. Amazon Lex removes any fields that you don\'t provide values for in the request, except for the <code>idleTTLInSeconds</code> and <code>privacySettings</code> fields, which are set to their default values. If you don\'t specify values for required fields, Amazon Lex throws an exception.</p> <p>This operation requires permissions for the <code>lex:PutBot</code> action. For more information, see <a>auth-and-access-control</a>.</p>', 'PutBotAlias' => '<p>Creates an alias for the specified version of the bot or replaces an alias for the specified bot. To change the version of the bot that the alias points to, replace the alias. For more information about aliases, see <a>versioning-aliases</a>.</p> <p>This operation requires permissions for the <code>lex:PutBotAlias</code> action. </p>', 'PutIntent' => '<p>Creates an intent or replaces an existing intent.</p> <p>To define the interaction between the user and your bot, you use one or more intents. For a pizza ordering bot, for example, you would create an <code>OrderPizza</code> intent. </p> <p>To create an intent or replace an existing intent, you must provide the following:</p> <ul> <li> <p>Intent name. For example, <code>OrderPizza</code>.</p> </li> <li> <p>Sample utterances. For example, "Can I order a pizza, please." and "I want to order a pizza."</p> </li> <li> <p>Information to be gathered. You specify slot types for the information that your bot will request from the user. You can specify standard slot types, such as a date or a time, or custom slot types such as the size and crust of a pizza.</p> </li> <li> <p>How the intent will be fulfilled. You can provide a Lambda function or configure the intent to return the intent information to the client application. If you use a Lambda function, when all of the intent information is available, Amazon Lex invokes your Lambda function. If you configure your intent to return the intent information to the client application. </p> </li> </ul> <p>You can specify other optional information in the request, such as:</p> <ul> <li> <p>A confirmation prompt to ask the user to confirm an intent. For example, "Shall I order your pizza?"</p> </li> <li> <p>A conclusion statement to send to the user after the intent has been fulfilled. For example, "I placed your pizza order."</p> </li> <li> <p>A follow-up prompt that asks the user for additional activity. For example, asking "Do you want to order a drink with your pizza?"</p> </li> </ul> <p>If you specify an existing intent name to update the intent, Amazon Lex replaces the values in the <code>$LATEST</code> version of the slot type with the values in the request. Amazon Lex removes fields that you don\'t provide in the request. If you don\'t specify the required fields, Amazon Lex throws an exception.</p> <p>For more information, see <a>how-it-works</a>.</p> <p>This operation requires permissions for the <code>lex:PutIntent</code> action.</p>', 'PutSlotType' => '<p>Creates a custom slot type or replaces an existing custom slot type.</p> <p>To create a custom slot type, specify a name for the slot type and a set of enumeration values, which are the values that a slot of this type can assume. For more information, see <a>how-it-works</a>.</p> <p>If you specify the name of an existing slot type, the fields in the request replace the existing values in the <code>$LATEST</code> version of the slot type. Amazon Lex removes the fields that you don\'t provide in the request. If you don\'t specify required fields, Amazon Lex throws an exception.</p> <p>This operation requires permissions for the <code>lex:PutSlotType</code> action.</p>', ], 'shapes' => [ 'AliasName' => [ 'base' => NULL, 'refs' => [ 'BotAliasMetadata$name' => '<p>The name of the bot alias.</p>', 'BotChannelAssociation$botAlias' => '<p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made. </p>', 'DeleteBotAliasRequest$name' => '<p>The name of the alias to delete. The name is case sensitive. </p>', 'DeleteBotChannelAssociationRequest$botAlias' => '<p>An alias that points to the specific version of the Amazon Lex bot to which this association is being made.</p>', 'GetBotAliasRequest$name' => '<p>The name of the bot alias. The name is case sensitive.</p>', 'GetBotAliasResponse$name' => '<p>The name of the bot alias.</p>', 'GetBotAliasesRequest$nameContains' => '<p>Substring to match in bot alias names. An alias will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>', 'GetBotChannelAssociationRequest$botAlias' => '<p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.</p>', 'GetBotChannelAssociationResponse$botAlias' => '<p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.</p>', 'PutBotAliasRequest$name' => '<p>The name of the alias. The name is <i>not</i> case sensitive.</p>', 'PutBotAliasResponse$name' => '<p>The name of the alias.</p>', ], ], 'AliasNameOrListAll' => [ 'base' => NULL, 'refs' => [ 'GetBotChannelAssociationsRequest$botAlias' => '<p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateBotVersionResponse$childDirected' => '<p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children\'s Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p> <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>', 'GetBotResponse$childDirected' => '<p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children\'s Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p> <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>', 'PutBotRequest$childDirected' => '<p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children\'s Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p> <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>', 'PutBotResponse$childDirected' => '<p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children\'s Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p> <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>', ], ], 'BotAliasMetadata' => [ 'base' => '<p>Provides information about a bot alias.</p>', 'refs' => [ 'BotAliasMetadataList$member' => NULL, ], ], 'BotAliasMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetBotAliasesResponse$BotAliases' => '<p>An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.</p>', ], ], 'BotChannelAssociation' => [ 'base' => '<p>Represents an association between an Amazon Lex bot and an external messaging platform.</p>', 'refs' => [ 'BotChannelAssociationList$member' => NULL, ], ], 'BotChannelAssociationList' => [ 'base' => NULL, 'refs' => [ 'GetBotChannelAssociationsResponse$botChannelAssociations' => '<p>An array of objects, one for each association, that provides information about the Amazon Lex bot and its association with the channel. </p>', ], ], 'BotChannelName' => [ 'base' => NULL, 'refs' => [ 'BotChannelAssociation$name' => '<p>The name of the association between the bot and the channel. </p>', 'DeleteBotChannelAssociationRequest$name' => '<p>The name of the association. The name is case sensitive. </p>', 'GetBotChannelAssociationRequest$name' => '<p>The name of the association between the bot and the channel. The name is case sensitive. </p>', 'GetBotChannelAssociationResponse$name' => '<p>The name of the association between the bot and the channel.</p>', 'GetBotChannelAssociationsRequest$nameContains' => '<p>Substring to match in channel association names. An association will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To return all bot channel associations, use a hyphen ("-") as the <code>nameContains</code> parameter.</p>', ], ], 'BotMetadata' => [ 'base' => '<p>Provides information about a bot. .</p>', 'refs' => [ 'BotMetadataList$member' => NULL, ], ], 'BotMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetBotVersionsResponse$bots' => '<p>An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for the <code>$LATEST</code> version.</p>', 'GetBotsResponse$bots' => '<p>An array of <code>botMetadata</code> objects, with one entry for each bot. </p>', ], ], 'BotName' => [ 'base' => NULL, 'refs' => [ 'BotAliasMetadata$botName' => '<p>The name of the bot to which the alias points.</p>', 'BotChannelAssociation$botName' => '<p>The name of the Amazon Lex bot to which this association is being made. </p> <note> <p>Currently, Amazon Lex supports associations with Facebook and Slack, and Twilio.</p> </note>', 'BotMetadata$name' => '<p>The name of the bot. </p>', 'CreateBotVersionRequest$name' => '<p>The name of the bot that you want to create a new version of. The name is case sensitive. </p>', 'CreateBotVersionResponse$name' => '<p>The name of the bot.</p>', 'DeleteBotAliasRequest$botName' => '<p>The name of the bot that the alias points to.</p>', 'DeleteBotChannelAssociationRequest$botName' => '<p>The name of the Amazon Lex bot.</p>', 'DeleteBotRequest$name' => '<p>The name of the bot. The name is case sensitive. </p>', 'DeleteBotVersionRequest$name' => '<p>The name of the bot.</p>', 'DeleteUtterancesRequest$botName' => '<p>The name of the bot that stored the utterances.</p>', 'GetBotAliasRequest$botName' => '<p>The name of the bot.</p>', 'GetBotAliasResponse$botName' => '<p>The name of the bot that the alias points to.</p>', 'GetBotAliasesRequest$botName' => '<p>The name of the bot.</p>', 'GetBotChannelAssociationRequest$botName' => '<p>The name of the Amazon Lex bot.</p>', 'GetBotChannelAssociationResponse$botName' => '<p>The name of the Amazon Lex bot.</p>', 'GetBotChannelAssociationsRequest$botName' => '<p>The name of the Amazon Lex bot in the association.</p>', 'GetBotRequest$name' => '<p>The name of the bot. The name is case sensitive. </p>', 'GetBotResponse$name' => '<p>The name of the bot.</p>', 'GetBotVersionsRequest$name' => '<p>The name of the bot for which versions should be returned.</p>', 'GetBotsRequest$nameContains' => '<p>Substring to match in bot names. A bot will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>', 'GetUtterancesViewRequest$botName' => '<p>The name of the bot for which utterance information should be returned.</p>', 'GetUtterancesViewResponse$botName' => '<p>The name of the bot for which utterance information was returned.</p>', 'PutBotAliasRequest$botName' => '<p>The name of the bot.</p>', 'PutBotAliasResponse$botName' => '<p>The name of the bot that the alias points to.</p>', 'PutBotRequest$name' => '<p>The name of the bot. The name is <i>not</i> case sensitive. </p>', 'PutBotResponse$name' => '<p>The name of the bot.</p>', ], ], 'BotVersions' => [ 'base' => NULL, 'refs' => [ 'GetUtterancesViewRequest$botVersions' => '<p>An array of bot versions for which utterance information should be returned. The limit is 5 versions per request.</p>', ], ], 'BuiltinIntentMetadata' => [ 'base' => '<p>Provides metadata for a built-in intent.</p>', 'refs' => [ 'BuiltinIntentMetadataList$member' => NULL, ], ], 'BuiltinIntentMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetBuiltinIntentsResponse$intents' => '<p>An array of <code>builtinIntentMetadata</code> objects, one for each intent in the response.</p>', ], ], 'BuiltinIntentSignature' => [ 'base' => NULL, 'refs' => [ 'BuiltinIntentMetadata$signature' => '<p>A unique identifier for the built-in intent. To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>', 'CreateIntentVersionResponse$parentIntentSignature' => '<p>A unique identifier for a built-in intent.</p>', 'GetBuiltinIntentRequest$signature' => '<p>The unique identifier for a built-in intent. To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>', 'GetBuiltinIntentResponse$signature' => '<p>The unique identifier for a built-in intent.</p>', 'GetIntentResponse$parentIntentSignature' => '<p>A unique identifier for a built-in intent.</p>', 'PutIntentRequest$parentIntentSignature' => '<p>A unique identifier for the built-in intent to base this intent on. To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>', 'PutIntentResponse$parentIntentSignature' => '<p>A unique identifier for the built-in intent that this intent is based on.</p>', ], ], 'BuiltinIntentSlot' => [ 'base' => '<p>Provides information about a slot used in a built-in intent.</p>', 'refs' => [ 'BuiltinIntentSlotList$member' => NULL, ], ], 'BuiltinIntentSlotList' => [ 'base' => NULL, 'refs' => [ 'GetBuiltinIntentResponse$slots' => '<p>An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.</p>', ], ], 'BuiltinSlotTypeMetadata' => [ 'base' => '<p>Provides information about a built in slot type.</p>', 'refs' => [ 'BuiltinSlotTypeMetadataList$member' => NULL, ], ], 'BuiltinSlotTypeMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetBuiltinSlotTypesResponse$slotTypes' => '<p>An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.</p>', ], ], 'BuiltinSlotTypeSignature' => [ 'base' => NULL, 'refs' => [ 'BuiltinSlotTypeMetadata$signature' => '<p>A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.</p>', ], ], 'ChannelConfigurationMap' => [ 'base' => NULL, 'refs' => [ 'BotChannelAssociation$botConfiguration' => '<p>Provides information necessary to communicate with the messaging platform. </p>', 'GetBotChannelAssociationResponse$botConfiguration' => '<p>Provides information that the messaging platform needs to communicate with the Amazon Lex bot.</p>', ], ], 'ChannelType' => [ 'base' => NULL, 'refs' => [ 'BotChannelAssociation$type' => '<p>Specifies the type of association by indicating the type of channel being established between the Amazon Lex bot and the external messaging platform.</p>', 'GetBotChannelAssociationResponse$type' => '<p>The type of the messaging platform.</p>', ], ], 'CodeHook' => [ 'base' => '<p>Specifies a Lambda function that verifies requests to a bot or fulfills the user\'s request to a bot..</p>', 'refs' => [ 'CreateIntentVersionResponse$dialogCodeHook' => '<p>If defined, Amazon Lex invokes this Lambda function for each user input.</p>', 'FulfillmentActivity$codeHook' => '<p> A description of the Lambda function that is run to fulfill the intent. </p>', 'GetIntentResponse$dialogCodeHook' => '<p>If defined in the bot, Amazon Amazon Lex invokes this Lambda function for each user input. For more information, see <a>PutIntent</a>. </p>', 'PutIntentRequest$dialogCodeHook' => '<p> Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to personalize user interaction. </p> <p>For example, suppose your bot determines that the user is John. Your Lambda function might retrieve John\'s information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>GlutenIntolerant</code>, to true. You might find John\'s phone number and set the corresponding session attribute. </p>', 'PutIntentResponse$dialogCodeHook' => '<p>If defined in the intent, Amazon Lex invokes this Lambda function for each user input.</p>', ], ], 'ConflictException' => [ 'base' => '<p> There was a conflict processing the request. Try your request again. </p>', 'refs' => [], ], 'ContentString' => [ 'base' => NULL, 'refs' => [ 'Message$content' => '<p>The text of the message.</p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'Message$contentType' => '<p>The content type of the message string.</p>', ], ], 'Count' => [ 'base' => NULL, 'refs' => [ 'UtteranceData$count' => '<p>The number of times that the utterance was processed.</p>', 'UtteranceData$distinctUsers' => '<p>The total number of individuals that used the utterance.</p>', ], ], 'CreateBotVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIntentVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIntentVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlotTypeVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlotTypeVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomOrBuiltinSlotTypeName' => [ 'base' => NULL, 'refs' => [ 'Slot$slotType' => '<p>The type of the slot, either a custom slot type that you defined or one of the built-in slot types.</p>', ], ], 'DeleteBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotChannelAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIntentVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlotTypeVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUtterancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'BotAliasMetadata$description' => '<p>A description of the bot alias.</p>', 'BotChannelAssociation$description' => '<p>A text description of the association you are creating. </p>', 'BotMetadata$description' => '<p>A description of the bot.</p>', 'CreateBotVersionResponse$description' => '<p>A description of the bot.</p>', 'CreateIntentVersionResponse$description' => '<p>A description of the intent.</p>', 'CreateSlotTypeVersionResponse$description' => '<p>A description of the slot type.</p>', 'GetBotAliasResponse$description' => '<p>A description of the bot alias.</p>', 'GetBotChannelAssociationResponse$description' => '<p>A description of the association between the bot and the channel.</p>', 'GetBotResponse$description' => '<p>A description of the bot.</p>', 'GetIntentResponse$description' => '<p>A description of the intent.</p>', 'GetSlotTypeResponse$description' => '<p>A description of the slot type.</p>', 'IntentMetadata$description' => '<p>A description of the intent.</p>', 'PutBotAliasRequest$description' => '<p>A description of the alias.</p>', 'PutBotAliasResponse$description' => '<p>A description of the alias.</p>', 'PutBotRequest$description' => '<p>A description of the bot.</p>', 'PutBotResponse$description' => '<p>A description of the bot.</p>', 'PutIntentRequest$description' => '<p>A description of the intent.</p>', 'PutIntentResponse$description' => '<p>A description of the intent.</p>', 'PutSlotTypeRequest$description' => '<p>A description of the slot type.</p>', 'PutSlotTypeResponse$description' => '<p>A description of the slot type.</p>', 'Slot$description' => '<p>A description of the slot.</p>', 'SlotTypeMetadata$description' => '<p>A description of the slot type.</p>', ], ], 'EnumerationValue' => [ 'base' => '<p>Each slot type can have a set of values. Each enumeration value represents a value the slot type can take. </p> <p>For example, a pizza ordering bot could have a slot type that specifies the type of crust that the pizza should have. The slot type could include the values </p> <ul> <li> <p>thick</p> </li> <li> <p>thin</p> </li> <li> <p>stuffed</p> </li> </ul>', 'refs' => [ 'EnumerationValues$member' => NULL, ], ], 'EnumerationValues' => [ 'base' => NULL, 'refs' => [ 'CreateSlotTypeVersionResponse$enumerationValues' => '<p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.</p>', 'GetSlotTypeResponse$enumerationValues' => '<p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.</p>', 'PutSlotTypeRequest$enumerationValues' => '<p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.</p>', 'PutSlotTypeResponse$enumerationValues' => '<p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.</p>', ], ], 'FollowUpPrompt' => [ 'base' => '<p>A prompt for additional activity after an intent is fulfilled. For example, after the <code>OrderPizza</code> intent is fulfilled, you might prompt the user to find out whether the user wants to order drinks.</p>', 'refs' => [ 'CreateIntentVersionResponse$followUpPrompt' => '<p>If defined, Amazon Lex uses this prompt to solicit additional user activity after the intent is fulfilled. </p>', 'GetIntentResponse$followUpPrompt' => '<p>If defined in the bot, Amazon Lex uses this prompt to solicit additional user activity after the intent is fulfilled. For more information, see <a>PutIntent</a>.</p>', 'PutIntentRequest$followUpPrompt' => '<p>Amazon Lex uses this prompt to solicit additional activity after fulfilling an intent. For example, after the <code>OrderPizza</code> intent is fulfilled, you might prompt the user to order a drink.</p> <p>The action that Amazon Lex takes depends on the user\'s response, as follows:</p> <ul> <li> <p>If the user says "Yes" it responds with the clarification prompt that is configured for the bot.</p> </li> <li> <p>if the user says "Yes" and continues with an utterance that triggers an intent it starts a conversation for the intent.</p> </li> <li> <p>If the user says "No" it responds with the rejection statement configured for the the follow-up prompt.</p> </li> <li> <p>If it doesn\'t recognize the utterance it repeats the follow-up prompt again.</p> </li> </ul> <p>The <code>followUpPrompt</code> field and the <code>conclusionStatement</code> field are mutually exclusive. You can specify only one. </p>', 'PutIntentResponse$followUpPrompt' => '<p>If defined in the intent, Amazon Lex uses this prompt to solicit additional user activity after the intent is fulfilled.</p>', ], ], 'FulfillmentActivity' => [ 'base' => '<p> Describes how the intent is fulfilled after the user provides all of the information required for the intent. You can provide a Lambda function to process the intent, or you can return the intent information to the client application. We recommend that you use a Lambda function so that the relevant logic lives in the Cloud and limit the client-side code primarily to presentation. If you need to update the logic, you only update the Lambda function; you don\'t need to upgrade your client application. </p> <p>Consider the following examples:</p> <ul> <li> <p>In a pizza ordering application, after the user provides all of the information for placing an order, you use a Lambda function to place an order with a pizzeria. </p> </li> <li> <p>In a gaming application, when a user says "pick up a rock," this information must go back to the client application so that it can perform the operation and update the graphics. In this case, you want Amazon Lex to return the intent data to the client. </p> </li> </ul>', 'refs' => [ 'CreateIntentVersionResponse$fulfillmentActivity' => '<p> Describes how the intent is fulfilled. </p>', 'GetIntentResponse$fulfillmentActivity' => '<p>Describes how the intent is fulfilled. For more information, see <a>PutIntent</a>. </p>', 'PutIntentRequest$fulfillmentActivity' => '<p> Describes how the intent is fulfilled. For example, after a user provides all of the information for a pizza order, <code>fulfillmentActivity</code> defines how the bot places an order with a local pizza store. </p> <p> You might configure Amazon Lex to return all of the intent information to the client application, or direct it to invoke a Lambda function that can process the intent (for example, place an order with a pizzeria). </p>', 'PutIntentResponse$fulfillmentActivity' => '<p>If defined in the intent, Amazon Lex invokes this Lambda function to fulfill the intent after the user provides all of the information required by the intent.</p>', ], ], 'FulfillmentActivityType' => [ 'base' => NULL, 'refs' => [ 'FulfillmentActivity$type' => '<p> How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to the client application. </p>', ], ], 'GetBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBotAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBotChannelAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotChannelAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBotChannelAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotChannelAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBotVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBuiltinIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBuiltinIntentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBuiltinIntentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBuiltinIntentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBuiltinSlotTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBuiltinSlotTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIntentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIntentVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIntentVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIntentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIntentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSlotTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSlotTypeVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSlotTypeVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSlotTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSlotTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUtterancesViewRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUtterancesViewResponse' => [ 'base' => NULL, 'refs' => [], ], 'Intent' => [ 'base' => '<p>Identifies the specific version of an intent.</p>', 'refs' => [ 'IntentList$member' => NULL, ], ], 'IntentList' => [ 'base' => NULL, 'refs' => [ 'CreateBotVersionResponse$intents' => '<p>An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.</p>', 'GetBotResponse$intents' => '<p>An array of <code>intent</code> objects. For more information, see <a>PutBot</a>.</p>', 'PutBotRequest$intents' => '<p>An array of <code>Intent</code> objects. Each intent represents a command that a user can express. For example, a pizza ordering bot might support an OrderPizza intent. For more information, see <a>how-it-works</a>.</p>', 'PutBotResponse$intents' => '<p>An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.</p>', ], ], 'IntentMetadata' => [ 'base' => '<p>Provides information about an intent.</p>', 'refs' => [ 'IntentMetadataList$member' => NULL, ], ], 'IntentMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetIntentVersionsResponse$intents' => '<p>An array of <code>IntentMetadata</code> objects, one for each numbered version of the intent plus one for the <code>$LATEST</code> version.</p>', 'GetIntentsResponse$intents' => '<p>An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.</p>', ], ], 'IntentName' => [ 'base' => NULL, 'refs' => [ 'CreateIntentVersionRequest$name' => '<p>The name of the intent that you want to create a new version of. The name is case sensitive. </p>', 'CreateIntentVersionResponse$name' => '<p>The name of the intent.</p>', 'DeleteIntentRequest$name' => '<p>The name of the intent. The name is case sensitive. </p>', 'DeleteIntentVersionRequest$name' => '<p>The name of the intent.</p>', 'GetIntentRequest$name' => '<p>The name of the intent. The name is case sensitive. </p>', 'GetIntentResponse$name' => '<p>The name of the intent.</p>', 'GetIntentVersionsRequest$name' => '<p>The name of the intent for which versions should be returned.</p>', 'GetIntentsRequest$nameContains' => '<p>Substring to match in intent names. An intent will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>', 'Intent$intentName' => '<p>The name of the intent.</p>', 'IntentMetadata$name' => '<p>The name of the intent.</p>', 'PutIntentRequest$name' => '<p>The name of the intent. The name is <i>not</i> case sensitive. </p> <p>The name can\'t match a built-in intent name, or a built-in intent name with "AMAZON." removed. For example, because there is a built-in intent called <code>AMAZON.HelpIntent</code>, you can\'t create a custom intent called <code>HelpIntent</code>.</p> <p>For a list of built-in intents, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>', 'PutIntentResponse$name' => '<p>The name of the intent.</p>', ], ], 'IntentUtteranceList' => [ 'base' => NULL, 'refs' => [ 'CreateIntentVersionResponse$sampleUtterances' => '<p>An array of sample utterances configured for the intent. </p>', 'GetIntentResponse$sampleUtterances' => '<p>An array of sample utterances configured for the intent.</p>', 'PutIntentRequest$sampleUtterances' => '<p>An array of utterances (strings) that a user might say to signal the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas". </p> <p>In each utterance, a slot name is enclosed in curly braces. </p>', 'PutIntentResponse$sampleUtterances' => '<p> An array of sample utterances that are configured for the intent. </p>', ], ], 'InternalFailureException' => [ 'base' => '<p>An internal Amazon Lex error occurred. Try your request again.</p>', 'refs' => [], ], 'LambdaARN' => [ 'base' => NULL, 'refs' => [ 'CodeHook$uri' => '<p>The Amazon Resource Name (ARN) of the Lambda function.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request exceeded a limit. Try your request again.</p>', 'refs' => [], ], 'ListOfUtterance' => [ 'base' => NULL, 'refs' => [ 'UtteranceList$utterances' => '<p>One or more <a>UtteranceData</a> objects that contain information about the utterances that have been made to a bot. The maximum number of object is 100.</p>', ], ], 'ListsOfUtterances' => [ 'base' => NULL, 'refs' => [ 'GetUtterancesViewResponse$utterances' => '<p>An array of <a>UtteranceList</a> objects, each containing a list of <a>UtteranceData</a> objects describing the utterances that were processed by your bot. The response contains a maximum of 100 <code>UtteranceData</code> objects for each version.</p>', ], ], 'Locale' => [ 'base' => NULL, 'refs' => [ 'CreateBotVersionResponse$locale' => '<p> Specifies the target locale for the bot. </p>', 'GetBotResponse$locale' => '<p> The target locale for the bot. </p>', 'GetBuiltinIntentsRequest$locale' => '<p>A list of locales that the intent supports.</p>', 'GetBuiltinSlotTypesRequest$locale' => '<p>A list of locales that the slot type supports.</p>', 'LocaleList$member' => NULL, 'PutBotRequest$locale' => '<p> Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. </p> <p>The default is <code>en-US</code>.</p>', 'PutBotResponse$locale' => '<p> The target locale for the bot. </p>', ], ], 'LocaleList' => [ 'base' => NULL, 'refs' => [ 'BuiltinIntentMetadata$supportedLocales' => '<p>A list of identifiers for the locales that the intent supports.</p>', 'BuiltinSlotTypeMetadata$supportedLocales' => '<p>A list of target locales for the slot. </p>', 'GetBuiltinIntentResponse$supportedLocales' => '<p>A list of locales that the intent supports.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetBotAliasesRequest$maxResults' => '<p>The maximum number of aliases to return in the response. The default is 50. . </p>', 'GetBotChannelAssociationsRequest$maxResults' => '<p>The maximum number of associations to return in the response. The default is 50. </p>', 'GetBotVersionsRequest$maxResults' => '<p>The maximum number of bot versions to return in the response. The default is 10.</p>', 'GetBotsRequest$maxResults' => '<p>The maximum number of bots to return in the response that the request will return. The default is 10.</p>', 'GetBuiltinIntentsRequest$maxResults' => '<p>The maximum number of intents to return in the response. The default is 10.</p>', 'GetBuiltinSlotTypesRequest$maxResults' => '<p>The maximum number of slot types to return in the response. The default is 10.</p>', 'GetIntentVersionsRequest$maxResults' => '<p>The maximum number of intent versions to return in the response. The default is 10.</p>', 'GetIntentsRequest$maxResults' => '<p>The maximum number of intents to return in the response. The default is 10.</p>', 'GetSlotTypeVersionsRequest$maxResults' => '<p>The maximum number of slot type versions to return in the response. The default is 10.</p>', 'GetSlotTypesRequest$maxResults' => '<p>The maximum number of slot types to return in the response. The default is 10.</p>', ], ], 'Message' => [ 'base' => '<p>The message object that provides the message text and its type.</p>', 'refs' => [ 'MessageList$member' => NULL, ], ], 'MessageList' => [ 'base' => NULL, 'refs' => [ 'Prompt$messages' => '<p>An array of objects, each of which provides a message string and its type. You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).</p>', 'Statement$messages' => '<p>A collection of message objects.</p>', ], ], 'MessageVersion' => [ 'base' => NULL, 'refs' => [ 'CodeHook$messageVersion' => '<p>The version of the request-response that you want Amazon Lex to use to invoke your Lambda function. For more information, see <a>using-lambda</a>.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'ResourceReference$name' => '<p>The name of the resource that is using the resource that you are trying to delete.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetBotAliasesRequest$nextToken' => '<p>A pagination token for fetching the next page of aliases. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token in the next request. </p>', 'GetBotAliasesResponse$nextToken' => '<p>A pagination token for fetching next page of aliases. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token in the next request. </p>', 'GetBotChannelAssociationsRequest$nextToken' => '<p>A pagination token for fetching the next page of associations. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of associations, specify the pagination token in the next request. </p>', 'GetBotChannelAssociationsResponse$nextToken' => '<p>A pagination token that fetches the next page of associations. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of associations, specify the pagination token in the next request. </p>', 'GetBotVersionsRequest$nextToken' => '<p>A pagination token for fetching the next page of bot versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>', 'GetBotVersionsResponse$nextToken' => '<p>A pagination token for fetching the next page of bot versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>', 'GetBotsRequest$nextToken' => '<p>A pagination token that fetches the next page of bots. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of bots, specify the pagination token in the next request. </p>', 'GetBotsResponse$nextToken' => '<p>If the response is truncated, it includes a pagination token that you can specify in your next request to fetch the next page of bots. </p>', 'GetBuiltinIntentsRequest$nextToken' => '<p>A pagination token that fetches the next page of intents. If this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, use the pagination token in the next request.</p>', 'GetBuiltinIntentsResponse$nextToken' => '<p>A pagination token that fetches the next page of intents. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, specify the pagination token in the next request.</p>', 'GetBuiltinSlotTypesRequest$nextToken' => '<p>A pagination token that fetches the next page of slot types. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of slot types, specify the pagination token in the next request.</p>', 'GetBuiltinSlotTypesResponse$nextToken' => '<p>If the response is truncated, the response includes a pagination token that you can use in your next request to fetch the next page of slot types.</p>', 'GetIntentVersionsRequest$nextToken' => '<p>A pagination token for fetching the next page of intent versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>', 'GetIntentVersionsResponse$nextToken' => '<p>A pagination token for fetching the next page of intent versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>', 'GetIntentsRequest$nextToken' => '<p>A pagination token that fetches the next page of intents. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, specify the pagination token in the next request. </p>', 'GetIntentsResponse$nextToken' => '<p>If the response is truncated, the response includes a pagination token that you can specify in your next request to fetch the next page of intents. </p>', 'GetSlotTypeVersionsRequest$nextToken' => '<p>A pagination token for fetching the next page of slot type versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>', 'GetSlotTypeVersionsResponse$nextToken' => '<p>A pagination token for fetching the next page of slot type versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>', 'GetSlotTypesRequest$nextToken' => '<p>A pagination token that fetches the next page of slot types. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch next page of slot types, specify the pagination token in the next request.</p>', 'GetSlotTypesResponse$nextToken' => '<p>If the response is truncated, it includes a pagination token that you can specify in your next request to fetch the next page of slot types.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>The resource specified in the request was not found. Check the resource and try again.</p>', 'refs' => [], ], 'NumericalVersion' => [ 'base' => NULL, 'refs' => [ 'DeleteBotVersionRequest$version' => '<p>The version of the bot to delete. You cannot delete the <code>$LATEST</code> version of the bot. To delete the <code>$LATEST</code> version, use the <a>DeleteBot</a> operation.</p>', 'DeleteIntentVersionRequest$version' => '<p>The version of the intent to delete. You cannot delete the <code>$LATEST</code> version of the intent. To delete the <code>$LATEST</code> version, use the <a>DeleteIntent</a> operation.</p>', 'DeleteSlotTypeVersionRequest$version' => '<p>The version of the slot type to delete. You cannot delete the <code>$LATEST</code> version of the slot type. To delete the <code>$LATEST</code> version, use the <a>DeleteSlotType</a> operation.</p>', ], ], 'PreconditionFailedException' => [ 'base' => '<p> The checksum of the resource that you are trying to change does not match the checksum in the request. Check the resource\'s checksum and try again.</p>', 'refs' => [], ], 'Priority' => [ 'base' => NULL, 'refs' => [ 'Slot$priority' => '<p> Directs Lex the order in which to elicit this slot value from the user. For example, if the intent has two slots with priorities 1 and 2, AWS Lex first elicits a value for the slot with priority 1.</p> <p>If multiple slots share the same priority, the order in which Lex elicits values is arbitrary.</p>', ], ], 'ProcessBehavior' => [ 'base' => NULL, 'refs' => [ 'PutBotRequest$processBehavior' => '<p>If you set the <code>processBehavior</code> element to <code>Build</code>, Amazon Lex builds the bot so that it can be run. If you set the element to <code>Save</code>Amazon Lex saves the bot, but doesn\'t build it. </p> <p>If you don\'t specify this value, the default value is <code>Save</code>.</p>', ], ], 'Prompt' => [ 'base' => '<p>Obtains information from the user. To define a prompt, provide one or more messages and specify the number of attempts to get information from the user. If you provide more than one message, Amazon Lex chooses one of the messages to use to prompt the user. For more information, see <a>how-it-works</a>.</p>', 'refs' => [ 'CreateBotVersionResponse$clarificationPrompt' => '<p>The message that Amazon Lex uses when it doesn\'t understand the user\'s request. For more information, see <a>PutBot</a>. </p>', 'CreateIntentVersionResponse$confirmationPrompt' => '<p>If defined, the prompt that Amazon Lex uses to confirm the user\'s intent before fulfilling it. </p>', 'FollowUpPrompt$prompt' => '<p>Prompts for information from the user. </p>', 'GetBotResponse$clarificationPrompt' => '<p>The message Amazon Lex uses when it doesn\'t understand the user\'s request. For more information, see <a>PutBot</a>. </p>', 'GetIntentResponse$confirmationPrompt' => '<p>If defined in the bot, Amazon Lex uses prompt to confirm the intent before fulfilling the user\'s request. For more information, see <a>PutIntent</a>. </p>', 'PutBotRequest$clarificationPrompt' => '<p>When Amazon Lex doesn\'t understand the user\'s intent, it uses this message to get clarification. To specify how many times Amazon Lex should repeate the clarification prompt, use the <code>maxAttempts</code> field. If Amazon Lex still doesn\'t understand, it sends the message in the <code>abortStatement</code> field. </p> <p>When you create a clarification prompt, make sure that it suggests the correct response from the user. for example, for a bot that orders pizza and drinks, you might create this clarification prompt: "What would you like to do? You can say \'Order a pizza\' or \'Order a drink.\'"</p>', 'PutBotResponse$clarificationPrompt' => '<p> The prompts that Amazon Lex uses when it doesn\'t understand the user\'s intent. For more information, see <a>PutBot</a>. </p>', 'PutIntentRequest$confirmationPrompt' => '<p>Prompts the user to confirm the intent. This question should have a yes or no answer.</p> <p>Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information. </p> <note> <p>You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or neither.</p> </note>', 'PutIntentResponse$confirmationPrompt' => '<p>If defined in the intent, Amazon Lex prompts the user to confirm the intent before fulfilling it.</p>', 'Slot$valueElicitationPrompt' => '<p>The prompt that Amazon Lex uses to elicit the slot value from the user.</p>', ], ], 'PromptMaxAttempts' => [ 'base' => NULL, 'refs' => [ 'Prompt$maxAttempts' => '<p>The number of times to prompt the user for information.</p>', ], ], 'PutBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBotAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutIntentResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutSlotTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReferenceType' => [ 'base' => NULL, 'refs' => [ 'ResourceInUseException$referenceType' => NULL, ], ], 'ResourceInUseException' => [ 'base' => '<p>The resource that you are attempting to delete is referred to by another resource. Use this information to remove references to the resource that you are trying to delete.</p> <p>The body of the exception contains a JSON object that describes the resource.</p> <p> <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code> </p> <p> <code>"resourceReference": {</code> </p> <p> <code>"name": <i>string</i>, "version": <i>string</i> } }</code> </p>', 'refs' => [], ], 'ResourceReference' => [ 'base' => '<p>Describes the resource that refers to the resource that you are attempting to delete. This object is returned as part of the <code>ResourceInUseException</code> exception. </p>', 'refs' => [ 'ResourceInUseException$exampleReference' => NULL, ], ], 'ResponseCard' => [ 'base' => NULL, 'refs' => [ 'Prompt$responseCard' => '<p>A response card. Amazon Lex uses this prompt at runtime, in the <code>PostText</code> API response. It substitutes session attributes and slot values for placeholders in the response card. For more information, see <a>ex-resp-card</a>. </p>', 'Slot$responseCard' => '<p> A set of possible responses for the slot type used by text-based clients. A user chooses an option from the response card, instead of using text to reply. </p>', 'Statement$responseCard' => '<p> At runtime, if the client is using the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> API, Amazon Lex includes the response card in the response. It substitutes all of the session attributes and slot values for placeholders in the response card. </p>', ], ], 'SessionTTL' => [ 'base' => NULL, 'refs' => [ 'CreateBotVersionResponse$idleSessionTTLInSeconds' => '<p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. For more information, see <a>PutBot</a>.</p>', 'GetBotResponse$idleSessionTTLInSeconds' => '<p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. For more information, see <a>PutBot</a>.</p>', 'PutBotRequest$idleSessionTTLInSeconds' => '<p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p> <p>A user interaction session remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p> <p>For example, suppose that a user chooses the OrderPizza intent, but gets sidetracked halfway through placing an order. If the user doesn\'t complete the order within the specified time, Amazon Lex discards the slot information that it gathered, and the user must start over.</p> <p>If you don\'t include the <code>idleSessionTTLInSeconds</code> element in a <code>PutBot</code> operation request, Amazon Lex uses the default value. This is also true if the request replaces an existing bot.</p> <p>The default is 300 seconds (5 minutes).</p>', 'PutBotResponse$idleSessionTTLInSeconds' => '<p>The maximum length of time that Amazon Lex retains the data gathered in a conversation. For more information, see <a>PutBot</a>.</p>', ], ], 'Slot' => [ 'base' => '<p>Identifies the version of a specific slot.</p>', 'refs' => [ 'SlotList$member' => NULL, ], ], 'SlotConstraint' => [ 'base' => NULL, 'refs' => [ 'Slot$slotConstraint' => '<p>Specifies whether the slot is required or optional. </p>', ], ], 'SlotList' => [ 'base' => NULL, 'refs' => [ 'CreateIntentVersionResponse$slots' => '<p>An array of slot types that defines the information required to fulfill the intent.</p>', 'GetIntentResponse$slots' => '<p>An array of intent slots configured for the intent.</p>', 'PutIntentRequest$slots' => '<p>An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts defined in the slots. For more information, see &lt;xref linkend="how-it-works"/&gt;. </p>', 'PutIntentResponse$slots' => '<p>An array of intent slots that are configured for the intent.</p>', ], ], 'SlotName' => [ 'base' => NULL, 'refs' => [ 'Slot$name' => '<p>The name of the slot.</p>', ], ], 'SlotTypeMetadata' => [ 'base' => '<p>Provides information about a slot type..</p>', 'refs' => [ 'SlotTypeMetadataList$member' => NULL, ], ], 'SlotTypeMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetSlotTypeVersionsResponse$slotTypes' => '<p>An array of <code>SlotTypeMetadata</code> objects, one for each numbered version of the slot type plus one for the <code>$LATEST</code> version.</p>', 'GetSlotTypesResponse$slotTypes' => '<p>An array of objects, one for each slot type, that provides information such as the name of the slot type, the version, and a description.</p>', ], ], 'SlotTypeName' => [ 'base' => NULL, 'refs' => [ 'CreateSlotTypeVersionRequest$name' => '<p>The name of the slot type that you want to create a new version for. The name is case sensitive. </p>', 'CreateSlotTypeVersionResponse$name' => '<p>The name of the slot type.</p>', 'DeleteSlotTypeRequest$name' => '<p>The name of the slot type. The name is case sensitive. </p>', 'DeleteSlotTypeVersionRequest$name' => '<p>The name of the slot type.</p>', 'GetSlotTypeRequest$name' => '<p>The name of the slot type. The name is case sensitive. </p>', 'GetSlotTypeResponse$name' => '<p>The name of the slot type.</p>', 'GetSlotTypeVersionsRequest$name' => '<p>The name of the slot type for which versions should be returned.</p>', 'GetSlotTypesRequest$nameContains' => '<p>Substring to match in slot type names. A slot type will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>', 'PutSlotTypeRequest$name' => '<p>The name of the slot type. The name is <i>not</i> case sensitive. </p> <p>The name can\'t match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can\'t create a custom slot type called <code>DATE</code>.</p> <p>For a list of built-in slot types, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.</p>', 'PutSlotTypeResponse$name' => '<p>The name of the slot type.</p>', 'SlotTypeMetadata$name' => '<p>The name of the slot type.</p>', ], ], 'SlotUtteranceList' => [ 'base' => NULL, 'refs' => [ 'Slot$sampleUtterances' => '<p> If you know a specific pattern with which users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable of understanding user utterances. </p>', ], ], 'Statement' => [ 'base' => '<p>A collection of messages that convey information to the user. At runtime, Amazon Lex selects the message to convey. </p>', 'refs' => [ 'CreateBotVersionResponse$abortStatement' => '<p>The message that Amazon Lex uses to abort a conversation. For more information, see <a>PutBot</a>.</p>', 'CreateIntentVersionResponse$rejectionStatement' => '<p>If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p>', 'CreateIntentVersionResponse$conclusionStatement' => '<p>After the Lambda function specified in the <code>fulfillmentActivity</code> field fulfills the intent, Amazon Lex conveys this statement to the user. </p>', 'FollowUpPrompt$rejectionStatement' => '<p>If the user answers "no" to the question defined in the <code>prompt</code> field, Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p>', 'GetBotResponse$abortStatement' => '<p>The message that Amazon Lex returns when the user elects to end the conversation without completing it. For more information, see <a>PutBot</a>.</p>', 'GetIntentResponse$rejectionStatement' => '<p>If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p>', 'GetIntentResponse$conclusionStatement' => '<p>After the Lambda function specified in the <code>fulfillmentActivity</code> element fulfills the intent, Amazon Lex conveys this statement to the user.</p>', 'PutBotRequest$abortStatement' => '<p>When Amazon Lex can\'t understand the user\'s input in context, it tries to elicit the information a few times. After that, Amazon Lex sends the message defined in <code>abortStatement</code> to the user, and then aborts the conversation. To set the number of retries, use the <code>valueElicitationPrompt</code> field for the slot type. </p> <p>For example, in a pizza ordering bot, Amazon Lex might ask a user "What type of crust would you like?" If the user\'s response is not one of the expected responses (for example, "thin crust, "deep dish," etc.), Amazon Lex tries to elicit a correct response a few more times. </p> <p>For example, in a pizza ordering application, <code>OrderPizza</code> might be one of the intents. This intent might require the <code>CrustType</code> slot. You specify the <code>valueElicitationPrompt</code> field when you create the <code>CrustType</code> slot.</p>', 'PutBotResponse$abortStatement' => '<p>The message that Amazon Lex uses to abort a conversation. For more information, see <a>PutBot</a>.</p>', 'PutIntentRequest$rejectionStatement' => '<p>When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p> <note> <p>You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or neither.</p> </note>', 'PutIntentRequest$conclusionStatement' => '<p> The statement that you want Amazon Lex to convey to the user after the intent is successfully fulfilled by the Lambda function. </p> <p>This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>. If you return the intent to the client application, you can\'t specify this element.</p> <note> <p>The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can specify only one.</p> </note>', 'PutIntentResponse$rejectionStatement' => '<p>If the user answers "no" to the question defined in <code>confirmationPrompt</code> Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p>', 'PutIntentResponse$conclusionStatement' => '<p>After the Lambda function specified in the<code>fulfillmentActivity</code>intent fulfills the intent, Amazon Lex conveys this statement to the user.</p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'BotMetadata$status' => '<p>The status of the bot.</p>', 'CreateBotVersionResponse$status' => '<p> When you send a request to create or update a bot, Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>. After Amazon Lex builds the bot, it sets <code>status</code> to <code>READY</code>. If Amazon Lex can\'t build the bot, it sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns the reason for the failure in the <code>failureReason</code> response element. </p>', 'GetBotResponse$status' => '<p>The status of the bot. If the bot is ready to run, the status is <code>READY</code>. If there was a problem with building the bot, the status is <code>FAILED</code> and the <code>failureReason</code> explains why the bot did not build. If the bot was saved but not built, the status is <code>NOT BUILT</code>.</p>', 'PutBotResponse$status' => '<p> When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>, Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>. After Amazon Lex builds the bot, it sets <code>status</code> to <code>READY</code>. If Amazon Lex can\'t build the bot, Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns the reason for the failure in the <code>failureReason</code> response element. </p> <p>When you set <code>processBehavior</code>to <code>SAVE</code>, Amazon Lex sets the status code to <code>NOT BUILT</code>.</p>', ], ], 'StatusType' => [ 'base' => NULL, 'refs' => [ 'GetUtterancesViewRequest$statusType' => '<p>To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances that were not recognized, use <code>Missed</code>.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$message' => NULL, 'BotAliasMetadata$checksum' => '<p>Checksum of the bot alias.</p>', 'BuiltinIntentSlot$name' => '<p>A list of the slots defined for the intent.</p>', 'ChannelConfigurationMap$key' => NULL, 'ChannelConfigurationMap$value' => NULL, 'ConflictException$message' => NULL, 'CreateBotVersionRequest$checksum' => '<p>Identifies a specific revision of the <code>$LATEST</code> version of the bot. If you specify a checksum and the <code>$LATEST</code> version of the bot has a different checksum, a <code>PreconditionFailedException</code> exception is returned and Amazon Lex doesn\'t publish a new version. If you don\'t specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>', 'CreateBotVersionResponse$failureReason' => '<p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the bot.</p>', 'CreateBotVersionResponse$voiceId' => '<p>The Amazon Polly voice ID that Amazon Lex uses for voice interactions with the user.</p>', 'CreateBotVersionResponse$checksum' => '<p>Checksum identifying the version of the bot that was created.</p>', 'CreateIntentVersionRequest$checksum' => '<p>Checksum of the <code>$LATEST</code> version of the intent that should be used to create the new version. If you specify a checksum and the <code>$LATEST</code> version of the intent has a different checksum, Amazon Lex returns a <code>PreconditionFailedException</code> exception and doesn\'t publish a new version. If you don\'t specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>', 'CreateIntentVersionResponse$checksum' => '<p>Checksum of the intent version created.</p>', 'CreateSlotTypeVersionRequest$checksum' => '<p>Checksum for the <code>$LATEST</code> version of the slot type that you want to publish. If you specify a checksum and the <code>$LATEST</code> version of the slot type has a different checksum, Amazon Lex returns a <code>PreconditionFailedException</code> exception and doesn\'t publish the new version. If you don\'t specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>', 'CreateSlotTypeVersionResponse$checksum' => '<p>Checksum of the <code>$LATEST</code> version of the slot type.</p>', 'GetBotAliasResponse$checksum' => '<p>Checksum of the bot alias.</p>', 'GetBotRequest$versionOrAlias' => '<p>The version or alias of the bot.</p>', 'GetBotResponse$failureReason' => '<p>If <code>status</code> is <code>FAILED</code>, Amazon Lex explains why it failed to build the bot.</p>', 'GetBotResponse$voiceId' => '<p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more information, see <a>PutBot</a>.</p>', 'GetBotResponse$checksum' => '<p>Checksum of the bot used to identify a specific revision of the bot\'s <code>$LATEST</code> version.</p>', 'GetBuiltinIntentsRequest$signatureContains' => '<p>Substring to match in built-in intent signatures. An intent will be returned if any part of its signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>', 'GetBuiltinSlotTypesRequest$signatureContains' => '<p>Substring to match in built-in slot type signatures. A slot type will be returned if any part of its signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>', 'GetIntentResponse$checksum' => '<p>Checksum of the intent.</p>', 'GetSlotTypeResponse$checksum' => '<p>Checksum of the <code>$LATEST</code> version of the slot type.</p>', 'InternalFailureException$message' => NULL, 'LimitExceededException$retryAfterSeconds' => NULL, 'LimitExceededException$message' => NULL, 'NotFoundException$message' => NULL, 'PreconditionFailedException$message' => NULL, 'PutBotAliasRequest$checksum' => '<p>Identifies a specific revision of the <code>$LATEST</code> version.</p> <p>When you create a new bot alias, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p> <p>When you want to update a bot alias, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don\'t specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>', 'PutBotAliasResponse$checksum' => '<p>The checksum for the current version of the alias.</p>', 'PutBotRequest$voiceId' => '<p>The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see <a href="http://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Available Voices</a> in the <i>Amazon Polly Developer Guide</i>.</p>', 'PutBotRequest$checksum' => '<p>Identifies a specific revision of the <code>$LATEST</code> version.</p> <p>When you create a new bot, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p> <p>When you want to update a bot, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don\'t specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>', 'PutBotResponse$failureReason' => '<p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the bot.</p>', 'PutBotResponse$voiceId' => '<p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more information, see <a>PutBot</a>.</p>', 'PutBotResponse$checksum' => '<p>Checksum of the bot that you created.</p>', 'PutIntentRequest$checksum' => '<p>Identifies a specific revision of the <code>$LATEST</code> version.</p> <p>When you create a new intent, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p> <p>When you want to update a intent, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don\'t specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>', 'PutIntentResponse$checksum' => '<p>Checksum of the <code>$LATEST</code>version of the intent created or updated.</p>', 'PutSlotTypeRequest$checksum' => '<p>Identifies a specific revision of the <code>$LATEST</code> version.</p> <p>When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p> <p>When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don\'t specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>', 'PutSlotTypeResponse$checksum' => '<p>Checksum of the <code>$LATEST</code> version of the slot type.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'BotAliasMetadata$lastUpdatedDate' => '<p>The date that the bot alias was updated. When you create a resource, the creation date and last updated date are the same.</p>', 'BotAliasMetadata$createdDate' => '<p>The date that the bot alias was created.</p>', 'BotChannelAssociation$createdDate' => '<p>The date that the association between the Amazon Lex bot and the channel was created. </p>', 'BotMetadata$lastUpdatedDate' => '<p>The date that the bot was updated. When you create a bot, the creation date and last updated date are the same. </p>', 'BotMetadata$createdDate' => '<p>The date that the bot was created.</p>', 'CreateBotVersionResponse$lastUpdatedDate' => '<p>The date when the <code>$LATEST</code> version of this bot was updated. </p>', 'CreateBotVersionResponse$createdDate' => '<p>The date when the bot version was created.</p>', 'CreateIntentVersionResponse$lastUpdatedDate' => '<p>The date that the intent was updated. </p>', 'CreateIntentVersionResponse$createdDate' => '<p>The date that the intent was created.</p>', 'CreateSlotTypeVersionResponse$lastUpdatedDate' => '<p>The date that the slot type was updated. When you create a resource, the creation date and last update date are the same.</p>', 'CreateSlotTypeVersionResponse$createdDate' => '<p>The date that the slot type was created.</p>', 'GetBotAliasResponse$lastUpdatedDate' => '<p>The date that the bot alias was updated. When you create a resource, the creation date and the last updated date are the same.</p>', 'GetBotAliasResponse$createdDate' => '<p>The date that the bot alias was created.</p>', 'GetBotChannelAssociationResponse$createdDate' => '<p>The date that the association between the bot and the channel was created.</p>', 'GetBotResponse$lastUpdatedDate' => '<p>The date that the bot was updated. When you create a resource, the creation date and last updated date are the same. </p>', 'GetBotResponse$createdDate' => '<p>The date that the bot was created.</p>', 'GetIntentResponse$lastUpdatedDate' => '<p>The date that the intent was updated. When you create a resource, the creation date and the last updated date are the same. </p>', 'GetIntentResponse$createdDate' => '<p>The date that the intent was created.</p>', 'GetSlotTypeResponse$lastUpdatedDate' => '<p>The date that the slot type was updated. When you create a resource, the creation date and last update date are the same.</p>', 'GetSlotTypeResponse$createdDate' => '<p>The date that the slot type was created.</p>', 'IntentMetadata$lastUpdatedDate' => '<p>The date that the intent was updated. When you create an intent, the creation date and last updated date are the same.</p>', 'IntentMetadata$createdDate' => '<p>The date that the intent was created.</p>', 'PutBotAliasResponse$lastUpdatedDate' => '<p>The date that the bot alias was updated. When you create a resource, the creation date and the last updated date are the same.</p>', 'PutBotAliasResponse$createdDate' => '<p>The date that the bot alias was created.</p>', 'PutBotResponse$lastUpdatedDate' => '<p>The date that the bot was updated. When you create a resource, the creation date and last updated date are the same.</p>', 'PutBotResponse$createdDate' => '<p>The date that the bot was created.</p>', 'PutIntentResponse$lastUpdatedDate' => '<p>The date that the intent was updated. When you create a resource, the creation date and last update dates are the same.</p>', 'PutIntentResponse$createdDate' => '<p>The date that the intent was created.</p>', 'PutSlotTypeResponse$lastUpdatedDate' => '<p>The date that the slot type was updated. When you create a slot type, the creation date and last update date are the same.</p>', 'PutSlotTypeResponse$createdDate' => '<p>The date that the slot type was created.</p>', 'SlotTypeMetadata$lastUpdatedDate' => '<p>The date that the slot type was updated. When you create a resource, the creation date and last updated date are the same. </p>', 'SlotTypeMetadata$createdDate' => '<p>The date that the slot type was created.</p>', 'UtteranceData$firstUtteredDate' => '<p>The date that the utterance was first recorded.</p>', 'UtteranceData$lastUtteredDate' => '<p>The date that the utterance was last recorded.</p>', ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'DeleteUtterancesRequest$userId' => '<p> The unique identifier for the user that made the utterances. This is the user ID that was sent in the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> operation request that contained the utterance.</p>', ], ], 'Utterance' => [ 'base' => NULL, 'refs' => [ 'IntentUtteranceList$member' => NULL, 'SlotUtteranceList$member' => NULL, ], ], 'UtteranceData' => [ 'base' => '<p>Provides information about a single utterance that was made to your bot. </p>', 'refs' => [ 'ListOfUtterance$member' => NULL, ], ], 'UtteranceList' => [ 'base' => '<p>Provides a list of utterances that have been made to a specific version of your bot. The list contains a maximum of 100 utterances.</p>', 'refs' => [ 'ListsOfUtterances$member' => NULL, ], ], 'UtteranceString' => [ 'base' => NULL, 'refs' => [ 'UtteranceData$utteranceString' => '<p>The text that was entered by the user or the text representation of an audio clip.</p>', ], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'EnumerationValue$value' => '<p>The value of the slot type.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'BotAliasMetadata$botVersion' => '<p>The version of the Amazon Lex bot to which the alias points.</p>', 'BotMetadata$version' => '<p>The version of the bot. For a new bot, the version is always <code>$LATEST</code>.</p>', 'BotVersions$member' => NULL, 'CreateBotVersionResponse$version' => '<p>The version of the bot. </p>', 'CreateIntentVersionResponse$version' => '<p>The version number assigned to the new version of the intent.</p>', 'CreateSlotTypeVersionResponse$version' => '<p>The version assigned to the new slot type version. </p>', 'GetBotAliasResponse$botVersion' => '<p>The version of the bot that the alias points to.</p>', 'GetBotResponse$version' => '<p>The version of the bot. For a new bot, the version is always <code>$LATEST</code>.</p>', 'GetIntentRequest$version' => '<p>The version of the intent.</p>', 'GetIntentResponse$version' => '<p>The version of the intent.</p>', 'GetSlotTypeRequest$version' => '<p>The version of the slot type. </p>', 'GetSlotTypeResponse$version' => '<p>The version of the slot type.</p>', 'Intent$intentVersion' => '<p>The version of the intent.</p>', 'IntentMetadata$version' => '<p>The version of the intent.</p>', 'PutBotAliasRequest$botVersion' => '<p>The version of the bot.</p>', 'PutBotAliasResponse$botVersion' => '<p>The version of the bot that the alias points to.</p>', 'PutBotResponse$version' => '<p>The version of the bot. For a new bot, the version is always <code>$LATEST</code>.</p>', 'PutIntentResponse$version' => '<p>The version of the intent. For a new intent, the version is always <code>$LATEST</code>.</p>', 'PutSlotTypeResponse$version' => '<p>The version of the slot type. For a new slot type, the version is always <code>$LATEST</code>. </p>', 'ResourceReference$version' => '<p>The version of the resource that is using the resource that you are trying to delete.</p>', 'Slot$slotTypeVersion' => '<p>The version of the slot type.</p>', 'SlotTypeMetadata$version' => '<p>The version of the slot type.</p>', 'UtteranceList$botVersion' => '<p>The version of the bot that processed the list.</p>', ], ], ],];
