<?php
// This file was auto-generated from sdk-root/src/data/lightsail/2016-11-28/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Lightsail is the easiest way to get started with AWS for developers who just need virtual private servers. Lightsail includes everything you need to launch your project quickly - a virtual machine, SSD-based storage, data transfer, DNS management, and a static IP - for a low, predictable price. You manage those Lightsail servers through the Lightsail console or by using the API or command-line interface (CLI).</p> <p>For more information about Lightsail concepts and tasks, see the <a href="https://lightsail.aws.amazon.com/ls/docs/all">Lightsail Dev Guide</a>.</p> <p>To use the Lightsail API or the CLI, you will need to use AWS Identity and Access Management (IAM) to generate access keys. For details about how to set this up, see the <a href="http://lightsail.aws.amazon.com/ls/docs/how-to/article/lightsail-how-to-set-up-access-keys-to-use-sdk-api-cli">Lightsail Dev Guide</a>.</p>', 'operations' => [ 'AllocateStaticIp' => '<p>Allocates a static IP address.</p>', 'AttachStaticIp' => '<p>Attaches a static IP address to a specific Amazon Lightsail instance.</p>', 'CloseInstancePublicPorts' => '<p>Closes the public ports on a specific Amazon Lightsail instance.</p>', 'CreateDomain' => '<p>Creates a domain resource for the specified domain (e.g., example.com).</p>', 'CreateDomainEntry' => '<p>Creates one of the following entry records associated with the domain: A record, CNAME record, TXT record, or MX record.</p>', 'CreateInstanceSnapshot' => '<p>Creates a snapshot of a specific virtual private server, or <i>instance</i>. You can use a snapshot to create a new instance that is based on that snapshot.</p>', 'CreateInstances' => '<p>Creates one or more Amazon Lightsail virtual private servers, or <i>instances</i>.</p>', 'CreateInstancesFromSnapshot' => '<p>Uses a specific snapshot as a blueprint for creating one or more new instances that are based on that identical configuration.</p>', 'CreateKeyPair' => '<p>Creates sn SSH key pair.</p>', 'DeleteDomain' => '<p>Deletes the specified domain recordset and all of its domain records.</p>', 'DeleteDomainEntry' => '<p>Deletes a specific domain entry.</p>', 'DeleteInstance' => '<p>Deletes a specific Amazon Lightsail virtual private server, or <i>instance</i>.</p>', 'DeleteInstanceSnapshot' => '<p>Deletes a specific snapshot of a virtual private server (or <i>instance</i>).</p>', 'DeleteKeyPair' => '<p>Deletes a specific SSH key pair.</p>', 'DetachStaticIp' => '<p>Detaches a static IP from the Amazon Lightsail instance to which it is attached.</p>', 'DownloadDefaultKeyPair' => '<p>Downloads the default SSH key pair from the user\'s account.</p>', 'GetActiveNames' => '<p>Returns the names of all active (not deleted) resources.</p>', 'GetBlueprints' => '<p>Returns the list of available instance images, or <i>blueprints</i>. You can use a blueprint to create a new virtual private server already running a specific operating system, as well as a preinstalled app or development stack. The software each instance is running depends on the blueprint image you choose.</p>', 'GetBundles' => '<p>Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual private server (or <i>instance</i>).</p>', 'GetDomain' => '<p>Returns information about a specific domain recordset.</p>', 'GetDomains' => '<p>Returns a list of all domains in the user\'s account.</p>', 'GetInstance' => '<p>Returns information about a specific Amazon Lightsail instance, which is a virtual private server.</p>', 'GetInstanceAccessDetails' => '<p>Returns temporary SSH keys you can use to connect to a specific virtual private server, or <i>instance</i>.</p>', 'GetInstanceMetricData' => '<p>Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.</p>', 'GetInstancePortStates' => '<p>Returns the port states for a specific virtual private server, or <i>instance</i>.</p>', 'GetInstanceSnapshot' => '<p>Returns information about a specific instance snapshot.</p>', 'GetInstanceSnapshots' => '<p>Returns all instance snapshots for the user\'s account.</p>', 'GetInstanceState' => '<p>Returns the state of a specific instance. Works on one instance at a time.</p>', 'GetInstances' => '<p>Returns information about all Amazon Lightsail virtual private servers, or <i>instances</i>.</p>', 'GetKeyPair' => '<p>Returns information about a specific key pair.</p>', 'GetKeyPairs' => '<p>Returns information about all key pairs in the user\'s account.</p>', 'GetOperation' => '<p>Returns information about a specific operation. Operations include events such as when you create an instance, allocate a static IP, attach a static IP, and so on.</p>', 'GetOperations' => '<p>Returns information about all operations.</p> <p>Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each subsequent call to <code>GetOperations</code> use the maximum (last) <code>statusChangedAt</code> value from the previous request.</p>', 'GetOperationsForResource' => '<p>Gets operations for a specific resource (e.g., an instance or a static IP).</p>', 'GetRegions' => '<p>Returns a list of all valid regions for Amazon Lightsail. Use the <code>include availability zones</code> parameter to also return the availability zones in a region.</p>', 'GetStaticIp' => '<p>Returns information about a specific static IP.</p>', 'GetStaticIps' => '<p>Returns information about all static IPs in the user\'s account.</p>', 'ImportKeyPair' => '<p>Imports a public SSH key from a specific key pair.</p>', 'IsVpcPeered' => '<p>Returns a Boolean value indicating whether your Lightsail VPC is peered.</p>', 'OpenInstancePublicPorts' => '<p>Adds public ports to an Amazon Lightsail instance.</p>', 'PeerVpc' => '<p>Tries to peer the Lightsail VPC with the user\'s default VPC.</p>', 'PutInstancePublicPorts' => '<p>Sets the specified open ports for an Amazon Lightsail instance, and closes all ports for every protocol not included in the current request.</p>', 'RebootInstance' => '<p>Restarts a specific instance. When your Amazon Lightsail instance is finished rebooting, Lightsail assigns a new public IP address. To use the same IP address after restarting, create a static IP address and attach it to the instance.</p>', 'ReleaseStaticIp' => '<p>Deletes a specific static IP from your account.</p>', 'StartInstance' => '<p>Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the reboot instance operation.</p>', 'StopInstance' => '<p>Stops a specific Amazon Lightsail instance that is currently running.</p>', 'UnpeerVpc' => '<p>Attempts to unpeer the Lightsail VPC from the user\'s default VPC.</p>', 'UpdateDomainEntry' => '<p>Updates a domain recordset after it is created.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to access a resource.</p>', 'refs' => [], ], 'AccessDirection' => [ 'base' => NULL, 'refs' => [ 'InstancePortInfo$accessDirection' => '<p>The access direction (<code>inbound</code> or <code>outbound</code>).</p>', ], ], 'AccountSetupInProgressException' => [ 'base' => '<p>Lightsail throws this exception when an account is still in the setup in progress state.</p>', 'refs' => [], ], 'AllocateStaticIpRequest' => [ 'base' => NULL, 'refs' => [], ], 'AllocateStaticIpResult' => [ 'base' => NULL, 'refs' => [], ], 'AttachStaticIpRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachStaticIpResult' => [ 'base' => NULL, 'refs' => [], ], 'AvailabilityZone' => [ 'base' => '<p>Describes an Availability Zone.</p>', 'refs' => [ 'AvailabilityZoneList$member' => NULL, ], ], 'AvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'Region$availabilityZones' => '<p>The Availability Zones. Follows the format <code>us-east-1a</code> (case-sensitive).</p>', ], ], 'Base64' => [ 'base' => NULL, 'refs' => [ 'CreateKeyPairResult$publicKeyBase64' => '<p>A base64-encoded public key of the <code>ssh-rsa</code> type.</p>', 'CreateKeyPairResult$privateKeyBase64' => '<p>A base64-encoded RSA private key.</p>', 'DownloadDefaultKeyPairResult$publicKeyBase64' => '<p>A base64-encoded public key of the <code>ssh-rsa</code> type.</p>', 'DownloadDefaultKeyPairResult$privateKeyBase64' => '<p>A base64-encoded RSA private key.</p>', 'ImportKeyPairRequest$publicKeyBase64' => '<p>A base64-encoded public key of the <code>ssh-rsa</code> type.</p>', 'KeyPair$fingerprint' => '<p>The RSA fingerprint of the key pair.</p>', ], ], 'Blueprint' => [ 'base' => '<p>Describes a blueprint (a virtual private server image).</p>', 'refs' => [ 'BlueprintList$member' => NULL, ], ], 'BlueprintList' => [ 'base' => NULL, 'refs' => [ 'GetBlueprintsResult$blueprints' => '<p>An array of key-value pairs that contains information about the available blueprints.</p>', ], ], 'BlueprintType' => [ 'base' => NULL, 'refs' => [ 'Blueprint$type' => '<p>The type of the blueprint (e.g., <code>os</code> or <code>app</code>).</p>', ], ], 'Bundle' => [ 'base' => '<p>Describes a bundle, which is a set of specs describing your virtual private server (or <i>instance</i>).</p>', 'refs' => [ 'BundleList$member' => NULL, ], ], 'BundleList' => [ 'base' => NULL, 'refs' => [ 'GetBundlesResult$bundles' => '<p>An array of key-value pairs that contains information about the available bundles.</p>', ], ], 'CloseInstancePublicPortsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CloseInstancePublicPortsResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainEntryResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstancesFromSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstancesFromSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKeyPairResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainEntryResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKeyPairResult' => [ 'base' => NULL, 'refs' => [], ], 'DetachStaticIpRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachStaticIpResult' => [ 'base' => NULL, 'refs' => [], ], 'Disk' => [ 'base' => '<p>Describes the hard disk (an SSD).</p>', 'refs' => [ 'DiskList$member' => NULL, ], ], 'DiskList' => [ 'base' => NULL, 'refs' => [ 'InstanceHardware$disks' => '<p>The disks attached to the instance.</p>', ], ], 'Domain' => [ 'base' => '<p>Describes a domain where you are storing recordsets in Lightsail.</p>', 'refs' => [ 'DomainList$member' => NULL, 'GetDomainResult$domain' => '<p>An array of key-value pairs containing information about your get domain request.</p>', ], ], 'DomainEntry' => [ 'base' => '<p>Describes a domain recordset entry.</p>', 'refs' => [ 'CreateDomainEntryRequest$domainEntry' => '<p>An array of key-value pairs containing information about the domain entry request.</p>', 'DeleteDomainEntryRequest$domainEntry' => '<p>An array of key-value pairs containing information about your domain entries.</p>', 'DomainEntryList$member' => NULL, 'UpdateDomainEntryRequest$domainEntry' => '<p>An array of key-value pairs containing information about the domain entry.</p>', ], ], 'DomainEntryList' => [ 'base' => NULL, 'refs' => [ 'Domain$domainEntries' => '<p>An array of key-value pairs containing information about the domain entries.</p>', ], ], 'DomainEntryOptions' => [ 'base' => NULL, 'refs' => [ 'DomainEntry$options' => '<p>The options for the domain entry.</p>', ], ], 'DomainEntryOptionsKeys' => [ 'base' => NULL, 'refs' => [ 'DomainEntryOptions$key' => NULL, ], ], 'DomainEntryType' => [ 'base' => NULL, 'refs' => [ 'DomainEntry$type' => '<p>The type of domain entry (e.g., <code>SOA</code> or <code>NS</code>).</p>', ], ], 'DomainList' => [ 'base' => NULL, 'refs' => [ 'GetDomainsResult$domains' => '<p>An array of key-value pairs containing information about each of the domain entries in the user\'s account.</p>', ], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'CreateDomainEntryRequest$domainName' => '<p>The domain name (e.g., <code>example.com</code>) for which you want to create the domain entry.</p>', 'CreateDomainRequest$domainName' => '<p>The domain name to manage (e.g., <code>example.com</code>).</p> <note> <p>You cannot register a new domain name using Lightsail. You must register a domain name using Amazon Route 53 or another domain name registrar. If you have already registered your domain, you can enter its name in this parameter to manage the DNS records for that domain.</p> </note>', 'DeleteDomainEntryRequest$domainName' => '<p>The name of the domain entry to delete.</p>', 'DeleteDomainRequest$domainName' => '<p>The specific domain name to delete.</p>', 'DomainEntry$name' => '<p>The name of the domain.</p>', 'GetDomainRequest$domainName' => '<p>The domain name for which your want to return information about.</p>', 'UpdateDomainEntryRequest$domainName' => '<p>The name of the domain recordset to update.</p>', ], ], 'DownloadDefaultKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'DownloadDefaultKeyPairResult' => [ 'base' => NULL, 'refs' => [], ], 'GetActiveNamesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetActiveNamesResult' => [ 'base' => NULL, 'refs' => [], ], 'GetBlueprintsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBlueprintsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetBundlesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBundlesResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDomainsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInstanceAccessDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInstanceAccessDetailsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInstanceMetricDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInstanceMetricDataResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInstancePortStatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInstancePortStatesResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInstanceSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInstanceSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInstanceSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInstanceSnapshotsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInstanceStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInstanceStateResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyPairResult' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyPairsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyPairsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetOperationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOperationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetOperationsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOperationsForResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'GetOperationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOperationsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetRegionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRegionsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetStaticIpRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStaticIpResult' => [ 'base' => NULL, 'refs' => [], ], 'GetStaticIpsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStaticIpsResult' => [ 'base' => NULL, 'refs' => [], ], 'ImportKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportKeyPairResult' => [ 'base' => NULL, 'refs' => [], ], 'Instance' => [ 'base' => '<p>Describes an instance (a virtual private server).</p>', 'refs' => [ 'GetInstanceResult$instance' => '<p>An array of key-value pairs containing information about the specified instance.</p>', 'InstanceList$member' => NULL, ], ], 'InstanceAccessDetails' => [ 'base' => '<p>The parameters for gaining temporary access to one of your Amazon Lightsail instances.</p>', 'refs' => [ 'GetInstanceAccessDetailsResult$accessDetails' => '<p>An array of key-value pairs containing information about a get instance access request.</p>', ], ], 'InstanceAccessProtocol' => [ 'base' => NULL, 'refs' => [ 'GetInstanceAccessDetailsRequest$protocol' => '<p>The protocol to use to connect to your instance. Defaults to <code>ssh</code>.</p>', 'InstanceAccessDetails$protocol' => '<p>The protocol for these Amazon Lightsail instance access details.</p>', ], ], 'InstanceHardware' => [ 'base' => '<p>Describes the hardware for the instance.</p>', 'refs' => [ 'Instance$hardware' => '<p>The size of the vCPU and the amount of RAM for the instance.</p>', ], ], 'InstanceList' => [ 'base' => NULL, 'refs' => [ 'GetInstancesResult$instances' => '<p>An array of key-value pairs containing information about your instances.</p>', ], ], 'InstanceMetricName' => [ 'base' => NULL, 'refs' => [ 'GetInstanceMetricDataRequest$metricName' => '<p>The metric name to get data about. </p>', 'GetInstanceMetricDataResult$metricName' => '<p>The metric name to return data for. </p>', ], ], 'InstanceNetworking' => [ 'base' => '<p>Describes monthly data transfer rates and port information for an instance.</p>', 'refs' => [ 'Instance$networking' => '<p>Information about the public ports and monthly data transfer rates for the instance.</p>', ], ], 'InstancePortInfo' => [ 'base' => '<p>Describes information about the instance ports.</p>', 'refs' => [ 'InstancePortInfoList$member' => NULL, ], ], 'InstancePortInfoList' => [ 'base' => NULL, 'refs' => [ 'InstanceNetworking$ports' => '<p>An array of key-value pairs containing information about the ports on the instance.</p>', ], ], 'InstancePortState' => [ 'base' => '<p>Describes the port state.</p>', 'refs' => [ 'InstancePortStateList$member' => NULL, ], ], 'InstancePortStateList' => [ 'base' => NULL, 'refs' => [ 'GetInstancePortStatesResult$portStates' => '<p>Information about the port states resulting from your request.</p>', ], ], 'InstanceSnapshot' => [ 'base' => '<p>Describes the snapshot of the virtual private server, or <i>instance</i>.</p>', 'refs' => [ 'GetInstanceSnapshotResult$instanceSnapshot' => '<p>An array of key-value pairs containing information about the results of your get instance snapshot request.</p>', 'InstanceSnapshotList$member' => NULL, ], ], 'InstanceSnapshotList' => [ 'base' => NULL, 'refs' => [ 'GetInstanceSnapshotsResult$instanceSnapshots' => '<p>An array of key-value pairs containing information about the results of your get instance snapshots request.</p>', ], ], 'InstanceSnapshotState' => [ 'base' => NULL, 'refs' => [ 'InstanceSnapshot$state' => '<p>The state the snapshot is in.</p>', ], ], 'InstanceState' => [ 'base' => '<p>Describes the virtual private server (or <i>instance</i>) status.</p>', 'refs' => [ 'GetInstanceStateResult$state' => '<p>The state of the instance.</p>', 'Instance$state' => '<p>The status code and the state (e.g., <code>running</code>) for the instance.</p>', ], ], 'InvalidInputException' => [ 'base' => '<p>Lightsail throws this exception when user input does not conform to the validation rules of an input field.</p> <note> <p>Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region configuration to us-east-1 to create, view, or edit these resources.</p> </note>', 'refs' => [], ], 'IpAddress' => [ 'base' => NULL, 'refs' => [ 'Instance$privateIpAddress' => '<p>The private IP address of the instance.</p>', 'Instance$publicIpAddress' => '<p>The public IP address of the instance.</p>', 'InstanceAccessDetails$ipAddress' => '<p>The public IP address of the Amazon Lightsail instance.</p>', 'StaticIp$ipAddress' => '<p>The static IP address.</p>', ], ], 'IpV6Address' => [ 'base' => NULL, 'refs' => [ 'Instance$ipv6Address' => '<p>The IPv6 address of the instance.</p>', ], ], 'IsVpcPeeredRequest' => [ 'base' => NULL, 'refs' => [], ], 'IsVpcPeeredResult' => [ 'base' => NULL, 'refs' => [], ], 'IsoDate' => [ 'base' => NULL, 'refs' => [ 'Disk$createdAt' => '<p>The date when the disk was created.</p>', 'Domain$createdAt' => '<p>The date when the domain recordset was created.</p>', 'Instance$createdAt' => '<p>The timestamp when the instance was created (e.g., <code>1479734909.17</code>).</p>', 'InstanceAccessDetails$expiresAt' => '<p>For SSH access, the date on which the temporary keys expire.</p>', 'InstanceSnapshot$createdAt' => '<p>The timestamp when the snapshot was created (e.g., <code>1479907467.024</code>).</p>', 'KeyPair$createdAt' => '<p>The timestamp when the key pair was created (e.g., <code>1479816991.349</code>).</p>', 'Operation$createdAt' => '<p>The timestamp when the operation was initialized (e.g., <code>1479816991.349</code>).</p>', 'Operation$statusChangedAt' => '<p>The timestamp when the status was changed (e.g., <code>1479816991.349</code>).</p>', 'StaticIp$createdAt' => '<p>The timestamp when the static IP was created (e.g., <code>1479735304.222</code>).</p>', ], ], 'KeyPair' => [ 'base' => '<p>Describes the SSH key pair.</p>', 'refs' => [ 'CreateKeyPairResult$keyPair' => '<p>An array of key-value pairs containing information about the new key pair you just created.</p>', 'GetKeyPairResult$keyPair' => '<p>An array of key-value pairs containing information about the key pair.</p>', 'KeyPairList$member' => NULL, ], ], 'KeyPairList' => [ 'base' => NULL, 'refs' => [ 'GetKeyPairsResult$keyPairs' => '<p>An array of key-value pairs containing information about the key pairs.</p>', ], ], 'MetricDatapoint' => [ 'base' => '<p>Describes the metric data point.</p>', 'refs' => [ 'MetricDatapointList$member' => NULL, ], ], 'MetricDatapointList' => [ 'base' => NULL, 'refs' => [ 'GetInstanceMetricDataResult$metricData' => '<p>An array of key-value pairs containing information about the results of your get instance metric data request.</p>', ], ], 'MetricPeriod' => [ 'base' => NULL, 'refs' => [ 'GetInstanceMetricDataRequest$period' => '<p>The time period for which you are requesting data.</p>', ], ], 'MetricStatistic' => [ 'base' => NULL, 'refs' => [ 'MetricStatisticList$member' => NULL, ], ], 'MetricStatisticList' => [ 'base' => NULL, 'refs' => [ 'GetInstanceMetricDataRequest$statistics' => '<p>The instance statistics. </p>', ], ], 'MetricUnit' => [ 'base' => NULL, 'refs' => [ 'GetInstanceMetricDataRequest$unit' => '<p>The unit. The list of valid values is below.</p>', 'MetricDatapoint$unit' => '<p>The unit. </p>', ], ], 'MonthlyTransfer' => [ 'base' => '<p>Describes the monthly data transfer in and out of your virtual private server (or <i>instance</i>).</p>', 'refs' => [ 'InstanceNetworking$monthlyTransfer' => '<p>The amount of data in GB allocated for monthly data transfers.</p>', ], ], 'NetworkProtocol' => [ 'base' => NULL, 'refs' => [ 'InstancePortInfo$protocol' => '<p>The protocol being used. Can be one of the following.</p> <ul> <li> <p> <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery of streamed data between applications running on hosts communicating by an IP network. If you have an application that doesn\'t require reliable data stream service, use UDP instead.</p> </li> <li> <p> <code>all</code> - All transport layer protocol types. For more general information, see <a href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.</p> </li> <li> <p> <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up transmission channels or data paths. Applications that don\'t require reliable data stream service can use UDP, which provides a connectionless datagram service that emphasizes reduced latency over reliability. If you do require reliable data stream service, use TCP instead.</p> </li> </ul>', 'InstancePortState$protocol' => '<p>The protocol being used. Can be one of the following.</p> <ul> <li> <p> <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery of streamed data between applications running on hosts communicating by an IP network. If you have an application that doesn\'t require reliable data stream service, use UDP instead.</p> </li> <li> <p> <code>all</code> - All transport layer protocol types. For more general information, see <a href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.</p> </li> <li> <p> <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up transmission channels or data paths. Applications that don\'t require reliable data stream service can use UDP, which provides a connectionless datagram service that emphasizes reduced latency over reliability. If you do require reliable data stream service, use TCP instead.</p> </li> </ul>', 'PortInfo$protocol' => '<p>The protocol. </p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$zoneName' => '<p>The name of the Availability Zone. The format is <code>us-east-1a</code> (case-sensitive).</p>', 'AvailabilityZone$state' => '<p>The state of the Availability Zone.</p>', 'Blueprint$blueprintId' => '<p>The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or <code>app_lamp_7_0</code>).</p>', 'Blueprint$group' => '<p>The group name of the blueprint (e.g., <code>amazon-linux</code>).</p>', 'Bundle$bundleId' => '<p>The bundle ID (e.g., <code>micro_1_0</code>).</p>', 'CreateInstancesFromSnapshotRequest$bundleId' => '<p>The bundle of specification information for your virtual private server (or <i>instance</i>), including the pricing plan (e.g., <code>micro_1_0</code>).</p>', 'CreateInstancesRequest$blueprintId' => '<p>The ID for a virtual private server image (e.g., <code>app_wordpress_4_4</code> or <code>app_lamp_7_0</code>). Use the get blueprints operation to return a list of available images (or <i>blueprints</i>).</p>', 'CreateInstancesRequest$bundleId' => '<p>The bundle of specification information for your virtual private server (or <i>instance</i>), including the pricing plan (e.g., <code>micro_1_0</code>).</p>', 'Disk$arn' => '<p>The Amazon Resource Name (ARN) of the disk.</p>', 'Domain$arn' => '<p>The Amazon Resource Name (ARN) of the domain recordset (e.g., <code>arn:aws:lightsail:global:123456789101:Domain/824cede0-abc7-4f84-8dbc-12345EXAMPLE</code>).</p>', 'DomainEntry$id' => '<p>The ID of the domain recordset entry.</p>', 'GetOperationRequest$operationId' => '<p>A GUID used to identify the operation.</p>', 'Instance$arn' => '<p>The Amazon Resource Name (ARN) of the instance (e.g., <code>arn:aws:lightsail:us-east-1:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).</p>', 'Instance$blueprintId' => '<p>The blueprint ID (e.g., <code>os_amlinux_2016_03</code>).</p>', 'Instance$blueprintName' => '<p>The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).</p>', 'Instance$bundleId' => '<p>The bundle for the instance (e.g., <code>micro_1_0</code>).</p>', 'Instance$username' => '<p>The user name for connecting to the instance (e.g., <code>ec2-user</code>).</p>', 'InstanceSnapshot$arn' => '<p>The Amazon Resource Name (ARN) of the snapshot (e.g., <code>arn:aws:lightsail:us-east-1:123456789101:InstanceSnapshot/d23b5706-3322-4d83-81e5-12345EXAMPLE</code>).</p>', 'InstanceSnapshot$fromInstanceArn' => '<p>The Amazon Resource Name (ARN) of the instance from which the snapshot was created (e.g., <code>arn:aws:lightsail:us-east-1:123456789101:Instance/64b8404c-ccb1-430b-8daf-12345EXAMPLE</code>).</p>', 'KeyPair$arn' => '<p>The Amazon Resource Name (ARN) of the key pair (e.g., <code>arn:aws:lightsail:us-east-1:123456789101:KeyPair/05859e3d-331d-48ba-9034-12345EXAMPLE</code>).</p>', 'Operation$id' => '<p>The ID of the operation.</p>', 'StaticIp$arn' => '<p>The Amazon Resource Name (ARN) of the static IP (e.g., <code>arn:aws:lightsail:us-east-1:123456789101:StaticIp/9cbb4a9e-f8e3-4dfe-b57e-12345EXAMPLE</code>).</p>', ], ], 'NotFoundException' => [ 'base' => '<p>Lightsail throws this exception when it cannot find a resource.</p>', 'refs' => [], ], 'OpenInstancePublicPortsRequest' => [ 'base' => NULL, 'refs' => [], ], 'OpenInstancePublicPortsResult' => [ 'base' => NULL, 'refs' => [], ], 'Operation' => [ 'base' => '<p>Describes the API operation.</p>', 'refs' => [ 'CloseInstancePublicPortsResult$operation' => '<p>An array of key-value pairs that contains information about the operation.</p>', 'CreateDomainEntryResult$operation' => '<p>An array of key-value pairs containing information about the operation.</p>', 'CreateDomainResult$operation' => '<p>An array of key-value pairs containing information about the domain resource you created.</p>', 'CreateKeyPairResult$operation' => '<p>An array of key-value pairs containing information about the results of your create key pair request.</p>', 'DeleteDomainEntryResult$operation' => '<p>An array of key-value pairs containing information about the results of your delete domain entry request.</p>', 'DeleteDomainResult$operation' => '<p>An array of key-value pairs containing information about the results of your delete domain request.</p>', 'DeleteKeyPairResult$operation' => '<p>An array of key-value pairs containing information about the results of your delete key pair request.</p>', 'GetOperationResult$operation' => '<p>An array of key-value pairs containing information about the results of your get operation request.</p>', 'ImportKeyPairResult$operation' => '<p>An array of key-value pairs containing information about the request operation.</p>', 'OpenInstancePublicPortsResult$operation' => '<p>An array of key-value pairs containing information about the request operation.</p>', 'OperationList$member' => NULL, 'PeerVpcResult$operation' => '<p>An array of key-value pairs containing information about the request operation.</p>', 'PutInstancePublicPortsResult$operation' => '<p>Describes metadata about the operation you just executed.</p>', 'UnpeerVpcResult$operation' => '<p>An array of key-value pairs containing information about the request operation.</p>', ], ], 'OperationFailureException' => [ 'base' => '<p>Lightsail throws this exception when an operation fails to execute.</p>', 'refs' => [], ], 'OperationList' => [ 'base' => NULL, 'refs' => [ 'AllocateStaticIpResult$operations' => '<p>An array of key-value pairs containing information about the static IP address you allocated.</p>', 'AttachStaticIpResult$operations' => '<p>An array of key-value pairs containing information about your API operations.</p>', 'CreateInstanceSnapshotResult$operations' => '<p>An array of key-value pairs containing information about the results of your create instances snapshot request.</p>', 'CreateInstancesFromSnapshotResult$operations' => '<p>An array of key-value pairs containing information about the results of your create instances from snapshot request.</p>', 'CreateInstancesResult$operations' => '<p>An array of key-value pairs containing information about the results of your create instances request.</p>', 'DeleteInstanceResult$operations' => '<p>An array of key-value pairs containing information about the results of your delete instance request.</p>', 'DeleteInstanceSnapshotResult$operations' => '<p>An array of key-value pairs containing information about the results of your delete instance snapshot request.</p>', 'DetachStaticIpResult$operations' => '<p>An array of key-value pairs containing information about the results of your detach static IP request.</p>', 'GetOperationsForResourceResult$operations' => '<p>An array of key-value pairs containing information about the results of your get operations for resource request.</p>', 'GetOperationsResult$operations' => '<p>An array of key-value pairs containing information about the results of your get operations request.</p>', 'RebootInstanceResult$operations' => '<p>An array of key-value pairs containing information about the request operation.</p>', 'ReleaseStaticIpResult$operations' => '<p>An array of key-value pairs containing information about the request operation.</p>', 'StartInstanceResult$operations' => '<p>An array of key-value pairs containing information about the request operation.</p>', 'StopInstanceResult$operations' => '<p>An array of key-value pairs containing information about the request operation.</p>', 'UpdateDomainEntryResult$operations' => '<p>An array of key-value pairs containing information about the request operation.</p>', ], ], 'OperationStatus' => [ 'base' => NULL, 'refs' => [ 'Operation$status' => '<p>The status of the operation. </p>', ], ], 'OperationType' => [ 'base' => NULL, 'refs' => [ 'Operation$operationType' => '<p>The type of operation. </p>', ], ], 'PeerVpcRequest' => [ 'base' => NULL, 'refs' => [], ], 'PeerVpcResult' => [ 'base' => NULL, 'refs' => [], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'InstancePortInfo$fromPort' => '<p>The first port in the range.</p>', 'InstancePortInfo$toPort' => '<p>The last port in the range.</p>', 'InstancePortState$fromPort' => '<p>The first port in the range.</p>', 'InstancePortState$toPort' => '<p>The last port in the range.</p>', 'PortInfo$fromPort' => '<p>The first port in the range.</p>', 'PortInfo$toPort' => '<p>The last port in the range.</p>', ], ], 'PortAccessType' => [ 'base' => NULL, 'refs' => [ 'InstancePortInfo$accessType' => '<p>The type of access (<code>Public</code> or <code>Private</code>).</p>', ], ], 'PortInfo' => [ 'base' => '<p>Describes information about the ports on your virtual private server (or <i>instance</i>).</p>', 'refs' => [ 'CloseInstancePublicPortsRequest$portInfo' => '<p>Information about the public port you are trying to close.</p>', 'OpenInstancePublicPortsRequest$portInfo' => '<p>An array of key-value pairs containing information about the port mappings.</p>', 'PortInfoList$member' => NULL, ], ], 'PortInfoList' => [ 'base' => NULL, 'refs' => [ 'PutInstancePublicPortsRequest$portInfos' => '<p>Specifies information about the public port(s).</p>', ], ], 'PortState' => [ 'base' => NULL, 'refs' => [ 'InstancePortState$state' => '<p>Specifies whether the instance port is <code>open</code> or <code>closed</code>.</p>', ], ], 'PutInstancePublicPortsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutInstancePublicPortsResult' => [ 'base' => NULL, 'refs' => [], ], 'RebootInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RebootInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'Region' => [ 'base' => '<p>Describes the AWS Region.</p>', 'refs' => [ 'RegionList$member' => NULL, ], ], 'RegionList' => [ 'base' => NULL, 'refs' => [ 'GetRegionsResult$regions' => '<p>An array of key-value pairs containing information about your get regions request.</p>', ], ], 'RegionName' => [ 'base' => NULL, 'refs' => [ 'Region$name' => '<p>The region name (e.g., <code>us-east-1</code>).</p>', 'ResourceLocation$regionName' => '<p>The AWS Region name.</p>', ], ], 'ReleaseStaticIpRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReleaseStaticIpResult' => [ 'base' => NULL, 'refs' => [], ], 'ResourceLocation' => [ 'base' => '<p>Describes the resource location.</p>', 'refs' => [ 'Disk$location' => '<p>The region and Availability Zone where the disk is located.</p>', 'Domain$location' => '<p>The AWS Region and Availability Zones where the domain recordset was created.</p>', 'Instance$location' => '<p>The region name and availability zone where the instance is located.</p>', 'InstanceSnapshot$location' => '<p>The region name and availability zone where you created the snapshot.</p>', 'KeyPair$location' => '<p>The region name and Availability Zone where the key pair was created.</p>', 'Operation$location' => '<p>The region and Availability Zone.</p>', 'StaticIp$location' => '<p>The region and Availability Zone where the static IP was created.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'AllocateStaticIpRequest$staticIpName' => '<p>The name of the static IP address.</p>', 'AttachStaticIpRequest$staticIpName' => '<p>The name of the static IP.</p>', 'AttachStaticIpRequest$instanceName' => '<p>The instance name to which you want to attach the static IP address.</p>', 'Blueprint$name' => '<p>The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).</p>', 'CloseInstancePublicPortsRequest$instanceName' => '<p>The name of the instance on which you\'re attempting to close the public ports.</p>', 'CreateInstanceSnapshotRequest$instanceSnapshotName' => '<p>The name for your new snapshot.</p>', 'CreateInstanceSnapshotRequest$instanceName' => '<p>The Lightsail instance on which to base your snapshot.</p>', 'CreateInstancesFromSnapshotRequest$instanceSnapshotName' => '<p>The name of the instance snapshot on which you are basing your new instances. Use the get instance snapshots operation to return information about your existing snapshots.</p>', 'CreateInstancesFromSnapshotRequest$keyPairName' => '<p>The name for your key pair.</p>', 'CreateInstancesRequest$customImageName' => '<p>(Deprecated) The name for your custom image.</p> <note> <p>In releases prior to June 12, 2017, this parameter was ignored by the API. It is now deprecated.</p> </note>', 'CreateInstancesRequest$keyPairName' => '<p>The name of your key pair.</p>', 'CreateKeyPairRequest$keyPairName' => '<p>The name for your new key pair.</p>', 'DeleteInstanceRequest$instanceName' => '<p>The name of the instance to delete.</p>', 'DeleteInstanceSnapshotRequest$instanceSnapshotName' => '<p>The name of the snapshot to delete.</p>', 'DeleteKeyPairRequest$keyPairName' => '<p>The name of the key pair to delete.</p>', 'DetachStaticIpRequest$staticIpName' => '<p>The name of the static IP to detach from the instance.</p>', 'Disk$name' => '<p>The name of the disk.</p>', 'Domain$name' => '<p>The name of the domain.</p>', 'GetInstanceAccessDetailsRequest$instanceName' => '<p>The name of the instance to access.</p>', 'GetInstanceMetricDataRequest$instanceName' => '<p>The name of the instance for which you want to get metrics data.</p>', 'GetInstancePortStatesRequest$instanceName' => '<p>The name of the instance.</p>', 'GetInstanceRequest$instanceName' => '<p>The name of the instance.</p>', 'GetInstanceSnapshotRequest$instanceSnapshotName' => '<p>The name of the snapshot for which you are requesting information.</p>', 'GetInstanceStateRequest$instanceName' => '<p>The name of the instance to get state information about.</p>', 'GetKeyPairRequest$keyPairName' => '<p>The name of the key pair for which you are requesting information.</p>', 'GetOperationsForResourceRequest$resourceName' => '<p>The name of the resource for which you are requesting information.</p>', 'GetStaticIpRequest$staticIpName' => '<p>The name of the static IP in Lightsail.</p>', 'ImportKeyPairRequest$keyPairName' => '<p>The name of the key pair for which you want to import the public key.</p>', 'Instance$name' => '<p>The name the user gave the instance (e.g., <code>Amazon_Linux-1GB-Virginia-1</code>).</p>', 'Instance$sshKeyName' => '<p>The name of the SSH key being used to connect to the instance (e.g., <code>LightsailDefaultKeyPair</code>).</p>', 'InstanceAccessDetails$instanceName' => '<p>The name of this Amazon Lightsail instance.</p>', 'InstanceSnapshot$name' => '<p>The name of the snapshot.</p>', 'InstanceSnapshot$fromInstanceName' => '<p>The instance from which the snapshot was created.</p>', 'KeyPair$name' => '<p>The friendly name of the SSH key pair.</p>', 'OpenInstancePublicPortsRequest$instanceName' => '<p>The name of the instance for which you want to open the public ports.</p>', 'Operation$resourceName' => '<p>The resource name.</p>', 'PutInstancePublicPortsRequest$instanceName' => '<p>The Lightsail instance name of the public port(s) you are setting.</p>', 'RebootInstanceRequest$instanceName' => '<p>The name of the instance to reboot.</p>', 'ReleaseStaticIpRequest$staticIpName' => '<p>The name of the static IP to delete.</p>', 'StartInstanceRequest$instanceName' => '<p>The name of the instance (a virtual private server) to start.</p>', 'StaticIp$name' => '<p>The name of the static IP (e.g., <code>StaticIP-Virginia-EXAMPLE</code>).</p>', 'StaticIp$attachedTo' => '<p>The instance where the static IP is attached (e.g., <code>Amazon_Linux-1GB-Virginia-1</code>).</p>', 'StopInstanceRequest$instanceName' => '<p>The name of the instance (a virtual private server) to stop.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'Disk$resourceType' => '<p>The resource type of the disk. </p>', 'Domain$resourceType' => '<p>The resource type. </p>', 'Instance$resourceType' => '<p>The type of resource (usually <code>Instance</code>).</p>', 'InstanceSnapshot$resourceType' => '<p>The type of resource (usually <code>InstanceSnapshot</code>).</p>', 'KeyPair$resourceType' => '<p>The resource type (usually <code>KeyPair</code>).</p>', 'Operation$resourceType' => '<p>The resource type. </p>', 'StaticIp$resourceType' => '<p>The resource type (usually <code>StaticIp</code>).</p>', ], ], 'ServiceException' => [ 'base' => '<p>A general service exception.</p>', 'refs' => [], ], 'StartInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'StaticIp' => [ 'base' => '<p>Describes the static IP.</p>', 'refs' => [ 'GetStaticIpResult$staticIp' => '<p>An array of key-value pairs containing information about the requested static IP.</p>', 'StaticIpList$member' => NULL, ], ], 'StaticIpList' => [ 'base' => NULL, 'refs' => [ 'GetStaticIpsResult$staticIps' => '<p>An array of key-value pairs containing information about your get static IPs request.</p>', ], ], 'StopInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'CreateInstancesFromSnapshotRequest$instanceNames' => '<p>The names for your new instances.</p>', 'CreateInstancesRequest$instanceNames' => '<p>The names to use for your new Lightsail instances. Separate multiple values using quotation marks and commas, for example: <code>["MyFirstInstance","MySecondInstance"]</code> </p>', 'GetActiveNamesResult$activeNames' => '<p>The list of active names returned by the get active names request.</p>', ], ], 'UnauthenticatedException' => [ 'base' => '<p>Lightsail throws this exception when the user has not been authenticated.</p>', 'refs' => [], ], 'UnpeerVpcRequest' => [ 'base' => NULL, 'refs' => [], ], 'UnpeerVpcResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainEntryResult' => [ 'base' => NULL, 'refs' => [], ], 'boolean' => [ 'base' => NULL, 'refs' => [ 'Blueprint$isActive' => '<p>A Boolean value indicating whether the blueprint is active. When you update your blueprints, you will inactivate old blueprints and keep the most recent versions active.</p>', 'Bundle$isActive' => '<p>A Boolean value indicating whether the bundle is active.</p>', 'Disk$isSystemDisk' => '<p>A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).</p>', 'Disk$isAttached' => '<p>A Boolean value indicating whether the disk is attached.</p>', 'GetBlueprintsRequest$includeInactive' => '<p>A Boolean value indicating whether to include inactive results in your request.</p>', 'GetBundlesRequest$includeInactive' => '<p>A Boolean value that indicates whether to include inactive bundle results in your request.</p>', 'GetRegionsRequest$includeAvailabilityZones' => '<p>A Boolean value indicating whether to also include Availability Zones in your get regions request. Availability Zones are indicated with a letter: e.g., <code>us-east-1a</code>.</p>', 'Instance$isStaticIp' => '<p>A Boolean value indicating whether this instance has a static IP assigned to it.</p>', 'IsVpcPeeredResult$isPeered' => '<p>Returns <code>true</code> if the Lightsail VPC is peered; otherwise, <code>false</code>.</p>', 'Operation$isTerminal' => '<p>A Boolean value indicating whether the operation is terminal.</p>', 'StaticIp$isAttached' => '<p>A Boolean value indicating whether the static IP is attached.</p>', ], ], 'double' => [ 'base' => NULL, 'refs' => [ 'MetricDatapoint$average' => '<p>The average.</p>', 'MetricDatapoint$maximum' => '<p>The maximum.</p>', 'MetricDatapoint$minimum' => '<p>The minimum.</p>', 'MetricDatapoint$sampleCount' => '<p>The sample count.</p>', 'MetricDatapoint$sum' => '<p>The sum.</p>', ], ], 'float' => [ 'base' => NULL, 'refs' => [ 'Bundle$price' => '<p>The price in US dollars (e.g., <code>5.0</code>).</p>', 'Bundle$ramSizeInGb' => '<p>The amount of RAM in GB (e.g., <code>2.0</code>).</p>', 'InstanceHardware$ramSizeInGb' => '<p>The amount of RAM in GB on the instance (e.g., <code>1.0</code>).</p>', ], ], 'integer' => [ 'base' => NULL, 'refs' => [ 'Blueprint$minPower' => '<p>The minimum machine size required to run this blueprint. <code>0</code> indicates that the blueprint runs on all instances.</p>', 'Bundle$cpuCount' => '<p>The number of vCPUs included in the bundle (e.g., <code>2</code>).</p>', 'Bundle$diskSizeInGb' => '<p>The size of the SSD (e.g., <code>30</code>).</p>', 'Bundle$power' => '<p>The power of the bundle (e.g., <code>500</code>).</p>', 'Bundle$transferPerMonthInGb' => '<p>The data transfer rate per month in GB (e.g., <code>2000</code>).</p>', 'Disk$sizeInGb' => '<p>The size of the disk in GB.</p>', 'Disk$gbInUse' => '<p>The number of GB in use by the disk.</p>', 'Disk$iops' => '<p>The input/output operations per second (IOPS) of the disk.</p>', 'InstanceHardware$cpuCount' => '<p>The number of vCPUs the instance has.</p>', 'InstanceSnapshot$sizeInGb' => '<p>The size in GB of the SSD.</p>', 'InstanceState$code' => '<p>The status code for the instance.</p>', 'MonthlyTransfer$gbPerMonthAllocated' => '<p>The amount allocated per month (in GB).</p>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$code' => NULL, 'AccessDeniedException$docs' => NULL, 'AccessDeniedException$message' => NULL, 'AccessDeniedException$tip' => NULL, 'AccountSetupInProgressException$code' => NULL, 'AccountSetupInProgressException$docs' => NULL, 'AccountSetupInProgressException$message' => NULL, 'AccountSetupInProgressException$tip' => NULL, 'Blueprint$description' => '<p>The description of the blueprint.</p>', 'Blueprint$version' => '<p>The version number of the operating system, application, or stack (e.g., <code>2016.03.0</code>).</p>', 'Blueprint$versionCode' => '<p>The version code.</p>', 'Blueprint$productUrl' => '<p>The product URL to learn more about the image or blueprint.</p>', 'Blueprint$licenseUrl' => '<p>The end-user license agreement URL for the image or blueprint.</p>', 'Bundle$instanceType' => '<p>The Amazon EC2 instance type (e.g., <code>t2.micro</code>).</p>', 'Bundle$name' => '<p>A friendly name for the bundle (e.g., <code>Micro</code>).</p>', 'CreateInstancesFromSnapshotRequest$availabilityZone' => '<p>The Availability Zone where you want to create your instances. Use the following formatting: <code>us-east-1a</code> (case sensitive). You can get a list of availability zones by using the <a href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a> operation. Be sure to add the <code>include availability zones</code> parameter to your request.</p>', 'CreateInstancesFromSnapshotRequest$userData' => '<p>You can create a launch script that configures a server with additional user data. For example, <code>apt-get –y update</code>.</p> <note> <p>Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a complete list, see the <a href="http://lightsail.aws.amazon.com/ls/docs/getting-started/articles/pre-installed-apps">Dev Guide</a>.</p> </note>', 'CreateInstancesRequest$availabilityZone' => '<p>The Availability Zone in which to create your instance. Use the following format: <code>us-east-1a</code> (case sensitive). You can get a list of availability zones by using the <a href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a> operation. Be sure to add the <code>include availability zones</code> parameter to your request.</p>', 'CreateInstancesRequest$userData' => '<p>A launch script you can create that configures a server with additional user data. For example, you might want to run <code>apt-get –y update</code>.</p> <note> <p>Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a complete list, see the <a href="http://lightsail.aws.amazon.com/ls/docs/getting-started/articles/pre-installed-apps">Dev Guide</a>.</p> </note>', 'Disk$supportCode' => '<p>The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.</p>', 'Disk$path' => '<p>The disk path.</p>', 'Disk$attachedTo' => '<p>The resources to which the disk is attached.</p>', 'Disk$attachmentState' => '<p>The attachment state of the disk.</p>', 'Domain$supportCode' => '<p>The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.</p>', 'DomainEntry$target' => '<p>The target AWS name server (e.g., <code>ns-111.awsdns-22.com.</code>).</p>', 'DomainEntryOptions$value' => NULL, 'GetActiveNamesRequest$pageToken' => '<p>A token used for paginating results from your get active names request.</p>', 'GetActiveNamesResult$nextPageToken' => '<p>A token used for advancing to the next page of results from your get active names request.</p>', 'GetBlueprintsRequest$pageToken' => '<p>A token used for advancing to the next page of results from your get blueprints request.</p>', 'GetBlueprintsResult$nextPageToken' => '<p>A token used for advancing to the next page of results from your get blueprints request.</p>', 'GetBundlesRequest$pageToken' => '<p>A token used for advancing to the next page of results from your get bundles request.</p>', 'GetBundlesResult$nextPageToken' => '<p>A token used for advancing to the next page of results from your get active names request.</p>', 'GetDomainsRequest$pageToken' => '<p>A token used for advancing to the next page of results from your get domains request.</p>', 'GetDomainsResult$nextPageToken' => '<p>A token used for advancing to the next page of results from your get active names request.</p>', 'GetInstanceSnapshotsRequest$pageToken' => '<p>A token used for advancing to the next page of results from your get instance snapshots request.</p>', 'GetInstanceSnapshotsResult$nextPageToken' => '<p>A token used for advancing to the next page of results from your get instance snapshots request.</p>', 'GetInstancesRequest$pageToken' => '<p>A token used for advancing to the next page of results from your get instances request.</p>', 'GetInstancesResult$nextPageToken' => '<p>A token used for advancing to the next page of results from your get instances request.</p>', 'GetKeyPairsRequest$pageToken' => '<p>A token used for advancing to the next page of results from your get key pairs request.</p>', 'GetKeyPairsResult$nextPageToken' => '<p>A token used for advancing to the next page of results from your get key pairs request.</p>', 'GetOperationsForResourceRequest$pageToken' => '<p>A token used for advancing to the next page of results from your get operations for resource request.</p>', 'GetOperationsForResourceResult$nextPageCount' => '<p>(Deprecated) Returns the number of pages of results that remain.</p> <note> <p>In releases prior to June 12, 2017, this parameter returned <code>null</code> by the API. It is now deprecated, and the API returns the <code>nextPageToken</code> parameter instead.</p> </note>', 'GetOperationsForResourceResult$nextPageToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'GetOperationsRequest$pageToken' => '<p>A token used for advancing to the next page of results from your get operations request.</p>', 'GetOperationsResult$nextPageToken' => '<p>A token used for advancing to the next page of results from your get operations request.</p>', 'GetStaticIpsRequest$pageToken' => '<p>A token used for advancing to the next page of results from your get static IPs request.</p>', 'GetStaticIpsResult$nextPageToken' => '<p>A token used for advancing to the next page of results from your get static IPs request.</p>', 'Instance$supportCode' => '<p>The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.</p>', 'InstanceAccessDetails$certKey' => '<p>For SSH access, the public key to use when accessing your instance For OpenSSH clients (e.g., command line SSH), you should save this value to <code>tempkey-cert.pub</code>.</p>', 'InstanceAccessDetails$password' => '<p>For RDP access, the temporary password of the Amazon EC2 instance.</p>', 'InstanceAccessDetails$privateKey' => '<p>For SSH access, the temporary private key. For OpenSSH clients (e.g., command line SSH), you should save this value to <code>tempkey</code>).</p>', 'InstanceAccessDetails$username' => '<p>The user name to use when logging in to the Amazon Lightsail instance.</p>', 'InstancePortInfo$accessFrom' => '<p>The location from which access is allowed (e.g., <code>Anywhere (0.0.0.0/0)</code>).</p>', 'InstancePortInfo$commonName' => '<p>The common name.</p>', 'InstanceSnapshot$supportCode' => '<p>The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.</p>', 'InstanceSnapshot$progress' => '<p>The progress of the snapshot.</p>', 'InstanceSnapshot$fromBlueprintId' => '<p>The blueprint ID from which you created the snapshot (e.g., <code>os_debian_8_3</code>). A blueprint is a virtual private server (or <i>instance</i>) image used to create instances quickly.</p>', 'InstanceSnapshot$fromBundleId' => '<p>The bundle ID from which you created the snapshot (e.g., <code>micro_1_0</code>).</p>', 'InstanceState$name' => '<p>The state of the instance (e.g., <code>running</code> or <code>pending</code>).</p>', 'InvalidInputException$code' => NULL, 'InvalidInputException$docs' => NULL, 'InvalidInputException$message' => NULL, 'InvalidInputException$tip' => NULL, 'KeyPair$supportCode' => '<p>The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.</p>', 'NotFoundException$code' => NULL, 'NotFoundException$docs' => NULL, 'NotFoundException$message' => NULL, 'NotFoundException$tip' => NULL, 'Operation$operationDetails' => '<p>Details about the operation (e.g., <code>Debian-1GB-Virginia-1</code>).</p>', 'Operation$errorCode' => '<p>The error code.</p>', 'Operation$errorDetails' => '<p>The error details.</p>', 'OperationFailureException$code' => NULL, 'OperationFailureException$docs' => NULL, 'OperationFailureException$message' => NULL, 'OperationFailureException$tip' => NULL, 'Region$continentCode' => '<p>The continent code (e.g., <code>NA</code>, meaning North America).</p>', 'Region$description' => '<p>The description of the AWS Region (e.g., <code>This region is recommended to serve users in the eastern United States and eastern Canada</code>).</p>', 'Region$displayName' => '<p>The display name (e.g., <code>Virginia</code>).</p>', 'ResourceLocation$availabilityZone' => '<p>The Availability Zone. Follows the format <code>us-east-1a</code> (case-sensitive).</p>', 'ServiceException$code' => NULL, 'ServiceException$docs' => NULL, 'ServiceException$message' => NULL, 'ServiceException$tip' => NULL, 'StaticIp$supportCode' => '<p>The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.</p>', 'StringList$member' => NULL, 'UnauthenticatedException$code' => NULL, 'UnauthenticatedException$docs' => NULL, 'UnauthenticatedException$message' => NULL, 'UnauthenticatedException$tip' => NULL, ], ], 'timestamp' => [ 'base' => NULL, 'refs' => [ 'GetInstanceMetricDataRequest$startTime' => '<p>The start time of the time period.</p>', 'GetInstanceMetricDataRequest$endTime' => '<p>The end time of the time period.</p>', 'MetricDatapoint$timestamp' => '<p>The timestamp (e.g., <code>1479816991.349</code>).</p>', ], ], ],];
