<?php
// This file was auto-generated from sdk-root/src/data/monitoring/2010-08-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon CloudWatch monitors your Amazon Web Services (AWS) resources and the applications you run on AWS in real time. You can use CloudWatch to collect and track metrics, which are the variables you want to measure for your resources and applications.</p> <p>CloudWatch alarms send notifications or automatically change the resources you are monitoring based on rules that you define. For example, you can monitor the CPU usage and disk reads and writes of your Amazon EC2 instances. Then, use this data to determine whether you should launch additional instances to handle increased load. You can also use this data to stop under-used instances to save money.</p> <p>In addition to monitoring the built-in metrics that come with AWS, you can monitor your own custom metrics. With CloudWatch, you gain system-wide visibility into resource utilization, application performance, and operational health.</p>', 'operations' => [ 'DeleteAlarms' => '<p>Deletes the specified alarms. In the event of an error, no alarms are deleted.</p>', 'DeleteDashboards' => '<p>Deletes all dashboards that you specify. You may specify up to 100 dashboards to delete. If there is an error during this call, no dashboards are deleted.</p>', 'DescribeAlarmHistory' => '<p>Retrieves the history for the specified alarm. You can filter the results by date range or item type. If an alarm name is not specified, the histories for all alarms are returned.</p> <p>CloudWatch retains the history of an alarm even if you delete the alarm.</p>', 'DescribeAlarms' => '<p>Retrieves the specified alarms. If no alarms are specified, all alarms are returned. Alarms can be retrieved by using only a prefix for the alarm name, the alarm state, or a prefix for any action.</p>', 'DescribeAlarmsForMetric' => '<p>Retrieves the alarms for the specified metric. To filter the results, specify a statistic, period, or unit.</p>', 'DisableAlarmActions' => '<p>Disables the actions for the specified alarms. When an alarm\'s actions are disabled, the alarm actions do not execute when the alarm state changes.</p>', 'EnableAlarmActions' => '<p>Enables the actions for the specified alarms.</p>', 'GetDashboard' => '<p>Displays the details of the dashboard that you specify.</p> <p>To copy an existing dashboard, use <code>GetDashboard</code>, and then use the data returned within <code>DashboardBody</code> as the template for the new dashboard when you call <code>PutDashboard</code> to create the copy.</p>', 'GetMetricStatistics' => '<p>Gets statistics for the specified metric.</p> <p>The maximum number of data points returned from a single call is 1,440. If you request more than 1,440 data points, CloudWatch returns an error. To reduce the number of data points, you can narrow the specified time range and make multiple requests across adjacent time ranges, or you can increase the specified period. Data points are not returned in chronological order.</p> <p>CloudWatch aggregates data points based on the length of the period that you specify. For example, if you request statistics with a one-hour period, CloudWatch aggregates all data points with time stamps that fall within each one-hour period. Therefore, the number of values aggregated by CloudWatch is larger than the number of data points returned.</p> <p>CloudWatch needs raw data points to calculate percentile statistics. If you publish data using a statistic set instead, you can only retrieve percentile statistics for this data if one of the following conditions is true:</p> <ul> <li> <p>The SampleCount value of the statistic set is 1.</p> </li> <li> <p>The Min and the Max values of the statistic set are equal.</p> </li> </ul> <p>Amazon CloudWatch retains metric data as follows:</p> <ul> <li> <p>Data points with a period of less than 60 seconds are available for 3 hours. These data points are high-resolution metrics and are available only for custom metrics that have been defined with a <code>StorageResolution</code> of 1.</p> </li> <li> <p>Data points with a period of 60 seconds (1-minute) are available for 15 days.</p> </li> <li> <p>Data points with a period of 300 seconds (5-minute) are available for 63 days.</p> </li> <li> <p>Data points with a period of 3600 seconds (1 hour) are available for 455 days (15 months).</p> </li> </ul> <p>Data points that are initially published with a shorter period are aggregated together for long-term storage. For example, if you collect data using a period of 1 minute, the data remains available for 15 days with 1-minute resolution. After 15 days, this data is still available, but is aggregated and retrievable only with a resolution of 5 minutes. After 63 days, the data is further aggregated and is available with a resolution of 1 hour.</p> <p>CloudWatch started retaining 5-minute and 1-hour metric data as of July 9, 2016.</p> <p>For information about metrics and dimensions supported by AWS services, see the <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CW_Support_For_AWS.html">Amazon CloudWatch Metrics and Dimensions Reference</a> in the <i>Amazon CloudWatch User Guide</i>.</p>', 'ListDashboards' => '<p>Returns a list of the dashboards for your account. If you include <code>DashboardNamePrefix</code>, only those dashboards with names starting with the prefix are listed. Otherwise, all dashboards in your account are listed. </p>', 'ListMetrics' => '<p>List the specified metrics. You can use the returned metrics with <a>GetMetricStatistics</a> to obtain statistical data.</p> <p>Up to 500 results are returned for any one call. To retrieve additional results, use the returned token with subsequent calls.</p> <p>After you create a metric, allow up to fifteen minutes before the metric appears. Statistics about the metric, however, are available sooner using <a>GetMetricStatistics</a>.</p>', 'PutDashboard' => '<p>Creates a dashboard if it does not already exist, or updates an existing dashboard. If you update a dashboard, the entire contents are replaced with what you specify here.</p> <p>You can have up to 500 dashboards per account. All dashboards in your account are global, not region-specific.</p> <p>A simple way to create a dashboard using <code>PutDashboard</code> is to copy an existing dashboard. To copy an existing dashboard using the console, you can load the dashboard and then use the View/edit source command in the Actions menu to display the JSON block for that dashboard. Another way to copy a dashboard is to use <code>GetDashboard</code>, and then use the data returned within <code>DashboardBody</code> as the template for the new dashboard when you call <code>PutDashboard</code>.</p> <p>When you create a dashboard with <code>PutDashboard</code>, a good practice is to add a text widget at the top of the dashboard with a message that the dashboard was created by script and should not be changed in the console. This message could also point console users to the location of the <code>DashboardBody</code> script or the CloudFormation template used to create the dashboard.</p>', 'PutMetricAlarm' => '<p>Creates or updates an alarm and associates it with the specified metric. Optionally, this operation can associate one or more Amazon SNS resources with the alarm.</p> <p>When this operation creates an alarm, the alarm state is immediately set to <code>INSUFFICIENT_DATA</code>. The alarm is evaluated and its state is set appropriately. Any actions associated with the state are then executed.</p> <p>When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm.</p> <p>If you are an IAM user, you must have Amazon EC2 permissions for some operations:</p> <ul> <li> <p> <code>ec2:DescribeInstanceStatus</code> and <code>ec2:DescribeInstances</code> for all alarms on EC2 instance status metrics</p> </li> <li> <p> <code>ec2:StopInstances</code> for alarms with stop actions</p> </li> <li> <p> <code>ec2:TerminateInstances</code> for alarms with terminate actions</p> </li> <li> <p> <code>ec2:DescribeInstanceRecoveryAttribute</code> and <code>ec2:RecoverInstances</code> for alarms with recover actions</p> </li> </ul> <p>If you have read/write permissions for Amazon CloudWatch but not for Amazon EC2, you can still create an alarm, but the stop or terminate actions are not performed. However, if you are later granted the required permissions, the alarm actions that you created earlier are performed.</p> <p>If you are using an IAM role (for example, an EC2 instance profile), you cannot stop or terminate the instance using alarm actions. However, you can still see the alarm state and perform any other actions such as Amazon SNS notifications or Auto Scaling policies.</p> <p>If you are using temporary security credentials granted using AWS STS, you cannot stop or terminate an EC2 instance using alarm actions.</p> <p>You must create at least one stop, terminate, or reboot alarm using either the Amazon EC2 or CloudWatch consoles to create the <b>EC2ActionsAccess</b> IAM role. After this IAM role is created, you can create stop, terminate, or reboot alarms using a command-line interface or API.</p>', 'PutMetricData' => '<p>Publishes metric data points to Amazon CloudWatch. CloudWatch associates the data points with the specified metric. If the specified metric does not exist, CloudWatch creates the metric. When CloudWatch creates a metric, it can take up to fifteen minutes for the metric to appear in calls to <a>ListMetrics</a>.</p> <p>Each <code>PutMetricData</code> request is limited to 40 KB in size for HTTP POST requests.</p> <p>Although the <code>Value</code> parameter accepts numbers of type <code>Double</code>, CloudWatch rejects values that are either too small or too large. Values must be in the range of 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2). In addition, special values (for example, NaN, +Infinity, -Infinity) are not supported.</p> <p>You can use up to 10 dimensions per metric to further clarify what data the metric collects. For more information about specifying dimensions, see <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publishing Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.</p> <p>Data points with time stamps from 24 hours ago or longer can take at least 48 hours to become available for <a>GetMetricStatistics</a> from the time they are submitted.</p> <p>CloudWatch needs raw data points to calculate percentile statistics. If you publish data using a statistic set instead, you can only retrieve percentile statistics for this data if one of the following conditions is true:</p> <ul> <li> <p>The SampleCount value of the statistic set is 1</p> </li> <li> <p>The Min and the Max values of the statistic set are equal</p> </li> </ul>', 'SetAlarmState' => '<p>Temporarily sets the state of an alarm for testing purposes. When the updated state differs from the previous value, the action configured for the appropriate state is invoked. For example, if your alarm is configured to send an Amazon SNS message when an alarm is triggered, temporarily changing the alarm state to <code>ALARM</code> sends an SNS message. The alarm returns to its actual state (often within seconds). Because the alarm state change happens quickly, it is typically only visible in the alarm\'s <b>History</b> tab in the Amazon CloudWatch console or through <a>DescribeAlarmHistory</a>.</p>', ], 'shapes' => [ 'ActionPrefix' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsInput$ActionPrefix' => '<p>The action name prefix.</p>', ], ], 'ActionsEnabled' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$ActionsEnabled' => '<p>Indicates whether actions should be executed during any changes to the alarm state.</p>', 'PutMetricAlarmInput$ActionsEnabled' => '<p>Indicates whether actions should be executed during any changes to the alarm state.</p>', ], ], 'AlarmArn' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$AlarmArn' => '<p>The Amazon Resource Name (ARN) of the alarm.</p>', ], ], 'AlarmDescription' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$AlarmDescription' => '<p>The description of the alarm.</p>', 'PutMetricAlarmInput$AlarmDescription' => '<p>The description for the alarm.</p>', ], ], 'AlarmHistoryItem' => [ 'base' => '<p>Represents the history of a specific alarm.</p>', 'refs' => [ 'AlarmHistoryItems$member' => NULL, ], ], 'AlarmHistoryItems' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmHistoryOutput$AlarmHistoryItems' => '<p>The alarm histories, in JSON format.</p>', ], ], 'AlarmName' => [ 'base' => NULL, 'refs' => [ 'AlarmHistoryItem$AlarmName' => '<p>The descriptive name for the alarm.</p>', 'AlarmNames$member' => NULL, 'DescribeAlarmHistoryInput$AlarmName' => '<p>The name of the alarm.</p>', 'MetricAlarm$AlarmName' => '<p>The name of the alarm.</p>', 'PutMetricAlarmInput$AlarmName' => '<p>The name for the alarm. This name must be unique within the AWS account.</p>', 'SetAlarmStateInput$AlarmName' => '<p>The name for the alarm. This name must be unique within the AWS account. The maximum length is 255 characters.</p>', ], ], 'AlarmNamePrefix' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsInput$AlarmNamePrefix' => '<p>The alarm name prefix. If this parameter is specified, you cannot specify <code>AlarmNames</code>.</p>', ], ], 'AlarmNames' => [ 'base' => NULL, 'refs' => [ 'DeleteAlarmsInput$AlarmNames' => '<p>The alarms to be deleted.</p>', 'DescribeAlarmsInput$AlarmNames' => '<p>The names of the alarms.</p>', 'DisableAlarmActionsInput$AlarmNames' => '<p>The names of the alarms.</p>', 'EnableAlarmActionsInput$AlarmNames' => '<p>The names of the alarms.</p>', ], ], 'AwsQueryErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidParameterCombinationException$message' => '<p/>', 'InvalidParameterValueException$message' => '<p/>', 'MissingRequiredParameterException$message' => '<p/>', ], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$ComparisonOperator' => '<p>The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic value is used as the first operand.</p>', 'PutMetricAlarmInput$ComparisonOperator' => '<p> The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic value is used as the first operand.</p>', ], ], 'DashboardArn' => [ 'base' => NULL, 'refs' => [ 'DashboardEntry$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', 'GetDashboardOutput$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', ], ], 'DashboardBody' => [ 'base' => NULL, 'refs' => [ 'GetDashboardOutput$DashboardBody' => '<p>The detailed information about the dashboard, including what widgets are included and their location on the dashboard. For more information about the <code>DashboardBody</code> syntax, see <a>CloudWatch-Dashboard-Body-Structure</a>. </p>', 'PutDashboardInput$DashboardBody' => '<p>The detailed information about the dashboard in JSON format, including the widgets to include and their location on the dashboard.</p> <p>For more information about the syntax, see <a>CloudWatch-Dashboard-Body-Structure</a>.</p>', ], ], 'DashboardEntries' => [ 'base' => NULL, 'refs' => [ 'ListDashboardsOutput$DashboardEntries' => '<p>The list of matching dashboards.</p>', ], ], 'DashboardEntry' => [ 'base' => '<p>Represents a specific dashboard.</p>', 'refs' => [ 'DashboardEntries$member' => NULL, ], ], 'DashboardErrorMessage' => [ 'base' => NULL, 'refs' => [ 'DashboardInvalidInputError$message' => NULL, 'DashboardNotFoundError$message' => NULL, ], ], 'DashboardInvalidInputError' => [ 'base' => '<p>Some part of the dashboard data is invalid.</p>', 'refs' => [], ], 'DashboardName' => [ 'base' => NULL, 'refs' => [ 'DashboardEntry$DashboardName' => '<p>The name of the dashboard.</p>', 'DashboardNames$member' => NULL, 'GetDashboardInput$DashboardName' => '<p>The name of the dashboard to be described.</p>', 'GetDashboardOutput$DashboardName' => '<p>The name of the dashboard.</p>', 'PutDashboardInput$DashboardName' => '<p>The name of the dashboard. If a dashboard with this name already exists, this call modifies that dashboard, replacing its current contents. Otherwise, a new dashboard is created. The maximum length is 255, and valid characters are A-Z, a-z, 0-9, "-", and "_".</p>', ], ], 'DashboardNamePrefix' => [ 'base' => NULL, 'refs' => [ 'ListDashboardsInput$DashboardNamePrefix' => '<p>If you specify this parameter, only the dashboards with names starting with the specified string are listed. The maximum length is 255, and valid characters are A-Z, a-z, 0-9, ".", "-", and "_". </p>', ], ], 'DashboardNames' => [ 'base' => NULL, 'refs' => [ 'DeleteDashboardsInput$DashboardNames' => '<p>The dashboards to be deleted.</p>', ], ], 'DashboardNotFoundError' => [ 'base' => '<p>The specified dashboard does not exist.</p>', 'refs' => [], ], 'DashboardValidationMessage' => [ 'base' => '<p>An error or warning for the operation.</p>', 'refs' => [ 'DashboardValidationMessages$member' => NULL, ], ], 'DashboardValidationMessages' => [ 'base' => NULL, 'refs' => [ 'DashboardInvalidInputError$dashboardValidationMessages' => NULL, 'PutDashboardOutput$DashboardValidationMessages' => '<p>If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or modified, this result is empty.</p> <p>If this result includes only warning messages, then the input was valid enough for the dashboard to be created or modified, but some elements of the dashboard may not render.</p> <p>If this result includes error messages, the input was not valid and the operation failed.</p>', ], ], 'DataPath' => [ 'base' => NULL, 'refs' => [ 'DashboardValidationMessage$DataPath' => '<p>The data path related to the message.</p>', ], ], 'Datapoint' => [ 'base' => '<p>Encapsulates the statistical data that CloudWatch computes from metric data.</p>', 'refs' => [ 'Datapoints$member' => NULL, ], ], 'DatapointValue' => [ 'base' => NULL, 'refs' => [ 'Datapoint$SampleCount' => '<p>The number of metric values that contributed to the aggregate value of this data point.</p>', 'Datapoint$Average' => '<p>The average of the metric values that correspond to the data point.</p>', 'Datapoint$Sum' => '<p>The sum of the metric values for the data point.</p>', 'Datapoint$Minimum' => '<p>The minimum metric value for the data point.</p>', 'Datapoint$Maximum' => '<p>The maximum metric value for the data point.</p>', 'DatapointValueMap$value' => NULL, 'MetricDatum$Value' => '<p>The value for the metric.</p> <p>Although the parameter accepts numbers of type Double, CloudWatch rejects values that are either too small or too large. Values must be in the range of 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2). In addition, special values (for example, NaN, +Infinity, -Infinity) are not supported.</p>', 'StatisticSet$SampleCount' => '<p>The number of samples used for the statistic set.</p>', 'StatisticSet$Sum' => '<p>The sum of values for the sample set.</p>', 'StatisticSet$Minimum' => '<p>The minimum value of the sample set.</p>', 'StatisticSet$Maximum' => '<p>The maximum value of the sample set.</p>', ], ], 'DatapointValueMap' => [ 'base' => NULL, 'refs' => [ 'Datapoint$ExtendedStatistics' => '<p>The percentile statistic for the data point.</p>', ], ], 'Datapoints' => [ 'base' => NULL, 'refs' => [ 'GetMetricStatisticsOutput$Datapoints' => '<p>The data points for the specified metric.</p>', ], ], 'DeleteAlarmsInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDashboardsInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDashboardsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlarmHistoryInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlarmHistoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlarmsForMetricInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlarmsForMetricOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlarmsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlarmsOutput' => [ 'base' => NULL, 'refs' => [], ], 'Dimension' => [ 'base' => '<p>Expands the identity of a metric.</p>', 'refs' => [ 'Dimensions$member' => NULL, ], ], 'DimensionFilter' => [ 'base' => '<p>Represents filters for a dimension.</p>', 'refs' => [ 'DimensionFilters$member' => NULL, ], ], 'DimensionFilters' => [ 'base' => NULL, 'refs' => [ 'ListMetricsInput$Dimensions' => '<p>The dimensions to filter against.</p>', ], ], 'DimensionName' => [ 'base' => NULL, 'refs' => [ 'Dimension$Name' => '<p>The name of the dimension.</p>', 'DimensionFilter$Name' => '<p>The dimension name to be matched.</p>', ], ], 'DimensionValue' => [ 'base' => NULL, 'refs' => [ 'Dimension$Value' => '<p>The value representing the dimension measurement.</p>', 'DimensionFilter$Value' => '<p>The value of the dimension to be matched.</p>', ], ], 'Dimensions' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsForMetricInput$Dimensions' => '<p>The dimensions associated with the metric. If the metric has any associated dimensions, you must specify them in order for the call to succeed.</p>', 'GetMetricStatisticsInput$Dimensions' => '<p>The dimensions. If the metric contains multiple dimensions, you must include a value for each dimension. CloudWatch treats each unique combination of dimensions as a separate metric. If a specific combination of dimensions was not published, you can\'t retrieve statistics for it. You must specify the same dimensions that were used when the metrics were created. For an example, see <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations">Dimension Combinations</a> in the <i>Amazon CloudWatch User Guide</i>. For more information about specifying dimensions, see <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publishing Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.</p>', 'Metric$Dimensions' => '<p>The dimensions for the metric.</p>', 'MetricAlarm$Dimensions' => '<p>The dimensions for the metric associated with the alarm.</p>', 'MetricDatum$Dimensions' => '<p>The dimensions associated with the metric.</p>', 'PutMetricAlarmInput$Dimensions' => '<p>The dimensions for the metric associated with the alarm.</p>', ], ], 'DisableAlarmActionsInput' => [ 'base' => NULL, 'refs' => [], ], 'EnableAlarmActionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidFormatFault$message' => '<p/>', 'InvalidNextToken$message' => '<p/>', 'LimitExceededFault$message' => '<p/>', 'ResourceNotFound$message' => '<p/>', ], ], 'EvaluateLowSampleCountPercentile' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$EvaluateLowSampleCountPercentile' => '<p>Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change during periods with too few data points to be statistically significant. If <code>evaluate</code> or this parameter is not used, the alarm is always evaluated and possibly changes state no matter how many data points are available.</p>', 'PutMetricAlarmInput$EvaluateLowSampleCountPercentile' => '<p> Used only for alarms based on percentiles. If you specify <code>ignore</code>, the alarm state does not change during periods with too few data points to be statistically significant. If you specify <code>evaluate</code> or omit this parameter, the alarm is always evaluated and possibly changes state no matter how many data points are available. For more information, see <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples">Percentile-Based CloudWatch Alarms and Low Data Samples</a>.</p> <p>Valid Values: <code>evaluate | ignore</code> </p>', ], ], 'EvaluationPeriods' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$EvaluationPeriods' => '<p>The number of periods over which data is compared to the specified threshold.</p>', 'PutMetricAlarmInput$EvaluationPeriods' => '<p>The number of periods over which data is compared to the specified threshold. An alarm\'s total current evaluation period can be no longer than one day, so this number multiplied by <code>Period</code> cannot be more than 86,400 seconds.</p>', ], ], 'ExtendedStatistic' => [ 'base' => NULL, 'refs' => [ 'DatapointValueMap$key' => NULL, 'DescribeAlarmsForMetricInput$ExtendedStatistic' => '<p>The percentile statistic for the metric. Specify a value between p0.0 and p100.</p>', 'ExtendedStatistics$member' => NULL, 'MetricAlarm$ExtendedStatistic' => '<p>The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.</p>', 'PutMetricAlarmInput$ExtendedStatistic' => '<p>The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.</p>', ], ], 'ExtendedStatistics' => [ 'base' => NULL, 'refs' => [ 'GetMetricStatisticsInput$ExtendedStatistics' => '<p>The percentile statistics. Specify values between p0.0 and p100. When calling <code>GetMetricStatistics</code>, you must specify either <code>Statistics</code> or <code>ExtendedStatistics</code>, but not both.</p>', ], ], 'FaultDescription' => [ 'base' => NULL, 'refs' => [ 'InternalServiceFault$Message' => '<p/>', ], ], 'GetDashboardInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDashboardOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricStatisticsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricStatisticsOutput' => [ 'base' => NULL, 'refs' => [], ], 'HistoryData' => [ 'base' => NULL, 'refs' => [ 'AlarmHistoryItem$HistoryData' => '<p>Data about the alarm, in JSON format.</p>', ], ], 'HistoryItemType' => [ 'base' => NULL, 'refs' => [ 'AlarmHistoryItem$HistoryItemType' => '<p>The type of alarm history item.</p>', 'DescribeAlarmHistoryInput$HistoryItemType' => '<p>The type of alarm histories to retrieve.</p>', ], ], 'HistorySummary' => [ 'base' => NULL, 'refs' => [ 'AlarmHistoryItem$HistorySummary' => '<p>A summary of the alarm history, in text format.</p>', ], ], 'InternalServiceFault' => [ 'base' => '<p>Request processing has failed due to some unknown error, exception, or failure.</p>', 'refs' => [], ], 'InvalidFormatFault' => [ 'base' => '<p>Data was not syntactically valid JSON.</p>', 'refs' => [], ], 'InvalidNextToken' => [ 'base' => '<p>The next token specified is invalid.</p>', 'refs' => [], ], 'InvalidParameterCombinationException' => [ 'base' => '<p>Parameters were used together that cannot be used together.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>The value of an input parameter is bad or out-of-range.</p>', 'refs' => [], ], 'LastModified' => [ 'base' => NULL, 'refs' => [ 'DashboardEntry$LastModified' => '<p>The time stamp of when the dashboard was last modified, either by an API call or through the console. This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>', ], ], 'LimitExceededFault' => [ 'base' => '<p>The quota for alarms for this customer has already been reached.</p>', 'refs' => [], ], 'ListDashboardsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMetricsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMetricsOutput' => [ 'base' => NULL, 'refs' => [], ], 'MaxRecords' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmHistoryInput$MaxRecords' => '<p>The maximum number of alarm history records to retrieve.</p>', 'DescribeAlarmsInput$MaxRecords' => '<p>The maximum number of alarm descriptions to retrieve.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'DashboardValidationMessage$Message' => '<p>A message describing the error or warning.</p>', ], ], 'Metric' => [ 'base' => '<p>Represents a specific metric.</p>', 'refs' => [ 'Metrics$member' => NULL, ], ], 'MetricAlarm' => [ 'base' => '<p>Represents an alarm.</p>', 'refs' => [ 'MetricAlarms$member' => NULL, ], ], 'MetricAlarms' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsForMetricOutput$MetricAlarms' => '<p>The information for each alarm with the specified metric.</p>', 'DescribeAlarmsOutput$MetricAlarms' => '<p>The information for the specified alarms.</p>', ], ], 'MetricData' => [ 'base' => NULL, 'refs' => [ 'PutMetricDataInput$MetricData' => '<p>The data for the metric.</p>', ], ], 'MetricDatum' => [ 'base' => '<p>Encapsulates the information sent to either create a metric or add new values to be aggregated into an existing metric.</p>', 'refs' => [ 'MetricData$member' => NULL, ], ], 'MetricLabel' => [ 'base' => NULL, 'refs' => [ 'GetMetricStatisticsOutput$Label' => '<p>A label for the specified metric.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsForMetricInput$MetricName' => '<p>The name of the metric.</p>', 'GetMetricStatisticsInput$MetricName' => '<p>The name of the metric, with or without spaces.</p>', 'ListMetricsInput$MetricName' => '<p>The name of the metric to filter against.</p>', 'Metric$MetricName' => '<p>The name of the metric.</p>', 'MetricAlarm$MetricName' => '<p>The name of the metric associated with the alarm.</p>', 'MetricDatum$MetricName' => '<p>The name of the metric.</p>', 'PutMetricAlarmInput$MetricName' => '<p>The name for the metric associated with the alarm.</p>', ], ], 'Metrics' => [ 'base' => NULL, 'refs' => [ 'ListMetricsOutput$Metrics' => '<p>The metrics.</p>', ], ], 'MissingRequiredParameterException' => [ 'base' => '<p>An input parameter that is required is missing.</p>', 'refs' => [], ], 'Namespace' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsForMetricInput$Namespace' => '<p>The namespace of the metric.</p>', 'GetMetricStatisticsInput$Namespace' => '<p>The namespace of the metric, with or without spaces.</p>', 'ListMetricsInput$Namespace' => '<p>The namespace to filter against.</p>', 'Metric$Namespace' => '<p>The namespace of the metric.</p>', 'MetricAlarm$Namespace' => '<p>The namespace of the metric associated with the alarm.</p>', 'PutMetricAlarmInput$Namespace' => '<p>The namespace for the metric associated with the alarm.</p>', 'PutMetricDataInput$Namespace' => '<p>The namespace for the metric data.</p> <p>You cannot specify a namespace that begins with "AWS/". Namespaces that begin with "AWS/" are reserved for use by Amazon Web Services products.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmHistoryInput$NextToken' => '<p>The token returned by a previous call to indicate that there is more data available.</p>', 'DescribeAlarmHistoryOutput$NextToken' => '<p>The token that marks the start of the next batch of returned results.</p>', 'DescribeAlarmsInput$NextToken' => '<p>The token returned by a previous call to indicate that there is more data available.</p>', 'DescribeAlarmsOutput$NextToken' => '<p>The token that marks the start of the next batch of returned results.</p>', 'ListDashboardsInput$NextToken' => '<p>The token returned by a previous call to indicate that there is more data available.</p>', 'ListDashboardsOutput$NextToken' => '<p>The token that marks the start of the next batch of returned results.</p>', 'ListMetricsInput$NextToken' => '<p>The token returned by a previous call to indicate that there is more data available.</p>', 'ListMetricsOutput$NextToken' => '<p>The token that marks the start of the next batch of returned results.</p>', ], ], 'Period' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsForMetricInput$Period' => '<p>The period, in seconds, over which the statistic is applied.</p>', 'GetMetricStatisticsInput$Period' => '<p>The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.</p> <p>If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you must specify the period as follows or no data points in that time range is returned:</p> <ul> <li> <p>Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).</p> </li> <li> <p>Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).</p> </li> <li> <p>Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).</p> </li> </ul>', 'MetricAlarm$Period' => '<p>The period, in seconds, over which the statistic is applied.</p>', 'PutMetricAlarmInput$Period' => '<p>The period, in seconds, over which the specified statistic is applied. Valid values are 10, 30, and any multiple of 60.</p> <p>Be sure to specify 10 or 30 only for metrics that are stored by a <code>PutMetricData</code> call with a <code>StorageResolution</code> of 1. If you specify a Period of 10 or 30 for a metric that does not have sub-minute resolution, the alarm still attempts to gather data at the period rate that you specify. In this case, it does not receive data for the attempts that do not correspond to a one-minute data resolution, and the alarm may often lapse into INSUFFICENT_DATA status. Specifying 10 or 30 also sets this alarm as a high-resolution alarm, which has a higher charge than other alarms. For more information about pricing, see <a href="https://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.</p> <p>An alarm\'s total current evaluation period can be no longer than one day, so <code>Period</code> multiplied by <code>EvaluationPeriods</code> cannot be more than 86,400 seconds.</p>', ], ], 'PutDashboardInput' => [ 'base' => NULL, 'refs' => [], ], 'PutDashboardOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutMetricAlarmInput' => [ 'base' => NULL, 'refs' => [], ], 'PutMetricDataInput' => [ 'base' => NULL, 'refs' => [], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$OKActions' => '<p>The actions to execute when this alarm transitions to the <code>OK</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>', 'MetricAlarm$AlarmActions' => '<p>The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>', 'MetricAlarm$InsufficientDataActions' => '<p>The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>', 'PutMetricAlarmInput$OKActions' => '<p>The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p> <p>Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate | arn:aws:automate:<i>region</i>:ec2:recover</p> <p>Valid Values (for use with IAM roles): arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 | arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 | arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0</p>', 'PutMetricAlarmInput$AlarmActions' => '<p>The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p> <p>Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate | arn:aws:automate:<i>region</i>:ec2:recover</p> <p>Valid Values (for use with IAM roles): arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 | arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 | arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0</p>', 'PutMetricAlarmInput$InsufficientDataActions' => '<p>The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p> <p>Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate | arn:aws:automate:<i>region</i>:ec2:recover</p> <p>Valid Values (for use with IAM roles): arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 | arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 | arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceNotFound' => [ 'base' => '<p>The named resource does not exist.</p>', 'refs' => [], ], 'SetAlarmStateInput' => [ 'base' => NULL, 'refs' => [], ], 'Size' => [ 'base' => NULL, 'refs' => [ 'DashboardEntry$Size' => '<p>The size of the dashboard, in bytes.</p>', ], ], 'StandardUnit' => [ 'base' => NULL, 'refs' => [ 'Datapoint$Unit' => '<p>The standard unit for the data point.</p>', 'DescribeAlarmsForMetricInput$Unit' => '<p>The unit for the metric.</p>', 'GetMetricStatisticsInput$Unit' => '<p>The unit for a given metric. Metrics may be reported in multiple units. Not supplying a unit results in all units being returned. If the metric only ever reports one unit, specifying a unit has no effect.</p>', 'MetricAlarm$Unit' => '<p>The unit of the metric associated with the alarm.</p>', 'MetricDatum$Unit' => '<p>The unit of the metric.</p>', 'PutMetricAlarmInput$Unit' => '<p>The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are Bytes because NetworkIn tracks the number of bytes that an instance receives on all network interfaces. You can also specify a unit when you create a custom metric. Units help provide conceptual meaning to your data. Metric data points that specify a unit of measure, such as Percent, are aggregated separately.</p> <p>If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the CloudWatch alarm can get stuck in the <code>INSUFFICIENT DATA</code> state. </p>', ], ], 'StateReason' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$StateReason' => '<p>An explanation for the alarm state, in text format.</p>', 'SetAlarmStateInput$StateReason' => '<p>The reason that this alarm is set to this specific state, in text format.</p>', ], ], 'StateReasonData' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$StateReasonData' => '<p>An explanation for the alarm state, in JSON format.</p>', 'SetAlarmStateInput$StateReasonData' => '<p>The reason that this alarm is set to this specific state, in JSON format.</p>', ], ], 'StateValue' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsInput$StateValue' => '<p>The state value to be used in matching alarms.</p>', 'MetricAlarm$StateValue' => '<p>The state value for the alarm.</p>', 'SetAlarmStateInput$StateValue' => '<p>The value of the state.</p>', ], ], 'Statistic' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsForMetricInput$Statistic' => '<p>The statistic for the metric, other than percentiles. For percentile statistics, use <code>ExtendedStatistics</code>.</p>', 'MetricAlarm$Statistic' => '<p>The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use <code>ExtendedStatistic</code>.</p>', 'PutMetricAlarmInput$Statistic' => '<p>The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use <code>ExtendedStatistic</code>.</p>', 'Statistics$member' => NULL, ], ], 'StatisticSet' => [ 'base' => '<p>Represents a set of statistics that describes a specific metric. </p>', 'refs' => [ 'MetricDatum$StatisticValues' => '<p>The statistical values for the metric.</p>', ], ], 'Statistics' => [ 'base' => NULL, 'refs' => [ 'GetMetricStatisticsInput$Statistics' => '<p>The metric statistics, other than percentile. For percentile statistics, use <code>ExtendedStatistics</code>. When calling <code>GetMetricStatistics</code>, you must specify either <code>Statistics</code> or <code>ExtendedStatistics</code>, but not both.</p>', ], ], 'StorageResolution' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$StorageResolution' => '<p>Valid values are 1 and 60. Setting this to 1 specifies this metric as a high-resolution metric, so that CloudWatch stores the metric with sub-minute resolution down to one second. Setting this to 60 specifies this metric as a regular-resolution metric, which CloudWatch stores at 1-minute resolution. Currently, high resolution is available only for custom metrics. For more information about high-resolution metrics, see <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#high-resolution-metrics">High-Resolution Metrics</a> in the <i>Amazon CloudWatch User Guide</i>. </p> <p>This field is optional, if you do not specify it the default of 60 is used.</p>', ], ], 'Threshold' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$Threshold' => '<p>The value to compare with the specified statistic.</p>', 'PutMetricAlarmInput$Threshold' => '<p>The value against which the specified statistic is compared.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AlarmHistoryItem$Timestamp' => '<p>The time stamp for the alarm history item.</p>', 'Datapoint$Timestamp' => '<p>The time stamp used for the data point.</p>', 'DescribeAlarmHistoryInput$StartDate' => '<p>The starting date to retrieve alarm history.</p>', 'DescribeAlarmHistoryInput$EndDate' => '<p>The ending date to retrieve alarm history.</p>', 'GetMetricStatisticsInput$StartTime' => '<p>The time stamp that determines the first data point to return. Start times are evaluated relative to the time that CloudWatch receives the request.</p> <p>The value specified is inclusive; results include data points with the specified time stamp. The time stamp must be in ISO 8601 UTC format (for example, 2016-10-03T23:00:00Z).</p> <p>CloudWatch rounds the specified time stamp as follows:</p> <ul> <li> <p>Start time less than 15 days ago - Round down to the nearest whole minute. For example, 12:32:34 is rounded down to 12:32:00.</p> </li> <li> <p>Start time between 15 and 63 days ago - Round down to the nearest 5-minute clock interval. For example, 12:32:34 is rounded down to 12:30:00.</p> </li> <li> <p>Start time greater than 63 days ago - Round down to the nearest 1-hour clock interval. For example, 12:32:34 is rounded down to 12:00:00.</p> </li> </ul> <p>If you set <code>Period</code> to 5, 10, or 30, the start time of your request is rounded down to the nearest time that corresponds to even 5-, 10-, or 30-second divisions of a minute. For example, if you make a query at (HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of your request is rounded down and you receive data from 01:05:10 to 01:05:20. If you make a query at 15:07:17 for the previous 5 minutes of data, using a period of 5 seconds, you receive data timestamped between 15:02:15 and 15:07:15. </p>', 'GetMetricStatisticsInput$EndTime' => '<p>The time stamp that determines the last data point to return.</p> <p>The value specified is exclusive; results include data points up to the specified time stamp. The time stamp must be in ISO 8601 UTC format (for example, 2016-10-10T23:00:00Z).</p>', 'MetricAlarm$AlarmConfigurationUpdatedTimestamp' => '<p>The time stamp of the last update to the alarm configuration.</p>', 'MetricAlarm$StateUpdatedTimestamp' => '<p>The time stamp of the last update to the alarm state.</p>', 'MetricDatum$Timestamp' => '<p>The time the metric data was received, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>', ], ], 'TreatMissingData' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$TreatMissingData' => '<p>Sets how this alarm is to handle missing data points. If this parameter is omitted, the default behavior of <code>missing</code> is used.</p>', 'PutMetricAlarmInput$TreatMissingData' => '<p> Sets how this alarm is to handle missing data points. If <code>TreatMissingData</code> is omitted, the default behavior of <code>missing</code> is used. For more information, see <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data">Configuring How CloudWatch Alarms Treats Missing Data</a>.</p> <p>Valid Values: <code>breaching | notBreaching | ignore | missing</code> </p>', ], ], ],];
