<?php
// This file was auto-generated from sdk-root/src/data/opsworkscm/2016-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS OpsWorks for Chef Automate</fullname> <p> AWS OpsWorks for Chef Automate is a service that runs and manages configuration management servers. </p> <p> <b>Glossary of terms</b> </p> <ul> <li> <p> <b>Server</b>: A configuration management server that can be highly-available. The configuration manager runs on your instances by using various AWS services, such as Amazon Elastic Compute Cloud (EC2), and potentially Amazon Relational Database Service (RDS). A server is a generic abstraction over the configuration manager that you want to use, much like Amazon RDS. In AWS OpsWorks for Chef Automate, you do not start or stop servers. After you create servers, they continue to run until they are deleted.</p> </li> <li> <p> <b>Engine</b>: The specific configuration manager that you want to use (such as <code>Chef</code>) is the engine.</p> </li> <li> <p> <b>Backup</b>: This is an application-level backup of the data that the configuration manager stores. A backup creates a .tar.gz file that is stored in an Amazon Simple Storage Service (S3) bucket in your account. AWS OpsWorks for Chef Automate creates the S3 bucket when you launch the first instance. A backup maintains a snapshot of all of a server\'s important attributes at the time of the backup.</p> </li> <li> <p> <b>Events</b>: Events are always related to a server. Events are written during server creation, when health checks run, when backups are created, etc. When you delete a server, the server\'s events are also deleted.</p> </li> <li> <p> <b>AccountAttributes</b>: Every account has attributes that are assigned in the AWS OpsWorks for Chef Automate database. These attributes store information about configuration limits (servers, backups, etc.) and your customer account. </p> </li> </ul> <p> <b>Endpoints</b> </p> <p>AWS OpsWorks for Chef Automate supports the following endpoints, all HTTPS. You must connect to one of the following endpoints. Chef servers can only be accessed or managed within the endpoint in which they are created.</p> <ul> <li> <p>opsworks-cm.us-east-1.amazonaws.com</p> </li> <li> <p>opsworks-cm.us-west-2.amazonaws.com</p> </li> <li> <p>opsworks-cm.eu-west-1.amazonaws.com</p> </li> </ul> <p> <b>Throttling limits</b> </p> <p>All API operations allow for five requests per second with a burst of 10 requests per second.</p>', 'operations' => [ 'AssociateNode' => '<p> Associates a new node with the Chef server. This command is an alternative to <code>knife bootstrap</code>. For more information about how to disassociate a node, see <a>DisassociateNode</a>.</p> <p> A node can can only be associated with servers that are in a <code>HEALTHY</code> state. Otherwise, an <code>InvalidStateException</code> is thrown. A <code>ResourceNotFoundException</code> is thrown when the server does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid. The AssociateNode API call can be integrated into Auto Scaling configurations, AWS Cloudformation templates, or the user data of a server\'s instance. </p> <p> Example: <code>aws opsworks-cm associate-node --server-name <i>MyServer</i> --node-name <i>MyManagedNode</i> --engine-attributes "Name=<i>MyOrganization</i>,Value=default" "Name=<i>Chef_node_public_key</i>,Value=<i>Public_key_contents</i>"</code> </p>', 'CreateBackup' => '<p> Creates an application-level backup of a server. While the server is in the <code>BACKING_UP</code> state, the server cannot be changed, and no additional backup can be created. </p> <p> Backups can be created for servers in <code>RUNNING</code>, <code>HEALTHY</code>, and <code>UNHEALTHY</code> states. By default, you can create a maximum of 50 manual backups. </p> <p> This operation is asynchronous. </p> <p> A <code>LimitExceededException</code> is thrown when the maximum number of manual backups is reached. An <code>InvalidStateException</code> is thrown when the server is not in any of the following states: RUNNING, HEALTHY, or UNHEALTHY. A <code>ResourceNotFoundException</code> is thrown when the server is not found. A <code>ValidationException</code> is thrown when parameters of the request are not valid. </p>', 'CreateServer' => '<p> Creates and immedately starts a new server. The server is ready to use when it is in the <code>HEALTHY</code> state. By default, you can create a maximum of 10 servers. </p> <p> This operation is asynchronous. </p> <p> A <code>LimitExceededException</code> is thrown when you have created the maximum number of servers (10). A <code>ResourceAlreadyExistsException</code> is thrown when a server with the same name already exists in the account. A <code>ResourceNotFoundException</code> is thrown when you specify a backup ID that is not valid or is for a backup that does not exist. A <code>ValidationException</code> is thrown when parameters of the request are not valid. </p> <p> If you do not specify a security group by adding the <code>SecurityGroupIds</code> parameter, AWS OpsWorks creates a new security group. The default security group opens the Chef server to the world on TCP port 443. If a KeyName is present, AWS OpsWorks enables SSH access. SSH is also open to the world on TCP port 22. </p> <p>By default, the Chef Server is accessible from any IP address. We recommend that you update your security group rules to allow access from known IP addresses and address ranges only. To edit security group rules, open Security Groups in the navigation pane of the EC2 management console. </p>', 'DeleteBackup' => '<p> Deletes a backup. You can delete both manual and automated backups. This operation is asynchronous. </p> <p> An <code>InvalidStateException</code> is thrown when a backup deletion is already in progress. A <code>ResourceNotFoundException</code> is thrown when the backup does not exist. A <code>ValidationException</code> is thrown when parameters of the request are not valid. </p>', 'DeleteServer' => '<p> Deletes the server and the underlying AWS CloudFormation stack (including the server\'s EC2 instance). When you run this command, the server state is updated to <code>DELETING</code>. After the server is deleted, it is no longer returned by <code>DescribeServer</code> requests. If the AWS CloudFormation stack cannot be deleted, the server cannot be deleted. </p> <p> This operation is asynchronous. </p> <p> An <code>InvalidStateException</code> is thrown when a server deletion is already in progress. A <code>ResourceNotFoundException</code> is thrown when the server does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid. </p> <p> </p>', 'DescribeAccountAttributes' => '<p> Describes your account attributes, and creates requests to increase limits before they are reached or exceeded. </p> <p> This operation is synchronous. </p>', 'DescribeBackups' => '<p> Describes backups. The results are ordered by time, with newest backups first. If you do not specify a BackupId or ServerName, the command returns all backups. </p> <p> This operation is synchronous. </p> <p> A <code>ResourceNotFoundException</code> is thrown when the backup does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid. </p>', 'DescribeEvents' => '<p> Describes events for a specified server. Results are ordered by time, with newest events first. </p> <p> This operation is synchronous. </p> <p> A <code>ResourceNotFoundException</code> is thrown when the server does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid. </p>', 'DescribeNodeAssociationStatus' => '<p> Returns the current status of an existing association or disassociation request. </p> <p> A <code>ResourceNotFoundException</code> is thrown when no recent association or disassociation request with the specified token is found, or when the server does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid. </p>', 'DescribeServers' => '<p> Lists all configuration management servers that are identified with your account. Only the stored results from Amazon DynamoDB are returned. AWS OpsWorks for Chef Automate does not query other services. </p> <p> This operation is synchronous. </p> <p> A <code>ResourceNotFoundException</code> is thrown when the server does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid. </p>', 'DisassociateNode' => '<p> Disassociates a node from a Chef server, and removes the node from the Chef server\'s managed nodes. After a node is disassociated, the node key pair is no longer valid for accessing the Chef API. For more information about how to associate a node, see <a>AssociateNode</a>. </p> <p>A node can can only be disassociated from a server that is in a <code>HEALTHY</code> state. Otherwise, an <code>InvalidStateException</code> is thrown. A <code>ResourceNotFoundException</code> is thrown when the server does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid. </p>', 'RestoreServer' => '<p> Restores a backup to a server that is in a <code>CONNECTION_LOST</code>, <code>HEALTHY</code>, <code>RUNNING</code>, <code>UNHEALTHY</code>, or <code>TERMINATED</code> state. When you run RestoreServer, the server\'s EC2 instance is deleted, and a new EC2 instance is configured. RestoreServer maintains the existing server endpoint, so configuration management of the server\'s client devices (nodes) should continue to work. </p> <p> This operation is asynchronous. </p> <p> An <code>InvalidStateException</code> is thrown when the server is not in a valid state. A <code>ResourceNotFoundException</code> is thrown when the server does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid. </p>', 'StartMaintenance' => '<p> Manually starts server maintenance. This command can be useful if an earlier maintenance attempt failed, and the underlying cause of maintenance failure has been resolved. The server is in an <code>UNDER_MAINTENANCE</code> state while maintenance is in progress. </p> <p> Maintenance can only be started on servers in <code>HEALTHY</code> and <code>UNHEALTHY</code> states. Otherwise, an <code>InvalidStateException</code> is thrown. A <code>ResourceNotFoundException</code> is thrown when the server does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid. </p>', 'UpdateServer' => '<p> Updates settings for a server. </p> <p> This operation is synchronous. </p>', 'UpdateServerEngineAttributes' => '<p> Updates engine-specific attributes on a specified server. The server enters the <code>MODIFYING</code> state when this operation is in progress. Only one update can occur at a time. You can use this command to reset the Chef server\'s private key (<code>CHEF_PIVOTAL_KEY</code>). </p> <p> This operation is asynchronous. </p> <p> This operation can only be called for servers in <code>HEALTHY</code> or <code>UNHEALTHY</code> states. Otherwise, an <code>InvalidStateException</code> is raised. A <code>ResourceNotFoundException</code> is thrown when the server does not exist. A <code>ValidationException</code> is raised when parameters of the request are not valid. </p>', ], 'shapes' => [ 'AccountAttribute' => [ 'base' => '<p>Stores account attributes. </p>', 'refs' => [ 'AccountAttributes$member' => NULL, ], ], 'AccountAttributes' => [ 'base' => '<p> A list of individual account attributes. </p>', 'refs' => [ 'DescribeAccountAttributesResponse$Attributes' => '<p> The attributes that are currently set for the account. </p>', ], ], 'AssociateNodeRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateNodeResponse' => [ 'base' => NULL, 'refs' => [], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'UpdateServerEngineAttributesRequest$AttributeName' => '<p>The name of the engine attribute to update. </p>', ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'UpdateServerEngineAttributesRequest$AttributeValue' => '<p>The value to set for the attribute. </p>', ], ], 'Backup' => [ 'base' => '<p>Describes a single backup. </p>', 'refs' => [ 'Backups$member' => NULL, 'CreateBackupResponse$Backup' => '<p>Backup created by request.</p>', ], ], 'BackupId' => [ 'base' => NULL, 'refs' => [ 'Backup$BackupId' => '<p> The generated ID of the backup. Example: <code>myServerName-yyyyMMddHHmmssSSS</code> </p>', 'CreateServerRequest$BackupId' => '<p> If you specify this field, AWS OpsWorks for Chef Automate creates the server by using the backup represented by BackupId. </p>', 'DeleteBackupRequest$BackupId' => '<p>The ID of the backup to delete. Run the DescribeBackups command to get a list of backup IDs. Backup IDs are in the format <code>ServerName-yyyyMMddHHmmssSSS</code>. </p>', 'DescribeBackupsRequest$BackupId' => '<p>Describes a single backup. </p>', 'RestoreServerRequest$BackupId' => '<p> The ID of the backup that you want to use to restore a server. </p>', ], ], 'BackupRetentionCountDefinition' => [ 'base' => NULL, 'refs' => [ 'CreateServerRequest$BackupRetentionCount' => '<p> The number of automated backups that you want to keep. Whenever a new backup is created, AWS OpsWorks for Chef Automate deletes the oldest backups if this number is exceeded. The default value is <code>1</code>. </p>', ], ], 'BackupStatus' => [ 'base' => NULL, 'refs' => [ 'Backup$Status' => '<p>The status of a backup while in progress. </p>', ], ], 'BackupType' => [ 'base' => NULL, 'refs' => [ 'Backup$BackupType' => '<p> The backup type. Valid values are <code>automated</code> or <code>manual</code>. </p>', ], ], 'Backups' => [ 'base' => NULL, 'refs' => [ 'DescribeBackupsResponse$Backups' => '<p>Contains the response to a <code>DescribeBackups</code> request. </p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateServerRequest$AssociatePublicIpAddress' => '<p> Associate a public IP address with a server that you are launching. Valid values are <code>true</code> or <code>false</code>. The default value is <code>true</code>. </p>', 'CreateServerRequest$DisableAutomatedBackup' => '<p> Enable or disable scheduled backups. Valid values are <code>true</code> or <code>false</code>. The default value is <code>true</code>. </p>', 'Server$AssociatePublicIpAddress' => '<p>Associate a public IP address with a server that you are launching. </p>', 'Server$DisableAutomatedBackup' => '<p>Disables automated backups. The number of stored backups is dependent on the value of PreferredBackupCount. </p>', 'UpdateServerRequest$DisableAutomatedBackup' => '<p>Setting DisableAutomatedBackup to <code>true</code> disables automated or scheduled backups. Automated backups are enabled by default. </p>', ], ], 'CreateBackupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBackupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBackupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBackupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNodeAssociationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNodeAssociationStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateNodeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateNodeResponse' => [ 'base' => NULL, 'refs' => [], ], 'EngineAttribute' => [ 'base' => '<p>A name and value pair that is specific to the engine of the server. </p>', 'refs' => [ 'EngineAttributes$member' => NULL, ], ], 'EngineAttributeName' => [ 'base' => NULL, 'refs' => [ 'EngineAttribute$Name' => '<p>The name of the engine attribute. </p>', ], ], 'EngineAttributeValue' => [ 'base' => NULL, 'refs' => [ 'EngineAttribute$Value' => '<p>The value of the engine attribute. </p>', ], ], 'EngineAttributes' => [ 'base' => NULL, 'refs' => [ 'AssociateNodeRequest$EngineAttributes' => '<p>Engine attributes used for associating the node. </p> <p class="title"> <b>Attributes accepted in a AssociateNode request:</b> </p> <ul> <li> <p> <code>CHEF_ORGANIZATION</code>: The Chef organization with which the node is associated. By default only one organization named <code>default</code> can exist. </p> </li> <li> <p> <code>CHEF_NODE_PUBLIC_KEY</code>: A PEM-formatted public key. This key is required for the <code>chef-client</code> agent to access the Chef API. </p> </li> </ul>', 'CreateServerRequest$EngineAttributes' => '<p>Optional engine attributes on a specified server. </p> <p class="title"> <b>Attributes accepted in a createServer request:</b> </p> <ul> <li> <p> <code>CHEF_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is not stored by AWS OpsWorks for Chef. This private key is required to access the Chef API. When no CHEF_PIVOTAL_KEY is set, one is generated and returned in the response. </p> </li> <li> <p> <code>CHEF_DELIVERY_ADMIN_PASSWORD</code>: The password for the administrative user in the Chef Automate GUI. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/@#$%^&amp;+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_DELIVERY_ADMIN_PASSWORD is set, one is generated and returned in the response.</p> </li> </ul>', 'DisassociateNodeRequest$EngineAttributes' => '<p>Engine attributes used for disassociating the node. </p> <p class="title"> <b>Attributes accepted in a DisassociateNode request:</b> </p> <ul> <li> <p> <code>CHEF_ORGANIZATION</code>: The Chef organization with which the node was associated. By default only one organization named <code>default</code> can exist. </p> </li> </ul>', 'Server$EngineAttributes' => '<p>The response of a createServer() request returns the master credential to access the server in EngineAttributes. These credentials are not stored by AWS OpsWorks for Chef Automate; they are returned only as part of the result of createServer(). </p> <p class="title"> <b>Attributes returned in a createServer response:</b> </p> <ul> <li> <p> <code>CHEF_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS OpsWorks for Chef Automate. This private key is required to access the Chef API.</p> </li> <li> <p> <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and then change to the directory where you\'ve unzipped the file contents. From this directory, you can run Knife commands.</p> </li> </ul>', ], ], 'InstanceProfileArn' => [ 'base' => NULL, 'refs' => [ 'CreateServerRequest$InstanceProfileArn' => '<p> The ARN of the instance profile that your Amazon EC2 instances use. Although the AWS OpsWorks console typically creates the instance profile for you, if you are using API commands instead, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the instance profile you need. </p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AccountAttribute$Maximum' => '<p> The maximum allowed value. </p>', 'AccountAttribute$Used' => '<p> The current usage, such as the current number of servers that are associated with the account. </p>', 'Backup$S3DataSize' => '<p> This field is deprecated and is no longer used. </p>', 'Server$BackupRetentionCount' => '<p>The number of automated backups to keep. </p>', 'UpdateServerRequest$BackupRetentionCount' => '<p>Sets the number of automated backups that you want to keep. </p>', ], ], 'InvalidNextTokenException' => [ 'base' => '<p>This occurs when the provided nextToken is not valid. </p>', 'refs' => [], ], 'InvalidStateException' => [ 'base' => '<p>The resource is in a state that does not allow you to perform a specified action. </p>', 'refs' => [], ], 'KeyPair' => [ 'base' => NULL, 'refs' => [ 'CreateServerRequest$KeyPair' => '<p> The Amazon EC2 key pair to set for the instance. This parameter is optional; if desired, you may specify this parameter to connect to your instances by using SSH. </p>', 'RestoreServerRequest$KeyPair' => '<p> The name of the key pair to set on the new EC2 instance. This can be helpful if the administrator no longer has the SSH key. </p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The limit of servers or backups has been reached. </p>', 'refs' => [], ], 'MaintenanceStatus' => [ 'base' => NULL, 'refs' => [ 'Server$MaintenanceStatus' => '<p>The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>. </p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeBackupsRequest$MaxResults' => '<p>To receive a paginated response, use this parameter to specify the maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results. </p>', 'DescribeEventsRequest$MaxResults' => '<p>To receive a paginated response, use this parameter to specify the maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results. </p>', 'DescribeServersRequest$MaxResults' => '<p>To receive a paginated response, use this parameter to specify the maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results. </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeBackupsRequest$NextToken' => '<p>NextToken is a string that is returned in some command responses. It indicates that not all entries have been returned, and that you must run at least one more request to get remaining items. To get remaining results, call <code>DescribeBackups</code> again, and assign the token from the previous results as the value of the <code>nextToken</code> parameter. If there are no more results, the response object\'s <code>nextToken</code> parameter value is <code>null</code>. Setting a <code>nextToken</code> value that was not returned in your previous results causes an <code>InvalidNextTokenException</code> to occur.</p>', 'DescribeEventsRequest$NextToken' => '<p>NextToken is a string that is returned in some command responses. It indicates that not all entries have been returned, and that you must run at least one more request to get remaining items. To get remaining results, call <code>DescribeEvents</code> again, and assign the token from the previous results as the value of the <code>nextToken</code> parameter. If there are no more results, the response object\'s <code>nextToken</code> parameter value is <code>null</code>. Setting a <code>nextToken</code> value that was not returned in your previous results causes an <code>InvalidNextTokenException</code> to occur. </p>', 'DescribeServersRequest$NextToken' => '<p>NextToken is a string that is returned in some command responses. It indicates that not all entries have been returned, and that you must run at least one more request to get remaining items. To get remaining results, call <code>DescribeServers</code> again, and assign the token from the previous results as the value of the <code>nextToken</code> parameter. If there are no more results, the response object\'s <code>nextToken</code> parameter value is <code>null</code>. Setting a <code>nextToken</code> value that was not returned in your previous results causes an <code>InvalidNextTokenException</code> to occur. </p>', ], ], 'NodeAssociationStatus' => [ 'base' => '<p>The status of the association or disassociation request. </p> <p class="title"> <b>Possible values:</b> </p> <ul> <li> <p> <code>SUCCESS</code>: The association or disassociation succeeded. </p> </li> <li> <p> <code>FAILED</code>: The association or disassociation failed. </p> </li> <li> <p> <code>IN_PROGRESS</code>: The association or disassociation is still in progress. </p> </li> </ul>', 'refs' => [ 'DescribeNodeAssociationStatusResponse$NodeAssociationStatus' => '<p>The status of the association or disassociation request. </p> <p class="title"> <b>Possible values:</b> </p> <ul> <li> <p> <code>SUCCESS</code>: The association or disassociation succeeded. </p> </li> <li> <p> <code>FAILED</code>: The association or disassociation failed. </p> </li> <li> <p> <code>IN_PROGRESS</code>: The association or disassociation is still in progress. </p> </li> </ul>', ], ], 'NodeAssociationStatusToken' => [ 'base' => NULL, 'refs' => [ 'AssociateNodeResponse$NodeAssociationStatusToken' => '<p>Contains a token which can be passed to the <code>DescribeNodeAssociationStatus</code> API call to get the status of the association request. </p>', 'DescribeNodeAssociationStatusRequest$NodeAssociationStatusToken' => NULL, 'DisassociateNodeResponse$NodeAssociationStatusToken' => '<p>Contains a token which can be passed to the <code>DescribeNodeAssociationStatus</code> API call to get the status of the disassociation request. </p>', ], ], 'NodeName' => [ 'base' => '<p>The node name that is used by <code>chef-client</code> for a new node. For more information, see the <a href="http://docs.aws.amazon.com/https:/docs.chef.io/nodes.html#about-node-names">Chef Documentation</a>. </p>', 'refs' => [ 'AssociateNodeRequest$NodeName' => '<p>The name of the Chef client node. </p>', 'DisassociateNodeRequest$NodeName' => '<p>The name of the Chef client node. </p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The requested resource cannot be created because it already exists. </p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource does not exist, or access was denied. </p>', 'refs' => [], ], 'RestoreServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'Server' => [ 'base' => '<p>Describes a configuration management server. </p>', 'refs' => [ 'CreateServerResponse$Server' => '<p>The server that is created by the request. </p>', 'Servers$member' => NULL, 'StartMaintenanceResponse$Server' => '<p>Contains the response to a <code>StartMaintenance</code> request. </p>', 'UpdateServerEngineAttributesResponse$Server' => '<p>Contains the response to an <code>UpdateServerEngineAttributes</code> request. </p>', 'UpdateServerResponse$Server' => '<p>Contains the response to a <code>UpdateServer</code> request. </p>', ], ], 'ServerEvent' => [ 'base' => '<p>An event that is related to the server, such as the start of maintenance or backup. </p>', 'refs' => [ 'ServerEvents$member' => NULL, ], ], 'ServerEvents' => [ 'base' => NULL, 'refs' => [ 'DescribeEventsResponse$ServerEvents' => '<p>Contains the response to a <code>DescribeEvents</code> request. </p>', ], ], 'ServerName' => [ 'base' => NULL, 'refs' => [ 'AssociateNodeRequest$ServerName' => '<p>The name of the server with which to associate the node. </p>', 'Backup$ServerName' => '<p> The name of the server from which the backup was made. </p>', 'CreateBackupRequest$ServerName' => '<p>The name of the server that you want to back up. </p>', 'CreateServerRequest$ServerName' => '<p> The name of the server. The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters. </p>', 'DeleteServerRequest$ServerName' => '<p>The ID of the server to delete.</p>', 'DescribeBackupsRequest$ServerName' => '<p>Returns backups for the server with the specified ServerName. </p>', 'DescribeEventsRequest$ServerName' => '<p>The name of the server for which you want to view events.</p>', 'DescribeNodeAssociationStatusRequest$ServerName' => '<p>The name of the server from which to disassociate the node. </p>', 'DescribeServersRequest$ServerName' => '<p>Describes the server with the specified ServerName.</p>', 'DisassociateNodeRequest$ServerName' => '<p>The name of the server from which to disassociate the node. </p>', 'RestoreServerRequest$ServerName' => '<p> The name of the server that you want to restore. </p>', 'StartMaintenanceRequest$ServerName' => '<p>The name of the server on which to run maintenance. </p>', 'UpdateServerEngineAttributesRequest$ServerName' => '<p>The name of the server to update. </p>', 'UpdateServerRequest$ServerName' => '<p>The name of the server to update. </p>', ], ], 'ServerStatus' => [ 'base' => NULL, 'refs' => [ 'Server$Status' => '<p> The server\'s status. This field displays the states of actions in progress, such as creating, running, or backing up the server, as well as the server\'s health state. </p>', ], ], 'Servers' => [ 'base' => NULL, 'refs' => [ 'DescribeServersResponse$Servers' => '<p>Contains the response to a <code>DescribeServers</code> request. </p>', ], ], 'ServiceRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateServerRequest$ServiceRoleArn' => '<p> The service role that the AWS OpsWorks for Chef Automate service backend uses to work with your account. Although the AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-stuff/latest/service-role-creation.yaml. This template creates a CloudFormation stack that includes the service role that you need. </p>', ], ], 'StartMaintenanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMaintenanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccountAttribute$Name' => '<p> The attribute name. The following are supported attribute names. </p> <ul> <li> <p> <i>ServerLimit:</i> The number of current servers/maximum number of servers allowed. By default, you can have a maximum of 10 servers. </p> </li> <li> <p> <i>ManualBackupLimit:</i> The number of current manual backups/maximum number of backups allowed. By default, you can have a maximum of 50 manual backups saved. </p> </li> </ul>', 'Backup$BackupArn' => '<p>The ARN of the backup. </p>', 'Backup$Description' => '<p> A user-provided description for a manual backup. This field is empty for automated backups. </p>', 'Backup$Engine' => '<p> The engine type that is obtained from the server when the backup is created. </p>', 'Backup$EngineModel' => '<p> The engine model that is obtained from the server when the backup is created. </p>', 'Backup$EngineVersion' => '<p> The engine version that is obtained from the server when the backup is created. </p>', 'Backup$InstanceProfileArn' => '<p> The EC2 instance profile ARN that is obtained from the server when the backup is created. Because this value is stored, you are not required to provide the InstanceProfileArn again if you restore a backup. </p>', 'Backup$InstanceType' => '<p> The instance type that is obtained from the server when the backup is created. </p>', 'Backup$KeyPair' => '<p> The key pair that is obtained from the server when the backup is created. </p>', 'Backup$S3DataUrl' => '<p> This field is deprecated and is no longer used. </p>', 'Backup$S3LogUrl' => '<p> The Amazon S3 URL of the backup\'s log file. </p>', 'Backup$ServiceRoleArn' => '<p> The service role ARN that is obtained from the server when the backup is created. </p>', 'Backup$StatusDescription' => '<p> An informational message about backup status. </p>', 'Backup$ToolsVersion' => '<p> The version of AWS OpsWorks for Chef Automate-specific tools that is obtained from the server when the backup is created. </p>', 'Backup$UserArn' => '<p> The IAM user ARN of the requester for manual backups. This field is empty for automated backups. </p>', 'CreateBackupRequest$Description' => '<p> A user-defined description of the backup. </p>', 'CreateServerRequest$Engine' => '<p> The configuration management engine to use. Valid values include <code>Chef</code>. </p>', 'CreateServerRequest$EngineModel' => '<p> The engine model, or option. Valid values include <code>Single</code>. </p>', 'CreateServerRequest$EngineVersion' => '<p> The major release version of the engine that you want to use. Values depend on the engine that you choose. </p>', 'CreateServerRequest$InstanceType' => '<p> The Amazon EC2 instance type to use. Valid values must be specified in the following format: <code>^([cm][34]|t2).*</code> For example, <code>m4.large</code>. Valid values are <code>t2.medium</code>, <code>m4.large</code>, or <code>m4.2xlarge</code>. </p>', 'DescribeBackupsResponse$NextToken' => '<p>NextToken is a string that is returned in some command responses. It indicates that not all entries have been returned, and that you must run at least one more request to get remaining items. To get remaining results, call <code>DescribeBackups</code> again, and assign the token from the previous results as the value of the <code>nextToken</code> parameter. If there are no more results, the response object\'s <code>nextToken</code> parameter value is <code>null</code>. Setting a <code>nextToken</code> value that was not returned in your previous results causes an <code>InvalidNextTokenException</code> to occur. </p>', 'DescribeEventsResponse$NextToken' => '<p>NextToken is a string that is returned in some command responses. It indicates that not all entries have been returned, and that you must run at least one more request to get remaining items. To get remaining results, call <code>DescribeEvents</code> again, and assign the token from the previous results as the value of the <code>nextToken</code> parameter. If there are no more results, the response object\'s <code>nextToken</code> parameter value is <code>null</code>. Setting a <code>nextToken</code> value that was not returned in your previous results causes an <code>InvalidNextTokenException</code> to occur. </p>', 'DescribeServersResponse$NextToken' => '<p>NextToken is a string that is returned in some command responses. It indicates that not all entries have been returned, and that you must run at least one more request to get remaining items. To get remaining results, call <code>DescribeServers</code> again, and assign the token from the previous results as the value of the <code>nextToken</code> parameter. If there are no more results, the response object\'s <code>nextToken</code> parameter value is <code>null</code>. Setting a <code>nextToken</code> value that was not returned in your previous results causes an <code>InvalidNextTokenException</code> to occur. </p>', 'InvalidNextTokenException$Message' => '<p>Error or informational message that can contain more detail about a nextToken failure. </p>', 'InvalidStateException$Message' => '<p>Error or informational message that provides more detail if a resource is in a state that is not valid for performing a specified action. </p>', 'LimitExceededException$Message' => '<p>Error or informational message that the maximum allowed number of servers or backups has been exceeded. </p>', 'ResourceAlreadyExistsException$Message' => '<p>Error or informational message in response to a CreateServer request that a resource cannot be created because it already exists. </p>', 'ResourceNotFoundException$Message' => '<p>Error or informational message that can contain more detail about problems locating or accessing a resource. </p>', 'RestoreServerRequest$InstanceType' => '<p> The type of the instance to create. Valid values must be specified in the following format: <code>^([cm][34]|t2).*</code> For example, <code>m4.large</code>. Valid values are <code>t2.medium</code>, <code>m4.large</code>, and <code>m4.2xlarge</code>. If you do not specify this parameter, RestoreServer uses the instance type from the specified backup. </p>', 'Server$ServerName' => '<p>The name of the server. </p>', 'Server$CloudFormationStackArn' => '<p>The ARN of the CloudFormation stack that was used to create the server. </p>', 'Server$Endpoint' => '<p> A DNS name that can be used to access the engine. Example: <code>myserver-asdfghjkl.us-east-1.opsworks.io</code> </p>', 'Server$Engine' => '<p>The engine type of the server. The valid value in this release is <code>Chef</code>. </p>', 'Server$EngineModel' => '<p>The engine model of the server. The valid value in this release is <code>Single</code>. </p>', 'Server$EngineVersion' => '<p>The engine version of the server. Because Chef is the engine available in this release, the valid value for EngineVersion is <code>12</code>. </p>', 'Server$InstanceProfileArn' => '<p>The instance profile ARN of the server. </p>', 'Server$InstanceType' => '<p> The instance type for the server, as specified in the CloudFormation stack. This might not be the same instance type that is shown in the EC2 console. </p>', 'Server$KeyPair' => '<p>The key pair associated with the server. </p>', 'Server$ServiceRoleArn' => '<p>The service role ARN used to create the server. </p>', 'Server$StatusReason' => '<p> Depending on the server status, this field has either a human-readable message (such as a create or backup error), or an escaped block of JSON (used for health check results). </p>', 'Server$ServerArn' => '<p>The ARN of the server. </p>', 'ServerEvent$ServerName' => '<p>The name of the server on or for which the event occurred. </p>', 'ServerEvent$Message' => '<p>A human-readable informational or status message.</p>', 'ServerEvent$LogUrl' => '<p>The Amazon S3 URL of the event\'s log file.</p>', 'Strings$member' => NULL, 'ValidationException$Message' => '<p>Error or informational message that can contain more detail about a validation failure. </p>', ], ], 'Strings' => [ 'base' => NULL, 'refs' => [ 'Backup$SecurityGroupIds' => '<p> The security group IDs that are obtained from the server when the backup is created. </p>', 'Backup$SubnetIds' => '<p> The subnet IDs that are obtained from the server when the backup is created. </p>', 'CreateServerRequest$SecurityGroupIds' => '<p> A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the specified security groups must be within the VPC that is specified by <code>SubnetIds</code>. </p> <p> If you do not specify this parameter, AWS OpsWorks for Chef Automate creates one new security group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone). </p>', 'CreateServerRequest$SubnetIds' => '<p> The IDs of subnets in which to launch the server EC2 instance. </p> <p> Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have "Auto Assign Public IP" enabled. </p> <p> EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP" enabled. </p> <p>For more information about supported Amazon EC2 platforms, see <a href="http://docs.aws.amazon.com/https:/docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>.</p>', 'Server$SecurityGroupIds' => '<p> The security group IDs for the server, as specified in the CloudFormation stack. These might not be the same security groups that are shown in the EC2 console. </p>', 'Server$SubnetIds' => '<p> The subnet IDs specified in a CreateServer request. </p>', ], ], 'TimeWindowDefinition' => [ 'base' => '<p> <code>DDD:HH:MM</code> (weekly start time) or <code>HH:MM</code> (daily start time). </p> <p> Time windows always use coordinated universal time (UTC). Valid strings for day of week (<code>DDD</code>) are: <code>Mon</code>, <code>Tue</code>, <code>Wed</code>, <code>Thr</code>, <code>Fri</code>, <code>Sat</code>, or <code>Sun</code>.</p>', 'refs' => [ 'Backup$PreferredBackupWindow' => '<p> The preferred backup period that is obtained from the server when the backup is created. </p>', 'Backup$PreferredMaintenanceWindow' => '<p> The preferred maintenance period that is obtained from the server when the backup is created. </p>', 'CreateServerRequest$PreferredMaintenanceWindow' => '<p> The start time for a one-hour period each week during which AWS OpsWorks for Chef Automate performs maintenance on the instance. Valid values must be specified in the following format: <code>DDD:HH:MM</code>. The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See <code>TimeWindowDefinition</code> for more information. </p> <p> <b>Example:</b> <code>Mon:08:00</code>, which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.) </p>', 'CreateServerRequest$PreferredBackupWindow' => '<p> The start time for a one-hour period during which AWS OpsWorks for Chef Automate backs up application-level data on your server if automated backups are enabled. Valid values must be specified in one of the following formats: </p> <ul> <li> <p> <code>HH:MM</code> for daily backups</p> </li> <li> <p> <code>DDD:HH:MM</code> for weekly backups</p> </li> </ul> <p>The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.</p> <p> <b>Example:</b> <code>08:00</code>, which represents a daily start time of 08:00 UTC.</p> <p> <b>Example:</b> <code>Mon:08:00</code>, which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)</p>', 'Server$PreferredMaintenanceWindow' => '<p>The preferred maintenance period specified for the server. </p>', 'Server$PreferredBackupWindow' => '<p>The preferred backup period specified for the server. </p>', 'UpdateServerRequest$PreferredMaintenanceWindow' => NULL, 'UpdateServerRequest$PreferredBackupWindow' => NULL, ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Backup$CreatedAt' => '<p> The time stamp when the backup was created in the database. Example: <code>2016-07-29T13:38:47.520Z</code> </p>', 'Server$CreatedAt' => '<p>Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code> </p>', 'ServerEvent$CreatedAt' => '<p>The time when the event occurred. </p>', ], ], 'UpdateServerEngineAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServerEngineAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>One or more of the provided request parameters are not valid. </p>', 'refs' => [], ], ],];
