<?php
// This file was auto-generated from sdk-root/src/data/organizations/2016-11-28/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Organizations API Reference</fullname> <p>AWS Organizations is a web service that enables you to consolidate your multiple AWS accounts into an <i>organization</i> and centrally manage your accounts and their resources.</p> <p>This guide provides descriptions of the Organizations API. For more information about using this service, see the <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">AWS Organizations User Guide</a>.</p> <p> <b>API Version</b> </p> <p>This version of the Organizations API Reference documents the Organizations API version 2016-11-28.</p> <note> <p>As an alternative to using the API directly, you can use one of the AWS SDKs, which consist of libraries and sample code for various programming languages and platforms (Java, Ruby, .NET, iOS, Android, and more). The SDKs provide a convenient way to create programmatic access to AWS Organizations. For example, the SDKs take care of cryptographically signing requests, managing errors, and retrying requests automatically. For more information about the AWS SDKs, including how to download and install them, see <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>.</p> </note> <p>We recommend that you use the AWS SDKs to make programmatic API calls to Organizations. However, you also can use the Organizations Query API to make direct calls to the Organizations web service. To learn more about the Organizations Query API, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_query-requests.html">Making Query Requests</a> in the <i>AWS Organizations User Guide</i>. Organizations supports GET and POST requests for all actions. That is, the API does not require you to use GET for some actions and POST for others. However, GET requests are subject to the limitation size of a URL. Therefore, for operations that require larger sizes, use a POST request.</p> <p> <b>Signing Requests</b> </p> <p>When you send HTTP requests to AWS, you must sign the requests so that AWS can identify who sent them. You sign requests with your AWS access key, which consists of an access key ID and a secret access key. We strongly recommend that you do not create an access key for your root account. Anyone who has the access key for your root account has unrestricted access to all the resources in your account. Instead, create an access key for an IAM user account that has administrative privileges. As another option, use AWS Security Token Service to generate temporary security credentials, and use those credentials to sign requests. </p> <p>To sign requests, we recommend that you use <a href="http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>. If you have an existing application that uses Signature Version 2, you do not have to update it to use Signature Version 4. However, some operations now require Signature Version 4. The documentation for operations that require version 4 indicate this requirement. </p> <p>When you use the AWS Command Line Interface (AWS CLI) or one of the AWS SDKs to make requests to AWS, these tools automatically sign the requests for you with the access key that you specify when you configure the tools.</p> <p>In this release, each organization can have only one root. In a future release, a single organization will support multiple roots.</p> <p> <b>Support and Feedback for AWS Organizations</b> </p> <p>We welcome your feedback. Send your comments to <a href="mailto:feedback-awsorganizations@amazon.com">feedback-awsorganizations@amazon.com</a> or post your feedback and questions in our private <a href="http://forums.aws.amazon.com/forum.jspa?forumID=219">AWS Organizations support forum</a>. If you don\'t have access to the forum, send a request for access to the email address, along with your forum user ID. For more information about the AWS support forums, see <a href="http://forums.aws.amazon.com/help.jspa">Forums Help</a>.</p> <p> <b>Endpoint to Call When Using the CLI or the AWS API</b> </p> <p>For the current release of Organizations, you must specify the <code>us-east-1</code> region for all AWS API and CLI calls. You can do this in the CLI by using these parameters and commands:</p> <ul> <li> <p>Use the following parameter with each command to specify both the endpoint and its region:</p> <p> <code>--endpoint-url https://organizations.us-east-1.amazonaws.com</code> </p> </li> <li> <p>Use the default endpoint, but configure your default region with this command:</p> <p> <code>aws configure set default.region us-east-1</code> </p> </li> <li> <p>Use the following parameter with each command to specify the endpoint:</p> <p> <code>--region us-east-1</code> </p> </li> </ul> <p>For the various SDKs used to call the APIs, see the documentation for the SDK of interest to learn how to direct the requests to a specific endpoint. For more information, see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#sts_region">Regions and Endpoints</a> in the <i>AWS General Reference</i>. </p> <p> <b>How examples are presented</b> </p> <p>The JSON returned by the AWS Organizations service as response to your requests is returned as a single long string without line breaks or formatting whitespace. Both line breaks and whitespace are included in the examples in this guide to improve readability. When example input parameters also would result in long strings that would extend beyond the screen, we insert line breaks to enhance readability. You should always submit the input as a single JSON text string.</p> <p> <b>Recording API Requests</b> </p> <p>AWS Organizations supports AWS CloudTrail, a service that records AWS API calls for your AWS account and delivers log files to an Amazon S3 bucket. By using information collected by AWS CloudTrail, you can determine which requests were successfully made to Organizations, who made the request, when it was made, and so on. For more about AWS Organizations and its support for AWS CloudTrail, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_cloudtrail-integration.html">Logging AWS Organizations Events with AWS CloudTrail</a> in the <i>AWS Organizations User Guide</i>. To learn more about CloudTrail, including how to turn it on and find your log files, see the <a href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">AWS CloudTrail User Guide</a>.</p>', 'operations' => [ 'AcceptHandshake' => '<p>Sends a response to the originator of a handshake agreeing to the action proposed by the handshake request. </p> <p>This operation can be called only by the following principals when they also have the relevant IAM permissions:</p> <ul> <li> <p> <b>Invitation to join</b> or <b>Approve all features request</b> handshakes: only a principal from the member account. </p> </li> <li> <p> <b>Enable all features final confirmation</b> handshake: only a principal from the master account.</p> <p>For more information about invitations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_invites.html">Inviting an AWS Account to Join Your Organization</a> in the <i>AWS Organizations User Guide</i>. For more information about requests to enable all features in the organization, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>AWS Organizations User Guide</i>.</p> </li> </ul> <p>After you accept a handshake, it continues to appear in the results of relevant APIs for only 30 days. After that it is deleted.</p>', 'AttachPolicy' => '<p>Attaches a policy to a root, an organizational unit, or an individual account. How the policy affects accounts depends on the type of policy:</p> <ul> <li> <p> <b>Service control policy (SCP)</b> - An SCP specifies what permissions can be delegated to users in affected member accounts. The scope of influence for a policy depends on what you attach the policy to:</p> <ul> <li> <p>If you attach an SCP to a root, it affects all accounts in the organization.</p> </li> <li> <p>If you attach an SCP to an OU, it affects all accounts in that OU and in any child OUs.</p> </li> <li> <p>If you attach the policy directly to an account, then it affects only that account.</p> </li> </ul> <p>SCPs essentially are permission "filters". When you attach one SCP to a higher level root or OU, and you also attach a different SCP to a child OU or to an account, the child policy can further restrict only the permissions that pass through the parent filter and are available to the child. An SCP that is attached to a child cannot grant a permission that is not already granted by the parent. For example, imagine that the parent SCP allows permissions A, B, C, D, and E. The child SCP allows C, D, E, F, and G. The result is that the accounts affected by the child SCP are allowed to use only C, D, and E. They cannot use A or B because they were filtered out by the child OU. They also cannot use F and G because they were filtered out by the parent OU. They cannot be granted back by the child SCP; child SCPs can only filter the permissions they receive from the parent SCP.</p> <p>AWS Organizations attaches a default SCP named <code>"FullAWSAccess</code> to every root, OU, and account. This default SCP allows all services and actions, enabling any new child OU or account to inherit the permissions of the parent root or OU. If you detach the default policy, you must replace it with a policy that specifies the permissions that you want to allow in that OU or account.</p> <p>For more information about how Organizations policies permissions work, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">Using Service Control Policies</a> in the <i>AWS Organizations User Guide</i>.</p> </li> </ul> <p>This operation can be called only from the organization\'s master account.</p>', 'CancelHandshake' => '<p>Cancels a handshake. Canceling a handshake sets the handshake state to <code>CANCELED</code>. </p> <p>This operation can be called only from the account that originated the handshake. The recipient of the handshake can\'t cancel it, but can use <a>DeclineHandshake</a> instead. After a handshake is canceled, the recipient can no longer respond to that handshake.</p> <p>After you cancel a handshake, it continues to appear in the results of relevant APIs for only 30 days. After that it is deleted.</p>', 'CreateAccount' => '<p>Creates an AWS account that is automatically a member of the organization whose credentials made the request. This is an asynchronous request that AWS performs in the background. If you want to check the status of the request later, you need the <code>OperationId</code> response element from this operation to provide as a parameter to the <a>DescribeCreateAccountStatus</a> operation.</p> <p>AWS Organizations preconfigures the new member account with a role (named <code>OrganizationAccountAccessRole</code> by default) that grants administrator permissions to the new account. Principals in the master account can assume the role. AWS Organizations clones the company name and address information for the new account from the organization\'s master account.</p> <p>For more information about creating accounts, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html">Creating an AWS Account in Your Organization</a> in the <i>AWS Organizations User Guide</i>.</p> <important> <p>You cannot remove accounts that are created with this operation from an organization. That also means that you cannot delete an organization that contains an account that is created with this operation.</p> </important> <note> <p>When you create a member account with this operation, you can choose whether to create the account with the <b>IAM User and Role Access to Billing Information</b> switch enabled. If you enable it, IAM users and roles that have appropriate permissions can view billing information for the account. If you disable this, then only the account root user can access billing information. For information about how to disable this for an account, see <a href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html">Granting Access to Your Billing Information and Tools</a>.</p> </note> <p>This operation can be called only from the organization\'s master account.</p>', 'CreateOrganization' => '<p>Creates an AWS organization. The account whose user is calling the CreateOrganization operation automatically becomes the <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/orgs_getting-started_concepts.html#account">master account</a> of the new organization.</p> <p>This operation must be called using credentials from the account that is to become the new organization\'s master account. The principal must also have the relevant IAM permissions.</p> <p>By default (or if you set the <code>FeatureSet</code> parameter to <code>ALL</code>), the new organization is created with all features enabled and service control policies automatically enabled in the root. If you instead choose to create the organization supporting only the consolidated billing features by setting the <code>FeatureSet</code> parameter to <code>CONSOLIDATED_BILLING"</code>, then no policy types are enabled by default and you cannot use organization policies.</p>', 'CreateOrganizationalUnit' => '<p>Creates an organizational unit (OU) within a root or parent OU. An OU is a container for accounts that enables you to organize your accounts to apply policies according to your business requirements. The number of levels deep that you can nest OUs is dependent upon the policy types enabled for that root. For service control policies, the limit is five. </p> <p>For more information about OUs, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing Organizational Units</a> in the <i>AWS Organizations User Guide</i>.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'CreatePolicy' => '<p>Creates a policy of a specified type that you can attach to a root, an organizational unit (OU), or an individual AWS account.</p> <p>For more information about policies and their use, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html">Managing Organization Policies</a>.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'DeclineHandshake' => '<p>Declines a handshake request. This sets the handshake state to <code>DECLINED</code> and effectively deactivates the request.</p> <p>This operation can be called only from the account that received the handshake. The originator of the handshake can use <a>CancelHandshake</a> instead. The originator can\'t reactivate a declined request, but can re-initiate the process with a new handshake request.</p> <p>After you decline a handshake, it continues to appear in the results of relevant APIs for only 30 days. After that it is deleted.</p>', 'DeleteOrganization' => '<p>Deletes the organization. You can delete an organization only by using credentials from the master account. The organization must be empty of member accounts, OUs, and policies.</p> <important> <p>If you create any accounts using Organizations operations or the Organizations console, you can\'t remove those accounts from the organization, which means that you can\'t delete the organization.</p> </important>', 'DeleteOrganizationalUnit' => '<p>Deletes an organizational unit from a root or another OU. You must first remove all accounts and child OUs from the OU that you want to delete.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'DeletePolicy' => '<p>Deletes the specified policy from your organization. Before you perform this operation, you must first detach the policy from all OUs, roots, and accounts.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'DescribeAccount' => '<p>Retrieves Organizations-related information about the specified account.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'DescribeCreateAccountStatus' => '<p>Retrieves the current status of an asynchronous request to create an account.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'DescribeHandshake' => '<p>Retrieves information about a previously requested handshake. The handshake ID comes from the response to the original <a>InviteAccountToOrganization</a> operation that generated the handshake.</p> <p>You can access handshakes that are ACCEPTED, DECLINED, or CANCELED for only 30 days after they change to that state. They are then deleted and no longer accessible.</p> <p>This operation can be called from any account in the organization.</p>', 'DescribeOrganization' => '<p>Retrieves information about the organization that the user\'s account belongs to.</p> <p>This operation can be called from any account in the organization.</p>', 'DescribeOrganizationalUnit' => '<p>Retrieves information about an organizational unit (OU).</p> <p>This operation can be called only from the organization\'s master account.</p>', 'DescribePolicy' => '<p>Retrieves information about a policy.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'DetachPolicy' => '<p>Detaches a policy from a target root, organizational unit, or account. If the policy being detached is a service control policy (SCP), the changes to permissions for IAM users and roles in affected accounts are immediate.</p> <p> <b>Note:</b> Every root, OU, and account must have at least one SCP attached. If you want to replace the default <code>FullAWSAccess</code> policy with one that limits the permissions that can be delegated, then you must attach the replacement policy before you can remove the default one. This is the authorization strategy of <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_about-scps.html#orgs_policies_whitelist">whitelisting</a>. If you instead attach a second SCP and leave the <code>FullAWSAccess</code> SCP still attached, and specify <code>"Effect": "Deny"</code> in the second SCP to override the <code>"Effect": "Allow"</code> in the <code>FullAWSAccess</code> policy (or any other attached SCP), then you are using the authorization strategy of <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_about-scps.html#orgs_policies_blacklist">blacklisting</a>. </p> <p>This operation can be called only from the organization\'s master account.</p>', 'DisablePolicyType' => '<p>Disables an organizational control policy type in a root. A poicy of a certain type can be attached to entities in a root only if that type is enabled in the root. After you perform this operation, you no longer can attach policies of the specified type to that root or to any OU or account in that root. You can undo this by using the <a>EnablePolicyType</a> operation.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'EnableAllFeatures' => '<p>Enables all features in an organization. This enables the use of organization policies that can restrict the services and actions that can be called in each account. Until you enable all features, you have access only to consolidated billing, and you can\'t use any of the advanced account administration features that AWS Organizations supports. For more information, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>AWS Organizations User Guide</i>.</p> <important> <p>This operation is required only for organizations that were created explicitly with only the consolidated billing features enabled, or that were migrated from a Consolidated Billing account family to Organizations. Calling this operation sends a handshake to every invited account in the organization. The feature set change can be finalized and the additional features enabled only after all administrators in the invited accounts approve the change by accepting the handshake.</p> </important> <p>After all invited member accounts accept the handshake, you finalize the feature set change by accepting the handshake that contains <code>"Action": "ENABLE_ALL_FEATURES"</code>. This completes the change.</p> <p>After you enable all features in your organization, the master account in the organization can apply policies on all member accounts. These policies can restrict what users and even administrators in those accounts can do. The master account can apply policies that prevent accounts from leaving the organization. Ensure that your account administrators are aware of this.</p> <p>This operation can be called only from the organization\'s master account. </p>', 'EnablePolicyType' => '<p>Enables a policy type in a root. After you enable a policy type in a root, you can attach policies of that type to the root, any OU, or account in that root. You can undo this by using the <a>DisablePolicyType</a> operation.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'InviteAccountToOrganization' => '<p>Sends an invitation to another account to join your organization as a member account. Organizations sends email on your behalf to the email address that is associated with the other account\'s owner. The invitation is implemented as a <a>Handshake</a> whose details are in the response.</p> <important> <p>You can invite AWS accounts only from the same reseller as the master account. For example, if your organization\'s master account was created by Amazon Internet Services Pvt. Ltd (AISPL), an AWS reseller in India, then you can only invite other AISPL accounts to your organization. You can\'t combine accounts from AISPL and AWS. For more information, see <a href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/useconsolidatedbilliing-India.html">Consolidated Billing in India</a>.</p> </important> <p>This operation can be called only from the organization\'s master account.</p>', 'LeaveOrganization' => '<p>Removes a member account from its parent organization. This version of the operation is performed by the account that wants to leave. To remove a member account as a user in the master account, use <a>RemoveAccountFromOrganization</a> instead.</p> <p>This operation can be called only from a member account in the organization.</p> <important> <ul> <li> <p>The master account in an organization with all features enabled can set service control policies (SCPs) that can restrict what administrators of member accounts can do, including preventing them from successfully calling <code>LeaveOrganization</code> and leaving the organization. </p> </li> <li> <p>If you created the account using the AWS Organizations console, the Organizations API, or the Organizations CLI commands, then you cannot remove the account.</p> </li> <li> <p>You can leave an organization only after you enable IAM user access to billing in your account. For more information, see <a href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p> </li> </ul> </important>', 'ListAccounts' => '<p>Lists all the accounts in the organization. To request only the accounts in a root or OU, use the <a>ListAccountsForParent</a> operation instead.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'ListAccountsForParent' => '<p>Lists the accounts in an organization that are contained by the specified target root or organizational unit (OU). If you specify the root, you get a list of all the accounts that are not in any OU. If you specify an OU, you get a list of all the accounts in only that OU, and not in any child OUs. To get a list of all accounts in the organization, use the <a>ListAccounts</a> operation.</p>', 'ListChildren' => '<p>Lists all of the OUs or accounts that are contained in the specified parent OU or root. This operation, along with <a>ListParents</a> enables you to traverse the tree structure that makes up this root.</p>', 'ListCreateAccountStatus' => '<p>Lists the account creation requests that match the specified status that is currently being tracked for the organization.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'ListHandshakesForAccount' => '<p>Lists the current handshakes that are associated with the account of the requesting user.</p> <p>Handshakes that are ACCEPTED, DECLINED, or CANCELED appear in the results of this API for only 30 days after changing to that state. After that they are deleted and no longer accessible.</p> <p>This operation can be called from any account in the organization.</p>', 'ListHandshakesForOrganization' => '<p>Lists the handshakes that are associated with the organization that the requesting user is part of. The <code>ListHandshakesForOrganization</code> operation returns a list of handshake structures. Each structure contains details and status about a handshake.</p> <p>Handshakes that are ACCEPTED, DECLINED, or CANCELED appear in the results of this API for only 30 days after changing to that state. After that they are deleted and no longer accessible.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'ListOrganizationalUnitsForParent' => '<p>Lists the organizational units (OUs) in a parent organizational unit or root.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'ListParents' => '<p>Lists the root or organizational units (OUs) that serve as the immediate parent of the specified child OU or account. This operation, along with <a>ListChildren</a> enables you to traverse the tree structure that makes up this root.</p> <p>This operation can be called only from the organization\'s master account.</p> <note> <p>In the current release, a child can have only a single parent. </p> </note>', 'ListPolicies' => '<p>Retrieves the list of all policies in an organization of a specified type.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'ListPoliciesForTarget' => '<p>Lists the policies that are directly attached to the specified target root, organizational unit (OU), or account. You must specify the policy type that you want included in the returned list.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'ListRoots' => '<p>Lists the roots that are defined in the current organization.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'ListTargetsForPolicy' => '<p>Lists all the roots, OUs, and accounts to which the specified policy is attached.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'MoveAccount' => '<p>Moves an account from its current source parent root or OU to the specified destination parent root or OU.</p> <p>This operation can be called only from the organization\'s master account.</p>', 'RemoveAccountFromOrganization' => '<p>Removes the specified account from the organization.</p> <p>The removed account becomes a stand-alone account that is not a member of any organization. It is no longer subject to any policies and is responsible for its own bill payments. The organization\'s master account is no longer charged for any expenses accrued by the member account after it is removed from the organization.</p> <p>This operation can be called only from the organization\'s master account. Member accounts can remove themselves with <a>LeaveOrganization</a> instead.</p> <important> <ul> <li> <p>You can remove only accounts that were created outside your organization and invited to join. If you created the account using the AWS Organizations console, the Organizations API, or the Organizations CLI commands, then you cannot remove the account.</p> </li> <li> <p>You can remove a member account only after you enable IAM user access to billing in the member account. For more information, see <a href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p> </li> </ul> </important>', 'UpdateOrganizationalUnit' => '<p>Renames the specified organizational unit (OU). The ID and ARN do not change. The child OUs and accounts remain in place, and any attached policies of the OU remain attached. </p> <p>This operation can be called only from the organization\'s master account.</p>', 'UpdatePolicy' => '<p>Updates an existing policy with a new name, description, or content. If any parameter is not supplied, that value remains unchanged. Note that you cannot change a policy\'s type.</p> <p>This operation can be called only from the organization\'s master account.</p>', ], 'shapes' => [ 'AWSOrganizationsNotInUseException' => [ 'base' => '<p>Your account is not a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>', 'refs' => [], ], 'AcceptHandshakeRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptHandshakeResponse' => [ 'base' => NULL, 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>You don\'t have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>.</p>', 'refs' => [], ], 'Account' => [ 'base' => '<p>Contains information about an AWS account that is a member of an organization.</p>', 'refs' => [ 'Accounts$member' => NULL, 'DescribeAccountResponse$Account' => '<p>A structure that contains information about the requested account.</p>', ], ], 'AccountArn' => [ 'base' => NULL, 'refs' => [ 'Account$Arn' => '<p>The Amazon Resource Name (ARN) of the account.</p> <p>For more information about ARNs in Organizations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns">ARN Formats Supported by Organizations</a> in the <i>AWS Organizations User Guide</i>.</p>', 'Organization$MasterAccountArn' => '<p>The Amazon Resource Name (ARN) of the account that is designated as the master account for the organization.</p> <p>For more information about ARNs in Organizations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns">ARN Formats Supported by Organizations</a> in the <i>AWS Organizations User Guide</i>.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'Account$Id' => '<p>The unique identifier (ID) of the account.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>', 'CreateAccountStatus$AccountId' => '<p>If the account was created successfully, the unique identifier (ID) of the new account.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>', 'DescribeAccountRequest$AccountId' => '<p>The unique identifier (ID) of the AWS account that you want information about. You can get the ID from the <a>ListAccounts</a> or <a>ListAccountsForParent</a> operations.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>', 'MoveAccountRequest$AccountId' => '<p>The unique identifier (ID) of the account that you want to move.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>', 'Organization$MasterAccountId' => '<p>The unique identifier (ID) of the master account of an organization.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>', 'RemoveAccountFromOrganizationRequest$AccountId' => '<p>The unique identifier (ID) of the member account that you want to remove from the organization.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>', ], ], 'AccountJoinedMethod' => [ 'base' => NULL, 'refs' => [ 'Account$JoinedMethod' => '<p>The method by which the account joined the organization.</p>', ], ], 'AccountName' => [ 'base' => NULL, 'refs' => [ 'Account$Name' => '<p>The friendly name of the account.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', 'CreateAccountRequest$AccountName' => '<p>The friendly name of the member account.</p>', 'CreateAccountStatus$AccountName' => '<p>The account name given to the account when it was created.</p>', ], ], 'AccountNotFoundException' => [ 'base' => '<p> We can\'t find an AWS account with the AccountId that you specified, or the account whose credentials you used to make this request is not a member of an organization.</p>', 'refs' => [], ], 'AccountStatus' => [ 'base' => NULL, 'refs' => [ 'Account$Status' => '<p>The status of the account in the organization.</p>', ], ], 'Accounts' => [ 'base' => NULL, 'refs' => [ 'ListAccountsForParentResponse$Accounts' => '<p>A list of the accounts in the specified root or OU.</p>', 'ListAccountsResponse$Accounts' => '<p>A list of objects in the organization.</p>', ], ], 'ActionType' => [ 'base' => NULL, 'refs' => [ 'Handshake$Action' => '<p>The type of handshake, indicating what action occurs when the recipient accepts the handshake.</p>', 'HandshakeFilter$ActionType' => '<p>Specifies the type of handshake action.</p> <p>If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.</p>', ], ], 'AlreadyInOrganizationException' => [ 'base' => '<p>This account is already a member of an organization. An account can belong to only one organization at a time.</p>', 'refs' => [], ], 'AttachPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'AwsManagedPolicy' => [ 'base' => NULL, 'refs' => [ 'PolicySummary$AwsManaged' => '<p>A boolean value that indicates whether the specified policy is an AWS managed policy. If true, then you can attach the policy to roots, OUs, or accounts, but you cannot edit it.</p>', ], ], 'CancelHandshakeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelHandshakeResponse' => [ 'base' => NULL, 'refs' => [], ], 'Child' => [ 'base' => '<p>Contains a list of child entities, either OUs or accounts.</p>', 'refs' => [ 'Children$member' => NULL, ], ], 'ChildId' => [ 'base' => NULL, 'refs' => [ 'Child$Id' => '<p>The unique identifier (ID) of this child entity.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the following:</p> <ul> <li> <p>Account: a string that consists of exactly 12 digits.</p> </li> <li> <p>Organizational unit (OU): a string that begins with "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that contains the OU) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p> </li> </ul>', 'ListParentsRequest$ChildId' => '<p>The unique identifier (ID) of the OU or account whose parent containers you want to list. Do not specify a root.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the following:</p> <ul> <li> <p>Account: a string that consists of exactly 12 digits.</p> </li> <li> <p>Organizational unit (OU): a string that begins with "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that contains the OU) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p> </li> </ul>', ], ], 'ChildNotFoundException' => [ 'base' => '<p>We can\'t find an organizational unit (OU) or AWS account with the ChildId that you specified.</p>', 'refs' => [], ], 'ChildType' => [ 'base' => NULL, 'refs' => [ 'Child$Type' => '<p>The type of this child entity.</p>', 'ListChildrenRequest$ChildType' => '<p>Filters the output to include only the specified child type.</p>', ], ], 'Children' => [ 'base' => NULL, 'refs' => [ 'ListChildrenResponse$Children' => '<p>The list of children of the specified parent container.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>The target of the operation is currently being modified by a different request. Try again later.</p>', 'refs' => [], ], 'ConstraintViolationException' => [ 'base' => '<p>Performing this operation violates a minimum or maximum value limit. For example, attempting to removing the last SCP from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <p/> <ul> <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact AWS Support to request an increase in your limit. </p> <p>Or, The number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations, or contact AWS Support to request an increase in the number of accounts.</p> <p> <b>Note</b>: deleted and closed accounts still count toward your limit.</p> </li> <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes you can send in one day.</p> </li> <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of organizational units you can have in an organization.</p> </li> <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an organizational unit tree that is too many levels deep.</p> </li> <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED. You attempted to exceed the number of policies that you can have in an organization.</p> </li> <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li> <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li> <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA: You attempted to remove an account from the organization that does not yet have enough information to exist as a stand-alone account. This account requires you to first agree to the End-User License Agreement (EULA).</p> </li> <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that does not yet have enough information to exist as a stand-alone account. This account requires you to first complete phone verification.</p> </li> <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this account, you first must associate a payment instrument, such as a credit card, with the account.</p> </li> <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a payment instrument, such as a credit card, with the account.</p> </li> <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li> <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization\'s master account to the marketplace that corresponds to the master account\'s address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li> </ul>', 'refs' => [], ], 'ConstraintViolationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ConstraintViolationException$Reason' => NULL, ], ], 'CreateAccountFailureReason' => [ 'base' => NULL, 'refs' => [ 'CreateAccountStatus$FailureReason' => '<p>If the request failed, a description of the reason for the failure.</p> <ul> <li> <p>ACCOUNT_LIMIT_EXCEEDED: The account could not be created because you have reached the limit on the number of accounts in your organization.</p> </li> <li> <p>EMAIL_ALREADY_EXISTS: The account could not be created because another AWS account with that email address already exists.</p> </li> <li> <p>INVALID_ADDRESS: The account could not be created because the address you provided is not valid.</p> </li> <li> <p>INVALID_EMAIL: The account could not be created because the email address you provided is not valid.</p> </li> <li> <p>INTERNAL_FAILURE: The account could not be created because of an internal failure. Try again later. If the problem persists, contact Customer Support.</p> </li> </ul>', ], ], 'CreateAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountRequestId' => [ 'base' => NULL, 'refs' => [ 'CreateAccountStatus$Id' => '<p>The unique identifier (ID) that references this request. You get this value from the response of the initial <a>CreateAccount</a> request to create the account.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an create account request ID string requires "car-" followed by from 8 to 32 lower-case letters or digits.</p>', 'DescribeCreateAccountStatusRequest$CreateAccountRequestId' => '<p>Specifies the <code>operationId</code> that uniquely identifies the request. You can get the ID from the response to an earlier <a>CreateAccount</a> request, or from the <a>ListCreateAccountStatus</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an create account request ID string requires "car-" followed by from 8 to 32 lower-case letters or digits.</p>', ], ], 'CreateAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountState' => [ 'base' => NULL, 'refs' => [ 'CreateAccountStates$member' => NULL, 'CreateAccountStatus$State' => '<p>The status of the request.</p>', ], ], 'CreateAccountStates' => [ 'base' => NULL, 'refs' => [ 'ListCreateAccountStatusRequest$States' => '<p>A list of one or more states that you want included in the response. If this parameter is not present, then all requests are included in the response.</p>', ], ], 'CreateAccountStatus' => [ 'base' => '<p>Contains the status about a <a>CreateAccount</a> request to create an AWS account in an organization.</p>', 'refs' => [ 'CreateAccountResponse$CreateAccountStatus' => '<p>A structure that contains details about the request to create an account. This response structure might not be fully populated when you first receive it because account creation is an asynchronous process. You can pass the returned CreateAccountStatus ID as a parameter to <code> <a>DescribeCreateAccountStatus</a> </code> to get status about the progress of the request at later times. </p>', 'CreateAccountStatuses$member' => NULL, 'DescribeCreateAccountStatusResponse$CreateAccountStatus' => '<p>A structure that contains the current status of an account creation request.</p>', ], ], 'CreateAccountStatusNotFoundException' => [ 'base' => '<p>We can\'t find an create account request with the CreateAccountRequestId that you specified.</p>', 'refs' => [], ], 'CreateAccountStatuses' => [ 'base' => NULL, 'refs' => [ 'ListCreateAccountStatusResponse$CreateAccountStatuses' => '<p>A list of objects with details about the requests. Certain elements, such as the accountId number, are present in the output only after the account has been successfully created.</p>', ], ], 'CreateOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateOrganizationalUnitRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOrganizationalUnitResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeclineHandshakeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeclineHandshakeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOrganizationalUnitRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCreateAccountStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCreateAccountStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHandshakeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHandshakeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationalUnitRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationalUnitResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DestinationParentNotFoundException' => [ 'base' => '<p>We can\'t find the destination container (a root or OU) with the ParentId that you specified.</p>', 'refs' => [], ], 'DetachPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisablePolicyTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisablePolicyTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DuplicateAccountException' => [ 'base' => '<p>That account is already present in the specified destination.</p>', 'refs' => [], ], 'DuplicateHandshakeException' => [ 'base' => '<p>A handshake with the same action and target already exists. For example, if you invited an account to join your organization, the invited account might already have a pending invitation from this organization. If you intend to resend an invitation to an account, ensure that existing handshakes that might be considered duplicates are canceled or declined.</p>', 'refs' => [], ], 'DuplicateOrganizationalUnitException' => [ 'base' => '<p>An organizational unit (OU) with the same name already exists.</p>', 'refs' => [], ], 'DuplicatePolicyAttachmentException' => [ 'base' => '<p>The selected policy is already attached to the specified target.</p>', 'refs' => [], ], 'DuplicatePolicyException' => [ 'base' => '<p>A policy with the same name already exists.</p>', 'refs' => [], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'Account$Email' => '<p>The email address associated with the AWS account.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for this parameter is a string of characters that represents a standard Internet email address.</p>', 'CreateAccountRequest$Email' => '<p>The email address of the owner to assign to the new member account. This email address must not already be associated with another AWS account.</p>', 'Organization$MasterAccountEmail' => '<p>The email address that is associated with the AWS account that is designated as the master account for the organization.</p>', ], ], 'EnableAllFeaturesRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableAllFeaturesResponse' => [ 'base' => NULL, 'refs' => [], ], 'EnablePolicyTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnablePolicyTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'AWSOrganizationsNotInUseException$Message' => NULL, 'AccessDeniedException$Message' => NULL, 'AccountNotFoundException$Message' => NULL, 'AlreadyInOrganizationException$Message' => NULL, 'ChildNotFoundException$Message' => NULL, 'ConcurrentModificationException$Message' => NULL, 'ConstraintViolationException$Message' => NULL, 'CreateAccountStatusNotFoundException$Message' => NULL, 'DestinationParentNotFoundException$Message' => NULL, 'DuplicateAccountException$Message' => NULL, 'DuplicateHandshakeException$Message' => NULL, 'DuplicateOrganizationalUnitException$Message' => NULL, 'DuplicatePolicyAttachmentException$Message' => NULL, 'DuplicatePolicyException$Message' => NULL, 'FinalizingOrganizationException$Message' => NULL, 'HandshakeAlreadyInStateException$Message' => NULL, 'HandshakeConstraintViolationException$Message' => NULL, 'HandshakeNotFoundException$Message' => NULL, 'InvalidHandshakeTransitionException$Message' => NULL, 'InvalidInputException$Message' => NULL, 'MalformedPolicyDocumentException$Message' => NULL, 'MasterCannotLeaveOrganizationException$Message' => NULL, 'OrganizationNotEmptyException$Message' => NULL, 'OrganizationalUnitNotEmptyException$Message' => NULL, 'OrganizationalUnitNotFoundException$Message' => NULL, 'ParentNotFoundException$Message' => NULL, 'PolicyInUseException$Message' => NULL, 'PolicyNotAttachedException$Message' => NULL, 'PolicyNotFoundException$Message' => NULL, 'PolicyTypeAlreadyEnabledException$Message' => NULL, 'PolicyTypeNotAvailableForOrganizationException$Message' => NULL, 'PolicyTypeNotEnabledException$Message' => NULL, 'RootNotFoundException$Message' => NULL, 'ServiceException$Message' => NULL, 'SourceParentNotFoundException$Message' => NULL, 'TargetNotFoundException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, ], ], 'ExceptionType' => [ 'base' => NULL, 'refs' => [ 'TooManyRequestsException$Type' => NULL, ], ], 'FinalizingOrganizationException' => [ 'base' => '<p>AWS Organizations could not finalize the creation of your organization. Try again later. If this persists, contact AWS customer support.</p>', 'refs' => [], ], 'GenericArn' => [ 'base' => NULL, 'refs' => [ 'PolicyTargetSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the policy target.</p> <p>For more information about ARNs in Organizations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns">ARN Formats Supported by Organizations</a> in the <i>AWS Organizations User Guide</i>.</p>', ], ], 'Handshake' => [ 'base' => '<p>Contains information that must be exchanged to securely establish a relationship between two accounts (an <i>originator</i> and a <i>recipient</i>). For example, when a master account (the originator) invites another account (the recipient) to join its organization, the two accounts exchange information as a series of handshake requests and responses.</p> <p> <b>Note:</b> Handshakes that are CANCELED, ACCEPTED, or DECLINED show up in lists for only 30 days after entering that state After that they are deleted.</p>', 'refs' => [ 'AcceptHandshakeResponse$Handshake' => '<p>A structure that contains details about the accepted handshake.</p>', 'CancelHandshakeResponse$Handshake' => '<p>A structure that contains details about the handshake that you canceled.</p>', 'DeclineHandshakeResponse$Handshake' => '<p>A structure that contains details about the declined handshake. The state is updated to show the value <code>DECLINED</code>.</p>', 'DescribeHandshakeResponse$Handshake' => '<p>A structure that contains information about the specified handshake.</p>', 'EnableAllFeaturesResponse$Handshake' => '<p>A structure that contains details about the handshake created to support this request to enable all features in the organization.</p>', 'Handshakes$member' => NULL, 'InviteAccountToOrganizationResponse$Handshake' => '<p>A structure that contains details about the handshake that is created to support this invitation request.</p>', ], ], 'HandshakeAlreadyInStateException' => [ 'base' => '<p>The specified handshake is already in the requested state. For example, you can\'t accept a handshake that was already accepted.</p>', 'refs' => [], ], 'HandshakeArn' => [ 'base' => NULL, 'refs' => [ 'Handshake$Arn' => '<p>The Amazon Resource Name (ARN) of a handshake.</p> <p>For more information about ARNs in Organizations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns">ARN Formats Supported by Organizations</a> in the <i>AWS Organizations User Guide</i>.</p>', ], ], 'HandshakeConstraintViolationException' => [ 'base' => '<p>The requested operation would violate the constraint identified in the reason code.</p> <ul> <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. <b>Note</b>: deleted and closed accounts still count toward your limit.</p> </li> <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes you can send in one day.</p> </li> <li> <p>ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because the invited account is already a member of an organization.</p> </li> <li> <p>ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid because the organization has already enabled all features.</p> </li> <li> <p>INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You cannot issue new invitations to join an organization while it is in the process of enabling all features. You can resume inviting accounts after you finalize the process when all accounts have agreed to the change.</p> </li> <li> <p>PAYMENT_INSTRUMENT_REQUIRED: You cannot complete the operation with an account that does not have a payment instrument, such as a credit card, associated with it.</p> </li> <li> <p>ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because the account is from a different marketplace than the accounts in the organization. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be from the same marketplace.</p> </li> <li> <p>ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to change the membership of an account too quickly after its previous change.</p> </li> </ul>', 'refs' => [], ], 'HandshakeConstraintViolationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'HandshakeConstraintViolationException$Reason' => NULL, ], ], 'HandshakeFilter' => [ 'base' => '<p>Specifies the criteria that are used to select the handshakes for the operation.</p>', 'refs' => [ 'ListHandshakesForAccountRequest$Filter' => '<p>Filters the handshakes that you want included in the response. The default is all types. Use the <code>ActionType</code> element to limit the output to only a specified type, such as <code>INVITE</code>, <code>ENABLE-FULL-CONTROL</code>, or <code>APPROVE-FULL-CONTROL</code>. Alternatively, for the <code>ENABLE-FULL-CONTROL</code> handshake that generates a separate child handshake for each member account, you can specify <code>ParentHandshakeId</code> to see only the handshakes that were generated by that parent request.</p>', 'ListHandshakesForOrganizationRequest$Filter' => '<p>A filter of the handshakes that you want included in the response. The default is all types. Use the <code>ActionType</code> element to limit the output to only a specified type, such as <code>INVITE</code>, <code>ENABLE-ALL-FEATURES</code>, or <code>APPROVE-ALL-FEATURES</code>. Alternatively, for the <code>ENABLE-ALL-FEATURES</code> handshake that generates a separate child handshake for each member account, you can specify the <code>ParentHandshakeId</code> to see only the handshakes that were generated by that parent request.</p>', ], ], 'HandshakeId' => [ 'base' => NULL, 'refs' => [ 'AcceptHandshakeRequest$HandshakeId' => '<p>The unique identifier (ID) of the handshake that you want to accept.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lower-case letters or digits.</p>', 'CancelHandshakeRequest$HandshakeId' => '<p>The unique identifier (ID) of the handshake that you want to cancel. You can get the ID from the <a>ListHandshakesForOrganization</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lower-case letters or digits.</p>', 'DeclineHandshakeRequest$HandshakeId' => '<p>The unique identifier (ID) of the handshake that you want to decline. You can get the ID from the <a>ListHandshakesForAccount</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lower-case letters or digits.</p>', 'DescribeHandshakeRequest$HandshakeId' => '<p>The unique identifier (ID) of the handshake that you want information about. You can get the ID from the original call to <a>InviteAccountToOrganization</a>, or from a call to <a>ListHandshakesForAccount</a> or <a>ListHandshakesForOrganization</a>.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lower-case letters or digits.</p>', 'Handshake$Id' => '<p>The unique identifier (ID) of a handshake. The originating account creates the ID when it initiates the handshake.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lower-case letters or digits.</p>', 'HandshakeFilter$ParentHandshakeId' => '<p>Specifies the parent handshake. Only used for handshake types that are a child of another type.</p> <p>If you specify <code>ParentHandshakeId</code>, you cannot also specify <code>ActionType</code>.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lower-case letters or digits.</p>', ], ], 'HandshakeNotFoundException' => [ 'base' => '<p>We can\'t find a handshake with the HandshakeId that you specified.</p>', 'refs' => [], ], 'HandshakeNotes' => [ 'base' => NULL, 'refs' => [ 'InviteAccountToOrganizationRequest$Notes' => '<p>Additional information that you want to include in the generated email to the recipient account owner.</p>', ], ], 'HandshakeParties' => [ 'base' => NULL, 'refs' => [ 'Handshake$Parties' => '<p>Information about the two accounts that are participating in the handshake.</p>', ], ], 'HandshakeParty' => [ 'base' => '<p>Identifies a participant in a handshake.</p>', 'refs' => [ 'HandshakeParties$member' => NULL, 'InviteAccountToOrganizationRequest$Target' => '<p>The identifier (ID) of the AWS account that you want to invite to join your organization. This is a JSON object that contains the following elements: </p> <p> <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code> </p> <p>If you use the AWS CLI, you can submit this as a single string, similar to the following example:</p> <p> <code>--target id=123456789012,type=ACCOUNT</code> </p> <p>If you specify <code>"Type": "ACCOUNT"</code>, then you must provide the AWS account ID number as the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, then you must specify the email address that is associated with the account.</p> <p> <code>--target id=bill@example.com,type=EMAIL</code> </p>', ], ], 'HandshakePartyId' => [ 'base' => NULL, 'refs' => [ 'HandshakeParty$Id' => '<p>The unique identifier (ID) for the party.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lower-case letters or digits.</p>', ], ], 'HandshakePartyType' => [ 'base' => NULL, 'refs' => [ 'HandshakeParty$Type' => '<p>The type of party.</p>', ], ], 'HandshakeResource' => [ 'base' => '<p>Contains additional data that is needed to process a handshake.</p>', 'refs' => [ 'HandshakeResources$member' => NULL, ], ], 'HandshakeResourceType' => [ 'base' => NULL, 'refs' => [ 'HandshakeResource$Type' => '<p>The type of information being passed, specifying how the value is to be interpreted by the other party:</p> <ul> <li> <p> <code>ACCOUNT</code> - Specifies an AWS account ID number.</p> </li> <li> <p> <code>ORGANIZATION</code> - Specifies an organization ID number.</p> </li> <li> <p> <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the handshake. </p> </li> <li> <p> <code>OWNER_EMAIL</code> - Specifies the email address associated with the master account. Included as information about an organization. </p> </li> <li> <p> <code>OWNER_NAME</code> - Specifies the name associated with the master account. Included as information about an organization. </p> </li> <li> <p> <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the recipient to read.</p> </li> </ul>', ], ], 'HandshakeResourceValue' => [ 'base' => NULL, 'refs' => [ 'HandshakeResource$Value' => '<p>The information that is passed to the other party in the handshake. The format of the value string must match the requirements of the specified type.</p>', ], ], 'HandshakeResources' => [ 'base' => NULL, 'refs' => [ 'Handshake$Resources' => '<p>Additional information that is needed to process the handshake.</p>', 'HandshakeResource$Resources' => '<p>When needed, contains an additional array of <code>HandshakeResource</code> objects.</p>', ], ], 'HandshakeState' => [ 'base' => NULL, 'refs' => [ 'Handshake$State' => '<p>The current state of the handshake. Use the state to trace the flow of the handshake through the process from its creation to its acceptance. The meaning of each of the valid values is as follows:</p> <ul> <li> <p> <b>REQUESTED</b>: This handshake was sent to multiple recipients (applicable to only some handshake types) and not all recipients have responded yet. The request stays in this state until all recipients respond.</p> </li> <li> <p> <b>OPEN</b>: This handshake was sent to multiple recipients (applicable to only some policy types) and all recipients have responded, allowing the originator to complete the handshake action.</p> </li> <li> <p> <b>CANCELED</b>: This handshake is no longer active because it was canceled by the originating account.</p> </li> <li> <p> <b>ACCEPTED</b>: This handshake is complete because it has been accepted by the recipient.</p> </li> <li> <p> <b>DECLINED</b>: This handshake is no longer active because it was declined by the recipient account.</p> </li> <li> <p> <b>EXPIRED</b>: This handshake is no longer active because the originator did not receive a response of any kind from the recipient before the expiration time (15 days).</p> </li> </ul>', ], ], 'Handshakes' => [ 'base' => NULL, 'refs' => [ 'ListHandshakesForAccountResponse$Handshakes' => '<p>A list of <a>Handshake</a> objects with details about each of the handshakes that is associated with the specified account.</p>', 'ListHandshakesForOrganizationResponse$Handshakes' => '<p>A list of <a>Handshake</a> objects with details about each of the handshakes that are associated with an organization.</p>', ], ], 'IAMUserAccessToBilling' => [ 'base' => NULL, 'refs' => [ 'CreateAccountRequest$IamUserAccessToBilling' => '<p>If set to <code>ALLOW</code>, the new account enables IAM users to access account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, then only the root user of the new account can access account billing information. For more information, see <a href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p> <p>If you do not specify this parameter, the value defaults to ALLOW, and IAM users and roles with the required permissions can access billing information for the new account.</p>', ], ], 'InvalidHandshakeTransitionException' => [ 'base' => '<p>You can\'t perform the operation on the handshake in its current state. For example, you can\'t cancel a handshake that was already accepted, or accept a handshake that was already declined.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <ul> <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li> <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid ARN for the organization.</p> </li> <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li> <li> <p>INVALID_ENUM: You specified a value that is not valid for that parameter.</p> </li> <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li> <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li> <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li> <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li> <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li> <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li> <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by AWS and cannot be modified.</p> </li> <li> <p>INVALID_PATTERN: You provided a value that doesn\'t match the required pattern.</p> </li> <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn\'t match the required pattern.</p> </li> <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li> <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter from the response to a previous call of the operation.</p> </li> <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li> <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li> </ul>', 'refs' => [], ], 'InvalidInputExceptionReason' => [ 'base' => NULL, 'refs' => [ 'InvalidInputException$Reason' => NULL, ], ], 'InviteAccountToOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'InviteAccountToOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountsForParentRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountsForParentResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChildrenRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChildrenResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCreateAccountStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCreateAccountStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHandshakesForAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHandshakesForAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHandshakesForOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHandshakesForOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationalUnitsForParentRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationalUnitsForParentResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListParentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListParentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPoliciesForTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPoliciesForTargetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRootsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRootsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetsForPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetsForPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'MalformedPolicyDocumentException' => [ 'base' => '<p>The provided policy document does not meet the requirements of the specified policy type. For example, the syntax might be incorrect. For details about service control policy syntax, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service Control Policy Syntax</a> in the <i>AWS Organizations User Guide</i>.</p>', 'refs' => [], ], 'MasterCannotLeaveOrganizationException' => [ 'base' => '<p>You can\'t remove a master account from an organization. If you want the master account to become a member account in another organization, you must first delete the current organization of the master account.</p>', 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccountsForParentRequest$MaxResults' => '<p>(Optional) Use this to limit the number of results you want included in the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListAccountsRequest$MaxResults' => '<p>(Optional) Use this to limit the number of results you want included in the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListChildrenRequest$MaxResults' => '<p>(Optional) Use this to limit the number of results you want included in the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListCreateAccountStatusRequest$MaxResults' => '<p>(Optional) Use this to limit the number of results you want included in the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListHandshakesForAccountRequest$MaxResults' => '<p>(Optional) Use this to limit the number of results you want included in the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListHandshakesForOrganizationRequest$MaxResults' => '<p>(Optional) Use this to limit the number of results you want included in the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListOrganizationalUnitsForParentRequest$MaxResults' => '<p>(Optional) Use this to limit the number of results you want included in the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListParentsRequest$MaxResults' => '<p>(Optional) Use this to limit the number of results you want included in the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListPoliciesForTargetRequest$MaxResults' => '<p>(Optional) Use this to limit the number of results you want included in the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListPoliciesRequest$MaxResults' => '<p>(Optional) Use this to limit the number of results you want included in the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListRootsRequest$MaxResults' => '<p>(Optional) Use this to limit the number of results you want included in the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListTargetsForPolicyRequest$MaxResults' => '<p>(Optional) Use this to limit the number of results you want included in the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', ], ], 'MoveAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAccountsForParentRequest$NextToken' => '<p>Use this parameter if you receive a <code>NextToken</code> response in a previous request that indicates that there is more output available. Set it to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListAccountsForParentResponse$NextToken' => '<p>If present, this value indicates that there is more output available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListAccountsRequest$NextToken' => '<p>Use this parameter if you receive a <code>NextToken</code> response in a previous request that indicates that there is more output available. Set it to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListAccountsResponse$NextToken' => '<p>If present, this value indicates that there is more output available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListChildrenRequest$NextToken' => '<p>Use this parameter if you receive a <code>NextToken</code> response in a previous request that indicates that there is more output available. Set it to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListChildrenResponse$NextToken' => '<p>If present, this value indicates that there is more output available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListCreateAccountStatusRequest$NextToken' => '<p>Use this parameter if you receive a <code>NextToken</code> response in a previous request that indicates that there is more output available. Set it to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListCreateAccountStatusResponse$NextToken' => '<p>If present, this value indicates that there is more output available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListHandshakesForAccountRequest$NextToken' => '<p>Use this parameter if you receive a <code>NextToken</code> response in a previous request that indicates that there is more output available. Set it to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListHandshakesForAccountResponse$NextToken' => '<p>If present, this value indicates that there is more output available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListHandshakesForOrganizationRequest$NextToken' => '<p>Use this parameter if you receive a <code>NextToken</code> response in a previous request that indicates that there is more output available. Set it to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListHandshakesForOrganizationResponse$NextToken' => '<p>If present, this value indicates that there is more output available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListOrganizationalUnitsForParentRequest$NextToken' => '<p>Use this parameter if you receive a <code>NextToken</code> response in a previous request that indicates that there is more output available. Set it to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListOrganizationalUnitsForParentResponse$NextToken' => '<p>If present, this value indicates that there is more output available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListParentsRequest$NextToken' => '<p>Use this parameter if you receive a <code>NextToken</code> response in a previous request that indicates that there is more output available. Set it to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListParentsResponse$NextToken' => '<p>If present, this value indicates that there is more output available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListPoliciesForTargetRequest$NextToken' => '<p>Use this parameter if you receive a <code>NextToken</code> response in a previous request that indicates that there is more output available. Set it to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListPoliciesForTargetResponse$NextToken' => '<p>If present, this value indicates that there is more output available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListPoliciesRequest$NextToken' => '<p>Use this parameter if you receive a <code>NextToken</code> response in a previous request that indicates that there is more output available. Set it to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListPoliciesResponse$NextToken' => '<p>If present, this value indicates that there is more output available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListRootsRequest$NextToken' => '<p>Use this parameter if you receive a <code>NextToken</code> response in a previous request that indicates that there is more output available. Set it to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListRootsResponse$NextToken' => '<p>If present, this value indicates that there is more output available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListTargetsForPolicyRequest$NextToken' => '<p>Use this parameter if you receive a <code>NextToken</code> response in a previous request that indicates that there is more output available. Set it to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListTargetsForPolicyResponse$NextToken' => '<p>If present, this value indicates that there is more output available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', ], ], 'Organization' => [ 'base' => '<p>Contains details about an organization. An organization is a collection of accounts that are centrally managed together using consolidated billing, organized hierarchically with organizational units (OUs), and controlled with policies .</p>', 'refs' => [ 'CreateOrganizationResponse$Organization' => '<p>A structure that contains details about the newly created organization.</p>', 'DescribeOrganizationResponse$Organization' => '<p>A structure that contains information about the organization.</p>', ], ], 'OrganizationArn' => [ 'base' => NULL, 'refs' => [ 'Organization$Arn' => '<p>The Amazon Resource Name (ARN) of an organization.</p> <p>For more information about ARNs in Organizations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns">ARN Formats Supported by Organizations</a> in the <i>AWS Organizations User Guide</i>.</p>', ], ], 'OrganizationFeatureSet' => [ 'base' => NULL, 'refs' => [ 'CreateOrganizationRequest$FeatureSet' => '<p>Specifies the feature set supported by the new organization. Each feature set supports different levels of functionality.</p> <ul> <li> <p> <i>CONSOLIDATED_BILLING</i>: All member accounts have their bills consolidated to and paid by the master account. For more information, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only">Consolidated Billing</a> in the <i>AWS Organizations User Guide</i>.</p> </li> <li> <p> <i>ALL</i>: In addition to all the features supported by the consolidated billing feature set, the master account can also apply any type of policy to any member account in the organization. For more information, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all">All features</a> in the <i>AWS Organizations User Guide</i>.</p> </li> </ul>', 'Organization$FeatureSet' => '<p>Specifies the functionality that currently is available to the organization. If set to "ALL", then all features are enabled and policies can be applied to accounts in the organization. If set to "CONSOLIDATED_BILLING", then only consolidated billing functionality is available. For more information, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>AWS Organizations User Guide</i>.</p>', ], ], 'OrganizationId' => [ 'base' => NULL, 'refs' => [ 'Organization$Id' => '<p>The unique identifier (ID) of an organization.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organization ID string requires "o-" followed by from 10 to 32 lower-case letters or digits.</p>', ], ], 'OrganizationNotEmptyException' => [ 'base' => '<p>The organization isn\'t empty. To delete an organization, you must first remove all accounts except the master account, delete all organizational units (OUs), and delete all policies.</p>', 'refs' => [], ], 'OrganizationalUnit' => [ 'base' => '<p>Contains details about an organizational unit (OU). An OU is a container of AWS accounts within a root of an organization. Policies that are attached to an OU apply to all accounts contained in that OU and in any child OUs.</p>', 'refs' => [ 'CreateOrganizationalUnitResponse$OrganizationalUnit' => '<p>A structure that contains details about the newly created OU.</p>', 'DescribeOrganizationalUnitResponse$OrganizationalUnit' => '<p>A structure that contains details about the specified OU.</p>', 'OrganizationalUnits$member' => NULL, 'UpdateOrganizationalUnitResponse$OrganizationalUnit' => '<p>A structure that contains the details about the specified OU, including its new name.</p>', ], ], 'OrganizationalUnitArn' => [ 'base' => NULL, 'refs' => [ 'OrganizationalUnit$Arn' => '<p>The Amazon Resource Name (ARN) of this OU.</p> <p>For more information about ARNs in Organizations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns">ARN Formats Supported by Organizations</a> in the <i>AWS Organizations User Guide</i>.</p>', ], ], 'OrganizationalUnitId' => [ 'base' => NULL, 'refs' => [ 'DeleteOrganizationalUnitRequest$OrganizationalUnitId' => '<p>The unique identifier (ID) of the organizational unit that you want to delete. You can get the ID from the <a>ListOrganizationalUnitsForParent</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that contains the OU) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p>', 'DescribeOrganizationalUnitRequest$OrganizationalUnitId' => '<p>The unique identifier (ID) of the organizational unit that you want details about. You can get the ID from the <a>ListOrganizationalUnitsForParent</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that contains the OU) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p>', 'OrganizationalUnit$Id' => '<p>The unique identifier (ID) associated with this OU.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that contains the OU) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p>', 'UpdateOrganizationalUnitRequest$OrganizationalUnitId' => '<p>The unique identifier (ID) of the OU that you want to rename. You can get the ID from the <a>ListOrganizationalUnitsForParent</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that contains the OU) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p>', ], ], 'OrganizationalUnitName' => [ 'base' => NULL, 'refs' => [ 'CreateOrganizationalUnitRequest$Name' => '<p>The friendly name to assign to the new OU.</p>', 'OrganizationalUnit$Name' => '<p>The friendly name of this OU.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', 'UpdateOrganizationalUnitRequest$Name' => '<p>The new name that you want to assign to the OU.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', ], ], 'OrganizationalUnitNotEmptyException' => [ 'base' => '<p>The specified organizational unit (OU) is not empty. Move all accounts to another root or to other OUs, remove all child OUs, and then try the operation again.</p>', 'refs' => [], ], 'OrganizationalUnitNotFoundException' => [ 'base' => '<p>We can\'t find an organizational unit (OU) with the OrganizationalUnitId that you specified.</p>', 'refs' => [], ], 'OrganizationalUnits' => [ 'base' => NULL, 'refs' => [ 'ListOrganizationalUnitsForParentResponse$OrganizationalUnits' => '<p>A list of the OUs in the specified root or parent OU.</p>', ], ], 'Parent' => [ 'base' => '<p>Contains information about either a root or an organizational unit (OU) that can contain OUs or accounts in an organization.</p>', 'refs' => [ 'Parents$member' => NULL, ], ], 'ParentId' => [ 'base' => NULL, 'refs' => [ 'CreateOrganizationalUnitRequest$ParentId' => '<p>The unique identifier (ID) of the parent root or OU in which you want to create the new OU.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p> <ul> <li> <p>Root: a string that begins with "r-" followed by from 4 to 32 lower-case letters or digits.</p> </li> <li> <p>Organizational unit (OU): a string that begins with "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that the OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p> </li> </ul>', 'ListAccountsForParentRequest$ParentId' => '<p>The unique identifier (ID) for the parent root or organization unit (OU) whose accounts you want to list.</p>', 'ListChildrenRequest$ParentId' => '<p>The unique identifier (ID) for the parent root or OU whose children you want to list.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p> <ul> <li> <p>Root: a string that begins with "r-" followed by from 4 to 32 lower-case letters or digits.</p> </li> <li> <p>Organizational unit (OU): a string that begins with "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that the OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p> </li> </ul>', 'ListOrganizationalUnitsForParentRequest$ParentId' => '<p>The unique identifier (ID) of the root or OU whose child OUs you want to list.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p> <ul> <li> <p>Root: a string that begins with "r-" followed by from 4 to 32 lower-case letters or digits.</p> </li> <li> <p>Organizational unit (OU): a string that begins with "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that the OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p> </li> </ul>', 'MoveAccountRequest$SourceParentId' => '<p>The unique identifier (ID) of the root or organizational unit that you want to move the account from.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p> <ul> <li> <p>Root: a string that begins with "r-" followed by from 4 to 32 lower-case letters or digits.</p> </li> <li> <p>Organizational unit (OU): a string that begins with "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that the OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p> </li> </ul>', 'MoveAccountRequest$DestinationParentId' => '<p>The unique identifier (ID) of the root or organizational unit that you want to move the account to.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p> <ul> <li> <p>Root: a string that begins with "r-" followed by from 4 to 32 lower-case letters or digits.</p> </li> <li> <p>Organizational unit (OU): a string that begins with "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that the OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p> </li> </ul>', 'Parent$Id' => '<p>The unique identifier (ID) of the parent entity.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p> <ul> <li> <p>Root: a string that begins with "r-" followed by from 4 to 32 lower-case letters or digits.</p> </li> <li> <p>Organizational unit (OU): a string that begins with "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that the OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p> </li> </ul>', ], ], 'ParentNotFoundException' => [ 'base' => '<p>We can\'t find a root or organizational unit (OU) with the ParentId that you specified.</p>', 'refs' => [], ], 'ParentType' => [ 'base' => NULL, 'refs' => [ 'Parent$Type' => '<p>The type of the parent entity.</p>', ], ], 'Parents' => [ 'base' => NULL, 'refs' => [ 'ListParentsResponse$Parents' => '<p>A list of parents for the specified child account or OU.</p>', ], ], 'Policies' => [ 'base' => NULL, 'refs' => [ 'ListPoliciesForTargetResponse$Policies' => '<p>The list of policies that match the criteria in the request.</p>', 'ListPoliciesResponse$Policies' => '<p>A list of policies that match the filter criteria in the request. The output list does not include the policy contents. To see the content for a policy, see <a>DescribePolicy</a>.</p>', ], ], 'Policy' => [ 'base' => '<p>Contains rules to be applied to the affected accounts. Policies can be attached directly to accounts, or to roots and OUs to affect all accounts in those hierarchies.</p>', 'refs' => [ 'CreatePolicyResponse$Policy' => '<p>A structure that contains details about the newly created policy.</p>', 'DescribePolicyResponse$Policy' => '<p>A structure that contains details about the specified policy.</p>', 'UpdatePolicyResponse$Policy' => '<p>A structure that contains details about the updated policy, showing the requested changes.</p>', ], ], 'PolicyArn' => [ 'base' => NULL, 'refs' => [ 'PolicySummary$Arn' => '<p>The Amazon Resource Name (ARN) of the policy.</p> <p>For more information about ARNs in Organizations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns">ARN Formats Supported by Organizations</a> in the <i>AWS Organizations User Guide</i>.</p>', ], ], 'PolicyContent' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyRequest$Content' => '<p>The policy content to add to the new policy. For example, if you create a <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">service control policy</a> (SCP), this string must be JSON text that specifies the permissions that admins in attached accounts can delegate to their users, groups, and roles. For more information about the SCP syntax, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service Control Policy Syntax</a> in the <i>AWS Organizations User Guide</i>.</p>', 'Policy$Content' => '<p>The text content of the policy.</p>', 'UpdatePolicyRequest$Content' => '<p>If provided, the new content for the policy. The text must be correctly formatted JSON that complies with the syntax for the policy\'s type. For more information, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service Control Policy Syntax</a> in the <i>AWS Organizations User Guide</i>.</p>', ], ], 'PolicyDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyRequest$Description' => '<p>An optional description to assign to the policy.</p>', 'PolicySummary$Description' => '<p>The description of the policy.</p>', 'UpdatePolicyRequest$Description' => '<p>If provided, the new description for the policy.</p>', ], ], 'PolicyId' => [ 'base' => NULL, 'refs' => [ 'AttachPolicyRequest$PolicyId' => '<p>The unique identifier (ID) of the policy that you want to attach to the target. You can get the ID for the policy by calling the <a>ListPolicies</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lower-case letters or digits.</p>', 'DeletePolicyRequest$PolicyId' => '<p>The unique identifier (ID) of the policy that you want to delete. You can get the ID from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a> operations.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lower-case letters or digits.</p>', 'DescribePolicyRequest$PolicyId' => '<p>The unique identifier (ID) of the policy that you want details about. You can get the ID from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a> operations.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lower-case letters or digits.</p>', 'DetachPolicyRequest$PolicyId' => '<p>The unique identifier (ID) of the policy you want to detach. You can get the ID from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a> operations.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lower-case letters or digits.</p>', 'ListTargetsForPolicyRequest$PolicyId' => '<p>The unique identifier (ID) of the policy for which you want to know its attachments.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lower-case letters or digits.</p>', 'PolicySummary$Id' => '<p>The unique identifier (ID) of the policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lower-case letters or digits.</p>', 'UpdatePolicyRequest$PolicyId' => '<p>The unique identifier (ID) of the policy that you want to update.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lower-case letters or digits.</p>', ], ], 'PolicyInUseException' => [ 'base' => '<p>The policy is attached to one or more entities. You must detach it from all roots, organizational units (OUs), and accounts before performing this operation.</p>', 'refs' => [], ], 'PolicyName' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyRequest$Name' => '<p>The friendly name to assign to the policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', 'PolicySummary$Name' => '<p>The friendly name of the policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', 'UpdatePolicyRequest$Name' => '<p>If provided, the new name for the policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', ], ], 'PolicyNotAttachedException' => [ 'base' => '<p>The policy isn\'t attached to the specified target in the specified root.</p>', 'refs' => [], ], 'PolicyNotFoundException' => [ 'base' => '<p>We can\'t find a policy with the PolicyId that you specified.</p>', 'refs' => [], ], 'PolicySummary' => [ 'base' => '<p>Contains information about a policy, but does not include the content. To see the content of a policy, see <a>DescribePolicy</a>.</p>', 'refs' => [ 'Policies$member' => NULL, 'Policy$PolicySummary' => '<p>A structure that contains additional details about the policy.</p>', ], ], 'PolicyTargetId' => [ 'base' => NULL, 'refs' => [ 'AttachPolicyRequest$TargetId' => '<p>The unique identifier (ID) of the root, OU, or account that you want to attach the policy to. You can get the ID by calling the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a> operations.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p> <ul> <li> <p>Root: a string that begins with "r-" followed by from 4 to 32 lower-case letters or digits.</p> </li> <li> <p>Account: a string that consists of exactly 12 digits.</p> </li> <li> <p>Organizational unit (OU): a string that begins with "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that the OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p> </li> </ul>', 'DetachPolicyRequest$TargetId' => '<p>The unique identifier (ID) of the root, OU, or account from which you want to detach the policy. You can get the ID from the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a> operations.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p> <ul> <li> <p>Root: a string that begins with "r-" followed by from 4 to 32 lower-case letters or digits.</p> </li> <li> <p>Account: a string that consists of exactly 12 digits.</p> </li> <li> <p>Organizational unit (OU): a string that begins with "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that the OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p> </li> </ul>', 'ListPoliciesForTargetRequest$TargetId' => '<p>The unique identifier (ID) of the root, organizational unit, or account whose policies you want to list.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p> <ul> <li> <p>Root: a string that begins with "r-" followed by from 4 to 32 lower-case letters or digits.</p> </li> <li> <p>Account: a string that consists of exactly 12 digits.</p> </li> <li> <p>Organizational unit (OU): a string that begins with "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that the OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p> </li> </ul>', 'PolicyTargetSummary$TargetId' => '<p>The unique identifier (ID) of the policy target.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p> <ul> <li> <p>Root: a string that begins with "r-" followed by from 4 to 32 lower-case letters or digits.</p> </li> <li> <p>Account: a string that consists of exactly 12 digits.</p> </li> <li> <p>Organizational unit (OU): a string that begins with "ou-" followed by from 4 to 32 lower-case letters or digits (the ID of the root that the OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case letters or digits.</p> </li> </ul>', ], ], 'PolicyTargetSummary' => [ 'base' => '<p>Contains information about a root, OU, or account that a policy is attached to.</p>', 'refs' => [ 'PolicyTargets$member' => NULL, ], ], 'PolicyTargets' => [ 'base' => NULL, 'refs' => [ 'ListTargetsForPolicyResponse$Targets' => '<p>A list of structures, each of which contains details about one of the entities to which the specified policy is attached.</p>', ], ], 'PolicyType' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyRequest$Type' => '<p>The type of policy to create.</p> <note> <p>In the current release, the only type of policy that you can create is a service control policy (SCP).</p> </note>', 'DisablePolicyTypeRequest$PolicyType' => '<p>The policy type that you want to disable in this root.</p>', 'EnablePolicyTypeRequest$PolicyType' => '<p>The policy type that you want to enable.</p>', 'ListPoliciesForTargetRequest$Filter' => '<p>The type of policy that you want to include in the returned list.</p>', 'ListPoliciesRequest$Filter' => '<p>Specifies the type of policy that you want to include in the response.</p>', 'PolicySummary$Type' => '<p>The type of policy.</p>', 'PolicyTypeSummary$Type' => '<p>The name of the policy type.</p>', ], ], 'PolicyTypeAlreadyEnabledException' => [ 'base' => '<p>The specified policy type is already enabled in the specified root.</p>', 'refs' => [], ], 'PolicyTypeNotAvailableForOrganizationException' => [ 'base' => '<p>You can\'t use the specified policy type with the feature set currently enabled for this organization. For example, you can enable service control policies (SCPs) only after you enable all features in the organization. For more information, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#enable_policies_on_root">Enabling and Disabling a Policy Type on a Root</a> in the <i>AWS Organizations User Guide</i>.</p>', 'refs' => [], ], 'PolicyTypeNotEnabledException' => [ 'base' => '<p>The specified policy type is not currently enabled in this root. You cannot attach policies of the specified type to entities in a root until you enable that type in the root. For more information, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>AWS Organizations User Guide</i>.</p>', 'refs' => [], ], 'PolicyTypeStatus' => [ 'base' => NULL, 'refs' => [ 'PolicyTypeSummary$Status' => '<p>The status of the policy type as it relates to the associated root. To attach a policy of the specified type to a root or to an OU or account in that root, it must be available in the organization and enabled for that root.</p>', ], ], 'PolicyTypeSummary' => [ 'base' => '<p>Contains information about a policy type and its status in the associated root.</p>', 'refs' => [ 'PolicyTypes$member' => NULL, ], ], 'PolicyTypes' => [ 'base' => NULL, 'refs' => [ 'Organization$AvailablePolicyTypes' => '<p>A list of policy types that are enabled for this organization. For example, if your organization has all features enabled, then service control policies (SCPs) are included in the list.</p>', 'Root$PolicyTypes' => '<p>The types of policies that are currently enabled for the root and therefore can be attached to the root or to its OUs or accounts.</p>', ], ], 'RemoveAccountFromOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'RoleName' => [ 'base' => NULL, 'refs' => [ 'CreateAccountRequest$RoleName' => '<p>(Optional)</p> <p>The name of an IAM role that Organizations automatically preconfigures in the new member account. This role trusts the master account, allowing users in the master account to assume the role, as permitted by the master account administrator. The role has administrator permissions in the new member account.</p> <p>If you do not specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.</p> <p>For more information about how to use this role to access the member account, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the <i>AWS Organizations User Guide</i>, and steps 2 and 3 in <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across AWS Accounts Using IAM Roles</a> in the <i>IAM User Guide</i>.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of characters that can consist of uppercase letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>', ], ], 'Root' => [ 'base' => '<p>Contains details about a root. A root is a top-level parent node in the hierarchy of an organization that can contain organizational units (OUs) and accounts. Every root contains every AWS account in the organization. Each root enables the accounts to be organized in a different way and to have different policy types enabled for use in that root.</p>', 'refs' => [ 'DisablePolicyTypeResponse$Root' => '<p>A structure that shows the root with the updated list of enabled policy types.</p>', 'EnablePolicyTypeResponse$Root' => '<p>A structure that shows the root with the updated list of enabled policy types.</p>', 'Roots$member' => NULL, ], ], 'RootArn' => [ 'base' => NULL, 'refs' => [ 'Root$Arn' => '<p>The Amazon Resource Name (ARN) of the root.</p> <p>For more information about ARNs in Organizations, see <a href="http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns">ARN Formats Supported by Organizations</a> in the <i>AWS Organizations User Guide</i>.</p>', ], ], 'RootId' => [ 'base' => NULL, 'refs' => [ 'DisablePolicyTypeRequest$RootId' => '<p>The unique identifier (ID) of the root in which you want to disable a policy type. You can get the ID from the <a>ListPolicies</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lower-case letters or digits.</p>', 'EnablePolicyTypeRequest$RootId' => '<p>The unique identifier (ID) of the root in which you want to enable a policy type. You can get the ID from the <a>ListRoots</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lower-case letters or digits.</p>', 'Root$Id' => '<p>The unique identifier (ID) for the root.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lower-case letters or digits.</p>', ], ], 'RootName' => [ 'base' => NULL, 'refs' => [ 'Root$Name' => '<p>The friendly name of the root.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', ], ], 'RootNotFoundException' => [ 'base' => '<p>We can\'t find a root with the RootId that you specified.</p>', 'refs' => [], ], 'Roots' => [ 'base' => NULL, 'refs' => [ 'ListRootsResponse$Roots' => '<p>A list of roots that are defined in an organization.</p>', ], ], 'ServiceException' => [ 'base' => '<p>AWS Organizations can\'t complete your request because of an internal service error. Try again later.</p>', 'refs' => [], ], 'SourceParentNotFoundException' => [ 'base' => '<p>We can\'t find a source root or OU with the ParentId that you specified.</p>', 'refs' => [], ], 'TargetName' => [ 'base' => NULL, 'refs' => [ 'PolicyTargetSummary$Name' => '<p>The friendly name of the policy target.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', ], ], 'TargetNotFoundException' => [ 'base' => '<p>We can\'t find a root, OU, or account with the TargetId that you specified.</p>', 'refs' => [], ], 'TargetType' => [ 'base' => NULL, 'refs' => [ 'PolicyTargetSummary$Type' => '<p>The type of the policy target.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Account$JoinedTimestamp' => '<p>The date the account became a part of the organization.</p>', 'CreateAccountStatus$RequestedTimestamp' => '<p>The date and time that the request was made for the account creation.</p>', 'CreateAccountStatus$CompletedTimestamp' => '<p>The date and time that the account was created and the request completed.</p>', 'Handshake$RequestedTimestamp' => '<p>The date and time that the handshake request was made.</p>', 'Handshake$ExpirationTimestamp' => '<p>The date and time that the handshake expires. If the recipient of the handshake request fails to respond before the specified date and time, the handshake becomes inactive and is no longer valid.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>You\'ve sent too many requests in too short a period of time. The limit helps protect against denial-of-service attacks. Try again later.</p>', 'refs' => [], ], 'UpdateOrganizationalUnitRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrganizationalUnitResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
