<?php
// This file was auto-generated from sdk-root/src/data/rekognition/2016-06-27/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the Amazon Rekognition API reference.</p>', 'operations' => [ 'CompareFaces' => '<p>Compares a face in the <i>source</i> input image with each face detected in the <i>target</i> input image. </p> <note> <p> If the source image contains multiple faces, the service detects the largest face and compares it with each face detected in the target image. </p> </note> <p>In response, the operation returns an array of face matches ordered by similarity score in descending order. For each face match, the response provides a bounding box of the face, facial landmarks, pose details (pitch, role, and yaw), quality (brightness and sharpness), and confidence value (indicating the level of confidence that the bounding box contains a face). The response also provides a similarity score, which indicates how closely the faces match. </p> <note> <p>By default, only faces with a similarity score of greater than or equal to 80% are returned in the response. You can change this value by specifying the <code>SimilarityThreshold</code> parameter.</p> </note> <p> <code>CompareFaces</code> also returns an array of faces that don\'t match the source image. For each face, it returns a bounding box, confidence value, landmarks, pose details, and quality. The response also returns information about the face in the source image, including the bounding box of the face and confidence value.</p> <p>If the image doesn\'t contain Exif metadata, <code>CompareFaces</code> returns orientation information for the source and target images. Use these values to display the images with the correct image orientation.</p> <note> <p> This is a stateless API operation. That is, data returned by this operation doesn\'t persist.</p> </note> <p>For an example, see <a>get-started-exercise-compare-faces</a>.</p> <p>This operation requires permissions to perform the <code>rekognition:CompareFaces</code> action.</p>', 'CreateCollection' => '<p>Creates a collection in an AWS Region. You can add faces to the collection using the operation. </p> <p>For example, you might create collections, one for each of your application users. A user can then index faces using the <code>IndexFaces</code> operation and persist results in a specific collection. Then, a user can search the collection for faces in the user-specific container. </p> <note> <p>Collection names are case-sensitive.</p> </note> <p>For an example, see <a>example1</a>. </p> <p>This operation requires permissions to perform the <code>rekognition:CreateCollection</code> action.</p>', 'DeleteCollection' => '<p>Deletes the specified collection. Note that this operation removes all faces in the collection. For an example, see <a>example1</a>.</p> <p>This operation requires permissions to perform the <code>rekognition:DeleteCollection</code> action.</p>', 'DeleteFaces' => '<p>Deletes faces from a collection. You specify a collection ID and an array of face IDs to remove from the collection.</p> <p>This operation requires permissions to perform the <code>rekognition:DeleteFaces</code> action.</p>', 'DetectFaces' => '<p>Detects faces within an image (JPEG or PNG) that is provided as input.</p> <p> For each face detected, the operation returns face details including a bounding box of the face, a confidence value (that the bounding box contains a face), and a fixed set of attributes such as facial landmarks (for example, coordinates of eye and mouth), gender, presence of beard, sunglasses, etc. </p> <p>The face-detection algorithm is most effective on frontal faces. For non-frontal or obscured faces, the algorithm may not detect the faces or might detect faces with lower confidence. </p> <note> <p>This is a stateless API operation. That is, the operation does not persist any data.</p> </note> <p>For an example, see <a>get-started-exercise-detect-faces</a>.</p> <p>This operation requires permissions to perform the <code>rekognition:DetectFaces</code> action. </p>', 'DetectLabels' => '<p>Detects instances of real-world labels within an image (JPEG or PNG) provided as input. This includes objects like flower, tree, and table; events like wedding, graduation, and birthday party; and concepts like landscape, evening, and nature. For an example, see <a>get-started-exercise-detect-labels</a>.</p> <p> For each object, scene, and concept the API returns one or more labels. Each label provides the object name, and the level of confidence that the image contains the object. For example, suppose the input image has a lighthouse, the sea, and a rock. The response will include all three labels, one for each object. </p> <p> <code>{Name: lighthouse, Confidence: 98.4629}</code> </p> <p> <code>{Name: rock,Confidence: 79.2097}</code> </p> <p> <code> {Name: sea,Confidence: 75.061}</code> </p> <p> In the preceding example, the operation returns one label for each of the three objects. The operation can also return multiple labels for the same object in the image. For example, if the input image shows a flower (for example, a tulip), the operation might return the following three labels. </p> <p> <code>{Name: flower,Confidence: 99.0562}</code> </p> <p> <code>{Name: plant,Confidence: 99.0562}</code> </p> <p> <code>{Name: tulip,Confidence: 99.0562}</code> </p> <p>In this example, the detection algorithm more precisely identifies the flower as a tulip.</p> <p>You can provide the input image as an S3 object or as base64-encoded bytes. In response, the API returns an array of labels. In addition, the response also includes the orientation correction. Optionally, you can specify <code>MinConfidence</code> to control the confidence threshold for the labels returned. The default is 50%. You can also add the <code>MaxLabels</code> parameter to limit the number of labels returned. </p> <note> <p>If the object detected is a person, the operation doesn\'t provide the same facial details that the <a>DetectFaces</a> operation provides.</p> </note> <p>This is a stateless API operation. That is, the operation does not persist any data.</p> <p>This operation requires permissions to perform the <code>rekognition:DetectLabels</code> action. </p>', 'DetectModerationLabels' => '<p>Detects explicit or suggestive adult content in a specified JPEG or PNG format image. Use <code>DetectModerationLabels</code> to moderate images depending on your requirements. For example, you might want to filter images that contain nudity, but not images containing suggestive content.</p> <p>To filter images, use the labels returned by <code>DetectModerationLabels</code> to determine which types of content are appropriate. For information about moderation labels, see <a>image-moderation</a>.</p>', 'GetCelebrityInfo' => '<p>Gets the name and additional information about a celebrity based on his or her Rekognition ID. The additional information is returned as an array of URLs. If there is no additional information about the celebrity, this list is empty. For more information, see <a>celebrity-recognition</a>.</p> <p>This operation requires permissions to perform the <code>rekognition:GetCelebrityInfo</code> action. </p>', 'IndexFaces' => '<p>Detects faces in the input image and adds them to the specified collection. </p> <p> Amazon Rekognition does not save the actual faces detected. Instead, the underlying detection algorithm first detects the faces in the input image, and for each face extracts facial features into a feature vector, and stores it in the back-end database. Amazon Rekognition uses feature vectors when performing face match and search operations using the and operations. </p> <p>If you provide the optional <code>externalImageID</code> for the input image you provided, Amazon Rekognition associates this ID with all faces that it detects. When you call the operation, the response returns the external ID. You can use this external image ID to create a client-side index to associate the faces with each image. You can then use the index to find all faces in an image. </p> <p>In response, the operation returns an array of metadata for all detected faces. This includes, the bounding box of the detected face, confidence value (indicating the bounding box contains a face), a face ID assigned by the service for each face that is detected and stored, and an image ID assigned by the service for the input image. If you request all facial attributes (using the <code>detectionAttributes</code> parameter, Amazon Rekognition returns detailed facial attributes such as facial landmarks (for example, location of eye and mount) and other facial attributes such gender. If you provide the same image, specify the same collection, and use the same external ID in the <code>IndexFaces</code> operation, Amazon Rekognition doesn\'t save duplicate face metadata. </p> <p>For an example, see <a>example2</a>.</p> <p>This operation requires permissions to perform the <code>rekognition:IndexFaces</code> action.</p>', 'ListCollections' => '<p>Returns list of collection IDs in your account. If the result is truncated, the response also provides a <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.</p> <p>For an example, see <a>example1</a>.</p> <p>This operation requires permissions to perform the <code>rekognition:ListCollections</code> action.</p>', 'ListFaces' => '<p>Returns metadata for faces in the specified collection. This metadata includes information such as the bounding box coordinates, the confidence (that the bounding box contains a face), and face ID. For an example, see <a>example3</a>. </p> <p>This operation requires permissions to perform the <code>rekognition:ListFaces</code> action.</p>', 'RecognizeCelebrities' => '<p>Returns an array of celebrities recognized in the input image. The image is passed either as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. The image must be either a PNG or JPEG formatted file. For more information, see <a>celebrity-recognition</a>. </p> <p> <code>RecognizeCelebrities</code> returns the 15 largest faces in the image. It lists recognized celebrities in the <code>CelebrityFaces</code> list and unrecognized faces in the <code>UnrecognizedFaces</code> list. The operation doesn\'t return celebrities whose face sizes are smaller than the largest 15 faces in the image.</p> <p>For each celebrity recognized, the API returns a <code>Celebrity</code> object. The <code>Celebrity</code> object contains the celebrity name, ID, URL links to additional information, match confidence, and a <code>ComparedFace</code> object that you can use to locate the celebrity\'s face on the image.</p> <p>Rekognition does not retain information about which images a celebrity has been recognized in. Your application must store this information and use the <code>Celebrity</code> ID property as a unique identifier for the celebrity. If you don\'t store the celebrity name or additional information URLs returned by <code>RecognizeCelebrities</code>, you will need the ID to identify the celebrity in a call to the operation.</p> <p>For an example, see <a>recognize-celebrities-tutorial</a>.</p> <p>This operation requires permissions to perform the <code>rekognition:RecognizeCelebrities</code> operation.</p>', 'SearchFaces' => '<p>For a given input face ID, searches for matching faces in the collection the face belongs to. You get a face ID when you add a face to the collection using the <a>IndexFaces</a> operation. The operation compares the features of the input face with faces in the specified collection. </p> <note> <p>You can also search faces without indexing faces by using the <code>SearchFacesByImage</code> operation.</p> </note> <p> The operation response returns an array of faces that match, ordered by similarity score with the highest similarity first. More specifically, it is an array of metadata for each face match that is found. Along with the metadata, the response also includes a <code>confidence</code> value for each face match, indicating the confidence that the specific face matches the input face. </p> <p>For an example, see <a>example3</a>.</p> <p>This operation requires permissions to perform the <code>rekognition:SearchFaces</code> action.</p>', 'SearchFacesByImage' => '<p>For a given input image, first detects the largest face in the image, and then searches the specified collection for matching faces. The operation compares the features of the input face with faces in the specified collection. </p> <note> <p> To search for all faces in an input image, you might first call the operation, and then use the face IDs returned in subsequent calls to the operation. </p> <p> You can also call the <code>DetectFaces</code> operation and use the bounding boxes in the response to make face crops, which then you can pass in to the <code>SearchFacesByImage</code> operation. </p> </note> <p> The response returns an array of faces that match, ordered by similarity score with the highest similarity first. More specifically, it is an array of metadata for each face match found. Along with the metadata, the response also includes a <code>similarity</code> indicating how similar the face is to the input face. In the response, the operation also returns the bounding box (and a confidence level that the bounding box contains a face) of the face that Amazon Rekognition used for the input image. </p> <p>For an example, see <a>example3</a>.</p> <p>This operation requires permissions to perform the <code>rekognition:SearchFacesByImage</code> action.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You are not authorized to perform the action.</p>', 'refs' => [], ], 'AgeRange' => [ 'base' => '<p>Structure containing the estimated age range, in years, for a face.</p> <p>Rekognition estimates an age-range for faces detected in the input image. Estimated age ranges can overlap; a face of a 5 year old may have an estimated range of 4-6 whilst the face of a 6 year old may have an estimated range of 4-8.</p>', 'refs' => [ 'FaceDetail$AgeRange' => '<p>The estimated age range, in years, for the face. Low represents the lowest estimated age and High represents the highest estimated age.</p>', ], ], 'Attribute' => [ 'base' => NULL, 'refs' => [ 'Attributes$member' => NULL, ], ], 'Attributes' => [ 'base' => NULL, 'refs' => [ 'DetectFacesRequest$Attributes' => '<p>An array of facial attributes you want to be returned. This can be the default list of attributes or all attributes. If you don\'t specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but the operation will take longer to complete.</p> <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which attributes to return (in this case, all attributes). </p>', 'IndexFacesRequest$DetectionAttributes' => '<p>An array of facial attributes that you want to be returned. This can be the default list of attributes or all attributes. If you don\'t specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but the operation will take longer to complete.</p> <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which attributes to return (in this case, all attributes). </p>', ], ], 'Beard' => [ 'base' => '<p>Indicates whether or not the face has a beard, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$Beard' => '<p>Indicates whether or not the face has a beard, and the confidence level in the determination.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Beard$Value' => '<p>Boolean value that indicates whether the face has beard or not.</p>', 'EyeOpen$Value' => '<p>Boolean value that indicates whether the eyes on the face are open.</p>', 'Eyeglasses$Value' => '<p>Boolean value that indicates whether the face is wearing eye glasses or not.</p>', 'MouthOpen$Value' => '<p>Boolean value that indicates whether the mouth on the face is open or not.</p>', 'Mustache$Value' => '<p>Boolean value that indicates whether the face has mustache or not.</p>', 'Smile$Value' => '<p>Boolean value that indicates whether the face is smiling or not.</p>', 'Sunglasses$Value' => '<p>Boolean value that indicates whether the face is wearing sunglasses or not.</p>', ], ], 'BoundingBox' => [ 'base' => '<p>Identifies the bounding box around the object or face. The <code>left</code> (x-coordinate) and <code>top</code> (y-coordinate) are coordinates representing the top and left sides of the bounding box. Note that the upper-left corner of the image is the origin (0,0). </p> <p>The <code>top</code> and <code>left</code> values returned are ratios of the overall image size. For example, if the input image is 700x200 pixels, and the top-left coordinate of the bounding box is 350x50 pixels, the API returns a <code>left</code> value of 0.5 (350/700) and a <code>top</code> value of 0.25 (50/200).</p> <p> The <code>width</code> and <code>height</code> values represent the dimensions of the bounding box as a ratio of the overall image dimension. For example, if the input image is 700x200 pixels, and the bounding box width is 70 pixels, the width returned is 0.1. </p> <note> <p> The bounding box coordinates can have negative values. For example, if Amazon Rekognition is able to detect a face that is at the image edge and is only partially visible, the service can return coordinates that are outside the image bounds and, depending on the image edge, you might get negative values or values greater than 1 for the <code>left</code> or <code>top</code> values. </p> </note>', 'refs' => [ 'ComparedFace$BoundingBox' => '<p>Bounding box of the face.</p>', 'ComparedSourceImageFace$BoundingBox' => '<p>Bounding box of the face.</p>', 'Face$BoundingBox' => '<p>Bounding box of the face.</p>', 'FaceDetail$BoundingBox' => '<p>Bounding box of the face.</p>', 'SearchFacesByImageResponse$SearchedFaceBoundingBox' => '<p>The bounding box around the face in the input image that Amazon Rekognition used for the search.</p>', ], ], 'Celebrity' => [ 'base' => '<p>Provides information about a celebrity recognized by the operation.</p>', 'refs' => [ 'CelebrityList$member' => NULL, ], ], 'CelebrityList' => [ 'base' => NULL, 'refs' => [ 'RecognizeCelebritiesResponse$CelebrityFaces' => '<p>Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 15 celebrities in an image.</p>', ], ], 'CollectionId' => [ 'base' => NULL, 'refs' => [ 'CollectionIdList$member' => NULL, 'CreateCollectionRequest$CollectionId' => '<p>ID for the collection that you are creating.</p>', 'DeleteCollectionRequest$CollectionId' => '<p>ID of the collection to delete.</p>', 'DeleteFacesRequest$CollectionId' => '<p>Collection from which to remove the specific faces.</p>', 'IndexFacesRequest$CollectionId' => '<p>The ID of an existing collection to which you want to add the faces that are detected in the input images.</p>', 'ListFacesRequest$CollectionId' => '<p>ID of the collection from which to list the faces.</p>', 'SearchFacesByImageRequest$CollectionId' => '<p>ID of the collection to search.</p>', 'SearchFacesRequest$CollectionId' => '<p>ID of the collection the face belongs to.</p>', ], ], 'CollectionIdList' => [ 'base' => NULL, 'refs' => [ 'ListCollectionsResponse$CollectionIds' => '<p>An array of collection IDs.</p>', ], ], 'CompareFacesMatch' => [ 'base' => '<p>Provides information about a face in a target image that matches the source image face analysed by <code>CompareFaces</code>. The <code>Face</code> property contains the bounding box of the face in the target image. The <code>Similarity</code> property is the confidence that the source image face matches the face in the bounding box.</p>', 'refs' => [ 'CompareFacesMatchList$member' => NULL, ], ], 'CompareFacesMatchList' => [ 'base' => NULL, 'refs' => [ 'CompareFacesResponse$FaceMatches' => '<p>An array of faces in the target image that match the source image face. Each <code>CompareFacesMatch</code> object provides the bounding box, the confidence level that the bounding box contains a face, and the similarity score for the face in the bounding box and the face in the source image.</p>', ], ], 'CompareFacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'CompareFacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'CompareFacesUnmatchList' => [ 'base' => NULL, 'refs' => [ 'CompareFacesResponse$UnmatchedFaces' => '<p>An array of faces in the target image that did not match the source image face.</p>', ], ], 'ComparedFace' => [ 'base' => '<p>Provides face metadata for target image faces that are analysed by <code>CompareFaces</code> and <code>RecognizeCelebrities</code>.</p>', 'refs' => [ 'Celebrity$Face' => '<p>Provides information about the celebrity\'s face, such as its location on the image.</p>', 'CompareFacesMatch$Face' => '<p>Provides face metadata (bounding box and confidence that the bounding box actually contains a face).</p>', 'CompareFacesUnmatchList$member' => NULL, 'ComparedFaceList$member' => NULL, ], ], 'ComparedFaceList' => [ 'base' => NULL, 'refs' => [ 'RecognizeCelebritiesResponse$UnrecognizedFaces' => '<p>Details about each unrecognized face in the image.</p>', ], ], 'ComparedSourceImageFace' => [ 'base' => '<p>Type that describes the face Amazon Rekognition chose to compare with the faces in the target. This contains a bounding box for the selected face and confidence level that the bounding box contains a face. Note that Amazon Rekognition selects the largest face in the source image for this comparison. </p>', 'refs' => [ 'CompareFacesResponse$SourceImageFace' => '<p>The face in the source image that was used for comparison.</p>', ], ], 'CreateCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Degree' => [ 'base' => NULL, 'refs' => [ 'Pose$Roll' => '<p>Value representing the face rotation on the roll axis.</p>', 'Pose$Yaw' => '<p>Value representing the face rotation on the yaw axis.</p>', 'Pose$Pitch' => '<p>Value representing the face rotation on the pitch axis.</p>', ], ], 'DeleteCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectFacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectFacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectLabelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectLabelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectModerationLabelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectModerationLabelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Emotion' => [ 'base' => '<p>The emotions detected on the face, and the confidence level in the determination. For example, HAPPY, SAD, and ANGRY.</p>', 'refs' => [ 'Emotions$member' => NULL, ], ], 'EmotionName' => [ 'base' => NULL, 'refs' => [ 'Emotion$Type' => '<p>Type of emotion detected.</p>', ], ], 'Emotions' => [ 'base' => NULL, 'refs' => [ 'FaceDetail$Emotions' => '<p>The emotions detected on the face, and the confidence level in the determination. For example, HAPPY, SAD, and ANGRY. </p>', ], ], 'ExternalImageId' => [ 'base' => NULL, 'refs' => [ 'Face$ExternalImageId' => '<p>Identifier that you assign to all the faces in the input image.</p>', 'IndexFacesRequest$ExternalImageId' => '<p>ID you want to assign to all the faces detected in the image.</p>', ], ], 'EyeOpen' => [ 'base' => '<p>Indicates whether or not the eyes on the face are open, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$EyesOpen' => '<p>Indicates whether or not the eyes on the face are open, and the confidence level in the determination.</p>', ], ], 'Eyeglasses' => [ 'base' => '<p>Indicates whether or not the face is wearing eye glasses, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$Eyeglasses' => '<p>Indicates whether or not the face is wearing eye glasses, and the confidence level in the determination.</p>', ], ], 'Face' => [ 'base' => '<p>Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image ID that you assigned. </p>', 'refs' => [ 'FaceList$member' => NULL, 'FaceMatch$Face' => '<p>Describes the face properties such as the bounding box, face ID, image ID of the source image, and external image ID that you assigned.</p>', 'FaceRecord$Face' => '<p>Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image ID that you assigned. </p>', ], ], 'FaceDetail' => [ 'base' => '<p>Structure containing attributes of the face that the algorithm detected.</p>', 'refs' => [ 'FaceDetailList$member' => NULL, 'FaceRecord$FaceDetail' => '<p>Structure containing attributes of the face that the algorithm detected.</p>', ], ], 'FaceDetailList' => [ 'base' => NULL, 'refs' => [ 'DetectFacesResponse$FaceDetails' => '<p>Details of each face found in the image. </p>', ], ], 'FaceId' => [ 'base' => NULL, 'refs' => [ 'Face$FaceId' => '<p>Unique identifier that Amazon Rekognition assigns to the face.</p>', 'FaceIdList$member' => NULL, 'SearchFacesRequest$FaceId' => '<p>ID of a face to find matches for in the collection.</p>', 'SearchFacesResponse$SearchedFaceId' => '<p>ID of the face that was searched for matches in a collection.</p>', ], ], 'FaceIdList' => [ 'base' => NULL, 'refs' => [ 'DeleteFacesRequest$FaceIds' => '<p>An array of face IDs to delete.</p>', 'DeleteFacesResponse$DeletedFaces' => '<p>An array of strings (face IDs) of the faces that were deleted.</p>', ], ], 'FaceList' => [ 'base' => NULL, 'refs' => [ 'ListFacesResponse$Faces' => '<p>An array of <code>Face</code> objects. </p>', ], ], 'FaceMatch' => [ 'base' => '<p>Provides face metadata. In addition, it also provides the confidence in the match of this face with the input face.</p>', 'refs' => [ 'FaceMatchList$member' => NULL, ], ], 'FaceMatchList' => [ 'base' => NULL, 'refs' => [ 'SearchFacesByImageResponse$FaceMatches' => '<p>An array of faces that match the input face, along with the confidence in the match.</p>', 'SearchFacesResponse$FaceMatches' => '<p>An array of faces that matched the input face, along with the confidence in the match.</p>', ], ], 'FaceRecord' => [ 'base' => '<p>Object containing both the face metadata (stored in the back-end database) and facial attributes that are detected but aren\'t stored in the database.</p>', 'refs' => [ 'FaceRecordList$member' => NULL, ], ], 'FaceRecordList' => [ 'base' => NULL, 'refs' => [ 'IndexFacesResponse$FaceRecords' => '<p>An array of faces detected and added to the collection. For more information, see <a>howitworks-index-faces</a>. </p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'BoundingBox$Width' => '<p>Width of the bounding box as a ratio of the overall image width.</p>', 'BoundingBox$Height' => '<p>Height of the bounding box as a ratio of the overall image height.</p>', 'BoundingBox$Left' => '<p>Left coordinate of the bounding box as a ratio of overall image width.</p>', 'BoundingBox$Top' => '<p>Top coordinate of the bounding box as a ratio of overall image height.</p>', 'ImageQuality$Brightness' => '<p>Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A higher value indicates a brighter face image.</p>', 'ImageQuality$Sharpness' => '<p>Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A higher value indicates a sharper face image.</p>', 'Landmark$X' => '<p>x-coordinate from the top left of the landmark expressed as the ration of the width of the image. For example, if the images is 700x200 and the x-coordinate of the landmark is at 350 pixels, this value is 0.5. </p>', 'Landmark$Y' => '<p>y-coordinate from the top left of the landmark expressed as the ration of the height of the image. For example, if the images is 700x200 and the y-coordinate of the landmark is at 100 pixels, this value is 0.5.</p>', ], ], 'Gender' => [ 'base' => '<p>Gender of the face and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$Gender' => '<p>Gender of the face and the confidence level in the determination.</p>', ], ], 'GenderType' => [ 'base' => NULL, 'refs' => [ 'Gender$Value' => '<p>Gender of the face.</p>', ], ], 'GetCelebrityInfoRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCelebrityInfoResponse' => [ 'base' => NULL, 'refs' => [], ], 'Image' => [ 'base' => '<p>Provides the input image either as bytes or an S3 object.</p> <p>You pass image bytes to a Rekognition API operation by using the <code>Bytes</code> property. For example, you would use the <code>Bytes</code> property to pass an image loaded from a local file system. Image bytes passed by using the <code>Bytes</code> property must be base64-encoded. Your code may not need to encode image bytes if you are using an AWS SDK to call Rekognition API operations. For more information, see <a>example4</a>.</p> <p> You pass images stored in an S3 bucket to a Rekognition API operation by using the <code>S3Object</code> property. Images stored in an S3 bucket do not need to be base64-encoded.</p> <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p> <p>If you use the Amazon CLI to call Amazon Rekognition operations, passing image bytes using the Bytes property is not supported. You must first upload the image to an Amazon S3 bucket and then call the operation using the S3Object property.</p> <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see <a>manage-access-resource-policies</a>. </p>', 'refs' => [ 'CompareFacesRequest$SourceImage' => '<p>The source image, either as bytes or as an S3 object.</p>', 'CompareFacesRequest$TargetImage' => '<p>The target image, either as bytes or as an S3 object.</p>', 'DetectFacesRequest$Image' => '<p>The image in which you want to detect faces. You can specify a blob or an S3 object. </p>', 'DetectLabelsRequest$Image' => '<p>The input image. You can provide a blob of image bytes or an S3 object.</p>', 'DetectModerationLabelsRequest$Image' => '<p>The input image as bytes or an S3 object.</p>', 'IndexFacesRequest$Image' => '<p>The input image as bytes or an S3 object.</p>', 'RecognizeCelebritiesRequest$Image' => '<p>The input image to use for celebrity recognition.</p>', 'SearchFacesByImageRequest$Image' => '<p>The input image as bytes or an S3 object.</p>', ], ], 'ImageBlob' => [ 'base' => NULL, 'refs' => [ 'Image$Bytes' => '<p>Blob of image bytes up to 5 MBs.</p>', ], ], 'ImageId' => [ 'base' => NULL, 'refs' => [ 'Face$ImageId' => '<p>Unique identifier that Amazon Rekognition assigns to the input image.</p>', ], ], 'ImageQuality' => [ 'base' => '<p>Identifies face image brightness and sharpness. </p>', 'refs' => [ 'ComparedFace$Quality' => '<p>Identifies face image brightness and sharpness. </p>', 'FaceDetail$Quality' => '<p>Identifies image brightness and sharpness.</p>', ], ], 'ImageTooLargeException' => [ 'base' => '<p>The input image size exceeds the allowed limit. For more information, see <a>limits</a>. </p>', 'refs' => [], ], 'IndexFacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'IndexFacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerError' => [ 'base' => '<p>Amazon Rekognition experienced a service issue. Try your call again.</p>', 'refs' => [], ], 'InvalidImageFormatException' => [ 'base' => '<p>The provided image format is not supported. </p>', 'refs' => [], ], 'InvalidPaginationTokenException' => [ 'base' => '<p>Pagination token in the request is not valid.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>Input parameter violated a constraint. Validate your parameter before calling the API operation again.</p>', 'refs' => [], ], 'InvalidS3ObjectException' => [ 'base' => '<p>Amazon Rekognition is unable to access the S3 object specified in the request.</p>', 'refs' => [], ], 'Label' => [ 'base' => '<p>Structure containing details about the detected label, including name, and level of confidence.</p>', 'refs' => [ 'Labels$member' => NULL, ], ], 'Labels' => [ 'base' => NULL, 'refs' => [ 'DetectLabelsResponse$Labels' => '<p>An array of labels for the real-world objects detected. </p>', ], ], 'Landmark' => [ 'base' => '<p>Indicates the location of the landmark on the face.</p>', 'refs' => [ 'Landmarks$member' => NULL, ], ], 'LandmarkType' => [ 'base' => NULL, 'refs' => [ 'Landmark$Type' => '<p>Type of the landmark.</p>', ], ], 'Landmarks' => [ 'base' => NULL, 'refs' => [ 'ComparedFace$Landmarks' => '<p>An array of facial landmarks.</p>', 'FaceDetail$Landmarks' => '<p>Indicates the location of landmarks on the face.</p>', ], ], 'ListCollectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCollectionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxFaces' => [ 'base' => NULL, 'refs' => [ 'SearchFacesByImageRequest$MaxFaces' => '<p>Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence in the match.</p>', 'SearchFacesRequest$MaxFaces' => '<p>Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence in the match.</p>', ], ], 'ModerationLabel' => [ 'base' => '<p>Provides information about a single type of moderated content found in an image. Each type of moderated content has a label within a hierarchical taxonomy. For more information, see <a>image-moderation</a>.</p>', 'refs' => [ 'ModerationLabels$member' => NULL, ], ], 'ModerationLabels' => [ 'base' => NULL, 'refs' => [ 'DetectModerationLabelsResponse$ModerationLabels' => '<p>An array of labels for explicit or suggestive adult content found in the image. The list includes the top-level label and each child label detected in the image. This is useful for filtering specific categories of content. </p>', ], ], 'MouthOpen' => [ 'base' => '<p>Indicates whether or not the mouth on the face is open, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$MouthOpen' => '<p>Indicates whether or not the mouth on the face is open, and the confidence level in the determination.</p>', ], ], 'Mustache' => [ 'base' => '<p>Indicates whether or not the face has a mustache, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$Mustache' => '<p>Indicates whether or not the face has a mustache, and the confidence level in the determination.</p>', ], ], 'OrientationCorrection' => [ 'base' => NULL, 'refs' => [ 'CompareFacesResponse$SourceImageOrientationCorrection' => '<p> The orientation of the source image (counterclockwise direction). If your application displays the source image, you can use this value to correct image orientation. The bounding box coordinates returned in <code>SourceImageFace</code> represent the location of the face before the image orientation is corrected. </p> <note> <p>If the source image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the image\'s orientation. If the Exif metadata for the source image populates the orientation field, the value of <code>OrientationCorrection</code> is null and the <code>SourceImageFace</code> bounding box coordinates represent the location of the face after Exif metadata is used to correct the orientation. Images in .png format don\'t contain Exif metadata.</p> </note>', 'CompareFacesResponse$TargetImageOrientationCorrection' => '<p> The orientation of the target image (in counterclockwise direction). If your application displays the target image, you can use this value to correct the orientation of the image. The bounding box coordinates returned in <code>FaceMatches</code> and <code>UnmatchedFaces</code> represent face locations before the image orientation is corrected. </p> <note> <p>If the target image is in .jpg format, it might contain Exif metadata that includes the orientation of the image. If the Exif metadata for the target image populates the orientation field, the value of <code>OrientationCorrection</code> is null and the bounding box coordinates in <code>FaceMatches</code> and <code>UnmatchedFaces</code> represent the location of the face after Exif metadata is used to correct the orientation. Images in .png format don\'t contain Exif metadata.</p> </note>', 'DetectFacesResponse$OrientationCorrection' => '<p> The orientation of the input image (counter-clockwise direction). If your application displays the image, you can use this value to correct image orientation. The bounding box coordinates returned in <code>FaceDetails</code> represent face locations before the image orientation is corrected. </p> <note> <p>If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the image\'s orientation. If so, and the Exif metadata for the input image populates the orientation field, the value of <code>OrientationCorrection</code> is null and the <code>FaceDetails</code> bounding box coordinates represent face locations after Exif metadata is used to correct the image orientation. Images in .png format don\'t contain Exif metadata.</p> </note>', 'DetectLabelsResponse$OrientationCorrection' => '<p> The orientation of the input image (counter-clockwise direction). If your application displays the image, you can use this value to correct the orientation. If Amazon Rekognition detects that the input image was rotated (for example, by 90 degrees), it first corrects the orientation before detecting the labels. </p> <note> <p>If the input image Exif metadata populates the orientation field, Amazon Rekognition does not perform orientation correction and the value of OrientationCorrection will be null.</p> </note>', 'IndexFacesResponse$OrientationCorrection' => '<p>The orientation of the input image (counterclockwise direction). If your application displays the image, you can use this value to correct image orientation. The bounding box coordinates returned in <code>FaceRecords</code> represent face locations before the image orientation is corrected. </p> <note> <p>If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and the Exif metadata populates the orientation field, the value of <code>OrientationCorrection</code> is null and the bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif metadata is used to correct the image orientation. Images in .png format don\'t contain Exif metadata.</p> </note>', 'RecognizeCelebritiesResponse$OrientationCorrection' => '<p>The orientation of the input image (counterclockwise direction). If your application displays the image, you can use this value to correct the orientation. The bounding box coordinates returned in <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the image orientation is corrected. </p> <note> <p>If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the image\'s orientation. If so, and the Exif metadata for the input image populates the orientation field, the value of <code>OrientationCorrection</code> is null and the <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> bounding box coordinates represent face locations after Exif metadata is used to correct the image orientation. Images in .png format don\'t contain Exif metadata. </p> </note>', ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'ListCollectionsRequest$MaxResults' => '<p>Maximum number of collection IDs to return.</p>', 'ListFacesRequest$MaxResults' => '<p>Maximum number of faces to return.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListCollectionsRequest$NextToken' => '<p>Pagination token from the previous response.</p>', 'ListCollectionsResponse$NextToken' => '<p>If the result is truncated, the response provides a <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.</p>', 'ListFacesRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition returns a pagination token in the response. You can use this pagination token to retrieve the next set of faces.</p>', ], ], 'Percent' => [ 'base' => NULL, 'refs' => [ 'Beard$Confidence' => '<p>Level of confidence in the determination.</p>', 'Celebrity$MatchConfidence' => '<p>The confidence, in percentage, that Rekognition has that the recognized face is the celebrity.</p>', 'CompareFacesMatch$Similarity' => '<p>Level of confidence that the faces match.</p>', 'CompareFacesRequest$SimilarityThreshold' => '<p>The minimum level of confidence in the face matches that a match must meet to be included in the <code>FaceMatches</code> array.</p>', 'ComparedFace$Confidence' => '<p>Level of confidence that what the bounding box contains is a face.</p>', 'ComparedSourceImageFace$Confidence' => '<p>Confidence level that the selected bounding box contains a face.</p>', 'DetectLabelsRequest$MinConfidence' => '<p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn\'t return any labels with confidence lower than this specified value.</p> <p>If <code>MinConfidence</code> is not specified, the operation returns labels with a confidence values greater than or equal to 50 percent.</p>', 'DetectModerationLabelsRequest$MinConfidence' => '<p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn\'t return any labels with a confidence level lower than this specified value.</p> <p>If you don\'t specify <code>MinConfidence</code>, the operation returns labels with confidence values greater than or equal to 50 percent.</p>', 'Emotion$Confidence' => '<p>Level of confidence in the determination.</p>', 'EyeOpen$Confidence' => '<p>Level of confidence in the determination.</p>', 'Eyeglasses$Confidence' => '<p>Level of confidence in the determination.</p>', 'Face$Confidence' => '<p>Confidence level that the bounding box contains a face (and not a different object such as a tree).</p>', 'FaceDetail$Confidence' => '<p>Confidence level that the bounding box contains a face (and not a different object such as a tree).</p>', 'FaceMatch$Similarity' => '<p>Confidence in the match of this face with the input face.</p>', 'Gender$Confidence' => '<p>Level of confidence in the determination.</p>', 'Label$Confidence' => '<p>Level of confidence.</p>', 'ModerationLabel$Confidence' => '<p>Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.</p> <p>If you don\'t specify the <code>MinConfidence</code> parameter in the call to <code>DetectModerationLabels</code>, the operation returns labels with a confidence value greater than or equal to 50 percent.</p>', 'MouthOpen$Confidence' => '<p>Level of confidence in the determination.</p>', 'Mustache$Confidence' => '<p>Level of confidence in the determination.</p>', 'SearchFacesByImageRequest$FaceMatchThreshold' => '<p>(Optional) Specifies the minimum confidence in the face match to return. For example, don\'t return any matches where confidence in matches is less than 70%.</p>', 'SearchFacesByImageResponse$SearchedFaceConfidence' => '<p>The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.</p>', 'SearchFacesRequest$FaceMatchThreshold' => '<p>Optional value specifying the minimum confidence in the face match to return. For example, don\'t return any matches where confidence in matches is less than 70%.</p>', 'Smile$Confidence' => '<p>Level of confidence in the determination.</p>', 'Sunglasses$Confidence' => '<p>Level of confidence in the determination.</p>', ], ], 'Pose' => [ 'base' => '<p>Indicates the pose of the face as determined by its pitch, roll, and yaw.</p>', 'refs' => [ 'ComparedFace$Pose' => '<p>Indicates the pose of the face as determined by its pitch, roll, and yaw.</p>', 'FaceDetail$Pose' => '<p>Indicates the pose of the face as determined by its pitch, roll, and yaw.</p>', ], ], 'ProvisionedThroughputExceededException' => [ 'base' => '<p>The number of requests exceeded your throughput limit. If you want to increase this limit, contact Amazon Rekognition.</p>', 'refs' => [], ], 'RecognizeCelebritiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'RecognizeCelebritiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'RekognitionUniqueId' => [ 'base' => NULL, 'refs' => [ 'Celebrity$Id' => '<p>A unique identifier for the celebrity. </p>', 'GetCelebrityInfoRequest$Id' => '<p>The ID for the celebrity. You get the celebrity ID from a call to the operation, which recognizes celebrities in an image. </p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>A collection with the specified ID already exists.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>Collection specified in the request is not found.</p>', 'refs' => [], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'S3Object$Bucket' => '<p>Name of the S3 bucket.</p>', ], ], 'S3Object' => [ 'base' => '<p>Provides the S3 bucket name and object name.</p> <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p> <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see <a>manage-access-resource-policies</a>. </p>', 'refs' => [ 'Image$S3Object' => '<p>Identifies an S3 object as the image source.</p>', ], ], 'S3ObjectName' => [ 'base' => NULL, 'refs' => [ 'S3Object$Name' => '<p>S3 object key name.</p>', ], ], 'S3ObjectVersion' => [ 'base' => NULL, 'refs' => [ 'S3Object$Version' => '<p>If the bucket is versioning enabled, you can specify the object version. </p>', ], ], 'SearchFacesByImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchFacesByImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchFacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchFacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Smile' => [ 'base' => '<p>Indicates whether or not the face is smiling, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$Smile' => '<p>Indicates whether or not the face is smiling, and the confidence level in the determination.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'Celebrity$Name' => '<p>The name of the celebrity.</p>', 'CreateCollectionResponse$CollectionArn' => '<p>Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your resources. </p>', 'GetCelebrityInfoResponse$Name' => '<p>The name of the celebrity.</p>', 'Label$Name' => '<p>The name (label) of the object.</p>', 'ListFacesResponse$NextToken' => '<p>If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent request to retrieve the next set of faces.</p>', 'ModerationLabel$Name' => '<p>The label name for the type of content detected in the image.</p>', 'ModerationLabel$ParentName' => '<p>The name for the parent label. Labels at the top-level of the hierarchy have the parent label <code>""</code>.</p>', ], ], 'Sunglasses' => [ 'base' => '<p>Indicates whether or not the face is wearing sunglasses, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$Sunglasses' => '<p>Indicates whether or not the face is wearing sunglasses, and the confidence level in the determination.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Amazon Rekognition is temporarily unable to process the request. Try your call again.</p>', 'refs' => [], ], 'UInteger' => [ 'base' => NULL, 'refs' => [ 'AgeRange$Low' => '<p>The lowest estimated age.</p>', 'AgeRange$High' => '<p>The highest estimated age.</p>', 'CreateCollectionResponse$StatusCode' => '<p>HTTP status code indicating the result of the operation.</p>', 'DeleteCollectionResponse$StatusCode' => '<p>HTTP status code that indicates the result of the operation.</p>', 'DetectLabelsRequest$MaxLabels' => '<p>Maximum number of labels you want the service to return in the response. The service returns the specified number of highest confidence labels. </p>', ], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'Urls$member' => NULL, ], ], 'Urls' => [ 'base' => NULL, 'refs' => [ 'Celebrity$Urls' => '<p>An array of URLs pointing to additional information about the celebrity. If there is no additional information about the celebrity, this list is empty.</p>', 'GetCelebrityInfoResponse$Urls' => '<p>An array of URLs pointing to additional celebrity information. </p>', ], ], ],];
