<?php
// This file was auto-generated from sdk-root/src/data/resourcegroupstaggingapi/2017-01-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Resource Groups Tagging API</fullname> <p>This guide describes the API operations for the resource groups tagging.</p> <p>A tag is a label that you assign to an AWS resource. A tag consists of a key and a value, both of which you define. For example, if you have two Amazon EC2 instances, you might assign both a tag key of "Stack." But the value of "Stack" might be "Testing" for one and "Production" for the other.</p> <p>Tagging can help you organize your resources and enables you to simplify resource management, access management and cost allocation. For more information about tagging, see <a href="http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/tag-editor.html">Working with Tag Editor</a> and <a href="http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/resource-groups.html">Working with Resource Groups</a>. For more information about permissions you need to use the resource groups tagging APIs, see <a href="http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/obtaining-permissions-for-resource-groups.html">Obtaining Permissions for Resource Groups </a> and <a href="http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/obtaining-permissions-for-tagging.html">Obtaining Permissions for Tagging </a>.</p> <p>You can use the resource groups tagging APIs to complete the following tasks:</p> <ul> <li> <p>Tag and untag supported resources located in the specified region for the AWS account</p> </li> <li> <p>Use tag-based filters to search for resources located in the specified region for the AWS account</p> </li> <li> <p>List all existing tag keys in the specified region for the AWS account</p> </li> <li> <p>List all existing values for the specified key in the specified region for the AWS account</p> </li> </ul> <p>Not all resources can have tags. For a lists of resources that you can tag, see <a href="http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/supported-resources.html">Supported Resources</a> in the <i>AWS Resource Groups and Tag Editor User Guide</i>.</p> <p>To make full use of the resource groups tagging APIs, you might need additional IAM permissions, including permission to access the resources of individual services as well as permission to view and apply tags to those resources. For more information, see <a href="http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/obtaining-permissions-for-tagging.html">Obtaining Permissions for Tagging</a> in the <i>AWS Resource Groups and Tag Editor User Guide</i>.</p>', 'operations' => [ 'GetResources' => '<p>Returns all the tagged resources that are associated with the specified tags (keys and values) located in the specified region for the AWS account. The tags and the resource types that you specify in the request are known as <i>filters</i>. The response includes all tags that are associated with the requested resources. If no filter is provided, this action returns a paginated resource list with the associated tags.</p>', 'GetTagKeys' => '<p>Returns all tag keys in the specified region for the AWS account.</p>', 'GetTagValues' => '<p>Returns all tag values for the specified key in the specified region for the AWS account.</p>', 'TagResources' => '<p>Applies one or more tags to the specified resources. Note the following:</p> <ul> <li> <p>Not all resources can have tags. For a list of resources that support tagging, see <a href="http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/supported-resources.html">Supported Resources</a> in the <i>AWS Resource Groups and Tag Editor User Guide</i>.</p> </li> <li> <p>Each resource can have up to 50 tags. For other limits, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-restrictions">Tag Restrictions</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> </li> <li> <p>You can only tag resources that are located in the specified region for the AWS account.</p> </li> <li> <p>To add tags to a resource, you need the necessary permissions for the service that the resource belongs to as well as permissions for adding tags. For more information, see <a href="http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/obtaining-permissions-for-tagging.html">Obtaining Permissions for Tagging</a> in the <i>AWS Resource Groups and Tag Editor User Guide</i>.</p> </li> </ul>', 'UntagResources' => '<p>Removes the specified tags from the specified resources. When you specify a tag key, the action removes both that key and its associated value. The operation succeeds even if you attempt to remove tags from a resource that were already removed. Note the following:</p> <ul> <li> <p>To remove tags from a resource, you need the necessary permissions for the service that the resource belongs to as well as permissions for removing tags. For more information, see <a href="http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/obtaining-permissions-for-tagging.html">Obtaining Permissions for Tagging</a> in the <i>AWS Resource Groups and Tag Editor User Guide</i>.</p> </li> <li> <p>You can only tag resources that are located in the specified region for the AWS account.</p> </li> </ul>', ], 'shapes' => [ 'AmazonResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceTypeFilterList$member' => NULL, ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'FailureInfo$ErrorCode' => '<p>The code of the common error. Valid values include <code>InternalServiceException</code>, <code>InvalidParameterException</code>, and any valid error code returned by the AWS service that hosts the resource that you want to tag.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'FailureInfo$ErrorMessage' => '<p>The message of the common error.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'InternalServiceException$Message' => NULL, 'InvalidParameterException$Message' => NULL, 'PaginationTokenExpiredException$Message' => NULL, 'ThrottledException$Message' => NULL, ], ], 'FailedResourcesMap' => [ 'base' => NULL, 'refs' => [ 'TagResourcesOutput$FailedResourcesMap' => '<p>Details of resources that could not be tagged. An error code, status code, and error message are returned for each failed item.</p>', 'UntagResourcesOutput$FailedResourcesMap' => '<p>Details of resources that could not be untagged. An error code, status code, and error message are returned for each failed item.</p>', ], ], 'FailureInfo' => [ 'base' => '<p>Details of the common errors that all actions return.</p>', 'refs' => [ 'FailedResourcesMap$value' => NULL, ], ], 'GetResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetTagKeysInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTagKeysOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetTagValuesInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTagValuesOutput' => [ 'base' => NULL, 'refs' => [], ], 'InternalServiceException' => [ 'base' => '<p>The request processing failed because of an unknown error, exception, or failure. You can retry the request.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>A parameter is missing or a malformed string or invalid or out-of-range value was supplied for the request parameter.</p>', 'refs' => [], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'GetResourcesInput$PaginationToken' => '<p>A string that indicates that additional data is available. Leave this value empty for your initial request. If the response includes a <code>PaginationToken</code>, use that string for this value to request an additional page of data.</p>', 'GetResourcesOutput$PaginationToken' => '<p>A string that indicates that the response contains more data than can be returned in a single response. To receive additional data, specify this string for the <code>PaginationToken</code> value in a subsequent request.</p>', 'GetTagKeysInput$PaginationToken' => '<p>A string that indicates that additional data is available. Leave this value empty for your initial request. If the response includes a PaginationToken, use that string for this value to request an additional page of data.</p>', 'GetTagKeysOutput$PaginationToken' => '<p>A string that indicates that the response contains more data than can be returned in a single response. To receive additional data, specify this string for the <code>PaginationToken</code> value in a subsequent request.</p>', 'GetTagValuesInput$PaginationToken' => '<p>A string that indicates that additional data is available. Leave this value empty for your initial request. If the response includes a PaginationToken, use that string for this value to request an additional page of data.</p>', 'GetTagValuesOutput$PaginationToken' => '<p>A string that indicates that the response contains more data than can be returned in a single response. To receive additional data, specify this string for the <code>PaginationToken</code> value in a subsequent request.</p>', ], ], 'PaginationTokenExpiredException' => [ 'base' => '<p>A <code>PaginationToken</code> is valid for a maximum of 15 minutes. Your request was denied because the specified <code>PaginationToken</code> has expired.</p>', 'refs' => [], ], 'ResourceARN' => [ 'base' => NULL, 'refs' => [ 'FailedResourcesMap$key' => NULL, 'ResourceARNList$member' => NULL, 'ResourceTagMapping$ResourceARN' => '<p>An array of resource ARN(s).</p>', ], ], 'ResourceARNList' => [ 'base' => NULL, 'refs' => [ 'TagResourcesInput$ResourceARNList' => '<p>A list of ARNs. An ARN (Amazon Resource Name) uniquely identifies a resource. You can specify a minimum of 1 and a maximum of 20 ARNs (resources) to tag. An ARN can be set to a maximum of 1600 characters. For more information, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', 'UntagResourcesInput$ResourceARNList' => '<p>A list of ARNs. An ARN (Amazon Resource Name) uniquely identifies a resource. You can specify a minimum of 1 and a maximum of 20 ARNs (resources) to untag. An ARN can be set to a maximum of 1600 characters. For more information, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>', ], ], 'ResourceTagMapping' => [ 'base' => '<p>A list of resource ARNs and the tags (keys and values) that are associated with each.</p>', 'refs' => [ 'ResourceTagMappingList$member' => NULL, ], ], 'ResourceTagMappingList' => [ 'base' => NULL, 'refs' => [ 'GetResourcesOutput$ResourceTagMappingList' => '<p>A list of resource ARNs and the tags (keys and values) associated with each.</p>', ], ], 'ResourceTypeFilterList' => [ 'base' => NULL, 'refs' => [ 'GetResourcesInput$ResourceTypeFilters' => '<p>The constraints on the resources that you want returned. The format of each resource type is <code>service[:resourceType]</code>. For example, specifying a resource type of <code>ec2</code> returns all tagged Amazon EC2 resources (which includes tagged EC2 instances). Specifying a resource type of <code>ec2:instance</code> returns only EC2 instances. </p> <p>The string for each service name and resource type is the same as that embedded in a resource\'s Amazon Resource Name (ARN). Consult the <i>AWS General Reference</i> for the following:</p> <ul> <li> <p>For a list of service name strings, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">AWS Service Namespaces</a>.</p> </li> <li> <p>For resource type strings, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arns-syntax">Example ARNs</a>.</p> </li> <li> <p>For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p> </li> </ul>', ], ], 'ResourcesPerPage' => [ 'base' => NULL, 'refs' => [ 'GetResourcesInput$ResourcesPerPage' => '<p>A limit that restricts the number of resources returned by GetResources in paginated output. You can set ResourcesPerPage to a minimum of 1 item and the maximum of 50 items. </p>', ], ], 'StatusCode' => [ 'base' => NULL, 'refs' => [ 'FailureInfo$StatusCode' => '<p>The HTTP status code of the common error.</p>', ], ], 'Tag' => [ 'base' => '<p>The metadata that you apply to AWS resources to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-basics">Tag Basics</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagFilter' => [ 'base' => '<p>A list of tags (keys and values) that are used to specify the associated resources.</p>', 'refs' => [ 'TagFilterList$member' => NULL, ], ], 'TagFilterList' => [ 'base' => NULL, 'refs' => [ 'GetResourcesInput$TagFilters' => '<p>A list of tags (keys and values). A request can include up to 50 keys, and each key can include up to 20 values.</p> <p>If you specify multiple filters connected by an AND operator in a single request, the response returns only those resources that are associated with every specified filter.</p> <p>If you specify multiple filters connected by an OR operator in a single request, the response returns all resources that are associated with at least one or possibly more of the specified filters.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'GetTagValuesInput$Key' => '<p>The key for which you want to list all existing values in the specified region for the AWS account.</p>', 'Tag$Key' => '<p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>', 'TagFilter$Key' => '<p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>', 'TagKeyList$member' => NULL, 'TagKeyListForUntag$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'GetTagKeysOutput$TagKeys' => '<p>A list of all tag keys in the AWS account.</p>', ], ], 'TagKeyListForUntag' => [ 'base' => NULL, 'refs' => [ 'UntagResourcesInput$TagKeys' => '<p>A list of the tag keys that you want to remove from the specified resources.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ResourceTagMapping$Tags' => '<p>The tags that have been applied to one or more AWS resources.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'TagResourcesInput$Tags' => '<p>The tags that you want to add to the specified resources. A tag consists of a key and a value that you define.</p>', ], ], 'TagResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>', 'TagMap$value' => NULL, 'TagValueList$member' => NULL, 'TagValuesOutputList$member' => NULL, ], ], 'TagValueList' => [ 'base' => NULL, 'refs' => [ 'TagFilter$Values' => '<p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>', ], ], 'TagValuesOutputList' => [ 'base' => NULL, 'refs' => [ 'GetTagValuesOutput$TagValues' => '<p>A list of all tag values for the specified key in the AWS account.</p>', ], ], 'TagsPerPage' => [ 'base' => NULL, 'refs' => [ 'GetResourcesInput$TagsPerPage' => '<p>A limit that restricts the number of tags (key and value pairs) returned by GetResources in paginated output. A resource with no tags is counted as having one tag (one key and value pair).</p> <p> <code>GetResources</code> does not split a resource and its associated tags across pages. If the specified <code>TagsPerPage</code> would cause such a break, a <code>PaginationToken</code> is returned in place of the affected resource and its tags. Use that token in another request to get the remaining data. For example, if you specify a <code>TagsPerPage</code> of <code>100</code> and the account has 22 resources with 10 tags each (meaning that each resource has 10 key and value pairs), the output will consist of 3 pages, with the first page displaying the first 10 resources, each with its 10 tags, the second page displaying the next 10 resources each with its 10 tags, and the third page displaying the remaining 2 resources, each with its 10 tags.</p> <p/> <p>You can set <code>TagsPerPage</code> to a minimum of 100 items and the maximum of 500 items.</p>', ], ], 'ThrottledException' => [ 'base' => '<p>The request was denied to limit the frequency of submitted requests.</p>', 'refs' => [], ], 'UntagResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], ],];
