<?php
// This file was auto-generated from sdk-root/src/data/route53/2013-04-01/docs-2.json
return [ 'version' => '2.0', 'service' => NULL, 'operations' => [ 'AssociateVPCWithHostedZone' => '<p>Associates an Amazon VPC with a private hosted zone. </p> <important> <p>To perform the association, the VPC and the private hosted zone must already exist. You can\'t convert a public hosted zone into a private hosted zone.</p> </important> <note> <p>If you want to associate a VPC that was created by using one AWS account with a private hosted zone that was created by using a different account, the AWS account that created the private hosted zone must first submit a <code>CreateVPCAssociationAuthorization</code> request. Then the account that created the VPC must submit an <code>AssociateVPCWithHostedZone</code> request.</p> </note>', 'ChangeResourceRecordSets' => '<p>Creates, changes, or deletes a resource record set, which contains authoritative DNS information for a specified domain name or subdomain name. For example, you can use <code>ChangeResourceRecordSets</code> to create a resource record set that routes traffic for test.example.com to a web server that has an IP address of 192.0.2.44.</p> <p> <b>Change Batches and Transactional Changes</b> </p> <p>The request body must include a document with a <code>ChangeResourceRecordSetsRequest</code> element. The request body contains a list of change items, known as a change batch. Change batches are considered transactional changes. When using the Amazon Route 53 API to change resource record sets, Amazon Route 53 either makes all or none of the changes in a change batch request. This ensures that Amazon Route 53 never partially implements the intended changes to the resource record sets in a hosted zone. </p> <p>For example, a change batch request that deletes the <code>CNAME</code> record for www.example.com and creates an alias resource record set for www.example.com. Amazon Route 53 deletes the first resource record set and creates the second resource record set in a single operation. If either the <code>DELETE</code> or the <code>CREATE</code> action fails, then both changes (plus any other changes in the batch) fail, and the original <code>CNAME</code> record continues to exist.</p> <important> <p>Due to the nature of transactional changes, you can\'t delete the same resource record set more than once in a single change batch. If you attempt to delete the same change batch more than once, Amazon Route 53 returns an <code>InvalidChangeBatch</code> error.</p> </important> <p> <b>Traffic Flow</b> </p> <p>To create resource record sets for complex routing configurations, use either the traffic flow visual editor in the Amazon Route 53 console or the API actions for traffic policies and traffic policy instances. Save the configuration as a traffic policy, then associate the traffic policy with one or more domain names (such as example.com) or subdomain names (such as www.example.com), in the same hosted zone or in multiple hosted zones. You can roll back the updates if the new configuration isn\'t performing as expected. For more information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-flow.html">Using Traffic Flow to Route DNS Traffic</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p> <b>Create, Delete, and Upsert</b> </p> <p>Use <code>ChangeResourceRecordsSetsRequest</code> to perform the following actions:</p> <ul> <li> <p> <code>CREATE</code>: Creates a resource record set that has the specified values.</p> </li> <li> <p> <code>DELETE</code>: Deletes an existing resource record set that has the specified values.</p> </li> <li> <p> <code>UPSERT</code>: If a resource record set does not already exist, AWS creates it. If a resource set does exist, Amazon Route 53 updates it with the values in the request. </p> </li> </ul> <p> <b>Syntaxes for Creating, Updating, and Deleting Resource Record Sets</b> </p> <p>The syntax for a request depends on the type of resource record set that you want to create, delete, or update, such as weighted, alias, or failover. The XML elements in your request must appear in the order listed in the syntax. </p> <p>For an example for each type of resource record set, see "Examples."</p> <p>Don\'t refer to the syntax in the "Parameter Syntax" section, which includes all of the elements for every kind of resource record set that you can create, delete, or update by using <code>ChangeResourceRecordSets</code>. </p> <p> <b>Change Propagation to Amazon Route 53 DNS Servers</b> </p> <p>When you submit a <code>ChangeResourceRecordSets</code> request, Amazon Route 53 propagates your changes to all of the Amazon Route 53 authoritative DNS servers. While your changes are propagating, <code>GetChange</code> returns a status of <code>PENDING</code>. When propagation is complete, <code>GetChange</code> returns a status of <code>INSYNC</code>. Changes generally propagate to all Amazon Route 53 name servers within 60 seconds. For more information, see <a>GetChange</a>.</p> <p> <b>Limits on ChangeResourceRecordSets Requests</b> </p> <p>For information about the limits on a <code>ChangeResourceRecordSets</code> request, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>', 'ChangeTagsForResource' => '<p>Adds, edits, or deletes tags for a health check or a hosted zone.</p> <p>For information about using tags for cost allocation, see <a href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>', 'CreateHealthCheck' => '<p>Creates a new health check.</p> <p>For information about adding health checks to resource record sets, see <a>ResourceRecordSet$HealthCheckId</a> in <a>ChangeResourceRecordSets</a>. </p> <p> <b>ELB Load Balancers</b> </p> <p>If you\'re registering EC2 instances with an Elastic Load Balancing (ELB) load balancer, do not create Amazon Route 53 health checks for the EC2 instances. When you register an EC2 instance with a load balancer, you configure settings for an ELB health check, which performs a similar function to an Amazon Route 53 health check.</p> <p> <b>Private Hosted Zones</b> </p> <p>You can associate health checks with failover resource record sets in a private hosted zone. Note the following:</p> <ul> <li> <p>Amazon Route 53 health checkers are outside the VPC. To check the health of an endpoint within a VPC by IP address, you must assign a public IP address to the instance in the VPC.</p> </li> <li> <p>You can configure a health checker to check the health of an external resource that the instance relies on, such as a database server.</p> </li> <li> <p>You can create a CloudWatch metric, associate an alarm with the metric, and then create a health check that is based on the state of the alarm. For example, you might create a CloudWatch metric that checks the status of the Amazon EC2 <code>StatusCheckFailed</code> metric, add an alarm to the metric, and then create a health check that is based on the state of the alarm. For information about creating CloudWatch metrics and alarms by using the CloudWatch console, see the <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a>.</p> </li> </ul>', 'CreateHostedZone' => '<p>Creates a new public hosted zone, which you use to specify how the Domain Name System (DNS) routes traffic on the Internet for a domain, such as example.com, and its subdomains. </p> <important> <p>You can\'t convert a public hosted zones to a private hosted zone or vice versa. Instead, you must create a new hosted zone with the same name and create new resource record sets.</p> </important> <p>For more information about charges for hosted zones, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p> <p>Note the following:</p> <ul> <li> <p>You can\'t create a hosted zone for a top-level domain (TLD).</p> </li> <li> <p>Amazon Route 53 automatically creates a default SOA record and four NS records for the zone. For more information about SOA and NS records, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html">NS and SOA Records that Amazon Route 53 Creates for a Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p>If you want to use the same name servers for multiple hosted zones, you can optionally associate a reusable delegation set with the hosted zone. See the <code>DelegationSetId</code> element.</p> </li> <li> <p>If your domain is registered with a registrar other than Amazon Route 53, you must update the name servers with your registrar to make Amazon Route 53 your DNS service. For more information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/creating-migrating.html">Configuring Amazon Route 53 as your DNS Service</a> in the <i>Amazon Route 53 Developer Guide</i>. </p> </li> </ul> <p>When you submit a <code>CreateHostedZone</code> request, the initial status of the hosted zone is <code>PENDING</code>. This means that the NS and SOA records are not yet available on all Amazon Route 53 DNS servers. When the NS and SOA records are available, the status of the zone changes to <code>INSYNC</code>.</p>', 'CreateReusableDelegationSet' => '<p>Creates a delegation set (a group of four name servers) that can be reused by multiple hosted zones. If a hosted zoned ID is specified, <code>CreateReusableDelegationSet</code> marks the delegation set associated with that zone as reusable</p> <note> <p>A reusable delegation set can\'t be associated with a private hosted zone.</p> </note> <p>For information on how to use a reusable delegation set to configure white label name servers, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/white-label-name-servers.html">Configuring White Label Name Servers</a>.</p>', 'CreateTrafficPolicy' => '<p>Creates a traffic policy, which you use to create multiple DNS resource record sets for one domain name (such as example.com) or one subdomain name (such as www.example.com).</p>', 'CreateTrafficPolicyInstance' => '<p>Creates resource record sets in a specified hosted zone based on the settings in a specified traffic policy version. In addition, <code>CreateTrafficPolicyInstance</code> associates the resource record sets with a specified domain name (such as example.com) or subdomain name (such as www.example.com). Amazon Route 53 responds to DNS queries for the domain or subdomain name by using the resource record sets that <code>CreateTrafficPolicyInstance</code> created.</p>', 'CreateTrafficPolicyVersion' => '<p>Creates a new version of an existing traffic policy. When you create a new version of a traffic policy, you specify the ID of the traffic policy that you want to update and a JSON-formatted document that describes the new version. You use traffic policies to create multiple DNS resource record sets for one domain name (such as example.com) or one subdomain name (such as www.example.com). You can create a maximum of 1000 versions of a traffic policy. If you reach the limit and need to create another version, you\'ll need to start a new traffic policy.</p>', 'CreateVPCAssociationAuthorization' => '<p>Authorizes the AWS account that created a specified VPC to submit an <code>AssociateVPCWithHostedZone</code> request to associate the VPC with a specified hosted zone that was created by a different account. To submit a <code>CreateVPCAssociationAuthorization</code> request, you must use the account that created the hosted zone. After you authorize the association, use the account that created the VPC to submit an <code>AssociateVPCWithHostedZone</code> request.</p> <note> <p>If you want to associate multiple VPCs that you created by using one account with a hosted zone that you created by using a different account, you must submit one authorization request for each VPC.</p> </note>', 'DeleteHealthCheck' => '<p>Deletes a health check.</p> <important> <p>Amazon Route 53 does not prevent you from deleting a health check even if the health check is associated with one or more resource record sets. If you delete a health check and you don\'t update the associated resource record sets, the future status of the health check can\'t be predicted and may change. This will affect the routing of DNS queries for your DNS failover configuration. For more information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html#health-checks-deleting.html">Replacing and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> </important>', 'DeleteHostedZone' => '<p>Deletes a hosted zone.</p> <important> <p>If the name servers for the hosted zone are associated with a domain and if you want to make the domain unavailable on the Internet, we recommend that you delete the name servers from the domain to prevent future DNS queries from possibly being misrouted. If the domain is registered with Amazon Route 53, see <code>UpdateDomainNameservers</code>. If the domain is registered with another registrar, use the method provided by the registrar to delete name servers for the domain.</p> <p>Some domain registries don\'t allow you to remove all of the name servers for a domain. If the registry for your domain requires one or more name servers, we recommend that you delete the hosted zone only if you transfer DNS service to another service provider, and you replace the name servers for the domain with name servers from the new provider.</p> </important> <p>You can delete a hosted zone only if it contains only the default SOA record and NS resource record sets. If the hosted zone contains other resource record sets, you must delete them before you can delete the hosted zone. If you try to delete a hosted zone that contains other resource record sets, the request fails, and Amazon Route 53 returns a <code>HostedZoneNotEmpty</code> error. For information about deleting records from your hosted zone, see <a>ChangeResourceRecordSets</a>.</p> <p>To verify that the hosted zone has been deleted, do one of the following:</p> <ul> <li> <p>Use the <code>GetHostedZone</code> action to request information about the hosted zone.</p> </li> <li> <p>Use the <code>ListHostedZones</code> action to get a list of the hosted zones associated with the current AWS account.</p> </li> </ul>', 'DeleteReusableDelegationSet' => '<p>Deletes a reusable delegation set.</p> <important> <p>You can delete a reusable delegation set only if it isn\'t associated with any hosted zones.</p> </important> <p>To verify that the reusable delegation set is not associated with any hosted zones, submit a <a>GetReusableDelegationSet</a> request and specify the ID of the reusable delegation set that you want to delete.</p>', 'DeleteTrafficPolicy' => '<p>Deletes a traffic policy.</p>', 'DeleteTrafficPolicyInstance' => '<p>Deletes a traffic policy instance and all of the resource record sets that Amazon Route 53 created when you created the instance.</p> <note> <p>In the Amazon Route 53 console, traffic policy instances are known as policy records.</p> </note>', 'DeleteVPCAssociationAuthorization' => '<p>Removes authorization to submit an <code>AssociateVPCWithHostedZone</code> request to associate a specified VPC with a hosted zone that was created by a different account. You must use the account that created the hosted zone to submit a <code>DeleteVPCAssociationAuthorization</code> request.</p> <important> <p>Sending this request only prevents the AWS account that created the VPC from associating the VPC with the Amazon Route 53 hosted zone in the future. If the VPC is already associated with the hosted zone, <code>DeleteVPCAssociationAuthorization</code> won\'t disassociate the VPC from the hosted zone. If you want to delete an existing association, use <code>DisassociateVPCFromHostedZone</code>.</p> </important>', 'DisassociateVPCFromHostedZone' => '<p>Disassociates a VPC from a Amazon Route 53 private hosted zone. </p> <note> <p>You can\'t disassociate the last VPC from a private hosted zone.</p> </note> <important> <p>You can\'t disassociate a VPC from a private hosted zone when only one VPC is associated with the hosted zone. You also can\'t convert a private hosted zone into a public hosted zone.</p> </important>', 'GetChange' => '<p>Returns the current status of a change batch request. The status is one of the following values:</p> <ul> <li> <p> <code>PENDING</code> indicates that the changes in this request have not propagated to all Amazon Route 53 DNS servers. This is the initial status of all change batch requests.</p> </li> <li> <p> <code>INSYNC</code> indicates that the changes have propagated to all Amazon Route 53 DNS servers. </p> </li> </ul>', 'GetCheckerIpRanges' => '<p> <code>GetCheckerIpRanges</code> still works, but we recommend that you download ip-ranges.json, which includes IP address ranges for all AWS services. For more information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-ip-addresses.html">IP Address Ranges of Amazon Route 53 Servers</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>', 'GetGeoLocation' => '<p>Gets information about whether a specified geographic location is supported for Amazon Route 53 geolocation resource record sets.</p> <p>Use the following syntax to determine whether a continent is supported for geolocation:</p> <p> <code>GET /2013-04-01/geolocation?ContinentCode=<i>two-letter abbreviation for a continent</i> </code> </p> <p>Use the following syntax to determine whether a country is supported for geolocation:</p> <p> <code>GET /2013-04-01/geolocation?CountryCode=<i>two-character country code</i> </code> </p> <p>Use the following syntax to determine whether a subdivision of a country is supported for geolocation:</p> <p> <code>GET /2013-04-01/geolocation?CountryCode=<i>two-character country code</i>&amp;SubdivisionCode=<i>subdivision code</i> </code> </p>', 'GetHealthCheck' => '<p>Gets information about a specified health check.</p>', 'GetHealthCheckCount' => '<p>Retrieves the number of health checks that are associated with the current AWS account.</p>', 'GetHealthCheckLastFailureReason' => '<p>Gets the reason that a specified health check failed most recently.</p>', 'GetHealthCheckStatus' => '<p>Gets status of a specified health check. </p>', 'GetHostedZone' => '<p>Gets information about a specified hosted zone including the four name servers assigned to the hosted zone.</p>', 'GetHostedZoneCount' => '<p>Retrieves the number of hosted zones that are associated with the current AWS account.</p>', 'GetReusableDelegationSet' => '<p>Retrieves information about a specified reusable delegation set, including the four name servers that are assigned to the delegation set.</p>', 'GetTrafficPolicy' => '<p>Gets information about a specific traffic policy version.</p>', 'GetTrafficPolicyInstance' => '<p>Gets information about a specified traffic policy instance.</p> <note> <p>After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code> request, there\'s a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the <code>State</code> response element.</p> </note> <note> <p>In the Amazon Route 53 console, traffic policy instances are known as policy records.</p> </note>', 'GetTrafficPolicyInstanceCount' => '<p>Gets the number of traffic policy instances that are associated with the current AWS account.</p>', 'ListGeoLocations' => '<p>Retrieves a list of supported geo locations.</p> <p>Countries are listed first, and continents are listed last. If Amazon Route 53 supports subdivisions for a country (for example, states or provinces), the subdivisions for that country are listed in alphabetical order immediately after the corresponding country.</p>', 'ListHealthChecks' => '<p>Retrieve a list of the health checks that are associated with the current AWS account. </p>', 'ListHostedZones' => '<p>Retrieves a list of the public and private hosted zones that are associated with the current AWS account. The response includes a <code>HostedZones</code> child element for each hosted zone.</p> <p>Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use the <code>maxitems</code> parameter to list them in groups of up to 100.</p>', 'ListHostedZonesByName' => '<p>Retrieves a list of your hosted zones in lexicographic order. The response includes a <code>HostedZones</code> child element for each hosted zone created by the current AWS account. </p> <p> <code>ListHostedZonesByName</code> sorts hosted zones by name with the labels reversed. For example:</p> <p> <code>com.example.www.</code> </p> <p>Note the trailing dot, which can change the sort order in some circumstances.</p> <p>If the domain name includes escape characters or Punycode, <code>ListHostedZonesByName</code> alphabetizes the domain name using the escaped or Punycoded value, which is the format that Amazon Route 53 saves in its database. For example, to create a hosted zone for exämple.com, you specify ex\\344mple.com for the domain name. <code>ListHostedZonesByName</code> alphabetizes it as:</p> <p> <code>com.ex\\344mple.</code> </p> <p>The labels are reversed and alphabetized using the escaped value. For more information about valid domain name formats, including internationalized domain names, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p>Amazon Route 53 returns up to 100 items in each response. If you have a lot of hosted zones, use the <code>MaxItems</code> parameter to list them in groups of up to 100. The response includes values that help navigate from one group of <code>MaxItems</code> hosted zones to the next:</p> <ul> <li> <p>The <code>DNSName</code> and <code>HostedZoneId</code> elements in the response contain the values, if any, specified for the <code>dnsname</code> and <code>hostedzoneid</code> parameters in the request that produced the current response.</p> </li> <li> <p>The <code>MaxItems</code> element in the response contains the value, if any, that you specified for the <code>maxitems</code> parameter in the request that produced the current response.</p> </li> <li> <p>If the value of <code>IsTruncated</code> in the response is true, there are more hosted zones associated with the current AWS account. </p> <p>If <code>IsTruncated</code> is false, this response includes the last hosted zone that is associated with the current account. The <code>NextDNSName</code> element and <code>NextHostedZoneId</code> elements are omitted from the response.</p> </li> <li> <p>The <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the response contain the domain name and the hosted zone ID of the next hosted zone that is associated with the current AWS account. If you want to list more hosted zones, make another call to <code>ListHostedZonesByName</code>, and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p> </li> </ul>', 'ListResourceRecordSets' => '<p>Lists the resource record sets in a specified hosted zone.</p> <p> <code>ListResourceRecordSets</code> returns up to 100 resource record sets at a time in ASCII order, beginning at a position specified by the <code>name</code> and <code>type</code> elements. The action sorts results first by DNS name with the labels reversed, for example:</p> <p> <code>com.example.www.</code> </p> <p>Note the trailing dot, which can change the sort order in some circumstances.</p> <p>When multiple records have the same DNS name, the action sorts results by the record type.</p> <p>You can use the name and type elements to adjust the beginning position of the list of resource record sets returned:</p> <dl> <dt>If you do not specify Name or Type</dt> <dd> <p>The results begin with the first resource record set that the hosted zone contains.</p> </dd> <dt>If you specify Name but not Type</dt> <dd> <p>The results begin with the first resource record set in the list whose name is greater than or equal to <code>Name</code>.</p> </dd> <dt>If you specify Type but not Name</dt> <dd> <p>Amazon Route 53 returns the <code>InvalidInput</code> error.</p> </dd> <dt>If you specify both Name and Type</dt> <dd> <p>The results begin with the first resource record set in the list whose name is greater than or equal to <code>Name</code>, and whose type is greater than or equal to <code>Type</code>.</p> </dd> </dl> <p>This action returns the most current version of the records. This includes records that are <code>PENDING</code>, and that are not yet available on all Amazon Route 53 DNS servers.</p> <p>To ensure that you get an accurate listing of the resource record sets for a hosted zone at a point in time, do not submit a <code>ChangeResourceRecordSets</code> request while you\'re paging through the results of a <code>ListResourceRecordSets</code> request. If you do, some pages may display results without the latest changes while other pages display results with the latest changes.</p>', 'ListReusableDelegationSets' => '<p>Retrieves a list of the reusable delegation sets that are associated with the current AWS account.</p>', 'ListTagsForResource' => '<p>Lists tags for one health check or hosted zone. </p> <p>For information about using tags for cost allocation, see <a href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>', 'ListTagsForResources' => '<p>Lists tags for up to 10 health checks or hosted zones.</p> <p>For information about using tags for cost allocation, see <a href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>', 'ListTrafficPolicies' => '<p>Gets information about the latest version for every traffic policy that is associated with the current AWS account. Policies are listed in the order in which they were created. </p>', 'ListTrafficPolicyInstances' => '<p>Gets information about the traffic policy instances that you created by using the current AWS account.</p> <note> <p>After you submit an <code>UpdateTrafficPolicyInstance</code> request, there\'s a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the <code>State</code> response element.</p> </note> <p>Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can use the <code>MaxItems</code> parameter to list them in groups of up to 100.</p>', 'ListTrafficPolicyInstancesByHostedZone' => '<p>Gets information about the traffic policy instances that you created in a specified hosted zone.</p> <note> <p>After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code> request, there\'s a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the <code>State</code> response element.</p> </note> <p>Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can use the <code>MaxItems</code> parameter to list them in groups of up to 100.</p>', 'ListTrafficPolicyInstancesByPolicy' => '<p>Gets information about the traffic policy instances that you created by using a specify traffic policy version.</p> <note> <p>After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code> request, there\'s a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the <code>State</code> response element.</p> </note> <p>Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can use the <code>MaxItems</code> parameter to list them in groups of up to 100.</p>', 'ListTrafficPolicyVersions' => '<p>Gets information about all of the versions for a specified traffic policy.</p> <p>Traffic policy versions are listed in numerical order by <code>VersionNumber</code>.</p>', 'ListVPCAssociationAuthorizations' => '<p>Gets a list of the VPCs that were created by other accounts and that can be associated with a specified hosted zone because you\'ve submitted one or more <code>CreateVPCAssociationAuthorization</code> requests. </p> <p>The response includes a <code>VPCs</code> element with a <code>VPC</code> child element for each VPC that can be associated with the hosted zone.</p>', 'TestDNSAnswer' => '<p>Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type. You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask. </p>', 'UpdateHealthCheck' => '<p>Updates an existing health check. Note that some values can\'t be updated. </p> <p>For more information about updating health checks, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html">Creating, Updating, and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>', 'UpdateHostedZoneComment' => '<p>Updates the comment for a specified hosted zone.</p>', 'UpdateTrafficPolicyComment' => '<p>Updates the comment for a specified traffic policy version.</p>', 'UpdateTrafficPolicyInstance' => '<p>Updates the resource record sets in a specified hosted zone that were created based on the settings in a specified traffic policy version.</p> <p>When you update a traffic policy instance, Amazon Route 53 continues to respond to DNS queries for the root resource record set name (such as example.com) while it replaces one group of resource record sets with another. Amazon Route 53 performs the following operations:</p> <ol> <li> <p>Amazon Route 53 creates a new group of resource record sets based on the specified traffic policy. This is true regardless of how significant the differences are between the existing resource record sets and the new resource record sets. </p> </li> <li> <p>When all of the new resource record sets have been created, Amazon Route 53 starts to respond to DNS queries for the root resource record set name (such as example.com) by using the new resource record sets.</p> </li> <li> <p>Amazon Route 53 deletes the old group of resource record sets that are associated with the root resource record set name.</p> </li> </ol>', ], 'shapes' => [ 'AlarmIdentifier' => [ 'base' => '<p>A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether this health check is healthy.</p>', 'refs' => [ 'HealthCheckConfig$AlarmIdentifier' => '<p>A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether this health check is healthy.</p>', 'UpdateHealthCheckRequest$AlarmIdentifier' => NULL, ], ], 'AlarmName' => [ 'base' => NULL, 'refs' => [ 'AlarmIdentifier$Name' => '<p>The name of the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether this health check is healthy.</p>', ], ], 'AliasHealthEnabled' => [ 'base' => NULL, 'refs' => [ 'AliasTarget$EvaluateTargetHealth' => '<p> <i>Applies only to alias, failover alias, geolocation alias, latency alias, and weighted alias resource record sets:</i> When <code>EvaluateTargetHealth</code> is <code>true</code>, an alias resource record set inherits the health of the referenced AWS resource, such as an ELB load balancer, or the referenced resource record set.</p> <p>Note the following:</p> <ul> <li> <p>You can\'t set <code>EvaluateTargetHealth</code> to <code>true</code> when the alias target is a CloudFront distribution.</p> </li> <li> <p>If the AWS resource that you specify in <code>AliasTarget</code> is a resource record set or a group of resource record sets (for example, a group of weighted resource record sets), but it is not another alias resource record set, we recommend that you associate a health check with all of the resource record sets in the alias target. For more information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-complex-configs.html#dns-failover-complex-configs-hc-omitting">What Happens When You Omit Health Checks?</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> </li> <li> <p>If you specify an Elastic Beanstalk environment in <code>HostedZoneId</code> and <code>DNSName</code>, and if the environment contains an ELB load balancer, Elastic Load Balancing routes queries only to the healthy Amazon EC2 instances that are registered with the load balancer. (An environment automatically contains an ELB load balancer if it includes more than one EC2 instance.) If you set <code>EvaluateTargetHealth</code> to <code>true</code> and either no EC2 instances are healthy or the load balancer itself is unhealthy, Amazon Route 53 routes queries to other available resources that are healthy, if any.</p> <p>If the environment contains a single EC2 instance, there are no special requirements.</p> </li> <li> <p>If you specify an ELB load balancer in <code> <a>AliasTarget</a> </code>, ELB routes queries only to the healthy EC2 instances that are registered with the load balancer. If no EC2 instances are healthy or if the load balancer itself is unhealthy, and if <code>EvaluateTargetHealth</code> is true for the corresponding alias resource record set, Amazon Route 53 routes queries to other resources. When you create a load balancer, you configure settings for ELB health checks; they\'re not Amazon Route 53 health checks, but they perform a similar function. Do not create Amazon Route 53 health checks for the EC2 instances that you register with an ELB load balancer.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-complex-configs.html">How Health Checks Work in More Complex Amazon Route 53 Configurations</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> </li> <li> <p>We recommend that you set <code>EvaluateTargetHealth</code> to true only when you have enough idle capacity to handle the failure of one or more endpoints.</p> </li> </ul> <p>For more information and examples, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Amazon Route 53 Health Checks and DNS Failover</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>', ], ], 'AliasTarget' => [ 'base' => '<p> <i>Alias resource record sets only:</i> Information about the CloudFront distribution, Elastic Beanstalk environment, ELB load balancer, Amazon S3 bucket, or Amazon Route 53 resource record set that you\'re redirecting queries to. An Elastic Beanstalk environment must have a regionalized subdomain.</p> <p>When creating resource record sets for a private hosted zone, note the following:</p> <ul> <li> <p>Resource record sets can\'t be created for CloudFront distributions in a private hosted zone.</p> </li> <li> <p>Creating geolocation alias resource record sets or latency alias resource record sets in a private hosted zone is unsupported.</p> </li> <li> <p>For information about creating failover resource record sets in a private hosted zone, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a>.</p> </li> </ul>', 'refs' => [ 'ResourceRecordSet$AliasTarget' => '<p> <i>Alias resource record sets only:</i> Information about the CloudFront distribution, AWS Elastic Beanstalk environment, ELB load balancer, Amazon S3 bucket, or Amazon Route 53 resource record set to which you\'re redirecting queries. The AWS Elastic Beanstalk environment must have a regionalized subdomain.</p> <p>If you\'re creating resource records sets for a private hosted zone, note the following:</p> <ul> <li> <p>You can\'t create alias resource record sets for CloudFront distributions in a private hosted zone.</p> </li> <li> <p>Creating geolocation alias resource record sets or latency alias resource record sets in a private hosted zone is unsupported.</p> </li> <li> <p>For information about creating failover resource record sets in a private hosted zone, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> </li> </ul>', ], ], 'AssociateVPCComment' => [ 'base' => NULL, 'refs' => [ 'AssociateVPCWithHostedZoneRequest$Comment' => '<p> <i>Optional:</i> A comment about the association request.</p>', ], ], 'AssociateVPCWithHostedZoneRequest' => [ 'base' => '<p>A complex type that contains information about the request to associate a VPC with a private hosted zone.</p>', 'refs' => [], ], 'AssociateVPCWithHostedZoneResponse' => [ 'base' => '<p>A complex type that contains the response information for the <code>AssociateVPCWithHostedZone</code> request.</p>', 'refs' => [], ], 'Change' => [ 'base' => '<p>The information for each resource record set that you want to change.</p>', 'refs' => [ 'Changes$member' => NULL, ], ], 'ChangeAction' => [ 'base' => NULL, 'refs' => [ 'Change$Action' => '<p>The action to perform:</p> <ul> <li> <p> <code>CREATE</code>: Creates a resource record set that has the specified values.</p> </li> <li> <p> <code>DELETE</code>: Deletes a existing resource record set.</p> <important> <p>To delete the resource record set that is associated with a traffic policy instance, use <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Amazon Route 53 doesn\'t automatically delete the traffic policy instance, and you\'ll continue to be charged for it even though it\'s no longer in use. </p> </important> </li> <li> <p> <code>UPSERT</code>: If a resource record set doesn\'t already exist, Amazon Route 53 creates it. If a resource record set does exist, Amazon Route 53 updates it with the values in the request.</p> </li> </ul> <p>The values that you need to include in the request depend on the type of resource record set that you\'re creating, deleting, or updating:</p> <p> <b>Basic resource record sets (excluding alias, failover, geolocation, latency, and weighted resource record sets)</b> </p> <ul> <li> <p> <code>Name</code> </p> </li> <li> <p> <code>Type</code> </p> </li> <li> <p> <code>TTL</code> </p> </li> </ul> <p> <b>Failover, geolocation, latency, or weighted resource record sets (excluding alias resource record sets)</b> </p> <ul> <li> <p> <code>Name</code> </p> </li> <li> <p> <code>Type</code> </p> </li> <li> <p> <code>TTL</code> </p> </li> <li> <p> <code>SetIdentifier</code> </p> </li> </ul> <p> <b>Alias resource record sets (including failover alias, geolocation alias, latency alias, and weighted alias resource record sets)</b> </p> <ul> <li> <p> <code>Name</code> </p> </li> <li> <p> <code>Type</code> </p> </li> <li> <p> <code>AliasTarget</code> (includes <code>DNSName</code>, <code>EvaluateTargetHealth</code>, and <code>HostedZoneId</code>)</p> </li> <li> <p> <code>SetIdentifier</code> (for failover, geolocation, latency, and weighted resource record sets)</p> </li> </ul>', ], ], 'ChangeBatch' => [ 'base' => '<p>The information for a change request.</p>', 'refs' => [ 'ChangeResourceRecordSetsRequest$ChangeBatch' => '<p>A complex type that contains an optional comment and the <code>Changes</code> element.</p>', ], ], 'ChangeInfo' => [ 'base' => '<p>A complex type that describes change information about changes made to your hosted zone.</p>', 'refs' => [ 'AssociateVPCWithHostedZoneResponse$ChangeInfo' => '<p>A complex type that describes the changes made to your hosted zone.</p>', 'ChangeResourceRecordSetsResponse$ChangeInfo' => '<p>A complex type that contains information about changes made to your hosted zone.</p> <p>This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed information about the change.</p>', 'CreateHostedZoneResponse$ChangeInfo' => '<p>A complex type that contains information about the <code>CreateHostedZone</code> request.</p>', 'DeleteHostedZoneResponse$ChangeInfo' => '<p>A complex type that contains the ID, the status, and the date and time of a request to delete a hosted zone.</p>', 'DisassociateVPCFromHostedZoneResponse$ChangeInfo' => '<p>A complex type that describes the changes made to the specified private hosted zone.</p>', 'GetChangeResponse$ChangeInfo' => '<p>A complex type that contains information about the specified change batch.</p>', ], ], 'ChangeResourceRecordSetsRequest' => [ 'base' => '<p>A complex type that contains change information for the resource record set.</p>', 'refs' => [], ], 'ChangeResourceRecordSetsResponse' => [ 'base' => '<p>A complex type containing the response for the request.</p>', 'refs' => [], ], 'ChangeStatus' => [ 'base' => NULL, 'refs' => [ 'ChangeInfo$Status' => '<p>The current state of the request. <code>PENDING</code> indicates that this request has not yet been applied to all Amazon Route 53 DNS servers.</p>', ], ], 'ChangeTagsForResourceRequest' => [ 'base' => '<p>A complex type that contains information about the tags that you want to add, edit, or delete.</p>', 'refs' => [], ], 'ChangeTagsForResourceResponse' => [ 'base' => '<p>Empty response for the request.</p>', 'refs' => [], ], 'Changes' => [ 'base' => NULL, 'refs' => [ 'ChangeBatch$Changes' => '<p>Information about the changes to make to the record sets.</p>', ], ], 'CheckerIpRanges' => [ 'base' => NULL, 'refs' => [ 'GetCheckerIpRangesResponse$CheckerIpRanges' => NULL, ], ], 'ChildHealthCheckList' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$ChildHealthChecks' => '<p>(CALCULATED Health Checks Only) A complex type that contains one <code>ChildHealthCheck</code> element for each health check that you want to associate with a <code>CALCULATED</code> health check.</p>', 'UpdateHealthCheckRequest$ChildHealthChecks' => '<p>A complex type that contains one <code>ChildHealthCheck</code> element for each health check that you want to associate with a <code>CALCULATED</code> health check.</p>', ], ], 'CloudWatchAlarmConfiguration' => [ 'base' => '<p>A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for this health check.</p>', 'refs' => [ 'HealthCheck$CloudWatchAlarmConfiguration' => '<p>A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for this health check.</p>', ], ], 'CloudWatchRegion' => [ 'base' => NULL, 'refs' => [ 'AlarmIdentifier$Region' => '<p>A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether this health check is healthy.</p> <p>For the current list of CloudWatch regions, see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#cw_region">Amazon CloudWatch</a> in the <i>AWS Regions and Endpoints</i> chapter of the <i>Amazon Web Services General Reference</i>.</p>', ], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmConfiguration$ComparisonOperator' => '<p>For the metric that the CloudWatch alarm is associated with, the arithmetic operation that is used for the comparison.</p>', ], ], 'ConcurrentModification' => [ 'base' => '<p>Another user submitted a request to update the object at the same time that you did. Retry the request. </p>', 'refs' => [], ], 'ConflictingDomainExists' => [ 'base' => '<p>The cause of this error depends on whether you\'re trying to create a public or a private hosted zone:</p> <ul> <li> <p> <b>Public hosted zone:</b> Two hosted zones that have the same name or that have a parent/child relationship (example.com and test.example.com) can\'t have any common name servers. You tried to create a hosted zone that has the same name as an existing hosted zone or that\'s the parent or child of an existing hosted zone, and you specified a delegation set that shares one or more name servers with the existing hosted zone. </p> </li> <li> <p> <b>Private hosted zone:</b> You specified an Amazon VPC that you\'re already using for another hosted zone, and the domain that you specified for one of the hosted zones is a subdomain of the domain that you specified for the other hosted zone. For example, you can\'t use the same Amazon VPC for the hosted zones for example.com and test.example.com.</p> </li> </ul>', 'refs' => [], ], 'ConflictingTypes' => [ 'base' => '<p>You tried to update a traffic policy instance by using a traffic policy version that has a different DNS type than the current type for the instance. You specified the type in the JSON document in the <code>CreateTrafficPolicy</code> or <code>CreateTrafficPolicyVersion</code>request. </p>', 'refs' => [], ], 'CreateHealthCheckRequest' => [ 'base' => '<p>A complex type that contains the health check request information.</p>', 'refs' => [], ], 'CreateHealthCheckResponse' => [ 'base' => '<p>A complex type containing the response information for the new health check.</p>', 'refs' => [], ], 'CreateHostedZoneRequest' => [ 'base' => '<p>A complex type that contains information about the request to create a hosted zone.</p>', 'refs' => [], ], 'CreateHostedZoneResponse' => [ 'base' => '<p>A complex type containing the response information for the hosted zone.</p>', 'refs' => [], ], 'CreateReusableDelegationSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateReusableDelegationSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficPolicyInstanceRequest' => [ 'base' => '<p>A complex type that contains information about the resource record sets that you want to create based on a specified traffic policy.</p>', 'refs' => [], ], 'CreateTrafficPolicyInstanceResponse' => [ 'base' => '<p>A complex type that contains the response information for the <code>CreateTrafficPolicyInstance</code> request.</p>', 'refs' => [], ], 'CreateTrafficPolicyRequest' => [ 'base' => '<p>A complex type that contains information about the traffic policy that you want to create.</p>', 'refs' => [], ], 'CreateTrafficPolicyResponse' => [ 'base' => '<p>A complex type that contains the response information for the <code>CreateTrafficPolicy</code> request.</p>', 'refs' => [], ], 'CreateTrafficPolicyVersionRequest' => [ 'base' => '<p>A complex type that contains information about the traffic policy that you want to create a new version for.</p>', 'refs' => [], ], 'CreateTrafficPolicyVersionResponse' => [ 'base' => '<p>A complex type that contains the response information for the <code>CreateTrafficPolicyVersion</code> request.</p>', 'refs' => [], ], 'CreateVPCAssociationAuthorizationRequest' => [ 'base' => '<p>A complex type that contains information about the request to authorize associating a VPC with your private hosted zone. Authorization is only required when a private hosted zone and a VPC were created by using different accounts.</p>', 'refs' => [], ], 'CreateVPCAssociationAuthorizationResponse' => [ 'base' => '<p>A complex type that contains the response information from a <code>CreateVPCAssociationAuthorization</code> request.</p>', 'refs' => [], ], 'DNSName' => [ 'base' => NULL, 'refs' => [ 'AliasTarget$DNSName' => '<p> <i>Alias resource record sets only:</i> The value that you specify depends on where you want to route queries:</p> <dl> <dt>CloudFront distribution</dt> <dd> <p>Specify the domain name that CloudFront assigned when you created your distribution.</p> <p>Your CloudFront distribution must include an alternate domain name that matches the name of the resource record set. For example, if the name of the resource record set is <i>acme.example.com</i>, your CloudFront distribution must include <i>acme.example.com</i> as one of the alternate domain names. For more information, see <a href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html">Using Alternate Domain Names (CNAMEs)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> </dd> <dt>Elastic Beanstalk environment</dt> <dd> <p>Specify the <code>CNAME</code> attribute for the environment. (The environment must have a regionalized domain name.) You can use the following methods to get the value of the CNAME attribute:</p> <ul> <li> <p> <i>AWS Management Console</i>: For information about how to get the value by using the console, see <a href="http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/customdomains.html">Using Custom Domains with AWS Elastic Beanstalk</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> </li> <li> <p> <i>Elastic Beanstalk API</i>: Use the <code>DescribeEnvironments</code> action to get the value of the <code>CNAME</code> attribute. For more information, see <a href="http://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironments.html">DescribeEnvironments</a> in the <i>AWS Elastic Beanstalk API Reference</i>.</p> </li> <li> <p> <i>AWS CLI</i>: Use the <code>describe-environments</code> command to get the value of the <code>CNAME</code> attribute. For more information, see <a href="http://docs.aws.amazon.com/cli/latest/reference/elasticbeanstalk/describe-environments.html">describe-environments</a> in the <i>AWS Command Line Interface Reference</i>.</p> </li> </ul> </dd> <dt>ELB load balancer</dt> <dd> <p>Specify the DNS name that is associated with the load balancer. Get the DNS name by using the AWS Management Console, the ELB API, or the AWS CLI. </p> <ul> <li> <p> <b>AWS Management Console</b>: Go to the EC2 page, choose <b>Load Balancers</b> in the navigation pane, choose the load balancer, choose the <b>Description</b> tab, and get the value of the <b>DNS name</b> field. (If you\'re routing traffic to a Classic Load Balancer, get the value that begins with <b>dualstack</b>.) </p> </li> <li> <p> <b>Elastic Load Balancing API</b>: Use <code>DescribeLoadBalancers</code> to get the value of <code>DNSName</code>. For more information, see the applicable guide:</p> <ul> <li> <p>Classic Load Balancer: <a href="http://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> </p> </li> <li> <p>Application Load Balancer: <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> </p> </li> </ul> </li> <li> <p> <b>AWS CLI</b>: Use <code> <a href="http://docs.aws.amazon.com/cli/latest/reference/elb/describe-load-balancers.html">describe-load-balancers</a> </code> to get the value of <code>DNSName</code>.</p> </li> </ul> </dd> <dt>Amazon S3 bucket that is configured as a static website</dt> <dd> <p>Specify the domain name of the Amazon S3 website endpoint in which you created the bucket, for example, <code>s3-website-us-east-2.amazonaws.com</code>. For more information about valid values, see the table <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Amazon Simple Storage Service (S3) Website Endpoints</a> in the <i>Amazon Web Services General Reference</i>. For more information about using S3 buckets for websites, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/getting-started.html">Getting Started with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide.</i> </p> </dd> <dt>Another Amazon Route 53 resource record set</dt> <dd> <p>Specify the value of the <code>Name</code> element for a resource record set in the current hosted zone.</p> </dd> </dl>', 'CreateHostedZoneRequest$Name' => '<p>The name of the domain. For resource record types that include a domain name, specify a fully qualified domain name, for example, <i>www.example.com</i>. The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Amazon Route 53 treats <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a trailing dot) as identical.</p> <p>If you\'re creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name is registered with a registrar other than Amazon Route 53, change the name servers for your domain to the set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in <code>DelegationSet</code>.</p>', 'CreateTrafficPolicyInstanceRequest$Name' => '<p>The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53 responds to DNS queries by using the resource record sets that Amazon Route 53 creates for this traffic policy instance.</p>', 'DelegationSetNameServers$member' => NULL, 'HostedZone$Name' => '<p>The name of the domain. For public hosted zones, this is the name that you have registered with your DNS registrar.</p> <p>For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and <code>-</code> (hyphen) and how to specify internationalized domain names, see <a>CreateHostedZone</a>.</p>', 'ListHostedZonesByNameRequest$DNSName' => '<p>(Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code> parameter only if you want to specify the name of the first hosted zone in the response. If you don\'t include the <code>dnsname</code> parameter, Amazon Route 53 returns all of the hosted zones that were created by the current AWS account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code> from the previous response.</p>', 'ListHostedZonesByNameResponse$DNSName' => '<p>For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the value that you specified for the <code>dnsname</code> parameter in the request that produced the current response.</p>', 'ListHostedZonesByNameResponse$NextDNSName' => '<p>If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p> <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>', 'ListResourceRecordSetsRequest$StartRecordName' => '<p>The first name in the lexicographic ordering of resource record sets that you want to list.</p>', 'ListResourceRecordSetsResponse$NextRecordName' => '<p>If the results were truncated, the name of the next record in the list.</p> <p>This element is present only if <code>IsTruncated</code> is true. </p>', 'ListTrafficPolicyInstancesByHostedZoneRequest$TrafficPolicyInstanceNameMarker' => '<p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.</p> <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>', 'ListTrafficPolicyInstancesByHostedZoneResponse$TrafficPolicyInstanceNameMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance in the next group of traffic policy instances.</p>', 'ListTrafficPolicyInstancesByPolicyRequest$TrafficPolicyInstanceNameMarker' => '<p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p> <p>For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p> <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>', 'ListTrafficPolicyInstancesByPolicyResponse$TrafficPolicyInstanceNameMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>', 'ListTrafficPolicyInstancesRequest$TrafficPolicyInstanceNameMarker' => '<p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.</p> <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>', 'ListTrafficPolicyInstancesResponse$TrafficPolicyInstanceNameMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>', 'ResourceRecordSet$Name' => '<p>The name of the domain you want to perform the action on.</p> <p>Enter a fully qualified domain name, for example, <code>www.example.com</code>. You can optionally include a trailing dot. If you omit the trailing dot, Amazon Route 53 still assumes that the domain name that you specify is fully qualified. This means that Amazon Route 53 treats <code>www.example.com</code> (without a trailing dot) and <code>www.example.com.</code> (with a trailing dot) as identical.</p> <p>For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and <code>-</code> (hyphen) and how to specify internationalized domain names, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p>You can use the asterisk (*) wildcard to replace the leftmost label in a domain name, for example, <code>*.example.com</code>. Note the following:</p> <ul> <li> <p>The * must replace the entire label. For example, you can\'t specify <code>*prod.example.com</code> or <code>prod*.example.com</code>.</p> </li> <li> <p>The * can\'t replace any of the middle labels, for example, marketing.*.example.com.</p> </li> <li> <p>If you include * in any position other than the leftmost label in a domain name, DNS treats it as an * character (ASCII 42), not as a wildcard.</p> <important> <p>You can\'t use the * wildcard for resource records sets that have a type of NS.</p> </important> </li> </ul> <p>You can use the * wildcard as the leftmost label in a domain name, for example, <code>*.example.com</code>. You can\'t use an * for one of the middle labels, for example, <code>marketing.*.example.com</code>. In addition, the * must replace the entire label; for example, you can\'t specify <code>prod*.example.com</code>.</p>', 'TestDNSAnswerRequest$RecordName' => '<p>The name of the resource record set that you want Amazon Route 53 to simulate a query for.</p>', 'TestDNSAnswerResponse$RecordName' => '<p>The name of the resource record set that you submitted a request for.</p>', 'TrafficPolicyInstance$Name' => '<p>The DNS name, such as www.example.com, for which Amazon Route 53 responds to queries by using the resource record sets that are associated with this traffic policy instance. </p>', ], ], 'DNSRCode' => [ 'base' => NULL, 'refs' => [ 'TestDNSAnswerResponse$ResponseCode' => '<p>A code that indicates whether the request is valid or not. The most common response code is <code>NOERROR</code>, meaning that the request is valid. If the response is not valid, Amazon Route 53 returns a response code that describes the error. For a list of possible response codes, see <a href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS RCODES</a> on the IANA website. </p>', ], ], 'DelegationSet' => [ 'base' => '<p>A complex type that lists the name servers in a delegation set, as well as the <code>CallerReference</code> and the <code>ID</code> for the delegation set.</p>', 'refs' => [ 'CreateHostedZoneResponse$DelegationSet' => '<p>A complex type that describes the name servers for this hosted zone.</p>', 'CreateReusableDelegationSetResponse$DelegationSet' => '<p>A complex type that contains name server information.</p>', 'DelegationSets$member' => NULL, 'GetHostedZoneResponse$DelegationSet' => '<p>A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.</p>', 'GetReusableDelegationSetResponse$DelegationSet' => '<p>A complex type that contains information about the reusable delegation set.</p>', ], ], 'DelegationSetAlreadyCreated' => [ 'base' => '<p>A delegation set with the same owner and caller reference combination has already been created.</p>', 'refs' => [], ], 'DelegationSetAlreadyReusable' => [ 'base' => '<p>The specified delegation set has already been marked as reusable.</p>', 'refs' => [], ], 'DelegationSetInUse' => [ 'base' => '<p>The specified delegation contains associated hosted zones which must be deleted before the reusable delegation set can be deleted.</p>', 'refs' => [], ], 'DelegationSetNameServers' => [ 'base' => NULL, 'refs' => [ 'DelegationSet$NameServers' => '<p>A complex type that contains a list of the authoritative name servers for a hosted zone or for a reusable delegation set.</p>', ], ], 'DelegationSetNotAvailable' => [ 'base' => '<p>You can create a hosted zone that has the same name as an existing hosted zone (example.com is common), but there is a limit to the number of hosted zones that have the same name. If you get this error, Amazon Route 53 has reached that limit. If you own the domain name and Amazon Route 53 generates this error, contact Customer Support.</p>', 'refs' => [], ], 'DelegationSetNotReusable' => [ 'base' => '<p>A reusable delegation set with the specified ID does not exist.</p>', 'refs' => [], ], 'DelegationSets' => [ 'base' => NULL, 'refs' => [ 'ListReusableDelegationSetsResponse$DelegationSets' => '<p>A complex type that contains one <code>DelegationSet</code> element for each reusable delegation set that was created by the current AWS account.</p>', ], ], 'DeleteHealthCheckRequest' => [ 'base' => '<p>This action deletes a health check.</p>', 'refs' => [], ], 'DeleteHealthCheckResponse' => [ 'base' => '<p>An empty element.</p>', 'refs' => [], ], 'DeleteHostedZoneRequest' => [ 'base' => '<p>A request to delete a hosted zone.</p>', 'refs' => [], ], 'DeleteHostedZoneResponse' => [ 'base' => '<p>A complex type that contains the response to a <code>DeleteHostedZone</code> request.</p>', 'refs' => [], ], 'DeleteReusableDelegationSetRequest' => [ 'base' => '<p>A request to delete a reusable delegation set.</p>', 'refs' => [], ], 'DeleteReusableDelegationSetResponse' => [ 'base' => '<p>An empty element.</p>', 'refs' => [], ], 'DeleteTrafficPolicyInstanceRequest' => [ 'base' => '<p>A request to delete a specified traffic policy instance.</p>', 'refs' => [], ], 'DeleteTrafficPolicyInstanceResponse' => [ 'base' => '<p>An empty element.</p>', 'refs' => [], ], 'DeleteTrafficPolicyRequest' => [ 'base' => '<p>A request to delete a specified traffic policy version.</p>', 'refs' => [], ], 'DeleteTrafficPolicyResponse' => [ 'base' => '<p>An empty element.</p>', 'refs' => [], ], 'DeleteVPCAssociationAuthorizationRequest' => [ 'base' => '<p>A complex type that contains information about the request to remove authorization to associate a VPC that was created by one AWS account with a hosted zone that was created with a different AWS account. </p>', 'refs' => [], ], 'DeleteVPCAssociationAuthorizationResponse' => [ 'base' => '<p>Empty response for the request.</p>', 'refs' => [], ], 'Dimension' => [ 'base' => '<p>For the metric that the CloudWatch alarm is associated with, a complex type that contains information about one dimension.</p>', 'refs' => [ 'DimensionList$member' => NULL, ], ], 'DimensionField' => [ 'base' => NULL, 'refs' => [ 'Dimension$Name' => '<p>For the metric that the CloudWatch alarm is associated with, the name of one dimension.</p>', 'Dimension$Value' => '<p>For the metric that the CloudWatch alarm is associated with, the value of one dimension.</p>', ], ], 'DimensionList' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmConfiguration$Dimensions' => '<p>For the metric that the CloudWatch alarm is associated with, a complex type that contains information about the dimensions for the metric. For information, see <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html">Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference</a> in the <i>Amazon CloudWatch User Guide</i>.</p>', ], ], 'DisassociateVPCComment' => [ 'base' => NULL, 'refs' => [ 'DisassociateVPCFromHostedZoneRequest$Comment' => '<p> <i>Optional:</i> A comment about the disassociation request.</p>', ], ], 'DisassociateVPCFromHostedZoneRequest' => [ 'base' => '<p>A complex type that contains information about the VPC that you want to disassociate from a specified private hosted zone.</p>', 'refs' => [], ], 'DisassociateVPCFromHostedZoneResponse' => [ 'base' => '<p>A complex type that contains the response information for the disassociate request.</p>', 'refs' => [], ], 'EnableSNI' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$EnableSNI' => '<p>Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code> message during TLS negotiation. This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.</p> <p>Some endpoints require that <code>HTTPS</code> requests include the host name in the <code>client_hello</code> message. If you don\'t enable SNI, the status of the health check will be <code>SSL alert handshake_failure</code>. A health check can also have that status for other reasons. If SNI is enabled and you\'re still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.</p> <p>The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for <code>FullyQualifiedDomainName</code>. If the endpoint responds to the <code>client_hello</code> message with a certificate that does not include the domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the handshake. In the second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.</p>', 'UpdateHealthCheckRequest$EnableSNI' => '<p>Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code> message during <code>TLS</code> negotiation. This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.</p> <p>Some endpoints require that HTTPS requests include the host name in the <code>client_hello</code> message. If you don\'t enable SNI, the status of the health check will be SSL alert <code>handshake_failure</code>. A health check can also have that status for other reasons. If SNI is enabled and you\'re still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.</p> <p>The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for <code>FullyQualifiedDomainName</code>. If the endpoint responds to the <code>client_hello</code> message with a certificate that does not include the domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the handshake. In the second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ConcurrentModification$message' => '<p>Descriptive message for the error response.</p>', 'ConflictingDomainExists$message' => NULL, 'ConflictingTypes$message' => '<p>Descriptive message for the error response.</p>', 'DelegationSetAlreadyCreated$message' => '<p>Descriptive message for the error response.</p>', 'DelegationSetAlreadyReusable$message' => '<p>Descriptive message for the error response.</p>', 'DelegationSetInUse$message' => '<p>Descriptive message for the error response.</p>', 'DelegationSetNotAvailable$message' => '<p>Descriptive message for the error response.</p>', 'DelegationSetNotReusable$message' => '<p>Descriptive message for the error response.</p>', 'ErrorMessages$member' => NULL, 'HealthCheckAlreadyExists$message' => '<p>Descriptive message for the error response.</p>', 'HealthCheckInUse$message' => '<p>Descriptive message for the error response.</p>', 'HealthCheckVersionMismatch$message' => NULL, 'HostedZoneAlreadyExists$message' => '<p>Descriptive message for the error response.</p>', 'HostedZoneNotEmpty$message' => '<p>Descriptive message for the error response.</p>', 'HostedZoneNotFound$message' => '<p>Descriptive message for the error response.</p>', 'IncompatibleVersion$message' => NULL, 'InvalidArgument$message' => '<p>Descriptive message for the error response.</p>', 'InvalidChangeBatch$message' => NULL, 'InvalidDomainName$message' => '<p>Descriptive message for the error response.</p>', 'InvalidInput$message' => '<p>Descriptive message for the error response.</p>', 'InvalidPaginationToken$message' => NULL, 'InvalidTrafficPolicyDocument$message' => '<p>Descriptive message for the error response.</p>', 'InvalidVPCId$message' => '<p>Descriptive message for the error response.</p>', 'LastVPCAssociation$message' => '<p>Descriptive message for the error response.</p>', 'LimitsExceeded$message' => '<p>Descriptive message for the error response.</p>', 'NoSuchChange$message' => NULL, 'NoSuchDelegationSet$message' => '<p>Descriptive message for the error response.</p>', 'NoSuchGeoLocation$message' => '<p>Descriptive message for the error response.</p>', 'NoSuchHealthCheck$message' => '<p>Descriptive message for the error response.</p>', 'NoSuchHostedZone$message' => '<p>Descriptive message for the error response.</p>', 'NoSuchTrafficPolicy$message' => '<p>Descriptive message for the error response.</p>', 'NoSuchTrafficPolicyInstance$message' => '<p>Descriptive message for the error response.</p>', 'NotAuthorizedException$message' => '<p>Descriptive message for the error response.</p>', 'PriorRequestNotComplete$message' => NULL, 'PublicZoneVPCAssociation$message' => '<p>Descriptive message for the error response.</p>', 'ThrottlingException$message' => NULL, 'TooManyHealthChecks$message' => NULL, 'TooManyHostedZones$message' => '<p>Descriptive message for the error response.</p>', 'TooManyTrafficPolicies$message' => '<p>Descriptive message for the error response.</p>', 'TooManyTrafficPolicyInstances$message' => '<p>Descriptive message for the error response.</p>', 'TooManyVPCAssociationAuthorizations$message' => '<p>Descriptive message for the error response.</p>', 'TrafficPolicyAlreadyExists$message' => '<p>Descriptive message for the error response.</p>', 'TrafficPolicyInUse$message' => '<p>Descriptive message for the error response.</p>', 'TrafficPolicyInstanceAlreadyExists$message' => '<p>Descriptive message for the error response.</p>', 'VPCAssociationAuthorizationNotFound$message' => '<p>Descriptive message for the error response.</p>', 'VPCAssociationNotFound$message' => '<p>Descriptive message for the error response.</p>', ], ], 'ErrorMessages' => [ 'base' => NULL, 'refs' => [ 'InvalidChangeBatch$messages' => '<p>Descriptive message for the error response.</p>', ], ], 'EvaluationPeriods' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmConfiguration$EvaluationPeriods' => '<p>For the metric that the CloudWatch alarm is associated with, the number of periods that the metric is compared to the threshold.</p>', ], ], 'FailureThreshold' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$FailureThreshold' => '<p>The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p>If you don\'t specify a value for <code>FailureThreshold</code>, the default value is three health checks.</p>', 'UpdateHealthCheckRequest$FailureThreshold' => '<p>The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p>If you don\'t specify a value for <code>FailureThreshold</code>, the default value is three health checks.</p>', ], ], 'FullyQualifiedDomainName' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$FullyQualifiedDomainName' => '<p>Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.</p> <p> <b>If you specify a value for</b> <code>IPAddress</code>:</p> <p>Amazon Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Amazon Route 53 to perform health checks.</p> <p>When Amazon Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:</p> <ul> <li> <p>If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or <code>HTTP_STR_MATCH</code> for <code>Type</code>, Amazon Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the Host header. </p> </li> <li> <p>If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or <code>HTTPS_STR_MATCH</code> for <code>Type</code>, Amazon Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p> </li> <li> <p>If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code>, Amazon Route 53 passes <code>FullyQualifiedDomainName:Port</code> to the endpoint in the <code>Host</code> header.</p> </li> </ul> <p>If you don\'t specify a value for <code>FullyQualifiedDomainName</code>, Amazon Route 53 substitutes the value of <code>IPAddress</code> in the <code>Host</code> header in each of the preceding cases.</p> <p> <b>If you don\'t specify a value for <code>IPAddress</code> </b>:</p> <p>Amazon Route 53 sends a DNS request to the domain that you specify for <code>FullyQualifiedDomainName</code> at the interval that you specify for <code>RequestInterval</code>. Using an IPv4 address that DNS returns, Amazon Route 53 then checks the health of the endpoint.</p> <note> <p>If you don\'t specify a value for <code>IPAddress</code>, Amazon Route 53 uses only IPv4 to send health checks to the endpoint. If there\'s no resource record set with a type of A for the name that you specify for <code>FullyQualifiedDomainName</code>, the health check fails with a "DNS resolution failed" error.</p> </note> <p>If you want to check the health of weighted, latency, or failover resource record sets and you choose to specify the endpoint only by <code>FullyQualifiedDomainName</code>, we recommend that you create a separate health check for each endpoint. For example, create a health check for each HTTP server that is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>, specify the domain name of the server (such as us-east-2-www.example.com), not the name of the resource record sets (www.example.com).</p> <important> <p>In this configuration, if you create a health check for which the value of <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and you then associate the health check with those resource record sets, health check results will be unpredictable.</p> </important> <p>In addition, if the value that you specify for <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>, <code>HTTP_STR_MATCH</code>, or <code>HTTPS_STR_MATCH</code>, Amazon Route 53 passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does when you specify a value for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Amazon Route 53 doesn\'t pass a <code>Host</code> header.</p>', 'UpdateHealthCheckRequest$FullyQualifiedDomainName' => '<p>Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.</p> <note> <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can\'t update an existing health check to add or remove the value of <code>IPAddress</code>. </p> </note> <p> <b>If you specify a value for</b> <code>IPAddress</code>:</p> <p>Amazon Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Amazon Route 53 to perform health checks.</p> <p>When Amazon Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:</p> <ul> <li> <p>If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or <code>HTTP_STR_MATCH</code> for <code>Type</code>, Amazon Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p> </li> <li> <p>If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or <code>HTTPS_STR_MATCH</code> for <code>Type</code>, Amazon Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p> </li> <li> <p>If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code>, Amazon Route 53 passes <i> <code>FullyQualifiedDomainName</code>:<code>Port</code> </i> to the endpoint in the <code>Host</code> header.</p> </li> </ul> <p>If you don\'t specify a value for <code>FullyQualifiedDomainName</code>, Amazon Route 53 substitutes the value of <code>IPAddress</code> in the <code>Host</code> header in each of the above cases.</p> <p> <b>If you don\'t specify a value for</b> <code>IPAddress</code>:</p> <p>If you don\'t specify a value for <code>IPAddress</code>, Amazon Route 53 sends a DNS request to the domain that you specify in <code>FullyQualifiedDomainName</code> at the interval you specify in <code>RequestInterval</code>. Using an IPv4 address that is returned by DNS, Amazon Route 53 then checks the health of the endpoint.</p> <note> <p>If you don\'t specify a value for <code>IPAddress</code>, Amazon Route 53 uses only IPv4 to send health checks to the endpoint. If there\'s no resource record set with a type of A for the name that you specify for <code>FullyQualifiedDomainName</code>, the health check fails with a "DNS resolution failed" error.</p> </note> <p>If you want to check the health of weighted, latency, or failover resource record sets and you choose to specify the endpoint only by <code>FullyQualifiedDomainName</code>, we recommend that you create a separate health check for each endpoint. For example, create a health check for each HTTP server that is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>, specify the domain name of the server (such as <code>us-east-2-www.example.com</code>), not the name of the resource record sets (www.example.com).</p> <important> <p>In this configuration, if the value of <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and you then associate the health check with those resource record sets, health check results will be unpredictable.</p> </important> <p>In addition, if the value of <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>, <code>HTTP_STR_MATCH</code>, or <code>HTTPS_STR_MATCH</code>, Amazon Route 53 passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does when you specify a value for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Amazon Route 53 doesn\'t pass a <code>Host</code> header.</p>', ], ], 'GeoLocation' => [ 'base' => '<p>A complex type that contains information about a geo location.</p>', 'refs' => [ 'ResourceRecordSet$GeoLocation' => '<p> <i>Geo location resource record sets only:</i> A complex type that lets you control how Amazon Route 53 responds to DNS queries based on the geographic origin of the query. For example, if you want all queries from Africa to be routed to a web server with an IP address of <code>192.0.2.111</code>, create a resource record set with a <code>Type</code> of <code>A</code> and a <code>ContinentCode</code> of <code>AF</code>.</p> <note> <p>Creating geolocation and geolocation alias resource record sets in private hosted zones is not supported.</p> </note> <p>If you create separate resource record sets for overlapping geographic regions (for example, one resource record set for a continent and one for a country on the same continent), priority goes to the smallest geographic region. This allows you to route most queries for a continent to one resource and to route queries for a country on that continent to a different resource.</p> <p>You can\'t create two geolocation resource record sets that specify the same geographic location.</p> <p>The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that aren\'t specified in other geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.</p> <important> <p>Geolocation works by mapping IP addresses to locations. However, some IP addresses aren\'t mapped to geographic locations, so even if you create geolocation resource record sets that cover all seven continents, Amazon Route 53 will receive some DNS queries from locations that it can\'t identify. We recommend that you create a resource record set for which the value of <code>CountryCode</code> is <code>*</code>, which handles both queries that come from locations for which you haven\'t created geolocation resource record sets and queries from IP addresses that aren\'t mapped to a location. If you don\'t create a <code>*</code> resource record set, Amazon Route 53 returns a "no answer" response for queries from those locations.</p> </important> <p>You can\'t create non-geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as geolocation resource record sets.</p>', ], ], 'GeoLocationContinentCode' => [ 'base' => NULL, 'refs' => [ 'GeoLocation$ContinentCode' => '<p>The two-letter code for the continent.</p> <p>Valid values: <code>AF</code> | <code>AN</code> | <code>AS</code> | <code>EU</code> | <code>OC</code> | <code>NA</code> | <code>SA</code> </p> <p>Constraint: Specifying <code>ContinentCode</code> with either <code>CountryCode</code> or <code>SubdivisionCode</code> returns an <code>InvalidInput</code> error.</p>', 'GeoLocationDetails$ContinentCode' => '<p>The two-letter code for the continent.</p>', 'GetGeoLocationRequest$ContinentCode' => '<p>Amazon Route 53 supports the following continent codes:</p> <ul> <li> <p> <b>AF</b>: Africa</p> </li> <li> <p> <b>AN</b>: Antarctica</p> </li> <li> <p> <b>AS</b>: Asia</p> </li> <li> <p> <b>EU</b>: Europe</p> </li> <li> <p> <b>OC</b>: Oceania</p> </li> <li> <p> <b>NA</b>: North America</p> </li> <li> <p> <b>SA</b>: South America</p> </li> </ul>', 'ListGeoLocationsRequest$StartContinentCode' => '<p>The code for the continent with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Amazon Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is true, and if <code>NextContinentCode</code> from the previous response has a value, enter that value in <code>StartContinentCode</code> to return the next page of results.</p> <p>Include <code>StartContinentCode</code> only if you want to list continents. Don\'t include <code>StartContinentCode</code> when you\'re listing countries or countries with their subdivisions.</p>', 'ListGeoLocationsResponse$NextContinentCode' => '<p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextContinentCode</code> in the <code>StartContinentCode</code> parameter in another <code>ListGeoLocations</code> request.</p>', ], ], 'GeoLocationContinentName' => [ 'base' => NULL, 'refs' => [ 'GeoLocationDetails$ContinentName' => '<p>The full name of the continent.</p>', ], ], 'GeoLocationCountryCode' => [ 'base' => NULL, 'refs' => [ 'GeoLocation$CountryCode' => '<p>The two-letter code for the country.</p>', 'GeoLocationDetails$CountryCode' => '<p>The two-letter code for the country.</p>', 'GetGeoLocationRequest$CountryCode' => '<p>Amazon Route 53 uses the two-letter country codes that are specified in <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.</p>', 'ListGeoLocationsRequest$StartCountryCode' => '<p>The code for the country with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Amazon Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextCountryCode</code> from the previous response has a value, enter that value in <code>StartCountryCode</code> to return the next page of results.</p> <p>Amazon Route 53 uses the two-letter country codes that are specified in <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.</p>', 'ListGeoLocationsResponse$NextCountryCode' => '<p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextCountryCode</code> in the <code>StartCountryCode</code> parameter in another <code>ListGeoLocations</code> request.</p>', ], ], 'GeoLocationCountryName' => [ 'base' => NULL, 'refs' => [ 'GeoLocationDetails$CountryName' => '<p>The name of the country.</p>', ], ], 'GeoLocationDetails' => [ 'base' => '<p>A complex type that contains the codes and full continent, country, and subdivision names for the specified <code>geolocation</code> code.</p>', 'refs' => [ 'GeoLocationDetailsList$member' => NULL, 'GetGeoLocationResponse$GeoLocationDetails' => '<p>A complex type that contains the codes and full continent, country, and subdivision names for the specified geolocation code.</p>', ], ], 'GeoLocationDetailsList' => [ 'base' => NULL, 'refs' => [ 'ListGeoLocationsResponse$GeoLocationDetailsList' => '<p>A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route 53 supports for geolocation.</p>', ], ], 'GeoLocationSubdivisionCode' => [ 'base' => NULL, 'refs' => [ 'GeoLocation$SubdivisionCode' => '<p>The code for the subdivision, for example, a state in the United States or a province in Canada.</p>', 'GeoLocationDetails$SubdivisionCode' => '<p>The code for the subdivision, for example, a state in the United States or a province in Canada.</p>', 'GetGeoLocationRequest$SubdivisionCode' => '<p>Amazon Route 53 uses the one- to three-letter subdivision codes that are specified in <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>. Amazon Route 53 doesn\'t support subdivision codes for all countries. If you specify <code>SubdivisionCode</code>, you must also specify <code>CountryCode</code>. </p>', 'ListGeoLocationsRequest$StartSubdivisionCode' => '<p>The code for the subdivision (for example, state or province) with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Amazon Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextSubdivisionCode</code> from the previous response has a value, enter that value in <code>StartSubdivisionCode</code> to return the next page of results.</p> <p>To list subdivisions of a country, you must include both <code>StartCountryCode</code> and <code>StartSubdivisionCode</code>.</p>', 'ListGeoLocationsResponse$NextSubdivisionCode' => '<p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextSubdivisionCode</code> in the <code>StartSubdivisionCode</code> parameter in another <code>ListGeoLocations</code> request.</p>', ], ], 'GeoLocationSubdivisionName' => [ 'base' => NULL, 'refs' => [ 'GeoLocationDetails$SubdivisionName' => '<p>The full name of the subdivision, for example, a state in the United States or a province in Canada.</p>', ], ], 'GetChangeRequest' => [ 'base' => '<p>The input for a GetChange request.</p>', 'refs' => [], ], 'GetChangeResponse' => [ 'base' => '<p>A complex type that contains the <code>ChangeInfo</code> element.</p>', 'refs' => [], ], 'GetCheckerIpRangesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCheckerIpRangesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetGeoLocationRequest' => [ 'base' => '<p>A request for information about whether a specified geographic location is supported for Amazon Route 53 geolocation resource record sets.</p>', 'refs' => [], ], 'GetGeoLocationResponse' => [ 'base' => '<p>A complex type that contains the response information for the specified geolocation code.</p>', 'refs' => [], ], 'GetHealthCheckCountRequest' => [ 'base' => '<p>A request for the number of health checks that are associated with the current AWS account.</p>', 'refs' => [], ], 'GetHealthCheckCountResponse' => [ 'base' => '<p>A complex type that contains the response to a <code>GetHealthCheckCount</code> request.</p>', 'refs' => [], ], 'GetHealthCheckLastFailureReasonRequest' => [ 'base' => '<p>A request for the reason that a health check failed most recently.</p>', 'refs' => [], ], 'GetHealthCheckLastFailureReasonResponse' => [ 'base' => '<p>A complex type that contains the response to a <code>GetHealthCheckLastFailureReason</code> request.</p>', 'refs' => [], ], 'GetHealthCheckRequest' => [ 'base' => '<p>A request to get information about a specified health check. </p>', 'refs' => [], ], 'GetHealthCheckResponse' => [ 'base' => '<p>A complex type that contains the response to a <code>GetHealthCheck</code> request.</p>', 'refs' => [], ], 'GetHealthCheckStatusRequest' => [ 'base' => '<p>A request to get the status for a health check.</p>', 'refs' => [], ], 'GetHealthCheckStatusResponse' => [ 'base' => '<p>A complex type that contains the response to a <code>GetHealthCheck</code> request.</p>', 'refs' => [], ], 'GetHostedZoneCountRequest' => [ 'base' => '<p>A request to retrieve a count of all the hosted zones that are associated with the current AWS account.</p>', 'refs' => [], ], 'GetHostedZoneCountResponse' => [ 'base' => '<p>A complex type that contains the response to a <code>GetHostedZoneCount</code> request.</p>', 'refs' => [], ], 'GetHostedZoneRequest' => [ 'base' => '<p>A request to get information about a specified hosted zone. </p>', 'refs' => [], ], 'GetHostedZoneResponse' => [ 'base' => '<p>A complex type that contain the response to a <code>GetHostedZone</code> request.</p>', 'refs' => [], ], 'GetReusableDelegationSetRequest' => [ 'base' => '<p>A request to get information about a specified reusable delegation set.</p>', 'refs' => [], ], 'GetReusableDelegationSetResponse' => [ 'base' => '<p>A complex type that contains the response to the <code>GetReusableDelegationSet</code> request.</p>', 'refs' => [], ], 'GetTrafficPolicyInstanceCountRequest' => [ 'base' => '<p>Request to get the number of traffic policy instances that are associated with the current AWS account.</p>', 'refs' => [], ], 'GetTrafficPolicyInstanceCountResponse' => [ 'base' => '<p>A complex type that contains information about the resource record sets that Amazon Route 53 created based on a specified traffic policy.</p>', 'refs' => [], ], 'GetTrafficPolicyInstanceRequest' => [ 'base' => '<p>Gets information about a specified traffic policy instance.</p>', 'refs' => [], ], 'GetTrafficPolicyInstanceResponse' => [ 'base' => '<p>A complex type that contains information about the resource record sets that Amazon Route 53 created based on a specified traffic policy.</p>', 'refs' => [], ], 'GetTrafficPolicyRequest' => [ 'base' => '<p>Gets information about a specific traffic policy version.</p>', 'refs' => [], ], 'GetTrafficPolicyResponse' => [ 'base' => '<p>A complex type that contains the response information for the request.</p>', 'refs' => [], ], 'HealthCheck' => [ 'base' => '<p>A complex type that contains information about one health check that is associated with the current AWS account.</p>', 'refs' => [ 'CreateHealthCheckResponse$HealthCheck' => '<p>A complex type that contains identifying information about the health check.</p>', 'GetHealthCheckResponse$HealthCheck' => '<p>A complex type that contains information about one health check that is associated with the current AWS account.</p>', 'HealthChecks$member' => NULL, 'UpdateHealthCheckResponse$HealthCheck' => NULL, ], ], 'HealthCheckAlreadyExists' => [ 'base' => '<p> The health check you\'re attempting to create already exists. Amazon Route 53 returns this error when you submit a request that has the following values:</p> <ul> <li> <p>The same value for <code>CallerReference</code> as an existing health check, and one or more values that differ from the existing health check that has the same caller reference.</p> </li> <li> <p>The same value for <code>CallerReference</code> as a health check that you created and later deleted, regardless of the other settings in the request.</p> </li> </ul>', 'refs' => [], ], 'HealthCheckConfig' => [ 'base' => '<p>A complex type that contains information about the health check.</p>', 'refs' => [ 'CreateHealthCheckRequest$HealthCheckConfig' => '<p>A complex type that contains the response to a <code>CreateHealthCheck</code> request. </p>', 'HealthCheck$HealthCheckConfig' => '<p>A complex type that contains detailed information about one health check.</p>', ], ], 'HealthCheckCount' => [ 'base' => NULL, 'refs' => [ 'GetHealthCheckCountResponse$HealthCheckCount' => '<p>The number of health checks associated with the current AWS account.</p>', ], ], 'HealthCheckId' => [ 'base' => NULL, 'refs' => [ 'ChildHealthCheckList$member' => NULL, 'DeleteHealthCheckRequest$HealthCheckId' => '<p>The ID of the health check that you want to delete.</p>', 'GetHealthCheckLastFailureReasonRequest$HealthCheckId' => '<p>The ID for the health check for which you want the last failure reason. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>', 'GetHealthCheckRequest$HealthCheckId' => '<p>The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a resource record set, you use this value to specify which health check to use. The value can be up to 64 characters long.</p>', 'GetHealthCheckStatusRequest$HealthCheckId' => '<p>The ID for the health check that you want the current status for. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p> <note> <p>If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console. You can\'t use <code>GetHealthCheckStatus</code> to get the status of a calculated health check.</p> </note>', 'HealthCheck$Id' => '<p>The identifier that Amazon Route 53assigned to the health check when you created it. When you add or update a resource record set, you use this value to specify which health check to use. The value can be up to 64 characters long. </p>', 'ResourceRecordSet$HealthCheckId' => '<p>If you want Amazon Route 53 to return this resource record set in response to a DNS query only when a health check is passing, include the <code>HealthCheckId</code> element and specify the ID of the applicable health check.</p> <p>Amazon Route 53 determines whether a resource record set is healthy based on one of the following:</p> <ul> <li> <p>By periodically sending a request to the endpoint that is specified in the health check</p> </li> <li> <p>By aggregating the status of a specified group of health checks (calculated health checks)</p> </li> <li> <p>By determining the current state of a CloudWatch alarm (CloudWatch metric health checks)</p> </li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a>.</p> <p>The <code>HealthCheckId</code> element is only useful when Amazon Route 53 is choosing between two or more resource record sets to respond to a DNS query, and you want Amazon Route 53 to base the choice in part on the status of a health check. Configuring health checks only makes sense in the following configurations:</p> <ul> <li> <p>You\'re checking the health of the resource record sets in a group of weighted, latency, geolocation, or failover resource record sets, and you specify health check IDs for all of the resource record sets. If the health check for one resource record set specifies an endpoint that is not healthy, Amazon Route 53 stops responding to queries using the value for that resource record set.</p> </li> <li> <p>You set <code>EvaluateTargetHealth</code> to true for the resource record sets in a group of alias, weighted alias, latency alias, geolocation alias, or failover alias resource record sets, and you specify health check IDs for all of the resource record sets that are referenced by the alias resource record sets.</p> </li> </ul> <important> <p>Amazon Route 53 doesn\'t check the health of the endpoint specified in the resource record set, for example, the endpoint specified by the IP address in the <code>Value</code> element. When you add a <code>HealthCheckId</code> element to a resource record set, Amazon Route 53 checks the health of the endpoint that you specified in the health check. </p> </important> <p>For geolocation resource record sets, if an endpoint is unhealthy, Amazon Route 53 looks for a resource record set for the larger, associated geographic region. For example, suppose you have resource record sets for a state in the United States, for the United States, for North America, and for all locations. If the endpoint for the state resource record set is unhealthy, Amazon Route 53 checks the resource record sets for the United States, for North America, and for all locations (a resource record set for which the value of <code>CountryCode</code> is <code>*</code>), in that order, until it finds a resource record set for which the endpoint is healthy. </p> <p>If your health checks specify the endpoint only by domain name, we recommend that you create a separate health check for each endpoint. For example, create a health check for each <code>HTTP</code> server that is serving content for <code>www.example.com</code>. For the value of <code>FullyQualifiedDomainName</code>, specify the domain name of the server (such as <code>us-east-2-www.example.com</code>), not the name of the resource record sets (example.com).</p> <important> <p>n this configuration, if you create a health check for which the value of <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and then associate the health check with those resource record sets, health check results will be unpredictable.</p> </important> <p>For more information, see the following topics in the <i>Amazon Route 53 Developer Guide</i>:</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Amazon Route 53 Health Checks and DNS Failover</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a> </p> </li> </ul>', 'UpdateHealthCheckRequest$HealthCheckId' => '<p>The ID for the health check for which you want detailed information. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>', ], ], 'HealthCheckInUse' => [ 'base' => '<p>This error code is not in use.</p>', 'refs' => [], ], 'HealthCheckNonce' => [ 'base' => NULL, 'refs' => [ 'CreateHealthCheckRequest$CallerReference' => '<p>A unique string that identifies the request and that allows you to retry a failed <code>CreateHealthCheck</code> request without the risk of creating two identical health checks:</p> <ul> <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and settings as a previous request, and if the health check doesn\'t exist, Amazon Route 53 creates the health check. If the health check does exist, Amazon Route 53 returns the settings for the existing health check.</p> </li> <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a deleted health check, regardless of the settings, Amazon Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p> </li> <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an existing health check but with different settings, Amazon Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p> </li> <li> <p>If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but settings identical to an existing health check, Amazon Route 53 creates the health check.</p> </li> </ul>', 'HealthCheck$CallerReference' => '<p>A unique string that you specified when you created the health check.</p>', ], ], 'HealthCheckObservation' => [ 'base' => '<p>A complex type that contains the last failure reason as reported by one Amazon Route 53 health checker.</p>', 'refs' => [ 'HealthCheckObservations$member' => NULL, ], ], 'HealthCheckObservations' => [ 'base' => NULL, 'refs' => [ 'GetHealthCheckLastFailureReasonResponse$HealthCheckObservations' => '<p>A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is reporting a last failure reason. </p>', 'GetHealthCheckStatusResponse$HealthCheckObservations' => '<p>A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker that is reporting a status about the health check endpoint.</p>', ], ], 'HealthCheckRegion' => [ 'base' => NULL, 'refs' => [ 'HealthCheckObservation$Region' => '<p>The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>.</p>', 'HealthCheckRegionList$member' => NULL, ], ], 'HealthCheckRegionList' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$Regions' => '<p>A complex type that contains one <code>Region</code> element for each region from which you want Amazon Route 53 health checkers to check the specified endpoint.</p> <p>If you don\'t specify any regions, Amazon Route 53 health checkers automatically performs checks from all of the regions that are listed under <b>Valid Values</b>.</p> <p>If you update a health check to remove a region that has been performing health checks, Amazon Route 53 will briefly continue to perform checks from that region to ensure that some health checkers are always checking the endpoint (for example, if you replace three regions with four different regions). </p>', 'UpdateHealthCheckRequest$Regions' => '<p>A complex type that contains one <code>Region</code> element for each region that you want Amazon Route 53 health checkers to check the specified endpoint from.</p>', ], ], 'HealthCheckType' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$Type' => '<p>The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an endpoint is healthy.</p> <important> <p>You can\'t change the value of <code>Type</code> after you create a health check.</p> </important> <p>You can create the following types of health checks:</p> <ul> <li> <p> <b>HTTP</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.</p> </li> <li> <p> <b>HTTPS</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.</p> <important> <p>If you specify <code>HTTPS</code> for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.</p> </important> </li> <li> <p> <b>HTTP_STR_MATCH</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits an HTTP request and searches the first 5,120 bytes of the response body for the string that you specify in <code>SearchString</code>.</p> </li> <li> <p> <b>HTTPS_STR_MATCH</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits an <code>HTTPS</code> request and searches the first 5,120 bytes of the response body for the string that you specify in <code>SearchString</code>.</p> </li> <li> <p> <b>TCP</b>: Amazon Route 53 tries to establish a TCP connection.</p> </li> <li> <p> <b>CLOUDWATCH_METRIC</b>: The health check is associated with a CloudWatch alarm. If the state of the alarm is <code>OK</code>, the health check is considered healthy. If the state is <code>ALARM</code>, the health check is considered unhealthy. If CloudWatch doesn\'t have sufficient data to determine whether the state is <code>OK</code> or <code>ALARM</code>, the health check status depends on the setting for <code>InsufficientDataHealthStatus</code>: <code>Healthy</code>, <code>Unhealthy</code>, or <code>LastKnownStatus</code>. </p> </li> <li> <p> <b>CALCULATED</b>: For health checks that monitor the status of other health checks, Amazon Route 53 adds up the number of health checks that Amazon Route 53 health checkers consider to be healthy and compares that number with the value of <code>HealthThreshold</code>. </p> </li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>', ], ], 'HealthCheckVersion' => [ 'base' => NULL, 'refs' => [ 'HealthCheck$HealthCheckVersion' => '<p>The version of the health check. You can optionally pass this value in a call to <code>UpdateHealthCheck</code> to prevent overwriting another change to the health check.</p>', 'UpdateHealthCheckRequest$HealthCheckVersion' => '<p>A sequential counter that Amazon Route 53 sets to <code>1</code> when you create a health check and increments by 1 each time you update settings for the health check.</p> <p>We recommend that you use <code>GetHealthCheck</code> or <code>ListHealthChecks</code> to get the current value of <code>HealthCheckVersion</code> for the health check that you want to update, and that you include that value in your <code>UpdateHealthCheck</code> request. This prevents Amazon Route 53 from overwriting an intervening update:</p> <ul> <li> <p>If the value in the <code>UpdateHealthCheck</code> request matches the value of <code>HealthCheckVersion</code> in the health check, Amazon Route 53 updates the health check with the new settings.</p> </li> <li> <p>If the value of <code>HealthCheckVersion</code> in the health check is greater, the health check was changed after you got the version number. Amazon Route 53 does not update the health check, and it returns a <code>HealthCheckVersionMismatch</code> error.</p> </li> </ul>', ], ], 'HealthCheckVersionMismatch' => [ 'base' => '<p>The value of <code>HealthCheckVersion</code> in the request doesn\'t match the value of <code>HealthCheckVersion</code> in the health check.</p>', 'refs' => [], ], 'HealthChecks' => [ 'base' => NULL, 'refs' => [ 'ListHealthChecksResponse$HealthChecks' => '<p>A complex type that contains one <code>HealthCheck</code> element for each health check that is associated with the current AWS account.</p>', ], ], 'HealthThreshold' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$HealthThreshold' => '<p>The number of child health checks that are associated with a <code>CALCULATED</code> health that Amazon Route 53 must consider healthy for the <code>CALCULATED</code> health check to be considered healthy. To specify the child health checks that you want to associate with a <code>CALCULATED</code> health check, use the <a>HealthCheckConfig$ChildHealthChecks</a> and <a>HealthCheckConfig$ChildHealthChecks</a> elements.</p> <p>Note the following:</p> <ul> <li> <p>If you specify a number greater than the number of child health checks, Amazon Route 53 always considers this health check to be unhealthy.</p> </li> <li> <p>If you specify <code>0</code>, Amazon Route 53 always considers this health check to be healthy.</p> </li> </ul>', 'UpdateHealthCheckRequest$HealthThreshold' => '<p>The number of child health checks that are associated with a <code>CALCULATED</code> health that Amazon Route 53 must consider healthy for the <code>CALCULATED</code> health check to be considered healthy. To specify the child health checks that you want to associate with a <code>CALCULATED</code> health check, use the <code>ChildHealthChecks</code> and <code>ChildHealthCheck</code> elements.</p> <p>Note the following:</p> <ul> <li> <p>If you specify a number greater than the number of child health checks, Amazon Route 53 always considers this health check to be unhealthy.</p> </li> <li> <p>If you specify <code>0</code>, Amazon Route 53 always considers this health check to be healthy.</p> </li> </ul>', ], ], 'HostedZone' => [ 'base' => '<p>A complex type that contains general information about the hosted zone.</p>', 'refs' => [ 'CreateHostedZoneResponse$HostedZone' => '<p>A complex type that contains general information about the hosted zone.</p>', 'GetHostedZoneResponse$HostedZone' => '<p>A complex type that contains general information about the specified hosted zone.</p>', 'HostedZones$member' => NULL, 'UpdateHostedZoneCommentResponse$HostedZone' => NULL, ], ], 'HostedZoneAlreadyExists' => [ 'base' => '<p>The hosted zone you\'re trying to create already exists. Amazon Route 53 returns this error when a hosted zone has already been created with the specified <code>CallerReference</code>.</p>', 'refs' => [], ], 'HostedZoneConfig' => [ 'base' => '<p>A complex type that contains an optional comment about your hosted zone. If you don\'t want to specify a comment, omit both the <code>HostedZoneConfig</code> and <code>Comment</code> elements.</p>', 'refs' => [ 'CreateHostedZoneRequest$HostedZoneConfig' => '<p>(Optional) A complex type that contains the following optional values:</p> <ul> <li> <p>For public and private hosted zones, an optional comment</p> </li> <li> <p>For private hosted zones, an optional <code>PrivateZone</code> element</p> </li> </ul> <p>If you don\'t specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code> and the other elements.</p>', 'HostedZone$Config' => '<p>A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you omitted the <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the <code>Config</code> and <code>Comment</code> elements don\'t appear in the response.</p>', ], ], 'HostedZoneCount' => [ 'base' => NULL, 'refs' => [ 'GetHostedZoneCountResponse$HostedZoneCount' => '<p>The total number of public and private hosted zones that are associated with the current AWS account.</p>', ], ], 'HostedZoneNotEmpty' => [ 'base' => '<p>The hosted zone contains resource records that are not SOA or NS records.</p>', 'refs' => [], ], 'HostedZoneNotFound' => [ 'base' => '<p>The specified HostedZone can\'t be found.</p>', 'refs' => [], ], 'HostedZoneRRSetCount' => [ 'base' => NULL, 'refs' => [ 'HostedZone$ResourceRecordSetCount' => '<p>The number of resource record sets in the hosted zone.</p>', ], ], 'HostedZones' => [ 'base' => NULL, 'refs' => [ 'ListHostedZonesByNameResponse$HostedZones' => '<p>A complex type that contains general information about the hosted zone.</p>', 'ListHostedZonesResponse$HostedZones' => '<p>A complex type that contains general information about the hosted zone.</p>', ], ], 'IPAddress' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$IPAddress' => '<p>The IPv4 or IPv6 IP address of the endpoint that you want Amazon Route 53 to perform health checks on. If you don\'t specify a value for <code>IPAddress</code>, Amazon Route 53 sends a DNS request to resolve the domain name that you specify in <code>FullyQualifiedDomainName</code> at the interval that you specify in <code>RequestInterval</code>. Using an IP address returned by DNS, Amazon Route 53 then checks the health of the endpoint.</p> <p>Use one of the following formats for the value of <code>IPAddress</code>: </p> <ul> <li> <p> <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.), for example, <code>192.0.2.44</code>.</p> </li> <li> <p> <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:), for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in RFC 5952, for example, <code>2001:db8:85a3::abcd:1:2345</code>.</p> </li> </ul> <p>If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and specify the Elastic IP address for <code>IPAddress</code>. This ensures that the IP address of your instance will never change.</p> <p>For more information, see <a>HealthCheckConfig$FullyQualifiedDomainName</a>.</p> <p>Constraints: Amazon Route 53 can\'t check the health of endpoints for which the IP address is in local, private, non-routable, or multicast ranges. For more information about IP addresses for which you can\'t create health checks, see the following documents:</p> <ul> <li> <p> <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a> </p> </li> <li> <p> <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a> </p> </li> <li> <p> <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a> </p> </li> </ul> <p>When the value of <code>Type</code> is <code>CALCULATED</code> or <code>CLOUDWATCH_METRIC</code>, omit <code>IPAddress</code>.</p>', 'HealthCheckObservation$IPAddress' => '<p>The IP address of the Amazon Route 53 health checker that provided the failure reason in <code>StatusReport</code>.</p>', 'TestDNSAnswerRequest$ResolverIP' => '<p>If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the AWS US East (N. Virginia) Region (<code>us-east-1</code>).</p>', 'TestDNSAnswerRequest$EDNS0ClientSubnetIP' => '<p>If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client in the applicable location, for example, <code>192.0.2.44</code> or <code>2001:db8:85a3::8a2e:370:7334</code>.</p>', 'UpdateHealthCheckRequest$IPAddress' => '<p>The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on. If you don\'t specify a value for <code>IPAddress</code>, Amazon Route 53 sends a DNS request to resolve the domain name that you specify in <code>FullyQualifiedDomainName</code> at the interval that you specify in <code>RequestInterval</code>. Using an IP address that is returned by DNS, Amazon Route 53 then checks the health of the endpoint.</p> <p>Use one of the following formats for the value of <code>IPAddress</code>: </p> <ul> <li> <p> <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.), for example, <code>192.0.2.44</code>.</p> </li> <li> <p> <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:), for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in RFC 5952, for example, <code>2001:db8:85a3::abcd:1:2345</code>.</p> </li> </ul> <p>If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and specify the Elastic IP address for <code>IPAddress</code>. This ensures that the IP address of your instance never changes. For more information, see the applicable documentation:</p> <ul> <li> <p>Linux: <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> </p> </li> <li> <p>Windows: <a href="http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the <i>Amazon EC2 User Guide for Windows Instances</i> </p> </li> </ul> <note> <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can\'t update an existing health check to add or remove the value of <code>IPAddress</code>. </p> </note> <p>For more information, see <a>UpdateHealthCheckRequest$FullyQualifiedDomainName</a>.</p> <p>Constraints: Amazon Route 53 can\'t check the health of endpoints for which the IP address is in local, private, non-routable, or multicast ranges. For more information about IP addresses for which you can\'t create health checks, see the following documents:</p> <ul> <li> <p> <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a> </p> </li> <li> <p> <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a> </p> </li> <li> <p> <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a> </p> </li> </ul>', ], ], 'IPAddressCidr' => [ 'base' => NULL, 'refs' => [ 'CheckerIpRanges$member' => NULL, ], ], 'IncompatibleVersion' => [ 'base' => '<p>The resource you\'re trying to access is unsupported on this Amazon Route 53 endpoint.</p>', 'refs' => [], ], 'InsufficientDataHealthStatus' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$InsufficientDataHealthStatus' => '<p>When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign to the health check:</p> <ul> <li> <p> <code>Healthy</code>: Amazon Route 53 considers the health check to be healthy.</p> </li> <li> <p> <code>Unhealthy</code>: Amazon Route 53 considers the health check to be unhealthy.</p> </li> <li> <p> <code>LastKnownStatus</code>: Amazon Route 53 uses the status of the health check from the last time that CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last known status, the default status for the health check is healthy.</p> </li> </ul>', 'UpdateHealthCheckRequest$InsufficientDataHealthStatus' => '<p>When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign to the health check:</p> <ul> <li> <p> <code>Healthy</code>: Amazon Route 53 considers the health check to be healthy.</p> </li> <li> <p> <code>Unhealthy</code>: Amazon Route 53 considers the health check to be unhealthy.</p> </li> <li> <p> <code>LastKnownStatus</code>: Amazon Route 53 uses the status of the health check from the last time CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last known status, the default status for the health check is healthy.</p> </li> </ul>', ], ], 'InvalidArgument' => [ 'base' => '<p>Parameter name is invalid.</p>', 'refs' => [], ], 'InvalidChangeBatch' => [ 'base' => '<p>This exception contains a list of messages that might contain one or more error messages. Each error message indicates one error in the change batch.</p>', 'refs' => [], ], 'InvalidDomainName' => [ 'base' => '<p>The specified domain name is not valid.</p>', 'refs' => [], ], 'InvalidInput' => [ 'base' => '<p>The input is not valid.</p>', 'refs' => [], ], 'InvalidPaginationToken' => [ 'base' => NULL, 'refs' => [], ], 'InvalidTrafficPolicyDocument' => [ 'base' => '<p>The format of the traffic policy document that you specified in the <code>Document</code> element is invalid.</p>', 'refs' => [], ], 'InvalidVPCId' => [ 'base' => '<p>The VPC ID that you specified either isn\'t a valid ID or the current account is not authorized to access this VPC.</p>', 'refs' => [], ], 'Inverted' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$Inverted' => '<p>Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it otherwise would be considered healthy.</p>', 'UpdateHealthCheckRequest$Inverted' => '<p>Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it otherwise would be considered healthy.</p>', ], ], 'IsPrivateZone' => [ 'base' => NULL, 'refs' => [ 'HostedZoneConfig$PrivateZone' => '<p>A value that indicates whether this is a private hosted zone.</p>', ], ], 'LastVPCAssociation' => [ 'base' => '<p>The VPC that you\'re trying to disassociate from the private hosted zone is the last VPC that is associated with the hosted zone. Amazon Route 53 doesn\'t support disassociating the last VPC from a hosted zone.</p>', 'refs' => [], ], 'LimitsExceeded' => [ 'base' => '<p>The limits specified for a resource have been exceeded.</p>', 'refs' => [], ], 'ListGeoLocationsRequest' => [ 'base' => '<p>A request to get a list of geographic locations that Amazon Route 53 supports for geolocation resource record sets. </p>', 'refs' => [], ], 'ListGeoLocationsResponse' => [ 'base' => '<p>A complex type containing the response information for the request.</p>', 'refs' => [], ], 'ListHealthChecksRequest' => [ 'base' => '<p>A request to retrieve a list of the health checks that are associated with the current AWS account.</p>', 'refs' => [], ], 'ListHealthChecksResponse' => [ 'base' => '<p>A complex type that contains the response to a <code>ListHealthChecks</code> request.</p>', 'refs' => [], ], 'ListHostedZonesByNameRequest' => [ 'base' => '<p>Retrieves a list of the public and private hosted zones that are associated with the current AWS account in ASCII order by domain name. </p>', 'refs' => [], ], 'ListHostedZonesByNameResponse' => [ 'base' => '<p>A complex type that contains the response information for the request.</p>', 'refs' => [], ], 'ListHostedZonesRequest' => [ 'base' => '<p>A request to retrieve a list of the public and private hosted zones that are associated with the current AWS account.</p>', 'refs' => [], ], 'ListHostedZonesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceRecordSetsRequest' => [ 'base' => '<p>A request for the resource record sets that are associated with a specified hosted zone.</p>', 'refs' => [], ], 'ListResourceRecordSetsResponse' => [ 'base' => '<p>A complex type that contains list information for the resource record set.</p>', 'refs' => [], ], 'ListReusableDelegationSetsRequest' => [ 'base' => '<p>A request to get a list of the reusable delegation sets that are associated with the current AWS account.</p>', 'refs' => [], ], 'ListReusableDelegationSetsResponse' => [ 'base' => '<p>A complex type that contains information about the reusable delegation sets that are associated with the current AWS account.</p>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => '<p>A complex type containing information about a request for a list of the tags that are associated with an individual resource.</p>', 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => '<p>A complex type that contains information about the health checks or hosted zones for which you want to list tags.</p>', 'refs' => [], ], 'ListTagsForResourcesRequest' => [ 'base' => '<p>A complex type that contains information about the health checks or hosted zones for which you want to list tags.</p>', 'refs' => [], ], 'ListTagsForResourcesResponse' => [ 'base' => '<p>A complex type containing tags for the specified resources.</p>', 'refs' => [], ], 'ListTrafficPoliciesRequest' => [ 'base' => '<p>A complex type that contains the information about the request to list the traffic policies that are associated with the current AWS account.</p>', 'refs' => [], ], 'ListTrafficPoliciesResponse' => [ 'base' => '<p>A complex type that contains the response information for the request.</p>', 'refs' => [], ], 'ListTrafficPolicyInstancesByHostedZoneRequest' => [ 'base' => '<p>A request for the traffic policy instances that you created in a specified hosted zone.</p>', 'refs' => [], ], 'ListTrafficPolicyInstancesByHostedZoneResponse' => [ 'base' => '<p>A complex type that contains the response information for the request.</p>', 'refs' => [], ], 'ListTrafficPolicyInstancesByPolicyRequest' => [ 'base' => '<p>A complex type that contains the information about the request to list your traffic policy instances.</p>', 'refs' => [], ], 'ListTrafficPolicyInstancesByPolicyResponse' => [ 'base' => '<p>A complex type that contains the response information for the request.</p>', 'refs' => [], ], 'ListTrafficPolicyInstancesRequest' => [ 'base' => '<p>A request to get information about the traffic policy instances that you created by using the current AWS account.</p>', 'refs' => [], ], 'ListTrafficPolicyInstancesResponse' => [ 'base' => '<p>A complex type that contains the response information for the request.</p>', 'refs' => [], ], 'ListTrafficPolicyVersionsRequest' => [ 'base' => '<p>A complex type that contains the information about the request to list your traffic policies.</p>', 'refs' => [], ], 'ListTrafficPolicyVersionsResponse' => [ 'base' => '<p>A complex type that contains the response information for the request.</p>', 'refs' => [], ], 'ListVPCAssociationAuthorizationsRequest' => [ 'base' => '<p>A complex type that contains information about that can be associated with your hosted zone.</p>', 'refs' => [], ], 'ListVPCAssociationAuthorizationsResponse' => [ 'base' => '<p>A complex type that contains the response information for the request.</p>', 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListVPCAssociationAuthorizationsRequest$MaxResults' => '<p> <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return. If you don\'t specify a value for <code>MaxResults</code>, Amazon Route 53 returns up to 50 VPCs per page.</p>', ], ], 'MeasureLatency' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$MeasureLatency' => '<p>Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint, and to display CloudWatch latency graphs on the <b>Health Checks</b> page in the Amazon Route 53 console.</p> <important> <p>You can\'t change the value of <code>MeasureLatency</code> after you create a health check.</p> </important>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'TrafficPolicyInstance$Message' => '<p>If <code>State</code> is <code>Failed</code>, an explanation of the reason for the failure. If <code>State</code> is another value, <code>Message</code> is empty.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmConfiguration$MetricName' => '<p>The name of the CloudWatch metric that the alarm is associated with.</p>', ], ], 'Nameserver' => [ 'base' => NULL, 'refs' => [ 'TestDNSAnswerResponse$Nameserver' => '<p>The Amazon Route 53 name server used to respond to the request.</p>', ], ], 'Namespace' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmConfiguration$Namespace' => '<p>The namespace of the metric that the alarm is associated with. For more information, see <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html">Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference</a> in the <i>Amazon CloudWatch User Guide</i>.</p>', ], ], 'NoSuchChange' => [ 'base' => '<p>A change with the specified change ID does not exist.</p>', 'refs' => [], ], 'NoSuchDelegationSet' => [ 'base' => '<p>A reusable delegation set with the specified ID does not exist.</p>', 'refs' => [], ], 'NoSuchGeoLocation' => [ 'base' => '<p>Amazon Route 53 doesn\'t support the specified geolocation.</p>', 'refs' => [], ], 'NoSuchHealthCheck' => [ 'base' => '<p>No health check exists with the ID that you specified in the <code>DeleteHealthCheck</code> request.</p>', 'refs' => [], ], 'NoSuchHostedZone' => [ 'base' => '<p>No hosted zone exists with the ID that you specified.</p>', 'refs' => [], ], 'NoSuchTrafficPolicy' => [ 'base' => '<p>No traffic policy exists with the specified ID.</p>', 'refs' => [], ], 'NoSuchTrafficPolicyInstance' => [ 'base' => '<p>No traffic policy instance exists with the specified ID.</p>', 'refs' => [], ], 'Nonce' => [ 'base' => NULL, 'refs' => [ 'CreateHostedZoneRequest$CallerReference' => '<p>A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to be retried without the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a <code>CreateHostedZone</code> request. <code>CallerReference</code> can be any unique string, for example, a date/time stamp.</p>', 'CreateReusableDelegationSetRequest$CallerReference' => '<p>A unique string that identifies the request, and that allows you to retry failed <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique string, for example a date/time stamp.</p>', 'DelegationSet$CallerReference' => '<p>The value that you specified for <code>CallerReference</code> when you created the reusable delegation set.</p>', 'HostedZone$CallerReference' => '<p>The value that you specified for <code>CallerReference</code> when you created the hosted zone.</p>', ], ], 'NotAuthorizedException' => [ 'base' => '<p>Associating the specified VPC with the specified hosted zone has not been authorized.</p>', 'refs' => [], ], 'PageMarker' => [ 'base' => NULL, 'refs' => [ 'ListHealthChecksRequest$Marker' => '<p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health checks. To get another group, submit another <code>ListHealthChecks</code> request. </p> <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first health check that Amazon Route 53 will return if you submit another request.</p> <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more health checks to get.</p>', 'ListHealthChecksResponse$Marker' => '<p>For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the previous request.</p>', 'ListHealthChecksResponse$NextMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code> request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>', 'ListHostedZonesRequest$Marker' => '<p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted zones. To get more hosted zones, submit another <code>ListHostedZones</code> request. </p> <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.</p> <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more hosted zones to get.</p>', 'ListHostedZonesResponse$Marker' => '<p>For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the request that produced the current response.</p>', 'ListHostedZonesResponse$NextMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code> request, and specify the value of <code>NextMarker</code> from the response in the <code>marker</code> parameter.</p> <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>', 'ListReusableDelegationSetsRequest$Marker' => '<p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more reusable delegation sets. To get another group, submit another <code>ListReusableDelegationSets</code> request. </p> <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another request.</p> <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more reusable delegation sets to get.</p>', 'ListReusableDelegationSetsResponse$Marker' => '<p>For the second and subsequent calls to <code>ListReusableDelegationSets</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the request that produced the current response.</p>', 'ListReusableDelegationSetsResponse$NextMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the next reusable delegation set that Amazon Route 53 will return if you submit another <code>ListReusableDelegationSets</code> request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>', ], ], 'PageMaxItems' => [ 'base' => NULL, 'refs' => [ 'ListGeoLocationsRequest$MaxItems' => '<p>(Optional) The maximum number of geolocations to be included in the response body for this request. If more than <code>MaxItems</code> geolocations remain to be listed, then the value of the <code>IsTruncated</code> element in the response is <code>true</code>.</p>', 'ListGeoLocationsResponse$MaxItems' => '<p>The value that you specified for <code>MaxItems</code> in the request.</p>', 'ListHealthChecksRequest$MaxItems' => '<p>The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the current request. Amazon Route 53 returns a maximum of 100 items. If you set <code>MaxItems</code> to a value greater than 100, Amazon Route 53 returns only the first 100 health checks. </p>', 'ListHealthChecksResponse$MaxItems' => '<p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHealthChecks</code> that produced the current response.</p>', 'ListHostedZonesByNameRequest$MaxItems' => '<p>The maximum number of hosted zones to be included in the response body for this request. If you have more than <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element in the response is true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> specify the first hosted zone in the next group of <code>maxitems</code> hosted zones. </p>', 'ListHostedZonesByNameResponse$MaxItems' => '<p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZonesByName</code> that produced the current response.</p>', 'ListHostedZonesRequest$MaxItems' => '<p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted zone that Amazon Route 53 will return if you submit another request.</p>', 'ListHostedZonesResponse$MaxItems' => '<p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZones</code> that produced the current response.</p>', 'ListResourceRecordSetsRequest$MaxItems' => '<p>(Optional) The maximum number of resource records sets to include in the response body for this request. If the response includes more than <code>maxitems</code> resource record sets, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of the <code>NextRecordName</code> and <code>NextRecordType</code> elements in the response identify the first resource record set in the next group of <code>maxitems</code> resource record sets.</p>', 'ListResourceRecordSetsResponse$MaxItems' => '<p>The maximum number of records you requested.</p>', 'ListReusableDelegationSetsRequest$MaxItems' => '<p>The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request. If you specify a value greater than 100, Amazon Route 53 returns only the first 100 reusable delegation sets.</p>', 'ListReusableDelegationSetsResponse$MaxItems' => '<p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListReusableDelegationSets</code> that produced the current response.</p>', 'ListTrafficPoliciesRequest$MaxItems' => '<p>(Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this request. If you have more than <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Amazon Route 53 will return if you submit another request.</p>', 'ListTrafficPoliciesResponse$MaxItems' => '<p>The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicies</code> request that produced the current response.</p>', 'ListTrafficPolicyInstancesByHostedZoneRequest$MaxItems' => '<p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>', 'ListTrafficPolicyInstancesByHostedZoneResponse$MaxItems' => '<p>The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicyInstancesByHostedZone</code> request that produced the current response.</p>', 'ListTrafficPolicyInstancesByPolicyRequest$MaxItems' => '<p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>', 'ListTrafficPolicyInstancesByPolicyResponse$MaxItems' => '<p>The value that you specified for the <code>MaxItems</code> parameter in the call to <code>ListTrafficPolicyInstancesByPolicy</code> that produced the current response.</p>', 'ListTrafficPolicyInstancesRequest$MaxItems' => '<p>The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>', 'ListTrafficPolicyInstancesResponse$MaxItems' => '<p>The value that you specified for the <code>MaxItems</code> parameter in the call to <code>ListTrafficPolicyInstances</code> that produced the current response.</p>', 'ListTrafficPolicyVersionsRequest$MaxItems' => '<p>The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body for this request. If the specified traffic policy has more than <code>MaxItems</code> versions, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of the <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Amazon Route 53 will return if you submit another request.</p>', 'ListTrafficPolicyVersionsResponse$MaxItems' => '<p>The value that you specified for the <code>maxitems</code> parameter in the <code>ListTrafficPolicyVersions</code> request that produced the current response.</p>', ], ], 'PageTruncated' => [ 'base' => NULL, 'refs' => [ 'ListGeoLocationsResponse$IsTruncated' => '<p>A value that indicates whether more locations remain to be listed after the last location in this response. If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit another request and include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>, and <code>NextSubdivisionCode</code> in the <code>StartContinentCode</code>, <code>StartCountryCode</code>, and <code>StartSubdivisionCode</code>, as applicable.</p>', 'ListHealthChecksResponse$IsTruncated' => '<p>A flag that indicates whether there are more health checks to be listed. If the response was truncated, you can get the next group of health checks by submitting another <code>ListHealthChecks</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>', 'ListHostedZonesByNameResponse$IsTruncated' => '<p>A flag that indicates whether there are more hosted zones to be listed. If the response was truncated, you can get the next group of <code>maxitems</code> hosted zones by calling <code>ListHostedZonesByName</code> again and specifying the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the <code>dnsname</code> and <code>hostedzoneid</code> parameters.</p>', 'ListHostedZonesResponse$IsTruncated' => '<p>A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you can get more hosted zones by submitting another <code>ListHostedZones</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>', 'ListResourceRecordSetsResponse$IsTruncated' => '<p>A flag that indicates whether more resource record sets remain to be listed. If your results were truncated, you can make a follow-up pagination request by using the <code>NextRecordName</code> element.</p>', 'ListReusableDelegationSetsResponse$IsTruncated' => '<p>A flag that indicates whether there are more reusable delegation sets to be listed.</p>', 'ListTrafficPoliciesResponse$IsTruncated' => '<p>A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another <code>ListTrafficPolicies</code> request and specifying the value of <code>TrafficPolicyIdMarker</code> in the <code>TrafficPolicyIdMarker</code> request parameter.</p>', 'ListTrafficPolicyInstancesByHostedZoneResponse$IsTruncated' => '<p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by submitting another <code>ListTrafficPolicyInstancesByHostedZone</code> request and specifying the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.</p>', 'ListTrafficPolicyInstancesByPolicyResponse$IsTruncated' => '<p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by calling <code>ListTrafficPolicyInstancesByPolicy</code> again and specifying the values of the <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> elements in the corresponding request parameters.</p>', 'ListTrafficPolicyInstancesResponse$IsTruncated' => '<p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get more traffic policy instances by calling <code>ListTrafficPolicyInstances</code> again and specifying the values of the <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.</p>', 'ListTrafficPolicyVersionsResponse$IsTruncated' => '<p>A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another <code>ListTrafficPolicyVersions</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListVPCAssociationAuthorizationsRequest$NextToken' => '<p> <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of results, submit another request, and include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter in another <code>ListVPCAssociationAuthorizations</code> request.</p>', 'ListVPCAssociationAuthorizationsResponse$NextToken' => '<p>When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of VPCs, submit another <code>ListVPCAssociationAuthorizations</code> request, and include the value of the <code>NextToken</code> element from the response in the <code>nexttoken</code> request parameter.</p>', ], ], 'Period' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmConfiguration$Period' => '<p>For the metric that the CloudWatch alarm is associated with, the duration of one evaluation period in seconds.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$Port' => '<p>The port on the endpoint on which you want Amazon Route 53 to perform health checks. Specify a value for <code>Port</code> only when you specify a value for <code>IPAddress</code>.</p>', 'UpdateHealthCheckRequest$Port' => '<p>The port on the endpoint on which you want Amazon Route 53 to perform health checks.</p>', ], ], 'PriorRequestNotComplete' => [ 'base' => '<p>If Amazon Route 53 can\'t process a request before the next request arrives, it will reject subsequent requests for the same hosted zone and return an <code>HTTP 400 error</code> (<code>Bad request</code>). If Amazon Route 53 returns this error repeatedly for the same request, we recommend that you wait, in intervals of increasing duration, before you try the request again.</p>', 'refs' => [], ], 'PublicZoneVPCAssociation' => [ 'base' => '<p>You\'re trying to associate a VPC with a public hosted zone. Amazon Route 53 doesn\'t support associating a VPC with a public hosted zone.</p>', 'refs' => [], ], 'RData' => [ 'base' => NULL, 'refs' => [ 'ResourceRecord$Value' => '<p>The current or new DNS record value, not to exceed 4,000 characters. In the case of a <code>DELETE</code> action, if the current value does not match the actual value, an error is returned. For descriptions about how to format <code>Value</code> for different record types, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p>You can specify more than one value for all record types except <code>CNAME</code> and <code>SOA</code>. </p> <note> <p>If you\'re creating an alias resource record set, omit <code>Value</code>.</p> </note>', ], ], 'RRType' => [ 'base' => NULL, 'refs' => [ 'ListResourceRecordSetsRequest$StartRecordType' => '<p>The type of resource record set to begin the record listing from.</p> <p>Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p> <p>Values for weighted, latency, geo, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p> <p>Values for alias resource record sets: </p> <ul> <li> <p> <b>CloudFront distribution</b>: A or AAAA</p> </li> <li> <p> <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A</p> </li> <li> <p> <b>ELB load balancer</b>: A | AAAA</p> </li> <li> <p> <b>Amazon S3 bucket</b>: A</p> </li> <li> <p> <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the alias references.</p> </li> </ul> <p>Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an <code>InvalidInput</code> error.</p>', 'ListResourceRecordSetsResponse$NextRecordType' => '<p>If the results were truncated, the type of the next record in the list.</p> <p>This element is present only if <code>IsTruncated</code> is true. </p>', 'ListTrafficPolicyInstancesByHostedZoneRequest$TrafficPolicyInstanceTypeMarker' => '<p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.</p> <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>', 'ListTrafficPolicyInstancesByHostedZoneResponse$TrafficPolicyInstanceTypeMarker' => '<p>If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of traffic policy instances.</p>', 'ListTrafficPolicyInstancesByPolicyRequest$TrafficPolicyInstanceTypeMarker' => '<p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p> <p>For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p> <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>', 'ListTrafficPolicyInstancesByPolicyResponse$TrafficPolicyInstanceTypeMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>', 'ListTrafficPolicyInstancesRequest$TrafficPolicyInstanceTypeMarker' => '<p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.</p> <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>', 'ListTrafficPolicyInstancesResponse$TrafficPolicyInstanceTypeMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance that Amazon Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>', 'ResourceRecordSet$Type' => '<p>The DNS record type. For information about different record types and how data is encoded for them, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p>Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p> <p>Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>. When creating a group of weighted, latency, geolocation, or failover resource record sets, specify the same value for all of the resource record sets in the group.</p> <p>Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p> <note> <p>SPF records were formerly used to verify the identity of the sender of email messages. However, we no longer recommend that you create resource record sets for which the value of <code>Type</code> is <code>SPF</code>. RFC 7208, <i>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email, Version 1</i>, has been updated to say, "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it." In RFC 7208, see section 14.1, <a href="http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS Record Type</a>.</p> </note> <p>Values for alias resource record sets:</p> <ul> <li> <p> <b>CloudFront distributions:</b> <code>A</code> </p> <p>If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your distribution, one with a value of <code>A</code> and one with a value of <code>AAAA</code>. </p> </li> <li> <p> <b>AWS Elastic Beanstalk environment that has a regionalized subdomain</b>: <code>A</code> </p> </li> <li> <p> <b>ELB load balancers:</b> <code>A</code> | <code>AAAA</code> </p> </li> <li> <p> <b>Amazon S3 buckets:</b> <code>A</code> </p> </li> <li> <p> <b>Another resource record set in this hosted zone:</b> Specify the type of the resource record set that you\'re creating the alias for. All values are supported except <code>NS</code> and <code>SOA</code>.</p> </li> </ul>', 'TestDNSAnswerRequest$RecordType' => '<p>The type of the resource record set.</p>', 'TestDNSAnswerResponse$RecordType' => '<p>The type of the resource record set that you submitted a request for.</p>', 'TrafficPolicy$Type' => '<p>The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create a traffic policy instance.</p>', 'TrafficPolicyInstance$TrafficPolicyType' => '<p>The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this traffic policy instance. </p>', 'TrafficPolicySummary$Type' => '<p>The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create a traffic policy instance.</p>', ], ], 'RecordData' => [ 'base' => NULL, 'refs' => [ 'TestDNSAnswerResponse$RecordData' => '<p>A list that contains values that Amazon Route 53 returned for this resource record set.</p>', ], ], 'RecordDataEntry' => [ 'base' => '<p>A value that Amazon Route 53 returned for this resource record set. A <code>RecordDataEntry</code> element is one of the following:</p> <ul> <li> <p>For non-alias resource record sets, a <code>RecordDataEntry</code> element contains one value in the resource record set. If the resource record set contains multiple values, the response includes one <code>RecordDataEntry</code> element for each value.</p> </li> <li> <p>For multiple resource record sets that have the same name and type, which includes weighted, latency, geolocation, and failover, a <code>RecordDataEntry</code> element contains the value from the appropriate resource record set based on the request.</p> </li> <li> <p>For alias resource record sets that refer to AWS resources other than another resource record set, the <code>RecordDataEntry</code> element contains an IP address or a domain name for the AWS resource, depending on the type of resource.</p> </li> <li> <p>For alias resource record sets that refer to other resource record sets, a <code>RecordDataEntry</code> element contains one value from the referenced resource record set. If the referenced resource record set contains multiple values, the response includes one <code>RecordDataEntry</code> element for each value.</p> </li> </ul>', 'refs' => [ 'RecordData$member' => NULL, ], ], 'RequestInterval' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$RequestInterval' => '<p>The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health check request. Each Amazon Route 53 health checker makes requests at this interval.</p> <important> <p>You can\'t change the value of <code>RequestInterval</code> after you create a health check.</p> </important> <p>If you don\'t specify a value for <code>RequestInterval</code>, the default value is <code>30</code> seconds.</p>', ], ], 'ResourceDescription' => [ 'base' => NULL, 'refs' => [ 'ChangeBatch$Comment' => '<p> <i>Optional:</i> Any comments you want to include about a change batch request.</p>', 'ChangeInfo$Comment' => '<p>A complex type that describes change information about changes made to your hosted zone.</p> <p>This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed information about the change.</p>', 'HostedZoneConfig$Comment' => '<p>Any comments that you want to include about the hosted zone.</p>', 'UpdateHostedZoneCommentRequest$Comment' => '<p>The new comment for the hosted zone. If you don\'t specify a value for <code>Comment</code>, Amazon Route 53 deletes the existing value of the <code>Comment</code> element, if any.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'AliasTarget$HostedZoneId' => '<p> <i>Alias resource records sets only</i>: The value used depends on where you want to route traffic:</p> <dl> <dt>CloudFront distribution</dt> <dd> <p>Specify <code>Z2FDTNDATAQYW2</code>.</p> <note> <p>Alias resource record sets for CloudFront can\'t be created in a private zone.</p> </note> </dd> <dt>Elastic Beanstalk environment</dt> <dd> <p>Specify the hosted zone ID for the region in which you created the environment. The environment must have a regionalized subdomain. For a list of regions and the corresponding hosted zone IDs, see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#elasticbeanstalk_region">AWS Elastic Beanstalk</a> in the "AWS Regions and Endpoints" chapter of the <i>Amazon Web Services General Reference</i>.</p> </dd> <dt>ELB load balancer</dt> <dd> <p>Specify the value of the hosted zone ID for the load balancer. Use the following methods to get the hosted zone ID:</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#elb_region">Elastic Load Balancing</a> table in the "AWS Regions and Endpoints" chapter of the <i>Amazon Web Services General Reference</i>: Use the value in the "Amazon Route 53 Hosted Zone ID" column that corresponds with the region that you created your load balancer in.</p> </li> <li> <p> <b>AWS Management Console</b>: Go to the Amazon EC2 page, click <b>Load Balancers</b> in the navigation pane, select the load balancer, and get the value of the <b>Hosted zone</b> field on the <b>Description</b> tab.</p> </li> <li> <p> <b>Elastic Load Balancing API</b>: Use <code>DescribeLoadBalancers</code> to get the value of <code>CanonicalHostedZoneNameId</code>. For more information, see the applicable guide:</p> <ul> <li> <p>Classic Load Balancer: <a href="http://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> </p> </li> <li> <p>Application Load Balancer: <a href="http://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> </p> </li> </ul> </li> <li> <p> <b>AWS CLI</b>: Use <code> <a href="http://docs.aws.amazon.com/cli/latest/reference/elb/describe-load-balancers.html">describe-load-balancers</a> </code> to get the value of <code>CanonicalHostedZoneNameID</code>.</p> </li> </ul> </dd> <dt>An Amazon S3 bucket configured as a static website</dt> <dd> <p>Specify the hosted zone ID for the region that you created the bucket in. For more information about valid values, see the <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Amazon Simple Storage Service Website Endpoints</a> table in the "AWS Regions and Endpoints" chapter of the <i>Amazon Web Services General Reference</i>.</p> </dd> <dt>Another Amazon Route 53 resource record set in your hosted zone</dt> <dd> <p>Specify the hosted zone ID of your hosted zone. (An alias resource record set can\'t reference a resource record set in a different hosted zone.)</p> </dd> </dl>', 'AssociateVPCWithHostedZoneRequest$HostedZoneId' => '<p>The ID of the private hosted zone that you want to associate an Amazon VPC with.</p> <p>Note that you can\'t associate a VPC with a hosted zone that doesn\'t have an existing VPC association.</p>', 'ChangeInfo$Id' => '<p>The ID of the request.</p>', 'ChangeResourceRecordSetsRequest$HostedZoneId' => '<p>The ID of the hosted zone that contains the resource record sets that you want to change.</p>', 'CreateHostedZoneRequest$DelegationSetId' => '<p>If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to the reusable delegation set when you created it. For more information about reusable delegation sets, see <a>CreateReusableDelegationSet</a>.</p>', 'CreateReusableDelegationSetRequest$HostedZoneId' => '<p>If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted zone.</p>', 'CreateTrafficPolicyInstanceRequest$HostedZoneId' => '<p>The ID of the hosted zone in which you want Amazon Route 53 to create resource record sets by using the configuration in a traffic policy.</p>', 'CreateVPCAssociationAuthorizationRequest$HostedZoneId' => '<p>The ID of the private hosted zone that you want to authorize associating a VPC with.</p>', 'CreateVPCAssociationAuthorizationResponse$HostedZoneId' => '<p>The ID of the hosted zone that you authorized associating a VPC with.</p>', 'DelegationSet$Id' => '<p>The ID that Amazon Route 53 assigns to a reusable delegation set.</p>', 'DeleteHostedZoneRequest$Id' => '<p>The ID of the hosted zone you want to delete.</p>', 'DeleteReusableDelegationSetRequest$Id' => '<p>The ID of the reusable delegation set that you want to delete.</p>', 'DeleteVPCAssociationAuthorizationRequest$HostedZoneId' => '<p>When removing authorization to associate a VPC that was created by one AWS account with a hosted zone that was created with a different AWS account, the ID of the hosted zone.</p>', 'DisassociateVPCFromHostedZoneRequest$HostedZoneId' => '<p>The ID of the private hosted zone that you want to disassociate a VPC from.</p>', 'GetChangeRequest$Id' => '<p>The ID of the change batch request. The value that you specify here is the value that <code>ChangeResourceRecordSets</code> returned in the <code>Id</code> element when you submitted the request.</p>', 'GetHostedZoneRequest$Id' => '<p>The ID of the hosted zone that you want to get information about.</p>', 'GetReusableDelegationSetRequest$Id' => '<p>The ID of the reusable delegation set that you want to get a list of name servers for.</p>', 'HostedZone$Id' => '<p>The ID that Amazon Route 53 assigned to the hosted zone when you created it.</p>', 'ListHostedZonesByNameRequest$HostedZoneId' => '<p>(Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the <code>hostedzoneid</code> parameter.</p> <p>If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code> returns only the first <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code> hosted zones, submit another request to <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of <code>hostedzoneid</code>, specify the value of the <code>NextHostedZoneId</code> element from the previous response.</p>', 'ListHostedZonesByNameResponse$HostedZoneId' => '<p>The ID that Amazon Route 53 assigned to the hosted zone when you created it.</p>', 'ListHostedZonesByNameResponse$NextHostedZoneId' => '<p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code> identifies the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p> <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>', 'ListHostedZonesRequest$DelegationSetId' => '<p>If you\'re using reusable delegation sets and you want to list all of the hosted zones that are associated with a reusable delegation set, specify the ID of that reusable delegation set. </p>', 'ListResourceRecordSetsRequest$HostedZoneId' => '<p>The ID of the hosted zone that contains the resource record sets that you want to list.</p>', 'ListTrafficPolicyInstancesByHostedZoneRequest$HostedZoneId' => '<p>The ID of the hosted zone that you want to list traffic policy instances for.</p>', 'ListTrafficPolicyInstancesByPolicyRequest$HostedZoneIdMarker' => '<p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request. </p> <p>For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p> <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>', 'ListTrafficPolicyInstancesByPolicyResponse$HostedZoneIdMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted zone of the first traffic policy instance in the next group of traffic policy instances.</p>', 'ListTrafficPolicyInstancesRequest$HostedZoneIdMarker' => '<p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance in the next group of traffic policy instances.</p> <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>', 'ListTrafficPolicyInstancesResponse$HostedZoneIdMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted zone of the first traffic policy instance that Amazon Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>', 'ListVPCAssociationAuthorizationsRequest$HostedZoneId' => '<p>The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.</p>', 'ListVPCAssociationAuthorizationsResponse$HostedZoneId' => '<p>The ID of the hosted zone that you can associate the listed VPCs with.</p>', 'TestDNSAnswerRequest$HostedZoneId' => '<p>The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.</p>', 'TrafficPolicyInstance$HostedZoneId' => '<p>The ID of the hosted zone that Amazon Route 53 created resource record sets in.</p>', 'UpdateHostedZoneCommentRequest$Id' => '<p>The ID for the hosted zone that you want to update the comment for.</p>', ], ], 'ResourcePath' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$ResourcePath' => '<p>The path, if any, that you want Amazon Route 53 to request when performing health checks. The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example, the file /docs/route53-health-check.html. </p>', 'UpdateHealthCheckRequest$ResourcePath' => '<p>The path that you want Amazon Route 53 to request when performing health checks. The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example the file /docs/route53-health-check.html. </p> <p>Specify this value only if you want to change it.</p>', ], ], 'ResourceRecord' => [ 'base' => '<p>Information specific to the resource record.</p> <note> <p>If you\'re creating an alias resource record set, omit <code>ResourceRecord</code>.</p> </note>', 'refs' => [ 'ResourceRecords$member' => NULL, ], ], 'ResourceRecordSet' => [ 'base' => '<p>Information about the resource record set to create or delete.</p>', 'refs' => [ 'Change$ResourceRecordSet' => '<p>Information about the resource record set to create, delete, or update.</p>', 'ResourceRecordSets$member' => NULL, ], ], 'ResourceRecordSetFailover' => [ 'base' => NULL, 'refs' => [ 'ResourceRecordSet$Failover' => '<p> <i>Failover resource record sets only:</i> To configure failover, you add the <code>Failover</code> element to two resource record sets. For one resource record set, you specify <code>PRIMARY</code> as the value for <code>Failover</code>; for the other resource record set, you specify <code>SECONDARY</code>. In addition, you include the <code>HealthCheckId</code> element and specify the health check that you want Amazon Route 53 to perform for each resource record set.</p> <p>Except where noted, the following failover behaviors assume that you have included the <code>HealthCheckId</code> element in both resource record sets:</p> <ul> <li> <p>When the primary resource record set is healthy, Amazon Route 53 responds to DNS queries with the applicable value from the primary resource record set regardless of the health of the secondary resource record set.</p> </li> <li> <p>When the primary resource record set is unhealthy and the secondary resource record set is healthy, Amazon Route 53 responds to DNS queries with the applicable value from the secondary resource record set.</p> </li> <li> <p>When the secondary resource record set is unhealthy, Amazon Route 53 responds to DNS queries with the applicable value from the primary resource record set regardless of the health of the primary resource record set.</p> </li> <li> <p>If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the primary resource record set is unhealthy, Amazon Route 53 always responds to DNS queries with the applicable value from the secondary resource record set. This is true regardless of the health of the associated endpoint.</p> </li> </ul> <p>You can\'t create non-failover resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as failover resource record sets.</p> <p>For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code> element and set the value to true.</p> <p>For more information about configuring failover for Amazon Route 53, see the following topics in the <i>Amazon Route 53 Developer Guide</i>: </p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Amazon Route 53 Health Checks and DNS Failover</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a> </p> </li> </ul>', ], ], 'ResourceRecordSetIdentifier' => [ 'base' => NULL, 'refs' => [ 'ListResourceRecordSetsRequest$StartRecordIdentifier' => '<p> <i>Weighted resource record sets only:</i> If results were truncated for a given DNS name and type, specify the value of <code>NextRecordIdentifier</code> from the previous response to get the next resource record set that has the current DNS name and type.</p>', 'ListResourceRecordSetsResponse$NextRecordIdentifier' => '<p> <i>Weighted, latency, geolocation, and failover resource record sets only</i>: If results were truncated for a given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set that has the current DNS name and type.</p>', 'ResourceRecordSet$SetIdentifier' => '<p> <i>Weighted, Latency, Geo, and Failover resource record sets only:</i> An identifier that differentiates among multiple resource record sets that have the same combination of DNS name and type. The value of <code>SetIdentifier</code> must be unique for each resource record set that has the same combination of DNS name and type. Omit <code>SetIdentifier</code> for any other types of record sets.</p>', ], ], 'ResourceRecordSetMultiValueAnswer' => [ 'base' => NULL, 'refs' => [ 'ResourceRecordSet$MultiValueAnswer' => '<p> <i>Multivalue answer resource record sets only</i>: To route traffic approximately randomly to multiple resources, such as web servers, create one multivalue answer record for each resource and specify <code>true</code> for <code>MultiValueAnswer</code>. Note the following:</p> <ul> <li> <p>If you associate a health check with a multivalue answer resource record set, Amazon Route 53 responds to DNS queries with the corresponding IP address only when the health check is healthy.</p> </li> <li> <p>If you don\'t associate a health check with a multivalue answer record, Amazon Route 53 always considers the record to be healthy.</p> </li> <li> <p>Amazon Route 53 responds to DNS queries with up to eight healthy records; if you have eight or fewer healthy records, Amazon Route 53 responds to all DNS queries with all the healthy records.</p> </li> <li> <p>If you have more than eight healthy records, Amazon Route 53 responds to different DNS resolvers with different combinations of healthy records.</p> </li> <li> <p>When all records are unhealthy, Amazon Route 53 responds to DNS queries with up to eight unhealthy records.</p> </li> <li> <p>If a resource becomes unavailable after a resolver caches a response, client software typically tries another of the IP addresses in the response.</p> </li> </ul> <p>You can\'t create multivalue answer alias records.</p>', ], ], 'ResourceRecordSetRegion' => [ 'base' => NULL, 'refs' => [ 'ResourceRecordSet$Region' => '<p> <i>Latency-based resource record sets only:</i> The Amazon EC2 Region where you created the resource that this resource record set refers to. The resource typically is an AWS resource, such as an EC2 instance or an ELB load balancer, and is referred to by an IP address or a DNS domain name, depending on the record type.</p> <note> <p>Creating latency and latency alias resource record sets in private hosted zones is not supported.</p> </note> <p>When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency resource record sets, Amazon Route 53 selects the latency resource record set that has the lowest latency between the end user and the associated Amazon EC2 Region. Amazon Route 53 then returns the value that is associated with the selected resource record set.</p> <p>Note the following:</p> <ul> <li> <p>You can only specify one <code>ResourceRecord</code> per latency resource record set.</p> </li> <li> <p>You can only create one latency resource record set for each Amazon EC2 Region.</p> </li> <li> <p>You aren\'t required to create latency resource record sets for all Amazon EC2 Regions. Amazon Route 53 will choose the region with the best latency from among the regions that you create latency resource record sets for.</p> </li> <li> <p>You can\'t create non-latency resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as latency resource record sets.</p> </li> </ul>', ], ], 'ResourceRecordSetWeight' => [ 'base' => NULL, 'refs' => [ 'ResourceRecordSet$Weight' => '<p> <i>Weighted resource record sets only:</i> Among resource record sets that have the same combination of DNS name and type, a value that determines the proportion of DNS queries that Amazon Route 53 responds to using the current resource record set. Amazon Route 53 calculates the sum of the weights for the resource record sets that have the same combination of DNS name and type. Amazon Route 53 then responds to queries based on the ratio of a resource\'s weight to the total. Note the following:</p> <ul> <li> <p>You must specify a value for the <code>Weight</code> element for every weighted resource record set.</p> </li> <li> <p>You can only specify one <code>ResourceRecord</code> per weighted resource record set.</p> </li> <li> <p>You can\'t create latency, failover, or geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as weighted resource record sets.</p> </li> <li> <p>You can create a maximum of 100 weighted resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.</p> </li> <li> <p>For weighted (but not weighted alias) resource record sets, if you set <code>Weight</code> to <code>0</code> for a resource record set, Amazon Route 53 never responds to queries with the applicable value for that resource record set. However, if you set <code>Weight</code> to <code>0</code> for all resource record sets that have the same combination of DNS name and type, traffic is routed to all resources with equal probability.</p> <p>The effect of setting <code>Weight</code> to <code>0</code> is different when you associate health checks with weighted resource record sets. For more information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html">Options for Configuring Amazon Route 53 Active-Active and Active-Passive Failover</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> </li> </ul>', ], ], 'ResourceRecordSets' => [ 'base' => NULL, 'refs' => [ 'ListResourceRecordSetsResponse$ResourceRecordSets' => '<p>Information about multiple resource record sets.</p>', ], ], 'ResourceRecords' => [ 'base' => NULL, 'refs' => [ 'ResourceRecordSet$ResourceRecords' => '<p>Information about the resource records to act upon.</p> <note> <p>If you\'re creating an alias resource record set, omit <code>ResourceRecords</code>.</p> </note>', ], ], 'ResourceTagSet' => [ 'base' => '<p>A complex type containing a resource and its associated tags.</p>', 'refs' => [ 'ListTagsForResourceResponse$ResourceTagSet' => '<p>A <code>ResourceTagSet</code> containing tags associated with the specified resource.</p>', 'ResourceTagSetList$member' => NULL, ], ], 'ResourceTagSetList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourcesResponse$ResourceTagSets' => '<p>A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.</p>', ], ], 'ResourceURI' => [ 'base' => NULL, 'refs' => [ 'CreateHealthCheckResponse$Location' => '<p>The unique URL representing the new health check.</p>', 'CreateHostedZoneResponse$Location' => '<p>The unique URL representing the new hosted zone.</p>', 'CreateReusableDelegationSetResponse$Location' => '<p>The unique URL representing the new reusable delegation set.</p>', 'CreateTrafficPolicyInstanceResponse$Location' => '<p>A unique URL that represents a new traffic policy instance.</p>', 'CreateTrafficPolicyResponse$Location' => '<p>A unique URL that represents a new traffic policy.</p>', 'CreateTrafficPolicyVersionResponse$Location' => '<p>A unique URL that represents a new traffic policy version.</p>', ], ], 'SearchString' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$SearchString' => '<p>If the value of Type is <code>HTTP_STR_MATCH</code> or <code>HTTP_STR_MATCH</code>, the string that you want Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the response body, Amazon Route 53 considers the resource healthy.</p> <p>Amazon Route 53 considers case when searching for <code>SearchString</code> in the response body. </p>', 'UpdateHealthCheckRequest$SearchString' => '<p>If the value of <code>Type</code> is <code>HTTP_STR_MATCH</code> or <code>HTTP_STR_MATCH</code>, the string that you want Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the response body, Amazon Route 53 considers the resource healthy. (You can\'t change the value of <code>Type</code> when you update a health check.)</p>', ], ], 'Statistic' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmConfiguration$Statistic' => '<p>For the metric that the CloudWatch alarm is associated with, the statistic that is applied to the metric.</p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'StatusReport$Status' => '<p>A description of the status of the health check endpoint as reported by one of the Amazon Route 53 health checkers.</p>', ], ], 'StatusReport' => [ 'base' => '<p>A complex type that contains the status that one Amazon Route 53 health checker reports and the time of the health check.</p>', 'refs' => [ 'HealthCheckObservation$StatusReport' => '<p>A complex type that contains the last failure reason as reported by one Amazon Route 53 health checker and the time of the failed health check.</p>', ], ], 'SubnetMask' => [ 'base' => NULL, 'refs' => [ 'TestDNSAnswerRequest$EDNS0ClientSubnetMask' => '<p>If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of bits of the IP address that you want the checking tool to include in the DNS query. For example, if you specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.</p>', ], ], 'TTL' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficPolicyInstanceRequest$TTL' => '<p>(Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in the specified hosted zone.</p>', 'ResourceRecordSet$TTL' => '<p>The resource record cache time to live (TTL), in seconds. Note the following:</p> <ul> <li> <p>If you\'re creating or updating an alias resource record set, omit <code>TTL</code>. Amazon Route 53 uses the value of <code>TTL</code> for the alias target. </p> </li> <li> <p>If you\'re associating this resource record set with a health check (if you\'re adding a <code>HealthCheckId</code> element), we recommend that you specify a <code>TTL</code> of 60 seconds or less so clients respond quickly to changes in health status.</p> </li> <li> <p>All of the resource record sets in a group of weighted resource record sets must have the same value for <code>TTL</code>.</p> </li> <li> <p>If a group of weighted resource record sets includes one or more weighted alias resource record sets for which the alias target is an ELB load balancer, we recommend that you specify a <code>TTL</code> of 60 seconds for all of the non-alias weighted resource record sets that have the same name and type. Values other than 60 seconds (the TTL for load balancers) will change the effect of the values that you specify for <code>Weight</code>.</p> </li> </ul>', 'TrafficPolicyInstance$TTL' => '<p>The TTL that Amazon Route 53 assigned to all of the resource record sets that it created in the specified hosted zone.</p>', 'UpdateTrafficPolicyInstanceRequest$TTL' => '<p>The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.</p>', ], ], 'Tag' => [ 'base' => '<p>A complex type that contains information about a tag that you want to add or edit for the specified health check or hosted zone.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The value of <code>Key</code> depends on the operation that you want to perform:</p> <ul> <li> <p> <b>Add a tag to a health check or hosted zone</b>: <code>Key</code> is the name that you want to give the new tag.</p> </li> <li> <p> <b>Edit a tag</b>: <code>Key</code> is the name of the tag that you want to change the <code>Value</code> for.</p> </li> <li> <p> <b> Delete a key</b>: <code>Key</code> is the name of the tag you want to remove.</p> </li> <li> <p> <b>Give a name to a health check</b>: Edit the default <code>Name</code> tag. In the Amazon Route 53 console, the list of your health checks includes a <b>Name</b> column that lets you see the name that you\'ve given to each health check.</p> </li> </ul>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'ChangeTagsForResourceRequest$RemoveTagKeys' => '<p>A complex type that contains a list of the tags that you want to delete from the specified health check or hosted zone. You can specify up to 10 keys.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ChangeTagsForResourceRequest$AddTags' => '<p>A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone and/or the tags that you want to edit <code>Value</code> for.</p> <p>You can add a maximum of 10 tags to a health check or a hosted zone.</p>', 'ResourceTagSet$Tags' => '<p>The tags associated with the specified resource.</p>', ], ], 'TagResourceId' => [ 'base' => NULL, 'refs' => [ 'ChangeTagsForResourceRequest$ResourceId' => '<p>The ID of the resource for which you want to add, change, or delete tags.</p>', 'ListTagsForResourceRequest$ResourceId' => '<p>The ID of the resource for which you want to retrieve tags.</p>', 'ResourceTagSet$ResourceId' => '<p>The ID for the specified resource.</p>', 'TagResourceIdList$member' => NULL, ], ], 'TagResourceIdList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourcesRequest$ResourceIds' => '<p>A complex type that contains the ResourceId element for each resource for which you want to get a list of tags.</p>', ], ], 'TagResourceType' => [ 'base' => NULL, 'refs' => [ 'ChangeTagsForResourceRequest$ResourceType' => '<p>The type of the resource.</p> <ul> <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li> <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li> </ul>', 'ListTagsForResourceRequest$ResourceType' => '<p>The type of the resource.</p> <ul> <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li> <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li> </ul>', 'ListTagsForResourcesRequest$ResourceType' => '<p>The type of the resources.</p> <ul> <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li> <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li> </ul>', 'ResourceTagSet$ResourceType' => '<p>The type of the resource.</p> <ul> <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li> <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li> </ul>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of <code>Value</code> depends on the operation that you want to perform:</p> <ul> <li> <p> <b>Add a tag to a health check or hosted zone</b>: <code>Value</code> is the value that you want to give the new tag.</p> </li> <li> <p> <b>Edit a tag</b>: <code>Value</code> is the new value that you want to assign the tag.</p> </li> </ul>', ], ], 'TestDNSAnswerRequest' => [ 'base' => '<p>Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type. You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask. </p>', 'refs' => [], ], 'TestDNSAnswerResponse' => [ 'base' => '<p>A complex type that contains the response to a <code>TestDNSAnswer</code> request. </p>', 'refs' => [], ], 'Threshold' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmConfiguration$Threshold' => '<p>For the metric that the CloudWatch alarm is associated with, the value the metric is compared with.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The limit on the number of requests per second was exceeded.</p>', 'refs' => [], ], 'TimeStamp' => [ 'base' => NULL, 'refs' => [ 'ChangeInfo$SubmittedAt' => '<p>The date and time that the change request was submitted in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time (UTC). For example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751 UTC.</p>', 'StatusReport$CheckedTime' => '<p>The date and time that the health checker performed the health check in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time (UTC). For example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751 UTC.</p>', ], ], 'TooManyHealthChecks' => [ 'base' => '<p>You have reached the maximum number of active health checks for an AWS account. The default limit is 100. To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the AWS Support Center.</p>', 'refs' => [], ], 'TooManyHostedZones' => [ 'base' => '<p>This hosted zone can\'t be created because the hosted zone limit is exceeded. To request a limit increase, go to the Amazon Route 53 <a href="http://aws.amazon.com/route53-request/">Contact Us</a> page.</p>', 'refs' => [], ], 'TooManyTrafficPolicies' => [ 'base' => '<p>You\'ve created the maximum number of traffic policies that can be created for the current AWS account. You can request an increase to the limit on the <a href="http://aws.amazon.com/route53-request/">Contact Us</a> page.</p>', 'refs' => [], ], 'TooManyTrafficPolicyInstances' => [ 'base' => '<p>You\'ve created the maximum number of traffic policy instances that can be created for the current AWS account. You can request an increase to the limit on the <a href="http://aws.amazon.com/route53-request/">Contact Us</a> page.</p>', 'refs' => [], ], 'TooManyVPCAssociationAuthorizations' => [ 'base' => '<p>You\'ve created the maximum number of authorizations that can be created for the specified hosted zone. To authorize another VPC to be associated with the hosted zone, submit a <code>DeleteVPCAssociationAuthorization</code> request to remove an existing authorization. To get a list of existing authorizations, submit a <code>ListVPCAssociationAuthorizations</code> request.</p>', 'refs' => [], ], 'TrafficPolicies' => [ 'base' => NULL, 'refs' => [ 'ListTrafficPolicyVersionsResponse$TrafficPolicies' => '<p>A list that contains one <code>TrafficPolicy</code> element for each traffic policy version that is associated with the specified traffic policy.</p>', ], ], 'TrafficPolicy' => [ 'base' => '<p>A complex type that contains settings for a traffic policy.</p>', 'refs' => [ 'CreateTrafficPolicyResponse$TrafficPolicy' => '<p>A complex type that contains settings for the new traffic policy.</p>', 'CreateTrafficPolicyVersionResponse$TrafficPolicy' => '<p>A complex type that contains settings for the new version of the traffic policy.</p>', 'GetTrafficPolicyResponse$TrafficPolicy' => '<p>A complex type that contains settings for the specified traffic policy.</p>', 'TrafficPolicies$member' => NULL, 'UpdateTrafficPolicyCommentResponse$TrafficPolicy' => '<p>A complex type that contains settings for the specified traffic policy.</p>', ], ], 'TrafficPolicyAlreadyExists' => [ 'base' => '<p>A traffic policy that has the same value for <code>Name</code> already exists.</p>', 'refs' => [], ], 'TrafficPolicyComment' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficPolicyRequest$Comment' => '<p>(Optional) Any comments that you want to include about the traffic policy.</p>', 'CreateTrafficPolicyVersionRequest$Comment' => '<p>The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.</p>', 'TrafficPolicy$Comment' => '<p>The comment that you specify in the <code>CreateTrafficPolicy</code> request, if any.</p>', 'UpdateTrafficPolicyCommentRequest$Comment' => '<p>The new comment for the specified traffic policy and version.</p>', ], ], 'TrafficPolicyDocument' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficPolicyRequest$Document' => '<p>The definition of this traffic policy in JSON format. For more information, see <a href="http://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html">Traffic Policy Document Format</a>.</p>', 'CreateTrafficPolicyVersionRequest$Document' => '<p>The definition of this version of the traffic policy, in JSON format. You specified the JSON in the <code>CreateTrafficPolicyVersion</code> request. For more information about the JSON format, see <a>CreateTrafficPolicy</a>.</p>', 'TrafficPolicy$Document' => '<p>The definition of a traffic policy in JSON format. You specify the JSON document to use for a new traffic policy in the <code>CreateTrafficPolicy</code> request. For more information about the JSON format, see <a href="http://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html">Traffic Policy Document Format</a>.</p>', ], ], 'TrafficPolicyId' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficPolicyInstanceRequest$TrafficPolicyId' => '<p>The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>', 'CreateTrafficPolicyVersionRequest$Id' => '<p>The ID of the traffic policy for which you want to create a new version.</p>', 'DeleteTrafficPolicyRequest$Id' => '<p>The ID of the traffic policy that you want to delete.</p>', 'GetTrafficPolicyRequest$Id' => '<p>The ID of the traffic policy that you want to get information about.</p>', 'ListTrafficPoliciesRequest$TrafficPolicyIdMarker' => '<p>(Conditional) For your first request to <code>ListTrafficPolicies</code>, don\'t include the <code>TrafficPolicyIdMarker</code> parameter.</p> <p>If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code> returns only the first <code>MaxItems</code> traffic policies. To get the next group of policies, submit another request to <code>ListTrafficPolicies</code>. For the value of <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that was returned in the previous response.</p>', 'ListTrafficPoliciesResponse$TrafficPolicyIdMarker' => '<p>If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy in the next group of <code>MaxItems</code> traffic policies.</p>', 'ListTrafficPolicyInstancesByPolicyRequest$TrafficPolicyId' => '<p>The ID of the traffic policy for which you want to list traffic policy instances.</p>', 'ListTrafficPolicyVersionsRequest$Id' => '<p>Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.</p>', 'TrafficPolicy$Id' => '<p>The ID that Amazon Route 53 assigned to a traffic policy when you created it.</p>', 'TrafficPolicyInstance$TrafficPolicyId' => '<p>The ID of the traffic policy that Amazon Route 53 used to create resource record sets in the specified hosted zone.</p>', 'TrafficPolicySummary$Id' => '<p>The ID that Amazon Route 53 assigned to the traffic policy when you created it.</p>', 'UpdateTrafficPolicyCommentRequest$Id' => '<p>The value of <code>Id</code> for the traffic policy that you want to update the comment for.</p>', 'UpdateTrafficPolicyInstanceRequest$TrafficPolicyId' => '<p>The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>', ], ], 'TrafficPolicyInUse' => [ 'base' => '<p>One or more traffic policy instances were created by using the specified traffic policy.</p>', 'refs' => [], ], 'TrafficPolicyInstance' => [ 'base' => '<p>A complex type that contains settings for the new traffic policy instance.</p>', 'refs' => [ 'CreateTrafficPolicyInstanceResponse$TrafficPolicyInstance' => '<p>A complex type that contains settings for the new traffic policy instance.</p>', 'GetTrafficPolicyInstanceResponse$TrafficPolicyInstance' => '<p>A complex type that contains settings for the traffic policy instance.</p>', 'TrafficPolicyInstances$member' => NULL, 'UpdateTrafficPolicyInstanceResponse$TrafficPolicyInstance' => '<p>A complex type that contains settings for the updated traffic policy instance.</p>', ], ], 'TrafficPolicyInstanceAlreadyExists' => [ 'base' => '<p>Traffic policy instance with given Id already exists.</p>', 'refs' => [], ], 'TrafficPolicyInstanceCount' => [ 'base' => NULL, 'refs' => [ 'GetTrafficPolicyInstanceCountResponse$TrafficPolicyInstanceCount' => '<p>The number of traffic policy instances that are associated with the current AWS account.</p>', ], ], 'TrafficPolicyInstanceId' => [ 'base' => NULL, 'refs' => [ 'DeleteTrafficPolicyInstanceRequest$Id' => '<p>The ID of the traffic policy instance that you want to delete. </p> <important> <p>When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets that were created when you created the traffic policy instance.</p> </important>', 'GetTrafficPolicyInstanceRequest$Id' => '<p>The ID of the traffic policy instance that you want to get information about.</p>', 'ResourceRecordSet$TrafficPolicyInstanceId' => '<p>When you create a traffic policy instance, Amazon Route 53 automatically creates a resource record set. <code>TrafficPolicyInstanceId</code> is the ID of the traffic policy instance that Amazon Route 53 created this resource record set for.</p> <important> <p>To delete the resource record set that is associated with a traffic policy instance, use <code>DeleteTrafficPolicyInstance</code>. Amazon Route 53 will delete the resource record set automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Amazon Route 53 doesn\'t automatically delete the traffic policy instance, and you\'ll continue to be charged for it even though it\'s no longer in use. </p> </important>', 'TrafficPolicyInstance$Id' => '<p>The ID that Amazon Route 53 assigned to the new traffic policy instance.</p>', 'UpdateTrafficPolicyInstanceRequest$Id' => '<p>The ID of the traffic policy instance that you want to update.</p>', ], ], 'TrafficPolicyInstanceState' => [ 'base' => NULL, 'refs' => [ 'TrafficPolicyInstance$State' => '<p>The value of <code>State</code> is one of the following values:</p> <dl> <dt>Applied</dt> <dd> <p>Amazon Route 53 has finished creating resource record sets, and changes have propagated to all Amazon Route 53 edge locations.</p> </dd> <dt>Creating</dt> <dd> <p>Amazon Route 53 is creating the resource record sets. Use <code>GetTrafficPolicyInstance</code> to confirm that the <code>CreateTrafficPolicyInstance</code> request completed successfully.</p> </dd> <dt>Failed</dt> <dd> <p>Amazon Route 53 wasn\'t able to create or update the resource record sets. When the value of <code>State</code> is <code>Failed</code>, see <code>Message</code> for an explanation of what caused the request to fail.</p> </dd> </dl>', ], ], 'TrafficPolicyInstances' => [ 'base' => NULL, 'refs' => [ 'ListTrafficPolicyInstancesByHostedZoneResponse$TrafficPolicyInstances' => '<p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request. </p>', 'ListTrafficPolicyInstancesByPolicyResponse$TrafficPolicyInstances' => '<p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request.</p>', 'ListTrafficPolicyInstancesResponse$TrafficPolicyInstances' => '<p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request.</p>', ], ], 'TrafficPolicyName' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficPolicyRequest$Name' => '<p>The name of the traffic policy.</p>', 'TrafficPolicy$Name' => '<p>The name that you specified when you created the traffic policy.</p>', 'TrafficPolicySummary$Name' => '<p>The name that you specified for the traffic policy when you created it.</p>', ], ], 'TrafficPolicySummaries' => [ 'base' => NULL, 'refs' => [ 'ListTrafficPoliciesResponse$TrafficPolicySummaries' => '<p>A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was created by the current AWS account.</p>', ], ], 'TrafficPolicySummary' => [ 'base' => '<p>A complex type that contains information about the latest version of one traffic policy that is associated with the current AWS account.</p>', 'refs' => [ 'TrafficPolicySummaries$member' => NULL, ], ], 'TrafficPolicyVersion' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficPolicyInstanceRequest$TrafficPolicyVersion' => '<p>The version of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>', 'DeleteTrafficPolicyRequest$Version' => '<p>The version number of the traffic policy that you want to delete.</p>', 'GetTrafficPolicyRequest$Version' => '<p>The version number of the traffic policy that you want to get information about.</p>', 'ListTrafficPolicyInstancesByPolicyRequest$TrafficPolicyVersion' => '<p>The version of the traffic policy for which you want to list traffic policy instances. The version must be associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.</p>', 'TrafficPolicy$Version' => '<p>The version number that Amazon Route 53 assigns to a traffic policy. For a new traffic policy, the value of <code>Version</code> is always 1.</p>', 'TrafficPolicyInstance$TrafficPolicyVersion' => '<p>The version of the traffic policy that Amazon Route 53 used to create resource record sets in the specified hosted zone.</p>', 'TrafficPolicySummary$LatestVersion' => '<p>The version number of the latest version of the traffic policy.</p>', 'TrafficPolicySummary$TrafficPolicyCount' => '<p>The number of traffic policies that are associated with the current AWS account.</p>', 'UpdateTrafficPolicyCommentRequest$Version' => '<p>The value of <code>Version</code> for the traffic policy that you want to update the comment for.</p>', 'UpdateTrafficPolicyInstanceRequest$TrafficPolicyVersion' => '<p>The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>', ], ], 'TrafficPolicyVersionMarker' => [ 'base' => NULL, 'refs' => [ 'ListTrafficPolicyVersionsRequest$TrafficPolicyVersionMarker' => '<p>For your first request to <code>ListTrafficPolicyVersions</code>, don\'t include the <code>TrafficPolicyVersionMarker</code> parameter.</p> <p>If you have more traffic policy versions than the value of <code>MaxItems</code>, <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions. To get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request. For the value of <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the previous response.</p>', 'ListTrafficPolicyVersionsResponse$TrafficPolicyVersionMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>TrafficPolicyVersionMarker</code> identifies the first traffic policy that Amazon Route 53 will return if you submit another request. Call <code>ListTrafficPolicyVersions</code> again and specify the value of <code>TrafficPolicyVersionMarker</code> in the <code>TrafficPolicyVersionMarker</code> request parameter.</p> <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>', ], ], 'TransportProtocol' => [ 'base' => NULL, 'refs' => [ 'TestDNSAnswerResponse$Protocol' => '<p>The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or <code>TCP</code>. </p>', ], ], 'UpdateHealthCheckRequest' => [ 'base' => '<p>A complex type that contains information about a request to update a health check.</p>', 'refs' => [], ], 'UpdateHealthCheckResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateHostedZoneCommentRequest' => [ 'base' => '<p>A request to update the comment for a hosted zone.</p>', 'refs' => [], ], 'UpdateHostedZoneCommentResponse' => [ 'base' => '<p>A complex type that contains the response to the <code>UpdateHostedZoneComment</code> request.</p>', 'refs' => [], ], 'UpdateTrafficPolicyCommentRequest' => [ 'base' => '<p>A complex type that contains information about the traffic policy that you want to update the comment for.</p>', 'refs' => [], ], 'UpdateTrafficPolicyCommentResponse' => [ 'base' => '<p>A complex type that contains the response information for the traffic policy.</p>', 'refs' => [], ], 'UpdateTrafficPolicyInstanceRequest' => [ 'base' => '<p>A complex type that contains information about the resource record sets that you want to update based on a specified traffic policy instance.</p>', 'refs' => [], ], 'UpdateTrafficPolicyInstanceResponse' => [ 'base' => '<p>A complex type that contains information about the resource record sets that Amazon Route 53 created based on a specified traffic policy.</p>', 'refs' => [], ], 'VPC' => [ 'base' => '<p>(Private hosted zones only) A complex type that contains information about an Amazon VPC.</p>', 'refs' => [ 'AssociateVPCWithHostedZoneRequest$VPC' => '<p>A complex type that contains information about the VPC that you want to associate with a private hosted zone.</p>', 'CreateHostedZoneRequest$VPC' => '<p>(Private hosted zones only) A complex type that contains information about the Amazon VPC that you\'re associating with this hosted zone.</p> <p>You can specify only one Amazon VPC when you create a private hosted zone. To associate additional Amazon VPCs with the hosted zone, use <a>AssociateVPCWithHostedZone</a> after you create a hosted zone.</p>', 'CreateHostedZoneResponse$VPC' => '<p>A complex type that contains information about an Amazon VPC that you associated with this hosted zone.</p>', 'CreateVPCAssociationAuthorizationRequest$VPC' => '<p>A complex type that contains the VPC ID and region for the VPC that you want to authorize associating with your hosted zone.</p>', 'CreateVPCAssociationAuthorizationResponse$VPC' => '<p>The VPC that you authorized associating with a hosted zone.</p>', 'DeleteVPCAssociationAuthorizationRequest$VPC' => '<p>When removing authorization to associate a VPC that was created by one AWS account with a hosted zone that was created with a different AWS account, a complex type that includes the ID and region of the VPC.</p>', 'DisassociateVPCFromHostedZoneRequest$VPC' => '<p>A complex type that contains information about the VPC that you\'re disassociating from the specified hosted zone.</p>', 'VPCs$member' => NULL, ], ], 'VPCAssociationAuthorizationNotFound' => [ 'base' => '<p>The VPC that you specified is not authorized to be associated with the hosted zone.</p>', 'refs' => [], ], 'VPCAssociationNotFound' => [ 'base' => '<p>The specified VPC and hosted zone are not currently associated.</p>', 'refs' => [], ], 'VPCId' => [ 'base' => '<p>(Private hosted zones only) The ID of an Amazon VPC. </p>', 'refs' => [ 'VPC$VPCId' => NULL, ], ], 'VPCRegion' => [ 'base' => NULL, 'refs' => [ 'VPC$VPCRegion' => '<p>(Private hosted zones only) The region in which you created an Amazon VPC.</p>', ], ], 'VPCs' => [ 'base' => '<p>(Private hosted zones only) A list of <code>VPC</code> elements.</p>', 'refs' => [ 'GetHostedZoneResponse$VPCs' => '<p>A complex type that contains information about the VPCs that are associated with the specified hosted zone.</p>', 'ListVPCAssociationAuthorizationsResponse$VPCs' => '<p>The list of VPCs that are authorized to be associated with the specified hosted zone.</p>', ], ], ],];
