<?php
// This file was auto-generated from sdk-root/src/data/route53domains/2014-05-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Route 53 API actions let you register domain names and perform related operations.</p>', 'operations' => [ 'CheckDomainAvailability' => '<p>This operation checks the availability of one domain name. Note that if the availability status of a domain is pending, you must submit another request to determine the availability of the domain name.</p>', 'DeleteTagsForDomain' => '<p>This operation deletes the specified tags for a domain.</p> <p>All tag operations are eventually consistent; subsequent operations may not immediately represent all issued operations.</p>', 'DisableDomainAutoRenew' => '<p>This operation disables automatic renewal of domain registration for the specified domain.</p>', 'DisableDomainTransferLock' => '<p>This operation removes the transfer lock on the domain (specifically the <code>clientTransferProhibited</code> status) to allow domain transfers. We recommend you refrain from performing this action unless you intend to transfer the domain to a different registrar. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.</p>', 'EnableDomainAutoRenew' => '<p>This operation configures Amazon Route 53 to automatically renew the specified domain before the domain registration expires. The cost of renewing your domain registration is billed to your AWS account.</p> <p>The period during which you can renew a domain name varies by TLD. For a list of TLDs and their renewal policies, see <a href="http://wiki.gandi.net/en/domains/renew#renewal_restoration_and_deletion_times">"Renewal, restoration, and deletion times"</a> on the website for our registrar partner, Gandi. Route 53 requires that you renew before the end of the renewal period that is listed on the Gandi website so we can complete processing before the deadline.</p>', 'EnableDomainTransferLock' => '<p>This operation sets the transfer lock on the domain (specifically the <code>clientTransferProhibited</code> status) to prevent domain transfers. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.</p>', 'GetContactReachabilityStatus' => '<p>For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation returns information about whether the registrant contact has responded.</p> <p>If you want us to resend the email, use the <code>ResendContactReachabilityEmail</code> operation.</p>', 'GetDomainDetail' => '<p>This operation returns detailed information about a specified domain that is associated with the current AWS account. Contact information for the domain is also returned as part of the output.</p>', 'GetDomainSuggestions' => '<p>The GetDomainSuggestions operation returns a list of suggested domain names given a string, which can either be a domain name or simply a word or phrase (without spaces).</p>', 'GetOperationDetail' => '<p>This operation returns the current status of an operation that is not completed.</p>', 'ListDomains' => '<p>This operation returns all the domain names registered with Amazon Route 53 for the current AWS account.</p>', 'ListOperations' => '<p>This operation returns the operation IDs of operations that are not yet complete.</p>', 'ListTagsForDomain' => '<p>This operation returns all of the tags that are associated with the specified domain.</p> <p>All tag operations are eventually consistent; subsequent operations may not immediately represent all issued operations.</p>', 'RegisterDomain' => '<p>This operation registers a domain. Domains are registered by the AWS registrar partner, Gandi. For some top-level domains (TLDs), this operation requires extra parameters.</p> <p>When you register a domain, Amazon Route 53 does the following:</p> <ul> <li> <p>Creates a Amazon Route 53 hosted zone that has the same name as the domain. Amazon Route 53 assigns four name servers to your hosted zone and automatically updates your domain registration with the names of these name servers.</p> </li> <li> <p>Enables autorenew, so your domain registration will renew automatically each year. We\'ll notify you in advance of the renewal date so you can choose whether to renew the registration.</p> </li> <li> <p>Optionally enables privacy protection, so WHOIS queries return contact information for our registrar partner, Gandi, instead of the information you entered for registrant, admin, and tech contacts.</p> </li> <li> <p>If registration is successful, returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant is notified by email.</p> </li> <li> <p>Charges your AWS account an amount based on the top-level domain. For more information, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p> </li> </ul>', 'RenewDomain' => '<p>This operation renews a domain for the specified number of years. The cost of renewing your domain is billed to your AWS account.</p> <p>We recommend that you renew your domain several weeks before the expiration date. Some TLD registries delete domains before the expiration date if you haven\'t renewed far enough in advance. For more information about renewing domain registration, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-renew.html">Renewing Registration for a Domain</a> in the Amazon Route 53 Developer Guide.</p>', 'ResendContactReachabilityEmail' => '<p>For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation resends the confirmation email to the current email address for the registrant contact.</p>', 'RetrieveDomainAuthCode' => '<p>This operation returns the AuthCode for the domain. To transfer a domain to another registrar, you provide this value to the new registrar.</p>', 'TransferDomain' => '<p>This operation transfers a domain from another registrar to Amazon Route 53. When the transfer is complete, the domain is registered with the AWS registrar partner, Gandi.</p> <p>For transfer requirements, a detailed procedure, and information about viewing the status of a domain transfer, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-to-route-53.html">Transferring Registration for a Domain to Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p>If the registrar for your domain is also the DNS service provider for the domain, we highly recommend that you consider transferring your DNS service to Amazon Route 53 or to another DNS service provider before you transfer your registration. Some registrars provide free DNS service when you purchase a domain registration. When you transfer the registration, the previous registrar will not renew your domain registration and could end your DNS service at any time.</p> <important> <p>If the registrar for your domain is also the DNS service provider for the domain and you don\'t transfer DNS service to another provider, your website, email, and the web applications associated with the domain might become unavailable.</p> </important> <p>If the transfer is successful, this method returns an operation ID that you can use to track the progress and completion of the action. If the transfer doesn\'t complete successfully, the domain registrant will be notified by email.</p>', 'UpdateDomainContact' => '<p>This operation updates the contact information for a particular domain. Information for at least one contact (registrant, administrator, or technical) must be supplied for update.</p> <p>If the update is successful, this method returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.</p>', 'UpdateDomainContactPrivacy' => '<p>This operation updates the specified domain contact\'s privacy setting. When the privacy option is enabled, personal information such as postal or email address is hidden from the results of a public WHOIS query. The privacy services are provided by the AWS registrar, Gandi. For more information, see the <a href="http://www.gandi.net/domain/whois/?currency=USD&amp;amp;lang=en">Gandi privacy features</a>.</p> <p>This operation only affects the privacy of the specified contact type (registrant, administrator, or tech). Successful acceptance returns an operation ID that you can use with <a>GetOperationDetail</a> to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.</p>', 'UpdateDomainNameservers' => '<p>This operation replaces the current set of name servers for the domain with the specified set of name servers. If you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted zone for the domain.</p> <p>If successful, this operation returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.</p>', 'UpdateTagsForDomain' => '<p>This operation adds or updates tags for a specified domain.</p> <p>All tag operations are eventually consistent; subsequent operations may not immediately represent all issued operations.</p>', 'ViewBilling' => '<p>Returns all the domain-related billing records for the current AWS account for a specified period</p>', ], 'shapes' => [ 'AddressLine' => [ 'base' => NULL, 'refs' => [ 'ContactDetail$AddressLine1' => '<p>First line of the contact\'s address.</p>', 'ContactDetail$AddressLine2' => '<p>Second line of contact\'s address, if any.</p>', ], ], 'BillingRecord' => [ 'base' => '<p>Information for one billing record.</p>', 'refs' => [ 'BillingRecords$member' => NULL, ], ], 'BillingRecords' => [ 'base' => NULL, 'refs' => [ 'ViewBillingResponse$BillingRecords' => '<p>A summary of billing records.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'DomainSummary$AutoRenew' => '<p>Indicates whether the domain is automatically renewed upon expiration.</p>', 'DomainSummary$TransferLock' => '<p>Indicates whether a domain is locked from unauthorized transfer to another party.</p>', 'GetDomainDetailResponse$AutoRenew' => '<p>Specifies whether the domain registration is set to renew automatically.</p>', 'GetDomainDetailResponse$AdminPrivacy' => '<p>Specifies whether contact information for the admin contact is concealed from WHOIS queries. If the value is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact information that you enter.</p>', 'GetDomainDetailResponse$RegistrantPrivacy' => '<p>Specifies whether contact information for the registrant contact is concealed from WHOIS queries. If the value is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact information that you enter.</p>', 'GetDomainDetailResponse$TechPrivacy' => '<p>Specifies whether contact information for the tech contact is concealed from WHOIS queries. If the value is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact information that you enter.</p>', 'GetDomainSuggestionsRequest$OnlyAvailable' => '<p>If <code>OnlyAvailable</code> is <code>true</code>, Amazon Route 53 returns only domain names that are available. If <code>OnlyAvailable</code> is <code>false</code>, Amazon Route 53 returns domain names without checking whether they\'re available to be registered. To determine whether the domain is available, you can call <code>checkDomainAvailability</code> for each suggestion.</p>', 'RegisterDomainRequest$AutoRenew' => '<p>Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>). Autorenewal only takes effect after the account is charged.</p> <p>Default: <code>true</code> </p>', 'RegisterDomainRequest$PrivacyProtectAdminContact' => '<p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact information that you enter.</p> <p>Default: <code>true</code> </p>', 'RegisterDomainRequest$PrivacyProtectRegistrantContact' => '<p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact information that you enter.</p> <p>Default: <code>true</code> </p>', 'RegisterDomainRequest$PrivacyProtectTechContact' => '<p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact information that you enter.</p> <p>Default: <code>true</code> </p>', 'ResendContactReachabilityEmailResponse$isAlreadyVerified' => '<p> <code>True</code> if the email address for the registrant contact has already been verified, and <code>false</code> otherwise. If the email address has already been verified, we don\'t send another confirmation email.</p>', 'TransferDomainRequest$AutoRenew' => '<p>Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect after the account is charged.</p> <p>Default: true</p>', 'TransferDomainRequest$PrivacyProtectAdminContact' => '<p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact information that you enter.</p> <p>Default: <code>true</code> </p>', 'TransferDomainRequest$PrivacyProtectRegistrantContact' => '<p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact information that you enter.</p> <p>Default: <code>true</code> </p>', 'TransferDomainRequest$PrivacyProtectTechContact' => '<p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact information that you enter.</p> <p>Default: <code>true</code> </p>', 'UpdateDomainContactPrivacyRequest$AdminPrivacy' => '<p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact information that you enter.</p>', 'UpdateDomainContactPrivacyRequest$RegistrantPrivacy' => '<p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact information that you enter.</p>', 'UpdateDomainContactPrivacyRequest$TechPrivacy' => '<p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact information that you enter.</p>', ], ], 'CheckDomainAvailabilityRequest' => [ 'base' => '<p>The CheckDomainAvailability request contains the following elements.</p>', 'refs' => [], ], 'CheckDomainAvailabilityResponse' => [ 'base' => '<p>The CheckDomainAvailability response includes the following elements.</p>', 'refs' => [], ], 'City' => [ 'base' => NULL, 'refs' => [ 'ContactDetail$City' => '<p>The city of the contact\'s address.</p>', ], ], 'ContactDetail' => [ 'base' => '<p>ContactDetail includes the following elements.</p>', 'refs' => [ 'GetDomainDetailResponse$AdminContact' => '<p>Provides details about the domain administrative contact.</p>', 'GetDomainDetailResponse$RegistrantContact' => '<p>Provides details about the domain registrant.</p>', 'GetDomainDetailResponse$TechContact' => '<p>Provides details about the domain technical contact.</p>', 'RegisterDomainRequest$AdminContact' => '<p>Provides detailed contact information.</p>', 'RegisterDomainRequest$RegistrantContact' => '<p>Provides detailed contact information.</p>', 'RegisterDomainRequest$TechContact' => '<p>Provides detailed contact information.</p>', 'TransferDomainRequest$AdminContact' => '<p>Provides detailed contact information.</p>', 'TransferDomainRequest$RegistrantContact' => '<p>Provides detailed contact information.</p>', 'TransferDomainRequest$TechContact' => '<p>Provides detailed contact information.</p>', 'UpdateDomainContactRequest$AdminContact' => '<p>Provides detailed contact information.</p>', 'UpdateDomainContactRequest$RegistrantContact' => '<p>Provides detailed contact information.</p>', 'UpdateDomainContactRequest$TechContact' => '<p>Provides detailed contact information.</p>', ], ], 'ContactName' => [ 'base' => NULL, 'refs' => [ 'ContactDetail$FirstName' => '<p>First name of contact.</p>', 'ContactDetail$LastName' => '<p>Last name of contact.</p>', 'ContactDetail$OrganizationName' => '<p>Name of the organization for contact types other than <code>PERSON</code>.</p>', ], ], 'ContactNumber' => [ 'base' => NULL, 'refs' => [ 'ContactDetail$PhoneNumber' => '<p>The phone number of the contact.</p> <p>Constraints: Phone number must be specified in the format "+[country dialing code].[number including any area code&gt;]". For example, a US phone number might appear as <code>"+1.1234567890"</code>.</p>', 'ContactDetail$Fax' => '<p>Fax number of the contact.</p> <p>Constraints: Phone number must be specified in the format "+[country dialing code].[number including any area code]". For example, a US phone number might appear as <code>"+1.1234567890"</code>.</p>', 'GetDomainDetailResponse$AbuseContactPhone' => '<p>Phone number for reporting abuse.</p>', ], ], 'ContactType' => [ 'base' => NULL, 'refs' => [ 'ContactDetail$ContactType' => '<p>Indicates whether the contact is a person, company, association, or public organization. If you choose an option other than <code>PERSON</code>, you must enter an organization name, and you can\'t enable privacy protection for the contact.</p>', ], ], 'CountryCode' => [ 'base' => NULL, 'refs' => [ 'ContactDetail$CountryCode' => '<p>Code for the country of the contact\'s address.</p>', ], ], 'CurrentExpiryYear' => [ 'base' => NULL, 'refs' => [ 'RenewDomainRequest$CurrentExpiryYear' => '<p>The year when the registration for the domain is set to expire. This value must match the current expiration date for the domain.</p>', ], ], 'DNSSec' => [ 'base' => NULL, 'refs' => [ 'GetDomainDetailResponse$DnsSec' => '<p>Reserved for future use.</p>', ], ], 'DeleteTagsForDomainRequest' => [ 'base' => '<p>The DeleteTagsForDomainRequest includes the following elements.</p>', 'refs' => [], ], 'DeleteTagsForDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisableDomainAutoRenewRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableDomainAutoRenewResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisableDomainTransferLockRequest' => [ 'base' => '<p>The DisableDomainTransferLock request includes the following element.</p>', 'refs' => [], ], 'DisableDomainTransferLockResponse' => [ 'base' => '<p>The DisableDomainTransferLock response includes the following element.</p>', 'refs' => [], ], 'DomainAuthCode' => [ 'base' => NULL, 'refs' => [ 'RetrieveDomainAuthCodeResponse$AuthCode' => '<p>The authorization code for the domain.</p>', 'TransferDomainRequest$AuthCode' => '<p>The authorization code for the domain. You get this value from the current registrar.</p>', ], ], 'DomainAvailability' => [ 'base' => NULL, 'refs' => [ 'CheckDomainAvailabilityResponse$Availability' => '<p>Whether the domain name is available for registering.</p> <note> <p>You can only register domains designated as <code>AVAILABLE</code>.</p> </note> <p>Valid values:</p> <dl> <dt>AVAILABLE</dt> <dd> <p>The domain name is available.</p> </dd> <dt>AVAILABLE_RESERVED</dt> <dd> <p>The domain name is reserved under specific conditions.</p> </dd> <dt>AVAILABLE_PREORDER</dt> <dd> <p>The domain name is available and can be preordered.</p> </dd> <dt>DONT_KNOW</dt> <dd> <p>The TLD registry didn\'t reply with a definitive answer about whether the domain name is available. Amazon Route 53 can return this response for a variety of reasons, for example, the registry is performing maintenance. Try again later.</p> </dd> <dt>PENDING</dt> <dd> <p>The TLD registry didn\'t return a response in the expected amount of time. When the response is delayed, it usually takes just a few extra seconds. You can resubmit the request immediately.</p> </dd> <dt>RESERVED</dt> <dd> <p>The domain name has been reserved for another person or organization.</p> </dd> <dt>UNAVAILABLE</dt> <dd> <p>The domain name is not available.</p> </dd> <dt>UNAVAILABLE_PREMIUM</dt> <dd> <p>The domain name is not available.</p> </dd> <dt>UNAVAILABLE_RESTRICTED</dt> <dd> <p>The domain name is forbidden.</p> </dd> </dl>', ], ], 'DomainLimitExceeded' => [ 'base' => '<p>The number of domains has exceeded the allowed threshold for the account.</p>', 'refs' => [], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'BillingRecord$DomainName' => '<p>The name of the domain that the billing record applies to. If the domain name contains characters other than a-z, 0-9, and - (hyphen), such as an internationalized domain name, then this value is in Punycode. For more information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a> in the <i>Amazon Route 53 Developer Guidezzz</i>.</p>', 'CheckDomainAvailabilityRequest$DomainName' => '<p>The name of the domain that you want to get availability for.</p> <p>Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not supported.</p>', 'DeleteTagsForDomainRequest$DomainName' => '<p>The domain for which you want to delete one or more tags.</p>', 'DisableDomainAutoRenewRequest$DomainName' => '<p>The name of the domain that you want to disable automatic renewal for.</p>', 'DisableDomainTransferLockRequest$DomainName' => '<p>The name of the domain that you want to remove the transfer lock for.</p>', 'DomainSuggestion$DomainName' => '<p>A suggested domain name.</p>', 'DomainSummary$DomainName' => '<p>The name of the domain that the summary information applies to.</p>', 'EnableDomainAutoRenewRequest$DomainName' => '<p>The name of the domain that you want to enable automatic renewal for.</p>', 'EnableDomainTransferLockRequest$DomainName' => '<p>The name of the domain that you want to set the transfer lock for.</p>', 'GetContactReachabilityStatusRequest$domainName' => '<p>The name of the domain for which you want to know whether the registrant contact has confirmed that the email address is valid.</p>', 'GetContactReachabilityStatusResponse$domainName' => '<p>The domain name for which you requested the reachability status.</p>', 'GetDomainDetailRequest$DomainName' => '<p>The name of the domain that you want to get detailed information about.</p>', 'GetDomainDetailResponse$DomainName' => '<p>The name of a domain.</p>', 'GetDomainSuggestionsRequest$DomainName' => '<p>A domain name that you want to use as the basis for a list of possible domain names. The domain name must contain a top-level domain (TLD), such as .com, that Amazon Route 53 supports. For a list of TLDs, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>', 'GetOperationDetailResponse$DomainName' => '<p>The name of a domain.</p>', 'ListTagsForDomainRequest$DomainName' => '<p>The domain for which you want to get a list of tags.</p>', 'RegisterDomainRequest$DomainName' => '<p>The domain name that you want to register.</p> <p>Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not supported.</p>', 'RenewDomainRequest$DomainName' => '<p>The name of the domain that you want to renew.</p>', 'ResendContactReachabilityEmailRequest$domainName' => '<p>The name of the domain for which you want Amazon Route 53 to resend a confirmation email to the registrant contact.</p>', 'ResendContactReachabilityEmailResponse$domainName' => '<p>The domain name for which you requested a confirmation email.</p>', 'RetrieveDomainAuthCodeRequest$DomainName' => '<p>The name of the domain that you want to get an authorization code for.</p>', 'TransferDomainRequest$DomainName' => '<p>The name of the domain that you want to transfer to Amazon Route 53.</p> <p>Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not supported.</p>', 'UpdateDomainContactPrivacyRequest$DomainName' => '<p>The name of the domain that you want to update the privacy setting for.</p>', 'UpdateDomainContactRequest$DomainName' => '<p>The name of the domain that you want to update contact information for.</p>', 'UpdateDomainNameserversRequest$DomainName' => '<p>The name of the domain that you want to change name servers for.</p>', 'UpdateTagsForDomainRequest$DomainName' => '<p>The domain for which you want to add or update tags.</p>', ], ], 'DomainStatus' => [ 'base' => NULL, 'refs' => [ 'DomainStatusList$member' => NULL, ], ], 'DomainStatusList' => [ 'base' => NULL, 'refs' => [ 'GetDomainDetailResponse$StatusList' => '<p>An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.</p> <p>ICANN, the organization that maintains a central database of domain names, has developed a set of domain name status codes that tell you the status of a variety of operations on a domain name, for example, registering a domain name, transferring a domain name to another registrar, renewing the registration for a domain name, and so on. All registrars use this same set of status codes.</p> <p>For a current list of domain name status codes and an explanation of what each code means, go to the <a href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on the ICANN website; web searches sometimes return an old version of the document.)</p>', ], ], 'DomainSuggestion' => [ 'base' => '<p>Information about one suggested domain name.</p>', 'refs' => [ 'DomainSuggestionsList$member' => NULL, ], ], 'DomainSuggestionsList' => [ 'base' => NULL, 'refs' => [ 'GetDomainSuggestionsResponse$SuggestionsList' => '<p>A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the request, the list contains only domains that are available for registration.</p>', ], ], 'DomainSummary' => [ 'base' => '<p>Summary information about one domain.</p>', 'refs' => [ 'DomainSummaryList$member' => NULL, ], ], 'DomainSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDomainsResponse$Domains' => '<p>A summary of domains.</p>', ], ], 'DuplicateRequest' => [ 'base' => '<p>The request is already in progress for the domain.</p>', 'refs' => [], ], 'DurationInYears' => [ 'base' => NULL, 'refs' => [ 'RegisterDomainRequest$DurationInYears' => '<p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain. For the range of valid values for your domain, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p>Default: 1</p>', 'RenewDomainRequest$DurationInYears' => '<p>The number of years that you want to renew the domain for. The maximum number of years depends on the top-level domain. For the range of valid values for your domain, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p>Default: 1</p>', 'TransferDomainRequest$DurationInYears' => '<p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain.</p> <p>Default: 1</p>', ], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'ContactDetail$Email' => '<p>Email address of the contact.</p>', 'GetDomainDetailResponse$AbuseContactEmail' => '<p>Email address to contact to report incorrect contact information for a domain, to report that the domain is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.</p>', 'ResendContactReachabilityEmailResponse$emailAddress' => '<p>The email address for the registrant contact at the time that we sent the verification email.</p>', ], ], 'EnableDomainAutoRenewRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableDomainAutoRenewResponse' => [ 'base' => NULL, 'refs' => [], ], 'EnableDomainTransferLockRequest' => [ 'base' => '<p>A request to set the transfer lock for the specified domain.</p>', 'refs' => [], ], 'EnableDomainTransferLockResponse' => [ 'base' => '<p>The EnableDomainTransferLock response includes the following elements.</p>', 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'DomainLimitExceeded$message' => '<p>The number of domains has exceeded the allowed threshold for the account.</p>', 'DuplicateRequest$message' => '<p>The request is already in progress for the domain.</p>', 'GetOperationDetailResponse$Message' => '<p>Detailed information on the status including possible errors.</p>', 'InvalidInput$message' => '<p>The requested item is not acceptable. For example, for an OperationId it may refer to the ID of an operation that is already completed. For a domain name, it may not be a valid domain name or belong to the requester account.</p>', 'OperationLimitExceeded$message' => '<p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>', 'TLDRulesViolation$message' => '<p>The top-level domain does not support this operation.</p>', 'UnsupportedTLD$message' => '<p>Amazon Route 53 does not support this top-level domain.</p>', ], ], 'ExtraParam' => [ 'base' => '<p>ExtraParam includes the following elements.</p>', 'refs' => [ 'ExtraParamList$member' => NULL, ], ], 'ExtraParamList' => [ 'base' => NULL, 'refs' => [ 'ContactDetail$ExtraParams' => '<p>A list of name-value pairs for parameters required by certain top-level domains.</p>', ], ], 'ExtraParamName' => [ 'base' => NULL, 'refs' => [ 'ExtraParam$Name' => '<p>Name of the additional parameter required by the top-level domain.</p>', ], ], 'ExtraParamValue' => [ 'base' => NULL, 'refs' => [ 'ExtraParam$Value' => '<p>Values corresponding to the additional parameter names required by some top-level domains.</p>', ], ], 'FIAuthKey' => [ 'base' => NULL, 'refs' => [ 'UpdateDomainNameserversRequest$FIAuthKey' => '<p>The authorization key for .fi domains</p>', ], ], 'GetContactReachabilityStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContactReachabilityStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDomainDetailRequest' => [ 'base' => '<p>The GetDomainDetail request includes the following element.</p>', 'refs' => [], ], 'GetDomainDetailResponse' => [ 'base' => '<p>The GetDomainDetail response includes the following elements.</p>', 'refs' => [], ], 'GetDomainSuggestionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDomainSuggestionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetOperationDetailRequest' => [ 'base' => '<p>The <a>GetOperationDetail</a> request includes the following element.</p>', 'refs' => [], ], 'GetOperationDetailResponse' => [ 'base' => '<p>The GetOperationDetail response includes the following elements.</p>', 'refs' => [], ], 'GlueIp' => [ 'base' => NULL, 'refs' => [ 'GlueIpList$member' => NULL, ], ], 'GlueIpList' => [ 'base' => NULL, 'refs' => [ 'Nameserver$GlueIps' => '<p>Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name server is a subdomain of the domain. For example, if your domain is example.com and the name server for the domain is ns.example.com, you need to specify the IP address for ns.example.com.</p> <p>Constraints: The list can contain only one IPv4 and one IPv6 address.</p>', ], ], 'HostName' => [ 'base' => NULL, 'refs' => [ 'Nameserver$Name' => '<p>The fully qualified host name of the name server.</p> <p>Constraint: Maximum 255 characters</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'GetDomainSuggestionsRequest$SuggestionCount' => '<p>The number of suggested domain names that you want Amazon Route 53 to return.</p>', ], ], 'InvalidInput' => [ 'base' => '<p>The requested item is not acceptable. For example, for an OperationId it may refer to the ID of an operation that is already completed. For a domain name, it may not be a valid domain name or belong to the requester account.</p>', 'refs' => [], ], 'InvoiceId' => [ 'base' => NULL, 'refs' => [ 'BillingRecord$InvoiceId' => '<p>The ID of the invoice that is associated with the billing record.</p>', ], ], 'LangCode' => [ 'base' => NULL, 'refs' => [ 'CheckDomainAvailabilityRequest$IdnLangCode' => '<p>Reserved for future use.</p>', 'RegisterDomainRequest$IdnLangCode' => '<p>Reserved for future use.</p>', 'TransferDomainRequest$IdnLangCode' => '<p>Reserved for future use.</p>', ], ], 'ListDomainsRequest' => [ 'base' => '<p>The ListDomains request includes the following elements.</p>', 'refs' => [], ], 'ListDomainsResponse' => [ 'base' => '<p>The ListDomains response includes the following elements.</p>', 'refs' => [], ], 'ListOperationsRequest' => [ 'base' => '<p>The ListOperations request includes the following elements.</p>', 'refs' => [], ], 'ListOperationsResponse' => [ 'base' => '<p>The ListOperations response includes the following elements.</p>', 'refs' => [], ], 'ListTagsForDomainRequest' => [ 'base' => '<p>The ListTagsForDomainRequest includes the following elements.</p>', 'refs' => [], ], 'ListTagsForDomainResponse' => [ 'base' => '<p>The ListTagsForDomain response includes the following elements.</p>', 'refs' => [], ], 'Nameserver' => [ 'base' => '<p>Nameserver includes the following elements.</p>', 'refs' => [ 'NameserverList$member' => NULL, ], ], 'NameserverList' => [ 'base' => NULL, 'refs' => [ 'GetDomainDetailResponse$Nameservers' => '<p>The name of the domain.</p>', 'TransferDomainRequest$Nameservers' => '<p>Contains details for the host and glue IP addresses.</p>', 'UpdateDomainNameserversRequest$Nameservers' => '<p>A list of new name servers for the domain.</p>', ], ], 'OperationId' => [ 'base' => NULL, 'refs' => [ 'DisableDomainTransferLockResponse$OperationId' => '<p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use <a>GetOperationDetail</a>.</p>', 'EnableDomainTransferLockResponse$OperationId' => '<p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use GetOperationDetail.</p>', 'GetOperationDetailRequest$OperationId' => '<p>The identifier for the operation for which you want to get the status. Amazon Route 53 returned the identifier in the response to the original request.</p>', 'GetOperationDetailResponse$OperationId' => '<p>The identifier for the operation.</p>', 'OperationSummary$OperationId' => '<p>Identifier returned to track the requested action.</p>', 'RegisterDomainResponse$OperationId' => '<p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use <a>GetOperationDetail</a>.</p>', 'RenewDomainResponse$OperationId' => '<p>The identifier for tracking the progress of the request. To use this ID to query the operation status, use <a>GetOperationDetail</a>.</p>', 'TransferDomainResponse$OperationId' => '<p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use <a>GetOperationDetail</a>.</p>', 'UpdateDomainContactPrivacyResponse$OperationId' => '<p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use GetOperationDetail.</p>', 'UpdateDomainContactResponse$OperationId' => '<p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use <a>GetOperationDetail</a>.</p>', 'UpdateDomainNameserversResponse$OperationId' => '<p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use <a>GetOperationDetail</a>.</p>', ], ], 'OperationLimitExceeded' => [ 'base' => '<p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>', 'refs' => [], ], 'OperationStatus' => [ 'base' => NULL, 'refs' => [ 'GetOperationDetailResponse$Status' => '<p>The current status of the requested operation in the system.</p>', 'OperationSummary$Status' => '<p>The current status of the requested operation in the system.</p>', ], ], 'OperationSummary' => [ 'base' => '<p>OperationSummary includes the following elements.</p>', 'refs' => [ 'OperationSummaryList$member' => NULL, ], ], 'OperationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListOperationsResponse$Operations' => '<p>Lists summaries of the operations.</p>', ], ], 'OperationType' => [ 'base' => NULL, 'refs' => [ 'BillingRecord$Operation' => '<p>The operation that you were charged for.</p>', 'GetOperationDetailResponse$Type' => '<p>The type of operation that was requested.</p>', 'OperationSummary$Type' => '<p>Type of the action requested.</p>', ], ], 'PageMarker' => [ 'base' => NULL, 'refs' => [ 'ListDomainsRequest$Marker' => '<p>For an initial request for a list of domains, omit this element. If the number of domains that are associated with the current AWS account is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p> <p>Constraints: The marker must match the value specified in the previous request.</p>', 'ListDomainsResponse$NextPageMarker' => '<p>If there are more domains than you specified for <code>MaxItems</code> in the request, submit another request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>', 'ListOperationsRequest$Marker' => '<p>For an initial request for a list of operations, omit this element. If the number of operations that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>', 'ListOperationsResponse$NextPageMarker' => '<p>If there are more operations than you specified for <code>MaxItems</code> in the request, submit another request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>', 'ViewBillingRequest$Marker' => '<p>For an initial request for a list of billing records, omit this element. If the number of billing records that are associated with the current AWS account during the specified period is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing records. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p> <p>Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous response.</p>', 'ViewBillingResponse$NextPageMarker' => '<p>If there are more billing records than you specified for <code>MaxItems</code> in the request, submit another request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>', ], ], 'PageMaxItems' => [ 'base' => NULL, 'refs' => [ 'ListDomainsRequest$MaxItems' => '<p>Number of domains to be returned.</p> <p>Default: 20</p>', 'ListOperationsRequest$MaxItems' => '<p>Number of domains to be returned.</p> <p>Default: 20</p>', 'ViewBillingRequest$MaxItems' => '<p>The number of billing records to be returned.</p> <p>Default: 20</p>', ], ], 'Price' => [ 'base' => NULL, 'refs' => [ 'BillingRecord$Price' => '<p>The price that you were charged for the operation, in US dollars.</p> <p>Example value: 12.0</p>', ], ], 'ReachabilityStatus' => [ 'base' => NULL, 'refs' => [ 'GetContactReachabilityStatusResponse$status' => '<p>Whether the registrant contact has responded. Values include the following:</p> <dl> <dt>PENDING</dt> <dd> <p>We sent the confirmation email and haven\'t received a response yet.</p> </dd> <dt>DONE</dt> <dd> <p>We sent the email and got confirmation from the registrant contact.</p> </dd> <dt>EXPIRED</dt> <dd> <p>The time limit expired before the registrant contact responded.</p> </dd> </dl>', ], ], 'RegisterDomainRequest' => [ 'base' => '<p>The RegisterDomain request includes the following elements.</p>', 'refs' => [], ], 'RegisterDomainResponse' => [ 'base' => '<p>The RegisterDomain response includes the following element.</p>', 'refs' => [], ], 'RegistrarName' => [ 'base' => NULL, 'refs' => [ 'GetDomainDetailResponse$RegistrarName' => '<p>Name of the registrar of the domain as identified in the registry. Amazon Route 53 domains are registered by registrar Gandi. The value is <code>"GANDI SAS"</code>. </p>', ], ], 'RegistrarUrl' => [ 'base' => NULL, 'refs' => [ 'GetDomainDetailResponse$RegistrarUrl' => '<p>Web address of the registrar.</p>', ], ], 'RegistrarWhoIsServer' => [ 'base' => NULL, 'refs' => [ 'GetDomainDetailResponse$WhoIsServer' => '<p>The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.</p>', ], ], 'RegistryDomainId' => [ 'base' => NULL, 'refs' => [ 'GetDomainDetailResponse$RegistryDomainId' => '<p>Reserved for future use.</p>', ], ], 'RenewDomainRequest' => [ 'base' => '<p>A <code>RenewDomain</code> request includes the number of years that you want to renew for and the current expiration year.</p>', 'refs' => [], ], 'RenewDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'Reseller' => [ 'base' => NULL, 'refs' => [ 'GetDomainDetailResponse$Reseller' => '<p>Reseller of the domain. Domains registered or transferred using Amazon Route 53 domains will have <code>"Amazon"</code> as the reseller. </p>', ], ], 'ResendContactReachabilityEmailRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResendContactReachabilityEmailResponse' => [ 'base' => NULL, 'refs' => [], ], 'RetrieveDomainAuthCodeRequest' => [ 'base' => '<p>A request for the authorization code for the specified domain. To transfer a domain to another registrar, you provide this value to the new registrar.</p>', 'refs' => [], ], 'RetrieveDomainAuthCodeResponse' => [ 'base' => '<p>The RetrieveDomainAuthCode response includes the following element.</p>', 'refs' => [], ], 'State' => [ 'base' => NULL, 'refs' => [ 'ContactDetail$State' => '<p>The state or province of the contact\'s city.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'DomainSuggestion$Availability' => '<p>Whether the domain name is available for registering.</p> <note> <p>You can register only the domains that are designated as <code>AVAILABLE</code>.</p> </note> <p>Valid values:</p> <dl> <dt>AVAILABLE</dt> <dd> <p>The domain name is available.</p> </dd> <dt>AVAILABLE_RESERVED</dt> <dd> <p>The domain name is reserved under specific conditions.</p> </dd> <dt>AVAILABLE_PREORDER</dt> <dd> <p>The domain name is available and can be preordered.</p> </dd> <dt>DONT_KNOW</dt> <dd> <p>The TLD registry didn\'t reply with a definitive answer about whether the domain name is available. Amazon Route 53 can return this response for a variety of reasons, for example, the registry is performing maintenance. Try again later.</p> </dd> <dt>PENDING</dt> <dd> <p>The TLD registry didn\'t return a response in the expected amount of time. When the response is delayed, it usually takes just a few extra seconds. You can resubmit the request immediately.</p> </dd> <dt>RESERVED</dt> <dd> <p>The domain name has been reserved for another person or organization.</p> </dd> <dt>UNAVAILABLE</dt> <dd> <p>The domain name is not available.</p> </dd> <dt>UNAVAILABLE_PREMIUM</dt> <dd> <p>The domain name is not available.</p> </dd> <dt>UNAVAILABLE_RESTRICTED</dt> <dd> <p>The domain name is forbidden.</p> </dd> </dl>', ], ], 'TLDRulesViolation' => [ 'base' => '<p>The top-level domain does not support this operation.</p>', 'refs' => [], ], 'Tag' => [ 'base' => '<p>Each tag includes the following elements.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key (name) of a tag.</p> <p>Valid values: A-Z, a-z, 0-9, space, ".:/=+\\-@"</p> <p>Constraints: Each key can be 1-128 characters long.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'DeleteTagsForDomainRequest$TagsToDelete' => '<p>A list of tag keys to delete.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForDomainResponse$TagList' => '<p>A list of the tags that are associated with the specified domain.</p>', 'UpdateTagsForDomainRequest$TagsToUpdate' => '<p>A list of the tag keys and values that you want to add or update. If you specify a key that already exists, the corresponding value will be replaced.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of a tag.</p> <p>Valid values: A-Z, a-z, 0-9, space, ".:/=+\\-@"</p> <p>Constraints: Each value can be 0-256 characters long.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'BillingRecord$BillDate' => '<p>The date that the operation was billed, in Unix format.</p>', 'DomainSummary$Expiry' => '<p>Expiration date of the domain in Coordinated Universal Time (UTC).</p>', 'GetDomainDetailResponse$CreationDate' => '<p>The date when the domain was created as found in the response to a WHOIS query. The date format is Unix time.</p>', 'GetDomainDetailResponse$UpdatedDate' => '<p>The last updated date of the domain as found in the response to a WHOIS query. The date format is Unix time.</p>', 'GetDomainDetailResponse$ExpirationDate' => '<p>The date when the registration for the domain is set to expire. The date format is Unix time.</p>', 'GetOperationDetailResponse$SubmittedDate' => '<p>The date when the request was submitted.</p>', 'OperationSummary$SubmittedDate' => '<p>The date when the request was submitted.</p>', 'ViewBillingRequest$Start' => '<p>The beginning date and time for the time period for which you want a list of billing records. Specify the date in Unix time format.</p>', 'ViewBillingRequest$End' => '<p>The end date and time for the time period for which you want a list of billing records. Specify the date in Unix time format.</p>', ], ], 'TransferDomainRequest' => [ 'base' => '<p>The TransferDomain request includes the following elements.</p>', 'refs' => [], ], 'TransferDomainResponse' => [ 'base' => '<p>The TranserDomain response includes the following element.</p>', 'refs' => [], ], 'UnsupportedTLD' => [ 'base' => '<p>Amazon Route 53 does not support this top-level domain.</p>', 'refs' => [], ], 'UpdateDomainContactPrivacyRequest' => [ 'base' => '<p>The UpdateDomainContactPrivacy request includes the following elements.</p>', 'refs' => [], ], 'UpdateDomainContactPrivacyResponse' => [ 'base' => '<p>The UpdateDomainContactPrivacy response includes the following element.</p>', 'refs' => [], ], 'UpdateDomainContactRequest' => [ 'base' => '<p>The UpdateDomainContact request includes the following elements.</p>', 'refs' => [], ], 'UpdateDomainContactResponse' => [ 'base' => '<p>The UpdateDomainContact response includes the following element.</p>', 'refs' => [], ], 'UpdateDomainNameserversRequest' => [ 'base' => '<p>Replaces the current set of name servers for the domain with the specified set of name servers. If you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted zone for the domain.</p> <p>If successful, this operation returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email. </p>', 'refs' => [], ], 'UpdateDomainNameserversResponse' => [ 'base' => '<p>The UpdateDomainNameservers response includes the following element.</p>', 'refs' => [], ], 'UpdateTagsForDomainRequest' => [ 'base' => '<p>The UpdateTagsForDomainRequest includes the following elements.</p>', 'refs' => [], ], 'UpdateTagsForDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'ViewBillingRequest' => [ 'base' => '<p>The ViewBilling request includes the following elements.</p>', 'refs' => [], ], 'ViewBillingResponse' => [ 'base' => '<p>The ViewBilling response includes the following elements.</p>', 'refs' => [], ], 'ZipCode' => [ 'base' => NULL, 'refs' => [ 'ContactDetail$ZipCode' => '<p>The zip or postal code of the contact\'s address.</p>', ], ], ],];
