<?php
// This file was auto-generated from sdk-root/src/data/sms/2016-10-24/docs-2.json
return [ 'version' => '2.0', 'service' => 'Amazon Server Migration Service automates the process of migrating servers to EC2.', 'operations' => [ 'CreateReplicationJob' => 'The CreateReplicationJob API is used to create a ReplicationJob to replicate a server on AWS. Call this API to first create a ReplicationJob, which will then schedule periodic ReplicationRuns to replicate your server to AWS. Each ReplicationRun will result in the creation of an AWS AMI.', 'DeleteReplicationJob' => 'The DeleteReplicationJob API is used to delete a ReplicationJob, resulting in no further ReplicationRuns. This will delete the contents of the S3 bucket used to store SMS artifacts, but will not delete any AMIs created by the SMS service.', 'DeleteServerCatalog' => 'The DeleteServerCatalog API clears all servers from your server catalog. This means that these servers will no longer be accessible to the Server Migration Service.', 'DisassociateConnector' => 'The DisassociateConnector API will disassociate a connector from the Server Migration Service, rendering it unavailable to support replication jobs.', 'GetConnectors' => 'The GetConnectors API returns a list of connectors that are registered with the Server Migration Service.', 'GetReplicationJobs' => 'The GetReplicationJobs API will return all of your ReplicationJobs and their details. This API returns a paginated list, that may be consecutively called with nextToken to retrieve all ReplicationJobs.', 'GetReplicationRuns' => 'The GetReplicationRuns API will return all ReplicationRuns for a given ReplicationJob. This API returns a paginated list, that may be consecutively called with nextToken to retrieve all ReplicationRuns for a ReplicationJob.', 'GetServers' => 'The GetServers API returns a list of all servers in your server catalog. For this call to succeed, you must previously have called ImportServerCatalog.', 'ImportServerCatalog' => 'The ImportServerCatalog API is used to gather the complete list of on-premises servers on your premises. This API call requires connectors to be installed and monitoring all servers you would like imported. This API call returns immediately, but may take some time to retrieve all of the servers.', 'StartOnDemandReplicationRun' => 'The StartOnDemandReplicationRun API is used to start a ReplicationRun on demand (in addition to those that are scheduled based on your frequency). This ReplicationRun will start immediately. StartOnDemandReplicationRun is subject to limits on how many on demand ReplicationRuns you may call per 24-hour period.', 'UpdateReplicationJob' => 'The UpdateReplicationJob API is used to change the settings of your existing ReplicationJob created using CreateReplicationJob. Calling this API will affect the next scheduled ReplicationRun.', ], 'shapes' => [ 'AmiId' => [ 'base' => 'The AMI id for the image resulting from a Replication Run.', 'refs' => [ 'ReplicationJob$latestAmiId' => NULL, 'ReplicationRun$amiId' => NULL, ], ], 'Connector' => [ 'base' => 'Object representing a Connector', 'refs' => [ 'ConnectorList$member' => NULL, ], ], 'ConnectorCapability' => [ 'base' => 'Capabilities for a Connector', 'refs' => [ 'ConnectorCapabilityList$member' => NULL, ], ], 'ConnectorCapabilityList' => [ 'base' => 'List of Connector Capabilities', 'refs' => [ 'Connector$capabilityList' => NULL, ], ], 'ConnectorId' => [ 'base' => 'Unique Identifier for Connector', 'refs' => [ 'Connector$connectorId' => NULL, 'DisassociateConnectorRequest$connectorId' => NULL, ], ], 'ConnectorList' => [ 'base' => 'List of connectors', 'refs' => [ 'GetConnectorsResponse$connectorList' => NULL, ], ], 'ConnectorStatus' => [ 'base' => 'Status of on-premise Connector', 'refs' => [ 'Connector$status' => NULL, ], ], 'ConnectorVersion' => [ 'base' => 'Connector version string', 'refs' => [ 'Connector$version' => NULL, ], ], 'CreateReplicationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateReplicationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReplicationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReplicationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServerCatalogRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServerCatalogResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => 'The description for a Replication Job/Run.', 'refs' => [ 'CreateReplicationJobRequest$description' => NULL, 'ReplicationJob$description' => NULL, 'ReplicationRun$description' => NULL, 'StartOnDemandReplicationRunRequest$description' => NULL, 'UpdateReplicationJobRequest$description' => NULL, ], ], 'DisassociateConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'ErrorMessage' => [ 'base' => 'Error Message string', 'refs' => [ 'InternalError$message' => NULL, 'InvalidParameterException$message' => NULL, 'MissingRequiredParameterException$message' => NULL, 'NoConnectorsAvailableException$message' => NULL, 'OperationNotPermittedException$message' => NULL, 'ReplicationJobAlreadyExistsException$message' => NULL, 'ReplicationJobNotFoundException$message' => NULL, 'ReplicationRunLimitExceededException$message' => NULL, 'ServerCannotBeReplicatedException$message' => NULL, 'UnauthorizedOperationException$message' => NULL, ], ], 'Frequency' => [ 'base' => 'Interval between Replication Runs. This value is specified in hours, and represents the time between consecutive Replication Runs.', 'refs' => [ 'CreateReplicationJobRequest$frequency' => NULL, 'ReplicationJob$frequency' => NULL, 'UpdateReplicationJobRequest$frequency' => NULL, ], ], 'GetConnectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetReplicationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReplicationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetReplicationRunsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReplicationRunsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImportServerCatalogRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportServerCatalogResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalError' => [ 'base' => 'An internal error has occured.', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => 'A parameter specified in the request is not valid, is unsupported, or cannot be used.', 'refs' => [], ], 'IpAddress' => [ 'base' => 'Internet Protocol (IP) Address', 'refs' => [ 'Connector$ipAddress' => NULL, ], ], 'LicenseType' => [ 'base' => 'The license type to be used for the Amazon Machine Image (AMI) created after a successful ReplicationRun.', 'refs' => [ 'CreateReplicationJobRequest$licenseType' => NULL, 'ReplicationJob$licenseType' => NULL, 'UpdateReplicationJobRequest$licenseType' => NULL, ], ], 'MacAddress' => [ 'base' => 'Hardware (MAC) address', 'refs' => [ 'Connector$macAddress' => NULL, ], ], 'MaxResults' => [ 'base' => 'The maximum number of results to return in one API call. If left empty, this will default to 50.', 'refs' => [ 'GetConnectorsRequest$maxResults' => NULL, 'GetReplicationJobsRequest$maxResults' => NULL, 'GetReplicationRunsRequest$maxResults' => NULL, 'GetServersRequest$maxResults' => NULL, ], ], 'MissingRequiredParameterException' => [ 'base' => 'The request is missing a required parameter. Ensure that you have supplied all the required parameters for the request.', 'refs' => [], ], 'NextToken' => [ 'base' => 'Pagination token to pass as input to API call', 'refs' => [ 'GetConnectorsRequest$nextToken' => NULL, 'GetConnectorsResponse$nextToken' => NULL, 'GetReplicationJobsRequest$nextToken' => NULL, 'GetReplicationJobsResponse$nextToken' => NULL, 'GetReplicationRunsRequest$nextToken' => NULL, 'GetReplicationRunsResponse$nextToken' => NULL, 'GetServersRequest$nextToken' => NULL, 'GetServersResponse$nextToken' => NULL, ], ], 'NoConnectorsAvailableException' => [ 'base' => 'No connectors are available to handle this request. Please associate connector(s) and verify any existing connectors are healthy and can respond to requests.', 'refs' => [], ], 'OperationNotPermittedException' => [ 'base' => 'The specified operation is not allowed. This error can occur for a number of reasons; for example, you might be trying to start a Replication Run before seed Replication Run.', 'refs' => [], ], 'ReplicationJob' => [ 'base' => 'Object representing a Replication Job', 'refs' => [ 'GetReplicationRunsResponse$replicationJob' => NULL, 'ReplicationJobList$member' => NULL, ], ], 'ReplicationJobAlreadyExistsException' => [ 'base' => 'An active Replication Job already exists for the specified server.', 'refs' => [], ], 'ReplicationJobId' => [ 'base' => 'The unique identifier for a Replication Job.', 'refs' => [ 'CreateReplicationJobResponse$replicationJobId' => NULL, 'DeleteReplicationJobRequest$replicationJobId' => NULL, 'GetReplicationJobsRequest$replicationJobId' => NULL, 'GetReplicationRunsRequest$replicationJobId' => NULL, 'ReplicationJob$replicationJobId' => NULL, 'Server$replicationJobId' => NULL, 'StartOnDemandReplicationRunRequest$replicationJobId' => NULL, 'UpdateReplicationJobRequest$replicationJobId' => NULL, ], ], 'ReplicationJobList' => [ 'base' => 'List of Replication Jobs', 'refs' => [ 'GetReplicationJobsResponse$replicationJobList' => NULL, ], ], 'ReplicationJobNotFoundException' => [ 'base' => 'The specified Replication Job cannot be found.', 'refs' => [], ], 'ReplicationJobState' => [ 'base' => 'Current state of Replication Job', 'refs' => [ 'ReplicationJob$state' => NULL, ], ], 'ReplicationJobStatusMessage' => [ 'base' => 'String describing current status of Replication Job', 'refs' => [ 'ReplicationJob$statusMessage' => NULL, ], ], 'ReplicationJobTerminated' => [ 'base' => 'An indicator of the Replication Job being deleted or failed.', 'refs' => [ 'Server$replicationJobTerminated' => NULL, ], ], 'ReplicationRun' => [ 'base' => 'Object representing a Replication Run', 'refs' => [ 'ReplicationRunList$member' => NULL, ], ], 'ReplicationRunId' => [ 'base' => 'The unique identifier for a Replication Run.', 'refs' => [ 'ReplicationRun$replicationRunId' => NULL, 'StartOnDemandReplicationRunResponse$replicationRunId' => NULL, ], ], 'ReplicationRunLimitExceededException' => [ 'base' => 'This user has exceeded the maximum allowed Replication Run limit.', 'refs' => [], ], 'ReplicationRunList' => [ 'base' => 'List of Replication Runs', 'refs' => [ 'GetReplicationRunsResponse$replicationRunList' => NULL, 'ReplicationJob$replicationRunList' => NULL, ], ], 'ReplicationRunState' => [ 'base' => 'Current state of Replication Run', 'refs' => [ 'ReplicationRun$state' => NULL, ], ], 'ReplicationRunStatusMessage' => [ 'base' => 'String describing current status of Replication Run', 'refs' => [ 'ReplicationRun$statusMessage' => NULL, ], ], 'ReplicationRunType' => [ 'base' => 'Type of Replication Run', 'refs' => [ 'ReplicationRun$type' => NULL, ], ], 'RoleName' => [ 'base' => 'Name of service role in customer\'s account to be used by SMS service.', 'refs' => [ 'CreateReplicationJobRequest$roleName' => NULL, 'ReplicationJob$roleName' => NULL, 'UpdateReplicationJobRequest$roleName' => NULL, ], ], 'Server' => [ 'base' => 'Object representing a server', 'refs' => [ 'ServerList$member' => NULL, ], ], 'ServerCannotBeReplicatedException' => [ 'base' => 'The provided server cannot be replicated.', 'refs' => [], ], 'ServerCatalogStatus' => [ 'base' => 'Status of Server catalog', 'refs' => [ 'GetServersResponse$serverCatalogStatus' => NULL, ], ], 'ServerId' => [ 'base' => 'Unique Identifier for a server', 'refs' => [ 'CreateReplicationJobRequest$serverId' => NULL, 'ReplicationJob$serverId' => NULL, 'Server$serverId' => NULL, ], ], 'ServerList' => [ 'base' => 'List of servers from catalog', 'refs' => [ 'GetServersResponse$serverList' => NULL, ], ], 'ServerType' => [ 'base' => 'Type of server.', 'refs' => [ 'ReplicationJob$serverType' => NULL, 'Server$serverType' => NULL, ], ], 'StartOnDemandReplicationRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartOnDemandReplicationRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'Timestamp' => [ 'base' => 'Timestamp of an operation', 'refs' => [ 'Connector$associatedOn' => NULL, 'CreateReplicationJobRequest$seedReplicationTime' => NULL, 'GetServersResponse$lastModifiedOn' => NULL, 'ReplicationJob$seedReplicationTime' => NULL, 'ReplicationJob$nextReplicationRunStartTime' => NULL, 'ReplicationRun$scheduledStartTime' => NULL, 'ReplicationRun$completedTime' => NULL, 'UpdateReplicationJobRequest$nextReplicationRunStartTime' => NULL, ], ], 'UnauthorizedOperationException' => [ 'base' => 'This user does not have permissions to perform this operation.', 'refs' => [], ], 'UpdateReplicationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReplicationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'VmId' => [ 'base' => 'Unique Identifier for a VM', 'refs' => [ 'VmServerAddress$vmId' => NULL, ], ], 'VmManagerId' => [ 'base' => 'Unique Identifier for VM Manager', 'refs' => [ 'Connector$vmManagerId' => NULL, 'VmServerAddress$vmManagerId' => NULL, ], ], 'VmManagerName' => [ 'base' => 'VM Manager Name', 'refs' => [ 'Connector$vmManagerName' => NULL, 'VmServer$vmManagerName' => NULL, ], ], 'VmManagerType' => [ 'base' => 'VM Management Product', 'refs' => [ 'Connector$vmManagerType' => NULL, 'VmServer$vmManagerType' => NULL, ], ], 'VmName' => [ 'base' => 'Name of Virtual Machine', 'refs' => [ 'VmServer$vmName' => NULL, ], ], 'VmPath' => [ 'base' => 'Path to VM', 'refs' => [ 'VmServer$vmPath' => NULL, ], ], 'VmServer' => [ 'base' => 'Object representing a VM server', 'refs' => [ 'ReplicationJob$vmServer' => NULL, 'Server$vmServer' => NULL, ], ], 'VmServerAddress' => [ 'base' => 'Object representing a server\'s location', 'refs' => [ 'VmServer$vmServerAddress' => NULL, ], ], ],];
