<?php
// This file was auto-generated from sdk-root/src/data/ssm/2014-11-06/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon EC2 Systems Manager</fullname> <p>Amazon EC2 Systems Manager is a collection of capabilities that helps you automate management tasks such as collecting system inventory, applying operating system (OS) patches, automating the creation of Amazon Machine Images (AMIs), and configuring operating systems (OSs) and applications at scale. Systems Manager lets you remotely and securely manage the configuration of your managed instances. A <i>managed instance</i> is any Amazon EC2 instance or on-premises machine in your hybrid environment that has been configured for Systems Manager.</p> <p>This reference is intended to be used with the <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/">Amazon EC2 Systems Manager User Guide</a>.</p> <p>To get started, verify prerequisites and configure managed instances. For more information, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-setting-up.html">Systems Manager Prerequisites</a>.</p>', 'operations' => [ 'AddTagsToResource' => '<p>Adds or overwrites one or more tags for the specified resource. Tags are metadata that you assign to your managed instances, Maintenance Windows, or Parameter Store parameters. Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value, both of which you define. For example, you could define a set of tags for your account\'s managed instances that helps you track each instance\'s owner and stack level. For example: Key=Owner and Value=DbAdmin, SysAdmin, or Dev. Or Key=Stack and Value=Production, Pre-Production, or Test.</p> <p>Each resource can have a maximum of 10 tags. </p> <p>We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based on the tags you add. Tags don\'t have any semantic meaning to Amazon EC2 and are interpreted strictly as a string of characters. </p> <p>For more information about tags, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Amazon EC2 Resources</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CancelCommand' => '<p>Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be terminated and the underlying process stopped.</p>', 'CreateActivation' => '<p>Registers your on-premises server or virtual machine with Amazon EC2 so that you can manage these resources using Run Command. An on-premises server or virtual machine that has been registered with EC2 is called a managed instance. For more information about activations, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting Up Systems Manager in Hybrid Environments</a>.</p>', 'CreateAssociation' => '<p>Associates the specified Systems Manager document with the specified instances or targets.</p> <p>When you associate a document with one or more instances using instance IDs or tags, the SSM Agent running on the instance processes the document and configures the instance as specified.</p> <p>If you associate a document with an instance that already has an associated document, the system throws the AssociationAlreadyExists exception.</p>', 'CreateAssociationBatch' => '<p>Associates the specified Systems Manager document with the specified instances or targets.</p> <p>When you associate a document with one or more instances using instance IDs or tags, the SSM Agent running on the instance processes the document and configures the instance as specified.</p> <p>If you associate a document with an instance that already has an associated document, the system throws the AssociationAlreadyExists exception.</p>', 'CreateDocument' => '<p>Creates a Systems Manager document.</p> <p>After you create a document, you can use CreateAssociation to associate it with one or more running instances.</p>', 'CreateMaintenanceWindow' => '<p>Creates a new Maintenance Window.</p>', 'CreatePatchBaseline' => '<p>Creates a patch baseline.</p>', 'CreateResourceDataSync' => '<p>Creates a resource data sync configuration to a single bucket in Amazon S3. This is an asynchronous operation that returns immediately. After a successful initial sync is completed, the system continuously syncs data to the Amazon S3 bucket. To check the status of the sync, use the <a href="API_ListResourceDataSync.html">ListResourceDataSync</a> operation.</p> <p>By default, data is not encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a restrictive bucket policy. To view an example of a restrictive Amazon S3 bucket policy for Resource Data Sync, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-configuring.html#sysman-inventory-datasync">Configuring Resource Data Sync for Inventory</a>.</p>', 'DeleteActivation' => '<p>Deletes an activation. You are not required to delete an activation. If you delete an activation, you can no longer use it to register additional managed instances. Deleting an activation does not de-register managed instances. You must manually de-register managed instances.</p>', 'DeleteAssociation' => '<p>Disassociates the specified Systems Manager document from the specified instance.</p> <p>When you disassociate a document from an instance, it does not change the configuration of the instance. To change the configuration state of an instance after you disassociate a document, you must create a new document with the desired configuration and associate it with the instance.</p>', 'DeleteDocument' => '<p>Deletes the Systems Manager document and all instance associations to the document.</p> <p>Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all instances that are associated with the document.</p>', 'DeleteMaintenanceWindow' => '<p>Deletes a Maintenance Window.</p>', 'DeleteParameter' => '<p>Delete a parameter from the system.</p>', 'DeleteParameters' => '<p>Delete a list of parameters. This API is used to delete parameters by using the Amazon EC2 console.</p>', 'DeletePatchBaseline' => '<p>Deletes a patch baseline.</p>', 'DeleteResourceDataSync' => '<p>Deletes a Resource Data Sync configuration. After the configuration is deleted, changes to inventory data on managed instances are no longer synced with the target Amazon S3 bucket. Deleting a sync configuration does not delete data in the target Amazon S3 bucket.</p>', 'DeregisterManagedInstance' => '<p>Removes the server or virtual machine from the list of registered servers. You can reregister the instance again at any time. If you don\'t plan to use Run Command on the server, we suggest uninstalling the SSM Agent first.</p>', 'DeregisterPatchBaselineForPatchGroup' => '<p>Removes a patch group from a patch baseline.</p>', 'DeregisterTargetFromMaintenanceWindow' => '<p>Removes a target from a Maintenance Window.</p>', 'DeregisterTaskFromMaintenanceWindow' => '<p>Removes a task from a Maintenance Window.</p>', 'DescribeActivations' => '<p>Details about the activation, including: the date and time the activation was created, the expiration date, the IAM role assigned to the instances in the activation, and the number of instances activated by this registration.</p>', 'DescribeAssociation' => '<p>Describes the associations for the specified Systems Manager document or instance.</p>', 'DescribeAutomationExecutions' => '<p>Provides details about all active and terminated Automation executions.</p>', 'DescribeAvailablePatches' => '<p>Lists all patches that could possibly be included in a patch baseline.</p>', 'DescribeDocument' => '<p>Describes the specified SSM document.</p>', 'DescribeDocumentPermission' => '<p>Describes the permissions for a Systems Manager document. If you created the document, you are the owner. If a document is shared, it can either be shared privately (by specifying a user\'s AWS account ID) or publicly (<i>All</i>). </p>', 'DescribeEffectiveInstanceAssociations' => '<p>All associations for the instance(s).</p>', 'DescribeEffectivePatchesForPatchBaseline' => '<p>Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Note that this API applies only to Windows patch baselines.</p>', 'DescribeInstanceAssociationsStatus' => '<p>The status of the associations for the instance(s).</p>', 'DescribeInstanceInformation' => '<p>Describes one or more of your instances. You can use this to get information about instances like the operating system platform, the SSM Agent version (Linux), status etc. If you specify one or more instance IDs, it returns information for those instances. If you do not specify instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or an instance that you do not own, you receive an error. </p>', 'DescribeInstancePatchStates' => '<p>Retrieves the high-level patch state of one or more instances.</p>', 'DescribeInstancePatchStatesForPatchGroup' => '<p>Retrieves the high-level patch state for the instances in the specified patch group.</p>', 'DescribeInstancePatches' => '<p>Retrieves information about the patches on the specified instance and their state relative to the patch baseline being used for the instance.</p>', 'DescribeMaintenanceWindowExecutionTaskInvocations' => '<p>Retrieves the individual task executions (one per target) for a particular task executed as part of a Maintenance Window execution.</p>', 'DescribeMaintenanceWindowExecutionTasks' => '<p>For a given Maintenance Window execution, lists the tasks that were executed.</p>', 'DescribeMaintenanceWindowExecutions' => '<p>Lists the executions of a Maintenance Window. This includes information about when the Maintenance Window was scheduled to be active, and information about tasks registered and run with the Maintenance Window.</p>', 'DescribeMaintenanceWindowTargets' => '<p>Lists the targets registered with the Maintenance Window.</p>', 'DescribeMaintenanceWindowTasks' => '<p>Lists the tasks in a Maintenance Window.</p>', 'DescribeMaintenanceWindows' => '<p>Retrieves the Maintenance Windows in an AWS account.</p>', 'DescribeParameters' => '<p>Get information about a parameter.</p> <p>Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the response includes information up to the limit specified. The number of items returned, however, can be between zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>. You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.</p>', 'DescribePatchBaselines' => '<p>Lists the patch baselines in your AWS account.</p>', 'DescribePatchGroupState' => '<p>Returns high-level aggregated patch compliance state for a patch group.</p>', 'DescribePatchGroups' => '<p>Lists all patch groups that have been registered with patch baselines.</p>', 'GetAutomationExecution' => '<p>Get detailed information about a particular Automation execution.</p>', 'GetCommandInvocation' => '<p>Returns detailed information about command execution for an invocation or plugin. </p>', 'GetDefaultPatchBaseline' => '<p>Retrieves the default patch baseline. Note that Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.</p>', 'GetDeployablePatchSnapshotForInstance' => '<p>Retrieves the current snapshot for the patch baseline the instance uses. This API is primarily used by the AWS-RunPatchBaseline Systems Manager document. </p>', 'GetDocument' => '<p>Gets the contents of the specified SSM document.</p>', 'GetInventory' => '<p>Query inventory information.</p>', 'GetInventorySchema' => '<p>Return a list of inventory type names for the account, or return a list of attribute names for a specific Inventory item type. </p>', 'GetMaintenanceWindow' => '<p>Retrieves a Maintenance Window.</p>', 'GetMaintenanceWindowExecution' => '<p>Retrieves details about a specific task executed as part of a Maintenance Window execution.</p>', 'GetMaintenanceWindowExecutionTask' => '<p>Retrieves the details about a specific task executed as part of a Maintenance Window execution.</p>', 'GetMaintenanceWindowExecutionTaskInvocation' => '<p>Retrieves a task invocation. A task invocation is a specific task executing on a specific target. Maintenance Windows report status for all invocations. </p>', 'GetMaintenanceWindowTask' => '<p>Lists the tasks in a Maintenance Window.</p>', 'GetParameter' => '<p>Get information about a parameter by using the parameter name. </p>', 'GetParameterHistory' => '<p>Query a list of all parameters used by the AWS account.</p>', 'GetParameters' => '<p>Get details of a parameter.</p>', 'GetParametersByPath' => '<p>Retrieve parameters in a specific hierarchy. For more information, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-working.html">Working with Systems Manager Parameters</a>. </p> <p>Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the response includes information up to the limit specified. The number of items returned, however, can be between zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>. You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.</p>', 'GetPatchBaseline' => '<p>Retrieves information about a patch baseline.</p>', 'GetPatchBaselineForPatchGroup' => '<p>Retrieves the patch baseline that should be used for the specified patch group.</p>', 'ListAssociations' => '<p>Lists the associations for the specified Systems Manager document or instance.</p>', 'ListCommandInvocations' => '<p>An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A command invocation applies to one instance. For example, if a user executes SendCommand against three instances, then a command invocation is created for each requested instance ID. ListCommandInvocations provide status about command execution.</p>', 'ListCommands' => '<p>Lists the commands requested by users of the AWS account.</p>', 'ListComplianceItems' => '<p>For a specified resource ID, this API returns a list of compliance statuses for different resource types. Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the filter. </p>', 'ListComplianceSummaries' => '<p>Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call can return State Manager associations, patches, or custom compliance types according to the filter criteria you specify. </p>', 'ListDocumentVersions' => '<p>List all versions for a document.</p>', 'ListDocuments' => '<p>Describes one or more of your SSM documents.</p>', 'ListInventoryEntries' => '<p>A list of inventory items returned by the request.</p>', 'ListResourceComplianceSummaries' => '<p>Returns a resource-level summary count. The summary includes information about compliant and non-compliant statuses and detailed compliance-item severity counts, according to the filter criteria you specify.</p>', 'ListResourceDataSync' => '<p>Lists your resource data sync configurations. Includes information about the last time a sync attempted to start, the last sync status, and the last time a sync successfully completed.</p> <p>The number of sync configurations might be too large to return using a single call to <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call. </p>', 'ListTagsForResource' => '<p>Returns a list of the tags assigned to the specified resource.</p>', 'ModifyDocumentPermission' => '<p>Shares a Systems Manager document publicly or privately. If you share a document privately, you must specify the AWS user account IDs for those people who can use the document. If you share a document publicly, you must specify <i>All</i> as the account ID.</p>', 'PutComplianceItems' => '<p>Registers a compliance type and other compliance details on a designated resource. This API lets you register custom compliance details with a resource. This call overwrites existing compliance information on the resource, so you must provide a full list of compliance items each time you send the request.</p>', 'PutInventory' => '<p>Bulk update custom inventory items on one more instance. The request adds an inventory item, if it doesn\'t already exist, or updates an inventory item, if it does exist.</p>', 'PutParameter' => '<p>Add one or more parameters to the system.</p>', 'RegisterDefaultPatchBaseline' => '<p>Defines the default patch baseline.</p>', 'RegisterPatchBaselineForPatchGroup' => '<p>Registers a patch baseline for a patch group.</p>', 'RegisterTargetWithMaintenanceWindow' => '<p>Registers a target with a Maintenance Window.</p>', 'RegisterTaskWithMaintenanceWindow' => '<p>Adds a new task to a Maintenance Window.</p>', 'RemoveTagsFromResource' => '<p>Removes all tags from the specified resource.</p>', 'SendAutomationSignal' => '<p>Sends a signal to an Automation execution to change the current behavior or status of the execution. </p>', 'SendCommand' => '<p>Executes commands on one or more managed instances.</p>', 'StartAutomationExecution' => '<p>Initiates execution of an Automation document.</p>', 'StopAutomationExecution' => '<p>Stop an Automation that is currently executing.</p>', 'UpdateAssociation' => '<p>Updates an association. You can only update the document version, schedule, parameters, and Amazon S3 output of an association.</p>', 'UpdateAssociationStatus' => '<p>Updates the status of the Systems Manager document associated with the specified instance.</p>', 'UpdateDocument' => '<p>The document you want to update.</p>', 'UpdateDocumentDefaultVersion' => '<p>Set the default version of a document. </p>', 'UpdateMaintenanceWindow' => '<p>Updates an existing Maintenance Window. Only specified parameters are modified.</p>', 'UpdateMaintenanceWindowTarget' => '<p>Modifies the target of an existing Maintenance Window. You can\'t change the target type, but you can change the following:</p> <p>The target from being an ID target to a Tag target, or a Tag target to an ID target.</p> <p>The IDs of an ID target.</p> <p>The tags of a Tag target.</p> <p>The Owner.</p> <p>The Name.</p> <p>The Description.</p> <p>Also note that if a parameter is null, then the corresponding field is not modified.</p>', 'UpdateMaintenanceWindowTask' => '<p>Modifies a task assigned to a Maintenance Window. You can\'t change the task type, but you can change the following:</p> <p>The Task Arn. For example, you can change a RUN_COMMAND task from AWS-RunPowerShellScript to AWS-RunShellScript.</p> <p>The service role ARN.</p> <p>The task parameters.</p> <p>The task priority.</p> <p>The task MaxConcurrency and MaxErrors.</p> <p>The log location.</p> <p>If a parameter is null, then the corresponding field is not modified. Also, if you set Replace to true, then all fields required by the RegisterTaskWithMaintenanceWindow operation are required for this request. Optional fields that aren\'t specified are be set to null.</p>', 'UpdateManagedInstanceRole' => '<p>Assigns or changes an Amazon Identity and Access Management (IAM) role to the managed instance.</p>', 'UpdatePatchBaseline' => '<p>Modifies an existing patch baseline. Fields not specified in the request are left unchanged.</p>', ], 'shapes' => [ 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountIdList$member' => NULL, ], ], 'AccountIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeDocumentPermissionResponse$AccountIds' => '<p>The account IDs that have permission to use this document. The ID can be either an AWS account or <i>All</i>.</p>', 'ModifyDocumentPermissionRequest$AccountIdsToAdd' => '<p>The AWS user accounts that should have access to the document. The account IDs can either be a group of account IDs or <i>All</i>.</p>', 'ModifyDocumentPermissionRequest$AccountIdsToRemove' => '<p>The AWS user accounts that should no longer have access to the document. The AWS user account can either be a group of account IDs or <i>All</i>. This action has a higher priority than <i>AccountIdsToAdd</i>. If you specify an account ID to add and the same ID to remove, the system removes access to the document.</p>', ], ], 'Activation' => [ 'base' => '<p>An activation registers one or more on-premises servers or virtual machines (VMs) with AWS so that you can configure those servers or VMs using Run Command. A server or VM that has been registered with AWS is called a managed instance.</p>', 'refs' => [ 'ActivationList$member' => NULL, ], ], 'ActivationCode' => [ 'base' => NULL, 'refs' => [ 'CreateActivationResult$ActivationCode' => '<p>The code the system generates when it processes the activation. The activation code functions like a password to validate the activation ID. </p>', ], ], 'ActivationDescription' => [ 'base' => NULL, 'refs' => [ 'Activation$Description' => '<p>A user defined description of the activation.</p>', 'CreateActivationRequest$Description' => '<p>A userdefined description of the resource that you want to register with Amazon EC2. </p>', ], ], 'ActivationId' => [ 'base' => NULL, 'refs' => [ 'Activation$ActivationId' => '<p>The ID created by Systems Manager when you submitted the activation.</p>', 'CreateActivationResult$ActivationId' => '<p>The ID number generated by the system when it processed the activation. The activation ID functions like a user name.</p>', 'DeleteActivationRequest$ActivationId' => '<p>The ID of the activation that you want to delete.</p>', 'InstanceInformation$ActivationId' => '<p>The activation ID created by Systems Manager when the server or VM was registered.</p>', ], ], 'ActivationList' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsResult$ActivationList' => '<p>A list of activations for your AWS account.</p>', ], ], 'AddTagsToResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsToResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'AgentErrorCode' => [ 'base' => NULL, 'refs' => [ 'InstanceAssociationStatusInfo$ErrorCode' => '<p>An error code returned by the request to create the association.</p>', ], ], 'AllowedPattern' => [ 'base' => NULL, 'refs' => [ 'ParameterHistory$AllowedPattern' => '<p>Parameter names can include the following letters and symbols.</p> <p>a-zA-Z0-9_.-</p>', 'ParameterMetadata$AllowedPattern' => '<p>A parameter name can include only the following letters and symbols.</p> <p>a-zA-Z0-9_.-</p>', 'PutParameterRequest$AllowedPattern' => '<p>A regular expression used to validate the parameter value. For example, for String types with values restricted to numbers, you can specify the following: AllowedPattern=^\\d+$ </p>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>Error returned if an attempt is made to register a patch group with a patch baseline that is already registered with a different patch baseline.</p>', 'refs' => [], ], 'ApproveAfterDays' => [ 'base' => NULL, 'refs' => [ 'PatchRule$ApproveAfterDays' => '<p>The number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline.</p>', ], ], 'AssociatedInstances' => [ 'base' => '<p>You must disassociate a document from all instances before you can delete it.</p>', 'refs' => [], ], 'Association' => [ 'base' => '<p>Describes an association of a Systems Manager document and an instance.</p>', 'refs' => [ 'AssociationList$member' => NULL, ], ], 'AssociationAlreadyExists' => [ 'base' => '<p>The specified association already exists.</p>', 'refs' => [], ], 'AssociationDescription' => [ 'base' => '<p>Describes the parameters for a document.</p>', 'refs' => [ 'AssociationDescriptionList$member' => NULL, 'CreateAssociationResult$AssociationDescription' => '<p>Information about the association.</p>', 'DescribeAssociationResult$AssociationDescription' => '<p>Information about the association.</p>', 'UpdateAssociationResult$AssociationDescription' => '<p>The description of the association that was updated.</p>', 'UpdateAssociationStatusResult$AssociationDescription' => '<p>Information about the association.</p>', ], ], 'AssociationDescriptionList' => [ 'base' => NULL, 'refs' => [ 'CreateAssociationBatchResult$Successful' => '<p>Information about the associations that succeeded.</p>', ], ], 'AssociationDoesNotExist' => [ 'base' => '<p>The specified association does not exist.</p>', 'refs' => [], ], 'AssociationFilter' => [ 'base' => '<p>Describes a filter.</p>', 'refs' => [ 'AssociationFilterList$member' => NULL, ], ], 'AssociationFilterKey' => [ 'base' => NULL, 'refs' => [ 'AssociationFilter$key' => '<p>The name of the filter.</p>', ], ], 'AssociationFilterList' => [ 'base' => NULL, 'refs' => [ 'ListAssociationsRequest$AssociationFilterList' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', ], ], 'AssociationFilterValue' => [ 'base' => NULL, 'refs' => [ 'AssociationFilter$value' => '<p>The filter value.</p>', ], ], 'AssociationId' => [ 'base' => NULL, 'refs' => [ 'Association$AssociationId' => '<p>The ID created by the system when you create an association. An association is a binding between a document and a set of targets with a schedule.</p>', 'AssociationDescription$AssociationId' => '<p>The association ID.</p>', 'DeleteAssociationRequest$AssociationId' => '<p>The association ID that you want to delete.</p>', 'DescribeAssociationRequest$AssociationId' => '<p>The association ID for which you want information.</p>', 'InstanceAssociation$AssociationId' => '<p>The association ID.</p>', 'InstanceAssociationStatusInfo$AssociationId' => '<p>The association ID.</p>', 'UpdateAssociationRequest$AssociationId' => '<p>The ID of the association you want to update. </p>', ], ], 'AssociationLimitExceeded' => [ 'base' => '<p>You can have at most 2,000 active associations.</p>', 'refs' => [], ], 'AssociationList' => [ 'base' => NULL, 'refs' => [ 'ListAssociationsResult$Associations' => '<p>The associations.</p>', ], ], 'AssociationOverview' => [ 'base' => '<p>Information about the association.</p>', 'refs' => [ 'Association$Overview' => '<p>Information about the association.</p>', 'AssociationDescription$Overview' => '<p>Information about the association.</p>', ], ], 'AssociationStatus' => [ 'base' => '<p>Describes an association status.</p>', 'refs' => [ 'AssociationDescription$Status' => '<p>The association status.</p>', 'UpdateAssociationStatusRequest$AssociationStatus' => '<p>The association status.</p>', ], ], 'AssociationStatusAggregatedCount' => [ 'base' => NULL, 'refs' => [ 'AssociationOverview$AssociationStatusAggregatedCount' => '<p>Returns the number of targets for the association status. For example, if you created an association with two instances, and one of them was successful, this would return the count of instances by status.</p>', ], ], 'AssociationStatusName' => [ 'base' => NULL, 'refs' => [ 'AssociationStatus$Name' => '<p>The status.</p>', ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'ComplianceItemDetails$key' => NULL, 'InventoryItemContentContext$key' => NULL, 'InventoryItemEntry$key' => NULL, ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'ComplianceItemDetails$value' => NULL, 'InventoryItemContentContext$value' => NULL, 'InventoryItemEntry$value' => NULL, ], ], 'AutomationActionName' => [ 'base' => NULL, 'refs' => [ 'StepExecution$Action' => '<p>The action this step performs. The action determines the behavior of the step.</p>', ], ], 'AutomationDefinitionNotFoundException' => [ 'base' => '<p>An Automation document with the specified name could not be found.</p>', 'refs' => [], ], 'AutomationDefinitionVersionNotFoundException' => [ 'base' => '<p>An Automation document with the specified name and version could not be found.</p>', 'refs' => [], ], 'AutomationExecution' => [ 'base' => '<p>Detailed information about the current state of an individual Automation execution.</p>', 'refs' => [ 'GetAutomationExecutionResult$AutomationExecution' => '<p>Detailed information about the current state of an automation execution.</p>', ], ], 'AutomationExecutionFilter' => [ 'base' => '<p>A filter used to match specific automation executions. This is used to limit the scope of Automation execution information returned.</p>', 'refs' => [ 'AutomationExecutionFilterList$member' => NULL, ], ], 'AutomationExecutionFilterKey' => [ 'base' => NULL, 'refs' => [ 'AutomationExecutionFilter$Key' => '<p>The aspect of the Automation execution information that should be limited.</p>', ], ], 'AutomationExecutionFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAutomationExecutionsRequest$Filters' => '<p>Filters used to limit the scope of executions that are requested.</p>', ], ], 'AutomationExecutionFilterValue' => [ 'base' => NULL, 'refs' => [ 'AutomationExecutionFilterValueList$member' => NULL, ], ], 'AutomationExecutionFilterValueList' => [ 'base' => NULL, 'refs' => [ 'AutomationExecutionFilter$Values' => '<p>The values used to limit the execution information associated with the filter\'s key.</p>', ], ], 'AutomationExecutionId' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$AutomationExecutionId' => '<p>The execution ID.</p>', 'AutomationExecutionMetadata$AutomationExecutionId' => '<p>The execution ID.</p>', 'GetAutomationExecutionRequest$AutomationExecutionId' => '<p>The unique identifier for an existing automation execution to examine. The execution ID is returned by StartAutomationExecution when the execution of an Automation document is initiated.</p>', 'SendAutomationSignalRequest$AutomationExecutionId' => '<p>The unique identifier for an existing Automation execution that you want to send the signal to.</p>', 'StartAutomationExecutionResult$AutomationExecutionId' => '<p>The unique ID of a newly scheduled automation execution.</p>', 'StopAutomationExecutionRequest$AutomationExecutionId' => '<p>The execution ID of the Automation to stop.</p>', ], ], 'AutomationExecutionLimitExceededException' => [ 'base' => '<p>The number of simultaneously running Automation executions exceeded the allowable limit.</p>', 'refs' => [], ], 'AutomationExecutionMetadata' => [ 'base' => '<p>Details about a specific Automation execution.</p>', 'refs' => [ 'AutomationExecutionMetadataList$member' => NULL, ], ], 'AutomationExecutionMetadataList' => [ 'base' => NULL, 'refs' => [ 'DescribeAutomationExecutionsResult$AutomationExecutionMetadataList' => '<p>The list of details about each automation execution which has occurred which matches the filter specification, if any.</p>', ], ], 'AutomationExecutionNotFoundException' => [ 'base' => '<p>There is no automation execution information for the requested automation execution ID.</p>', 'refs' => [], ], 'AutomationExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$AutomationExecutionStatus' => '<p>The execution status of the Automation.</p>', 'AutomationExecutionMetadata$AutomationExecutionStatus' => '<p>The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.</p>', 'StepExecution$StepStatus' => '<p>The execution status for this step. Valid values include: Pending, InProgress, Success, Cancelled, Failed, and TimedOut.</p>', ], ], 'AutomationParameterKey' => [ 'base' => NULL, 'refs' => [ 'AutomationParameterMap$key' => NULL, ], ], 'AutomationParameterMap' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$Parameters' => '<p>The key-value map of execution parameters, which were supplied when calling StartAutomationExecution.</p>', 'AutomationExecution$Outputs' => '<p>The list of execution outputs as defined in the automation document.</p>', 'AutomationExecutionMetadata$Outputs' => '<p>The list of execution outputs as defined in the Automation document.</p>', 'FailureDetails$Details' => '<p>Detailed information about the Automation step failure.</p>', 'MaintenanceWindowAutomationParameters$Parameters' => '<p>Parameters for the AUTOMATION task.</p>', 'SendAutomationSignalRequest$Payload' => '<p>The data sent with the signal. The data schema depends on the type of signal used in the request. </p>', 'StartAutomationExecutionRequest$Parameters' => '<p>A key-value map of execution parameters, which match the declared parameters in the Automation document.</p>', 'StepExecution$Outputs' => '<p>Returned values from the execution of the step.</p>', ], ], 'AutomationParameterValue' => [ 'base' => NULL, 'refs' => [ 'AutomationParameterValueList$member' => NULL, ], ], 'AutomationParameterValueList' => [ 'base' => NULL, 'refs' => [ 'AutomationParameterMap$value' => NULL, ], ], 'BaselineDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$Description' => '<p>A description of the patch baseline.</p>', 'GetPatchBaselineResult$Description' => '<p>A description of the patch baseline.</p>', 'PatchBaselineIdentity$BaselineDescription' => '<p>The description of the patch baseline.</p>', 'UpdatePatchBaselineRequest$Description' => '<p>A description of the patch baseline.</p>', 'UpdatePatchBaselineResult$Description' => '<p>A description of the Patch Baseline.</p>', ], ], 'BaselineId' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineResult$BaselineId' => '<p>The ID of the created patch baseline.</p>', 'DeletePatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline to delete.</p>', 'DeletePatchBaselineResult$BaselineId' => '<p>The ID of the deleted patch baseline.</p>', 'DeregisterPatchBaselineForPatchGroupRequest$BaselineId' => '<p>The ID of the patch baseline to deregister the patch group from.</p>', 'DeregisterPatchBaselineForPatchGroupResult$BaselineId' => '<p>The ID of the patch baseline the patch group was deregistered from.</p>', 'DescribeEffectivePatchesForPatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline to retrieve the effective patches for.</p>', 'GetDefaultPatchBaselineResult$BaselineId' => '<p>The ID of the default patch baseline.</p>', 'GetPatchBaselineForPatchGroupResult$BaselineId' => '<p>The ID of the patch baseline that should be used for the patch group.</p>', 'GetPatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline to retrieve.</p>', 'GetPatchBaselineResult$BaselineId' => '<p>The ID of the retrieved patch baseline.</p>', 'InstancePatchState$BaselineId' => '<p>The ID of the patch baseline used to patch the instance.</p>', 'PatchBaselineIdentity$BaselineId' => '<p>The ID of the patch baseline.</p>', 'RegisterDefaultPatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline that should be the default patch baseline.</p>', 'RegisterDefaultPatchBaselineResult$BaselineId' => '<p>The ID of the default patch baseline.</p>', 'RegisterPatchBaselineForPatchGroupRequest$BaselineId' => '<p>The ID of the patch baseline to register the patch group with.</p>', 'RegisterPatchBaselineForPatchGroupResult$BaselineId' => '<p>The ID of the patch baseline the patch group was registered with.</p>', 'UpdatePatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline to update.</p>', 'UpdatePatchBaselineResult$BaselineId' => '<p>The ID of the deleted patch baseline.</p>', ], ], 'BaselineName' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$Name' => '<p>The name of the patch baseline.</p>', 'GetPatchBaselineResult$Name' => '<p>The name of the patch baseline.</p>', 'PatchBaselineIdentity$BaselineName' => '<p>The name of the patch baseline.</p>', 'UpdatePatchBaselineRequest$Name' => '<p>The name of the patch baseline.</p>', 'UpdatePatchBaselineResult$Name' => '<p>The name of the patch baseline.</p>', ], ], 'BatchErrorMessage' => [ 'base' => NULL, 'refs' => [ 'FailedCreateAssociation$Message' => '<p>A description of the failure.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Activation$Expired' => '<p>Whether or not the activation is expired.</p>', 'DeregisterTargetFromMaintenanceWindowRequest$Safe' => '<p>The system checks if the target is being referenced by a task. If the target is being referenced, the system returns and error and does not deregister the target from the Maintenance Window.</p>', 'DocumentVersionInfo$IsDefaultVersion' => '<p>An identifier for the default version of the document.</p>', 'GetParameterHistoryRequest$WithDecryption' => '<p>Return decrypted values for secure string parameters. This flag is ignored for String and StringList parameter types.</p>', 'GetParameterRequest$WithDecryption' => '<p>Return decrypted values for secure string parameters. This flag is ignored for String and StringList parameter types.</p>', 'GetParametersByPathRequest$Recursive' => '<p>Retrieve all parameters within a hierarchy.</p>', 'GetParametersByPathRequest$WithDecryption' => '<p>Retrieve all parameters in a hierarchy with their value decrypted.</p>', 'GetParametersRequest$WithDecryption' => '<p>Return decrypted secure string value. Return decrypted values for secure string parameters. This flag is ignored for String and StringList parameter types.</p>', 'InstanceInformation$IsLatestVersion' => '<p>Indicates whether latest version of the SSM Agent is running on your instance. </p>', 'ListCommandInvocationsRequest$Details' => '<p>(Optional) If set this returns the response of the command executions and any command output. By default this is set to False. </p>', 'PutParameterRequest$Overwrite' => '<p>Overwrite an existing parameter. If not specified, will default to "false".</p>', 'UpdateMaintenanceWindowRequest$Replace' => '<p>If you specify True, then all fields that are required by the CreateMaintenanceWindow API are also required for this API request. Optional fields that are not specified will be set to null. </p>', 'UpdateMaintenanceWindowTargetRequest$Replace' => '<p>If you specify True, then all fields that are required by the RegisterTargetWithMaintenanceWindow API are also required for this API request. Optional fields that are not specified will be set to null.</p>', 'UpdateMaintenanceWindowTaskRequest$Replace' => '<p>If you specify True, then all fields that are required by the RegisterTaskWithMaintenanceWndow API are also required for this API request. Optional fields that are not specified will be set to null.</p>', ], ], 'CancelCommandRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'CancelCommandResult' => [ 'base' => '<p>Whether or not the command was successfully canceled. There is no guarantee that a request can be canceled.</p>', 'refs' => [], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$ClientToken' => '<p>User-provided idempotency token.</p>', 'CreatePatchBaselineRequest$ClientToken' => '<p>User-provided idempotency token.</p>', 'RegisterTargetWithMaintenanceWindowRequest$ClientToken' => '<p>User-provided idempotency token.</p>', 'RegisterTaskWithMaintenanceWindowRequest$ClientToken' => '<p>User-provided idempotency token.</p>', ], ], 'Command' => [ 'base' => '<p>Describes a command request.</p>', 'refs' => [ 'CommandList$member' => NULL, 'SendCommandResult$Command' => '<p>The request as it was received by Systems Manager. Also provides the command ID which can be used future references to this request.</p>', ], ], 'CommandFilter' => [ 'base' => '<p>Describes a command filter.</p>', 'refs' => [ 'CommandFilterList$member' => NULL, ], ], 'CommandFilterKey' => [ 'base' => NULL, 'refs' => [ 'CommandFilter$key' => '<p>The name of the filter.</p>', ], ], 'CommandFilterList' => [ 'base' => NULL, 'refs' => [ 'ListCommandInvocationsRequest$Filters' => '<p>(Optional) One or more filters. Use a filter to return a more specific list of results.</p>', 'ListCommandsRequest$Filters' => '<p>(Optional) One or more filters. Use a filter to return a more specific list of results. </p>', ], ], 'CommandFilterValue' => [ 'base' => NULL, 'refs' => [ 'CommandFilter$value' => '<p>The filter value. </p>', ], ], 'CommandId' => [ 'base' => NULL, 'refs' => [ 'CancelCommandRequest$CommandId' => '<p>The ID of the command you want to cancel.</p>', 'Command$CommandId' => '<p>A unique identifier for this command.</p>', 'CommandInvocation$CommandId' => '<p>The command against which this invocation was requested.</p>', 'GetCommandInvocationRequest$CommandId' => '<p>(Required) The parent command ID of the invocation plugin.</p>', 'GetCommandInvocationResult$CommandId' => '<p>The parent command ID of the invocation plugin.</p>', 'ListCommandInvocationsRequest$CommandId' => '<p>(Optional) The invocations for a specific command ID.</p>', 'ListCommandsRequest$CommandId' => '<p>(Optional) If provided, lists only the specified command.</p>', ], ], 'CommandInvocation' => [ 'base' => '<p>An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A command invocation applies to one instance. For example, if a user executes SendCommand against three instances, then a command invocation is created for each requested instance ID. A command invocation returns status and detail information about a command you executed. </p>', 'refs' => [ 'CommandInvocationList$member' => NULL, ], ], 'CommandInvocationList' => [ 'base' => NULL, 'refs' => [ 'ListCommandInvocationsResult$CommandInvocations' => '<p>(Optional) A list of all invocations. </p>', ], ], 'CommandInvocationStatus' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$Status' => '<p>Whether or not the invocation succeeded, failed, or is pending.</p>', 'GetCommandInvocationResult$Status' => '<p>The status of the parent command for this invocation. This status can be different than StatusDetails.</p>', ], ], 'CommandList' => [ 'base' => NULL, 'refs' => [ 'ListCommandsResult$Commands' => '<p>(Optional) The list of commands requested by the user. </p>', ], ], 'CommandMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCommandInvocationsRequest$MaxResults' => '<p>(Optional) The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListCommandsRequest$MaxResults' => '<p>(Optional) The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'CommandPlugin' => [ 'base' => '<p>Describes plugin details.</p>', 'refs' => [ 'CommandPluginList$member' => NULL, ], ], 'CommandPluginList' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$CommandPlugins' => NULL, ], ], 'CommandPluginName' => [ 'base' => NULL, 'refs' => [ 'CommandPlugin$Name' => '<p>The name of the plugin. Must be one of the following: aws:updateAgent, aws:domainjoin, aws:applications, aws:runPowerShellScript, aws:psmodule, aws:cloudWatch, aws:runShellScript, or aws:updateSSMAgent. </p>', 'GetCommandInvocationRequest$PluginName' => '<p>(Optional) The name of the plugin for which you want detailed results. If the document contains only one plugin, the name can be omitted and the details will be returned.</p>', 'GetCommandInvocationResult$PluginName' => '<p>The name of the plugin for which you want detailed results. For example, aws:RunShellScript is a plugin.</p>', ], ], 'CommandPluginOutput' => [ 'base' => NULL, 'refs' => [ 'CommandPlugin$Output' => '<p>Output of the plugin execution.</p>', ], ], 'CommandPluginStatus' => [ 'base' => NULL, 'refs' => [ 'CommandPlugin$Status' => '<p>The status of this plugin. You can execute a document with multiple plugins.</p>', ], ], 'CommandStatus' => [ 'base' => NULL, 'refs' => [ 'Command$Status' => '<p>The status of the command.</p>', ], ], 'Comment' => [ 'base' => NULL, 'refs' => [ 'Command$Comment' => '<p>User-specified information about the command, such as a brief description of what the command should do.</p>', 'CommandInvocation$Comment' => '<p>User-specified information about the command, such as a brief description of what the command should do.</p>', 'GetCommandInvocationResult$Comment' => '<p>The comment text for the command.</p>', 'MaintenanceWindowRunCommandParameters$Comment' => '<p>Information about the command(s) to execute.</p>', 'SendCommandRequest$Comment' => '<p>User-specified information about the command, such as a brief description of what the command should do.</p>', ], ], 'CompletedCount' => [ 'base' => NULL, 'refs' => [ 'Command$CompletedCount' => '<p>The number of targets for which the command invocation reached a terminal state. Terminal states include the following: Success, Failed, Execution Timed Out, Delivery Timed Out, Canceled, Terminated, or Undeliverable.</p>', ], ], 'ComplianceExecutionId' => [ 'base' => NULL, 'refs' => [ 'ComplianceExecutionSummary$ExecutionId' => '<p>An ID created by the system when <code>PutComplianceItems</code> was called. For example, <code>CommandID</code> is a valid execution ID. You can use this ID in subsequent calls.</p>', ], ], 'ComplianceExecutionSummary' => [ 'base' => '<p>A summary of the call execution that includes an execution ID, the type of execution (for example, <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the following format: yyyy-MM-dd\'T\'HH:mm:ss\'Z\'.</p>', 'refs' => [ 'ComplianceItem$ExecutionSummary' => '<p>A summary for the compliance item. The summary includes an execution ID, the execution type (for example, command), and the execution time.</p>', 'PutComplianceItemsRequest$ExecutionSummary' => '<p>A summary of the call execution that includes an execution ID, the type of execution (for example, <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the following format: yyyy-MM-dd\'T\'HH:mm:ss\'Z\'.</p>', 'ResourceComplianceSummaryItem$ExecutionSummary' => '<p>Information about the execution.</p>', ], ], 'ComplianceExecutionType' => [ 'base' => NULL, 'refs' => [ 'ComplianceExecutionSummary$ExecutionType' => '<p>The type of execution. For example, <code>Command</code> is a valid execution type.</p>', ], ], 'ComplianceFilterValue' => [ 'base' => NULL, 'refs' => [ 'ComplianceStringFilterValueList$member' => NULL, ], ], 'ComplianceItem' => [ 'base' => '<p>Information about the compliance as defined by the resource type. For example, for a patch resource type, <code>Items</code> includes information about the PatchSeverity, Classification, etc.</p>', 'refs' => [ 'ComplianceItemList$member' => NULL, ], ], 'ComplianceItemContentHash' => [ 'base' => NULL, 'refs' => [ 'PutComplianceItemsRequest$ItemContentHash' => '<p>MD5 or Sha256 content hash. The content hash is used to determine if existing information should be overwritten or ignored. If the content hashes match, ,the request to put compliance information is ignored.</p>', ], ], 'ComplianceItemDetails' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Details' => '<p>A "Key": "Value" tag combination for the compliance item.</p>', 'ComplianceItemEntry$Details' => '<p>A "Key": "Value" tag combination for the compliance item.</p>', ], ], 'ComplianceItemEntry' => [ 'base' => '<p>Information about a compliance item.</p>', 'refs' => [ 'ComplianceItemEntryList$member' => NULL, ], ], 'ComplianceItemEntryList' => [ 'base' => NULL, 'refs' => [ 'PutComplianceItemsRequest$Items' => '<p>Information about the compliance as defined by the resource type. For example, for a patch compliance type, <code>Items</code> includes information about the PatchSeverity, Classification, etc.</p>', ], ], 'ComplianceItemId' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Id' => '<p>An ID for the compliance item. For example, if the compliance item is a Windows patch, the ID could be the number of the KB article. Here\'s an example: KB4010320.</p>', 'ComplianceItemEntry$Id' => '<p>The compliance item ID. For example, if the compliance item is a Windows patch, the ID could be the number of the KB article.</p>', ], ], 'ComplianceItemList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceItemsResult$ComplianceItems' => '<p>A list of compliance information for the specified resource ID. </p>', ], ], 'ComplianceItemTitle' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Title' => '<p>A title for the compliance item. For example, if the compliance item is a Windows patch, the title could be the title of the KB article for the patch. Here\'s an example: Security Update for Active Directory Federation Services.</p>', 'ComplianceItemEntry$Title' => '<p>The title of the compliance item. For example, if the compliance item is a Windows patch, the title could be the title of the KB article for the patch. Here\'s an example: Security Update for Active Directory Federation Services. </p>', ], ], 'ComplianceQueryOperatorType' => [ 'base' => NULL, 'refs' => [ 'ComplianceStringFilter$Type' => '<p>The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith, LessThan, or GreaterThan.</p>', ], ], 'ComplianceResourceId' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$ResourceId' => '<p>An ID for the resource. For a managed instance, this is the instance ID.</p>', 'ComplianceResourceIdList$member' => NULL, 'PutComplianceItemsRequest$ResourceId' => '<p>Specify an ID for this resource. For a managed instance, this is the instance ID.</p>', 'ResourceComplianceSummaryItem$ResourceId' => '<p>The resource ID.</p>', ], ], 'ComplianceResourceIdList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceItemsRequest$ResourceIds' => '<p>The ID for the resources from which you want to get compliance information. Currently, you can only specify one resource ID.</p>', ], ], 'ComplianceResourceType' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$ResourceType' => '<p>The type of resource. <code>ManagedInstance</code> is currently the only supported resource type.</p>', 'ComplianceResourceTypeList$member' => NULL, 'PutComplianceItemsRequest$ResourceType' => '<p>Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource type.</p>', 'ResourceComplianceSummaryItem$ResourceType' => '<p>The resource type.</p>', ], ], 'ComplianceResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceItemsRequest$ResourceTypes' => '<p>The type of resource from which you want to get compliance information. Currently, the only supported resource type is <code>ManagedInstance</code>.</p>', ], ], 'ComplianceSeverity' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Severity' => '<p>The severity of the compliance status. Severity can be one of the following: Critical, HIGH, Medium, Low, Informational, Unspecified.</p>', 'ComplianceItemEntry$Severity' => '<p>The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low, Informational, Unspecified.</p>', 'ResourceComplianceSummaryItem$OverallSeverity' => '<p>The highest severity item found for the resource. The resource is compliant for this item.</p>', ], ], 'ComplianceStatus' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Status' => '<p>The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.</p>', 'ComplianceItemEntry$Status' => '<p>The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.</p>', 'ResourceComplianceSummaryItem$Status' => '<p>The compliance status for the resource.</p>', ], ], 'ComplianceStringFilter' => [ 'base' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', 'refs' => [ 'ComplianceStringFilterList$member' => NULL, ], ], 'ComplianceStringFilterKey' => [ 'base' => NULL, 'refs' => [ 'ComplianceStringFilter$Key' => '<p>The name of the filter.</p>', ], ], 'ComplianceStringFilterList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceItemsRequest$Filters' => '<p>One or more compliance filters. Use a filter to return a more specific list of results.</p>', 'ListComplianceSummariesRequest$Filters' => '<p>One or more compliance or inventory filters. Use a filter to return a more specific list of results.</p>', 'ListResourceComplianceSummariesRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', ], ], 'ComplianceStringFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ComplianceStringFilter$Values' => '<p>The value you want to search for.</p>', ], ], 'ComplianceSummaryCount' => [ 'base' => NULL, 'refs' => [ 'CompliantSummary$CompliantCount' => '<p>The total number of resources that are compliant.</p>', 'NonCompliantSummary$NonCompliantCount' => '<p>The total number of compliance items that are not compliant.</p>', 'SeveritySummary$CriticalCount' => '<p>The total number of resources or compliance items that have a severity level of critical. Critical severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$HighCount' => '<p>The total number of resources or compliance items that have a severity level of high. High severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$MediumCount' => '<p>The total number of resources or compliance items that have a severity level of medium. Medium severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$LowCount' => '<p>The total number of resources or compliance items that have a severity level of low. Low severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$InformationalCount' => '<p>The total number of resources or compliance items that have a severity level of informational. Informational severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$UnspecifiedCount' => '<p>The total number of resources or compliance items that have a severity level of unspecified. Unspecified severity is determined by the organization that published the compliance items.</p>', ], ], 'ComplianceSummaryItem' => [ 'base' => '<p>A summary of compliance information by compliance type.</p>', 'refs' => [ 'ComplianceSummaryItemList$member' => NULL, ], ], 'ComplianceSummaryItemList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceSummariesResult$ComplianceSummaryItems' => '<p>A list of compliant and non-compliant summary counts based on compliance types. For example, this call returns State Manager associations, patches, or custom compliance types according to the filter criteria you specified.</p>', ], ], 'ComplianceTypeCountLimitExceededException' => [ 'base' => '<p>You specified too many custom compliance types. You can specify a maximum of 10 different types. </p>', 'refs' => [], ], 'ComplianceTypeName' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$ComplianceType' => '<p>The compliance type. For example, Association (for a State Manager association), Patch, or Custom:<code>string</code> are all valide compliance types.</p>', 'ComplianceSummaryItem$ComplianceType' => '<p>The type of compliance item. For example, the compliance type can be Association, Patch, or Custom:string.</p>', 'PutComplianceItemsRequest$ComplianceType' => '<p>Specify the compliance type. For example, specify Association (for a State Manager association), Patch, or Custom:<code>string</code>.</p>', 'ResourceComplianceSummaryItem$ComplianceType' => '<p>The compliance type.</p>', ], ], 'CompliantSummary' => [ 'base' => '<p>A summary of resources that are compliant. The summary is organized according to the resource count for each compliance type.</p>', 'refs' => [ 'ComplianceSummaryItem$CompliantSummary' => '<p>A list of COMPLIANT items for the specified compliance type.</p>', 'ResourceComplianceSummaryItem$CompliantSummary' => '<p>A list of items that are compliant for the resource.</p>', ], ], 'ComputerName' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$ComputerName' => '<p>The fully qualified host name of the managed instance.</p>', ], ], 'CreateActivationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateActivationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssociationBatchRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssociationBatchRequestEntries' => [ 'base' => NULL, 'refs' => [ 'CreateAssociationBatchRequest$Entries' => '<p>One or more associations.</p>', ], ], 'CreateAssociationBatchRequestEntry' => [ 'base' => '<p>Describes the association of a Systems Manager document and an instance.</p>', 'refs' => [ 'CreateAssociationBatchRequestEntries$member' => NULL, 'FailedCreateAssociation$Entry' => '<p>The association.</p>', ], ], 'CreateAssociationBatchResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'CreatePatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceDataSyncRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceDataSyncResult' => [ 'base' => NULL, 'refs' => [], ], 'CreatedDate' => [ 'base' => NULL, 'refs' => [ 'Activation$CreatedDate' => '<p>The date the activation was created.</p>', ], ], 'CustomSchemaCountLimitExceededException' => [ 'base' => '<p>You have exceeded the limit for custom schemas. Delete one or more custom schemas and try again.</p>', 'refs' => [], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'Association$LastExecutionDate' => '<p>The date on which the association was last run.</p>', 'AssociationDescription$Date' => '<p>The date when the association was made.</p>', 'AssociationDescription$LastUpdateAssociationDate' => '<p>The date when the association was last updated.</p>', 'AssociationDescription$LastExecutionDate' => '<p>The date on which the association was last run.</p>', 'AssociationDescription$LastSuccessfulExecutionDate' => '<p>The last date on which the association was successfully run.</p>', 'AssociationStatus$Date' => '<p>The date when the status changed.</p>', 'AutomationExecution$ExecutionStartTime' => '<p>The time the execution started.</p>', 'AutomationExecution$ExecutionEndTime' => '<p>The time the execution finished.</p>', 'AutomationExecutionMetadata$ExecutionStartTime' => '<p>The time the execution started.&gt;</p>', 'AutomationExecutionMetadata$ExecutionEndTime' => '<p>The time the execution finished. This is not populated if the execution is still in progress.</p>', 'Command$ExpiresAfter' => '<p>If this time is reached and the command has not already started executing, it will not execute. Calculated based on the ExpiresAfter user input provided as part of the SendCommand API.</p>', 'Command$RequestedDateTime' => '<p>The date and time the command was requested.</p>', 'CommandInvocation$RequestedDateTime' => '<p>The time and date the request was sent to this instance.</p>', 'CommandPlugin$ResponseStartDateTime' => '<p>The time the plugin started executing. </p>', 'CommandPlugin$ResponseFinishDateTime' => '<p>The time the plugin stopped executing. Could stop prematurely if, for example, a cancel command was sent. </p>', 'ComplianceExecutionSummary$ExecutionTime' => '<p>The time the execution ran as a datetime object that is saved in the following format: yyyy-MM-dd\'T\'HH:mm:ss\'Z\'.</p>', 'DocumentDescription$CreatedDate' => '<p>The date when the document was created.</p>', 'DocumentVersionInfo$CreatedDate' => '<p>The date the document was created.</p>', 'GetMaintenanceWindowExecutionResult$StartTime' => '<p>The time the Maintenance Window started executing.</p>', 'GetMaintenanceWindowExecutionResult$EndTime' => '<p>The time the Maintenance Window finished executing.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$StartTime' => '<p>The time the task started executing on the target.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$EndTime' => '<p>The time the task finished executing on the target.</p>', 'GetMaintenanceWindowExecutionTaskResult$StartTime' => '<p>The time the task execution started.</p>', 'GetMaintenanceWindowExecutionTaskResult$EndTime' => '<p>The time the task execution completed.</p>', 'GetMaintenanceWindowResult$CreatedDate' => '<p>The date the Maintenance Window was created.</p>', 'GetMaintenanceWindowResult$ModifiedDate' => '<p>The date the Maintenance Window was last modified.</p>', 'GetPatchBaselineResult$CreatedDate' => '<p>The date the patch baseline was created.</p>', 'GetPatchBaselineResult$ModifiedDate' => '<p>The date the patch baseline was last modified.</p>', 'InstanceAssociationStatusInfo$ExecutionDate' => '<p>The date the instance association executed. </p>', 'InstanceInformation$LastPingDateTime' => '<p>The date and time when agent last pinged Systems Manager service. </p>', 'InstanceInformation$RegistrationDate' => '<p>The date the server or VM was registered with AWS as a managed instance.</p>', 'InstanceInformation$LastAssociationExecutionDate' => '<p>The date the association was last executed.</p>', 'InstanceInformation$LastSuccessfulAssociationExecutionDate' => '<p>The last date the association was successfully run.</p>', 'InstancePatchState$OperationStartTime' => '<p>The time the most recent patching operation was started on the instance.</p>', 'InstancePatchState$OperationEndTime' => '<p>The time the most recent patching operation completed on the instance.</p>', 'MaintenanceWindowExecution$StartTime' => '<p>The time the execution started.</p>', 'MaintenanceWindowExecution$EndTime' => '<p>The time the execution finished.</p>', 'MaintenanceWindowExecutionTaskIdentity$StartTime' => '<p>The time the task execution started.</p>', 'MaintenanceWindowExecutionTaskIdentity$EndTime' => '<p>The time the task execution finished.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$StartTime' => '<p>The time the invocation started.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$EndTime' => '<p>The time the invocation finished.</p>', 'ParameterHistory$LastModifiedDate' => '<p>Date the parameter was last changed or updated.</p>', 'ParameterMetadata$LastModifiedDate' => '<p>Date the parameter was last changed or updated.</p>', 'Patch$ReleaseDate' => '<p>The date the patch was released.</p>', 'PatchComplianceData$InstalledTime' => '<p>The date/time the patch was installed on the instance. Note that not all operating systems provide this level of information.</p>', 'PatchStatus$ApprovalDate' => '<p>The date the patch was approved (or will be approved if the status is PENDING_APPROVAL).</p>', 'StepExecution$ExecutionStartTime' => '<p>If a step has begun execution, this contains the time the step started. If the step is in Pending status, this field is not populated.</p>', 'StepExecution$ExecutionEndTime' => '<p>If a step has finished execution, this contains the time the execution ended. If the step has not yet concluded, this field is not populated.</p>', 'UpdatePatchBaselineResult$CreatedDate' => '<p>The date when the patch baseline was created.</p>', 'UpdatePatchBaselineResult$ModifiedDate' => '<p>The date when the patch baseline was last modified.</p>', ], ], 'DefaultBaseline' => [ 'base' => NULL, 'refs' => [ 'PatchBaselineIdentity$DefaultBaseline' => '<p>Whether this is the default baseline. Note that Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.</p>', ], ], 'DefaultInstanceName' => [ 'base' => NULL, 'refs' => [ 'Activation$DefaultInstanceName' => '<p>A name for the managed instance when it is created.</p>', 'CreateActivationRequest$DefaultInstanceName' => '<p>The name of the registered, managed instance as it will appear in the Amazon EC2 console or when you use the AWS command line tools to list EC2 resources.</p>', ], ], 'DeleteActivationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteActivationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParameterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParameterResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParametersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DeletePatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceDataSyncRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceDataSyncResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterManagedInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterManagedInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterPatchBaselineForPatchGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterPatchBaselineForPatchGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTargetFromMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTargetFromMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTaskFromMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTaskFromMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActivationsFilter' => [ 'base' => '<p>Filter for the DescribeActivation API.</p>', 'refs' => [ 'DescribeActivationsFilterList$member' => NULL, ], ], 'DescribeActivationsFilterKeys' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsFilter$FilterKey' => '<p>The name of the filter.</p>', ], ], 'DescribeActivationsFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsRequest$Filters' => '<p>A filter to view information about your activations.</p>', ], ], 'DescribeActivationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActivationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutomationExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutomationExecutionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAvailablePatchesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAvailablePatchesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentPermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectiveInstanceAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectiveInstanceAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectivePatchesForPatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectivePatchesForPatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAssociationsStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAssociationsStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceInformationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceInformationResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchStatesForPatchGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchStatesForPatchGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchStatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchStatesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionTaskInvocationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowTargetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeParametersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchBaselinesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchBaselinesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchGroupStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchGroupStateResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionInDocument' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Description' => '<p>A description of the document. </p>', ], ], 'DocumentARN' => [ 'base' => NULL, 'refs' => [ 'DescribeDocumentRequest$Name' => '<p>The name of the SSM document.</p>', 'DocumentDescription$Name' => '<p>The name of the SSM document.</p>', 'DocumentIdentifier$Name' => '<p>The name of the SSM document.</p>', 'GetDocumentRequest$Name' => '<p>The name of the SSM document.</p>', 'GetDocumentResult$Name' => '<p>The name of the SSM document.</p>', 'SendCommandRequest$DocumentName' => '<p>Required. The name of the Systems Manager document to execute. This can be a public document or a custom document.</p>', 'StartAutomationExecutionRequest$DocumentName' => '<p>The name of the Automation document to use for this execution.</p>', ], ], 'DocumentAlreadyExists' => [ 'base' => '<p>The specified document already exists.</p>', 'refs' => [], ], 'DocumentContent' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$Content' => '<p>A valid JSON string.</p>', 'GetDocumentResult$Content' => '<p>The contents of the SSM document.</p>', 'InstanceAssociation$Content' => '<p>The content of the association document for the instance(s).</p>', 'UpdateDocumentRequest$Content' => '<p>The content in a document that you want to update.</p>', ], ], 'DocumentDefaultVersionDescription' => [ 'base' => '<p>A default version of a document.</p>', 'refs' => [ 'UpdateDocumentDefaultVersionResult$Description' => '<p>The description of a custom document that you want to set as the default version.</p>', ], ], 'DocumentDescription' => [ 'base' => '<p>Describes an SSM document. </p>', 'refs' => [ 'CreateDocumentResult$DocumentDescription' => '<p>Information about the Systems Manager document.</p>', 'DescribeDocumentResult$Document' => '<p>Information about the SSM document.</p>', 'UpdateDocumentResult$DocumentDescription' => '<p>A description of the document that was updated.</p>', ], ], 'DocumentFilter' => [ 'base' => '<p>Describes a filter.</p>', 'refs' => [ 'DocumentFilterList$member' => NULL, ], ], 'DocumentFilterKey' => [ 'base' => NULL, 'refs' => [ 'DocumentFilter$key' => '<p>The name of the filter.</p>', ], ], 'DocumentFilterList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentsRequest$DocumentFilterList' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', ], ], 'DocumentFilterValue' => [ 'base' => NULL, 'refs' => [ 'DocumentFilter$value' => '<p>The value of the filter.</p>', ], ], 'DocumentHash' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Hash' => '<p>The Sha256 or Sha1 hash created by the system when the document was created. </p> <note> <p>Sha1 hashes have been deprecated.</p> </note>', 'MaintenanceWindowRunCommandParameters$DocumentHash' => '<p>The Sha256 or Sha1 hash created by the system when the document was created. Sha1 hashes have been deprecated.</p>', 'SendCommandRequest$DocumentHash' => '<p>The Sha256 or Sha1 hash created by the system when the document was created. </p> <note> <p>Sha1 hashes have been deprecated.</p> </note>', ], ], 'DocumentHashType' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$HashType' => '<p>Sha256 or Sha1.</p> <note> <p>Sha1 hashes have been deprecated.</p> </note>', 'MaintenanceWindowRunCommandParameters$DocumentHashType' => '<p>Sha256 or Sha1. Sha1 hashes have been deprecated.</p>', 'SendCommandRequest$DocumentHashType' => '<p>Sha256 or Sha1.</p> <note> <p>Sha1 hashes have been deprecated.</p> </note>', ], ], 'DocumentIdentifier' => [ 'base' => '<p>Describes the name of an SSM document.</p>', 'refs' => [ 'DocumentIdentifierList$member' => NULL, ], ], 'DocumentIdentifierList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentsResult$DocumentIdentifiers' => '<p>The names of the SSM documents.</p>', ], ], 'DocumentLimitExceeded' => [ 'base' => '<p>You can have at most 200 active SSM documents.</p>', 'refs' => [], ], 'DocumentName' => [ 'base' => NULL, 'refs' => [ 'Association$Name' => '<p>The name of the SSM document.</p>', 'AssociationDescription$Name' => '<p>The name of the SSM document.</p>', 'AutomationExecution$DocumentName' => '<p>The name of the Automation document used during the execution.</p>', 'AutomationExecutionMetadata$DocumentName' => '<p>The name of the Automation document used during execution.</p>', 'Command$DocumentName' => '<p>The name of the document requested for execution.</p>', 'CommandInvocation$DocumentName' => '<p>The document name that was requested for execution.</p>', 'CreateAssociationBatchRequestEntry$Name' => '<p>The name of the configuration document. </p>', 'CreateAssociationRequest$Name' => '<p>The name of the Systems Manager document.</p>', 'CreateDocumentRequest$Name' => '<p>A name for the Systems Manager document.</p>', 'DeleteAssociationRequest$Name' => '<p>The name of the Systems Manager document.</p>', 'DeleteDocumentRequest$Name' => '<p>The name of the document.</p>', 'DescribeAssociationRequest$Name' => '<p>The name of the SSM document.</p>', 'DescribeDocumentPermissionRequest$Name' => '<p>The name of the document for which you are the owner.</p>', 'DocumentDefaultVersionDescription$Name' => '<p>The name of the document.</p>', 'DocumentVersionInfo$Name' => '<p>The document name.</p>', 'GetCommandInvocationResult$DocumentName' => '<p>The name of the document that was executed. For example, AWS-RunShellScript.</p>', 'InstanceAssociationStatusInfo$Name' => '<p>The name of the association.</p>', 'ListDocumentVersionsRequest$Name' => '<p>The name of the document about which you want version information.</p>', 'ModifyDocumentPermissionRequest$Name' => '<p>The name of the document that you want to share.</p>', 'UpdateAssociationRequest$Name' => '<p>The name of the association document.</p>', 'UpdateAssociationStatusRequest$Name' => '<p>The name of the SSM document.</p>', 'UpdateDocumentDefaultVersionRequest$Name' => '<p>The name of a custom document that you want to set as the default version.</p>', 'UpdateDocumentRequest$Name' => '<p>The name of the document that you want to update.</p>', ], ], 'DocumentOwner' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Owner' => '<p>The AWS user account of the person who created the document.</p>', 'DocumentIdentifier$Owner' => '<p>The AWS user account of the person who created the document.</p>', ], ], 'DocumentParameter' => [ 'base' => '<p>Parameters specified in a System Manager document that execute on the server when the command is run. </p>', 'refs' => [ 'DocumentParameterList$member' => NULL, ], ], 'DocumentParameterDefaultValue' => [ 'base' => NULL, 'refs' => [ 'DocumentParameter$DefaultValue' => '<p>If specified, the default values for the parameters. Parameters without a default value are required. Parameters with a default value are optional.</p>', ], ], 'DocumentParameterDescrption' => [ 'base' => NULL, 'refs' => [ 'DocumentParameter$Description' => '<p>A description of what the parameter does, how to use it, the default value, and whether or not the parameter is optional.</p>', ], ], 'DocumentParameterList' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Parameters' => '<p>A description of the parameters for a document.</p>', ], ], 'DocumentParameterName' => [ 'base' => NULL, 'refs' => [ 'DocumentParameter$Name' => '<p>The name of the parameter.</p>', ], ], 'DocumentParameterType' => [ 'base' => NULL, 'refs' => [ 'DocumentParameter$Type' => '<p>The type of parameter. The type can be either String or StringList.</p>', ], ], 'DocumentPermissionLimit' => [ 'base' => '<p>The document cannot be shared with more AWS user accounts. You can share a document with a maximum of 20 accounts. You can publicly share up to five documents. If you need to increase this limit, contact AWS Support.</p>', 'refs' => [], ], 'DocumentPermissionType' => [ 'base' => NULL, 'refs' => [ 'DescribeDocumentPermissionRequest$PermissionType' => '<p>The permission type for the document. The permission type can be <i>Share</i>.</p>', 'ModifyDocumentPermissionRequest$PermissionType' => '<p>The permission type for the document. The permission type can be <i>Share</i>.</p>', ], ], 'DocumentSchemaVersion' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$SchemaVersion' => '<p>The schema version.</p>', 'DocumentIdentifier$SchemaVersion' => '<p>The schema version.</p>', ], ], 'DocumentSha1' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Sha1' => '<p>The SHA1 hash of the document, which you can use for verification purposes.</p>', ], ], 'DocumentStatus' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Status' => '<p>The status of the SSM document.</p>', ], ], 'DocumentType' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$DocumentType' => '<p>The type of document to create. Valid document types include: Policy, Automation, and Command.</p>', 'DocumentDescription$DocumentType' => '<p>The type of document. </p>', 'DocumentIdentifier$DocumentType' => '<p>The document type.</p>', 'GetDocumentResult$DocumentType' => '<p>The document type.</p>', ], ], 'DocumentVersion' => [ 'base' => NULL, 'refs' => [ 'Association$DocumentVersion' => '<p>The version of the document used in the association.</p>', 'AssociationDescription$DocumentVersion' => '<p>The document version.</p>', 'AutomationExecution$DocumentVersion' => '<p>The version of the document to use during execution.</p>', 'AutomationExecutionMetadata$DocumentVersion' => '<p>The document version used during the execution.</p>', 'CreateAssociationBatchRequestEntry$DocumentVersion' => '<p>The document version.</p>', 'CreateAssociationRequest$DocumentVersion' => '<p>The document version you want to associate with the target(s). Can be a specific version or the default version.</p>', 'DescribeDocumentRequest$DocumentVersion' => '<p>The document version for which you want information. Can be a specific version or the default version.</p>', 'DocumentDefaultVersionDescription$DefaultVersion' => '<p>The default version of the document.</p>', 'DocumentDescription$DocumentVersion' => '<p>The document version.</p>', 'DocumentDescription$LatestVersion' => '<p>The latest version of the document.</p>', 'DocumentDescription$DefaultVersion' => '<p>The default version.</p>', 'DocumentIdentifier$DocumentVersion' => '<p>The document version.</p>', 'DocumentVersionInfo$DocumentVersion' => '<p>The document version.</p>', 'GetDocumentRequest$DocumentVersion' => '<p>The document version for which you want information.</p>', 'GetDocumentResult$DocumentVersion' => '<p>The document version.</p>', 'InstanceAssociationStatusInfo$DocumentVersion' => '<p>The association document verions.</p>', 'MaintenanceWindowAutomationParameters$DocumentVersion' => '<p>The version of an SSM Automation document to use during task execution.</p>', 'StartAutomationExecutionRequest$DocumentVersion' => '<p>The version of the Automation document to use for this execution.</p>', 'UpdateAssociationRequest$DocumentVersion' => '<p>The document version you want update for the association. </p>', 'UpdateDocumentRequest$DocumentVersion' => '<p>The version of the document that you want to update.</p>', ], ], 'DocumentVersionInfo' => [ 'base' => '<p>Version information about the document.</p>', 'refs' => [ 'DocumentVersionList$member' => NULL, ], ], 'DocumentVersionLimitExceeded' => [ 'base' => '<p>The document has too many versions. Delete one or more document versions and try again.</p>', 'refs' => [], ], 'DocumentVersionList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentVersionsResult$DocumentVersions' => '<p>The document versions.</p>', ], ], 'DocumentVersionNumber' => [ 'base' => NULL, 'refs' => [ 'UpdateDocumentDefaultVersionRequest$DocumentVersion' => '<p>The version of a custom document that you want to set as the default version.</p>', ], ], 'DoesNotExistException' => [ 'base' => '<p>Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn\'t exist.</p>', 'refs' => [], ], 'DuplicateDocumentContent' => [ 'base' => '<p>The content of the association document matches another document. Change the content of the document and try again.</p>', 'refs' => [], ], 'DuplicateInstanceId' => [ 'base' => '<p>You cannot specify an instance ID in more than one association.</p>', 'refs' => [], ], 'EffectiveInstanceAssociationMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeEffectiveInstanceAssociationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'EffectivePatch' => [ 'base' => '<p>The EffectivePatch structure defines metadata about a patch along with the approval state of the patch in a particular patch baseline. The approval state includes information about whether the patch is currently approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the date the patch was or will be approved.</p>', 'refs' => [ 'EffectivePatchList$member' => NULL, ], ], 'EffectivePatchList' => [ 'base' => NULL, 'refs' => [ 'DescribeEffectivePatchesForPatchBaselineResult$EffectivePatches' => '<p>An array of patches and patch status.</p>', ], ], 'ErrorCount' => [ 'base' => NULL, 'refs' => [ 'Command$ErrorCount' => '<p>The number of targets for which the status is Failed or Execution Timed Out.</p>', ], ], 'ExpirationDate' => [ 'base' => NULL, 'refs' => [ 'Activation$ExpirationDate' => '<p>The date when this activation can no longer be used to register managed instances.</p>', 'CreateActivationRequest$ExpirationDate' => '<p>The date by which this activation request should expire. The default value is 24 hours.</p>', ], ], 'FailedCreateAssociation' => [ 'base' => '<p>Describes a failed association.</p>', 'refs' => [ 'FailedCreateAssociationList$member' => NULL, ], ], 'FailedCreateAssociationList' => [ 'base' => NULL, 'refs' => [ 'CreateAssociationBatchResult$Failed' => '<p>Information about the associations that failed.</p>', ], ], 'FailureDetails' => [ 'base' => '<p>Information about an Automation failure.</p>', 'refs' => [ 'StepExecution$FailureDetails' => '<p>Information about the Automation failure.</p>', ], ], 'Fault' => [ 'base' => NULL, 'refs' => [ 'FailedCreateAssociation$Fault' => '<p>The source of the failure.</p>', ], ], 'FeatureNotAvailableException' => [ 'base' => '<p>You attempted to register a LAMBDA or STEP_FUNCTION task in a region where there corresponding service is not available. </p>', 'refs' => [], ], 'GetAutomationExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAutomationExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'GetCommandInvocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCommandInvocationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDefaultPatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDefaultPatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDeployablePatchSnapshotForInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDeployablePatchSnapshotForInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInventoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInventoryResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInventorySchemaMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'GetInventorySchemaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInventorySchemaResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionTaskInvocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionTaskInvocationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'GetParameterHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParameterHistoryResult' => [ 'base' => NULL, 'refs' => [], ], 'GetParameterRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParameterResult' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersByPathMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetParametersByPathRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'GetParametersByPathRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersByPathResult' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPatchBaselineForPatchGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPatchBaselineForPatchGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'HierarchyLevelLimitExceededException' => [ 'base' => '<p>A hierarchy can have a maximum of five levels. For example:</p> <p>/Finance/Prod/IAD/OS/WinServ2016/license15</p> <p>For more information, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-working.html">Working with Systems Manager Parameters</a>. </p>', 'refs' => [], ], 'HierarchyTypeMismatchException' => [ 'base' => '<p>Parameter Store does not support changing a parameter type in a hierarchy. For example, you can\'t change a parameter from a String type to a SecureString type. You must create a new, unique parameter.</p>', 'refs' => [], ], 'IPAddress' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$IPAddress' => '<p>The IP address of the managed instance.</p>', ], ], 'IamRole' => [ 'base' => NULL, 'refs' => [ 'Activation$IamRole' => '<p>The Amazon Identity and Access Management (IAM) role to assign to the managed instance.</p>', 'CreateActivationRequest$IamRole' => '<p>The Amazon Identity and Access Management (IAM) role that you want to assign to the managed instance. </p>', 'InstanceInformation$IamRole' => '<p>The Amazon Identity and Access Management (IAM) role assigned to EC2 instances or managed instances. </p>', 'UpdateManagedInstanceRoleRequest$IamRole' => '<p>The IAM role you want to assign or change.</p>', ], ], 'IdempotentParameterMismatch' => [ 'base' => '<p>Error returned when an idempotent operation is retried and the parameters don\'t match the original call to the API with the same idempotency token. </p>', 'refs' => [], ], 'InstanceAggregatedAssociationOverview' => [ 'base' => '<p>Status information about the aggregated associations.</p>', 'refs' => [ 'InstanceInformation$AssociationOverview' => '<p>Information about the association.</p>', ], ], 'InstanceAssociation' => [ 'base' => '<p>One or more association documents on the instance. </p>', 'refs' => [ 'InstanceAssociationList$member' => NULL, ], ], 'InstanceAssociationExecutionSummary' => [ 'base' => NULL, 'refs' => [ 'InstanceAssociationStatusInfo$ExecutionSummary' => '<p>Summary information about association execution.</p>', ], ], 'InstanceAssociationList' => [ 'base' => NULL, 'refs' => [ 'DescribeEffectiveInstanceAssociationsResult$Associations' => '<p>The associations for the requested instance.</p>', ], ], 'InstanceAssociationOutputLocation' => [ 'base' => '<p>An Amazon S3 bucket where you want to store the results of this request.</p>', 'refs' => [ 'AssociationDescription$OutputLocation' => '<p>An Amazon S3 bucket where you want to store the output details of the request.</p>', 'CreateAssociationBatchRequestEntry$OutputLocation' => '<p>An Amazon S3 bucket where you want to store the results of this request.</p>', 'CreateAssociationRequest$OutputLocation' => '<p>An Amazon S3 bucket where you want to store the output details of the request.</p>', 'UpdateAssociationRequest$OutputLocation' => '<p>An Amazon S3 bucket where you want to store the results of this request.</p>', ], ], 'InstanceAssociationOutputUrl' => [ 'base' => '<p>The URL of Amazon S3 bucket where you want to store the results of this request.</p>', 'refs' => [ 'InstanceAssociationStatusInfo$OutputUrl' => '<p>A URL for an Amazon S3 bucket where you want to store the results of this request.</p>', ], ], 'InstanceAssociationStatusAggregatedCount' => [ 'base' => NULL, 'refs' => [ 'InstanceAggregatedAssociationOverview$InstanceAssociationStatusAggregatedCount' => '<p>The number of associations for the instance(s).</p>', ], ], 'InstanceAssociationStatusInfo' => [ 'base' => '<p>Status information about the instance association.</p>', 'refs' => [ 'InstanceAssociationStatusInfos$member' => NULL, ], ], 'InstanceAssociationStatusInfos' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceAssociationsStatusResult$InstanceAssociationStatusInfos' => '<p>Status information about the association.</p>', ], ], 'InstanceCount' => [ 'base' => NULL, 'refs' => [ 'AssociationStatusAggregatedCount$value' => NULL, 'InstanceAssociationStatusAggregatedCount$value' => NULL, ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'Association$InstanceId' => '<p>The ID of the instance.</p>', 'AssociationDescription$InstanceId' => '<p>The ID of the instance.</p>', 'CommandInvocation$InstanceId' => '<p>The instance ID in which this invocation was requested.</p>', 'CreateAssociationBatchRequestEntry$InstanceId' => '<p>The ID of the instance. </p>', 'CreateAssociationRequest$InstanceId' => '<p>The instance ID.</p>', 'DeleteAssociationRequest$InstanceId' => '<p>The ID of the instance.</p>', 'DescribeAssociationRequest$InstanceId' => '<p>The instance ID.</p>', 'DescribeEffectiveInstanceAssociationsRequest$InstanceId' => '<p>The instance ID for which you want to view all associations.</p>', 'DescribeInstanceAssociationsStatusRequest$InstanceId' => '<p>The instance IDs for which you want association status information.</p>', 'DescribeInstancePatchesRequest$InstanceId' => '<p>The ID of the instance whose patch state information should be retrieved.</p>', 'GetCommandInvocationRequest$InstanceId' => '<p>(Required) The ID of the managed instance targeted by the command. A managed instance can be an Amazon EC2 instance or an instance in your hybrid environment that is configured for Systems Manager.</p>', 'GetCommandInvocationResult$InstanceId' => '<p>The ID of the managed instance targeted by the command. A managed instance can be an Amazon EC2 instance or an instance in your hybrid environment that is configured for Systems Manager.</p>', 'GetDeployablePatchSnapshotForInstanceRequest$InstanceId' => '<p>The ID of the instance for which the appropriate patch snapshot should be retrieved.</p>', 'GetDeployablePatchSnapshotForInstanceResult$InstanceId' => '<p>The ID of the instance.</p>', 'InstanceAssociation$InstanceId' => '<p>The instance ID.</p>', 'InstanceAssociationStatusInfo$InstanceId' => '<p>The instance ID where the association was created.</p>', 'InstanceIdList$member' => NULL, 'InstanceInformation$InstanceId' => '<p>The instance ID. </p>', 'InstancePatchState$InstanceId' => '<p>The ID of the managed instance the high-level patch compliance information was collected for.</p>', 'ListCommandInvocationsRequest$InstanceId' => '<p>(Optional) The command execution details for a specific instance ID.</p>', 'ListCommandsRequest$InstanceId' => '<p>(Optional) Lists commands issued against this instance ID.</p>', 'ListInventoryEntriesRequest$InstanceId' => '<p>The instance ID for which you want inventory information.</p>', 'ListInventoryEntriesResult$InstanceId' => '<p>The instance ID targeted by the request to query inventory information.</p>', 'PutInventoryRequest$InstanceId' => '<p>One or more instance IDs where you want to add or update inventory items.</p>', 'UpdateAssociationStatusRequest$InstanceId' => '<p>The ID of the instance.</p>', ], ], 'InstanceIdList' => [ 'base' => NULL, 'refs' => [ 'CancelCommandRequest$InstanceIds' => '<p>(Optional) A list of instance IDs on which you want to cancel the command. If not provided, the command is canceled on every instance on which it was requested.</p>', 'Command$InstanceIds' => '<p>The instance IDs against which this command was requested.</p>', 'DescribeInstancePatchStatesRequest$InstanceIds' => '<p>The ID of the instance whose patch state information should be retrieved.</p>', 'SendCommandRequest$InstanceIds' => '<p>The instance IDs where the command should execute. You can specify a maximum of 50 IDs. If you prefer not to list individual instance IDs, you can instead send commands to a fleet of instances using the Targets parameter, which accepts EC2 tags. For more information about how to use Targets, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending Commands to a Fleet</a>.</p>', ], ], 'InstanceInformation' => [ 'base' => '<p>Describes a filter for a specific list of instances. </p>', 'refs' => [ 'InstanceInformationList$member' => NULL, ], ], 'InstanceInformationFilter' => [ 'base' => '<p>Describes a filter for a specific list of instances. </p>', 'refs' => [ 'InstanceInformationFilterList$member' => NULL, ], ], 'InstanceInformationFilterKey' => [ 'base' => NULL, 'refs' => [ 'InstanceInformationFilter$key' => '<p>The name of the filter. </p>', ], ], 'InstanceInformationFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceInformationRequest$InstanceInformationFilterList' => '<p>One or more filters. Use a filter to return a more specific list of instances.</p>', ], ], 'InstanceInformationFilterValue' => [ 'base' => NULL, 'refs' => [ 'InstanceInformationFilterValueSet$member' => NULL, ], ], 'InstanceInformationFilterValueSet' => [ 'base' => NULL, 'refs' => [ 'InstanceInformationFilter$valueSet' => '<p>The filter values.</p>', 'InstanceInformationStringFilter$Values' => '<p>The filter values.</p>', ], ], 'InstanceInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceInformationResult$InstanceInformationList' => '<p>The instance information list.</p>', ], ], 'InstanceInformationStringFilter' => [ 'base' => '<p>The filters to describe or get information about your managed instances.</p>', 'refs' => [ 'InstanceInformationStringFilterList$member' => NULL, ], ], 'InstanceInformationStringFilterKey' => [ 'base' => NULL, 'refs' => [ 'InstanceInformationStringFilter$Key' => '<p>The filter key name to describe your instances. For example:</p> <p>"InstanceIds"|"AgentVersion"|"PingStatus"|"PlatformTypes"|"ActivationIds"|"IamRole"|"ResourceType"|"AssociationStatus"|"Tag Key"</p>', ], ], 'InstanceInformationStringFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceInformationRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of instances.</p>', ], ], 'InstancePatchState' => [ 'base' => '<p>Defines the high-level patch compliance state for a managed instance, providing information about the number of installed, missing, not applicable, and failed patches along with metadata about the operation when this information was gathered for the instance.</p>', 'refs' => [ 'InstancePatchStateList$member' => NULL, 'InstancePatchStatesList$member' => NULL, ], ], 'InstancePatchStateFilter' => [ 'base' => '<p>Defines a filter used in DescribeInstancePatchStatesForPatchGroup used to scope down the information returned by the API.</p>', 'refs' => [ 'InstancePatchStateFilterList$member' => NULL, ], ], 'InstancePatchStateFilterKey' => [ 'base' => NULL, 'refs' => [ 'InstancePatchStateFilter$Key' => '<p>The key for the filter. Supported values are FailedCount, InstalledCount, InstalledOtherCount, MissingCount and NotApplicableCount.</p>', ], ], 'InstancePatchStateFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchStatesForPatchGroupRequest$Filters' => '<p>Each entry in the array is a structure containing:</p> <p>Key (string between 1 and 200 characters)</p> <p> Values (array containing a single string)</p> <p> Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")</p>', ], ], 'InstancePatchStateFilterValue' => [ 'base' => NULL, 'refs' => [ 'InstancePatchStateFilterValues$member' => NULL, ], ], 'InstancePatchStateFilterValues' => [ 'base' => NULL, 'refs' => [ 'InstancePatchStateFilter$Values' => '<p>The value for the filter, must be an integer greater than or equal to 0.</p>', ], ], 'InstancePatchStateList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchStatesResult$InstancePatchStates' => '<p>The high-level patch state for the requested instances.</p>', ], ], 'InstancePatchStateOperatorType' => [ 'base' => NULL, 'refs' => [ 'InstancePatchStateFilter$Type' => '<p>The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or GreaterThan.</p>', ], ], 'InstancePatchStatesList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchStatesForPatchGroupResult$InstancePatchStates' => '<p>The high-level patch state for the requested instances. </p>', ], ], 'InstanceTagName' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$InstanceName' => '<p>The name of the invocation target. For Amazon EC2 instances this is the value for the aws:Name tag. For on-premises instances, this is the name of the instance.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DescribePatchGroupStateResult$Instances' => '<p>The number of instances in the patch group.</p>', 'DescribePatchGroupStateResult$InstancesWithInstalledPatches' => '<p>The number of instances with installed patches.</p>', 'DescribePatchGroupStateResult$InstancesWithInstalledOtherPatches' => '<p>The number of instances with patches installed that aren\'t defined in the patch baseline.</p>', 'DescribePatchGroupStateResult$InstancesWithMissingPatches' => '<p>The number of instances with missing patches from the patch baseline.</p>', 'DescribePatchGroupStateResult$InstancesWithFailedPatches' => '<p>The number of instances with patches from the patch baseline that failed to install.</p>', 'DescribePatchGroupStateResult$InstancesWithNotApplicablePatches' => '<p>The number of instances with patches that aren\'t applicable.</p>', ], ], 'InternalServerError' => [ 'base' => '<p>An error occurred on the server side.</p>', 'refs' => [], ], 'InvalidActivation' => [ 'base' => '<p>The activation is not valid. The activation might have been deleted, or the ActivationId and the ActivationCode do not match.</p>', 'refs' => [], ], 'InvalidActivationId' => [ 'base' => '<p>The activation ID is not valid. Verify the you entered the correct ActivationId or ActivationCode and try again.</p>', 'refs' => [], ], 'InvalidAllowedPatternException' => [ 'base' => '<p>The request does not meet the regular expression requirement.</p>', 'refs' => [], ], 'InvalidAutomationExecutionParametersException' => [ 'base' => '<p>The supplied parameters for invoking the specified Automation document are incorrect. For example, they may not match the set of parameters permitted for the specified Automation document.</p>', 'refs' => [], ], 'InvalidAutomationSignalException' => [ 'base' => '<p>The signal is not valid for the current Automation execution.</p>', 'refs' => [], ], 'InvalidCommandId' => [ 'base' => NULL, 'refs' => [], ], 'InvalidDocument' => [ 'base' => '<p>The specified document does not exist.</p>', 'refs' => [], ], 'InvalidDocumentContent' => [ 'base' => '<p>The content for the document is not valid.</p>', 'refs' => [], ], 'InvalidDocumentOperation' => [ 'base' => '<p>You attempted to delete a document while it is still shared. You must stop sharing the document before you can delete it.</p>', 'refs' => [], ], 'InvalidDocumentSchemaVersion' => [ 'base' => '<p>The version of the document schema is not supported.</p>', 'refs' => [], ], 'InvalidDocumentVersion' => [ 'base' => '<p>The document version is not valid or does not exist.</p>', 'refs' => [], ], 'InvalidFilter' => [ 'base' => '<p>The filter name is not valid. Verify the you entered the correct name and try again.</p>', 'refs' => [], ], 'InvalidFilterKey' => [ 'base' => '<p>The specified key is not valid.</p>', 'refs' => [], ], 'InvalidFilterOption' => [ 'base' => '<p>The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid options are Recursive and OneLevel.</p>', 'refs' => [], ], 'InvalidFilterValue' => [ 'base' => '<p>The filter value is not valid. Verify the value and try again.</p>', 'refs' => [], ], 'InvalidInstanceId' => [ 'base' => '<p>The following problems can cause this exception:</p> <p>You do not have permission to access the instance.</p> <p>The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is running. On EC2 Windows instances, verify that the EC2Config service is running.</p> <p>The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent or EC2Config service.</p> <p>The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states are: Shutting-down and Terminated.</p>', 'refs' => [], ], 'InvalidInstanceInformationFilterValue' => [ 'base' => '<p>The specified filter value is not valid.</p>', 'refs' => [], ], 'InvalidInventoryItemContextException' => [ 'base' => '<p>You specified invalid keys or values in the <code>Context</code> attribute for <code>InventoryItem</code>. Verify the keys and values, and try again.</p>', 'refs' => [], ], 'InvalidItemContentException' => [ 'base' => '<p>One or more content items is not valid.</p>', 'refs' => [], ], 'InvalidKeyId' => [ 'base' => '<p>The query key ID is not valid.</p>', 'refs' => [], ], 'InvalidNextToken' => [ 'base' => '<p>The specified token is not valid.</p>', 'refs' => [], ], 'InvalidNotificationConfig' => [ 'base' => '<p>One or more configuration items is not valid. Verify that a valid Amazon Resource Name (ARN) was provided for an Amazon SNS topic.</p>', 'refs' => [], ], 'InvalidOutputFolder' => [ 'base' => '<p>The S3 bucket does not exist.</p>', 'refs' => [], ], 'InvalidOutputLocation' => [ 'base' => '<p>The output location is not valid or does not exist.</p>', 'refs' => [], ], 'InvalidParameters' => [ 'base' => '<p>You must specify values for all required parameters in the SSM document. You can only supply values to parameters defined in the SSM document.</p>', 'refs' => [], ], 'InvalidPermissionType' => [ 'base' => '<p>The permission type is not supported. <i>Share</i> is the only supported permission type.</p>', 'refs' => [], ], 'InvalidPluginName' => [ 'base' => '<p>The plugin name is not valid.</p>', 'refs' => [], ], 'InvalidResourceId' => [ 'base' => '<p>The resource ID is not valid. Verify that you entered the correct ID and try again.</p>', 'refs' => [], ], 'InvalidResourceType' => [ 'base' => '<p>The resource type is not valid. If you are attempting to tag an instance, the instance must be a registered, managed instance.</p>', 'refs' => [], ], 'InvalidResultAttributeException' => [ 'base' => '<p>The specified inventory item result attribute is not valid.</p>', 'refs' => [], ], 'InvalidRole' => [ 'base' => '<p>The role name can\'t contain invalid characters. Also verify that you specified an IAM role for notifications that includes the required trust policy. For information about configuring the IAM role for Run Command notifications, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/rc-sns-notifications.html">Configuring Amazon SNS Notifications for Run Command</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.</p>', 'refs' => [], ], 'InvalidSchedule' => [ 'base' => '<p>The schedule is invalid. Verify your cron or rate expression and try again.</p>', 'refs' => [], ], 'InvalidTarget' => [ 'base' => '<p>The target is not valid or does not exist. It might not be configured for EC2 Systems Manager or you might not have permission to perform the operation.</p>', 'refs' => [], ], 'InvalidTypeNameException' => [ 'base' => '<p>The parameter type name is not valid.</p>', 'refs' => [], ], 'InvalidUpdate' => [ 'base' => '<p>The update is not valid.</p>', 'refs' => [], ], 'InventoryAttributeDataType' => [ 'base' => NULL, 'refs' => [ 'InventoryItemAttribute$DataType' => '<p>The data type of the inventory item attribute. </p>', ], ], 'InventoryFilter' => [ 'base' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', 'refs' => [ 'InventoryFilterList$member' => NULL, ], ], 'InventoryFilterKey' => [ 'base' => NULL, 'refs' => [ 'InventoryFilter$Key' => '<p>The name of the filter key.</p>', ], ], 'InventoryFilterList' => [ 'base' => NULL, 'refs' => [ 'GetInventoryRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', 'ListInventoryEntriesRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', ], ], 'InventoryFilterValue' => [ 'base' => NULL, 'refs' => [ 'InventoryFilterValueList$member' => NULL, ], ], 'InventoryFilterValueList' => [ 'base' => NULL, 'refs' => [ 'InventoryFilter$Values' => '<p>Inventory filter values. Example: inventory filter where instance IDs are specified as values Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g, i-1a2b3c4d5e6,Type=Equal </p>', ], ], 'InventoryItem' => [ 'base' => '<p>Information collected from managed instances based on your inventory policy document</p>', 'refs' => [ 'InventoryItemList$member' => NULL, ], ], 'InventoryItemAttribute' => [ 'base' => '<p>Attributes are the entries within the inventory item content. It contains name and value.</p>', 'refs' => [ 'InventoryItemAttributeList$member' => NULL, ], ], 'InventoryItemAttributeList' => [ 'base' => NULL, 'refs' => [ 'InventoryItemSchema$Attributes' => '<p>The schema attributes for inventory. This contains data type and attribute name.</p>', ], ], 'InventoryItemAttributeName' => [ 'base' => NULL, 'refs' => [ 'InventoryItemAttribute$Name' => '<p>Name of the inventory item attribute.</p>', ], ], 'InventoryItemCaptureTime' => [ 'base' => NULL, 'refs' => [ 'InventoryItem$CaptureTime' => '<p>The time the inventory information was collected.</p>', 'InventoryResultItem$CaptureTime' => '<p>The time inventory item data was captured.</p>', 'ListInventoryEntriesResult$CaptureTime' => '<p>The time that inventory information was collected for the instance(s).</p>', ], ], 'InventoryItemContentContext' => [ 'base' => NULL, 'refs' => [ 'InventoryItem$Context' => '<p>A map of associated properties for a specified inventory type. For example, with this attribute, you can specify the <code>ExecutionId</code>, <code>ExecutionType</code>, <code>ComplianceType</code> properties of the <code>AWS:ComplianceItem</code> type.</p>', ], ], 'InventoryItemContentHash' => [ 'base' => NULL, 'refs' => [ 'InventoryItem$ContentHash' => '<p>MD5 hash of the inventory item type contents. The content hash is used to determine whether to update inventory information. The PutInventory API does not update the inventory item type contents if the MD5 hash has not changed since last update. </p>', 'InventoryResultItem$ContentHash' => '<p>MD5 hash of the inventory item type contents. The content hash is used to determine whether to update inventory information. The PutInventory API does not update the inventory item type contents if the MD5 hash has not changed since last update. </p>', ], ], 'InventoryItemEntry' => [ 'base' => NULL, 'refs' => [ 'InventoryItemEntryList$member' => NULL, ], ], 'InventoryItemEntryList' => [ 'base' => NULL, 'refs' => [ 'InventoryItem$Content' => '<p>The inventory data of the inventory type.</p>', 'InventoryResultItem$Content' => '<p>Contains all the inventory data of the item type. Results include attribute names and values. </p>', 'ListInventoryEntriesResult$Entries' => '<p>A list of inventory items on the instance(s).</p>', ], ], 'InventoryItemList' => [ 'base' => NULL, 'refs' => [ 'PutInventoryRequest$Items' => '<p>The inventory items that you want to add or update on instances.</p>', ], ], 'InventoryItemSchema' => [ 'base' => '<p>The inventory item schema definition. Users can use this to compose inventory query filters.</p>', 'refs' => [ 'InventoryItemSchemaResultList$member' => NULL, ], ], 'InventoryItemSchemaResultList' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaResult$Schemas' => '<p>Inventory schemas returned by the request.</p>', ], ], 'InventoryItemSchemaVersion' => [ 'base' => NULL, 'refs' => [ 'InventoryItem$SchemaVersion' => '<p>The schema version for the inventory item.</p>', 'InventoryItemSchema$Version' => '<p>The schema version for the inventory item.</p>', 'InventoryResultItem$SchemaVersion' => '<p>The schema version for the inventory result item/</p>', 'ListInventoryEntriesResult$SchemaVersion' => '<p>The inventory schema version used by the instance(s).</p>', ], ], 'InventoryItemTypeName' => [ 'base' => NULL, 'refs' => [ 'InvalidItemContentException$TypeName' => NULL, 'InventoryItem$TypeName' => '<p>The name of the inventory type. Default inventory item type names start with AWS. Custom inventory type names will start with Custom. Default inventory item types include the following: AWS:AWSComponent, AWS:Application, AWS:InstanceInformation, AWS:Network, and AWS:WindowsUpdate.</p>', 'InventoryItemSchema$TypeName' => '<p>The name of the inventory type. Default inventory item type names start with AWS. Custom inventory type names will start with Custom. Default inventory item types include the following: AWS:AWSComponent, AWS:Application, AWS:InstanceInformation, AWS:Network, and AWS:WindowsUpdate.</p>', 'InventoryResultItem$TypeName' => '<p>The name of the inventory result item type.</p>', 'ItemContentMismatchException$TypeName' => NULL, 'ItemSizeLimitExceededException$TypeName' => NULL, 'ListInventoryEntriesRequest$TypeName' => '<p>The type of inventory item for which you want information.</p>', 'ListInventoryEntriesResult$TypeName' => '<p>The type of inventory item returned by the request.</p>', 'ResultAttribute$TypeName' => '<p>Name of the inventory item type. Valid value: AWS:InstanceInformation. Default Value: AWS:InstanceInformation.</p>', 'UnsupportedInventoryItemContextException$TypeName' => NULL, ], ], 'InventoryItemTypeNameFilter' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaRequest$TypeName' => '<p>The type of inventory item to return.</p>', ], ], 'InventoryQueryOperatorType' => [ 'base' => NULL, 'refs' => [ 'InventoryFilter$Type' => '<p>The type of filter. Valid values include the following: "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"</p>', ], ], 'InventoryResultEntity' => [ 'base' => '<p>Inventory query results.</p>', 'refs' => [ 'InventoryResultEntityList$member' => NULL, ], ], 'InventoryResultEntityId' => [ 'base' => NULL, 'refs' => [ 'InventoryResultEntity$Id' => '<p>ID of the inventory result entity. For example, for managed instance inventory the result will be the managed instance ID. For EC2 instance inventory, the result will be the instance ID. </p>', ], ], 'InventoryResultEntityList' => [ 'base' => NULL, 'refs' => [ 'GetInventoryResult$Entities' => '<p>Collection of inventory entities such as a collection of instance inventory. </p>', ], ], 'InventoryResultItem' => [ 'base' => '<p>The inventory result item.</p>', 'refs' => [ 'InventoryResultItemMap$value' => NULL, ], ], 'InventoryResultItemKey' => [ 'base' => NULL, 'refs' => [ 'InventoryResultItemMap$key' => NULL, ], ], 'InventoryResultItemMap' => [ 'base' => NULL, 'refs' => [ 'InventoryResultEntity$Data' => '<p>The data section in the inventory result entity json.</p>', ], ], 'InvocationDoesNotExist' => [ 'base' => '<p>The command ID and instance ID you specified did not match any invocations. Verify the command ID adn the instance ID and try again. </p>', 'refs' => [], ], 'InvocationTraceOutput' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$TraceOutput' => '<p> Gets the trace output sent by the agent. </p>', ], ], 'IsSubTypeSchema' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaRequest$SubType' => '<p>Returns the sub-type schema for a specified inventory type.</p>', ], ], 'ItemContentMismatchException' => [ 'base' => '<p>The inventory item has invalid content. </p>', 'refs' => [], ], 'ItemSizeLimitExceededException' => [ 'base' => '<p>The inventory item size has exceeded the size limit.</p>', 'refs' => [], ], 'KeyList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsFromResourceRequest$TagKeys' => '<p>Tag keys that you want to remove from the specified resource.</p>', ], ], 'LastResourceDataSyncStatus' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$LastStatus' => '<p>The status reported by the last sync.</p>', ], ], 'LastResourceDataSyncTime' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$LastSyncTime' => '<p>The last time the configuration attempted to sync (UTC).</p>', ], ], 'LastSuccessfulResourceDataSyncTime' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$LastSuccessfulSyncTime' => '<p>The last time the sync operations returned a status of <code>SUCCESSFUL</code> (UTC).</p>', ], ], 'ListAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListCommandInvocationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCommandInvocationsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListCommandsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCommandsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceItemsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceSummariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceSummariesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListInventoryEntriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInventoryEntriesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceComplianceSummariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceComplianceSummariesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceDataSyncRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceDataSyncResult' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'LoggingInfo' => [ 'base' => '<p>Information about an Amazon S3 bucket to write instance-level logs to.</p>', 'refs' => [ 'GetMaintenanceWindowTaskResult$LoggingInfo' => '<p>The location in Amazon S3 where the task results will be logged.</p>', 'MaintenanceWindowTask$LoggingInfo' => '<p>Information about an Amazon S3 bucket to write task-level logs to.</p>', 'RegisterTaskWithMaintenanceWindowRequest$LoggingInfo' => '<p>A structure containing information about an Amazon S3 bucket to write instance-level logs to. </p>', 'UpdateMaintenanceWindowTaskRequest$LoggingInfo' => '<p>The new logging location in Amazon S3 that you want to specify.</p>', 'UpdateMaintenanceWindowTaskResult$LoggingInfo' => '<p>The updated logging information in Amazon S3.</p>', ], ], 'MaintenanceWindowAllowUnassociatedTargets' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$AllowUnassociatedTargets' => '<p>Whether targets must be registered with the Maintenance Window before tasks can be defined for those targets.</p>', 'GetMaintenanceWindowResult$AllowUnassociatedTargets' => '<p>Whether targets must be registered with the Maintenance Window before tasks can be defined for those targets.</p>', 'UpdateMaintenanceWindowRequest$AllowUnassociatedTargets' => '<p>Whether targets must be registered with the Maintenance Window before tasks can be defined for those targets.</p>', 'UpdateMaintenanceWindowResult$AllowUnassociatedTargets' => '<p>Whether targets must be registered with the Maintenance Window before tasks can be defined for those targets.</p>', ], ], 'MaintenanceWindowAutomationParameters' => [ 'base' => '<p>Parameters for an AUTOMATION task type.</p>', 'refs' => [ 'MaintenanceWindowTaskInvocationParameters$Automation' => '<p>Parameters for a AUTOMATION task type.</p>', ], ], 'MaintenanceWindowCutoff' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Cutoff' => '<p>The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks for execution.</p>', 'GetMaintenanceWindowResult$Cutoff' => '<p>The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks for execution.</p>', 'MaintenanceWindowIdentity$Cutoff' => '<p>The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks for execution.</p>', 'UpdateMaintenanceWindowRequest$Cutoff' => '<p>The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks for execution.</p>', 'UpdateMaintenanceWindowResult$Cutoff' => '<p>The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks for execution.</p>', ], ], 'MaintenanceWindowDescription' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Description' => '<p>An optional description for the Maintenance Window. We recommend specifying a description to help your organize your Maintenance Windows. </p>', 'GetMaintenanceWindowResult$Description' => '<p>The description of the Maintenance Window.</p>', 'GetMaintenanceWindowTaskResult$Description' => '<p>The retrieved task description.</p>', 'MaintenanceWindowIdentity$Description' => '<p>A description of the Maintenance Window.</p>', 'MaintenanceWindowTarget$Description' => '<p>A description of the target.</p>', 'MaintenanceWindowTask$Description' => '<p>A description of the task.</p>', 'RegisterTargetWithMaintenanceWindowRequest$Description' => '<p>An optional description for the target.</p>', 'RegisterTaskWithMaintenanceWindowRequest$Description' => '<p>An optional description for the task.</p>', 'UpdateMaintenanceWindowRequest$Description' => '<p>An optional description for the update request.</p>', 'UpdateMaintenanceWindowResult$Description' => '<p>An optional description of the update.</p>', 'UpdateMaintenanceWindowTargetRequest$Description' => '<p>An optional description for the update.</p>', 'UpdateMaintenanceWindowTargetResult$Description' => '<p>The updated description.</p>', 'UpdateMaintenanceWindowTaskRequest$Description' => '<p>The new task description that you want to specify.</p>', 'UpdateMaintenanceWindowTaskResult$Description' => '<p>The updated task description.</p>', ], ], 'MaintenanceWindowDurationHours' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Duration' => '<p>The duration of the Maintenance Window in hours.</p>', 'GetMaintenanceWindowResult$Duration' => '<p>The duration of the Maintenance Window in hours.</p>', 'MaintenanceWindowIdentity$Duration' => '<p>The duration of the Maintenance Window in hours.</p>', 'UpdateMaintenanceWindowRequest$Duration' => '<p>The duration of the Maintenance Window in hours.</p>', 'UpdateMaintenanceWindowResult$Duration' => '<p>The duration of the Maintenance Window in hours.</p>', ], ], 'MaintenanceWindowEnabled' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowResult$Enabled' => '<p>Whether the Maintenance Windows is enabled.</p>', 'MaintenanceWindowIdentity$Enabled' => '<p>Whether the Maintenance Window is enabled.</p>', 'UpdateMaintenanceWindowRequest$Enabled' => '<p>Whether the Maintenance Window is enabled.</p>', 'UpdateMaintenanceWindowResult$Enabled' => '<p>Whether the Maintenance Window is enabled.</p>', ], ], 'MaintenanceWindowExecution' => [ 'base' => '<p>Describes the information about an execution of a Maintenance Window. </p>', 'refs' => [ 'MaintenanceWindowExecutionList$member' => NULL, ], ], 'MaintenanceWindowExecutionId' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$WindowExecutionId' => '<p>The ID of the Maintenance Window execution the task is part of.</p>', 'DescribeMaintenanceWindowExecutionTasksRequest$WindowExecutionId' => '<p>The ID of the Maintenance Window execution whose task executions should be retrieved.</p>', 'GetMaintenanceWindowExecutionRequest$WindowExecutionId' => '<p>The ID of the Maintenance Window execution that includes the task.</p>', 'GetMaintenanceWindowExecutionResult$WindowExecutionId' => '<p>The ID of the Maintenance Window execution.</p>', 'GetMaintenanceWindowExecutionTaskInvocationRequest$WindowExecutionId' => '<p>The ID of the Maintenance Window execution the task is part of.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$WindowExecutionId' => '<p>The Maintenance Window execution ID.</p>', 'GetMaintenanceWindowExecutionTaskRequest$WindowExecutionId' => '<p>The ID of the Maintenance Window execution that includes the task.</p>', 'GetMaintenanceWindowExecutionTaskResult$WindowExecutionId' => '<p>The ID of the Maintenance Window execution that includes the task.</p>', 'MaintenanceWindowExecution$WindowExecutionId' => '<p>The ID of the Maintenance Window execution.</p>', 'MaintenanceWindowExecutionTaskIdentity$WindowExecutionId' => '<p>The ID of the Maintenance Window execution that ran the task.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$WindowExecutionId' => '<p>The ID of the Maintenance Window execution that ran the task.</p>', ], ], 'MaintenanceWindowExecutionList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionsResult$WindowExecutions' => '<p>Information about the Maintenance Windows execution.</p>', ], ], 'MaintenanceWindowExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionResult$Status' => '<p>The status of the Maintenance Window execution.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$Status' => '<p>The task status for an invocation.</p>', 'GetMaintenanceWindowExecutionTaskResult$Status' => '<p>The status of the task.</p>', 'MaintenanceWindowExecution$Status' => '<p>The status of the execution.</p>', 'MaintenanceWindowExecutionTaskIdentity$Status' => '<p>The status of the task execution.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$Status' => '<p>The status of the task invocation.</p>', ], ], 'MaintenanceWindowExecutionStatusDetails' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionResult$StatusDetails' => '<p>The details explaining the Status. Only available for certain status values.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$StatusDetails' => '<p>The details explaining the status. Details are only available for certain status values.</p>', 'GetMaintenanceWindowExecutionTaskResult$StatusDetails' => '<p>The details explaining the Status. Only available for certain status values.</p>', 'MaintenanceWindowExecution$StatusDetails' => '<p>The details explaining the Status. Only available for certain status values.</p>', 'MaintenanceWindowExecutionTaskIdentity$StatusDetails' => '<p>The details explaining the status of the task execution. Only available for certain status values.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$StatusDetails' => '<p>The details explaining the status of the task invocation. Only available for certain Status values. </p>', ], ], 'MaintenanceWindowExecutionTaskExecutionId' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$ExecutionId' => '<p>The execution ID.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$ExecutionId' => '<p>The ID of the action performed in the service that actually handled the task invocation. If the task type is RUN_COMMAND, this value is the command ID.</p>', ], ], 'MaintenanceWindowExecutionTaskId' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$TaskId' => '<p>The ID of the specific task in the Maintenance Window task that should be retrieved.</p>', 'GetMaintenanceWindowExecutionTaskInvocationRequest$TaskId' => '<p>The ID of the specific task in the Maintenance Window task that should be retrieved. </p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$TaskExecutionId' => '<p>The task execution ID.</p>', 'GetMaintenanceWindowExecutionTaskRequest$TaskId' => '<p>The ID of the specific task execution in the Maintenance Window task that should be retrieved.</p>', 'GetMaintenanceWindowExecutionTaskResult$TaskExecutionId' => '<p>The ID of the specific task execution in the Maintenance Window task that was retrieved.</p>', 'MaintenanceWindowExecutionTaskIdList$member' => NULL, 'MaintenanceWindowExecutionTaskIdentity$TaskExecutionId' => '<p>The ID of the specific task execution in the Maintenance Window execution.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$TaskExecutionId' => '<p>The ID of the specific task execution in the Maintenance Window execution.</p>', ], ], 'MaintenanceWindowExecutionTaskIdList' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionResult$TaskIds' => '<p>The ID of the task executions from the Maintenance Window execution.</p>', ], ], 'MaintenanceWindowExecutionTaskIdentity' => [ 'base' => '<p>Information about a task execution performed as part of a Maintenance Window execution.</p>', 'refs' => [ 'MaintenanceWindowExecutionTaskIdentityList$member' => NULL, ], ], 'MaintenanceWindowExecutionTaskIdentityList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTasksResult$WindowExecutionTaskIdentities' => '<p>Information about the task executions.</p>', ], ], 'MaintenanceWindowExecutionTaskInvocationId' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationRequest$InvocationId' => '<p>The invocation ID to retrieve.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$InvocationId' => '<p>The invocation ID.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$InvocationId' => '<p>The ID of the task invocation.</p>', ], ], 'MaintenanceWindowExecutionTaskInvocationIdentity' => [ 'base' => '<p>Describes the information about a task invocation for a particular target as part of a task execution performed as part of a Maintenance Window execution.</p>', 'refs' => [ 'MaintenanceWindowExecutionTaskInvocationIdentityList$member' => NULL, ], ], 'MaintenanceWindowExecutionTaskInvocationIdentityList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTaskInvocationsResult$WindowExecutionTaskInvocationIdentities' => '<p>Information about the task invocation results per invocation.</p>', ], ], 'MaintenanceWindowExecutionTaskInvocationParameters' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$Parameters' => '<p>The parameters used at the time the task executed.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$Parameters' => '<p>The parameters that were provided for the invocation when it was executed.</p>', ], ], 'MaintenanceWindowFilter' => [ 'base' => '<p>Filter used in the request.</p>', 'refs' => [ 'MaintenanceWindowFilterList$member' => NULL, ], ], 'MaintenanceWindowFilterKey' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowFilter$Key' => '<p>The name of the filter.</p>', ], ], 'MaintenanceWindowFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$Filters' => '<p>Optional filters used to scope down the returned task invocations. The supported filter key is STATUS with the corresponding values PENDING, IN_PROGRESS, SUCCESS, FAILED, TIMED_OUT, CANCELLING, and CANCELLED.</p>', 'DescribeMaintenanceWindowExecutionTasksRequest$Filters' => '<p>Optional filters used to scope down the returned tasks. The supported filter key is STATUS with the corresponding values PENDING, IN_PROGRESS, SUCCESS, FAILED, TIMED_OUT, CANCELLING, and CANCELLED. </p>', 'DescribeMaintenanceWindowExecutionsRequest$Filters' => '<p>Each entry in the array is a structure containing:</p> <p>Key (string, between 1 and 128 characters)</p> <p>Values (array of strings, each string is between 1 and 256 characters)</p> <p>The supported Keys are ExecutedBefore and ExecutedAfter with the value being a date/time string such as 2016-11-04T05:00:00Z.</p>', 'DescribeMaintenanceWindowTargetsRequest$Filters' => '<p>Optional filters that can be used to narrow down the scope of the returned window targets. The supported filter keys are Type, WindowTargetId and OwnerInformation.</p>', 'DescribeMaintenanceWindowTasksRequest$Filters' => '<p>Optional filters used to narrow down the scope of the returned tasks. The supported filter keys are WindowTaskId, TaskArn, Priority, and TaskType.</p>', 'DescribeMaintenanceWindowsRequest$Filters' => '<p>Optional filters used to narrow down the scope of the returned Maintenance Windows. Supported filter keys are Name and Enabled.</p>', ], ], 'MaintenanceWindowFilterValue' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowFilterValues$member' => NULL, ], ], 'MaintenanceWindowFilterValues' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowFilter$Values' => '<p>The filter values.</p>', ], ], 'MaintenanceWindowId' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowResult$WindowId' => '<p>The ID of the created Maintenance Window.</p>', 'DeleteMaintenanceWindowRequest$WindowId' => '<p>The ID of the Maintenance Window to delete.</p>', 'DeleteMaintenanceWindowResult$WindowId' => '<p>The ID of the deleted Maintenance Window.</p>', 'DeregisterTargetFromMaintenanceWindowRequest$WindowId' => '<p>The ID of the Maintenance Window the target should be removed from.</p>', 'DeregisterTargetFromMaintenanceWindowResult$WindowId' => '<p>The ID of the Maintenance Window the target was removed from.</p>', 'DeregisterTaskFromMaintenanceWindowRequest$WindowId' => '<p>The ID of the Maintenance Window the task should be removed from.</p>', 'DeregisterTaskFromMaintenanceWindowResult$WindowId' => '<p>The ID of the Maintenance Window the task was removed from.</p>', 'DescribeMaintenanceWindowExecutionsRequest$WindowId' => '<p>The ID of the Maintenance Window whose executions should be retrieved.</p>', 'DescribeMaintenanceWindowTargetsRequest$WindowId' => '<p>The ID of the Maintenance Window whose targets should be retrieved.</p>', 'DescribeMaintenanceWindowTasksRequest$WindowId' => '<p>The ID of the Maintenance Window whose tasks should be retrieved.</p>', 'GetMaintenanceWindowRequest$WindowId' => '<p>The ID of the desired Maintenance Window.</p>', 'GetMaintenanceWindowResult$WindowId' => '<p>The ID of the created Maintenance Window.</p>', 'GetMaintenanceWindowTaskRequest$WindowId' => '<p>The Maintenance Window ID that includes the task to retrieve.</p>', 'GetMaintenanceWindowTaskResult$WindowId' => '<p>The retrieved Maintenance Window ID.</p>', 'MaintenanceWindowExecution$WindowId' => '<p>The ID of the Maintenance Window.</p>', 'MaintenanceWindowIdentity$WindowId' => '<p>The ID of the Maintenance Window.</p>', 'MaintenanceWindowTarget$WindowId' => '<p>The Maintenance Window ID where the target is registered.</p>', 'MaintenanceWindowTask$WindowId' => '<p>The Maintenance Window ID where the task is registered.</p>', 'RegisterTargetWithMaintenanceWindowRequest$WindowId' => '<p>The ID of the Maintenance Window the target should be registered with.</p>', 'RegisterTaskWithMaintenanceWindowRequest$WindowId' => '<p>The id of the Maintenance Window the task should be added to.</p>', 'UpdateMaintenanceWindowRequest$WindowId' => '<p>The ID of the Maintenance Window to update.</p>', 'UpdateMaintenanceWindowResult$WindowId' => '<p>The ID of the created Maintenance Window.</p>', 'UpdateMaintenanceWindowTargetRequest$WindowId' => '<p>The Maintenance Window ID for which you want to modify the target.</p>', 'UpdateMaintenanceWindowTargetResult$WindowId' => '<p>The Maintenance Window ID specified in the update request.</p>', 'UpdateMaintenanceWindowTaskRequest$WindowId' => '<p>The Maintenance Window ID that contains the task that you want to modify.</p>', 'UpdateMaintenanceWindowTaskResult$WindowId' => '<p>The Maintenance Window ID that was updated.</p>', ], ], 'MaintenanceWindowIdentity' => [ 'base' => '<p>Information about the Maintenance Window.</p>', 'refs' => [ 'MaintenanceWindowIdentityList$member' => NULL, ], ], 'MaintenanceWindowIdentityList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowsResult$WindowIdentities' => '<p>Information about the Maintenance Windows.</p>', ], ], 'MaintenanceWindowLambdaClientContext' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowLambdaParameters$ClientContext' => '<p>Using the ClientContext you can pass client-specific information to the Lambda function you are invoking. You can then process the client information in your Lambda function as you choose through the context variable.</p>', ], ], 'MaintenanceWindowLambdaParameters' => [ 'base' => '<p>Parameters for a LAMBDA task type.</p>', 'refs' => [ 'MaintenanceWindowTaskInvocationParameters$Lambda' => '<p>Parameters for a LAMBDA task type.</p>', ], ], 'MaintenanceWindowLambdaPayload' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowLambdaParameters$Payload' => '<p>JSON that you want to provide to your Lambda function as input.</p>', ], ], 'MaintenanceWindowLambdaQualifier' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowLambdaParameters$Qualifier' => '<p>You can use this optional parameter to specify a Lambda function version or alias name. If you specify a function version, the API uses the qualified function ARN to invoke a specific Lambda function. If you specify an alias name, the API uses the alias ARN to invoke the Lambda function version to which the alias points.</p>', ], ], 'MaintenanceWindowMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowExecutionTasksRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowExecutionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowTargetsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowTasksRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'MaintenanceWindowName' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Name' => '<p>The name of the Maintenance Window.</p>', 'GetMaintenanceWindowResult$Name' => '<p>The name of the Maintenance Window.</p>', 'GetMaintenanceWindowTaskResult$Name' => '<p>The retrieved task name.</p>', 'MaintenanceWindowIdentity$Name' => '<p>The name of the Maintenance Window.</p>', 'MaintenanceWindowTarget$Name' => '<p>The target name.</p>', 'MaintenanceWindowTask$Name' => '<p>The task name.</p>', 'RegisterTargetWithMaintenanceWindowRequest$Name' => '<p>An optional name for the target.</p>', 'RegisterTaskWithMaintenanceWindowRequest$Name' => '<p>An optional name for the task.</p>', 'UpdateMaintenanceWindowRequest$Name' => '<p>The name of the Maintenance Window.</p>', 'UpdateMaintenanceWindowResult$Name' => '<p>The name of the Maintenance Window.</p>', 'UpdateMaintenanceWindowTargetRequest$Name' => '<p>A name for the update.</p>', 'UpdateMaintenanceWindowTargetResult$Name' => '<p>The updated name.</p>', 'UpdateMaintenanceWindowTaskRequest$Name' => '<p>The new task name that you want to specify.</p>', 'UpdateMaintenanceWindowTaskResult$Name' => '<p>The updated task name.</p>', ], ], 'MaintenanceWindowResourceType' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowTarget$ResourceType' => '<p>The type of target.</p>', 'RegisterTargetWithMaintenanceWindowRequest$ResourceType' => '<p>The type of target being registered with the Maintenance Window.</p>', ], ], 'MaintenanceWindowRunCommandParameters' => [ 'base' => '<p>Parameters for a RUN_COMMAND task type.</p>', 'refs' => [ 'MaintenanceWindowTaskInvocationParameters$RunCommand' => '<p>Parameters for a RUN_COMMAND task type.</p>', ], ], 'MaintenanceWindowSchedule' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Schedule' => '<p>The schedule of the Maintenance Window in the form of a cron or rate expression.</p>', 'GetMaintenanceWindowResult$Schedule' => '<p>The schedule of the Maintenance Window in the form of a cron or rate expression.</p>', 'UpdateMaintenanceWindowRequest$Schedule' => '<p>The schedule of the Maintenance Window in the form of a cron or rate expression.</p>', 'UpdateMaintenanceWindowResult$Schedule' => '<p>The schedule of the Maintenance Window in the form of a cron or rate expression.</p>', ], ], 'MaintenanceWindowStepFunctionsInput' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowStepFunctionsParameters$Input' => '<p>The inputs for the STEP_FUNCTION task.</p>', ], ], 'MaintenanceWindowStepFunctionsName' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowStepFunctionsParameters$Name' => '<p>The name of the STEP_FUNCTION task.</p>', ], ], 'MaintenanceWindowStepFunctionsParameters' => [ 'base' => '<p>Parameters for the STEP_FUNCTION execution.</p>', 'refs' => [ 'MaintenanceWindowTaskInvocationParameters$StepFunctions' => '<p>Parameters for a STEP_FUNCTION task type.</p>', ], ], 'MaintenanceWindowTarget' => [ 'base' => '<p>The target registered with the Maintenance Window.</p>', 'refs' => [ 'MaintenanceWindowTargetList$member' => NULL, ], ], 'MaintenanceWindowTargetId' => [ 'base' => NULL, 'refs' => [ 'DeregisterTargetFromMaintenanceWindowRequest$WindowTargetId' => '<p>The ID of the target definition to remove.</p>', 'DeregisterTargetFromMaintenanceWindowResult$WindowTargetId' => '<p>The ID of the removed target definition.</p>', 'MaintenanceWindowTarget$WindowTargetId' => '<p>The ID of the target.</p>', 'RegisterTargetWithMaintenanceWindowResult$WindowTargetId' => '<p>The ID of the target definition in this Maintenance Window.</p>', 'UpdateMaintenanceWindowTargetRequest$WindowTargetId' => '<p>The target ID that you want to modify.</p>', 'UpdateMaintenanceWindowTargetResult$WindowTargetId' => '<p>The target ID specified in the update request.</p>', ], ], 'MaintenanceWindowTargetList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowTargetsResult$Targets' => '<p>Information about the targets in the Maintenance Window.</p>', ], ], 'MaintenanceWindowTask' => [ 'base' => '<p>Information about a task defined for a Maintenance Window.</p>', 'refs' => [ 'MaintenanceWindowTaskList$member' => NULL, ], ], 'MaintenanceWindowTaskArn' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskResult$TaskArn' => '<p>The ARN of the executed task.</p>', 'GetMaintenanceWindowTaskResult$TaskArn' => '<p>TaskArn is the resource that the task used during execution. For RUN_COMMAND and AUTOMATION task types, the TaskArn is the SSM Document Name/ARN. For LAMBDA tasks, TaskArn is the Function Name/ARN. For STEP_FUNCTION tasks, the TaskArn is the State Machine ARN.</p>', 'MaintenanceWindowExecutionTaskIdentity$TaskArn' => '<p>The ARN of the executed task.</p>', 'MaintenanceWindowTask$TaskArn' => '<p>TaskArn is the resource that the task uses during execution. For RUN_COMMAND and AUTOMATION task types, the TaskArn is the SSM Document Name/ARN. For LAMBDA tasks, it\'s the Function Name/ARN. For STEP_FUNCTION tasks, it\'s the State Machine ARN.</p>', 'RegisterTaskWithMaintenanceWindowRequest$TaskArn' => '<p>The ARN of the task to execute </p>', 'UpdateMaintenanceWindowTaskRequest$TaskArn' => '<p>The task ARN that you want to modify.</p>', 'UpdateMaintenanceWindowTaskResult$TaskArn' => '<p>The updated task ARN value.</p>', ], ], 'MaintenanceWindowTaskId' => [ 'base' => NULL, 'refs' => [ 'DeregisterTaskFromMaintenanceWindowRequest$WindowTaskId' => '<p>The ID of the task to remove from the Maintenance Window.</p>', 'DeregisterTaskFromMaintenanceWindowResult$WindowTaskId' => '<p>The ID of the task removed from the Maintenance Window.</p>', 'GetMaintenanceWindowTaskRequest$WindowTaskId' => '<p>The Maintenance Window task ID to retrieve.</p>', 'GetMaintenanceWindowTaskResult$WindowTaskId' => '<p>The retrieved Maintenance Window task ID.</p>', 'MaintenanceWindowTask$WindowTaskId' => '<p>The task ID.</p>', 'RegisterTaskWithMaintenanceWindowResult$WindowTaskId' => '<p>The id of the task in the Maintenance Window.</p>', 'UpdateMaintenanceWindowTaskRequest$WindowTaskId' => '<p>The task ID that you want to modify.</p>', 'UpdateMaintenanceWindowTaskResult$WindowTaskId' => '<p>The Maintenance Window task ID that was updated.</p>', ], ], 'MaintenanceWindowTaskInvocationParameters' => [ 'base' => '<p>Parameters for task execution.</p>', 'refs' => [ 'GetMaintenanceWindowTaskResult$TaskInvocationParameters' => '<p>The parameters to pass to the task when it executes.</p>', 'RegisterTaskWithMaintenanceWindowRequest$TaskInvocationParameters' => '<p>Parameters the task should use during execution. Populate only the fields that match the task type. All other fields should be empty. </p>', 'UpdateMaintenanceWindowTaskRequest$TaskInvocationParameters' => '<p>Parameters the task should use during execution. Populate only the fields that match the task type. All other fields should be empty.</p>', 'UpdateMaintenanceWindowTaskResult$TaskInvocationParameters' => '<p>The updated parameter values.</p>', ], ], 'MaintenanceWindowTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowTasksResult$Tasks' => '<p>Information about the tasks in the Maintenance Window.</p>', ], ], 'MaintenanceWindowTaskParameterName' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowTaskParameters$key' => NULL, ], ], 'MaintenanceWindowTaskParameterValue' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowTaskParameterValueList$member' => NULL, ], ], 'MaintenanceWindowTaskParameterValueExpression' => [ 'base' => '<p>Defines the values for a task parameter.</p>', 'refs' => [ 'MaintenanceWindowTaskParameters$value' => NULL, ], ], 'MaintenanceWindowTaskParameterValueList' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowTaskParameterValueExpression$Values' => '<p>This field contains an array of 0 or more strings, each 1 to 255 characters in length.</p>', ], ], 'MaintenanceWindowTaskParameters' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowTaskResult$TaskParameters' => '<p>The parameters to pass to the task when it executes.</p>', 'MaintenanceWindowTask$TaskParameters' => '<p>The parameters that should be passed to the task when it is executed.</p>', 'MaintenanceWindowTaskParametersList$member' => NULL, 'RegisterTaskWithMaintenanceWindowRequest$TaskParameters' => '<p>The parameters that should be passed to the task when it is executed.</p>', 'UpdateMaintenanceWindowTaskRequest$TaskParameters' => '<p>The parameters that you want to modify. The map has the following format:</p> <p>Key: string, between 1 and 255 characters</p> <p>Value: an array of strings, each string is between 1 and 255 characters</p>', 'UpdateMaintenanceWindowTaskResult$TaskParameters' => '<p>The updated parameter values.</p>', ], ], 'MaintenanceWindowTaskParametersList' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskResult$TaskParameters' => '<p>The parameters passed to the task when it was executed. The map has the following format:</p> <p>Key: string, between 1 and 255 characters</p> <p>Value: an array of strings, each string is between 1 and 255 characters</p>', ], ], 'MaintenanceWindowTaskPriority' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskResult$Priority' => '<p>The priority of the task.</p>', 'GetMaintenanceWindowTaskResult$Priority' => '<p>The priority of the task when it executes. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>', 'MaintenanceWindowTask$Priority' => '<p>The priority of the task in the Maintenance Window. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>', 'RegisterTaskWithMaintenanceWindowRequest$Priority' => '<p>The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.</p>', 'UpdateMaintenanceWindowTaskRequest$Priority' => '<p>The new task priority that you want to specify. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>', 'UpdateMaintenanceWindowTaskResult$Priority' => '<p>The updated priority value.</p>', ], ], 'MaintenanceWindowTaskTargetId' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$WindowTargetId' => '<p>The Maintenance Window target ID.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$WindowTargetId' => '<p>The ID of the target definition in this Maintenance Window the invocation was performed for.</p>', ], ], 'MaintenanceWindowTaskType' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$TaskType' => '<p>Retrieves the task type for a Maintenance Window. Task types include the following: LAMBDA, STEP_FUNCTION, AUTOMATION, RUN_COMMAND.</p>', 'GetMaintenanceWindowExecutionTaskResult$Type' => '<p>The type of task executed.</p>', 'GetMaintenanceWindowTaskResult$TaskType' => '<p>The type of task to execute.</p>', 'MaintenanceWindowExecutionTaskIdentity$TaskType' => '<p>The type of executed task.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$TaskType' => '<p>The task type.</p>', 'MaintenanceWindowTask$Type' => '<p>The type of task. The type can be one of the following: RUN_COMMAND, AUTOMATION, LAMBDA, or STEP_FUNCTION.</p>', 'RegisterTaskWithMaintenanceWindowRequest$TaskType' => '<p>The type of task being registered.</p>', ], ], 'ManagedInstanceId' => [ 'base' => NULL, 'refs' => [ 'DeregisterManagedInstanceRequest$InstanceId' => '<p>The ID assigned to the managed instance when you registered it using the activation process. </p>', 'UpdateManagedInstanceRoleRequest$InstanceId' => '<p>The ID of the managed instance where you want to update the role.</p>', ], ], 'MaxConcurrency' => [ 'base' => NULL, 'refs' => [ 'Command$MaxConcurrency' => '<p>The maximum number of instances that are allowed to execute the command at the same time. You can specify a number of instances, such as 10, or a percentage of instances, such as 10%. The default value is 50. For more information about how to use MaxConcurrency, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Executing a Command Using Systems Manager Run Command</a>.</p>', 'GetMaintenanceWindowExecutionTaskResult$MaxConcurrency' => '<p>The defined maximum number of task executions that could be run in parallel.</p>', 'GetMaintenanceWindowTaskResult$MaxConcurrency' => '<p>The maximum number of targets allowed to run this task in parallel.</p>', 'MaintenanceWindowTask$MaxConcurrency' => '<p>The maximum number of targets this task can be run for in parallel.</p>', 'RegisterTaskWithMaintenanceWindowRequest$MaxConcurrency' => '<p>The maximum number of targets this task can be run for in parallel.</p>', 'SendCommandRequest$MaxConcurrency' => '<p>(Optional) The maximum number of instances that are allowed to execute the command at the same time. You can specify a number such as 10 or a percentage such as 10%. The default value is 50. For more information about how to use MaxConcurrency, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-velocity.html">Using Concurrency Controls</a>.</p>', 'UpdateMaintenanceWindowTaskRequest$MaxConcurrency' => '<p>The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code> is the number of targets that are allowed to run this task in parallel.</p>', 'UpdateMaintenanceWindowTaskResult$MaxConcurrency' => '<p>The updated MaxConcurrency value.</p>', ], ], 'MaxDocumentSizeExceeded' => [ 'base' => '<p>The size limit of a document is 64 KB.</p>', 'refs' => [], ], 'MaxErrors' => [ 'base' => NULL, 'refs' => [ 'Command$MaxErrors' => '<p>The maximum number of errors allowed before the system stops sending the command to additional targets. You can specify a number of errors, such as 10, or a percentage or errors, such as 10%. The default value is 50. For more information about how to use MaxErrors, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Executing a Command Using Systems Manager Run Command</a>.</p>', 'GetMaintenanceWindowExecutionTaskResult$MaxErrors' => '<p>The defined maximum number of task execution errors allowed before scheduling of the task execution would have been stopped.</p>', 'GetMaintenanceWindowTaskResult$MaxErrors' => '<p>The maximum number of errors allowed before the task stops being scheduled.</p>', 'MaintenanceWindowTask$MaxErrors' => '<p>The maximum number of errors allowed before this task stops being scheduled.</p>', 'RegisterTaskWithMaintenanceWindowRequest$MaxErrors' => '<p>The maximum number of errors allowed before this task stops being scheduled.</p>', 'SendCommandRequest$MaxErrors' => '<p>The maximum number of errors allowed without the command failing. When the command fails one more time beyond the value of MaxErrors, the systems stops sending the command to additional targets. You can specify a number like 10 or a percentage like 10%. The default value is 50. For more information about how to use MaxErrors, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-maxerrors.html">Using Error Controls</a>.</p>', 'UpdateMaintenanceWindowTaskRequest$MaxErrors' => '<p>The new <code>MaxErrors</code> value you want to specify. <code>MaxErrors</code> is the maximum number of errors that are allowed before the task stops being scheduled.</p>', 'UpdateMaintenanceWindowTaskResult$MaxErrors' => '<p>The updated MaxErrors value.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeAutomationExecutionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeInstanceAssociationsStatusRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeParametersRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'GetInventoryRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'GetParameterHistoryRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListAssociationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListComplianceItemsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListComplianceSummariesRequest$MaxResults' => '<p>The maximum number of items to return for this call. Currently, you can specify null or 50. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListDocumentVersionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListDocumentsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListInventoryEntriesRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListResourceComplianceSummariesRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListResourceDataSyncRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'MaxResultsEC2Compatible' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceInformationRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. </p>', ], ], 'ModifyDocumentPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDocumentPermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'DescribeActivationsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results. </p>', 'DescribeAutomationExecutionsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeAutomationExecutionsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeAvailablePatchesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeAvailablePatchesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeEffectiveInstanceAssociationsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeEffectiveInstanceAssociationsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeEffectivePatchesForPatchBaselineRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeEffectivePatchesForPatchBaselineResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInstanceAssociationsStatusRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstanceAssociationsStatusResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInstanceInformationRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstanceInformationResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty. </p>', 'DescribeInstancePatchStatesForPatchGroupRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstancePatchStatesForPatchGroupResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInstancePatchStatesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstancePatchStatesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInstancePatchesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstancePatchesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowExecutionTaskInvocationsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowExecutionTasksRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowExecutionTasksResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowExecutionsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowExecutionsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowTargetsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowTargetsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowTasksRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowTasksResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeParametersRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeParametersResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribePatchBaselinesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribePatchBaselinesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribePatchGroupsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribePatchGroupsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'GetInventoryRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'GetInventoryResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'GetInventorySchemaRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'GetInventorySchemaResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'GetParameterHistoryRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'GetParameterHistoryResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'GetParametersByPathRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'GetParametersByPathResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListAssociationsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListAssociationsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'ListCommandInvocationsRequest$NextToken' => '<p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListCommandInvocationsResult$NextToken' => '<p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListCommandsRequest$NextToken' => '<p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListCommandsResult$NextToken' => '<p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListComplianceItemsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListComplianceItemsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListComplianceSummariesRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListComplianceSummariesResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListDocumentVersionsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListDocumentVersionsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'ListDocumentsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListDocumentsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'ListInventoryEntriesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListInventoryEntriesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'ListResourceComplianceSummariesRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListResourceComplianceSummariesResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListResourceDataSyncRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListResourceDataSyncResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', ], ], 'NonCompliantSummary' => [ 'base' => '<p>A summary of resources that are not compliant. The summary is organized according to resource type.</p>', 'refs' => [ 'ComplianceSummaryItem$NonCompliantSummary' => '<p>A list of NON_COMPLIANT items for the specified compliance type.</p>', 'ResourceComplianceSummaryItem$NonCompliantSummary' => '<p>A list of items that aren\'t compliant for the resource.</p>', ], ], 'NormalStringMap' => [ 'base' => NULL, 'refs' => [ 'StepExecution$Inputs' => '<p>Fully-resolved values passed into the step before execution.</p>', ], ], 'NotificationArn' => [ 'base' => NULL, 'refs' => [ 'NotificationConfig$NotificationArn' => '<p>An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic. Run Command pushes notifications about command status changes to this topic.</p>', ], ], 'NotificationConfig' => [ 'base' => '<p>Configurations for sending notifications.</p>', 'refs' => [ 'Command$NotificationConfig' => '<p>Configurations for sending notifications about command status changes. </p>', 'CommandInvocation$NotificationConfig' => '<p>Configurations for sending notifications about command status changes on a per instance basis.</p>', 'MaintenanceWindowRunCommandParameters$NotificationConfig' => '<p>Configurations for sending notifications about command status changes on a per instance basis.</p>', 'SendCommandRequest$NotificationConfig' => '<p>Configurations for sending notifications.</p>', ], ], 'NotificationEvent' => [ 'base' => NULL, 'refs' => [ 'NotificationEventList$member' => NULL, ], ], 'NotificationEventList' => [ 'base' => NULL, 'refs' => [ 'NotificationConfig$NotificationEvents' => '<p>The different events for which you can receive notifications. These events include the following: All (events), InProgress, Success, TimedOut, Cancelled, Failed. To learn more about these events, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Setting Up Events and Notifications</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.</p>', ], ], 'NotificationType' => [ 'base' => NULL, 'refs' => [ 'NotificationConfig$NotificationType' => '<p>Command: Receive notification when the status of a command changes. Invocation: For commands sent to multiple instances, receive notification on a per-instance basis when the status of a command changes. </p>', ], ], 'OperatingSystem' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$OperatingSystem' => '<p>Defines the operating system the patch baseline applies to. Supported operating systems include WINDOWS, AMAZON_LINUX, UBUNTU and REDHAT_ENTERPRISE_LINUX. The Default value is WINDOWS.</p>', 'GetDefaultPatchBaselineRequest$OperatingSystem' => '<p>Returns the default patch baseline for the specified operating system.</p>', 'GetDefaultPatchBaselineResult$OperatingSystem' => '<p>The operating system for the returned patch baseline. </p>', 'GetPatchBaselineForPatchGroupRequest$OperatingSystem' => '<p>Returns he operating system rule specified for patch groups using the patch baseline.</p>', 'GetPatchBaselineForPatchGroupResult$OperatingSystem' => '<p>The operating system rule specified for patch groups using the patch baseline.</p>', 'GetPatchBaselineResult$OperatingSystem' => '<p>Returns the operating system specified for the patch baseline.</p>', 'PatchBaselineIdentity$OperatingSystem' => '<p>Defines the operating system the patch baseline applies to. Supported operating systems include WINDOWS, AMAZON_LINUX, UBUNTU and REDHAT_ENTERPRISE_LINUX. The Default value is WINDOWS. </p>', 'UpdatePatchBaselineResult$OperatingSystem' => '<p>The operating system rule used by the updated patch baseline.</p>', ], ], 'OwnerInformation' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$OwnerInformation' => '<p>User-provided value that will be included in any CloudWatch events raised while running tasks for these targets in this Maintenance Window. </p>', 'InstancePatchState$OwnerInformation' => '<p>Placeholder information, this field will always be empty in the current release of the service.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$OwnerInformation' => '<p>User-provided value that was specified when the target was registered with the Maintenance Window. This was also included in any CloudWatch events raised during the task invocation.</p>', 'MaintenanceWindowTarget$OwnerInformation' => '<p>User-provided value that will be included in any CloudWatch events raised while running tasks for these targets in this Maintenance Window.</p>', 'RegisterTargetWithMaintenanceWindowRequest$OwnerInformation' => '<p>User-provided value that will be included in any CloudWatch events raised while running tasks for these targets in this Maintenance Window.</p>', 'UpdateMaintenanceWindowTargetRequest$OwnerInformation' => '<p>User-provided value that will be included in any CloudWatch events raised while running tasks for these targets in this Maintenance Window.</p>', 'UpdateMaintenanceWindowTargetResult$OwnerInformation' => '<p>The updated owner.</p>', ], ], 'PSParameterName' => [ 'base' => NULL, 'refs' => [ 'DeleteParameterRequest$Name' => '<p>The name of the parameter to delete.</p>', 'GetParameterHistoryRequest$Name' => '<p>The name of a parameter you want to query.</p>', 'GetParameterRequest$Name' => '<p>The name of the parameter you want to query.</p>', 'GetParametersByPathRequest$Path' => '<p>The hierarchy for the parameter. Hierarchies start with a forward slash (/) and end with the parameter name. A hierarchy can have a maximum of five levels. Examples: /Environment/Test/DBString003</p> <p>/Finance/Prod/IAD/OS/WinServ2016/license15</p>', 'Parameter$Name' => '<p>The name of the parameter.</p>', 'ParameterHistory$Name' => '<p>The name of the parameter.</p>', 'ParameterMetadata$Name' => '<p>The parameter name.</p>', 'ParameterNameList$member' => NULL, 'PutParameterRequest$Name' => '<p>The name of the parameter that you want to add to the system.</p>', ], ], 'PSParameterValue' => [ 'base' => NULL, 'refs' => [ 'Parameter$Value' => '<p>The parameter value.</p>', 'ParameterHistory$Value' => '<p>The parameter value.</p>', 'PutParameterRequest$Value' => '<p>The parameter value that you want to add to the system.</p>', ], ], 'Parameter' => [ 'base' => '<p>An Amazon EC2 Systems Manager parameter in Parameter Store.</p>', 'refs' => [ 'GetParameterResult$Parameter' => '<p>Information about a parameter.</p>', 'ParameterList$member' => NULL, ], ], 'ParameterAlreadyExists' => [ 'base' => '<p>The parameter already exists. You can\'t create duplicate parameters.</p>', 'refs' => [], ], 'ParameterDescription' => [ 'base' => NULL, 'refs' => [ 'ParameterHistory$Description' => '<p>Information about the parameter.</p>', 'ParameterMetadata$Description' => '<p>Description of the parameter actions.</p>', 'PutParameterRequest$Description' => '<p>Information about the parameter that you want to add to the system</p>', ], ], 'ParameterHistory' => [ 'base' => '<p>Information about parameter usage.</p>', 'refs' => [ 'ParameterHistoryList$member' => NULL, ], ], 'ParameterHistoryList' => [ 'base' => NULL, 'refs' => [ 'GetParameterHistoryResult$Parameters' => '<p>A list of parameters returned by the request.</p>', ], ], 'ParameterKeyId' => [ 'base' => NULL, 'refs' => [ 'ParameterHistory$KeyId' => '<p>The ID of the query key used for this parameter.</p>', 'ParameterMetadata$KeyId' => '<p>The ID of the query key used for this parameter.</p>', 'PutParameterRequest$KeyId' => '<p>The KMS Key ID that you want to use to encrypt a parameter when you choose the SecureString data type. If you don\'t specify a key ID, the system uses the default key associated with your AWS account.</p>', ], ], 'ParameterLimitExceeded' => [ 'base' => '<p>You have exceeded the number of parameters for this AWS account. Delete one or more parameters and try again.</p>', 'refs' => [], ], 'ParameterList' => [ 'base' => NULL, 'refs' => [ 'GetParametersByPathResult$Parameters' => '<p>A list of parameters found in the specified hierarchy.</p>', 'GetParametersResult$Parameters' => '<p>A list of details for a parameter.</p>', ], ], 'ParameterMetadata' => [ 'base' => '<p>Metada includes information like the ARN of the last user and the date/time the parameter was last used.</p>', 'refs' => [ 'ParameterMetadataList$member' => NULL, ], ], 'ParameterMetadataList' => [ 'base' => NULL, 'refs' => [ 'DescribeParametersResult$Parameters' => '<p>Parameters returned by the request.</p>', ], ], 'ParameterName' => [ 'base' => NULL, 'refs' => [ 'Parameters$key' => NULL, ], ], 'ParameterNameList' => [ 'base' => NULL, 'refs' => [ 'DeleteParametersRequest$Names' => '<p>The names of the parameters to delete.</p>', 'DeleteParametersResult$DeletedParameters' => '<p>The names of the deleted parameters.</p>', 'DeleteParametersResult$InvalidParameters' => '<p>The names of parameters that weren\'t deleted because the parameters are not valid.</p>', 'GetParametersRequest$Names' => '<p>Names of the parameters for which you want to query information.</p>', 'GetParametersResult$InvalidParameters' => '<p>A list of parameters that are not formatted correctly or do not run when executed.</p>', ], ], 'ParameterNotFound' => [ 'base' => '<p>The parameter could not be found. Verify the name and try again.</p>', 'refs' => [], ], 'ParameterPatternMismatchException' => [ 'base' => '<p>The parameter name is not valid.</p>', 'refs' => [], ], 'ParameterStringFilter' => [ 'base' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', 'refs' => [ 'ParameterStringFilterList$member' => NULL, ], ], 'ParameterStringFilterKey' => [ 'base' => NULL, 'refs' => [ 'ParameterStringFilter$Key' => '<p>The name of the filter.</p>', ], ], 'ParameterStringFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeParametersRequest$ParameterFilters' => '<p>Filters to limit the request results.</p>', 'GetParametersByPathRequest$ParameterFilters' => '<p>Filters to limit the request results.</p>', ], ], 'ParameterStringFilterValue' => [ 'base' => NULL, 'refs' => [ 'ParameterStringFilterValueList$member' => NULL, ], ], 'ParameterStringFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ParameterStringFilter$Values' => '<p>The value you want to search for.</p>', ], ], 'ParameterStringQueryOption' => [ 'base' => NULL, 'refs' => [ 'ParameterStringFilter$Option' => '<p>Valid options are Equals and BeginsWith. For Path filter, valid options are Recursive and OneLevel.</p>', ], ], 'ParameterType' => [ 'base' => NULL, 'refs' => [ 'Parameter$Type' => '<p>The type of parameter. Valid values include the following: String, String list, Secure string.</p>', 'ParameterHistory$Type' => '<p>The type of parameter used.</p>', 'ParameterMetadata$Type' => '<p>The type of parameter. Valid parameter types include the following: String, String list, Secure string.</p>', 'PutParameterRequest$Type' => '<p>The type of parameter that you want to add to the system.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'ParameterValueList$member' => NULL, ], ], 'ParameterValueList' => [ 'base' => NULL, 'refs' => [ 'Parameters$value' => NULL, ], ], 'Parameters' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$Parameters' => '<p>A description of the parameters for a document. </p>', 'Command$Parameters' => '<p>The parameter values to be inserted in the document when executing the command.</p>', 'CreateAssociationBatchRequestEntry$Parameters' => '<p>A description of the parameters for a document. </p>', 'CreateAssociationRequest$Parameters' => '<p>The parameters for the documents runtime configuration. </p>', 'MaintenanceWindowRunCommandParameters$Parameters' => '<p>Parameters for the RUN_COMMAND task execution.</p>', 'SendCommandRequest$Parameters' => '<p>The required and optional parameters specified in the document being executed.</p>', 'UpdateAssociationRequest$Parameters' => '<p>The parameters you want to update for the association. If you create a parameter using Parameter Store, you can reference the parameter using {{ssm:parameter-name}}</p>', ], ], 'ParametersFilter' => [ 'base' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', 'refs' => [ 'ParametersFilterList$member' => NULL, ], ], 'ParametersFilterKey' => [ 'base' => NULL, 'refs' => [ 'ParametersFilter$Key' => '<p>The name of the filter.</p>', ], ], 'ParametersFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeParametersRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', ], ], 'ParametersFilterValue' => [ 'base' => NULL, 'refs' => [ 'ParametersFilterValueList$member' => NULL, ], ], 'ParametersFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ParametersFilter$Values' => '<p>The filter values.</p>', ], ], 'Patch' => [ 'base' => '<p>Represents metadata about a patch.</p>', 'refs' => [ 'EffectivePatch$Patch' => '<p>Provides metadata for a patch, including information such as the KB ID, severity, classification and a URL for where more information can be obtained about the patch.</p>', 'PatchList$member' => NULL, ], ], 'PatchBaselineIdentity' => [ 'base' => '<p>Defines the basic information about a patch baseline.</p>', 'refs' => [ 'PatchBaselineIdentityList$member' => NULL, 'PatchGroupPatchBaselineMapping$BaselineIdentity' => '<p>The patch baseline the patch group is registered with.</p>', ], ], 'PatchBaselineIdentityList' => [ 'base' => NULL, 'refs' => [ 'DescribePatchBaselinesResult$BaselineIdentities' => '<p>An array of PatchBaselineIdentity elements.</p>', ], ], 'PatchBaselineMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailablePatchesRequest$MaxResults' => '<p>The maximum number of patches to return (per page).</p>', 'DescribeEffectivePatchesForPatchBaselineRequest$MaxResults' => '<p>The maximum number of patches to return (per page).</p>', 'DescribePatchBaselinesRequest$MaxResults' => '<p>The maximum number of patch baselines to return (per page).</p>', 'DescribePatchGroupsRequest$MaxResults' => '<p>The maximum number of patch groups to return (per page).</p>', ], ], 'PatchClassification' => [ 'base' => NULL, 'refs' => [ 'Patch$Classification' => '<p>The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).</p>', 'PatchComplianceData$Classification' => '<p>The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).</p>', ], ], 'PatchComplianceData' => [ 'base' => '<p>Information about the state of a patch on a particular instance as it relates to the patch baseline used to patch the instance.</p>', 'refs' => [ 'PatchComplianceDataList$member' => NULL, ], ], 'PatchComplianceDataList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchesResult$Patches' => '<p>Each entry in the array is a structure containing:</p> <p>Title (string)</p> <p>KBId (string)</p> <p>Classification (string)</p> <p>Severity (string)</p> <p>State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")</p> <p>InstalledTime (DateTime)</p> <p>InstalledBy (string)</p>', ], ], 'PatchComplianceDataState' => [ 'base' => NULL, 'refs' => [ 'PatchComplianceData$State' => '<p>The state of the patch on the instance (INSTALLED, INSTALLED_OTHER, MISSING, NOT_APPLICABLE or FAILED).</p>', ], ], 'PatchComplianceLevel' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$ApprovedPatchesComplianceLevel' => '<p>Defines the compliance level for approved patches. This means that if an approved patch is reported as missing, this is the severity of the compliance violation. Valid compliance severity levels include the following: CRITICAL, HIGH, MEDIUM, LOW, INFORMATIONAL, UNSPECIFIED. The default value is UNSPECIFIED.</p>', 'GetPatchBaselineResult$ApprovedPatchesComplianceLevel' => '<p>Returns the specified compliance severity level for approved patches in the patch baseline.</p>', 'PatchRule$ComplianceLevel' => '<p>A compliance severity level for all approved patches in a patch baseline. Valid compliance severity levels include the following: Unspecified, Critical, High, Medium, Low, and Informational.</p>', 'PatchStatus$ComplianceLevel' => '<p>The compliance severity level for a patch.</p>', 'UpdatePatchBaselineRequest$ApprovedPatchesComplianceLevel' => '<p>Assigns a new compliance severity level to an existing patch baseline.</p>', 'UpdatePatchBaselineResult$ApprovedPatchesComplianceLevel' => '<p>The compliance severity level assigned to the patch baseline after the update completed.</p>', ], ], 'PatchComplianceMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchStatesForPatchGroupRequest$MaxResults' => '<p>The maximum number of patches to return (per page).</p>', 'DescribeInstancePatchStatesRequest$MaxResults' => '<p>The maximum number of instances to return (per page).</p>', 'DescribeInstancePatchesRequest$MaxResults' => '<p>The maximum number of patches to return (per page).</p>', ], ], 'PatchContentUrl' => [ 'base' => NULL, 'refs' => [ 'Patch$ContentUrl' => '<p>The URL where more information can be obtained about the patch.</p>', ], ], 'PatchDeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'PatchStatus$DeploymentStatus' => '<p>The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).</p>', ], ], 'PatchDescription' => [ 'base' => NULL, 'refs' => [ 'Patch$Description' => '<p>The description of the patch.</p>', ], ], 'PatchFailedCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$FailedCount' => '<p>The number of patches from the patch baseline that were attempted to be installed during the last patching operation, but failed to install.</p>', ], ], 'PatchFilter' => [ 'base' => '<p>Defines a patch filter.</p>', 'refs' => [ 'PatchFilterList$member' => NULL, ], ], 'PatchFilterGroup' => [ 'base' => '<p>A set of patch filters, typically used for approval rules.</p>', 'refs' => [ 'CreatePatchBaselineRequest$GlobalFilters' => '<p>A set of global filters used to exclude patches from the baseline.</p>', 'GetPatchBaselineResult$GlobalFilters' => '<p>A set of global filters used to exclude patches from the baseline.</p>', 'PatchRule$PatchFilterGroup' => '<p>The patch filter group that defines the criteria for the rule.</p>', 'UpdatePatchBaselineRequest$GlobalFilters' => '<p>A set of global filters used to exclude patches from the baseline.</p>', 'UpdatePatchBaselineResult$GlobalFilters' => '<p>A set of global filters used to exclude patches from the baseline.</p>', ], ], 'PatchFilterKey' => [ 'base' => NULL, 'refs' => [ 'PatchFilter$Key' => '<p>The key for the filter (PRODUCT, CLASSIFICATION, MSRC_SEVERITY, PATCH_ID)</p>', ], ], 'PatchFilterList' => [ 'base' => NULL, 'refs' => [ 'PatchFilterGroup$PatchFilters' => '<p>The set of patch filters that make up the group.</p>', ], ], 'PatchFilterValue' => [ 'base' => NULL, 'refs' => [ 'PatchFilterValueList$member' => NULL, ], ], 'PatchFilterValueList' => [ 'base' => NULL, 'refs' => [ 'PatchFilter$Values' => '<p>The value for the filter key.</p>', ], ], 'PatchGroup' => [ 'base' => NULL, 'refs' => [ 'DeregisterPatchBaselineForPatchGroupRequest$PatchGroup' => '<p>The name of the patch group that should be deregistered from the patch baseline.</p>', 'DeregisterPatchBaselineForPatchGroupResult$PatchGroup' => '<p>The name of the patch group deregistered from the patch baseline.</p>', 'DescribeInstancePatchStatesForPatchGroupRequest$PatchGroup' => '<p>The name of the patch group for which the patch state information should be retrieved.</p>', 'DescribePatchGroupStateRequest$PatchGroup' => '<p>The name of the patch group whose patch snapshot should be retrieved.</p>', 'GetPatchBaselineForPatchGroupRequest$PatchGroup' => '<p>The name of the patch group whose patch baseline should be retrieved.</p>', 'GetPatchBaselineForPatchGroupResult$PatchGroup' => '<p>The name of the patch group.</p>', 'InstancePatchState$PatchGroup' => '<p>The name of the patch group the managed instance belongs to.</p>', 'PatchGroupList$member' => NULL, 'PatchGroupPatchBaselineMapping$PatchGroup' => '<p>The name of the patch group registered with the patch baseline.</p>', 'RegisterPatchBaselineForPatchGroupRequest$PatchGroup' => '<p>The name of the patch group that should be registered with the patch baseline.</p>', 'RegisterPatchBaselineForPatchGroupResult$PatchGroup' => '<p>The name of the patch group registered with the patch baseline.</p>', ], ], 'PatchGroupList' => [ 'base' => NULL, 'refs' => [ 'GetPatchBaselineResult$PatchGroups' => '<p>Patch groups included in the patch baseline.</p>', ], ], 'PatchGroupPatchBaselineMapping' => [ 'base' => '<p>The mapping between a patch group and the patch baseline the patch group is registered with.</p>', 'refs' => [ 'PatchGroupPatchBaselineMappingList$member' => NULL, ], ], 'PatchGroupPatchBaselineMappingList' => [ 'base' => NULL, 'refs' => [ 'DescribePatchGroupsResult$Mappings' => '<p>Each entry in the array contains:</p> <p>PatchGroup: string (between 1 and 256 characters, Regex: ^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$)</p> <p>PatchBaselineIdentity: A PatchBaselineIdentity element. </p>', ], ], 'PatchId' => [ 'base' => NULL, 'refs' => [ 'Patch$Id' => '<p>The ID of the patch (this is different than the Microsoft Knowledge Base ID).</p>', 'PatchIdList$member' => NULL, ], ], 'PatchIdList' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$ApprovedPatches' => '<p>A list of explicitly approved patches for the baseline.</p>', 'CreatePatchBaselineRequest$RejectedPatches' => '<p>A list of explicitly rejected patches for the baseline.</p>', 'GetPatchBaselineResult$ApprovedPatches' => '<p>A list of explicitly approved patches for the baseline.</p>', 'GetPatchBaselineResult$RejectedPatches' => '<p>A list of explicitly rejected patches for the baseline.</p>', 'UpdatePatchBaselineRequest$ApprovedPatches' => '<p>A list of explicitly approved patches for the baseline.</p>', 'UpdatePatchBaselineRequest$RejectedPatches' => '<p>A list of explicitly rejected patches for the baseline.</p>', 'UpdatePatchBaselineResult$ApprovedPatches' => '<p>A list of explicitly approved patches for the baseline.</p>', 'UpdatePatchBaselineResult$RejectedPatches' => '<p>A list of explicitly rejected patches for the baseline.</p>', ], ], 'PatchInstalledCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$InstalledCount' => '<p>The number of patches from the patch baseline that are installed on the instance.</p>', ], ], 'PatchInstalledOtherCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$InstalledOtherCount' => '<p>The number of patches not specified in the patch baseline that are installed on the instance.</p>', ], ], 'PatchKbNumber' => [ 'base' => NULL, 'refs' => [ 'Patch$KbNumber' => '<p>The Microsoft Knowledge Base ID of the patch.</p>', 'PatchComplianceData$KBId' => '<p>The operating system-specific ID of the patch.</p>', ], ], 'PatchLanguage' => [ 'base' => NULL, 'refs' => [ 'Patch$Language' => '<p>The language of the patch if it\'s language-specific.</p>', ], ], 'PatchList' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailablePatchesResult$Patches' => '<p>An array of patches. Each entry in the array is a patch structure.</p>', ], ], 'PatchMissingCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$MissingCount' => '<p>The number of patches from the patch baseline that are applicable for the instance but aren\'t currently installed.</p>', ], ], 'PatchMsrcNumber' => [ 'base' => NULL, 'refs' => [ 'Patch$MsrcNumber' => '<p>The ID of the MSRC bulletin the patch is related to.</p>', ], ], 'PatchMsrcSeverity' => [ 'base' => NULL, 'refs' => [ 'Patch$MsrcSeverity' => '<p>The severity of the patch (for example Critical, Important, Moderate).</p>', ], ], 'PatchNotApplicableCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$NotApplicableCount' => '<p>The number of patches from the patch baseline that aren\'t applicable for the instance and hence aren\'t installed on the instance.</p>', ], ], 'PatchOperationType' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$Operation' => '<p>The type of patching operation that was performed: SCAN (assess patch compliance state) or INSTALL (install missing patches).</p>', ], ], 'PatchOrchestratorFilter' => [ 'base' => '<p>Defines a filter used in Patch Manager APIs.</p>', 'refs' => [ 'PatchOrchestratorFilterList$member' => NULL, ], ], 'PatchOrchestratorFilterKey' => [ 'base' => NULL, 'refs' => [ 'PatchOrchestratorFilter$Key' => '<p>The key for the filter.</p>', ], ], 'PatchOrchestratorFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailablePatchesRequest$Filters' => '<p>Filters used to scope down the returned patches.</p>', 'DescribeInstancePatchesRequest$Filters' => '<p>Each entry in the array is a structure containing:</p> <p>Key (string, between 1 and 128 characters)</p> <p>Values (array of strings, each string between 1 and 256 characters)</p>', 'DescribePatchBaselinesRequest$Filters' => '<p>Each element in the array is a structure containing: </p> <p>Key: (string, "NAME_PREFIX" or "OWNER")</p> <p>Value: (array of strings, exactly 1 entry, between 1 and 255 characters)</p>', 'DescribePatchGroupsRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', ], ], 'PatchOrchestratorFilterValue' => [ 'base' => NULL, 'refs' => [ 'PatchOrchestratorFilterValues$member' => NULL, ], ], 'PatchOrchestratorFilterValues' => [ 'base' => NULL, 'refs' => [ 'PatchOrchestratorFilter$Values' => '<p>The value for the filter.</p>', ], ], 'PatchProduct' => [ 'base' => NULL, 'refs' => [ 'Patch$Product' => '<p>The specific product the patch is applicable for (for example, WindowsServer2016).</p>', ], ], 'PatchProductFamily' => [ 'base' => NULL, 'refs' => [ 'Patch$ProductFamily' => '<p>The product family the patch is applicable for (for example, Windows).</p>', ], ], 'PatchRule' => [ 'base' => '<p>Defines an approval rule for a patch baseline.</p>', 'refs' => [ 'PatchRuleList$member' => NULL, ], ], 'PatchRuleGroup' => [ 'base' => '<p>A set of rules defining the approval rules for a patch baseline.</p>', 'refs' => [ 'CreatePatchBaselineRequest$ApprovalRules' => '<p>A set of rules used to include patches in the baseline.</p>', 'GetPatchBaselineResult$ApprovalRules' => '<p>A set of rules used to include patches in the baseline.</p>', 'UpdatePatchBaselineRequest$ApprovalRules' => '<p>A set of rules used to include patches in the baseline.</p>', 'UpdatePatchBaselineResult$ApprovalRules' => '<p>A set of rules used to include patches in the baseline.</p>', ], ], 'PatchRuleList' => [ 'base' => NULL, 'refs' => [ 'PatchRuleGroup$PatchRules' => '<p>The rules that make up the rule group.</p>', ], ], 'PatchSeverity' => [ 'base' => NULL, 'refs' => [ 'PatchComplianceData$Severity' => '<p>The severity of the patch (for example, Critical, Important, Moderate).</p>', ], ], 'PatchStatus' => [ 'base' => '<p>Information about the approval status of a patch.</p>', 'refs' => [ 'EffectivePatch$PatchStatus' => '<p>The status of the patch in a patch baseline. This includes information about whether the patch is currently approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the date the patch was or will be approved.</p>', ], ], 'PatchTitle' => [ 'base' => NULL, 'refs' => [ 'Patch$Title' => '<p>The title of the patch.</p>', 'PatchComplianceData$Title' => '<p>The title of the patch.</p>', ], ], 'PatchVendor' => [ 'base' => NULL, 'refs' => [ 'Patch$Vendor' => '<p>The name of the vendor providing the patch.</p>', ], ], 'PingStatus' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$PingStatus' => '<p>Connection status of the SSM Agent. </p>', ], ], 'PlatformType' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$PlatformType' => '<p>The operating system platform type. </p>', 'PlatformTypeList$member' => NULL, ], ], 'PlatformTypeList' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$PlatformTypes' => '<p>The list of OS platforms compatible with this SSM document. </p>', 'DocumentIdentifier$PlatformTypes' => '<p>The operating system platform. </p>', ], ], 'Product' => [ 'base' => NULL, 'refs' => [ 'GetDeployablePatchSnapshotForInstanceResult$Product' => '<p>Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the instance for the specified patch snapshot.</p>', ], ], 'PutComplianceItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutComplianceItemsResult' => [ 'base' => NULL, 'refs' => [], ], 'PutInventoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutInventoryResult' => [ 'base' => NULL, 'refs' => [], ], 'PutParameterRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutParameterResult' => [ 'base' => NULL, 'refs' => [], ], 'RegisterDefaultPatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterDefaultPatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'RegisterPatchBaselineForPatchGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterPatchBaselineForPatchGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTargetWithMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTargetWithMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTaskWithMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTaskWithMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'RegistrationLimit' => [ 'base' => NULL, 'refs' => [ 'Activation$RegistrationLimit' => '<p>The maximum number of managed instances that can be registered using this activation.</p>', 'CreateActivationRequest$RegistrationLimit' => '<p>Specify the maximum number of managed instances you want to register. The default value is 1 instance.</p>', ], ], 'RegistrationsCount' => [ 'base' => NULL, 'refs' => [ 'Activation$RegistrationsCount' => '<p>The number of managed instances already registered with this activation.</p>', ], ], 'RemoveTagsFromResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTagsFromResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'ResourceComplianceSummaryItem' => [ 'base' => '<p>Compliance summary information for a specific resource. </p>', 'refs' => [ 'ResourceComplianceSummaryItemList$member' => NULL, ], ], 'ResourceComplianceSummaryItemList' => [ 'base' => NULL, 'refs' => [ 'ListResourceComplianceSummariesResult$ResourceComplianceSummaryItems' => '<p>A summary count for specified or targeted managed instances. Summary count includes information about compliant and non-compliant State Manager associations, patch statuses, or custom items according to the filter criteria you specify. </p>', ], ], 'ResourceDataSyncAlreadyExistsException' => [ 'base' => '<p>A sync configuration with the same name already exists.</p>', 'refs' => [], ], 'ResourceDataSyncCountExceededException' => [ 'base' => '<p>You have exceeded the allowed maximum sync configurations.</p>', 'refs' => [], ], 'ResourceDataSyncCreatedTime' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$SyncCreatedTime' => '<p>The date and time the configuration was created (UTC).</p>', ], ], 'ResourceDataSyncInvalidConfigurationException' => [ 'base' => '<p>The specified sync configuration is invalid.</p>', 'refs' => [], ], 'ResourceDataSyncItem' => [ 'base' => '<p>Information about a Resource Data Sync configuration, including its current status and last successful sync.</p>', 'refs' => [ 'ResourceDataSyncItemList$member' => NULL, ], ], 'ResourceDataSyncItemList' => [ 'base' => NULL, 'refs' => [ 'ListResourceDataSyncResult$ResourceDataSyncItems' => '<p>A list of your current Resource Data Sync configurations and their statuses.</p>', ], ], 'ResourceDataSyncName' => [ 'base' => NULL, 'refs' => [ 'CreateResourceDataSyncRequest$SyncName' => '<p>A name for the configuration.</p>', 'DeleteResourceDataSyncRequest$SyncName' => '<p>The name of the configuration to delete.</p>', 'ResourceDataSyncAlreadyExistsException$SyncName' => NULL, 'ResourceDataSyncItem$SyncName' => '<p>The name of the Resource Data Sync.</p>', 'ResourceDataSyncNotFoundException$SyncName' => NULL, ], ], 'ResourceDataSyncNotFoundException' => [ 'base' => '<p>The specified sync name was not found.</p>', 'refs' => [], ], 'ResourceDataSyncS3BucketName' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$BucketName' => '<p>The name of the Amazon S3 bucket where the aggregated data is stored.</p>', ], ], 'ResourceDataSyncS3Destination' => [ 'base' => '<p>Information about the target Amazon S3 bucket for the Resource Data Sync.</p>', 'refs' => [ 'CreateResourceDataSyncRequest$S3Destination' => '<p>Amazon S3 configuration details for the sync.</p>', 'ResourceDataSyncItem$S3Destination' => '<p>Configuration information for the target Amazon S3 bucket.</p>', ], ], 'ResourceDataSyncS3Format' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$SyncFormat' => '<p>A supported sync format. The following format is currently supported: JsonSerDe</p>', ], ], 'ResourceDataSyncS3Prefix' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$Prefix' => '<p>An Amazon S3 prefix for the bucket.</p>', ], ], 'ResourceDataSyncS3Region' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$Region' => '<p>The AWS Region with the Amazon S3 bucket targeted by the Resource Data Sync.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceRequest$ResourceId' => '<p>The resource ID you want to tag.</p>', 'ListTagsForResourceRequest$ResourceId' => '<p>The resource ID for which you want to see a list of tags.</p>', 'RemoveTagsFromResourceRequest$ResourceId' => '<p>The resource ID for which you want to remove tags.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>Error returned if an attempt is made to delete a patch baseline that is registered for a patch group.</p>', 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>Error returned when the caller has exceeded the default resource limits (e.g. too many Maintenance Windows have been created).</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$ResourceType' => '<p>The type of instance. Instances are either EC2 instances or managed instances. </p>', ], ], 'ResourceTypeForTagging' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceRequest$ResourceType' => '<p>Specifies the type of resource you are tagging.</p>', 'ListTagsForResourceRequest$ResourceType' => '<p>Returns a list of tags for a specific resource type.</p>', 'RemoveTagsFromResourceRequest$ResourceType' => '<p>The type of resource of which you want to remove a tag.</p>', ], ], 'ResponseCode' => [ 'base' => NULL, 'refs' => [ 'CommandPlugin$ResponseCode' => '<p>A numeric response code generated after executing the plugin. </p>', 'GetCommandInvocationResult$ResponseCode' => '<p>The error level response code for the plugin script. If the response code is -1, then the command has not started executing on the instance, or it was not received by the instance.</p>', ], ], 'ResultAttribute' => [ 'base' => '<p>The inventory item result attribute.</p>', 'refs' => [ 'ResultAttributeList$member' => NULL, ], ], 'ResultAttributeList' => [ 'base' => NULL, 'refs' => [ 'GetInventoryRequest$ResultAttributes' => '<p>The list of inventory item types to return.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'Command$OutputS3BucketName' => '<p>The S3 bucket where the responses to the command executions should be stored. This was requested when issuing the command.</p>', 'CommandPlugin$OutputS3BucketName' => '<p>The S3 bucket where the responses to the command executions should be stored. This was requested when issuing the command. For example, in the following response:</p> <p> test_folder/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-1234567876543/awsrunShellScript </p> <p>test_folder is the name of the Amazon S3 bucket;</p> <p> ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix is the name of the S3 prefix;</p> <p>i-1234567876543 is the instance ID;</p> <p>awsrunShellScript is the name of the plugin.</p>', 'LoggingInfo$S3BucketName' => '<p>The name of an Amazon S3 bucket where execution logs are stored .</p>', 'MaintenanceWindowRunCommandParameters$OutputS3BucketName' => '<p>The name of the Amazon S3 bucket.</p>', 'S3OutputLocation$OutputS3BucketName' => '<p>The name of the Amazon S3 bucket.</p>', 'SendCommandRequest$OutputS3BucketName' => '<p>The name of the S3 bucket where command execution responses should be stored.</p>', ], ], 'S3KeyPrefix' => [ 'base' => NULL, 'refs' => [ 'Command$OutputS3KeyPrefix' => '<p>The S3 directory path inside the bucket where the responses to the command executions should be stored. This was requested when issuing the command.</p>', 'CommandPlugin$OutputS3KeyPrefix' => '<p>The S3 directory path inside the bucket where the responses to the command executions should be stored. This was requested when issuing the command. For example, in the following response:</p> <p> test_folder/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-1234567876543/awsrunShellScript </p> <p>test_folder is the name of the Amazon S3 bucket;</p> <p> ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix is the name of the S3 prefix;</p> <p>i-1234567876543 is the instance ID;</p> <p>awsrunShellScript is the name of the plugin.</p>', 'LoggingInfo$S3KeyPrefix' => '<p>(Optional) The Amazon S3 bucket subfolder. </p>', 'MaintenanceWindowRunCommandParameters$OutputS3KeyPrefix' => '<p>The Amazon S3 bucket subfolder.</p>', 'S3OutputLocation$OutputS3KeyPrefix' => '<p>The Amazon S3 bucket subfolder.</p>', 'SendCommandRequest$OutputS3KeyPrefix' => '<p>The directory structure within the S3 bucket where the responses should be stored.</p>', ], ], 'S3OutputLocation' => [ 'base' => '<p>An Amazon S3 bucket where you want to store the results of this request.</p>', 'refs' => [ 'InstanceAssociationOutputLocation$S3Location' => '<p>An Amazon S3 bucket where you want to store the results of this request.</p>', ], ], 'S3OutputUrl' => [ 'base' => '<p>A URL for the Amazon S3 bucket where you want to store the results of this request.</p>', 'refs' => [ 'InstanceAssociationOutputUrl$S3OutputUrl' => '<p>The URL of Amazon S3 bucket where you want to store the results of this request.</p>', ], ], 'S3Region' => [ 'base' => NULL, 'refs' => [ 'Command$OutputS3Region' => '<p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Amazon S3 bucket region.</p>', 'CommandPlugin$OutputS3Region' => '<p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Amazon S3 bucket region.</p>', 'LoggingInfo$S3Region' => '<p>The region where the Amazon S3 bucket is located.</p>', 'S3OutputLocation$OutputS3Region' => '<p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Amazon S3 bucket region.</p>', 'SendCommandRequest$OutputS3Region' => '<p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Amazon S3 bucket region.</p>', ], ], 'ScheduleExpression' => [ 'base' => NULL, 'refs' => [ 'Association$ScheduleExpression' => '<p>A cron expression that specifies a schedule when the association runs.</p>', 'AssociationDescription$ScheduleExpression' => '<p>A cron expression that specifies a schedule when the association runs.</p>', 'CreateAssociationBatchRequestEntry$ScheduleExpression' => '<p>A cron expression that specifies a schedule when the association runs.</p>', 'CreateAssociationRequest$ScheduleExpression' => '<p>A cron expression when the association will be applied to the target(s).</p>', 'UpdateAssociationRequest$ScheduleExpression' => '<p>The cron expression used to schedule the association that you want to update.</p>', ], ], 'SendAutomationSignalRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendAutomationSignalResult' => [ 'base' => NULL, 'refs' => [], ], 'SendCommandRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendCommandResult' => [ 'base' => NULL, 'refs' => [], ], 'ServiceRole' => [ 'base' => NULL, 'refs' => [ 'Command$ServiceRole' => '<p>The IAM service role that Run Command uses to act on your behalf when sending notifications about command status changes. </p>', 'CommandInvocation$ServiceRole' => '<p>The IAM service role that Run Command uses to act on your behalf when sending notifications about command status changes on a per instance basis.</p>', 'GetMaintenanceWindowExecutionTaskResult$ServiceRole' => '<p>The role that was assumed when executing the task.</p>', 'GetMaintenanceWindowTaskResult$ServiceRoleArn' => '<p>The IAM service role to assume during task execution.</p>', 'MaintenanceWindowRunCommandParameters$ServiceRoleArn' => '<p>The IAM service role that to assume during task execution.</p>', 'MaintenanceWindowTask$ServiceRoleArn' => '<p>The role that should be assumed when executing the task</p>', 'RegisterTaskWithMaintenanceWindowRequest$ServiceRoleArn' => '<p>The role that should be assumed when executing the task.</p>', 'SendCommandRequest$ServiceRoleArn' => '<p>The IAM role that Systems Manager uses to send notifications. </p>', 'UpdateMaintenanceWindowTaskRequest$ServiceRoleArn' => '<p>The IAM service role ARN that you want to modify. The system assumes this role during task exectuion. </p>', 'UpdateMaintenanceWindowTaskResult$ServiceRoleArn' => '<p>The updated service role ARN value.</p>', ], ], 'SeveritySummary' => [ 'base' => '<p>The number of managed instances found for each patch severity level defined in the request filter.</p>', 'refs' => [ 'CompliantSummary$SeveritySummary' => '<p>A summary of the compliance severity by compliance type.</p>', 'NonCompliantSummary$SeveritySummary' => '<p>A summary of the non-compliance severity by compliance type</p>', ], ], 'SignalType' => [ 'base' => NULL, 'refs' => [ 'SendAutomationSignalRequest$SignalType' => '<p>The type of signal. Valid signal types include the following: Approve and Reject </p>', ], ], 'SnapshotDownloadUrl' => [ 'base' => NULL, 'refs' => [ 'GetDeployablePatchSnapshotForInstanceResult$SnapshotDownloadUrl' => '<p>A pre-signed Amazon S3 URL that can be used to download the patch snapshot.</p>', ], ], 'SnapshotId' => [ 'base' => NULL, 'refs' => [ 'GetDeployablePatchSnapshotForInstanceRequest$SnapshotId' => '<p>The user-defined snapshot ID.</p>', 'GetDeployablePatchSnapshotForInstanceResult$SnapshotId' => '<p>The user-defined snapshot ID.</p>', 'InstancePatchState$SnapshotId' => '<p>The ID of the patch baseline snapshot used during the patching operation when this compliance data was collected.</p>', ], ], 'StandardErrorContent' => [ 'base' => NULL, 'refs' => [ 'GetCommandInvocationResult$StandardErrorContent' => '<p>The first 8,000 characters written by the plugin to stderr. If the command has not finished executing, then this string is empty.</p>', ], ], 'StandardOutputContent' => [ 'base' => NULL, 'refs' => [ 'GetCommandInvocationResult$StandardOutputContent' => '<p>The first 24,000 characters written by the plugin to stdout. If the command has not finished executing, if ExecutionStatus is neither Succeeded nor Failed, then this string is empty.</p>', ], ], 'StartAutomationExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAutomationExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'StatusAdditionalInfo' => [ 'base' => NULL, 'refs' => [ 'AssociationStatus$AdditionalInfo' => '<p>A user-defined string.</p>', ], ], 'StatusDetails' => [ 'base' => NULL, 'refs' => [ 'Command$StatusDetails' => '<p>A detailed status of the command execution. StatusDetails includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-about-status.html">Run Command Status</a>. StatusDetails can be one of the following values:</p> <ul> <li> <p>Pending: The command has not been sent to any instances.</p> </li> <li> <p>In Progress: The command has been sent to at least one instance but has not reached a final state on all instances.</p> </li> <li> <p>Success: The command successfully executed on all invocations. This is a terminal state.</p> </li> <li> <p>Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of Delivery Timed Out. This is a terminal state.</p> </li> <li> <p>Execution Timed Out: The value of MaxErrors or more command invocations shows a status of Execution Timed Out. This is a terminal state.</p> </li> <li> <p>Failed: The value of MaxErrors or more command invocations shows a status of Failed. This is a terminal state.</p> </li> <li> <p>Incomplete: The command was attempted on all instances and one or more invocations does not have a value of Success but not enough invocations failed for the status to be Failed. This is a terminal state.</p> </li> <li> <p>Canceled: The command was terminated before it was completed. This is a terminal state.</p> </li> <li> <p>Rate Exceeded: The number of instances targeted by the command exceeded the account limit for pending invocations. The system has canceled the command before executing it on any instance. This is a terminal state.</p> </li> </ul>', 'CommandInvocation$StatusDetails' => '<p>A detailed status of the command execution for each invocation (each instance targeted by the command). StatusDetails includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-about-status.html">Run Command Status</a>. StatusDetails can be one of the following values:</p> <ul> <li> <p>Pending: The command has not been sent to the instance.</p> </li> <li> <p>In Progress: The command has been sent to the instance but has not reached a terminal state.</p> </li> <li> <p>Success: The execution of the command or plugin was successfully completed. This is a terminal state.</p> </li> <li> <p>Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired. Delivery timeouts do not count against the parent command\'s MaxErrors limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Execution Timed Out: Command execution started on the instance, but the execution was not complete before the execution timeout expired. Execution timeouts count against the MaxErrors limit of the parent command. This is a terminal state.</p> </li> <li> <p>Failed: The command was not successful on the instance. For a plugin, this indicates that the result code was not zero. For a command invocation, this indicates that the result code for one or more plugins was not zero. Invocation failures count against the MaxErrors limit of the parent command. This is a terminal state.</p> </li> <li> <p>Canceled: The command was terminated before it was completed. This is a terminal state.</p> </li> <li> <p>Undeliverable: The command can\'t be delivered to the instance. The instance might not exist or might not be responding. Undeliverable invocations don\'t count against the parent command\'s MaxErrors limit and don\'t contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li> </ul>', 'CommandPlugin$StatusDetails' => '<p>A detailed status of the plugin execution. StatusDetails includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-about-status.html">Run Command Status</a>. StatusDetails can be one of the following values:</p> <ul> <li> <p>Pending: The command has not been sent to the instance.</p> </li> <li> <p>In Progress: The command has been sent to the instance but has not reached a terminal state.</p> </li> <li> <p>Success: The execution of the command or plugin was successfully completed. This is a terminal state.</p> </li> <li> <p>Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired. Delivery timeouts do not count against the parent command\'s MaxErrors limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Execution Timed Out: Command execution started on the instance, but the execution was not complete before the execution timeout expired. Execution timeouts count against the MaxErrors limit of the parent command. This is a terminal state.</p> </li> <li> <p>Failed: The command was not successful on the instance. For a plugin, this indicates that the result code was not zero. For a command invocation, this indicates that the result code for one or more plugins was not zero. Invocation failures count against the MaxErrors limit of the parent command. This is a terminal state.</p> </li> <li> <p>Canceled: The command was terminated before it was completed. This is a terminal state.</p> </li> <li> <p>Undeliverable: The command can\'t be delivered to the instance. The instance might not exist, or it might not be responding. Undeliverable invocations don\'t count against the parent command\'s MaxErrors limit, and they don\'t contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li> </ul>', 'GetCommandInvocationResult$StatusDetails' => '<p>A detailed status of the command execution for an invocation. StatusDetails includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-about-status.html">Run Command Status</a>. StatusDetails can be one of the following values:</p> <ul> <li> <p>Pending: The command has not been sent to the instance.</p> </li> <li> <p>In Progress: The command has been sent to the instance but has not reached a terminal state.</p> </li> <li> <p>Delayed: The system attempted to send the command to the target, but the target was not available. The instance might not be available because of network issues, the instance was stopped, etc. The system will try to deliver the command again.</p> </li> <li> <p>Success: The command or plugin was executed successfully. This is a terminal state.</p> </li> <li> <p>Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired. Delivery timeouts do not count against the parent command\'s MaxErrors limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Execution Timed Out: The command started to execute on the instance, but the execution was not complete before the timeout expired. Execution timeouts count against the MaxErrors limit of the parent command. This is a terminal state.</p> </li> <li> <p>Failed: The command wasn\'t executed successfully on the instance. For a plugin, this indicates that the result code was not zero. For a command invocation, this indicates that the result code for one or more plugins was not zero. Invocation failures count against the MaxErrors limit of the parent command. This is a terminal state.</p> </li> <li> <p>Canceled: The command was terminated before it was completed. This is a terminal state.</p> </li> <li> <p>Undeliverable: The command can\'t be delivered to the instance. The instance might not exist or might not be responding. Undeliverable invocations don\'t count against the parent command\'s MaxErrors limit and don\'t contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li> </ul>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'AssociationStatus$Message' => '<p>The reason for the status.</p>', ], ], 'StatusName' => [ 'base' => NULL, 'refs' => [ 'AssociationOverview$Status' => '<p>The status of the association. Status can be: Pending, Success, or Failed.</p>', 'AssociationOverview$DetailedStatus' => '<p>A detailed status of the association.</p>', 'AssociationStatusAggregatedCount$key' => NULL, 'InstanceAggregatedAssociationOverview$DetailedStatus' => '<p>Detailed status information about the aggregated associations.</p>', 'InstanceAssociationStatusAggregatedCount$key' => NULL, 'InstanceAssociationStatusInfo$Status' => '<p>Status information about the instance association.</p>', 'InstanceAssociationStatusInfo$DetailedStatus' => '<p>Detailed status information about the instance association.</p>', 'InstanceInformation$AssociationStatus' => '<p>The status of the association.</p>', ], ], 'StatusUnchanged' => [ 'base' => '<p>The updated status is the same as the current status.</p>', 'refs' => [], ], 'StepExecution' => [ 'base' => '<p>Detailed information about an the execution state of an Automation step.</p>', 'refs' => [ 'StepExecutionList$member' => NULL, ], ], 'StepExecutionList' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$StepExecutions' => '<p>A list of details about the current state of all steps that comprise an execution. An Automation document contains a list of steps that are executed in order.</p>', ], ], 'StopAutomationExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopAutomationExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AlreadyExistsException$Message' => NULL, 'AssociationDoesNotExist$Message' => NULL, 'AutomationDefinitionNotFoundException$Message' => NULL, 'AutomationDefinitionVersionNotFoundException$Message' => NULL, 'AutomationExecution$FailureMessage' => '<p>A message describing why an execution has failed, if the status is set to Failed.</p>', 'AutomationExecutionLimitExceededException$Message' => NULL, 'AutomationExecutionMetadata$ExecutedBy' => '<p>The IAM role ARN of the user who executed the Automation.</p>', 'AutomationExecutionMetadata$LogFile' => '<p>An Amazon S3 bucket where execution information is stored.</p>', 'AutomationExecutionNotFoundException$Message' => NULL, 'ComplianceTypeCountLimitExceededException$Message' => NULL, 'CustomSchemaCountLimitExceededException$Message' => NULL, 'DocumentAlreadyExists$Message' => NULL, 'DocumentLimitExceeded$Message' => NULL, 'DocumentPermissionLimit$Message' => NULL, 'DocumentVersionLimitExceeded$Message' => NULL, 'DoesNotExistException$Message' => NULL, 'DuplicateDocumentContent$Message' => NULL, 'FailureDetails$FailureStage' => '<p>The stage of the Automation execution when the failure occurred. The stages include the following: InputValidation, PreVerification, Invocation, PostVerification.</p>', 'FailureDetails$FailureType' => '<p>The type of Automation failure. Failure types include the following: Action, Permission, Throttling, Verification, Internal.</p>', 'FeatureNotAvailableException$Message' => NULL, 'HierarchyLevelLimitExceededException$message' => '<p>A hierarchy can have a maximum of five levels. For example:</p> <p>/Finance/Prod/IAD/OS/WinServ2016/license15</p> <p>For more information, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-working.html">Working with Systems Manager Parameters</a>. </p>', 'HierarchyTypeMismatchException$message' => '<p>Parameter Store does not support changing a parameter type in a hierarchy. For example, you can\'t change a parameter from a String type to a SecureString type. You must create a new, unique parameter.</p>', 'IdempotentParameterMismatch$Message' => NULL, 'InstanceInformation$PlatformName' => '<p>The name of the operating system platform running on your instance. </p>', 'InstanceInformation$PlatformVersion' => '<p>The version of the OS platform running on your instance. </p>', 'InstanceInformation$Name' => '<p>The name of the managed instance.</p>', 'InternalServerError$Message' => NULL, 'InvalidActivation$Message' => NULL, 'InvalidActivationId$Message' => NULL, 'InvalidAllowedPatternException$message' => '<p>The request does not meet the regular expression requirement.</p>', 'InvalidAutomationExecutionParametersException$Message' => NULL, 'InvalidAutomationSignalException$Message' => NULL, 'InvalidDocument$Message' => '<p>The document does not exist or the document is not available to the user. This exception can be issued by CreateAssociation, CreateAssociationBatch, DeleteAssociation, DeleteDocument, DescribeAssociation, DescribeDocument, GetDocument, SendCommand, or UpdateAssociationStatus. </p>', 'InvalidDocumentContent$Message' => '<p>A description of the validation error.</p>', 'InvalidDocumentOperation$Message' => NULL, 'InvalidDocumentSchemaVersion$Message' => NULL, 'InvalidDocumentVersion$Message' => NULL, 'InvalidFilter$Message' => NULL, 'InvalidFilterOption$message' => '<p>The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid options are Recursive and OneLevel.</p>', 'InvalidFilterValue$Message' => NULL, 'InvalidInstanceId$Message' => NULL, 'InvalidInstanceInformationFilterValue$message' => NULL, 'InvalidInventoryItemContextException$Message' => NULL, 'InvalidItemContentException$Message' => NULL, 'InvalidKeyId$message' => NULL, 'InvalidNextToken$Message' => NULL, 'InvalidNotificationConfig$Message' => NULL, 'InvalidParameters$Message' => NULL, 'InvalidPermissionType$Message' => NULL, 'InvalidResultAttributeException$Message' => NULL, 'InvalidRole$Message' => NULL, 'InvalidSchedule$Message' => NULL, 'InvalidTarget$Message' => NULL, 'InvalidTypeNameException$Message' => NULL, 'InvalidUpdate$Message' => NULL, 'ItemContentMismatchException$Message' => NULL, 'ItemSizeLimitExceededException$Message' => NULL, 'MaxDocumentSizeExceeded$Message' => NULL, 'NormalStringMap$key' => NULL, 'NormalStringMap$value' => NULL, 'ParameterAlreadyExists$message' => NULL, 'ParameterHistory$LastModifiedUser' => '<p>Amazon Resource Name (ARN) of the AWS user who last changed the parameter.</p>', 'ParameterLimitExceeded$message' => NULL, 'ParameterMetadata$LastModifiedUser' => '<p>Amazon Resource Name (ARN) of the AWS user who last changed the parameter.</p>', 'ParameterNotFound$message' => NULL, 'ParameterPatternMismatchException$message' => '<p>The parameter name is not valid.</p>', 'ResourceDataSyncCountExceededException$Message' => NULL, 'ResourceDataSyncInvalidConfigurationException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceLimitExceededException$Message' => NULL, 'StepExecution$StepName' => '<p>The name of this execution step.</p>', 'StepExecution$ResponseCode' => '<p>The response code returned by the execution of the step.</p>', 'StepExecution$Response' => '<p>A message associated with the response code for an execution.</p>', 'StepExecution$FailureMessage' => '<p>If a step failed, this message explains why the execution failed.</p>', 'StringList$member' => NULL, 'SubTypeCountLimitExceededException$Message' => NULL, 'TargetInUseException$Message' => NULL, 'TooManyUpdates$Message' => NULL, 'TotalSizeLimitExceededException$Message' => NULL, 'UnsupportedInventoryItemContextException$Message' => NULL, 'UnsupportedInventorySchemaVersionException$Message' => NULL, 'UnsupportedOperatingSystem$Message' => NULL, 'UnsupportedParameterType$message' => NULL, 'UnsupportedPlatformType$Message' => NULL, ], ], 'StringDateTime' => [ 'base' => NULL, 'refs' => [ 'GetCommandInvocationResult$ExecutionStartDateTime' => '<p>The date and time the plugin started executing. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the <code>InvokedBefore</code> filter.</p> <p> <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code> </p> <p>If the plugin has not started to execute, the string is empty.</p>', 'GetCommandInvocationResult$ExecutionElapsedTime' => '<p>Duration since ExecutionStartDateTime.</p>', 'GetCommandInvocationResult$ExecutionEndDateTime' => '<p>The date and time the plugin was finished executing. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the <code>InvokedAfter</code> filter.</p> <p> <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code> </p> <p>If the plugin has not started to execute, the string is empty.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsFilter$FilterValues' => '<p>The filter values.</p>', ], ], 'SubTypeCountLimitExceededException' => [ 'base' => '<p>The sub-type count exceeded the limit for the inventory type.</p>', 'refs' => [], ], 'Tag' => [ 'base' => '<p>Metadata that you assign to your managed instances. Tags enable you to categorize your managed instances in different ways, for example, by purpose, owner, or environment.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'KeyList$member' => NULL, 'Tag$Key' => '<p>The name of the tag.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceRequest$Tags' => '<p> One or more tags. The value parameter is required, but if you don\'t want the tag to have a value, specify the parameter with no value, and we set the value to an empty string. </p>', 'ListTagsForResourceResult$TagList' => '<p>A list of tags.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'Target' => [ 'base' => '<p>An array of search criteria that targets instances using a Key,Value combination that you specify. <code>Targets</code> is required if you don\'t provide one or more instance IDs in the call.</p> <p/>', 'refs' => [ 'Targets$member' => NULL, ], ], 'TargetCount' => [ 'base' => NULL, 'refs' => [ 'Command$TargetCount' => '<p>The number of targets for the command.</p>', ], ], 'TargetInUseException' => [ 'base' => '<p>You specified the <code>Safe</code> option for the DeregisterTargetFromMaintenanceWindow operation, but the target is still referenced in a task.</p>', 'refs' => [], ], 'TargetKey' => [ 'base' => NULL, 'refs' => [ 'Target$Key' => '<p>User-defined criteria for sending commands that target instances that meet the criteria. Key can be tag:&lt;Amazon EC2 tag&gt; or InstanceIds. For more information about how to send commands that target instances using Key,Value parameters, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Executing a Command Using Systems Manager Run Command</a>.</p>', ], ], 'TargetValue' => [ 'base' => NULL, 'refs' => [ 'TargetValues$member' => NULL, ], ], 'TargetValues' => [ 'base' => NULL, 'refs' => [ 'Target$Values' => '<p>User-defined criteria that maps to Key. For example, if you specified tag:ServerRole, you could specify value:WebServer to execute a command on instances that include Amazon EC2 tags of ServerRole,WebServer. For more information about how to send commands that target instances using Key,Value parameters, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Executing a Command Using Systems Manager Run Command</a>.</p>', ], ], 'Targets' => [ 'base' => NULL, 'refs' => [ 'Association$Targets' => '<p>The instances targeted by the request to create an association. </p>', 'AssociationDescription$Targets' => '<p>The instances targeted by the request. </p>', 'Command$Targets' => '<p>An array of search criteria that targets instances using a Key,Value combination that you specify. Targets is required if you don\'t provide one or more instance IDs in the call.</p>', 'CreateAssociationBatchRequestEntry$Targets' => '<p>The instances targeted by the request.</p>', 'CreateAssociationRequest$Targets' => '<p>The targets (either instances or tags) for the association.</p>', 'GetMaintenanceWindowTaskResult$Targets' => '<p>The targets where the task should execute.</p>', 'MaintenanceWindowTarget$Targets' => '<p>The targets (either instances or tags). Instances are specified using Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag name&gt;,Values=&lt;tag value&gt;.</p>', 'MaintenanceWindowTask$Targets' => '<p>The targets (either instances or tags). Instances are specified using Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag name&gt;,Values=&lt;tag value&gt;.</p>', 'RegisterTargetWithMaintenanceWindowRequest$Targets' => '<p>The targets (either instances or tags). Instances are specified using Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag name&gt;,Values=&lt;tag value&gt;.</p>', 'RegisterTaskWithMaintenanceWindowRequest$Targets' => '<p>The targets (either instances or tags). Instances are specified using Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag name&gt;,Values=&lt;tag value&gt;.</p>', 'SendCommandRequest$Targets' => '<p>(Optional) An array of search criteria that targets instances using a Key,Value combination that you specify. Targets is required if you don\'t provide one or more instance IDs in the call. For more information about how to use Targets, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending Commands to a Fleet</a>.</p>', 'UpdateAssociationRequest$Targets' => '<p>The targets of the association.</p>', 'UpdateMaintenanceWindowTargetRequest$Targets' => '<p>The targets that you want to add or replace.</p>', 'UpdateMaintenanceWindowTargetResult$Targets' => '<p>The updated targets.</p>', 'UpdateMaintenanceWindowTaskRequest$Targets' => '<p>The targets (either instances or tags) that you want to modify. Instances are specified using Key=instanceids,Values=instanceID_1,instanceID_2. Tags are specified using Key=tag_name,Values=tag_value. </p>', 'UpdateMaintenanceWindowTaskResult$Targets' => '<p>The updated target values.</p>', ], ], 'TimeoutSeconds' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowRunCommandParameters$TimeoutSeconds' => '<p>If this time is reached and the command has not already started executing, it will not execute.</p>', 'SendCommandRequest$TimeoutSeconds' => '<p>If this time is reached and the command has not already started executing, it will not execute.</p>', ], ], 'TooManyTagsError' => [ 'base' => '<p>The Targets parameter includes too many tags. Remove one or more tags and try the command again.</p>', 'refs' => [], ], 'TooManyUpdates' => [ 'base' => '<p>There are concurrent updates for a resource that supports one update at a time.</p>', 'refs' => [], ], 'TotalSizeLimitExceededException' => [ 'base' => '<p>The size of inventory data has exceeded the total size limit for the resource.</p>', 'refs' => [], ], 'UnsupportedInventoryItemContextException' => [ 'base' => '<p>The <code>Context</code> attribute you specified for the <code>InventoryItem</code> is not allowed for this inventory type. You can only use the <code>Context</code> attribute with inventory types like <code>AWS:ComplianceItem</code>.</p>', 'refs' => [], ], 'UnsupportedInventorySchemaVersionException' => [ 'base' => '<p>Inventory item type schema version has to match supported versions in the service. Check output of GetInventorySchema to see the available schema version for each type.</p>', 'refs' => [], ], 'UnsupportedOperatingSystem' => [ 'base' => '<p>The operating systems you specified is not supported, or the operation is not supported for the operating system. Valid operating systems include: Windows, AmazonLinux, RedhatEnterpriseLinux, and Ubuntu.</p>', 'refs' => [], ], 'UnsupportedParameterType' => [ 'base' => '<p>The parameter type is not supported.</p>', 'refs' => [], ], 'UnsupportedPlatformType' => [ 'base' => '<p>The document does not support the platform type of the given instance ID(s). For example, you sent an document for a Windows instance to a Linux instance.</p>', 'refs' => [], ], 'UpdateAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssociationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssociationStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentDefaultVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentDefaultVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowTargetResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateManagedInstanceRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateManagedInstanceRoleResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$StandardOutputUrl' => '<p>The URL to the plugin\'s StdOut file in Amazon S3, if the Amazon S3 bucket was defined for the parent command. For an invocation, StandardOutputUrl is populated if there is just one plugin defined for the command, and the Amazon S3 bucket was defined for the command.</p>', 'CommandInvocation$StandardErrorUrl' => '<p>The URL to the plugin\'s StdErr file in Amazon S3, if the Amazon S3 bucket was defined for the parent command. For an invocation, StandardErrorUrl is populated if there is just one plugin defined for the command, and the Amazon S3 bucket was defined for the command.</p>', 'CommandPlugin$StandardOutputUrl' => '<p>The URL for the complete text written by the plugin to stdout in Amazon S3. If the Amazon S3 bucket for the command was not specified, then this string is empty.</p>', 'CommandPlugin$StandardErrorUrl' => '<p>The URL for the complete text written by the plugin to stderr. If execution is not yet complete, then this string is empty.</p>', 'GetCommandInvocationResult$StandardOutputUrl' => '<p>The URL for the complete text written by the plugin to stdout in Amazon S3. If an Amazon S3 bucket was not specified, then this string is empty.</p>', 'GetCommandInvocationResult$StandardErrorUrl' => '<p>The URL for the complete text written by the plugin to stderr. If the command has not finished executing, then this string is empty.</p>', 'S3OutputUrl$OutputUrl' => '<p>A URL for an Amazon S3 bucket where you want to store the results of this request.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$AgentVersion' => '<p>The version of the SSM Agent running on your Linux instance. </p>', ], ], ],];
