<?php
// This file was auto-generated from sdk-root/src/data/states/2016-11-23/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Step Functions</fullname> <p>AWS Step Functions is a web service that enables you to coordinate the components of distributed applications and microservices using visual workflows. You build applications from individual components that each perform a discrete function, or <i>task</i>, allowing you to scale and change applications quickly. Step Functions provides a graphical console to visualize the components of your application as a series of steps. It automatically triggers and tracks each step, and retries when there are errors, so your application executes in order and as expected, every time. Step Functions logs the state of each step, so when things do go wrong, you can diagnose and debug problems quickly.</p> <p>Step Functions manages the operations and underlying infrastructure for you to ensure your application is available at any scale. You can run tasks on the AWS cloud, on your own servers, or an any system that has access to AWS. Step Functions can be accessed and used with the Step Functions console, the AWS SDKs (included with your Beta release invitation email), or an HTTP API (the subject of this document).</p>', 'operations' => [ 'CreateActivity' => '<p>Creates an activity.</p>', 'CreateStateMachine' => '<p>Creates a state machine.</p>', 'DeleteActivity' => '<p>Deletes an activity.</p>', 'DeleteStateMachine' => '<p>Deletes a state machine. This is an asynchronous operation-- it sets the state machine\'s status to "DELETING" and begins the delete process.</p>', 'DescribeActivity' => '<p>Describes an activity.</p>', 'DescribeExecution' => '<p>Describes an execution.</p>', 'DescribeStateMachine' => '<p>Describes a state machine.</p>', 'GetActivityTask' => '<p>Used by workers to retrieve a task (with the specified activity ARN) scheduled for execution by a running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll will return an empty result, that is, the <code>taskToken</code> returned is an empty string.</p> <important> <p>Workers should set their client side socket timeout to at least 65 seconds (5 seconds higher than the maximum time the service may hold the poll request).</p> </important>', 'GetExecutionHistory' => '<p>Returns the history of the specified execution as a list of events. By default, the results are returned in ascending order of the <code>timeStamp</code> of the events. Use the <code>reverseOrder</code> parameter to get the latest events first. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the <code>nextToken</code> returned by the previous call.</p>', 'ListActivities' => '<p>Lists the existing activities. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the <code>nextToken</code> returned by the previous call.</p>', 'ListExecutions' => '<p>Lists the executions of a state machine that meet the filtering criteria. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the <code>nextToken</code> returned by the previous call.</p>', 'ListStateMachines' => '<p>Lists the existing state machines. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the <code>nextToken</code> returned by the previous call.</p>', 'SendTaskFailure' => '<p>Used by workers to report that the task identified by the <code>taskToken</code> failed.</p>', 'SendTaskHeartbeat' => '<p>Used by workers to report to the service that the task represented by the specified <code>taskToken</code> is still making progress. This action resets the <code>Heartbeat</code> clock. The <code>Heartbeat</code> threshold is specified in the state machine\'s Amazon States Language definition. This action does not in itself create an event in the execution history. However, if the task times out, the execution history will contain an <code>ActivityTimedOut</code> event.</p> <note> <p>The <code>Timeout</code> of a task, defined in the state machine\'s Amazon States Language definition, is its maximum allowed duration, regardless of the number of <a>SendTaskHeartbeat</a> requests received.</p> </note> <note> <p>This operation is only useful for long-lived tasks to report the liveliness of the task.</p> </note>', 'SendTaskSuccess' => '<p>Used by workers to report that the task identified by the <code>taskToken</code> completed successfully.</p>', 'StartExecution' => '<p>Starts a state machine execution.</p>', 'StopExecution' => '<p>Stops an execution.</p>', ], 'shapes' => [ 'ActivityDoesNotExist' => [ 'base' => '<p>The specified activity does not exist.</p>', 'refs' => [], ], 'ActivityFailedEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$activityFailedEventDetails' => NULL, ], ], 'ActivityLimitExceeded' => [ 'base' => '<p>The maximum number of activities has been reached. Existing activities must be deleted before a new activity can be created.</p>', 'refs' => [], ], 'ActivityList' => [ 'base' => NULL, 'refs' => [ 'ListActivitiesOutput$activities' => '<p>The list of activities.</p>', ], ], 'ActivityListItem' => [ 'base' => NULL, 'refs' => [ 'ActivityList$member' => NULL, ], ], 'ActivityScheduleFailedEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$activityScheduleFailedEventDetails' => NULL, ], ], 'ActivityScheduledEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$activityScheduledEventDetails' => NULL, ], ], 'ActivityStartedEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$activityStartedEventDetails' => NULL, ], ], 'ActivitySucceededEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$activitySucceededEventDetails' => NULL, ], ], 'ActivityTimedOutEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$activityTimedOutEventDetails' => NULL, ], ], 'ActivityWorkerLimitExceeded' => [ 'base' => '<p>The maximum number of workers concurrently polling for activity tasks has been reached.</p>', 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ActivityListItem$activityArn' => '<p>The Amazon Resource Name (ARN) that identifies the activity.</p>', 'ActivityScheduledEventDetails$resource' => '<p>The Amazon Resource Name (ARN) of the scheduled activity.</p>', 'CreateActivityOutput$activityArn' => '<p>The Amazon Resource Name (ARN) that identifies the created activity.</p>', 'CreateStateMachineInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to use for this state machine.</p>', 'CreateStateMachineOutput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) that identifies the created state machine.</p>', 'DeleteActivityInput$activityArn' => '<p>The Amazon Resource Name (ARN) of the activity to delete.</p>', 'DeleteStateMachineInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine to delete.</p>', 'DescribeActivityInput$activityArn' => '<p>The Amazon Resource Name (ARN) of the activity to describe.</p>', 'DescribeActivityOutput$activityArn' => '<p>The Amazon Resource Name (ARN) that identifies the activity.</p>', 'DescribeExecutionInput$executionArn' => '<p>The Amazon Resource Name (ARN) of the execution to describe.</p>', 'DescribeExecutionOutput$executionArn' => '<p>The Amazon Resource Name (ARN) that identifies the execution.</p>', 'DescribeExecutionOutput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the executed stated machine.</p>', 'DescribeStateMachineInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine to describe.</p>', 'DescribeStateMachineOutput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) that identifies the state machine.</p>', 'DescribeStateMachineOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used for executing this state machine.</p>', 'ExecutionListItem$executionArn' => '<p>The Amazon Resource Name (ARN) that identifies the execution.</p>', 'ExecutionListItem$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the executed state machine.</p>', 'ExecutionStartedEventDetails$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used for executing AWS Lambda tasks.</p>', 'GetActivityTaskInput$activityArn' => '<p>The Amazon Resource Name (ARN) of the activity to retrieve tasks from.</p>', 'GetExecutionHistoryInput$executionArn' => '<p>The Amazon Resource Name (ARN) of the execution.</p>', 'LambdaFunctionScheduledEventDetails$resource' => '<p>The Amazon Resource Name (ARN) of the scheduled lambda function.</p>', 'ListExecutionsInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine whose executions will be listed.</p>', 'StartExecutionInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine to execute.</p>', 'StartExecutionOutput$executionArn' => '<p>The Amazon Resource Name (ARN) that identifies the execution.</p>', 'StateMachineListItem$stateMachineArn' => '<p>The Amazon Resource Name (ARN) that identifies the state machine.</p>', 'StopExecutionInput$executionArn' => '<p>The Amazon Resource Name (ARN) of the execution to stop.</p>', ], ], 'Cause' => [ 'base' => NULL, 'refs' => [ 'ActivityFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'ActivityScheduleFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'ActivityTimedOutEventDetails$cause' => '<p>A more detailed explanation of the cause of the timeout.</p>', 'ExecutionAbortedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'ExecutionFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'ExecutionTimedOutEventDetails$cause' => '<p>A more detailed explanation of the cause of the timeout.</p>', 'LambdaFunctionFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'LambdaFunctionScheduleFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'LambdaFunctionStartFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'LambdaFunctionTimedOutEventDetails$cause' => '<p>A more detailed explanation of the cause of the timeout.</p>', 'SendTaskFailureInput$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'StopExecutionInput$cause' => '<p>A more detailed explanation of the cause of the termination.</p>', ], ], 'CreateActivityInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateActivityOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStateMachineInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStateMachineOutput' => [ 'base' => NULL, 'refs' => [], ], 'Data' => [ 'base' => NULL, 'refs' => [ 'ActivityScheduledEventDetails$input' => '<p>The JSON data input to the activity task.</p>', 'ActivitySucceededEventDetails$output' => '<p>The JSON data output by the activity task.</p>', 'DescribeExecutionOutput$input' => '<p>The JSON input data of the execution.</p>', 'DescribeExecutionOutput$output' => '<p>The JSON output data of the execution.</p>', 'ExecutionStartedEventDetails$input' => '<p>The JSON data input to the execution.</p>', 'ExecutionSucceededEventDetails$output' => '<p>The JSON data output by the execution.</p>', 'GetActivityTaskOutput$input' => '<p>The JSON input data for the task.</p>', 'LambdaFunctionScheduledEventDetails$input' => '<p>The JSON data input to the lambda function.</p>', 'LambdaFunctionSucceededEventDetails$output' => '<p>The JSON data output by the lambda function.</p>', 'SendTaskSuccessInput$output' => '<p>The JSON output of the task.</p>', 'StartExecutionInput$input' => '<p>The JSON input data for the execution.</p>', 'StateEnteredEventDetails$input' => '<p>The JSON input data to the state.</p>', 'StateExitedEventDetails$output' => '<p>The JSON output data of the state.</p>', ], ], 'Definition' => [ 'base' => NULL, 'refs' => [ 'CreateStateMachineInput$definition' => '<p>The Amazon States Language definition of the state machine.</p>', 'DescribeStateMachineOutput$definition' => '<p>The Amazon States Language definition of the state machine.</p>', ], ], 'DeleteActivityInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteActivityOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStateMachineInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStateMachineOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActivityInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActivityOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStateMachineInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStateMachineOutput' => [ 'base' => NULL, 'refs' => [], ], 'Error' => [ 'base' => NULL, 'refs' => [ 'ActivityFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'ActivityScheduleFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'ActivityTimedOutEventDetails$error' => '<p>The error code of the failure.</p>', 'ExecutionAbortedEventDetails$error' => '<p>The error code of the failure.</p>', 'ExecutionFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'ExecutionTimedOutEventDetails$error' => '<p>The error code of the failure.</p>', 'LambdaFunctionFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'LambdaFunctionScheduleFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'LambdaFunctionStartFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'LambdaFunctionTimedOutEventDetails$error' => '<p>The error code of the failure.</p>', 'SendTaskFailureInput$error' => '<p>An arbitrary error code that identifies the cause of the failure.</p>', 'StopExecutionInput$error' => '<p>An arbitrary error code that identifies the cause of the termination.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ActivityDoesNotExist$message' => NULL, 'ActivityLimitExceeded$message' => NULL, 'ActivityWorkerLimitExceeded$message' => NULL, 'ExecutionAlreadyExists$message' => NULL, 'ExecutionDoesNotExist$message' => NULL, 'ExecutionLimitExceeded$message' => NULL, 'InvalidArn$message' => NULL, 'InvalidDefinition$message' => NULL, 'InvalidExecutionInput$message' => NULL, 'InvalidName$message' => NULL, 'InvalidOutput$message' => NULL, 'InvalidToken$message' => NULL, 'StateMachineAlreadyExists$message' => NULL, 'StateMachineDeleting$message' => NULL, 'StateMachineDoesNotExist$message' => NULL, 'StateMachineLimitExceeded$message' => NULL, 'TaskDoesNotExist$message' => NULL, 'TaskTimedOut$message' => NULL, ], ], 'EventId' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$id' => '<p>The id of the event. Events are numbered sequentially, starting at one.</p>', 'HistoryEvent$previousEventId' => '<p>The id of the previous event.</p>', ], ], 'ExecutionAbortedEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$executionAbortedEventDetails' => NULL, ], ], 'ExecutionAlreadyExists' => [ 'base' => '<p>An execution with the same name already exists.</p>', 'refs' => [], ], 'ExecutionDoesNotExist' => [ 'base' => '<p>The specified execution does not exist.</p>', 'refs' => [], ], 'ExecutionFailedEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$executionFailedEventDetails' => NULL, ], ], 'ExecutionLimitExceeded' => [ 'base' => '<p>The maximum number of running executions has been reached. Running executions must end or be stopped before a new execution can be started.</p>', 'refs' => [], ], 'ExecutionList' => [ 'base' => NULL, 'refs' => [ 'ListExecutionsOutput$executions' => '<p>The list of matching executions.</p>', ], ], 'ExecutionListItem' => [ 'base' => NULL, 'refs' => [ 'ExecutionList$member' => NULL, ], ], 'ExecutionStartedEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$executionStartedEventDetails' => NULL, ], ], 'ExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeExecutionOutput$status' => '<p>The current status of the execution.</p>', 'ExecutionListItem$status' => '<p>The current status of the execution.</p>', 'ListExecutionsInput$statusFilter' => '<p>If specified, only list the executions whose current execution status matches the given filter.</p>', ], ], 'ExecutionSucceededEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$executionSucceededEventDetails' => NULL, ], ], 'ExecutionTimedOutEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$executionTimedOutEventDetails' => NULL, ], ], 'GetActivityTaskInput' => [ 'base' => NULL, 'refs' => [], ], 'GetActivityTaskOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetExecutionHistoryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetExecutionHistoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'HistoryEvent' => [ 'base' => NULL, 'refs' => [ 'HistoryEventList$member' => NULL, ], ], 'HistoryEventList' => [ 'base' => NULL, 'refs' => [ 'GetExecutionHistoryOutput$events' => '<p>The list of events that occurred in the execution.</p>', ], ], 'HistoryEventType' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$type' => '<p>The type of the event.</p>', ], ], 'Identity' => [ 'base' => NULL, 'refs' => [ 'ActivityStartedEventDetails$workerName' => '<p>The name of the worker that the task was assigned to. These names are provided by the workers when calling <a>GetActivityTask</a>.</p>', ], ], 'InvalidArn' => [ 'base' => '<p>The provided Amazon Resource Name (ARN) is invalid.</p>', 'refs' => [], ], 'InvalidDefinition' => [ 'base' => '<p>The provided Amazon States Language definition is invalid.</p>', 'refs' => [], ], 'InvalidExecutionInput' => [ 'base' => '<p>The provided JSON input data is invalid.</p>', 'refs' => [], ], 'InvalidName' => [ 'base' => '<p>The provided name is invalid.</p>', 'refs' => [], ], 'InvalidOutput' => [ 'base' => '<p>The provided JSON output data is invalid.</p>', 'refs' => [], ], 'InvalidToken' => [ 'base' => '<p>The provided token is invalid.</p>', 'refs' => [], ], 'LambdaFunctionFailedEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$lambdaFunctionFailedEventDetails' => NULL, ], ], 'LambdaFunctionScheduleFailedEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$lambdaFunctionScheduleFailedEventDetails' => NULL, ], ], 'LambdaFunctionScheduledEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$lambdaFunctionScheduledEventDetails' => NULL, ], ], 'LambdaFunctionStartFailedEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$lambdaFunctionStartFailedEventDetails' => NULL, ], ], 'LambdaFunctionSucceededEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$lambdaFunctionSucceededEventDetails' => NULL, ], ], 'LambdaFunctionTimedOutEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$lambdaFunctionTimedOutEventDetails' => NULL, ], ], 'ListActivitiesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListActivitiesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListExecutionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListExecutionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStateMachinesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStateMachinesOutput' => [ 'base' => NULL, 'refs' => [], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'ActivityListItem$name' => '<p>The name of the activity.</p>', 'CreateActivityInput$name' => '<p>The name of the activity to create. This name must be unique for your AWS account and region.</p>', 'CreateStateMachineInput$name' => '<p>The name of the state machine. This name must be unique for your AWS account and region.</p>', 'DescribeActivityOutput$name' => '<p>The name of the activity.</p>', 'DescribeExecutionOutput$name' => '<p>The name of the execution.</p>', 'DescribeStateMachineOutput$name' => '<p>The name of the state machine.</p>', 'ExecutionListItem$name' => '<p>The name of the execution.</p>', 'GetActivityTaskInput$workerName' => '<p>An arbitrary name may be provided in order to identify the worker that the task is assigned to. This name will be used when it is logged in the execution history.</p>', 'StartExecutionInput$name' => '<p>The name of the execution. This name must be unique for your AWS account and region.</p>', 'StateEnteredEventDetails$name' => '<p>The name of the state.</p>', 'StateExitedEventDetails$name' => '<p>The name of the state.</p>', 'StateMachineListItem$name' => '<p>The name of the state machine.</p>', ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'GetExecutionHistoryInput$maxResults' => '<p>The maximum number of results that will be returned per call. <code>nextToken</code> can be used to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000.</p> <p>This is an upper limit only; the actual number of results returned per call may be fewer than the specified maximum.</p>', 'ListActivitiesInput$maxResults' => '<p>The maximum number of results that will be returned per call. <code>nextToken</code> can be used to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000.</p> <p>This is an upper limit only; the actual number of results returned per call may be fewer than the specified maximum.</p>', 'ListExecutionsInput$maxResults' => '<p>The maximum number of results that will be returned per call. <code>nextToken</code> can be used to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000.</p> <p>This is an upper limit only; the actual number of results returned per call may be fewer than the specified maximum.</p>', 'ListStateMachinesInput$maxResults' => '<p>The maximum number of results that will be returned per call. <code>nextToken</code> can be used to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000.</p> <p>This is an upper limit only; the actual number of results returned per call may be fewer than the specified maximum.</p>', ], ], 'PageToken' => [ 'base' => NULL, 'refs' => [ 'GetExecutionHistoryInput$nextToken' => '<p>If a <code>nextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextToken</code>. Keep all other arguments unchanged.</p> <p>The configured <code>maxResults</code> determines how many results can be returned in a single call.</p>', 'GetExecutionHistoryOutput$nextToken' => '<p>If a <code>nextToken</code> is returned, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextToken</code>. Keep all other arguments unchanged.</p> <p>The configured <code>maxResults</code> determines how many results can be returned in a single call.</p>', 'ListActivitiesInput$nextToken' => '<p>If a <code>nextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextToken</code>. Keep all other arguments unchanged.</p> <p>The configured <code>maxResults</code> determines how many results can be returned in a single call.</p>', 'ListActivitiesOutput$nextToken' => '<p>If a <code>nextToken</code> is returned, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextToken</code>. Keep all other arguments unchanged.</p> <p>The configured <code>maxResults</code> determines how many results can be returned in a single call.</p>', 'ListExecutionsInput$nextToken' => '<p>If a <code>nextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextToken</code>. Keep all other arguments unchanged.</p> <p>The configured <code>maxResults</code> determines how many results can be returned in a single call.</p>', 'ListExecutionsOutput$nextToken' => '<p>If a <code>nextToken</code> is returned, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextToken</code>. Keep all other arguments unchanged.</p> <p>The configured <code>maxResults</code> determines how many results can be returned in a single call.</p>', 'ListStateMachinesInput$nextToken' => '<p>If a <code>nextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextToken</code>. Keep all other arguments unchanged.</p> <p>The configured <code>maxResults</code> determines how many results can be returned in a single call.</p>', 'ListStateMachinesOutput$nextToken' => '<p>If a <code>nextToken</code> is returned, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>nextToken</code>. Keep all other arguments unchanged.</p> <p>The configured <code>maxResults</code> determines how many results can be returned in a single call.</p>', ], ], 'ReverseOrder' => [ 'base' => NULL, 'refs' => [ 'GetExecutionHistoryInput$reverseOrder' => '<p>Lists events in descending order of their <code>timeStamp</code>.</p>', ], ], 'SendTaskFailureInput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskFailureOutput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskHeartbeatInput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskHeartbeatOutput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskSuccessInput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskSuccessOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StartExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'StateEnteredEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$stateEnteredEventDetails' => NULL, ], ], 'StateExitedEventDetails' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$stateExitedEventDetails' => NULL, ], ], 'StateMachineAlreadyExists' => [ 'base' => '<p>A state machine with the same name but a different definition or role ARN already exists.</p>', 'refs' => [], ], 'StateMachineDeleting' => [ 'base' => '<p>The specified state machine is being deleted.</p>', 'refs' => [], ], 'StateMachineDoesNotExist' => [ 'base' => '<p>The specified state machine does not exist.</p>', 'refs' => [], ], 'StateMachineLimitExceeded' => [ 'base' => '<p>The maximum number of state machines has been reached. Existing state machines must be deleted before a new state machine can be created.</p>', 'refs' => [], ], 'StateMachineList' => [ 'base' => NULL, 'refs' => [ 'ListStateMachinesOutput$stateMachines' => NULL, ], ], 'StateMachineListItem' => [ 'base' => NULL, 'refs' => [ 'StateMachineList$member' => NULL, ], ], 'StateMachineStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeStateMachineOutput$status' => '<p>The current status of the state machine.</p>', ], ], 'StopExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StopExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'TaskDoesNotExist' => [ 'base' => NULL, 'refs' => [], ], 'TaskTimedOut' => [ 'base' => NULL, 'refs' => [], ], 'TaskToken' => [ 'base' => NULL, 'refs' => [ 'GetActivityTaskOutput$taskToken' => '<p>A token that identifies the scheduled task. This token must be copied and included in subsequent calls to <a>SendTaskHeartbeat</a>, <a>SendTaskSuccess</a> or <a>SendTaskFailure</a> in order to report the progress or completion of the task.</p>', 'SendTaskFailureInput$taskToken' => '<p>The token that represents this task. Task tokens are generated by the service when the tasks are assigned to a worker (see GetActivityTask::taskToken).</p>', 'SendTaskHeartbeatInput$taskToken' => '<p>The token that represents this task. Task tokens are generated by the service when the tasks are assigned to a worker (see GetActivityTask::taskToken).</p>', 'SendTaskSuccessInput$taskToken' => '<p>The token that represents this task. Task tokens are generated by the service when the tasks are assigned to a worker (see GetActivityTask::taskToken).</p>', ], ], 'TimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'ActivityScheduledEventDetails$timeoutInSeconds' => '<p>The maximum allowed duration of the activity task.</p>', 'ActivityScheduledEventDetails$heartbeatInSeconds' => '<p>The maximum allowed duration between two heartbeats for the activity task.</p>', 'LambdaFunctionScheduledEventDetails$timeoutInSeconds' => '<p>The maximum allowed duration of the lambda function.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ActivityListItem$creationDate' => '<p>The date the activity was created.</p>', 'CreateActivityOutput$creationDate' => '<p>The date the activity was created.</p>', 'CreateStateMachineOutput$creationDate' => '<p>The date the state machine was created.</p>', 'DescribeActivityOutput$creationDate' => '<p>The date the activity was created.</p>', 'DescribeExecutionOutput$startDate' => '<p>The date the execution was started.</p>', 'DescribeExecutionOutput$stopDate' => '<p>If the execution has already ended, the date the execution stopped.</p>', 'DescribeStateMachineOutput$creationDate' => '<p>The date the state machine was created.</p>', 'ExecutionListItem$startDate' => '<p>The date the execution started.</p>', 'ExecutionListItem$stopDate' => '<p>If the execution already ended, the date the execution stopped.</p>', 'HistoryEvent$timestamp' => '<p>The date the event occured.</p>', 'StartExecutionOutput$startDate' => '<p>The date the execution was started.</p>', 'StateMachineListItem$creationDate' => '<p>The date the state machine was created.</p>', 'StopExecutionOutput$stopDate' => '<p>The date the execution was stopped.</p>', ], ], ],];
