<?php
// This file was auto-generated from sdk-root/src/data/storagegateway/2013-06-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Storage Gateway Service</fullname> <p>AWS Storage Gateway is the service that connects an on-premises software appliance with cloud-based storage to provide seamless and secure integration between an organization\'s on-premises IT environment and AWS\'s storage infrastructure. The service enables you to securely upload data to the AWS cloud for cost effective backup and rapid disaster recovery.</p> <p>Use the following links to get started using the <i>AWS Storage Gateway Service API Reference</i>:</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayAPI.html#AWSStorageGatewayHTTPRequestsHeaders">AWS Storage Gateway Required Request Headers</a>: Describes the required headers that you must send with every POST request to AWS Storage Gateway.</p> </li> <li> <p> <a href="http://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayAPI.html#AWSStorageGatewaySigningRequests">Signing Requests</a>: AWS Storage Gateway requires that you authenticate every request you send; this topic describes how sign such a request.</p> </li> <li> <p> <a href="http://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayAPI.html#APIErrorResponses">Error Responses</a>: Provides reference information about AWS Storage Gateway errors.</p> </li> <li> <p> <a href="http://docs.aws.amazon.com/storagegateway/latest/APIReference/API_Operations.html">Operations in AWS Storage Gateway</a>: Contains detailed descriptions of all AWS Storage Gateway operations, their request parameters, response elements, possible errors, and examples of requests and responses.</p> </li> <li> <p> <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#sg_region">AWS Storage Gateway Regions and Endpoints:</a> Provides a list of each region and endpoints available for use with AWS Storage Gateway. </p> </li> </ul> <note> <p>AWS Storage Gateway resource IDs are in uppercase. When you use these resource IDs with the Amazon EC2 API, EC2 expects resource IDs in lowercase. You must change your resource ID to lowercase to use it with the EC2 API. For example, in Storage Gateway the ID for a volume might be <code>vol-AA22BB012345DAF670</code>. When you use this ID with the EC2 API, you must change it to <code>vol-aa22bb012345daf670</code>. Otherwise, the EC2 API might not behave as expected.</p> </note> <important> <p>IDs for Storage Gateway volumes and Amazon EBS snapshots created from gateway volumes are changing to a longer format. Starting in December 2016, all new volumes and snapshots will be created with a 17-character string. Starting in April 2016, you will be able to use these longer IDs so you can test your systems with the new format. For more information, see <a href="https://aws.amazon.com/ec2/faqs/#longer-ids">Longer EC2 and EBS Resource IDs</a>.</p> <p> For example, a volume Amazon Resource Name (ARN) with the longer volume ID format looks like the following:</p> <p> <code>arn:aws:storagegateway:us-west-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABBCCDDEEFFG</code>.</p> <p>A snapshot ID with the longer ID format looks like the following: <code>snap-78e226633445566ee</code>.</p> <p>For more information, see <a href="https://forums.aws.amazon.com/ann.jspa?annID=3557">Announcement: Heads-up – Longer AWS Storage Gateway volume and snapshot IDs coming in 2016</a>.</p> </important>', 'operations' => [ 'ActivateGateway' => '<p>Activates the gateway you previously deployed on your host. For more information, see <a href="http://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedActivateGateway-common.html"> Activate the AWS Storage Gateway</a>. In the activation process, you specify information such as the region you want to use for storing snapshots or tapes, the time zone for scheduled snapshots the gateway snapshot schedule window, an activation key, and a name for your gateway. The activation process also associates your gateway with your account; for more information, see <a>UpdateGatewayInformation</a>.</p> <note> <p>You must turn on the gateway VM before you can activate your gateway.</p> </note>', 'AddCache' => '<p>Configures one or more gateway local disks as cache for a gateway. This operation is only supported in the cached volume, tape and file gateway architectures (see <a href="http://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html">Storage Gateway Concepts</a>).</p> <p>In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add cache, and one or more disk IDs that you want to configure as cache.</p>', 'AddTagsToResource' => '<p>Adds one or more tags to the specified resource. You use tags to add metadata to resources, which you can use to categorize these resources. For example, you can categorize resources by purpose, owner, environment, or team. Each tag consists of a key and a value, which you define. You can add tags to the following AWS Storage Gateway resources:</p> <ul> <li> <p>Storage gateways of all types</p> </li> </ul> <ul> <li> <p>Storage Volumes</p> </li> </ul> <ul> <li> <p>Virtual Tapes</p> </li> </ul> <p>You can create a maximum of 10 tags for each resource. Virtual tapes and storage volumes that are recovered to a new gateway maintain their tags.</p>', 'AddUploadBuffer' => '<p>Configures one or more gateway local disks as upload buffer for a specified gateway. This operation is supported for the stored volume, cached volume and tape gateway architectures.</p> <p>In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add upload buffer, and one or more disk IDs that you want to configure as upload buffer.</p>', 'AddWorkingStorage' => '<p>Configures one or more gateway local disks as working storage for a gateway. This operation is only supported in the stored volume gateway architecture. This operation is deprecated in cached volume API version 20120630. Use <a>AddUploadBuffer</a> instead.</p> <note> <p>Working storage is also referred to as upload buffer. You can also use the <a>AddUploadBuffer</a> operation to add upload buffer to a stored volume gateway.</p> </note> <p>In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add working storage, and one or more disk IDs that you want to configure as working storage.</p>', 'CancelArchival' => '<p>Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated. This operation is only supported in the tape gateway architecture.</p>', 'CancelRetrieval' => '<p>Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is initiated. The virtual tape is returned to the VTS.</p>', 'CreateCachediSCSIVolume' => '<p>Creates a cached volume on a specified cached volume gateway. This operation is only supported in the cached volume gateway architecture.</p> <note> <p>Cache storage must be allocated to the gateway before you can create a cached volume. Use the <a>AddCache</a> operation to add cache storage to a gateway. </p> </note> <p>In the request, you must specify the gateway, size of the volume in bytes, the iSCSI target name, an IP address on which to expose the target, and a unique client token. In response, the gateway creates the volume and returns information about it. This information includes the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.</p> <p>Optionally, you can provide the ARN for an existing volume as the <code>SourceVolumeARN</code> for this cached volume, which creates an exact copy of the existing volume’s latest recovery point. The <code>VolumeSizeInBytes</code> value must be equal to or larger than the size of the copied volume, in bytes.</p>', 'CreateNFSFileShare' => '<p>Creates a file share on an existing file gateway. In Storage Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using a Network File System (NFS) interface. This operation is only supported in the file gateway architecture.</p> <important> <p>File gateway requires AWS Security Token Service (AWS STS) to be activated to enable you create a file share. Make sure AWS STS is activated in the region you are creating your file gateway in. If AWS STS is not activated in the region, activate it. For information about how to activate AWS STS, see Activating and Deactivating AWS STS in an AWS Region in the AWS Identity and Access Management User Guide. </p> <p>File gateway does not support creating hard or symbolic links on a file share.</p> </important>', 'CreateSnapshot' => '<p>Initiates a snapshot of a volume.</p> <p>AWS Storage Gateway provides the ability to back up point-in-time snapshots of your data to Amazon Simple Storage (S3) for durable off-site recovery, as well as import the data to an Amazon Elastic Block Store (EBS) volume in Amazon Elastic Compute Cloud (EC2). You can take snapshots of your gateway volume on a scheduled or ad-hoc basis. This API enables you to take ad-hoc snapshot. For more information, see <a href="http://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#SchedulingSnapshot">Editing a Snapshot Schedule</a>.</p> <p>In the CreateSnapshot request you identify the volume by providing its Amazon Resource Name (ARN). You must also provide description for the snapshot. When AWS Storage Gateway takes the snapshot of specified volume, the snapshot and description appears in the AWS Storage Gateway Console. In response, AWS Storage Gateway returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it when you want to create a volume from a snapshot. This operation is only supported in stored and cached volume gateway architecture.</p> <note> <p>To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see DescribeSnapshots or DeleteSnapshot in the <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Operations.html">EC2 API reference</a>.</p> </note> <important> <p>Volume and snapshot IDs are changing to a longer length ID format. For more information, see the important note on the <a href="http://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html">Welcome</a> page.</p> </important>', 'CreateSnapshotFromVolumeRecoveryPoint' => '<p>Initiates a snapshot of a gateway from a volume recovery point. This operation is only supported in the cached volume gateway architecture.</p> <p>A volume recovery point is a point in time at which all data of the volume is consistent and from which you can create a snapshot. To get a list of volume recovery point for cached volume gateway, use <a>ListVolumeRecoveryPoints</a>.</p> <p>In the <code>CreateSnapshotFromVolumeRecoveryPoint</code> request, you identify the volume by providing its Amazon Resource Name (ARN). You must also provide a description for the snapshot. When the gateway takes a snapshot of the specified volume, the snapshot and its description appear in the AWS Storage Gateway console. In response, the gateway returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it when you want to create a volume from a snapshot.</p> <note> <p>To list or delete a snapshot, you must use the Amazon EC2 API. For more information, in <i>Amazon Elastic Compute Cloud API Reference</i>.</p> </note>', 'CreateStorediSCSIVolume' => '<p>Creates a volume on a specified gateway. This operation is only supported in the stored volume gateway architecture.</p> <p>The size of the volume to create is inferred from the disk size. You can choose to preserve existing data on the disk, create volume from an existing snapshot, or create an empty volume. If you choose to create an empty gateway volume, then any existing data on the disk is erased.</p> <p>In the request you must specify the gateway and the disk information on which you are creating the volume. In response, the gateway creates the volume and returns volume information such as the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.</p>', 'CreateTapeWithBarcode' => '<p>Creates a virtual tape by using your own barcode. You write data to the virtual tape and then archive the tape. A barcode is unique and can not be reused if it has already been used on a tape . This applies to barcodes used on deleted tapes. This operation is only supported in the tape gateway. architecture.</p> <note> <p>Cache storage must be allocated to the gateway before you can create a virtual tape. Use the <a>AddCache</a> operation to add cache storage to a gateway.</p> </note>', 'CreateTapes' => '<p>Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes. This operation is only supported in the tape gateway architecture.</p> <note> <p>Cache storage must be allocated to the gateway before you can create virtual tapes. Use the <a>AddCache</a> operation to add cache storage to a gateway. </p> </note>', 'DeleteBandwidthRateLimit' => '<p>Deletes the bandwidth rate limits of a gateway. You can delete either the upload and download bandwidth rate limit, or you can delete both. If you delete only one of the limits, the other limit remains unchanged. To specify which gateway to work with, use the Amazon Resource Name (ARN) of the gateway in your request.</p>', 'DeleteChapCredentials' => '<p>Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator pair.</p>', 'DeleteFileShare' => '<p>Deletes a file share from a file gateway. This operation is only supported in the file gateway architecture.</p>', 'DeleteGateway' => '<p>Deletes a gateway. To specify which gateway to delete, use the Amazon Resource Name (ARN) of the gateway in your request. The operation deletes the gateway; however, it does not delete the gateway virtual machine (VM) from your host computer.</p> <p>After you delete a gateway, you cannot reactivate it. Completed snapshots of the gateway volumes are not deleted upon deleting the gateway, however, pending snapshots will not complete. After you delete a gateway, your next step is to remove it from your environment.</p> <important> <p>You no longer pay software charges after the gateway is deleted; however, your existing Amazon EBS snapshots persist and you will continue to be billed for these snapshots. You can choose to remove all remaining Amazon EBS snapshots by canceling your Amazon EC2 subscription.  If you prefer not to cancel your Amazon EC2 subscription, you can delete your snapshots using the Amazon EC2 console. For more information, see the <a href="http://aws.amazon.com/storagegateway"> AWS Storage Gateway Detail Page</a>. </p> </important>', 'DeleteSnapshotSchedule' => '<p>Deletes a snapshot of a volume.</p> <p>You can take snapshots of your gateway volumes on a scheduled or ad hoc basis. This API action enables you to delete a snapshot schedule for a volume. For more information, see <a href="http://docs.aws.amazon.com/storagegateway/latest/userguide/WorkingWithSnapshots.html">Working with Snapshots</a>. In the <code>DeleteSnapshotSchedule</code> request, you identify the volume by providing its Amazon Resource Name (ARN). </p> <note> <p>To list or delete a snapshot, you must use the Amazon EC2 API. in <i>Amazon Elastic Compute Cloud API Reference</i>.</p> </note>', 'DeleteTape' => '<p>Deletes the specified virtual tape. This operation is only supported in the tape gateway architecture.</p>', 'DeleteTapeArchive' => '<p>Deletes the specified virtual tape from the virtual tape shelf (VTS). This operation is only supported in the tape gateway architecture.</p>', 'DeleteVolume' => '<p>Deletes the specified storage volume that you previously created using the <a>CreateCachediSCSIVolume</a> or <a>CreateStorediSCSIVolume</a> API. This operation is only supported in the cached volume and stored volume architectures. For stored volume gateways, the local disk that was configured as the storage volume is not deleted. You can reuse the local disk to create another storage volume. </p> <p>Before you delete a volume, make sure there are no iSCSI connections to the volume you are deleting. You should also make sure there is no snapshot in progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API to query snapshots on the volume you are deleting and check the snapshot status. For more information, go to <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p> <p>In the request, you must provide the Amazon Resource Name (ARN) of the storage volume you want to delete.</p>', 'DescribeBandwidthRateLimit' => '<p>Returns the bandwidth rate limits of a gateway. By default, these limits are not set, which means no bandwidth rate limiting is in effect.</p> <p>This operation only returns a value for a bandwidth rate limit only if the limit is set. If no limits are set for the gateway, then this operation returns only the gateway ARN in the response body. To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.</p>', 'DescribeCache' => '<p>Returns information about the cache of a gateway. This operation is only supported in the cached volume,tape and file gateway architectures.</p> <p>The response includes disk IDs that are configured as cache, and it includes the amount of cache allocated and used.</p>', 'DescribeCachediSCSIVolumes' => '<p>Returns a description of the gateway volumes specified in the request. This operation is only supported in the cached volume gateway architecture.</p> <p>The list of gateway volumes in the request must be from one gateway. In the response Amazon Storage Gateway returns volume information sorted by volume Amazon Resource Name (ARN).</p>', 'DescribeChapCredentials' => '<p>Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified iSCSI target, one for each target-initiator pair.</p>', 'DescribeGatewayInformation' => '<p>Returns metadata about a gateway such as its name, network interfaces, configured time zone, and the state (whether the gateway is running or not). To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.</p>', 'DescribeMaintenanceStartTime' => '<p>Returns your gateway\'s weekly maintenance start time including the day and time of the week. Note that values are in terms of the gateway\'s time zone.</p>', 'DescribeNFSFileShares' => '<p>Gets a description for one or more file shares from a file gateway. This operation is only supported in file gateways.</p>', 'DescribeSnapshotSchedule' => '<p>Describes the snapshot schedule for the specified gateway volume. The snapshot schedule information includes intervals at which snapshots are automatically initiated on the volume. This operation is only supported in the cached volume and stored volume architectures.</p>', 'DescribeStorediSCSIVolumes' => '<p>Returns the description of the gateway volumes specified in the request. The list of gateway volumes in the request must be from one gateway. In the response Amazon Storage Gateway returns volume information sorted by volume ARNs. This operation is only supported in stored volume gateway architecture.</p>', 'DescribeTapeArchives' => '<p>Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only supported in the tape gateway architecture.</p> <p>If a specific <code>TapeARN</code> is not specified, AWS Storage Gateway returns a description of all virtual tapes found in the VTS associated with your account.</p>', 'DescribeTapeRecoveryPoints' => '<p>Returns a list of virtual tape recovery points that are available for the specified tape gateway.</p> <p>A recovery point is a point-in-time view of a virtual tape at which all the data on the virtual tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway. This operation is only supported in the tape gateway architecture.</p>', 'DescribeTapes' => '<p>Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes. If a <code>TapeARN</code> is not specified, returns a description of all virtual tapes associated with the specified gateway. This operation is only supported in the tape gateway architecture.</p>', 'DescribeUploadBuffer' => '<p>Returns information about the upload buffer of a gateway. This operation is supported for the stored volume, cached volume and tape gateway architectures.</p> <p>The response includes disk IDs that are configured as upload buffer space, and it includes the amount of upload buffer space allocated and used.</p>', 'DescribeVTLDevices' => '<p>Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response, AWS Storage Gateway returns VTL device information.</p> <p>This operation is only supported in the tape gateway architecture.</p>', 'DescribeWorkingStorage' => '<p>Returns information about the working storage of a gateway. This operation is only supported in the stored volumes gateway architecture. This operation is deprecated in cached volumes API version (20120630). Use DescribeUploadBuffer instead.</p> <note> <p>Working storage is also referred to as upload buffer. You can also use the DescribeUploadBuffer operation to add upload buffer to a stored volume gateway.</p> </note> <p>The response includes disk IDs that are configured as working storage, and it includes the amount of working storage allocated and used.</p>', 'DisableGateway' => '<p>Disables a tape gateway when the gateway is no longer functioning. For example, if your gateway VM is damaged, you can disable the gateway so you can recover virtual tapes.</p> <p>Use this operation for a tape gateway that is not reachable or not functioning. This operation is only supported in the tape gateway architectures.</p> <important> <p>Once a gateway is disabled it cannot be enabled.</p> </important>', 'ListFileShares' => '<p>Gets a list of the file shares for a specific file gateway, or the list of file shares that belong to the calling user account. This operation is only supported in the file gateway architecture.</p>', 'ListGateways' => '<p>Lists gateways owned by an AWS account in a region specified in the request. The returned list is ordered by gateway Amazon Resource Name (ARN).</p> <p>By default, the operation returns a maximum of 100 gateways. This operation supports pagination that allows you to optionally reduce the number of gateways returned in a response.</p> <p>If you have more gateways than are returned in a response (that is, the response returns only a truncated list of your gateways), the response contains a marker that you can specify in your next request to fetch the next page of gateways.</p>', 'ListLocalDisks' => '<p>Returns a list of the gateway\'s local disks. To specify which gateway to describe, you use the Amazon Resource Name (ARN) of the gateway in the body of the request.</p> <p>The request returns a list of all disks, specifying which are configured as working storage, cache storage, or stored volume or not configured at all. The response includes a <code>DiskStatus</code> field. This field can have a value of present (the disk is available to use), missing (the disk is no longer connected to the gateway), or mismatch (the disk node is occupied by a disk that has incorrect metadata or the disk content is corrupted).</p>', 'ListTagsForResource' => '<p>Lists the tags that have been added to the specified resource. This operation is only supported in the cached volume, stored volume and tape gateway architecture.</p>', 'ListTapes' => '<p>Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes to list by specifying one or more tape Amazon Resource Names (ARNs). If you don\'t specify a tape ARN, the operation lists all virtual tapes in both your VTL and VTS.</p> <p>This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can optionally specify the <code>Limit</code> parameter in the body to limit the number of tapes in the response. If the number of tapes returned in the response is truncated, the response includes a <code>Marker</code> element that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported in the tape gateway architecture.</p>', 'ListVolumeInitiators' => '<p>Lists iSCSI initiators that are connected to a volume. You can use this operation to determine whether a volume is being used or not. This operation is only supported in the cached volume and stored volume gateway architecture.</p>', 'ListVolumeRecoveryPoints' => '<p>Lists the recovery points for a specified gateway. This operation is only supported in the cached volume gateway architecture.</p> <p>Each cache volume has one recovery point. A volume recovery point is a point in time at which all data of the volume is consistent and from which you can create a snapshot or clone a new cached volume from a source volume. To create a snapshot from a volume recovery point use the <a>CreateSnapshotFromVolumeRecoveryPoint</a> operation.</p>', 'ListVolumes' => '<p>Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the volume ARNs. If you want additional volume information, use the <a>DescribeStorediSCSIVolumes</a> or the <a>DescribeCachediSCSIVolumes</a> API.</p> <p>The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can optionally specify the <code>Limit</code> field in the body to limit the number of volumes in the response. If the number of volumes returned in the response is truncated, the response includes a Marker field. You can use this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only supported in the cached volume and stored volume gateway architectures.</p>', 'RefreshCache' => '<p>Refreshes the cache for the specified file share. This operation finds objects in the Amazon S3 bucket that were added, removed or replaced since the gateway last listed the bucket\'s contents and cached the results.</p>', 'RemoveTagsFromResource' => '<p>Removes one or more tags from the specified resource. This operation is only supported in the cached volume, stored volume and tape gateway architectures.</p>', 'ResetCache' => '<p>Resets all cache disks that have encountered a error and makes the disks available for reconfiguration as cache storage. If your cache disk encounters a error, the gateway prevents read and write operations on virtual tapes in the gateway. For example, an error can occur when a disk is corrupted or removed from the gateway. When a cache is reset, the gateway loses its cache storage. At this point you can reconfigure the disks as cache disks. This operation is only supported in the cached volume,tape and file gateway architectures.</p> <important> <p>If the cache disk you are resetting contains data that has not been uploaded to Amazon S3 yet, that data can be lost. After you reset cache disks, there will be no configured cache disks left in the gateway, so you must configure at least one new cache disk for your gateway to function properly.</p> </important>', 'RetrieveTapeArchive' => '<p>Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a tape gateway. Virtual tapes archived in the VTS are not associated with any gateway. However after a tape is retrieved, it is associated with a gateway, even though it is also listed in the VTS, that is, archive. This operation is only supported in the tape gateway architecture.</p> <p>Once a tape is successfully retrieved to a gateway, it cannot be retrieved again to another gateway. You must archive the tape again before you can retrieve it to another gateway. This operation is only supported in the tape gateway architecture.</p>', 'RetrieveTapeRecoveryPoint' => '<p>Retrieves the recovery point for the specified virtual tape. This operation is only supported in the tape gateway architecture.</p> <p>A recovery point is a point in time view of a virtual tape at which all the data on the tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.</p> <note> <p>The virtual tape can be retrieved to only one gateway. The retrieved tape is read-only. The virtual tape can be retrieved to only a tape gateway. There is no charge for retrieving recovery points.</p> </note>', 'SetLocalConsolePassword' => '<p>Sets the password for your VM local console. When you log in to the local console for the first time, you log in to the VM with the default credentials. We recommend that you set a new password. You don\'t need to know the default password to set a new password.</p>', 'ShutdownGateway' => '<p>Shuts down a gateway. To specify which gateway to shut down, use the Amazon Resource Name (ARN) of the gateway in the body of your request.</p> <p>The operation shuts down the gateway service component running in the gateway\'s virtual machine (VM) and not the host VM.</p> <note> <p>If you want to shut down the VM, it is recommended that you first shut down the gateway component in the VM to avoid unpredictable conditions.</p> </note> <p>After the gateway is shutdown, you cannot call any other API except <a>StartGateway</a>, <a>DescribeGatewayInformation</a>, and <a>ListGateways</a>. For more information, see <a>ActivateGateway</a>. Your applications cannot read from or write to the gateway\'s storage volumes, and there are no snapshots taken.</p> <note> <p>When you make a shutdown request, you will get a <code>200 OK</code> success response immediately. However, it might take some time for the gateway to shut down. You can call the <a>DescribeGatewayInformation</a> API to check the status. For more information, see <a>ActivateGateway</a>.</p> </note> <p>If do not intend to use the gateway again, you must delete the gateway (using <a>DeleteGateway</a>) to no longer pay software charges associated with the gateway.</p>', 'StartGateway' => '<p>Starts a gateway that you previously shut down (see <a>ShutdownGateway</a>). After the gateway starts, you can then make other API calls, your applications can read from or write to the gateway\'s storage volumes and you will be able to take snapshot backups.</p> <note> <p>When you make a request, you will get a 200 OK success response immediately. However, it might take some time for the gateway to be ready. You should call <a>DescribeGatewayInformation</a> and check the status before making any additional API calls. For more information, see <a>ActivateGateway</a>.</p> </note> <p>To specify which gateway to start, use the Amazon Resource Name (ARN) of the gateway in your request.</p>', 'UpdateBandwidthRateLimit' => '<p>Updates the bandwidth rate limits of a gateway. You can update both the upload and download bandwidth rate limit or specify only one of the two. If you don\'t set a bandwidth rate limit, the existing rate limit remains.</p> <p>By default, a gateway\'s bandwidth rate limits are not set. If you don\'t set any limit, the gateway does not have any limitations on its bandwidth usage and could potentially use the maximum available bandwidth.</p> <p>To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.</p>', 'UpdateChapCredentials' => '<p>Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target. By default, a gateway does not have CHAP enabled; however, for added security, you might use it.</p> <important> <p>When you update CHAP credentials, all existing connections on the target are closed and initiators must reconnect with the new credentials.</p> </important>', 'UpdateGatewayInformation' => '<p>Updates a gateway\'s metadata, which includes the gateway\'s name and time zone. To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.</p> <note> <p>For Gateways activated after September 2, 2015, the gateway\'s ARN contains the gateway ID rather than the gateway name. However, changing the name of the gateway has no effect on the gateway\'s ARN.</p> </note>', 'UpdateGatewaySoftwareNow' => '<p>Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.</p> <note> <p>When you make this request, you get a <code>200 OK</code> success response immediately. However, it might take some time for the update to complete. You can call <a>DescribeGatewayInformation</a> to verify the gateway is in the <code>STATE_RUNNING</code> state.</p> </note> <important> <p>A software update forces a system restart of your gateway. You can minimize the chance of any disruption to your applications by increasing your iSCSI Initiators\' timeouts. For more information about increasing iSCSI Initiator timeouts for Windows and Linux, see <a href="http://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings">Customizing Your Windows iSCSI Settings</a> and <a href="http://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings">Customizing Your Linux iSCSI Settings</a>, respectively.</p> </important>', 'UpdateMaintenanceStartTime' => '<p>Updates a gateway\'s weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway\'s time zone.</p>', 'UpdateNFSFileShare' => '<p>Updates a file share. This operation is only supported in the file gateway architecture.</p> <note> <p>To leave a file share field unchanged, set the corresponding input field to null.</p> </note> <p>Updates the following file share setting:</p> <ul> <li> <p>Default storage class for your S3 bucket</p> </li> <li> <p>Metadata defaults for your S3 bucket</p> </li> <li> <p>Allowed NFS clients for your file share</p> </li> <li> <p>Squash settings</p> </li> <li> <p>Write status of your file share</p> </li> </ul> <note> <p>To leave a file share field unchanged, set the corresponding input field to null. This operation is only supported in file gateways.</p> </note>', 'UpdateSnapshotSchedule' => '<p>Updates a snapshot schedule configured for a gateway volume. This operation is only supported in the cached volume and stored volume gateway architectures.</p> <p>The default snapshot schedule for volume is once every 24 hours, starting at the creation time of the volume. You can use this API to change the snapshot schedule configured for the volume.</p> <p>In the request you must identify the gateway volume whose snapshot schedule you want to update, and the schedule information, including when you want the snapshot to begin on a day and the frequency (in hours) of snapshots.</p>', 'UpdateVTLDeviceType' => '<p>Updates the type of medium changer in a tape gateway. When you activate a tape gateway, you select a medium changer type for the tape gateway. This operation enables you to select a different type of medium changer after a tape gateway is activated. This operation is only supported in the tape gateway architecture.</p>', ], 'shapes' => [ 'ActivateGatewayInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>ActivateGatewayInput$ActivationKey</a> </p> </li> <li> <p> <a>ActivateGatewayInput$GatewayName</a> </p> </li> <li> <p> <a>ActivateGatewayInput$GatewayRegion</a> </p> </li> <li> <p> <a>ActivateGatewayInput$GatewayTimezone</a> </p> </li> <li> <p> <a>ActivateGatewayInput$GatewayType</a> </p> </li> <li> <p> <a>ActivateGatewayInput$TapeDriveType</a> </p> </li> <li> <p> <a>ActivateGatewayInput$MediumChangerType</a> </p> </li> </ul>', 'refs' => [], ], 'ActivateGatewayOutput' => [ 'base' => '<p>AWS Storage Gateway returns the Amazon Resource Name (ARN) of the activated gateway. It is a string made of information such as your account, gateway name, and region. This ARN is used to reference the gateway in other API operations as well as resource-based authorization.</p> <note> <p>For gateways activated prior to September 02, 2015 the gateway ARN contains the gateway name rather than the gateway id. Changing the name of the gateway has no effect on the gateway ARN.</p> </note>', 'refs' => [], ], 'ActivationKey' => [ 'base' => NULL, 'refs' => [ 'ActivateGatewayInput$ActivationKey' => '<p>Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with redirects enabled to the gateway IP address (port 80). The redirect URL returned in the response provides you the activation key for your gateway in the query string parameter <code>activationKey</code>. It may also include other activation-related parameters, however, these are merely defaults -- the arguments you pass to the <code>ActivateGateway</code> API call determine the actual configuration of your gateway.</p>', ], ], 'AddCacheInput' => [ 'base' => NULL, 'refs' => [], ], 'AddCacheOutput' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsToResourceInput' => [ 'base' => '<p>AddTagsToResourceInput</p>', 'refs' => [], ], 'AddTagsToResourceOutput' => [ 'base' => '<p>AddTagsToResourceOutput</p>', 'refs' => [], ], 'AddUploadBufferInput' => [ 'base' => NULL, 'refs' => [], ], 'AddUploadBufferOutput' => [ 'base' => NULL, 'refs' => [], ], 'AddWorkingStorageInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>AddWorkingStorageInput$DiskIds</a> </p> </li> </ul>', 'refs' => [], ], 'AddWorkingStorageOutput' => [ 'base' => '<p>A JSON object containing the of the gateway for which working storage was configured.</p>', 'refs' => [], ], 'BandwidthDownloadRateLimit' => [ 'base' => NULL, 'refs' => [ 'DescribeBandwidthRateLimitOutput$AverageDownloadRateLimitInBitsPerSec' => '<p>The average download bandwidth rate limit in bits per second. This field does not appear in the response if the download rate limit is not set.</p>', 'UpdateBandwidthRateLimitInput$AverageDownloadRateLimitInBitsPerSec' => '<p>The average download bandwidth rate limit in bits per second.</p>', ], ], 'BandwidthType' => [ 'base' => NULL, 'refs' => [ 'DeleteBandwidthRateLimitInput$BandwidthType' => '<p>One of the BandwidthType values that indicates the gateway bandwidth rate limit to delete.</p> <p>Valid Values: <code>Upload</code>, <code>Download</code>, <code>All</code>.</p>', ], ], 'BandwidthUploadRateLimit' => [ 'base' => NULL, 'refs' => [ 'DescribeBandwidthRateLimitOutput$AverageUploadRateLimitInBitsPerSec' => '<p>The average upload bandwidth rate limit in bits per second. This field does not appear in the response if the upload rate limit is not set.</p>', 'UpdateBandwidthRateLimitInput$AverageUploadRateLimitInBitsPerSec' => '<p>The average upload bandwidth rate limit in bits per second.</p>', ], ], 'Boolean' => [ 'base' => '<p>A value that indicates whether the write status of a file share is read-only: "true" if write status is read-only, and otherwise "false".</p>', 'refs' => [ 'CreateNFSFileShareInput$KMSEncrypted' => '<p>True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by Amazon S3. Optional.</p>', 'CreateNFSFileShareInput$ReadOnly' => '<p>Sets the write status of a file share: "true" if the write status is read-only, and otherwise "false".</p>', 'NFSFileShareInfo$ReadOnly' => NULL, 'UpdateNFSFileShareInput$KMSEncrypted' => '<p>True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by Amazon S3. Optional. </p>', 'UpdateNFSFileShareInput$ReadOnly' => '<p>Sets the write status of a file share: "true" if the write status is read-only, otherwise "false".</p>', ], ], 'CachediSCSIVolume' => [ 'base' => '<p>Describes an iSCSI cached volume.</p>', 'refs' => [ 'CachediSCSIVolumes$member' => NULL, ], ], 'CachediSCSIVolumes' => [ 'base' => NULL, 'refs' => [ 'DescribeCachediSCSIVolumesOutput$CachediSCSIVolumes' => '<p>An array of objects where each object contains metadata about one cached volume.</p>', ], ], 'CancelArchivalInput' => [ 'base' => '<p>CancelArchivalInput</p>', 'refs' => [], ], 'CancelArchivalOutput' => [ 'base' => '<p>CancelArchivalOutput</p>', 'refs' => [], ], 'CancelRetrievalInput' => [ 'base' => '<p>CancelRetrievalInput</p>', 'refs' => [], ], 'CancelRetrievalOutput' => [ 'base' => '<p>CancelRetrievalOutput</p>', 'refs' => [], ], 'ChapCredentials' => [ 'base' => NULL, 'refs' => [ 'DescribeChapCredentialsOutput$ChapCredentials' => '<p>An array of <a>ChapInfo</a> objects that represent CHAP credentials. Each object in the array contains CHAP credential information for one target-initiator pair. If no CHAP credentials are set, an empty array is returned. CHAP credential information is provided in a JSON object with the following fields:</p> <ul> <li> <p> <b>InitiatorName</b>: The iSCSI initiator that connects to the target.</p> </li> <li> <p> <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p> </li> <li> <p> <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).</p> </li> <li> <p> <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.</p> </li> </ul>', ], ], 'ChapInfo' => [ 'base' => '<p>Describes Challenge-Handshake Authentication Protocol (CHAP) information that supports authentication between your gateway and iSCSI initiators.</p>', 'refs' => [ 'ChapCredentials$member' => NULL, ], ], 'ChapSecret' => [ 'base' => NULL, 'refs' => [ 'ChapInfo$SecretToAuthenticateInitiator' => '<p>The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p>', 'ChapInfo$SecretToAuthenticateTarget' => '<p>The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).</p>', 'UpdateChapCredentialsInput$SecretToAuthenticateInitiator' => '<p>The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p> <note> <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p> </note>', 'UpdateChapCredentialsInput$SecretToAuthenticateTarget' => '<p>The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).</p> <p>Byte constraints: Minimum bytes of 12. Maximum bytes of 16.</p> <note> <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p> </note>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateCachediSCSIVolumeInput$ClientToken' => NULL, 'CreateNFSFileShareInput$ClientToken' => '<p>A unique string value that you supply that is used by file gateway to ensure idempotent file share creation.</p>', 'CreateTapesInput$ClientToken' => '<p>A unique identifier that you use to retry a request. If you retry a request, use the same <code>ClientToken</code> you specified in the initial request.</p> <note> <p>Using the same <code>ClientToken</code> prevents creating the tape multiple times.</p> </note>', ], ], 'CreateCachediSCSIVolumeInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCachediSCSIVolumeOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNFSFileShareInput' => [ 'base' => '<p>CreateNFSFileShareInput</p>', 'refs' => [], ], 'CreateNFSFileShareOutput' => [ 'base' => '<p>CreateNFSFileShareOutput</p>', 'refs' => [], ], 'CreateSnapshotFromVolumeRecoveryPointInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotFromVolumeRecoveryPointOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>CreateSnapshotInput$SnapshotDescription</a> </p> </li> <li> <p> <a>CreateSnapshotInput$VolumeARN</a> </p> </li> </ul>', 'refs' => [], ], 'CreateSnapshotOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'CreateStorediSCSIVolumeInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>CreateStorediSCSIVolumeInput$DiskId</a> </p> </li> <li> <p> <a>CreateStorediSCSIVolumeInput$NetworkInterfaceId</a> </p> </li> <li> <p> <a>CreateStorediSCSIVolumeInput$PreserveExistingData</a> </p> </li> <li> <p> <a>CreateStorediSCSIVolumeInput$SnapshotId</a> </p> </li> <li> <p> <a>CreateStorediSCSIVolumeInput$TargetName</a> </p> </li> </ul>', 'refs' => [], ], 'CreateStorediSCSIVolumeOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'CreateTapeWithBarcodeInput' => [ 'base' => '<p>CreateTapeWithBarcodeInput</p>', 'refs' => [], ], 'CreateTapeWithBarcodeOutput' => [ 'base' => '<p>CreateTapeOutput</p>', 'refs' => [], ], 'CreateTapesInput' => [ 'base' => '<p>CreateTapesInput</p>', 'refs' => [], ], 'CreateTapesOutput' => [ 'base' => '<p>CreateTapeOutput</p>', 'refs' => [], ], 'CreatedDate' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$CreatedDate' => '<p>The date the volume was created. Volumes created prior to March 28, 2017 don’t have this time stamp.</p>', 'StorediSCSIVolume$CreatedDate' => '<p>The date the volume was created. Volumes created prior to March 28, 2017 don’t have this time stamp.</p>', ], ], 'DayOfWeek' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceStartTimeOutput$DayOfWeek' => '<p>An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6 represents Saturday. The day of week is in the time zone of the gateway.</p>', 'UpdateMaintenanceStartTimeInput$DayOfWeek' => '<p>The maintenance start time day of the week represented as an ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday.</p>', ], ], 'DeleteBandwidthRateLimitInput' => [ 'base' => '<p>A JSON object containing the following fields:</p> <ul> <li> <p> <a>DeleteBandwidthRateLimitInput$BandwidthType</a> </p> </li> </ul>', 'refs' => [], ], 'DeleteBandwidthRateLimitOutput' => [ 'base' => '<p>A JSON object containing the of the gateway whose bandwidth rate information was deleted.</p>', 'refs' => [], ], 'DeleteChapCredentialsInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>DeleteChapCredentialsInput$InitiatorName</a> </p> </li> <li> <p> <a>DeleteChapCredentialsInput$TargetARN</a> </p> </li> </ul>', 'refs' => [], ], 'DeleteChapCredentialsOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'DeleteFileShareInput' => [ 'base' => '<p>DeleteFileShareInput</p>', 'refs' => [], ], 'DeleteFileShareOutput' => [ 'base' => '<p>DeleteFileShareOutput</p>', 'refs' => [], ], 'DeleteGatewayInput' => [ 'base' => '<p>A JSON object containing the id of the gateway to delete.</p>', 'refs' => [], ], 'DeleteGatewayOutput' => [ 'base' => '<p>A JSON object containing the id of the deleted gateway.</p>', 'refs' => [], ], 'DeleteSnapshotScheduleInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotScheduleOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTapeArchiveInput' => [ 'base' => '<p>DeleteTapeArchiveInput</p>', 'refs' => [], ], 'DeleteTapeArchiveOutput' => [ 'base' => '<p>DeleteTapeArchiveOutput</p>', 'refs' => [], ], 'DeleteTapeInput' => [ 'base' => '<p>DeleteTapeInput</p>', 'refs' => [], ], 'DeleteTapeOutput' => [ 'base' => '<p>DeleteTapeOutput</p>', 'refs' => [], ], 'DeleteVolumeInput' => [ 'base' => '<p>A JSON object containing the <a>DeleteVolumeInput$VolumeARN</a> to delete.</p>', 'refs' => [], ], 'DeleteVolumeOutput' => [ 'base' => '<p>A JSON object containing the of the storage volume that was deleted</p>', 'refs' => [], ], 'DescribeBandwidthRateLimitInput' => [ 'base' => '<p>A JSON object containing the of the gateway.</p>', 'refs' => [], ], 'DescribeBandwidthRateLimitOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'DescribeCacheInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCacheOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCachediSCSIVolumesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCachediSCSIVolumesOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'DescribeChapCredentialsInput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the iSCSI volume target.</p>', 'refs' => [], ], 'DescribeChapCredentialsOutput' => [ 'base' => '<p>A JSON object containing a .</p>', 'refs' => [], ], 'DescribeGatewayInformationInput' => [ 'base' => '<p>A JSON object containing the id of the gateway.</p>', 'refs' => [], ], 'DescribeGatewayInformationOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'DescribeMaintenanceStartTimeInput' => [ 'base' => '<p>A JSON object containing the of the gateway.</p>', 'refs' => [], ], 'DescribeMaintenanceStartTimeOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p> <ul> <li> <p> <a>DescribeMaintenanceStartTimeOutput$DayOfWeek</a> </p> </li> <li> <p> <a>DescribeMaintenanceStartTimeOutput$HourOfDay</a> </p> </li> <li> <p> <a>DescribeMaintenanceStartTimeOutput$MinuteOfHour</a> </p> </li> <li> <p> <a>DescribeMaintenanceStartTimeOutput$Timezone</a> </p> </li> </ul>', 'refs' => [], ], 'DescribeNFSFileSharesInput' => [ 'base' => '<p>DescribeNFSFileSharesInput</p>', 'refs' => [], ], 'DescribeNFSFileSharesOutput' => [ 'base' => '<p>DescribeNFSFileSharesOutput</p>', 'refs' => [], ], 'DescribeSnapshotScheduleInput' => [ 'base' => '<p>A JSON object containing the <a>DescribeSnapshotScheduleInput$VolumeARN</a> of the volume.</p>', 'refs' => [], ], 'DescribeSnapshotScheduleOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStorediSCSIVolumesInput' => [ 'base' => '<p>A JSON object containing a list of <a>DescribeStorediSCSIVolumesInput$VolumeARNs</a>.</p>', 'refs' => [], ], 'DescribeStorediSCSIVolumesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTapeArchivesInput' => [ 'base' => '<p>DescribeTapeArchivesInput</p>', 'refs' => [], ], 'DescribeTapeArchivesOutput' => [ 'base' => '<p>DescribeTapeArchivesOutput</p>', 'refs' => [], ], 'DescribeTapeRecoveryPointsInput' => [ 'base' => '<p>DescribeTapeRecoveryPointsInput</p>', 'refs' => [], ], 'DescribeTapeRecoveryPointsOutput' => [ 'base' => '<p>DescribeTapeRecoveryPointsOutput</p>', 'refs' => [], ], 'DescribeTapesInput' => [ 'base' => '<p>DescribeTapesInput</p>', 'refs' => [], ], 'DescribeTapesOutput' => [ 'base' => '<p>DescribeTapesOutput</p>', 'refs' => [], ], 'DescribeUploadBufferInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUploadBufferOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVTLDevicesInput' => [ 'base' => '<p>DescribeVTLDevicesInput</p>', 'refs' => [], ], 'DescribeVTLDevicesOutput' => [ 'base' => '<p>DescribeVTLDevicesOutput</p>', 'refs' => [], ], 'DescribeWorkingStorageInput' => [ 'base' => '<p>A JSON object containing the of the gateway.</p>', 'refs' => [], ], 'DescribeWorkingStorageOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotScheduleOutput$Description' => NULL, 'UpdateSnapshotScheduleInput$Description' => '<p>Optional description of the snapshot that overwrites the existing description.</p>', ], ], 'DeviceType' => [ 'base' => NULL, 'refs' => [ 'UpdateVTLDeviceTypeInput$DeviceType' => '<p>The type of medium changer you want to select.</p> <p> Valid Values: "STK-L700", "AWS-Gateway-VTL"</p>', ], ], 'DeviceiSCSIAttributes' => [ 'base' => '<p>Lists iSCSI information about a VTL device.</p>', 'refs' => [ 'VTLDevice$DeviceiSCSIAttributes' => '<p>A list of iSCSI information about a VTL device.</p>', ], ], 'DisableGatewayInput' => [ 'base' => '<p>DisableGatewayInput</p>', 'refs' => [], ], 'DisableGatewayOutput' => [ 'base' => '<p>DisableGatewayOutput</p>', 'refs' => [], ], 'Disk' => [ 'base' => NULL, 'refs' => [ 'Disks$member' => NULL, ], ], 'DiskAllocationType' => [ 'base' => NULL, 'refs' => [ 'Disk$DiskAllocationType' => NULL, ], ], 'DiskId' => [ 'base' => NULL, 'refs' => [ 'CreateStorediSCSIVolumeInput$DiskId' => '<p>The unique identifier for the gateway local disk that is configured as a stored volume. Use <a href="http://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks</a> to list disk IDs for a gateway.</p>', 'Disk$DiskId' => NULL, 'DiskIds$member' => NULL, 'StorediSCSIVolume$VolumeDiskId' => '<p>The ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a> operation.</p>', ], ], 'DiskIds' => [ 'base' => NULL, 'refs' => [ 'AddCacheInput$DiskIds' => NULL, 'AddUploadBufferInput$DiskIds' => NULL, 'AddWorkingStorageInput$DiskIds' => '<p>An array of strings that identify disks that are to be configured as working storage. Each string have a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <a>ListLocalDisks</a> API.</p>', 'DescribeCacheOutput$DiskIds' => NULL, 'DescribeUploadBufferOutput$DiskIds' => NULL, 'DescribeWorkingStorageOutput$DiskIds' => '<p>An array of the gateway\'s local disk IDs that are configured as working storage. Each local disk ID is specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage, then the DiskIds array is empty.</p>', ], ], 'Disks' => [ 'base' => NULL, 'refs' => [ 'ListLocalDisksOutput$Disks' => NULL, ], ], 'DoubleObject' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$VolumeProgress' => '<p>Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of data transferred. This field does not appear in the response if the cached volume is not restoring or bootstrapping.</p>', 'StorediSCSIVolume$VolumeProgress' => '<p>Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of data transferred. This field does not appear in the response if the stored volume is not restoring or bootstrapping.</p>', 'Tape$Progress' => '<p>For archiving virtual tapes, indicates how much data remains to be uploaded before archiving is complete.</p> <p>Range: 0 (not started) to 100 (complete).</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'StorageGatewayError$errorCode' => '<p>Additional information about the error.</p>', ], ], 'FileShareARN' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the file share. </p>', 'refs' => [ 'CreateNFSFileShareOutput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the newly created file share. </p>', 'DeleteFileShareInput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the file share to be deleted. </p>', 'DeleteFileShareOutput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the deleted file share. </p>', 'FileShareARNList$member' => NULL, 'FileShareInfo$FileShareARN' => NULL, 'NFSFileShareInfo$FileShareARN' => NULL, 'RefreshCacheInput$FileShareARN' => NULL, 'RefreshCacheOutput$FileShareARN' => NULL, 'UpdateNFSFileShareInput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the file share to be updated. </p>', 'UpdateNFSFileShareOutput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the updated file share. </p>', ], ], 'FileShareARNList' => [ 'base' => NULL, 'refs' => [ 'DescribeNFSFileSharesInput$FileShareARNList' => '<p>An array containing the Amazon Resource Name (ARN) of each file share to be described. </p>', ], ], 'FileShareClientList' => [ 'base' => '<p>The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. </p>', 'refs' => [ 'CreateNFSFileShareInput$ClientList' => '<p>The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. </p>', 'NFSFileShareInfo$ClientList' => NULL, 'UpdateNFSFileShareInput$ClientList' => '<p>The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks.</p>', ], ], 'FileShareId' => [ 'base' => '<p>The ID of the file share. </p>', 'refs' => [ 'FileShareInfo$FileShareId' => NULL, 'NFSFileShareInfo$FileShareId' => NULL, ], ], 'FileShareInfo' => [ 'base' => '<p>Describes a file share.</p>', 'refs' => [ 'FileShareInfoList$member' => NULL, ], ], 'FileShareInfoList' => [ 'base' => NULL, 'refs' => [ 'ListFileSharesOutput$FileShareInfoList' => '<p>An array of information about the file gateway\'s file shares. </p>', ], ], 'FileShareStatus' => [ 'base' => '<p>The status of the file share. Possible values are CREATING, UPDATING, AVAILABLE and DELETING. </p>', 'refs' => [ 'FileShareInfo$FileShareStatus' => NULL, 'NFSFileShareInfo$FileShareStatus' => NULL, ], ], 'GatewayARN' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of gateways for your account and region.</p>', 'refs' => [ 'ActivateGatewayOutput$GatewayARN' => NULL, 'AddCacheInput$GatewayARN' => NULL, 'AddCacheOutput$GatewayARN' => NULL, 'AddUploadBufferInput$GatewayARN' => NULL, 'AddUploadBufferOutput$GatewayARN' => NULL, 'AddWorkingStorageInput$GatewayARN' => NULL, 'AddWorkingStorageOutput$GatewayARN' => NULL, 'CancelArchivalInput$GatewayARN' => NULL, 'CancelRetrievalInput$GatewayARN' => NULL, 'CreateCachediSCSIVolumeInput$GatewayARN' => NULL, 'CreateNFSFileShareInput$GatewayARN' => '<p>The Amazon Resource Name (ARN) of the file gateway on which you want to create a file share.</p>', 'CreateStorediSCSIVolumeInput$GatewayARN' => NULL, 'CreateTapeWithBarcodeInput$GatewayARN' => '<p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use the <a>ListGateways</a> operation to return a list of gateways for your account and region.</p>', 'CreateTapesInput$GatewayARN' => '<p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tapes with. Use the <a>ListGateways</a> operation to return a list of gateways for your account and region.</p>', 'DeleteBandwidthRateLimitInput$GatewayARN' => NULL, 'DeleteBandwidthRateLimitOutput$GatewayARN' => NULL, 'DeleteGatewayInput$GatewayARN' => NULL, 'DeleteGatewayOutput$GatewayARN' => NULL, 'DeleteTapeInput$GatewayARN' => '<p>The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is associated with. Use the <a>ListGateways</a> operation to return a list of gateways for your account and region.</p>', 'DescribeBandwidthRateLimitInput$GatewayARN' => NULL, 'DescribeBandwidthRateLimitOutput$GatewayARN' => NULL, 'DescribeCacheInput$GatewayARN' => NULL, 'DescribeCacheOutput$GatewayARN' => NULL, 'DescribeGatewayInformationInput$GatewayARN' => NULL, 'DescribeGatewayInformationOutput$GatewayARN' => NULL, 'DescribeMaintenanceStartTimeInput$GatewayARN' => NULL, 'DescribeMaintenanceStartTimeOutput$GatewayARN' => NULL, 'DescribeTapeRecoveryPointsInput$GatewayARN' => NULL, 'DescribeTapeRecoveryPointsOutput$GatewayARN' => NULL, 'DescribeTapesInput$GatewayARN' => NULL, 'DescribeUploadBufferInput$GatewayARN' => NULL, 'DescribeUploadBufferOutput$GatewayARN' => NULL, 'DescribeVTLDevicesInput$GatewayARN' => NULL, 'DescribeVTLDevicesOutput$GatewayARN' => NULL, 'DescribeWorkingStorageInput$GatewayARN' => NULL, 'DescribeWorkingStorageOutput$GatewayARN' => NULL, 'DisableGatewayInput$GatewayARN' => NULL, 'DisableGatewayOutput$GatewayARN' => '<p>The unique Amazon Resource Name of the disabled gateway.</p>', 'FileShareInfo$GatewayARN' => NULL, 'GatewayInfo$GatewayARN' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of gateways for your account and region.</p>', 'ListFileSharesInput$GatewayARN' => '<p>The Amazon resource Name (ARN) of the gateway whose file shares you want to list. If this field is not present, all file shares under your account are listed.</p>', 'ListLocalDisksInput$GatewayARN' => NULL, 'ListLocalDisksOutput$GatewayARN' => NULL, 'ListVolumeRecoveryPointsInput$GatewayARN' => NULL, 'ListVolumeRecoveryPointsOutput$GatewayARN' => NULL, 'ListVolumesInput$GatewayARN' => NULL, 'ListVolumesOutput$GatewayARN' => NULL, 'NFSFileShareInfo$GatewayARN' => NULL, 'ResetCacheInput$GatewayARN' => NULL, 'ResetCacheOutput$GatewayARN' => NULL, 'RetrieveTapeArchiveInput$GatewayARN' => '<p>The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to. Use the <a>ListGateways</a> operation to return a list of gateways for your account and region.</p> <p>You retrieve archived virtual tapes to only one gateway and the gateway must be a tape gateway.</p>', 'RetrieveTapeRecoveryPointInput$GatewayARN' => NULL, 'SetLocalConsolePasswordInput$GatewayARN' => NULL, 'SetLocalConsolePasswordOutput$GatewayARN' => NULL, 'ShutdownGatewayInput$GatewayARN' => NULL, 'ShutdownGatewayOutput$GatewayARN' => NULL, 'StartGatewayInput$GatewayARN' => NULL, 'StartGatewayOutput$GatewayARN' => NULL, 'TapeArchive$RetrievedTo' => '<p>The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being retrieved to.</p> <p>The virtual tape is retrieved from the virtual tape shelf (VTS).</p>', 'TapeInfo$GatewayARN' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of gateways for your account and region.</p>', 'UpdateBandwidthRateLimitInput$GatewayARN' => NULL, 'UpdateBandwidthRateLimitOutput$GatewayARN' => NULL, 'UpdateGatewayInformationInput$GatewayARN' => NULL, 'UpdateGatewayInformationOutput$GatewayARN' => NULL, 'UpdateGatewaySoftwareNowInput$GatewayARN' => NULL, 'UpdateGatewaySoftwareNowOutput$GatewayARN' => NULL, 'UpdateMaintenanceStartTimeInput$GatewayARN' => NULL, 'UpdateMaintenanceStartTimeOutput$GatewayARN' => NULL, 'VolumeInfo$GatewayARN' => NULL, ], ], 'GatewayId' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$GatewayId' => '<p>The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.</p>', 'GatewayInfo$GatewayId' => '<p>The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.</p>', 'VolumeInfo$GatewayId' => '<p>The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.</p> <p> Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>', ], ], 'GatewayInfo' => [ 'base' => '<p>Describes a gateway object.</p>', 'refs' => [ 'Gateways$member' => NULL, ], ], 'GatewayName' => [ 'base' => '<p>The name you configured for your gateway.</p>', 'refs' => [ 'ActivateGatewayInput$GatewayName' => '<p>The name you configured for your gateway.</p>', 'UpdateGatewayInformationInput$GatewayName' => NULL, ], ], 'GatewayNetworkInterfaces' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$GatewayNetworkInterfaces' => '<p>A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.</p>', ], ], 'GatewayOperationalState' => [ 'base' => NULL, 'refs' => [ 'GatewayInfo$GatewayOperationalState' => '<p>The state of the gateway.</p> <p>Valid Values: DISABLED or ACTIVE</p>', ], ], 'GatewayState' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$GatewayState' => '<p>A value that indicates the operating state of the gateway.</p>', ], ], 'GatewayTimezone' => [ 'base' => NULL, 'refs' => [ 'ActivateGatewayInput$GatewayTimezone' => '<p>A value that indicates the time zone you want to set for the gateway. The time zone is of the format "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is used, for example, for scheduling snapshots and your gateway\'s maintenance schedule.</p>', 'DescribeGatewayInformationOutput$GatewayTimezone' => '<p>A value that indicates the time zone configured for the gateway.</p>', 'DescribeMaintenanceStartTimeOutput$Timezone' => NULL, 'DescribeSnapshotScheduleOutput$Timezone' => NULL, 'UpdateGatewayInformationInput$GatewayTimezone' => NULL, ], ], 'GatewayType' => [ 'base' => NULL, 'refs' => [ 'ActivateGatewayInput$GatewayType' => '<p>A value that defines the type of gateway to activate. The type specified is critical to all later functions of the gateway and cannot be changed after activation. The default value is <code>STORED</code>. </p> <p> Valid Values: "STORED", "CACHED", "VTL", "FILE_S3"</p>', 'DescribeGatewayInformationOutput$GatewayType' => '<p>The type of the gateway.</p>', 'GatewayInfo$GatewayType' => '<p>The type of the gateway.</p>', ], ], 'Gateways' => [ 'base' => NULL, 'refs' => [ 'ListGatewaysOutput$Gateways' => NULL, ], ], 'HourOfDay' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceStartTimeOutput$HourOfDay' => '<p>The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>', 'DescribeSnapshotScheduleOutput$StartAt' => NULL, 'UpdateMaintenanceStartTimeInput$HourOfDay' => '<p>The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (00 to 23). The hour of the day is in the time zone of the gateway.</p>', 'UpdateSnapshotScheduleInput$StartAt' => '<p>The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>', ], ], 'IPV4AddressCIDR' => [ 'base' => NULL, 'refs' => [ 'FileShareClientList$member' => NULL, ], ], 'Initiator' => [ 'base' => NULL, 'refs' => [ 'Initiators$member' => NULL, ], ], 'Initiators' => [ 'base' => NULL, 'refs' => [ 'ListVolumeInitiatorsOutput$Initiators' => '<p>The host names and port numbers of all iSCSI initiators that are connected to the gateway.</p>', ], ], 'InternalServerError' => [ 'base' => '<p>An internal server error has occurred during the request. For more information, see the error and message fields.</p>', 'refs' => [], ], 'InvalidGatewayRequestException' => [ 'base' => '<p>An exception occurred because an invalid gateway request was issued to the service. For more information, see the error and message fields.</p>', 'refs' => [], ], 'IqnName' => [ 'base' => NULL, 'refs' => [ 'ChapInfo$InitiatorName' => '<p>The iSCSI initiator that connects to the target.</p>', 'DeleteChapCredentialsInput$InitiatorName' => '<p>The iSCSI initiator that connects to the target.</p>', 'DeleteChapCredentialsOutput$InitiatorName' => '<p>The iSCSI initiator that connects to the target.</p>', 'UpdateChapCredentialsInput$InitiatorName' => '<p>The iSCSI initiator that connects to the target.</p>', 'UpdateChapCredentialsOutput$InitiatorName' => '<p>The iSCSI initiator that connects to the target. This is the same initiator name specified in the request.</p>', ], ], 'KMSKey' => [ 'base' => '<p>The ARN of the KMS key used for Amazon S3 server side encryption. </p>', 'refs' => [ 'CreateNFSFileShareInput$KMSKey' => '<p>The KMS key used for Amazon S3 server side encryption. This value can only be set when KmsEncrypted is true. Optional.</p>', 'NFSFileShareInfo$KMSKey' => NULL, 'UpdateNFSFileShareInput$KMSKey' => '<p>The KMS key used for Amazon S3 server side encryption. This value can only be set when KmsEncrypted is true. Optional. </p>', ], ], 'LastSoftwareUpdate' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$LastSoftwareUpdate' => '<p>The date on which the last software update was applied to the gateway. If the gateway has never been updated, this field does not return a value in the response.</p>', ], ], 'ListFileSharesInput' => [ 'base' => '<p>ListFileShareInput</p>', 'refs' => [], ], 'ListFileSharesOutput' => [ 'base' => '<p>ListFileShareOutput</p>', 'refs' => [], ], 'ListGatewaysInput' => [ 'base' => '<p>A JSON object containing zero or more of the following fields:</p> <ul> <li> <p> <a>ListGatewaysInput$Limit</a> </p> </li> <li> <p> <a>ListGatewaysInput$Marker</a> </p> </li> </ul>', 'refs' => [], ], 'ListGatewaysOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListLocalDisksInput' => [ 'base' => '<p>A JSON object containing the of the gateway.</p>', 'refs' => [], ], 'ListLocalDisksOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => '<p>ListTagsForResourceInput</p>', 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => '<p>ListTagsForResourceOutput</p>', 'refs' => [], ], 'ListTapesInput' => [ 'base' => '<p>A JSON object that contains one or more of the following fields:</p> <ul> <li> <p> <a>ListTapesInput$Limit</a> </p> </li> <li> <p> <a>ListTapesInput$Marker</a> </p> </li> <li> <p> <a>ListTapesInput$TapeARNs</a> </p> </li> </ul>', 'refs' => [], ], 'ListTapesOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p> <ul> <li> <p> <a>ListTapesOutput$Marker</a> </p> </li> <li> <p> <a>ListTapesOutput$VolumeInfos</a> </p> </li> </ul>', 'refs' => [], ], 'ListVolumeInitiatorsInput' => [ 'base' => '<p>ListVolumeInitiatorsInput</p>', 'refs' => [], ], 'ListVolumeInitiatorsOutput' => [ 'base' => '<p>ListVolumeInitiatorsOutput</p>', 'refs' => [], ], 'ListVolumeRecoveryPointsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListVolumeRecoveryPointsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListVolumesInput' => [ 'base' => '<p>A JSON object that contains one or more of the following fields:</p> <ul> <li> <p> <a>ListVolumesInput$Limit</a> </p> </li> <li> <p> <a>ListVolumesInput$Marker</a> </p> </li> </ul>', 'refs' => [], ], 'ListVolumesOutput' => [ 'base' => NULL, 'refs' => [], ], 'LocalConsolePassword' => [ 'base' => NULL, 'refs' => [ 'SetLocalConsolePasswordInput$LocalConsolePassword' => '<p>The password you want to set for your VM local console.</p>', ], ], 'LocationARN' => [ 'base' => '<p>The ARN of the backend storage used for storing file data. </p>', 'refs' => [ 'CreateNFSFileShareInput$LocationARN' => '<p>The ARN of the backed storage used for storing file data. </p>', 'NFSFileShareInfo$LocationARN' => NULL, ], ], 'Marker' => [ 'base' => NULL, 'refs' => [ 'DescribeTapeArchivesInput$Marker' => '<p>An opaque string that indicates the position at which to begin describing virtual tapes.</p>', 'DescribeTapeArchivesOutput$Marker' => '<p>An opaque string that indicates the position at which the virtual tapes that were fetched for description ended. Use this marker in your next request to fetch the next set of virtual tapes in the virtual tape shelf (VTS). If there are no more virtual tapes to describe, this field does not appear in the response.</p>', 'DescribeTapeRecoveryPointsInput$Marker' => '<p>An opaque string that indicates the position at which to begin describing the virtual tape recovery points.</p>', 'DescribeTapeRecoveryPointsOutput$Marker' => '<p>An opaque string that indicates the position at which the virtual tape recovery points that were listed for description ended.</p> <p>Use this marker in your next request to list the next set of virtual tape recovery points in the list. If there are no more recovery points to describe, this field does not appear in the response.</p>', 'DescribeTapesInput$Marker' => '<p>A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker indicates which page of results to retrieve. </p> <p>If not specified, the first page of results is retrieved.</p>', 'DescribeTapesOutput$Marker' => '<p>An opaque string which can be used as part of a subsequent DescribeTapes call to retrieve the next page of results.</p> <p>If a response does not contain a marker, then there are no more results to be retrieved.</p>', 'DescribeVTLDevicesInput$Marker' => '<p>An opaque string that indicates the position at which to begin describing the VTL devices.</p>', 'DescribeVTLDevicesOutput$Marker' => '<p>An opaque string that indicates the position at which the VTL devices that were fetched for description ended. Use the marker in your next request to fetch the next set of VTL devices in the list. If there are no more VTL devices to describe, this field does not appear in the response.</p>', 'ListFileSharesInput$Marker' => '<p>Opaque pagination token returned from a previous ListFileShares operation. If present, <code>Marker</code> specifies where to continue the list from after a previous call to ListFileShares. Optional.</p>', 'ListFileSharesOutput$Marker' => '<p>If the request includes <code>Marker</code>, the response returns that value in this field. </p>', 'ListFileSharesOutput$NextMarker' => '<p>If a value is present, there are more file shares to return. In a subsequent request, use <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file shares. </p>', 'ListGatewaysInput$Marker' => '<p>An opaque string that indicates the position at which to begin the returned list of gateways.</p>', 'ListGatewaysOutput$Marker' => NULL, 'ListTagsForResourceInput$Marker' => '<p>An opaque string that indicates the position at which to begin returning the list of tags.</p>', 'ListTagsForResourceOutput$Marker' => '<p>An opaque string that indicates the position at which to stop returning the list of tags.</p>', 'ListTapesInput$Marker' => '<p>A string that indicates the position at which to begin the returned list of tapes.</p>', 'ListTapesOutput$Marker' => '<p>A string that indicates the position at which to begin returning the next list of tapes. Use the marker in your next request to continue pagination of tapes. If there are no more tapes to list, this element does not appear in the response body.</p>', 'ListVolumesInput$Marker' => '<p>A string that indicates the position at which to begin the returned list of volumes. Obtain the marker from the response of a previous List iSCSI Volumes request.</p>', 'ListVolumesOutput$Marker' => NULL, ], ], 'MediumChangerType' => [ 'base' => NULL, 'refs' => [ 'ActivateGatewayInput$MediumChangerType' => '<p>The value that indicates the type of medium changer to use for tape gateway. This field is optional.</p> <p> Valid Values: "STK-L700", "AWS-Gateway-VTL"</p>', ], ], 'MinuteOfHour' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceStartTimeOutput$MinuteOfHour' => '<p>The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (0 to 59). The minute of the hour is in the time zone of the gateway.</p>', 'UpdateMaintenanceStartTimeInput$MinuteOfHour' => '<p>The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (00 to 59). The minute of the hour is in the time zone of the gateway.</p>', ], ], 'NFSFileShareDefaults' => [ 'base' => '<p>Describes file share default values. Files and folders stored as Amazon S3 objects in S3 buckets don\'t, by default, have Unix file permissions assigned to them. Upon discovery in an S3 bucket by Storage Gateway, the S3 objects that represent files and folders are assigned these default Unix permissions. This operation is only supported in the file gateway architecture.</p>', 'refs' => [ 'CreateNFSFileShareInput$NFSFileShareDefaults' => '<p>File share default values. Optional.</p>', 'NFSFileShareInfo$NFSFileShareDefaults' => NULL, 'UpdateNFSFileShareInput$NFSFileShareDefaults' => '<p>The default values for the file share. Optional.</p>', ], ], 'NFSFileShareInfo' => [ 'base' => '<p>The Unix file permissions and ownership information assigned, by default, to native S3 objects when file gateway discovers them in S3 buckets. This operation is only supported in file gateways.</p>', 'refs' => [ 'NFSFileShareInfoList$member' => NULL, ], ], 'NFSFileShareInfoList' => [ 'base' => NULL, 'refs' => [ 'DescribeNFSFileSharesOutput$NFSFileShareInfoList' => '<p>An array containing a description for each requested file share. </p>', ], ], 'NetworkInterface' => [ 'base' => '<p>Describes a gateway\'s network interface.</p>', 'refs' => [ 'GatewayNetworkInterfaces$member' => NULL, ], ], 'NetworkInterfaceId' => [ 'base' => NULL, 'refs' => [ 'CreateCachediSCSIVolumeInput$NetworkInterfaceId' => NULL, 'CreateStorediSCSIVolumeInput$NetworkInterfaceId' => '<p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a gateway.</p> <p> Valid Values: A valid IP address.</p>', 'DeviceiSCSIAttributes$NetworkInterfaceId' => '<p>The network interface identifier of the VTL device.</p>', 'VolumeiSCSIAttributes$NetworkInterfaceId' => '<p>The network interface identifier.</p>', ], ], 'NextUpdateAvailabilityDate' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$NextUpdateAvailabilityDate' => '<p>The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the gateway is not available for an update this field is not returned in the response.</p>', ], ], 'NumTapesToCreate' => [ 'base' => NULL, 'refs' => [ 'CreateTapesInput$NumTapesToCreate' => '<p>The number of virtual tapes that you want to create.</p>', ], ], 'Path' => [ 'base' => '<p>The file share path used by the NFS client to identify the mount point. </p>', 'refs' => [ 'NFSFileShareInfo$Path' => NULL, ], ], 'PermissionId' => [ 'base' => NULL, 'refs' => [ 'NFSFileShareDefaults$GroupId' => '<p>The default group ID for the file share (unless the files have another group ID specified). The default value is nfsnobody. </p>', 'NFSFileShareDefaults$OwnerId' => '<p>The default owner ID for files in the file share (unless the files have another owner ID specified). The default value is nfsnobody. </p>', ], ], 'PermissionMode' => [ 'base' => NULL, 'refs' => [ 'NFSFileShareDefaults$FileMode' => '<p>The Unix file mode in the form "nnnn". For example, "0666" represents the default file mode inside the file share. The default value is 0666. </p>', 'NFSFileShareDefaults$DirectoryMode' => '<p>The Unix directory mode in the form "nnnn". For example, "0666" represents the default access mode for all directories inside the file share. The default value is 0777.</p>', ], ], 'PositiveIntObject' => [ 'base' => NULL, 'refs' => [ 'DescribeTapeArchivesInput$Limit' => '<p>Specifies that the number of virtual tapes descried be limited to the specified number.</p>', 'DescribeTapeRecoveryPointsInput$Limit' => '<p>Specifies that the number of virtual tape recovery points that are described be limited to the specified number.</p>', 'DescribeTapesInput$Limit' => '<p>Specifies that the number of virtual tapes described be limited to the specified number.</p> <note> <p>Amazon Web Services may impose its own limit, if this field is not set.</p> </note>', 'DescribeVTLDevicesInput$Limit' => '<p>Specifies that the number of VTL devices described be limited to the specified number.</p>', 'ListFileSharesInput$Limit' => '<p>The maximum number of file shares to return in the response. The value must be an integer with a value greater than zero. Optional.</p>', 'ListGatewaysInput$Limit' => '<p>Specifies that the list of gateways returned be limited to the specified number of items.</p>', 'ListTagsForResourceInput$Limit' => '<p>Specifies that the list of tags returned be limited to the specified number of items.</p>', 'ListTapesInput$Limit' => '<p>An optional number limit for the tapes in the list returned by this call.</p>', 'ListVolumesInput$Limit' => '<p>Specifies that the list of volumes returned be limited to the specified number of items.</p>', 'VolumeiSCSIAttributes$LunNumber' => '<p>The logical disk number.</p>', ], ], 'RecurrenceInHours' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotScheduleOutput$RecurrenceInHours' => NULL, 'UpdateSnapshotScheduleInput$RecurrenceInHours' => '<p>Frequency of snapshots. Specify the number of hours between snapshots.</p>', ], ], 'RefreshCacheInput' => [ 'base' => NULL, 'refs' => [], ], 'RefreshCacheOutput' => [ 'base' => NULL, 'refs' => [], ], 'RegionId' => [ 'base' => NULL, 'refs' => [ 'ActivateGatewayInput$GatewayRegion' => '<p>A value that indicates the region where you want to store your data. The gateway region specified must be the same region as the region in your <code>Host</code> header in the request. For more information about available regions and endpoints for AWS Storage Gateway, see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#sg_region">Regions and Endpoints</a> in the <i>Amazon Web Services Glossary</i>.</p> <p> Valid Values: "us-east-1", "us-east-2", "us-west-1", "us-west-2", "ca-central-1", "eu-west-1", "eu-central-1", "eu-west-2", "ap-northeast-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-south-1", "sa-east-1"</p>', ], ], 'RemoveTagsFromResourceInput' => [ 'base' => '<p>RemoveTagsFromResourceInput</p>', 'refs' => [], ], 'RemoveTagsFromResourceOutput' => [ 'base' => '<p>RemoveTagsFromResourceOutput</p>', 'refs' => [], ], 'ResetCacheInput' => [ 'base' => NULL, 'refs' => [], ], 'ResetCacheOutput' => [ 'base' => NULL, 'refs' => [], ], 'ResourceARN' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>', 'AddTagsToResourceOutput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>', 'ListTagsForResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>', 'ListTagsForResourceOutput$ResourceARN' => '<p>he Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>', 'RemoveTagsFromResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource you want to remove the tags from.</p>', 'RemoveTagsFromResourceOutput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource that the tags were removed from.</p>', ], ], 'RetrieveTapeArchiveInput' => [ 'base' => '<p>RetrieveTapeArchiveInput</p>', 'refs' => [], ], 'RetrieveTapeArchiveOutput' => [ 'base' => '<p>RetrieveTapeArchiveOutput</p>', 'refs' => [], ], 'RetrieveTapeRecoveryPointInput' => [ 'base' => '<p>RetrieveTapeRecoveryPointInput</p>', 'refs' => [], ], 'RetrieveTapeRecoveryPointOutput' => [ 'base' => '<p>RetrieveTapeRecoveryPointOutput</p>', 'refs' => [], ], 'Role' => [ 'base' => '<p>The ARN of the IAM role that file gateway assumes when it accesses the underlying storage. </p>', 'refs' => [ 'CreateNFSFileShareInput$Role' => '<p>The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage. </p>', 'NFSFileShareInfo$Role' => NULL, ], ], 'ServiceUnavailableError' => [ 'base' => '<p>An internal server error has occurred because the service is unavailable. For more information, see the error and message fields.</p>', 'refs' => [], ], 'SetLocalConsolePasswordInput' => [ 'base' => '<p>SetLocalConsolePasswordInput</p>', 'refs' => [], ], 'SetLocalConsolePasswordOutput' => [ 'base' => NULL, 'refs' => [], ], 'ShutdownGatewayInput' => [ 'base' => '<p>A JSON object containing the of the gateway to shut down.</p>', 'refs' => [], ], 'ShutdownGatewayOutput' => [ 'base' => '<p>A JSON object containing the of the gateway that was shut down.</p>', 'refs' => [], ], 'SnapshotDescription' => [ 'base' => NULL, 'refs' => [ 'CreateSnapshotFromVolumeRecoveryPointInput$SnapshotDescription' => NULL, 'CreateSnapshotInput$SnapshotDescription' => '<p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic Block Store snapshots panel in the <b>Description</b> field, and in the AWS Storage Gateway snapshot <b>Details</b> pane, <b>Description</b> field</p>', ], ], 'SnapshotId' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$SourceSnapshotId' => '<p>If the cached volume was created from a snapshot, this field contains the snapshot ID used, e.g. snap-78e22663. Otherwise, this field is not included.</p>', 'CreateCachediSCSIVolumeInput$SnapshotId' => NULL, 'CreateSnapshotFromVolumeRecoveryPointOutput$SnapshotId' => NULL, 'CreateSnapshotOutput$SnapshotId' => '<p>The snapshot ID that is used to refer to the snapshot in future operations such as describing snapshots (Amazon Elastic Compute Cloud API <code>DescribeSnapshots</code>) or creating a volume from a snapshot (<a>CreateStorediSCSIVolume</a>).</p>', 'CreateStorediSCSIVolumeInput$SnapshotId' => '<p>The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new stored volume. Specify this field if you want to create the iSCSI storage volume from a snapshot otherwise do not include this field. To list snapshots for your account use <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>', 'StorediSCSIVolume$SourceSnapshotId' => '<p>If the stored volume was created from a snapshot, this field contains the snapshot ID used, e.g. snap-78e22663. Otherwise, this field is not included.</p>', ], ], 'Squash' => [ 'base' => '<p>The user mapped to anonymous user. Valid options are the following: </p> <ul> <li> <p>"RootSquash" - Only root is mapped to anonymous user.</p> </li> <li> <p>"NoSquash" - No one is mapped to anonymous user</p> </li> <li> <p>"AllSquash" - Everyone is mapped to anonymous user.</p> </li> </ul>', 'refs' => [ 'CreateNFSFileShareInput$Squash' => '<p>Maps a user to anonymous user. Valid options are the following: </p> <ul> <li> <p>"RootSquash" - Only root is mapped to anonymous user.</p> </li> <li> <p>"NoSquash" - No one is mapped to anonymous user.</p> </li> <li> <p>"AllSquash" - Everyone is mapped to anonymous user.</p> </li> </ul>', 'NFSFileShareInfo$Squash' => NULL, 'UpdateNFSFileShareInput$Squash' => '<p>The user mapped to anonymous user. Valid options are the following:</p> <ul> <li> <p>"RootSquash" - Only root is mapped to anonymous user.</p> </li> <li> <p>"NoSquash" - No one is mapped to anonymous user</p> </li> <li> <p>"AllSquash" - Everyone is mapped to anonymous user.</p> </li> </ul>', ], ], 'StartGatewayInput' => [ 'base' => '<p>A JSON object containing the of the gateway to start.</p>', 'refs' => [], ], 'StartGatewayOutput' => [ 'base' => '<p>A JSON object containing the of the gateway that was restarted.</p>', 'refs' => [], ], 'StorageClass' => [ 'base' => '<p/>', 'refs' => [ 'CreateNFSFileShareInput$DefaultStorageClass' => '<p>The default storage class for objects put into an Amazon S3 bucket by file gateway. Possible values are S3_STANDARD or S3_STANDARD_IA. If this field is not populated, the default value S3_STANDARD is used. Optional.</p>', 'NFSFileShareInfo$DefaultStorageClass' => '<p>The default storage class for objects put into an Amazon S3 bucket by file gateway. Possible values are S3_STANDARD or S3_STANDARD_IA. If this field is not populated, the default value S3_STANDARD is used. Optional.</p>', 'UpdateNFSFileShareInput$DefaultStorageClass' => '<p>The default storage class for objects put into an Amazon S3 bucket by a file gateway. Possible values are S3_STANDARD or S3_STANDARD_IA. If this field is not populated, the default value S3_STANDARD is used. Optional.</p>', ], ], 'StorageGatewayError' => [ 'base' => '<p>Provides additional information about an error that was returned by the service as an or. See the <code>errorCode</code> and <code>errorDetails</code> members for more information about the error.</p>', 'refs' => [ 'InternalServerError$error' => '<p>A <a>StorageGatewayError</a> that provides more information about the cause of the error.</p>', 'InvalidGatewayRequestException$error' => '<p>A <a>StorageGatewayError</a> that provides more detail about the cause of the error.</p>', 'ServiceUnavailableError$error' => '<p>A <a>StorageGatewayError</a> that provides more information about the cause of the error.</p>', ], ], 'StorediSCSIVolume' => [ 'base' => '<p>Describes an iSCSI stored volume.</p>', 'refs' => [ 'StorediSCSIVolumes$member' => NULL, ], ], 'StorediSCSIVolumes' => [ 'base' => NULL, 'refs' => [ 'DescribeStorediSCSIVolumesOutput$StorediSCSIVolumes' => NULL, ], ], 'Tag' => [ 'base' => NULL, 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => NULL, 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsFromResourceInput$TagKeys' => '<p>The keys of the tags you want to remove from the specified resource. A tag is composed of a key/value pair.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceInput$Tags' => '<p>The key-value pair that represents the tag you want to add to the resource. The value can be an empty string.</p> <note> <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @.</p> </note>', 'ListTagsForResourceOutput$Tags' => '<p>An array that contains the tags for the specified resource.</p>', ], ], 'Tape' => [ 'base' => '<p>Describes a virtual tape object.</p>', 'refs' => [ 'Tapes$member' => NULL, ], ], 'TapeARN' => [ 'base' => NULL, 'refs' => [ 'CancelArchivalInput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel archiving for.</p>', 'CancelArchivalOutput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape for which archiving was canceled.</p>', 'CancelRetrievalInput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel retrieval for.</p>', 'CancelRetrievalOutput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape for which retrieval was canceled.</p>', 'CreateTapeWithBarcodeOutput$TapeARN' => '<p>A unique Amazon Resource Name (ARN) that represents the virtual tape that was created.</p>', 'DeleteTapeArchiveInput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf (VTS).</p>', 'DeleteTapeArchiveOutput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape that was deleted from the virtual tape shelf (VTS).</p>', 'DeleteTapeInput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape to delete.</p>', 'DeleteTapeOutput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the deleted virtual tape.</p>', 'RetrieveTapeArchiveInput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual tape shelf (VTS).</p>', 'RetrieveTapeArchiveOutput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the retrieved virtual tape.</p>', 'RetrieveTapeRecoveryPointInput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape for which you want to retrieve the recovery point.</p>', 'RetrieveTapeRecoveryPointOutput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape for which the recovery point was retrieved.</p>', 'Tape$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape.</p>', 'TapeARNs$member' => NULL, 'TapeArchive$TapeARN' => '<p>The Amazon Resource Name (ARN) of an archived virtual tape.</p>', 'TapeInfo$TapeARN' => '<p>The Amazon Resource Name (ARN) of a virtual tape.</p>', 'TapeRecoveryPointInfo$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape.</p>', ], ], 'TapeARNs' => [ 'base' => '<p>The Amazon Resource Name (ARN) of each of the tapes you want to list. If you don\'t specify a tape ARN, the response lists all tapes in both your VTL and VTS.</p>', 'refs' => [ 'CreateTapesOutput$TapeARNs' => '<p>A list of unique Amazon Resource Names (ARNs) that represents the virtual tapes that were created.</p>', 'DescribeTapeArchivesInput$TapeARNs' => '<p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe.</p>', 'DescribeTapesInput$TapeARNs' => '<p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe. If this parameter is not specified, Tape gateway returns a description of all virtual tapes associated with the specified gateway.</p>', 'ListTapesInput$TapeARNs' => NULL, ], ], 'TapeArchive' => [ 'base' => '<p>Represents a virtual tape that is archived in the virtual tape shelf (VTS).</p>', 'refs' => [ 'TapeArchives$member' => NULL, ], ], 'TapeArchiveStatus' => [ 'base' => NULL, 'refs' => [ 'TapeArchive$TapeStatus' => '<p>The current state of the archived virtual tape.</p>', ], ], 'TapeArchives' => [ 'base' => NULL, 'refs' => [ 'DescribeTapeArchivesOutput$TapeArchives' => '<p>An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the Amazon Resource Name(ARN) of the virtual tapes. The information returned includes the Amazon Resource Names (ARNs) of the tapes, size of the tapes, status of the tapes, progress of the description and tape barcode.</p>', ], ], 'TapeBarcode' => [ 'base' => NULL, 'refs' => [ 'CreateTapeWithBarcodeInput$TapeBarcode' => '<p>The barcode that you want to assign to the tape.</p> <note> <p>Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.</p> </note>', 'Tape$TapeBarcode' => '<p>The barcode that identifies a specific virtual tape.</p>', 'TapeArchive$TapeBarcode' => '<p>The barcode that identifies the archived virtual tape.</p>', 'TapeInfo$TapeBarcode' => '<p>The barcode that identifies a specific virtual tape.</p>', ], ], 'TapeBarcodePrefix' => [ 'base' => NULL, 'refs' => [ 'CreateTapesInput$TapeBarcodePrefix' => '<p>A prefix that you append to the barcode of the virtual tape you are creating. This prefix makes the barcode unique.</p> <note> <p>The prefix must be 1 to 4 characters in length and must be one of the uppercase letters from A to Z.</p> </note>', ], ], 'TapeDriveType' => [ 'base' => NULL, 'refs' => [ 'ActivateGatewayInput$TapeDriveType' => '<p>The value that indicates the type of tape drive to use for tape gateway. This field is optional.</p> <p> Valid Values: "IBM-ULT3580-TD5" </p>', ], ], 'TapeInfo' => [ 'base' => '<p>Describes a virtual tape.</p>', 'refs' => [ 'TapeInfos$member' => NULL, ], ], 'TapeInfos' => [ 'base' => '<p>An array of <a>TapeInfo</a> objects, where each object describes an a single tape. If there not tapes in the tape library or VTS, then the <code>TapeInfos</code> is an empty array.</p>', 'refs' => [ 'ListTapesOutput$TapeInfos' => NULL, ], ], 'TapeRecoveryPointInfo' => [ 'base' => '<p>Describes a recovery point.</p>', 'refs' => [ 'TapeRecoveryPointInfos$member' => NULL, ], ], 'TapeRecoveryPointInfos' => [ 'base' => NULL, 'refs' => [ 'DescribeTapeRecoveryPointsOutput$TapeRecoveryPointInfos' => '<p>An array of TapeRecoveryPointInfos that are available for the specified gateway.</p>', ], ], 'TapeRecoveryPointStatus' => [ 'base' => NULL, 'refs' => [ 'TapeRecoveryPointInfo$TapeStatus' => NULL, ], ], 'TapeSize' => [ 'base' => NULL, 'refs' => [ 'CreateTapeWithBarcodeInput$TapeSizeInBytes' => '<p>The size, in bytes, of the virtual tape that you want to create.</p> <note> <p>The size must be aligned by gigabyte (1024*1024*1024 byte).</p> </note>', 'CreateTapesInput$TapeSizeInBytes' => '<p>The size, in bytes, of the virtual tapes that you want to create.</p> <note> <p>The size must be aligned by gigabyte (1024*1024*1024 byte).</p> </note>', 'Tape$TapeSizeInBytes' => '<p>The size, in bytes, of the virtual tape capacity.</p>', 'TapeArchive$TapeSizeInBytes' => '<p>The size, in bytes, of the archived virtual tape.</p>', 'TapeInfo$TapeSizeInBytes' => '<p>The size, in bytes, of a virtual tape.</p>', 'TapeRecoveryPointInfo$TapeSizeInBytes' => '<p>The size, in bytes, of the virtual tapes to recover.</p>', ], ], 'TapeStatus' => [ 'base' => NULL, 'refs' => [ 'Tape$TapeStatus' => '<p>The current state of the virtual tape.</p>', 'TapeInfo$TapeStatus' => '<p>The status of the tape.</p>', ], ], 'TapeUsage' => [ 'base' => NULL, 'refs' => [ 'Tape$TapeUsedInBytes' => '<p>The size, in bytes, of data written to the virtual tape.</p> <note> <p>This value is not available for tapes created prior to May 13, 2015.</p> </note>', 'TapeArchive$TapeUsedInBytes' => '<p>The size, in bytes, of data written to the virtual tape.</p> <note> <p>This value is not available for tapes created prior to May 13, 2015.</p> </note>', ], ], 'Tapes' => [ 'base' => NULL, 'refs' => [ 'DescribeTapesOutput$Tapes' => '<p>An array of virtual tape descriptions.</p>', ], ], 'TargetARN' => [ 'base' => NULL, 'refs' => [ 'ChapInfo$TargetARN' => '<p>The Amazon Resource Name (ARN) of the volume.</p> <p> Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>', 'CreateCachediSCSIVolumeOutput$TargetARN' => NULL, 'CreateStorediSCSIVolumeOutput$TargetARN' => '<p>he Amazon Resource Name (ARN) of the volume target that includes the iSCSI name that initiators can use to connect to the target.</p>', 'DeleteChapCredentialsInput$TargetARN' => '<p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for specified VolumeARN.</p>', 'DeleteChapCredentialsOutput$TargetARN' => '<p>The Amazon Resource Name (ARN) of the target.</p>', 'DescribeChapCredentialsInput$TargetARN' => '<p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for specified VolumeARN.</p>', 'DeviceiSCSIAttributes$TargetARN' => '<p>Specifies the unique Amazon Resource Name(ARN) that encodes the iSCSI qualified name(iqn) of a tape drive or media changer target.</p>', 'UpdateChapCredentialsInput$TargetARN' => '<p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return the TargetARN for specified VolumeARN.</p>', 'UpdateChapCredentialsOutput$TargetARN' => '<p>The Amazon Resource Name (ARN) of the target. This is the same target specified in the request.</p>', 'VolumeiSCSIAttributes$TargetARN' => '<p>The Amazon Resource Name (ARN) of the volume target.</p>', ], ], 'TargetName' => [ 'base' => NULL, 'refs' => [ 'CreateCachediSCSIVolumeInput$TargetName' => NULL, 'CreateStorediSCSIVolumeInput$TargetName' => '<p>The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume. The target name must be unique across all volumes of a gateway.</p>', ], ], 'Time' => [ 'base' => NULL, 'refs' => [ 'Tape$TapeCreatedDate' => '<p>The date the virtual tape was created.</p>', 'TapeArchive$TapeCreatedDate' => NULL, 'TapeArchive$CompletionTime' => '<p>The time that the archiving of the virtual tape was completed.</p> <p>The string format of the completion time is in the ISO8601 extended YYYY-MM-DD\'T\'HH:MM:SS\'Z\' format.</p>', 'TapeRecoveryPointInfo$TapeRecoveryPointTime' => '<p>The time when the point-in-time view of the virtual tape was replicated for later recovery.</p> <p>The string format of the tape recovery point time is in the ISO8601 extended YYYY-MM-DD\'T\'HH:MM:SS\'Z\' format.</p>', ], ], 'UpdateBandwidthRateLimitInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>UpdateBandwidthRateLimitInput$AverageDownloadRateLimitInBitsPerSec</a> </p> </li> <li> <p> <a>UpdateBandwidthRateLimitInput$AverageUploadRateLimitInBitsPerSec</a> </p> </li> </ul>', 'refs' => [], ], 'UpdateBandwidthRateLimitOutput' => [ 'base' => '<p>A JSON object containing the of the gateway whose throttle information was updated.</p>', 'refs' => [], ], 'UpdateChapCredentialsInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>UpdateChapCredentialsInput$InitiatorName</a> </p> </li> <li> <p> <a>UpdateChapCredentialsInput$SecretToAuthenticateInitiator</a> </p> </li> <li> <p> <a>UpdateChapCredentialsInput$SecretToAuthenticateTarget</a> </p> </li> <li> <p> <a>UpdateChapCredentialsInput$TargetARN</a> </p> </li> </ul>', 'refs' => [], ], 'UpdateChapCredentialsOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'UpdateGatewayInformationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGatewayInformationOutput' => [ 'base' => '<p>A JSON object containing the ARN of the gateway that was updated.</p>', 'refs' => [], ], 'UpdateGatewaySoftwareNowInput' => [ 'base' => '<p>A JSON object containing the of the gateway to update.</p>', 'refs' => [], ], 'UpdateGatewaySoftwareNowOutput' => [ 'base' => '<p>A JSON object containing the of the gateway that was updated.</p>', 'refs' => [], ], 'UpdateMaintenanceStartTimeInput' => [ 'base' => '<p>A JSON object containing the following fields:</p> <ul> <li> <p> <a>UpdateMaintenanceStartTimeInput$DayOfWeek</a> </p> </li> <li> <p> <a>UpdateMaintenanceStartTimeInput$HourOfDay</a> </p> </li> <li> <p> <a>UpdateMaintenanceStartTimeInput$MinuteOfHour</a> </p> </li> </ul>', 'refs' => [], ], 'UpdateMaintenanceStartTimeOutput' => [ 'base' => '<p>A JSON object containing the of the gateway whose maintenance start time is updated.</p>', 'refs' => [], ], 'UpdateNFSFileShareInput' => [ 'base' => '<p>UpdateNFSFileShareInput</p>', 'refs' => [], ], 'UpdateNFSFileShareOutput' => [ 'base' => '<p>UpdateNFSFileShareOutput</p>', 'refs' => [], ], 'UpdateSnapshotScheduleInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>UpdateSnapshotScheduleInput$Description</a> </p> </li> <li> <p> <a>UpdateSnapshotScheduleInput$RecurrenceInHours</a> </p> </li> <li> <p> <a>UpdateSnapshotScheduleInput$StartAt</a> </p> </li> <li> <p> <a>UpdateSnapshotScheduleInput$VolumeARN</a> </p> </li> </ul>', 'refs' => [], ], 'UpdateSnapshotScheduleOutput' => [ 'base' => '<p>A JSON object containing the of the updated storage volume.</p>', 'refs' => [], ], 'UpdateVTLDeviceTypeInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVTLDeviceTypeOutput' => [ 'base' => '<p>UpdateVTLDeviceTypeOutput</p>', 'refs' => [], ], 'VTLDevice' => [ 'base' => '<p>Represents a device object associated with a tape gateway.</p>', 'refs' => [ 'VTLDevices$member' => NULL, ], ], 'VTLDeviceARN' => [ 'base' => NULL, 'refs' => [ 'Tape$VTLDevice' => '<p>The virtual tape library (VTL) device that the virtual tape is associated with.</p>', 'UpdateVTLDeviceTypeInput$VTLDeviceARN' => '<p>The Amazon Resource Name (ARN) of the medium changer you want to select.</p>', 'UpdateVTLDeviceTypeOutput$VTLDeviceARN' => '<p>The Amazon Resource Name (ARN) of the medium changer you have selected.</p>', 'VTLDevice$VTLDeviceARN' => '<p>Specifies the unique Amazon Resource Name (ARN) of the device (tape drive or media changer).</p>', 'VTLDeviceARNs$member' => NULL, ], ], 'VTLDeviceARNs' => [ 'base' => NULL, 'refs' => [ 'DescribeVTLDevicesInput$VTLDeviceARNs' => '<p>An array of strings, where each string represents the Amazon Resource Name (ARN) of a VTL device.</p> <note> <p>All of the specified VTL devices must be from the same gateway. If no VTL devices are specified, the result will contain all devices on the specified gateway.</p> </note>', ], ], 'VTLDeviceProductIdentifier' => [ 'base' => NULL, 'refs' => [ 'VTLDevice$VTLDeviceProductIdentifier' => NULL, ], ], 'VTLDeviceType' => [ 'base' => NULL, 'refs' => [ 'VTLDevice$VTLDeviceType' => NULL, ], ], 'VTLDeviceVendor' => [ 'base' => NULL, 'refs' => [ 'VTLDevice$VTLDeviceVendor' => NULL, ], ], 'VTLDevices' => [ 'base' => NULL, 'refs' => [ 'DescribeVTLDevicesOutput$VTLDevices' => '<p>An array of VTL device objects composed of the Amazon Resource Name(ARN) of the VTL devices.</p>', ], ], 'VolumeARN' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the storage volume.</p>', 'CreateCachediSCSIVolumeInput$SourceVolumeARN' => '<p>The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume\'s latest recovery point. The <code>VolumeSizeInBytes</code> value for this new volume must be equal to or larger than the size of the existing volume, in bytes.</p>', 'CreateCachediSCSIVolumeOutput$VolumeARN' => NULL, 'CreateSnapshotFromVolumeRecoveryPointInput$VolumeARN' => NULL, 'CreateSnapshotFromVolumeRecoveryPointOutput$VolumeARN' => NULL, 'CreateSnapshotInput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of gateway volumes.</p>', 'CreateSnapshotOutput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume of which the snapshot was taken.</p>', 'CreateStorediSCSIVolumeOutput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the configured volume.</p>', 'DeleteSnapshotScheduleInput$VolumeARN' => NULL, 'DeleteSnapshotScheduleOutput$VolumeARN' => NULL, 'DeleteVolumeInput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of gateway volumes.</p>', 'DeleteVolumeOutput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the storage volume that was deleted. It is the same ARN you provided in the request.</p>', 'DescribeSnapshotScheduleInput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of gateway volumes.</p>', 'DescribeSnapshotScheduleOutput$VolumeARN' => NULL, 'ListVolumeInitiatorsInput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of gateway volumes for the gateway.</p>', 'StorediSCSIVolume$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the storage volume.</p>', 'UpdateSnapshotScheduleInput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of gateway volumes.</p>', 'UpdateSnapshotScheduleOutput$VolumeARN' => '<p/>', 'VolumeARNs$member' => NULL, 'VolumeInfo$VolumeARN' => '<p>The Amazon Resource Name (ARN) for the storage volume. For example, the following is a valid ARN:</p> <p> <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB</code> </p> <p> Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>', 'VolumeRecoveryPointInfo$VolumeARN' => NULL, ], ], 'VolumeARNs' => [ 'base' => NULL, 'refs' => [ 'DescribeCachediSCSIVolumesInput$VolumeARNs' => NULL, 'DescribeStorediSCSIVolumesInput$VolumeARNs' => '<p>An array of strings where each string represents the Amazon Resource Name (ARN) of a stored volume. All of the specified stored volumes must from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>', ], ], 'VolumeId' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$VolumeId' => '<p>The unique identifier of the volume, e.g. vol-AE4B946D.</p>', 'StorediSCSIVolume$VolumeId' => '<p>The unique identifier of the volume, e.g. vol-AE4B946D.</p>', 'VolumeInfo$VolumeId' => '<p>The unique identifier assigned to the volume. This ID becomes part of the volume Amazon Resource Name (ARN), which you use as input for other operations.</p> <p> Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>', ], ], 'VolumeInfo' => [ 'base' => '<p>Describes a storage volume object.</p>', 'refs' => [ 'VolumeInfos$member' => NULL, ], ], 'VolumeInfos' => [ 'base' => NULL, 'refs' => [ 'ListVolumesOutput$VolumeInfos' => NULL, ], ], 'VolumeRecoveryPointInfo' => [ 'base' => NULL, 'refs' => [ 'VolumeRecoveryPointInfos$member' => NULL, ], ], 'VolumeRecoveryPointInfos' => [ 'base' => NULL, 'refs' => [ 'ListVolumeRecoveryPointsOutput$VolumeRecoveryPointInfos' => NULL, ], ], 'VolumeStatus' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$VolumeStatus' => '<p>One of the VolumeStatus values that indicates the state of the storage volume.</p>', 'StorediSCSIVolume$VolumeStatus' => '<p>One of the VolumeStatus values that indicates the state of the storage volume.</p>', ], ], 'VolumeType' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$VolumeType' => '<p>One of the VolumeType enumeration values that describes the type of the volume.</p>', 'StorediSCSIVolume$VolumeType' => '<p>One of the VolumeType enumeration values describing the type of the volume.</p>', 'VolumeInfo$VolumeType' => NULL, ], ], 'VolumeiSCSIAttributes' => [ 'base' => '<p>Lists iSCSI information about a volume.</p>', 'refs' => [ 'CachediSCSIVolume$VolumeiSCSIAttributes' => '<p>An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored volume.</p>', 'StorediSCSIVolume$VolumeiSCSIAttributes' => '<p>An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored volume.</p>', ], ], 'boolean' => [ 'base' => NULL, 'refs' => [ 'CreateStorediSCSIVolumeInput$PreserveExistingData' => '<p>Specify this field as true if you want to preserve the data on the local disk. Otherwise, specifying this field as false creates an empty volume.</p> <p> Valid Values: true, false</p>', 'DeleteFileShareInput$ForceDelete' => '<p>If set to true, deletes a file share immediately and aborts all data uploads to AWS. Otherwise the file share is not deleted until all data is uploaded to AWS. This process aborts the data upload process and the file share enters the FORCE_DELETING status.</p>', 'DeviceiSCSIAttributes$ChapEnabled' => '<p>Indicates whether mutual CHAP is enabled for the iSCSI target.</p>', 'NFSFileShareInfo$KMSEncrypted' => '<p>True to use Amazon S3 server side encryption with your own KMS key, or false to use a key managed by Amazon S3. Optional. </p>', 'StorediSCSIVolume$PreservedExistingData' => '<p>Indicates if when the stored volume was created, existing data on the underlying local disk was preserved.</p> <p> Valid Values: true, false</p>', 'VolumeiSCSIAttributes$ChapEnabled' => '<p>Indicates whether mutual CHAP is enabled for the iSCSI target.</p>', ], ], 'double' => [ 'base' => NULL, 'refs' => [ 'DescribeCacheOutput$CacheUsedPercentage' => NULL, 'DescribeCacheOutput$CacheDirtyPercentage' => NULL, 'DescribeCacheOutput$CacheHitPercentage' => NULL, 'DescribeCacheOutput$CacheMissPercentage' => NULL, ], ], 'errorDetails' => [ 'base' => NULL, 'refs' => [ 'StorageGatewayError$errorDetails' => '<p>Human-readable text that provides detail about the error that occurred.</p>', ], ], 'integer' => [ 'base' => NULL, 'refs' => [ 'DeviceiSCSIAttributes$NetworkInterfacePort' => '<p>The port used to communicate with iSCSI VTL device targets.</p>', 'VolumeiSCSIAttributes$NetworkInterfacePort' => '<p>The port used to communicate with iSCSI targets.</p>', ], ], 'long' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$VolumeSizeInBytes' => '<p>The size, in bytes, of the volume capacity.</p>', 'CreateCachediSCSIVolumeInput$VolumeSizeInBytes' => NULL, 'CreateStorediSCSIVolumeOutput$VolumeSizeInBytes' => '<p>The size of the volume in bytes.</p>', 'DescribeCacheOutput$CacheAllocatedInBytes' => NULL, 'DescribeUploadBufferOutput$UploadBufferUsedInBytes' => NULL, 'DescribeUploadBufferOutput$UploadBufferAllocatedInBytes' => NULL, 'DescribeWorkingStorageOutput$WorkingStorageUsedInBytes' => '<p>The total working storage in bytes in use by the gateway. If no working storage is configured for the gateway, this field returns 0.</p>', 'DescribeWorkingStorageOutput$WorkingStorageAllocatedInBytes' => '<p>The total working storage in bytes allocated for the gateway. If no working storage is configured for the gateway, this field returns 0.</p>', 'Disk$DiskSizeInBytes' => NULL, 'StorediSCSIVolume$VolumeSizeInBytes' => '<p>The size of the volume in bytes.</p>', 'VolumeInfo$VolumeSizeInBytes' => '<p>The size of the volume in bytes.</p> <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>', 'VolumeRecoveryPointInfo$VolumeSizeInBytes' => NULL, 'VolumeRecoveryPointInfo$VolumeUsageInBytes' => NULL, ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'CreateSnapshotFromVolumeRecoveryPointOutput$VolumeRecoveryPointTime' => NULL, 'DescribeGatewayInformationOutput$GatewayName' => '<p>The name you configured for your gateway.</p>', 'Disk$DiskPath' => NULL, 'Disk$DiskNode' => NULL, 'Disk$DiskStatus' => NULL, 'Disk$DiskAllocationResource' => NULL, 'GatewayInfo$GatewayName' => '<p>The name of the gateway.</p>', 'InternalServerError$message' => '<p>A human-readable message describing the error that occurred.</p>', 'InvalidGatewayRequestException$message' => '<p>A human-readable message describing the error that occurred.</p>', 'NetworkInterface$Ipv4Address' => '<p>The Internet Protocol version 4 (IPv4) address of the interface.</p>', 'NetworkInterface$MacAddress' => '<p>The Media Access Control (MAC) address of the interface.</p> <note> <p>This is currently unsupported and will not be returned in output.</p> </note>', 'NetworkInterface$Ipv6Address' => '<p>The Internet Protocol version 6 (IPv6) address of the interface. <i>Currently not supported</i>.</p>', 'ServiceUnavailableError$message' => '<p>A human-readable message describing the error that occurred.</p>', 'UpdateGatewayInformationOutput$GatewayName' => NULL, 'VolumeRecoveryPointInfo$VolumeRecoveryPointTime' => NULL, 'errorDetails$key' => NULL, 'errorDetails$value' => NULL, ], ], ],];
